(* Automatically generated from HDecay output                                  *
 * (c.f. "HDECAY: A Program for Higgs boson decays in the standard model and   *
 *      its supersymmetric extension.", A. Djouadi, J. Kalinowski, M. Spira,   *
 *  Comput.Phys.Commun.108:56-74,1998)                                         *)

BeginPackage ["Hdecay`"];
Begin ["Hdecay`p`"];

data = {{0, 0}, {1., 2.251*^-7}, {6.0201, 0.00002011}, {11.0402, 0.0001738}, {16.0603, 0.0004549},
    {21.0804, 0.0006405}, {26.1005, 0.0007918}, {31.1206, 0.0009277}, {36.1407, 0.001055},
    {41.1608, 0.001178}, {46.1809, 0.001298}, {51.201, 0.001416}, {56.2211, 0.001533},
    {61.2412, 0.001649}, {66.2613, 0.001766}, {71.2814, 0.001883}, {76.3015, 0.002},
    {81.3216, 0.002119}, {86.3417, 0.00224}, {91.3618, 0.002364}, {96.3819, 0.002495},
    {101.402, 0.002642}, {106.422, 0.002816}, {111.442, 0.003041}, {116.462, 0.003347},
    {121.482, 0.003782}, {126.503, 0.00442}, {131.523, 0.005373}, {136.543, 0.00683},
    {141.563, 0.009133}, {146.583, 0.013}, {151.603, 0.02027}, {156.623, 0.03847},
    {161.643, 0.1316}, {166.663, 0.2903}, {171.683, 0.4168}, {176.704, 0.5386},
    {181.724, 0.6883}, {186.744, 0.9035}, {191.764, 1.105}, {196.784, 1.3}, {201.804, 1.499},
    {206.824, 1.705}, {211.844, 1.922}, {216.864, 2.151}, {221.884, 2.394}, {226.905, 2.651},
    {231.925, 2.924}, {236.945, 3.213}, {241.965, 3.519}, {246.985, 3.843}, {252.005, 4.184},
    {257.025, 4.545}, {262.045, 4.925}, {267.065, 5.324}, {272.085, 5.742}, {277.106, 6.182},
    {282.126, 6.642}, {287.146, 7.123}, {292.166, 7.625}, {297.186, 8.15}, {302.206, 8.696},
    {307.226, 9.265}, {312.246, 9.856}, {317.266, 10.47}, {322.286, 11.1}, {327.307, 11.76},
    {332.327, 12.44}, {337.347, 13.13}, {342.367, 13.83}, {347.387, 14.61}, {352.407, 15.7},
    {357.427, 16.91}, {362.447, 18.18}, {367.467, 19.51}, {372.487, 20.89}, {377.508, 22.31},
    {382.528, 23.77}, {387.548, 25.27}, {392.568, 26.81}, {397.588, 28.38}, {402.608, 29.99},
    {407.628, 31.63}, {412.648, 33.3}, {417.668, 35.01}, {422.688, 36.76}, {427.709, 38.53},
    {432.729, 40.34}, {437.749, 42.19}, {442.769, 44.06}, {447.789, 45.97}, {452.809, 47.92},
    {457.829, 49.9}, {462.849, 51.91}, {467.869, 53.96}, {472.889, 56.05}, {477.91, 58.17},
    {482.93, 60.33}, {487.95, 62.52}, {492.97, 64.76},
    {497.99, 67.03}};

interpolation[x_, l_] := Plus @@ ((#[[1]] * x^#[[2]])& /@ l);

params = {{-0.26293901351164234, 1}, {0.001368182199849752, 2}, {-2.3048363155706936*^-6, 3},
    {3.1498414039397794*^-9, 4}, {-1.977234012939224*^-12, 5},
    {6.665973758092558*^-16, 6}};

Hdecay`Hdecay[mh_] := If[mh < 500, Max[Interpolation[data, InterpolationOrder->1][mh], 0], interpolation[mh, params]]/;(mh >= 0);
Hdecay`Hdecay::usage = "usage: Hdecay [mh]";

End[];
Protect[Hdecay];
EndPackage[];
(* Spectrum calculator for compact HEIDI. For more information, please take    *
 * a look at                                                                   *
 *                                                                             *
 *   "Exploring the golden channel for HEIDI models using an interface between *
 *      WHIZARD and FeynRules", N. D. Christensen, C. Duhr, B. Fuks, J. Reuter,*
 *    C. Speckner, arXiv:1010.3251                                             *
 *                                                                             *
 * Please cite above reference if you use this program.                        *)

BeginPackage["Heidi`"];
Begin["Heidi`p`"];
Needs["Hdecay`"];

(* Initialize the package and clear all caches. *)
Heidi`InitHeidi[mv_, mmh_, mcs_, mmb_, mg2_, mprec_] := Block[{},
   v = mv;
   mh = mmh;
   cs = mcs;
   mb = mmb;
   g2 = mg2;
   g = N[Sqrt[g2]];
   alpha = N[g2 / mb * Coth[mb * Pi / cs]];
   lambda = N[mh^2 / v^2 / 2];
   prec = mprec;
   Clear[MassCache, WFCache, WidthCache];
   If[lambda <= alpha,
      mh = 1.1 * Sqrt[2*alpha] * v;
      Print["WARNING: choosen Higgs mass is to small; using mh "
         <> ToString [mh] <> "GeV instead!"];
      InitHeidi[v, mh, cs, mb, g2, prec];
   ];
];

Heidi`InitHeidi[v_, mh_, cs_, mb_, g2_] := InitHeidi[v, mh, cs, mb, g2, 0.000001];

Heidi`InitHeidi::usage = "usage: InitHeidi [v, mh, cs, mb, g2, prec]
   v    : higgs VeV
   mh   : higgs mass
   cs   : compactification scale
   mb   : bulk mass
   g2   : 5D mixing squared
   prec : precision for the numeric determination of the masses
          (optional; default: 0.000001)";


(* Calculate the nth mass eigenvalue *)
Heidi`HeidiMass[n_] := Block[{fun, l, r, x, oldx},
   If[NumericQ[MassCache[n]],
      MassCache[n]
   ,
      If[n > 0,
         fun = (mh^2 - mb^2 + 2*g2*v^2/# * Cot[Pi/cs*#] - #^2)&;
         l = (n - 1) * cs; r = n * cs;
      ,
         fun = (mb^2 - mh^2 + 2*g2*v^2/# * Coth[Pi/cs*#] - #^2)&;
         l = 0; r = mb;
      ];
      oldx = l;
      x = (l + r) / 2;
      While[Abs[(x - oldx) / x] > prec,
         oldx = x;
         If[fun[x] > 0, l = x, r = x];
         x = (l + r) / 2;
      ];
      MassCache[n] = If[n == 0, Sqrt[mb^2 - N[x]^2], Sqrt[N[x]^2 + mb^2]]
   ]
]/;(n >= 0);

Heidi`HeidiMass::usage = "usage: HeidiMass [n]
   n    : mode index";


(* Calculate the mth component of the nth wavefunction *)
Heidi`HeidiWavefunction[n_, m_] := Block[{},
   If[NumericQ[WFCache[n, m]],
      WFCache[n, m]
   ,
      If[m == 0,
         WFCache[n, m] = N[1/Sqrt[
            1 + g2*v^2*Pi/cs/(HeidiMass[n]^2 - mb^2) +
               (HeidiMass[n]^2 - mh^2)/2/(HeidiMass[n]^2 - mb^2) +
               (HeidiMass[n]^2 - mh^2)^2 * Pi/4/g2/v^2/cs
            ]]
      ,
         WFCache[n, m] = N[HeidiWavefunction[n, 0] *
            2*g*v*Sqrt[cs/Pi/If[m == 1, 2, 1]] /
            (HeidiMass[n]^2 - mb^2 - (m - 1)^2*cs^2)]
      ]
   ]
]/;((n >= 0) && (m >= 0));

Heidi`HeidiWavefunction::usage = "usage: HeidiWavefunction [n, m]
   n : mode index
   m : wavefunction component index (0 = pre-mixing higgs)";


Heidi`HeidiScalarCoupling[i__] := Block[{},
   -I*6 * (Times @@ (Heidi`HeidiWavefunction[#, 0]& /@ {i}))
]/;((Length[{i}] == 4) && (And @@ ((# >= 0)& /@ {i})));

Heidi`HeidiScalarCoupling[i__] := Block [{thing},
   -2*I*v * (Times @@ (Heidi`HeidiWavefunction[#, 0]& /@ {i})) *
      (3*lambda - ((Plus @@ ((HeidiMass[#]^2)& /@ {i})) - 3 * mh^2)/2/v^2)
]/;((Length[{i}] == 3) && (And @@ ((# >= 0)& /@ {i})));

Heidi`HeidiScalarCoupling::usage = "usage: HeidiScalarCoupling [i1, ..., in]
   i1, ..., in : modes meeting at the vertex (n = 3 or n = 4)";


Heidi`HeidiScalarWidth[i_] := Block[{calc},
   calc[{x_, j_, k_}] := Which[
      j == i, {x, j, k},
      (HeidiMass[i] < HeidiMass[j] + HeidiMass[k]) || (k > j), {x, j+1, 0},
      True, {
         Sqrt[
            (HeidiMass[i]^2 - (HeidiMass[j] + HeidiMass[k])^2) *
            (HeidiMass[i]^2 - (HeidiMass[j] - HeidiMass[k])^2)]
         /16/Pi/HeidiMass[i]^3 * Abs[HeidiScalarCoupling[i, j, k]]^2
         /If[j == k, 2, 1] + x, j, k+1}
   ];
   If[NumericQ[WidthCache[i]], WidthCache[i], WidthCache[i] = FixedPoint[calc, {0, 0, 0}][[1]]]
]/;(i >= 0);

Heidi`HeidiScalarWidth::usage = "usage: HeidiScalarWidth [n]
   n : mode index";


Heidi`HeidiSMWidth[i_] := Block[{},
   Hdecay[HeidiMass[i]] * HeidiWavefunction[i, 0]^2
]/;(i >= 0);

Heidi`HeidiSMWidth::usage = "usage: HeidiSMWidth [n]
   n : mode index";


Heidi`HeidiWidth[i_] := HeidiSMWidth[i] + HeidiScalarWidth[i];

Heidi`HeidiWidth::usage = "usage: HeidiWidth [n]
   n : mode index";

End[];
Protect[InitHeidi, HeidiMass, HeidiWavefunction, HeidiScalarCoupling, HeidiScalarWidth,
   HeidiSMWidth, HeidiWidth];
EndPackage[];
(* *************************************************************************************
                        HEIDI Higgs with a compact extra dimension.

   The model is intended for use on top of the Standard Model where it replaces the
   Higgs sector. As the theory contains a variable number of modes below the cutoff
   (the masses of which cannot be expressed analytically), the HEIDI parameters have to
   be set before creating the Feynman rules and model files. Those parameters are:

   Heidi$v      : higgs VeV. Optional, default is the value.
   Heidi$mh     : higgs Mass. Optional, default is the SM value
   Heidi$cs     : compactification scale
   Heidi$mb     : bulk mass
   Heidi$g2     : 5D trilinear coupling squared
   Heidi$cutoff : cutoff scale
   Heidi$nmodes : if Heidi$cutoff is undefined, Heidi$nmodes determines the number of
                  modes in the spectrum (starting from index 0)

   Masses, widths and couplings are calculated statically. DO NOT CHANGE THOSE OR THE
   ELECTROWEAK PARAMETERS AFTER CREATING THE MODEL.

   This model file is a descendant of Claude Duhr's SMScalars model.

*)


(* Make sure everything we need is at our disposal *)
Needs["Heidi`"];
Block[{error},
   error[s_] := (Print["HEIDI error: please set " <> s]; Throw[Null]);
   If[!NumericQ[Heidi$v], error["Heidi$v"]];
   If[!NumericQ[Heidi$mh], error["Heidi$mh"]];
   If[!NumericQ[Heidi$cs], error["Heidi$cs"]];
   If[!NumericQ[Heidi$mb], error["Heidi$mb"]];
   If[!NumericQ[Heidi$g2], error["Heidi$g2"]];
   If[FeynmanGauge,
      Print["HEIDI error: the model currently only supports unitarity gauge"
         <> "; please set FeynmanGauge = False."];
      Throw[Null];
   ];
];

(* Init HEIDI *)
InitHeidi[Heidi$v, Heidi$mh, Heidi$cs, Heidi$mb, Heidi$g2];

(* Determine the number of modes we have been requested to include *)
If[NumericQ[Heidi$cutoff],
   Heidi$nmodes = FixedPoint[If[HeidiMass[#] < Heidi$cutoff, # + 1, #]&, 0];
];
If[!NumericQ[Heidi$nmodes],
   Print["HEIDI error: please set either Heidi$cutoff or Heidi$nmodes"];
   Throw[Null];
];

(* Model metadata *)
M$ModelName = "HEIDI";
M$Information = {Authors -> "C. Speckner",
   Institutions -> "Universitaet Freiburg",
   Emails -> "Christian.Speckner@physik.uni-freiburg.de",
   Date -> "30.07.2010",
   Version  ->  "0.1",
   URLs  -> "None",
   References -> (
      ""
         <> "\"Exploring the golden channel for HEIDI models using an "
         <> "interface between WHIZARD and FeynRules\", "
         <> "N. D. Christensen, C. Duhr, B. Fuks, J. Reuter, C. Speckner, "
         <> "arXiv:1010.3251")
};

(* The flavor index for the HEIDI modes *)
IndexRange[Index[Heidi]] = Range[Heidi$nmodes];
IndexStyle[Heidi, k];

M$Parameters = {
(* The Higgs wavefunction is a tensor parameter, the entries of which are *
 * stored numerically as external parameters.                             *)
   xi == {
      Indices -> {Index[Heidi]},
      ComplexParameter -> False,
      Value -> Table[Rule[xi[n], HeidiWavefunction[n - 1, 0]],
         {n, 1, Heidi$nmodes}],
      Description -> "Higgs wave function",
      ParameterType -> External,
      AllowSummation -> True
   },
(* K factor for the effective ggh coupling *)
   kggh == {
      Value -> 1,
      ParamterType -> External,
      Description -> "ggh K factor"
   }
};


(* Enter the HEIDI scalars *)
M$ClassesDescription =  {
   S[4] == {
      ClassName -> Hh,
      ClassMembers -> Table[Symbol["Hh" <> ToString[n]], {n, 1, Heidi$nmodes}],
      SelfConjugate -> True,
      Indices -> {Index[Heidi]},
      FlavorIndex -> Heidi,
      Mass -> Table[{Symbol["mhh" <> ToString[n]], HeidiMass[n - 1]}, {n, 1, Heidi$nmodes}],
      Width -> Table[{Symbol["whh" <> ToString[n]], HeidiWidth[n - 1]}, {n, 1, Heidi$nmodes}],
      PDG -> Table[990000 + n, {n, 1, Heidi$nmodes}]
  }
}

(* Construct HEIDI Lagrangian *) 
LHEIDI := (LSM /. {muH -> 0, \[Lambda] -> 0}) /. H -> (Hh[n]*xi[n]);
LHEIDI::usage = "LHEIDI: HEIDI lagrangian";

(* Optional: the effective ggh_i lagrangian *)
LHEIDIgg[mode_] := Block[{fun, piece, tt, mm, hh},
   Print["adding effective scalar-gluon-gluon vertices " <> If[mode == "heavytop",
      "in heavy top limit", "with dynamical loop factor"]];
   tt[m_] := 4*MT^2 / m^2;
   fun[tau_] := If[mode == "heavytop", 2/3,
      tau * (1 + (1 - tau)* If[NumericalValue[tau] > 1,
         ArcSin[Sqrt[1 / tau]]^2
      ,
         -1/4 * (Log[(1 + Sqrt[1 + tau])/(1 - Sqrt[1 - tau])]
            - I*Pi)^2
      ])
   ];
   mm[n_] := Symbol["mhh" <> ToString[n]];
   hh[n_] := Symbol["Hh" <> ToString[n]];
   piece[n_] :=
      Sqrt[kggh] * gs^2/32/Pi^2/v * fun[tt[mm[n]]] * xi[n] *
      hh[n] * (del[G[mu, a], nu] - del[G[nu, a], mu])^2;
   Plus @@ (piece /@ Range[Heidi$nmodes])
];
LHEIDIgg[] := LHEIDIgg[""];
LHEIDIgg::usage = "LHEIDIgg [mode]: HEIDI effective scalar-gluon-gluon couplings
   mode : optional, set to \"heavytop\" to use heavy top limit";

(* Protect our symbols. *)
Protect[LHEIDI, LHEIDIgg];

(* Spit out final warnings. *)
Print["HEIDI initialized. Please doublecheck that the runtime parametrization of "
   <> "the electroweak sector is consistent with the parameters you used for HEIDI "
   <> "before running any code."];
