(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[      9067,        225]
NotebookOptionsPosition[      7975,        184]
NotebookOutlinePosition[      8483,        204]
CellTagsIndexPosition[      8440,        201]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.4921467751527157`*^9, 3.492146812657303*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{
   "SetDirectory", "[", "\"\<< insert the path to FeynRules here >\>\"", 
    "]"}]}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}]}], "Input",
 CellChangeTimes->{{3.562493790773467*^9, 3.56249379133423*^9}, {
  3.5669854592231197`*^9, 3.566985470009097*^9}, {3.573969547023426*^9, 
  3.573969552638027*^9}, {3.5763110817083693`*^9, 3.576311082380014*^9}, {
  3.577095398145216*^9, 3.577095424358136*^9}, {3.579449013242025*^9, 
  3.5794490139598637`*^9}, {3.581151089241591*^9, 3.581151095405628*^9}, {
  3.591006102395862*^9, 3.591006102747958*^9}, {3.5953297894365797`*^9, 
  3.595329795947875*^9}, {3.612498209463675*^9, 3.612498210075754*^9}, {
  3.626351094653633*^9, 3.62635109543893*^9}, {3.633752767994205*^9, 
  3.633752769326686*^9}, {3.637489378470703*^9, 3.637489378581725*^9}, {
  3.64491925272816*^9, 3.644919253612585*^9}, {3.6471724402212954`*^9, 
  3.6471724570943813`*^9}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["The SM EFT Mass Basis Model",
 FontSize->24]], "Title",
 CellChangeTimes->{{3.563969384897138*^9, 3.563969388480772*^9}, {
  3.579542855003995*^9, 3.579542855878519*^9}, {3.580788704233615*^9, 
  3.580788704402492*^9}, {3.633764100895033*^9, 3.633764107953764*^9}, {
  3.645341427525136*^9, 3.645341428720394*^9}, {3.6458652020926247`*^9, 
  3.645865202359612*^9}}],

Cell[CellGroupData[{

Cell["Loading the model", "Subsubsection",
 CellChangeTimes->{{3.647172505769191*^9, 3.647172507742222*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
  "SetDirectory", "[", 
   "\"\< < insert the path to the model directory here > \>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"LoadModel", "[", 
  RowBox[{"\"\<SM_MB.fr\>\"", ",", "\"\<MB.fr\>\""}], "]"}]}], "Input",
 CellChangeTimes->{{3.5797689230966454`*^9, 3.579768959605196*^9}, {
  3.5797728634876137`*^9, 3.579772869622957*^9}, {3.579773022805372*^9, 
  3.579773025161128*^9}, {3.580788700320038*^9, 3.58078870048149*^9}, {
  3.581956192102425*^9, 3.5819561934167557`*^9}, {3.5819604209931593`*^9, 
  3.58196042170662*^9}, {3.591006112028008*^9, 3.591006115130166*^9}, {
  3.5910062552983418`*^9, 3.591006257373683*^9}, {3.595329809474881*^9, 
  3.595329812689343*^9}, {3.633752783565755*^9, 3.633752786573667*^9}, {
  3.6338518266335278`*^9, 3.633851827584215*^9}, {3.6338699068325233`*^9, 
  3.633869907529812*^9}, {3.644921036607795*^9, 3.644921041635105*^9}, {
  3.644921714382965*^9, 3.644921727217204*^9}, {3.644921766860733*^9, 
  3.6449217784459143`*^9}, {3.645181745661171*^9, 3.6451817465024233`*^9}, {
  3.6471724314536867`*^9, 3.6471724690049562`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Electronic signature", "Subsubsection",
 CellChangeTimes->{{3.647172501101695*^9, 3.647172502802919*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ModelInformation", "[", "]"}], ";"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Some checks", "Subsubsection",
 CellChangeTimes->{{3.6471724960543833`*^9, 3.647172497342194*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"CheckHermiticity", "[", "LMB", "]"}], ";"}]], "Input",
 CellChangeTimes->{3.645868499828899*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Generating the UFO", "Subsubsection",
 CellChangeTimes->{{3.6471724742914248`*^9, 3.6471724795053062`*^9}}],

Cell[BoxData[
 RowBox[{"LoadRestriction", "[", "\"\<Massless.rst\>\"", "]"}]], "Input",
 CellChangeTimes->{
  3.563280223155616*^9, {3.563771875657627*^9, 3.563771912735396*^9}, 
   3.5671480612443037`*^9, {3.579429036774397*^9, 3.579429037217311*^9}, {
   3.6471789493355503`*^9, 3.6471789503013363`*^9}, 3.647234623179413*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", " ", 
  RowBox[{"WriteUFO", "[", 
   RowBox[{"LSM", ",", 
    RowBox[{"Sequence", "@@", "LMB"}], ",", " ", 
    RowBox[{"RemoveGhosts", "\[Rule]", "True"}], ",", 
    RowBox[{"AddDecays", "\[Rule]", "False"}], ",", 
    RowBox[{"MaxParticles", "\[Rule]", "4"}], ",", " ", 
    RowBox[{"Output", "\[Rule]", "\"\<MB_4pt\>\""}]}], "]"}], ";"}]], "Input",\

 CellChangeTimes->{{3.577107029356776*^9, 3.5771070477923737`*^9}, {
   3.577158523077528*^9, 3.577158534562706*^9}, 3.577160281210434*^9, {
   3.579411806714102*^9, 3.579411828528706*^9}, {3.579422946305105*^9, 
   3.579422989755477*^9}, {3.579451314563088*^9, 3.5794513402565603`*^9}, {
   3.579509547412293*^9, 3.579509551094151*^9}, {3.5795101776420813`*^9, 
   3.579510178098853*^9}, {3.579510326274065*^9, 3.579510327951848*^9}, {
   3.579511951094426*^9, 3.579511951792654*^9}, {3.579516692371182*^9, 
   3.579516693661449*^9}, {3.579517289114347*^9, 3.579517290160247*^9}, {
   3.579517469625496*^9, 3.579517497580488*^9}, {3.5795397677576017`*^9, 
   3.579539779430418*^9}, 3.579595493612273*^9, {3.579609434073883*^9, 
   3.579609440715682*^9}, {3.579775253548801*^9, 3.579775259057622*^9}, {
   3.579775397339424*^9, 3.579775401034914*^9}, {3.579776087450013*^9, 
   3.579776090678286*^9}, {3.581159850189066*^9, 3.5811598529615707`*^9}, {
   3.595333062080071*^9, 3.595333076540902*^9}, {3.633754874061948*^9, 
   3.633754874908918*^9}, {3.633866592200938*^9, 3.633866595533534*^9}, {
   3.645422597855199*^9, 3.645422602085012*^9}, {3.645446058399941*^9, 
   3.645446060439068*^9}, {3.645446315944306*^9, 3.6454463185698566`*^9}, {
   3.6454471500451317`*^9, 3.645447175183316*^9}, {3.6454490787336483`*^9, 
   3.645449081951357*^9}, {3.645460164609558*^9, 3.645460171727055*^9}, {
   3.6454607480058203`*^9, 3.6454607539308243`*^9}, {3.645461035958262*^9, 
   3.645461037934042*^9}, {3.645461104869426*^9, 3.645461105076232*^9}, {
   3.645461342760161*^9, 3.6454613428480864`*^9}, {3.645461445447649*^9, 
   3.6454614455824347`*^9}, {3.645462049534629*^9, 3.645462056252779*^9}, {
   3.6454635583227673`*^9, 3.645463562863798*^9}, {3.6455033382316837`*^9, 
   3.6455033435140467`*^9}, {3.645766848974765*^9, 3.6457668520036592`*^9}, {
   3.645865276269596*^9, 3.645865276410048*^9}, {3.647172484546142*^9, 
   3.647172521180607*^9}, {3.6472346266076307`*^9, 3.647234638837646*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", " ", 
  RowBox[{"WriteUFO", "[", 
   RowBox[{"LSM", ",", 
    RowBox[{"Sequence", "@@", "LMB"}], ",", " ", 
    RowBox[{"RemoveGhosts", "\[Rule]", "True"}], ",", 
    RowBox[{"AddDecays", "\[Rule]", "False"}], ",", 
    RowBox[{"MaxParticles", "\[Rule]", "5"}], ",", " ", 
    RowBox[{"Output", "\[Rule]", "\"\<MB_5pt\>\""}]}], "]"}], ";"}]], "Input",\

 CellChangeTimes->{{3.645463290075967*^9, 3.6454632902279577`*^9}, {
   3.645865293525578*^9, 3.6458652936815147`*^9}, 3.64717248639361*^9, 
   3.647172524367447*^9, {3.6472346434573507`*^9, 3.647234647764927*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";", " ", 
  RowBox[{"WriteUFO", "[", 
   RowBox[{"LSM", ",", 
    RowBox[{"Sequence", "@@", "LMB"}], ",", " ", 
    RowBox[{"RemoveGhosts", "\[Rule]", "True"}], ",", 
    RowBox[{"AddDecays", "\[Rule]", "False"}], ",", " ", 
    RowBox[{"Output", "\[Rule]", "\"\<MB_full\>\""}]}], "]"}], ";"}]], "Input",\

 CellChangeTimes->{{3.6472346528602953`*^9, 3.6472346593229*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{994, 727},
WindowMargins->{{Automatic, 29}, {Automatic, 0}},
PrintingCopies->1,
PrintingPageRange->{1, Automatic},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (January 25, \
2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 120, 2, 28, "Input"],
Cell[680, 24, 979, 17, 46, "Input"],
Cell[CellGroupData[{
Cell[1684, 45, 389, 6, 69, "Title"],
Cell[CellGroupData[{
Cell[2098, 55, 108, 1, 35, "Subsubsection"],
Cell[2209, 58, 1119, 19, 46, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3365, 82, 111, 1, 35, "Subsubsection"],
Cell[3479, 85, 82, 2, 28, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3598, 92, 104, 1, 35, "Subsubsection"],
Cell[3705, 95, 131, 3, 28, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3873, 103, 113, 1, 35, "Subsubsection"],
Cell[3989, 106, 328, 5, 28, "Input"],
Cell[4320, 113, 2461, 38, 46, "Input"],
Cell[6784, 153, 680, 14, 46, "Input"],
Cell[7467, 169, 480, 11, 46, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
