(*****************************************************************************)
(*  This is the FeynRules model file for the BSM Characterisation            *)
(*****************************************************************************)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)

M$ModelName = "BSMC";

M$Information = {
 Authors      -> {"B. Fuks", "K. Mawatari"}, 
 Version      -> "2.1",
 Date         -> "31.05.2017",
 Institutions -> {"LPTHE Paris / U. Paris VI", "LPSC Grenoble"},
 Emails       -> {"fuks@lpthe.jussieu.fr", "kentarou.mawatari@lpsc.in2p3.fr"},
 URLs         -> "http://feynrules.irmp.ucl.ac.be/wiki/BSMCharacterisation",
 References   -> {"A. Falkowski, B. Fuks, K. Mawatari, K. Mimasu, F. Riva and V. Sanz, arXiv:1508.05895"}
};


(* ************************** *)
(* *****  Change  log   ***** *)
(* ************************** *)

(* 14.07.2015 v1.0 - release version (based on the Higgs basis note (Jun/14)).                    *)
(* 04.03.2016 v2.0 - version corresponding to the Rosetta paper arXiv:1508.05895.                 *)
(* 31.05.2017 v2.1 - change of the signs of the SM Hgg, HaZ and Haa couplings (thanks S. Di Vita) *)


FeynmanGauge = False;

(* ************************** *)
(* **  Interaction  orders ** *)
(* ************************** *)

M$InteractionOrderLimit = { {QNP, 2} };
M$InteractionOrderHierarchy = { {QNP, 1} };


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

  (* Quadratic terms *)
  dM  == { TeX -> "\[Delta]m", ParameterType -> External, Value -> 0., BlockName -> BCxmass,  OrderBlock -> 1, Description -> "W-mass corrections"},

  (* Lvertex parameters *)
  RdGLzu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGLzu[i_,j_]->0.}, BlockName ->   BCxdGLzu, Description -> "Z-u vertex interactions (real part, L)"},
  IdGLzu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGLzu[i_,j_]->0.}, BlockName -> IMBCxdGLzu, Description -> "Z-u vertex interactions (im part, L)"  },
  RdGLzd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGLzd[i_,j_]->0.}, BlockName ->   BCxdGLzd, Description -> "Z-d vertex interactions (real part, L)"},
  IdGLzd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGLzd[i_,j_]->0.}, BlockName -> IMBCxdGLzd, Description -> "Z-d vertex interactions (im part, L)"  },
  RdGLze ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGLze[i_,j_]->0.}, BlockName ->   BCxdGLze, Description -> "Z-l vertex interactions (real part, L)"},
  IdGLze ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGLze[i_,j_]->0.}, BlockName -> IMBCxdGLze, Description -> "Z-l vertex interactions (im part, L)"},
  RdGLzv ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGLzv[i_,j_]->0.}, BlockName ->   BCxdGLzv, Description -> "Z-v vertex interactions (real part, L)"},
  IdGLzv ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGLzv[i_,j_]->0.}, BlockName -> IMBCxdGLzv, Description -> "Z-v vertex interactions (im part, L)"},
  RdGRzu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGRzu[i_,j_]->0.}, BlockName ->   BCxdGRzu, Description -> "Z-u vertex interactions (real part, R)"},
  IdGRzu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGRzu[i_,j_]->0.}, BlockName -> IMBCxdGRzu, Description -> "Z-u vertex interactions (im part, R)"  },
  RdGRzd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGRzd[i_,j_]->0.}, BlockName ->   BCxdGRzd, Description -> "Z-d vertex interactions (real part, R)"},
  IdGRzd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGRzd[i_,j_]->0.}, BlockName -> IMBCxdGRzd, Description -> "Z-d vertex interactions (im part, R)"  },
  RdGRze ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGRze[i_,j_]->0.}, BlockName ->   BCxdGRze, Description -> "Z-l vertex interactions (real part, R)"},
  IdGRze ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGRze[i_,j_]->0.}, BlockName -> IMBCxdGRze, Description -> "Z-l vertex interactions (im part, R)"},
  RdGLwq ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGLwq[i_,j_]->0.}, BlockName ->   BCxdGLWq, Description -> "W-q vertex interactions (real part, L)"},
  IdGLwq ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGLwq[i_,j_]->0.}, BlockName -> IMBCxdGLWq, Description -> "W-q vertex interactions (im part, L)"  },
  RdGRwq ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGRwq[i_,j_]->0.}, BlockName ->   BCxdGRWq, Description -> "W-q vertex interactions (real part, R)"},
  IdGRwq ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGRwq[i_,j_]->0.}, BlockName -> IMBCxdGRWq, Description -> "W-q vertex interactions (im part, R)"  },
  RdGLwl ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGLwl[i_,j_]->0.}, BlockName ->   BCxdGLWl, Description -> "W-l vertex interactions (real part, L)"},
  IdGLwl ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGLwl[i_,j_]->0.}, BlockName -> IMBCxdGLWl, Description -> "W-l vertex interactions (im part, L)"  },

  dGLzu ==  { TeX -> Subsuperscript["\[Delta]g", L, Zu], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGLzu[i_,j_]->RdGLzu[i,j] + I IdGLzu[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "Z-u vertex interactions (L)"},
  dGLzd ==  { TeX -> Subsuperscript["\[Delta]g", L, Zd], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGLzd[i_,j_]->RdGLzd[i,j] + I IdGLzd[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "Z-d vertex interactions (L)"},
  dGLze ==  { TeX -> Subsuperscript["\[Delta]g", L, Zl], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGLze[i_,j_]->RdGLze[i,j] + I IdGLze[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "Z-l vertex interactions (L)"},
  dGLzv ==  { TeX -> Subsuperscript["\[Delta]g", L, Zv], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGLzv[i_,j_]->RdGLzv[i,j] + I IdGLzv[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "Z-v vertex interactions (L)"},
  dGRzu ==  { TeX -> Subsuperscript["\[Delta]g", R, Zu], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGRzu[i_,j_]->RdGRzu[i,j] + I IdGRzu[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "Z-u vertex interactions (R)"},
  dGRzd ==  { TeX -> Subsuperscript["\[Delta]g", R, Zd], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGRzd[i_,j_]->RdGRzd[i,j] + I IdGRzd[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "Z-d vertex interactions (R)"},
  dGRze ==  { TeX -> Subsuperscript["\[Delta]g", R, Zl], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGRze[i_,j_]->RdGRze[i,j] + I IdGRze[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "Z-l vertex interactions (R)"},
  dGLwq ==  { TeX -> Subsuperscript["\[Delta]g", L, Wq], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGLwq[i_,j_]->RdGLwq[i,j] + I IdGLwq[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "W-q vertex interactions (L)"},
  dGRwq ==  { TeX -> Subsuperscript["\[Delta]g", R, Wq], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGRwq[i_,j_]->RdGRwq[i,j] + I IdGRwq[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "W-q vertex interactions (R)"},
  dGLwl ==  { TeX -> Subsuperscript["\[Delta]g", L, Wl], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGLwl[i_,j_]->RdGLwl[i,j] + I IdGLwl[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "W-l vertex interactions (L)"},

  (* Ldip parameters *)
  Rdgu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdgu[i_,j_]->0.}, BlockName ->   BCxdgu, Description -> "G-u dipole interactions (real part)"},
  Idgu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idgu[i_,j_]->0.}, BlockName -> IMBCxdgu, Description -> "G-u dipole interactions (im part)"  },
  Rdgd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdgd[i_,j_]->0.}, BlockName ->   BCxdgd, Description -> "G-d dipole interactions (real part)"},
  Idgd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idgd[i_,j_]->0.}, BlockName -> IMBCxdgd, Description -> "G-d dipole interactions (im part)"  },
  Rdau ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdau[i_,j_]->0.}, BlockName ->   BCxdau, Description -> "A-u dipole interactions (real part)"},
  Idau ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idau[i_,j_]->0.}, BlockName -> IMBCxdau, Description -> "A-u dipole interactions (im part)"  },
  Rdad ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdad[i_,j_]->0.}, BlockName ->   BCxdad, Description -> "A-d dipole interactions (real part)"},
  Idad ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idad[i_,j_]->0.}, BlockName -> IMBCxdad, Description -> "A-d dipole interactions (im part)"  },
  Rdae ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdae[i_,j_]->0.}, BlockName ->   BCxdae, Description -> "A-e dipole interactions (real part)"},
  Idae ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idae[i_,j_]->0.}, BlockName -> IMBCxdae, Description -> "A-e dipole interactions (im part)"  },
  Rdzu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdzu[i_,j_]->0.}, BlockName ->   BCxdzu, Description -> "Z-u dipole interactions (real part)"},
  Idzu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idzu[i_,j_]->0.}, BlockName -> IMBCxdzu, Description -> "Z-u dipole interactions (im part)"  },
  Rdzd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdzd[i_,j_]->0.}, BlockName ->   BCxdzd, Description -> "Z-d dipole interactions (real part)"},
  Idzd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idzd[i_,j_]->0.}, BlockName -> IMBCxdzd, Description -> "Z-d dipole interactions (im part)"  },
  Rdze ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdze[i_,j_]->0.}, BlockName ->   BCxdze, Description -> "Z-e dipole interactions (real part)"},
  Idze ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idze[i_,j_]->0.}, BlockName -> IMBCxdze, Description -> "Z-e dipole interactions (im part)"  },
  Rdwd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdwd[i_,j_]->0.}, BlockName ->   BCxdwd, Description -> "W-d dipole interactions (real part)"},
  Idwd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idwd[i_,j_]->0.}, BlockName -> IMBCxdwd, Description -> "W-d dipole interactions (im part)"  },
  Rdwu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdwu[i_,j_]->0.}, BlockName ->   BCxdwu, Description -> "W-u dipole interactions (real part)"},
  Idwu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idwu[i_,j_]->0.}, BlockName -> IMBCxdwu, Description -> "W-u dipole interactions (im part)"  },
  Rdwl ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdwl[i_,j_]->0.}, BlockName ->   BCxdwl, Description -> "W-l dipole interactions (real part)"},
  Idwl ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idwl[i_,j_]->0.}, BlockName -> IMBCxdwl, Description -> "W-l dipole interactions (im part)"  },
  Rtdgu == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rtdgu[i_,j_]->0.}, BlockName ->   BCxtdgu, Description -> "G-u dipole interactions (real part)"},
  Itdgu == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Itdgu[i_,j_]->0.}, BlockName -> IMBCxtdgu, Description -> "G-u dipole interactions (im part, CP-odd)  "},
  Rtdgd == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rtdgd[i_,j_]->0.}, BlockName ->   BCxtdgd, Description -> "G-d dipole interactions (real part, CP-odd)"},
  Itdgd == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Itdgd[i_,j_]->0.}, BlockName -> IMBCxtdgd, Description -> "G-d dipole interactions (im part, CP-odd)"  },
  Rtdau == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rtdau[i_,j_]->0.}, BlockName ->   BCxtdau, Description -> "A-u dipole interactions (real part, CP-odd)"},
  Itdau == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Itdau[i_,j_]->0.}, BlockName -> IMBCxtdau, Description -> "A-u dipole interactions (im part, CP-odd)"  },
  Rtdad == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rtdad[i_,j_]->0.}, BlockName ->   BCxtdad, Description -> "A-d dipole interactions (real part, CP-odd)"},
  Itdad == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Itdad[i_,j_]->0.}, BlockName -> IMBCxtdad, Description -> "A-d dipole interactions (im part, CP-odd)"  },
  Rtdae == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rtdae[i_,j_]->0.}, BlockName ->   BCxtdae, Description -> "A-e dipole interactions (real part, CP-odd)"},
  Itdae == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Itdae[i_,j_]->0.}, BlockName -> IMBCxtdae, Description -> "A-e dipole interactions (im part, CP-odd)"  },
  Rtdzu == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rtdzu[i_,j_]->0.}, BlockName ->   BCxtdzu, Description -> "Z-u dipole interactions (real part, CP-odd)"},
  Itdzu == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Itdzu[i_,j_]->0.}, BlockName -> IMBCxtdzu, Description -> "Z-u dipole interactions (im part, CP-odd)"  },
  Rtdzd == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rtdzd[i_,j_]->0.}, BlockName ->   BCxtdzd, Description -> "Z-d dipole interactions (real part, CP-odd)"},
  Itdzd == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Itdzd[i_,j_]->0.}, BlockName -> IMBCxtdzd, Description -> "Z-d dipole interactions (im part, CP-odd)"  },
  Rtdze == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rtdze[i_,j_]->0.}, BlockName ->   BCxtdze, Description -> "Z-e dipole interactions (real part, CP-odd)"},
  Itdze == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Itdze[i_,j_]->0.}, BlockName -> IMBCxtdze, Description -> "Z-e dipole interactions (im part, CP-odd)"  },

  dgu ==  { TeX -> Subscript["d", gu], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dgu[i_,j_]->Rdgu[i,j] + I Idgu[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "G-u dipole interactions"},
  dgd ==  { TeX -> Subscript["d", gd], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dgd[i_,j_]->Rdgd[i,j] + I Idgd[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "G-d dipole interactions"},
  dau ==  { TeX -> Subscript["d", au], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dau[i_,j_]->Rdau[i,j] + I Idau[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "A-u dipole interactions"},
  dad ==  { TeX -> Subscript["d", ad], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dad[i_,j_]->Rdad[i,j] + I Idad[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "A-d dipole interactions"},
  dae ==  { TeX -> Subscript["d", ae], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dae[i_,j_]->Rdae[i,j] + I Idae[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "A-e dipole interactions"},
  dzu ==  { TeX -> Subscript["d", zu], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dzu[i_,j_]->Rdzu[i,j] + I Idzu[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "Z-u dipole interactions"},
  dzd ==  { TeX -> Subscript["d", zd], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dzd[i_,j_]->Rdzd[i,j] + I Idzd[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "Z-d dipole interactions"},
  dze ==  { TeX -> Subscript["d", ze], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dze[i_,j_]->Rdze[i,j] + I Idze[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "Z-e dipole interactions"},
  dwu ==  { TeX -> Subscript["d", wu], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dwu[i_,j_]->Rdwu[i,j] + I Idwu[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "w-u dipole interactions"},
  dwd ==  { TeX -> Subscript["d", wd], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dwd[i_,j_]->Rdwd[i,j] + I Idwd[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "w-d dipole interactions"},
  dwl ==  { TeX -> Subscript["d", wl], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dwl[i_,j_]->Rdwl[i,j] + I Idwl[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "W-l dipole interactions"},
  tdgu ==  { TeX -> Subscript[OverTilde["d"], gu], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {tdgu[i_,j_]->Rtdgu[i,j] + I Itdgu[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "G-u dipole interactions (CP-odd)"},
  tdgd ==  { TeX -> Subscript[OverTilde["d"], gd], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {tdgd[i_,j_]->Rtdgd[i,j] + I Itdgd[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "G-d dipole interactions (CP-odd)"},
  tdau ==  { TeX -> Subscript[OverTilde["d"], au], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {tdau[i_,j_]->Rtdau[i,j] + I Itdau[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "A-u dipole interactions (CP-odd)"},
  tdad ==  { TeX -> Subscript[OverTilde["d"], ad], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {tdad[i_,j_]->Rtdad[i,j] + I Itdad[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "A-d dipole interactions (CP-odd)"},
  tdae ==  { TeX -> Subscript[OverTilde["d"], ae], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {tdae[i_,j_]->Rtdae[i,j] + I Itdae[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "A-e dipole interactions (CP-odd)"},
  tdzu ==  { TeX -> Subscript[OverTilde["d"], zu], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {tdzu[i_,j_]->Rtdzu[i,j] + I Itdzu[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "Z-u dipole interactions (CP-odd)"},
  tdzd ==  { TeX -> Subscript[OverTilde["d"], zd], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {tdzd[i_,j_]->Rtdzd[i,j] + I Itdzd[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "Z-d dipole interactions (CP-odd)"},
  tdze ==  { TeX -> Subscript[OverTilde["d"], ze], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {tdze[i_,j_]->Rtdze[i,j] + I Itdze[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "Z-e dipole interactions (CP-odd)"},

 (* Ltgc parameters *)
  dKa  == { TeX -> Subscript["\[Delta]\[Kappa]",a], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxtgc, OrderBlock -> 1, Description -> "fsA-W-W interactions"},
  dKz  == { TeX -> Subscript["\[Delta]\[Kappa]",z], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxtgc, OrderBlock -> 2, Description -> "fsZ-W-W interactions"},
  dG1z == { TeX -> Subscript["\[Delta]g","1z"],     ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxtgc, OrderBlock -> 3, Description -> "fsW-W-Z interactions"},
  La   == { TeX -> Subscript["\[Lambda]",a],        ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxtgc, OrderBlock -> 4, Description -> "fsW-fsW-fsA interactions"},
  Lz   == { TeX -> Subscript["\[Lambda]",z],        ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxtgc, OrderBlock -> 5, Description -> "fsW-fsW-fsZ interactions"},
  C3g  == { TeX -> Subscript[c,"3G"],               ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxtgc, OrderBlock -> 6, Description -> "fsG-fsG-fsG interactions"},
  tKa == { TeX -> Subscript[OverTilde["\[Kappa]"],a],  ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxtgc, OrderBlock -> 7,  Description -> "fsA-W-W interactions (CP-odd)"},
  tKz == { TeX -> Subscript[OverTilde["\[Kappa]"],z],  ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxtgc, OrderBlock -> 8,  Description -> "fsZ-W-W interactions (CP-odd)"},
  tLa == { TeX -> Subscript[OverTilde["\[Lambda]"],a], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxtgc, OrderBlock -> 9,  Description -> "fsW-fsW-fsA interactions (CP-odd)"},
  tLz == { TeX -> Subscript[OverTilde["\[Lambda]"],z], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxtgc, OrderBlock -> 10, Description -> "fsW-fsW-fsZ interactions (CP-odd)"},
  tC3g== { TeX -> Subscript[OverTilde["c"],"3g"],      ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxtgc, OrderBlock -> 11, Description -> "fsG-fsG-fsG interactions (CP-odd)"},

 (* Lqgc parameters *)
  dGw4   == { TeX -> Subscript["\[Delta]g",w4],   ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxqgc, OrderBlock -> 1, Description -> "W^4 interactions"},
  dGw2z2 == { TeX -> Subscript["\[Delta]g",w2z2], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxqgc, OrderBlock -> 2, Description -> "W^2-Z^2 interactions"},
  dGw2za == { TeX -> Subscript["\[Delta]g",w2za], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxqgc, OrderBlock -> 3, Description -> "W^2-Z-A interactions"},
  Lw4    == { TeX -> Subscript["\[Lambda]",w4],   ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxqgc, OrderBlock -> 4, Description -> "fsW^2-W^2 interactions"},
  Lw2z2  == { TeX -> Subscript["\[Lambda]",w2z2], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxqgc, OrderBlock -> 5, Description -> "fsW-fsZ-W-Z interactions"},
  Lw2a2  == { TeX -> Subscript["\[Lambda]",w2a2], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxqgc, OrderBlock -> 6, Description -> "fsW-fsA-W-A interactions"},
  Lw2az  == { TeX -> Subscript["\[Lambda]",w2az], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxqgc, OrderBlock -> 7, Description -> "fsW-fsA-W-Z interactions"},
  Lw2za  == { TeX -> Subscript["\[Lambda]",w2za], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxqgc, OrderBlock -> 8, Description -> "fsW-fsZ-W-A interactions"},
  C4g    == { TeX -> Subscript[c,"4G"],           ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxqgc, OrderBlock -> 9, Description -> "fsG-fsG-G-G interactions"},
  tLw4   == { TeX -> Subscript[OverTilde["\[Lambda]"],w4],   ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxqgc, OrderBlock -> 10, Description -> "fsW^2-W^2 interactions (CP-odd)"},
  tLw2z2 == { TeX -> Subscript[OverTilde["\[Lambda]"],w2z2], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxqgc, OrderBlock -> 11, Description -> "fsW-fsZ-W-Z interactions (CP-odd)"},
  tLw2a2 == { TeX -> Subscript[OverTilde["\[Lambda]"],w2a2], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxqgc, OrderBlock -> 12, Description -> "fsW-fsA-W-A interactions (CP-odd)"},
  tLw2az == { TeX -> Subscript[OverTilde["\[Lambda]"],w2az], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxqgc, OrderBlock -> 13, Description -> "fsW-fsA-W-Z interactions (CP-odd)"},
  tLw2za == { TeX -> Subscript[OverTilde["\[Lambda]"],w2za], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxqgc, OrderBlock -> 14, Description -> "fsW-fsZ-W-A interactions (CP-odd)"},
  tC4g   == { TeX -> Subscript[OverTilde[c],"4G"],           ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxqgc, OrderBlock -> 15, Description -> "fsG-fsG-G-G interactions (CP-odd)"},

  (* Lh parameters *)
  dCw  == { TeX -> Subscript["\[Delta]c",w],   ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxh, OrderBlock -> 1, Description -> "W-W-h interactions"},
  dCz  == { TeX -> Subscript["\[Delta]c",z],   ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxh, OrderBlock -> 2, Description -> "Z-Z-h interactions"},
  Cww  == { TeX -> Subscript[c,ww],            ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxh, OrderBlock -> 3, Description -> "fsW-fsW-h interactions"},
  Cgg  == { TeX -> Subscript[c,gg],            ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxh, OrderBlock -> 4, Description -> "fsG-fsG-h interactions"},
  Caa  == { TeX -> Subscript[c,aa],            ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxh, OrderBlock -> 5, Description -> "fsA-fsA-h interactions"},
  Cza  == { TeX -> Subscript[c,za],            ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxh, OrderBlock -> 6, Description -> "fsZ-fsA-h interactions"},
  Czz  == { TeX -> Subscript[c,zz],            ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxh, OrderBlock -> 7, Description -> "fsZ-fsZ-h interactions"},
  Cwbx == { TeX -> Subscript[c,w,Square[""]],  ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxh, OrderBlock -> 8, Description -> "fsW-W-h interactions"},
  Czbx == { TeX -> Subscript[c,z,Square[""]],  ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxh, OrderBlock -> 9, Description -> "fsZ-Z-h interactions"},
  Cabx == { TeX -> Subscript[c,a,Square[""]],  ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxh, OrderBlock -> 10,Description -> "fsA-Z-h interactions"},
  tCww  == { TeX -> Subscript[OverTilde[c],ww], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxh, OrderBlock -> 11, Description -> "fsW-fsW-h interactions (CP-odd)"},
  tCgg  == { TeX -> Subscript[OverTilde[c],gg], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxh, OrderBlock -> 12, Description -> "fsG-fsG-h interactions (CP-odd)"},
  tCaa  == { TeX -> Subscript[OverTilde[c],aa], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxh, OrderBlock -> 13, Description -> "fsA-fsA-h interactions (CP-odd)"},
  tCza  == { TeX -> Subscript[OverTilde[c],za], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxh, OrderBlock -> 14, Description -> "fsZ-fsA-h interactions (CP-odd)"},
  tCzz  == { TeX -> Subscript[OverTilde[c],zz], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxh, OrderBlock -> 15, Description -> "fsZ-fsZ-h interactions (CP-odd)"},

  dYu == { TeX -> Subscript["\[Delta]Y",u], ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {dYu[i_,j_]->0.}, InteractionOrder -> {QNP, 1},
    BlockName -> BCxdYu, Description -> "Norm of Huu couplings"},
  dYd == { TeX -> Subscript["\[Delta]Y",d], ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {dYd[i_,j_]->0.}, InteractionOrder -> {QNP, 1},
    BlockName -> BCxdYd, Description -> "Norm of Hdd couplings"},
  dYe == { TeX -> Subscript["\[Delta]Y",e], ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {dYe[i_,j_]->0.}, InteractionOrder -> {QNP, 1},
    BlockName -> BCxdYe, Description -> "Norm of Hee couplings"},
  Su  == { TeX -> Subscript[S,"\[Phi]u"], ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Su[i_,j_]->0.707107}, BlockName -> BCxSu, Description -> "Sin(phase) of Huu couplings"},
  Sd  == { TeX -> Subscript[S,"\[Phi]d"], ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Sd[i_,j_]->0.707107}, BlockName -> BCxSd, Description -> "Sin(phase) of Hdd couplings"},
  Se  == { TeX -> Subscript[S,"\[Phi]e"], ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Se[i_,j_]->0.707107}, BlockName -> BCxSe, Description -> "Sin(phase) of Hee couplings"},
  Cu  == { TeX -> Subscript[C,"\[Phi]u"], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, Value -> {Cu[i_,j_]->Sqrt[1-Su[i,j]^2]}, Description -> "Cos(phase) of Huu couplings"},
  Cd  == { TeX -> Subscript[C,"\[Phi]d"], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, Value -> {Cd[i_,j_]->Sqrt[1-Sd[i,j]^2]}, Description -> "Cos(phase) of Huu couplings"},
  Ce  == { TeX -> Subscript[C,"\[Phi]e"], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, Value -> {Ce[i_,j_]->Sqrt[1-Se[i,j]^2]}, Description -> "Cos(phase) of Huu couplings"},

  (* Lhvff parameters *)
  RdGLhzu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGLhzu[i_,j_]->0.}, BlockName ->   BCxdGLhzu, Description -> "h-Z-u vertex interactions (real part, L)"},
  IdGLhzu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGLhzu[i_,j_]->0.}, BlockName -> IMBCxdGLhzu, Description -> "h-Z-u vertex interactions (im part, L)"  },
  RdGLhzd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGLhzd[i_,j_]->0.}, BlockName ->   BCxdGLhzd, Description -> "h-Z-d vertex interactions (real part, L)"},
  IdGLhzd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGLhzd[i_,j_]->0.}, BlockName -> IMBCxdGLhzd, Description -> "h-Z-d vertex interactions (im part, L)"  },
  RdGLhze ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGLhze[i_,j_]->0.}, BlockName ->   BCxdGLhze, Description -> "h-Z-l vertex interactions (real part, L)"},
  IdGLhze ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGLhze[i_,j_]->0.}, BlockName -> IMBCxdGLhze, Description -> "h-Z-l vertex interactions (im part, L)"},
  RdGLhzv ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGLhzv[i_,j_]->0.}, BlockName ->   BCxdGLhzv, Description -> "h-Z-v vertex interactions (real part, L)"},
  IdGLhzv ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGLhzv[i_,j_]->0.}, BlockName -> IMBCxdGLhzv, Description -> "h-Z-v vertex interactions (im part, L)"},
  RdGRhzu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGRhzu[i_,j_]->0.}, BlockName ->   BCxdGRhzu, Description -> "h-Z-u vertex interactions (real part, R)"},
  IdGRhzu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGRhzu[i_,j_]->0.}, BlockName -> IMBCxdGRhzu, Description -> "h-Z-u vertex interactions (im part, R)"  },
  RdGRhzd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGRhzd[i_,j_]->0.}, BlockName ->   BCxdGRhzd, Description -> "h-Z-d vertex interactions (real part, R)"},
  IdGRhzd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGRhzd[i_,j_]->0.}, BlockName -> IMBCxdGRhzd, Description -> "h-Z-d vertex interactions (im part, R)"  },
  RdGRhze ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGRhze[i_,j_]->0.}, BlockName ->   BCxdGRhze, Description -> "h-Z-l vertex interactions (real part, R)"},
  IdGRhze ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGRhze[i_,j_]->0.}, BlockName -> IMBCxdGRhze, Description -> "h-Z-l vertex interactions (im part, R)"},
  RdGLhwq ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGLhwq[i_,j_]->0.}, BlockName ->   BCxdGLhWq, Description -> "h-W-q vertex interactions (real part, L)"},
  IdGLhwq ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGLhwq[i_,j_]->0.}, BlockName -> IMBCxdGLhWq, Description -> "h-W-q vertex interactions (im part, L)"  },
  RdGRhwq ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGRhwq[i_,j_]->0.}, BlockName ->   BCxdGRhWq, Description -> "h-W-q vertex interactions (real part, R)"},
  IdGRhwq ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGRhwq[i_,j_]->0.}, BlockName -> IMBCxdGRhWq, Description -> "h-W-q vertex interactions (im part, R)"  },
  RdGLhwl ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdGLhwl[i_,j_]->0.}, BlockName ->   BCxdGLhWl, Description -> "h-W-l vertex interactions (real part, L)"},
  IdGLhwl ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdGLhwl[i_,j_]->0.}, BlockName -> IMBCxdGLhWl, Description -> "h-W-l vertex interactions (im part, L)"  },

  dGLhzu ==  { TeX -> Subsuperscript["\[Delta]g", L, hZu], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGLhzu[i_,j_]->RdGLhzu[i,j] + I IdGLhzu[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-Z-u vertex interactions (L)"},
  dGLhzd ==  { TeX -> Subsuperscript["\[Delta]g", L, hZd], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGLhzd[i_,j_]->RdGLhzd[i,j] + I IdGLhzd[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-Z-d vertex interactions (L)"},
  dGLhze ==  { TeX -> Subsuperscript["\[Delta]g", L, hZl], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGLhze[i_,j_]->RdGLhze[i,j] + I IdGLhze[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-Z-l vertex interactions (L)"},
  dGLhzv ==  { TeX -> Subsuperscript["\[Delta]g", L, hZv], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGLhzv[i_,j_]->RdGLhzv[i,j] + I IdGLhzv[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-Z-v vertex interactions (L)"},
  dGRhzu ==  { TeX -> Subsuperscript["\[Delta]g", R, hZu], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGRhzu[i_,j_]->RdGRhzu[i,j] + I IdGRhzu[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-Z-u vertex interactions (R)"},
  dGRhzd ==  { TeX -> Subsuperscript["\[Delta]g", R, hZd], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGRhzd[i_,j_]->RdGRhzd[i,j] + I IdGRhzd[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-Z-d vertex interactions (R)"},
  dGRhze ==  { TeX -> Subsuperscript["\[Delta]g", R, hZl], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGRhze[i_,j_]->RdGRhze[i,j] + I IdGRhze[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-Z-l vertex interactions (R)"},
  dGLhwq ==  { TeX -> Subsuperscript["\[Delta]g", L, hWq], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGLhwq[i_,j_]->RdGLhwq[i,j] + I IdGLhwq[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-W-q vertex interactions (L)"},
  dGRhwq ==  { TeX -> Subsuperscript["\[Delta]g", R, hWq], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGRhwq[i_,j_]->RdGRhwq[i,j] + I IdGRhwq[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-W-q vertex interactions (R)"},
  dGLhwl ==  { TeX -> Subsuperscript["\[Delta]g", L, hWl], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dGLhwl[i_,j_]->RdGLhwl[i,j] + I IdGLhwl[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-W-l vertex interactions (L)"},


  (* Lhdvff parameters *)
  Rdhgu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdhgu[i_,j_]->0.}, BlockName ->   BCxdhgu, Description -> "h-G-u dipole interactions (real part)"},
  Idhgu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idhgu[i_,j_]->0.}, BlockName -> IMBCxdhgu, Description -> "h-G-u dipole interactions (im part)"  },
  Rdhgd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdhgd[i_,j_]->0.}, BlockName ->   BCxdhgd, Description -> "h-G-d dipole interactions (real part)"},
  Idhgd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idhgd[i_,j_]->0.}, BlockName -> IMBCxdhgd, Description -> "h-G-d dipole interactions (im part)"  },
  Rdhau ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdhau[i_,j_]->0.}, BlockName ->   BCxdhau, Description -> "h-A-u dipole interactions (real part)"},
  Idhau ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idhau[i_,j_]->0.}, BlockName -> IMBCxdhau, Description -> "h-A-u dipole interactions (im part)"  },
  Rdhad ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdhad[i_,j_]->0.}, BlockName ->   BCxdhad, Description -> "h-A-d dipole interactions (real part)"},
  Idhad ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idhad[i_,j_]->0.}, BlockName -> IMBCxdhad, Description -> "h-A-d dipole interactions (im part)"  },
  Rdhae ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdhae[i_,j_]->0.}, BlockName ->   BCxdhae, Description -> "h-A-e dipole interactions (real part)"},
  Idhae ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idhae[i_,j_]->0.}, BlockName -> IMBCxdhae, Description -> "h-A-e dipole interactions (im part)"  },
  Rdhzu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdhzu[i_,j_]->0.}, BlockName ->   BCxdhzu, Description -> "h-Z-u dipole interactions (real part)"},
  Idhzu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idhzu[i_,j_]->0.}, BlockName -> IMBCxdhzu, Description -> "h-Z-u dipole interactions (im part)"  },
  Rdhzd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdhzd[i_,j_]->0.}, BlockName ->   BCxdhzd, Description -> "h-Z-d dipole interactions (real part)"},
  Idhzd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idhzd[i_,j_]->0.}, BlockName -> IMBCxdhzd, Description -> "h-Z-d dipole interactions (im part)"  },
  Rdhze ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdhze[i_,j_]->0.}, BlockName ->   BCxdhze, Description -> "h-Z-e dipole interactions (real part)"},
  Idhze ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idhze[i_,j_]->0.}, BlockName -> IMBCxdhze, Description -> "h-Z-e dipole interactions (im part)"  },
  Rdhwd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdhwd[i_,j_]->0.}, BlockName ->   BCxdhwd, Description -> "h-W-d dipole interactions (real part)"},
  Idhwd ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idhwd[i_,j_]->0.}, BlockName -> IMBCxdhwd, Description -> "h-W-d dipole interactions (im part)"  },
  Rdhwu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdhwu[i_,j_]->0.}, BlockName ->   BCxdhwu, Description -> "h-W-u dipole interactions (real part)"},
  Idhwu ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idhwu[i_,j_]->0.}, BlockName -> IMBCxdhwu, Description -> "h-W-u dipole interactions (im part)"  },
  Rdhwl ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rdhwl[i_,j_]->0.}, BlockName ->   BCxdhwl, Description -> "h-W-l dipole interactions (real part)"},
  Idhwl ==  { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Idhwl[i_,j_]->0.}, BlockName -> IMBCxdhwl, Description -> "h-W-l dipole interactions (im part)"  },
  Rtdhgu == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rtdhgu[i_,j_]->0.}, BlockName ->   BCxtdhgu, Description -> "h-G-u dipole interactions (real part)"},
  Itdhgu == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Itdhgu[i_,j_]->0.}, BlockName -> IMBCxtdhgu, Description -> "h-G-u dipole interactions (im part, CP-odd)  "},
  Rtdhgd == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rtdhgd[i_,j_]->0.}, BlockName ->   BCxtdhgd, Description -> "h-G-d dipole interactions (real part, CP-odd)"},
  Itdhgd == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Itdhgd[i_,j_]->0.}, BlockName -> IMBCxtdhgd, Description -> "h-G-d dipole interactions (im part, CP-odd)"  },
  Rtdhau == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rtdhau[i_,j_]->0.}, BlockName ->   BCxtdhau, Description -> "h-A-u dipole interactions (real part, CP-odd)"},
  Itdhau == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Itdhau[i_,j_]->0.}, BlockName -> IMBCxtdhau, Description -> "h-A-u dipole interactions (im part, CP-odd)"  },
  Rtdhad == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rtdhad[i_,j_]->0.}, BlockName ->   BCxtdhad, Description -> "h-A-d dipole interactions (real part, CP-odd)"},
  Itdhad == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Itdhad[i_,j_]->0.}, BlockName -> IMBCxtdhad, Description -> "h-A-d dipole interactions (im part, CP-odd)"  },
  Rtdhae == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rtdhae[i_,j_]->0.}, BlockName ->   BCxtdhae, Description -> "h-A-e dipole interactions (real part, CP-odd)"},
  Itdhae == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Itdhae[i_,j_]->0.}, BlockName -> IMBCxtdhae, Description -> "h-A-e dipole interactions (im part, CP-odd)"  },
  Rtdhzu == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rtdhzu[i_,j_]->0.}, BlockName ->   BCxtdhzu, Description -> "h-Z-u dipole interactions (real part, CP-odd)"},
  Itdhzu == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Itdhzu[i_,j_]->0.}, BlockName -> IMBCxtdhzu, Description -> "h-Z-u dipole interactions (im part, CP-odd)"  },
  Rtdhzd == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rtdhzd[i_,j_]->0.}, BlockName ->   BCxtdhzd, Description -> "h-Z-d dipole interactions (real part, CP-odd)"},
  Itdhzd == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Itdhzd[i_,j_]->0.}, BlockName -> IMBCxtdhzd, Description -> "h-Z-d dipole interactions (im part, CP-odd)"  },
  Rtdhze == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Rtdhze[i_,j_]->0.}, BlockName ->   BCxtdhze, Description -> "h-Z-e dipole interactions (real part, CP-odd)"},
  Itdhze == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {Itdhze[i_,j_]->0.}, BlockName -> IMBCxtdhze, Description -> "h-Z-e dipole interactions (im part, CP-odd)"  },

  dhgu ==  { TeX -> Subscript["d", hgu], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dhgu[i_,j_]->Rdhgu[i,j] + I Idhgu[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-G-u dipole interactions"},
  dhgd ==  { TeX -> Subscript["d", hgd], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dhgd[i_,j_]->Rdhgd[i,j] + I Idhgd[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-G-d dipole interactions"},
  dhau ==  { TeX -> Subscript["d", hau], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dhau[i_,j_]->Rdhau[i,j] + I Idhau[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-A-u dipole interactions"},
  dhad ==  { TeX -> Subscript["d", had], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dhad[i_,j_]->Rdhad[i,j] + I Idhad[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-A-d dipole interactions"},
  dhae ==  { TeX -> Subscript["d", hae], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dhae[i_,j_]->Rdhae[i,j] + I Idhae[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-A-e dipole interactions"},
  dhzu ==  { TeX -> Subscript["d", hzu], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dhzu[i_,j_]->Rdhzu[i,j] + I Idhzu[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-Z-u dipole interactions"},
  dhzd ==  { TeX -> Subscript["d", hzd], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dhzd[i_,j_]->Rdhzd[i,j] + I Idhzd[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-Z-d dipole interactions"},
  dhze ==  { TeX -> Subscript["d", hze], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dhze[i_,j_]->Rdhze[i,j] + I Idhze[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-Z-e dipole interactions"},
  dhwu ==  { TeX -> Subscript["d", hwu], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dhwu[i_,j_]->Rdhwu[i,j] + I Idhwu[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-w-u dipole interactions"},
  dhwd ==  { TeX -> Subscript["d", hwd], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dhwd[i_,j_]->Rdhwd[i,j] + I Idhwd[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-w-d dipole interactions"},
  dhwl ==  { TeX -> Subscript["d", hwl], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {dhwl[i_,j_]->Rdhwl[i,j] + I Idhwl[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-W-l dipole interactions"},

  tdhgu ==  { TeX -> Subscript[OverTilde["d"], hgu], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {tdhgu[i_,j_]->Rtdhgu[i,j] + I Itdhgu[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-G-u dipole interactions (CP-odd)"},
  tdhgd ==  { TeX -> Subscript[OverTilde["d"], hgd], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {tdhgd[i_,j_]->Rtdhgd[i,j] + I Itdhgd[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-G-d dipole interactions (CP-odd)"},
  tdhau ==  { TeX -> Subscript[OverTilde["d"], hau], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {tdhau[i_,j_]->Rtdhau[i,j] + I Itdhau[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-A-u dipole interactions (CP-odd)"},
  tdhad ==  { TeX -> Subscript[OverTilde["d"], had], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {tdhad[i_,j_]->Rtdhad[i,j] + I Itdhad[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-A-d dipole interactions (CP-odd)"},
  tdhae ==  { TeX -> Subscript[OverTilde["d"], hae], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {tdhae[i_,j_]->Rtdhae[i,j] + I Itdhae[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-A-e dipole interactions (CP-odd)"},
  tdhzu ==  { TeX -> Subscript[OverTilde["d"], hzu], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {tdhzu[i_,j_]->Rtdhzu[i,j] + I Itdhzu[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-Z-u dipole interactions (CP-odd)"},
  tdhzd ==  { TeX -> Subscript[OverTilde["d"], hzd], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {tdhzd[i_,j_]->Rtdhzd[i,j] + I Itdhzd[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-Z-d dipole interactions (CP-odd)"},
  tdhze ==  { TeX -> Subscript[OverTilde["d"], hze], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter->True,
    Value -> {tdhze[i_,j_]->Rtdhze[i,j] + I Itdhze[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "h-Z-e dipole interactions (CP-odd)"},

  (* Lhself parameters *)
  dL3 == { TeX -> Subscript["\[Delta]\[Lambda]",3], ParameterType -> External, Value -> 0., InteractionOrder -> {{QED,1}, {QNP, 1}}, BlockName -> BCxhself,  OrderBlock -> 1, Description -> "Trilinear Higgs self-coupling"},
  dL4 == { TeX -> Subscript["\[Delta]\[Lambda]",4], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxhself,  OrderBlock -> 2, Description -> "Quartic Higgs self-coupling"},

  (* Lhh parameters *)
  dCw2  == { TeX -> Subsuperscript["\[Delta]c",w,"(2)"],    ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxhh, OrderBlock -> 1, Description -> "W-W-h-h interactions"},
  dCz2  == { TeX -> Subsuperscript["\[Delta]c",z,"(2)"],    ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxhh, OrderBlock -> 2, Description -> "Z-Z-h-h interactions"},
  Cww2  == { TeX -> Subsuperscript[c,ww,"(2)"],             ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxhh, OrderBlock -> 3, Description -> "fsW-fsW-h-h interactions"},
  Cgg2  == { TeX -> Subsuperscript[c,gg,"(2)"],             ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxhh, OrderBlock -> 4, Description -> "fsG-fsG-h-h interactions"},
  Caa2  == { TeX -> Subsuperscript[c,aa,"(2)"],             ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxhh, OrderBlock -> 5, Description -> "fsA-fsA-h-h interactions"},
  Cza2  == { TeX -> Subsuperscript[c,za,"(2)"],             ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxhh, OrderBlock -> 6, Description -> "fsZ-fsA-h-h interactions"},
  Czz2  == { TeX -> Subsuperscript[c,zz,"(2)"],             ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxhh, OrderBlock -> 7, Description -> "fsZ-fsZ-h-h interactions"},
  Cwbx2 == { TeX -> Subsuperscript[c,w,Square[""],"(2)"],   ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxhh, OrderBlock -> 8, Description -> "fsW-W-h-h interactions"},
  Czbx2 == { TeX -> Subsuperscript[c,z,Square[""],"(2)"],   ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxhh, OrderBlock -> 9, Description -> "fsZ-Z-h-h interactions"},
  Cabx2 == { TeX -> Subsuperscript[c,a,Square[""],"(2)"],   ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxhh, OrderBlock -> 10,Description -> "fsA-Z-h-h interactions"},
  tCww2  == { TeX -> Subsuperscript[OverTilde[c],ww,"(2)"], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxhh, OrderBlock -> 11, Description -> "fsW-fsW-h-h interactions (CP-odd)"},
  tCgg2  == { TeX -> Subsuperscript[OverTilde[c],gg,"(2)"], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxhh, OrderBlock -> 12, Description -> "fsG-fsG-h-h interactions (CP-odd)"},
  tCaa2  == { TeX -> Subsuperscript[OverTilde[c],aa,"(2)"], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxhh, OrderBlock -> 13, Description -> "fsA-fsA-h-h interactions (CP-odd)"},
  tCza2  == { TeX -> Subsuperscript[OverTilde[c],za,"(2)"], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxhh, OrderBlock -> 14, Description -> "fsZ-fsA-h-h interactions (CP-odd)"},
  tCzz2  == { TeX -> Subsuperscript[OverTilde[c],zz,"(2)"], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCxhh, OrderBlock -> 15, Description -> "fsZ-fsZ-h-h interactions (CP-odd)"},

  RdYu2 == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdYu2[i_,j_]->0.}, BlockName ->   BCxY2u, Description -> "HHuu couplings (real part)"},
  RdYd2 == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdYd2[i_,j_]->0.}, BlockName ->   BCxY2d, Description -> "HHdd couplings (real part)"},
  RdYe2 == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {RdYe2[i_,j_]->0.}, BlockName ->   BCxY2e, Description -> "HHee couplings (real part)"},
  IdYu2 == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdYu2[i_,j_]->0.}, BlockName -> IMBCxY2u, Description -> "HHuu couplings (im part)"},
  IdYd2 == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdYd2[i_,j_]->0.}, BlockName -> IMBCxY2d, Description -> "HHdd couplings (im part)"},
  IdYe2 == { ParameterType -> External, Indices -> {Index[Generation], Index[Generation]}, Value -> {IdYe2[i_,j_]->0.}, BlockName -> IMBCxY2e, Description -> "HHee couplings (im part)"},

  dYu2 == { TeX -> Subsuperscript["\[Delta]Y",u,"(2)"], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter -> True,
    Value -> {dYu2[i_,j_]->RdYu2[i,j]+I*IdYu2[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "HHuu couplings"},
  dYd2 == { TeX -> Subsuperscript["\[Delta]Y",d,"(2)"], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter -> True,
    Value -> {dYd2[i_,j_]->RdYd2[i,j]+I*IdYd2[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "HHdd couplings"},
  dYe2 == { TeX -> Subsuperscript["\[Delta]Y",e,"(2)"], ParameterType -> Internal, Indices -> {Index[Generation], Index[Generation]}, ComplexParameter -> True,
    Value -> {dYe2[i_,j_]->RdYe2[i,j]+I*IdYe2[i,j]}, InteractionOrder -> {QNP, 1}, Description -> "HHee couplings"},

  (* Four-fermion interactions *)
  cll1122 == { TeX -> Subscript[c,ll,1122],    ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCx4f,  OrderBlock -> 1, Description -> "Four fermion interaction strength"},
  cpuu3333== { TeX -> Subscript["c'",uu,3333], ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCx4f,  OrderBlock -> 2, Description -> "Four fermion interaction strength"},
  cll1221 == { TeX -> Subscript[c,ll,1221],    ParameterType -> External, Value -> 0., InteractionOrder -> {QNP, 1}, BlockName -> BCx4f,  OrderBlock -> 3, Description -> "Four fermion interaction strength"},

  (* loop-induced SM couplings *)
  gHgg == { ParameterType -> Internal,
            Value -> 1/(4*Pi)/(3*Pi),
            TeX -> Subscript[g,Hgg], 
            Description -> "loop-induced SM Hgg coupling"},			
  gHaa == { ParameterType -> Internal,
            Value -> -1/(4*Pi)/(Pi)*(47/18),
            TeX -> Subscript[g,Haa],
            Description -> "loop-induced SM Haa coupling"},		
  gHza == { ParameterType -> Internal,
            Value -> -Sqrt[ee^2/(4*Pi)*Gf*MZ^2/(8*Sqrt[2]*Pi)]*(94*cw^2-13)/(9*Pi)/ee^2,
            TeX -> Subscript[g,Hza],
            Description -> "loop-induced SM Hza coupling"}
		   
};


(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

(* eq. (3.3) in the Higgs basis note *)
LMass:= 2 dM gw^2 vev^2/4 W[mu] Wbar[mu];

(* eq. (3.4) *)
Lvertex := Block[{LZ,LW},
  LZ =  Sqrt[gw^2+g1^2] Z[mu] ( uqbar.Ga[mu].dGLzu.ProjM.uq + dqbar.Ga[mu].dGLzd.ProjM.dq + lbar.Ga[mu].dGLze.ProjM.l + vlbar.Ga[mu].dGLzv.ProjM.vl +
                                uqbar.Ga[mu].dGRzu.ProjP.uq + dqbar.Ga[mu].dGRzd.ProjP.dq + lbar.Ga[mu].dGRze.ProjP.l );
  LW= gw/Sqrt[2] W[mu] (uqbar.Ga[mu].dGLwq.ProjM.dq + uqbar.Ga[mu].dGRwq.ProjP.dq + vlbar.Ga[mu].dGLwl.ProjM.l);
  LZ+LW+HC[LW]
];

(* eq. (3.5) for the dipole terms *)
Ldip:=Block[{LG,LA,LZ,LW},
  LG = gs FS[G,mu,nu,a] (uqbar.Sig[mu,nu].T[a].dgu.uq + dqbar.Sig[mu,nu].T[a].dgd.dq) +
       gs Dual[FS][G,mu,nu,a] (uqbar.Sig[mu,nu].T[a].tdgu.uq + dqbar.Sig[mu,nu].T[a].tdgd.dq);
  LA = ee FS[A,mu,nu] (uqbar.Sig[mu,nu].dau.uq + dqbar.Sig[mu,nu].dad.dq + lbar.Sig[mu,nu].dae.l) +
       ee Dual[FS][A,mu,nu] (uqbar.Sig[mu,nu].tdau.uq + dqbar.Sig[mu,nu].tdad.dq + lbar.Sig[mu,nu].tdae.l);
  LZ = Sqrt[gw^2+g1^2] FS[Z,mu,nu] (uqbar.Sig[mu,nu].dzu.uq + dqbar.Sig[mu,nu].dzd.dq + lbar.Sig[mu,nu].dze.l) +
       Sqrt[gw^2+g1^2] Dual[FS][Z,mu,nu] (uqbar.Sig[mu,nu].tdzu.uq + dqbar.Sig[mu,nu].tdzd.dq + lbar.Sig[mu,nu].tdze.l);
  LW = Sqrt[2] gw (FS[Wbar,mu,nu] dqbar.Sig[mu,nu].dwu.ProjP.uq + FS[W,mu,nu] uqbar.Sig[mu,nu].dwd.ProjP.dq + FS[W,mu,nu] vlbar.Sig[mu,nu].dwl.ProjP.l);
  -1/(4 vev) (LG+LA+LZ+LW)
];

(* eqs. (3.6) and (3.7) for the gauge boson self-interactions *)
Ltgc := I ee ( dKa FS[A,mu,nu] W[mu] Wbar[nu]  + tKa Dual[FS][A,mu,nu] W[mu] Wbar[nu]  ) +
        I gw cw ( dG1z (FS[W,mu,nu] Wbar[mu] - FS[Wbar,mu,nu] W[mu] ) Z[nu] + dKz FS[Z,mu,nu] W[mu] Wbar[nu]  + tKz Dual[FS][Z,mu,nu] W[mu] Wbar[nu] ) +
        I ee/MW^2 ( La FS[W,mu,nu] FS[Wbar,nu,rho] FS[A,rho,mu] + tLa FS[W,mu,nu] FS[Wbar,nu,rho] Dual[FS][A,rho,mu] ) +
        I gw cw/MW^2 ( Lz  FS[W,mu,nu] FS[Wbar,nu,rho] FS[Z,rho,mu] + tLz FS[W,mu,nu] FS[Wbar,nu,rho] Dual[FS][Z,rho,mu] ) +
        gs^3/vev^2 f[a,b,c] ( C3g FS[G,mu,nu,a] FS[G,nu,rho,b] FS[G,rho,mu,c] + tC3g Dual[FS][G,mu,nu,a] FS[G,nu,rho,b] FS[G,rho,mu,c] );

Lqgc := gw^2/2    dGw4    ( W[mu] W[mu] Wbar[nu] Wbar[nu] - W[mu] Wbar[mu] W[nu] Wbar[nu] ) +
        gw^2 cw^2 dGw2z2  ( W[mu] Z[mu] Wbar[nu] Z[nu]    - W[mu] Wbar[mu] Z[nu] Z[nu]    ) +
        gw^2 cw sw dGw2za ( W[mu] Z[mu] Wbar[nu] A[nu]    + W[mu] A[mu] Wbar[nu] Z[nu] - 2 W[mu] Wbar[mu] Z[nu] A[nu] ) -
        gw^2/2/MW^2    Lw4   ( FS[W,mu,nu] FS[Wbar,nu,rho] - FS[Wbar,mu,nu] FS[W,nu,rho] ) ( W[mu] Wbar[rho] - Wbar[mu] W[rho] ) -
        gw^2 cw^2/MW^2 Lw2z2 ( W[mu] ( FS[Z,mu,nu] FS[Wbar,nu,rho] - FS[Wbar,mu,nu] FS[Z,nu,rho] ) Z[rho] + Wbar[mu] ( FS[Z,mu,nu] FS[W,nu,rho] - FS[W,mu,nu] FS[Z,nu,rho] ) Z[rho] ) -
        ee^2/MW^2      Lw2a2 ( W[mu] ( FS[A,mu,nu] FS[Wbar,nu,rho] - FS[Wbar,mu,nu] FS[A,nu,rho] ) A[rho] + Wbar[mu] ( FS[A,mu,nu] FS[W,nu,rho] - FS[W,mu,nu] FS[A,nu,rho] ) A[rho] ) -
        ee gw cw/MW^2  Lw2az ( W[mu] ( FS[A,mu,nu] FS[Wbar,nu,rho] - FS[Wbar,mu,nu] FS[A,nu,rho] ) Z[rho] + Wbar[mu] ( FS[A,mu,nu] FS[W,nu,rho] - FS[W,mu,nu] FS[A,nu,rho] ) Z[rho] ) -
        ee gw cw/MW^2  Lw2za ( W[mu] ( FS[Z,mu,nu] FS[Wbar,nu,rho] - FS[Wbar,mu,nu] FS[Z,nu,rho] ) A[rho] + Wbar[mu] ( FS[Z,mu,nu] FS[W,nu,rho] - FS[W,mu,nu] FS[Z,nu,rho] ) A[rho] ) +
        3 gs^3/vev^2   C4g f[a,b,c] f[c,d,e] FS[G,mu,nu,a] FS[G,nu,rho,b] G[rho,d] G[mu,e] -
        gw^2/2/MW^2    tLw4   ( FS[W,mu,nu] Dual[FS][Wbar,nu,rho] - FS[Wbar,mu,nu] Dual[FS][W,nu,rho] ) ( W[mu] Wbar[rho] - Wbar[mu] W[rho] ) -
        gw^2 cw^2/MW^2 tLw2z2 ( W[mu] ( FS[Z,mu,nu] Dual[FS][Wbar,nu,rho] - FS[Wbar,mu,nu] Dual[FS][Z,nu,rho] ) Z[rho] + Wbar[mu] ( FS[Z,mu,nu] FS[W,nu,rho] - FS[W,mu,nu] FS[Z,nu,rho] ) Z[rho] ) -
        ee^2/MW^2      tLw2a2 ( W[mu] ( FS[A,mu,nu] Dual[FS][Wbar,nu,rho] - FS[Wbar,mu,nu] Dual[FS][A,nu,rho] ) A[rho] + Wbar[mu] ( FS[A,mu,nu] FS[W,nu,rho] - FS[W,mu,nu] FS[A,nu,rho] ) A[rho] ) -
        ee gw cw/MW^2  tLw2az ( W[mu] ( FS[A,mu,nu] Dual[FS][Wbar,nu,rho] - FS[Wbar,mu,nu] Dual[FS][A,nu,rho] ) Z[rho] + Wbar[mu] ( FS[A,mu,nu] FS[W,nu,rho] - FS[W,mu,nu] FS[A,nu,rho] ) Z[rho] ) -
        ee gw cw/MW^2  tLw2za ( W[mu] ( FS[Z,mu,nu] Dual[FS][Wbar,nu,rho] - FS[Wbar,mu,nu] Dual[FS][Z,nu,rho] ) A[rho] + Wbar[mu] ( FS[Z,mu,nu] FS[W,nu,rho] - FS[W,mu,nu] FS[Z,nu,rho] ) A[rho] ) +
        3 gs^3/vev^2   tC4g f[a,b,c] f[c,d,e] Dual[FS][G,mu,nu,a] FS[G,nu,rho,b] G[rho,d] G[mu,e];


(* eq.(3.8) for the 3-point single Higgs interactions *)
Lh := Block[{Lvv,Lff},
  Lvv = 2 dCw MW^2 Wbar[mu] W[mu] + dCz MZ^2 Z[mu] Z[mu] +
           gs^2/4     gHgg FS[G,mu,nu,a]  FS[G,mu,nu,a] +
           gs^2/4      Cgg FS[G,mu,nu,a]  FS[G,mu,nu,a] + gs^2/4      tCgg FS[G,mu,nu,a]  Dual[FS][G,mu,nu,a] +
           gw^2/2      Cww FS[Wbar,mu,nu] FS[W,mu,nu]   + gw^2/2      tCww FS[Wbar,mu,nu] Dual[FS][W,mu,nu]  +
		   ee^2/4     gHaa FS[A,mu,nu]    FS[A,mu,nu]   +
           ee^2/4      Caa FS[A,mu,nu]    FS[A,mu,nu]   + ee^2/4      tCaa FS[A,mu,nu]    Dual[FS][A,mu,nu] +
		   ee^2/2     gHza FS[Z,mu,nu]    FS[A,mu,nu]   +
           ee gw/2/cw  Cza FS[Z,mu,nu]    FS[A,mu,nu]   + ee gw/2/cw  tCza FS[Z,mu,nu]    Dual[FS][A,mu,nu] +
           gw^2/4/cw^2 Czz FS[Z,mu,nu]    FS[Z,mu,nu]   + gw^2/4/cw^2 tCzz FS[Z,mu,nu]    Dual[FS][Z,mu,nu] +
           gw^2 Cwbx (Wbar[mu] del[FS[W,mu,nu],nu] + W[mu] del[FS[Wbar,mu,nu],nu]) + g1 gw Cabx Z[mu] del[FS[A,mu,nu],nu] + gw^2 Czbx Z[mu] del[FS[Z,mu,nu],nu];
  Lff = - ExpandIndices[Plus@@Flatten[Table[Sqrt[Mu[ff] Mu[ffp]] dYu[ff,ffp] (Cu[ff,ffp] IndexDelta[sp1,sp2]-I*Su[ff,ffp] Ga[5,sp1,sp2]) uqbar[sp1,ff,cc].uq[sp2,ffp,cc], {ffp,1,3},{ff,1,3}]]] -
          ExpandIndices[Plus@@Flatten[Table[Sqrt[Md[ff] Md[ffp]] dYd[ff,ffp] (Cd[ff,ffp] IndexDelta[sp1,sp2]-I*Sd[ff,ffp] Ga[5,sp1,sp2]) dqbar[sp1,ff,cc].dq[sp2,ffp,cc], {ffp,1,3},{ff,1,3}]]] -
          ExpandIndices[Plus@@Flatten[Table[Sqrt[Ml[ff] Ml[ffp]] dYe[ff,ffp] (Ce[ff,ffp] IndexDelta[sp1,sp2]-I*Se[ff,ffp] Ga[5,sp1,sp2]) lbar[sp1,ff].l[sp2,ffp], {ffp,1,3},{ff,1,3}]]];
  H/vev (Lvv + Lff)
];

(* eq (3.9) for the hvff interactions *)
Lhvff := Block[{LW,LZ},
  LW = Sqrt[2] gw H/vev W[mu] (uqbar.Ga[mu].dGLhwq.ProjM.dq + uqbar.Ga[mu].dGRhwq.ProjP.dq + vlbar.Ga[mu].dGLhwl.ProjM.l);
  LZ = 2 Sqrt[gw^2+g1^2] H/vev Z[mu] ( uqbar.Ga[mu].dGLhzu.ProjM.uq + dqbar.Ga[mu].dGLhzd.ProjM.dq + lbar.Ga[mu].dGLhze.ProjM.l + vlbar.Ga[mu].dGLhzv.ProjM.vl +
                                       uqbar.Ga[mu].dGRhzu.ProjP.uq + dqbar.Ga[mu].dGRhzd.ProjP.dq + lbar.Ga[mu].dGRhze.ProjP.l );
  LZ + LW + HC[LW]
];

(* eq. (3.11) for the hvff dipole terms *)
Lhdvff:=Block[{LG,LA,LZ,LW},
  LG = gs FS[G,mu,nu,a] (uqbar.Sig[mu,nu].T[a].dhgu.uq + dqbar.Sig[mu,nu].T[a].dhgd.dq) +
       gs Dual[FS][G,mu,nu,a] (uqbar.Sig[mu,nu].T[a].tdhgu.uq + dqbar.Sig[mu,nu].T[a].tdhgd.dq);
  LA = ee FS[A,mu,nu] (uqbar.Sig[mu,nu].dhau.uq + dqbar.Sig[mu,nu].dhad.dq + lbar.Sig[mu,nu].dhae.l) +
       ee Dual[FS][A,mu,nu] (uqbar.Sig[mu,nu].tdhau.uq + dqbar.Sig[mu,nu].tdhad.dq + lbar.Sig[mu,nu].tdhae.l);
  LZ = Sqrt[gw^2+g1^2] FS[Z,mu,nu] (uqbar.Sig[mu,nu].dhzu.uq + dqbar.Sig[mu,nu].dhzd.dq + lbar.Sig[mu,nu].dhze.l) +
       Sqrt[gw^2+g1^2] Dual[FS][Z,mu,nu] (uqbar.Sig[mu,nu].tdhzu.uq + dqbar.Sig[mu,nu].tdhzd.dq + lbar.Sig[mu,nu].tdhze.l);
  LW = Sqrt[2] gw (FS[Wbar,mu,nu] dqbar.Sig[mu,nu].dhwu.ProjP.uq +  FS[W,mu,nu] uqbar.Sig[mu,nu].dhwd.ProjP.dq + FS[W,mu,nu] vlbar.Sig[mu,nu].dhwl.ProjP.l);
  -H/(4 vev^2) (LG+LA+LZ+LW)
];

(* eq.(3.12)  for the Higgs self interactions *)
Lhself := -dL3 vev H^3 - dL4 H^4;

(* eq (3.13) for the diHiggs couplings *)
Lhh := Block[{Lvv,Lff},
  Lvv = dCw2 gw^2 Wbar[mu] W[mu] + dCz2 Sqrt[g1^2+gw^2]/2 Z[mu] Z[mu] +
         gs^2/8        Cgg2 FS[G,mu,nu,a]  FS[G,mu,nu,a] + gs^2/8          tCgg2 FS[G,mu,nu,a]  Dual[FS][G,mu,nu,a] +
         gw^2/4        Cww2 FS[Wbar,mu,nu] FS[W,mu,nu]   + gw^2/4          tCww2 FS[Wbar,mu,nu] Dual[FS][W,mu,nu]   +
         ee^2/8        Caa2 FS[A,mu,nu]    FS[A,mu,nu]   + ee^2/8          tCaa2 FS[A,mu,nu]    Dual[FS][A,mu,nu]   +
         gw g1/4       Cza2 FS[Z,mu,nu]    FS[A,mu,nu]   + gw g1/4         tCza2 FS[Z,mu,nu]    Dual[FS][A,mu,nu]   +
         (gw^2+g1^2)/8 Czz2 FS[Z,mu,nu]    FS[Z,mu,nu]   + (gw^2 + g1^2)/8 tCzz2 FS[Z,mu,nu]    Dual[FS][Z,mu,nu]   -
         gw^2 Cwbx2/2 (Wbar[mu] del[FS[W,mu,nu],nu] + W[mu] del[FS[Wbar,mu,nu],nu]) -
         gw^2 Cabx2/2 Z[mu] del[FS[A,mu,nu],nu] -
         gw^2 Czbx2/2 Z[mu] del[FS[Z,mu,nu],nu];
  Lff = -ExpandIndices[Plus@@Flatten[Table[Sqrt[Mu[ff] Mu[ffp]]/2 dYu2[ff,ffp] ProjM[sp1,sp2] uqbar[sp1,ff,cc].uq[sp2,ffp,cc], {ffp,1,3},{ff,1,3}]]] -
         ExpandIndices[Plus@@Flatten[Table[Sqrt[Md[ff] Md[ffp]]/2 dYd2[ff,ffp] ProjM[sp1,sp2] dqbar[sp1,ff,cc].dq[sp2,ffp,cc], {ffp,1,3},{ff,1,3}]]] -
         ExpandIndices[Plus@@Flatten[Table[Sqrt[Ml[ff] Ml[ffp]]/2 dYe2[ff,ffp] ProjM[sp1,sp2] lbar[sp1,ff].l[sp2,ffp], {ffp,1,3},{ff,1,3}]]];
  H^2/vev^2 ( Lvv + Lff + HC[Lff] )
];

(* LOther not included *)

(* The sum of all contributions *)
LBSMC:= {LMass, Lvertex, Ldip, Ltgc, Lqgc, Lh, Lhvff, Lhdvff, Lhself, Lhh};
