(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     30692,        912]
NotebookOptionsPosition[     25349,        732]
NotebookOutlinePosition[     25722,        749]
CellTagsIndexPosition[     25679,        746]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
  3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
  3.4234163227881193`*^9}, {3.424068937202279*^9, 3.424068972595354*^9}, {
  3.441972201424767*^9, 3.441972204100518*^9}, {3.441974075463511*^9, 
  3.441974075807181*^9}, {3.44275751802024*^9, 3.442757518156605*^9}, {
  3.4543250469973173`*^9, 3.4543250494197693`*^9}, {3.516783400817431*^9, 
  3.5167834220533867`*^9}, {3.5173357288552427`*^9, 3.517335732723227*^9}, {
  3.528710280793704*^9, 3.5287102823479433`*^9}, {3.535207105567418*^9, 
  3.535207106023735*^9}, {3.5352075888368263`*^9, 3.535207590724679*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"$FeynRulesPath", "=", 
  RowBox[{
  "SetDirectory", "[", "\"\<~/mathematica/FeynRules_1.6.0\>\"", 
   "]"}]}]], "Input"],

Cell[BoxData["\<\"/home/lb1010/mathematica/FeynRules_1.6.0\"\>"], "Output",
 CellChangeTimes->{3.535207585867983*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input"],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"Get", "::", "noopen"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Cannot open \
\[NoBreak]\\!\\(\\\"FeynRules`\\\"\\)\[NoBreak]. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/noopen\\\", ButtonNote -> \
\\\"Get::noopen\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{{3.53520756138244*^9, 3.53520757375135*^9}}],

Cell[BoxData["$Failed"], "Output",
 CellChangeTimes->{{3.5352075613868504`*^9, 3.535207573811308*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/minimal_Zp\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.419073170860696*^9, 3.419073182827229*^9}, {
  3.424068987980844*^9, 3.4240689893965273`*^9}, {3.5166247126271763`*^9, 
  3.516624713497857*^9}, {3.5352070954798527`*^9, 3.535207098236246*^9}}],

Cell[CellGroupData[{

Cell["The minimal Zp models", "Title",
 CellChangeTimes->{{3.424069004105296*^9, 3.424069007850328*^9}, {
  3.51667774685853*^9, 3.516677747368164*^9}, {3.535207524910108*^9, 
  3.5352075311664057`*^9}}],

Cell["\<\
We first load in the minimal Zp Models model-file\
\>", "Text",
 CellChangeTimes->{{3.424069016807353*^9, 3.4240690172628117`*^9}, {
  3.53520753529545*^9, 3.5352075434754763`*^9}}],

Cell[BoxData[
 RowBox[{"LoadModel", "[", "\"\<minimal_Zp.fr\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.4022069973481913`*^9, 3.402207011768662*^9}, 
   3.4022081212072697`*^9, {3.402208250379383*^9, 3.402208254043104*^9}, 
   3.4027466057480917`*^9, {3.403240270135737*^9, 3.403240277228945*^9}, 
   3.403266503388291*^9, {3.403267649630335*^9, 3.40326765417397*^9}, {
   3.403269919787421*^9, 3.403269921965273*^9}, {3.403347551273425*^9, 
   3.403347555049163*^9}, 3.4044490490588417`*^9, {3.411744339876704*^9, 
   3.411744340012457*^9}, {3.4121886924550533`*^9, 3.412188699157571*^9}, 
   3.412188808811866*^9, 3.4121888580521603`*^9, {3.412450464077868*^9, 
   3.412450464378695*^9}, {3.413715097460478*^9, 3.41371509757642*^9}, {
   3.41440825334604*^9, 3.414408254159686*^9}, {3.41862573831756*^9, 
   3.4186257392223186`*^9}, {3.4190731862389174`*^9, 3.419073187003003*^9}, {
   3.419073336802393*^9, 3.4190733374513063`*^9}, {3.4190828041801767`*^9, 
   3.4190828048079023`*^9}, {3.4240690195427647`*^9, 3.424069028019803*^9}, {
   3.516624716643621*^9, 3.5166247173457317`*^9}, {3.535207113629547*^9, 
   3.5352071154697723`*^9}}],

Cell[CellGroupData[{

Cell["The B-L lagrangian", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.424069513901162*^9, 3.424069514344799*^9}}],

Cell[CellGroupData[{

Cell["Unitary Gauge", "Subsection",
 CellChangeTimes->{{3.411910080775518*^9, 3.41191008414785*^9}}],

Cell["\<\
The full lagrangian in unitary gauge can be accessed immediatly via\
\>", "Text",
 CellChangeTimes->{{3.411910016771447*^9, 3.411910062087528*^9}, {
  3.411910094087652*^9, 3.411910096590087*^9}, {3.411910215381351*^9, 
  3.4119102162371798`*^9}}],

Cell[BoxData["LmZp"], "Input",
 CellChangeTimes->{{3.411910106011015*^9, 3.411910106351081*^9}, {
  3.535207118838848*^9, 3.53520711951691*^9}}],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}}],

Cell["\<\
The part of the lagrangian representing the gauge sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}}],

Cell[BoxData["LGauge"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910274288354*^9, 3.41191027703699*^9}}],

Cell["\<\
The part of the lagrangian representing the scalar sector can be accessed via\
\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.41191028690167*^9, 
  3.411910287709094*^9}}],

Cell[BoxData["LHiggs"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910290186841*^9, 3.411910292005392*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fermion sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.4119103528868923`*^9, 3.411910357404933*^9}}],

Cell["\<\
The part of the lagrangian representing the fermion sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.4119103873434134`*^9, 
  3.411910388077118*^9}}],

Cell[BoxData["LFermions"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910379677638*^9, 3.4119103807255*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}}],

Cell["\<\
The part of the lagrangian representing the Yukawa sector can be accessed via\
\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.411910399061659*^9, 
  3.411910400421185*^9}}],

Cell[BoxData["LYukawa"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.4119104032372026`*^9, 3.411910404165523*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Feynman Gauge", "Subsection",
 CellChangeTimes->{{3.411910080775518*^9, 3.41191008414785*^9}, {
  3.411910431304595*^9, 3.41191043361451*^9}}],

Cell["\<\
By default, SM lagrangian is loaded in unitary gauge. However, Feynman gauge \
can be obtained by putting\
\>", "Text",
 CellChangeTimes->{{3.411910440565042*^9, 3.411910480762147*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input",
 CellChangeTimes->{{3.411910487433539*^9, 3.4119104927114267`*^9}}],

Cell["\<\
The full lagrangian in Feynman gauge can be accessed immediatly via\
\>", "Text",
 CellChangeTimes->{{3.411910016771447*^9, 3.411910062087528*^9}, {
  3.411910094087652*^9, 3.411910096590087*^9}, {3.411910215381351*^9, 
  3.4119102162371798`*^9}, {3.411910436148773*^9, 3.411910437013105*^9}}],

Cell[BoxData["LmZp"], "Input",
 CellChangeTimes->{{3.411910106011015*^9, 3.411910106351081*^9}, {
  3.535207124147511*^9, 3.535207124704051*^9}}],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}}],

Cell["\<\
The part of the lagrangian representing the gauge sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}}],

Cell[BoxData["LGauge"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910274288354*^9, 3.41191027703699*^9}}],

Cell["\<\
The part of the lagrangian representing the scalar sector can be accessed via\
\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.41191028690167*^9, 
  3.411910287709094*^9}}],

Cell[BoxData["LHiggs"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910290186841*^9, 3.411910292005392*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fermion sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.4119103528868923`*^9, 3.411910357404933*^9}}],

Cell["\<\
The part of the lagrangian representing the fermion sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.4119103873434134`*^9, 
  3.411910388077118*^9}}],

Cell[BoxData["LFermions"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910379677638*^9, 3.4119103807255*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}}],

Cell["\<\
The part of the lagrangian representing the Yukawa sector can be accessed via\
\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.411910399061659*^9, 
  3.411910400421185*^9}}],

Cell[BoxData["LYukawa"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.4119104032372026`*^9, 3.411910404165523*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ghost sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}, {3.4119106057673063`*^9, 
  3.411910606397141*^9}}],

Cell["\<\
The part of the lagrangian representing the ghost sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.411910399061659*^9, 
  3.411910400421185*^9}, {3.4119106110136833`*^9, 3.411910611661195*^9}}],

Cell[BoxData["LGhost"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.4119104032372026`*^9, 3.411910404165523*^9}, {3.411910615100849*^9, 
  3.411910615781582*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking the Lagrangian", "Section",
 CellChangeTimes->{{3.4234156496121893`*^9, 3.423415657027569*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input",
 CellChangeTimes->{{3.4234159280429783`*^9, 3.423415934798614*^9}}],

Cell[CellGroupData[{

Cell["Checking hermiticity", "Subsection",
 CellChangeTimes->{{3.4234156831783743`*^9, 3.423415689540821*^9}}],

Cell["The hermiticity of the Lagrangian can be checked via", "Text",
 CellChangeTimes->{{3.423415694323595*^9, 3.423415707867804*^9}}],

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", 
  RowBox[{"LmZp", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.414763473002973*^9, 3.4147634845507174`*^9}, {
  3.535207129471339*^9, 3.5352071300248127`*^9}}],

Cell["\<\
The same command can be applied to the flavor - expanded Lagrangian\
\>", "Text",
 CellChangeTimes->{{3.423415721582508*^9, 3.423415739787958*^9}}],

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", 
  RowBox[{"LmZp", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.414763604111637*^9, 3.4147636044973803`*^9}, {
   3.424080314738064*^9, 3.4240803160202007`*^9}, {3.4240803610787563`*^9, 
   3.424080369363863*^9}, 3.424080528889154*^9, {3.424637906862782*^9, 
   3.42463790717518*^9}, 3.535207134155414*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking the mass spectrum", "Subsection",
 CellChangeTimes->{{3.423415831209465*^9, 3.423415835278742*^9}}],

Cell["\<\
FeynRules can check whether all the values of the masses given in the model \
file ar ein agreement with the masses given in the Lagrangian:\
\>", "Text",
 CellChangeTimes->{{3.423415751305388*^9, 3.423415792594919*^9}}],

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "LmZp", "]"}]], "Input",
 CellChangeTimes->{{3.414736325829801*^9, 3.414736326065997*^9}, 
   3.4147528281460342`*^9, 3.535207135233859*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking the kinetic terms", "Subsection",
 CellChangeTimes->{{3.423415843532096*^9, 3.42341584850035*^9}}],

Cell["\<\
In the same way, FeynRules can check whether all kinetic terms are correctly \
normalized :\
\>", "Text",
 CellChangeTimes->{{3.423415798800013*^9, 3.423415817964087*^9}}],

Cell[BoxData[
 RowBox[{"CheckKineticTermNormalisation", "[", 
  RowBox[{"LmZp", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4147636651636972`*^9, 3.414763667250185*^9}, 
   3.535207137919743*^9}],

Cell["\<\
The same command cen be used at the level of the flavor - expanded Lagrangian \
:\
\>", "Text",
 CellChangeTimes->{{3.423415868906054*^9, 3.4234158864202538`*^9}}],

Cell[BoxData[
 RowBox[{"CheckKineticTermNormalisation", "[", 
  RowBox[{"LmZp", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{3.5352071390908537`*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculation of the Feynman rules", "Section",
 CellChangeTimes->{{3.411910637332127*^9, 3.41191064360071*^9}}],

Cell["\<\
We will calculate now explicitly the Feynman rules for the minimal Zp models \
in Feynman gauge.\
\>", "Text",
 CellChangeTimes->{{3.41191064804084*^9, 3.411910672936666*^9}, {
  3.535207143229074*^9, 3.535207146475482*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input",
 CellChangeTimes->{{3.411910674121689*^9, 3.4119106799564953`*^9}}],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsection",
 CellChangeTimes->{{3.411910690443768*^9, 3.411910692233274*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsGauge", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LGauge", ",", 
     RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.40274690437012*^9, {3.402746954727231*^9, 3.4027469691642714`*^9}, {
   3.4032592998045692`*^9, 3.403259304564069*^9}, 3.403267976055098*^9, {
   3.411910705212987*^9, 3.411910705553741*^9}, {3.423415993272615*^9, 
   3.42341600147605*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Higgs Sector", "Subsection",
 CellChangeTimes->{3.404470070069872*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsHiggs", "=", 
   RowBox[{"FeynmanRules", "[", "LHiggs", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.411910728609757*^9, 3.41191072908109*^9}, {
   3.423416009086747*^9, 3.423416012982971*^9}, 3.423416065626593*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matter sector", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsFermions", "=", 
   RowBox[{"FeynmanRules", "[", "LFermions", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.402205118991502*^9, 3.4022051228508387`*^9}, 
   3.402747846432675*^9, {3.4032613449872217`*^9, 3.403261349245253*^9}, {
   3.403266977133403*^9, 3.4032669793125563`*^9}, {3.411910788644576*^9, 
   3.411910789233307*^9}, {3.423416034294303*^9, 3.423416042739814*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsYukawa", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LYukawa", ",", 
     RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.403266987858165*^9, 3.4032670026080303`*^9}, {
  3.411910826105542*^9, 3.411910826777452*^9}, {3.423416089772278*^9, 
  3.423416095643961*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["LGhost sector", "Subsection",
 CellChangeTimes->{{3.411910849714159*^9, 3.411910851088325*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsGhosts", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LGhost", ",", 
     RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.403266987858165*^9, 3.4032670026080303`*^9}, {
   3.411910826105542*^9, 3.411910826777452*^9}, {3.411910857580064*^9, 
   3.411910870001601*^9}, 3.415256462464088*^9, {3.423416107236608*^9, 
   3.423416112835993*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outputs and interfaces", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}}],

Cell[CellGroupData[{

Cell["TeX output", "Subsection",
 CellChangeTimes->{{3.411910947430851*^9, 3.411910949151555*^9}}],

Cell["\<\
The TeX output for the minimal Zp models can be obtained via\
\>", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, 
   3.535207193312626*^9}],

Cell[BoxData[
 RowBox[{"WriteTeXOutput", "[", 
  RowBox[{"LmZp", ",", "vertsGhosts", ",", 
   RowBox[{"Output", "\[Rule]", "\"\<minimal_Zp.tex\>\""}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.411910975128832*^9, 3.411910989032667*^9}, {
  3.413715190013906*^9, 3.413715219763245*^9}, {3.4143155989473963`*^9, 
  3.414315622297143*^9}, {3.4234161283912163`*^9, 3.423416165214814*^9}, {
  3.424434998765719*^9, 3.42443500440279*^9}, {3.516624726513577*^9, 
  3.51662472715726*^9}, {3.535207156290826*^9, 3.535207172169827*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["FeynArts output", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}}],

Cell["\<\
The FeynArts output for the minimal Zp models can be obtained via\
\>", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
   3.411911062212926*^9, 3.4119110634765463`*^9}, 3.5352071951804237`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", " ", "=", " ", "False"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{"LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.411911018354619*^9, 3.4119110196967573`*^9}, {
   3.412185470680571*^9, 3.412185480912915*^9}, {3.41245048911446*^9, 
   3.4124504892674522`*^9}, 3.414315634453483*^9, {3.423416180751266*^9, 
   3.423416182892613*^9}}],

Cell["FeynArts also supports the Feynman gauge", "Text",
 CellChangeTimes->{{3.4121854851672792`*^9, 3.412185494183435*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", " ", "=", " ", "True"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{
  "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", "LGhost", 
   ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}], ",", 
   RowBox[{"Output", "\[Rule]", "\"\<minimal_Zp.mod\>\""}]}], "]"}]}], "Input",\

 CellChangeTimes->{{3.411911018354619*^9, 3.4119110196967573`*^9}, {
   3.412185470680571*^9, 3.412185506240796*^9}, {3.4234161971513453`*^9, 
   3.423416209716672*^9}, {3.424637927237001*^9, 3.424637928707159*^9}, {
   3.516624730853075*^9, 3.51662473152958*^9}, 3.5352071770102587`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sherpa output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}}],

Cell["\<\
The Sherpa output for the minimal Zp models can be obtained via\
\>", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
   3.411911059590749*^9, 3.4119110601885567`*^9}, 3.5352071971947308`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "False"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"WriteSHOutput", "[", 
  RowBox[{"LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
  3.412185455856553*^9, 3.412185456628922*^9}, {3.4143156544792233`*^9, 
  3.414315668290971*^9}, {3.423416222700699*^9, 3.423416235756197*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MadGraph output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911131666554*^9, 3.411911135984398*^9}}],

Cell["\<\
The MadGraph output for the minimal Zp models can be obtained via\
\>", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
   3.411911059590749*^9, 3.4119110601885567`*^9}, {3.41191113897644*^9, 
   3.411911142024486*^9}, 3.535207198526808*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "False"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteMGOutput", "[", 
   RowBox[{"LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa"}], "]"}],
   ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
  3.412185409690489*^9, 3.4121854352800217`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["CalcHep output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911150323291*^9, 3.4119111515122623`*^9}}],

Cell["\<\
The CalcHep output for the minimal Zp models can be obtained via\
\>", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
   3.411911059590749*^9, 3.4119110601885567`*^9}, {3.4119111540967712`*^9, 
   3.411911155096376*^9}, 3.535207200675213*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "False"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteCHOutput", "[", 
   RowBox[{"LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", 
    RowBox[{"MaxExpressionLength", "\[Rule]", "120"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
   3.412185398898693*^9, 3.412185419919883*^9}, {3.414315699020526*^9, 
   3.41431570701153*^9}, 3.414315777726746*^9, {3.414316480328691*^9, 
   3.414316491307609*^9}, {3.4143165302100153`*^9, 3.414316531719597*^9}, 
   3.423416262588552*^9, {3.4244350982608624`*^9, 3.424435102519063*^9}}],

Cell["CalcHep also supports the Feynman gauge", "Text",
 CellChangeTimes->{{3.4121853722243843`*^9, 3.412185380407339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "True"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteCHOutput", "[", 
   RowBox[{
   "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", "LGhost", 
    ",", 
    RowBox[{"MaxExpressionLength", "\[Rule]", "286"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
  3.412185409690489*^9, 3.4121854275198507`*^9}, {3.412450479942018*^9, 
  3.4124504817138367`*^9}, {3.424435099210684*^9, 3.4244351046994867`*^9}, {
  3.516688741605616*^9, 3.516688744089039*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Whizard output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
   3.411911150323291*^9, 3.4119111515122623`*^9}, 3.535207336383799*^9}],

Cell["\<\
Whizard also supports the Feynman gauge\
\>", "Text",
 CellChangeTimes->{{3.4121853722243843`*^9, 3.412185380407339*^9}, 
   3.535207325241043*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "True"}], ";"}], 
  "\[IndentingNewLine]"}], "\n", 
 RowBox[{
  RowBox[{"WriteWOOutput", "[", 
   RowBox[{
   "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", "LGhost"}],
    "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.535207272402688*^9, 3.53520727240837*^9}, {
   3.535207340343623*^9, 3.535207341465938*^9}, 3.535207400929963*^9, {
   3.5352074441830883`*^9, 3.5352074487603607`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["UFO output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
   3.411911150323291*^9, 3.4119111515122623`*^9}, 3.535207336383799*^9, {
   3.535207372887471*^9, 3.5352073732258587`*^9}}],

Cell["\<\
The UFO output (for MadGraph5) for the minimal Zp models can be obtained via\
\>", "Text",
 CellChangeTimes->{{3.4121853722243843`*^9, 3.412185380407339*^9}, 
   3.535207325241043*^9, {3.535207358303567*^9, 3.53520739082025*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "False"}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{
   "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", "LGhost"}],
    "]"}], ";"}]}], "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1010, 806},
WindowMargins->{{0, Automatic}, {194, -24}},
ShowSelection->True,
Magnification->1.5,
FrontEndVersion->"8.0 for Linux x86 (64-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 708, 10, 43, "Input"],
Cell[CellGroupData[{
Cell[1278, 34, 144, 4, 43, "Input"],
Cell[1425, 40, 117, 1, 43, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[1579, 46, 54, 1, 43, "Input"],
Cell[1636, 49, 462, 10, 33, "Message"],
Cell[2101, 61, 102, 1, 43, "Output"]
}, Open  ]],
Cell[2218, 65, 365, 7, 43, "Input"],
Cell[CellGroupData[{
Cell[2608, 76, 203, 3, 130, "Title"],
Cell[2814, 81, 191, 4, 43, "Text"],
Cell[3008, 87, 1142, 16, 43, "Input"],
Cell[CellGroupData[{
Cell[4175, 107, 152, 2, 110, "Section"],
Cell[CellGroupData[{
Cell[4352, 113, 100, 1, 57, "Subsection"],
Cell[4455, 116, 257, 5, 42, "Text"],
Cell[4715, 123, 144, 2, 43, "Input"],
Cell[CellGroupData[{
Cell[4884, 129, 105, 1, 40, "Subsubsection"],
Cell[4992, 132, 219, 4, 42, "Text"],
Cell[5214, 138, 98, 1, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5349, 144, 154, 2, 40, "Subsubsection"],
Cell[5506, 148, 270, 6, 42, "Text"],
Cell[5779, 156, 147, 2, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5963, 163, 158, 2, 40, "Subsubsection"],
Cell[6124, 167, 272, 5, 42, "Text"],
Cell[6399, 174, 148, 2, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6584, 181, 155, 2, 40, "Subsubsection"],
Cell[6742, 185, 271, 6, 42, "Text"],
Cell[7016, 193, 150, 2, 64, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7215, 201, 148, 2, 85, "Subsection"],
Cell[7366, 205, 195, 4, 102, "Text"],
Cell[7564, 211, 149, 3, 64, "Input"],
Cell[7716, 216, 303, 5, 63, "Text"],
Cell[8022, 223, 145, 2, 64, "Input"],
Cell[CellGroupData[{
Cell[8192, 229, 105, 1, 60, "Subsubsection"],
Cell[8300, 232, 219, 4, 63, "Text"],
Cell[8522, 238, 98, 1, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8657, 244, 154, 2, 60, "Subsubsection"],
Cell[8814, 248, 270, 6, 63, "Text"],
Cell[9087, 256, 147, 2, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9271, 263, 158, 2, 60, "Subsubsection"],
Cell[9432, 267, 272, 5, 63, "Text"],
Cell[9707, 274, 148, 2, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9892, 281, 155, 2, 60, "Subsubsection"],
Cell[10050, 285, 271, 6, 63, "Text"],
Cell[10324, 293, 150, 2, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10511, 300, 205, 3, 60, "Subsubsection"],
Cell[10719, 305, 316, 5, 63, "Text"],
Cell[11038, 312, 198, 3, 64, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11297, 322, 110, 1, 165, "Section"],
Cell[11410, 325, 149, 3, 64, "Input"],
Cell[CellGroupData[{
Cell[11584, 332, 110, 1, 85, "Subsection"],
Cell[11697, 335, 134, 1, 63, "Text"],
Cell[11834, 338, 258, 5, 64, "Input"],
Cell[12095, 345, 157, 3, 63, "Text"],
Cell[12255, 350, 404, 7, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12696, 362, 114, 1, 85, "Subsection"],
Cell[12813, 365, 230, 4, 102, "Text"],
Cell[13046, 371, 189, 3, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13272, 379, 113, 1, 85, "Subsection"],
Cell[13388, 382, 181, 4, 63, "Text"],
Cell[13572, 388, 246, 5, 64, "Input"],
Cell[13821, 395, 173, 4, 63, "Text"],
Cell[13997, 401, 196, 4, 64, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14242, 411, 116, 1, 165, "Section"],
Cell[14361, 414, 234, 5, 64, "Text"],
Cell[14598, 421, 149, 3, 64, "Input"],
Cell[CellGroupData[{
Cell[14772, 428, 100, 1, 85, "Subsection"],
Cell[14875, 431, 457, 10, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15369, 446, 76, 1, 85, "Subsection"],
Cell[15448, 449, 258, 5, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15743, 459, 35, 0, 85, "Subsection"],
Cell[15781, 461, 417, 7, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16235, 473, 35, 0, 85, "Subsection"],
Cell[16273, 475, 360, 8, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[16670, 488, 101, 1, 85, "Subsection"],
Cell[16774, 491, 433, 9, 64, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[17256, 506, 132, 2, 165, "Section"],
Cell[CellGroupData[{
Cell[17413, 512, 98, 1, 85, "Subsection"],
Cell[17514, 515, 178, 4, 64, "Text"],
Cell[17695, 521, 527, 9, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18259, 535, 103, 1, 85, "Subsection"],
Cell[18365, 538, 233, 4, 64, "Text"],
Cell[18601, 544, 569, 11, 187, "Input"],
Cell[19173, 557, 124, 1, 63, "Text"],
Cell[19300, 560, 706, 15, 187, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20043, 580, 103, 1, 85, "Subsection"],
Cell[20149, 583, 231, 4, 64, "Text"],
Cell[20383, 589, 474, 10, 147, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20894, 604, 154, 2, 85, "Subsection"],
Cell[21051, 608, 280, 5, 64, "Text"],
Cell[21334, 615, 398, 10, 147, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21769, 630, 155, 2, 85, "Subsection"],
Cell[21927, 634, 282, 5, 64, "Text"],
Cell[22212, 641, 701, 14, 187, "Input"],
Cell[22916, 657, 123, 1, 63, "Text"],
Cell[23042, 660, 630, 15, 187, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23709, 680, 178, 2, 85, "Subsection"],
Cell[23890, 684, 157, 4, 64, "Text"],
Cell[24050, 690, 473, 12, 147, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[24560, 707, 226, 3, 85, "Subsection"],
Cell[24789, 712, 239, 4, 64, "Text"],
Cell[25031, 718, 278, 9, 147, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
