(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     29228,        867]
NotebookOptionsPosition[     24074,        694]
NotebookOutlinePosition[     24452,        711]
CellTagsIndexPosition[     24409,        708]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
  3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
  3.4234163227881193`*^9}, {3.424068937202279*^9, 3.424068972595354*^9}, {
  3.441972201424767*^9, 3.441972204100518*^9}, {3.441974075463511*^9, 
  3.441974075807181*^9}, {3.44275751802024*^9, 3.442757518156605*^9}, {
  3.4543250469973173`*^9, 3.4543250494197693`*^9}, {3.528797117128602*^9, 
  3.52879711983528*^9}, {3.5352057748794737`*^9, 3.53520577577702*^9}, {
  3.535207608385954*^9, 3.5352076091277018`*^9}}],

Cell[BoxData[
 RowBox[{"$FeynRulesPath", "=", 
  RowBox[{
  "SetDirectory", "[", "\"\<~/mathematica/FeynRules_1.6.0\>\"", 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/B-L\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.419073170860696*^9, 3.419073182827229*^9}, {
  3.424068987980844*^9, 3.4240689893965273`*^9}}],

Cell[CellGroupData[{

Cell["The B-L extension of the Standard Model", "Title",
 CellChangeTimes->{{3.424069004105296*^9, 3.424069007850328*^9}}],

Cell["We first load in the B-L Model model-file", "Text",
 CellChangeTimes->{{3.424069016807353*^9, 3.4240690172628117`*^9}}],

Cell[BoxData[
 RowBox[{"LoadModel", "[", "\"\<B-L.fr\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.4022069973481913`*^9, 3.402207011768662*^9}, 
   3.4022081212072697`*^9, {3.402208250379383*^9, 3.402208254043104*^9}, 
   3.4027466057480917`*^9, {3.403240270135737*^9, 3.403240277228945*^9}, 
   3.403266503388291*^9, {3.403267649630335*^9, 3.40326765417397*^9}, {
   3.403269919787421*^9, 3.403269921965273*^9}, {3.403347551273425*^9, 
   3.403347555049163*^9}, 3.4044490490588417`*^9, {3.411744339876704*^9, 
   3.411744340012457*^9}, {3.4121886924550533`*^9, 3.412188699157571*^9}, 
   3.412188808811866*^9, 3.4121888580521603`*^9, {3.412450464077868*^9, 
   3.412450464378695*^9}, {3.413715097460478*^9, 3.41371509757642*^9}, {
   3.41440825334604*^9, 3.414408254159686*^9}, {3.41862573831756*^9, 
   3.4186257392223186`*^9}, {3.4190731862389174`*^9, 3.419073187003003*^9}, {
   3.419073336802393*^9, 3.4190733374513063`*^9}, {3.4190828041801767`*^9, 
   3.4190828048079023`*^9}, {3.4240690195427647`*^9, 3.424069028019803*^9}}],

Cell[CellGroupData[{

Cell["The B-L lagrangian", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
  3.424069513901162*^9, 3.424069514344799*^9}}],

Cell[CellGroupData[{

Cell["Unitary Gauge", "Subsection",
 CellChangeTimes->{{3.411910080775518*^9, 3.41191008414785*^9}}],

Cell["\<\
The full lagrangian in unitary gauge can be accessed immediatly via\
\>", "Text",
 CellChangeTimes->{{3.411910016771447*^9, 3.411910062087528*^9}, {
  3.411910094087652*^9, 3.411910096590087*^9}, {3.411910215381351*^9, 
  3.4119102162371798`*^9}}],

Cell[BoxData["LBL"], "Input",
 CellChangeTimes->{{3.411910106011015*^9, 3.411910106351081*^9}, {
  3.535205784209942*^9, 3.535205784276331*^9}}],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}}],

Cell["\<\
The part of the lagrangian representing the gauge sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}}],

Cell[BoxData["LGauge"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910274288354*^9, 3.41191027703699*^9}}],

Cell["\<\
The part of the lagrangian representing the scalar sector can be accessed via\
\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.41191028690167*^9, 
  3.411910287709094*^9}}],

Cell[BoxData["LHiggs"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910290186841*^9, 3.411910292005392*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fermion sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.4119103528868923`*^9, 3.411910357404933*^9}}],

Cell["\<\
The part of the lagrangian representing the fermion sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.4119103873434134`*^9, 
  3.411910388077118*^9}}],

Cell[BoxData["LFermions"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910379677638*^9, 3.4119103807255*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}}],

Cell["\<\
The part of the lagrangian representing the Yukawa sector can be accessed via\
\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.411910399061659*^9, 
  3.411910400421185*^9}}],

Cell[BoxData["LYukawa"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.4119104032372026`*^9, 3.411910404165523*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Feynman Gauge", "Subsection",
 CellChangeTimes->{{3.411910080775518*^9, 3.41191008414785*^9}, {
  3.411910431304595*^9, 3.41191043361451*^9}}],

Cell["\<\
By default, SM lagrangian is loaded in unitary gauge. However, Feynman gauge \
can be obtained by putting\
\>", "Text",
 CellChangeTimes->{{3.411910440565042*^9, 3.411910480762147*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input",
 CellChangeTimes->{{3.411910487433539*^9, 3.4119104927114267`*^9}}],

Cell["\<\
The full lagrangian in Feynman gauge can be accessed immediatly via\
\>", "Text",
 CellChangeTimes->{{3.411910016771447*^9, 3.411910062087528*^9}, {
  3.411910094087652*^9, 3.411910096590087*^9}, {3.411910215381351*^9, 
  3.4119102162371798`*^9}, {3.411910436148773*^9, 3.411910437013105*^9}}],

Cell[BoxData["LBL"], "Input",
 CellChangeTimes->{{3.411910106011015*^9, 3.411910106351081*^9}, {
  3.5352057896067543`*^9, 3.5352057896886463`*^9}}],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}}],

Cell["\<\
The part of the lagrangian representing the gauge sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}}],

Cell[BoxData["LGauge"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910274288354*^9, 3.41191027703699*^9}}],

Cell["\<\
The part of the lagrangian representing the scalar sector can be accessed via\
\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.41191028690167*^9, 
  3.411910287709094*^9}}],

Cell[BoxData["LHiggs"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910290186841*^9, 3.411910292005392*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fermion sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.4119103528868923`*^9, 3.411910357404933*^9}}],

Cell["\<\
The part of the lagrangian representing the fermion sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.4119103873434134`*^9, 
  3.411910388077118*^9}}],

Cell[BoxData["LFermions"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910379677638*^9, 3.4119103807255*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}}],

Cell["\<\
The part of the lagrangian representing the Yukawa sector can be accessed via\
\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.411910399061659*^9, 
  3.411910400421185*^9}}],

Cell[BoxData["LYukawa"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.4119104032372026`*^9, 3.411910404165523*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Ghost sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}, {3.4119106057673063`*^9, 
  3.411910606397141*^9}}],

Cell["\<\
The part of the lagrangian representing the ghost sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.411910399061659*^9, 
  3.411910400421185*^9}, {3.4119106110136833`*^9, 3.411910611661195*^9}}],

Cell[BoxData["LGhost"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.4119104032372026`*^9, 3.411910404165523*^9}, {3.411910615100849*^9, 
  3.411910615781582*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking the Lagrangian", "Section",
 CellChangeTimes->{{3.4234156496121893`*^9, 3.423415657027569*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input",
 CellChangeTimes->{{3.4234159280429783`*^9, 3.423415934798614*^9}}],

Cell[CellGroupData[{

Cell["Checking hermiticity", "Subsection",
 CellChangeTimes->{{3.4234156831783743`*^9, 3.423415689540821*^9}}],

Cell["The hermiticity of the Lagrangian can be checked via", "Text",
 CellChangeTimes->{{3.423415694323595*^9, 3.423415707867804*^9}}],

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", 
  RowBox[{"LBL", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.414763473002973*^9, 3.4147634845507174`*^9}, {
  3.535205795048677*^9, 3.535205795142927*^9}}],

Cell["\<\
The same command can be applied to the flavor - expanded Lagrangian\
\>", "Text",
 CellChangeTimes->{{3.423415721582508*^9, 3.423415739787958*^9}}],

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", 
  RowBox[{"LBL", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.414763604111637*^9, 3.4147636044973803`*^9}, {
   3.424080314738064*^9, 3.4240803160202007`*^9}, {3.4240803610787563`*^9, 
   3.424080369363863*^9}, 3.424080528889154*^9, {3.424637906862782*^9, 
   3.42463790717518*^9}, {3.535205797882455*^9, 3.5352057979381227`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking the mass spectrum", "Subsection",
 CellChangeTimes->{{3.423415831209465*^9, 3.423415835278742*^9}}],

Cell["\<\
FeynRules can check whether all the values of the masses given in the model \
file ar ein agreement with the masses given in the Lagrangian:\
\>", "Text",
 CellChangeTimes->{{3.423415751305388*^9, 3.423415792594919*^9}}],

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", "LBL", "]"}]], "Input",
 CellChangeTimes->{{3.414736325829801*^9, 3.414736326065997*^9}, 
   3.4147528281460342`*^9, {3.535205800580488*^9, 3.5352058006644983`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking the kinetic terms", "Subsection",
 CellChangeTimes->{{3.423415843532096*^9, 3.42341584850035*^9}}],

Cell["\<\
In the same way, FeynRules can check whether all kinetic terms are correctly \
normalized :\
\>", "Text",
 CellChangeTimes->{{3.423415798800013*^9, 3.423415817964087*^9}}],

Cell[BoxData[
 RowBox[{"CheckKineticTermNormalisation", "[", 
  RowBox[{"LBL", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.4147636651636972`*^9, 3.414763667250185*^9}, {
  3.5352058047093573`*^9, 3.535205804765349*^9}}],

Cell["\<\
The same command cen be used at the level of the flavor - expanded Lagrangian \
:\
\>", "Text",
 CellChangeTimes->{{3.423415868906054*^9, 3.4234158864202538`*^9}}],

Cell[BoxData[
 RowBox[{"CheckKineticTermNormalisation", "[", 
  RowBox[{"LBL", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5352058076649523`*^9, 3.535205807812533*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculation of the Feynman rules", "Section",
 CellChangeTimes->{{3.411910637332127*^9, 3.41191064360071*^9}}],

Cell["\<\
We will calculate now explicitly the Feynman rules for the SM in Feynman \
gauge.\
\>", "Text",
 CellChangeTimes->{{3.41191064804084*^9, 3.411910672936666*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input",
 CellChangeTimes->{{3.411910674121689*^9, 3.4119106799564953`*^9}}],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsection",
 CellChangeTimes->{{3.411910690443768*^9, 3.411910692233274*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsGauge", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LGauge", ",", 
     RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.40274690437012*^9, {3.402746954727231*^9, 3.4027469691642714`*^9}, {
   3.4032592998045692`*^9, 3.403259304564069*^9}, 3.403267976055098*^9, {
   3.411910705212987*^9, 3.411910705553741*^9}, {3.423415993272615*^9, 
   3.42341600147605*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Higgs Sector", "Subsection",
 CellChangeTimes->{3.404470070069872*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsHiggs", "=", 
   RowBox[{"FeynmanRules", "[", "LHiggs", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.411910728609757*^9, 3.41191072908109*^9}, {
   3.423416009086747*^9, 3.423416012982971*^9}, 3.423416065626593*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matter sector", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsFermions", "=", 
   RowBox[{"FeynmanRules", "[", "LFermions", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.402205118991502*^9, 3.4022051228508387`*^9}, 
   3.402747846432675*^9, {3.4032613449872217`*^9, 3.403261349245253*^9}, {
   3.403266977133403*^9, 3.4032669793125563`*^9}, {3.411910788644576*^9, 
   3.411910789233307*^9}, {3.423416034294303*^9, 3.423416042739814*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsYukawa", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LYukawa", ",", 
     RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.403266987858165*^9, 3.4032670026080303`*^9}, {
  3.411910826105542*^9, 3.411910826777452*^9}, {3.423416089772278*^9, 
  3.423416095643961*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["LGhost sector", "Subsection",
 CellChangeTimes->{{3.411910849714159*^9, 3.411910851088325*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsGhosts", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LGhost", ",", 
     RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.403266987858165*^9, 3.4032670026080303`*^9}, {
   3.411910826105542*^9, 3.411910826777452*^9}, {3.411910857580064*^9, 
   3.411910870001601*^9}, 3.415256462464088*^9, {3.423416107236608*^9, 
   3.423416112835993*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outputs and interfaces", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}}],

Cell[CellGroupData[{

Cell["TeX output", "Subsection",
 CellChangeTimes->{{3.411910947430851*^9, 3.411910949151555*^9}}],

Cell["\<\
The TeX output for the pure B-L model can be obtained via\
\>", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, 
   3.535205890778984*^9}],

Cell[BoxData[
 RowBox[{"WriteTeXOutput", "[", 
  RowBox[{"LBL", ",", "vertsGhosts", ",", 
   RowBox[{"Output", "\[Rule]", "\"\<B-L.tex\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.411910975128832*^9, 3.411910989032667*^9}, {
  3.413715190013906*^9, 3.413715219763245*^9}, {3.4143155989473963`*^9, 
  3.414315622297143*^9}, {3.4234161283912163`*^9, 3.423416165214814*^9}, {
  3.424434998765719*^9, 3.42443500440279*^9}, {3.535205816001309*^9, 
  3.5352058160497837`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["FeynArts output", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}}],

Cell["\<\
The FeynArts output for the pure B-L model can be obtained via\
\>", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
   3.411911062212926*^9, 3.4119110634765463`*^9}, 3.5352058849351053`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", " ", "=", " ", "False"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{"LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.411911018354619*^9, 3.4119110196967573`*^9}, {
   3.412185470680571*^9, 3.412185480912915*^9}, {3.41245048911446*^9, 
   3.4124504892674522`*^9}, 3.414315634453483*^9, {3.423416180751266*^9, 
   3.423416182892613*^9}}],

Cell["FeynArts also supports the Feynman gauge", "Text",
 CellChangeTimes->{{3.4121854851672792`*^9, 3.412185494183435*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", " ", "=", " ", "True"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{
  "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", "LGhost", 
   ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}], ",", 
   RowBox[{"Output", "\[Rule]", "\"\<B-L.mod\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.411911018354619*^9, 3.4119110196967573`*^9}, {
  3.412185470680571*^9, 3.412185506240796*^9}, {3.4234161971513453`*^9, 
  3.423416209716672*^9}, {3.424637927237001*^9, 3.424637928707159*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sherpa output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}}],

Cell["\<\
The Sherpa output for the pure B-L model can be obtained via\
\>", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911059590749*^9, 3.4119110601885567`*^9}, {3.5352058750540133`*^9, 
  3.5352058773981543`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "False"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{"WriteSHOutput", "[", 
  RowBox[{"LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa"}], 
  "]"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
  3.412185455856553*^9, 3.412185456628922*^9}, {3.4143156544792233`*^9, 
  3.414315668290971*^9}, {3.423416222700699*^9, 3.423416235756197*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MadGraph output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911131666554*^9, 3.411911135984398*^9}}],

Cell["\<\
The MadGraph output for the pure B-L model can be obtained via\
\>", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911059590749*^9, 3.4119110601885567`*^9}, {3.41191113897644*^9, 
  3.411911142024486*^9}, {3.5352058731583033`*^9, 3.5352058786065807`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "False"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteMGOutput", "[", 
   RowBox[{"LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa"}], "]"}],
   ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
  3.412185409690489*^9, 3.4121854352800217`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["CalcHep output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911150323291*^9, 3.4119111515122623`*^9}}],

Cell["\<\
The CalcHep output for the pure B-L model can be obtained via\
\>", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911059590749*^9, 3.4119110601885567`*^9}, {3.4119111540967712`*^9, 
  3.411911155096376*^9}, {3.535205860814587*^9, 3.535205867141062*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "False"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteCHOutput", "[", 
   RowBox[{"LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", 
    RowBox[{"MaxExpressionLength", "\[Rule]", "120"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
   3.412185398898693*^9, 3.412185419919883*^9}, {3.414315699020526*^9, 
   3.41431570701153*^9}, 3.414315777726746*^9, {3.414316480328691*^9, 
   3.414316491307609*^9}, {3.4143165302100153`*^9, 3.414316531719597*^9}, 
   3.423416262588552*^9, {3.4244350982608624`*^9, 3.424435102519063*^9}}],

Cell["CalcHep also supports the Feynman gauge", "Text",
 CellChangeTimes->{{3.4121853722243843`*^9, 3.412185380407339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "True"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteCHOutput", "[", 
   RowBox[{
   "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", "LGhost", 
    ",", 
    RowBox[{"MaxExpressionLength", "\[Rule]", "120"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
  3.412185409690489*^9, 3.4121854275198507`*^9}, {3.412450479942018*^9, 
  3.4124504817138367`*^9}, {3.424435099210684*^9, 3.4244351046994867`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Whizard output", "Subsection",
 CellChangeTimes->{{3.528797132808325*^9, 3.528797132820179*^9}, {
  3.52879722803909*^9, 3.5287972323663054`*^9}}],

Cell["Whizard also supports the Feynman gauge", "Text",
 CellChangeTimes->{{3.528797137943204*^9, 3.528797137944153*^9}, {
  3.528797240132764*^9, 3.528797243603442*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "True"}], ";"}], 
  "\n"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteWOOutput", "[", 
   RowBox[{
   "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", "LGhost"}],
    "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.528797146761663*^9, 3.528797146762849*^9}, {
  3.528797210028261*^9, 3.528797211739274*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["UFO output", "Subsection",
 CellChangeTimes->{{3.528797217186555*^9, 3.528797236293277*^9}}],

Cell["\<\
The UFO output (for MadGraph5) for the pure B-L model can be obtained via\
\>", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911059590749*^9, 3.4119110601885567`*^9}, {3.4119111540967712`*^9, 
  3.411911155096376*^9}, {3.535205860814587*^9, 3.535205867141062*^9}, {
  3.535205914201091*^9, 3.5352059214019833`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "False"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteUFO", "[", 
   RowBox[{
   "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", "LGhost"}],
    "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.528797221130815*^9, 3.528797221131584*^9}, {
  3.535205850686822*^9, 3.535205854235278*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1144, 806},
WindowMargins->{{-5, Automatic}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.5,
FrontEndVersion->"8.0 for Linux x86 (64-bit) (February 23, 2011)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 607, 9, 43, "Input"],
Cell[1155, 31, 144, 4, 43, "Input"],
Cell[1302, 37, 54, 1, 43, "Input"],
Cell[1359, 40, 259, 6, 43, "Input"],
Cell[CellGroupData[{
Cell[1643, 50, 122, 1, 130, "Title"],
Cell[1768, 53, 125, 1, 42, "Text"],
Cell[1896, 56, 1031, 14, 43, "Input"],
Cell[CellGroupData[{
Cell[2952, 74, 152, 2, 110, "Section"],
Cell[CellGroupData[{
Cell[3129, 80, 100, 1, 57, "Subsection"],
Cell[3232, 83, 257, 5, 42, "Text"],
Cell[3492, 90, 144, 2, 43, "Input"],
Cell[CellGroupData[{
Cell[3661, 96, 105, 1, 40, "Subsubsection"],
Cell[3769, 99, 219, 4, 42, "Text"],
Cell[3991, 105, 98, 1, 43, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4126, 111, 154, 2, 40, "Subsubsection"],
Cell[4283, 115, 270, 6, 42, "Text"],
Cell[4556, 123, 147, 2, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4740, 130, 158, 2, 60, "Subsubsection"],
Cell[4901, 134, 272, 5, 63, "Text"],
Cell[5176, 141, 148, 2, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5361, 148, 155, 2, 60, "Subsubsection"],
Cell[5519, 152, 271, 6, 63, "Text"],
Cell[5793, 160, 150, 2, 64, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5992, 168, 148, 2, 85, "Subsection"],
Cell[6143, 172, 195, 4, 63, "Text"],
Cell[6341, 178, 149, 3, 64, "Input"],
Cell[6493, 183, 303, 5, 63, "Text"],
Cell[6799, 190, 148, 2, 64, "Input"],
Cell[CellGroupData[{
Cell[6972, 196, 105, 1, 60, "Subsubsection"],
Cell[7080, 199, 219, 4, 63, "Text"],
Cell[7302, 205, 98, 1, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[7437, 211, 154, 2, 60, "Subsubsection"],
Cell[7594, 215, 270, 6, 63, "Text"],
Cell[7867, 223, 147, 2, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8051, 230, 158, 2, 60, "Subsubsection"],
Cell[8212, 234, 272, 5, 63, "Text"],
Cell[8487, 241, 148, 2, 96, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[8672, 248, 155, 2, 90, "Subsubsection"],
Cell[8830, 252, 271, 6, 94, "Text"],
Cell[9104, 260, 150, 2, 96, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9291, 267, 205, 3, 90, "Subsubsection"],
Cell[9499, 272, 316, 5, 94, "Text"],
Cell[9818, 279, 198, 3, 96, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10077, 289, 110, 1, 247, "Section"],
Cell[10190, 292, 149, 3, 96, "Input"],
Cell[CellGroupData[{
Cell[10364, 299, 110, 1, 127, "Subsection"],
Cell[10477, 302, 134, 1, 94, "Text"],
Cell[10614, 305, 255, 5, 96, "Input"],
Cell[10872, 312, 157, 3, 63, "Text"],
Cell[11032, 317, 429, 7, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11498, 329, 114, 1, 85, "Subsection"],
Cell[11615, 332, 230, 4, 102, "Text"],
Cell[11848, 338, 214, 3, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12099, 346, 113, 1, 85, "Subsection"],
Cell[12215, 349, 181, 4, 63, "Text"],
Cell[12399, 355, 270, 5, 64, "Input"],
Cell[12672, 362, 173, 4, 63, "Text"],
Cell[12848, 368, 219, 4, 64, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[13116, 378, 116, 1, 165, "Section"],
Cell[13235, 381, 170, 4, 63, "Text"],
Cell[13408, 387, 149, 3, 64, "Input"],
Cell[CellGroupData[{
Cell[13582, 394, 100, 1, 85, "Subsection"],
Cell[13685, 397, 457, 10, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14179, 412, 76, 1, 85, "Subsection"],
Cell[14258, 415, 258, 5, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14553, 425, 35, 0, 85, "Subsection"],
Cell[14591, 427, 417, 7, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15045, 439, 35, 0, 85, "Subsection"],
Cell[15083, 441, 360, 8, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15480, 454, 101, 1, 85, "Subsection"],
Cell[15584, 457, 433, 9, 64, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[16066, 472, 132, 2, 165, "Section"],
Cell[CellGroupData[{
Cell[16223, 478, 98, 1, 85, "Subsection"],
Cell[16324, 481, 175, 4, 63, "Text"],
Cell[16502, 487, 474, 8, 64, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[17013, 500, 103, 1, 85, "Subsection"],
Cell[17119, 503, 230, 4, 63, "Text"],
Cell[17352, 509, 569, 11, 147, "Input"],
Cell[17924, 522, 124, 1, 63, "Text"],
Cell[18051, 525, 622, 13, 187, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18710, 543, 103, 1, 85, "Subsection"],
Cell[18816, 546, 256, 5, 63, "Text"],
Cell[19075, 553, 474, 10, 147, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[19586, 568, 154, 2, 85, "Subsection"],
Cell[19743, 572, 303, 5, 63, "Text"],
Cell[20049, 579, 398, 10, 147, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[20484, 594, 155, 2, 85, "Subsection"],
Cell[20642, 598, 301, 5, 63, "Text"],
Cell[20946, 605, 701, 14, 147, "Input"],
Cell[21650, 621, 123, 1, 63, "Text"],
Cell[21776, 624, 581, 14, 147, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[22394, 643, 152, 2, 85, "Subsection"],
Cell[22549, 647, 170, 2, 63, "Text"],
Cell[22722, 651, 397, 11, 147, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[23156, 667, 98, 1, 85, "Subsection"],
Cell[23257, 670, 364, 6, 63, "Text"],
Cell[23624, 678, 410, 11, 147, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
