(***************************************************************************************************************)
(******                       This is the FeynRules mod-file for the B-L model                       ******)
(******                                                                                                   ******)
(******     Authors: Wei.Liu              ******)
(******                                                                                                   ******)
(****** Choose whether Feynman gauge is desired.                                                          ******)
(****** If set to False, unitary gauge is assumed.                                                          ****)
(****** Feynman gauge is especially useful for CalcHEP/CompHEP where the calculation is 10-100 times faster. ***)
(****** Feynman gauge is not supported in MadGraph and Sherpa.                                              ****)
(***************************************************************************************************************)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "B-L-N-4";

M$Information = {
  Authors      -> {"Wei.Liu"}, 
  Version      -> "4.0.0",
  Date         -> "09. 12. 2019",
  Institutions -> {"University College London"},
  Emails       -> {"wei.liu.16@ucl.ac.uk"},
  URLs         -> "http://feynrules.phys.ucl.ac.be"
};

FeynmanGauge = True;

(* ************************** *)
(* ***** NLO Variables ****** *)
(******************************)

FR$LoopSwitches = {{Gf, MW}};
FR$RmDblExt = { ymb -> MB, ymc -> MC, ymdo -> MD, yme -> Me, 
   ymm -> MMU, yms -> MS, ymt -> MT, ymtau -> MTA, ymup -> MU};
(************B-L***************)


(************End***************)

(* ************************** *)
(* *****  Change  log   ***** *)
(* ************************** *)

(***v1.0,the ordinary version without NLO***)
(***v2.1,change muh1 and muh2 to mu2h1 and mu2h2*****)
(***v3.0,delete VEV blockname, and enter Neutrino mixing as internal parameters******)
(***v4.0,rewrite accroding to my thesis, adding LGhBp, rewrite the LYukawa for the B-L part******)
(* ************************** *)
(* *****      vevs      ***** *)
(* ************************** *)
M$vevs = { {Phi[2],vev} };
(************B-L***************)


(************End***************)

(* ************************** *)
(* *****  Gauge groups  ***** *)
(* ************************** *)
M$GaugeGroups = {
(************B-L***************)
  U1BL == {
    Abelian          -> True,
    CouplingConstant -> g1p,
    GaugeBoson       -> Bp,
    Charge           -> BL
  },
(************End***************)
  U1Y  == { 
    Abelian          -> True,  
    CouplingConstant -> g1, 
    GaugeBoson       -> B, 
    Charge           -> Y
  },
  SU2L == { 
    Abelian           -> False, 
    CouplingConstant  -> gw, 
    GaugeBoson        -> Wi, 
    StructureConstant -> Eps, 
    Representations   -> {Ta,SU2D}, 
    Definitions       -> {Ta[a_,b_,c_]->PauliSigma[a,b,c]/2, FSU2L[i_,j_,k_]:> I Eps[i,j,k]}
  },
  SU3C == { 
    Abelian           -> False, 
    CouplingConstant  -> gs, 
    GaugeBoson        -> G,
    StructureConstant -> f, 
    Representations   -> {T,Colour}, 
    SymmetricTensor   -> dSUN
  } 
};


(* ************************** *)
(* *****    Indices     ***** *)
(* ************************** *)

IndexRange[Index[SU2W      ]] = Unfold[Range[3]]; 
IndexRange[Index[SU2D      ]] = Unfold[Range[2]];
IndexRange[Index[Gluon     ]] = NoUnfold[Range[8]];
IndexRange[Index[Colour    ]] = NoUnfold[Range[3]]; 
IndexRange[Index[Generation]] = Range[3];

IndexStyle[SU2W,       j];
IndexStyle[SU2D,       k];
IndexStyle[Gluon,      a];
IndexStyle[Colour,     m];
IndexStyle[Generation, f];


(* ************************** *)
(* *** Interaction orders *** *)
(* ***  (as used by mg5)  *** *)
(* ************************** *)

M$InteractionOrderHierarchy = {
  {QCD, 1},
  {QED, 2}
};


(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)
M$ClassesDescription = {

(* Gauge bosons: physical vector fields *)
(* Gauge bosons: Q = 0 *)
  V[1] == { 
    ClassName       -> A, 
    SelfConjugate   -> True,  
    Mass            -> 0,  
    Width           -> 0,  
    ParticleName    -> "a", 
    PDG             -> 22, 
    PropagatorLabel -> "a", 
    PropagatorType  -> W, 
    PropagatorArrow -> None,
    FullName        -> "Photon"
  },
  V[2] == { 
    ClassName       -> Z, 
    SelfConjugate   -> True,
    Mass            -> {MZ, 91.1876},
    Width           -> {WZ, 2.4952},
    ParticleName    -> "Z", 
    PDG             -> 23, 
    PropagatorLabel -> "Z",
    PropagatorType  -> Sine,
    PropagatorArrow -> None,
    FullName        -> "Z"
  },
  V[3] == {
    ClassName        -> W,
    SelfConjugate    -> False,
    Mass             -> {MW, Internal},
    Width            -> {WW, 2.085},
    ParticleName     -> "W+",
    AntiParticleName -> "W-",
    QuantumNumbers   -> {Q -> 1},
    PDG              -> 24, 
    PropagatorLabel  -> "W",
    PropagatorType   -> Sine,
    PropagatorArrow  -> Forward,
    FullName         -> "W"
  },
  V[4] == {
    ClassName        -> G,
    SelfConjugate    -> True,
    Indices          -> {Index[Gluon]},
    Mass             -> 0,
    Width            -> 0,
    ParticleName     -> "g", 
    PDG              -> 21,
    PropagatorLabel  -> "G",
    PropagatorType   -> C,
    PropagatorArrow  -> None,
    FullName         -> "G"
  },

(* Ghosts: related to physical gauge bosons *)
  U[1] == { 
    ClassName       -> ghA, 
    SelfConjugate   -> False,
    Ghost           -> A,
    QuantumNumbers  -> {GhostNumber -> 1},
    Mass            -> 0,
    Width	    -> 0,
    PropagatorLabel -> "uA",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[2] == {
    ClassName       -> ghZ,
    SelfConjugate   -> False,
    Ghost           -> Z,
    QuantumNumbers  -> {GhostNumber -> 1},
    Mass            -> {MZ,91.1876},  
    Width	    -> {WZ, 2.4952},
    PropagatorLabel -> "uZ",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[31] == { 
    ClassName       -> ghWp,
    SelfConjugate   -> False, 
    Ghost           -> W,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> 1},
    Mass            -> {MW,Internal}, 
    Width           -> {WW, 2.085}, 
    PropagatorLabel -> "uWp",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[32] == { 
    ClassName       -> ghWm,
    SelfConjugate   -> False, 
    Ghost           -> Wbar,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> -1},
    Mass            -> {MW,Internal}, 
    Width           -> {WW, 2.085},
    PropagatorLabel -> "uWm",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[4] == { 
    ClassName       -> ghG, 
    SelfConjugate   -> False,
    Indices         -> {Index[Gluon]},
    Ghost           -> G,
    PDG             -> 82,
    QuantumNumbers  ->{GhostNumber -> 1}, 
    Mass            -> 0,
    Width	    -> 0,
    PropagatorLabel -> "uG",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
(************B-L***************)
  V[5] == {
    ClassName        -> Zp,
    SelfConjugate    -> True,
    Indices          -> {},
    Mass             -> {MZp, 1500},
    Width            -> {WZp, 80.00},
    ParticleName     -> "Zp",
    PDG              -> 9900032,
    PropagatorLabel  -> "Zp",
    PropagatorType   -> Sine,
    PropagatorArrow  -> None,
    FullName         -> "Zp"
  },
  V[6] == {
    ClassName        -> Bp,
    SelfConjugate    -> True,
    Indices          -> {},
    Definitions      -> {Bp[mu_] -> Zp[mu]},
    Unphysical        -> True
  },

  U[5] == {
    ClassName       -> ghZp,
    SelfConjugate   -> False,
    Indices         -> {},
    Ghost           -> Zp,
    QuantumNumbers  -> {GhostNumber -> 1},
    Mass            -> {MZp, Internal},
    Width           -> {WZp, 80.00},
    PropagatorLabel -> "uZp",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[6] == {
    ClassName       -> ghBp,
    SelfConjugate   -> False,
    Definitions     -> {ghBp -> ghZp},
    Indices         -> {},
    Unphysical      -> True,
    Ghost           -> Bp
  },

(************End***************)

(* Gauge bosons: unphysical vector fields *)
  V[11] == { 
    ClassName     -> B, 
    Unphysical    -> True, 
    SelfConjugate -> True, 
    Definitions   -> { B[mu_] -> -sw Z[mu]+cw A[mu]} 
  },
  V[12] == { 
    ClassName     -> Wi,
    Unphysical    -> True,
    SelfConjugate -> True, 
    Indices       -> {Index[SU2W]},
    FlavorIndex   -> SU2W,
    Definitions   -> { Wi[mu_,1] -> (Wbar[mu]+W[mu])/Sqrt[2], Wi[mu_,2] -> (Wbar[mu]-W[mu])/(I*Sqrt[2]), Wi[mu_,3] -> cw Z[mu] + sw A[mu]}
  },

(* Ghosts: related to unphysical gauge bosons *)
  U[11] == {
    ClassName     -> ghB, 
    Unphysical    -> True,
    SelfConjugate -> False,
    Ghost         -> B, 
    Definitions   -> { ghB -> -sw ghZ + cw ghA}
  },
  U[12] == {
    ClassName     -> ghWi,
    Unphysical    -> True,
    SelfConjugate -> False,
    Ghost         -> Wi,
    Indices       -> {Index[SU2W]},
    FlavorIndex   -> SU2W,
    Definitions   -> { ghWi[1] -> (ghWp+ghWm)/Sqrt[2], ghWi[2] -> (ghWm-ghWp)/(I*Sqrt[2]), ghWi[3] -> cw ghZ+sw ghA}
  } ,

(* Fermions: physical fields *)
(************B-L******************)
  F[1] == {
    ClassName        -> nL,
    ClassMembers     -> {nL1,nL2,nL3},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> True,
    QuantumNumbers   -> {},
    Mass             -> {MnL,{MnL1, 10^(-9)},{MnL2, 10^(-9)},{MnL3, 10^(-9)}},
    Width            -> 0,
    PropagatorLabel  -> {"nL", "nul1", "nul2", "nul3"} ,
    PropagatorType   -> S,
    PropagatorArrow  -> Forward,
    PDG              -> {12,14,16},
    ParticleName     -> {"n1","n2","n3"},
    FullName         -> {"Light neutrino 1", "Light neutrino 2", "Light neutrino 3"}
  },
  F[16] == {
    ClassName        -> nH,
    ClassMembers     -> {nH1, nH2, nH3},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> True,
    QuantumNumbers   -> {},
    Mass             -> {MnH,{MnH1, 200.00},{MnH2, 200.00},{MnH3, 200.00}},
    Width            -> 10^(-13),
    PropagatorLabel  -> {"nH","nuh1","nuh2","nuh3"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {9910012, 9910014, 9910016},
    ParticleName     -> {"nH1","nH2","nH3"},
    FullName         -> {"Heavy neutrino 1", "Heavy neutrino 2", "Heavy neutrino 3"}
  },
   (* unphysical *)
  F[17] == {
    ClassName        -> nF,
    ClassMembers     -> {nF1,nF2,nF3},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> True,
    Unphysical       -> True,
    Definitions      -> {nF[sp_,ff_] -> Can[ff] nL[sp,ff]-San[ff] nH[sp,ff]}
  },
   (* unphysical *)
  F[18] == {
    ClassName        -> nR,
    ClassMembers     -> {nR1,nR2,nR3},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> True,
    Unphysical       -> True,
    Definitions      -> {nR[sp_,ff_] -> San[ff] nL[sp,ff]+Can[ff] nH[sp,ff]}
  },

  (* Flavour-eigenstate neutrino: unphysical *)    
  (* Righthanded flavor neutrino: unphysical *)
  F[20] == {
    ClassName        -> VR,
    Unphysical       -> True,
    Indices          -> {Index[Generation]},
    QuantumNumbers   -> {Y -> 0, BL -> -1},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Definitions      -> { VR[sp1_,ff_] :> Module[{sp2}, ProjP[sp1,sp2] nR[sp2,ff]]}
  },
(***************END******************)

  F[2] == {
    ClassName        -> l,
    ClassMembers     -> {e, mu, ta},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Ml, {Me,5.11*^-4}, {MMU,0.10566}, {MTA,1.777}},
    Width            -> 0,
    QuantumNumbers   -> {Q -> -1, LeptonNumber -> 1},
    PropagatorLabel  -> {"l", "e", "mu", "ta"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {11, 13, 15},
    ParticleName     -> {"e-", "mu-", "ta-"},
    AntiParticleName -> {"e+", "mu+", "ta+"},
    FullName         -> {"Electron", "Muon", "Tau"} 
  },
    (* Quarks (u): I_3 = +1/2, Q = +2/3, BL=1/3 *)
  F[3] == {
    ClassName        -> uq,
    ClassMembers     -> {u, c, t},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Mu, {MU, 2.55*^-3}, {MC,1.27}, {MT,172}},
    Width            -> {0, 0, {WT,1.50833649}},
    QuantumNumbers   -> {Q -> 2/3},
    PropagatorLabel  -> {"uq", "u", "c", "t"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {2, 4, 6}, 
    ParticleName     -> {"u",  "c",  "t" },
    AntiParticleName -> {"u~", "c~", "t~"},
    FullName         -> {"u-quark", "c-quark", "t-quark"}
  },
    (* Quarks (d): I_3 = -1/2, Q = -1/3, BL=1/3 *) 
  F[4] == {
    ClassName        -> dq,
    ClassMembers     -> {d, s, b},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Md, {MD,5.04*^-3}, {MS,0.101}, {MB,4.7}},
    Width            -> 0,
    QuantumNumbers   -> {Q -> -1/3},
    PropagatorLabel  -> {"dq", "d", "s", "b"},
    PropagatorType   -> Straight, 
    PropagatorArrow  -> Forward,
    PDG              -> {1,3,5},
    ParticleName     -> {"d",  "s",  "b" },
    AntiParticleName -> {"d~", "s~", "b~"},
    FullName         -> {"d-quark", "s-quark", "b-quark"}
  },

(* Fermions: unphysical fields *)
  F[11] == { 
    ClassName      -> LL, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Generation]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1/2, BL -> -1},
    Definitions    -> { LL[sp1_,1,ff_] :> Module[{sp2}, ProjM[sp1,sp2] nF[sp2,ff]], LL[sp1_,2,ff_] :> Module[{sp2}, ProjM[sp1,sp2] l[sp2,ff]] }
  },
  F[12] == { 
    ClassName      -> lR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1, BL -> -1},
    Definitions    -> { lR[sp1_,ff_] :> Module[{sp2}, ProjP[sp1,sp2] l[sp2,ff]] }
  },
  F[13] == { 
    ClassName      -> QL, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D], Index[Generation], Index[Colour]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/6, BL -> 1/3},
    Definitions    -> { 
      QL[sp1_,1,ff_,cc_] :> Module[{sp2}, ProjM[sp1,sp2] uq[sp2,ff,cc]], 
      QL[sp1_,2,ff_,cc_] :> Module[{sp2,ff2}, CKM[ff,ff2] ProjM[sp1,sp2] dq[sp2,ff2,cc]] }
  },
  F[14] == { 
    ClassName      -> uR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 2/3, BL -> 1/3},
    Definitions    -> { uR[sp1_,ff_,cc_] :> Module[{sp2}, ProjP[sp1,sp2] uq[sp2,ff,cc]] }
  },
  F[15] == { 
    ClassName      -> dR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> -1/3, BL -> 1/3},
    Definitions    -> { dR[sp1_,ff_,cc_] :> Module[{sp2}, ProjP[sp1,sp2] dq[sp2,ff,cc]] }
  },

(* Higgs: physical scalars  *)
  S[1] == {
    ClassName       -> H1,
    SelfConjugate   -> True,
    Mass            -> {MH1,125},
    Width           -> {WH1,0.00407},
    PropagatorLabel -> "H1",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 9900025,
    ParticleName    -> "H1",
    FullName        -> "H1"
  },

(* Higgs: physical scalars  *)
(**********phi(phi0)****************)
  S[2] == {
    ClassName       -> G0,
    SelfConjugate   -> True,
    Goldstone       -> Z,
    Mass            -> {MZ, 91.1876},
    Width           -> {WZ, 2.4952},
    PropagatorLabel -> "Go",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 250,
    ParticleName    -> "G0",
    FullName        -> "G0"
  },
(************phi2*******************)
  S[3] == {
    ClassName        -> GP,
    SelfConjugate    -> False,
    Goldstone        -> W,
    Mass             -> {MW, Internal},
    QuantumNumbers   -> {Q -> 1},
    Width            -> {WW, 2.085},
    PropagatorLabel  -> "GP",
    PropagatorType   -> D,
    PropagatorArrow  -> None,
    PDG              -> 251,
    ParticleName     -> "G+",
    AntiParticleName -> "G-",
    FullName         -> "GP"
  },
 (***************B-L*****************)
(* Higgs: unphysical scalars  *)
  S[11] == { 
    ClassName      -> Phi, 
    Unphysical     -> True, 
    Indices        -> {Index[SU2D]},
    FlavorIndex    -> SU2D,
    SelfConjugate  -> False,
    QuantumNumbers -> {Y -> 1/2, BL -> 0},
    Definitions    -> { Phi[1] -> -I GP, Phi[2] -> (vev + Ca*H1 + Sa*H2 + I G0)/Sqrt[2]  }
  },
  S[12] == {
    ClassName       -> Xi,
    Unphysical      -> True,
    SelfConjugate   -> False,
    QuantumNumbers  -> {Y -> 0, BL -> 2},
    Definitions     -> { Xi -> (xev - Sa*H1 + Ca*H2 + I phip)/Sqrt[2]
    }
  },
  S[4]  == {
    ClassName       -> H2,
    SelfConjugate   -> True,
    Mass            -> {MH2, Internal},
    Width           -> {WH2, 10},
    PropagatorLabel -> "H2",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 9900026,
    ParticleName    -> "H2",
    FullName        -> "H2"
  },
  S[5]  == {
    ClassName       -> phip,
    SelfConjugate   -> True,
    Goldstone       -> Zp,
    Mass            -> {MZp, Internal},
    Width           -> Wphip,
    PropagatorLabel -> "Phip",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 9900252,
    ParticleName    -> "phi0p",
    FullName        -> "Phip"
  }
};
 (***************END*****************) 

(* ************************** *)
(* *****     Gauge      ***** *)
(* *****   Parameters   ***** *)
(* *****   (FeynArts)   ***** *)
(* ************************** *)

GaugeXi[ V[1]  ] = GaugeXi[A];
GaugeXi[ V[2]  ] = GaugeXi[Z];
GaugeXi[ V[3]  ] = GaugeXi[W];
GaugeXi[ V[4]  ] = GaugeXi[G];
GaugeXi[ S[1]  ] = 1;
GaugeXi[ S[2]  ] = GaugeXi[Z];
GaugeXi[ S[3]  ] = GaugeXi[W];
GaugeXi[ U[1]  ] = GaugeXi[A];
GaugeXi[ U[2]  ] = GaugeXi[Z];
GaugeXi[ U[31] ] = GaugeXi[W];
GaugeXi[ U[32] ] = GaugeXi[W];
GaugeXi[ U[4]  ] = GaugeXi[G];
(***************B-L*****************)
GaugeXi[ V[5] ] = GaugeXi[Zp];
GaugeXi[ S[4] ] = 1;
GaugeXi[ S[5] ] = GaugeXi[Zp];
GaugeXi[ U[5] ] = GaugeXi[Zp];
(***************END*****************)

(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

  (* External parameters *)
  aEWM1 == { 
    ParameterType    -> External, 
    BlockName        -> SMINPUTS, 
    OrderBlock       -> 1, 
    Value            -> 127.9,
    InteractionOrder -> {QED,-2},
    Description      -> "Inverse of the EW coupling constant at the Z pole"
  },
  Gf == {
    ParameterType    -> External,
    BlockName        -> SMINPUTS,
    OrderBlock       -> 2,
    Value            -> 1.16637*^-5, 
    InteractionOrder -> {QED,2},
    TeX              -> Subscript[G,f],
    Description      -> "Fermi constant"
  },
  aS    == { 
    ParameterType    -> External,
    BlockName        -> SMINPUTS,
    OrderBlock       -> 3,
    Value            -> 0.1184, 
    InteractionOrder -> {QCD,2},
    TeX              -> Subscript[\[Alpha],s],
    Description      -> "Strong coupling constant at the Z pole"
  },
  ymdo == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 1,
    Value         -> 5.04*^-3,
    Description   -> "Down Yukawa mass"
  },
  ymup == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 2,
    Value         -> 2.55*^-3,
    Description   -> "Up Yukawa mass"
  },
  yms == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 3,
    Value         -> 0.101,
    Description   -> "Strange Yukawa mass"
  },
  ymc == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 4,
    Value         -> 1.27,
    Description   -> "Charm Yukawa mass"
  },
  ymb == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 5,
    Value         -> 4.7,
    Description   -> "Bottom Yukawa mass"
  },
  ymt == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 6,
    Value         -> 172,
    Description   -> "Top Yukawa mass"
  },
  yme == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 11,
    Value         -> 5.11*^-4,
    Description   -> "Electron Yukawa mass"
  },
  ymm == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 13,
    Value         -> 0.10566,
    Description   -> "Muon Yukawa mass"
  },
  ymtau == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 15,
    Value         -> 1.777,
    Description   -> "Tau Yukawa mass"
  },
  cabi == {
    ParameterType -> External,
    BlockName     -> CKMBLOCK,
    OrderBlock    -> 1,
    Value         -> 0.227736,
    TeX           -> Subscript[\[Theta], c],
    Description   -> "Cabibbo angle"
  },
 (***************B-L*****************)
  g1p == {
    ParameterType -> External,
    BlockName -> BLINPUTS,
    InteractionOrder -> {QED, 1},
    TeX              -> Subscript[g,1p],
    Value -> 0.2,
    Description -> "U(1)Y B-L coupling coustant at the Zp pole"
  },
  MH2 == {
    ParameterType -> External,
    BlockName -> BLINPUTS,
    Value -> 450.00,
    Description -> "H2 mass"
  },
  Sa == {
    ParameterType -> External,
    BlockName -> BLINPUTS,
    Value -> 0.1,
    Description -> "Sine of Higgses mixing angle"
  },
  (*********************neutrino mixing********************)
  San == {
    ParameterType -> Internal,
    BlockName -> BLINPUTS,
    Indices -> {Index[Generation]}, 
    AllowSummation -> True,
    Value -> {San[1] ->-Sqrt[MnL1/(MnH1+MnL1)],
        San[2] -> -Sin[ArcSin[2*Mdd2/Sqrt[4*Mdd2^2+(MnH2-MnL2)^2]]/2],
        San[3] -> -Sin[ArcSin[2*Mdd3/Sqrt[4*Mdd3^2+(MnH3-MnL3)^2]]/2]
        },
    ComplexParameter -> False,
    ParameterName -> {San[1] -> San1, San[2] -> San2, San[3] -> San3},
    Description -> "Sin-array of neutrino mass-eigenstates"
  },
 (***************END*****************)
  (* Internal Parameters *)
  Mdd == {
        Indices -> {Index[Generation]},
        AllowSummation -> True,
        ParameterType -> Internal,
        Value -> {Mdd[1] -> ynd1*vev/Sqrt[2],
                  Mdd[2] -> ynd2*vev/Sqrt[2],
                  Mdd[3] -> ynd3*vev/Sqrt[2]},
        ParameterName -> {Mdd[1] -> Mdd1,
                          Mdd[2] -> Mdd2,
                          Mdd[3] -> Mdd3},
        ComplexParameter -> False,
        Description -> "Neutrino Dirac Mass"
  },
  aEW == {
    ParameterType    -> Internal,
    Value            -> 1/aEWM1,
    InteractionOrder -> {QED,2},
    TeX              -> Subscript[\[Alpha], EW],
    Description      -> "Electroweak coupling contant"
  },
  MW == { 
    ParameterType -> Internal, 
    Value         -> Sqrt[MZ^2/2+Sqrt[MZ^4/4-Pi/Sqrt[2]*aEW/Gf*MZ^2]], 
    TeX           -> Subscript[M,W], 
    Description   -> "W mass"
  },
  sw2 == { 
    ParameterType -> Internal, 
    Value         -> 1-(MW/MZ)^2, 
    Description   -> "Squared Sin of the Weinberg angle"
  },
  ee == { 
    ParameterType    -> Internal, 
    Value            -> Sqrt[4 Pi aEW], 
    InteractionOrder -> {QED,1}, 
    TeX              -> e,  
    Description      -> "Electric coupling constant"
  },
  cw == { 
    ParameterType -> Internal, 
    Value         -> Sqrt[1-sw2], 
    TeX           -> Subscript[c,w], 
    Description   -> "Cosine of the Weinberg angle"
  },
  sw == { 
    ParameterType -> Internal, 
    Value         -> Sqrt[sw2], 
    TeX           -> Subscript[s,w], 
    Description   -> "Sine of the Weinberg angle"
  },
  gw == { 
    ParameterType    -> Internal, 
    Definitions      -> {gw->ee/sw}, 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[g,w], 
    Description      -> "Weak coupling constant at the Z pole"
  },
  g1 == { 
    ParameterType    -> Internal, 
    Definitions      -> {g1->ee/cw}, 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[g,1], 
    Description      -> "U(1)Y coupling constant at the Z pole"
  },
  gs == { 
    ParameterType    -> Internal, 
    Value            -> Sqrt[4 Pi aS],
    InteractionOrder -> {QCD,1},  
    TeX              -> Subscript[g,s], 
    ParameterName    -> G,
    Description      -> "Strong coupling constant at the Z pole"
  },
  vev == {
    ParameterType    -> Internal,
    Value            -> 2*MW*sw/ee, 
    InteractionOrder -> {QED,-1},
    Description      -> "Higgs vacuum expectation value"
  },
  (****************lightneutrino**************)
  (*****************B-L********************)
  xev == {
    ParameterType    -> Internal,
    Value            -> MZp/(2*g1p),
    InteractionOrder -> {QED, -1},
    Description      -> "H2 VEV"
  },
  Ca == {
    ParameterType    -> Internal,
    Value            -> Sqrt[1-Sa^2],
    ParameterName    -> Ca,
    Description      -> "Cosine of Higgses mixing angle"
  },
  (*************neutrino mass terms********)
  ynd == {
    ParameterType -> Internal,
    Indices -> {Index[Generation]},
    AllowSummation -> True,
    Value -> {ynd[1] -> Sqrt[2*MnH1*MnL1]/vev,
              ynd[2] -> Sqrt[2*MnH2*MnL2]/vev, 
              ynd[3] -> Sqrt[2*MnH3*MnL3]/vev
              },   
    InteractionOrder -> {QED, 1},
    ComplexParameter -> False,    
    ParameterName -> {ynd[1] -> ynd1, ynd[2] -> ynd2, ynd[3] -> ynd3},
    Description -> "Dirac neutrino Yukawa coupling"
  },

  ynm == {
    ParameterType -> Internal,
    Indices -> {Index[Generation]},
    AllowSummation -> True,
    Value -> {ynm[1] -> (MnH1-MnL1)/Sqrt[2]/xev,
              ynm[2] -> (MnH2-MnL2)/Sqrt[2]/xev,
              ynm[3] -> (MnH3-MnL3)/Sqrt[2]/xev},
    InteractionOrder -> {QED, 1},
    ComplexParameter -> False,
    ParameterName -> {ynm[1] -> ynm1, ynm[2] -> ynm2, ynm[3] -> ynm3},
    Description -> "Majorana neutrino Yukawa coupling"
  },

  Can == {
    ParameterType -> Internal,
    Indices -> {Index[Generation]},
    AllowSummation -> True,
    Value -> {Can[1] -> Sqrt[1-San1^2],
               Can[2] -> Sqrt[1-San2^2],
               Can[3] -> Sqrt[1-San3^2]},
    ComplexParameter -> False,
    ParameterName -> {Can[1] -> Can1, Can[2] -> Can2, Can[3] -> Can3},
    Description -> "Cos-array of neutrino mass-eigenstates"
  },


  (**************Higgs Potential*******************)
  lam1 == {
    ParameterType    -> Internal,
    Value            -> MH1^2/(2*vev^2)*Ca^2 + MH2^2 /(2*vev^2)*Sa^2,
    ParameterName    -> lam1,
    InteractionOrder -> {QED, 2},
    Description      -> "Higgs quartic coupling piece for H1"
  },
  lam2 == {
    ParameterType    -> Internal,
    Value            -> MH1^2 /(2*xev^2)*Sa^2 + MH2^2 /(2*xev^2)*Ca^2,
    ParameterName    -> lam2,
    InteractionOrder -> {QED,2},
    Description      -> "Higgs quartic coupling piece for H2"
  },
  lam3 == {
    ParameterType    -> Internal,
    Value            -> (MH2^2 - MH1^2)/(xev*vev)*Sa*Ca,
    ParameterName    -> lam3,
    InteractionOrder -> {QED, 2},
    Description      -> "Mixing part"
  },
  mu2H1 == {
    ParameterType -> Internal,
    Value         -> -lam1 * vev^2 - lam3 /2 * xev^2, 
    TeX           -> \[Mu],
    Description   -> "Coefficient of the quadratic piece of the H1 potential"
  },
  mu2H2 == {
    ParameterType -> Internal,
    Value         -> -lam3 /2 * vev^2 - lam2 * xev^2,
    TeX           -> \[Mu]prime,
    Description   -> "Coefficient of the quadratic piece of the H2 potential"
  },
  (******************END*********************)
  yl == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yl[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yl[1,1] -> Sqrt[2] yme / vev, yl[2,2] -> Sqrt[2] ymm / vev, yl[3,3] -> Sqrt[2] ymtau / vev},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yl[1,1] -> ye, yl[2,2] -> ym, yl[3,3] -> ytau},
    TeX              -> Superscript[y, l],
    Description      -> "Lepton Yukawa couplings"
  },
  yu == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yu[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yu[1,1] -> Sqrt[2] ymup/vev, yu[2,2] -> Sqrt[2] ymc/vev, yu[3,3] -> Sqrt[2] ymt/vev},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yu[1,1] -> yup, yu[2,2] -> yc, yu[3,3] -> yt},
    TeX              -> Superscript[y, u],
    Description      -> "Up-type Yukawa couplings"
  },
  yd == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yd[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yd[1,1] -> Sqrt[2] ymdo/vev, yd[2,2] -> Sqrt[2] yms/vev, yd[3,3] -> Sqrt[2] ymb/vev},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yd[1,1] -> ydo, yd[2,2] -> ys, yd[3,3] -> yb},
    TeX              -> Superscript[y, d],
    Description      -> "Down-type Yukawa couplings"
  },
(* N. B. : only Cabibbo mixing! *)
  CKM == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    Unitary       -> True,
    Value         -> {CKM[1,1] -> Cos[cabi],  CKM[1,2] -> Sin[cabi], CKM[1,3] -> 0,
                      CKM[2,1] -> -Sin[cabi], CKM[2,2] -> Cos[cabi], CKM[2,3] -> 0,
                      CKM[3,1] -> 0,          CKM[3,2] -> 0,         CKM[3,3] -> 1},
    TeX         -> Superscript[V,CKM],
    Description -> "CKM-Matrix"}
};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

LGauge := Block[{mu,nu,ii,aa}, 
  ExpandIndices[-1/4 FS[B,mu,nu] FS[B,mu,nu] - 1/4 FS[Wi,mu,nu,ii] FS[Wi,mu,nu,ii] - 1/4 FS[G,mu,nu,aa] FS[G,mu,nu,aa] 
(*************B-L*******************)
  -1/4 FS[Bp,mu,nu] FS[Bp,mu,nu], 
(*************END********************)
  FlavorExpand->SU2W]];

LFermions := Block[{mu}, 
  ExpandIndices[I*(
    QLbar.Ga[mu].DC[QL, mu] + LLbar.Ga[mu].DC[LL, mu] + uRbar.Ga[mu].DC[uR, mu] + dRbar.Ga[mu].DC[dR, mu] + lRbar.Ga[mu].DC[lR, mu]
(**********B-L*********************)
    + VRbar.Ga[mu].DC[VR,mu]
(***********END********************)
), 
  FlavorExpand->{SU2W,SU2D}]/.{CKM[a_,b_] Conjugate[CKM[a_,c_]]->IndexDelta[b,c], CKM[b_,a_] Conjugate[CKM[c_,a_]]->IndexDelta[b,c]}];

LHiggs := Block[{ii,mu, feynmangaugerules},
  feynmangaugerules = If[Not[FeynmanGauge], {G0|GP|GPbar|phip ->0}, {}];
 
  ExpandIndices[DC[Phibar[ii],mu] DC[Phi[ii],mu] - mu2H1 Phibar[ii] Phi[ii] - lam1 Phibar[ii] Phi[ii] Phibar[jj] Phi[jj]
(*******************B-L****************************)
+ DC[Xibar,mu] DC[Xi,mu]
- mu2H2 Xibar Xi
- lam2 Xibar Xi Xibar Xi
- lam3 Phibar[ii]Phi[ii] Xibar Xi
(*******************END****************************)
  , FlavorExpand->{SU2D,SU2W}]/.feynmangaugerules
 ];

LYukawaSM := Block[{sp,ii,jj,cc,ff1,ff2,ff3,yuk,feynmangaugerules},
  feynmangaugerules = If[Not[FeynmanGauge], {G0|GP|GPbar|phip ->0}, {}];
 
  yuk = ExpandIndices[
    -yd[ff2, ff3] CKM[ff1, ff2] QLbar[sp, ii, ff1, cc].dR [sp, ff3, cc] Phi[ii] - 
    yl[ff1, ff3] LLbar[sp, ii, ff1].lR [sp, ff3] Phi[ii] - 
    yu[ff1, ff2] QLbar[sp, ii, ff1, cc].uR [sp, ff2, cc] Phibar[jj] Eps[ii, jj]
    , FlavorExpand -> SU2D];
  yuk = yuk /. { CKM[a_, b_] Conjugate[CKM[a_, c_]] -> IndexDelta[b, c], CKM[b_, a_] Conjugate[CKM[c_, a_]] -> IndexDelta[b, c]};
  yuk+HC[yuk]/.feynmangaugerules
  ];
(**********************B-L***************************)
LYukawaBL := Block[{ff1,sp,ii,feynmangaugerules},
  feynmangaugerules = If[Not[FeynmanGauge], {G0|GP|GPbar|phip ->0}, {}];

  yun = ExpandIndices[
    -ynd[ff1] LLbar[sp,ii,ff1].VR[sp,ff1]Phibar[jj]Eps[ii, jj]
    -ynm[ff1] nRbar[sp,ff1].VR[sp,ff1] Xi
    , FlavorExpand -> SU2D];
  yun+HC[yun]/.feynmangaugerules
  ];
LYukawa := LYukawaSM + LYukawaBL;
Lmaj :=-ynm[ff1] nRbar[sp,ff1].VR[sp,ff1] Xi
Lnew :=-ynm[n] San[n] San[n]  anti[nL][s,n].ProjP[s,r].nL[r,n]Xi
(**********************END***************************)
(*******************Eqn.(2.44) from 1106.4691******************************)
(*****************B-L is an abelian group, DC->del, https://en.wikipedia.org/wiki/Faddeev%E2%80%93Popov_ghost**********)
LGhost := Block[{LGh1,LGhw,LGhs,LGhphi,LGhBp, LGhphiBL, mu, generators,gh,ghbar,Vectorize,phi1,phi2,togoldstones,doublet,doublet0},
  (* Pure gauge piece *)  
  LGh1 = -ghBbar.del[DC[ghB,mu],mu];
  LGhw = -ghWibar[ii].del[DC[ghWi[ii],mu],mu];
  LGhs = -ghGbar[ii].del[DC[ghG[ii],mu],mu];
(******************B-L***********************)
  LGhBp = - ghBpbar.del[del[ghBp, mu],mu];
  LGhphiBL = -2*g1p MZp (xev-Sa*H1+Ca*H2) ghZpbar.ghZp; 
(**********************END***************************)
  (* Scalar pieces: see Peskin pages 739-742 *)
  (* phi1 and phi2 are the real degrees of freedom of GP *)
  (* Vectorize transforms a doublet in a vector in the phi-basis, i.e. the basis of real degrees of freedom *)
  gh    = {ghB, ghWi[1], ghWi[2], ghWi[3]};
  ghbar = {ghBbar, ghWibar[1], ghWibar[2], ghWibar[3]};
  generators = {-I/2 g1 IdentityMatrix[2], -I/2 gw PauliSigma[1], -I/2 gw PauliSigma[2], -I/2 gw PauliSigma[3]};
  doublet = Expand[{(-I phi1 - phi2)/Sqrt[2], Phi[2]} /. MR$Definitions /. vev -> 0]; 
  doublet0 = {0, vev/Sqrt[2]};
  Vectorize[{a_, b_}]:= Simplify[{Sqrt[2] Re[Expand[a]], Sqrt[2] Im[Expand[a]], Sqrt[2] Re[Expand[b]], Sqrt[2] Im[Expand[b]]}/.{Im[_]->0, Re[num_]->num}];
  togoldstones := {phi1 -> (GP + GPbar)/Sqrt[2], phi2 -> (-GP + GPbar)/(I Sqrt[2])};
  LGhphi=Plus@@Flatten[Table[-ghbar[[kkk]].gh[[lll]] Vectorize[generators[[kkk]].doublet0].Vectorize[generators[[lll]].(doublet+doublet0)],{kkk,4},{lll,4}]] /.togoldstones;

ExpandIndices[ LGhs + If[FeynmanGauge, LGh1 + LGhw + LGhphi + LGhBp + LGhphiBL ,0], FlavorExpand->SU2W]];
LBL:= LGauge + LFermions + LHiggs + LYukawa + LGhost;