(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     10156,        277]
NotebookOptionsPosition[      8876,        235]
NotebookOutlinePosition[      9273,        253]
CellTagsIndexPosition[      9230,        250]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  FrameBox[
   RowBox[{
   "\[SelectionPlaceholder]", " ", "FeynRules", " ", 
    "initialization"}]]}]], "Input",
 CellChangeTimes->{{3.5542065470381117`*^9, 3.554206578929636*^9}}],

Cell[BoxData[
 RowBox[{"$FeynRulesPath", "=", 
  RowBox[{
  "SetDirectory", "[", 
   "\"\</Users/oscar/Trabalho/WorkInProgress/FeynRules/feynrules-development\>\
\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
  3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
  3.4234163227881193`*^9}, {3.549259989465773*^9, 3.549259999606881*^9}}],

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/Quartic_linear\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.419073170860696*^9, 3.419073182827229*^9}, {
  3.549260010957612*^9, 3.549260018221593*^9}, {3.5527968095887547`*^9, 
  3.552796815826297*^9}}],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  FrameBox[
   RowBox[{
    RowBox[{
    "\[SelectionPlaceholder]", " ", "Loading", " ", "the", " ", "file", " ", 
     "containing", " ", "the", " ", "Standard", " ", "Model", " ", "and", " ",
      "L_S0"}], " ", "+", " ", "L_S1"}]], " "}]], "Input",
 CellChangeTimes->{{3.554206586417383*^9, 3.554206720572693*^9}}],

Cell[BoxData[
 RowBox[{"LoadModel", "[", "\"\<quartic.fr\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.4022069973481913`*^9, 3.402207011768662*^9}, 
   3.4022081212072697`*^9, {3.402208250379383*^9, 3.402208254043104*^9}, 
   3.4027466057480917`*^9, {3.403240270135737*^9, 3.403240277228945*^9}, 
   3.403266503388291*^9, {3.403267649630335*^9, 3.40326765417397*^9}, {
   3.403269919787421*^9, 3.403269921965273*^9}, {3.403347551273425*^9, 
   3.403347555049163*^9}, 3.4044490490588417`*^9, {3.411744339876704*^9, 
   3.411744340012457*^9}, {3.4121886924550533`*^9, 3.412188699157571*^9}, 
   3.412188808811866*^9, 3.4121888580521603`*^9, {3.412450464077868*^9, 
   3.412450464378695*^9}, {3.413715097460478*^9, 3.41371509757642*^9}, {
   3.41440825334604*^9, 3.414408254159686*^9}, {3.41862573831756*^9, 
   3.4186257392223186`*^9}, {3.4190731862389174`*^9, 3.419073187003003*^9}, {
   3.419073336802393*^9, 3.4190733374513063`*^9}, {3.4190828041801767`*^9, 
   3.4190828048079023`*^9}, {3.549356567929675*^9, 3.549356569284753*^9}, {
   3.552796819881452*^9, 3.552796823177125*^9}}],

Cell[BoxData[
 RowBox[{"LoadRestriction", "[", 
  RowBox[{"\"\<Cabibbo.rst\>\"", ",", "\"\<Massless.rst\>\""}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.453790588503598*^9, 3.4537906008856297`*^9}, 
   3.5529941847635183`*^9}],

Cell[BoxData[
 RowBox[{
  FrameBox[
   RowBox[{
   "\[SelectionPlaceholder]", " ", "Checking", " ", "the", " ", 
    "lagrangian"}]], "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.554207149082877*^9, 3.5542071697416487`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input",
 CellChangeTimes->{{3.4234159280429783`*^9, 3.423415934798614*^9}, 
   3.554210133339581*^9}],

Cell["The hermiticity of the Lagrangian can be checked via", "Text",
 CellChangeTimes->{{3.423415694323595*^9, 3.423415707867804*^9}}],

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", 
  RowBox[{"LQS", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.414763604111637*^9, 3.4147636044973803`*^9}, {
  3.554207230374851*^9, 3.554207231973926*^9}}],

Cell["\<\
FeynRules can check whether all the values of the masses given in the model \
file are in agreement with the masses given in the Lagrangian:\
\>", "Text",
 CellChangeTimes->{{3.423415751305388*^9, 3.423415792594919*^9}, {
  3.5542072544005003`*^9, 3.554207255988462*^9}}],

Cell[BoxData[
 RowBox[{"CheckMassSpectrum", "[", 
  RowBox[{"LSM", "+", "LQS"}], "]"}]], "Input",
 CellChangeTimes->{{3.414736325829801*^9, 3.414736326065997*^9}, 
   3.4147528281460342`*^9, {3.5542072604055557`*^9, 3.554207262590489*^9}, {
   3.554290298409437*^9, 3.554290300070582*^9}}],

Cell["\<\
In the same way, FeynRules can check whether all kinetic terms are correctly \
normalized :\
\>", "Text",
 CellChangeTimes->{{3.423415798800013*^9, 3.423415817964087*^9}}],

Cell[BoxData[
 RowBox[{"CheckKineticTermNormalisation", "[", 
  RowBox[{
   RowBox[{"LSM", "+", "LQS"}], ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.554290748499344*^9, 3.554290750913568*^9}}],

Cell[BoxData[
 FrameBox[
  RowBox[{
  "\[SelectionPlaceholder]", " ", "Feynman", " ", "rules", " ", "originating",
    " ", "from", " ", "L_S0", " ", "and", " ", "L_S1", " ", "using", " ", 
   "the", " ", "unitary", " ", "gauge"}]]], "Input",
 CellChangeTimes->{{3.554206797674385*^9, 3.554206865976857*^9}, {
  3.5542069112258472`*^9, 3.554206917083228*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LS0", " ", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.5542147888623667`*^9, 3.5542147904036713`*^9}, 
   3.5542148289281187`*^9}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"FeynmanRules", "[", 
  RowBox[{"LS1", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.55421481319798*^9, 3.5542148158116817`*^9}}],

Cell[BoxData[
 FrameBox[
  RowBox[{
  "\[SelectionPlaceholder]", " ", "Generating", " ", "the", " ", "UFO", " ", 
   "output", " ", "used", " ", "by", " ", "MadGraph5"}]]], "Input",
 CellChangeTimes->{{3.554207020764146*^9, 3.554207046179934*^9}, {
  3.554207083712941*^9, 3.55420709708432*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"WriteUFO", "[", 
  RowBox[{
  "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", "LS0", ",", 
   " ", "LS1", ",", " ", 
   RowBox[{"Output", " ", "\[Rule]", " ", "\"\<SM_LS0_LS1_UFO\>\""}]}], 
  "]"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  FrameBox[
   RowBox[{"\[SelectionPlaceholder]", " ", "FeynArts", " ", "output"}]], 
  " "}]], "Input",
 CellChangeTimes->{{3.554210222303082*^9, 3.554210236874051*^9}}],

Cell["FeynArts also supports the Feynman gauge", "Text",
 CellChangeTimes->{{3.4121854851672792`*^9, 3.412185494183435*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", " ", "=", " ", "False"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{
  "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", "LS0", ",", 
   "LS1", ",", " ", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}], ",", 
   RowBox[{"Output", "\[Rule]", "\"\<SM_LS0_LS1_FA\>\""}]}], "]"}]}], "Input",\

 CellChangeTimes->{{3.411911018354619*^9, 3.4119110196967573`*^9}, {
   3.412185470680571*^9, 3.412185506240796*^9}, {3.4234161971513453`*^9, 
   3.423416209716672*^9}, {3.5542103799698553`*^9, 3.554210404862816*^9}, {
   3.554213142736615*^9, 3.554213144826766*^9}, {3.554214531350573*^9, 
   3.554214532452024*^9}, {3.5542147194543047`*^9, 3.554214722231299*^9}, 
   3.5542907766028643`*^9}],

Cell[BoxData[
 FrameBox[
  RowBox[{
  "\[SelectionPlaceholder]", " ", "CalcHep", " ", "output"}]]], "Input",
 CellChangeTimes->{{3.554210492982093*^9, 3.554210505875268*^9}}],

Cell["CalcHep also supports the Feynman gauge", "Text",
 CellChangeTimes->{{3.4121853722243843`*^9, 3.412185380407339*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteCHOutput", "[", 
   RowBox[{
   "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", " ", "LS0",
     ",", " ", "LS1", ",", 
    RowBox[{"Output", "\[Rule]", "\"\<SM_LS0_LS1_CH\>\""}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
   3.412185409690489*^9, 3.4121854275198507`*^9}, {3.412450479942018*^9, 
   3.4124504817138367`*^9}, {3.554210518056747*^9, 3.554210525845241*^9}, {
   3.554212177238345*^9, 3.554212186985408*^9}, {3.554214738990678*^9, 
   3.5542147440692997`*^9}, 3.5542907733944674`*^9}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{3.412185367693318*^9, 3.412185407947097*^9}]
},
WindowSize->{1024, 656},
WindowMargins->{{Automatic, -2}, {Automatic, 0}},
ShowSelection->True,
Magnification->1.5,
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (November 6, \
2010)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 229, 6, 82, "Input"],
Cell[777, 28, 398, 8, 87, "Input"],
Cell[1178, 38, 54, 1, 40, "Input"],
Cell[1235, 41, 319, 7, 42, "Input"],
Cell[1557, 50, 365, 8, 83, "Input"],
Cell[1925, 60, 1083, 15, 40, "Input"],
Cell[3011, 77, 227, 5, 40, "Input"],
Cell[3241, 84, 236, 6, 83, "Input"],
Cell[3480, 92, 175, 4, 40, "Input"],
Cell[3658, 98, 134, 1, 39, "Text"],
Cell[3795, 101, 255, 5, 40, "Input"],
Cell[4053, 108, 281, 5, 62, "Text"],
Cell[4337, 115, 289, 5, 40, "Input"],
Cell[4629, 122, 181, 4, 39, "Text"],
Cell[4813, 128, 243, 5, 40, "Input"],
Cell[5059, 135, 359, 7, 59, "Input"],
Cell[5421, 144, 322, 7, 64, "Input"],
Cell[5746, 153, 286, 6, 64, "Input"],
Cell[6035, 161, 295, 6, 58, "Input"],
Cell[6333, 169, 333, 8, 65, "Input"],
Cell[6669, 179, 194, 5, 58, "Input"],
Cell[6866, 186, 124, 1, 39, "Text"],
Cell[6993, 189, 788, 16, 88, "Input"],
Cell[7784, 207, 174, 4, 58, "Input"],
Cell[7961, 213, 123, 1, 39, "Text"],
Cell[8087, 216, 692, 14, 88, "Input"],
Cell[8782, 232, 90, 1, 40, "Input"]
}
]
*)

(* End of internal cache information *)
