# This file was automatically created by FeynRules 2.3.14
# Mathematica version: 9.0 for Mac OS X x86 (64-bit) (November 20, 2012)
# Date: Mon 14 Aug 2017 13:58:31


from object_library import all_lorentz, Lorentz

from function_library import complexconjugate, re, im, csc, sec, acsc, asec, cot
try:
   import form_factors as ForFac 
except ImportError:
   pass


UUV3 = Lorentz(name = 'UUV3',
               spins = [ -1, -1, 3 ],
               structure = 'P(3,2) + P(3,3)')

SSS3 = Lorentz(name = 'SSS3',
               spins = [ 1, 1, 1 ],
               structure = '1')

FFS3 = Lorentz(name = 'FFS3',
               spins = [ 2, 2, 1 ],
               structure = 'ProjM(2,1) + ProjP(2,1)')

FFV11 = Lorentz(name = 'FFV11',
                spins = [ 2, 2, 3 ],
                structure = 'Gamma(3,2,1)')

FFV12 = Lorentz(name = 'FFV12',
                spins = [ 2, 2, 3 ],
                structure = 'Gamma(3,2,-1)*ProjM(-1,1)')

FFV13 = Lorentz(name = 'FFV13',
                spins = [ 2, 2, 3 ],
                structure = 'Gamma(3,2,-1)*ProjP(-1,1)')

FFV14 = Lorentz(name = 'FFV14',
                spins = [ 2, 2, 3 ],
                structure = 'Gamma(3,2,-1)*ProjM(-1,1) - 2*Gamma(3,2,-1)*ProjP(-1,1)')

VVS3 = Lorentz(name = 'VVS3',
               spins = [ 3, 3, 1 ],
               structure = 'Metric(1,2)')

VVV3 = Lorentz(name = 'VVV3',
               spins = [ 3, 3, 3 ],
               structure = 'P(3,1)*Metric(1,2) - P(3,2)*Metric(1,2) - P(2,1)*Metric(1,3) + P(2,3)*Metric(1,3) + P(1,2)*Metric(2,3) - P(1,3)*Metric(2,3)')

SSSS3 = Lorentz(name = 'SSSS3',
                spins = [ 1, 1, 1, 1 ],
                structure = '1')

VVSS5 = Lorentz(name = 'VVSS5',
                spins = [ 3, 3, 1, 1 ],
                structure = 'Metric(1,2)')

VVSS6 = Lorentz(name = 'VVSS6',
                spins = [ 3, 3, 1, 1 ],
                structure = '-(P(-1,2)*P(-1,4)*P(1,3)*P(2,1)) - P(-1,2)*P(-1,3)*P(1,4)*P(2,1) - P(-1,1)*P(-1,4)*P(1,2)*P(2,3) + P(-1,1)*P(-1,2)*P(1,4)*P(2,3) - P(-1,1)*P(-1,3)*P(1,2)*P(2,4) + P(-1,1)*P(-1,2)*P(1,3)*P(2,4) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,2) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,2)')

VVVS5 = Lorentz(name = 'VVVS5',
                spins = [ 3, 3, 3, 1 ],
                structure = '-(P(1,2)*P(2,4)*P(3,1)) + P(1,4)*P(2,1)*P(3,2) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3)')

VVVS6 = Lorentz(name = 'VVVS6',
                spins = [ 3, 3, 3, 1 ],
                structure = '-(P(1,4)*P(2,3)*P(3,1)) - P(1,2)*P(2,4)*P(3,1) + P(1,4)*P(2,1)*P(3,2) + P(1,3)*P(2,1)*P(3,4) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3) - P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)')

VVVS7 = Lorentz(name = 'VVVS7',
                spins = [ 3, 3, 3, 1 ],
                structure = '-(P(1,4)*P(2,3)*P(3,1)) - P(1,2)*P(2,4)*P(3,1) + P(1,4)*P(2,1)*P(3,2) + P(1,3)*P(2,4)*P(3,2) + P(1,3)*P(2,1)*P(3,4) - P(1,2)*P(2,3)*P(3,4) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,3)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2) + P(-1,2)*P(-1,3)*P(3,4)*Metric(1,2) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,2)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) - P(-1,2)*P(-1,3)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,3)*P(-1,4)*P(1,2)*Metric(2,3) - P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,2)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)')

VVVV23 = Lorentz(name = 'VVVV23',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) - Metric(1,3)*Metric(2,4)')

VVVV24 = Lorentz(name = 'VVVV24',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)')

VVVV25 = Lorentz(name = 'VVVV25',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) + Metric(1,3)*Metric(2,4) - 2*Metric(1,2)*Metric(3,4)')

VVVV26 = Lorentz(name = 'VVVV26',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) - Metric(1,2)*Metric(3,4)')

VVVV27 = Lorentz(name = 'VVVV27',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,3)*Metric(2,4) - Metric(1,2)*Metric(3,4)')

VVVV28 = Lorentz(name = 'VVVV28',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) - (Metric(1,3)*Metric(2,4))/2. - (Metric(1,2)*Metric(3,4))/2.')

VVVV29 = Lorentz(name = 'VVVV29',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,1)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(1,2)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4)')

VVVV30 = Lorentz(name = 'VVVV30',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,4)*P(4,1)*Metric(1,2) - P(3,1)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) + P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(1,2)*P(3,1)*Metric(2,4) + P(1,4)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV31 = Lorentz(name = 'VVVV31',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV32 = Lorentz(name = 'VVVV32',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,4)*P(4,1)*Metric(1,2) + P(3,4)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) - P(2,1)*P(4,3)*Metric(1,3) - P(2,1)*P(3,4)*Metric(1,4) - P(1,2)*P(4,3)*Metric(2,3) - P(1,2)*P(3,4)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV33 = Lorentz(name = 'VVVV33',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) + P(3,4)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,4)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(1,3)*P(4,2)*Metric(2,3) - P(1,4)*P(4,2)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) - P(1,3)*P(3,2)*Metric(2,4) + P(1,4)*P(3,2)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV34 = Lorentz(name = 'VVVV34',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) + (P(3,4)*P(4,1)*Metric(1,2))/2. + P(3,1)*P(4,2)*Metric(1,2) + (P(3,4)*P(4,2)*Metric(1,2))/2. + (P(3,1)*P(4,3)*Metric(1,2))/2. + (P(3,2)*P(4,3)*Metric(1,2))/2. + (P(2,3)*P(4,1)*Metric(1,3))/2. - (P(2,4)*P(4,1)*Metric(1,3))/2. - P(2,1)*P(4,2)*Metric(1,3) - (P(2,3)*P(4,2)*Metric(1,3))/2. - (P(2,1)*P(4,3)*Metric(1,3))/2. - (P(2,3)*P(3,1)*Metric(1,4))/2. + (P(2,4)*P(3,1)*Metric(1,4))/2. - P(2,1)*P(3,2)*Metric(1,4) - (P(2,4)*P(3,2)*Metric(1,4))/2. - (P(2,1)*P(3,4)*Metric(1,4))/2. - P(1,2)*P(4,1)*Metric(2,3) - (P(1,3)*P(4,1)*Metric(2,3))/2. + (P(1,3)*P(4,2)*Metric(2,3))/2. - (P(1,4)*P(4,2)*Metric(2,3))/2. - (P(1,2)*P(4,3)*Metric(2,3))/2. + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + (P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3))/2. - P(1,2)*P(3,1)*Metric(2,4) - (P(1,4)*P(3,1)*Metric(2,4))/2. - (P(1,3)*P(3,2)*Metric(2,4))/2. + (P(1,4)*P(3,2)*Metric(2,4))/2. - (P(1,2)*P(3,4)*Metric(2,4))/2. + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + (P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4))/2. + (P(1,3)*P(2,1)*Metric(3,4))/2. + (P(1,4)*P(2,1)*Metric(3,4))/2. + (P(1,2)*P(2,3)*Metric(3,4))/2. + (P(1,2)*P(2,4)*Metric(3,4))/2. - (P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4))/2. - (P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4))/2. - (P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4))/2.')

VVVV35 = Lorentz(name = 'VVVV35',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,4)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) - P(3,2)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,4)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(1,3)*P(4,2)*Metric(2,3) - P(1,4)*P(4,2)*Metric(2,3) + P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) - P(1,3)*P(3,2)*Metric(2,4) + P(1,4)*P(3,2)*Metric(2,4) + P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) - P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) - P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVSS5 = Lorentz(name = 'VVVSS5',
                 spins = [ 3, 3, 3, 1, 1 ],
                 structure = '-(P(1,2)*P(2,4)*P(3,1)) - P(1,2)*P(2,5)*P(3,1) + P(1,4)*P(2,1)*P(3,2) + P(1,5)*P(2,1)*P(3,2) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3)')

VVVSS6 = Lorentz(name = 'VVVSS6',
                 spins = [ 3, 3, 3, 1, 1 ],
                 structure = '-(P(1,4)*P(2,3)*P(3,1)) - P(1,5)*P(2,3)*P(3,1) - P(1,2)*P(2,4)*P(3,1) - 2*P(1,5)*P(2,4)*P(3,1) - P(1,2)*P(2,5)*P(3,1) - 2*P(1,4)*P(2,5)*P(3,1) + P(1,4)*P(2,1)*P(3,2) + P(1,5)*P(2,1)*P(3,2) + 2*P(1,5)*P(2,4)*P(3,2) + 2*P(1,4)*P(2,5)*P(3,2) + P(1,3)*P(2,1)*P(3,4) + 2*P(1,5)*P(2,1)*P(3,4) - 2*P(1,5)*P(2,3)*P(3,4) - 2*P(1,2)*P(2,5)*P(3,4) + 2*P(1,3)*P(2,5)*P(3,4) + P(1,3)*P(2,1)*P(3,5) + 2*P(1,4)*P(2,1)*P(3,5) - 2*P(1,4)*P(2,3)*P(3,5) - 2*P(1,2)*P(2,4)*P(3,5) + 2*P(1,3)*P(2,4)*P(3,5) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2) + P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2) - 2*P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2) + 2*P(-1,2)*P(-1,5)*P(3,4)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2) - 2*P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2) + 2*P(-1,2)*P(-1,4)*P(3,5)*Metric(1,2) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) + 2*P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3) - 2*P(-1,3)*P(-1,5)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3) + 2*P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3) - 2*P(-1,3)*P(-1,4)*P(2,5)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3) - P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3) - 2*P(-1,2)*P(-1,5)*P(1,4)*Metric(2,3) + 2*P(-1,3)*P(-1,5)*P(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3) + P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3) - 2*P(-1,2)*P(-1,4)*P(1,5)*Metric(2,3) + 2*P(-1,3)*P(-1,4)*P(1,5)*Metric(2,3)')

VVVSS7 = Lorentz(name = 'VVVSS7',
                 spins = [ 3, 3, 3, 1, 1 ],
                 structure = '-(P(1,4)*P(2,3)*P(3,1)) - P(1,5)*P(2,3)*P(3,1) - P(1,2)*P(2,4)*P(3,1) - 2*P(1,5)*P(2,4)*P(3,1) - P(1,2)*P(2,5)*P(3,1) - 2*P(1,4)*P(2,5)*P(3,1) + P(1,4)*P(2,1)*P(3,2) + P(1,5)*P(2,1)*P(3,2) + P(1,3)*P(2,4)*P(3,2) + 2*P(1,5)*P(2,4)*P(3,2) + P(1,3)*P(2,5)*P(3,2) + 2*P(1,4)*P(2,5)*P(3,2) + P(1,3)*P(2,1)*P(3,4) + 2*P(1,5)*P(2,1)*P(3,4) - P(1,2)*P(2,3)*P(3,4) - 2*P(1,5)*P(2,3)*P(3,4) - 2*P(1,2)*P(2,5)*P(3,4) + 2*P(1,3)*P(2,5)*P(3,4) + P(1,3)*P(2,1)*P(3,5) + 2*P(1,4)*P(2,1)*P(3,5) - P(1,2)*P(2,3)*P(3,5) - 2*P(1,4)*P(2,3)*P(3,5) - 2*P(1,2)*P(2,4)*P(3,5) + 2*P(1,3)*P(2,4)*P(3,5) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2) + P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,3)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2) - P(-1,3)*P(-1,5)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2) + P(-1,2)*P(-1,3)*P(3,4)*Metric(1,2) - 2*P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2) + 2*P(-1,2)*P(-1,5)*P(3,4)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2) + P(-1,2)*P(-1,3)*P(3,5)*Metric(1,2) - 2*P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2) + 2*P(-1,2)*P(-1,4)*P(3,5)*Metric(1,2) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,2)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3) + P(-1,2)*P(-1,5)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) - P(-1,2)*P(-1,3)*P(2,4)*Metric(1,3) + 2*P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3) - 2*P(-1,3)*P(-1,5)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3) - P(-1,2)*P(-1,3)*P(2,5)*Metric(1,3) + 2*P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3) - 2*P(-1,3)*P(-1,4)*P(2,5)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,3)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3) + P(-1,3)*P(-1,5)*P(1,2)*Metric(2,3) - P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,2)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3) - 2*P(-1,2)*P(-1,5)*P(1,4)*Metric(2,3) + 2*P(-1,3)*P(-1,5)*P(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3) + P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3) - 2*P(-1,2)*P(-1,4)*P(1,5)*Metric(2,3) + 2*P(-1,3)*P(-1,4)*P(1,5)*Metric(2,3)')

VVVVS17 = Lorentz(name = 'VVVVS17',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)')

VVVVS18 = Lorentz(name = 'VVVVS18',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVS19 = Lorentz(name = 'VVVVS19',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,4)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) - P(3,2)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,4)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(1,3)*P(4,2)*Metric(2,3) - P(1,4)*P(4,2)*Metric(2,3) + P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) - P(1,3)*P(3,2)*Metric(2,4) + P(1,4)*P(3,2)*Metric(2,4) + P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) - P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) - P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVS20 = Lorentz(name = 'VVVVS20',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,5)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,1)*P(4,5)*Metric(1,2) + P(3,2)*P(4,5)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - P(2,5)*P(4,2)*Metric(1,3) - P(2,1)*P(4,5)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - P(2,5)*P(3,2)*Metric(1,4) - P(2,1)*P(3,5)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,5)*P(4,1)*Metric(2,3) - P(1,2)*P(4,5)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,5)*P(3,1)*Metric(2,4) - P(1,2)*P(3,5)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4) + 2*P(1,5)*P(2,1)*Metric(3,4) + 2*P(1,2)*P(2,5)*Metric(3,4) - 2*P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVS21 = Lorentz(name = 'VVVVS21',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,1)*P(4,2)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) + P(2,5)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,5)*P(3,2)*Metric(1,4) - P(2,3)*P(3,5)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) - P(1,5)*P(4,2)*Metric(2,3) - P(1,5)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(1,2)*P(3,1)*Metric(2,4) + P(1,5)*P(3,2)*Metric(2,4) - P(1,2)*P(3,5)*Metric(2,4) + P(1,3)*P(3,5)*Metric(2,4) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,5)*P(2,3)*Metric(3,4) + P(1,2)*P(2,5)*Metric(3,4) - P(1,3)*P(2,5)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVS22 = Lorentz(name = 'VVVVS22',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) + (P(3,4)*P(4,1)*Metric(1,2))/2. + (P(3,5)*P(4,1)*Metric(1,2))/2. + P(3,1)*P(4,2)*Metric(1,2) + (P(3,4)*P(4,2)*Metric(1,2))/2. + (P(3,5)*P(4,2)*Metric(1,2))/2. + (P(3,1)*P(4,3)*Metric(1,2))/2. + (P(3,2)*P(4,3)*Metric(1,2))/2. + (P(3,1)*P(4,5)*Metric(1,2))/2. + (P(3,2)*P(4,5)*Metric(1,2))/2. + (P(2,3)*P(4,1)*Metric(1,3))/2. - (P(2,4)*P(4,1)*Metric(1,3))/2. - P(2,1)*P(4,2)*Metric(1,3) - (P(2,3)*P(4,2)*Metric(1,3))/2. - (P(2,5)*P(4,2)*Metric(1,3))/2. - (P(2,1)*P(4,3)*Metric(1,3))/2. - (P(2,1)*P(4,5)*Metric(1,3))/2. - (P(2,3)*P(3,1)*Metric(1,4))/2. + (P(2,4)*P(3,1)*Metric(1,4))/2. - P(2,1)*P(3,2)*Metric(1,4) - (P(2,4)*P(3,2)*Metric(1,4))/2. - (P(2,5)*P(3,2)*Metric(1,4))/2. - (P(2,1)*P(3,4)*Metric(1,4))/2. - (P(2,1)*P(3,5)*Metric(1,4))/2. - P(1,2)*P(4,1)*Metric(2,3) - (P(1,3)*P(4,1)*Metric(2,3))/2. - (P(1,5)*P(4,1)*Metric(2,3))/2. + (P(1,3)*P(4,2)*Metric(2,3))/2. - (P(1,4)*P(4,2)*Metric(2,3))/2. - (P(1,2)*P(4,3)*Metric(2,3))/2. - (P(1,2)*P(4,5)*Metric(2,3))/2. + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + (P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. - P(1,2)*P(3,1)*Metric(2,4) - (P(1,4)*P(3,1)*Metric(2,4))/2. - (P(1,5)*P(3,1)*Metric(2,4))/2. - (P(1,3)*P(3,2)*Metric(2,4))/2. + (P(1,4)*P(3,2)*Metric(2,4))/2. - (P(1,2)*P(3,4)*Metric(2,4))/2. - (P(1,2)*P(3,5)*Metric(2,4))/2. + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + (P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(1,3)*P(2,1)*Metric(3,4))/2. + (P(1,4)*P(2,1)*Metric(3,4))/2. + P(1,5)*P(2,1)*Metric(3,4) + (P(1,2)*P(2,3)*Metric(3,4))/2. + (P(1,2)*P(2,4)*Metric(3,4))/2. + P(1,2)*P(2,5)*Metric(3,4) - (P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4))/2. - (P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4))/2. - (P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4))/2. - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVS23 = Lorentz(name = 'VVVVS23',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,4)*P(4,1)*Metric(1,2) + P(3,5)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) + P(3,4)*P(4,2)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) + 2*P(3,5)*P(4,3)*Metric(1,2) + P(3,1)*P(4,5)*Metric(1,2) + P(3,2)*P(4,5)*Metric(1,2) + 2*P(3,4)*P(4,5)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(4,2)*Metric(1,3) - P(2,5)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,5)*P(4,3)*Metric(1,3) - P(2,1)*P(4,5)*Metric(1,3) - P(2,4)*P(4,5)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,4)*P(3,2)*Metric(1,4) - P(2,5)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(2,5)*P(3,4)*Metric(1,4) - P(2,1)*P(3,5)*Metric(1,4) - P(2,3)*P(3,5)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) - P(1,5)*P(4,1)*Metric(2,3) + P(1,3)*P(4,2)*Metric(2,3) - P(1,4)*P(4,2)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) - P(1,5)*P(4,3)*Metric(2,3) - P(1,2)*P(4,5)*Metric(2,3) - P(1,4)*P(4,5)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) - P(1,5)*P(3,1)*Metric(2,4) - P(1,3)*P(3,2)*Metric(2,4) + P(1,4)*P(3,2)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) - P(1,5)*P(3,4)*Metric(2,4) - P(1,2)*P(3,5)*Metric(2,4) - P(1,3)*P(3,5)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + 2*P(1,5)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) + P(1,5)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) + P(1,5)*P(2,4)*Metric(3,4) + 2*P(1,2)*P(2,5)*Metric(3,4) + P(1,3)*P(2,5)*Metric(3,4) + P(1,4)*P(2,5)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4) - 2*P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVS24 = Lorentz(name = 'VVVVS24',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,4)*P(4,1)*Metric(1,2) + P(3,5)*P(4,1)*Metric(1,2) - P(3,1)*P(4,2)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,4)*P(4,5)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) + P(2,5)*P(4,1)*Metric(1,3) + P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) + P(2,5)*P(4,3)*Metric(1,3) + P(2,4)*P(4,5)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) - P(2,5)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,5)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - P(2,5)*P(3,4)*Metric(1,4) - P(2,1)*P(3,5)*Metric(1,4) - P(2,3)*P(3,5)*Metric(1,4) - P(2,4)*P(3,5)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) - 2*P(1,5)*P(4,1)*Metric(2,3) - P(1,5)*P(4,2)*Metric(2,3) - P(1,5)*P(4,3)*Metric(2,3) - 2*P(1,4)*P(4,5)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + 2*P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3) + 2*P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(1,2)*P(3,1)*Metric(2,4) + P(1,4)*P(3,1)*Metric(2,4) + P(1,5)*P(3,1)*Metric(2,4) + P(1,5)*P(3,2)*Metric(2,4) - P(1,2)*P(3,5)*Metric(2,4) + P(1,3)*P(3,5)*Metric(2,4) + P(1,4)*P(3,5)*Metric(2,4) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4) - P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,5)*P(2,1)*Metric(3,4) + P(1,5)*P(2,3)*Metric(3,4) + P(1,2)*P(2,5)*Metric(3,4) - P(1,3)*P(2,5)*Metric(3,4) + P(1,4)*P(2,5)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVS25 = Lorentz(name = 'VVVVS25',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,4)*P(4,1)*Metric(1,2) + (P(3,5)*P(4,1)*Metric(1,2))/2. + P(3,4)*P(4,2)*Metric(1,2) + (P(3,5)*P(4,2)*Metric(1,2))/2. + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) + P(3,5)*P(4,3)*Metric(1,2) + (P(3,1)*P(4,5)*Metric(1,2))/2. + (P(3,2)*P(4,5)*Metric(1,2))/2. + P(3,4)*P(4,5)*Metric(1,2) - (P(2,5)*P(4,2)*Metric(1,3))/2. - P(2,1)*P(4,3)*Metric(1,3) - (P(2,5)*P(4,3)*Metric(1,3))/2. - (P(2,1)*P(4,5)*Metric(1,3))/2. - (P(2,4)*P(4,5)*Metric(1,3))/2. - (P(2,5)*P(3,2)*Metric(1,4))/2. - P(2,1)*P(3,4)*Metric(1,4) - (P(2,5)*P(3,4)*Metric(1,4))/2. - (P(2,1)*P(3,5)*Metric(1,4))/2. - (P(2,3)*P(3,5)*Metric(1,4))/2. - (P(1,5)*P(4,1)*Metric(2,3))/2. - P(1,2)*P(4,3)*Metric(2,3) - (P(1,5)*P(4,3)*Metric(2,3))/2. - (P(1,2)*P(4,5)*Metric(2,3))/2. - (P(1,4)*P(4,5)*Metric(2,3))/2. + (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. - (P(1,5)*P(3,1)*Metric(2,4))/2. - P(1,2)*P(3,4)*Metric(2,4) - (P(1,5)*P(3,4)*Metric(2,4))/2. - (P(1,2)*P(3,5)*Metric(2,4))/2. - (P(1,3)*P(3,5)*Metric(2,4))/2. + (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,5)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + (P(1,5)*P(2,3)*Metric(3,4))/2. + P(1,2)*P(2,4)*Metric(3,4) + (P(1,5)*P(2,4)*Metric(3,4))/2. + P(1,2)*P(2,5)*Metric(3,4) + (P(1,3)*P(2,5)*Metric(3,4))/2. + (P(1,4)*P(2,5)*Metric(3,4))/2. - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVV19 = Lorentz(name = 'VVVVV19',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5)')

VVVVV20 = Lorentz(name = 'VVVVV20',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - 3*P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + 3*P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - 2*P(3,4)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) - 3*P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) + 3*P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(3,5)*Metric(1,4)*Metric(2,5) + 3*P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(5,4)*Metric(1,2)*Metric(3,4) - 3*P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + 2*P(2,4)*Metric(1,5)*Metric(3,4) - P(2,5)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) + 3*P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(4,5)*Metric(1,2)*Metric(3,5) - 3*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - P(2,4)*Metric(1,4)*Metric(3,5) + 2*P(2,5)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) - 4*P(3,1)*Metric(1,2)*Metric(4,5) + P(3,4)*Metric(1,2)*Metric(4,5) + P(3,5)*Metric(1,2)*Metric(4,5) + 4*P(2,1)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5)')

VVVVV21 = Lorentz(name = 'VVVVV21',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + (P(5,4)*Metric(1,3)*Metric(2,4))/2. + 2*P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(3,4)*Metric(1,5)*Metric(2,4) + (P(3,5)*Metric(1,5)*Metric(2,4))/2. - 2*P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + (P(4,5)*Metric(1,3)*Metric(2,5))/2. + 2*P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + (P(3,4)*Metric(1,4)*Metric(2,5))/2. - P(3,5)*Metric(1,4)*Metric(2,5) + 2*P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - (P(5,4)*Metric(1,2)*Metric(3,4))/2. - 2*P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + P(2,4)*Metric(1,5)*Metric(3,4) - (P(2,5)*Metric(1,5)*Metric(3,4))/2. + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - (P(1,4)*Metric(2,5)*Metric(3,4))/2. + (P(1,5)*Metric(2,5)*Metric(3,4))/2. + 2*P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - (P(4,5)*Metric(1,2)*Metric(3,5))/2. - 2*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - (P(2,4)*Metric(1,4)*Metric(3,5))/2. + P(2,5)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5) + (P(1,4)*Metric(2,4)*Metric(3,5))/2. - (P(1,5)*Metric(2,4)*Metric(3,5))/2. - 2*P(3,1)*Metric(1,2)*Metric(4,5) + (P(3,4)*Metric(1,2)*Metric(4,5))/2. + (P(3,5)*Metric(1,2)*Metric(4,5))/2. + 2*P(2,1)*Metric(1,3)*Metric(4,5) - (P(2,4)*Metric(1,3)*Metric(4,5))/2. - (P(2,5)*Metric(1,3)*Metric(4,5))/2.')

VVVVV22 = Lorentz(name = 'VVVVV22',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,4)*Metric(2,3) - P(5,2)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + 2*P(4,2)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - 2*P(3,2)*Metric(1,5)*Metric(2,4) + 2*P(4,1)*Metric(1,3)*Metric(2,5) - P(4,2)*Metric(1,3)*Metric(2,5) - 2*P(3,1)*Metric(1,4)*Metric(2,5) + P(3,2)*Metric(1,4)*Metric(2,5) - P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5)')

VVVVV23 = Lorentz(name = 'VVVVV23',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(5,1)*Metric(1,2)*Metric(3,4) - 2*P(5,2)*Metric(1,2)*Metric(3,4) + 2*P(5,3)*Metric(1,2)*Metric(3,4) + 2*P(5,4)*Metric(1,2)*Metric(3,4) + 2*P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 2*P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) - 2*P(4,3)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) - 2*P(3,4)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5)')

VVVVV24 = Lorentz(name = 'VVVVV24',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - 2*P(5,1)*Metric(1,2)*Metric(3,4) + 2*P(5,2)*Metric(1,2)*Metric(3,4) + 2*P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) - 2*P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 2*P(4,1)*Metric(1,2)*Metric(3,5) + 2*P(4,2)*Metric(1,2)*Metric(3,5) + 2*P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) - 2*P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - 2*P(3,1)*Metric(1,2)*Metric(4,5) + 2*P(3,2)*Metric(1,2)*Metric(4,5) + 2*P(2,1)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV25 = Lorentz(name = 'VVVVV25',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - (2*P(5,1)*Metric(1,2)*Metric(3,4))/3. + (2*P(5,2)*Metric(1,2)*Metric(3,4))/3. + (2*P(2,1)*Metric(1,5)*Metric(3,4))/3. - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + (4*P(2,5)*Metric(1,5)*Metric(3,4))/3. - (2*P(1,2)*Metric(2,5)*Metric(3,4))/3. + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - (4*P(1,5)*Metric(2,5)*Metric(3,4))/3. - (2*P(4,1)*Metric(1,2)*Metric(3,5))/3. + (2*P(4,2)*Metric(1,2)*Metric(3,5))/3. + (2*P(2,1)*Metric(1,4)*Metric(3,5))/3. - P(2,3)*Metric(1,4)*Metric(3,5) + (4*P(2,4)*Metric(1,4)*Metric(3,5))/3. - P(2,5)*Metric(1,4)*Metric(3,5) - (2*P(1,2)*Metric(2,4)*Metric(3,5))/3. + P(1,3)*Metric(2,4)*Metric(3,5) - (4*P(1,4)*Metric(2,4)*Metric(3,5))/3. + P(1,5)*Metric(2,4)*Metric(3,5) - (2*P(3,1)*Metric(1,2)*Metric(4,5))/3. + (2*P(3,2)*Metric(1,2)*Metric(4,5))/3. + (2*P(2,1)*Metric(1,3)*Metric(4,5))/3. + (4*P(2,3)*Metric(1,3)*Metric(4,5))/3. - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - (2*P(1,2)*Metric(2,3)*Metric(4,5))/3. - (4*P(1,3)*Metric(2,3)*Metric(4,5))/3. + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV26 = Lorentz(name = 'VVVVV26',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(5,2)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(2,5)*Metric(1,5)*Metric(3,4) - P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) + P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) + P(2,1)*Metric(1,3)*Metric(4,5) + P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV27 = Lorentz(name = 'VVVVV27',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + 3*P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + 3*P(3,4)*Metric(1,5)*Metric(2,4) - 2*P(3,5)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) + 3*P(4,3)*Metric(1,3)*Metric(2,5) - 2*P(4,5)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + 3*P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(3,5)*Metric(1,4)*Metric(2,5) - 6*P(5,1)*Metric(1,2)*Metric(3,4) - 6*P(5,2)*Metric(1,2)*Metric(3,4) + 6*P(5,3)*Metric(1,2)*Metric(3,4) + 6*P(5,4)*Metric(1,2)*Metric(3,4) + 6*P(2,1)*Metric(1,5)*Metric(3,4) - 3*P(2,3)*Metric(1,5)*Metric(3,4) - 3*P(2,4)*Metric(1,5)*Metric(3,4) + 6*P(1,2)*Metric(2,5)*Metric(3,4) - 3*P(1,3)*Metric(2,5)*Metric(3,4) - 3*P(1,4)*Metric(2,5)*Metric(3,4) + 3*P(4,1)*Metric(1,2)*Metric(3,5) + 3*P(4,2)*Metric(1,2)*Metric(3,5) - 6*P(4,3)*Metric(1,2)*Metric(3,5) - 3*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(2,5)*Metric(1,4)*Metric(3,5) - 3*P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + 2*P(1,5)*Metric(2,4)*Metric(3,5) + 3*P(3,1)*Metric(1,2)*Metric(4,5) + 3*P(3,2)*Metric(1,2)*Metric(4,5) - 6*P(3,4)*Metric(1,2)*Metric(4,5) - 3*P(2,1)*Metric(1,3)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) + 2*P(2,5)*Metric(1,3)*Metric(4,5) - 3*P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV28 = Lorentz(name = 'VVVVV28',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,2)*Metric(1,4)*Metric(2,3) + P(5,3)*Metric(1,4)*Metric(2,3) - 2*P(5,4)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(5,4)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(4,5)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(3,2)*Metric(1,2)*Metric(4,5) - P(3,4)*Metric(1,2)*Metric(4,5) - P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,2)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*Metric(2,3)*Metric(4,5) + 2*P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVSS17 = Lorentz(name = 'VVVVSS17',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)')

VVVVSS18 = Lorentz(name = 'VVVVSS18',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVSS19 = Lorentz(name = 'VVVVSS19',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,4)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) - P(3,2)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,4)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(1,3)*P(4,2)*Metric(2,3) - P(1,4)*P(4,2)*Metric(2,3) + P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) - P(1,3)*P(3,2)*Metric(2,4) + P(1,4)*P(3,2)*Metric(2,4) + P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) - P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) - P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVSS20 = Lorentz(name = 'VVVVSS20',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,5)*P(4,1)*Metric(1,2) + P(3,6)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,6)*P(4,2)*Metric(1,2) + P(3,1)*P(4,5)*Metric(1,2) + P(3,2)*P(4,5)*Metric(1,2) + 4*P(3,6)*P(4,5)*Metric(1,2) + P(3,1)*P(4,6)*Metric(1,2) + P(3,2)*P(4,6)*Metric(1,2) + 4*P(3,5)*P(4,6)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - P(2,5)*P(4,2)*Metric(1,3) - P(2,6)*P(4,2)*Metric(1,3) - P(2,1)*P(4,5)*Metric(1,3) - 2*P(2,6)*P(4,5)*Metric(1,3) - P(2,1)*P(4,6)*Metric(1,3) - 2*P(2,5)*P(4,6)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - P(2,5)*P(3,2)*Metric(1,4) - P(2,6)*P(3,2)*Metric(1,4) - P(2,1)*P(3,5)*Metric(1,4) - 2*P(2,6)*P(3,5)*Metric(1,4) - P(2,1)*P(3,6)*Metric(1,4) - 2*P(2,5)*P(3,6)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,5)*P(4,1)*Metric(2,3) - P(1,6)*P(4,1)*Metric(2,3) - P(1,2)*P(4,5)*Metric(2,3) - 2*P(1,6)*P(4,5)*Metric(2,3) - P(1,2)*P(4,6)*Metric(2,3) - 2*P(1,5)*P(4,6)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,5)*P(3,1)*Metric(2,4) - P(1,6)*P(3,1)*Metric(2,4) - P(1,2)*P(3,5)*Metric(2,4) - 2*P(1,6)*P(3,5)*Metric(2,4) - P(1,2)*P(3,6)*Metric(2,4) - 2*P(1,5)*P(3,6)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4) + 2*P(1,5)*P(2,1)*Metric(3,4) + 2*P(1,6)*P(2,1)*Metric(3,4) + 2*P(1,2)*P(2,5)*Metric(3,4) + 4*P(1,6)*P(2,5)*Metric(3,4) + 2*P(1,2)*P(2,6)*Metric(3,4) + 4*P(1,5)*P(2,6)*Metric(3,4) - 2*P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4) - 2*P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS21 = Lorentz(name = 'VVVVSS21',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,1)*P(4,2)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,6)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) + P(2,5)*P(4,3)*Metric(1,3) + P(2,6)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,5)*P(3,2)*Metric(1,4) - P(2,6)*P(3,2)*Metric(1,4) - P(2,3)*P(3,5)*Metric(1,4) - P(2,3)*P(3,6)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) - P(1,5)*P(4,2)*Metric(2,3) - P(1,6)*P(4,2)*Metric(2,3) - P(1,5)*P(4,3)*Metric(2,3) - P(1,6)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(1,2)*P(3,1)*Metric(2,4) + P(1,5)*P(3,2)*Metric(2,4) + P(1,6)*P(3,2)*Metric(2,4) - P(1,2)*P(3,5)*Metric(2,4) + P(1,3)*P(3,5)*Metric(2,4) - P(1,2)*P(3,6)*Metric(2,4) + P(1,3)*P(3,6)*Metric(2,4) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,5)*P(2,3)*Metric(3,4) + P(1,6)*P(2,3)*Metric(3,4) + P(1,2)*P(2,5)*Metric(3,4) - P(1,3)*P(2,5)*Metric(3,4) + P(1,2)*P(2,6)*Metric(3,4) - P(1,3)*P(2,6)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS22 = Lorentz(name = 'VVVVSS22',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) + (P(3,4)*P(4,1)*Metric(1,2))/2. + (P(3,5)*P(4,1)*Metric(1,2))/2. + (P(3,6)*P(4,1)*Metric(1,2))/2. + P(3,1)*P(4,2)*Metric(1,2) + (P(3,4)*P(4,2)*Metric(1,2))/2. + (P(3,5)*P(4,2)*Metric(1,2))/2. + (P(3,6)*P(4,2)*Metric(1,2))/2. + (P(3,1)*P(4,3)*Metric(1,2))/2. + (P(3,2)*P(4,3)*Metric(1,2))/2. + (P(3,1)*P(4,5)*Metric(1,2))/2. + (P(3,2)*P(4,5)*Metric(1,2))/2. + (P(3,1)*P(4,6)*Metric(1,2))/2. + (P(3,2)*P(4,6)*Metric(1,2))/2. + (P(2,3)*P(4,1)*Metric(1,3))/2. - (P(2,4)*P(4,1)*Metric(1,3))/2. - P(2,1)*P(4,2)*Metric(1,3) - (P(2,3)*P(4,2)*Metric(1,3))/2. - (P(2,5)*P(4,2)*Metric(1,3))/2. - (P(2,6)*P(4,2)*Metric(1,3))/2. - (P(2,1)*P(4,3)*Metric(1,3))/2. - (P(2,1)*P(4,5)*Metric(1,3))/2. - (P(2,1)*P(4,6)*Metric(1,3))/2. - (P(2,3)*P(3,1)*Metric(1,4))/2. + (P(2,4)*P(3,1)*Metric(1,4))/2. - P(2,1)*P(3,2)*Metric(1,4) - (P(2,4)*P(3,2)*Metric(1,4))/2. - (P(2,5)*P(3,2)*Metric(1,4))/2. - (P(2,6)*P(3,2)*Metric(1,4))/2. - (P(2,1)*P(3,4)*Metric(1,4))/2. - (P(2,1)*P(3,5)*Metric(1,4))/2. - (P(2,1)*P(3,6)*Metric(1,4))/2. - P(1,2)*P(4,1)*Metric(2,3) - (P(1,3)*P(4,1)*Metric(2,3))/2. - (P(1,5)*P(4,1)*Metric(2,3))/2. - (P(1,6)*P(4,1)*Metric(2,3))/2. + (P(1,3)*P(4,2)*Metric(2,3))/2. - (P(1,4)*P(4,2)*Metric(2,3))/2. - (P(1,2)*P(4,3)*Metric(2,3))/2. - (P(1,2)*P(4,5)*Metric(2,3))/2. - (P(1,2)*P(4,6)*Metric(2,3))/2. + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + (P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. - P(1,2)*P(3,1)*Metric(2,4) - (P(1,4)*P(3,1)*Metric(2,4))/2. - (P(1,5)*P(3,1)*Metric(2,4))/2. - (P(1,6)*P(3,1)*Metric(2,4))/2. - (P(1,3)*P(3,2)*Metric(2,4))/2. + (P(1,4)*P(3,2)*Metric(2,4))/2. - (P(1,2)*P(3,4)*Metric(2,4))/2. - (P(1,2)*P(3,5)*Metric(2,4))/2. - (P(1,2)*P(3,6)*Metric(2,4))/2. + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + (P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + (P(1,3)*P(2,1)*Metric(3,4))/2. + (P(1,4)*P(2,1)*Metric(3,4))/2. + P(1,5)*P(2,1)*Metric(3,4) + P(1,6)*P(2,1)*Metric(3,4) + (P(1,2)*P(2,3)*Metric(3,4))/2. + (P(1,2)*P(2,4)*Metric(3,4))/2. + P(1,2)*P(2,5)*Metric(3,4) + P(1,2)*P(2,6)*Metric(3,4) - (P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4))/2. - (P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4))/2. - (P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4))/2. - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS23 = Lorentz(name = 'VVVVSS23',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,4)*P(4,1)*Metric(1,2) + P(3,5)*P(4,1)*Metric(1,2) + P(3,6)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) + P(3,4)*P(4,2)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,6)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) + 2*P(3,5)*P(4,3)*Metric(1,2) + 2*P(3,6)*P(4,3)*Metric(1,2) + P(3,1)*P(4,5)*Metric(1,2) + P(3,2)*P(4,5)*Metric(1,2) + 2*P(3,4)*P(4,5)*Metric(1,2) + 4*P(3,6)*P(4,5)*Metric(1,2) + P(3,1)*P(4,6)*Metric(1,2) + P(3,2)*P(4,6)*Metric(1,2) + 2*P(3,4)*P(4,6)*Metric(1,2) + 4*P(3,5)*P(4,6)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(4,2)*Metric(1,3) - P(2,5)*P(4,2)*Metric(1,3) - P(2,6)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,5)*P(4,3)*Metric(1,3) - P(2,6)*P(4,3)*Metric(1,3) - P(2,1)*P(4,5)*Metric(1,3) - P(2,4)*P(4,5)*Metric(1,3) - 2*P(2,6)*P(4,5)*Metric(1,3) - P(2,1)*P(4,6)*Metric(1,3) - P(2,4)*P(4,6)*Metric(1,3) - 2*P(2,5)*P(4,6)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,4)*P(3,2)*Metric(1,4) - P(2,5)*P(3,2)*Metric(1,4) - P(2,6)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(2,5)*P(3,4)*Metric(1,4) - P(2,6)*P(3,4)*Metric(1,4) - P(2,1)*P(3,5)*Metric(1,4) - P(2,3)*P(3,5)*Metric(1,4) - 2*P(2,6)*P(3,5)*Metric(1,4) - P(2,1)*P(3,6)*Metric(1,4) - P(2,3)*P(3,6)*Metric(1,4) - 2*P(2,5)*P(3,6)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) - P(1,5)*P(4,1)*Metric(2,3) - P(1,6)*P(4,1)*Metric(2,3) + P(1,3)*P(4,2)*Metric(2,3) - P(1,4)*P(4,2)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) - P(1,5)*P(4,3)*Metric(2,3) - P(1,6)*P(4,3)*Metric(2,3) - P(1,2)*P(4,5)*Metric(2,3) - P(1,4)*P(4,5)*Metric(2,3) - 2*P(1,6)*P(4,5)*Metric(2,3) - P(1,2)*P(4,6)*Metric(2,3) - P(1,4)*P(4,6)*Metric(2,3) - 2*P(1,5)*P(4,6)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) - P(1,5)*P(3,1)*Metric(2,4) - P(1,6)*P(3,1)*Metric(2,4) - P(1,3)*P(3,2)*Metric(2,4) + P(1,4)*P(3,2)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) - P(1,5)*P(3,4)*Metric(2,4) - P(1,6)*P(3,4)*Metric(2,4) - P(1,2)*P(3,5)*Metric(2,4) - P(1,3)*P(3,5)*Metric(2,4) - 2*P(1,6)*P(3,5)*Metric(2,4) - P(1,2)*P(3,6)*Metric(2,4) - P(1,3)*P(3,6)*Metric(2,4) - 2*P(1,5)*P(3,6)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + 2*P(1,5)*P(2,1)*Metric(3,4) + 2*P(1,6)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) + P(1,5)*P(2,3)*Metric(3,4) + P(1,6)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) + P(1,5)*P(2,4)*Metric(3,4) + P(1,6)*P(2,4)*Metric(3,4) + 2*P(1,2)*P(2,5)*Metric(3,4) + P(1,3)*P(2,5)*Metric(3,4) + P(1,4)*P(2,5)*Metric(3,4) + 4*P(1,6)*P(2,5)*Metric(3,4) + 2*P(1,2)*P(2,6)*Metric(3,4) + P(1,3)*P(2,6)*Metric(3,4) + P(1,4)*P(2,6)*Metric(3,4) + 4*P(1,5)*P(2,6)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4) - 2*P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4) - 2*P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4) - 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4) - 2*P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS24 = Lorentz(name = 'VVVVSS24',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,4)*P(4,1)*Metric(1,2) + P(3,5)*P(4,1)*Metric(1,2) + P(3,6)*P(4,1)*Metric(1,2) - P(3,1)*P(4,2)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,6)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,4)*P(4,5)*Metric(1,2) + 2*P(3,6)*P(4,5)*Metric(1,2) + P(3,4)*P(4,6)*Metric(1,2) + 2*P(3,5)*P(4,6)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) + P(2,5)*P(4,1)*Metric(1,3) + P(2,6)*P(4,1)*Metric(1,3) + P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) + P(2,5)*P(4,3)*Metric(1,3) + P(2,6)*P(4,3)*Metric(1,3) + P(2,4)*P(4,5)*Metric(1,3) + 2*P(2,6)*P(4,5)*Metric(1,3) + P(2,4)*P(4,6)*Metric(1,3) + 2*P(2,5)*P(4,6)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) - P(2,5)*P(3,1)*Metric(1,4) - P(2,6)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,5)*P(3,2)*Metric(1,4) - P(2,6)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - P(2,5)*P(3,4)*Metric(1,4) - P(2,6)*P(3,4)*Metric(1,4) - P(2,1)*P(3,5)*Metric(1,4) - P(2,3)*P(3,5)*Metric(1,4) - P(2,4)*P(3,5)*Metric(1,4) - 4*P(2,6)*P(3,5)*Metric(1,4) - P(2,1)*P(3,6)*Metric(1,4) - P(2,3)*P(3,6)*Metric(1,4) - P(2,4)*P(3,6)*Metric(1,4) - 4*P(2,5)*P(3,6)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) - 2*P(1,5)*P(4,1)*Metric(2,3) - 2*P(1,6)*P(4,1)*Metric(2,3) - P(1,5)*P(4,2)*Metric(2,3) - P(1,6)*P(4,2)*Metric(2,3) - P(1,5)*P(4,3)*Metric(2,3) - P(1,6)*P(4,3)*Metric(2,3) - 2*P(1,4)*P(4,5)*Metric(2,3) - 4*P(1,6)*P(4,5)*Metric(2,3) - 2*P(1,4)*P(4,6)*Metric(2,3) - 4*P(1,5)*P(4,6)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + 2*P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3) + 2*P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3) + 2*P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3) + 2*P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(1,2)*P(3,1)*Metric(2,4) + P(1,4)*P(3,1)*Metric(2,4) + P(1,5)*P(3,1)*Metric(2,4) + P(1,6)*P(3,1)*Metric(2,4) + P(1,5)*P(3,2)*Metric(2,4) + P(1,6)*P(3,2)*Metric(2,4) - P(1,2)*P(3,5)*Metric(2,4) + P(1,3)*P(3,5)*Metric(2,4) + P(1,4)*P(3,5)*Metric(2,4) + 2*P(1,6)*P(3,5)*Metric(2,4) - P(1,2)*P(3,6)*Metric(2,4) + P(1,3)*P(3,6)*Metric(2,4) + P(1,4)*P(3,6)*Metric(2,4) + 2*P(1,5)*P(3,6)*Metric(2,4) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4) - P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4) - P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,5)*P(2,1)*Metric(3,4) + P(1,6)*P(2,1)*Metric(3,4) + P(1,5)*P(2,3)*Metric(3,4) + P(1,6)*P(2,3)*Metric(3,4) + P(1,2)*P(2,5)*Metric(3,4) - P(1,3)*P(2,5)*Metric(3,4) + P(1,4)*P(2,5)*Metric(3,4) + 2*P(1,6)*P(2,5)*Metric(3,4) + P(1,2)*P(2,6)*Metric(3,4) - P(1,3)*P(2,6)*Metric(3,4) + P(1,4)*P(2,6)*Metric(3,4) + 2*P(1,5)*P(2,6)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS25 = Lorentz(name = 'VVVVSS25',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,4)*P(4,1)*Metric(1,2) + (P(3,5)*P(4,1)*Metric(1,2))/2. + (P(3,6)*P(4,1)*Metric(1,2))/2. + P(3,4)*P(4,2)*Metric(1,2) + (P(3,5)*P(4,2)*Metric(1,2))/2. + (P(3,6)*P(4,2)*Metric(1,2))/2. + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) + P(3,5)*P(4,3)*Metric(1,2) + P(3,6)*P(4,3)*Metric(1,2) + (P(3,1)*P(4,5)*Metric(1,2))/2. + (P(3,2)*P(4,5)*Metric(1,2))/2. + P(3,4)*P(4,5)*Metric(1,2) + 2*P(3,6)*P(4,5)*Metric(1,2) + (P(3,1)*P(4,6)*Metric(1,2))/2. + (P(3,2)*P(4,6)*Metric(1,2))/2. + P(3,4)*P(4,6)*Metric(1,2) + 2*P(3,5)*P(4,6)*Metric(1,2) - (P(2,5)*P(4,2)*Metric(1,3))/2. - (P(2,6)*P(4,2)*Metric(1,3))/2. - P(2,1)*P(4,3)*Metric(1,3) - (P(2,5)*P(4,3)*Metric(1,3))/2. - (P(2,6)*P(4,3)*Metric(1,3))/2. - (P(2,1)*P(4,5)*Metric(1,3))/2. - (P(2,4)*P(4,5)*Metric(1,3))/2. - P(2,6)*P(4,5)*Metric(1,3) - (P(2,1)*P(4,6)*Metric(1,3))/2. - (P(2,4)*P(4,6)*Metric(1,3))/2. - P(2,5)*P(4,6)*Metric(1,3) - (P(2,5)*P(3,2)*Metric(1,4))/2. - (P(2,6)*P(3,2)*Metric(1,4))/2. - P(2,1)*P(3,4)*Metric(1,4) - (P(2,5)*P(3,4)*Metric(1,4))/2. - (P(2,6)*P(3,4)*Metric(1,4))/2. - (P(2,1)*P(3,5)*Metric(1,4))/2. - (P(2,3)*P(3,5)*Metric(1,4))/2. - P(2,6)*P(3,5)*Metric(1,4) - (P(2,1)*P(3,6)*Metric(1,4))/2. - (P(2,3)*P(3,6)*Metric(1,4))/2. - P(2,5)*P(3,6)*Metric(1,4) - (P(1,5)*P(4,1)*Metric(2,3))/2. - (P(1,6)*P(4,1)*Metric(2,3))/2. - P(1,2)*P(4,3)*Metric(2,3) - (P(1,5)*P(4,3)*Metric(2,3))/2. - (P(1,6)*P(4,3)*Metric(2,3))/2. - (P(1,2)*P(4,5)*Metric(2,3))/2. - (P(1,4)*P(4,5)*Metric(2,3))/2. - P(1,6)*P(4,5)*Metric(2,3) - (P(1,2)*P(4,6)*Metric(2,3))/2. - (P(1,4)*P(4,6)*Metric(2,3))/2. - P(1,5)*P(4,6)*Metric(2,3) + (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. + (P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. + (P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. - (P(1,5)*P(3,1)*Metric(2,4))/2. - (P(1,6)*P(3,1)*Metric(2,4))/2. - P(1,2)*P(3,4)*Metric(2,4) - (P(1,5)*P(3,4)*Metric(2,4))/2. - (P(1,6)*P(3,4)*Metric(2,4))/2. - (P(1,2)*P(3,5)*Metric(2,4))/2. - (P(1,3)*P(3,5)*Metric(2,4))/2. - P(1,6)*P(3,5)*Metric(2,4) - (P(1,2)*P(3,6)*Metric(2,4))/2. - (P(1,3)*P(3,6)*Metric(2,4))/2. - P(1,5)*P(3,6)*Metric(2,4) + (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + (P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + (P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,5)*P(2,1)*Metric(3,4) + P(1,6)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + (P(1,5)*P(2,3)*Metric(3,4))/2. + (P(1,6)*P(2,3)*Metric(3,4))/2. + P(1,2)*P(2,4)*Metric(3,4) + (P(1,5)*P(2,4)*Metric(3,4))/2. + (P(1,6)*P(2,4)*Metric(3,4))/2. + P(1,2)*P(2,5)*Metric(3,4) + (P(1,3)*P(2,5)*Metric(3,4))/2. + (P(1,4)*P(2,5)*Metric(3,4))/2. + 2*P(1,6)*P(2,5)*Metric(3,4) + P(1,2)*P(2,6)*Metric(3,4) + (P(1,3)*P(2,6)*Metric(3,4))/2. + (P(1,4)*P(2,6)*Metric(3,4))/2. + 2*P(1,5)*P(2,6)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVVS19 = Lorentz(name = 'VVVVVS19',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5)')

VVVVVS20 = Lorentz(name = 'VVVVVS20',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - 3*P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(5,6)*Metric(1,3)*Metric(2,4) + 3*P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - 2*P(3,4)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) - P(3,6)*Metric(1,5)*Metric(2,4) - 3*P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) + P(4,6)*Metric(1,3)*Metric(2,5) + 3*P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(3,5)*Metric(1,4)*Metric(2,5) - P(3,6)*Metric(1,4)*Metric(2,5) + 3*P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(5,4)*Metric(1,2)*Metric(3,4) - P(5,6)*Metric(1,2)*Metric(3,4) - 3*P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + 2*P(2,4)*Metric(1,5)*Metric(3,4) - P(2,5)*Metric(1,5)*Metric(3,4) + P(2,6)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) + 3*P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(4,5)*Metric(1,2)*Metric(3,5) - P(4,6)*Metric(1,2)*Metric(3,5) - 3*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - P(2,4)*Metric(1,4)*Metric(3,5) + 2*P(2,5)*Metric(1,4)*Metric(3,5) + P(2,6)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) - 4*P(3,1)*Metric(1,2)*Metric(4,5) + P(3,4)*Metric(1,2)*Metric(4,5) + P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(3,6)*Metric(1,2)*Metric(4,5) + 4*P(2,1)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(2,6)*Metric(1,3)*Metric(4,5)')

VVVVVS21 = Lorentz(name = 'VVVVVS21',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + (P(5,4)*Metric(1,3)*Metric(2,4))/2. + (P(5,6)*Metric(1,3)*Metric(2,4))/2. + 2*P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(3,4)*Metric(1,5)*Metric(2,4) + (P(3,5)*Metric(1,5)*Metric(2,4))/2. - (P(3,6)*Metric(1,5)*Metric(2,4))/2. - 2*P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + (P(4,5)*Metric(1,3)*Metric(2,5))/2. + (P(4,6)*Metric(1,3)*Metric(2,5))/2. + 2*P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + (P(3,4)*Metric(1,4)*Metric(2,5))/2. - P(3,5)*Metric(1,4)*Metric(2,5) - (P(3,6)*Metric(1,4)*Metric(2,5))/2. + 2*P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - (P(5,4)*Metric(1,2)*Metric(3,4))/2. - (P(5,6)*Metric(1,2)*Metric(3,4))/2. - 2*P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + P(2,4)*Metric(1,5)*Metric(3,4) - (P(2,5)*Metric(1,5)*Metric(3,4))/2. + (P(2,6)*Metric(1,5)*Metric(3,4))/2. + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - (P(1,4)*Metric(2,5)*Metric(3,4))/2. + (P(1,5)*Metric(2,5)*Metric(3,4))/2. + 2*P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - (P(4,5)*Metric(1,2)*Metric(3,5))/2. - (P(4,6)*Metric(1,2)*Metric(3,5))/2. - 2*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - (P(2,4)*Metric(1,4)*Metric(3,5))/2. + P(2,5)*Metric(1,4)*Metric(3,5) + (P(2,6)*Metric(1,4)*Metric(3,5))/2. + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5) + (P(1,4)*Metric(2,4)*Metric(3,5))/2. - (P(1,5)*Metric(2,4)*Metric(3,5))/2. - 2*P(3,1)*Metric(1,2)*Metric(4,5) + (P(3,4)*Metric(1,2)*Metric(4,5))/2. + (P(3,5)*Metric(1,2)*Metric(4,5))/2. + P(3,6)*Metric(1,2)*Metric(4,5) + 2*P(2,1)*Metric(1,3)*Metric(4,5) - (P(2,4)*Metric(1,3)*Metric(4,5))/2. - (P(2,5)*Metric(1,3)*Metric(4,5))/2. - P(2,6)*Metric(1,3)*Metric(4,5)')

VVVVVS22 = Lorentz(name = 'VVVVVS22',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(5,1)*Metric(1,2)*Metric(3,4) - 2*P(5,2)*Metric(1,2)*Metric(3,4) + 2*P(5,3)*Metric(1,2)*Metric(3,4) + 2*P(5,4)*Metric(1,2)*Metric(3,4) + 2*P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 2*P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) - 2*P(4,3)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) - 2*P(3,4)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5)')

VVVVVS23 = Lorentz(name = 'VVVVVS23',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - 2*P(5,1)*Metric(1,2)*Metric(3,4) + 2*P(5,2)*Metric(1,2)*Metric(3,4) + 2*P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) - 2*P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 2*P(4,1)*Metric(1,2)*Metric(3,5) + 2*P(4,2)*Metric(1,2)*Metric(3,5) + 2*P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) - 2*P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - 2*P(3,1)*Metric(1,2)*Metric(4,5) + 2*P(3,2)*Metric(1,2)*Metric(4,5) + 2*P(2,1)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS24 = Lorentz(name = 'VVVVVS24',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - (2*P(5,1)*Metric(1,2)*Metric(3,4))/3. + (2*P(5,2)*Metric(1,2)*Metric(3,4))/3. + (2*P(2,1)*Metric(1,5)*Metric(3,4))/3. - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + (4*P(2,5)*Metric(1,5)*Metric(3,4))/3. - (2*P(1,2)*Metric(2,5)*Metric(3,4))/3. + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - (4*P(1,5)*Metric(2,5)*Metric(3,4))/3. - (2*P(4,1)*Metric(1,2)*Metric(3,5))/3. + (2*P(4,2)*Metric(1,2)*Metric(3,5))/3. + (2*P(2,1)*Metric(1,4)*Metric(3,5))/3. - P(2,3)*Metric(1,4)*Metric(3,5) + (4*P(2,4)*Metric(1,4)*Metric(3,5))/3. - P(2,5)*Metric(1,4)*Metric(3,5) - (2*P(1,2)*Metric(2,4)*Metric(3,5))/3. + P(1,3)*Metric(2,4)*Metric(3,5) - (4*P(1,4)*Metric(2,4)*Metric(3,5))/3. + P(1,5)*Metric(2,4)*Metric(3,5) - (2*P(3,1)*Metric(1,2)*Metric(4,5))/3. + (2*P(3,2)*Metric(1,2)*Metric(4,5))/3. + (2*P(2,1)*Metric(1,3)*Metric(4,5))/3. + (4*P(2,3)*Metric(1,3)*Metric(4,5))/3. - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - (2*P(1,2)*Metric(2,3)*Metric(4,5))/3. - (4*P(1,3)*Metric(2,3)*Metric(4,5))/3. + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS25 = Lorentz(name = 'VVVVVS25',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(5,2)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(2,5)*Metric(1,5)*Metric(3,4) - P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) + P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) + P(2,1)*Metric(1,3)*Metric(4,5) + P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS26 = Lorentz(name = 'VVVVVS26',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + 3*P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + 3*P(3,4)*Metric(1,5)*Metric(2,4) - 2*P(3,5)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) + 3*P(4,3)*Metric(1,3)*Metric(2,5) - 2*P(4,5)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + 3*P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(3,5)*Metric(1,4)*Metric(2,5) - 6*P(5,1)*Metric(1,2)*Metric(3,4) - 6*P(5,2)*Metric(1,2)*Metric(3,4) + 6*P(5,3)*Metric(1,2)*Metric(3,4) + 6*P(5,4)*Metric(1,2)*Metric(3,4) + 6*P(2,1)*Metric(1,5)*Metric(3,4) - 3*P(2,3)*Metric(1,5)*Metric(3,4) - 3*P(2,4)*Metric(1,5)*Metric(3,4) + 6*P(1,2)*Metric(2,5)*Metric(3,4) - 3*P(1,3)*Metric(2,5)*Metric(3,4) - 3*P(1,4)*Metric(2,5)*Metric(3,4) + 3*P(4,1)*Metric(1,2)*Metric(3,5) + 3*P(4,2)*Metric(1,2)*Metric(3,5) - 6*P(4,3)*Metric(1,2)*Metric(3,5) - 3*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(2,5)*Metric(1,4)*Metric(3,5) - 3*P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + 2*P(1,5)*Metric(2,4)*Metric(3,5) + 3*P(3,1)*Metric(1,2)*Metric(4,5) + 3*P(3,2)*Metric(1,2)*Metric(4,5) - 6*P(3,4)*Metric(1,2)*Metric(4,5) - 3*P(2,1)*Metric(1,3)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) + 2*P(2,5)*Metric(1,3)*Metric(4,5) - 3*P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS27 = Lorentz(name = 'VVVVVS27',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,2)*Metric(1,4)*Metric(2,3) + P(5,3)*Metric(1,4)*Metric(2,3) - 2*P(5,4)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(5,4)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(4,5)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(3,2)*Metric(1,2)*Metric(4,5) - P(3,4)*Metric(1,2)*Metric(4,5) - P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,2)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*Metric(2,3)*Metric(4,5) + 2*P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS28 = Lorentz(name = 'VVVVVS28',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,1)*Metric(1,4)*Metric(2,3) - P(5,2)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + 2*P(4,2)*Metric(1,5)*Metric(2,3) - P(4,6)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - 2*P(3,2)*Metric(1,5)*Metric(2,4) + P(3,6)*Metric(1,5)*Metric(2,4) + 2*P(4,1)*Metric(1,3)*Metric(2,5) - P(4,2)*Metric(1,3)*Metric(2,5) - P(4,6)*Metric(1,3)*Metric(2,5) - 2*P(3,1)*Metric(1,4)*Metric(2,5) + P(3,2)*Metric(1,4)*Metric(2,5) + P(3,6)*Metric(1,4)*Metric(2,5) - P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) + 2*P(4,6)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,6)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,6)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) - 2*P(3,6)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) + P(2,6)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5) + P(1,6)*Metric(2,3)*Metric(4,5)')

VVVVVV1 = Lorentz(name = 'VVVVVV1',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + Metric(1,2)*Metric(3,5)*Metric(4,6)')

VVVVVV2 = Lorentz(name = 'VVVVVV2',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) + Metric(1,4)*Metric(2,6)*Metric(3,5) + Metric(1,5)*Metric(2,4)*Metric(3,6) + Metric(1,4)*Metric(2,5)*Metric(3,6) + Metric(1,6)*Metric(2,3)*Metric(4,5) + Metric(1,3)*Metric(2,6)*Metric(4,5) - 4*Metric(1,2)*Metric(3,6)*Metric(4,5) + Metric(1,5)*Metric(2,3)*Metric(4,6) + Metric(1,3)*Metric(2,5)*Metric(4,6) - 4*Metric(1,2)*Metric(3,5)*Metric(4,6) + Metric(1,4)*Metric(2,3)*Metric(5,6) + Metric(1,3)*Metric(2,4)*Metric(5,6) - 4*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV3 = Lorentz(name = 'VVVVVV3',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/4. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/4. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/4. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/4. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/4. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/4. - (Metric(1,5)*Metric(2,3)*Metric(4,6))/4. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/4. + Metric(1,4)*Metric(2,3)*Metric(5,6) + Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV4 = Lorentz(name = 'VVVVVV4',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (7*Metric(1,6)*Metric(2,4)*Metric(3,5))/18. - (7*Metric(1,4)*Metric(2,6)*Metric(3,5))/18. - (7*Metric(1,5)*Metric(2,4)*Metric(3,6))/18. - (7*Metric(1,4)*Metric(2,5)*Metric(3,6))/18. - (7*Metric(1,6)*Metric(2,3)*Metric(4,5))/18. - (7*Metric(1,3)*Metric(2,6)*Metric(4,5))/18. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (7*Metric(1,5)*Metric(2,3)*Metric(4,6))/18. - (7*Metric(1,3)*Metric(2,5)*Metric(4,6))/18. + Metric(1,2)*Metric(3,5)*Metric(4,6) + (4*Metric(1,4)*Metric(2,3)*Metric(5,6))/9. + (4*Metric(1,3)*Metric(2,4)*Metric(5,6))/9. - (16*Metric(1,2)*Metric(3,4)*Metric(5,6))/9.')

VVVVVV5 = Lorentz(name = 'VVVVVV5',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + Metric(1,2)*Metric(3,5)*Metric(4,6) + (2*Metric(1,4)*Metric(2,3)*Metric(5,6))/3. + (2*Metric(1,3)*Metric(2,4)*Metric(5,6))/3. - (4*Metric(1,2)*Metric(3,4)*Metric(5,6))/3.')

VVVVVV6 = Lorentz(name = 'VVVVVV6',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) - Metric(1,5)*Metric(2,6)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) - Metric(1,4)*Metric(2,6)*Metric(3,5) - Metric(1,5)*Metric(2,4)*Metric(3,6) - Metric(1,4)*Metric(2,5)*Metric(3,6) - 6*Metric(1,6)*Metric(2,3)*Metric(4,5) + 3*Metric(1,3)*Metric(2,6)*Metric(4,5) + 3*Metric(1,2)*Metric(3,6)*Metric(4,5) + 3*Metric(1,5)*Metric(2,3)*Metric(4,6) - Metric(1,3)*Metric(2,5)*Metric(4,6) - Metric(1,2)*Metric(3,5)*Metric(4,6) + 3*Metric(1,4)*Metric(2,3)*Metric(5,6) - Metric(1,3)*Metric(2,4)*Metric(5,6) - Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV7 = Lorentz(name = 'VVVVVV7',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) + Metric(1,4)*Metric(2,6)*Metric(3,5) + Metric(1,5)*Metric(2,4)*Metric(3,6) + Metric(1,4)*Metric(2,5)*Metric(3,6) - (2*Metric(1,6)*Metric(2,3)*Metric(4,5))/3. - (2*Metric(1,3)*Metric(2,6)*Metric(4,5))/3. - (2*Metric(1,2)*Metric(3,6)*Metric(4,5))/3. - (2*Metric(1,5)*Metric(2,3)*Metric(4,6))/3. - (2*Metric(1,3)*Metric(2,5)*Metric(4,6))/3. - (2*Metric(1,2)*Metric(3,5)*Metric(4,6))/3. - (2*Metric(1,4)*Metric(2,3)*Metric(5,6))/3. - (2*Metric(1,3)*Metric(2,4)*Metric(5,6))/3. - (2*Metric(1,2)*Metric(3,4)*Metric(5,6))/3.')

VVVVVV8 = Lorentz(name = 'VVVVVV8',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'Metric(1,6)*Metric(2,3)*Metric(4,5) - (Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + Metric(1,5)*Metric(2,3)*Metric(4,6) - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + Metric(1,4)*Metric(2,3)*Metric(5,6) - (Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVV9 = Lorentz(name = 'VVVVVV9',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) - (Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + Metric(1,6)*Metric(2,4)*Metric(3,5) - (Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - 2*Metric(1,6)*Metric(2,3)*Metric(4,5) + Metric(1,3)*Metric(2,6)*Metric(4,5) + Metric(1,2)*Metric(3,6)*Metric(4,5) + Metric(1,5)*Metric(2,3)*Metric(4,6) - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + Metric(1,4)*Metric(2,3)*Metric(5,6) - (Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVSS19 = Lorentz(name = 'VVVVVSS19',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5)')

VVVVVSS20 = Lorentz(name = 'VVVVVSS20',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - 3*P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(5,6)*Metric(1,3)*Metric(2,4) + P(5,7)*Metric(1,3)*Metric(2,4) + 3*P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - 2*P(3,4)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) - P(3,6)*Metric(1,5)*Metric(2,4) - P(3,7)*Metric(1,5)*Metric(2,4) - 3*P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) + P(4,6)*Metric(1,3)*Metric(2,5) + P(4,7)*Metric(1,3)*Metric(2,5) + 3*P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(3,5)*Metric(1,4)*Metric(2,5) - P(3,6)*Metric(1,4)*Metric(2,5) - P(3,7)*Metric(1,4)*Metric(2,5) + 3*P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(5,4)*Metric(1,2)*Metric(3,4) - P(5,6)*Metric(1,2)*Metric(3,4) - P(5,7)*Metric(1,2)*Metric(3,4) - 3*P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + 2*P(2,4)*Metric(1,5)*Metric(3,4) - P(2,5)*Metric(1,5)*Metric(3,4) + P(2,6)*Metric(1,5)*Metric(3,4) + P(2,7)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) + 3*P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(4,5)*Metric(1,2)*Metric(3,5) - P(4,6)*Metric(1,2)*Metric(3,5) - P(4,7)*Metric(1,2)*Metric(3,5) - 3*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - P(2,4)*Metric(1,4)*Metric(3,5) + 2*P(2,5)*Metric(1,4)*Metric(3,5) + P(2,6)*Metric(1,4)*Metric(3,5) + P(2,7)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) - 4*P(3,1)*Metric(1,2)*Metric(4,5) + P(3,4)*Metric(1,2)*Metric(4,5) + P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(3,6)*Metric(1,2)*Metric(4,5) + 2*P(3,7)*Metric(1,2)*Metric(4,5) + 4*P(2,1)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(2,6)*Metric(1,3)*Metric(4,5) - 2*P(2,7)*Metric(1,3)*Metric(4,5)')

VVVVVSS21 = Lorentz(name = 'VVVVVSS21',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + (P(5,4)*Metric(1,3)*Metric(2,4))/2. + (P(5,6)*Metric(1,3)*Metric(2,4))/2. + (P(5,7)*Metric(1,3)*Metric(2,4))/2. + 2*P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(3,4)*Metric(1,5)*Metric(2,4) + (P(3,5)*Metric(1,5)*Metric(2,4))/2. - (P(3,6)*Metric(1,5)*Metric(2,4))/2. - (P(3,7)*Metric(1,5)*Metric(2,4))/2. - 2*P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + (P(4,5)*Metric(1,3)*Metric(2,5))/2. + (P(4,6)*Metric(1,3)*Metric(2,5))/2. + (P(4,7)*Metric(1,3)*Metric(2,5))/2. + 2*P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + (P(3,4)*Metric(1,4)*Metric(2,5))/2. - P(3,5)*Metric(1,4)*Metric(2,5) - (P(3,6)*Metric(1,4)*Metric(2,5))/2. - (P(3,7)*Metric(1,4)*Metric(2,5))/2. + 2*P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - (P(5,4)*Metric(1,2)*Metric(3,4))/2. - (P(5,6)*Metric(1,2)*Metric(3,4))/2. - (P(5,7)*Metric(1,2)*Metric(3,4))/2. - 2*P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + P(2,4)*Metric(1,5)*Metric(3,4) - (P(2,5)*Metric(1,5)*Metric(3,4))/2. + (P(2,6)*Metric(1,5)*Metric(3,4))/2. + (P(2,7)*Metric(1,5)*Metric(3,4))/2. + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - (P(1,4)*Metric(2,5)*Metric(3,4))/2. + (P(1,5)*Metric(2,5)*Metric(3,4))/2. + 2*P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - (P(4,5)*Metric(1,2)*Metric(3,5))/2. - (P(4,6)*Metric(1,2)*Metric(3,5))/2. - (P(4,7)*Metric(1,2)*Metric(3,5))/2. - 2*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - (P(2,4)*Metric(1,4)*Metric(3,5))/2. + P(2,5)*Metric(1,4)*Metric(3,5) + (P(2,6)*Metric(1,4)*Metric(3,5))/2. + (P(2,7)*Metric(1,4)*Metric(3,5))/2. + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5) + (P(1,4)*Metric(2,4)*Metric(3,5))/2. - (P(1,5)*Metric(2,4)*Metric(3,5))/2. - 2*P(3,1)*Metric(1,2)*Metric(4,5) + (P(3,4)*Metric(1,2)*Metric(4,5))/2. + (P(3,5)*Metric(1,2)*Metric(4,5))/2. + P(3,6)*Metric(1,2)*Metric(4,5) + P(3,7)*Metric(1,2)*Metric(4,5) + 2*P(2,1)*Metric(1,3)*Metric(4,5) - (P(2,4)*Metric(1,3)*Metric(4,5))/2. - (P(2,5)*Metric(1,3)*Metric(4,5))/2. - P(2,6)*Metric(1,3)*Metric(4,5) - P(2,7)*Metric(1,3)*Metric(4,5)')

VVVVVSS22 = Lorentz(name = 'VVVVVSS22',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(5,1)*Metric(1,2)*Metric(3,4) - 2*P(5,2)*Metric(1,2)*Metric(3,4) + 2*P(5,3)*Metric(1,2)*Metric(3,4) + 2*P(5,4)*Metric(1,2)*Metric(3,4) + 2*P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 2*P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) - 2*P(4,3)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) - 2*P(3,4)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5)')

VVVVVSS23 = Lorentz(name = 'VVVVVSS23',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - 2*P(5,1)*Metric(1,2)*Metric(3,4) + 2*P(5,2)*Metric(1,2)*Metric(3,4) + 2*P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) - 2*P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 2*P(4,1)*Metric(1,2)*Metric(3,5) + 2*P(4,2)*Metric(1,2)*Metric(3,5) + 2*P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) - 2*P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - 2*P(3,1)*Metric(1,2)*Metric(4,5) + 2*P(3,2)*Metric(1,2)*Metric(4,5) + 2*P(2,1)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS24 = Lorentz(name = 'VVVVVSS24',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - (2*P(5,1)*Metric(1,2)*Metric(3,4))/3. + (2*P(5,2)*Metric(1,2)*Metric(3,4))/3. + (2*P(2,1)*Metric(1,5)*Metric(3,4))/3. - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + (4*P(2,5)*Metric(1,5)*Metric(3,4))/3. - (2*P(1,2)*Metric(2,5)*Metric(3,4))/3. + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - (4*P(1,5)*Metric(2,5)*Metric(3,4))/3. - (2*P(4,1)*Metric(1,2)*Metric(3,5))/3. + (2*P(4,2)*Metric(1,2)*Metric(3,5))/3. + (2*P(2,1)*Metric(1,4)*Metric(3,5))/3. - P(2,3)*Metric(1,4)*Metric(3,5) + (4*P(2,4)*Metric(1,4)*Metric(3,5))/3. - P(2,5)*Metric(1,4)*Metric(3,5) - (2*P(1,2)*Metric(2,4)*Metric(3,5))/3. + P(1,3)*Metric(2,4)*Metric(3,5) - (4*P(1,4)*Metric(2,4)*Metric(3,5))/3. + P(1,5)*Metric(2,4)*Metric(3,5) - (2*P(3,1)*Metric(1,2)*Metric(4,5))/3. + (2*P(3,2)*Metric(1,2)*Metric(4,5))/3. + (2*P(2,1)*Metric(1,3)*Metric(4,5))/3. + (4*P(2,3)*Metric(1,3)*Metric(4,5))/3. - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - (2*P(1,2)*Metric(2,3)*Metric(4,5))/3. - (4*P(1,3)*Metric(2,3)*Metric(4,5))/3. + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS25 = Lorentz(name = 'VVVVVSS25',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(5,2)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(2,5)*Metric(1,5)*Metric(3,4) - P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) + P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) + P(2,1)*Metric(1,3)*Metric(4,5) + P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS26 = Lorentz(name = 'VVVVVSS26',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + 3*P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + 3*P(3,4)*Metric(1,5)*Metric(2,4) - 2*P(3,5)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) + 3*P(4,3)*Metric(1,3)*Metric(2,5) - 2*P(4,5)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + 3*P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(3,5)*Metric(1,4)*Metric(2,5) - 6*P(5,1)*Metric(1,2)*Metric(3,4) - 6*P(5,2)*Metric(1,2)*Metric(3,4) + 6*P(5,3)*Metric(1,2)*Metric(3,4) + 6*P(5,4)*Metric(1,2)*Metric(3,4) + 6*P(2,1)*Metric(1,5)*Metric(3,4) - 3*P(2,3)*Metric(1,5)*Metric(3,4) - 3*P(2,4)*Metric(1,5)*Metric(3,4) + 6*P(1,2)*Metric(2,5)*Metric(3,4) - 3*P(1,3)*Metric(2,5)*Metric(3,4) - 3*P(1,4)*Metric(2,5)*Metric(3,4) + 3*P(4,1)*Metric(1,2)*Metric(3,5) + 3*P(4,2)*Metric(1,2)*Metric(3,5) - 6*P(4,3)*Metric(1,2)*Metric(3,5) - 3*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(2,5)*Metric(1,4)*Metric(3,5) - 3*P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + 2*P(1,5)*Metric(2,4)*Metric(3,5) + 3*P(3,1)*Metric(1,2)*Metric(4,5) + 3*P(3,2)*Metric(1,2)*Metric(4,5) - 6*P(3,4)*Metric(1,2)*Metric(4,5) - 3*P(2,1)*Metric(1,3)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) + 2*P(2,5)*Metric(1,3)*Metric(4,5) - 3*P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS27 = Lorentz(name = 'VVVVVSS27',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,2)*Metric(1,4)*Metric(2,3) + P(5,3)*Metric(1,4)*Metric(2,3) - 2*P(5,4)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(5,4)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(4,5)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(3,2)*Metric(1,2)*Metric(4,5) - P(3,4)*Metric(1,2)*Metric(4,5) - P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,2)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*Metric(2,3)*Metric(4,5) + 2*P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS28 = Lorentz(name = 'VVVVVSS28',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,1)*Metric(1,4)*Metric(2,3) - P(5,2)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + 2*P(4,2)*Metric(1,5)*Metric(2,3) - P(4,6)*Metric(1,5)*Metric(2,3) - P(4,7)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - 2*P(3,2)*Metric(1,5)*Metric(2,4) + P(3,6)*Metric(1,5)*Metric(2,4) + P(3,7)*Metric(1,5)*Metric(2,4) + 2*P(4,1)*Metric(1,3)*Metric(2,5) - P(4,2)*Metric(1,3)*Metric(2,5) - P(4,6)*Metric(1,3)*Metric(2,5) - P(4,7)*Metric(1,3)*Metric(2,5) - 2*P(3,1)*Metric(1,4)*Metric(2,5) + P(3,2)*Metric(1,4)*Metric(2,5) + P(3,6)*Metric(1,4)*Metric(2,5) + P(3,7)*Metric(1,4)*Metric(2,5) - P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) + 2*P(4,6)*Metric(1,2)*Metric(3,5) + 2*P(4,7)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,6)*Metric(1,4)*Metric(3,5) - P(2,7)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,6)*Metric(2,4)*Metric(3,5) - P(1,7)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) - 2*P(3,6)*Metric(1,2)*Metric(4,5) - 2*P(3,7)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) + P(2,6)*Metric(1,3)*Metric(4,5) + P(2,7)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5) + P(1,6)*Metric(2,3)*Metric(4,5) + P(1,7)*Metric(2,3)*Metric(4,5)')

VVVVVVS1 = Lorentz(name = 'VVVVVVS1',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + Metric(1,2)*Metric(3,5)*Metric(4,6)')

VVVVVVS2 = Lorentz(name = 'VVVVVVS2',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) + Metric(1,4)*Metric(2,6)*Metric(3,5) + Metric(1,5)*Metric(2,4)*Metric(3,6) + Metric(1,4)*Metric(2,5)*Metric(3,6) + Metric(1,6)*Metric(2,3)*Metric(4,5) + Metric(1,3)*Metric(2,6)*Metric(4,5) - 4*Metric(1,2)*Metric(3,6)*Metric(4,5) + Metric(1,5)*Metric(2,3)*Metric(4,6) + Metric(1,3)*Metric(2,5)*Metric(4,6) - 4*Metric(1,2)*Metric(3,5)*Metric(4,6) + Metric(1,4)*Metric(2,3)*Metric(5,6) + Metric(1,3)*Metric(2,4)*Metric(5,6) - 4*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVVS3 = Lorentz(name = 'VVVVVVS3',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/4. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/4. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/4. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/4. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/4. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/4. - (Metric(1,5)*Metric(2,3)*Metric(4,6))/4. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/4. + Metric(1,4)*Metric(2,3)*Metric(5,6) + Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVVS4 = Lorentz(name = 'VVVVVVS4',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (7*Metric(1,6)*Metric(2,4)*Metric(3,5))/18. - (7*Metric(1,4)*Metric(2,6)*Metric(3,5))/18. - (7*Metric(1,5)*Metric(2,4)*Metric(3,6))/18. - (7*Metric(1,4)*Metric(2,5)*Metric(3,6))/18. - (7*Metric(1,6)*Metric(2,3)*Metric(4,5))/18. - (7*Metric(1,3)*Metric(2,6)*Metric(4,5))/18. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (7*Metric(1,5)*Metric(2,3)*Metric(4,6))/18. - (7*Metric(1,3)*Metric(2,5)*Metric(4,6))/18. + Metric(1,2)*Metric(3,5)*Metric(4,6) + (4*Metric(1,4)*Metric(2,3)*Metric(5,6))/9. + (4*Metric(1,3)*Metric(2,4)*Metric(5,6))/9. - (16*Metric(1,2)*Metric(3,4)*Metric(5,6))/9.')

VVVVVVS5 = Lorentz(name = 'VVVVVVS5',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + Metric(1,2)*Metric(3,5)*Metric(4,6) + (2*Metric(1,4)*Metric(2,3)*Metric(5,6))/3. + (2*Metric(1,3)*Metric(2,4)*Metric(5,6))/3. - (4*Metric(1,2)*Metric(3,4)*Metric(5,6))/3.')

VVVVVVS6 = Lorentz(name = 'VVVVVVS6',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) - Metric(1,5)*Metric(2,6)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) - Metric(1,4)*Metric(2,6)*Metric(3,5) - Metric(1,5)*Metric(2,4)*Metric(3,6) - Metric(1,4)*Metric(2,5)*Metric(3,6) - 6*Metric(1,6)*Metric(2,3)*Metric(4,5) + 3*Metric(1,3)*Metric(2,6)*Metric(4,5) + 3*Metric(1,2)*Metric(3,6)*Metric(4,5) + 3*Metric(1,5)*Metric(2,3)*Metric(4,6) - Metric(1,3)*Metric(2,5)*Metric(4,6) - Metric(1,2)*Metric(3,5)*Metric(4,6) + 3*Metric(1,4)*Metric(2,3)*Metric(5,6) - Metric(1,3)*Metric(2,4)*Metric(5,6) - Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVVS7 = Lorentz(name = 'VVVVVVS7',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) + Metric(1,4)*Metric(2,6)*Metric(3,5) + Metric(1,5)*Metric(2,4)*Metric(3,6) + Metric(1,4)*Metric(2,5)*Metric(3,6) - (2*Metric(1,6)*Metric(2,3)*Metric(4,5))/3. - (2*Metric(1,3)*Metric(2,6)*Metric(4,5))/3. - (2*Metric(1,2)*Metric(3,6)*Metric(4,5))/3. - (2*Metric(1,5)*Metric(2,3)*Metric(4,6))/3. - (2*Metric(1,3)*Metric(2,5)*Metric(4,6))/3. - (2*Metric(1,2)*Metric(3,5)*Metric(4,6))/3. - (2*Metric(1,4)*Metric(2,3)*Metric(5,6))/3. - (2*Metric(1,3)*Metric(2,4)*Metric(5,6))/3. - (2*Metric(1,2)*Metric(3,4)*Metric(5,6))/3.')

VVVVVVS8 = Lorentz(name = 'VVVVVVS8',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,3)*Metric(4,5) - (Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + Metric(1,5)*Metric(2,3)*Metric(4,6) - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + Metric(1,4)*Metric(2,3)*Metric(5,6) - (Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVVS9 = Lorentz(name = 'VVVVVVS9',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) - (Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + Metric(1,6)*Metric(2,4)*Metric(3,5) - (Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - 2*Metric(1,6)*Metric(2,3)*Metric(4,5) + Metric(1,3)*Metric(2,6)*Metric(4,5) + Metric(1,2)*Metric(3,6)*Metric(4,5) + Metric(1,5)*Metric(2,3)*Metric(4,6) - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + Metric(1,4)*Metric(2,3)*Metric(5,6) - (Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVVSS1 = Lorentz(name = 'VVVVVVSS1',
                    spins = [ 3, 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + Metric(1,2)*Metric(3,5)*Metric(4,6)')

VVVVVVSS2 = Lorentz(name = 'VVVVVVSS2',
                    spins = [ 3, 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) + Metric(1,4)*Metric(2,6)*Metric(3,5) + Metric(1,5)*Metric(2,4)*Metric(3,6) + Metric(1,4)*Metric(2,5)*Metric(3,6) + Metric(1,6)*Metric(2,3)*Metric(4,5) + Metric(1,3)*Metric(2,6)*Metric(4,5) - 4*Metric(1,2)*Metric(3,6)*Metric(4,5) + Metric(1,5)*Metric(2,3)*Metric(4,6) + Metric(1,3)*Metric(2,5)*Metric(4,6) - 4*Metric(1,2)*Metric(3,5)*Metric(4,6) + Metric(1,4)*Metric(2,3)*Metric(5,6) + Metric(1,3)*Metric(2,4)*Metric(5,6) - 4*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVVSS3 = Lorentz(name = 'VVVVVVSS3',
                    spins = [ 3, 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/4. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/4. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/4. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/4. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/4. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/4. - (Metric(1,5)*Metric(2,3)*Metric(4,6))/4. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/4. + Metric(1,4)*Metric(2,3)*Metric(5,6) + Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVVSS4 = Lorentz(name = 'VVVVVVSS4',
                    spins = [ 3, 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (7*Metric(1,6)*Metric(2,4)*Metric(3,5))/18. - (7*Metric(1,4)*Metric(2,6)*Metric(3,5))/18. - (7*Metric(1,5)*Metric(2,4)*Metric(3,6))/18. - (7*Metric(1,4)*Metric(2,5)*Metric(3,6))/18. - (7*Metric(1,6)*Metric(2,3)*Metric(4,5))/18. - (7*Metric(1,3)*Metric(2,6)*Metric(4,5))/18. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (7*Metric(1,5)*Metric(2,3)*Metric(4,6))/18. - (7*Metric(1,3)*Metric(2,5)*Metric(4,6))/18. + Metric(1,2)*Metric(3,5)*Metric(4,6) + (4*Metric(1,4)*Metric(2,3)*Metric(5,6))/9. + (4*Metric(1,3)*Metric(2,4)*Metric(5,6))/9. - (16*Metric(1,2)*Metric(3,4)*Metric(5,6))/9.')

VVVVVVSS5 = Lorentz(name = 'VVVVVVSS5',
                    spins = [ 3, 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + Metric(1,2)*Metric(3,5)*Metric(4,6) + (2*Metric(1,4)*Metric(2,3)*Metric(5,6))/3. + (2*Metric(1,3)*Metric(2,4)*Metric(5,6))/3. - (4*Metric(1,2)*Metric(3,4)*Metric(5,6))/3.')

VVVVVVSS6 = Lorentz(name = 'VVVVVVSS6',
                    spins = [ 3, 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) - Metric(1,5)*Metric(2,6)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) - Metric(1,4)*Metric(2,6)*Metric(3,5) - Metric(1,5)*Metric(2,4)*Metric(3,6) - Metric(1,4)*Metric(2,5)*Metric(3,6) - 6*Metric(1,6)*Metric(2,3)*Metric(4,5) + 3*Metric(1,3)*Metric(2,6)*Metric(4,5) + 3*Metric(1,2)*Metric(3,6)*Metric(4,5) + 3*Metric(1,5)*Metric(2,3)*Metric(4,6) - Metric(1,3)*Metric(2,5)*Metric(4,6) - Metric(1,2)*Metric(3,5)*Metric(4,6) + 3*Metric(1,4)*Metric(2,3)*Metric(5,6) - Metric(1,3)*Metric(2,4)*Metric(5,6) - Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVVSS7 = Lorentz(name = 'VVVVVVSS7',
                    spins = [ 3, 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) + Metric(1,4)*Metric(2,6)*Metric(3,5) + Metric(1,5)*Metric(2,4)*Metric(3,6) + Metric(1,4)*Metric(2,5)*Metric(3,6) - (2*Metric(1,6)*Metric(2,3)*Metric(4,5))/3. - (2*Metric(1,3)*Metric(2,6)*Metric(4,5))/3. - (2*Metric(1,2)*Metric(3,6)*Metric(4,5))/3. - (2*Metric(1,5)*Metric(2,3)*Metric(4,6))/3. - (2*Metric(1,3)*Metric(2,5)*Metric(4,6))/3. - (2*Metric(1,2)*Metric(3,5)*Metric(4,6))/3. - (2*Metric(1,4)*Metric(2,3)*Metric(5,6))/3. - (2*Metric(1,3)*Metric(2,4)*Metric(5,6))/3. - (2*Metric(1,2)*Metric(3,4)*Metric(5,6))/3.')

VVVVVVSS8 = Lorentz(name = 'VVVVVVSS8',
                    spins = [ 3, 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'Metric(1,6)*Metric(2,3)*Metric(4,5) - (Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + Metric(1,5)*Metric(2,3)*Metric(4,6) - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + Metric(1,4)*Metric(2,3)*Metric(5,6) - (Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVVSS9 = Lorentz(name = 'VVVVVVSS9',
                    spins = [ 3, 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) - (Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + Metric(1,6)*Metric(2,4)*Metric(3,5) - (Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - 2*Metric(1,6)*Metric(2,3)*Metric(4,5) + Metric(1,3)*Metric(2,6)*Metric(4,5) + Metric(1,2)*Metric(3,6)*Metric(4,5) + Metric(1,5)*Metric(2,3)*Metric(4,6) - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + Metric(1,4)*Metric(2,3)*Metric(5,6) - (Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

