# This file was automatically created by FeynRules 2.3.47
# Mathematica version: 12.0.0 for Mac OS X x86 (64-bit) (April 7, 2019)
# Date: Sun 22 Aug 2021 00:05:19


from object_library import all_lorentz, Lorentz

from function_library import complexconjugate, re, im, csc, sec, acsc, asec, cot
try:
   import form_factors as ForFac 
except ImportError:
   pass


UUV1 = Lorentz(name = 'UUV1',
               spins = [ -1, -1, 3 ],
               structure = 'P(3,2) + P(3,3)')

SSS1 = Lorentz(name = 'SSS1',
               spins = [ 1, 1, 1 ],
               structure = '1')

FFS1 = Lorentz(name = 'FFS1',
               spins = [ 2, 2, 1 ],
               structure = 'ProjM(2,1) + ProjP(2,1)')

FFV1 = Lorentz(name = 'FFV1',
               spins = [ 2, 2, 3 ],
               structure = 'Gamma(3,2,1)')

FFV2 = Lorentz(name = 'FFV2',
               spins = [ 2, 2, 3 ],
               structure = 'Gamma(3,2,-1)*ProjM(-1,1)')

FFV3 = Lorentz(name = 'FFV3',
               spins = [ 2, 2, 3 ],
               structure = 'Gamma(3,2,-1)*ProjM(-1,1) - 2*Gamma(3,2,-1)*ProjP(-1,1)')

FFV4 = Lorentz(name = 'FFV4',
               spins = [ 2, 2, 3 ],
               structure = 'Gamma(3,2,-1)*ProjM(-1,1) + 2*Gamma(3,2,-1)*ProjP(-1,1)')

FFV5 = Lorentz(name = 'FFV5',
               spins = [ 2, 2, 3 ],
               structure = 'Gamma(3,2,-1)*ProjM(-1,1) + 4*Gamma(3,2,-1)*ProjP(-1,1)')

VVS1 = Lorentz(name = 'VVS1',
               spins = [ 3, 3, 1 ],
               structure = 'Metric(1,2)')

VVV1 = Lorentz(name = 'VVV1',
               spins = [ 3, 3, 3 ],
               structure = 'P(3,1)*Metric(1,2) - P(3,2)*Metric(1,2) - P(2,1)*Metric(1,3) + P(2,3)*Metric(1,3) + P(1,2)*Metric(2,3) - P(1,3)*Metric(2,3)')

SSSS1 = Lorentz(name = 'SSSS1',
                spins = [ 1, 1, 1, 1 ],
                structure = '1')

SSSS2 = Lorentz(name = 'SSSS2',
                spins = [ 1, 1, 1, 1 ],
                structure = 'P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)')

VVSS1 = Lorentz(name = 'VVSS1',
                spins = [ 3, 3, 1, 1 ],
                structure = 'P(1,4)*P(2,3) + P(1,3)*P(2,4)')

VVSS2 = Lorentz(name = 'VVSS2',
                spins = [ 3, 3, 1, 1 ],
                structure = 'Metric(1,2)')

VVSS3 = Lorentz(name = 'VVSS3',
                spins = [ 3, 3, 1, 1 ],
                structure = 'P(-1,3)*P(-1,4)*Metric(1,2)')

VVSS4 = Lorentz(name = 'VVSS4',
                spins = [ 3, 3, 1, 1 ],
                structure = 'P(1,4)*P(2,3) + P(1,3)*P(2,4) - P(-1,3)*P(-1,4)*Metric(1,2)')

VVSS5 = Lorentz(name = 'VVSS5',
                spins = [ 3, 3, 1, 1 ],
                structure = '-(P(-1,2)*P(-1,4)*P(1,3)*P(2,1)) - P(-1,2)*P(-1,3)*P(1,4)*P(2,1) - P(-1,1)*P(-1,4)*P(1,2)*P(2,3) + P(-1,1)*P(-1,2)*P(1,4)*P(2,3) - P(-1,1)*P(-1,3)*P(1,2)*P(2,4) + P(-1,1)*P(-1,2)*P(1,3)*P(2,4) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,2) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,2)')

VVSS6 = Lorentz(name = 'VVSS6',
                spins = [ 3, 3, 1, 1 ],
                structure = 'P(-1,3)*P(-1,4)*P(1,2)*P(2,1) - P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,2)')

VVVS1 = Lorentz(name = 'VVVS1',
                spins = [ 3, 3, 3, 1 ],
                structure = 'P(1,3)*P(2,4)*P(3,1) - P(1,2)*P(2,1)*P(3,4) + P(-1,1)*P(-1,2)*P(3,4)*Metric(1,2) - P(-1,1)*P(-1,3)*P(2,4)*Metric(1,3)')

VVVS2 = Lorentz(name = 'VVVS2',
                spins = [ 3, 3, 3, 1 ],
                structure = 'P(2,4)*Metric(1,3) - P(1,4)*Metric(2,3)')

VVVS3 = Lorentz(name = 'VVVS3',
                spins = [ 3, 3, 3, 1 ],
                structure = '-(P(1,3)*P(2,4)*P(3,1)) + P(1,4)*P(2,3)*P(3,2) + P(-1,1)*P(-1,3)*P(2,4)*Metric(1,3) - P(-1,2)*P(-1,3)*P(1,4)*Metric(2,3)')

VVVS4 = Lorentz(name = 'VVVS4',
                spins = [ 3, 3, 3, 1 ],
                structure = '-(P(1,2)*P(2,4)*P(3,1)) + P(1,4)*P(2,1)*P(3,2) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3)')

VVVS5 = Lorentz(name = 'VVVS5',
                spins = [ 3, 3, 3, 1 ],
                structure = '-(P(1,4)*P(2,3)*P(3,1)) - P(1,2)*P(2,4)*P(3,1) + P(1,4)*P(2,1)*P(3,2) + P(1,3)*P(2,1)*P(3,4) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3) - P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)')

VVVS6 = Lorentz(name = 'VVVS6',
                spins = [ 3, 3, 3, 1 ],
                structure = '-(P(1,4)*P(2,3)*P(3,1)) + P(1,2)*P(2,4)*P(3,1) + P(1,4)*P(2,1)*P(3,2) - P(1,3)*P(2,1)*P(3,4) - P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) - P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2) + P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2) + P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) - P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3) - P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)')

VVVS7 = Lorentz(name = 'VVVS7',
                spins = [ 3, 3, 3, 1 ],
                structure = '-(P(1,4)*P(2,3)*P(3,1)) - P(1,2)*P(2,4)*P(3,1) + P(1,4)*P(2,1)*P(3,2) + P(1,3)*P(2,4)*P(3,2) + P(1,3)*P(2,1)*P(3,4) - P(1,2)*P(2,3)*P(3,4) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,3)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2) + P(-1,2)*P(-1,3)*P(3,4)*Metric(1,2) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,2)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) - P(-1,2)*P(-1,3)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,3)*P(-1,4)*P(1,2)*Metric(2,3) - P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,2)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)')

VVVS8 = Lorentz(name = 'VVVS8',
                spins = [ 3, 3, 3, 1 ],
                structure = 'P(1,4)*P(2,3)*P(3,1) - P(1,3)*P(2,4)*P(3,2) + P(1,3)*P(2,1)*P(3,4) - P(1,2)*P(2,3)*P(3,4) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2) - P(-1,3)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2) + P(-1,2)*P(-1,3)*P(3,4)*Metric(1,2) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) - P(-1,2)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,2)*P(-1,3)*P(2,4)*Metric(1,3) + P(-1,3)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) + P(-1,2)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)')

VVVV1 = Lorentz(name = 'VVVV1',
                spins = [ 3, 3, 3, 3 ],
                structure = 'P(1,4)*P(4,1)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3)')

VVVV2 = Lorentz(name = 'VVVV2',
                spins = [ 3, 3, 3, 3 ],
                structure = 'P(1,4)*P(2,3)*P(3,2)*P(4,1) - P(-1,1)*P(-1,4)*P(2,3)*P(3,2)*Metric(1,4) - P(-1,2)*P(-1,3)*P(1,4)*P(4,1)*Metric(2,3) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3)')

VVVV3 = Lorentz(name = 'VVVV3',
                spins = [ 3, 3, 3, 3 ],
                structure = 'Metric(1,4)*Metric(2,3) - Metric(1,3)*Metric(2,4)')

VVVV4 = Lorentz(name = 'VVVV4',
                spins = [ 3, 3, 3, 3 ],
                structure = 'Metric(1,4)*Metric(2,3) + Metric(1,3)*Metric(2,4)')

VVVV5 = Lorentz(name = 'VVVV5',
                spins = [ 3, 3, 3, 3 ],
                structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)')

VVVV6 = Lorentz(name = 'VVVV6',
                spins = [ 3, 3, 3, 3 ],
                structure = 'P(2,4)*P(4,2)*Metric(1,3) + P(2,3)*P(3,2)*Metric(1,4) + P(1,4)*P(4,1)*Metric(2,3) - P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4)')

VVVV7 = Lorentz(name = 'VVVV7',
                spins = [ 3, 3, 3, 3 ],
                structure = 'P(1,3)*P(2,4)*P(3,2)*P(4,1) + P(1,4)*P(2,3)*P(3,1)*P(4,2) + P(-1,2)*P(-1,4)*P(2,3)*P(4,1)*Metric(1,3) - P(-1,2)*P(-1,3)*P(2,4)*P(4,1)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*P(4,2)*Metric(1,3) - P(-1,2)*P(-1,4)*P(2,3)*P(3,1)*Metric(1,4) + P(-1,2)*P(-1,3)*P(2,4)*P(3,1)*Metric(1,4) - P(-1,1)*P(-1,3)*P(2,4)*P(3,2)*Metric(1,4) - P(-1,2)*P(-1,4)*P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,3)*P(4,2)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,4)*P(4,2)*Metric(2,3) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,3)*P(1,4)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,4)*P(1,3)*P(3,2)*Metric(2,4) + P(-1,1)*P(-1,3)*P(1,4)*P(3,2)*Metric(2,4) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4)')

VVVV8 = Lorentz(name = 'VVVV8',
                spins = [ 3, 3, 3, 3 ],
                structure = 'P(1,4)*P(2,3)*P(3,2)*P(4,1) + P(1,3)*P(2,4)*P(3,1)*P(4,2) - P(-1,1)*P(-1,3)*P(2,4)*P(4,2)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*P(3,2)*Metric(1,4) - P(-1,2)*P(-1,3)*P(1,4)*P(4,1)*Metric(2,3) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,4)*P(1,3)*P(3,1)*Metric(2,4) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4)')

VVVV9 = Lorentz(name = 'VVVV9',
                spins = [ 3, 3, 3, 3 ],
                structure = 'Metric(1,2)*Metric(3,4)')

VVVV10 = Lorentz(name = 'VVVV10',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(2,4)*P(4,3)*Metric(1,3) + P(2,3)*P(3,4)*Metric(1,4) + P(1,4)*P(4,3)*Metric(2,3) - P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,4)*Metric(2,4) - P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,4)*P(2,3)*Metric(3,4) - P(1,3)*P(2,4)*Metric(3,4)')

VVVV11 = Lorentz(name = 'VVVV11',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,4)*P(2,3)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4)')

VVVV12 = Lorentz(name = 'VVVV12',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) + Metric(1,3)*Metric(2,4) - 2*Metric(1,2)*Metric(3,4)')

VVVV13 = Lorentz(name = 'VVVV13',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) - Metric(1,2)*Metric(3,4)')

VVVV14 = Lorentz(name = 'VVVV14',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,3)*Metric(2,4) - Metric(1,2)*Metric(3,4)')

VVVV15 = Lorentz(name = 'VVVV15',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) - (Metric(1,3)*Metric(2,4))/2. - (Metric(1,2)*Metric(3,4))/2.')

VVVV16 = Lorentz(name = 'VVVV16',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) + Metric(1,3)*Metric(2,4) + Metric(1,2)*Metric(3,4)')

VVVV17 = Lorentz(name = 'VVVV17',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,2)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVV18 = Lorentz(name = 'VVVV18',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,4)*P(4,1)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(1,2)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVV19 = Lorentz(name = 'VVVV19',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,4)*P(4,1)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(1,3)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(1,2)*P(2,1)*Metric(3,4) + P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVV20 = Lorentz(name = 'VVVV20',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,1)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(1,2)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4)')

VVVV21 = Lorentz(name = 'VVVV21',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,4)*P(4,1)*Metric(1,2) + P(2,4)*P(4,1)*Metric(1,3) - P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) + P(1,4)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,4)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV22 = Lorentz(name = 'VVVV22',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,4)*P(4,1)*Metric(1,2) - P(3,1)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) + P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(1,2)*P(3,1)*Metric(2,4) + P(1,4)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV23 = Lorentz(name = 'VVVV23',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) + P(1,4)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV24 = Lorentz(name = 'VVVV24',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV25 = Lorentz(name = 'VVVV25',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,4)*P(4,1)*Metric(1,2) + P(3,4)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) - P(2,1)*P(4,3)*Metric(1,3) - P(2,1)*P(3,4)*Metric(1,4) - P(1,2)*P(4,3)*Metric(2,3) - P(1,2)*P(3,4)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV26 = Lorentz(name = 'VVVV26',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,4)*P(4,1)*Metric(1,2) + P(3,4)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) - P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) + P(2,3)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) + P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) + P(2,4)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) + P(1,3)*P(4,1)*Metric(2,3) - P(1,3)*P(4,2)*Metric(2,3) + P(1,4)*P(4,2)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,4)*P(3,1)*Metric(2,4) + P(1,3)*P(3,2)*Metric(2,4) - P(1,4)*P(3,2)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV27 = Lorentz(name = 'VVVV27',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) + P(3,4)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,4)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(1,3)*P(4,2)*Metric(2,3) - P(1,4)*P(4,2)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) - P(1,3)*P(3,2)*Metric(2,4) + P(1,4)*P(3,2)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV28 = Lorentz(name = 'VVVV28',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,4)*P(4,1)*Metric(1,2) + P(3,4)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) - P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) + P(2,3)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) - 2*P(2,4)*P(4,3)*Metric(1,3) + P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) + P(2,4)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - 2*P(2,3)*P(3,4)*Metric(1,4) + P(1,3)*P(4,1)*Metric(2,3) - P(1,3)*P(4,2)*Metric(2,3) + P(1,4)*P(4,2)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - 2*P(1,4)*P(4,3)*Metric(2,3) - P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + 2*P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,4)*P(3,1)*Metric(2,4) + P(1,3)*P(3,2)*Metric(2,4) - P(1,4)*P(3,2)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - 2*P(1,3)*P(3,4)*Metric(2,4) - P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + 2*P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + 2*P(1,4)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) + 2*P(1,3)*P(2,4)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV29 = Lorentz(name = 'VVVV29',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) + (P(3,4)*P(4,1)*Metric(1,2))/2. + P(3,1)*P(4,2)*Metric(1,2) + (P(3,4)*P(4,2)*Metric(1,2))/2. + (P(3,1)*P(4,3)*Metric(1,2))/2. + (P(3,2)*P(4,3)*Metric(1,2))/2. + (P(2,3)*P(4,1)*Metric(1,3))/2. - (P(2,4)*P(4,1)*Metric(1,3))/2. - P(2,1)*P(4,2)*Metric(1,3) - (P(2,3)*P(4,2)*Metric(1,3))/2. - (P(2,1)*P(4,3)*Metric(1,3))/2. - (P(2,3)*P(3,1)*Metric(1,4))/2. + (P(2,4)*P(3,1)*Metric(1,4))/2. - P(2,1)*P(3,2)*Metric(1,4) - (P(2,4)*P(3,2)*Metric(1,4))/2. - (P(2,1)*P(3,4)*Metric(1,4))/2. - P(1,2)*P(4,1)*Metric(2,3) - (P(1,3)*P(4,1)*Metric(2,3))/2. + (P(1,3)*P(4,2)*Metric(2,3))/2. - (P(1,4)*P(4,2)*Metric(2,3))/2. - (P(1,2)*P(4,3)*Metric(2,3))/2. + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + (P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3))/2. - P(1,2)*P(3,1)*Metric(2,4) - (P(1,4)*P(3,1)*Metric(2,4))/2. - (P(1,3)*P(3,2)*Metric(2,4))/2. + (P(1,4)*P(3,2)*Metric(2,4))/2. - (P(1,2)*P(3,4)*Metric(2,4))/2. + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + (P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4))/2. + (P(1,3)*P(2,1)*Metric(3,4))/2. + (P(1,4)*P(2,1)*Metric(3,4))/2. + (P(1,2)*P(2,3)*Metric(3,4))/2. + (P(1,2)*P(2,4)*Metric(3,4))/2. - (P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4))/2. - (P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4))/2. - (P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4))/2.')

VVVV30 = Lorentz(name = 'VVVV30',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,4)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) - P(3,2)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,4)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(1,3)*P(4,2)*Metric(2,3) - P(1,4)*P(4,2)*Metric(2,3) + P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) - P(1,3)*P(3,2)*Metric(2,4) + P(1,4)*P(3,2)*Metric(2,4) + P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) - P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) - P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV31 = Lorentz(name = 'VVVV31',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,4)*P(4,3)*Metric(1,2) - P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV32 = Lorentz(name = 'VVVV32',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,4)*P(4,3)*Metric(1,2) - (P(2,4)*P(4,2)*Metric(1,3))/2. - (P(2,3)*P(3,2)*Metric(1,4))/2. - (P(1,4)*P(4,1)*Metric(2,3))/2. + (P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3))/2. - (P(1,3)*P(3,1)*Metric(2,4))/2. + (P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4))/2. - P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV33 = Lorentz(name = 'VVVV33',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,4)*P(4,3)*Metric(1,2) + P(1,2)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV34 = Lorentz(name = 'VVVV34',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,4)*P(4,3)*Metric(1,2) + P(2,4)*P(4,2)*Metric(1,3) + P(2,3)*P(3,2)*Metric(1,4) + P(1,4)*P(4,1)*Metric(2,3) - P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,2)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV35 = Lorentz(name = 'VVVV35',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,3)*P(2,4)*P(3,2)*P(4,1) + P(1,2)*P(2,3)*P(3,4)*P(4,1) + P(1,4)*P(2,3)*P(3,1)*P(4,2) + P(1,4)*P(2,1)*P(3,2)*P(4,3) + P(-1,3)*P(-1,4)*P(3,2)*P(4,1)*Metric(1,2) - P(-1,2)*P(-1,3)*P(3,4)*P(4,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*P(4,3)*Metric(1,2) + P(-1,2)*P(-1,4)*P(2,3)*P(4,1)*Metric(1,3) - P(-1,2)*P(-1,3)*P(2,4)*P(4,1)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*P(4,2)*Metric(1,3) - P(-1,2)*P(-1,4)*P(2,3)*P(3,1)*Metric(1,4) + P(-1,2)*P(-1,3)*P(2,4)*P(3,1)*Metric(1,4) - P(-1,3)*P(-1,4)*P(2,1)*P(3,2)*Metric(1,4) - P(-1,1)*P(-1,3)*P(2,4)*P(3,2)*Metric(1,4) + P(-1,2)*P(-1,3)*P(2,1)*P(3,4)*Metric(1,4) - P(-1,1)*P(-1,2)*P(2,3)*P(3,4)*Metric(1,4) - P(-1,3)*P(-1,4)*P(1,2)*P(4,1)*Metric(2,3) - P(-1,2)*P(-1,4)*P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,3)*P(4,2)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,4)*P(4,2)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,2)*P(4,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*P(4,3)*Metric(2,3) + P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,3)*P(1,4)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,4)*P(1,3)*P(3,2)*Metric(2,4) + P(-1,1)*P(-1,3)*P(1,4)*P(3,2)*Metric(2,4) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,3)*P(1,4)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,4)*P(1,2)*P(2,3)*Metric(3,4) + P(-1,1)*P(-1,2)*P(1,4)*P(2,3)*Metric(3,4) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV36 = Lorentz(name = 'VVVV36',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,3)*P(2,4)*P(3,2)*P(4,1) + (P(1,2)*P(2,3)*P(3,4)*P(4,1))/2. + P(1,4)*P(2,3)*P(3,1)*P(4,2) + (P(1,3)*P(2,1)*P(3,4)*P(4,2))/2. + (P(1,2)*P(2,4)*P(3,1)*P(4,3))/2. + (P(1,4)*P(2,1)*P(3,2)*P(4,3))/2. + (P(-1,3)*P(-1,4)*P(3,2)*P(4,1)*Metric(1,2))/2. - (P(-1,2)*P(-1,3)*P(3,4)*P(4,1)*Metric(1,2))/2. + (P(-1,3)*P(-1,4)*P(3,1)*P(4,2)*Metric(1,2))/2. - (P(-1,1)*P(-1,3)*P(3,4)*P(4,2)*Metric(1,2))/2. - (P(-1,2)*P(-1,4)*P(3,1)*P(4,3)*Metric(1,2))/2. - (P(-1,1)*P(-1,4)*P(3,2)*P(4,3)*Metric(1,2))/2. + P(-1,2)*P(-1,4)*P(2,3)*P(4,1)*Metric(1,3) - P(-1,2)*P(-1,3)*P(2,4)*P(4,1)*Metric(1,3) - (P(-1,3)*P(-1,4)*P(2,1)*P(4,2)*Metric(1,3))/2. - P(-1,1)*P(-1,4)*P(2,3)*P(4,2)*Metric(1,3) + (P(-1,2)*P(-1,4)*P(2,1)*P(4,3)*Metric(1,3))/2. - (P(-1,1)*P(-1,2)*P(2,4)*P(4,3)*Metric(1,3))/2. - P(-1,2)*P(-1,4)*P(2,3)*P(3,1)*Metric(1,4) + P(-1,2)*P(-1,3)*P(2,4)*P(3,1)*Metric(1,4) - (P(-1,3)*P(-1,4)*P(2,1)*P(3,2)*Metric(1,4))/2. - P(-1,1)*P(-1,3)*P(2,4)*P(3,2)*Metric(1,4) + (P(-1,2)*P(-1,3)*P(2,1)*P(3,4)*Metric(1,4))/2. - (P(-1,1)*P(-1,2)*P(2,3)*P(3,4)*Metric(1,4))/2. - (P(-1,3)*P(-1,4)*P(1,2)*P(4,1)*Metric(2,3))/2. - P(-1,2)*P(-1,4)*P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,3)*P(4,2)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,4)*P(4,2)*Metric(2,3) + (P(-1,1)*P(-1,4)*P(1,2)*P(4,3)*Metric(2,3))/2. - (P(-1,1)*P(-1,2)*P(1,4)*P(4,3)*Metric(2,3))/2. + (P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3))/2. + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - (P(-1,3)*P(-1,4)*P(1,2)*P(3,1)*Metric(2,4))/2. - P(-1,2)*P(-1,3)*P(1,4)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,4)*P(1,3)*P(3,2)*Metric(2,4) + P(-1,1)*P(-1,3)*P(1,4)*P(3,2)*Metric(2,4) + (P(-1,1)*P(-1,3)*P(1,2)*P(3,4)*Metric(2,4))/2. - (P(-1,1)*P(-1,2)*P(1,3)*P(3,4)*Metric(2,4))/2. + (P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4))/2. + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - (P(-1,2)*P(-1,4)*P(1,3)*P(2,1)*Metric(3,4))/2. - (P(-1,2)*P(-1,3)*P(1,4)*P(2,1)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*P(1,2)*P(2,3)*Metric(3,4))/2. + (P(-1,1)*P(-1,2)*P(1,4)*P(2,3)*Metric(3,4))/2. - (P(-1,1)*P(-1,3)*P(1,2)*P(2,4)*Metric(3,4))/2. + (P(-1,1)*P(-1,2)*P(1,3)*P(2,4)*Metric(3,4))/2. + (P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4))/2. + (P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4))/2.')

VVVV37 = Lorentz(name = 'VVVV37',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,3)*P(2,1)*P(3,4)*P(4,2) + P(1,2)*P(2,4)*P(3,1)*P(4,3) + P(-1,3)*P(-1,4)*P(3,1)*P(4,2)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,4)*P(4,2)*Metric(1,2) - P(-1,2)*P(-1,4)*P(3,1)*P(4,3)*Metric(1,2) - P(-1,3)*P(-1,4)*P(2,1)*P(4,2)*Metric(1,3) + P(-1,2)*P(-1,4)*P(2,1)*P(4,3)*Metric(1,3) - P(-1,1)*P(-1,2)*P(2,4)*P(4,3)*Metric(1,3) - P(-1,3)*P(-1,4)*P(1,2)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,3)*P(1,2)*P(3,4)*Metric(2,4) - P(-1,1)*P(-1,2)*P(1,3)*P(3,4)*Metric(2,4) + P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*P(1,3)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,3)*P(1,2)*P(2,4)*Metric(3,4) + P(-1,1)*P(-1,2)*P(1,3)*P(2,4)*Metric(3,4) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4)')

VVVV38 = Lorentz(name = 'VVVV38',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,2)*P(2,3)*P(3,4)*P(4,1) + P(1,3)*P(2,1)*P(3,4)*P(4,2) + P(1,2)*P(2,4)*P(3,1)*P(4,3) + P(1,4)*P(2,1)*P(3,2)*P(4,3) + P(-1,3)*P(-1,4)*P(3,2)*P(4,1)*Metric(1,2) - P(-1,2)*P(-1,3)*P(3,4)*P(4,1)*Metric(1,2) + P(-1,3)*P(-1,4)*P(3,1)*P(4,2)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,4)*P(4,2)*Metric(1,2) - P(-1,2)*P(-1,4)*P(3,1)*P(4,3)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*P(4,3)*Metric(1,2) - P(-1,3)*P(-1,4)*P(2,1)*P(4,2)*Metric(1,3) + P(-1,2)*P(-1,4)*P(2,1)*P(4,3)*Metric(1,3) - P(-1,1)*P(-1,2)*P(2,4)*P(4,3)*Metric(1,3) - P(-1,3)*P(-1,4)*P(2,1)*P(3,2)*Metric(1,4) + P(-1,2)*P(-1,3)*P(2,1)*P(3,4)*Metric(1,4) - P(-1,1)*P(-1,2)*P(2,3)*P(3,4)*Metric(1,4) - P(-1,3)*P(-1,4)*P(1,2)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,2)*P(4,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*P(4,3)*Metric(2,3) + P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,4)*P(1,2)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,3)*P(1,2)*P(3,4)*Metric(2,4) - P(-1,1)*P(-1,2)*P(1,3)*P(3,4)*Metric(2,4) + P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*P(1,3)*P(2,1)*Metric(3,4) - P(-1,2)*P(-1,3)*P(1,4)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,4)*P(1,2)*P(2,3)*Metric(3,4) + P(-1,1)*P(-1,2)*P(1,4)*P(2,3)*Metric(3,4) - P(-1,1)*P(-1,3)*P(1,2)*P(2,4)*Metric(3,4) + P(-1,1)*P(-1,2)*P(1,3)*P(2,4)*Metric(3,4) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV39 = Lorentz(name = 'VVVV39',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,3)*P(2,4)*P(3,2)*P(4,1) + P(1,2)*P(2,3)*P(3,4)*P(4,1) + P(1,4)*P(2,3)*P(3,1)*P(4,2) + P(1,3)*P(2,1)*P(3,4)*P(4,2) + P(1,2)*P(2,4)*P(3,1)*P(4,3) + P(1,4)*P(2,1)*P(3,2)*P(4,3) + P(-1,3)*P(-1,4)*P(3,2)*P(4,1)*Metric(1,2) - P(-1,2)*P(-1,3)*P(3,4)*P(4,1)*Metric(1,2) + P(-1,3)*P(-1,4)*P(3,1)*P(4,2)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,4)*P(4,2)*Metric(1,2) - P(-1,2)*P(-1,4)*P(3,1)*P(4,3)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*P(4,3)*Metric(1,2) + P(-1,2)*P(-1,4)*P(2,3)*P(4,1)*Metric(1,3) - P(-1,2)*P(-1,3)*P(2,4)*P(4,1)*Metric(1,3) - P(-1,3)*P(-1,4)*P(2,1)*P(4,2)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*P(4,2)*Metric(1,3) + P(-1,2)*P(-1,4)*P(2,1)*P(4,3)*Metric(1,3) - P(-1,1)*P(-1,2)*P(2,4)*P(4,3)*Metric(1,3) - P(-1,2)*P(-1,4)*P(2,3)*P(3,1)*Metric(1,4) + P(-1,2)*P(-1,3)*P(2,4)*P(3,1)*Metric(1,4) - P(-1,3)*P(-1,4)*P(2,1)*P(3,2)*Metric(1,4) - P(-1,1)*P(-1,3)*P(2,4)*P(3,2)*Metric(1,4) + P(-1,2)*P(-1,3)*P(2,1)*P(3,4)*Metric(1,4) - P(-1,1)*P(-1,2)*P(2,3)*P(3,4)*Metric(1,4) - P(-1,3)*P(-1,4)*P(1,2)*P(4,1)*Metric(2,3) - P(-1,2)*P(-1,4)*P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,3)*P(4,2)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,4)*P(4,2)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,2)*P(4,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*P(4,3)*Metric(2,3) + P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,4)*P(1,2)*P(3,1)*Metric(2,4) - P(-1,2)*P(-1,3)*P(1,4)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,4)*P(1,3)*P(3,2)*Metric(2,4) + P(-1,1)*P(-1,3)*P(1,4)*P(3,2)*Metric(2,4) + P(-1,1)*P(-1,3)*P(1,2)*P(3,4)*Metric(2,4) - P(-1,1)*P(-1,2)*P(1,3)*P(3,4)*Metric(2,4) + P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*P(1,3)*P(2,1)*Metric(3,4) - P(-1,2)*P(-1,3)*P(1,4)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,4)*P(1,2)*P(2,3)*Metric(3,4) + P(-1,1)*P(-1,2)*P(1,4)*P(2,3)*Metric(3,4) - P(-1,1)*P(-1,3)*P(1,2)*P(2,4)*Metric(3,4) + P(-1,1)*P(-1,2)*P(1,3)*P(2,4)*Metric(3,4) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV40 = Lorentz(name = 'VVVV40',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,2)*P(2,1)*P(3,4)*P(4,3) - P(-1,1)*P(-1,2)*P(3,4)*P(4,3)*Metric(1,2) - P(-1,3)*P(-1,4)*P(1,2)*P(2,1)*Metric(3,4) + P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVV41 = Lorentz(name = 'VVVV41',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,3)*P(2,4)*P(3,1)*P(4,2) + P(1,2)*P(2,1)*P(3,4)*P(4,3) - P(-1,1)*P(-1,2)*P(3,4)*P(4,3)*Metric(1,2) - P(-1,1)*P(-1,3)*P(2,4)*P(4,2)*Metric(1,3) - P(-1,2)*P(-1,4)*P(1,3)*P(3,1)*Metric(2,4) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,4)*P(1,2)*P(2,1)*Metric(3,4) + P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVV42 = Lorentz(name = 'VVVV42',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,4)*P(2,3)*P(3,2)*P(4,1) + P(1,3)*P(2,4)*P(3,1)*P(4,2) + P(1,2)*P(2,1)*P(3,4)*P(4,3) - P(-1,1)*P(-1,2)*P(3,4)*P(4,3)*Metric(1,2) - P(-1,1)*P(-1,3)*P(2,4)*P(4,2)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*P(3,2)*Metric(1,4) - P(-1,2)*P(-1,3)*P(1,4)*P(4,1)*Metric(2,3) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,4)*P(1,3)*P(3,1)*Metric(2,4) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,4)*P(1,2)*P(2,1)*Metric(3,4) + P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVV43 = Lorentz(name = 'VVVV43',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,4)*P(2,3)*P(3,2)*P(4,1) + P(1,3)*P(2,4)*P(3,1)*P(4,2) + 2*P(1,2)*P(2,1)*P(3,4)*P(4,3) - 2*P(-1,1)*P(-1,2)*P(3,4)*P(4,3)*Metric(1,2) - P(-1,1)*P(-1,3)*P(2,4)*P(4,2)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*P(3,2)*Metric(1,4) - P(-1,2)*P(-1,3)*P(1,4)*P(4,1)*Metric(2,3) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,4)*P(1,3)*P(3,1)*Metric(2,4) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) - 2*P(-1,3)*P(-1,4)*P(1,2)*P(2,1)*Metric(3,4) + 2*P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVSSS1 = Lorentz(name = 'VVSSS1',
                 spins = [ 3, 3, 1, 1, 1 ],
                 structure = 'P(1,4)*P(2,3) + P(1,5)*P(2,3) + P(1,3)*P(2,4) + P(1,5)*P(2,4) + P(1,3)*P(2,5) + P(1,4)*P(2,5)')

VVSSS2 = Lorentz(name = 'VVSSS2',
                 spins = [ 3, 3, 1, 1, 1 ],
                 structure = 'P(1,4)*P(2,3) + P(1,5)*P(2,3) + P(1,3)*P(2,4) + P(1,5)*P(2,4) + P(1,3)*P(2,5) + P(1,4)*P(2,5) - P(-1,3)*P(-1,4)*Metric(1,2) - P(-1,3)*P(-1,5)*Metric(1,2) - P(-1,4)*P(-1,5)*Metric(1,2)')

VVSSS3 = Lorentz(name = 'VVSSS3',
                 spins = [ 3, 3, 1, 1, 1 ],
                 structure = 'P(-1,3)*P(-1,4)*Metric(1,2) + P(-1,3)*P(-1,5)*Metric(1,2) + P(-1,4)*P(-1,5)*Metric(1,2)')

VVVSS1 = Lorentz(name = 'VVVSS1',
                 spins = [ 3, 3, 3, 1, 1 ],
                 structure = 'P(1,3)*P(2,4)*P(3,1) + P(1,3)*P(2,5)*P(3,1) - P(1,2)*P(2,1)*P(3,4) - P(1,2)*P(2,1)*P(3,5) - 2*P(-1,4)*P(-1,5)*P(3,1)*Metric(1,2) + P(-1,1)*P(-1,2)*P(3,4)*Metric(1,2) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,2) + 2*P(-1,4)*P(-1,5)*P(2,1)*Metric(1,3) - P(-1,1)*P(-1,3)*P(2,4)*Metric(1,3) - P(-1,1)*P(-1,3)*P(2,5)*Metric(1,3)')

VVVSS2 = Lorentz(name = 'VVVSS2',
                 spins = [ 3, 3, 3, 1, 1 ],
                 structure = 'P(2,4)*Metric(1,3) + P(2,5)*Metric(1,3) - P(1,4)*Metric(2,3) - P(1,5)*Metric(2,3)')

VVVSS3 = Lorentz(name = 'VVVSS3',
                 spins = [ 3, 3, 3, 1, 1 ],
                 structure = '-(P(1,2)*P(2,4)*P(3,1)) - P(1,2)*P(2,5)*P(3,1) + P(1,4)*P(2,1)*P(3,2) + P(1,5)*P(2,1)*P(3,2) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3)')

VVVSS4 = Lorentz(name = 'VVVSS4',
                 spins = [ 3, 3, 3, 1, 1 ],
                 structure = '-(P(1,4)*P(2,3)*P(3,1)) - P(1,5)*P(2,3)*P(3,1) + P(1,2)*P(2,4)*P(3,1) + 2*P(1,5)*P(2,4)*P(3,1) + P(1,2)*P(2,5)*P(3,1) + 2*P(1,4)*P(2,5)*P(3,1) + P(1,4)*P(2,1)*P(3,2) + P(1,5)*P(2,1)*P(3,2) - P(1,3)*P(2,1)*P(3,4) - 2*P(1,5)*P(2,1)*P(3,4) - P(1,3)*P(2,1)*P(3,5) - 2*P(1,4)*P(2,1)*P(3,5) - P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) - P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2) - P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2) - P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2) + P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2) + 2*P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2) + P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2) + 2*P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2) + P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3) + P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3) - P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) - 2*P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3) - P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3) - 2*P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3) - P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3) + P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3)')

VVVSS5 = Lorentz(name = 'VVVSS5',
                 spins = [ 3, 3, 3, 1, 1 ],
                 structure = 'P(1,4)*P(2,3)*P(3,1) + P(1,5)*P(2,3)*P(3,1) - P(1,3)*P(2,4)*P(3,2) - P(1,3)*P(2,5)*P(3,2) + P(1,3)*P(2,1)*P(3,4) - P(1,2)*P(2,3)*P(3,4) + 2*P(1,5)*P(2,3)*P(3,4) - 2*P(1,3)*P(2,5)*P(3,4) + P(1,3)*P(2,1)*P(3,5) - P(1,2)*P(2,3)*P(3,5) + 2*P(1,4)*P(2,3)*P(3,5) - 2*P(1,3)*P(2,4)*P(3,5) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2) - P(-1,3)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,3)*P(-1,5)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2) + P(-1,2)*P(-1,3)*P(3,4)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2) + P(-1,2)*P(-1,3)*P(3,5)*Metric(1,2) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) - P(-1,2)*P(-1,4)*P(2,3)*Metric(1,3) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3) - P(-1,2)*P(-1,5)*P(2,3)*Metric(1,3) + P(-1,2)*P(-1,3)*P(2,4)*Metric(1,3) + 2*P(-1,3)*P(-1,5)*P(2,4)*Metric(1,3) + P(-1,2)*P(-1,3)*P(2,5)*Metric(1,3) + 2*P(-1,3)*P(-1,4)*P(2,5)*Metric(1,3) + P(-1,3)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,3)*P(-1,5)*P(1,2)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) + P(-1,2)*P(-1,4)*P(1,3)*Metric(2,3) + P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3) + P(-1,2)*P(-1,5)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3) - 2*P(-1,3)*P(-1,5)*P(1,4)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3) - 2*P(-1,3)*P(-1,4)*P(1,5)*Metric(2,3)')

VVVSS6 = Lorentz(name = 'VVVSS6',
                 spins = [ 3, 3, 3, 1, 1 ],
                 structure = 'P(1,5)*P(2,4)*P(3,1) + P(1,4)*P(2,5)*P(3,1) - P(1,5)*P(2,4)*P(3,2) - P(1,4)*P(2,5)*P(3,2) - P(1,5)*P(2,1)*P(3,4) + P(1,5)*P(2,3)*P(3,4) + P(1,2)*P(2,5)*P(3,4) - P(1,3)*P(2,5)*P(3,4) - P(1,4)*P(2,1)*P(3,5) + P(1,4)*P(2,3)*P(3,5) + P(1,2)*P(2,4)*P(3,5) - P(1,3)*P(2,4)*P(3,5) + P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,2) + P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,2) - P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3) + P(-1,3)*P(-1,5)*P(2,4)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3) + P(-1,3)*P(-1,4)*P(2,5)*Metric(1,3) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,3) - P(-1,3)*P(-1,5)*P(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,3) - P(-1,3)*P(-1,4)*P(1,5)*Metric(2,3)')

VVVSS7 = Lorentz(name = 'VVVSS7',
                 spins = [ 3, 3, 3, 1, 1 ],
                 structure = '-(P(1,4)*P(2,3)*P(3,1)) - P(1,5)*P(2,3)*P(3,1) - P(1,2)*P(2,4)*P(3,1) - 2*P(1,5)*P(2,4)*P(3,1) - P(1,2)*P(2,5)*P(3,1) - 2*P(1,4)*P(2,5)*P(3,1) + P(1,4)*P(2,1)*P(3,2) + P(1,5)*P(2,1)*P(3,2) + 2*P(1,5)*P(2,4)*P(3,2) + 2*P(1,4)*P(2,5)*P(3,2) + P(1,3)*P(2,1)*P(3,4) + 2*P(1,5)*P(2,1)*P(3,4) - 2*P(1,5)*P(2,3)*P(3,4) - 2*P(1,2)*P(2,5)*P(3,4) + 2*P(1,3)*P(2,5)*P(3,4) + P(1,3)*P(2,1)*P(3,5) + 2*P(1,4)*P(2,1)*P(3,5) - 2*P(1,4)*P(2,3)*P(3,5) - 2*P(1,2)*P(2,4)*P(3,5) + 2*P(1,3)*P(2,4)*P(3,5) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2) + P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2) - 2*P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2) + 2*P(-1,2)*P(-1,5)*P(3,4)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2) - 2*P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2) + 2*P(-1,2)*P(-1,4)*P(3,5)*Metric(1,2) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) + 2*P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3) - 2*P(-1,3)*P(-1,5)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3) + 2*P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3) - 2*P(-1,3)*P(-1,4)*P(2,5)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3) - P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3) - 2*P(-1,2)*P(-1,5)*P(1,4)*Metric(2,3) + 2*P(-1,3)*P(-1,5)*P(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3) + P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3) - 2*P(-1,2)*P(-1,4)*P(1,5)*Metric(2,3) + 2*P(-1,3)*P(-1,4)*P(1,5)*Metric(2,3)')

VVVSS8 = Lorentz(name = 'VVVSS8',
                 spins = [ 3, 3, 3, 1, 1 ],
                 structure = '-(P(1,4)*P(2,3)*P(3,1)) - P(1,5)*P(2,3)*P(3,1) - P(1,2)*P(2,4)*P(3,1) - 2*P(1,5)*P(2,4)*P(3,1) - P(1,2)*P(2,5)*P(3,1) - 2*P(1,4)*P(2,5)*P(3,1) + P(1,4)*P(2,1)*P(3,2) + P(1,5)*P(2,1)*P(3,2) + P(1,3)*P(2,4)*P(3,2) + 2*P(1,5)*P(2,4)*P(3,2) + P(1,3)*P(2,5)*P(3,2) + 2*P(1,4)*P(2,5)*P(3,2) + P(1,3)*P(2,1)*P(3,4) + 2*P(1,5)*P(2,1)*P(3,4) - P(1,2)*P(2,3)*P(3,4) - 2*P(1,5)*P(2,3)*P(3,4) - 2*P(1,2)*P(2,5)*P(3,4) + 2*P(1,3)*P(2,5)*P(3,4) + P(1,3)*P(2,1)*P(3,5) + 2*P(1,4)*P(2,1)*P(3,5) - P(1,2)*P(2,3)*P(3,5) - 2*P(1,4)*P(2,3)*P(3,5) - 2*P(1,2)*P(2,4)*P(3,5) + 2*P(1,3)*P(2,4)*P(3,5) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2) + P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,3)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2) - P(-1,3)*P(-1,5)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2) + P(-1,2)*P(-1,3)*P(3,4)*Metric(1,2) - 2*P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2) + 2*P(-1,2)*P(-1,5)*P(3,4)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2) + P(-1,2)*P(-1,3)*P(3,5)*Metric(1,2) - 2*P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2) + 2*P(-1,2)*P(-1,4)*P(3,5)*Metric(1,2) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,2)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3) + P(-1,2)*P(-1,5)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) - P(-1,2)*P(-1,3)*P(2,4)*Metric(1,3) + 2*P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3) - 2*P(-1,3)*P(-1,5)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3) - P(-1,2)*P(-1,3)*P(2,5)*Metric(1,3) + 2*P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3) - 2*P(-1,3)*P(-1,4)*P(2,5)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,3)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3) + P(-1,3)*P(-1,5)*P(1,2)*Metric(2,3) - P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,2)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3) - 2*P(-1,2)*P(-1,5)*P(1,4)*Metric(2,3) + 2*P(-1,3)*P(-1,5)*P(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3) + P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3) - 2*P(-1,2)*P(-1,4)*P(1,5)*Metric(2,3) + 2*P(-1,3)*P(-1,4)*P(1,5)*Metric(2,3)')

VVVSS9 = Lorentz(name = 'VVVSS9',
                 spins = [ 3, 3, 3, 1, 1 ],
                 structure = 'P(-1,4)*P(-1,5)*P(3,1)*Metric(1,2) - P(-1,4)*P(-1,5)*P(3,2)*Metric(1,2) - P(-1,4)*P(-1,5)*P(2,1)*Metric(1,3) + P(-1,4)*P(-1,5)*P(2,3)*Metric(1,3) + P(-1,4)*P(-1,5)*P(1,2)*Metric(2,3) - P(-1,4)*P(-1,5)*P(1,3)*Metric(2,3)')

VVVSS10 = Lorentz(name = 'VVVSS10',
                  spins = [ 3, 3, 3, 1, 1 ],
                  structure = '-(P(1,3)*P(2,4)*P(3,1)) - P(1,3)*P(2,5)*P(3,1) + P(1,4)*P(2,3)*P(3,2) + P(1,5)*P(2,3)*P(3,2) - 2*P(-1,4)*P(-1,5)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,3)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,3)*P(2,5)*Metric(1,3) + 2*P(-1,4)*P(-1,5)*P(1,3)*Metric(2,3) - P(-1,2)*P(-1,3)*P(1,4)*Metric(2,3) - P(-1,2)*P(-1,3)*P(1,5)*Metric(2,3)')

VVVVS1 = Lorentz(name = 'VVVVS1',
                 spins = [ 3, 3, 3, 3, 1 ],
                 structure = 'P(1,4)*P(4,1)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3)')

VVVVS2 = Lorentz(name = 'VVVVS2',
                 spins = [ 3, 3, 3, 3, 1 ],
                 structure = 'Metric(1,4)*Metric(2,3) + Metric(1,3)*Metric(2,4)')

VVVVS3 = Lorentz(name = 'VVVVS3',
                 spins = [ 3, 3, 3, 3, 1 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)')

VVVVS4 = Lorentz(name = 'VVVVS4',
                 spins = [ 3, 3, 3, 3, 1 ],
                 structure = 'P(2,4)*P(4,2)*Metric(1,3) + P(2,3)*P(3,2)*Metric(1,4) + P(1,4)*P(4,1)*Metric(2,3) - P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4)')

VVVVS5 = Lorentz(name = 'VVVVS5',
                 spins = [ 3, 3, 3, 3, 1 ],
                 structure = 'Metric(1,2)*Metric(3,4)')

VVVVS6 = Lorentz(name = 'VVVVS6',
                 spins = [ 3, 3, 3, 3, 1 ],
                 structure = 'P(2,4)*P(4,3)*Metric(1,3) + P(2,3)*P(3,4)*Metric(1,4) + P(1,4)*P(4,3)*Metric(2,3) - P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,4)*Metric(2,4) - P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,4)*P(2,3)*Metric(3,4) - P(1,3)*P(2,4)*Metric(3,4)')

VVVVS7 = Lorentz(name = 'VVVVS7',
                 spins = [ 3, 3, 3, 3, 1 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,4)*P(2,3)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4)')

VVVVS8 = Lorentz(name = 'VVVVS8',
                 spins = [ 3, 3, 3, 3, 1 ],
                 structure = 'Metric(1,4)*Metric(2,3) + Metric(1,3)*Metric(2,4) + Metric(1,2)*Metric(3,4)')

VVVVS9 = Lorentz(name = 'VVVVS9',
                 spins = [ 3, 3, 3, 3, 1 ],
                 structure = 'P(3,5)*P(4,1)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,1)*P(4,5)*Metric(1,2) + P(3,2)*P(4,5)*Metric(1,2) - P(2,1)*P(4,5)*Metric(1,3) - P(2,1)*P(3,5)*Metric(1,4) - P(1,2)*P(4,5)*Metric(2,3) - P(1,2)*P(3,5)*Metric(2,4) + 2*P(1,2)*P(2,1)*Metric(3,4) - 2*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVVS10 = Lorentz(name = 'VVVVS10',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(1,2)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVVS11 = Lorentz(name = 'VVVVS11',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(1,4)*P(4,1)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(1,2)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVVS12 = Lorentz(name = 'VVVVS12',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,5)*P(4,1)*Metric(1,2) + P(2,5)*P(4,1)*Metric(1,3) - P(2,5)*P(3,1)*Metric(1,4) - P(2,1)*P(3,5)*Metric(1,4) - P(1,4)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(1,2)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVVS13 = Lorentz(name = 'VVVVS13',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(2,5)*P(3,4)*Metric(1,4) + P(2,4)*P(3,5)*Metric(1,4) + P(1,4)*P(4,1)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,1)*Metric(2,4) - P(1,4)*P(3,5)*Metric(2,4) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(1,2)*P(2,1)*Metric(3,4) - P(1,4)*P(2,5)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVVS14 = Lorentz(name = 'VVVVS14',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,4)*P(4,1)*Metric(1,2) + P(2,4)*P(4,1)*Metric(1,3) - P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) + P(1,4)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,4)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVS15 = Lorentz(name = 'VVVVS15',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVS16 = Lorentz(name = 'VVVVS16',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,4)*P(4,1)*Metric(1,2) + P(3,4)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) - P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) + P(2,3)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) + P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) + P(2,4)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) + P(1,3)*P(4,1)*Metric(2,3) - P(1,3)*P(4,2)*Metric(2,3) + P(1,4)*P(4,2)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,4)*P(3,1)*Metric(2,4) + P(1,3)*P(3,2)*Metric(2,4) - P(1,4)*P(3,2)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVS17 = Lorentz(name = 'VVVVS17',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,4)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) - P(3,2)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,4)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(1,3)*P(4,2)*Metric(2,3) - P(1,4)*P(4,2)*Metric(2,3) + P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) - P(1,3)*P(3,2)*Metric(2,4) + P(1,4)*P(3,2)*Metric(2,4) + P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) - P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) - P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVS18 = Lorentz(name = 'VVVVS18',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,4)*P(4,3)*Metric(1,2) - P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVS19 = Lorentz(name = 'VVVVS19',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,4)*P(4,3)*Metric(1,2) - (P(2,4)*P(4,2)*Metric(1,3))/2. - (P(2,5)*P(4,3)*Metric(1,3))/2. - (P(2,3)*P(3,2)*Metric(1,4))/2. - (P(2,5)*P(3,4)*Metric(1,4))/2. - (P(1,4)*P(4,1)*Metric(2,3))/2. - (P(1,5)*P(4,3)*Metric(2,3))/2. + (P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3))/2. - (P(1,3)*P(3,1)*Metric(2,4))/2. - (P(1,5)*P(3,4)*Metric(2,4))/2. + (P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4))/2. + (P(1,5)*P(2,3)*Metric(3,4))/2. + (P(1,5)*P(2,4)*Metric(3,4))/2. + (P(1,3)*P(2,5)*Metric(3,4))/2. + (P(1,4)*P(2,5)*Metric(3,4))/2. - P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVS20 = Lorentz(name = 'VVVVS20',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,4)*P(4,3)*Metric(1,2) + P(1,2)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVS21 = Lorentz(name = 'VVVVS21',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,4)*P(4,3)*Metric(1,2) + P(2,4)*P(4,2)*Metric(1,3) + P(2,3)*P(3,2)*Metric(1,4) + P(1,4)*P(4,1)*Metric(2,3) - P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,2)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVS22 = Lorentz(name = 'VVVVS22',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,4)*P(4,1)*Metric(1,2) - P(3,5)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) - P(2,5)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) + P(2,5)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) + P(2,1)*P(3,5)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) - 2*P(1,5)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + 2*P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) + P(1,4)*P(3,1)*Metric(2,4) + P(1,5)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,5)*P(2,1)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVS23 = Lorentz(name = 'VVVVS23',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,5)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,1)*P(4,5)*Metric(1,2) + P(3,2)*P(4,5)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - P(2,5)*P(4,2)*Metric(1,3) - P(2,1)*P(4,5)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - P(2,5)*P(3,2)*Metric(1,4) - P(2,1)*P(3,5)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,5)*P(4,1)*Metric(2,3) - P(1,2)*P(4,5)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,5)*P(3,1)*Metric(2,4) - P(1,2)*P(3,5)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4) + 2*P(1,5)*P(2,1)*Metric(3,4) + 2*P(1,2)*P(2,5)*Metric(3,4) - 2*P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVS24 = Lorentz(name = 'VVVVS24',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,1)*P(4,2)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) + P(2,5)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,5)*P(3,2)*Metric(1,4) - P(2,3)*P(3,5)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) - P(1,5)*P(4,2)*Metric(2,3) - P(1,5)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(1,2)*P(3,1)*Metric(2,4) + P(1,5)*P(3,2)*Metric(2,4) - P(1,2)*P(3,5)*Metric(2,4) + P(1,3)*P(3,5)*Metric(2,4) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,5)*P(2,3)*Metric(3,4) + P(1,2)*P(2,5)*Metric(3,4) - P(1,3)*P(2,5)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVS25 = Lorentz(name = 'VVVVS25',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) - (P(3,5)*P(4,1)*Metric(1,2))/2. + P(3,1)*P(4,2)*Metric(1,2) - (P(3,5)*P(4,2)*Metric(1,2))/2. - (P(3,1)*P(4,5)*Metric(1,2))/2. - (P(3,2)*P(4,5)*Metric(1,2))/2. - P(2,1)*P(4,2)*Metric(1,3) - (P(2,5)*P(4,2)*Metric(1,3))/2. + (P(2,1)*P(4,5)*Metric(1,3))/2. - P(2,1)*P(3,2)*Metric(1,4) - (P(2,5)*P(3,2)*Metric(1,4))/2. + (P(2,1)*P(3,5)*Metric(1,4))/2. - P(1,2)*P(4,1)*Metric(2,3) - (P(1,5)*P(4,1)*Metric(2,3))/2. + (P(1,2)*P(4,5)*Metric(2,3))/2. + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. - P(1,2)*P(3,1)*Metric(2,4) - (P(1,5)*P(3,1)*Metric(2,4))/2. + (P(1,2)*P(3,5)*Metric(2,4))/2. + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + P(1,5)*P(2,1)*Metric(3,4) + P(1,2)*P(2,5)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVS26 = Lorentz(name = 'VVVVS26',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) + (P(3,4)*P(4,1)*Metric(1,2))/2. + (P(3,5)*P(4,1)*Metric(1,2))/2. + P(3,1)*P(4,2)*Metric(1,2) + (P(3,4)*P(4,2)*Metric(1,2))/2. + (P(3,5)*P(4,2)*Metric(1,2))/2. + (P(3,1)*P(4,3)*Metric(1,2))/2. + (P(3,2)*P(4,3)*Metric(1,2))/2. + (P(3,1)*P(4,5)*Metric(1,2))/2. + (P(3,2)*P(4,5)*Metric(1,2))/2. + (P(2,3)*P(4,1)*Metric(1,3))/2. - (P(2,4)*P(4,1)*Metric(1,3))/2. - P(2,1)*P(4,2)*Metric(1,3) - (P(2,3)*P(4,2)*Metric(1,3))/2. - (P(2,5)*P(4,2)*Metric(1,3))/2. - (P(2,1)*P(4,3)*Metric(1,3))/2. - (P(2,1)*P(4,5)*Metric(1,3))/2. - (P(2,3)*P(3,1)*Metric(1,4))/2. + (P(2,4)*P(3,1)*Metric(1,4))/2. - P(2,1)*P(3,2)*Metric(1,4) - (P(2,4)*P(3,2)*Metric(1,4))/2. - (P(2,5)*P(3,2)*Metric(1,4))/2. - (P(2,1)*P(3,4)*Metric(1,4))/2. - (P(2,1)*P(3,5)*Metric(1,4))/2. - P(1,2)*P(4,1)*Metric(2,3) - (P(1,3)*P(4,1)*Metric(2,3))/2. - (P(1,5)*P(4,1)*Metric(2,3))/2. + (P(1,3)*P(4,2)*Metric(2,3))/2. - (P(1,4)*P(4,2)*Metric(2,3))/2. - (P(1,2)*P(4,3)*Metric(2,3))/2. - (P(1,2)*P(4,5)*Metric(2,3))/2. + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + (P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. - P(1,2)*P(3,1)*Metric(2,4) - (P(1,4)*P(3,1)*Metric(2,4))/2. - (P(1,5)*P(3,1)*Metric(2,4))/2. - (P(1,3)*P(3,2)*Metric(2,4))/2. + (P(1,4)*P(3,2)*Metric(2,4))/2. - (P(1,2)*P(3,4)*Metric(2,4))/2. - (P(1,2)*P(3,5)*Metric(2,4))/2. + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + (P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(1,3)*P(2,1)*Metric(3,4))/2. + (P(1,4)*P(2,1)*Metric(3,4))/2. + P(1,5)*P(2,1)*Metric(3,4) + (P(1,2)*P(2,3)*Metric(3,4))/2. + (P(1,2)*P(2,4)*Metric(3,4))/2. + P(1,2)*P(2,5)*Metric(3,4) - (P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4))/2. - (P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4))/2. - (P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4))/2. - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVS27 = Lorentz(name = 'VVVVS27',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,4)*P(4,1)*Metric(1,2) + P(3,4)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) + 2*P(3,5)*P(4,3)*Metric(1,2) + 2*P(3,4)*P(4,5)*Metric(1,2) - P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) + P(2,3)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) - 2*P(2,4)*P(4,3)*Metric(1,3) + P(2,5)*P(4,3)*Metric(1,3) - P(2,4)*P(4,5)*Metric(1,3) + P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) + P(2,4)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - 2*P(2,3)*P(3,4)*Metric(1,4) + P(2,5)*P(3,4)*Metric(1,4) - P(2,3)*P(3,5)*Metric(1,4) + P(1,3)*P(4,1)*Metric(2,3) - P(1,3)*P(4,2)*Metric(2,3) + P(1,4)*P(4,2)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - 2*P(1,4)*P(4,3)*Metric(2,3) + P(1,5)*P(4,3)*Metric(2,3) - P(1,4)*P(4,5)*Metric(2,3) - P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + 2*P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(1,4)*P(3,1)*Metric(2,4) + P(1,3)*P(3,2)*Metric(2,4) - P(1,4)*P(3,2)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - 2*P(1,3)*P(3,4)*Metric(2,4) + P(1,5)*P(3,4)*Metric(2,4) - P(1,3)*P(3,5)*Metric(2,4) - P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + 2*P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + 2*P(1,4)*P(2,3)*Metric(3,4) - P(1,5)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) + 2*P(1,3)*P(2,4)*Metric(3,4) - P(1,5)*P(2,4)*Metric(3,4) - P(1,3)*P(2,5)*Metric(3,4) - P(1,4)*P(2,5)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4) - 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVS28 = Lorentz(name = 'VVVVS28',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,4)*P(4,1)*Metric(1,2) + P(3,5)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) + P(3,4)*P(4,2)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) + 2*P(3,5)*P(4,3)*Metric(1,2) + P(3,1)*P(4,5)*Metric(1,2) + P(3,2)*P(4,5)*Metric(1,2) + 2*P(3,4)*P(4,5)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(4,2)*Metric(1,3) - P(2,5)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,5)*P(4,3)*Metric(1,3) - P(2,1)*P(4,5)*Metric(1,3) - P(2,4)*P(4,5)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,4)*P(3,2)*Metric(1,4) - P(2,5)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(2,5)*P(3,4)*Metric(1,4) - P(2,1)*P(3,5)*Metric(1,4) - P(2,3)*P(3,5)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) - P(1,5)*P(4,1)*Metric(2,3) + P(1,3)*P(4,2)*Metric(2,3) - P(1,4)*P(4,2)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) - P(1,5)*P(4,3)*Metric(2,3) - P(1,2)*P(4,5)*Metric(2,3) - P(1,4)*P(4,5)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) - P(1,5)*P(3,1)*Metric(2,4) - P(1,3)*P(3,2)*Metric(2,4) + P(1,4)*P(3,2)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) - P(1,5)*P(3,4)*Metric(2,4) - P(1,2)*P(3,5)*Metric(2,4) - P(1,3)*P(3,5)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + 2*P(1,5)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) + P(1,5)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) + P(1,5)*P(2,4)*Metric(3,4) + 2*P(1,2)*P(2,5)*Metric(3,4) + P(1,3)*P(2,5)*Metric(3,4) + P(1,4)*P(2,5)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4) - 2*P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVS29 = Lorentz(name = 'VVVVS29',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,4)*P(4,1)*Metric(1,2) + P(3,5)*P(4,1)*Metric(1,2) - P(3,1)*P(4,2)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,4)*P(4,5)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) + P(2,5)*P(4,1)*Metric(1,3) + P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) + P(2,5)*P(4,3)*Metric(1,3) + P(2,4)*P(4,5)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) - P(2,5)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,5)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - P(2,5)*P(3,4)*Metric(1,4) - P(2,1)*P(3,5)*Metric(1,4) - P(2,3)*P(3,5)*Metric(1,4) - P(2,4)*P(3,5)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) - 2*P(1,5)*P(4,1)*Metric(2,3) - P(1,5)*P(4,2)*Metric(2,3) - P(1,5)*P(4,3)*Metric(2,3) - 2*P(1,4)*P(4,5)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + 2*P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3) + 2*P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(1,2)*P(3,1)*Metric(2,4) + P(1,4)*P(3,1)*Metric(2,4) + P(1,5)*P(3,1)*Metric(2,4) + P(1,5)*P(3,2)*Metric(2,4) - P(1,2)*P(3,5)*Metric(2,4) + P(1,3)*P(3,5)*Metric(2,4) + P(1,4)*P(3,5)*Metric(2,4) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4) - P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,5)*P(2,1)*Metric(3,4) + P(1,5)*P(2,3)*Metric(3,4) + P(1,2)*P(2,5)*Metric(3,4) - P(1,3)*P(2,5)*Metric(3,4) + P(1,4)*P(2,5)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVS30 = Lorentz(name = 'VVVVS30',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,4)*P(4,1)*Metric(1,2) + (P(3,5)*P(4,1)*Metric(1,2))/2. + P(3,4)*P(4,2)*Metric(1,2) + (P(3,5)*P(4,2)*Metric(1,2))/2. + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) + P(3,5)*P(4,3)*Metric(1,2) + (P(3,1)*P(4,5)*Metric(1,2))/2. + (P(3,2)*P(4,5)*Metric(1,2))/2. + P(3,4)*P(4,5)*Metric(1,2) - (P(2,5)*P(4,2)*Metric(1,3))/2. - P(2,1)*P(4,3)*Metric(1,3) - (P(2,5)*P(4,3)*Metric(1,3))/2. - (P(2,1)*P(4,5)*Metric(1,3))/2. - (P(2,4)*P(4,5)*Metric(1,3))/2. - (P(2,5)*P(3,2)*Metric(1,4))/2. - P(2,1)*P(3,4)*Metric(1,4) - (P(2,5)*P(3,4)*Metric(1,4))/2. - (P(2,1)*P(3,5)*Metric(1,4))/2. - (P(2,3)*P(3,5)*Metric(1,4))/2. - (P(1,5)*P(4,1)*Metric(2,3))/2. - P(1,2)*P(4,3)*Metric(2,3) - (P(1,5)*P(4,3)*Metric(2,3))/2. - (P(1,2)*P(4,5)*Metric(2,3))/2. - (P(1,4)*P(4,5)*Metric(2,3))/2. + (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. - (P(1,5)*P(3,1)*Metric(2,4))/2. - P(1,2)*P(3,4)*Metric(2,4) - (P(1,5)*P(3,4)*Metric(2,4))/2. - (P(1,2)*P(3,5)*Metric(2,4))/2. - (P(1,3)*P(3,5)*Metric(2,4))/2. + (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,5)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + (P(1,5)*P(2,3)*Metric(3,4))/2. + P(1,2)*P(2,4)*Metric(3,4) + (P(1,5)*P(2,4)*Metric(3,4))/2. + P(1,2)*P(2,5)*Metric(3,4) + (P(1,3)*P(2,5)*Metric(3,4))/2. + (P(1,4)*P(2,5)*Metric(3,4))/2. - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVS31 = Lorentz(name = 'VVVVS31',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) - P(3,4)*P(4,5)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,5)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(2,5)*P(3,4)*Metric(1,4) - P(2,4)*P(3,5)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + 2*P(1,4)*P(4,5)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - 2*P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) + P(1,4)*P(3,5)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) + P(1,4)*P(2,5)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) + P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVV1 = Lorentz(name = 'VVVVV1',
                 spins = [ 3, 3, 3, 3, 3 ],
                 structure = 'P(2,3)*P(4,2)*P(5,1)*Metric(1,3) + P(2,5)*P(4,2)*P(5,1)*Metric(1,3) - P(2,3)*P(4,1)*P(5,2)*Metric(1,3) - P(2,4)*P(4,1)*P(5,2)*Metric(1,3) - P(2,4)*P(3,2)*P(5,1)*Metric(1,4) - P(2,5)*P(3,2)*P(5,1)*Metric(1,4) + P(2,3)*P(3,1)*P(5,2)*Metric(1,4) + P(2,4)*P(3,1)*P(5,2)*Metric(1,4) + P(2,4)*P(3,2)*P(4,1)*Metric(1,5) + P(2,5)*P(3,2)*P(4,1)*Metric(1,5) - P(2,3)*P(3,1)*P(4,2)*Metric(1,5) - P(2,5)*P(3,1)*P(4,2)*Metric(1,5) - P(1,3)*P(4,2)*P(5,1)*Metric(2,3) - P(1,4)*P(4,2)*P(5,1)*Metric(2,3) + P(1,3)*P(4,1)*P(5,2)*Metric(2,3) + P(1,5)*P(4,1)*P(5,2)*Metric(2,3) + P(-1,2)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,3)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,3)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,4)*P(4,2)*Metric(1,5)*Metric(2,3) + P(1,3)*P(3,2)*P(5,1)*Metric(2,4) + P(1,4)*P(3,2)*P(5,1)*Metric(2,4) - P(1,4)*P(3,1)*P(5,2)*Metric(2,4) - P(1,5)*P(3,1)*P(5,2)*Metric(2,4) - P(-1,2)*P(-1,3)*P(5,1)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*P(3,1)*Metric(1,5)*Metric(2,4) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,3)*P(3,2)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,5)*Metric(2,4) - P(1,3)*P(3,2)*P(4,1)*Metric(2,5) - P(1,5)*P(3,2)*P(4,1)*Metric(2,5) + P(1,4)*P(3,1)*P(4,2)*Metric(2,5) + P(1,5)*P(3,1)*P(4,2)*Metric(2,5) + P(-1,2)*P(-1,3)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,4)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,4)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,2)*P(-1,3)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,2)*P(-1,4)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,3)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5)')

VVVVV2 = Lorentz(name = 'VVVVV2',
                 spins = [ 3, 3, 3, 3, 3 ],
                 structure = 'P(2,4)*P(4,2)*P(5,1)*Metric(1,3) - P(2,5)*P(4,1)*P(5,2)*Metric(1,3) - P(2,3)*P(3,2)*P(5,1)*Metric(1,4) + P(2,5)*P(3,1)*P(5,2)*Metric(1,4) + P(2,3)*P(3,2)*P(4,1)*Metric(1,5) - P(2,4)*P(3,1)*P(4,2)*Metric(1,5) - P(1,5)*P(4,2)*P(5,1)*Metric(2,3) + P(1,4)*P(4,1)*P(5,2)*Metric(2,3) + P(-1,2)*P(-1,3)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,3)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(1,5)*P(3,2)*P(5,1)*Metric(2,4) - P(1,3)*P(3,1)*P(5,2)*Metric(2,4) - P(-1,2)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,3)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) - P(1,4)*P(3,2)*P(4,1)*Metric(2,5) + P(1,3)*P(3,1)*P(4,2)*Metric(2,5) + P(-1,2)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,3)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,2)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5)')

VVVVV3 = Lorentz(name = 'VVVVV3',
                 spins = [ 3, 3, 3, 3, 3 ],
                 structure = 'P(2,5)*P(4,1)*P(5,2)*Metric(1,3) - P(2,5)*P(4,3)*P(5,2)*Metric(1,3) - P(2,5)*P(3,1)*P(5,2)*Metric(1,4) + P(2,5)*P(3,4)*P(5,2)*Metric(1,4) + P(1,5)*P(4,2)*P(5,1)*Metric(2,3) - P(1,5)*P(4,3)*P(5,1)*Metric(2,3) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) - P(1,5)*P(3,2)*P(5,1)*Metric(2,4) + P(1,5)*P(3,4)*P(5,1)*Metric(2,4) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(1,5)*P(2,3)*P(5,1)*Metric(3,4) - P(1,5)*P(2,4)*P(5,1)*Metric(3,4) + P(1,3)*P(2,5)*P(5,2)*Metric(3,4) - P(1,4)*P(2,5)*P(5,2)*Metric(3,4) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4)')

VVVVV4 = Lorentz(name = 'VVVVV4',
                 spins = [ 3, 3, 3, 3, 3 ],
                 structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5)')

VVVVV5 = Lorentz(name = 'VVVVV5',
                 spins = [ 3, 3, 3, 3, 3 ],
                 structure = 'P(1,5)*P(4,2)*P(5,1)*Metric(2,3) - P(1,5)*P(4,3)*P(5,1)*Metric(2,3) + P(1,4)*P(4,1)*P(5,2)*Metric(2,3) - P(1,4)*P(4,1)*P(5,3)*Metric(2,3) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) - P(1,5)*P(3,2)*P(5,1)*Metric(2,4) + P(1,5)*P(3,4)*P(5,1)*Metric(2,4) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) - P(1,4)*P(3,2)*P(4,1)*Metric(2,5) + P(1,4)*P(3,5)*P(4,1)*Metric(2,5) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,5)*P(2,3)*P(5,1)*Metric(3,4) - P(1,5)*P(2,4)*P(5,1)*Metric(3,4) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) + P(1,4)*P(2,3)*P(4,1)*Metric(3,5) - P(1,4)*P(2,5)*P(4,1)*Metric(3,5) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5)')

VVVVV6 = Lorentz(name = 'VVVVV6',
                 spins = [ 3, 3, 3, 3, 3 ],
                 structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5)')

VVVVV7 = Lorentz(name = 'VVVVV7',
                 spins = [ 3, 3, 3, 3, 3 ],
                 structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(4,3)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(2,5)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,4)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5)')

VVVVV8 = Lorentz(name = 'VVVVV8',
                 spins = [ 3, 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,3)*P(5,1)*Metric(1,2) + P(3,5)*P(4,3)*P(5,1)*Metric(1,2) + P(3,1)*P(4,3)*P(5,2)*Metric(1,2) + P(3,5)*P(4,3)*P(5,2)*Metric(1,2) - P(3,2)*P(4,1)*P(5,3)*Metric(1,2) - P(3,4)*P(4,1)*P(5,3)*Metric(1,2) - P(3,1)*P(4,2)*P(5,3)*Metric(1,2) - P(3,4)*P(4,2)*P(5,3)*Metric(1,2) + P(2,3)*P(4,2)*P(5,1)*Metric(1,3) + P(2,5)*P(4,2)*P(5,1)*Metric(1,3) - P(2,3)*P(4,1)*P(5,2)*Metric(1,3) - P(2,4)*P(4,1)*P(5,2)*Metric(1,3) - P(2,1)*P(4,3)*P(5,2)*Metric(1,3) - P(2,4)*P(4,3)*P(5,2)*Metric(1,3) + P(2,1)*P(4,2)*P(5,3)*Metric(1,3) + P(2,5)*P(4,2)*P(5,3)*Metric(1,3) - P(2,4)*P(3,2)*P(5,1)*Metric(1,4) - P(2,5)*P(3,2)*P(5,1)*Metric(1,4) - P(2,3)*P(3,4)*P(5,1)*Metric(1,4) - P(2,3)*P(3,5)*P(5,1)*Metric(1,4) + P(2,3)*P(3,1)*P(5,2)*Metric(1,4) + P(2,4)*P(3,1)*P(5,2)*Metric(1,4) + P(2,1)*P(3,2)*P(5,3)*Metric(1,4) + P(2,1)*P(3,4)*P(5,3)*Metric(1,4) + P(2,4)*P(3,2)*P(4,1)*Metric(1,5) + P(2,5)*P(3,2)*P(4,1)*Metric(1,5) + P(2,3)*P(3,4)*P(4,1)*Metric(1,5) + P(2,3)*P(3,5)*P(4,1)*Metric(1,5) - P(2,3)*P(3,1)*P(4,2)*Metric(1,5) - P(2,5)*P(3,1)*P(4,2)*Metric(1,5) - P(2,1)*P(3,2)*P(4,3)*Metric(1,5) - P(2,1)*P(3,5)*P(4,3)*Metric(1,5) - P(1,3)*P(4,2)*P(5,1)*Metric(2,3) - P(1,4)*P(4,2)*P(5,1)*Metric(2,3) - P(1,2)*P(4,3)*P(5,1)*Metric(2,3) - P(1,4)*P(4,3)*P(5,1)*Metric(2,3) + P(1,3)*P(4,1)*P(5,2)*Metric(2,3) + P(1,5)*P(4,1)*P(5,2)*Metric(2,3) + P(1,2)*P(4,1)*P(5,3)*Metric(2,3) + P(1,5)*P(4,1)*P(5,3)*Metric(2,3) + P(-1,2)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,3)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,3)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,4)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,4)*P(4,3)*Metric(1,5)*Metric(2,3) + P(1,3)*P(3,2)*P(5,1)*Metric(2,4) + P(1,4)*P(3,2)*P(5,1)*Metric(2,4) - P(1,4)*P(3,1)*P(5,2)*Metric(2,4) - P(1,5)*P(3,1)*P(5,2)*Metric(2,4) - P(1,3)*P(3,4)*P(5,2)*Metric(2,4) - P(1,3)*P(3,5)*P(5,2)*Metric(2,4) + P(1,2)*P(3,1)*P(5,3)*Metric(2,4) + P(1,2)*P(3,4)*P(5,3)*Metric(2,4) - P(-1,2)*P(-1,3)*P(5,1)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,5)*P(5,3)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*P(3,1)*Metric(1,5)*Metric(2,4) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,3)*P(3,2)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,5)*Metric(2,4) - P(1,3)*P(3,2)*P(4,1)*Metric(2,5) - P(1,5)*P(3,2)*P(4,1)*Metric(2,5) + P(1,4)*P(3,1)*P(4,2)*Metric(2,5) + P(1,5)*P(3,1)*P(4,2)*Metric(2,5) + P(1,3)*P(3,4)*P(4,2)*Metric(2,5) + P(1,3)*P(3,5)*P(4,2)*Metric(2,5) - P(1,2)*P(3,1)*P(4,3)*Metric(2,5) - P(1,2)*P(3,5)*P(4,3)*Metric(2,5) + P(-1,2)*P(-1,3)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,4)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,4)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,3)*P(-1,4)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,3)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,4)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,2)*P(-1,3)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,2)*P(-1,4)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,3)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) + P(1,2)*P(2,3)*P(5,1)*Metric(3,4) + P(1,4)*P(2,3)*P(5,1)*Metric(3,4) + P(1,3)*P(2,1)*P(5,2)*Metric(3,4) + P(1,3)*P(2,4)*P(5,2)*Metric(3,4) - P(1,4)*P(2,1)*P(5,3)*Metric(3,4) - P(1,5)*P(2,1)*P(5,3)*Metric(3,4) - P(1,2)*P(2,4)*P(5,3)*Metric(3,4) - P(1,2)*P(2,5)*P(5,3)*Metric(3,4) - P(-1,2)*P(-1,3)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,3)*P(5,2)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(1,2)*Metric(2,5)*Metric(3,4) + P(-1,3)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(1,3)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,4)*P(1,3)*Metric(2,5)*Metric(3,4) - P(1,2)*P(2,3)*P(4,1)*Metric(3,5) - P(1,5)*P(2,3)*P(4,1)*Metric(3,5) - P(1,3)*P(2,1)*P(4,2)*Metric(3,5) - P(1,3)*P(2,5)*P(4,2)*Metric(3,5) + P(1,4)*P(2,1)*P(4,3)*Metric(3,5) + P(1,5)*P(2,1)*P(4,3)*Metric(3,5) + P(1,2)*P(2,4)*P(4,3)*Metric(3,5) + P(1,2)*P(2,5)*P(4,3)*Metric(3,5) + P(-1,2)*P(-1,3)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,4)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,3)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,4)*P(4,2)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,4)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,4)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,3)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,2)*P(2,3)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,3)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,3)*P(-1,4)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,2)*P(1,3)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,5)*P(1,3)*Metric(2,4)*Metric(3,5)')

VVVVV9 = Lorentz(name = 'VVVVV9',
                 spins = [ 3, 3, 3, 3, 3 ],
                 structure = 'P(3,4)*P(4,3)*P(5,1)*Metric(1,2) + P(3,4)*P(4,3)*P(5,2)*Metric(1,2) - P(3,5)*P(4,1)*P(5,3)*Metric(1,2) - P(3,5)*P(4,2)*P(5,3)*Metric(1,2) + P(2,4)*P(4,2)*P(5,1)*Metric(1,3) - P(2,5)*P(4,1)*P(5,2)*Metric(1,3) - P(2,5)*P(4,3)*P(5,2)*Metric(1,3) + P(2,4)*P(4,2)*P(5,3)*Metric(1,3) - 2*P(2,3)*P(3,2)*P(5,1)*Metric(1,4) + P(2,5)*P(3,1)*P(5,2)*Metric(1,4) + P(2,1)*P(3,5)*P(5,3)*Metric(1,4) + 2*P(2,3)*P(3,2)*P(4,1)*Metric(1,5) - P(2,4)*P(3,1)*P(4,2)*Metric(1,5) - P(2,1)*P(3,4)*P(4,3)*Metric(1,5) - P(1,5)*P(4,2)*P(5,1)*Metric(2,3) - P(1,5)*P(4,3)*P(5,1)*Metric(2,3) + P(1,4)*P(4,1)*P(5,2)*Metric(2,3) + P(1,4)*P(4,1)*P(5,3)*Metric(2,3) + 2*P(-1,2)*P(-1,3)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3) - 2*P(-1,2)*P(-1,3)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) + P(1,5)*P(3,2)*P(5,1)*Metric(2,4) - 2*P(1,3)*P(3,1)*P(5,2)*Metric(2,4) + P(1,2)*P(3,5)*P(5,3)*Metric(2,4) - P(-1,2)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) + 2*P(-1,1)*P(-1,3)*P(5,2)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) - P(1,4)*P(3,2)*P(4,1)*Metric(2,5) + 2*P(1,3)*P(3,1)*P(4,2)*Metric(2,5) - P(1,2)*P(3,4)*P(4,3)*Metric(2,5) + P(-1,2)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - 2*P(-1,1)*P(-1,3)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,2)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5) + P(1,5)*P(2,3)*P(5,1)*Metric(3,4) + P(1,3)*P(2,5)*P(5,2)*Metric(3,4) - 2*P(1,2)*P(2,1)*P(5,3)*Metric(3,4) - P(-1,3)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) + 2*P(-1,1)*P(-1,2)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,3)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*P(2,3)*P(4,1)*Metric(3,5) - P(1,3)*P(2,4)*P(4,2)*Metric(3,5) + 2*P(1,2)*P(2,1)*P(4,3)*Metric(3,5) + P(-1,3)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) - 2*P(-1,1)*P(-1,2)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5)')

VVVVV10 = Lorentz(name = 'VVVVV10',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(2,5)*P(3,4)*P(5,1)*Metric(1,4) - P(2,4)*P(3,5)*P(5,1)*Metric(1,4) - P(2,4)*P(3,5)*P(5,2)*Metric(1,4) + P(2,5)*P(3,4)*P(5,3)*Metric(1,4) - P(2,5)*P(3,4)*P(4,1)*Metric(1,5) + P(2,4)*P(3,5)*P(4,1)*Metric(1,5) - P(2,5)*P(3,4)*P(4,2)*Metric(1,5) + P(2,4)*P(3,5)*P(4,3)*Metric(1,5) + P(1,4)*P(3,5)*P(5,1)*Metric(2,4) - P(1,5)*P(3,4)*P(5,2)*Metric(2,4) + P(1,4)*P(3,5)*P(5,2)*Metric(2,4) - P(1,5)*P(3,4)*P(5,3)*Metric(2,4) + P(-1,2)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) + P(-1,3)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - P(-1,3)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) + P(1,5)*P(3,4)*P(4,1)*Metric(2,5) + P(1,5)*P(3,4)*P(4,2)*Metric(2,5) - P(1,4)*P(3,5)*P(4,2)*Metric(2,5) - P(1,4)*P(3,5)*P(4,3)*Metric(2,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) - P(-1,3)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(-1,2)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(-1,3)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) - P(1,4)*P(2,5)*P(5,1)*Metric(3,4) + P(1,5)*P(2,4)*P(5,2)*Metric(3,4) + P(1,5)*P(2,4)*P(5,3)*Metric(3,4) - P(1,4)*P(2,5)*P(5,3)*Metric(3,4) - P(-1,2)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) - P(-1,3)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) + P(-1,3)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) - P(1,5)*P(2,4)*P(4,1)*Metric(3,5) + P(1,4)*P(2,5)*P(4,2)*Metric(3,5) - P(1,5)*P(2,4)*P(4,3)*Metric(3,5) + P(1,4)*P(2,5)*P(4,3)*Metric(3,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) + P(-1,2)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - P(-1,2)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) + P(-1,3)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5)')

VVVVV11 = Lorentz(name = 'VVVVV11',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(2,5)*P(3,4)*P(5,2)*Metric(1,4) - P(2,4)*P(3,5)*P(5,3)*Metric(1,4) + P(2,4)*P(3,5)*P(4,2)*Metric(1,5) - P(2,5)*P(3,4)*P(4,3)*Metric(1,5) - P(1,5)*P(3,4)*P(5,1)*Metric(2,4) + P(1,4)*P(3,5)*P(5,3)*Metric(2,4) + P(-1,1)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - P(1,4)*P(3,5)*P(4,1)*Metric(2,5) + P(1,5)*P(3,4)*P(4,3)*Metric(2,5) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,5)*P(2,4)*P(5,1)*Metric(3,4) - P(1,4)*P(2,5)*P(5,2)*Metric(3,4) - P(-1,1)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) + P(-1,3)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + P(1,4)*P(2,5)*P(4,1)*Metric(3,5) - P(1,5)*P(2,4)*P(4,2)*Metric(3,5) + P(-1,3)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5)')

VVVVV12 = Lorentz(name = 'VVVVV12',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,4)*P(4,3)*P(5,1)*Metric(1,2) - P(3,4)*P(4,3)*P(5,2)*Metric(1,2) + P(3,5)*P(4,1)*P(5,3)*Metric(1,2) - P(3,5)*P(4,2)*P(5,3)*Metric(1,2) + P(2,4)*P(4,2)*P(5,1)*Metric(1,3) + P(2,5)*P(4,1)*P(5,2)*Metric(1,3) - P(2,5)*P(4,3)*P(5,2)*Metric(1,3) - P(2,4)*P(4,2)*P(5,3)*Metric(1,3) - P(2,5)*P(3,1)*P(5,2)*Metric(1,4) + P(2,5)*P(3,4)*P(5,2)*Metric(1,4) - P(2,1)*P(3,5)*P(5,3)*Metric(1,4) + P(2,4)*P(3,5)*P(5,3)*Metric(1,4) - P(2,4)*P(3,1)*P(4,2)*Metric(1,5) + P(2,4)*P(3,5)*P(4,2)*Metric(1,5) - P(2,1)*P(3,4)*P(4,3)*Metric(1,5) + P(2,5)*P(3,4)*P(4,3)*Metric(1,5) + P(1,2)*P(3,5)*P(5,3)*Metric(2,4) - P(1,4)*P(3,5)*P(5,3)*Metric(2,4) - P(-1,2)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) + P(1,2)*P(3,4)*P(4,3)*Metric(2,5) - P(1,5)*P(3,4)*P(4,3)*Metric(2,5) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(1,3)*P(2,5)*P(5,2)*Metric(3,4) - P(1,4)*P(2,5)*P(5,2)*Metric(3,4) - P(-1,3)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,3)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) - P(-1,3)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) + P(-1,3)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + P(1,3)*P(2,4)*P(4,2)*Metric(3,5) - P(1,5)*P(2,4)*P(4,2)*Metric(3,5) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5) + P(-1,3)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5)')

VVVVV13 = Lorentz(name = 'VVVVV13',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(1,2)*P(2,1)*P(5,3)*Metric(3,4) - P(1,2)*P(2,1)*P(5,4)*Metric(3,4) - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,2)*P(5,4)*Metric(1,2)*Metric(3,4) - P(1,2)*P(2,1)*P(4,3)*Metric(3,5) + P(1,2)*P(2,1)*P(4,5)*Metric(3,5) + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,2)*Metric(3,5) + P(1,2)*P(2,1)*P(3,4)*Metric(4,5) - P(1,2)*P(2,1)*P(3,5)*Metric(4,5) - P(-1,1)*P(-1,2)*P(3,4)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,2)*Metric(4,5)')

VVVVV14 = Lorentz(name = 'VVVVV14',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(2,5)*P(4,1)*P(5,2)*Metric(1,3) - P(2,5)*P(4,3)*P(5,2)*Metric(1,3) - P(2,5)*P(3,1)*P(5,2)*Metric(1,4) + P(2,5)*P(3,4)*P(5,2)*Metric(1,4) + P(1,5)*P(4,2)*P(5,1)*Metric(2,3) - P(1,5)*P(4,3)*P(5,1)*Metric(2,3) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) - P(1,5)*P(3,2)*P(5,1)*Metric(2,4) + P(1,5)*P(3,4)*P(5,1)*Metric(2,4) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(1,5)*P(2,3)*P(5,1)*Metric(3,4) - P(1,5)*P(2,4)*P(5,1)*Metric(3,4) + P(1,3)*P(2,5)*P(5,2)*Metric(3,4) - P(1,4)*P(2,5)*P(5,2)*Metric(3,4) + P(1,2)*P(2,1)*P(5,3)*Metric(3,4) - P(1,2)*P(2,1)*P(5,4)*Metric(3,4) - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,2)*P(5,4)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) - P(1,2)*P(2,1)*P(4,3)*Metric(3,5) + P(1,2)*P(2,1)*P(4,5)*Metric(3,5) + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,2)*Metric(3,5) + P(1,2)*P(2,1)*P(3,4)*Metric(4,5) - P(1,2)*P(2,1)*P(3,5)*Metric(4,5) - P(-1,1)*P(-1,2)*P(3,4)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,2)*Metric(4,5)')

VVVVV15 = Lorentz(name = 'VVVVV15',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) + 4*P(3,1)*Metric(1,2)*Metric(4,5) - 4*P(2,1)*Metric(1,3)*Metric(4,5)')

VVVVV16 = Lorentz(name = 'VVVVV16',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(2,5)*Metric(1,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,4)*Metric(1,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(3,1)*Metric(1,2)*Metric(4,5) - 2*P(2,1)*Metric(1,3)*Metric(4,5)')

VVVVV17 = Lorentz(name = 'VVVVV17',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5)')

VVVVV18 = Lorentz(name = 'VVVVV18',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,5)*Metric(1,5)*Metric(2,4) + P(3,4)*Metric(1,4)*Metric(2,5) - P(2,5)*Metric(1,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) - P(2,4)*Metric(1,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5)')

VVVVV19 = Lorentz(name = 'VVVVV19',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - 3*P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + 3*P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - 2*P(3,4)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) - 3*P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) + 3*P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(3,5)*Metric(1,4)*Metric(2,5) + 3*P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(5,4)*Metric(1,2)*Metric(3,4) - 3*P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + 2*P(2,4)*Metric(1,5)*Metric(3,4) - P(2,5)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) + 3*P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(4,5)*Metric(1,2)*Metric(3,5) - 3*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - P(2,4)*Metric(1,4)*Metric(3,5) + 2*P(2,5)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) - 4*P(3,1)*Metric(1,2)*Metric(4,5) + P(3,4)*Metric(1,2)*Metric(4,5) + P(3,5)*Metric(1,2)*Metric(4,5) + 4*P(2,1)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5)')

VVVVV20 = Lorentz(name = 'VVVVV20',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + (P(5,4)*Metric(1,3)*Metric(2,4))/2. + 2*P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(3,4)*Metric(1,5)*Metric(2,4) + (P(3,5)*Metric(1,5)*Metric(2,4))/2. - 2*P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + (P(4,5)*Metric(1,3)*Metric(2,5))/2. + 2*P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + (P(3,4)*Metric(1,4)*Metric(2,5))/2. - P(3,5)*Metric(1,4)*Metric(2,5) + 2*P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - (P(5,4)*Metric(1,2)*Metric(3,4))/2. - 2*P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + P(2,4)*Metric(1,5)*Metric(3,4) - (P(2,5)*Metric(1,5)*Metric(3,4))/2. + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - (P(1,4)*Metric(2,5)*Metric(3,4))/2. + (P(1,5)*Metric(2,5)*Metric(3,4))/2. + 2*P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - (P(4,5)*Metric(1,2)*Metric(3,5))/2. - 2*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - (P(2,4)*Metric(1,4)*Metric(3,5))/2. + P(2,5)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5) + (P(1,4)*Metric(2,4)*Metric(3,5))/2. - (P(1,5)*Metric(2,4)*Metric(3,5))/2. - 2*P(3,1)*Metric(1,2)*Metric(4,5) + (P(3,4)*Metric(1,2)*Metric(4,5))/2. + (P(3,5)*Metric(1,2)*Metric(4,5))/2. + 2*P(2,1)*Metric(1,3)*Metric(4,5) - (P(2,4)*Metric(1,3)*Metric(4,5))/2. - (P(2,5)*Metric(1,3)*Metric(4,5))/2.')

VVVVV21 = Lorentz(name = 'VVVVV21',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - (P(5,4)*Metric(1,3)*Metric(2,4))/2. - P(3,1)*Metric(1,5)*Metric(2,4) - P(3,4)*Metric(1,5)*Metric(2,4) + (P(3,5)*Metric(1,5)*Metric(2,4))/2. + P(4,1)*Metric(1,3)*Metric(2,5) - (P(4,5)*Metric(1,3)*Metric(2,5))/2. - P(3,1)*Metric(1,4)*Metric(2,5) + (P(3,4)*Metric(1,4)*Metric(2,5))/2. - P(3,5)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + (P(5,4)*Metric(1,2)*Metric(3,4))/2. + P(2,1)*Metric(1,5)*Metric(3,4) + P(2,4)*Metric(1,5)*Metric(3,4) - (P(2,5)*Metric(1,5)*Metric(3,4))/2. - (P(1,4)*Metric(2,5)*Metric(3,4))/2. + (P(1,5)*Metric(2,5)*Metric(3,4))/2. - P(4,1)*Metric(1,2)*Metric(3,5) + (P(4,5)*Metric(1,2)*Metric(3,5))/2. + P(2,1)*Metric(1,4)*Metric(3,5) - (P(2,4)*Metric(1,4)*Metric(3,5))/2. + P(2,5)*Metric(1,4)*Metric(3,5) + (P(1,4)*Metric(2,4)*Metric(3,5))/2. - (P(1,5)*Metric(2,4)*Metric(3,5))/2. + 2*P(3,1)*Metric(1,2)*Metric(4,5) - (P(3,4)*Metric(1,2)*Metric(4,5))/2. - (P(3,5)*Metric(1,2)*Metric(4,5))/2. - 2*P(2,1)*Metric(1,3)*Metric(4,5) + (P(2,4)*Metric(1,3)*Metric(4,5))/2. + (P(2,5)*Metric(1,3)*Metric(4,5))/2.')

VVVVV22 = Lorentz(name = 'VVVVV22',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) - 2*P(3,4)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(4,5)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(3,5)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(5,4)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) + 2*P(2,4)*Metric(1,5)*Metric(3,4) - P(2,5)*Metric(1,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(4,5)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,4)*Metric(1,4)*Metric(3,5) + 2*P(2,5)*Metric(1,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) - P(3,4)*Metric(1,2)*Metric(4,5) - P(3,5)*Metric(1,2)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) + P(2,5)*Metric(1,3)*Metric(4,5)')

VVVVV23 = Lorentz(name = 'VVVVV23',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,4)*P(4,2)*P(5,1)*Metric(1,2) + P(3,4)*P(4,5)*P(5,1)*Metric(1,2) + P(3,5)*P(4,1)*P(5,2)*Metric(1,2) - P(3,1)*P(4,5)*P(5,2)*Metric(1,2) - P(3,1)*P(4,5)*P(5,3)*Metric(1,2) + P(3,5)*P(4,1)*P(5,4)*Metric(1,2) - P(3,1)*P(4,2)*P(5,4)*Metric(1,2) - P(3,1)*P(4,3)*P(5,4)*Metric(1,2) - P(2,4)*P(4,3)*P(5,1)*Metric(1,3) - P(2,4)*P(4,5)*P(5,1)*Metric(1,3) + P(2,1)*P(4,5)*P(5,2)*Metric(1,3) - P(2,5)*P(4,1)*P(5,3)*Metric(1,3) + P(2,1)*P(4,5)*P(5,3)*Metric(1,3) - P(2,5)*P(4,1)*P(5,4)*Metric(1,3) + P(2,1)*P(4,2)*P(5,4)*Metric(1,3) + P(2,1)*P(4,3)*P(5,4)*Metric(1,3) - P(2,1)*P(3,5)*P(5,2)*Metric(1,4) + P(2,5)*P(3,1)*P(5,3)*Metric(1,4) + P(2,5)*P(3,1)*P(5,4)*Metric(1,4) - P(2,1)*P(3,5)*P(5,4)*Metric(1,4) - P(2,1)*P(3,4)*P(4,2)*Metric(1,5) + P(2,4)*P(3,1)*P(4,3)*Metric(1,5) + P(2,4)*P(3,1)*P(4,5)*Metric(1,5) - P(2,1)*P(3,4)*P(4,5)*Metric(1,5) - P(1,2)*P(3,4)*P(5,1)*Metric(2,4) - P(1,3)*P(3,4)*P(5,1)*Metric(2,4) + P(1,2)*P(3,1)*P(5,4)*Metric(2,4) + P(1,5)*P(3,1)*P(5,4)*Metric(2,4) + P(-1,3)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,2)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,2)*P(3,4)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,3)*P(3,4)*Metric(1,5)*Metric(2,4) - P(1,2)*P(3,5)*P(4,1)*Metric(2,5) - P(1,3)*P(3,5)*P(4,1)*Metric(2,5) + P(1,2)*P(3,1)*P(4,5)*Metric(2,5) + P(1,4)*P(3,1)*P(4,5)*Metric(2,5) + P(-1,3)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,4)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,3)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,3)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,2)*P(2,4)*P(5,1)*Metric(3,4) + P(1,3)*P(2,4)*P(5,1)*Metric(3,4) - P(1,3)*P(2,1)*P(5,4)*Metric(3,4) - P(1,5)*P(2,1)*P(5,4)*Metric(3,4) - P(-1,2)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(2,4)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,3)*P(2,4)*Metric(1,5)*Metric(3,4) + P(1,2)*P(2,5)*P(4,1)*Metric(3,5) + P(1,3)*P(2,5)*P(4,1)*Metric(3,5) - P(1,3)*P(2,1)*P(4,5)*Metric(3,5) - P(1,4)*P(2,1)*P(4,5)*Metric(3,5) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,4)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,3)*P(2,5)*Metric(1,4)*Metric(3,5) - P(1,2)*P(2,4)*P(3,1)*Metric(4,5) - P(1,5)*P(2,4)*P(3,1)*Metric(4,5) - P(1,2)*P(2,5)*P(3,1)*Metric(4,5) - P(1,4)*P(2,5)*P(3,1)*Metric(4,5) + P(1,3)*P(2,1)*P(3,4)*Metric(4,5) + P(1,5)*P(2,1)*P(3,4)*Metric(4,5) + P(1,3)*P(2,1)*P(3,5)*Metric(4,5) + P(1,4)*P(2,1)*P(3,5)*Metric(4,5) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5)')

VVVVV24 = Lorentz(name = 'VVVVV24',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,4)*P(4,2)*P(5,1)*Metric(1,2) + P(3,4)*P(4,5)*P(5,1)*Metric(1,2) + P(3,5)*P(4,1)*P(5,2)*Metric(1,2) - P(3,1)*P(4,5)*P(5,2)*Metric(1,2) - P(3,1)*P(4,5)*P(5,3)*Metric(1,2) + P(3,5)*P(4,1)*P(5,4)*Metric(1,2) - P(3,1)*P(4,2)*P(5,4)*Metric(1,2) - P(3,1)*P(4,3)*P(5,4)*Metric(1,2) - P(2,4)*P(4,3)*P(5,1)*Metric(1,3) - P(2,4)*P(4,5)*P(5,1)*Metric(1,3) + P(2,1)*P(4,5)*P(5,2)*Metric(1,3) - P(2,5)*P(4,1)*P(5,3)*Metric(1,3) + P(2,1)*P(4,5)*P(5,3)*Metric(1,3) - P(2,5)*P(4,1)*P(5,4)*Metric(1,3) + P(2,1)*P(4,2)*P(5,4)*Metric(1,3) + P(2,1)*P(4,3)*P(5,4)*Metric(1,3) + P(2,5)*P(3,4)*P(5,1)*Metric(1,4) - P(2,4)*P(3,5)*P(5,1)*Metric(1,4) - P(2,1)*P(3,5)*P(5,2)*Metric(1,4) - P(2,4)*P(3,5)*P(5,2)*Metric(1,4) + P(2,5)*P(3,1)*P(5,3)*Metric(1,4) + P(2,5)*P(3,4)*P(5,3)*Metric(1,4) + P(2,5)*P(3,1)*P(5,4)*Metric(1,4) - P(2,1)*P(3,5)*P(5,4)*Metric(1,4) - P(2,5)*P(3,4)*P(4,1)*Metric(1,5) + P(2,4)*P(3,5)*P(4,1)*Metric(1,5) - P(2,1)*P(3,4)*P(4,2)*Metric(1,5) - P(2,5)*P(3,4)*P(4,2)*Metric(1,5) + P(2,4)*P(3,1)*P(4,3)*Metric(1,5) + P(2,4)*P(3,5)*P(4,3)*Metric(1,5) + P(2,4)*P(3,1)*P(4,5)*Metric(1,5) - P(2,1)*P(3,4)*P(4,5)*Metric(1,5) - P(1,2)*P(3,4)*P(5,1)*Metric(2,4) - P(1,3)*P(3,4)*P(5,1)*Metric(2,4) + P(1,4)*P(3,5)*P(5,1)*Metric(2,4) - P(1,5)*P(3,4)*P(5,2)*Metric(2,4) + P(1,4)*P(3,5)*P(5,2)*Metric(2,4) - P(1,5)*P(3,4)*P(5,3)*Metric(2,4) + P(1,2)*P(3,1)*P(5,4)*Metric(2,4) + P(1,5)*P(3,1)*P(5,4)*Metric(2,4) + P(-1,3)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,2)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,2)*P(3,4)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,3)*P(3,4)*Metric(1,5)*Metric(2,4) + P(-1,2)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) + P(-1,3)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - P(-1,3)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) + P(1,5)*P(3,4)*P(4,1)*Metric(2,5) - P(1,2)*P(3,5)*P(4,1)*Metric(2,5) - P(1,3)*P(3,5)*P(4,1)*Metric(2,5) + P(1,5)*P(3,4)*P(4,2)*Metric(2,5) - P(1,4)*P(3,5)*P(4,2)*Metric(2,5) - P(1,4)*P(3,5)*P(4,3)*Metric(2,5) + P(1,2)*P(3,1)*P(4,5)*Metric(2,5) + P(1,4)*P(3,1)*P(4,5)*Metric(2,5) + P(-1,3)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,4)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,3)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) - P(-1,3)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,3)*P(3,5)*Metric(1,4)*Metric(2,5) + P(-1,2)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(-1,3)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,2)*P(2,4)*P(5,1)*Metric(3,4) + P(1,3)*P(2,4)*P(5,1)*Metric(3,4) - P(1,4)*P(2,5)*P(5,1)*Metric(3,4) + P(1,5)*P(2,4)*P(5,2)*Metric(3,4) + P(1,5)*P(2,4)*P(5,3)*Metric(3,4) - P(1,4)*P(2,5)*P(5,3)*Metric(3,4) - P(1,3)*P(2,1)*P(5,4)*Metric(3,4) - P(1,5)*P(2,1)*P(5,4)*Metric(3,4) - P(-1,2)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(2,4)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,3)*P(2,4)*Metric(1,5)*Metric(3,4) - P(-1,2)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) - P(-1,3)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) + P(-1,3)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) - P(1,5)*P(2,4)*P(4,1)*Metric(3,5) + P(1,2)*P(2,5)*P(4,1)*Metric(3,5) + P(1,3)*P(2,5)*P(4,1)*Metric(3,5) + P(1,4)*P(2,5)*P(4,2)*Metric(3,5) - P(1,5)*P(2,4)*P(4,3)*Metric(3,5) + P(1,4)*P(2,5)*P(4,3)*Metric(3,5) - P(1,3)*P(2,1)*P(4,5)*Metric(3,5) - P(1,4)*P(2,1)*P(4,5)*Metric(3,5) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,4)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) + P(-1,2)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,3)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,2)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) + P(-1,3)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) - P(1,2)*P(2,4)*P(3,1)*Metric(4,5) - P(1,5)*P(2,4)*P(3,1)*Metric(4,5) - P(1,2)*P(2,5)*P(3,1)*Metric(4,5) - P(1,4)*P(2,5)*P(3,1)*Metric(4,5) + P(1,3)*P(2,1)*P(3,4)*Metric(4,5) + P(1,5)*P(2,1)*P(3,4)*Metric(4,5) + P(1,3)*P(2,1)*P(3,5)*Metric(4,5) + P(1,4)*P(2,1)*P(3,5)*Metric(4,5) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5)')

VVVVV25 = Lorentz(name = 'VVVVV25',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,4)*P(4,3)*P(5,1)*Metric(1,2) + P(3,5)*P(4,1)*P(5,3)*Metric(1,2) - 2*P(3,1)*P(4,5)*P(5,4)*Metric(1,2) - P(2,4)*P(4,2)*P(5,1)*Metric(1,3) - P(2,5)*P(4,1)*P(5,2)*Metric(1,3) + 2*P(2,1)*P(4,5)*P(5,4)*Metric(1,3) + P(2,5)*P(3,1)*P(5,2)*Metric(1,4) - P(2,1)*P(3,5)*P(5,3)*Metric(1,4) + P(2,4)*P(3,1)*P(4,2)*Metric(1,5) - P(2,1)*P(3,4)*P(4,3)*Metric(1,5) - P(1,5)*P(3,4)*P(5,1)*Metric(2,4) + P(1,3)*P(3,1)*P(5,4)*Metric(2,4) + P(-1,2)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) - P(1,4)*P(3,5)*P(4,1)*Metric(2,5) + P(1,3)*P(3,1)*P(4,5)*Metric(2,5) + P(-1,2)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,2)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,5)*P(2,4)*P(5,1)*Metric(3,4) - P(1,2)*P(2,1)*P(5,4)*Metric(3,4) - P(-1,3)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,2)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) + P(1,4)*P(2,5)*P(4,1)*Metric(3,5) - P(1,2)*P(2,1)*P(4,5)*Metric(3,5) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,2)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - P(1,3)*P(2,4)*P(3,1)*Metric(4,5) - P(1,3)*P(2,5)*P(3,1)*Metric(4,5) + P(1,2)*P(2,1)*P(3,4)*Metric(4,5) + P(1,2)*P(2,1)*P(3,5)*Metric(4,5) + 2*P(-1,4)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,2)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,2)*P(3,5)*Metric(1,2)*Metric(4,5) - 2*P(-1,4)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5)')

VVVVV26 = Lorentz(name = 'VVVVV26',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,4)*P(4,3)*P(5,1)*Metric(1,2) + P(3,5)*P(4,1)*P(5,3)*Metric(1,2) - 2*P(3,1)*P(4,5)*P(5,4)*Metric(1,2) - P(2,4)*P(4,2)*P(5,1)*Metric(1,3) - P(2,5)*P(4,1)*P(5,2)*Metric(1,3) + 2*P(2,1)*P(4,5)*P(5,4)*Metric(1,3) + P(2,5)*P(3,1)*P(5,2)*Metric(1,4) + P(2,5)*P(3,4)*P(5,2)*Metric(1,4) - P(2,1)*P(3,5)*P(5,3)*Metric(1,4) - P(2,4)*P(3,5)*P(5,3)*Metric(1,4) + P(2,4)*P(3,1)*P(4,2)*Metric(1,5) + P(2,4)*P(3,5)*P(4,2)*Metric(1,5) - P(2,1)*P(3,4)*P(4,3)*Metric(1,5) - P(2,5)*P(3,4)*P(4,3)*Metric(1,5) - 2*P(1,5)*P(3,4)*P(5,1)*Metric(2,4) + P(1,4)*P(3,5)*P(5,3)*Metric(2,4) + P(1,3)*P(3,1)*P(5,4)*Metric(2,4) + P(-1,2)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) + 2*P(-1,1)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - 2*P(1,4)*P(3,5)*P(4,1)*Metric(2,5) + P(1,5)*P(3,4)*P(4,3)*Metric(2,5) + P(1,3)*P(3,1)*P(4,5)*Metric(2,5) + P(-1,2)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,2)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + 2*P(-1,1)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + 2*P(1,5)*P(2,4)*P(5,1)*Metric(3,4) - P(1,4)*P(2,5)*P(5,2)*Metric(3,4) - P(1,2)*P(2,1)*P(5,4)*Metric(3,4) - P(-1,3)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,2)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) - 2*P(-1,1)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) + P(-1,3)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + 2*P(1,4)*P(2,5)*P(4,1)*Metric(3,5) - P(1,5)*P(2,4)*P(4,2)*Metric(3,5) - P(1,2)*P(2,1)*P(4,5)*Metric(3,5) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,2)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,3)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - 2*P(-1,1)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) - P(1,3)*P(2,4)*P(3,1)*Metric(4,5) - P(1,3)*P(2,5)*P(3,1)*Metric(4,5) + P(1,2)*P(2,1)*P(3,4)*Metric(4,5) + P(1,2)*P(2,1)*P(3,5)*Metric(4,5) + 2*P(-1,4)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,2)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,2)*P(3,5)*Metric(1,2)*Metric(4,5) - 2*P(-1,4)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5)')

VVVVV27 = Lorentz(name = 'VVVVV27',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,4)*Metric(2,3) - P(5,2)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + 2*P(4,2)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - 2*P(3,2)*Metric(1,5)*Metric(2,4) + 2*P(4,1)*Metric(1,3)*Metric(2,5) - P(4,2)*Metric(1,3)*Metric(2,5) - 2*P(3,1)*Metric(1,4)*Metric(2,5) + P(3,2)*Metric(1,4)*Metric(2,5) - P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5)')

VVVVV28 = Lorentz(name = 'VVVVV28',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) - P(3,1)*Metric(1,2)*Metric(4,5) - P(3,2)*Metric(1,2)*Metric(4,5) + P(2,1)*Metric(1,3)*Metric(4,5) + P(1,2)*Metric(2,3)*Metric(4,5)')

VVVVV29 = Lorentz(name = 'VVVVV29',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,4)*Metric(2,3) - P(5,2)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) - 2*P(4,2)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) + 2*P(3,2)*Metric(1,5)*Metric(2,4) - 2*P(4,1)*Metric(1,3)*Metric(2,5) - P(4,2)*Metric(1,3)*Metric(2,5) + 2*P(3,1)*Metric(1,4)*Metric(2,5) + P(3,2)*Metric(1,4)*Metric(2,5) + P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) - P(3,1)*Metric(1,2)*Metric(4,5) - P(3,2)*Metric(1,2)*Metric(4,5) + P(2,1)*Metric(1,3)*Metric(4,5) + P(1,2)*Metric(2,3)*Metric(4,5)')

VVVVV30 = Lorentz(name = 'VVVVV30',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(2,5)*Metric(1,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) + P(2,4)*Metric(1,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) + P(2,3)*Metric(1,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5)')

VVVVV31 = Lorentz(name = 'VVVVV31',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,1)*Metric(1,2)*Metric(4,5) - P(3,2)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) + P(2,3)*Metric(1,3)*Metric(4,5) + P(1,2)*Metric(2,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5)')

VVVVV32 = Lorentz(name = 'VVVVV32',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(2,5)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,4)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) - P(3,2)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) + P(2,3)*Metric(1,3)*Metric(4,5) + P(1,2)*Metric(2,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5)')

VVVVV33 = Lorentz(name = 'VVVVV33',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(5,1)*Metric(1,2)*Metric(3,4) - 2*P(5,2)*Metric(1,2)*Metric(3,4) + 2*P(5,3)*Metric(1,2)*Metric(3,4) + 2*P(5,4)*Metric(1,2)*Metric(3,4) + 2*P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 2*P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) - 2*P(4,3)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) - 2*P(3,4)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5)')

VVVVV34 = Lorentz(name = 'VVVVV34',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) + 2*P(4,5)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) - P(3,4)*Metric(1,5)*Metric(2,4) + 2*P(3,5)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) - P(4,3)*Metric(1,3)*Metric(2,5) + 2*P(4,5)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + 2*P(3,5)*Metric(1,4)*Metric(2,5) + 2*P(5,1)*Metric(1,2)*Metric(3,4) + 2*P(5,2)*Metric(1,2)*Metric(3,4) - 2*P(5,3)*Metric(1,2)*Metric(3,4) - 2*P(5,4)*Metric(1,2)*Metric(3,4) - 2*P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + P(2,4)*Metric(1,5)*Metric(3,4) - 2*P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) + 2*P(4,3)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - 2*P(2,5)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - 2*P(1,5)*Metric(2,4)*Metric(3,5) - P(3,1)*Metric(1,2)*Metric(4,5) - P(3,2)*Metric(1,2)*Metric(4,5) + 2*P(3,4)*Metric(1,2)*Metric(4,5) + P(2,1)*Metric(1,3)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) - 2*P(2,5)*Metric(1,3)*Metric(4,5) + P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) - 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV35 = Lorentz(name = 'VVVVV35',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(4,5)*Metric(1,5)*Metric(2,3) + P(3,5)*Metric(1,5)*Metric(2,4) + P(4,5)*Metric(1,3)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,5)*Metric(1,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) - P(2,5)*Metric(1,3)*Metric(4,5) - P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV36 = Lorentz(name = 'VVVVV36',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + P(4,5)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) + P(2,3)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) + P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) - P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV37 = Lorentz(name = 'VVVVV37',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV38 = Lorentz(name = 'VVVVV38',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - 2*P(5,1)*Metric(1,2)*Metric(3,4) + 2*P(5,2)*Metric(1,2)*Metric(3,4) + 2*P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) - 2*P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 2*P(4,1)*Metric(1,2)*Metric(3,5) + 2*P(4,2)*Metric(1,2)*Metric(3,5) + 2*P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) - 2*P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - 2*P(3,1)*Metric(1,2)*Metric(4,5) + 2*P(3,2)*Metric(1,2)*Metric(4,5) + 2*P(2,1)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV39 = Lorentz(name = 'VVVVV39',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 4*P(2,5)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 4*P(1,5)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) + 4*P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - 4*P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + 4*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 4*P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV40 = Lorentz(name = 'VVVVV40',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 2*P(2,5)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 2*P(1,5)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - 2*P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV41 = Lorentz(name = 'VVVVV41',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - (2*P(5,1)*Metric(1,2)*Metric(3,4))/3. + (2*P(5,2)*Metric(1,2)*Metric(3,4))/3. + (2*P(2,1)*Metric(1,5)*Metric(3,4))/3. - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + (4*P(2,5)*Metric(1,5)*Metric(3,4))/3. - (2*P(1,2)*Metric(2,5)*Metric(3,4))/3. + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - (4*P(1,5)*Metric(2,5)*Metric(3,4))/3. - (2*P(4,1)*Metric(1,2)*Metric(3,5))/3. + (2*P(4,2)*Metric(1,2)*Metric(3,5))/3. + (2*P(2,1)*Metric(1,4)*Metric(3,5))/3. - P(2,3)*Metric(1,4)*Metric(3,5) + (4*P(2,4)*Metric(1,4)*Metric(3,5))/3. - P(2,5)*Metric(1,4)*Metric(3,5) - (2*P(1,2)*Metric(2,4)*Metric(3,5))/3. + P(1,3)*Metric(2,4)*Metric(3,5) - (4*P(1,4)*Metric(2,4)*Metric(3,5))/3. + P(1,5)*Metric(2,4)*Metric(3,5) - (2*P(3,1)*Metric(1,2)*Metric(4,5))/3. + (2*P(3,2)*Metric(1,2)*Metric(4,5))/3. + (2*P(2,1)*Metric(1,3)*Metric(4,5))/3. + (4*P(2,3)*Metric(1,3)*Metric(4,5))/3. - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - (2*P(1,2)*Metric(2,3)*Metric(4,5))/3. - (4*P(1,3)*Metric(2,3)*Metric(4,5))/3. + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV42 = Lorentz(name = 'VVVVV42',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(2,5)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) + P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV43 = Lorentz(name = 'VVVVV43',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(5,2)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(2,5)*Metric(1,5)*Metric(3,4) - P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) + P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) + P(2,1)*Metric(1,3)*Metric(4,5) + P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV44 = Lorentz(name = 'VVVVV44',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + 3*P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + 3*P(3,4)*Metric(1,5)*Metric(2,4) - 2*P(3,5)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) + 3*P(4,3)*Metric(1,3)*Metric(2,5) - 2*P(4,5)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + 3*P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(3,5)*Metric(1,4)*Metric(2,5) - 6*P(5,1)*Metric(1,2)*Metric(3,4) - 6*P(5,2)*Metric(1,2)*Metric(3,4) + 6*P(5,3)*Metric(1,2)*Metric(3,4) + 6*P(5,4)*Metric(1,2)*Metric(3,4) + 6*P(2,1)*Metric(1,5)*Metric(3,4) - 3*P(2,3)*Metric(1,5)*Metric(3,4) - 3*P(2,4)*Metric(1,5)*Metric(3,4) + 6*P(1,2)*Metric(2,5)*Metric(3,4) - 3*P(1,3)*Metric(2,5)*Metric(3,4) - 3*P(1,4)*Metric(2,5)*Metric(3,4) + 3*P(4,1)*Metric(1,2)*Metric(3,5) + 3*P(4,2)*Metric(1,2)*Metric(3,5) - 6*P(4,3)*Metric(1,2)*Metric(3,5) - 3*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(2,5)*Metric(1,4)*Metric(3,5) - 3*P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + 2*P(1,5)*Metric(2,4)*Metric(3,5) + 3*P(3,1)*Metric(1,2)*Metric(4,5) + 3*P(3,2)*Metric(1,2)*Metric(4,5) - 6*P(3,4)*Metric(1,2)*Metric(4,5) - 3*P(2,1)*Metric(1,3)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) + 2*P(2,5)*Metric(1,3)*Metric(4,5) - 3*P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV45 = Lorentz(name = 'VVVVV45',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,2)*Metric(1,4)*Metric(2,3) + P(5,3)*Metric(1,4)*Metric(2,3) - 2*P(5,4)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(5,4)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(4,5)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(3,2)*Metric(1,2)*Metric(4,5) - P(3,4)*Metric(1,2)*Metric(4,5) - P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,2)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*Metric(2,3)*Metric(4,5) + 2*P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV46 = Lorentz(name = 'VVVVV46',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,2)*Metric(1,4)*Metric(2,3) + P(5,3)*Metric(1,4)*Metric(2,3) - 2*P(5,4)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*Metric(1,5)*Metric(2,3) - 2*P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + 2*P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - 2*P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) + 2*P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(5,1)*Metric(1,2)*Metric(3,4) + P(5,2)*Metric(1,2)*Metric(3,4) + P(5,4)*Metric(1,2)*Metric(3,4) + 2*P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,5)*Metric(1,5)*Metric(3,4) - P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) - 2*P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) + P(4,5)*Metric(1,2)*Metric(3,5) + 2*P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) - P(2,4)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(3,2)*Metric(1,2)*Metric(4,5) - P(3,4)*Metric(1,2)*Metric(4,5) - P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,2)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*Metric(2,3)*Metric(4,5) + 2*P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV47 = Lorentz(name = 'VVVVV47',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(2,4)*P(4,2)*P(5,1)*Metric(1,3) - P(2,4)*P(4,2)*P(5,3)*Metric(1,3) + P(2,3)*P(3,2)*P(5,1)*Metric(1,4) - P(2,3)*P(3,2)*P(5,4)*Metric(1,4) - P(2,3)*P(3,2)*P(4,1)*Metric(1,5) - P(2,4)*P(3,1)*P(4,2)*Metric(1,5) + P(2,4)*P(3,5)*P(4,2)*Metric(1,5) + P(2,3)*P(3,2)*P(4,5)*Metric(1,5) + P(1,4)*P(4,1)*P(5,2)*Metric(2,3) - P(1,4)*P(4,1)*P(5,3)*Metric(2,3) - P(-1,2)*P(-1,3)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,3)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,3)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) + P(1,3)*P(3,1)*P(5,2)*Metric(2,4) - P(1,3)*P(3,1)*P(5,4)*Metric(2,4) - P(-1,2)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,3)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - P(1,4)*P(3,2)*P(4,1)*Metric(2,5) + P(1,4)*P(3,5)*P(4,1)*Metric(2,5) - P(1,3)*P(3,1)*P(4,2)*Metric(2,5) + P(1,3)*P(3,1)*P(4,5)*Metric(2,5) + P(-1,1)*P(-1,3)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,4)*P(2,3)*P(4,1)*Metric(3,5) - P(1,4)*P(2,5)*P(4,1)*Metric(3,5) + P(1,3)*P(2,4)*P(4,2)*Metric(3,5) - P(1,5)*P(2,4)*P(4,2)*Metric(3,5) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,2)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) + P(1,3)*P(2,4)*P(3,1)*Metric(4,5) - P(1,3)*P(2,5)*P(3,1)*Metric(4,5) + P(1,4)*P(2,3)*P(3,2)*Metric(4,5) - P(1,5)*P(2,3)*P(3,2)*Metric(4,5) - P(-1,1)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,3)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV48 = Lorentz(name = 'VVVVV48',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(2,3)*P(3,2)*P(5,1)*Metric(1,4) - P(2,3)*P(3,2)*P(5,4)*Metric(1,4) - P(2,3)*P(3,2)*P(4,1)*Metric(1,5) + P(2,3)*P(3,2)*P(4,5)*Metric(1,5) - P(-1,2)*P(-1,3)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,3)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,3)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) + P(1,3)*P(3,1)*P(5,2)*Metric(2,4) - P(1,3)*P(3,1)*P(5,4)*Metric(2,4) - P(-1,1)*P(-1,3)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(3,1)*P(4,2)*Metric(2,5) + P(1,3)*P(3,1)*P(4,5)*Metric(2,5) + P(-1,1)*P(-1,3)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) + P(1,2)*P(2,1)*P(5,3)*Metric(3,4) - P(1,2)*P(2,1)*P(5,4)*Metric(3,4) - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,2)*P(5,4)*Metric(1,2)*Metric(3,4) - P(1,2)*P(2,1)*P(4,3)*Metric(3,5) + P(1,2)*P(2,1)*P(4,5)*Metric(3,5) + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,2)*Metric(3,5) + P(1,3)*P(2,4)*P(3,1)*Metric(4,5) - P(1,3)*P(2,5)*P(3,1)*Metric(4,5) + P(1,4)*P(2,3)*P(3,2)*Metric(4,5) - P(1,5)*P(2,3)*P(3,2)*Metric(4,5) + P(1,2)*P(2,1)*P(3,4)*Metric(4,5) - P(1,2)*P(2,1)*P(3,5)*Metric(4,5) - P(-1,1)*P(-1,2)*P(3,4)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,3)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV49 = Lorentz(name = 'VVVVV49',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = '-(P(3,4)*P(4,2)*P(5,1)*Metric(1,2)) + P(3,5)*P(4,2)*P(5,1)*Metric(1,2) + P(3,2)*P(4,3)*P(5,1)*Metric(1,2) - P(3,2)*P(4,5)*P(5,1)*Metric(1,2) - P(3,4)*P(4,1)*P(5,2)*Metric(1,2) + P(3,5)*P(4,1)*P(5,2)*Metric(1,2) + P(3,1)*P(4,3)*P(5,2)*Metric(1,2) - P(3,1)*P(4,5)*P(5,2)*Metric(1,2) - P(3,2)*P(4,1)*P(5,3)*Metric(1,2) - P(3,1)*P(4,2)*P(5,3)*Metric(1,2) + P(3,2)*P(4,1)*P(5,4)*Metric(1,2) + P(3,1)*P(4,2)*P(5,4)*Metric(1,2) - P(2,1)*P(4,3)*P(5,2)*Metric(1,3) + P(2,1)*P(4,5)*P(5,2)*Metric(1,3) + P(2,1)*P(4,2)*P(5,3)*Metric(1,3) - P(2,1)*P(4,2)*P(5,4)*Metric(1,3) + P(2,1)*P(3,4)*P(5,2)*Metric(1,4) - P(2,1)*P(3,5)*P(5,2)*Metric(1,4) + P(2,1)*P(3,2)*P(5,3)*Metric(1,4) - P(2,1)*P(3,2)*P(5,4)*Metric(1,4) + P(2,1)*P(3,4)*P(4,2)*Metric(1,5) - P(2,1)*P(3,5)*P(4,2)*Metric(1,5) - P(2,1)*P(3,2)*P(4,3)*Metric(1,5) + P(2,1)*P(3,2)*P(4,5)*Metric(1,5) - P(1,2)*P(4,3)*P(5,1)*Metric(2,3) + P(1,2)*P(4,5)*P(5,1)*Metric(2,3) + P(1,2)*P(4,1)*P(5,3)*Metric(2,3) - P(1,2)*P(4,1)*P(5,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,2)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,5)*Metric(2,3) + P(1,2)*P(3,4)*P(5,1)*Metric(2,4) - P(1,2)*P(3,5)*P(5,1)*Metric(2,4) + P(1,2)*P(3,1)*P(5,3)*Metric(2,4) - P(1,2)*P(3,1)*P(5,4)*Metric(2,4) - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,2)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,2)*P(3,4)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,5)*Metric(2,4) + P(1,2)*P(3,4)*P(4,1)*Metric(2,5) - P(1,2)*P(3,5)*P(4,1)*Metric(2,5) - P(1,2)*P(3,1)*P(4,3)*Metric(2,5) + P(1,2)*P(3,1)*P(4,5)*Metric(2,5) + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,2)*P(3,4)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,2)*P(2,3)*P(5,1)*Metric(3,4) - P(1,2)*P(2,4)*P(5,1)*Metric(3,4) + P(1,3)*P(2,1)*P(5,2)*Metric(3,4) - P(1,4)*P(2,1)*P(5,2)*Metric(3,4) - P(-1,2)*P(-1,3)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,3)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(1,3)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,2)*P(1,4)*Metric(2,5)*Metric(3,4) - P(1,2)*P(2,3)*P(4,1)*Metric(3,5) + P(1,2)*P(2,5)*P(4,1)*Metric(3,5) - P(1,3)*P(2,1)*P(4,2)*Metric(3,5) + P(1,5)*P(2,1)*P(4,2)*Metric(3,5) + P(-1,2)*P(-1,3)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,3)*P(4,2)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,3)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,2)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,2)*P(2,3)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,3)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,2)*P(1,3)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,4)*Metric(3,5) + P(1,2)*P(2,4)*P(3,1)*Metric(4,5) - P(1,2)*P(2,5)*P(3,1)*Metric(4,5) + P(1,4)*P(2,1)*P(3,2)*Metric(4,5) - P(1,5)*P(2,1)*P(3,2)*Metric(4,5) - P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV50 = Lorentz(name = 'VVVVV50',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,5)*P(4,2)*P(5,1)*Metric(1,2) - P(3,5)*P(4,3)*P(5,1)*Metric(1,2) - P(3,2)*P(4,5)*P(5,1)*Metric(1,2) + P(3,4)*P(4,5)*P(5,1)*Metric(1,2) + P(3,4)*P(4,1)*P(5,2)*Metric(1,2) - P(3,4)*P(4,1)*P(5,3)*Metric(1,2) - P(3,2)*P(4,1)*P(5,4)*Metric(1,2) + P(3,5)*P(4,1)*P(5,4)*Metric(1,2) + P(2,5)*P(4,2)*P(5,1)*Metric(1,3) - P(2,5)*P(4,3)*P(5,1)*Metric(1,3) + P(2,3)*P(4,5)*P(5,1)*Metric(1,3) - P(2,4)*P(4,5)*P(5,1)*Metric(1,3) + P(2,4)*P(4,1)*P(5,2)*Metric(1,3) - P(2,4)*P(4,1)*P(5,3)*Metric(1,3) + P(2,3)*P(4,1)*P(5,4)*Metric(1,3) - P(2,5)*P(4,1)*P(5,4)*Metric(1,3) + P(2,4)*P(3,2)*P(5,1)*Metric(1,4) - P(2,5)*P(3,2)*P(5,1)*Metric(1,4) - P(2,3)*P(3,4)*P(5,1)*Metric(1,4) + 2*P(2,5)*P(3,4)*P(5,1)*Metric(1,4) + P(2,3)*P(3,5)*P(5,1)*Metric(1,4) - 2*P(2,4)*P(3,5)*P(5,1)*Metric(1,4) - P(2,4)*P(3,1)*P(5,2)*Metric(1,4) - P(2,1)*P(3,4)*P(5,2)*Metric(1,4) + P(2,4)*P(3,1)*P(5,3)*Metric(1,4) + P(2,1)*P(3,4)*P(5,3)*Metric(1,4) - P(2,3)*P(3,1)*P(5,4)*Metric(1,4) + P(2,5)*P(3,1)*P(5,4)*Metric(1,4) + P(2,1)*P(3,2)*P(5,4)*Metric(1,4) - P(2,1)*P(3,5)*P(5,4)*Metric(1,4) - P(2,4)*P(3,2)*P(4,1)*Metric(1,5) + P(2,5)*P(3,2)*P(4,1)*Metric(1,5) + P(2,3)*P(3,4)*P(4,1)*Metric(1,5) - 2*P(2,5)*P(3,4)*P(4,1)*Metric(1,5) - P(2,3)*P(3,5)*P(4,1)*Metric(1,5) + 2*P(2,4)*P(3,5)*P(4,1)*Metric(1,5) - P(2,5)*P(3,1)*P(4,2)*Metric(1,5) - P(2,1)*P(3,5)*P(4,2)*Metric(1,5) + P(2,5)*P(3,1)*P(4,3)*Metric(1,5) + P(2,1)*P(3,5)*P(4,3)*Metric(1,5) - P(2,3)*P(3,1)*P(4,5)*Metric(1,5) + P(2,4)*P(3,1)*P(4,5)*Metric(1,5) + P(2,1)*P(3,2)*P(4,5)*Metric(1,5) - P(2,1)*P(3,4)*P(4,5)*Metric(1,5) + P(1,4)*P(4,2)*P(5,1)*Metric(2,3) - P(1,4)*P(4,3)*P(5,1)*Metric(2,3) + P(1,2)*P(4,5)*P(5,1)*Metric(2,3) - P(1,3)*P(4,5)*P(5,1)*Metric(2,3) + P(1,5)*P(4,1)*P(5,2)*Metric(2,3) - P(1,5)*P(4,1)*P(5,3)*Metric(2,3) + P(1,2)*P(4,1)*P(5,4)*Metric(2,3) - P(1,3)*P(4,1)*P(5,4)*Metric(2,3) - P(-1,2)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,3)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,4)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,4)*P(4,3)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) - P(1,4)*P(3,2)*P(5,1)*Metric(2,4) - P(1,2)*P(3,5)*P(5,1)*Metric(2,4) + 2*P(1,4)*P(3,5)*P(5,1)*Metric(2,4) + P(1,4)*P(3,1)*P(5,2)*Metric(2,4) - P(1,5)*P(3,1)*P(5,2)*Metric(2,4) - P(1,4)*P(3,1)*P(5,3)*Metric(2,4) + P(1,5)*P(3,1)*P(5,4)*Metric(2,4) - P(-1,2)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,5)*Metric(2,4) - 2*P(-1,1)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - P(1,5)*P(3,2)*P(4,1)*Metric(2,5) - P(1,2)*P(3,4)*P(4,1)*Metric(2,5) + 2*P(1,5)*P(3,4)*P(4,1)*Metric(2,5) - P(1,4)*P(3,1)*P(4,2)*Metric(2,5) + P(1,5)*P(3,1)*P(4,2)*Metric(2,5) - P(1,5)*P(3,1)*P(4,3)*Metric(2,5) + P(1,4)*P(3,1)*P(4,5)*Metric(2,5) - P(-1,2)*P(-1,4)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,4)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,4)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,2)*P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(-1,1)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(1,4)*P(2,3)*P(5,1)*Metric(3,4) + P(1,3)*P(2,5)*P(5,1)*Metric(3,4) - 2*P(1,4)*P(2,5)*P(5,1)*Metric(3,4) + P(1,4)*P(2,1)*P(5,2)*Metric(3,4) - P(1,4)*P(2,1)*P(5,3)*Metric(3,4) + P(1,5)*P(2,1)*P(5,3)*Metric(3,4) - P(1,5)*P(2,1)*P(5,4)*Metric(3,4) + P(-1,3)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*P(5,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4) + 2*P(-1,1)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,5)*Metric(3,4) + 2*P(-1,1)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4) - 2*P(-1,1)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + P(1,5)*P(2,3)*P(4,1)*Metric(3,5) + P(1,3)*P(2,4)*P(4,1)*Metric(3,5) - 2*P(1,5)*P(2,4)*P(4,1)*Metric(3,5) + P(1,5)*P(2,1)*P(4,2)*Metric(3,5) + P(1,4)*P(2,1)*P(4,3)*Metric(3,5) - P(1,5)*P(2,1)*P(4,3)*Metric(3,5) - P(1,4)*P(2,1)*P(4,5)*Metric(3,5) + P(-1,3)*P(-1,4)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,4)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,4)*P(4,3)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,3)*P(2,4)*Metric(1,4)*Metric(3,5) + 2*P(-1,1)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,3)*P(1,4)*Metric(2,4)*Metric(3,5) - 2*P(-1,1)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(-1,1)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) + P(1,4)*P(2,3)*P(3,1)*Metric(4,5) + P(1,5)*P(2,3)*P(3,1)*Metric(4,5) - P(1,5)*P(2,4)*P(3,1)*Metric(4,5) - P(1,4)*P(2,5)*P(3,1)*Metric(4,5) - P(1,4)*P(2,1)*P(3,2)*Metric(4,5) - P(1,5)*P(2,1)*P(3,2)*Metric(4,5) + P(1,5)*P(2,1)*P(3,4)*Metric(4,5) + P(1,4)*P(2,1)*P(3,5)*Metric(4,5) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV51 = Lorentz(name = 'VVVVV51',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,5)*P(4,2)*P(5,1)*Metric(1,2) - P(3,2)*P(4,5)*P(5,1)*Metric(1,2) + P(3,5)*P(4,1)*P(5,2)*Metric(1,2) - P(3,1)*P(4,5)*P(5,2)*Metric(1,2) - P(3,1)*P(4,5)*P(5,3)*Metric(1,2) - P(3,2)*P(4,5)*P(5,3)*Metric(1,2) + P(3,5)*P(4,1)*P(5,4)*Metric(1,2) + P(3,5)*P(4,2)*P(5,4)*Metric(1,2) + P(2,1)*P(4,5)*P(5,2)*Metric(1,3) - P(2,5)*P(4,1)*P(5,3)*Metric(1,3) + P(2,1)*P(4,5)*P(5,3)*Metric(1,3) - P(2,5)*P(4,1)*P(5,4)*Metric(1,3) - P(2,1)*P(3,5)*P(5,2)*Metric(1,4) + P(2,5)*P(3,1)*P(5,3)*Metric(1,4) + P(2,5)*P(3,1)*P(5,4)*Metric(1,4) - P(2,1)*P(3,5)*P(5,4)*Metric(1,4) - P(2,1)*P(3,5)*P(4,2)*Metric(1,5) - P(2,3)*P(3,5)*P(4,2)*Metric(1,5) + P(2,1)*P(3,2)*P(4,5)*Metric(1,5) + P(2,4)*P(3,2)*P(4,5)*Metric(1,5) + P(1,2)*P(4,5)*P(5,1)*Metric(2,3) - P(1,5)*P(4,2)*P(5,3)*Metric(2,3) + P(1,2)*P(4,5)*P(5,3)*Metric(2,3) - P(1,5)*P(4,2)*P(5,4)*Metric(2,3) + P(-1,3)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,4)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) - P(1,2)*P(3,5)*P(5,1)*Metric(2,4) + P(1,5)*P(3,2)*P(5,3)*Metric(2,4) + P(1,5)*P(3,2)*P(5,4)*Metric(2,4) - P(1,2)*P(3,5)*P(5,4)*Metric(2,4) - P(-1,3)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,5)*Metric(2,4) + P(-1,2)*P(-1,3)*P(3,5)*Metric(1,5)*Metric(2,4) - P(1,2)*P(3,5)*P(4,1)*Metric(2,5) - P(1,3)*P(3,5)*P(4,1)*Metric(2,5) + P(1,2)*P(3,1)*P(4,5)*Metric(2,5) + P(1,4)*P(3,1)*P(4,5)*Metric(2,5) + P(-1,3)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,4)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,3)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,3)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,2)*P(2,5)*P(4,1)*Metric(3,5) + P(1,3)*P(2,5)*P(4,1)*Metric(3,5) + P(1,5)*P(2,1)*P(4,2)*Metric(3,5) + P(1,5)*P(2,3)*P(4,2)*Metric(3,5) - P(1,3)*P(2,1)*P(4,5)*Metric(3,5) - P(1,4)*P(2,1)*P(4,5)*Metric(3,5) - P(1,2)*P(2,3)*P(4,5)*Metric(3,5) - P(1,2)*P(2,4)*P(4,5)*Metric(3,5) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,4)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) - P(-1,4)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,3)*P(2,5)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,3)*P(1,5)*Metric(2,4)*Metric(3,5) - P(1,2)*P(2,5)*P(3,1)*Metric(4,5) - P(1,4)*P(2,5)*P(3,1)*Metric(4,5) - P(1,5)*P(2,1)*P(3,2)*Metric(4,5) - P(1,5)*P(2,4)*P(3,2)*Metric(4,5) + P(1,3)*P(2,1)*P(3,5)*Metric(4,5) + P(1,4)*P(2,1)*P(3,5)*Metric(4,5) + P(1,2)*P(2,3)*P(3,5)*Metric(4,5) + P(1,2)*P(2,4)*P(3,5)*Metric(4,5) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV52 = Lorentz(name = 'VVVVV52',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,5)*P(4,2)*P(5,1)*Metric(1,2) - P(3,2)*P(4,5)*P(5,1)*Metric(1,2) + P(3,5)*P(4,1)*P(5,2)*Metric(1,2) - P(3,1)*P(4,5)*P(5,2)*Metric(1,2) - P(3,1)*P(4,5)*P(5,3)*Metric(1,2) - P(3,2)*P(4,5)*P(5,3)*Metric(1,2) + P(3,5)*P(4,1)*P(5,4)*Metric(1,2) + P(3,5)*P(4,2)*P(5,4)*Metric(1,2) + P(2,3)*P(4,2)*P(5,1)*Metric(1,3) + P(2,5)*P(4,2)*P(5,1)*Metric(1,3) - P(2,3)*P(4,1)*P(5,2)*Metric(1,3) - P(2,4)*P(4,1)*P(5,2)*Metric(1,3) + P(2,1)*P(4,5)*P(5,2)*Metric(1,3) - P(2,5)*P(4,1)*P(5,3)*Metric(1,3) + P(2,1)*P(4,5)*P(5,3)*Metric(1,3) - P(2,5)*P(4,1)*P(5,4)*Metric(1,3) - P(2,4)*P(3,2)*P(5,1)*Metric(1,4) - P(2,5)*P(3,2)*P(5,1)*Metric(1,4) + P(2,3)*P(3,1)*P(5,2)*Metric(1,4) + P(2,4)*P(3,1)*P(5,2)*Metric(1,4) - P(2,1)*P(3,5)*P(5,2)*Metric(1,4) + P(2,5)*P(3,1)*P(5,3)*Metric(1,4) + P(2,5)*P(3,1)*P(5,4)*Metric(1,4) - P(2,1)*P(3,5)*P(5,4)*Metric(1,4) + P(2,4)*P(3,2)*P(4,1)*Metric(1,5) + P(2,5)*P(3,2)*P(4,1)*Metric(1,5) - P(2,3)*P(3,1)*P(4,2)*Metric(1,5) - P(2,5)*P(3,1)*P(4,2)*Metric(1,5) - P(2,1)*P(3,5)*P(4,2)*Metric(1,5) - P(2,3)*P(3,5)*P(4,2)*Metric(1,5) + P(2,1)*P(3,2)*P(4,5)*Metric(1,5) + P(2,4)*P(3,2)*P(4,5)*Metric(1,5) - P(1,3)*P(4,2)*P(5,1)*Metric(2,3) - P(1,4)*P(4,2)*P(5,1)*Metric(2,3) + P(1,2)*P(4,5)*P(5,1)*Metric(2,3) + P(1,3)*P(4,1)*P(5,2)*Metric(2,3) + P(1,5)*P(4,1)*P(5,2)*Metric(2,3) - P(1,5)*P(4,2)*P(5,3)*Metric(2,3) + P(1,2)*P(4,5)*P(5,3)*Metric(2,3) - P(1,5)*P(4,2)*P(5,4)*Metric(2,3) + P(-1,2)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,3)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,3)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,4)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,3)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,4)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) + P(1,3)*P(3,2)*P(5,1)*Metric(2,4) + P(1,4)*P(3,2)*P(5,1)*Metric(2,4) - P(1,2)*P(3,5)*P(5,1)*Metric(2,4) - P(1,4)*P(3,1)*P(5,2)*Metric(2,4) - P(1,5)*P(3,1)*P(5,2)*Metric(2,4) + P(1,5)*P(3,2)*P(5,3)*Metric(2,4) + P(1,5)*P(3,2)*P(5,4)*Metric(2,4) - P(1,2)*P(3,5)*P(5,4)*Metric(2,4) - P(-1,2)*P(-1,3)*P(5,1)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*P(3,1)*Metric(1,5)*Metric(2,4) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,3)*P(3,2)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,5)*Metric(2,4) - P(-1,3)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,5)*Metric(2,4) + P(-1,2)*P(-1,3)*P(3,5)*Metric(1,5)*Metric(2,4) - P(1,3)*P(3,2)*P(4,1)*Metric(2,5) - P(1,5)*P(3,2)*P(4,1)*Metric(2,5) - P(1,2)*P(3,5)*P(4,1)*Metric(2,5) - P(1,3)*P(3,5)*P(4,1)*Metric(2,5) + P(1,4)*P(3,1)*P(4,2)*Metric(2,5) + P(1,5)*P(3,1)*P(4,2)*Metric(2,5) + P(1,2)*P(3,1)*P(4,5)*Metric(2,5) + P(1,4)*P(3,1)*P(4,5)*Metric(2,5) + P(-1,2)*P(-1,3)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,4)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,3)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,4)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,4)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,2)*P(-1,3)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,2)*P(-1,4)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,3)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,3)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,3)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,2)*P(2,5)*P(4,1)*Metric(3,5) + P(1,3)*P(2,5)*P(4,1)*Metric(3,5) + P(1,5)*P(2,1)*P(4,2)*Metric(3,5) + P(1,5)*P(2,3)*P(4,2)*Metric(3,5) - P(1,3)*P(2,1)*P(4,5)*Metric(3,5) - P(1,4)*P(2,1)*P(4,5)*Metric(3,5) - P(1,2)*P(2,3)*P(4,5)*Metric(3,5) - P(1,2)*P(2,4)*P(4,5)*Metric(3,5) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,4)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) - P(-1,4)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,3)*P(2,5)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,3)*P(1,5)*Metric(2,4)*Metric(3,5) - P(1,2)*P(2,5)*P(3,1)*Metric(4,5) - P(1,4)*P(2,5)*P(3,1)*Metric(4,5) - P(1,5)*P(2,1)*P(3,2)*Metric(4,5) - P(1,5)*P(2,4)*P(3,2)*Metric(4,5) + P(1,3)*P(2,1)*P(3,5)*Metric(4,5) + P(1,4)*P(2,1)*P(3,5)*Metric(4,5) + P(1,2)*P(2,3)*P(3,5)*Metric(4,5) + P(1,2)*P(2,4)*P(3,5)*Metric(4,5) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV53 = Lorentz(name = 'VVVVV53',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = '-(P(3,4)*P(4,2)*P(5,1)*Metric(1,2))/2. + (P(3,5)*P(4,2)*P(5,1)*Metric(1,2))/2. + P(3,2)*P(4,3)*P(5,1)*Metric(1,2) - (P(3,2)*P(4,5)*P(5,1)*Metric(1,2))/2. - (P(3,4)*P(4,1)*P(5,2)*Metric(1,2))/2. + (P(3,5)*P(4,1)*P(5,2)*Metric(1,2))/2. + P(3,1)*P(4,3)*P(5,2)*Metric(1,2) - (P(3,1)*P(4,5)*P(5,2)*Metric(1,2))/2. - P(3,2)*P(4,1)*P(5,3)*Metric(1,2) - P(3,1)*P(4,2)*P(5,3)*Metric(1,2) + (P(3,1)*P(4,5)*P(5,3)*Metric(1,2))/2. + (P(3,2)*P(4,5)*P(5,3)*Metric(1,2))/2. + (P(3,2)*P(4,1)*P(5,4)*Metric(1,2))/2. + (P(3,1)*P(4,2)*P(5,4)*Metric(1,2))/2. - (P(3,1)*P(4,3)*P(5,4)*Metric(1,2))/2. - (P(3,2)*P(4,3)*P(5,4)*Metric(1,2))/2. + P(2,3)*P(4,2)*P(5,1)*Metric(1,3) - (P(2,4)*P(4,3)*P(5,1)*Metric(1,3))/2. + (P(2,5)*P(4,3)*P(5,1)*Metric(1,3))/2. - (P(2,3)*P(4,5)*P(5,1)*Metric(1,3))/2. - P(2,3)*P(4,1)*P(5,2)*Metric(1,3) - P(2,1)*P(4,3)*P(5,2)*Metric(1,3) + (P(2,1)*P(4,5)*P(5,2)*Metric(1,3))/2. + (P(2,3)*P(4,5)*P(5,2)*Metric(1,3))/2. - (P(2,4)*P(4,1)*P(5,3)*Metric(1,3))/2. + (P(2,5)*P(4,1)*P(5,3)*Metric(1,3))/2. + P(2,1)*P(4,2)*P(5,3)*Metric(1,3) - (P(2,1)*P(4,5)*P(5,3)*Metric(1,3))/2. + (P(2,3)*P(4,1)*P(5,4)*Metric(1,3))/2. - (P(2,1)*P(4,2)*P(5,4)*Metric(1,3))/2. - (P(2,3)*P(4,2)*P(5,4)*Metric(1,3))/2. + (P(2,1)*P(4,3)*P(5,4)*Metric(1,3))/2. + P(2,3)*P(3,1)*P(5,2)*Metric(1,4) + (P(2,1)*P(3,4)*P(5,2)*Metric(1,4))/2. - (P(2,3)*P(3,4)*P(5,2)*Metric(1,4))/2. - (P(2,1)*P(3,5)*P(5,2)*Metric(1,4))/2. + (P(2,4)*P(3,1)*P(5,3)*Metric(1,4))/2. - (P(2,5)*P(3,1)*P(5,3)*Metric(1,4))/2. + P(2,1)*P(3,2)*P(5,3)*Metric(1,4) - (P(2,4)*P(3,2)*P(5,3)*Metric(1,4))/2. - (P(2,3)*P(3,1)*P(5,4)*Metric(1,4))/2. - (P(2,1)*P(3,2)*P(5,4)*Metric(1,4))/2. - P(2,3)*P(3,1)*P(4,2)*Metric(1,5) + (P(2,1)*P(3,4)*P(4,2)*Metric(1,5))/2. - (P(2,1)*P(3,5)*P(4,2)*Metric(1,5))/2. + (P(2,3)*P(3,5)*P(4,2)*Metric(1,5))/2. + (P(2,4)*P(3,1)*P(4,3)*Metric(1,5))/2. - (P(2,5)*P(3,1)*P(4,3)*Metric(1,5))/2. - P(2,1)*P(3,2)*P(4,3)*Metric(1,5) + (P(2,5)*P(3,2)*P(4,3)*Metric(1,5))/2. + (P(2,3)*P(3,1)*P(4,5)*Metric(1,5))/2. + (P(2,1)*P(3,2)*P(4,5)*Metric(1,5))/2. - P(1,3)*P(4,2)*P(5,1)*Metric(2,3) - P(1,2)*P(4,3)*P(5,1)*Metric(2,3) + (P(1,2)*P(4,5)*P(5,1)*Metric(2,3))/2. + (P(1,3)*P(4,5)*P(5,1)*Metric(2,3))/2. + P(1,3)*P(4,1)*P(5,2)*Metric(2,3) - (P(1,4)*P(4,3)*P(5,2)*Metric(2,3))/2. + (P(1,5)*P(4,3)*P(5,2)*Metric(2,3))/2. - (P(1,3)*P(4,5)*P(5,2)*Metric(2,3))/2. + P(1,2)*P(4,1)*P(5,3)*Metric(2,3) - (P(1,4)*P(4,2)*P(5,3)*Metric(2,3))/2. + (P(1,5)*P(4,2)*P(5,3)*Metric(2,3))/2. - (P(1,2)*P(4,5)*P(5,3)*Metric(2,3))/2. - (P(1,2)*P(4,1)*P(5,4)*Metric(2,3))/2. - (P(1,3)*P(4,1)*P(5,4)*Metric(2,3))/2. + (P(1,3)*P(4,2)*P(5,4)*Metric(2,3))/2. + (P(1,2)*P(4,3)*P(5,4)*Metric(2,3))/2. - P(-1,1)*P(-1,3)*P(5,2)*Metric(1,4)*Metric(2,3) + (P(-1,3)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3))/2. - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,4)*Metric(2,3) + (P(-1,2)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,2)*P(5,4)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,3)*P(5,4)*Metric(1,4)*Metric(2,3))/2. + P(-1,1)*P(-1,3)*P(4,2)*Metric(1,5)*Metric(2,3) - (P(-1,3)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3))/2. + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,5)*Metric(2,3) - (P(-1,2)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3))/2. - (P(-1,1)*P(-1,2)*P(4,5)*Metric(1,5)*Metric(2,3))/2. - (P(-1,1)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3))/2. + P(1,3)*P(3,2)*P(5,1)*Metric(2,4) + (P(1,2)*P(3,4)*P(5,1)*Metric(2,4))/2. - (P(1,3)*P(3,4)*P(5,1)*Metric(2,4))/2. - (P(1,2)*P(3,5)*P(5,1)*Metric(2,4))/2. + P(1,2)*P(3,1)*P(5,3)*Metric(2,4) - (P(1,4)*P(3,1)*P(5,3)*Metric(2,4))/2. + (P(1,4)*P(3,2)*P(5,3)*Metric(2,4))/2. - (P(1,5)*P(3,2)*P(5,3)*Metric(2,4))/2. - (P(1,2)*P(3,1)*P(5,4)*Metric(2,4))/2. - (P(1,3)*P(3,2)*P(5,4)*Metric(2,4))/2. - P(-1,2)*P(-1,3)*P(5,1)*Metric(1,3)*Metric(2,4) + (P(-1,3)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4))/2. - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,3)*Metric(2,4) + (P(-1,1)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,2)*P(5,4)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4))/2. + P(-1,2)*P(-1,3)*P(3,1)*Metric(1,5)*Metric(2,4) - (P(-1,3)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4))/2. - P(-1,1)*P(-1,3)*P(3,2)*Metric(1,5)*Metric(2,4) + (P(-1,3)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4))/2. - (P(-1,1)*P(-1,2)*P(3,4)*Metric(1,5)*Metric(2,4))/2. + (P(-1,1)*P(-1,3)*P(3,4)*Metric(1,5)*Metric(2,4))/2. + (P(-1,1)*P(-1,2)*P(3,5)*Metric(1,5)*Metric(2,4))/2. - (P(-1,2)*P(-1,3)*P(3,5)*Metric(1,5)*Metric(2,4))/2. - P(1,3)*P(3,2)*P(4,1)*Metric(2,5) + (P(1,2)*P(3,4)*P(4,1)*Metric(2,5))/2. - (P(1,2)*P(3,5)*P(4,1)*Metric(2,5))/2. + (P(1,3)*P(3,5)*P(4,1)*Metric(2,5))/2. - P(1,2)*P(3,1)*P(4,3)*Metric(2,5) + (P(1,5)*P(3,1)*P(4,3)*Metric(2,5))/2. + (P(1,4)*P(3,2)*P(4,3)*Metric(2,5))/2. - (P(1,5)*P(3,2)*P(4,3)*Metric(2,5))/2. + (P(1,2)*P(3,1)*P(4,5)*Metric(2,5))/2. + (P(1,3)*P(3,2)*P(4,5)*Metric(2,5))/2. + P(-1,2)*P(-1,3)*P(4,1)*Metric(1,3)*Metric(2,5) - (P(-1,3)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5))/2. + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,3)*Metric(2,5) - (P(-1,1)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5))/2. - (P(-1,1)*P(-1,2)*P(4,5)*Metric(1,3)*Metric(2,5))/2. - (P(-1,2)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5))/2. - P(-1,2)*P(-1,3)*P(3,1)*Metric(1,4)*Metric(2,5) + (P(-1,3)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5))/2. + P(-1,1)*P(-1,3)*P(3,2)*Metric(1,4)*Metric(2,5) - (P(-1,3)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5))/2. - (P(-1,1)*P(-1,2)*P(3,4)*Metric(1,4)*Metric(2,5))/2. + (P(-1,2)*P(-1,3)*P(3,4)*Metric(1,4)*Metric(2,5))/2. + (P(-1,1)*P(-1,2)*P(3,5)*Metric(1,4)*Metric(2,5))/2. - (P(-1,1)*P(-1,3)*P(3,5)*Metric(1,4)*Metric(2,5))/2. + P(1,2)*P(2,3)*P(5,1)*Metric(3,4) - (P(1,2)*P(2,4)*P(5,1)*Metric(3,4))/2. + (P(1,3)*P(2,4)*P(5,1)*Metric(3,4))/2. - (P(1,3)*P(2,5)*P(5,1)*Metric(3,4))/2. + P(1,3)*P(2,1)*P(5,2)*Metric(3,4) - (P(1,4)*P(2,1)*P(5,2)*Metric(3,4))/2. + (P(1,4)*P(2,3)*P(5,2)*Metric(3,4))/2. - (P(1,5)*P(2,3)*P(5,2)*Metric(3,4))/2. - (P(1,3)*P(2,1)*P(5,4)*Metric(3,4))/2. - (P(1,2)*P(2,3)*P(5,4)*Metric(3,4))/2. - P(-1,2)*P(-1,3)*P(5,1)*Metric(1,2)*Metric(3,4) + (P(-1,2)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4))/2. - P(-1,1)*P(-1,3)*P(5,2)*Metric(1,2)*Metric(3,4) + (P(-1,1)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4))/2. + (P(-1,1)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4))/2. + (P(-1,2)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4))/2. + P(-1,2)*P(-1,3)*P(2,1)*Metric(1,5)*Metric(3,4) - (P(-1,2)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4))/2. - P(-1,1)*P(-1,2)*P(2,3)*Metric(1,5)*Metric(3,4) + (P(-1,2)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4))/2. + (P(-1,1)*P(-1,2)*P(2,4)*Metric(1,5)*Metric(3,4))/2. - (P(-1,1)*P(-1,3)*P(2,4)*Metric(1,5)*Metric(3,4))/2. + (P(-1,1)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4))/2. - (P(-1,2)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4))/2. + P(-1,1)*P(-1,3)*P(1,2)*Metric(2,5)*Metric(3,4) - (P(-1,1)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4))/2. - P(-1,1)*P(-1,2)*P(1,3)*Metric(2,5)*Metric(3,4) + (P(-1,1)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4))/2. + (P(-1,1)*P(-1,2)*P(1,4)*Metric(2,5)*Metric(3,4))/2. - (P(-1,2)*P(-1,3)*P(1,4)*Metric(2,5)*Metric(3,4))/2. - (P(-1,1)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4))/2. + (P(-1,2)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4))/2. - P(1,2)*P(2,3)*P(4,1)*Metric(3,5) + (P(1,3)*P(2,4)*P(4,1)*Metric(3,5))/2. + (P(1,2)*P(2,5)*P(4,1)*Metric(3,5))/2. - (P(1,3)*P(2,5)*P(4,1)*Metric(3,5))/2. - P(1,3)*P(2,1)*P(4,2)*Metric(3,5) + (P(1,5)*P(2,1)*P(4,2)*Metric(3,5))/2. + (P(1,4)*P(2,3)*P(4,2)*Metric(3,5))/2. - (P(1,5)*P(2,3)*P(4,2)*Metric(3,5))/2. + (P(1,3)*P(2,1)*P(4,5)*Metric(3,5))/2. + (P(1,2)*P(2,3)*P(4,5)*Metric(3,5))/2. + P(-1,2)*P(-1,3)*P(4,1)*Metric(1,2)*Metric(3,5) - (P(-1,2)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5))/2. + P(-1,1)*P(-1,3)*P(4,2)*Metric(1,2)*Metric(3,5) - (P(-1,1)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5))/2. - (P(-1,1)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5))/2. - (P(-1,2)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5))/2. - P(-1,2)*P(-1,3)*P(2,1)*Metric(1,4)*Metric(3,5) + (P(-1,2)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5))/2. + P(-1,1)*P(-1,2)*P(2,3)*Metric(1,4)*Metric(3,5) - (P(-1,2)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,3)*P(2,4)*Metric(1,4)*Metric(3,5))/2. + (P(-1,2)*P(-1,3)*P(2,4)*Metric(1,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,2)*P(2,5)*Metric(1,4)*Metric(3,5))/2. + (P(-1,1)*P(-1,3)*P(2,5)*Metric(1,4)*Metric(3,5))/2. - P(-1,1)*P(-1,3)*P(1,2)*Metric(2,4)*Metric(3,5) + (P(-1,1)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5))/2. + P(-1,1)*P(-1,2)*P(1,3)*Metric(2,4)*Metric(3,5) - (P(-1,1)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5))/2. + (P(-1,1)*P(-1,3)*P(1,4)*Metric(2,4)*Metric(3,5))/2. - (P(-1,2)*P(-1,3)*P(1,4)*Metric(2,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,2)*P(1,5)*Metric(2,4)*Metric(3,5))/2. + (P(-1,2)*P(-1,3)*P(1,5)*Metric(2,4)*Metric(3,5))/2. + (P(1,4)*P(2,3)*P(3,1)*Metric(4,5))/2. - (P(1,5)*P(2,3)*P(3,1)*Metric(4,5))/2. + (P(1,2)*P(2,4)*P(3,1)*Metric(4,5))/2. - (P(1,2)*P(2,5)*P(3,1)*Metric(4,5))/2. + (P(1,4)*P(2,1)*P(3,2)*Metric(4,5))/2. - (P(1,5)*P(2,1)*P(3,2)*Metric(4,5))/2. + (P(1,3)*P(2,4)*P(3,2)*Metric(4,5))/2. - (P(1,3)*P(2,5)*P(3,2)*Metric(4,5))/2. + (P(1,3)*P(2,1)*P(3,4)*Metric(4,5))/2. + (P(1,2)*P(2,3)*P(3,4)*Metric(4,5))/2. - (P(1,3)*P(2,1)*P(3,5)*Metric(4,5))/2. - (P(1,2)*P(2,3)*P(3,5)*Metric(4,5))/2. - (P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5))/2. + (P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5))/2. + (P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5))/2. - (P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5))/2. - (P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5))/2. + (P(-1,3)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5))/2. + (P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5))/2. - (P(-1,3)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5))/2. - (P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5))/2. - (P(-1,2)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5))/2. + (P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5))/2. + (P(-1,2)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5))/2. + (P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5))/2. - (P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5))/2. - (P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5))/2. + (P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3)*Metric(4,5))/2. + (P(-1,2)*P(-1,4)*P(2,3)*Metric(1,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5))/2. - (P(-1,2)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3)*Metric(4,5))/2. - (P(-1,2)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3)*Metric(4,5))/2. + (P(-1,2)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5))/2. - (P(-1,3)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5))/2. + (P(-1,3)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3)*Metric(4,5))/2. - (P(-1,2)*P(-1,4)*P(1,3)*Metric(2,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5))/2. + (P(-1,2)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5))/2.')

VVVVV54 = Lorentz(name = 'VVVVV54',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,4)*P(4,2)*P(5,1)*Metric(1,2) + P(3,2)*P(4,3)*P(5,1)*Metric(1,2) + P(3,4)*P(4,1)*P(5,2)*Metric(1,2) + P(3,1)*P(4,3)*P(5,2)*Metric(1,2) - P(3,2)*P(4,1)*P(5,3)*Metric(1,2) - P(3,4)*P(4,1)*P(5,3)*Metric(1,2) - P(3,1)*P(4,2)*P(5,3)*Metric(1,2) - P(3,4)*P(4,2)*P(5,3)*Metric(1,2) + P(3,1)*P(4,5)*P(5,3)*Metric(1,2) + P(3,2)*P(4,5)*P(5,3)*Metric(1,2) - P(3,2)*P(4,1)*P(5,4)*Metric(1,2) + P(3,5)*P(4,1)*P(5,4)*Metric(1,2) - P(3,1)*P(4,2)*P(5,4)*Metric(1,2) + P(3,5)*P(4,2)*P(5,4)*Metric(1,2) - P(3,1)*P(4,3)*P(5,4)*Metric(1,2) - P(3,2)*P(4,3)*P(5,4)*Metric(1,2) + 2*P(2,3)*P(4,2)*P(5,1)*Metric(1,3) - P(2,4)*P(4,3)*P(5,1)*Metric(1,3) + P(2,5)*P(4,3)*P(5,1)*Metric(1,3) - P(2,3)*P(4,5)*P(5,1)*Metric(1,3) - 2*P(2,3)*P(4,1)*P(5,2)*Metric(1,3) + 2*P(2,4)*P(4,1)*P(5,2)*Metric(1,3) - P(2,1)*P(4,3)*P(5,2)*Metric(1,3) - P(2,4)*P(4,3)*P(5,2)*Metric(1,3) + P(2,3)*P(4,5)*P(5,2)*Metric(1,3) - 2*P(2,4)*P(4,1)*P(5,3)*Metric(1,3) + P(2,5)*P(4,1)*P(5,3)*Metric(1,3) + P(2,1)*P(4,2)*P(5,3)*Metric(1,3) - P(2,1)*P(4,5)*P(5,3)*Metric(1,3) + 2*P(2,3)*P(4,1)*P(5,4)*Metric(1,3) - P(2,5)*P(4,1)*P(5,4)*Metric(1,3) + P(2,1)*P(4,2)*P(5,4)*Metric(1,3) - 2*P(2,3)*P(4,2)*P(5,4)*Metric(1,3) + P(2,1)*P(4,3)*P(5,4)*Metric(1,3) + 2*P(2,4)*P(3,2)*P(5,1)*Metric(1,4) - P(2,3)*P(3,4)*P(5,1)*Metric(1,4) + P(2,5)*P(3,4)*P(5,1)*Metric(1,4) - P(2,4)*P(3,5)*P(5,1)*Metric(1,4) + 2*P(2,3)*P(3,1)*P(5,2)*Metric(1,4) - 2*P(2,4)*P(3,1)*P(5,2)*Metric(1,4) - P(2,1)*P(3,4)*P(5,2)*Metric(1,4) - P(2,3)*P(3,4)*P(5,2)*Metric(1,4) + P(2,4)*P(3,5)*P(5,2)*Metric(1,4) + 2*P(2,4)*P(3,1)*P(5,3)*Metric(1,4) - P(2,5)*P(3,1)*P(5,3)*Metric(1,4) + P(2,1)*P(3,2)*P(5,3)*Metric(1,4) - 2*P(2,4)*P(3,2)*P(5,3)*Metric(1,4) + P(2,1)*P(3,4)*P(5,3)*Metric(1,4) - 2*P(2,3)*P(3,1)*P(5,4)*Metric(1,4) + P(2,5)*P(3,1)*P(5,4)*Metric(1,4) + P(2,1)*P(3,2)*P(5,4)*Metric(1,4) - P(2,1)*P(3,5)*P(5,4)*Metric(1,4) - 2*P(2,4)*P(3,2)*P(4,1)*Metric(1,5) + P(2,3)*P(3,4)*P(4,1)*Metric(1,5) - P(2,5)*P(3,4)*P(4,1)*Metric(1,5) + P(2,4)*P(3,5)*P(4,1)*Metric(1,5) - 2*P(2,3)*P(3,1)*P(4,2)*Metric(1,5) - P(2,1)*P(3,4)*P(4,2)*Metric(1,5) + P(2,5)*P(3,4)*P(4,2)*Metric(1,5) + P(2,3)*P(3,5)*P(4,2)*Metric(1,5) + P(2,4)*P(3,1)*P(4,3)*Metric(1,5) - P(2,5)*P(3,1)*P(4,3)*Metric(1,5) - P(2,1)*P(3,2)*P(4,3)*Metric(1,5) + P(2,5)*P(3,2)*P(4,3)*Metric(1,5) + P(2,3)*P(3,1)*P(4,5)*Metric(1,5) + P(2,4)*P(3,2)*P(4,5)*Metric(1,5) - 2*P(1,3)*P(4,2)*P(5,1)*Metric(2,3) + 2*P(1,4)*P(4,2)*P(5,1)*Metric(2,3) - P(1,2)*P(4,3)*P(5,1)*Metric(2,3) - P(1,4)*P(4,3)*P(5,1)*Metric(2,3) + P(1,3)*P(4,5)*P(5,1)*Metric(2,3) + 2*P(1,3)*P(4,1)*P(5,2)*Metric(2,3) - P(1,4)*P(4,3)*P(5,2)*Metric(2,3) + P(1,5)*P(4,3)*P(5,2)*Metric(2,3) - P(1,3)*P(4,5)*P(5,2)*Metric(2,3) + P(1,2)*P(4,1)*P(5,3)*Metric(2,3) - 2*P(1,4)*P(4,2)*P(5,3)*Metric(2,3) + P(1,5)*P(4,2)*P(5,3)*Metric(2,3) - P(1,2)*P(4,5)*P(5,3)*Metric(2,3) + P(1,2)*P(4,1)*P(5,4)*Metric(2,3) - 2*P(1,3)*P(4,1)*P(5,4)*Metric(2,3) + 2*P(1,3)*P(4,2)*P(5,4)*Metric(2,3) - P(1,5)*P(4,2)*P(5,4)*Metric(2,3) + P(1,2)*P(4,3)*P(5,4)*Metric(2,3) - 2*P(-1,2)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) - 2*P(-1,1)*P(-1,3)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,4)*Metric(2,3) + 2*P(-1,2)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(5,4)*Metric(1,4)*Metric(2,3) + 2*P(-1,1)*P(-1,3)*P(5,4)*Metric(1,4)*Metric(2,3) + 2*P(-1,2)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) + 2*P(-1,1)*P(-1,3)*P(4,2)*Metric(1,5)*Metric(2,3) - 2*P(-1,1)*P(-1,4)*P(4,2)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,4)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,4)*P(4,3)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) + 2*P(1,3)*P(3,2)*P(5,1)*Metric(2,4) - 2*P(1,4)*P(3,2)*P(5,1)*Metric(2,4) - P(1,2)*P(3,4)*P(5,1)*Metric(2,4) - P(1,3)*P(3,4)*P(5,1)*Metric(2,4) + P(1,4)*P(3,5)*P(5,1)*Metric(2,4) + 2*P(1,4)*P(3,1)*P(5,2)*Metric(2,4) - P(1,3)*P(3,4)*P(5,2)*Metric(2,4) + P(1,5)*P(3,4)*P(5,2)*Metric(2,4) - P(1,4)*P(3,5)*P(5,2)*Metric(2,4) + P(1,2)*P(3,1)*P(5,3)*Metric(2,4) - 2*P(1,4)*P(3,1)*P(5,3)*Metric(2,4) + 2*P(1,4)*P(3,2)*P(5,3)*Metric(2,4) - P(1,5)*P(3,2)*P(5,3)*Metric(2,4) + P(1,2)*P(3,4)*P(5,3)*Metric(2,4) + P(1,2)*P(3,1)*P(5,4)*Metric(2,4) - 2*P(1,3)*P(3,2)*P(5,4)*Metric(2,4) + P(1,5)*P(3,2)*P(5,4)*Metric(2,4) - P(1,2)*P(3,5)*P(5,4)*Metric(2,4) - 2*P(-1,2)*P(-1,3)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) - 2*P(-1,1)*P(-1,4)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*P(5,2)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,3)*Metric(2,4) + 2*P(-1,1)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,2)*P(5,4)*Metric(1,3)*Metric(2,4) + 2*P(-1,2)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4) + 2*P(-1,2)*P(-1,3)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,3)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) - 2*P(-1,1)*P(-1,3)*P(3,2)*Metric(1,5)*Metric(2,4) + 2*P(-1,1)*P(-1,4)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,3)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,2)*P(3,4)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,3)*P(3,4)*Metric(1,5)*Metric(2,4) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) - P(-1,2)*P(-1,3)*P(3,5)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - 2*P(1,3)*P(3,2)*P(4,1)*Metric(2,5) - P(1,2)*P(3,4)*P(4,1)*Metric(2,5) + P(1,5)*P(3,4)*P(4,1)*Metric(2,5) + P(1,3)*P(3,5)*P(4,1)*Metric(2,5) - 2*P(1,4)*P(3,1)*P(4,2)*Metric(2,5) + P(1,3)*P(3,4)*P(4,2)*Metric(2,5) - P(1,5)*P(3,4)*P(4,2)*Metric(2,5) + P(1,4)*P(3,5)*P(4,2)*Metric(2,5) - P(1,2)*P(3,1)*P(4,3)*Metric(2,5) + P(1,5)*P(3,1)*P(4,3)*Metric(2,5) + P(1,4)*P(3,2)*P(4,3)*Metric(2,5) - P(1,5)*P(3,2)*P(4,3)*Metric(2,5) + P(1,4)*P(3,1)*P(4,5)*Metric(2,5) + P(1,3)*P(3,2)*P(4,5)*Metric(2,5) + 2*P(-1,2)*P(-1,3)*P(4,1)*Metric(1,3)*Metric(2,5) - 2*P(-1,2)*P(-1,4)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,4)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) + 2*P(-1,1)*P(-1,4)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,3)*P(-1,4)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,4)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,2)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) - 2*P(-1,2)*P(-1,3)*P(3,1)*Metric(1,4)*Metric(2,5) + 2*P(-1,2)*P(-1,4)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,3)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) + 2*P(-1,1)*P(-1,3)*P(3,2)*Metric(1,4)*Metric(2,5) - P(-1,3)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,2)*P(3,4)*Metric(1,4)*Metric(2,5) + P(-1,2)*P(-1,3)*P(3,4)*Metric(1,4)*Metric(2,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) - P(-1,1)*P(-1,3)*P(3,5)*Metric(1,4)*Metric(2,5) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,2)*P(2,3)*P(5,1)*Metric(3,4) + P(1,4)*P(2,3)*P(5,1)*Metric(3,4) + P(1,2)*P(2,4)*P(5,1)*Metric(3,4) + P(1,3)*P(2,4)*P(5,1)*Metric(3,4) - P(1,3)*P(2,5)*P(5,1)*Metric(3,4) - P(1,4)*P(2,5)*P(5,1)*Metric(3,4) + P(1,3)*P(2,1)*P(5,2)*Metric(3,4) + P(1,4)*P(2,1)*P(5,2)*Metric(3,4) + P(1,4)*P(2,3)*P(5,2)*Metric(3,4) - P(1,5)*P(2,3)*P(5,2)*Metric(3,4) + P(1,3)*P(2,4)*P(5,2)*Metric(3,4) - P(1,5)*P(2,4)*P(5,2)*Metric(3,4) - P(1,4)*P(2,1)*P(5,3)*Metric(3,4) - P(1,2)*P(2,4)*P(5,3)*Metric(3,4) - P(1,3)*P(2,1)*P(5,4)*Metric(3,4) - P(1,2)*P(2,3)*P(5,4)*Metric(3,4) - P(-1,2)*P(-1,3)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,3)*P(5,2)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(2,4)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,3)*P(2,4)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4) - P(-1,2)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) - P(-1,2)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(1,2)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(1,3)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,4)*P(1,3)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,3)*P(1,4)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4) + P(-1,2)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) - P(1,2)*P(2,3)*P(4,1)*Metric(3,5) + 2*P(1,3)*P(2,4)*P(4,1)*Metric(3,5) - P(1,5)*P(2,4)*P(4,1)*Metric(3,5) - P(1,3)*P(2,5)*P(4,1)*Metric(3,5) - P(1,3)*P(2,1)*P(4,2)*Metric(3,5) + 2*P(1,4)*P(2,3)*P(4,2)*Metric(3,5) - P(1,5)*P(2,3)*P(4,2)*Metric(3,5) - P(1,4)*P(2,5)*P(4,2)*Metric(3,5) + P(1,4)*P(2,1)*P(4,3)*Metric(3,5) + P(1,2)*P(2,4)*P(4,3)*Metric(3,5) + P(1,3)*P(2,1)*P(4,5)*Metric(3,5) - P(1,4)*P(2,1)*P(4,5)*Metric(3,5) + P(1,2)*P(2,3)*P(4,5)*Metric(3,5) - P(1,2)*P(2,4)*P(4,5)*Metric(3,5) + P(-1,2)*P(-1,3)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,4)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,4)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,3)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,4)*P(4,2)*Metric(1,2)*Metric(3,5) - P(-1,4)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,4)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,4)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,3)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,2)*P(2,3)*Metric(1,4)*Metric(3,5) - 2*P(-1,2)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5) - 2*P(-1,1)*P(-1,3)*P(2,4)*Metric(1,4)*Metric(3,5) + 2*P(-1,2)*P(-1,3)*P(2,4)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - P(-1,2)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,3)*P(2,5)*Metric(1,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,3)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,3)*P(-1,4)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,2)*P(1,3)*Metric(2,4)*Metric(3,5) - 2*P(-1,1)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5) + 2*P(-1,1)*P(-1,3)*P(1,4)*Metric(2,4)*Metric(3,5) - 2*P(-1,2)*P(-1,3)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,3)*P(1,5)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(1,4)*P(2,3)*P(3,1)*Metric(4,5) - P(1,5)*P(2,3)*P(3,1)*Metric(4,5) - P(1,2)*P(2,4)*P(3,1)*Metric(4,5) - P(1,4)*P(2,5)*P(3,1)*Metric(4,5) - P(1,4)*P(2,1)*P(3,2)*Metric(4,5) + 2*P(1,3)*P(2,4)*P(3,2)*Metric(4,5) - P(1,5)*P(2,4)*P(3,2)*Metric(4,5) - P(1,3)*P(2,5)*P(3,2)*Metric(4,5) + P(1,3)*P(2,1)*P(3,4)*Metric(4,5) + P(1,2)*P(2,3)*P(3,4)*Metric(4,5) - P(1,3)*P(2,1)*P(3,5)*Metric(4,5) + P(1,4)*P(2,1)*P(3,5)*Metric(4,5) - P(1,2)*P(2,3)*P(3,5)*Metric(4,5) + P(1,2)*P(2,4)*P(3,5)*Metric(4,5) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5) - P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5) - P(-1,3)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) - 2*P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3)*Metric(4,5) + 2*P(-1,2)*P(-1,4)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3)*Metric(4,5) - 2*P(-1,2)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,2)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5) + P(-1,3)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) + 2*P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3)*Metric(4,5) - 2*P(-1,2)*P(-1,4)*P(1,3)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3)*Metric(4,5) - 2*P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV55 = Lorentz(name = 'VVVVV55',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,4)*P(4,2)*P(5,1)*Metric(1,2) + P(3,2)*P(4,3)*P(5,1)*Metric(1,2) + P(3,5)*P(4,3)*P(5,1)*Metric(1,2) + P(3,4)*P(4,5)*P(5,1)*Metric(1,2) + P(3,4)*P(4,1)*P(5,2)*Metric(1,2) + P(3,1)*P(4,3)*P(5,2)*Metric(1,2) + P(3,5)*P(4,3)*P(5,2)*Metric(1,2) + P(3,4)*P(4,5)*P(5,2)*Metric(1,2) - P(3,2)*P(4,1)*P(5,3)*Metric(1,2) - P(3,4)*P(4,1)*P(5,3)*Metric(1,2) - P(3,1)*P(4,2)*P(5,3)*Metric(1,2) - P(3,4)*P(4,2)*P(5,3)*Metric(1,2) - P(3,2)*P(4,1)*P(5,4)*Metric(1,2) - P(3,1)*P(4,2)*P(5,4)*Metric(1,2) - P(3,1)*P(4,3)*P(5,4)*Metric(1,2) - P(3,2)*P(4,3)*P(5,4)*Metric(1,2) - P(2,4)*P(4,3)*P(5,1)*Metric(1,3) - P(2,4)*P(4,5)*P(5,1)*Metric(1,3) - P(2,1)*P(4,3)*P(5,2)*Metric(1,3) - P(2,4)*P(4,3)*P(5,2)*Metric(1,3) + P(2,1)*P(4,2)*P(5,3)*Metric(1,3) + P(2,5)*P(4,2)*P(5,3)*Metric(1,3) + P(2,1)*P(4,2)*P(5,4)*Metric(1,3) + P(2,1)*P(4,3)*P(5,4)*Metric(1,3) - P(2,3)*P(3,4)*P(5,1)*Metric(1,4) - P(2,3)*P(3,5)*P(5,1)*Metric(1,4) - P(2,1)*P(3,4)*P(5,2)*Metric(1,4) - P(2,3)*P(3,4)*P(5,2)*Metric(1,4) + P(2,1)*P(3,2)*P(5,3)*Metric(1,4) + P(2,1)*P(3,4)*P(5,3)*Metric(1,4) + P(2,1)*P(3,2)*P(5,4)*Metric(1,4) + P(2,5)*P(3,2)*P(5,4)*Metric(1,4) + P(2,3)*P(3,4)*P(4,1)*Metric(1,5) + P(2,3)*P(3,5)*P(4,1)*Metric(1,5) - P(2,1)*P(3,4)*P(4,2)*Metric(1,5) + P(2,4)*P(3,1)*P(4,3)*Metric(1,5) - P(2,1)*P(3,2)*P(4,3)*Metric(1,5) - P(2,1)*P(3,5)*P(4,3)*Metric(1,5) + P(2,4)*P(3,1)*P(4,5)*Metric(1,5) - P(2,1)*P(3,4)*P(4,5)*Metric(1,5) - P(1,2)*P(4,3)*P(5,1)*Metric(2,3) - P(1,4)*P(4,3)*P(5,1)*Metric(2,3) - P(1,4)*P(4,3)*P(5,2)*Metric(2,3) - P(1,4)*P(4,5)*P(5,2)*Metric(2,3) + P(1,2)*P(4,1)*P(5,3)*Metric(2,3) + P(1,5)*P(4,1)*P(5,3)*Metric(2,3) + P(1,2)*P(4,1)*P(5,4)*Metric(2,3) + P(1,2)*P(4,3)*P(5,4)*Metric(2,3) + P(-1,3)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(5,4)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,4)*P(4,3)*Metric(1,5)*Metric(2,3) - P(1,2)*P(3,4)*P(5,1)*Metric(2,4) - P(1,3)*P(3,4)*P(5,1)*Metric(2,4) - P(1,3)*P(3,4)*P(5,2)*Metric(2,4) - P(1,3)*P(3,5)*P(5,2)*Metric(2,4) + P(1,2)*P(3,1)*P(5,3)*Metric(2,4) + P(1,2)*P(3,4)*P(5,3)*Metric(2,4) + P(1,2)*P(3,1)*P(5,4)*Metric(2,4) + P(1,5)*P(3,1)*P(5,4)*Metric(2,4) + P(-1,3)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,5)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,2)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,2)*P(3,4)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,3)*P(3,4)*Metric(1,5)*Metric(2,4) - P(1,2)*P(3,4)*P(4,1)*Metric(2,5) + P(1,3)*P(3,4)*P(4,2)*Metric(2,5) + P(1,3)*P(3,5)*P(4,2)*Metric(2,5) - P(1,2)*P(3,1)*P(4,3)*Metric(2,5) + P(1,4)*P(3,2)*P(4,3)*Metric(2,5) - P(1,2)*P(3,5)*P(4,3)*Metric(2,5) + P(1,4)*P(3,2)*P(4,5)*Metric(2,5) - P(1,2)*P(3,4)*P(4,5)*Metric(2,5) - P(-1,3)*P(-1,4)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,3)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,4)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,3)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,2)*P(3,4)*Metric(1,4)*Metric(2,5) + P(-1,2)*P(-1,3)*P(3,4)*Metric(1,4)*Metric(2,5) + P(1,2)*P(2,3)*P(5,1)*Metric(3,4) + P(1,4)*P(2,3)*P(5,1)*Metric(3,4) + P(1,2)*P(2,4)*P(5,1)*Metric(3,4) + P(1,3)*P(2,4)*P(5,1)*Metric(3,4) + P(1,3)*P(2,1)*P(5,2)*Metric(3,4) + P(1,4)*P(2,1)*P(5,2)*Metric(3,4) + P(1,4)*P(2,3)*P(5,2)*Metric(3,4) + P(1,3)*P(2,4)*P(5,2)*Metric(3,4) - P(1,4)*P(2,1)*P(5,3)*Metric(3,4) - P(1,5)*P(2,1)*P(5,3)*Metric(3,4) - P(1,2)*P(2,4)*P(5,3)*Metric(3,4) - P(1,2)*P(2,5)*P(5,3)*Metric(3,4) - P(1,3)*P(2,1)*P(5,4)*Metric(3,4) - P(1,5)*P(2,1)*P(5,4)*Metric(3,4) - P(1,2)*P(2,3)*P(5,4)*Metric(3,4) - P(1,2)*P(2,5)*P(5,4)*Metric(3,4) - P(-1,2)*P(-1,3)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,3)*P(5,2)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(2,4)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,3)*P(2,4)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(1,2)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) + P(-1,3)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(1,3)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,4)*P(1,3)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,3)*P(1,4)*Metric(2,5)*Metric(3,4) - P(1,2)*P(2,3)*P(4,1)*Metric(3,5) - P(1,5)*P(2,3)*P(4,1)*Metric(3,5) - P(1,3)*P(2,1)*P(4,2)*Metric(3,5) - P(1,3)*P(2,5)*P(4,2)*Metric(3,5) + P(1,4)*P(2,1)*P(4,3)*Metric(3,5) + P(1,5)*P(2,1)*P(4,3)*Metric(3,5) + P(1,2)*P(2,4)*P(4,3)*Metric(3,5) + P(1,2)*P(2,5)*P(4,3)*Metric(3,5) + P(-1,2)*P(-1,3)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,4)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,3)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,4)*P(4,2)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,4)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,4)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,3)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,2)*P(2,3)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,3)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,3)*P(-1,4)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,2)*P(1,3)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,5)*P(1,3)*Metric(2,4)*Metric(3,5) - P(1,2)*P(2,4)*P(3,1)*Metric(4,5) - P(1,5)*P(2,4)*P(3,1)*Metric(4,5) - P(1,4)*P(2,1)*P(3,2)*Metric(4,5) - P(1,4)*P(2,5)*P(3,2)*Metric(4,5) + P(1,3)*P(2,1)*P(3,4)*Metric(4,5) + P(1,5)*P(2,1)*P(3,4)*Metric(4,5) + P(1,2)*P(2,3)*P(3,4)*Metric(4,5) + P(1,2)*P(2,5)*P(3,4)*Metric(4,5) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5)')

VVVVV56 = Lorentz(name = 'VVVVV56',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = '-(P(3,4)*P(4,2)*P(5,1)*Metric(1,2)) + 2*P(3,5)*P(4,2)*P(5,1)*Metric(1,2) + P(3,2)*P(4,3)*P(5,1)*Metric(1,2) - P(3,5)*P(4,3)*P(5,1)*Metric(1,2) - 2*P(3,2)*P(4,5)*P(5,1)*Metric(1,2) + P(3,4)*P(4,5)*P(5,1)*Metric(1,2) - P(3,4)*P(4,1)*P(5,2)*Metric(1,2) + 2*P(3,5)*P(4,1)*P(5,2)*Metric(1,2) + P(3,1)*P(4,3)*P(5,2)*Metric(1,2) - P(3,5)*P(4,3)*P(5,2)*Metric(1,2) - 2*P(3,1)*P(4,5)*P(5,2)*Metric(1,2) + P(3,4)*P(4,5)*P(5,2)*Metric(1,2) - P(3,2)*P(4,1)*P(5,3)*Metric(1,2) - P(3,1)*P(4,2)*P(5,3)*Metric(1,2) + P(3,2)*P(4,1)*P(5,4)*Metric(1,2) + P(3,1)*P(4,2)*P(5,4)*Metric(1,2) + 2*P(2,5)*P(4,2)*P(5,1)*Metric(1,3) - P(2,5)*P(4,3)*P(5,1)*Metric(1,3) + P(2,3)*P(4,5)*P(5,1)*Metric(1,3) - P(2,4)*P(4,5)*P(5,1)*Metric(1,3) - P(2,1)*P(4,3)*P(5,2)*Metric(1,3) + 2*P(2,1)*P(4,5)*P(5,2)*Metric(1,3) - P(2,3)*P(4,5)*P(5,2)*Metric(1,3) + P(2,1)*P(4,2)*P(5,3)*Metric(1,3) - P(2,5)*P(4,2)*P(5,3)*Metric(1,3) - P(2,1)*P(4,2)*P(5,4)*Metric(1,3) - 2*P(2,5)*P(3,2)*P(5,1)*Metric(1,4) + P(2,5)*P(3,4)*P(5,1)*Metric(1,4) + P(2,3)*P(3,5)*P(5,1)*Metric(1,4) - P(2,4)*P(3,5)*P(5,1)*Metric(1,4) + P(2,1)*P(3,4)*P(5,2)*Metric(1,4) - 2*P(2,1)*P(3,5)*P(5,2)*Metric(1,4) + P(2,4)*P(3,5)*P(5,2)*Metric(1,4) + P(2,1)*P(3,2)*P(5,3)*Metric(1,4) - P(2,1)*P(3,2)*P(5,4)*Metric(1,4) + P(2,5)*P(3,2)*P(5,4)*Metric(1,4) + 2*P(2,5)*P(3,2)*P(4,1)*Metric(1,5) - P(2,5)*P(3,4)*P(4,1)*Metric(1,5) - P(2,3)*P(3,5)*P(4,1)*Metric(1,5) + P(2,4)*P(3,5)*P(4,1)*Metric(1,5) - 2*P(2,5)*P(3,1)*P(4,2)*Metric(1,5) + P(2,1)*P(3,4)*P(4,2)*Metric(1,5) + P(2,5)*P(3,4)*P(4,2)*Metric(1,5) - 2*P(2,1)*P(3,5)*P(4,2)*Metric(1,5) + P(2,5)*P(3,1)*P(4,3)*Metric(1,5) - P(2,1)*P(3,2)*P(4,3)*Metric(1,5) - P(2,5)*P(3,2)*P(4,3)*Metric(1,5) + P(2,1)*P(3,5)*P(4,3)*Metric(1,5) - P(2,3)*P(3,1)*P(4,5)*Metric(1,5) + P(2,4)*P(3,1)*P(4,5)*Metric(1,5) + 2*P(2,1)*P(3,2)*P(4,5)*Metric(1,5) - P(2,1)*P(3,4)*P(4,5)*Metric(1,5) - P(1,2)*P(4,3)*P(5,1)*Metric(2,3) + 2*P(1,2)*P(4,5)*P(5,1)*Metric(2,3) - P(1,3)*P(4,5)*P(5,1)*Metric(2,3) + 2*P(1,5)*P(4,1)*P(5,2)*Metric(2,3) - P(1,5)*P(4,3)*P(5,2)*Metric(2,3) + P(1,3)*P(4,5)*P(5,2)*Metric(2,3) - P(1,4)*P(4,5)*P(5,2)*Metric(2,3) + P(1,2)*P(4,1)*P(5,3)*Metric(2,3) - P(1,5)*P(4,1)*P(5,3)*Metric(2,3) - P(1,2)*P(4,1)*P(5,4)*Metric(2,3) + 2*P(-1,2)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) - 2*P(-1,1)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,2)*P(5,4)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) - 2*P(-1,2)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,3)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,5)*Metric(2,3) + P(-1,2)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(-1,1)*P(-1,2)*P(4,5)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) + P(1,2)*P(3,4)*P(5,1)*Metric(2,4) - 2*P(1,2)*P(3,5)*P(5,1)*Metric(2,4) + P(1,4)*P(3,5)*P(5,1)*Metric(2,4) - 2*P(1,5)*P(3,1)*P(5,2)*Metric(2,4) + P(1,5)*P(3,4)*P(5,2)*Metric(2,4) + P(1,3)*P(3,5)*P(5,2)*Metric(2,4) - P(1,4)*P(3,5)*P(5,2)*Metric(2,4) + P(1,2)*P(3,1)*P(5,3)*Metric(2,4) - P(1,2)*P(3,1)*P(5,4)*Metric(2,4) + P(1,5)*P(3,1)*P(5,4)*Metric(2,4) - 2*P(-1,2)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) + 2*P(-1,1)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*P(5,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,2)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) + 2*P(-1,2)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,2)*P(3,4)*Metric(1,5)*Metric(2,4) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) + 2*P(-1,1)*P(-1,2)*P(3,5)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - 2*P(1,5)*P(3,2)*P(4,1)*Metric(2,5) + P(1,2)*P(3,4)*P(4,1)*Metric(2,5) + P(1,5)*P(3,4)*P(4,1)*Metric(2,5) - 2*P(1,2)*P(3,5)*P(4,1)*Metric(2,5) + 2*P(1,5)*P(3,1)*P(4,2)*Metric(2,5) - P(1,5)*P(3,4)*P(4,2)*Metric(2,5) - P(1,3)*P(3,5)*P(4,2)*Metric(2,5) + P(1,4)*P(3,5)*P(4,2)*Metric(2,5) - P(1,2)*P(3,1)*P(4,3)*Metric(2,5) - P(1,5)*P(3,1)*P(4,3)*Metric(2,5) + P(1,5)*P(3,2)*P(4,3)*Metric(2,5) + P(1,2)*P(3,5)*P(4,3)*Metric(2,5) + 2*P(1,2)*P(3,1)*P(4,5)*Metric(2,5) - P(1,3)*P(3,2)*P(4,5)*Metric(2,5) + P(1,4)*P(3,2)*P(4,5)*Metric(2,5) - P(1,2)*P(3,4)*P(4,5)*Metric(2,5) - 2*P(-1,1)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,3)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - 2*P(-1,1)*P(-1,2)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) + 2*P(-1,1)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) - P(-1,1)*P(-1,2)*P(3,4)*Metric(1,4)*Metric(2,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + 2*P(-1,1)*P(-1,2)*P(3,5)*Metric(1,4)*Metric(2,5) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,2)*P(2,3)*P(5,1)*Metric(3,4) - P(1,2)*P(2,4)*P(5,1)*Metric(3,4) + P(1,3)*P(2,5)*P(5,1)*Metric(3,4) - P(1,4)*P(2,5)*P(5,1)*Metric(3,4) + P(1,3)*P(2,1)*P(5,2)*Metric(3,4) - P(1,4)*P(2,1)*P(5,2)*Metric(3,4) + P(1,5)*P(2,3)*P(5,2)*Metric(3,4) - P(1,5)*P(2,4)*P(5,2)*Metric(3,4) + P(1,5)*P(2,1)*P(5,3)*Metric(3,4) + P(1,2)*P(2,5)*P(5,3)*Metric(3,4) - P(1,5)*P(2,1)*P(5,4)*Metric(3,4) - P(1,2)*P(2,5)*P(5,4)*Metric(3,4) - P(-1,2)*P(-1,3)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,3)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,2)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) - P(-1,2)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(1,3)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,2)*P(1,4)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) - P(1,2)*P(2,3)*P(4,1)*Metric(3,5) + P(1,5)*P(2,3)*P(4,1)*Metric(3,5) - P(1,5)*P(2,4)*P(4,1)*Metric(3,5) + 2*P(1,2)*P(2,5)*P(4,1)*Metric(3,5) - P(1,3)*P(2,1)*P(4,2)*Metric(3,5) + 2*P(1,5)*P(2,1)*P(4,2)*Metric(3,5) + P(1,3)*P(2,5)*P(4,2)*Metric(3,5) - P(1,4)*P(2,5)*P(4,2)*Metric(3,5) - P(1,5)*P(2,1)*P(4,3)*Metric(3,5) - P(1,2)*P(2,5)*P(4,3)*Metric(3,5) + P(-1,2)*P(-1,3)*P(4,1)*Metric(1,2)*Metric(3,5) - 2*P(-1,2)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,3)*P(4,2)*Metric(1,2)*Metric(3,5) - 2*P(-1,1)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,3)*P(2,1)*Metric(1,4)*Metric(3,5) + 2*P(-1,2)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,2)*P(2,3)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - P(-1,2)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - 2*P(-1,1)*P(-1,2)*P(2,5)*Metric(1,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,3)*P(1,2)*Metric(2,4)*Metric(3,5) + 2*P(-1,1)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,2)*P(1,3)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) - 2*P(-1,1)*P(-1,2)*P(1,5)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) + P(1,5)*P(2,3)*P(3,1)*Metric(4,5) + P(1,2)*P(2,4)*P(3,1)*Metric(4,5) - P(1,5)*P(2,4)*P(3,1)*Metric(4,5) - 2*P(1,2)*P(2,5)*P(3,1)*Metric(4,5) + P(1,4)*P(2,1)*P(3,2)*Metric(4,5) - 2*P(1,5)*P(2,1)*P(3,2)*Metric(4,5) + P(1,3)*P(2,5)*P(3,2)*Metric(4,5) - P(1,4)*P(2,5)*P(3,2)*Metric(4,5) + P(1,5)*P(2,1)*P(3,4)*Metric(4,5) + P(1,2)*P(2,5)*P(3,4)*Metric(4,5) - P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5) + 2*P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5) + 2*P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5) - 2*P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,2)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) + 2*P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5) - 2*P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV57 = Lorentz(name = 'VVVVV57',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,5)*P(4,2)*P(5,1)*Metric(1,2) - P(3,5)*P(4,3)*P(5,1)*Metric(1,2) - P(3,2)*P(4,5)*P(5,1)*Metric(1,2) + P(3,4)*P(4,5)*P(5,1)*Metric(1,2) + P(3,5)*P(4,1)*P(5,2)*Metric(1,2) - P(3,5)*P(4,3)*P(5,2)*Metric(1,2) - P(3,1)*P(4,5)*P(5,2)*Metric(1,2) + P(3,4)*P(4,5)*P(5,2)*Metric(1,2) + 2*P(2,5)*P(4,2)*P(5,1)*Metric(1,3) - P(2,5)*P(4,3)*P(5,1)*Metric(1,3) + P(2,3)*P(4,5)*P(5,1)*Metric(1,3) - P(2,4)*P(4,5)*P(5,1)*Metric(1,3) + P(2,1)*P(4,5)*P(5,2)*Metric(1,3) - P(2,3)*P(4,5)*P(5,2)*Metric(1,3) - P(2,5)*P(4,2)*P(5,3)*Metric(1,3) - 2*P(2,5)*P(3,2)*P(5,1)*Metric(1,4) + P(2,5)*P(3,4)*P(5,1)*Metric(1,4) + P(2,3)*P(3,5)*P(5,1)*Metric(1,4) - P(2,4)*P(3,5)*P(5,1)*Metric(1,4) - P(2,1)*P(3,5)*P(5,2)*Metric(1,4) + P(2,4)*P(3,5)*P(5,2)*Metric(1,4) + P(2,5)*P(3,2)*P(5,4)*Metric(1,4) + 2*P(2,5)*P(3,2)*P(4,1)*Metric(1,5) - P(2,5)*P(3,4)*P(4,1)*Metric(1,5) - P(2,3)*P(3,5)*P(4,1)*Metric(1,5) + P(2,4)*P(3,5)*P(4,1)*Metric(1,5) - 2*P(2,5)*P(3,1)*P(4,2)*Metric(1,5) + P(2,5)*P(3,4)*P(4,2)*Metric(1,5) - P(2,1)*P(3,5)*P(4,2)*Metric(1,5) + P(2,5)*P(3,1)*P(4,3)*Metric(1,5) - P(2,5)*P(3,2)*P(4,3)*Metric(1,5) + P(2,1)*P(3,5)*P(4,3)*Metric(1,5) - P(2,3)*P(3,1)*P(4,5)*Metric(1,5) + P(2,4)*P(3,1)*P(4,5)*Metric(1,5) + P(2,1)*P(3,2)*P(4,5)*Metric(1,5) - P(2,1)*P(3,4)*P(4,5)*Metric(1,5) + P(1,2)*P(4,5)*P(5,1)*Metric(2,3) - P(1,3)*P(4,5)*P(5,1)*Metric(2,3) + 2*P(1,5)*P(4,1)*P(5,2)*Metric(2,3) - P(1,5)*P(4,3)*P(5,2)*Metric(2,3) + P(1,3)*P(4,5)*P(5,2)*Metric(2,3) - P(1,4)*P(4,5)*P(5,2)*Metric(2,3) - P(1,5)*P(4,1)*P(5,3)*Metric(2,3) + 2*P(-1,2)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) - 2*P(-1,1)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) - 2*P(-1,2)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,3)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,2)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) - P(1,2)*P(3,5)*P(5,1)*Metric(2,4) + P(1,4)*P(3,5)*P(5,1)*Metric(2,4) - 2*P(1,5)*P(3,1)*P(5,2)*Metric(2,4) + P(1,5)*P(3,4)*P(5,2)*Metric(2,4) + P(1,3)*P(3,5)*P(5,2)*Metric(2,4) - P(1,4)*P(3,5)*P(5,2)*Metric(2,4) + P(1,5)*P(3,1)*P(5,4)*Metric(2,4) - 2*P(-1,2)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) + 2*P(-1,1)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) + 2*P(-1,2)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - 2*P(1,5)*P(3,2)*P(4,1)*Metric(2,5) + P(1,5)*P(3,4)*P(4,1)*Metric(2,5) - P(1,2)*P(3,5)*P(4,1)*Metric(2,5) + 2*P(1,5)*P(3,1)*P(4,2)*Metric(2,5) - P(1,5)*P(3,4)*P(4,2)*Metric(2,5) - P(1,3)*P(3,5)*P(4,2)*Metric(2,5) + P(1,4)*P(3,5)*P(4,2)*Metric(2,5) - P(1,5)*P(3,1)*P(4,3)*Metric(2,5) + P(1,5)*P(3,2)*P(4,3)*Metric(2,5) + P(1,2)*P(3,5)*P(4,3)*Metric(2,5) + P(1,2)*P(3,1)*P(4,5)*Metric(2,5) - P(1,3)*P(3,2)*P(4,5)*Metric(2,5) + P(1,4)*P(3,2)*P(4,5)*Metric(2,5) - P(1,2)*P(3,4)*P(4,5)*Metric(2,5) - 2*P(-1,1)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,3)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) + 2*P(-1,1)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,4)*Metric(2,5) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,3)*P(2,5)*P(5,1)*Metric(3,4) - P(1,4)*P(2,5)*P(5,1)*Metric(3,4) + P(1,5)*P(2,3)*P(5,2)*Metric(3,4) - P(1,5)*P(2,4)*P(5,2)*Metric(3,4) + P(1,5)*P(2,1)*P(5,3)*Metric(3,4) + P(1,2)*P(2,5)*P(5,3)*Metric(3,4) - P(1,5)*P(2,1)*P(5,4)*Metric(3,4) - P(1,2)*P(2,5)*P(5,4)*Metric(3,4) + P(-1,3)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,2)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) - P(-1,2)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) - P(-1,3)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + P(1,5)*P(2,3)*P(4,1)*Metric(3,5) - P(1,5)*P(2,4)*P(4,1)*Metric(3,5) + P(1,2)*P(2,5)*P(4,1)*Metric(3,5) + P(1,5)*P(2,1)*P(4,2)*Metric(3,5) + P(1,3)*P(2,5)*P(4,2)*Metric(3,5) - P(1,4)*P(2,5)*P(4,2)*Metric(3,5) - P(1,5)*P(2,1)*P(4,3)*Metric(3,5) - P(1,2)*P(2,5)*P(4,3)*Metric(3,5) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - P(-1,2)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(2,5)*Metric(1,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) + P(1,5)*P(2,3)*P(3,1)*Metric(4,5) - P(1,5)*P(2,4)*P(3,1)*Metric(4,5) - P(1,2)*P(2,5)*P(3,1)*Metric(4,5) - P(1,5)*P(2,1)*P(3,2)*Metric(4,5) + P(1,3)*P(2,5)*P(3,2)*Metric(4,5) - P(1,4)*P(2,5)*P(3,2)*Metric(4,5) + P(1,5)*P(2,1)*P(3,4)*Metric(4,5) + P(1,2)*P(2,5)*P(3,4)*Metric(4,5) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,2)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV58 = Lorentz(name = 'VVVVV58',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(2,5)*P(4,3)*P(5,1)*Metric(1,3) - P(2,3)*P(4,5)*P(5,1)*Metric(1,3) - P(2,3)*P(4,5)*P(5,2)*Metric(1,3) + P(2,4)*P(4,1)*P(5,3)*Metric(1,3) + P(2,4)*P(4,5)*P(5,3)*Metric(1,3) - P(2,3)*P(4,1)*P(5,4)*Metric(1,3) - P(2,3)*P(4,2)*P(5,4)*Metric(1,3) + P(2,5)*P(4,3)*P(5,4)*Metric(1,3) + P(2,5)*P(3,4)*P(5,1)*Metric(1,4) - P(2,4)*P(3,5)*P(5,1)*Metric(1,4) - P(2,4)*P(3,5)*P(5,2)*Metric(1,4) - P(2,4)*P(3,1)*P(5,3)*Metric(1,4) - P(2,4)*P(3,2)*P(5,3)*Metric(1,4) + P(2,5)*P(3,4)*P(5,3)*Metric(1,4) + P(2,3)*P(3,1)*P(5,4)*Metric(1,4) + P(2,3)*P(3,5)*P(5,4)*Metric(1,4) - P(2,5)*P(3,4)*P(4,1)*Metric(1,5) + P(2,4)*P(3,5)*P(4,1)*Metric(1,5) - P(2,5)*P(3,4)*P(4,2)*Metric(1,5) - P(2,5)*P(3,1)*P(4,3)*Metric(1,5) - P(2,5)*P(3,2)*P(4,3)*Metric(1,5) + P(2,4)*P(3,5)*P(4,3)*Metric(1,5) + P(2,3)*P(3,1)*P(4,5)*Metric(1,5) + P(2,3)*P(3,4)*P(4,5)*Metric(1,5) + P(1,3)*P(4,5)*P(5,1)*Metric(2,3) - P(1,5)*P(4,3)*P(5,2)*Metric(2,3) + P(1,3)*P(4,5)*P(5,2)*Metric(2,3) - P(1,4)*P(4,2)*P(5,3)*Metric(2,3) - P(1,4)*P(4,5)*P(5,3)*Metric(2,3) + P(1,3)*P(4,1)*P(5,4)*Metric(2,3) + P(1,3)*P(4,2)*P(5,4)*Metric(2,3) - P(1,5)*P(4,3)*P(5,4)*Metric(2,3) + P(-1,2)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,3)*P(5,4)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) + P(-1,4)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) + P(1,4)*P(3,5)*P(5,1)*Metric(2,4) - P(1,5)*P(3,4)*P(5,2)*Metric(2,4) + P(1,4)*P(3,5)*P(5,2)*Metric(2,4) + P(1,4)*P(3,1)*P(5,3)*Metric(2,4) + P(1,4)*P(3,2)*P(5,3)*Metric(2,4) - P(1,5)*P(3,4)*P(5,3)*Metric(2,4) - P(1,3)*P(3,2)*P(5,4)*Metric(2,4) - P(1,3)*P(3,5)*P(5,4)*Metric(2,4) - P(-1,1)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,4)*P(-1,5)*P(5,3)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) + P(-1,3)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - P(-1,3)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) + P(1,5)*P(3,4)*P(4,1)*Metric(2,5) + P(1,5)*P(3,4)*P(4,2)*Metric(2,5) - P(1,4)*P(3,5)*P(4,2)*Metric(2,5) + P(1,5)*P(3,1)*P(4,3)*Metric(2,5) + P(1,5)*P(3,2)*P(4,3)*Metric(2,5) - P(1,4)*P(3,5)*P(4,3)*Metric(2,5) - P(1,3)*P(3,2)*P(4,5)*Metric(2,5) - P(1,3)*P(3,4)*P(4,5)*Metric(2,5) - P(-1,1)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,4)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,3)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) - P(-1,3)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(-1,2)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(-1,3)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) - P(1,3)*P(2,5)*P(5,1)*Metric(3,4) - P(1,4)*P(2,5)*P(5,1)*Metric(3,4) + P(1,5)*P(2,3)*P(5,2)*Metric(3,4) + P(1,5)*P(2,4)*P(5,2)*Metric(3,4) + P(1,5)*P(2,4)*P(5,3)*Metric(3,4) - P(1,4)*P(2,5)*P(5,3)*Metric(3,4) + P(1,5)*P(2,3)*P(5,4)*Metric(3,4) - P(1,3)*P(2,5)*P(5,4)*Metric(3,4) - P(-1,2)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,4)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,2)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) - P(-1,3)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) + P(-1,3)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) - P(1,3)*P(2,4)*P(4,1)*Metric(3,5) - P(1,5)*P(2,4)*P(4,1)*Metric(3,5) + P(1,4)*P(2,3)*P(4,2)*Metric(3,5) + P(1,4)*P(2,5)*P(4,2)*Metric(3,5) - P(1,5)*P(2,4)*P(4,3)*Metric(3,5) + P(1,4)*P(2,5)*P(4,3)*Metric(3,5) + P(1,4)*P(2,3)*P(4,5)*Metric(3,5) - P(1,3)*P(2,4)*P(4,5)*Metric(3,5) - P(-1,2)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5) - P(-1,4)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,3)*P(2,4)*Metric(1,4)*Metric(3,5) + P(-1,2)*P(-1,3)*P(2,4)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) + P(-1,2)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - P(-1,2)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(1,3)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,3)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,3)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) + P(-1,3)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) - P(1,4)*P(2,3)*P(3,1)*Metric(4,5) - P(1,5)*P(2,3)*P(3,1)*Metric(4,5) + P(1,3)*P(2,4)*P(3,2)*Metric(4,5) + P(1,3)*P(2,5)*P(3,2)*Metric(4,5) - P(1,5)*P(2,3)*P(3,4)*Metric(4,5) + P(1,3)*P(2,5)*P(3,4)*Metric(4,5) - P(1,4)*P(2,3)*P(3,5)*Metric(4,5) + P(1,3)*P(2,4)*P(3,5)*Metric(4,5) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,2)*P(-1,4)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,2)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,4)*P(1,3)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,3)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5) + P(-1,3)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV59 = Lorentz(name = 'VVVVV59',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,4)*P(4,5)*P(5,1)*Metric(1,2) - P(3,4)*P(4,5)*P(5,2)*Metric(1,2) + P(3,5)*P(4,1)*P(5,4)*Metric(1,2) - P(3,5)*P(4,2)*P(5,4)*Metric(1,2) - P(2,4)*P(4,5)*P(5,1)*Metric(1,3) + P(2,4)*P(4,5)*P(5,3)*Metric(1,3) - P(2,5)*P(4,1)*P(5,4)*Metric(1,3) + P(2,5)*P(4,3)*P(5,4)*Metric(1,3) + P(2,5)*P(3,1)*P(5,4)*Metric(1,4) - P(2,5)*P(3,2)*P(5,4)*Metric(1,4) - P(2,1)*P(3,5)*P(5,4)*Metric(1,4) + P(2,3)*P(3,5)*P(5,4)*Metric(1,4) + P(2,4)*P(3,1)*P(4,5)*Metric(1,5) - P(2,4)*P(3,2)*P(4,5)*Metric(1,5) - P(2,1)*P(3,4)*P(4,5)*Metric(1,5) + P(2,3)*P(3,4)*P(4,5)*Metric(1,5) + P(1,4)*P(4,5)*P(5,2)*Metric(2,3) - P(1,4)*P(4,5)*P(5,3)*Metric(2,3) + P(1,5)*P(4,2)*P(5,4)*Metric(2,3) - P(1,5)*P(4,3)*P(5,4)*Metric(2,3) - P(-1,4)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) - P(-1,4)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,4)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) + P(-1,2)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) + P(1,5)*P(3,1)*P(5,4)*Metric(2,4) - P(1,5)*P(3,2)*P(5,4)*Metric(2,4) + P(1,2)*P(3,5)*P(5,4)*Metric(2,4) - P(1,3)*P(3,5)*P(5,4)*Metric(2,4) + P(-1,4)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) - P(-1,4)*P(-1,5)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) + P(-1,4)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) + P(1,4)*P(3,1)*P(4,5)*Metric(2,5) - P(1,4)*P(3,2)*P(4,5)*Metric(2,5) + P(1,2)*P(3,4)*P(4,5)*Metric(2,5) - P(1,3)*P(3,4)*P(4,5)*Metric(2,5) + P(-1,4)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,4)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,3)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,4)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) - P(1,5)*P(2,1)*P(5,4)*Metric(3,4) + P(1,5)*P(2,3)*P(5,4)*Metric(3,4) + P(1,2)*P(2,5)*P(5,4)*Metric(3,4) - P(1,3)*P(2,5)*P(5,4)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,4)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,4)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,4)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*P(2,1)*P(4,5)*Metric(3,5) + P(1,4)*P(2,3)*P(4,5)*Metric(3,5) + P(1,2)*P(2,4)*P(4,5)*Metric(3,5) - P(1,3)*P(2,4)*P(4,5)*Metric(3,5) - P(-1,4)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,4)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,4)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) - P(-1,4)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(1,3)*Metric(2,4)*Metric(3,5) - P(1,5)*P(2,4)*P(3,1)*Metric(4,5) - P(1,4)*P(2,5)*P(3,1)*Metric(4,5) + P(1,5)*P(2,4)*P(3,2)*Metric(4,5) + P(1,4)*P(2,5)*P(3,2)*Metric(4,5) + P(1,5)*P(2,1)*P(3,4)*Metric(4,5) - P(1,5)*P(2,3)*P(3,4)*Metric(4,5) - P(1,2)*P(2,5)*P(3,4)*Metric(4,5) + P(1,3)*P(2,5)*P(3,4)*Metric(4,5) + P(1,4)*P(2,1)*P(3,5)*Metric(4,5) - P(1,4)*P(2,3)*P(3,5)*Metric(4,5) - P(1,2)*P(2,4)*P(3,5)*Metric(4,5) + P(1,3)*P(2,4)*P(3,5)*Metric(4,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,3)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5) + P(-1,3)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV60 = Lorentz(name = 'VVVVV60',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,5)*P(4,2)*P(5,1)*Metric(1,2) - P(3,5)*P(4,3)*P(5,1)*Metric(1,2) - P(3,2)*P(4,5)*P(5,1)*Metric(1,2) + 2*P(3,4)*P(4,5)*P(5,1)*Metric(1,2) + P(3,4)*P(4,1)*P(5,2)*Metric(1,2) - P(3,4)*P(4,5)*P(5,2)*Metric(1,2) - P(3,4)*P(4,1)*P(5,3)*Metric(1,2) - P(3,2)*P(4,1)*P(5,4)*Metric(1,2) + 2*P(3,5)*P(4,1)*P(5,4)*Metric(1,2) - P(3,5)*P(4,2)*P(5,4)*Metric(1,2) + P(2,5)*P(4,2)*P(5,1)*Metric(1,3) - P(2,5)*P(4,3)*P(5,1)*Metric(1,3) + P(2,3)*P(4,5)*P(5,1)*Metric(1,3) - 2*P(2,4)*P(4,5)*P(5,1)*Metric(1,3) + P(2,4)*P(4,1)*P(5,2)*Metric(1,3) - P(2,4)*P(4,1)*P(5,3)*Metric(1,3) + P(2,4)*P(4,5)*P(5,3)*Metric(1,3) + P(2,3)*P(4,1)*P(5,4)*Metric(1,3) - 2*P(2,5)*P(4,1)*P(5,4)*Metric(1,3) + P(2,5)*P(4,3)*P(5,4)*Metric(1,3) + P(2,4)*P(3,2)*P(5,1)*Metric(1,4) - P(2,5)*P(3,2)*P(5,1)*Metric(1,4) - P(2,3)*P(3,4)*P(5,1)*Metric(1,4) + 2*P(2,5)*P(3,4)*P(5,1)*Metric(1,4) + P(2,3)*P(3,5)*P(5,1)*Metric(1,4) - 2*P(2,4)*P(3,5)*P(5,1)*Metric(1,4) - P(2,4)*P(3,1)*P(5,2)*Metric(1,4) - P(2,1)*P(3,4)*P(5,2)*Metric(1,4) + P(2,4)*P(3,1)*P(5,3)*Metric(1,4) + P(2,1)*P(3,4)*P(5,3)*Metric(1,4) - P(2,3)*P(3,1)*P(5,4)*Metric(1,4) + 2*P(2,5)*P(3,1)*P(5,4)*Metric(1,4) + P(2,1)*P(3,2)*P(5,4)*Metric(1,4) - P(2,5)*P(3,2)*P(5,4)*Metric(1,4) - 2*P(2,1)*P(3,5)*P(5,4)*Metric(1,4) + P(2,3)*P(3,5)*P(5,4)*Metric(1,4) - P(2,4)*P(3,2)*P(4,1)*Metric(1,5) + P(2,5)*P(3,2)*P(4,1)*Metric(1,5) + P(2,3)*P(3,4)*P(4,1)*Metric(1,5) - 2*P(2,5)*P(3,4)*P(4,1)*Metric(1,5) - P(2,3)*P(3,5)*P(4,1)*Metric(1,5) + 2*P(2,4)*P(3,5)*P(4,1)*Metric(1,5) - P(2,5)*P(3,1)*P(4,2)*Metric(1,5) - P(2,1)*P(3,5)*P(4,2)*Metric(1,5) + P(2,5)*P(3,1)*P(4,3)*Metric(1,5) + P(2,1)*P(3,5)*P(4,3)*Metric(1,5) - P(2,3)*P(3,1)*P(4,5)*Metric(1,5) + 2*P(2,4)*P(3,1)*P(4,5)*Metric(1,5) + P(2,1)*P(3,2)*P(4,5)*Metric(1,5) - P(2,4)*P(3,2)*P(4,5)*Metric(1,5) - 2*P(2,1)*P(3,4)*P(4,5)*Metric(1,5) + P(2,3)*P(3,4)*P(4,5)*Metric(1,5) + P(1,4)*P(4,2)*P(5,1)*Metric(2,3) - P(1,4)*P(4,3)*P(5,1)*Metric(2,3) + P(1,2)*P(4,5)*P(5,1)*Metric(2,3) - P(1,3)*P(4,5)*P(5,1)*Metric(2,3) + P(1,5)*P(4,1)*P(5,2)*Metric(2,3) + P(1,4)*P(4,5)*P(5,2)*Metric(2,3) - P(1,5)*P(4,1)*P(5,3)*Metric(2,3) - P(1,4)*P(4,5)*P(5,3)*Metric(2,3) + P(1,2)*P(4,1)*P(5,4)*Metric(2,3) - P(1,3)*P(4,1)*P(5,4)*Metric(2,3) + P(1,5)*P(4,2)*P(5,4)*Metric(2,3) - P(1,5)*P(4,3)*P(5,4)*Metric(2,3) - P(-1,2)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,4)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,3)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,4)*P(4,2)*Metric(1,5)*Metric(2,3) - P(-1,4)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,4)*P(4,3)*Metric(1,5)*Metric(2,3) + P(-1,4)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) + P(-1,2)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) - P(1,4)*P(3,2)*P(5,1)*Metric(2,4) - P(1,2)*P(3,5)*P(5,1)*Metric(2,4) + 2*P(1,4)*P(3,5)*P(5,1)*Metric(2,4) + P(1,4)*P(3,1)*P(5,2)*Metric(2,4) - P(1,5)*P(3,1)*P(5,2)*Metric(2,4) - P(1,4)*P(3,1)*P(5,3)*Metric(2,4) + 2*P(1,5)*P(3,1)*P(5,4)*Metric(2,4) - P(1,5)*P(3,2)*P(5,4)*Metric(2,4) + P(1,2)*P(3,5)*P(5,4)*Metric(2,4) - P(1,3)*P(3,5)*P(5,4)*Metric(2,4) - P(-1,2)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) + 2*P(-1,4)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,4)*P(-1,5)*P(5,3)*Metric(1,3)*Metric(2,4) - 2*P(-1,1)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) - 2*P(-1,4)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,4)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,5)*Metric(2,4) - 2*P(-1,1)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - P(1,5)*P(3,2)*P(4,1)*Metric(2,5) - P(1,2)*P(3,4)*P(4,1)*Metric(2,5) + 2*P(1,5)*P(3,4)*P(4,1)*Metric(2,5) - P(1,4)*P(3,1)*P(4,2)*Metric(2,5) + P(1,5)*P(3,1)*P(4,2)*Metric(2,5) - P(1,5)*P(3,1)*P(4,3)*Metric(2,5) + 2*P(1,4)*P(3,1)*P(4,5)*Metric(2,5) - P(1,4)*P(3,2)*P(4,5)*Metric(2,5) + P(1,2)*P(3,4)*P(4,5)*Metric(2,5) - P(1,3)*P(3,4)*P(4,5)*Metric(2,5) - P(-1,2)*P(-1,4)*P(4,1)*Metric(1,3)*Metric(2,5) + 2*P(-1,4)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,4)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,4)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - 2*P(-1,1)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,3)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,4)*Metric(2,5) - 2*P(-1,4)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,4)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,2)*P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(-1,1)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(1,4)*P(2,3)*P(5,1)*Metric(3,4) + P(1,3)*P(2,5)*P(5,1)*Metric(3,4) - 2*P(1,4)*P(2,5)*P(5,1)*Metric(3,4) + P(1,4)*P(2,1)*P(5,2)*Metric(3,4) - P(1,4)*P(2,1)*P(5,3)*Metric(3,4) + P(1,5)*P(2,1)*P(5,3)*Metric(3,4) - 2*P(1,5)*P(2,1)*P(5,4)*Metric(3,4) + P(1,5)*P(2,3)*P(5,4)*Metric(3,4) + P(1,2)*P(2,5)*P(5,4)*Metric(3,4) - P(1,3)*P(2,5)*P(5,4)*Metric(3,4) + P(-1,3)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) - 2*P(-1,4)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,4)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*P(5,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) + 2*P(-1,1)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) + 2*P(-1,4)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,4)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4) + 2*P(-1,1)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,4)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,5)*Metric(3,4) + 2*P(-1,1)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4) - 2*P(-1,1)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + P(1,5)*P(2,3)*P(4,1)*Metric(3,5) + P(1,3)*P(2,4)*P(4,1)*Metric(3,5) - 2*P(1,5)*P(2,4)*P(4,1)*Metric(3,5) + P(1,5)*P(2,1)*P(4,2)*Metric(3,5) + P(1,4)*P(2,1)*P(4,3)*Metric(3,5) - P(1,5)*P(2,1)*P(4,3)*Metric(3,5) - 2*P(1,4)*P(2,1)*P(4,5)*Metric(3,5) + P(1,4)*P(2,3)*P(4,5)*Metric(3,5) + P(1,2)*P(2,4)*P(4,5)*Metric(3,5) - P(1,3)*P(2,4)*P(4,5)*Metric(3,5) + P(-1,3)*P(-1,4)*P(4,1)*Metric(1,2)*Metric(3,5) - 2*P(-1,4)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,4)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,4)*P(4,3)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) + 2*P(-1,1)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,4)*Metric(3,5) + 2*P(-1,4)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) - P(-1,4)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,3)*P(2,4)*Metric(1,4)*Metric(3,5) + 2*P(-1,1)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,4)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(1,3)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,3)*P(1,4)*Metric(2,4)*Metric(3,5) - 2*P(-1,1)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(-1,1)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) + P(1,4)*P(2,3)*P(3,1)*Metric(4,5) + P(1,5)*P(2,3)*P(3,1)*Metric(4,5) - 2*P(1,5)*P(2,4)*P(3,1)*Metric(4,5) - 2*P(1,4)*P(2,5)*P(3,1)*Metric(4,5) - P(1,4)*P(2,1)*P(3,2)*Metric(4,5) - P(1,5)*P(2,1)*P(3,2)*Metric(4,5) + P(1,5)*P(2,4)*P(3,2)*Metric(4,5) + P(1,4)*P(2,5)*P(3,2)*Metric(4,5) + 2*P(1,5)*P(2,1)*P(3,4)*Metric(4,5) - P(1,5)*P(2,3)*P(3,4)*Metric(4,5) - P(1,2)*P(2,5)*P(3,4)*Metric(4,5) + P(1,3)*P(2,5)*P(3,4)*Metric(4,5) + 2*P(1,4)*P(2,1)*P(3,5)*Metric(4,5) - P(1,4)*P(2,3)*P(3,5)*Metric(4,5) - P(1,2)*P(2,4)*P(3,5)*Metric(4,5) + P(1,3)*P(2,4)*P(3,5)*Metric(4,5) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) - 2*P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) - 2*P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) + 2*P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) + 2*P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,3)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5) + P(-1,3)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV61 = Lorentz(name = 'VVVVV61',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,4)*P(4,2)*P(5,1)*Metric(1,2) + P(3,5)*P(4,3)*P(5,1)*Metric(1,2) + P(3,5)*P(4,1)*P(5,2)*Metric(1,2) - 2*P(3,5)*P(4,3)*P(5,2)*Metric(1,2) - P(3,1)*P(4,5)*P(5,2)*Metric(1,2) + P(3,4)*P(4,5)*P(5,2)*Metric(1,2) + P(3,4)*P(4,1)*P(5,3)*Metric(1,2) - 2*P(3,4)*P(4,2)*P(5,3)*Metric(1,2) + P(3,1)*P(4,5)*P(5,3)*Metric(1,2) - P(3,2)*P(4,5)*P(5,3)*Metric(1,2) - P(3,1)*P(4,2)*P(5,4)*Metric(1,2) + P(3,5)*P(4,2)*P(5,4)*Metric(1,2) + P(3,1)*P(4,3)*P(5,4)*Metric(1,2) - P(3,2)*P(4,3)*P(5,4)*Metric(1,2) + P(2,5)*P(4,2)*P(5,1)*Metric(1,3) + P(2,4)*P(4,3)*P(5,1)*Metric(1,3) + P(2,4)*P(4,1)*P(5,2)*Metric(1,3) - 2*P(2,4)*P(4,3)*P(5,2)*Metric(1,3) + P(2,1)*P(4,5)*P(5,2)*Metric(1,3) - P(2,3)*P(4,5)*P(5,2)*Metric(1,3) + P(2,5)*P(4,1)*P(5,3)*Metric(1,3) - 2*P(2,5)*P(4,2)*P(5,3)*Metric(1,3) - P(2,1)*P(4,5)*P(5,3)*Metric(1,3) + P(2,4)*P(4,5)*P(5,3)*Metric(1,3) + P(2,1)*P(4,2)*P(5,4)*Metric(1,3) - P(2,3)*P(4,2)*P(5,4)*Metric(1,3) - P(2,1)*P(4,3)*P(5,4)*Metric(1,3) + P(2,5)*P(4,3)*P(5,4)*Metric(1,3) + P(2,4)*P(3,2)*P(5,1)*Metric(1,4) - P(2,5)*P(3,2)*P(5,1)*Metric(1,4) + P(2,3)*P(3,4)*P(5,1)*Metric(1,4) - P(2,3)*P(3,5)*P(5,1)*Metric(1,4) - P(2,4)*P(3,1)*P(5,2)*Metric(1,4) - P(2,3)*P(3,4)*P(5,2)*Metric(1,4) - P(2,1)*P(3,5)*P(5,2)*Metric(1,4) + 2*P(2,4)*P(3,5)*P(5,2)*Metric(1,4) - P(2,5)*P(3,1)*P(5,3)*Metric(1,4) - P(2,4)*P(3,2)*P(5,3)*Metric(1,4) - P(2,1)*P(3,4)*P(5,3)*Metric(1,4) + 2*P(2,5)*P(3,4)*P(5,3)*Metric(1,4) + P(2,5)*P(3,2)*P(5,4)*Metric(1,4) + P(2,3)*P(3,5)*P(5,4)*Metric(1,4) - P(2,4)*P(3,2)*P(4,1)*Metric(1,5) + P(2,5)*P(3,2)*P(4,1)*Metric(1,5) - P(2,3)*P(3,4)*P(4,1)*Metric(1,5) + P(2,3)*P(3,5)*P(4,1)*Metric(1,5) - P(2,5)*P(3,1)*P(4,2)*Metric(1,5) - P(2,1)*P(3,4)*P(4,2)*Metric(1,5) + 2*P(2,5)*P(3,4)*P(4,2)*Metric(1,5) - P(2,3)*P(3,5)*P(4,2)*Metric(1,5) - P(2,4)*P(3,1)*P(4,3)*Metric(1,5) - P(2,5)*P(3,2)*P(4,3)*Metric(1,5) - P(2,1)*P(3,5)*P(4,3)*Metric(1,5) + 2*P(2,4)*P(3,5)*P(4,3)*Metric(1,5) + P(2,4)*P(3,2)*P(4,5)*Metric(1,5) + P(2,3)*P(3,4)*P(4,5)*Metric(1,5) + P(1,4)*P(4,2)*P(5,1)*Metric(2,3) + P(1,4)*P(4,3)*P(5,1)*Metric(2,3) + P(1,5)*P(4,1)*P(5,2)*Metric(2,3) - P(1,4)*P(4,3)*P(5,2)*Metric(2,3) - P(1,5)*P(4,3)*P(5,2)*Metric(2,3) + P(1,3)*P(4,5)*P(5,2)*Metric(2,3) - P(1,4)*P(4,5)*P(5,2)*Metric(2,3) + P(1,5)*P(4,1)*P(5,3)*Metric(2,3) - P(1,4)*P(4,2)*P(5,3)*Metric(2,3) - P(1,5)*P(4,2)*P(5,3)*Metric(2,3) + P(1,2)*P(4,5)*P(5,3)*Metric(2,3) - P(1,4)*P(4,5)*P(5,3)*Metric(2,3) + P(1,3)*P(4,2)*P(5,4)*Metric(2,3) - P(1,5)*P(4,2)*P(5,4)*Metric(2,3) + P(1,2)*P(4,3)*P(5,4)*Metric(2,3) - P(1,5)*P(4,3)*P(5,4)*Metric(2,3) - P(-1,2)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,3)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,4)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,3)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,4)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,4)*P(4,3)*Metric(1,5)*Metric(2,3) + P(-1,2)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) + P(-1,4)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) - P(1,4)*P(3,2)*P(5,1)*Metric(2,4) - P(1,2)*P(3,4)*P(5,1)*Metric(2,4) + P(1,3)*P(3,4)*P(5,1)*Metric(2,4) + P(1,4)*P(3,1)*P(5,2)*Metric(2,4) - P(1,5)*P(3,1)*P(5,2)*Metric(2,4) - 2*P(1,3)*P(3,4)*P(5,2)*Metric(2,4) + 2*P(1,5)*P(3,4)*P(5,2)*Metric(2,4) + 2*P(1,3)*P(3,5)*P(5,2)*Metric(2,4) - 2*P(1,4)*P(3,5)*P(5,2)*Metric(2,4) + P(1,4)*P(3,2)*P(5,3)*Metric(2,4) + P(1,5)*P(3,2)*P(5,3)*Metric(2,4) + 2*P(1,2)*P(3,4)*P(5,3)*Metric(2,4) - 2*P(1,5)*P(3,4)*P(5,3)*Metric(2,4) + P(1,2)*P(3,1)*P(5,4)*Metric(2,4) - P(1,3)*P(3,2)*P(5,4)*Metric(2,4) + P(1,5)*P(3,2)*P(5,4)*Metric(2,4) - P(1,2)*P(3,5)*P(5,4)*Metric(2,4) - P(1,3)*P(3,5)*P(5,4)*Metric(2,4) - P(-1,3)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,3)*Metric(2,4) + 2*P(-1,3)*P(-1,4)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) - 2*P(-1,3)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) + 2*P(-1,2)*P(-1,5)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,4)*P(-1,5)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,2)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,5)*Metric(2,4) - P(-1,3)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,2)*P(3,4)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,5)*Metric(2,4) - 2*P(-1,2)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) + 2*P(-1,3)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) + P(-1,2)*P(-1,3)*P(3,5)*Metric(1,5)*Metric(2,4) - 2*P(-1,3)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - P(1,5)*P(3,2)*P(4,1)*Metric(2,5) - P(1,2)*P(3,5)*P(4,1)*Metric(2,5) + P(1,3)*P(3,5)*P(4,1)*Metric(2,5) - P(1,4)*P(3,1)*P(4,2)*Metric(2,5) + P(1,5)*P(3,1)*P(4,2)*Metric(2,5) + 2*P(1,3)*P(3,4)*P(4,2)*Metric(2,5) - 2*P(1,5)*P(3,4)*P(4,2)*Metric(2,5) - 2*P(1,3)*P(3,5)*P(4,2)*Metric(2,5) + 2*P(1,4)*P(3,5)*P(4,2)*Metric(2,5) + P(1,4)*P(3,2)*P(4,3)*Metric(2,5) + P(1,5)*P(3,2)*P(4,3)*Metric(2,5) + 2*P(1,2)*P(3,5)*P(4,3)*Metric(2,5) - 2*P(1,4)*P(3,5)*P(4,3)*Metric(2,5) + P(1,2)*P(3,1)*P(4,5)*Metric(2,5) - P(1,3)*P(3,2)*P(4,5)*Metric(2,5) + P(1,4)*P(3,2)*P(4,5)*Metric(2,5) - P(1,2)*P(3,4)*P(4,5)*Metric(2,5) - P(1,3)*P(3,4)*P(4,5)*Metric(2,5) - P(-1,2)*P(-1,4)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,4)*P(4,2)*Metric(1,3)*Metric(2,5) - 2*P(-1,3)*P(-1,4)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) + 2*P(-1,3)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) + 2*P(-1,2)*P(-1,4)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,4)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,3)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,3)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,3)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,2)*P(-1,3)*P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(-1,3)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,4)*Metric(2,5) - P(-1,1)*P(-1,3)*P(3,5)*Metric(1,4)*Metric(2,5) - 2*P(-1,2)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + 2*P(-1,3)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) - P(1,4)*P(2,3)*P(5,1)*Metric(3,4) + P(1,2)*P(2,4)*P(5,1)*Metric(3,4) - P(1,3)*P(2,4)*P(5,1)*Metric(3,4) + P(1,4)*P(2,3)*P(5,2)*Metric(3,4) + P(1,5)*P(2,3)*P(5,2)*Metric(3,4) + 2*P(1,3)*P(2,4)*P(5,2)*Metric(3,4) - 2*P(1,5)*P(2,4)*P(5,2)*Metric(3,4) + P(1,4)*P(2,1)*P(5,3)*Metric(3,4) - P(1,5)*P(2,1)*P(5,3)*Metric(3,4) - 2*P(1,2)*P(2,4)*P(5,3)*Metric(3,4) + 2*P(1,5)*P(2,4)*P(5,3)*Metric(3,4) + 2*P(1,2)*P(2,5)*P(5,3)*Metric(3,4) - 2*P(1,4)*P(2,5)*P(5,3)*Metric(3,4) + P(1,3)*P(2,1)*P(5,4)*Metric(3,4) - P(1,2)*P(2,3)*P(5,4)*Metric(3,4) + P(1,5)*P(2,3)*P(5,4)*Metric(3,4) - P(1,2)*P(2,5)*P(5,4)*Metric(3,4) - P(1,3)*P(2,5)*P(5,4)*Metric(3,4) - P(-1,2)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) + 2*P(-1,3)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*P(5,3)*Metric(1,2)*Metric(3,4) + 2*P(-1,2)*P(-1,4)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) - 2*P(-1,2)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,2)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,4)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(2,4)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(2,4)*Metric(1,5)*Metric(3,4) + 2*P(-1,2)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) - 2*P(-1,3)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4) - 2*P(-1,2)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) - 2*P(-1,3)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) - 2*P(-1,2)*P(-1,4)*P(1,3)*Metric(2,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,3)*P(1,4)*Metric(2,5)*Metric(3,4) + 2*P(-1,3)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4) + 2*P(-1,2)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) - P(1,5)*P(2,3)*P(4,1)*Metric(3,5) + P(1,2)*P(2,5)*P(4,1)*Metric(3,5) - P(1,3)*P(2,5)*P(4,1)*Metric(3,5) + P(1,4)*P(2,3)*P(4,2)*Metric(3,5) + P(1,5)*P(2,3)*P(4,2)*Metric(3,5) + 2*P(1,3)*P(2,5)*P(4,2)*Metric(3,5) - 2*P(1,4)*P(2,5)*P(4,2)*Metric(3,5) - P(1,4)*P(2,1)*P(4,3)*Metric(3,5) + P(1,5)*P(2,1)*P(4,3)*Metric(3,5) + 2*P(1,2)*P(2,4)*P(4,3)*Metric(3,5) - 2*P(1,5)*P(2,4)*P(4,3)*Metric(3,5) - 2*P(1,2)*P(2,5)*P(4,3)*Metric(3,5) + 2*P(1,4)*P(2,5)*P(4,3)*Metric(3,5) + P(1,3)*P(2,1)*P(4,5)*Metric(3,5) - P(1,2)*P(2,3)*P(4,5)*Metric(3,5) + P(1,4)*P(2,3)*P(4,5)*Metric(3,5) - P(1,2)*P(2,4)*P(4,5)*Metric(3,5) - P(1,3)*P(2,4)*P(4,5)*Metric(3,5) - P(-1,3)*P(-1,4)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + 2*P(-1,3)*P(-1,4)*P(4,2)*Metric(1,2)*Metric(3,5) - P(-1,4)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,4)*P(4,3)*Metric(1,2)*Metric(3,5) - 2*P(-1,2)*P(-1,4)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) + 2*P(-1,2)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,2)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,2)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) - P(-1,4)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) + P(-1,2)*P(-1,3)*P(2,4)*Metric(1,4)*Metric(3,5) - 2*P(-1,2)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(2,5)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,3)*P(2,5)*Metric(1,4)*Metric(3,5) + 2*P(-1,2)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - 2*P(-1,3)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - 2*P(-1,3)*P(-1,4)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) - 2*P(-1,2)*P(-1,5)*P(1,3)*Metric(2,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(1,3)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,3)*P(1,4)*Metric(2,4)*Metric(3,5) + 2*P(-1,2)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,3)*P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(-1,3)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) - P(1,2)*P(2,4)*P(3,1)*Metric(4,5) - P(1,2)*P(2,5)*P(3,1)*Metric(4,5) + P(1,3)*P(2,4)*P(3,2)*Metric(4,5) - P(1,5)*P(2,4)*P(3,2)*Metric(4,5) + P(1,3)*P(2,5)*P(3,2)*Metric(4,5) - P(1,4)*P(2,5)*P(3,2)*Metric(4,5) - P(1,3)*P(2,1)*P(3,4)*Metric(4,5) + P(1,2)*P(2,3)*P(3,4)*Metric(4,5) - P(1,5)*P(2,3)*P(3,4)*Metric(4,5) + P(1,2)*P(2,5)*P(3,4)*Metric(4,5) + P(1,3)*P(2,5)*P(3,4)*Metric(4,5) - P(1,3)*P(2,1)*P(3,5)*Metric(4,5) + P(1,2)*P(2,3)*P(3,5)*Metric(4,5) - P(1,4)*P(2,3)*P(3,5)*Metric(4,5) + P(1,2)*P(2,4)*P(3,5)*Metric(4,5) + P(1,3)*P(2,4)*P(3,5)*Metric(4,5) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5) - P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) - P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,2)*P(-1,4)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,2)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,4)*P(1,3)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,3)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5) + P(-1,3)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV62 = Lorentz(name = 'VVVVV62',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,5)*P(4,2)*P(5,1)*Metric(1,2) - P(3,2)*P(4,5)*P(5,1)*Metric(1,2) + P(3,4)*P(4,1)*P(5,2)*Metric(1,2) + P(3,4)*P(4,5)*P(5,2)*Metric(1,2) - P(3,2)*P(4,5)*P(5,3)*Metric(1,2) - P(3,2)*P(4,1)*P(5,4)*Metric(1,2) + P(3,5)*P(4,2)*P(5,4)*Metric(1,2) - P(3,2)*P(4,3)*P(5,4)*Metric(1,2) + P(2,5)*P(4,3)*P(5,1)*Metric(1,3) - P(2,3)*P(4,5)*P(5,1)*Metric(1,3) - P(2,3)*P(4,5)*P(5,2)*Metric(1,3) + P(2,4)*P(4,1)*P(5,3)*Metric(1,3) + P(2,4)*P(4,5)*P(5,3)*Metric(1,3) - P(2,3)*P(4,1)*P(5,4)*Metric(1,3) - P(2,3)*P(4,2)*P(5,4)*Metric(1,3) + P(2,5)*P(4,3)*P(5,4)*Metric(1,3) - P(2,1)*P(3,4)*P(5,2)*Metric(1,4) - P(2,3)*P(3,4)*P(5,2)*Metric(1,4) - P(2,4)*P(3,1)*P(5,3)*Metric(1,4) - P(2,4)*P(3,2)*P(5,3)*Metric(1,4) + P(2,3)*P(3,1)*P(5,4)*Metric(1,4) + P(2,1)*P(3,2)*P(5,4)*Metric(1,4) + P(2,5)*P(3,2)*P(5,4)*Metric(1,4) + P(2,3)*P(3,5)*P(5,4)*Metric(1,4) - P(2,1)*P(3,5)*P(4,2)*Metric(1,5) - P(2,3)*P(3,5)*P(4,2)*Metric(1,5) - P(2,5)*P(3,1)*P(4,3)*Metric(1,5) - P(2,5)*P(3,2)*P(4,3)*Metric(1,5) + P(2,3)*P(3,1)*P(4,5)*Metric(1,5) + P(2,1)*P(3,2)*P(4,5)*Metric(1,5) + P(2,4)*P(3,2)*P(4,5)*Metric(1,5) + P(2,3)*P(3,4)*P(4,5)*Metric(1,5) + P(1,2)*P(4,5)*P(5,1)*Metric(2,3) + P(1,3)*P(4,5)*P(5,1)*Metric(2,3) - P(1,4)*P(4,3)*P(5,2)*Metric(2,3) - P(1,5)*P(4,3)*P(5,2)*Metric(2,3) + P(1,3)*P(4,5)*P(5,2)*Metric(2,3) - P(1,4)*P(4,5)*P(5,2)*Metric(2,3) - P(1,4)*P(4,2)*P(5,3)*Metric(2,3) - P(1,5)*P(4,2)*P(5,3)*Metric(2,3) + P(1,2)*P(4,5)*P(5,3)*Metric(2,3) - P(1,4)*P(4,5)*P(5,3)*Metric(2,3) + P(1,2)*P(4,1)*P(5,4)*Metric(2,3) + P(1,3)*P(4,1)*P(5,4)*Metric(2,3) + P(1,3)*P(4,2)*P(5,4)*Metric(2,3) - P(1,5)*P(4,2)*P(5,4)*Metric(2,3) + P(1,2)*P(4,3)*P(5,4)*Metric(2,3) - P(1,5)*P(4,3)*P(5,4)*Metric(2,3) + P(-1,3)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(5,4)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,3)*P(5,4)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,4)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,2)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) + P(-1,4)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) - P(1,2)*P(3,5)*P(5,1)*Metric(2,4) + P(1,4)*P(3,1)*P(5,3)*Metric(2,4) + P(1,4)*P(3,2)*P(5,3)*Metric(2,4) + P(1,5)*P(3,2)*P(5,3)*Metric(2,4) - P(1,3)*P(3,2)*P(5,4)*Metric(2,4) + P(1,5)*P(3,2)*P(5,4)*Metric(2,4) - P(1,2)*P(3,5)*P(5,4)*Metric(2,4) - P(1,3)*P(3,5)*P(5,4)*Metric(2,4) - P(-1,1)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,4)*P(-1,5)*P(5,3)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,5)*Metric(2,4) + P(-1,2)*P(-1,3)*P(3,5)*Metric(1,5)*Metric(2,4) - P(1,2)*P(3,4)*P(4,1)*Metric(2,5) + P(1,5)*P(3,1)*P(4,3)*Metric(2,5) + P(1,4)*P(3,2)*P(4,3)*Metric(2,5) + P(1,5)*P(3,2)*P(4,3)*Metric(2,5) - P(1,3)*P(3,2)*P(4,5)*Metric(2,5) + P(1,4)*P(3,2)*P(4,5)*Metric(2,5) - P(1,2)*P(3,4)*P(4,5)*Metric(2,5) - P(1,3)*P(3,4)*P(4,5)*Metric(2,5) - P(-1,1)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,4)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,3)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,3)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,2)*P(3,4)*Metric(1,4)*Metric(2,5) + P(-1,2)*P(-1,3)*P(3,4)*Metric(1,4)*Metric(2,5) - P(1,3)*P(2,5)*P(5,1)*Metric(3,4) + P(1,4)*P(2,1)*P(5,2)*Metric(3,4) + P(1,4)*P(2,3)*P(5,2)*Metric(3,4) + P(1,5)*P(2,3)*P(5,2)*Metric(3,4) - P(1,2)*P(2,3)*P(5,4)*Metric(3,4) + P(1,5)*P(2,3)*P(5,4)*Metric(3,4) - P(1,2)*P(2,5)*P(5,4)*Metric(3,4) - P(1,3)*P(2,5)*P(5,4)*Metric(3,4) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,4)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,3)*P(1,4)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4) - P(1,3)*P(2,4)*P(4,1)*Metric(3,5) + P(1,5)*P(2,1)*P(4,2)*Metric(3,5) + P(1,4)*P(2,3)*P(4,2)*Metric(3,5) + P(1,5)*P(2,3)*P(4,2)*Metric(3,5) - P(1,2)*P(2,3)*P(4,5)*Metric(3,5) + P(1,4)*P(2,3)*P(4,5)*Metric(3,5) - P(1,2)*P(2,4)*P(4,5)*Metric(3,5) - P(1,3)*P(2,4)*P(4,5)*Metric(3,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) - P(-1,4)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5) - P(-1,4)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,3)*P(2,4)*Metric(1,4)*Metric(3,5) + P(-1,2)*P(-1,3)*P(2,4)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(1,3)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,3)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,3)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,3)*P(1,5)*Metric(2,4)*Metric(3,5) - P(1,4)*P(2,3)*P(3,1)*Metric(4,5) - P(1,5)*P(2,3)*P(3,1)*Metric(4,5) - P(1,4)*P(2,1)*P(3,2)*Metric(4,5) - P(1,5)*P(2,1)*P(3,2)*Metric(4,5) + P(1,3)*P(2,4)*P(3,2)*Metric(4,5) - P(1,5)*P(2,4)*P(3,2)*Metric(4,5) + P(1,3)*P(2,5)*P(3,2)*Metric(4,5) - P(1,4)*P(2,5)*P(3,2)*Metric(4,5) + P(1,2)*P(2,3)*P(3,4)*Metric(4,5) - P(1,5)*P(2,3)*P(3,4)*Metric(4,5) + P(1,2)*P(2,5)*P(3,4)*Metric(4,5) + P(1,3)*P(2,5)*P(3,4)*Metric(4,5) + P(1,2)*P(2,3)*P(3,5)*Metric(4,5) - P(1,4)*P(2,3)*P(3,5)*Metric(4,5) + P(1,2)*P(2,4)*P(3,5)*Metric(4,5) + P(1,3)*P(2,4)*P(3,5)*Metric(4,5) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,2)*P(-1,4)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,2)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,4)*P(1,3)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,3)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5) + P(-1,3)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV63 = Lorentz(name = 'VVVVV63',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,5)*P(4,3)*P(5,1)*Metric(1,2) + P(3,4)*P(4,5)*P(5,1)*Metric(1,2) - P(3,5)*P(4,3)*P(5,2)*Metric(1,2) - P(3,4)*P(4,5)*P(5,2)*Metric(1,2) + P(3,4)*P(4,1)*P(5,3)*Metric(1,2) - P(3,4)*P(4,2)*P(5,3)*Metric(1,2) + P(3,1)*P(4,5)*P(5,3)*Metric(1,2) - P(3,2)*P(4,5)*P(5,3)*Metric(1,2) + P(3,5)*P(4,1)*P(5,4)*Metric(1,2) - P(3,5)*P(4,2)*P(5,4)*Metric(1,2) + P(3,1)*P(4,3)*P(5,4)*Metric(1,2) - P(3,2)*P(4,3)*P(5,4)*Metric(1,2) + P(2,4)*P(4,3)*P(5,1)*Metric(1,3) - P(2,4)*P(4,5)*P(5,1)*Metric(1,3) - P(2,4)*P(4,3)*P(5,2)*Metric(1,3) + P(2,5)*P(4,1)*P(5,3)*Metric(1,3) - P(2,5)*P(4,2)*P(5,3)*Metric(1,3) - P(2,1)*P(4,5)*P(5,3)*Metric(1,3) + 2*P(2,4)*P(4,5)*P(5,3)*Metric(1,3) - P(2,5)*P(4,1)*P(5,4)*Metric(1,3) - P(2,1)*P(4,3)*P(5,4)*Metric(1,3) + 2*P(2,5)*P(4,3)*P(5,4)*Metric(1,3) + P(2,3)*P(3,4)*P(5,1)*Metric(1,4) - P(2,3)*P(3,5)*P(5,1)*Metric(1,4) - P(2,3)*P(3,4)*P(5,2)*Metric(1,4) - P(2,5)*P(3,1)*P(5,3)*Metric(1,4) - P(2,1)*P(3,4)*P(5,3)*Metric(1,4) + 2*P(2,5)*P(3,4)*P(5,3)*Metric(1,4) + P(2,5)*P(3,1)*P(5,4)*Metric(1,4) - P(2,5)*P(3,2)*P(5,4)*Metric(1,4) - P(2,1)*P(3,5)*P(5,4)*Metric(1,4) + 2*P(2,3)*P(3,5)*P(5,4)*Metric(1,4) - P(2,3)*P(3,4)*P(4,1)*Metric(1,5) + P(2,3)*P(3,5)*P(4,1)*Metric(1,5) - P(2,3)*P(3,5)*P(4,2)*Metric(1,5) - P(2,4)*P(3,1)*P(4,3)*Metric(1,5) - P(2,1)*P(3,5)*P(4,3)*Metric(1,5) + 2*P(2,4)*P(3,5)*P(4,3)*Metric(1,5) + P(2,4)*P(3,1)*P(4,5)*Metric(1,5) - P(2,4)*P(3,2)*P(4,5)*Metric(1,5) - P(2,1)*P(3,4)*P(4,5)*Metric(1,5) + 2*P(2,3)*P(3,4)*P(4,5)*Metric(1,5) + P(1,4)*P(4,3)*P(5,1)*Metric(2,3) - P(1,4)*P(4,3)*P(5,2)*Metric(2,3) + P(1,4)*P(4,5)*P(5,2)*Metric(2,3) + P(1,5)*P(4,1)*P(5,3)*Metric(2,3) - P(1,5)*P(4,2)*P(5,3)*Metric(2,3) + P(1,2)*P(4,5)*P(5,3)*Metric(2,3) - 2*P(1,4)*P(4,5)*P(5,3)*Metric(2,3) + P(1,5)*P(4,2)*P(5,4)*Metric(2,3) + P(1,2)*P(4,3)*P(5,4)*Metric(2,3) - 2*P(1,5)*P(4,3)*P(5,4)*Metric(2,3) - P(-1,3)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,4)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) + 2*P(-1,4)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) - 2*P(-1,3)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,3)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) - P(-1,4)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,4)*P(4,3)*Metric(1,5)*Metric(2,3) + 2*P(-1,4)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) + P(-1,2)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) - 2*P(-1,3)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) + P(1,3)*P(3,4)*P(5,1)*Metric(2,4) - P(1,3)*P(3,4)*P(5,2)*Metric(2,4) + P(1,3)*P(3,5)*P(5,2)*Metric(2,4) + P(1,5)*P(3,2)*P(5,3)*Metric(2,4) + P(1,2)*P(3,4)*P(5,3)*Metric(2,4) - 2*P(1,5)*P(3,4)*P(5,3)*Metric(2,4) + P(1,5)*P(3,1)*P(5,4)*Metric(2,4) - P(1,5)*P(3,2)*P(5,4)*Metric(2,4) + P(1,2)*P(3,5)*P(5,4)*Metric(2,4) - 2*P(1,3)*P(3,5)*P(5,4)*Metric(2,4) - P(-1,3)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*P(5,2)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*P(5,3)*Metric(1,3)*Metric(2,4) - 2*P(-1,4)*P(-1,5)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) + 2*P(-1,3)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,3)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,4)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,5)*Metric(2,4) + 2*P(-1,3)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) + P(-1,2)*P(-1,3)*P(3,5)*Metric(1,5)*Metric(2,4) - 2*P(-1,3)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) + P(1,3)*P(3,5)*P(4,1)*Metric(2,5) + P(1,3)*P(3,4)*P(4,2)*Metric(2,5) - P(1,3)*P(3,5)*P(4,2)*Metric(2,5) + P(1,4)*P(3,2)*P(4,3)*Metric(2,5) + P(1,2)*P(3,5)*P(4,3)*Metric(2,5) - 2*P(1,4)*P(3,5)*P(4,3)*Metric(2,5) + P(1,4)*P(3,1)*P(4,5)*Metric(2,5) - P(1,4)*P(3,2)*P(4,5)*Metric(2,5) + P(1,2)*P(3,4)*P(4,5)*Metric(2,5) - 2*P(1,3)*P(3,4)*P(4,5)*Metric(2,5) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,4)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,3)*P(-1,4)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,3)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,4)*P(4,3)*Metric(1,3)*Metric(2,5) - 2*P(-1,4)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) + 2*P(-1,3)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,3)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,3)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,4)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,2)*P(-1,3)*P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(-1,3)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) - P(-1,1)*P(-1,3)*P(3,5)*Metric(1,4)*Metric(2,5) + 2*P(-1,3)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) - P(1,4)*P(2,3)*P(5,1)*Metric(3,4) - P(1,3)*P(2,4)*P(5,1)*Metric(3,4) + P(1,4)*P(2,3)*P(5,2)*Metric(3,4) + P(1,3)*P(2,4)*P(5,2)*Metric(3,4) + P(1,4)*P(2,1)*P(5,3)*Metric(3,4) - P(1,5)*P(2,1)*P(5,3)*Metric(3,4) - P(1,2)*P(2,4)*P(5,3)*Metric(3,4) + 2*P(1,5)*P(2,4)*P(5,3)*Metric(3,4) + P(1,2)*P(2,5)*P(5,3)*Metric(3,4) - 2*P(1,4)*P(2,5)*P(5,3)*Metric(3,4) + P(1,3)*P(2,1)*P(5,4)*Metric(3,4) - P(1,5)*P(2,1)*P(5,4)*Metric(3,4) - P(1,2)*P(2,3)*P(5,4)*Metric(3,4) + 2*P(1,5)*P(2,3)*P(5,4)*Metric(3,4) + P(1,2)*P(2,5)*P(5,4)*Metric(3,4) - 2*P(1,3)*P(2,5)*P(5,4)*Metric(3,4) - P(-1,3)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,4)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,5)*Metric(3,4) - 2*P(-1,4)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(2,4)*Metric(1,5)*Metric(3,4) - 2*P(-1,3)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) - P(-1,3)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,4)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,4)*P(1,3)*Metric(2,5)*Metric(3,4) + 2*P(-1,4)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,3)*P(1,4)*Metric(2,5)*Metric(3,4) + 2*P(-1,3)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) - P(1,5)*P(2,3)*P(4,1)*Metric(3,5) - P(1,3)*P(2,5)*P(4,1)*Metric(3,5) + P(1,5)*P(2,3)*P(4,2)*Metric(3,5) + P(1,3)*P(2,5)*P(4,2)*Metric(3,5) - P(1,4)*P(2,1)*P(4,3)*Metric(3,5) + P(1,5)*P(2,1)*P(4,3)*Metric(3,5) + P(1,2)*P(2,4)*P(4,3)*Metric(3,5) - 2*P(1,5)*P(2,4)*P(4,3)*Metric(3,5) - P(1,2)*P(2,5)*P(4,3)*Metric(3,5) + 2*P(1,4)*P(2,5)*P(4,3)*Metric(3,5) + P(1,3)*P(2,1)*P(4,5)*Metric(3,5) - P(1,4)*P(2,1)*P(4,5)*Metric(3,5) - P(1,2)*P(2,3)*P(4,5)*Metric(3,5) + 2*P(1,4)*P(2,3)*P(4,5)*Metric(3,5) + P(1,2)*P(2,4)*P(4,5)*Metric(3,5) - 2*P(1,3)*P(2,4)*P(4,5)*Metric(3,5) - P(-1,3)*P(-1,4)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,4)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,4)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,4)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,4)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,4)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) - 2*P(-1,4)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,3)*P(2,5)*Metric(1,4)*Metric(3,5) - 2*P(-1,3)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,4)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,4)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,4)*Metric(3,5) + 2*P(-1,4)*P(-1,5)*P(1,3)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,3)*P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(-1,3)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) - P(1,5)*P(2,4)*P(3,1)*Metric(4,5) - P(1,4)*P(2,5)*P(3,1)*Metric(4,5) + P(1,5)*P(2,4)*P(3,2)*Metric(4,5) + P(1,4)*P(2,5)*P(3,2)*Metric(4,5) - P(1,3)*P(2,1)*P(3,4)*Metric(4,5) + P(1,5)*P(2,1)*P(3,4)*Metric(4,5) + P(1,2)*P(2,3)*P(3,4)*Metric(4,5) - 2*P(1,5)*P(2,3)*P(3,4)*Metric(4,5) - P(1,2)*P(2,5)*P(3,4)*Metric(4,5) + 2*P(1,3)*P(2,5)*P(3,4)*Metric(4,5) - P(1,3)*P(2,1)*P(3,5)*Metric(4,5) + P(1,4)*P(2,1)*P(3,5)*Metric(4,5) + P(1,2)*P(2,3)*P(3,5)*Metric(4,5) - 2*P(1,4)*P(2,3)*P(3,5)*Metric(4,5) - P(1,2)*P(2,4)*P(3,5)*Metric(4,5) + 2*P(1,3)*P(2,4)*P(3,5)*Metric(4,5) - P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5) - P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) - 2*P(-1,3)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(-1,3)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(-1,3)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5) + 2*P(-1,3)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV64 = Lorentz(name = 'VVVVV64',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,5)*P(4,1)*P(5,3)*Metric(1,2) + P(3,5)*P(4,2)*P(5,3)*Metric(1,2) - P(3,1)*P(4,5)*P(5,4)*Metric(1,2) - P(3,2)*P(4,5)*P(5,4)*Metric(1,2) + P(2,4)*P(4,2)*P(5,1)*Metric(1,3) - 2*P(2,5)*P(4,1)*P(5,2)*Metric(1,3) + P(2,1)*P(4,5)*P(5,4)*Metric(1,3) - P(2,3)*P(3,2)*P(5,1)*Metric(1,4) + 2*P(2,5)*P(3,1)*P(5,2)*Metric(1,4) - P(2,1)*P(3,5)*P(5,3)*Metric(1,4) + P(2,3)*P(3,2)*P(4,1)*Metric(1,5) - P(2,4)*P(3,1)*P(4,2)*Metric(1,5) - P(2,4)*P(3,5)*P(4,2)*Metric(1,5) + P(2,3)*P(3,2)*P(4,5)*Metric(1,5) - 2*P(1,5)*P(4,2)*P(5,1)*Metric(2,3) + P(1,4)*P(4,1)*P(5,2)*Metric(2,3) + P(1,2)*P(4,5)*P(5,4)*Metric(2,3) + P(-1,2)*P(-1,3)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,3)*P(4,1)*Metric(1,5)*Metric(2,3) + 2*P(-1,1)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) + 2*P(1,5)*P(3,2)*P(5,1)*Metric(2,4) - P(1,3)*P(3,1)*P(5,2)*Metric(2,4) - P(1,2)*P(3,5)*P(5,3)*Metric(2,4) - P(-1,2)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,3)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) - 2*P(-1,1)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,2)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - P(1,4)*P(3,2)*P(4,1)*Metric(2,5) - P(1,4)*P(3,5)*P(4,1)*Metric(2,5) + P(1,3)*P(3,1)*P(4,2)*Metric(2,5) + P(1,3)*P(3,1)*P(4,5)*Metric(2,5) + 2*P(-1,2)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,3)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) - 2*P(-1,2)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,4)*P(2,5)*P(4,1)*Metric(3,5) + P(1,5)*P(2,4)*P(4,2)*Metric(3,5) - 2*P(1,2)*P(2,1)*P(4,5)*Metric(3,5) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,3)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + 2*P(-1,1)*P(-1,2)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) + P(-1,3)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) - P(1,3)*P(2,5)*P(3,1)*Metric(4,5) - P(1,5)*P(2,3)*P(3,2)*Metric(4,5) + 2*P(1,2)*P(2,1)*P(3,5)*Metric(4,5) + P(-1,4)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,4)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) - 2*P(-1,1)*P(-1,2)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,4)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,4)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV65 = Lorentz(name = 'VVVVV65',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,5)*P(4,1)*P(5,3)*Metric(1,2) + P(3,5)*P(4,2)*P(5,3)*Metric(1,2) - P(3,1)*P(4,5)*P(5,4)*Metric(1,2) - P(3,2)*P(4,5)*P(5,4)*Metric(1,2) - P(2,5)*P(4,1)*P(5,2)*Metric(1,3) + P(2,1)*P(4,5)*P(5,4)*Metric(1,3) + P(2,5)*P(3,1)*P(5,2)*Metric(1,4) - P(2,1)*P(3,5)*P(5,3)*Metric(1,4) - P(2,4)*P(3,5)*P(4,2)*Metric(1,5) + P(2,3)*P(3,2)*P(4,5)*Metric(1,5) - P(1,5)*P(4,2)*P(5,1)*Metric(2,3) + P(1,2)*P(4,5)*P(5,4)*Metric(2,3) + P(-1,1)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) + P(1,5)*P(3,2)*P(5,1)*Metric(2,4) - P(1,2)*P(3,5)*P(5,3)*Metric(2,4) - P(-1,1)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,2)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - P(1,4)*P(3,5)*P(4,1)*Metric(2,5) + P(1,3)*P(3,1)*P(4,5)*Metric(2,5) + P(-1,2)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,2)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,4)*P(2,5)*P(4,1)*Metric(3,5) + P(1,5)*P(2,4)*P(4,2)*Metric(3,5) - 2*P(1,2)*P(2,1)*P(4,5)*Metric(3,5) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,3)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + 2*P(-1,1)*P(-1,2)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) + P(-1,3)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) - P(1,3)*P(2,5)*P(3,1)*Metric(4,5) - P(1,5)*P(2,3)*P(3,2)*Metric(4,5) + 2*P(1,2)*P(2,1)*P(3,5)*Metric(4,5) + P(-1,4)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,4)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) - 2*P(-1,1)*P(-1,2)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,4)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,4)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV66 = Lorentz(name = 'VVVVV66',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,4)*P(4,3)*P(5,1)*Metric(1,2) + P(3,4)*P(4,3)*P(5,2)*Metric(1,2) - (P(3,5)*P(4,1)*P(5,3)*Metric(1,2))/2. - (P(3,5)*P(4,2)*P(5,3)*Metric(1,2))/2. - (P(3,1)*P(4,5)*P(5,4)*Metric(1,2))/2. - (P(3,2)*P(4,5)*P(5,4)*Metric(1,2))/2. - (P(2,4)*P(4,2)*P(5,1)*Metric(1,3))/2. - (P(2,5)*P(4,3)*P(5,2)*Metric(1,3))/2. + (P(2,4)*P(4,2)*P(5,3)*Metric(1,3))/2. + (P(2,1)*P(4,5)*P(5,4)*Metric(1,3))/2. - (P(2,3)*P(3,2)*P(5,1)*Metric(1,4))/2. - (P(2,5)*P(3,4)*P(5,2)*Metric(1,4))/2. + (P(2,1)*P(3,5)*P(5,3)*Metric(1,4))/2. + (P(2,3)*P(3,2)*P(5,4)*Metric(1,4))/2. + (P(2,3)*P(3,2)*P(4,1)*Metric(1,5))/2. + (P(2,4)*P(3,1)*P(4,2)*Metric(1,5))/2. - P(2,1)*P(3,4)*P(4,3)*Metric(1,5) - (P(1,5)*P(4,3)*P(5,1)*Metric(2,3))/2. - (P(1,4)*P(4,1)*P(5,2)*Metric(2,3))/2. + (P(1,4)*P(4,1)*P(5,3)*Metric(2,3))/2. + (P(1,2)*P(4,5)*P(5,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,3)*P(5,1)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3))/2. - (P(-1,1)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3))/2. - (P(-1,2)*P(-1,3)*P(5,4)*Metric(1,4)*Metric(2,3))/2. - (P(-1,2)*P(-1,3)*P(4,1)*Metric(1,5)*Metric(2,3))/2. + (P(-1,1)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3))/2. - (P(1,5)*P(3,4)*P(5,1)*Metric(2,4))/2. - (P(1,3)*P(3,1)*P(5,2)*Metric(2,4))/2. + (P(1,2)*P(3,5)*P(5,3)*Metric(2,4))/2. + (P(1,3)*P(3,1)*P(5,4)*Metric(2,4))/2. + (P(-1,2)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,3)*P(5,2)*Metric(1,3)*Metric(2,4))/2. - (P(-1,2)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4))/2. - (P(-1,1)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4))/2. - (P(-1,2)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4))/2. + (P(-1,1)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4))/2. + (P(1,4)*P(3,2)*P(4,1)*Metric(2,5))/2. + (P(1,3)*P(3,1)*P(4,2)*Metric(2,5))/2. - P(1,2)*P(3,4)*P(4,3)*Metric(2,5) - (P(-1,1)*P(-1,3)*P(4,2)*Metric(1,3)*Metric(2,5))/2. + (P(-1,2)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5))/2. - (P(-1,1)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5))/2. + (P(-1,2)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5))/2. + (P(1,5)*P(2,3)*P(5,1)*Metric(3,4))/2. + (P(1,5)*P(2,4)*P(5,1)*Metric(3,4))/2. + (P(1,3)*P(2,5)*P(5,2)*Metric(3,4))/2. + (P(1,4)*P(2,5)*P(5,2)*Metric(3,4))/2. - P(1,2)*P(2,1)*P(5,3)*Metric(3,4) - P(1,2)*P(2,1)*P(5,4)*Metric(3,4) - P(-1,3)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,2)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,2)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) - (P(-1,1)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4))/2. - (P(-1,1)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4))/2. + P(-1,3)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) - (P(-1,2)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4))/2. - (P(-1,2)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4))/2. - (P(1,4)*P(2,3)*P(4,1)*Metric(3,5))/2. - (P(1,3)*P(2,4)*P(4,2)*Metric(3,5))/2. + P(1,2)*P(2,1)*P(4,3)*Metric(3,5) + (P(-1,3)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5))/2. + (P(-1,3)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5))/2. - P(-1,1)*P(-1,2)*P(4,3)*Metric(1,2)*Metric(3,5) - (P(-1,3)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5))/2. + (P(-1,1)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5))/2. - (P(-1,3)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5))/2. + (P(-1,2)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5))/2. - (P(1,3)*P(2,4)*P(3,1)*Metric(4,5))/2. - (P(1,4)*P(2,3)*P(3,2)*Metric(4,5))/2. + P(1,2)*P(2,1)*P(3,4)*Metric(4,5) + (P(-1,4)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5))/2. + (P(-1,4)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5))/2. - P(-1,1)*P(-1,2)*P(3,4)*Metric(1,2)*Metric(4,5) - (P(-1,4)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5))/2. - (P(-1,4)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5))/2. + (P(-1,2)*P(-1,3)*P(1,4)*Metric(2,3)*Metric(4,5))/2.')

VVVVV67 = Lorentz(name = 'VVVVV67',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(2,5)*P(4,3)*P(5,2)*Metric(1,3) + P(2,4)*P(4,2)*P(5,3)*Metric(1,3) - 2*P(2,3)*P(4,5)*P(5,4)*Metric(1,3) + P(2,5)*P(3,4)*P(5,2)*Metric(1,4) - 2*P(2,4)*P(3,5)*P(5,3)*Metric(1,4) + P(2,3)*P(3,2)*P(5,4)*Metric(1,4) + P(2,4)*P(3,5)*P(4,2)*Metric(1,5) - 2*P(2,5)*P(3,4)*P(4,3)*Metric(1,5) + P(2,3)*P(3,2)*P(4,5)*Metric(1,5) - P(1,5)*P(4,3)*P(5,1)*Metric(2,3) - P(1,4)*P(4,1)*P(5,3)*Metric(2,3) + 2*P(1,3)*P(4,5)*P(5,4)*Metric(2,3) + P(-1,1)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,3)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) - P(1,5)*P(3,4)*P(5,1)*Metric(2,4) + 2*P(1,4)*P(3,5)*P(5,3)*Metric(2,4) - P(1,3)*P(3,1)*P(5,4)*Metric(2,4) - P(-1,2)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - P(1,4)*P(3,5)*P(4,1)*Metric(2,5) + 2*P(1,5)*P(3,4)*P(4,3)*Metric(2,5) - P(1,3)*P(3,1)*P(4,5)*Metric(2,5) - P(-1,2)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,5)*P(2,3)*P(5,1)*Metric(3,4) + P(1,5)*P(2,4)*P(5,1)*Metric(3,4) - P(1,3)*P(2,5)*P(5,2)*Metric(3,4) - P(1,4)*P(2,5)*P(5,2)*Metric(3,4) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) + 2*P(-1,3)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) - 2*P(-1,3)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + P(1,4)*P(2,3)*P(4,1)*Metric(3,5) + P(1,4)*P(2,5)*P(4,1)*Metric(3,5) - P(1,3)*P(2,4)*P(4,2)*Metric(3,5) - P(1,5)*P(2,4)*P(4,2)*Metric(3,5) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(-1,3)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5) - 2*P(-1,3)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) + P(1,3)*P(2,4)*P(3,1)*Metric(4,5) + P(1,3)*P(2,5)*P(3,1)*Metric(4,5) - P(1,4)*P(2,3)*P(3,2)*Metric(4,5) - P(1,5)*P(2,3)*P(3,2)*Metric(4,5) + 2*P(-1,4)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(-1,4)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,3)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV68 = Lorentz(name = 'VVVVV68',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,4)*P(4,3)*P(5,2)*Metric(1,2) + P(3,5)*P(4,2)*P(5,3)*Metric(1,2) - 2*P(3,2)*P(4,5)*P(5,4)*Metric(1,2) + P(2,5)*P(4,3)*P(5,2)*Metric(1,3) + P(2,4)*P(4,2)*P(5,3)*Metric(1,3) - 2*P(2,3)*P(4,5)*P(5,4)*Metric(1,3) - P(2,5)*P(3,4)*P(5,2)*Metric(1,4) - P(2,4)*P(3,5)*P(5,3)*Metric(1,4) + 2*P(2,3)*P(3,2)*P(5,4)*Metric(1,4) - P(2,4)*P(3,5)*P(4,2)*Metric(1,5) - P(2,5)*P(3,4)*P(4,3)*Metric(1,5) + 2*P(2,3)*P(3,2)*P(4,5)*Metric(1,5) - P(1,5)*P(4,2)*P(5,1)*Metric(2,3) - P(1,5)*P(4,3)*P(5,1)*Metric(2,3) - P(1,4)*P(4,1)*P(5,2)*Metric(2,3) - P(1,4)*P(4,1)*P(5,3)*Metric(2,3) + 2*P(1,2)*P(4,5)*P(5,4)*Metric(2,3) + 2*P(1,3)*P(4,5)*P(5,4)*Metric(2,3) + P(-1,1)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3) - 2*P(-1,2)*P(-1,3)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(-1,2)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) + P(1,5)*P(3,2)*P(5,1)*Metric(2,4) - P(1,2)*P(3,5)*P(5,3)*Metric(2,4) + P(1,4)*P(3,5)*P(5,3)*Metric(2,4) - P(1,3)*P(3,1)*P(5,4)*Metric(2,4) - P(-1,2)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,2)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) + P(1,4)*P(3,2)*P(4,1)*Metric(2,5) - P(1,2)*P(3,4)*P(4,3)*Metric(2,5) + P(1,5)*P(3,4)*P(4,3)*Metric(2,5) - P(1,3)*P(3,1)*P(4,5)*Metric(2,5) - P(-1,2)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,2)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(1,5)*P(2,3)*P(5,1)*Metric(3,4) - P(1,3)*P(2,5)*P(5,2)*Metric(3,4) + P(1,4)*P(2,5)*P(5,2)*Metric(3,4) - P(1,2)*P(2,1)*P(5,4)*Metric(3,4) - P(-1,3)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,2)*P(5,4)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,3)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,3)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + P(1,4)*P(2,3)*P(4,1)*Metric(3,5) - P(1,3)*P(2,4)*P(4,2)*Metric(3,5) + P(1,5)*P(2,4)*P(4,2)*Metric(3,5) - P(1,2)*P(2,1)*P(4,5)*Metric(3,5) - P(-1,3)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,2)*P(4,5)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5) + P(-1,3)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) + P(-1,3)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5) - P(-1,3)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) + P(1,3)*P(2,4)*P(3,1)*Metric(4,5) + P(1,3)*P(2,5)*P(3,1)*Metric(4,5) - 2*P(1,4)*P(2,3)*P(3,2)*Metric(4,5) - 2*P(1,5)*P(2,3)*P(3,2)*Metric(4,5) + P(1,2)*P(2,1)*P(3,4)*Metric(4,5) + P(1,2)*P(2,1)*P(3,5)*Metric(4,5) + 2*P(-1,4)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,2)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,2)*P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(-1,4)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(-1,4)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) - 2*P(-1,4)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) + 2*P(-1,2)*P(-1,3)*P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(-1,2)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV69 = Lorentz(name = 'VVVVV69',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,1)*P(4,5)*P(5,4)*Metric(1,2) - P(3,2)*P(4,5)*P(5,4)*Metric(1,2) - P(2,1)*P(4,5)*P(5,4)*Metric(1,3) + P(2,3)*P(4,5)*P(5,4)*Metric(1,3) + P(1,2)*P(4,5)*P(5,4)*Metric(2,3) - P(1,3)*P(4,5)*P(5,4)*Metric(2,3) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,4)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,4)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) - P(-1,4)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) + P(-1,4)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5)')

VVVVV70 = Lorentz(name = 'VVVVV70',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,1)*P(4,5)*P(5,4)*Metric(1,2) - P(3,2)*P(4,5)*P(5,4)*Metric(1,2) - P(2,1)*P(4,5)*P(5,4)*Metric(1,3) + P(2,3)*P(4,5)*P(5,4)*Metric(1,3) + P(1,5)*P(4,2)*P(5,1)*Metric(2,3) - P(1,5)*P(4,3)*P(5,1)*Metric(2,3) + P(1,4)*P(4,1)*P(5,2)*Metric(2,3) - P(1,4)*P(4,1)*P(5,3)*Metric(2,3) + P(1,2)*P(4,5)*P(5,4)*Metric(2,3) - P(1,3)*P(4,5)*P(5,4)*Metric(2,3) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) - P(1,5)*P(3,2)*P(5,1)*Metric(2,4) + P(1,5)*P(3,4)*P(5,1)*Metric(2,4) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) - P(1,4)*P(3,2)*P(4,1)*Metric(2,5) + P(1,4)*P(3,5)*P(4,1)*Metric(2,5) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,5)*P(2,3)*P(5,1)*Metric(3,4) - P(1,5)*P(2,4)*P(5,1)*Metric(3,4) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) + P(1,4)*P(2,3)*P(4,1)*Metric(3,5) - P(1,4)*P(2,5)*P(4,1)*Metric(3,5) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,4)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,4)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) - P(-1,4)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) + P(-1,4)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5)')

VVVVV71 = Lorentz(name = 'VVVVV71',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,4)*P(4,3)*P(5,1)*Metric(1,2) - P(3,4)*P(4,3)*P(5,2)*Metric(1,2) + P(3,5)*P(4,1)*P(5,3)*Metric(1,2) - P(3,5)*P(4,2)*P(5,3)*Metric(1,2) + P(3,1)*P(4,5)*P(5,4)*Metric(1,2) - P(3,2)*P(4,5)*P(5,4)*Metric(1,2) - P(2,1)*P(4,5)*P(5,4)*Metric(1,3) + P(2,3)*P(4,5)*P(5,4)*Metric(1,3) - P(2,1)*P(3,5)*P(5,3)*Metric(1,4) + P(2,4)*P(3,5)*P(5,3)*Metric(1,4) - P(2,1)*P(3,4)*P(4,3)*Metric(1,5) + P(2,5)*P(3,4)*P(4,3)*Metric(1,5) + P(1,2)*P(4,5)*P(5,4)*Metric(2,3) - P(1,3)*P(4,5)*P(5,4)*Metric(2,3) + P(1,2)*P(3,5)*P(5,3)*Metric(2,4) - P(1,4)*P(3,5)*P(5,3)*Metric(2,4) + P(1,2)*P(3,4)*P(4,3)*Metric(2,5) - P(1,5)*P(3,4)*P(4,3)*Metric(2,5) - P(-1,3)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,3)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) - P(-1,3)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) + P(-1,3)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,3)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,4)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,4)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) - P(-1,4)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) + P(-1,4)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5)')

VVSSSS1 = Lorentz(name = 'VVSSSS1',
                  spins = [ 3, 3, 1, 1, 1, 1 ],
                  structure = 'P(1,4)*P(2,3) + P(1,5)*P(2,3) + P(1,6)*P(2,3) + P(1,3)*P(2,4) + P(1,5)*P(2,4) + P(1,6)*P(2,4) + P(1,3)*P(2,5) + P(1,4)*P(2,5) + P(1,6)*P(2,5) + P(1,3)*P(2,6) + P(1,4)*P(2,6) + P(1,5)*P(2,6)')

VVSSSS2 = Lorentz(name = 'VVSSSS2',
                  spins = [ 3, 3, 1, 1, 1, 1 ],
                  structure = 'P(1,4)*P(2,3) + P(1,5)*P(2,3) + P(1,6)*P(2,3) + P(1,3)*P(2,4) + P(1,5)*P(2,4) + P(1,6)*P(2,4) + P(1,3)*P(2,5) + P(1,4)*P(2,5) + P(1,6)*P(2,5) + P(1,3)*P(2,6) + P(1,4)*P(2,6) + P(1,5)*P(2,6) - P(-1,3)*P(-1,4)*Metric(1,2) - P(-1,3)*P(-1,5)*Metric(1,2) - P(-1,4)*P(-1,5)*Metric(1,2) - P(-1,3)*P(-1,6)*Metric(1,2) - P(-1,4)*P(-1,6)*Metric(1,2) - P(-1,5)*P(-1,6)*Metric(1,2)')

VVSSSS3 = Lorentz(name = 'VVSSSS3',
                  spins = [ 3, 3, 1, 1, 1, 1 ],
                  structure = 'P(-1,3)*P(-1,4)*Metric(1,2) + P(-1,3)*P(-1,5)*Metric(1,2) + P(-1,4)*P(-1,5)*Metric(1,2) + P(-1,3)*P(-1,6)*Metric(1,2) + P(-1,4)*P(-1,6)*Metric(1,2) + P(-1,5)*P(-1,6)*Metric(1,2)')

VVVSSS1 = Lorentz(name = 'VVVSSS1',
                  spins = [ 3, 3, 3, 1, 1, 1 ],
                  structure = 'P(2,4)*Metric(1,3) + P(2,5)*Metric(1,3) + P(2,6)*Metric(1,3) - P(1,4)*Metric(2,3) - P(1,5)*Metric(2,3) - P(1,6)*Metric(2,3)')

VVVVSS1 = Lorentz(name = 'VVVVSS1',
                  spins = [ 3, 3, 3, 3, 1, 1 ],
                  structure = 'P(1,4)*P(4,1)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3)')

VVVVSS2 = Lorentz(name = 'VVVVSS2',
                  spins = [ 3, 3, 3, 3, 1, 1 ],
                  structure = 'Metric(1,4)*Metric(2,3) + Metric(1,3)*Metric(2,4)')

VVVVSS3 = Lorentz(name = 'VVVVSS3',
                  spins = [ 3, 3, 3, 3, 1, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)')

VVVVSS4 = Lorentz(name = 'VVVVSS4',
                  spins = [ 3, 3, 3, 3, 1, 1 ],
                  structure = 'P(2,4)*P(4,2)*Metric(1,3) + P(2,3)*P(3,2)*Metric(1,4) + P(1,4)*P(4,1)*Metric(2,3) - P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4)')

VVVVSS5 = Lorentz(name = 'VVVVSS5',
                  spins = [ 3, 3, 3, 3, 1, 1 ],
                  structure = 'Metric(1,2)*Metric(3,4)')

VVVVSS6 = Lorentz(name = 'VVVVSS6',
                  spins = [ 3, 3, 3, 3, 1, 1 ],
                  structure = 'P(2,4)*P(4,3)*Metric(1,3) + P(2,3)*P(3,4)*Metric(1,4) + P(1,4)*P(4,3)*Metric(2,3) - P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,4)*Metric(2,4) - P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,4)*P(2,3)*Metric(3,4) - P(1,3)*P(2,4)*Metric(3,4)')

VVVVSS7 = Lorentz(name = 'VVVVSS7',
                  spins = [ 3, 3, 3, 3, 1, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) + 4*P(3,6)*P(4,5)*Metric(1,2) + 4*P(3,5)*P(4,6)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - 2*P(2,6)*P(4,5)*Metric(1,3) - 2*P(2,5)*P(4,6)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - 2*P(2,6)*P(3,5)*Metric(1,4) - 2*P(2,5)*P(3,6)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - 2*P(1,6)*P(4,5)*Metric(2,3) - 2*P(1,5)*P(4,6)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - 2*P(1,6)*P(3,5)*Metric(2,4) - 2*P(1,5)*P(3,6)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + 4*P(1,6)*P(2,5)*Metric(3,4) + 4*P(1,5)*P(2,6)*Metric(3,4)')

VVVVSS8 = Lorentz(name = 'VVVVSS8',
                  spins = [ 3, 3, 3, 3, 1, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) + 4*P(3,6)*P(4,5)*Metric(1,2) + 4*P(3,5)*P(4,6)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - 2*P(2,6)*P(4,5)*Metric(1,3) - 2*P(2,5)*P(4,6)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - 2*P(2,6)*P(3,5)*Metric(1,4) - 2*P(2,5)*P(3,6)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) - 2*P(1,6)*P(4,5)*Metric(2,3) - 2*P(1,5)*P(4,6)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) - 2*P(1,6)*P(3,5)*Metric(2,4) - 2*P(1,5)*P(3,6)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,4)*P(2,3)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) + 4*P(1,6)*P(2,5)*Metric(3,4) + 4*P(1,5)*P(2,6)*Metric(3,4)')

VVVVSS9 = Lorentz(name = 'VVVVSS9',
                  spins = [ 3, 3, 3, 3, 1, 1 ],
                  structure = 'Metric(1,4)*Metric(2,3) + Metric(1,3)*Metric(2,4) + Metric(1,2)*Metric(3,4)')

VVVVSS10 = Lorentz(name = 'VVVVSS10',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,5)*P(4,1)*Metric(1,2) + P(3,6)*P(4,1)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,6)*P(4,2)*Metric(1,2) + P(3,1)*P(4,5)*Metric(1,2) + P(3,2)*P(4,5)*Metric(1,2) + P(3,1)*P(4,6)*Metric(1,2) + P(3,2)*P(4,6)*Metric(1,2) - P(2,1)*P(4,5)*Metric(1,3) - P(2,1)*P(4,6)*Metric(1,3) - P(2,1)*P(3,5)*Metric(1,4) - P(2,1)*P(3,6)*Metric(1,4) - P(1,2)*P(4,5)*Metric(2,3) - P(1,2)*P(4,6)*Metric(2,3) - P(1,2)*P(3,5)*Metric(2,4) - P(1,2)*P(3,6)*Metric(2,4) + 2*P(1,2)*P(2,1)*Metric(3,4) - 2*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVVSS11 = Lorentz(name = 'VVVVSS11',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(1,2)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVVSS12 = Lorentz(name = 'VVVVSS12',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(1,4)*P(4,1)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(1,2)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVVSS13 = Lorentz(name = 'VVVVSS13',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,5)*P(4,1)*Metric(1,2) + P(3,6)*P(4,1)*Metric(1,2) + P(2,5)*P(4,1)*Metric(1,3) + P(2,6)*P(4,1)*Metric(1,3) - P(2,5)*P(3,1)*Metric(1,4) - P(2,6)*P(3,1)*Metric(1,4) - P(2,1)*P(3,5)*Metric(1,4) - P(2,1)*P(3,6)*Metric(1,4) - P(1,4)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(1,2)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVVSS14 = Lorentz(name = 'VVVVSS14',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(2,5)*P(3,4)*Metric(1,4) + P(2,6)*P(3,4)*Metric(1,4) + P(2,4)*P(3,5)*Metric(1,4) + P(2,4)*P(3,6)*Metric(1,4) + P(1,4)*P(4,1)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,1)*Metric(2,4) - P(1,4)*P(3,5)*Metric(2,4) - P(1,4)*P(3,6)*Metric(2,4) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(1,2)*P(2,1)*Metric(3,4) - P(1,4)*P(2,5)*Metric(3,4) - P(1,4)*P(2,6)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVVSS15 = Lorentz(name = 'VVVVSS15',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,4)*P(4,1)*Metric(1,2) + P(2,4)*P(4,1)*Metric(1,3) - P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) + P(1,4)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,4)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVSS16 = Lorentz(name = 'VVVVSS16',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,4)*P(4,1)*Metric(1,2) + 2*P(3,6)*P(4,5)*Metric(1,2) + 2*P(3,5)*P(4,6)*Metric(1,2) + P(2,4)*P(4,1)*Metric(1,3) + 2*P(2,6)*P(4,5)*Metric(1,3) + 2*P(2,5)*P(4,6)*Metric(1,3) - P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - 4*P(2,6)*P(3,5)*Metric(1,4) - 4*P(2,5)*P(3,6)*Metric(1,4) - 4*P(1,6)*P(4,5)*Metric(2,3) - 4*P(1,5)*P(4,6)*Metric(2,3) + P(1,4)*P(3,1)*Metric(2,4) + 2*P(1,6)*P(3,5)*Metric(2,4) + 2*P(1,5)*P(3,6)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,4)*P(2,1)*Metric(3,4) + 2*P(1,6)*P(2,5)*Metric(3,4) + 2*P(1,5)*P(2,6)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVSS17 = Lorentz(name = 'VVVVSS17',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVSS18 = Lorentz(name = 'VVVVSS18',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,4)*P(4,1)*Metric(1,2) + P(3,4)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) - P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) + P(2,3)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) + P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) + P(2,4)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) + P(1,3)*P(4,1)*Metric(2,3) - P(1,3)*P(4,2)*Metric(2,3) + P(1,4)*P(4,2)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,4)*P(3,1)*Metric(2,4) + P(1,3)*P(3,2)*Metric(2,4) - P(1,4)*P(3,2)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVSS19 = Lorentz(name = 'VVVVSS19',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,4)*P(4,1)*Metric(1,2) + P(3,4)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) + 4*P(3,6)*P(4,5)*Metric(1,2) + 4*P(3,5)*P(4,6)*Metric(1,2) - P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) + P(2,3)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) - 2*P(2,6)*P(4,5)*Metric(1,3) - 2*P(2,5)*P(4,6)*Metric(1,3) + P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) + P(2,4)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - 2*P(2,6)*P(3,5)*Metric(1,4) - 2*P(2,5)*P(3,6)*Metric(1,4) + P(1,3)*P(4,1)*Metric(2,3) - P(1,3)*P(4,2)*Metric(2,3) + P(1,4)*P(4,2)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - 2*P(1,6)*P(4,5)*Metric(2,3) - 2*P(1,5)*P(4,6)*Metric(2,3) - P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,4)*P(3,1)*Metric(2,4) + P(1,3)*P(3,2)*Metric(2,4) - P(1,4)*P(3,2)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - 2*P(1,6)*P(3,5)*Metric(2,4) - 2*P(1,5)*P(3,6)*Metric(2,4) - P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) + 4*P(1,6)*P(2,5)*Metric(3,4) + 4*P(1,5)*P(2,6)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVSS20 = Lorentz(name = 'VVVVSS20',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,4)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) - P(3,2)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,4)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(1,3)*P(4,2)*Metric(2,3) - P(1,4)*P(4,2)*Metric(2,3) + P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) - P(1,3)*P(3,2)*Metric(2,4) + P(1,4)*P(3,2)*Metric(2,4) + P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) - P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) - P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVSS21 = Lorentz(name = 'VVVVSS21',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,4)*P(4,3)*Metric(1,2) - P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVSS22 = Lorentz(name = 'VVVVSS22',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,4)*P(4,3)*Metric(1,2) - (P(2,4)*P(4,2)*Metric(1,3))/2. - (P(2,5)*P(4,3)*Metric(1,3))/2. - (P(2,6)*P(4,3)*Metric(1,3))/2. - (P(2,3)*P(3,2)*Metric(1,4))/2. - (P(2,5)*P(3,4)*Metric(1,4))/2. - (P(2,6)*P(3,4)*Metric(1,4))/2. - (P(1,4)*P(4,1)*Metric(2,3))/2. - (P(1,5)*P(4,3)*Metric(2,3))/2. - (P(1,6)*P(4,3)*Metric(2,3))/2. + (P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3))/2. - (P(1,3)*P(3,1)*Metric(2,4))/2. - (P(1,5)*P(3,4)*Metric(2,4))/2. - (P(1,6)*P(3,4)*Metric(2,4))/2. + (P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4))/2. + (P(1,5)*P(2,3)*Metric(3,4))/2. + (P(1,6)*P(2,3)*Metric(3,4))/2. + (P(1,5)*P(2,4)*Metric(3,4))/2. + (P(1,6)*P(2,4)*Metric(3,4))/2. + (P(1,3)*P(2,5)*Metric(3,4))/2. + (P(1,4)*P(2,5)*Metric(3,4))/2. + (P(1,3)*P(2,6)*Metric(3,4))/2. + (P(1,4)*P(2,6)*Metric(3,4))/2. - P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVSS23 = Lorentz(name = 'VVVVSS23',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,4)*P(4,3)*Metric(1,2) + P(2,4)*P(4,2)*Metric(1,3) + P(2,3)*P(3,2)*Metric(1,4) + P(1,4)*P(4,1)*Metric(2,3) - P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,2)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVSS24 = Lorentz(name = 'VVVVSS24',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,4)*P(4,1)*Metric(1,2) - P(3,5)*P(4,1)*Metric(1,2) - P(3,6)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) - P(2,5)*P(4,1)*Metric(1,3) - P(2,6)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) + P(2,5)*P(3,1)*Metric(1,4) + P(2,6)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) + P(2,1)*P(3,5)*Metric(1,4) + P(2,1)*P(3,6)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) - 2*P(1,5)*P(4,1)*Metric(2,3) - 2*P(1,6)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + 2*P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) + 2*P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) + P(1,4)*P(3,1)*Metric(2,4) + P(1,5)*P(3,1)*Metric(2,4) + P(1,6)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,5)*P(2,1)*Metric(3,4) + P(1,6)*P(2,1)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS25 = Lorentz(name = 'VVVVSS25',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,5)*P(4,1)*Metric(1,2) + P(3,6)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,6)*P(4,2)*Metric(1,2) + P(3,1)*P(4,5)*Metric(1,2) + P(3,2)*P(4,5)*Metric(1,2) + 4*P(3,6)*P(4,5)*Metric(1,2) + P(3,1)*P(4,6)*Metric(1,2) + P(3,2)*P(4,6)*Metric(1,2) + 4*P(3,5)*P(4,6)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - P(2,5)*P(4,2)*Metric(1,3) - P(2,6)*P(4,2)*Metric(1,3) - P(2,1)*P(4,5)*Metric(1,3) - 2*P(2,6)*P(4,5)*Metric(1,3) - P(2,1)*P(4,6)*Metric(1,3) - 2*P(2,5)*P(4,6)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - P(2,5)*P(3,2)*Metric(1,4) - P(2,6)*P(3,2)*Metric(1,4) - P(2,1)*P(3,5)*Metric(1,4) - 2*P(2,6)*P(3,5)*Metric(1,4) - P(2,1)*P(3,6)*Metric(1,4) - 2*P(2,5)*P(3,6)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,5)*P(4,1)*Metric(2,3) - P(1,6)*P(4,1)*Metric(2,3) - P(1,2)*P(4,5)*Metric(2,3) - 2*P(1,6)*P(4,5)*Metric(2,3) - P(1,2)*P(4,6)*Metric(2,3) - 2*P(1,5)*P(4,6)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,5)*P(3,1)*Metric(2,4) - P(1,6)*P(3,1)*Metric(2,4) - P(1,2)*P(3,5)*Metric(2,4) - 2*P(1,6)*P(3,5)*Metric(2,4) - P(1,2)*P(3,6)*Metric(2,4) - 2*P(1,5)*P(3,6)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4) + 2*P(1,5)*P(2,1)*Metric(3,4) + 2*P(1,6)*P(2,1)*Metric(3,4) + 2*P(1,2)*P(2,5)*Metric(3,4) + 4*P(1,6)*P(2,5)*Metric(3,4) + 2*P(1,2)*P(2,6)*Metric(3,4) + 4*P(1,5)*P(2,6)*Metric(3,4) - 2*P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4) - 2*P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS26 = Lorentz(name = 'VVVVSS26',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,1)*P(4,2)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,6)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) + P(2,5)*P(4,3)*Metric(1,3) + P(2,6)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,5)*P(3,2)*Metric(1,4) - P(2,6)*P(3,2)*Metric(1,4) - P(2,3)*P(3,5)*Metric(1,4) - P(2,3)*P(3,6)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) - P(1,5)*P(4,2)*Metric(2,3) - P(1,6)*P(4,2)*Metric(2,3) - P(1,5)*P(4,3)*Metric(2,3) - P(1,6)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(1,2)*P(3,1)*Metric(2,4) + P(1,5)*P(3,2)*Metric(2,4) + P(1,6)*P(3,2)*Metric(2,4) - P(1,2)*P(3,5)*Metric(2,4) + P(1,3)*P(3,5)*Metric(2,4) - P(1,2)*P(3,6)*Metric(2,4) + P(1,3)*P(3,6)*Metric(2,4) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,5)*P(2,3)*Metric(3,4) + P(1,6)*P(2,3)*Metric(3,4) + P(1,2)*P(2,5)*Metric(3,4) - P(1,3)*P(2,5)*Metric(3,4) + P(1,2)*P(2,6)*Metric(3,4) - P(1,3)*P(2,6)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS27 = Lorentz(name = 'VVVVSS27',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) - (P(3,5)*P(4,1)*Metric(1,2))/2. - (P(3,6)*P(4,1)*Metric(1,2))/2. + P(3,1)*P(4,2)*Metric(1,2) - (P(3,5)*P(4,2)*Metric(1,2))/2. - (P(3,6)*P(4,2)*Metric(1,2))/2. - (P(3,1)*P(4,5)*Metric(1,2))/2. - (P(3,2)*P(4,5)*Metric(1,2))/2. - (P(3,1)*P(4,6)*Metric(1,2))/2. - (P(3,2)*P(4,6)*Metric(1,2))/2. - P(2,1)*P(4,2)*Metric(1,3) - (P(2,5)*P(4,2)*Metric(1,3))/2. - (P(2,6)*P(4,2)*Metric(1,3))/2. + (P(2,1)*P(4,5)*Metric(1,3))/2. + (P(2,1)*P(4,6)*Metric(1,3))/2. - P(2,1)*P(3,2)*Metric(1,4) - (P(2,5)*P(3,2)*Metric(1,4))/2. - (P(2,6)*P(3,2)*Metric(1,4))/2. + (P(2,1)*P(3,5)*Metric(1,4))/2. + (P(2,1)*P(3,6)*Metric(1,4))/2. - P(1,2)*P(4,1)*Metric(2,3) - (P(1,5)*P(4,1)*Metric(2,3))/2. - (P(1,6)*P(4,1)*Metric(2,3))/2. + (P(1,2)*P(4,5)*Metric(2,3))/2. + (P(1,2)*P(4,6)*Metric(2,3))/2. + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. - P(1,2)*P(3,1)*Metric(2,4) - (P(1,5)*P(3,1)*Metric(2,4))/2. - (P(1,6)*P(3,1)*Metric(2,4))/2. + (P(1,2)*P(3,5)*Metric(2,4))/2. + (P(1,2)*P(3,6)*Metric(2,4))/2. + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + P(1,5)*P(2,1)*Metric(3,4) + P(1,6)*P(2,1)*Metric(3,4) + P(1,2)*P(2,5)*Metric(3,4) + P(1,2)*P(2,6)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS28 = Lorentz(name = 'VVVVSS28',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) + (P(3,4)*P(4,1)*Metric(1,2))/2. + (P(3,5)*P(4,1)*Metric(1,2))/2. + (P(3,6)*P(4,1)*Metric(1,2))/2. + P(3,1)*P(4,2)*Metric(1,2) + (P(3,4)*P(4,2)*Metric(1,2))/2. + (P(3,5)*P(4,2)*Metric(1,2))/2. + (P(3,6)*P(4,2)*Metric(1,2))/2. + (P(3,1)*P(4,3)*Metric(1,2))/2. + (P(3,2)*P(4,3)*Metric(1,2))/2. + (P(3,1)*P(4,5)*Metric(1,2))/2. + (P(3,2)*P(4,5)*Metric(1,2))/2. + (P(3,1)*P(4,6)*Metric(1,2))/2. + (P(3,2)*P(4,6)*Metric(1,2))/2. + (P(2,3)*P(4,1)*Metric(1,3))/2. - (P(2,4)*P(4,1)*Metric(1,3))/2. - P(2,1)*P(4,2)*Metric(1,3) - (P(2,3)*P(4,2)*Metric(1,3))/2. - (P(2,5)*P(4,2)*Metric(1,3))/2. - (P(2,6)*P(4,2)*Metric(1,3))/2. - (P(2,1)*P(4,3)*Metric(1,3))/2. - (P(2,1)*P(4,5)*Metric(1,3))/2. - (P(2,1)*P(4,6)*Metric(1,3))/2. - (P(2,3)*P(3,1)*Metric(1,4))/2. + (P(2,4)*P(3,1)*Metric(1,4))/2. - P(2,1)*P(3,2)*Metric(1,4) - (P(2,4)*P(3,2)*Metric(1,4))/2. - (P(2,5)*P(3,2)*Metric(1,4))/2. - (P(2,6)*P(3,2)*Metric(1,4))/2. - (P(2,1)*P(3,4)*Metric(1,4))/2. - (P(2,1)*P(3,5)*Metric(1,4))/2. - (P(2,1)*P(3,6)*Metric(1,4))/2. - P(1,2)*P(4,1)*Metric(2,3) - (P(1,3)*P(4,1)*Metric(2,3))/2. - (P(1,5)*P(4,1)*Metric(2,3))/2. - (P(1,6)*P(4,1)*Metric(2,3))/2. + (P(1,3)*P(4,2)*Metric(2,3))/2. - (P(1,4)*P(4,2)*Metric(2,3))/2. - (P(1,2)*P(4,3)*Metric(2,3))/2. - (P(1,2)*P(4,5)*Metric(2,3))/2. - (P(1,2)*P(4,6)*Metric(2,3))/2. + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + (P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. - P(1,2)*P(3,1)*Metric(2,4) - (P(1,4)*P(3,1)*Metric(2,4))/2. - (P(1,5)*P(3,1)*Metric(2,4))/2. - (P(1,6)*P(3,1)*Metric(2,4))/2. - (P(1,3)*P(3,2)*Metric(2,4))/2. + (P(1,4)*P(3,2)*Metric(2,4))/2. - (P(1,2)*P(3,4)*Metric(2,4))/2. - (P(1,2)*P(3,5)*Metric(2,4))/2. - (P(1,2)*P(3,6)*Metric(2,4))/2. + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + (P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + (P(1,3)*P(2,1)*Metric(3,4))/2. + (P(1,4)*P(2,1)*Metric(3,4))/2. + P(1,5)*P(2,1)*Metric(3,4) + P(1,6)*P(2,1)*Metric(3,4) + (P(1,2)*P(2,3)*Metric(3,4))/2. + (P(1,2)*P(2,4)*Metric(3,4))/2. + P(1,2)*P(2,5)*Metric(3,4) + P(1,2)*P(2,6)*Metric(3,4) - (P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4))/2. - (P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4))/2. - (P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4))/2. - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS29 = Lorentz(name = 'VVVVSS29',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,4)*P(4,1)*Metric(1,2) + P(3,4)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) + 2*P(3,5)*P(4,3)*Metric(1,2) + 2*P(3,6)*P(4,3)*Metric(1,2) + 2*P(3,4)*P(4,5)*Metric(1,2) + 2*P(3,4)*P(4,6)*Metric(1,2) - P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) + P(2,3)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) - 2*P(2,4)*P(4,3)*Metric(1,3) + P(2,5)*P(4,3)*Metric(1,3) + P(2,6)*P(4,3)*Metric(1,3) - P(2,4)*P(4,5)*Metric(1,3) - P(2,4)*P(4,6)*Metric(1,3) + P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) + P(2,4)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - 2*P(2,3)*P(3,4)*Metric(1,4) + P(2,5)*P(3,4)*Metric(1,4) + P(2,6)*P(3,4)*Metric(1,4) - P(2,3)*P(3,5)*Metric(1,4) - P(2,3)*P(3,6)*Metric(1,4) + P(1,3)*P(4,1)*Metric(2,3) - P(1,3)*P(4,2)*Metric(2,3) + P(1,4)*P(4,2)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - 2*P(1,4)*P(4,3)*Metric(2,3) + P(1,5)*P(4,3)*Metric(2,3) + P(1,6)*P(4,3)*Metric(2,3) - P(1,4)*P(4,5)*Metric(2,3) - P(1,4)*P(4,6)*Metric(2,3) - P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + 2*P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(1,4)*P(3,1)*Metric(2,4) + P(1,3)*P(3,2)*Metric(2,4) - P(1,4)*P(3,2)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - 2*P(1,3)*P(3,4)*Metric(2,4) + P(1,5)*P(3,4)*Metric(2,4) + P(1,6)*P(3,4)*Metric(2,4) - P(1,3)*P(3,5)*Metric(2,4) - P(1,3)*P(3,6)*Metric(2,4) - P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + 2*P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + 2*P(1,4)*P(2,3)*Metric(3,4) - P(1,5)*P(2,3)*Metric(3,4) - P(1,6)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) + 2*P(1,3)*P(2,4)*Metric(3,4) - P(1,5)*P(2,4)*Metric(3,4) - P(1,6)*P(2,4)*Metric(3,4) - P(1,3)*P(2,5)*Metric(3,4) - P(1,4)*P(2,5)*Metric(3,4) - P(1,3)*P(2,6)*Metric(3,4) - P(1,4)*P(2,6)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4) - 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4) - 2*P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS30 = Lorentz(name = 'VVVVSS30',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,4)*P(4,1)*Metric(1,2) + P(3,5)*P(4,1)*Metric(1,2) + P(3,6)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) + P(3,4)*P(4,2)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,6)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) + 2*P(3,5)*P(4,3)*Metric(1,2) + 2*P(3,6)*P(4,3)*Metric(1,2) + P(3,1)*P(4,5)*Metric(1,2) + P(3,2)*P(4,5)*Metric(1,2) + 2*P(3,4)*P(4,5)*Metric(1,2) + 4*P(3,6)*P(4,5)*Metric(1,2) + P(3,1)*P(4,6)*Metric(1,2) + P(3,2)*P(4,6)*Metric(1,2) + 2*P(3,4)*P(4,6)*Metric(1,2) + 4*P(3,5)*P(4,6)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(4,2)*Metric(1,3) - P(2,5)*P(4,2)*Metric(1,3) - P(2,6)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,5)*P(4,3)*Metric(1,3) - P(2,6)*P(4,3)*Metric(1,3) - P(2,1)*P(4,5)*Metric(1,3) - P(2,4)*P(4,5)*Metric(1,3) - 2*P(2,6)*P(4,5)*Metric(1,3) - P(2,1)*P(4,6)*Metric(1,3) - P(2,4)*P(4,6)*Metric(1,3) - 2*P(2,5)*P(4,6)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,4)*P(3,2)*Metric(1,4) - P(2,5)*P(3,2)*Metric(1,4) - P(2,6)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(2,5)*P(3,4)*Metric(1,4) - P(2,6)*P(3,4)*Metric(1,4) - P(2,1)*P(3,5)*Metric(1,4) - P(2,3)*P(3,5)*Metric(1,4) - 2*P(2,6)*P(3,5)*Metric(1,4) - P(2,1)*P(3,6)*Metric(1,4) - P(2,3)*P(3,6)*Metric(1,4) - 2*P(2,5)*P(3,6)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) - P(1,5)*P(4,1)*Metric(2,3) - P(1,6)*P(4,1)*Metric(2,3) + P(1,3)*P(4,2)*Metric(2,3) - P(1,4)*P(4,2)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) - P(1,5)*P(4,3)*Metric(2,3) - P(1,6)*P(4,3)*Metric(2,3) - P(1,2)*P(4,5)*Metric(2,3) - P(1,4)*P(4,5)*Metric(2,3) - 2*P(1,6)*P(4,5)*Metric(2,3) - P(1,2)*P(4,6)*Metric(2,3) - P(1,4)*P(4,6)*Metric(2,3) - 2*P(1,5)*P(4,6)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) - P(1,5)*P(3,1)*Metric(2,4) - P(1,6)*P(3,1)*Metric(2,4) - P(1,3)*P(3,2)*Metric(2,4) + P(1,4)*P(3,2)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) - P(1,5)*P(3,4)*Metric(2,4) - P(1,6)*P(3,4)*Metric(2,4) - P(1,2)*P(3,5)*Metric(2,4) - P(1,3)*P(3,5)*Metric(2,4) - 2*P(1,6)*P(3,5)*Metric(2,4) - P(1,2)*P(3,6)*Metric(2,4) - P(1,3)*P(3,6)*Metric(2,4) - 2*P(1,5)*P(3,6)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + 2*P(1,5)*P(2,1)*Metric(3,4) + 2*P(1,6)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) + P(1,5)*P(2,3)*Metric(3,4) + P(1,6)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) + P(1,5)*P(2,4)*Metric(3,4) + P(1,6)*P(2,4)*Metric(3,4) + 2*P(1,2)*P(2,5)*Metric(3,4) + P(1,3)*P(2,5)*Metric(3,4) + P(1,4)*P(2,5)*Metric(3,4) + 4*P(1,6)*P(2,5)*Metric(3,4) + 2*P(1,2)*P(2,6)*Metric(3,4) + P(1,3)*P(2,6)*Metric(3,4) + P(1,4)*P(2,6)*Metric(3,4) + 4*P(1,5)*P(2,6)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4) - 2*P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4) - 2*P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4) - 2*P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4) - 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4) - 2*P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS31 = Lorentz(name = 'VVVVSS31',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,4)*P(4,1)*Metric(1,2) + P(3,5)*P(4,1)*Metric(1,2) + P(3,6)*P(4,1)*Metric(1,2) - P(3,1)*P(4,2)*Metric(1,2) + P(3,5)*P(4,2)*Metric(1,2) + P(3,6)*P(4,2)*Metric(1,2) + P(3,1)*P(4,3)*Metric(1,2) + P(3,4)*P(4,5)*Metric(1,2) + 2*P(3,6)*P(4,5)*Metric(1,2) + P(3,4)*P(4,6)*Metric(1,2) + 2*P(3,5)*P(4,6)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) + P(2,5)*P(4,1)*Metric(1,3) + P(2,6)*P(4,1)*Metric(1,3) + P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(4,3)*Metric(1,3) + P(2,5)*P(4,3)*Metric(1,3) + P(2,6)*P(4,3)*Metric(1,3) + P(2,4)*P(4,5)*Metric(1,3) + 2*P(2,6)*P(4,5)*Metric(1,3) + P(2,4)*P(4,6)*Metric(1,3) + 2*P(2,5)*P(4,6)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) - P(2,5)*P(3,1)*Metric(1,4) - P(2,6)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,5)*P(3,2)*Metric(1,4) - P(2,6)*P(3,2)*Metric(1,4) - P(2,1)*P(3,4)*Metric(1,4) - P(2,5)*P(3,4)*Metric(1,4) - P(2,6)*P(3,4)*Metric(1,4) - P(2,1)*P(3,5)*Metric(1,4) - P(2,3)*P(3,5)*Metric(1,4) - P(2,4)*P(3,5)*Metric(1,4) - 4*P(2,6)*P(3,5)*Metric(1,4) - P(2,1)*P(3,6)*Metric(1,4) - P(2,3)*P(3,6)*Metric(1,4) - P(2,4)*P(3,6)*Metric(1,4) - 4*P(2,5)*P(3,6)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) - 2*P(1,5)*P(4,1)*Metric(2,3) - 2*P(1,6)*P(4,1)*Metric(2,3) - P(1,5)*P(4,2)*Metric(2,3) - P(1,6)*P(4,2)*Metric(2,3) - P(1,5)*P(4,3)*Metric(2,3) - P(1,6)*P(4,3)*Metric(2,3) - 2*P(1,4)*P(4,5)*Metric(2,3) - 4*P(1,6)*P(4,5)*Metric(2,3) - 2*P(1,4)*P(4,6)*Metric(2,3) - 4*P(1,5)*P(4,6)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + 2*P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3) + 2*P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3) + 2*P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3) + 2*P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(1,2)*P(3,1)*Metric(2,4) + P(1,4)*P(3,1)*Metric(2,4) + P(1,5)*P(3,1)*Metric(2,4) + P(1,6)*P(3,1)*Metric(2,4) + P(1,5)*P(3,2)*Metric(2,4) + P(1,6)*P(3,2)*Metric(2,4) - P(1,2)*P(3,5)*Metric(2,4) + P(1,3)*P(3,5)*Metric(2,4) + P(1,4)*P(3,5)*Metric(2,4) + 2*P(1,6)*P(3,5)*Metric(2,4) - P(1,2)*P(3,6)*Metric(2,4) + P(1,3)*P(3,6)*Metric(2,4) + P(1,4)*P(3,6)*Metric(2,4) + 2*P(1,5)*P(3,6)*Metric(2,4) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4) - P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4) - P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,5)*P(2,1)*Metric(3,4) + P(1,6)*P(2,1)*Metric(3,4) + P(1,5)*P(2,3)*Metric(3,4) + P(1,6)*P(2,3)*Metric(3,4) + P(1,2)*P(2,5)*Metric(3,4) - P(1,3)*P(2,5)*Metric(3,4) + P(1,4)*P(2,5)*Metric(3,4) + 2*P(1,6)*P(2,5)*Metric(3,4) + P(1,2)*P(2,6)*Metric(3,4) - P(1,3)*P(2,6)*Metric(3,4) + P(1,4)*P(2,6)*Metric(3,4) + 2*P(1,5)*P(2,6)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS32 = Lorentz(name = 'VVVVSS32',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,4)*P(4,1)*Metric(1,2) + (P(3,5)*P(4,1)*Metric(1,2))/2. + (P(3,6)*P(4,1)*Metric(1,2))/2. + P(3,4)*P(4,2)*Metric(1,2) + (P(3,5)*P(4,2)*Metric(1,2))/2. + (P(3,6)*P(4,2)*Metric(1,2))/2. + P(3,1)*P(4,3)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) + P(3,5)*P(4,3)*Metric(1,2) + P(3,6)*P(4,3)*Metric(1,2) + (P(3,1)*P(4,5)*Metric(1,2))/2. + (P(3,2)*P(4,5)*Metric(1,2))/2. + P(3,4)*P(4,5)*Metric(1,2) + 2*P(3,6)*P(4,5)*Metric(1,2) + (P(3,1)*P(4,6)*Metric(1,2))/2. + (P(3,2)*P(4,6)*Metric(1,2))/2. + P(3,4)*P(4,6)*Metric(1,2) + 2*P(3,5)*P(4,6)*Metric(1,2) - (P(2,5)*P(4,2)*Metric(1,3))/2. - (P(2,6)*P(4,2)*Metric(1,3))/2. - P(2,1)*P(4,3)*Metric(1,3) - (P(2,5)*P(4,3)*Metric(1,3))/2. - (P(2,6)*P(4,3)*Metric(1,3))/2. - (P(2,1)*P(4,5)*Metric(1,3))/2. - (P(2,4)*P(4,5)*Metric(1,3))/2. - P(2,6)*P(4,5)*Metric(1,3) - (P(2,1)*P(4,6)*Metric(1,3))/2. - (P(2,4)*P(4,6)*Metric(1,3))/2. - P(2,5)*P(4,6)*Metric(1,3) - (P(2,5)*P(3,2)*Metric(1,4))/2. - (P(2,6)*P(3,2)*Metric(1,4))/2. - P(2,1)*P(3,4)*Metric(1,4) - (P(2,5)*P(3,4)*Metric(1,4))/2. - (P(2,6)*P(3,4)*Metric(1,4))/2. - (P(2,1)*P(3,5)*Metric(1,4))/2. - (P(2,3)*P(3,5)*Metric(1,4))/2. - P(2,6)*P(3,5)*Metric(1,4) - (P(2,1)*P(3,6)*Metric(1,4))/2. - (P(2,3)*P(3,6)*Metric(1,4))/2. - P(2,5)*P(3,6)*Metric(1,4) - (P(1,5)*P(4,1)*Metric(2,3))/2. - (P(1,6)*P(4,1)*Metric(2,3))/2. - P(1,2)*P(4,3)*Metric(2,3) - (P(1,5)*P(4,3)*Metric(2,3))/2. - (P(1,6)*P(4,3)*Metric(2,3))/2. - (P(1,2)*P(4,5)*Metric(2,3))/2. - (P(1,4)*P(4,5)*Metric(2,3))/2. - P(1,6)*P(4,5)*Metric(2,3) - (P(1,2)*P(4,6)*Metric(2,3))/2. - (P(1,4)*P(4,6)*Metric(2,3))/2. - P(1,5)*P(4,6)*Metric(2,3) + (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. + (P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. + (P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. - (P(1,5)*P(3,1)*Metric(2,4))/2. - (P(1,6)*P(3,1)*Metric(2,4))/2. - P(1,2)*P(3,4)*Metric(2,4) - (P(1,5)*P(3,4)*Metric(2,4))/2. - (P(1,6)*P(3,4)*Metric(2,4))/2. - (P(1,2)*P(3,5)*Metric(2,4))/2. - (P(1,3)*P(3,5)*Metric(2,4))/2. - P(1,6)*P(3,5)*Metric(2,4) - (P(1,2)*P(3,6)*Metric(2,4))/2. - (P(1,3)*P(3,6)*Metric(2,4))/2. - P(1,5)*P(3,6)*Metric(2,4) + (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + (P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + (P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + P(1,3)*P(2,1)*Metric(3,4) + P(1,4)*P(2,1)*Metric(3,4) + P(1,5)*P(2,1)*Metric(3,4) + P(1,6)*P(2,1)*Metric(3,4) + P(1,2)*P(2,3)*Metric(3,4) + (P(1,5)*P(2,3)*Metric(3,4))/2. + (P(1,6)*P(2,3)*Metric(3,4))/2. + P(1,2)*P(2,4)*Metric(3,4) + (P(1,5)*P(2,4)*Metric(3,4))/2. + (P(1,6)*P(2,4)*Metric(3,4))/2. + P(1,2)*P(2,5)*Metric(3,4) + (P(1,3)*P(2,5)*Metric(3,4))/2. + (P(1,4)*P(2,5)*Metric(3,4))/2. + 2*P(1,6)*P(2,5)*Metric(3,4) + P(1,2)*P(2,6)*Metric(3,4) + (P(1,3)*P(2,6)*Metric(3,4))/2. + (P(1,4)*P(2,6)*Metric(3,4))/2. + 2*P(1,5)*P(2,6)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS33 = Lorentz(name = 'VVVVSS33',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) - P(3,4)*P(4,5)*Metric(1,2) - P(3,4)*P(4,6)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,5)*Metric(1,3) - P(2,4)*P(4,6)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(2,5)*P(3,4)*Metric(1,4) - P(2,6)*P(3,4)*Metric(1,4) - P(2,4)*P(3,5)*Metric(1,4) - P(2,4)*P(3,6)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + 2*P(1,4)*P(4,5)*Metric(2,3) + 2*P(1,4)*P(4,6)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - 2*P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3) - 2*P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) + P(1,4)*P(3,5)*Metric(2,4) + P(1,4)*P(3,6)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) + P(1,4)*P(2,5)*Metric(3,4) + P(1,4)*P(2,6)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) + P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4) + P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS34 = Lorentz(name = 'VVVVSS34',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = '2*P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,3) + 2*P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(1,2)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4) - 4*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS35 = Lorentz(name = 'VVVVSS35',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,4)*P(4,3)*Metric(1,2) + 2*P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,3) + 2*P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(1,2)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4) - 4*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS36 = Lorentz(name = 'VVVVSS36',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(1,4)*P(4,1)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) - 4*P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,3) + 2*P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,4) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS37 = Lorentz(name = 'VVVVSS37',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(2,4)*P(4,2)*Metric(1,3) + P(2,3)*P(3,2)*Metric(1,4) + P(1,4)*P(4,1)*Metric(2,3) - P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) - 2*P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,3) + P(1,3)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4) - 2*P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,4) + 4*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVVS1 = Lorentz(name = 'VVVVVS1',
                  spins = [ 3, 3, 3, 3, 3, 1 ],
                  structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5)')

VVVVVS2 = Lorentz(name = 'VVVVVS2',
                  spins = [ 3, 3, 3, 3, 3, 1 ],
                  structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5)')

VVVVVS3 = Lorentz(name = 'VVVVVS3',
                  spins = [ 3, 3, 3, 3, 3, 1 ],
                  structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(4,3)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(2,5)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,4)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5)')

VVVVVS4 = Lorentz(name = 'VVVVVS4',
                  spins = [ 3, 3, 3, 3, 3, 1 ],
                  structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) + 4*P(3,1)*Metric(1,2)*Metric(4,5) - 4*P(2,1)*Metric(1,3)*Metric(4,5)')

VVVVVS5 = Lorentz(name = 'VVVVVS5',
                  spins = [ 3, 3, 3, 3, 3, 1 ],
                  structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(2,5)*Metric(1,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,4)*Metric(1,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(3,1)*Metric(1,2)*Metric(4,5) - 2*P(2,1)*Metric(1,3)*Metric(4,5)')

VVVVVS6 = Lorentz(name = 'VVVVVS6',
                  spins = [ 3, 3, 3, 3, 3, 1 ],
                  structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5)')

VVVVVS7 = Lorentz(name = 'VVVVVS7',
                  spins = [ 3, 3, 3, 3, 3, 1 ],
                  structure = 'P(3,5)*Metric(1,5)*Metric(2,4) + P(3,4)*Metric(1,4)*Metric(2,5) - P(2,5)*Metric(1,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) - P(2,4)*Metric(1,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5)')

VVVVVS8 = Lorentz(name = 'VVVVVS8',
                  spins = [ 3, 3, 3, 3, 3, 1 ],
                  structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - (P(5,4)*Metric(1,3)*Metric(2,4))/2. - P(3,1)*Metric(1,5)*Metric(2,4) - P(3,4)*Metric(1,5)*Metric(2,4) + (P(3,5)*Metric(1,5)*Metric(2,4))/2. + P(4,1)*Metric(1,3)*Metric(2,5) - (P(4,5)*Metric(1,3)*Metric(2,5))/2. - P(3,1)*Metric(1,4)*Metric(2,5) + (P(3,4)*Metric(1,4)*Metric(2,5))/2. - P(3,5)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + (P(5,4)*Metric(1,2)*Metric(3,4))/2. + P(2,1)*Metric(1,5)*Metric(3,4) + P(2,4)*Metric(1,5)*Metric(3,4) - (P(2,5)*Metric(1,5)*Metric(3,4))/2. - (P(1,4)*Metric(2,5)*Metric(3,4))/2. + (P(1,5)*Metric(2,5)*Metric(3,4))/2. - P(4,1)*Metric(1,2)*Metric(3,5) + (P(4,5)*Metric(1,2)*Metric(3,5))/2. + P(2,1)*Metric(1,4)*Metric(3,5) - (P(2,4)*Metric(1,4)*Metric(3,5))/2. + P(2,5)*Metric(1,4)*Metric(3,5) + (P(1,4)*Metric(2,4)*Metric(3,5))/2. - (P(1,5)*Metric(2,4)*Metric(3,5))/2. + 2*P(3,1)*Metric(1,2)*Metric(4,5) - (P(3,4)*Metric(1,2)*Metric(4,5))/2. - (P(3,5)*Metric(1,2)*Metric(4,5))/2. - 2*P(2,1)*Metric(1,3)*Metric(4,5) + (P(2,4)*Metric(1,3)*Metric(4,5))/2. + (P(2,5)*Metric(1,3)*Metric(4,5))/2.')

VVVVVS9 = Lorentz(name = 'VVVVVS9',
                  spins = [ 3, 3, 3, 3, 3, 1 ],
                  structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) - 2*P(3,4)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(4,5)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(3,5)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(5,4)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) + 2*P(2,4)*Metric(1,5)*Metric(3,4) - P(2,5)*Metric(1,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(4,5)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,4)*Metric(1,4)*Metric(3,5) + 2*P(2,5)*Metric(1,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) - P(3,4)*Metric(1,2)*Metric(4,5) - P(3,5)*Metric(1,2)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) + P(2,5)*Metric(1,3)*Metric(4,5)')

VVVVVS10 = Lorentz(name = 'VVVVVS10',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - 3*P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(5,6)*Metric(1,3)*Metric(2,4) + 3*P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - 2*P(3,4)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) - P(3,6)*Metric(1,5)*Metric(2,4) - 3*P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) + P(4,6)*Metric(1,3)*Metric(2,5) + 3*P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(3,5)*Metric(1,4)*Metric(2,5) - P(3,6)*Metric(1,4)*Metric(2,5) + 3*P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(5,4)*Metric(1,2)*Metric(3,4) - P(5,6)*Metric(1,2)*Metric(3,4) - 3*P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + 2*P(2,4)*Metric(1,5)*Metric(3,4) - P(2,5)*Metric(1,5)*Metric(3,4) + P(2,6)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) + 3*P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(4,5)*Metric(1,2)*Metric(3,5) - P(4,6)*Metric(1,2)*Metric(3,5) - 3*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - P(2,4)*Metric(1,4)*Metric(3,5) + 2*P(2,5)*Metric(1,4)*Metric(3,5) + P(2,6)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) - 4*P(3,1)*Metric(1,2)*Metric(4,5) + P(3,4)*Metric(1,2)*Metric(4,5) + P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(3,6)*Metric(1,2)*Metric(4,5) + 4*P(2,1)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(2,6)*Metric(1,3)*Metric(4,5)')

VVVVVS11 = Lorentz(name = 'VVVVVS11',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + (P(5,4)*Metric(1,3)*Metric(2,4))/2. + (P(5,6)*Metric(1,3)*Metric(2,4))/2. + 2*P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(3,4)*Metric(1,5)*Metric(2,4) + (P(3,5)*Metric(1,5)*Metric(2,4))/2. - (P(3,6)*Metric(1,5)*Metric(2,4))/2. - 2*P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + (P(4,5)*Metric(1,3)*Metric(2,5))/2. + (P(4,6)*Metric(1,3)*Metric(2,5))/2. + 2*P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + (P(3,4)*Metric(1,4)*Metric(2,5))/2. - P(3,5)*Metric(1,4)*Metric(2,5) - (P(3,6)*Metric(1,4)*Metric(2,5))/2. + 2*P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - (P(5,4)*Metric(1,2)*Metric(3,4))/2. - (P(5,6)*Metric(1,2)*Metric(3,4))/2. - 2*P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + P(2,4)*Metric(1,5)*Metric(3,4) - (P(2,5)*Metric(1,5)*Metric(3,4))/2. + (P(2,6)*Metric(1,5)*Metric(3,4))/2. + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - (P(1,4)*Metric(2,5)*Metric(3,4))/2. + (P(1,5)*Metric(2,5)*Metric(3,4))/2. + 2*P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - (P(4,5)*Metric(1,2)*Metric(3,5))/2. - (P(4,6)*Metric(1,2)*Metric(3,5))/2. - 2*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - (P(2,4)*Metric(1,4)*Metric(3,5))/2. + P(2,5)*Metric(1,4)*Metric(3,5) + (P(2,6)*Metric(1,4)*Metric(3,5))/2. + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5) + (P(1,4)*Metric(2,4)*Metric(3,5))/2. - (P(1,5)*Metric(2,4)*Metric(3,5))/2. - 2*P(3,1)*Metric(1,2)*Metric(4,5) + (P(3,4)*Metric(1,2)*Metric(4,5))/2. + (P(3,5)*Metric(1,2)*Metric(4,5))/2. + P(3,6)*Metric(1,2)*Metric(4,5) + 2*P(2,1)*Metric(1,3)*Metric(4,5) - (P(2,4)*Metric(1,3)*Metric(4,5))/2. - (P(2,5)*Metric(1,3)*Metric(4,5))/2. - P(2,6)*Metric(1,3)*Metric(4,5)')

VVVVVS12 = Lorentz(name = 'VVVVVS12',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) - P(3,1)*Metric(1,2)*Metric(4,5) - P(3,2)*Metric(1,2)*Metric(4,5) + P(2,1)*Metric(1,3)*Metric(4,5) + P(1,2)*Metric(2,3)*Metric(4,5)')

VVVVVS13 = Lorentz(name = 'VVVVVS13',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,1)*Metric(1,4)*Metric(2,3) - P(5,2)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) - 2*P(4,2)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) + 2*P(3,2)*Metric(1,5)*Metric(2,4) - 2*P(4,1)*Metric(1,3)*Metric(2,5) - P(4,2)*Metric(1,3)*Metric(2,5) + 2*P(3,1)*Metric(1,4)*Metric(2,5) + P(3,2)*Metric(1,4)*Metric(2,5) + P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) - P(3,1)*Metric(1,2)*Metric(4,5) - P(3,2)*Metric(1,2)*Metric(4,5) + P(2,1)*Metric(1,3)*Metric(4,5) + P(1,2)*Metric(2,3)*Metric(4,5)')

VVVVVS14 = Lorentz(name = 'VVVVVS14',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(2,5)*Metric(1,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) + P(2,4)*Metric(1,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) + P(2,3)*Metric(1,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5)')

VVVVVS15 = Lorentz(name = 'VVVVVS15',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(3,1)*Metric(1,2)*Metric(4,5) - P(3,2)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) + P(2,3)*Metric(1,3)*Metric(4,5) + P(1,2)*Metric(2,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5)')

VVVVVS16 = Lorentz(name = 'VVVVVS16',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(2,5)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,4)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) - P(3,2)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) + P(2,3)*Metric(1,3)*Metric(4,5) + P(1,2)*Metric(2,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5)')

VVVVVS17 = Lorentz(name = 'VVVVVS17',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(5,1)*Metric(1,2)*Metric(3,4) - 2*P(5,2)*Metric(1,2)*Metric(3,4) + 2*P(5,3)*Metric(1,2)*Metric(3,4) + 2*P(5,4)*Metric(1,2)*Metric(3,4) + 2*P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 2*P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) - 2*P(4,3)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) - 2*P(3,4)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5)')

VVVVVS18 = Lorentz(name = 'VVVVVS18',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) + 2*P(4,5)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) - P(3,4)*Metric(1,5)*Metric(2,4) + 2*P(3,5)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) - P(4,3)*Metric(1,3)*Metric(2,5) + 2*P(4,5)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + 2*P(3,5)*Metric(1,4)*Metric(2,5) + 2*P(5,1)*Metric(1,2)*Metric(3,4) + 2*P(5,2)*Metric(1,2)*Metric(3,4) - 2*P(5,3)*Metric(1,2)*Metric(3,4) - 2*P(5,4)*Metric(1,2)*Metric(3,4) - 2*P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + P(2,4)*Metric(1,5)*Metric(3,4) - 2*P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) + 2*P(4,3)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - 2*P(2,5)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - 2*P(1,5)*Metric(2,4)*Metric(3,5) - P(3,1)*Metric(1,2)*Metric(4,5) - P(3,2)*Metric(1,2)*Metric(4,5) + 2*P(3,4)*Metric(1,2)*Metric(4,5) + P(2,1)*Metric(1,3)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) - 2*P(2,5)*Metric(1,3)*Metric(4,5) + P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) - 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS19 = Lorentz(name = 'VVVVVS19',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(4,5)*Metric(1,5)*Metric(2,3) + P(3,5)*Metric(1,5)*Metric(2,4) + P(4,5)*Metric(1,3)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,5)*Metric(1,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) - P(2,5)*Metric(1,3)*Metric(4,5) - P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS20 = Lorentz(name = 'VVVVVS20',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + P(4,5)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) + P(2,3)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) + P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) - P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS21 = Lorentz(name = 'VVVVVS21',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS22 = Lorentz(name = 'VVVVVS22',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - 2*P(5,1)*Metric(1,2)*Metric(3,4) + 2*P(5,2)*Metric(1,2)*Metric(3,4) + 2*P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) - 2*P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 2*P(4,1)*Metric(1,2)*Metric(3,5) + 2*P(4,2)*Metric(1,2)*Metric(3,5) + 2*P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) - 2*P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - 2*P(3,1)*Metric(1,2)*Metric(4,5) + 2*P(3,2)*Metric(1,2)*Metric(4,5) + 2*P(2,1)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS23 = Lorentz(name = 'VVVVVS23',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 4*P(2,5)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 4*P(1,5)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) + 4*P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - 4*P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + 4*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 4*P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS24 = Lorentz(name = 'VVVVVS24',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 2*P(2,5)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 2*P(1,5)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - 2*P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS25 = Lorentz(name = 'VVVVVS25',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - (2*P(5,1)*Metric(1,2)*Metric(3,4))/3. + (2*P(5,2)*Metric(1,2)*Metric(3,4))/3. + (2*P(2,1)*Metric(1,5)*Metric(3,4))/3. - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + (4*P(2,5)*Metric(1,5)*Metric(3,4))/3. - (2*P(1,2)*Metric(2,5)*Metric(3,4))/3. + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - (4*P(1,5)*Metric(2,5)*Metric(3,4))/3. - (2*P(4,1)*Metric(1,2)*Metric(3,5))/3. + (2*P(4,2)*Metric(1,2)*Metric(3,5))/3. + (2*P(2,1)*Metric(1,4)*Metric(3,5))/3. - P(2,3)*Metric(1,4)*Metric(3,5) + (4*P(2,4)*Metric(1,4)*Metric(3,5))/3. - P(2,5)*Metric(1,4)*Metric(3,5) - (2*P(1,2)*Metric(2,4)*Metric(3,5))/3. + P(1,3)*Metric(2,4)*Metric(3,5) - (4*P(1,4)*Metric(2,4)*Metric(3,5))/3. + P(1,5)*Metric(2,4)*Metric(3,5) - (2*P(3,1)*Metric(1,2)*Metric(4,5))/3. + (2*P(3,2)*Metric(1,2)*Metric(4,5))/3. + (2*P(2,1)*Metric(1,3)*Metric(4,5))/3. + (4*P(2,3)*Metric(1,3)*Metric(4,5))/3. - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - (2*P(1,2)*Metric(2,3)*Metric(4,5))/3. - (4*P(1,3)*Metric(2,3)*Metric(4,5))/3. + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS26 = Lorentz(name = 'VVVVVS26',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(2,5)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) + P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS27 = Lorentz(name = 'VVVVVS27',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(5,2)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(2,5)*Metric(1,5)*Metric(3,4) - P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) + P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) + P(2,1)*Metric(1,3)*Metric(4,5) + P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS28 = Lorentz(name = 'VVVVVS28',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + 3*P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + 3*P(3,4)*Metric(1,5)*Metric(2,4) - 2*P(3,5)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) + 3*P(4,3)*Metric(1,3)*Metric(2,5) - 2*P(4,5)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + 3*P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(3,5)*Metric(1,4)*Metric(2,5) - 6*P(5,1)*Metric(1,2)*Metric(3,4) - 6*P(5,2)*Metric(1,2)*Metric(3,4) + 6*P(5,3)*Metric(1,2)*Metric(3,4) + 6*P(5,4)*Metric(1,2)*Metric(3,4) + 6*P(2,1)*Metric(1,5)*Metric(3,4) - 3*P(2,3)*Metric(1,5)*Metric(3,4) - 3*P(2,4)*Metric(1,5)*Metric(3,4) + 6*P(1,2)*Metric(2,5)*Metric(3,4) - 3*P(1,3)*Metric(2,5)*Metric(3,4) - 3*P(1,4)*Metric(2,5)*Metric(3,4) + 3*P(4,1)*Metric(1,2)*Metric(3,5) + 3*P(4,2)*Metric(1,2)*Metric(3,5) - 6*P(4,3)*Metric(1,2)*Metric(3,5) - 3*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(2,5)*Metric(1,4)*Metric(3,5) - 3*P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + 2*P(1,5)*Metric(2,4)*Metric(3,5) + 3*P(3,1)*Metric(1,2)*Metric(4,5) + 3*P(3,2)*Metric(1,2)*Metric(4,5) - 6*P(3,4)*Metric(1,2)*Metric(4,5) - 3*P(2,1)*Metric(1,3)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) + 2*P(2,5)*Metric(1,3)*Metric(4,5) - 3*P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS29 = Lorentz(name = 'VVVVVS29',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,2)*Metric(1,4)*Metric(2,3) + P(5,3)*Metric(1,4)*Metric(2,3) - 2*P(5,4)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(5,4)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(4,5)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(3,2)*Metric(1,2)*Metric(4,5) - P(3,4)*Metric(1,2)*Metric(4,5) - P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,2)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*Metric(2,3)*Metric(4,5) + 2*P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS30 = Lorentz(name = 'VVVVVS30',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,2)*Metric(1,4)*Metric(2,3) + P(5,3)*Metric(1,4)*Metric(2,3) - 2*P(5,4)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*Metric(1,5)*Metric(2,3) - 2*P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + 2*P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - 2*P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) + 2*P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(5,1)*Metric(1,2)*Metric(3,4) + P(5,2)*Metric(1,2)*Metric(3,4) + P(5,4)*Metric(1,2)*Metric(3,4) + 2*P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,5)*Metric(1,5)*Metric(3,4) - P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) - 2*P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) + P(4,5)*Metric(1,2)*Metric(3,5) + 2*P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) - P(2,4)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(3,2)*Metric(1,2)*Metric(4,5) - P(3,4)*Metric(1,2)*Metric(4,5) - P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,2)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*Metric(2,3)*Metric(4,5) + 2*P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS31 = Lorentz(name = 'VVVVVS31',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,1)*Metric(1,4)*Metric(2,3) - P(5,2)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + 2*P(4,2)*Metric(1,5)*Metric(2,3) - P(4,6)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - 2*P(3,2)*Metric(1,5)*Metric(2,4) + P(3,6)*Metric(1,5)*Metric(2,4) + 2*P(4,1)*Metric(1,3)*Metric(2,5) - P(4,2)*Metric(1,3)*Metric(2,5) - P(4,6)*Metric(1,3)*Metric(2,5) - 2*P(3,1)*Metric(1,4)*Metric(2,5) + P(3,2)*Metric(1,4)*Metric(2,5) + P(3,6)*Metric(1,4)*Metric(2,5) - P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) + 2*P(4,6)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,6)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,6)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) - 2*P(3,6)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) + P(2,6)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5) + P(1,6)*Metric(2,3)*Metric(4,5)')

VVVVVV1 = Lorentz(name = 'VVVVVV1',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,2)*Metric(1,4)*Metric(2,3) - P(4,1)*P(6,2)*Metric(1,5)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) + P(5,2)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,2)*Metric(1,6)*Metric(2,4) - P(4,2)*P(6,1)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,2)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) - P(3,2)*P(5,1)*Metric(1,4)*Metric(2,6) + P(3,2)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6)')

VVVVVV2 = Lorentz(name = 'VVVVVV2',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,1)*Metric(1,4)*Metric(2,3) + P(4,2)*P(6,1)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,1)*Metric(1,5)*Metric(2,3) - P(4,2)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,3)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,3)*Metric(1,6)*Metric(2,3) + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,2)*Metric(1,3)*Metric(2,4) - P(3,2)*P(6,1)*Metric(1,5)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) + P(3,2)*P(5,1)*Metric(1,6)*Metric(2,4) + P(4,1)*P(6,2)*Metric(1,3)*Metric(2,5) + P(4,3)*P(6,2)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,1)*P(6,2)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) - P(4,1)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,3)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,2)*P(5,3)*Metric(1,3)*Metric(2,6) + P(3,1)*P(5,2)*Metric(1,4)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) + P(5,1)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,2)*P(6,3)*Metric(1,2)*Metric(3,4) - P(2,3)*P(6,1)*Metric(1,5)*Metric(3,4) - P(2,1)*P(6,3)*Metric(1,5)*Metric(3,4) + P(2,3)*P(5,1)*Metric(1,6)*Metric(3,4) - P(1,3)*P(6,2)*Metric(2,5)*Metric(3,4) - P(1,2)*P(6,3)*Metric(2,5)*Metric(3,4) + P(1,3)*P(5,2)*Metric(2,6)*Metric(3,4) + P(4,1)*P(6,3)*Metric(1,2)*Metric(3,5) + P(4,2)*P(6,3)*Metric(1,2)*Metric(3,5) - P(2,3)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,1)*P(6,3)*Metric(1,4)*Metric(3,5) + P(2,3)*P(4,1)*Metric(1,6)*Metric(3,5) - P(1,3)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,2)*P(6,3)*Metric(2,4)*Metric(3,5) + P(1,3)*P(4,2)*Metric(2,6)*Metric(3,5) - P(4,3)*P(5,1)*Metric(1,2)*Metric(3,6) - P(4,3)*P(5,2)*Metric(1,2)*Metric(3,6) - P(4,1)*P(5,3)*Metric(1,2)*Metric(3,6) - P(4,2)*P(5,3)*Metric(1,2)*Metric(3,6) + P(2,1)*P(5,3)*Metric(1,4)*Metric(3,6) + P(2,1)*P(4,3)*Metric(1,5)*Metric(3,6) + P(1,2)*P(5,3)*Metric(2,4)*Metric(3,6) + P(1,2)*P(4,3)*Metric(2,5)*Metric(3,6)')

VVVVVV3 = Lorentz(name = 'VVVVVV3',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'P(1,6)*P(6,1)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(1,6)*P(6,1)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(1,6)*P(6,1)*Metric(2,3)*Metric(4,5) + 2*P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5)')

VVVVVV4 = Lorentz(name = 'VVVVVV4',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'P(3,6)*P(6,3)*Metric(1,5)*Metric(2,4) + P(3,6)*P(6,3)*Metric(1,4)*Metric(2,5) + P(2,6)*P(6,2)*Metric(1,5)*Metric(3,4) + P(1,6)*P(6,1)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(2,6)*P(6,2)*Metric(1,4)*Metric(3,5) + P(1,6)*P(6,1)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 2*P(3,6)*P(6,3)*Metric(1,2)*Metric(4,5) - 2*P(2,6)*P(6,2)*Metric(1,3)*Metric(4,5) - 2*P(1,6)*P(6,1)*Metric(2,3)*Metric(4,5) + 2*P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5)')

VVVVVV5 = Lorentz(name = 'VVVVVV5',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'P(2,6)*P(6,2)*Metric(1,5)*Metric(3,4) + P(2,5)*P(5,2)*Metric(1,6)*Metric(3,4) + P(1,6)*P(6,1)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(1,5)*P(5,1)*Metric(2,6)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - (P(2,6)*P(6,2)*Metric(1,4)*Metric(3,5))/2. - (P(1,6)*P(6,1)*Metric(2,4)*Metric(3,5))/2. + (P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(2,5)*P(5,2)*Metric(1,4)*Metric(3,6))/2. - (P(1,5)*P(5,1)*Metric(2,4)*Metric(3,6))/2. + (P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(2,6)*P(6,2)*Metric(1,3)*Metric(4,5))/2. - (P(1,6)*P(6,1)*Metric(2,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(2,5)*P(5,2)*Metric(1,3)*Metric(4,6))/2. - (P(1,5)*P(5,1)*Metric(2,3)*Metric(4,6))/2. + (P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2.')

VVVVVV6 = Lorentz(name = 'VVVVVV6',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,4)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,4)*Metric(1,4)*Metric(2,3) - P(4,1)*P(6,2)*Metric(1,5)*Metric(2,3) - P(4,1)*P(6,3)*Metric(1,5)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,3)*Metric(1,6)*Metric(2,3) + P(5,2)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,2)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,4)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,1)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,2)*Metric(1,6)*Metric(2,4) - P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4) - P(4,2)*P(6,1)*Metric(1,3)*Metric(2,5) - P(4,2)*P(6,3)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,2)*P(6,4)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,2)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) - P(4,2)*P(5,3)*Metric(1,3)*Metric(2,6) - P(3,2)*P(5,1)*Metric(1,4)*Metric(2,6) - P(3,2)*P(5,4)*Metric(1,4)*Metric(2,6) + P(3,2)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) + P(5,3)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,3)*P(6,2)*Metric(1,2)*Metric(3,4) + P(5,4)*P(6,2)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,2)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,4)*Metric(1,2)*Metric(3,4) + P(5,2)*P(6,4)*Metric(1,2)*Metric(3,4) - P(2,1)*P(6,3)*Metric(1,5)*Metric(3,4) - P(2,1)*P(6,4)*Metric(1,5)*Metric(3,4) - P(2,1)*P(5,3)*Metric(1,6)*Metric(3,4) - P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4) - P(1,2)*P(6,3)*Metric(2,5)*Metric(3,4) - P(1,2)*P(6,4)*Metric(2,5)*Metric(3,4) - P(1,2)*P(5,3)*Metric(2,6)*Metric(3,4) - P(1,2)*P(5,4)*Metric(2,6)*Metric(3,4) - P(4,3)*P(6,1)*Metric(1,2)*Metric(3,5) - P(4,3)*P(6,2)*Metric(1,2)*Metric(3,5) - P(2,3)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,3)*P(6,4)*Metric(1,4)*Metric(3,5) + P(2,3)*P(4,1)*Metric(1,6)*Metric(3,5) + P(2,1)*P(4,3)*Metric(1,6)*Metric(3,5) - P(1,3)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) + P(1,3)*P(4,2)*Metric(2,6)*Metric(3,5) + P(1,2)*P(4,3)*Metric(2,6)*Metric(3,5) - P(4,3)*P(5,1)*Metric(1,2)*Metric(3,6) - P(4,3)*P(5,2)*Metric(1,2)*Metric(3,6) - P(2,3)*P(5,1)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6) + P(2,3)*P(4,1)*Metric(1,5)*Metric(3,6) + P(2,1)*P(4,3)*Metric(1,5)*Metric(3,6) - P(1,3)*P(5,2)*Metric(2,4)*Metric(3,6) - P(1,3)*P(5,4)*Metric(2,4)*Metric(3,6) + P(1,3)*P(4,2)*Metric(2,5)*Metric(3,6) + P(1,2)*P(4,3)*Metric(2,5)*Metric(3,6) - P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5) - P(3,4)*P(6,2)*Metric(1,2)*Metric(4,5) - P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,4)*P(6,3)*Metric(1,3)*Metric(4,5) + P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5) - P(1,4)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5) + P(1,4)*P(3,2)*Metric(2,6)*Metric(4,5) + P(1,2)*P(3,4)*Metric(2,6)*Metric(4,5) + P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,3)*P(2,4)*Metric(3,6)*Metric(4,5) - P(3,4)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,4)*P(5,2)*Metric(1,2)*Metric(4,6) - P(2,4)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) + P(2,4)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,4)*Metric(1,5)*Metric(4,6) - P(1,4)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,4)*P(5,3)*Metric(2,3)*Metric(4,6) + P(1,4)*P(3,2)*Metric(2,5)*Metric(4,6) + P(1,2)*P(3,4)*Metric(2,5)*Metric(4,6) + P(1,4)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6)')

VVVVVV7 = Lorentz(name = 'VVVVVV7',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,5)*P(4,6)*Metric(1,6)*Metric(2,5) + P(3,6)*P(4,5)*Metric(1,5)*Metric(2,6) + P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) - P(2,5)*P(4,6)*Metric(1,6)*Metric(3,5) - P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) - P(2,6)*P(4,5)*Metric(1,5)*Metric(3,6) - P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) - P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) - P(1,5)*P(3,6)*Metric(2,6)*Metric(4,5) + P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) + P(1,5)*P(2,6)*Metric(3,6)*Metric(4,5) - P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) - P(1,6)*P(3,5)*Metric(2,5)*Metric(4,6) + P(1,6)*P(2,5)*Metric(3,5)*Metric(4,6) + P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6)')

VVVVVV8 = Lorentz(name = 'VVVVVV8',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'Metric(1,6)*Metric(2,4)*Metric(3,5) + Metric(1,4)*Metric(2,6)*Metric(3,5) + Metric(1,5)*Metric(2,4)*Metric(3,6) + Metric(1,4)*Metric(2,5)*Metric(3,6) + Metric(1,6)*Metric(2,3)*Metric(4,5) + Metric(1,3)*Metric(2,6)*Metric(4,5) - 4*Metric(1,2)*Metric(3,6)*Metric(4,5) + Metric(1,5)*Metric(2,3)*Metric(4,6) + Metric(1,3)*Metric(2,5)*Metric(4,6) - 4*Metric(1,2)*Metric(3,5)*Metric(4,6)')

VVVVVV9 = Lorentz(name = 'VVVVVV9',
                  spins = [ 3, 3, 3, 3, 3, 3 ],
                  structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + Metric(1,2)*Metric(3,5)*Metric(4,6)')

VVVVVV10 = Lorentz(name = 'VVVVVV10',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,1)*P(5,6)*Metric(1,3)*Metric(2,6) - P(3,1)*P(5,6)*Metric(1,4)*Metric(2,6) - P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) + P(4,6)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) - P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,1)*P(4,6)*Metric(1,5)*Metric(3,6) - P(3,6)*P(5,1)*Metric(1,2)*Metric(4,6) - P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) + P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,6)*Metric(1,5)*Metric(4,6) - P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) - P(2,6)*P(4,1)*Metric(1,3)*Metric(5,6) + P(2,6)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6)')

VVVVVV11 = Lorentz(name = 'VVVVVV11',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,4)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4) + P(4,5)*P(6,1)*Metric(1,3)*Metric(2,5) + P(4,1)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,1)*P(6,5)*Metric(1,4)*Metric(2,5) - P(3,1)*P(4,5)*Metric(1,6)*Metric(2,5) + P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,1)*P(5,6)*Metric(1,3)*Metric(2,6) - P(3,1)*P(5,6)*Metric(1,4)*Metric(2,6) - P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) + P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,4)*Metric(1,2)*Metric(3,4) - P(2,1)*P(6,4)*Metric(1,5)*Metric(3,4) - P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4) + P(4,5)*P(6,1)*Metric(1,2)*Metric(3,5) + P(4,1)*P(6,5)*Metric(1,2)*Metric(3,5) - P(2,1)*P(6,5)*Metric(1,4)*Metric(3,5) - P(2,1)*P(4,5)*Metric(1,6)*Metric(3,5) + P(4,6)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) - P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,1)*P(4,6)*Metric(1,5)*Metric(3,6) - P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5) - P(3,5)*P(6,1)*Metric(1,2)*Metric(4,5) - P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,5)*P(6,1)*Metric(1,3)*Metric(4,5) + P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,5)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,5)*Metric(1,6)*Metric(4,5) - P(3,4)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,6)*P(5,1)*Metric(1,2)*Metric(4,6) - P(2,4)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) + P(2,4)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,4)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,6)*Metric(1,5)*Metric(4,6) - P(3,5)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) - P(2,5)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,1)*Metric(1,3)*Metric(5,6) + P(2,5)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6)')

VVVVVV12 = Lorentz(name = 'VVVVVV12',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) + 2*Metric(1,6)*Metric(2,3)*Metric(4,5) - Metric(1,3)*Metric(2,6)*Metric(4,5) - Metric(1,2)*Metric(3,6)*Metric(4,5) - Metric(1,5)*Metric(2,3)*Metric(4,6) - Metric(1,4)*Metric(2,3)*Metric(5,6)')

VVVVVV13 = Lorentz(name = 'VVVVVV13',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(1,6)*P(6,1)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(1,5)*P(5,1)*Metric(2,6)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(1,6)*P(6,1)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(1,4)*P(4,1)*Metric(2,6)*Metric(3,5) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(1,5)*P(5,1)*Metric(2,4)*Metric(3,6) - P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(1,4)*P(4,1)*Metric(2,5)*Metric(3,6) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 2*P(1,6)*P(6,1)*Metric(2,3)*Metric(4,5) + 2*P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(1,5)*P(5,1)*Metric(2,3)*Metric(4,6) + 2*P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - 2*P(1,4)*P(4,1)*Metric(2,3)*Metric(5,6) + 2*P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6)')

VVVVVV14 = Lorentz(name = 'VVVVVV14',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,2)*Metric(1,4)*Metric(2,3) - P(4,1)*P(6,2)*Metric(1,5)*Metric(2,3) - P(4,5)*P(6,2)*Metric(1,5)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,2)*Metric(1,6)*Metric(2,3) + P(5,2)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,5)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,2)*Metric(1,6)*Metric(2,4) - P(3,6)*P(5,2)*Metric(1,6)*Metric(2,4) - P(4,2)*P(6,1)*Metric(1,3)*Metric(2,5) - P(4,5)*P(6,1)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,5)*P(6,1)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,5)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,2)*Metric(1,6)*Metric(2,5) + P(3,6)*P(4,2)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,2)*P(4,6)*Metric(1,6)*Metric(2,5) + P(3,5)*P(4,6)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) - P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) - P(3,2)*P(5,1)*Metric(1,4)*Metric(2,6) - P(3,6)*P(5,1)*Metric(1,4)*Metric(2,6) + P(3,2)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,6)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) + P(3,5)*P(4,2)*Metric(1,5)*Metric(2,6) + P(3,2)*P(4,5)*Metric(1,5)*Metric(2,6) + P(3,6)*P(4,5)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) + P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) - P(4,1)*P(6,5)*Metric(1,2)*Metric(3,5) - P(4,2)*P(6,5)*Metric(1,2)*Metric(3,5) + P(2,5)*P(6,1)*Metric(1,4)*Metric(3,5) + P(2,1)*P(6,5)*Metric(1,4)*Metric(3,5) - P(2,5)*P(4,1)*Metric(1,6)*Metric(3,5) - P(2,5)*P(4,6)*Metric(1,6)*Metric(3,5) + P(1,5)*P(6,2)*Metric(2,4)*Metric(3,5) + P(1,2)*P(6,5)*Metric(2,4)*Metric(3,5) - P(1,5)*P(4,2)*Metric(2,6)*Metric(3,5) - P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) - P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) - P(4,2)*P(5,6)*Metric(1,2)*Metric(3,6) + P(2,6)*P(5,1)*Metric(1,4)*Metric(3,6) + P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,6)*P(4,1)*Metric(1,5)*Metric(3,6) - P(2,6)*P(4,5)*Metric(1,5)*Metric(3,6) + P(1,6)*P(5,2)*Metric(2,4)*Metric(3,6) + P(1,2)*P(5,6)*Metric(2,4)*Metric(3,6) - P(1,6)*P(4,2)*Metric(2,5)*Metric(3,6) - P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) - P(3,1)*P(6,5)*Metric(1,2)*Metric(4,5) - P(3,2)*P(6,5)*Metric(1,2)*Metric(4,5) + P(2,5)*P(6,1)*Metric(1,3)*Metric(4,5) + P(2,1)*P(6,5)*Metric(1,3)*Metric(4,5) - P(2,5)*P(3,1)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) + P(1,5)*P(6,2)*Metric(2,3)*Metric(4,5) + P(1,2)*P(6,5)*Metric(2,3)*Metric(4,5) - P(1,5)*P(3,2)*Metric(2,6)*Metric(4,5) - P(1,5)*P(3,6)*Metric(2,6)*Metric(4,5) + P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) + P(1,5)*P(2,6)*Metric(3,6)*Metric(4,5) - P(3,1)*P(5,6)*Metric(1,2)*Metric(4,6) - P(3,2)*P(5,6)*Metric(1,2)*Metric(4,6) + P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) + P(2,1)*P(5,6)*Metric(1,3)*Metric(4,6) - P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) - P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) + P(1,6)*P(5,2)*Metric(2,3)*Metric(4,6) + P(1,2)*P(5,6)*Metric(2,3)*Metric(4,6) - P(1,6)*P(3,2)*Metric(2,5)*Metric(4,6) - P(1,6)*P(3,5)*Metric(2,5)*Metric(4,6) + P(1,6)*P(2,5)*Metric(3,5)*Metric(4,6) + P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6) + P(3,5)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,5)*P(4,2)*Metric(1,2)*Metric(5,6) + P(3,6)*P(4,2)*Metric(1,2)*Metric(5,6) + P(3,1)*P(4,5)*Metric(1,2)*Metric(5,6) + P(3,2)*P(4,5)*Metric(1,2)*Metric(5,6) + P(3,1)*P(4,6)*Metric(1,2)*Metric(5,6) + P(3,2)*P(4,6)*Metric(1,2)*Metric(5,6) - P(2,1)*P(4,5)*Metric(1,3)*Metric(5,6) - P(2,1)*P(4,6)*Metric(1,3)*Metric(5,6) - P(2,1)*P(3,5)*Metric(1,4)*Metric(5,6) - P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) - P(1,2)*P(4,5)*Metric(2,3)*Metric(5,6) - P(1,2)*P(4,6)*Metric(2,3)*Metric(5,6) - P(1,2)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,2)*P(3,6)*Metric(2,4)*Metric(5,6)')

VVVVVV15 = Lorentz(name = 'VVVVVV15',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(4,5)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,6)*P(5,2)*Metric(1,6)*Metric(2,3) + P(3,5)*P(6,2)*Metric(1,5)*Metric(2,4) + P(3,6)*P(5,2)*Metric(1,6)*Metric(2,4) + P(4,5)*P(6,1)*Metric(1,3)*Metric(2,5) + P(3,5)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,5)*P(4,1)*Metric(1,6)*Metric(2,5) - P(3,6)*P(4,2)*Metric(1,6)*Metric(2,5) - P(3,1)*P(4,5)*Metric(1,6)*Metric(2,5) - P(3,2)*P(4,6)*Metric(1,6)*Metric(2,5) + P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) + P(3,6)*P(5,1)*Metric(1,4)*Metric(2,6) - P(3,6)*P(4,1)*Metric(1,5)*Metric(2,6) - P(3,5)*P(4,2)*Metric(1,5)*Metric(2,6) - P(3,2)*P(4,5)*Metric(1,5)*Metric(2,6) - P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) + P(4,1)*P(6,5)*Metric(1,2)*Metric(3,5) + P(4,2)*P(6,5)*Metric(1,2)*Metric(3,5) - P(2,5)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,1)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,5)*P(4,1)*Metric(1,6)*Metric(3,5) - P(1,5)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,2)*P(6,5)*Metric(2,4)*Metric(3,5) + P(1,5)*P(4,2)*Metric(2,6)*Metric(3,5) + P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) + P(4,2)*P(5,6)*Metric(1,2)*Metric(3,6) - P(2,6)*P(5,1)*Metric(1,4)*Metric(3,6) - P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) + P(2,6)*P(4,1)*Metric(1,5)*Metric(3,6) - P(1,6)*P(5,2)*Metric(2,4)*Metric(3,6) - P(1,2)*P(5,6)*Metric(2,4)*Metric(3,6) + P(1,6)*P(4,2)*Metric(2,5)*Metric(3,6) + P(3,1)*P(6,5)*Metric(1,2)*Metric(4,5) + P(3,2)*P(6,5)*Metric(1,2)*Metric(4,5) - P(2,5)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,1)*P(6,5)*Metric(1,3)*Metric(4,5) + P(2,5)*P(3,1)*Metric(1,6)*Metric(4,5) - P(1,5)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,2)*P(6,5)*Metric(2,3)*Metric(4,5) + P(1,5)*P(3,2)*Metric(2,6)*Metric(4,5) + P(3,1)*P(5,6)*Metric(1,2)*Metric(4,6) + P(3,2)*P(5,6)*Metric(1,2)*Metric(4,6) - P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,1)*P(5,6)*Metric(1,3)*Metric(4,6) + P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) - P(1,6)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,2)*P(5,6)*Metric(2,3)*Metric(4,6) + P(1,6)*P(3,2)*Metric(2,5)*Metric(4,6) - P(3,5)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,5)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,1)*P(4,5)*Metric(1,2)*Metric(5,6) - P(3,2)*P(4,5)*Metric(1,2)*Metric(5,6) - P(3,1)*P(4,6)*Metric(1,2)*Metric(5,6) - P(3,2)*P(4,6)*Metric(1,2)*Metric(5,6) + P(2,1)*P(4,5)*Metric(1,3)*Metric(5,6) + P(2,1)*P(4,6)*Metric(1,3)*Metric(5,6) + P(2,1)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) + P(1,2)*P(4,5)*Metric(2,3)*Metric(5,6) + P(1,2)*P(4,6)*Metric(2,3)*Metric(5,6) + P(1,2)*P(3,5)*Metric(2,4)*Metric(5,6) + P(1,2)*P(3,6)*Metric(2,4)*Metric(5,6)')

VVVVVV16 = Lorentz(name = 'VVVVVV16',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,2)*Metric(1,2)*Metric(3,4) - P(2,1)*P(6,2)*Metric(1,5)*Metric(3,4) - P(2,1)*P(5,2)*Metric(1,6)*Metric(3,4) - P(1,2)*P(6,1)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(1,2)*P(5,1)*Metric(2,6)*Metric(3,4) + P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,6)*Metric(3,4) - (P(4,2)*P(6,1)*Metric(1,2)*Metric(3,5))/2. - (P(4,1)*P(6,2)*Metric(1,2)*Metric(3,5))/2. + (P(2,1)*P(6,2)*Metric(1,4)*Metric(3,5))/2. + (P(2,1)*P(4,2)*Metric(1,6)*Metric(3,5))/2. + (P(1,2)*P(6,1)*Metric(2,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(1,2)*P(4,1)*Metric(2,6)*Metric(3,5))/2. - (P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(4,2)*P(5,1)*Metric(1,2)*Metric(3,6))/2. - (P(4,1)*P(5,2)*Metric(1,2)*Metric(3,6))/2. + (P(2,1)*P(5,2)*Metric(1,4)*Metric(3,6))/2. + (P(2,1)*P(4,2)*Metric(1,5)*Metric(3,6))/2. + (P(1,2)*P(5,1)*Metric(2,4)*Metric(3,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(1,2)*P(4,1)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(3,2)*P(6,1)*Metric(1,2)*Metric(4,5))/2. - (P(3,1)*P(6,2)*Metric(1,2)*Metric(4,5))/2. + (P(2,1)*P(6,2)*Metric(1,3)*Metric(4,5))/2. + (P(2,1)*P(3,2)*Metric(1,6)*Metric(4,5))/2. + (P(1,2)*P(6,1)*Metric(2,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(1,2)*P(3,1)*Metric(2,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(3,2)*P(5,1)*Metric(1,2)*Metric(4,6))/2. - (P(3,1)*P(5,2)*Metric(1,2)*Metric(4,6))/2. + (P(2,1)*P(5,2)*Metric(1,3)*Metric(4,6))/2. + (P(2,1)*P(3,2)*Metric(1,5)*Metric(4,6))/2. + (P(1,2)*P(5,1)*Metric(2,3)*Metric(4,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(1,2)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(3,2)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,1)*P(4,2)*Metric(1,2)*Metric(5,6) - P(2,1)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,1)*P(3,2)*Metric(1,4)*Metric(5,6) - P(1,2)*P(4,1)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(1,2)*P(3,1)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)*Metric(5,6)')

VVVVVV17 = Lorentz(name = 'VVVVVV17',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,1)*Metric(1,4)*Metric(2,3) + P(4,2)*P(6,1)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,1)*Metric(1,5)*Metric(2,3) - P(4,2)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,3)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,3)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3) - P(4,2)*P(5,6)*Metric(1,6)*Metric(2,3) - P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,2)*Metric(1,3)*Metric(2,4) - P(3,2)*P(6,1)*Metric(1,5)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) + P(3,2)*P(5,1)*Metric(1,6)*Metric(2,4) + P(3,2)*P(5,6)*Metric(1,6)*Metric(2,4) + P(4,1)*P(6,2)*Metric(1,3)*Metric(2,5) + P(4,3)*P(6,2)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,1)*P(6,2)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,2)*P(4,6)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) - P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) - P(4,1)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,3)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,2)*P(5,3)*Metric(1,3)*Metric(2,6) - P(4,6)*P(5,3)*Metric(1,3)*Metric(2,6) - P(4,1)*P(5,6)*Metric(1,3)*Metric(2,6) - P(4,3)*P(5,6)*Metric(1,3)*Metric(2,6) + P(3,1)*P(5,2)*Metric(1,4)*Metric(2,6) + P(3,1)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) + P(5,1)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,2)*P(6,3)*Metric(1,2)*Metric(3,4) - P(2,3)*P(6,1)*Metric(1,5)*Metric(3,4) - P(2,1)*P(6,3)*Metric(1,5)*Metric(3,4) + P(2,3)*P(5,1)*Metric(1,6)*Metric(3,4) + P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4) - P(1,3)*P(6,2)*Metric(2,5)*Metric(3,4) - P(1,2)*P(6,3)*Metric(2,5)*Metric(3,4) + P(1,3)*P(5,2)*Metric(2,6)*Metric(3,4) + P(1,3)*P(5,6)*Metric(2,6)*Metric(3,4) + P(4,1)*P(6,3)*Metric(1,2)*Metric(3,5) + P(4,2)*P(6,3)*Metric(1,2)*Metric(3,5) - P(2,3)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,1)*P(6,3)*Metric(1,4)*Metric(3,5) + P(2,3)*P(4,1)*Metric(1,6)*Metric(3,5) + P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5) - P(1,3)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,2)*P(6,3)*Metric(2,4)*Metric(3,5) + P(1,3)*P(4,2)*Metric(2,6)*Metric(3,5) + P(1,3)*P(4,6)*Metric(2,6)*Metric(3,5) - P(4,3)*P(5,1)*Metric(1,2)*Metric(3,6) - P(4,6)*P(5,1)*Metric(1,2)*Metric(3,6) - P(4,3)*P(5,2)*Metric(1,2)*Metric(3,6) - P(4,6)*P(5,2)*Metric(1,2)*Metric(3,6) - P(4,1)*P(5,3)*Metric(1,2)*Metric(3,6) - P(4,2)*P(5,3)*Metric(1,2)*Metric(3,6) - P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) - P(4,2)*P(5,6)*Metric(1,2)*Metric(3,6) + P(2,1)*P(5,3)*Metric(1,4)*Metric(3,6) + P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) + P(2,1)*P(4,3)*Metric(1,5)*Metric(3,6) + P(2,1)*P(4,6)*Metric(1,5)*Metric(3,6) + P(1,2)*P(5,3)*Metric(2,4)*Metric(3,6) + P(1,2)*P(5,6)*Metric(2,4)*Metric(3,6) + P(1,2)*P(4,3)*Metric(2,5)*Metric(3,6) + P(1,2)*P(4,6)*Metric(2,5)*Metric(3,6) + P(3,6)*P(5,1)*Metric(1,2)*Metric(4,6) + P(3,6)*P(5,2)*Metric(1,2)*Metric(4,6) + P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) + P(2,6)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) - P(2,1)*P(3,6)*Metric(1,5)*Metric(4,6) + P(1,6)*P(5,2)*Metric(2,3)*Metric(4,6) + P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6) - P(1,6)*P(3,2)*Metric(2,5)*Metric(4,6) - P(1,2)*P(3,6)*Metric(2,5)*Metric(4,6) - P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6) - P(1,3)*P(2,6)*Metric(3,5)*Metric(4,6) + P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,6)*P(4,2)*Metric(1,2)*Metric(5,6) + P(2,6)*P(4,1)*Metric(1,3)*Metric(5,6) + P(2,6)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,6)*P(3,1)*Metric(1,4)*Metric(5,6) - P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) + P(1,6)*P(4,2)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6) - P(1,6)*P(3,2)*Metric(2,4)*Metric(5,6) - P(1,2)*P(3,6)*Metric(2,4)*Metric(5,6) - P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,3)*P(2,6)*Metric(3,4)*Metric(5,6)')

VVVVVV18 = Lorentz(name = 'VVVVVV18',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(4,6)*P(5,2)*Metric(1,6)*Metric(2,3) + P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3) + P(4,2)*P(5,6)*Metric(1,6)*Metric(2,3) + P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3) - P(3,2)*P(5,6)*Metric(1,6)*Metric(2,4) - P(3,2)*P(4,6)*Metric(1,6)*Metric(2,5) + P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,6)*P(5,3)*Metric(1,3)*Metric(2,6) + P(4,1)*P(5,6)*Metric(1,3)*Metric(2,6) + P(4,3)*P(5,6)*Metric(1,3)*Metric(2,6) - P(3,1)*P(5,6)*Metric(1,4)*Metric(2,6) - P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) - P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4) - P(1,3)*P(5,6)*Metric(2,6)*Metric(3,4) - P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5) - P(1,3)*P(4,6)*Metric(2,6)*Metric(3,5) + P(4,6)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,6)*P(5,2)*Metric(1,2)*Metric(3,6) + P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) + P(4,2)*P(5,6)*Metric(1,2)*Metric(3,6) - P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,1)*P(4,6)*Metric(1,5)*Metric(3,6) - P(1,2)*P(5,6)*Metric(2,4)*Metric(3,6) - P(1,2)*P(4,6)*Metric(2,5)*Metric(3,6) - P(3,6)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,6)*P(5,2)*Metric(1,2)*Metric(4,6) - P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,3)*Metric(1,3)*Metric(4,6) + P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,6)*Metric(1,5)*Metric(4,6) - P(1,6)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6) + P(1,6)*P(3,2)*Metric(2,5)*Metric(4,6) + P(1,2)*P(3,6)*Metric(2,5)*Metric(4,6) + P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,6)*Metric(3,5)*Metric(4,6) - P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,2)*Metric(1,2)*Metric(5,6) - P(2,6)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,6)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) - P(1,6)*P(4,2)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,6)*P(3,2)*Metric(2,4)*Metric(5,6) + P(1,2)*P(3,6)*Metric(2,4)*Metric(5,6) + P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6) + P(1,3)*P(2,6)*Metric(3,4)*Metric(5,6)')

VVVVVV19 = Lorentz(name = 'VVVVVV19',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,4)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,4)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,4)*Metric(1,4)*Metric(2,3) + P(4,5)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,5)*P(6,3)*Metric(1,5)*Metric(2,3) + P(4,2)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,6)*P(5,2)*Metric(1,6)*Metric(2,3) + P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3) + P(4,2)*P(5,6)*Metric(1,6)*Metric(2,3) + P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,4)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,2)*P(6,5)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4) - P(3,2)*P(5,6)*Metric(1,6)*Metric(2,4) + P(4,5)*P(6,1)*Metric(1,3)*Metric(2,5) + P(4,5)*P(6,3)*Metric(1,3)*Metric(2,5) + P(4,1)*P(6,5)*Metric(1,3)*Metric(2,5) + P(4,3)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,4)*Metric(1,4)*Metric(2,5) - P(3,1)*P(6,5)*Metric(1,4)*Metric(2,5) - P(3,1)*P(4,5)*Metric(1,6)*Metric(2,5) - P(3,2)*P(4,6)*Metric(1,6)*Metric(2,5) + P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,6)*P(5,3)*Metric(1,3)*Metric(2,6) + P(4,1)*P(5,6)*Metric(1,3)*Metric(2,6) + P(4,3)*P(5,6)*Metric(1,3)*Metric(2,6) - P(3,2)*P(5,4)*Metric(1,4)*Metric(2,6) - P(3,1)*P(5,6)*Metric(1,4)*Metric(2,6) - P(3,2)*P(4,5)*Metric(1,5)*Metric(2,6) - P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) + P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,4)*P(6,2)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,4)*Metric(1,2)*Metric(3,4) + P(5,2)*P(6,4)*Metric(1,2)*Metric(3,4) - P(2,1)*P(6,4)*Metric(1,5)*Metric(3,4) - P(2,3)*P(6,5)*Metric(1,5)*Metric(3,4) - P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4) - P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4) - P(1,2)*P(6,4)*Metric(2,5)*Metric(3,4) - P(1,3)*P(6,5)*Metric(2,5)*Metric(3,4) - P(1,2)*P(5,4)*Metric(2,6)*Metric(3,4) - P(1,3)*P(5,6)*Metric(2,6)*Metric(3,4) + P(4,5)*P(6,1)*Metric(1,2)*Metric(3,5) + P(4,5)*P(6,2)*Metric(1,2)*Metric(3,5) + P(4,1)*P(6,5)*Metric(1,2)*Metric(3,5) + P(4,2)*P(6,5)*Metric(1,2)*Metric(3,5) - P(2,3)*P(6,4)*Metric(1,4)*Metric(3,5) - P(2,1)*P(6,5)*Metric(1,4)*Metric(3,5) - P(2,1)*P(4,5)*Metric(1,6)*Metric(3,5) - P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5) - P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,2)*P(6,5)*Metric(2,4)*Metric(3,5) - P(1,2)*P(4,5)*Metric(2,6)*Metric(3,5) - P(1,3)*P(4,6)*Metric(2,6)*Metric(3,5) + P(4,6)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,6)*P(5,2)*Metric(1,2)*Metric(3,6) + P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) + P(4,2)*P(5,6)*Metric(1,2)*Metric(3,6) - P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6) - P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,3)*P(4,5)*Metric(1,5)*Metric(3,6) - P(2,1)*P(4,6)*Metric(1,5)*Metric(3,6) - P(1,3)*P(5,4)*Metric(2,4)*Metric(3,6) - P(1,2)*P(5,6)*Metric(2,4)*Metric(3,6) - P(1,3)*P(4,5)*Metric(2,5)*Metric(3,6) - P(1,2)*P(4,6)*Metric(2,5)*Metric(3,6) - P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5) - P(3,5)*P(6,1)*Metric(1,2)*Metric(4,5) - P(3,4)*P(6,2)*Metric(1,2)*Metric(4,5) - P(3,5)*P(6,2)*Metric(1,2)*Metric(4,5) - P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,5)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,4)*P(6,3)*Metric(1,3)*Metric(4,5) - P(2,5)*P(6,3)*Metric(1,3)*Metric(4,5) + P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,5)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,5)*Metric(1,6)*Metric(4,5) - P(1,4)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,5)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5) - P(1,5)*P(6,3)*Metric(2,3)*Metric(4,5) + P(1,4)*P(3,2)*Metric(2,6)*Metric(4,5) + P(1,5)*P(3,2)*Metric(2,6)*Metric(4,5) + P(1,2)*P(3,4)*Metric(2,6)*Metric(4,5) + P(1,2)*P(3,5)*Metric(2,6)*Metric(4,5) + P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,5)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,3)*P(2,4)*Metric(3,6)*Metric(4,5) + P(1,3)*P(2,5)*Metric(3,6)*Metric(4,5) - P(3,4)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,6)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,4)*P(5,2)*Metric(1,2)*Metric(4,6) - P(3,6)*P(5,2)*Metric(1,2)*Metric(4,6) - P(2,4)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,3)*Metric(1,3)*Metric(4,6) + P(2,4)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,4)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,6)*Metric(1,5)*Metric(4,6) - P(1,4)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,4)*P(5,3)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6) + P(1,4)*P(3,2)*Metric(2,5)*Metric(4,6) + P(1,6)*P(3,2)*Metric(2,5)*Metric(4,6) + P(1,2)*P(3,4)*Metric(2,5)*Metric(4,6) + P(1,2)*P(3,6)*Metric(2,5)*Metric(4,6) + P(1,4)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,6)*Metric(3,5)*Metric(4,6) - P(3,5)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,5)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,2)*Metric(1,2)*Metric(5,6) - P(2,5)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,5)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,5)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) - P(1,5)*P(4,2)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,2)*Metric(2,3)*Metric(5,6) - P(1,5)*P(4,3)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,5)*P(3,2)*Metric(2,4)*Metric(5,6) + P(1,6)*P(3,2)*Metric(2,4)*Metric(5,6) + P(1,2)*P(3,5)*Metric(2,4)*Metric(5,6) + P(1,2)*P(3,6)*Metric(2,4)*Metric(5,6) + P(1,5)*P(2,3)*Metric(3,4)*Metric(5,6) + P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6) + P(1,3)*P(2,5)*Metric(3,4)*Metric(5,6) + P(1,3)*P(2,6)*Metric(3,4)*Metric(5,6)')

VVVVVV20 = Lorentz(name = 'VVVVVV20',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,4)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,5)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4) - P(3,6)*P(5,4)*Metric(1,6)*Metric(2,4) + P(4,5)*P(6,1)*Metric(1,3)*Metric(2,5) + P(4,1)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,1)*P(6,5)*Metric(1,4)*Metric(2,5) - P(3,4)*P(6,5)*Metric(1,4)*Metric(2,5) - P(3,1)*P(4,5)*Metric(1,6)*Metric(2,5) - P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) + P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,1)*P(5,6)*Metric(1,3)*Metric(2,6) - P(3,1)*P(5,6)*Metric(1,4)*Metric(2,6) - P(3,4)*P(5,6)*Metric(1,4)*Metric(2,6) - P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) - P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) + P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,4)*Metric(1,2)*Metric(3,4) - P(2,1)*P(6,4)*Metric(1,5)*Metric(3,4) - P(2,5)*P(6,4)*Metric(1,5)*Metric(3,4) - P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4) - P(2,6)*P(5,4)*Metric(1,6)*Metric(3,4) + P(1,5)*P(6,4)*Metric(2,5)*Metric(3,4) + P(1,4)*P(6,5)*Metric(2,5)*Metric(3,4) + P(1,6)*P(5,4)*Metric(2,6)*Metric(3,4) + P(1,4)*P(5,6)*Metric(2,6)*Metric(3,4) + P(4,5)*P(6,1)*Metric(1,2)*Metric(3,5) + P(4,1)*P(6,5)*Metric(1,2)*Metric(3,5) - P(2,1)*P(6,5)*Metric(1,4)*Metric(3,5) - P(2,4)*P(6,5)*Metric(1,4)*Metric(3,5) - P(2,1)*P(4,5)*Metric(1,6)*Metric(3,5) - P(2,6)*P(4,5)*Metric(1,6)*Metric(3,5) + P(1,5)*P(6,4)*Metric(2,4)*Metric(3,5) + P(1,4)*P(6,5)*Metric(2,4)*Metric(3,5) + P(1,6)*P(4,5)*Metric(2,6)*Metric(3,5) + P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) + P(4,6)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) - P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,4)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,1)*P(4,6)*Metric(1,5)*Metric(3,6) - P(2,5)*P(4,6)*Metric(1,5)*Metric(3,6) + P(1,6)*P(5,4)*Metric(2,4)*Metric(3,6) + P(1,4)*P(5,6)*Metric(2,4)*Metric(3,6) + P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) + P(1,5)*P(4,6)*Metric(2,5)*Metric(3,6) - P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5) - P(3,5)*P(6,1)*Metric(1,2)*Metric(4,5) - P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,5)*P(6,1)*Metric(1,3)*Metric(4,5) + P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,5)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5) + P(2,6)*P(3,4)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,5)*Metric(1,6)*Metric(4,5) + P(2,6)*P(3,5)*Metric(1,6)*Metric(4,5) + P(2,4)*P(3,6)*Metric(1,6)*Metric(4,5) + P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) - P(1,6)*P(3,4)*Metric(2,6)*Metric(4,5) - P(1,6)*P(3,5)*Metric(2,6)*Metric(4,5) - P(1,6)*P(2,4)*Metric(3,6)*Metric(4,5) - P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) - P(3,4)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,6)*P(5,1)*Metric(1,2)*Metric(4,6) - P(2,4)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) + P(2,4)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,4)*Metric(1,5)*Metric(4,6) + P(2,5)*P(3,4)*Metric(1,5)*Metric(4,6) + P(2,4)*P(3,5)*Metric(1,5)*Metric(4,6) + P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,6)*Metric(1,5)*Metric(4,6) + P(2,5)*P(3,6)*Metric(1,5)*Metric(4,6) - P(1,5)*P(3,4)*Metric(2,5)*Metric(4,6) - P(1,5)*P(3,6)*Metric(2,5)*Metric(4,6) - P(1,5)*P(2,4)*Metric(3,5)*Metric(4,6) - P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6) - P(3,5)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) - P(2,5)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,1)*Metric(1,3)*Metric(5,6) + P(2,5)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,5)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,4)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) + P(2,4)*P(3,6)*Metric(1,4)*Metric(5,6) - P(1,4)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,4)*P(3,6)*Metric(2,4)*Metric(5,6) - P(1,4)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,6)*Metric(3,4)*Metric(5,6)')

VVVVVV21 = Lorentz(name = 'VVVVVV21',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(3,5)*P(6,4)*Metric(1,5)*Metric(2,4) + P(3,6)*P(5,4)*Metric(1,6)*Metric(2,4) + P(3,4)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,4)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) + P(2,5)*P(6,4)*Metric(1,5)*Metric(3,4) + P(2,6)*P(5,4)*Metric(1,6)*Metric(3,4) - P(1,5)*P(6,4)*Metric(2,5)*Metric(3,4) - P(1,4)*P(6,5)*Metric(2,5)*Metric(3,4) - P(1,6)*P(5,4)*Metric(2,6)*Metric(3,4) - P(1,4)*P(5,6)*Metric(2,6)*Metric(3,4) + P(2,4)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,6)*P(4,5)*Metric(1,6)*Metric(3,5) - P(1,5)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,4)*P(6,5)*Metric(2,4)*Metric(3,5) - P(1,6)*P(4,5)*Metric(2,6)*Metric(3,5) - P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) + P(2,4)*P(5,6)*Metric(1,4)*Metric(3,6) + P(2,5)*P(4,6)*Metric(1,5)*Metric(3,6) - P(1,6)*P(5,4)*Metric(2,4)*Metric(3,6) - P(1,4)*P(5,6)*Metric(2,4)*Metric(3,6) - P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) - P(1,5)*P(4,6)*Metric(2,5)*Metric(3,6) - P(2,6)*P(3,4)*Metric(1,6)*Metric(4,5) - P(2,6)*P(3,5)*Metric(1,6)*Metric(4,5) - P(2,4)*P(3,6)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) + P(1,6)*P(3,4)*Metric(2,6)*Metric(4,5) + P(1,6)*P(3,5)*Metric(2,6)*Metric(4,5) + P(1,6)*P(2,4)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) - P(2,5)*P(3,4)*Metric(1,5)*Metric(4,6) - P(2,4)*P(3,5)*Metric(1,5)*Metric(4,6) - P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) - P(2,5)*P(3,6)*Metric(1,5)*Metric(4,6) + P(1,5)*P(3,4)*Metric(2,5)*Metric(4,6) + P(1,5)*P(3,6)*Metric(2,5)*Metric(4,6) + P(1,5)*P(2,4)*Metric(3,5)*Metric(4,6) + P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6) - P(2,5)*P(3,4)*Metric(1,4)*Metric(5,6) - P(2,6)*P(3,4)*Metric(1,4)*Metric(5,6) - P(2,4)*P(3,5)*Metric(1,4)*Metric(5,6) - P(2,4)*P(3,6)*Metric(1,4)*Metric(5,6) + P(1,4)*P(3,5)*Metric(2,4)*Metric(5,6) + P(1,4)*P(3,6)*Metric(2,4)*Metric(5,6) + P(1,4)*P(2,5)*Metric(3,4)*Metric(5,6) + P(1,4)*P(2,6)*Metric(3,4)*Metric(5,6)')

VVVVVV22 = Lorentz(name = 'VVVVVV22',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,4)*Metric(1,4)*Metric(2,3) + P(4,5)*P(6,3)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3) + P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,4)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) + P(3,5)*P(6,4)*Metric(1,5)*Metric(2,4) + P(3,4)*P(6,5)*Metric(1,5)*Metric(2,4) + P(3,6)*P(5,4)*Metric(1,6)*Metric(2,4) + P(3,4)*P(5,6)*Metric(1,6)*Metric(2,4) + P(4,5)*P(6,3)*Metric(1,3)*Metric(2,5) + P(4,3)*P(6,5)*Metric(1,3)*Metric(2,5) + P(3,5)*P(6,4)*Metric(1,4)*Metric(2,5) + P(3,4)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,5)*P(4,6)*Metric(1,6)*Metric(2,5) + P(4,6)*P(5,3)*Metric(1,3)*Metric(2,6) + P(4,3)*P(5,6)*Metric(1,3)*Metric(2,6) + P(3,6)*P(5,4)*Metric(1,4)*Metric(2,6) + P(3,4)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,6)*P(4,5)*Metric(1,5)*Metric(2,6) + P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) - P(2,3)*P(6,5)*Metric(1,5)*Metric(3,4) - P(2,4)*P(6,5)*Metric(1,5)*Metric(3,4) - P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4) - P(2,4)*P(5,6)*Metric(1,6)*Metric(3,4) - P(1,3)*P(6,5)*Metric(2,5)*Metric(3,4) - P(1,4)*P(6,5)*Metric(2,5)*Metric(3,4) - P(1,3)*P(5,6)*Metric(2,6)*Metric(3,4) - P(1,4)*P(5,6)*Metric(2,6)*Metric(3,4) - P(2,3)*P(6,4)*Metric(1,4)*Metric(3,5) - P(2,5)*P(6,4)*Metric(1,4)*Metric(3,5) - P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5) - P(2,5)*P(4,6)*Metric(1,6)*Metric(3,5) - P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,5)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,3)*P(4,6)*Metric(2,6)*Metric(3,5) - P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) - P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6) - P(2,6)*P(5,4)*Metric(1,4)*Metric(3,6) - P(2,3)*P(4,5)*Metric(1,5)*Metric(3,6) - P(2,6)*P(4,5)*Metric(1,5)*Metric(3,6) - P(1,3)*P(5,4)*Metric(2,4)*Metric(3,6) - P(1,6)*P(5,4)*Metric(2,4)*Metric(3,6) - P(1,3)*P(4,5)*Metric(2,5)*Metric(3,6) - P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) - P(2,4)*P(6,3)*Metric(1,3)*Metric(4,5) - P(2,5)*P(6,3)*Metric(1,3)*Metric(4,5) - P(2,4)*P(3,6)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) - P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5) - P(1,5)*P(6,3)*Metric(2,3)*Metric(4,5) - P(1,4)*P(3,6)*Metric(2,6)*Metric(4,5) - P(1,5)*P(3,6)*Metric(2,6)*Metric(4,5) + P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,5)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,3)*P(2,4)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,4)*Metric(3,6)*Metric(4,5) + P(1,3)*P(2,5)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) + P(1,4)*P(2,6)*Metric(3,6)*Metric(4,5) + P(1,5)*P(2,6)*Metric(3,6)*Metric(4,5) - P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,4)*P(3,5)*Metric(1,5)*Metric(4,6) - P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) - P(1,4)*P(5,3)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6) - P(1,4)*P(3,5)*Metric(2,5)*Metric(4,6) - P(1,6)*P(3,5)*Metric(2,5)*Metric(4,6) + P(1,4)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6) + P(1,5)*P(2,4)*Metric(3,5)*Metric(4,6) + P(1,4)*P(2,5)*Metric(3,5)*Metric(4,6) + P(1,6)*P(2,5)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,6)*Metric(3,5)*Metric(4,6) + P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6) - P(2,5)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,5)*P(3,4)*Metric(1,4)*Metric(5,6) - P(2,6)*P(3,4)*Metric(1,4)*Metric(5,6) - P(1,5)*P(4,3)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6) - P(1,5)*P(3,4)*Metric(2,4)*Metric(5,6) - P(1,6)*P(3,4)*Metric(2,4)*Metric(5,6) + P(1,5)*P(2,3)*Metric(3,4)*Metric(5,6) + P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6) + P(1,5)*P(2,4)*Metric(3,4)*Metric(5,6) + P(1,6)*P(2,4)*Metric(3,4)*Metric(5,6) + P(1,3)*P(2,5)*Metric(3,4)*Metric(5,6) + P(1,4)*P(2,5)*Metric(3,4)*Metric(5,6) + P(1,3)*P(2,6)*Metric(3,4)*Metric(5,6) + P(1,4)*P(2,6)*Metric(3,4)*Metric(5,6)')

VVVVVV23 = Lorentz(name = 'VVVVVV23',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(4,6)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,5)*P(5,6)*Metric(1,6)*Metric(2,3) + P(3,6)*P(6,5)*Metric(1,5)*Metric(2,4) + P(3,5)*P(5,6)*Metric(1,6)*Metric(2,4) + P(4,6)*P(6,5)*Metric(1,3)*Metric(2,5) + P(3,6)*P(6,5)*Metric(1,4)*Metric(2,5) + P(4,5)*P(5,6)*Metric(1,3)*Metric(2,6) + P(3,5)*P(5,6)*Metric(1,4)*Metric(2,6) - 2*P(2,6)*P(6,5)*Metric(1,5)*Metric(3,4) - 2*P(2,5)*P(5,6)*Metric(1,6)*Metric(3,4) - 2*P(1,6)*P(6,5)*Metric(2,5)*Metric(3,4) + 2*P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(1,5)*P(5,6)*Metric(2,6)*Metric(3,4) + 2*P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(4,6)*P(6,5)*Metric(1,2)*Metric(3,5) + P(2,6)*P(6,5)*Metric(1,4)*Metric(3,5) + P(1,6)*P(6,5)*Metric(2,4)*Metric(3,5) - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - 2*P(4,5)*P(5,6)*Metric(1,2)*Metric(3,6) + P(2,5)*P(5,6)*Metric(1,4)*Metric(3,6) + P(1,5)*P(5,6)*Metric(2,4)*Metric(3,6) - P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 2*P(3,6)*P(6,5)*Metric(1,2)*Metric(4,5) + P(2,6)*P(6,5)*Metric(1,3)*Metric(4,5) + P(1,6)*P(6,5)*Metric(2,3)*Metric(4,5) - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(3,5)*P(5,6)*Metric(1,2)*Metric(4,6) + P(2,5)*P(5,6)*Metric(1,3)*Metric(4,6) + P(1,5)*P(5,6)*Metric(2,3)*Metric(4,6) - P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(3,6)*P(4,5)*Metric(1,2)*Metric(5,6) + 2*P(3,5)*P(4,6)*Metric(1,2)*Metric(5,6) - P(2,6)*P(4,5)*Metric(1,3)*Metric(5,6) - P(2,5)*P(4,6)*Metric(1,3)*Metric(5,6) - P(2,6)*P(3,5)*Metric(1,4)*Metric(5,6) - P(2,5)*P(3,6)*Metric(1,4)*Metric(5,6) - P(1,6)*P(4,5)*Metric(2,3)*Metric(5,6) - P(1,5)*P(4,6)*Metric(2,3)*Metric(5,6) - P(1,6)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,5)*P(3,6)*Metric(2,4)*Metric(5,6) + 2*P(1,6)*P(2,5)*Metric(3,4)*Metric(5,6) + 2*P(1,5)*P(2,6)*Metric(3,4)*Metric(5,6)')

VVVVVV24 = Lorentz(name = 'VVVVVV24',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) + Metric(1,4)*Metric(2,6)*Metric(3,5) + Metric(1,5)*Metric(2,4)*Metric(3,6) + Metric(1,4)*Metric(2,5)*Metric(3,6) + Metric(1,6)*Metric(2,3)*Metric(4,5) + Metric(1,3)*Metric(2,6)*Metric(4,5) - 4*Metric(1,2)*Metric(3,6)*Metric(4,5) + Metric(1,5)*Metric(2,3)*Metric(4,6) + Metric(1,3)*Metric(2,5)*Metric(4,6) - 4*Metric(1,2)*Metric(3,5)*Metric(4,6) + Metric(1,4)*Metric(2,3)*Metric(5,6) + Metric(1,3)*Metric(2,4)*Metric(5,6) - 4*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV25 = Lorentz(name = 'VVVVVV25',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'Metric(1,4)*Metric(2,3)*Metric(5,6) + Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV26 = Lorentz(name = 'VVVVVV26',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/4. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/4. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/4. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/4. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/4. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/4. - (Metric(1,5)*Metric(2,3)*Metric(4,6))/4. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/4. + Metric(1,4)*Metric(2,3)*Metric(5,6) + Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV27 = Lorentz(name = 'VVVVVV27',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - Metric(1,2)*Metric(3,6)*Metric(4,5) - Metric(1,2)*Metric(3,5)*Metric(4,6) + Metric(1,4)*Metric(2,3)*Metric(5,6) + Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV28 = Lorentz(name = 'VVVVVV28',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (7*Metric(1,6)*Metric(2,4)*Metric(3,5))/18. - (7*Metric(1,4)*Metric(2,6)*Metric(3,5))/18. - (7*Metric(1,5)*Metric(2,4)*Metric(3,6))/18. - (7*Metric(1,4)*Metric(2,5)*Metric(3,6))/18. - (7*Metric(1,6)*Metric(2,3)*Metric(4,5))/18. - (7*Metric(1,3)*Metric(2,6)*Metric(4,5))/18. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (7*Metric(1,5)*Metric(2,3)*Metric(4,6))/18. - (7*Metric(1,3)*Metric(2,5)*Metric(4,6))/18. + Metric(1,2)*Metric(3,5)*Metric(4,6) + (4*Metric(1,4)*Metric(2,3)*Metric(5,6))/9. + (4*Metric(1,3)*Metric(2,4)*Metric(5,6))/9. - (16*Metric(1,2)*Metric(3,4)*Metric(5,6))/9.')

VVVVVV29 = Lorentz(name = 'VVVVVV29',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/6. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/6. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/6. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/6. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/6. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/6. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (Metric(1,5)*Metric(2,3)*Metric(4,6))/6. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/6. + Metric(1,2)*Metric(3,5)*Metric(4,6) - (2*Metric(1,4)*Metric(2,3)*Metric(5,6))/3. - (2*Metric(1,3)*Metric(2,4)*Metric(5,6))/3. - (4*Metric(1,2)*Metric(3,4)*Metric(5,6))/3.')

VVVVVV30 = Lorentz(name = 'VVVVVV30',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + Metric(1,2)*Metric(3,5)*Metric(4,6) + (2*Metric(1,4)*Metric(2,3)*Metric(5,6))/3. + (2*Metric(1,3)*Metric(2,4)*Metric(5,6))/3. - (4*Metric(1,2)*Metric(3,4)*Metric(5,6))/3.')

VVVVVV31 = Lorentz(name = 'VVVVVV31',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) - Metric(1,5)*Metric(2,6)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) - Metric(1,4)*Metric(2,6)*Metric(3,5) - Metric(1,5)*Metric(2,4)*Metric(3,6) - Metric(1,4)*Metric(2,5)*Metric(3,6) - 6*Metric(1,6)*Metric(2,3)*Metric(4,5) + 3*Metric(1,3)*Metric(2,6)*Metric(4,5) + 3*Metric(1,2)*Metric(3,6)*Metric(4,5) + 3*Metric(1,5)*Metric(2,3)*Metric(4,6) - Metric(1,3)*Metric(2,5)*Metric(4,6) - Metric(1,2)*Metric(3,5)*Metric(4,6) + 3*Metric(1,4)*Metric(2,3)*Metric(5,6) - Metric(1,3)*Metric(2,4)*Metric(5,6) - Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV32 = Lorentz(name = 'VVVVVV32',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) + Metric(1,4)*Metric(2,6)*Metric(3,5) + Metric(1,5)*Metric(2,4)*Metric(3,6) + Metric(1,4)*Metric(2,5)*Metric(3,6) - (2*Metric(1,6)*Metric(2,3)*Metric(4,5))/3. - (2*Metric(1,3)*Metric(2,6)*Metric(4,5))/3. - (2*Metric(1,2)*Metric(3,6)*Metric(4,5))/3. - (2*Metric(1,5)*Metric(2,3)*Metric(4,6))/3. - (2*Metric(1,3)*Metric(2,5)*Metric(4,6))/3. - (2*Metric(1,2)*Metric(3,5)*Metric(4,6))/3. - (2*Metric(1,4)*Metric(2,3)*Metric(5,6))/3. - (2*Metric(1,3)*Metric(2,4)*Metric(5,6))/3. - (2*Metric(1,2)*Metric(3,4)*Metric(5,6))/3.')

VVVVVV33 = Lorentz(name = 'VVVVVV33',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'Metric(1,6)*Metric(2,3)*Metric(4,5) - (Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + Metric(1,5)*Metric(2,3)*Metric(4,6) - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + Metric(1,4)*Metric(2,3)*Metric(5,6) - (Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVV34 = Lorentz(name = 'VVVVVV34',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) - (Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + Metric(1,6)*Metric(2,4)*Metric(3,5) - (Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - 2*Metric(1,6)*Metric(2,3)*Metric(4,5) + Metric(1,3)*Metric(2,6)*Metric(4,5) + Metric(1,2)*Metric(3,6)*Metric(4,5) + Metric(1,5)*Metric(2,3)*Metric(4,6) - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + Metric(1,4)*Metric(2,3)*Metric(5,6) - (Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVV35 = Lorentz(name = 'VVVVVV35',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) - (Metric(1,5)*Metric(2,6)*Metric(3,4))/4. + Metric(1,6)*Metric(2,4)*Metric(3,5) - (Metric(1,4)*Metric(2,6)*Metric(3,5))/4. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/4. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/4. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/4. - (Metric(1,2)*Metric(3,5)*Metric(4,6))/4. - (Metric(1,3)*Metric(2,4)*Metric(5,6))/4. - (Metric(1,2)*Metric(3,4)*Metric(5,6))/4.')

VVVVVV36 = Lorentz(name = 'VVVVVV36',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'Metric(1,6)*Metric(2,4)*Metric(3,5) + Metric(1,4)*Metric(2,6)*Metric(3,5) + Metric(1,5)*Metric(2,4)*Metric(3,6) + Metric(1,4)*Metric(2,5)*Metric(3,6) + Metric(1,6)*Metric(2,3)*Metric(4,5) + Metric(1,3)*Metric(2,6)*Metric(4,5) + Metric(1,5)*Metric(2,3)*Metric(4,6) + Metric(1,3)*Metric(2,5)*Metric(4,6) - 5*Metric(1,4)*Metric(2,3)*Metric(5,6) - 5*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV37 = Lorentz(name = 'VVVVVV37',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(3,6)*P(6,3)*Metric(1,5)*Metric(2,4) + P(3,6)*P(6,3)*Metric(1,4)*Metric(2,5) + P(2,6)*P(6,2)*Metric(1,5)*Metric(3,4) + P(1,6)*P(6,1)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(2,6)*P(6,2)*Metric(1,4)*Metric(3,5) + P(1,6)*P(6,1)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 2*P(3,6)*P(6,3)*Metric(1,2)*Metric(4,5) - 2*P(2,6)*P(6,2)*Metric(1,3)*Metric(4,5) - 2*P(2,3)*P(3,2)*Metric(1,6)*Metric(4,5) - 2*P(1,6)*P(6,1)*Metric(2,3)*Metric(4,5) + 2*P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*P(3,1)*Metric(2,6)*Metric(4,5) + 2*P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - 2*P(1,2)*P(2,1)*Metric(3,6)*Metric(4,5) + 2*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(2,3)*P(3,2)*Metric(1,5)*Metric(4,6) - P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(1,3)*P(3,1)*Metric(2,5)*Metric(4,6) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(1,2)*P(2,1)*Metric(3,5)*Metric(4,6) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(2,3)*P(3,2)*Metric(1,4)*Metric(5,6) - P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(1,3)*P(3,1)*Metric(2,4)*Metric(5,6) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(1,2)*P(2,1)*Metric(3,4)*Metric(5,6) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV38 = Lorentz(name = 'VVVVVV38',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(2,3)*P(3,2)*Metric(1,6)*Metric(4,5) - P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(1,3)*P(3,1)*Metric(2,6)*Metric(4,5) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(1,2)*P(2,1)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) - (P(2,3)*P(3,2)*Metric(1,5)*Metric(4,6))/2. + (P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(1,3)*P(3,1)*Metric(2,5)*Metric(4,6))/2. + (P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(1,2)*P(2,1)*Metric(3,5)*Metric(4,6))/2. + (P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(2,3)*P(3,2)*Metric(1,4)*Metric(5,6))/2. + (P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6))/2. - (P(1,3)*P(3,1)*Metric(2,4)*Metric(5,6))/2. + (P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(1,2)*P(2,1)*Metric(3,4)*Metric(5,6))/2. + (P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVV39 = Lorentz(name = 'VVVVVV39',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(1,2)*P(2,1)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(1,2)*P(2,1)*Metric(3,5)*Metric(4,6) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(1,2)*P(2,1)*Metric(3,4)*Metric(5,6) + 2*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV40 = Lorentz(name = 'VVVVVV40',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) - P(5,3)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,2)*Metric(1,4)*Metric(2,3) - P(5,4)*P(6,2)*Metric(1,4)*Metric(2,3) - P(5,1)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3) - P(5,2)*P(6,4)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,4)*Metric(1,4)*Metric(2,3) - P(4,1)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,5)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,1)*P(6,3)*Metric(1,5)*Metric(2,3) - P(4,5)*P(6,3)*Metric(1,5)*Metric(2,3) - P(4,6)*P(6,4)*Metric(1,5)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) + P(4,6)*P(5,2)*Metric(1,6)*Metric(2,3) + P(4,1)*P(5,3)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3) - P(4,5)*P(5,4)*Metric(1,6)*Metric(2,3) + P(5,2)*P(6,1)*Metric(1,3)*Metric(2,4) - P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) - P(5,3)*P(6,2)*Metric(1,3)*Metric(2,4) - P(5,2)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,3)*Metric(1,3)*Metric(2,4) - P(5,1)*P(6,4)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) + P(3,5)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,6)*P(6,3)*Metric(1,5)*Metric(2,4) + P(3,1)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,5)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,2)*Metric(1,6)*Metric(2,4) + P(3,6)*P(5,2)*Metric(1,6)*Metric(2,4) - P(3,5)*P(5,3)*Metric(1,6)*Metric(2,4) + P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4) - P(3,6)*P(5,4)*Metric(1,6)*Metric(2,4) - P(4,2)*P(6,1)*Metric(1,3)*Metric(2,5) + P(4,5)*P(6,1)*Metric(1,3)*Metric(2,5) + P(4,2)*P(6,3)*Metric(1,3)*Metric(2,5) - P(4,5)*P(6,3)*Metric(1,3)*Metric(2,5) - P(4,6)*P(6,4)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) + P(3,5)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,6)*P(6,3)*Metric(1,4)*Metric(2,5) + P(3,2)*P(6,4)*Metric(1,4)*Metric(2,5) - P(3,5)*P(6,4)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) - P(3,5)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,2)*Metric(1,6)*Metric(2,5) - P(3,6)*P(4,2)*Metric(1,6)*Metric(2,5) - P(3,1)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) - P(3,2)*P(4,6)*Metric(1,6)*Metric(2,5) + P(3,5)*P(4,6)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,2)*P(5,3)*Metric(1,3)*Metric(2,6) - P(4,6)*P(5,3)*Metric(1,3)*Metric(2,6) - P(4,5)*P(5,4)*Metric(1,3)*Metric(2,6) - P(3,2)*P(5,1)*Metric(1,4)*Metric(2,6) + P(3,6)*P(5,1)*Metric(1,4)*Metric(2,6) - P(3,5)*P(5,3)*Metric(1,4)*Metric(2,6) + P(3,2)*P(5,4)*Metric(1,4)*Metric(2,6) - P(3,6)*P(5,4)*Metric(1,4)*Metric(2,6) + P(3,2)*P(4,1)*Metric(1,5)*Metric(2,6) - P(3,6)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) - P(3,5)*P(4,2)*Metric(1,5)*Metric(2,6) - P(3,2)*P(4,5)*Metric(1,5)*Metric(2,6) + P(3,6)*P(4,5)*Metric(1,5)*Metric(2,6) - P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) + P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) + 2*P(4,6)*P(6,4)*Metric(1,2)*Metric(3,5) + P(2,3)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,5)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,3)*P(6,4)*Metric(1,4)*Metric(3,5) + P(2,5)*P(6,4)*Metric(1,4)*Metric(3,5) - P(2,3)*P(4,1)*Metric(1,6)*Metric(3,5) + P(2,5)*P(4,1)*Metric(1,6)*Metric(3,5) + P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5) - P(2,5)*P(4,6)*Metric(1,6)*Metric(3,5) + P(1,3)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,5)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) + P(1,5)*P(6,4)*Metric(2,4)*Metric(3,5) + P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(1,3)*P(4,2)*Metric(2,6)*Metric(3,5) + P(1,5)*P(4,2)*Metric(2,6)*Metric(3,5) + P(1,3)*P(4,6)*Metric(2,6)*Metric(3,5) - P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 2*P(4,5)*P(5,4)*Metric(1,2)*Metric(3,6) + P(2,3)*P(5,1)*Metric(1,4)*Metric(3,6) - P(2,6)*P(5,1)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6) + P(2,6)*P(5,4)*Metric(1,4)*Metric(3,6) - P(2,3)*P(4,1)*Metric(1,5)*Metric(3,6) + P(2,6)*P(4,1)*Metric(1,5)*Metric(3,6) + P(2,3)*P(4,5)*Metric(1,5)*Metric(3,6) - P(2,6)*P(4,5)*Metric(1,5)*Metric(3,6) + P(1,3)*P(5,2)*Metric(2,4)*Metric(3,6) - P(1,6)*P(5,2)*Metric(2,4)*Metric(3,6) - P(1,3)*P(5,4)*Metric(2,4)*Metric(3,6) + P(1,6)*P(5,4)*Metric(2,4)*Metric(3,6) + P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(1,3)*P(4,2)*Metric(2,5)*Metric(3,6) + P(1,6)*P(4,2)*Metric(2,5)*Metric(3,6) + P(1,3)*P(4,5)*Metric(2,5)*Metric(3,6) - P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(3,6)*P(6,3)*Metric(1,2)*Metric(4,5) + P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,5)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,4)*P(6,3)*Metric(1,3)*Metric(4,5) + P(2,5)*P(6,3)*Metric(1,3)*Metric(4,5) - P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,5)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,4)*P(3,6)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) + P(1,4)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,5)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5) + P(1,5)*P(6,3)*Metric(2,3)*Metric(4,5) + P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(1,4)*P(3,2)*Metric(2,6)*Metric(4,5) + P(1,5)*P(3,2)*Metric(2,6)*Metric(4,5) + P(1,4)*P(3,6)*Metric(2,6)*Metric(4,5) - P(1,5)*P(3,6)*Metric(2,6)*Metric(4,5) + P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(1,2)*P(2,1)*Metric(3,6)*Metric(4,5) + P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5) - P(1,5)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,3)*P(2,4)*Metric(3,6)*Metric(4,5) - P(1,6)*P(2,4)*Metric(3,6)*Metric(4,5) - P(1,3)*P(2,5)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) - P(1,4)*P(2,6)*Metric(3,6)*Metric(4,5) + P(1,5)*P(2,6)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(3,5)*P(5,3)*Metric(1,2)*Metric(4,6) + P(2,4)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) + P(2,6)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,4)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,4)*P(3,5)*Metric(1,5)*Metric(4,6) - P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) + P(1,4)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,4)*P(5,3)*Metric(2,3)*Metric(4,6) + P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6) + P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(1,4)*P(3,2)*Metric(2,5)*Metric(4,6) + P(1,6)*P(3,2)*Metric(2,5)*Metric(4,6) + P(1,4)*P(3,5)*Metric(2,5)*Metric(4,6) - P(1,6)*P(3,5)*Metric(2,5)*Metric(4,6) + P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(1,2)*P(2,1)*Metric(3,5)*Metric(4,6) + P(1,4)*P(2,3)*Metric(3,5)*Metric(4,6) - P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6) - P(1,5)*P(2,4)*Metric(3,5)*Metric(4,6) - P(1,4)*P(2,5)*Metric(3,5)*Metric(4,6) + P(1,6)*P(2,5)*Metric(3,5)*Metric(4,6) - P(1,3)*P(2,6)*Metric(3,5)*Metric(4,6) + P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(1,2)*P(2,1)*Metric(3,4)*Metric(5,6) + 2*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV41 = Lorentz(name = 'VVVVVV41',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,3)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,3)*Metric(1,4)*Metric(2,3) + P(4,3)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,2)*P(6,3)*Metric(1,5)*Metric(2,3) - 2*P(4,3)*P(5,2)*Metric(1,6)*Metric(2,3) - 2*P(4,2)*P(5,3)*Metric(1,6)*Metric(2,3) + P(5,3)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,3)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,3)*Metric(1,5)*Metric(2,4) - P(3,2)*P(6,3)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,3)*Metric(1,6)*Metric(2,4) + 2*P(3,2)*P(5,3)*Metric(1,6)*Metric(2,4) + P(4,3)*P(6,1)*Metric(1,3)*Metric(2,5) + P(4,1)*P(6,3)*Metric(1,3)*Metric(2,5) - P(3,1)*P(6,3)*Metric(1,4)*Metric(2,5) - P(3,2)*P(6,3)*Metric(1,4)*Metric(2,5) - P(3,1)*P(4,3)*Metric(1,6)*Metric(2,5) + 2*P(3,2)*P(4,3)*Metric(1,6)*Metric(2,5) - 2*P(4,3)*P(5,1)*Metric(1,3)*Metric(2,6) - 2*P(4,1)*P(5,3)*Metric(1,3)*Metric(2,6) + 2*P(3,1)*P(5,3)*Metric(1,4)*Metric(2,6) - P(3,2)*P(5,3)*Metric(1,4)*Metric(2,6) + 2*P(3,1)*P(4,3)*Metric(1,5)*Metric(2,6) - P(3,2)*P(4,3)*Metric(1,5)*Metric(2,6) + P(5,2)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,2)*Metric(1,2)*Metric(3,4) - P(2,1)*P(6,2)*Metric(1,5)*Metric(3,4) - P(2,3)*P(6,2)*Metric(1,5)*Metric(3,4) - P(2,1)*P(5,2)*Metric(1,6)*Metric(3,4) + 2*P(2,3)*P(5,2)*Metric(1,6)*Metric(3,4) - P(1,2)*P(6,1)*Metric(2,5)*Metric(3,4) - P(1,3)*P(6,1)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(1,2)*P(5,1)*Metric(2,6)*Metric(3,4) + 2*P(1,3)*P(5,1)*Metric(2,6)*Metric(3,4) + P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(4,2)*P(6,1)*Metric(1,2)*Metric(3,5) + P(4,1)*P(6,2)*Metric(1,2)*Metric(3,5) - P(2,1)*P(6,2)*Metric(1,4)*Metric(3,5) - P(2,3)*P(6,2)*Metric(1,4)*Metric(3,5) - P(2,1)*P(4,2)*Metric(1,6)*Metric(3,5) + 2*P(2,3)*P(4,2)*Metric(1,6)*Metric(3,5) - P(1,2)*P(6,1)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,1)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(1,2)*P(4,1)*Metric(2,6)*Metric(3,5) + 2*P(1,3)*P(4,1)*Metric(2,6)*Metric(3,5) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,6)*Metric(3,5) - 2*P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) - 2*P(4,2)*P(5,1)*Metric(1,2)*Metric(3,6) - 2*P(4,1)*P(5,2)*Metric(1,2)*Metric(3,6) + 2*P(2,1)*P(5,2)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,2)*Metric(1,4)*Metric(3,6) + 2*P(2,1)*P(4,2)*Metric(1,5)*Metric(3,6) - P(2,3)*P(4,2)*Metric(1,5)*Metric(3,6) + 2*P(1,2)*P(5,1)*Metric(2,4)*Metric(3,6) - P(1,3)*P(5,1)*Metric(2,4)*Metric(3,6) - 2*P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6) + 2*P(1,2)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,3)*P(4,1)*Metric(2,5)*Metric(3,6) - 2*P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 2*P(3,2)*P(6,1)*Metric(1,2)*Metric(4,5) - 2*P(3,1)*P(6,2)*Metric(1,2)*Metric(4,5) + 2*P(3,1)*P(6,3)*Metric(1,2)*Metric(4,5) + 2*P(3,2)*P(6,3)*Metric(1,2)*Metric(4,5) - 2*P(2,3)*P(6,1)*Metric(1,3)*Metric(4,5) + 2*P(2,1)*P(6,2)*Metric(1,3)*Metric(4,5) + 2*P(2,3)*P(6,2)*Metric(1,3)*Metric(4,5) - 2*P(2,1)*P(6,3)*Metric(1,3)*Metric(4,5) + 2*P(2,3)*P(3,1)*Metric(1,6)*Metric(4,5) + 2*P(2,1)*P(3,2)*Metric(1,6)*Metric(4,5) + 2*P(1,2)*P(6,1)*Metric(2,3)*Metric(4,5) + 2*P(1,3)*P(6,1)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*P(6,2)*Metric(2,3)*Metric(4,5) - 2*P(1,2)*P(6,3)*Metric(2,3)*Metric(4,5) - 2*P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(1,2)*P(3,1)*Metric(2,6)*Metric(4,5) + 2*P(1,3)*P(3,2)*Metric(2,6)*Metric(4,5) - 2*P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,6)*Metric(4,5) - 2*P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(1,3)*P(2,1)*Metric(3,6)*Metric(4,5) + 2*P(1,2)*P(2,3)*Metric(3,6)*Metric(4,5) - 2*P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(3,2)*P(5,1)*Metric(1,2)*Metric(4,6) + P(3,1)*P(5,2)*Metric(1,2)*Metric(4,6) - P(3,1)*P(5,3)*Metric(1,2)*Metric(4,6) - P(3,2)*P(5,3)*Metric(1,2)*Metric(4,6) + P(2,3)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,1)*P(5,2)*Metric(1,3)*Metric(4,6) - P(2,3)*P(5,2)*Metric(1,3)*Metric(4,6) + P(2,1)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,3)*P(3,1)*Metric(1,5)*Metric(4,6) - P(2,1)*P(3,2)*Metric(1,5)*Metric(4,6) - P(1,2)*P(5,1)*Metric(2,3)*Metric(4,6) - P(1,3)*P(5,1)*Metric(2,3)*Metric(4,6) + P(1,3)*P(5,2)*Metric(2,3)*Metric(4,6) + P(1,2)*P(5,3)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(1,2)*P(3,1)*Metric(2,5)*Metric(4,6) - P(1,3)*P(3,2)*Metric(2,5)*Metric(4,6) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(1,3)*P(2,1)*Metric(3,5)*Metric(4,6) - P(1,2)*P(2,3)*Metric(3,5)*Metric(4,6) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(3,2)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,1)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,1)*P(4,3)*Metric(1,2)*Metric(5,6) - P(3,2)*P(4,3)*Metric(1,2)*Metric(5,6) + P(2,3)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,1)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,3)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,1)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,3)*P(3,1)*Metric(1,4)*Metric(5,6) - P(2,1)*P(3,2)*Metric(1,4)*Metric(5,6) - P(1,2)*P(4,1)*Metric(2,3)*Metric(5,6) - P(1,3)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,3)*P(4,2)*Metric(2,3)*Metric(5,6) + P(1,2)*P(4,3)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(1,2)*P(3,1)*Metric(2,4)*Metric(5,6) - P(1,3)*P(3,2)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(1,3)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,2)*P(2,3)*Metric(3,4)*Metric(5,6) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV42 = Lorentz(name = 'VVVVVV42',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) - (P(5,3)*P(6,1)*Metric(1,4)*Metric(2,3))/2. - (3*P(5,4)*P(6,1)*Metric(1,4)*Metric(2,3))/2. + P(5,1)*P(6,2)*Metric(1,4)*Metric(2,3) - (3*P(5,3)*P(6,2)*Metric(1,4)*Metric(2,3))/2. - (P(5,4)*P(6,2)*Metric(1,4)*Metric(2,3))/2. - (P(5,1)*P(6,3)*Metric(1,4)*Metric(2,3))/2. - (3*P(5,2)*P(6,3)*Metric(1,4)*Metric(2,3))/2. + P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3) - (3*P(5,1)*P(6,4)*Metric(1,4)*Metric(2,3))/2. - (P(5,2)*P(6,4)*Metric(1,4)*Metric(2,3))/2. + P(5,3)*P(6,4)*Metric(1,4)*Metric(2,3) + (P(4,5)*P(6,1)*Metric(1,5)*Metric(2,3))/2. - (P(4,6)*P(6,1)*Metric(1,5)*Metric(2,3))/2. - P(4,1)*P(6,2)*Metric(1,5)*Metric(2,3) + (P(4,3)*P(6,2)*Metric(1,5)*Metric(2,3))/2. + (P(4,5)*P(6,2)*Metric(1,5)*Metric(2,3))/2. + (P(4,6)*P(6,2)*Metric(1,5)*Metric(2,3))/2. + (P(4,1)*P(6,3)*Metric(1,5)*Metric(2,3))/2. + P(4,2)*P(6,3)*Metric(1,5)*Metric(2,3) - (P(4,5)*P(6,3)*Metric(1,5)*Metric(2,3))/2. - (P(4,6)*P(6,3)*Metric(1,5)*Metric(2,3))/2. + (3*P(4,1)*P(6,4)*Metric(1,5)*Metric(2,3))/2. - P(4,2)*P(6,4)*Metric(1,5)*Metric(2,3) + (P(4,3)*P(6,4)*Metric(1,5)*Metric(2,3))/2. - (P(4,5)*P(6,4)*Metric(1,5)*Metric(2,3))/2. - (P(4,3)*P(6,5)*Metric(1,5)*Metric(2,3))/2. + P(4,6)*P(6,5)*Metric(1,5)*Metric(2,3) - (P(4,5)*P(5,1)*Metric(1,6)*Metric(2,3))/2. + (P(4,6)*P(5,1)*Metric(1,6)*Metric(2,3))/2. - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) + (P(4,3)*P(5,2)*Metric(1,6)*Metric(2,3))/2. + (P(4,5)*P(5,2)*Metric(1,6)*Metric(2,3))/2. + (P(4,6)*P(5,2)*Metric(1,6)*Metric(2,3))/2. + (P(4,1)*P(5,3)*Metric(1,6)*Metric(2,3))/2. + P(4,2)*P(5,3)*Metric(1,6)*Metric(2,3) - (P(4,5)*P(5,3)*Metric(1,6)*Metric(2,3))/2. - (P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3))/2. + (3*P(4,1)*P(5,4)*Metric(1,6)*Metric(2,3))/2. - P(4,2)*P(5,4)*Metric(1,6)*Metric(2,3) + (P(4,3)*P(5,4)*Metric(1,6)*Metric(2,3))/2. - (P(4,6)*P(5,4)*Metric(1,6)*Metric(2,3))/2. - (P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3))/2. + P(4,5)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,2)*P(6,1)*Metric(1,3)*Metric(2,4) - (3*P(5,3)*P(6,1)*Metric(1,3)*Metric(2,4))/2. - (P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4))/2. + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) - (P(5,3)*P(6,2)*Metric(1,3)*Metric(2,4))/2. - (3*P(5,4)*P(6,2)*Metric(1,3)*Metric(2,4))/2. - (3*P(5,1)*P(6,3)*Metric(1,3)*Metric(2,4))/2. - (P(5,2)*P(6,3)*Metric(1,3)*Metric(2,4))/2. + P(5,4)*P(6,3)*Metric(1,3)*Metric(2,4) - (P(5,1)*P(6,4)*Metric(1,3)*Metric(2,4))/2. - (3*P(5,2)*P(6,4)*Metric(1,3)*Metric(2,4))/2. + P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) + (P(3,5)*P(6,1)*Metric(1,5)*Metric(2,4))/2. - (P(3,6)*P(6,1)*Metric(1,5)*Metric(2,4))/2. - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) + (P(3,4)*P(6,2)*Metric(1,5)*Metric(2,4))/2. + (P(3,5)*P(6,2)*Metric(1,5)*Metric(2,4))/2. + (P(3,6)*P(6,2)*Metric(1,5)*Metric(2,4))/2. + (3*P(3,1)*P(6,3)*Metric(1,5)*Metric(2,4))/2. - P(3,2)*P(6,3)*Metric(1,5)*Metric(2,4) + (P(3,4)*P(6,3)*Metric(1,5)*Metric(2,4))/2. - (P(3,5)*P(6,3)*Metric(1,5)*Metric(2,4))/2. + (P(3,1)*P(6,4)*Metric(1,5)*Metric(2,4))/2. + P(3,2)*P(6,4)*Metric(1,5)*Metric(2,4) - (P(3,5)*P(6,4)*Metric(1,5)*Metric(2,4))/2. - (P(3,6)*P(6,4)*Metric(1,5)*Metric(2,4))/2. - (P(3,4)*P(6,5)*Metric(1,5)*Metric(2,4))/2. + P(3,6)*P(6,5)*Metric(1,5)*Metric(2,4) - (P(3,5)*P(5,1)*Metric(1,6)*Metric(2,4))/2. + (P(3,6)*P(5,1)*Metric(1,6)*Metric(2,4))/2. - P(3,1)*P(5,2)*Metric(1,6)*Metric(2,4) + (P(3,4)*P(5,2)*Metric(1,6)*Metric(2,4))/2. + (P(3,5)*P(5,2)*Metric(1,6)*Metric(2,4))/2. + (P(3,6)*P(5,2)*Metric(1,6)*Metric(2,4))/2. + (3*P(3,1)*P(5,3)*Metric(1,6)*Metric(2,4))/2. - P(3,2)*P(5,3)*Metric(1,6)*Metric(2,4) + (P(3,4)*P(5,3)*Metric(1,6)*Metric(2,4))/2. - (P(3,6)*P(5,3)*Metric(1,6)*Metric(2,4))/2. + (P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4))/2. + P(3,2)*P(5,4)*Metric(1,6)*Metric(2,4) - (P(3,5)*P(5,4)*Metric(1,6)*Metric(2,4))/2. - (P(3,6)*P(5,4)*Metric(1,6)*Metric(2,4))/2. - (P(3,4)*P(5,6)*Metric(1,6)*Metric(2,4))/2. + P(3,5)*P(5,6)*Metric(1,6)*Metric(2,4) - P(4,2)*P(6,1)*Metric(1,3)*Metric(2,5) + (P(4,3)*P(6,1)*Metric(1,3)*Metric(2,5))/2. + (P(4,5)*P(6,1)*Metric(1,3)*Metric(2,5))/2. + (P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5))/2. + (P(4,5)*P(6,2)*Metric(1,3)*Metric(2,5))/2. - (P(4,6)*P(6,2)*Metric(1,3)*Metric(2,5))/2. + P(4,1)*P(6,3)*Metric(1,3)*Metric(2,5) + (P(4,2)*P(6,3)*Metric(1,3)*Metric(2,5))/2. - (P(4,5)*P(6,3)*Metric(1,3)*Metric(2,5))/2. - (P(4,6)*P(6,3)*Metric(1,3)*Metric(2,5))/2. - P(4,1)*P(6,4)*Metric(1,3)*Metric(2,5) + (3*P(4,2)*P(6,4)*Metric(1,3)*Metric(2,5))/2. + (P(4,3)*P(6,4)*Metric(1,3)*Metric(2,5))/2. - (P(4,5)*P(6,4)*Metric(1,3)*Metric(2,5))/2. - (P(4,3)*P(6,5)*Metric(1,3)*Metric(2,5))/2. + P(4,6)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) + (P(3,4)*P(6,1)*Metric(1,4)*Metric(2,5))/2. + (P(3,5)*P(6,1)*Metric(1,4)*Metric(2,5))/2. + (P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5))/2. + (P(3,5)*P(6,2)*Metric(1,4)*Metric(2,5))/2. - (P(3,6)*P(6,2)*Metric(1,4)*Metric(2,5))/2. - P(3,1)*P(6,3)*Metric(1,4)*Metric(2,5) + (3*P(3,2)*P(6,3)*Metric(1,4)*Metric(2,5))/2. + (P(3,4)*P(6,3)*Metric(1,4)*Metric(2,5))/2. - (P(3,5)*P(6,3)*Metric(1,4)*Metric(2,5))/2. + P(3,1)*P(6,4)*Metric(1,4)*Metric(2,5) + (P(3,2)*P(6,4)*Metric(1,4)*Metric(2,5))/2. - (P(3,5)*P(6,4)*Metric(1,4)*Metric(2,5))/2. - (P(3,6)*P(6,4)*Metric(1,4)*Metric(2,5))/2. - (P(3,4)*P(6,5)*Metric(1,4)*Metric(2,5))/2. + P(3,6)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) - (P(3,4)*P(4,1)*Metric(1,6)*Metric(2,5))/2. - (P(3,5)*P(4,1)*Metric(1,6)*Metric(2,5))/2. - (P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5))/2. + P(3,1)*P(4,2)*Metric(1,6)*Metric(2,5) - (P(3,4)*P(4,2)*Metric(1,6)*Metric(2,5))/2. - (P(3,5)*P(4,2)*Metric(1,6)*Metric(2,5))/2. - (P(3,6)*P(4,2)*Metric(1,6)*Metric(2,5))/2. - (P(3,1)*P(4,3)*Metric(1,6)*Metric(2,5))/2. - (P(3,2)*P(4,3)*Metric(1,6)*Metric(2,5))/2. - (P(3,1)*P(4,5)*Metric(1,6)*Metric(2,5))/2. - (P(3,2)*P(4,5)*Metric(1,6)*Metric(2,5))/2. + P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) - (P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5))/2. - (P(3,2)*P(4,6)*Metric(1,6)*Metric(2,5))/2. + P(3,5)*P(4,6)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) + (P(4,3)*P(5,1)*Metric(1,3)*Metric(2,6))/2. + (P(4,5)*P(5,1)*Metric(1,3)*Metric(2,6))/2. + (P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6))/2. - (P(4,5)*P(5,2)*Metric(1,3)*Metric(2,6))/2. + (P(4,6)*P(5,2)*Metric(1,3)*Metric(2,6))/2. + P(4,1)*P(5,3)*Metric(1,3)*Metric(2,6) + (P(4,2)*P(5,3)*Metric(1,3)*Metric(2,6))/2. - (P(4,5)*P(5,3)*Metric(1,3)*Metric(2,6))/2. - (P(4,6)*P(5,3)*Metric(1,3)*Metric(2,6))/2. - P(4,1)*P(5,4)*Metric(1,3)*Metric(2,6) + (3*P(4,2)*P(5,4)*Metric(1,3)*Metric(2,6))/2. + (P(4,3)*P(5,4)*Metric(1,3)*Metric(2,6))/2. - (P(4,6)*P(5,4)*Metric(1,3)*Metric(2,6))/2. - (P(4,3)*P(5,6)*Metric(1,3)*Metric(2,6))/2. + P(4,5)*P(5,6)*Metric(1,3)*Metric(2,6) - P(3,2)*P(5,1)*Metric(1,4)*Metric(2,6) + (P(3,4)*P(5,1)*Metric(1,4)*Metric(2,6))/2. + (P(3,5)*P(5,1)*Metric(1,4)*Metric(2,6))/2. + (P(3,6)*P(5,1)*Metric(1,4)*Metric(2,6))/2. - (P(3,5)*P(5,2)*Metric(1,4)*Metric(2,6))/2. + (P(3,6)*P(5,2)*Metric(1,4)*Metric(2,6))/2. - P(3,1)*P(5,3)*Metric(1,4)*Metric(2,6) + (3*P(3,2)*P(5,3)*Metric(1,4)*Metric(2,6))/2. + (P(3,4)*P(5,3)*Metric(1,4)*Metric(2,6))/2. - (P(3,6)*P(5,3)*Metric(1,4)*Metric(2,6))/2. + P(3,1)*P(5,4)*Metric(1,4)*Metric(2,6) + (P(3,2)*P(5,4)*Metric(1,4)*Metric(2,6))/2. - (P(3,5)*P(5,4)*Metric(1,4)*Metric(2,6))/2. - (P(3,6)*P(5,4)*Metric(1,4)*Metric(2,6))/2. - (P(3,4)*P(5,6)*Metric(1,4)*Metric(2,6))/2. + P(3,5)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,2)*P(4,1)*Metric(1,5)*Metric(2,6) - (P(3,4)*P(4,1)*Metric(1,5)*Metric(2,6))/2. - (P(3,5)*P(4,1)*Metric(1,5)*Metric(2,6))/2. - (P(3,6)*P(4,1)*Metric(1,5)*Metric(2,6))/2. + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) - (P(3,4)*P(4,2)*Metric(1,5)*Metric(2,6))/2. - (P(3,5)*P(4,2)*Metric(1,5)*Metric(2,6))/2. - (P(3,6)*P(4,2)*Metric(1,5)*Metric(2,6))/2. - (P(3,1)*P(4,3)*Metric(1,5)*Metric(2,6))/2. - (P(3,2)*P(4,3)*Metric(1,5)*Metric(2,6))/2. - (P(3,1)*P(4,5)*Metric(1,5)*Metric(2,6))/2. - (P(3,2)*P(4,5)*Metric(1,5)*Metric(2,6))/2. + P(3,6)*P(4,5)*Metric(1,5)*Metric(2,6) - (P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6))/2. - (P(3,2)*P(4,6)*Metric(1,5)*Metric(2,6))/2. + P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) + P(5,2)*P(6,1)*Metric(1,2)*Metric(3,4) - (P(5,3)*P(6,1)*Metric(1,2)*Metric(3,4))/2. - (P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4))/2. + P(5,1)*P(6,2)*Metric(1,2)*Metric(3,4) - (P(5,3)*P(6,2)*Metric(1,2)*Metric(3,4))/2. - (P(5,4)*P(6,2)*Metric(1,2)*Metric(3,4))/2. - (P(5,1)*P(6,3)*Metric(1,2)*Metric(3,4))/2. - (P(5,2)*P(6,3)*Metric(1,2)*Metric(3,4))/2. + P(5,4)*P(6,3)*Metric(1,2)*Metric(3,4) - (P(5,1)*P(6,4)*Metric(1,2)*Metric(3,4))/2. - (P(5,2)*P(6,4)*Metric(1,2)*Metric(3,4))/2. + P(5,3)*P(6,4)*Metric(1,2)*Metric(3,4) - P(2,5)*P(6,1)*Metric(1,5)*Metric(3,4) + P(2,6)*P(6,1)*Metric(1,5)*Metric(3,4) - P(2,1)*P(6,2)*Metric(1,5)*Metric(3,4) - (P(2,3)*P(6,2)*Metric(1,5)*Metric(3,4))/2. - (P(2,4)*P(6,2)*Metric(1,5)*Metric(3,4))/2. + P(2,5)*P(6,2)*Metric(1,5)*Metric(3,4) + (P(2,1)*P(6,3)*Metric(1,5)*Metric(3,4))/2. - (P(2,4)*P(6,3)*Metric(1,5)*Metric(3,4))/2. + (P(2,1)*P(6,4)*Metric(1,5)*Metric(3,4))/2. - (P(2,3)*P(6,4)*Metric(1,5)*Metric(3,4))/2. + (P(2,3)*P(6,5)*Metric(1,5)*Metric(3,4))/2. + (P(2,4)*P(6,5)*Metric(1,5)*Metric(3,4))/2. - 2*P(2,6)*P(6,5)*Metric(1,5)*Metric(3,4) + P(2,5)*P(5,1)*Metric(1,6)*Metric(3,4) - P(2,6)*P(5,1)*Metric(1,6)*Metric(3,4) - P(2,1)*P(5,2)*Metric(1,6)*Metric(3,4) - (P(2,3)*P(5,2)*Metric(1,6)*Metric(3,4))/2. - (P(2,4)*P(5,2)*Metric(1,6)*Metric(3,4))/2. + P(2,6)*P(5,2)*Metric(1,6)*Metric(3,4) + (P(2,1)*P(5,3)*Metric(1,6)*Metric(3,4))/2. - (P(2,4)*P(5,3)*Metric(1,6)*Metric(3,4))/2. + (P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4))/2. - (P(2,3)*P(5,4)*Metric(1,6)*Metric(3,4))/2. + (P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4))/2. + (P(2,4)*P(5,6)*Metric(1,6)*Metric(3,4))/2. - 2*P(2,5)*P(5,6)*Metric(1,6)*Metric(3,4) - P(1,2)*P(6,1)*Metric(2,5)*Metric(3,4) - (P(1,3)*P(6,1)*Metric(2,5)*Metric(3,4))/2. - (P(1,4)*P(6,1)*Metric(2,5)*Metric(3,4))/2. + P(1,5)*P(6,1)*Metric(2,5)*Metric(3,4) - P(1,5)*P(6,2)*Metric(2,5)*Metric(3,4) + P(1,6)*P(6,2)*Metric(2,5)*Metric(3,4) + (P(1,2)*P(6,3)*Metric(2,5)*Metric(3,4))/2. - (P(1,4)*P(6,3)*Metric(2,5)*Metric(3,4))/2. + (P(1,2)*P(6,4)*Metric(2,5)*Metric(3,4))/2. - (P(1,3)*P(6,4)*Metric(2,5)*Metric(3,4))/2. + (P(1,3)*P(6,5)*Metric(2,5)*Metric(3,4))/2. + (P(1,4)*P(6,5)*Metric(2,5)*Metric(3,4))/2. - 2*P(1,6)*P(6,5)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) + (P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. + (P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. + (P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. + (P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + 2*P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(1,2)*P(5,1)*Metric(2,6)*Metric(3,4) - (P(1,3)*P(5,1)*Metric(2,6)*Metric(3,4))/2. - (P(1,4)*P(5,1)*Metric(2,6)*Metric(3,4))/2. + P(1,6)*P(5,1)*Metric(2,6)*Metric(3,4) + P(1,5)*P(5,2)*Metric(2,6)*Metric(3,4) - P(1,6)*P(5,2)*Metric(2,6)*Metric(3,4) + (P(1,2)*P(5,3)*Metric(2,6)*Metric(3,4))/2. - (P(1,4)*P(5,3)*Metric(2,6)*Metric(3,4))/2. + (P(1,2)*P(5,4)*Metric(2,6)*Metric(3,4))/2. - (P(1,3)*P(5,4)*Metric(2,6)*Metric(3,4))/2. + (P(1,3)*P(5,6)*Metric(2,6)*Metric(3,4))/2. + (P(1,4)*P(5,6)*Metric(2,6)*Metric(3,4))/2. - 2*P(1,5)*P(5,6)*Metric(2,6)*Metric(3,4) + P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,6)*Metric(3,4) + (P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - (P(4,2)*P(6,1)*Metric(1,2)*Metric(3,5))/2. + (P(4,3)*P(6,1)*Metric(1,2)*Metric(3,5))/2. - (P(4,1)*P(6,2)*Metric(1,2)*Metric(3,5))/2. + (P(4,3)*P(6,2)*Metric(1,2)*Metric(3,5))/2. - P(4,5)*P(6,3)*Metric(1,2)*Metric(3,5) + P(4,6)*P(6,3)*Metric(1,2)*Metric(3,5) - (P(4,1)*P(6,4)*Metric(1,2)*Metric(3,5))/2. - (P(4,2)*P(6,4)*Metric(1,2)*Metric(3,5))/2. - P(4,3)*P(6,4)*Metric(1,2)*Metric(3,5) + P(4,5)*P(6,4)*Metric(1,2)*Metric(3,5) + (P(4,1)*P(6,5)*Metric(1,2)*Metric(3,5))/2. + (P(4,2)*P(6,5)*Metric(1,2)*Metric(3,5))/2. - 2*P(4,6)*P(6,5)*Metric(1,2)*Metric(3,5) + (P(2,3)*P(6,1)*Metric(1,4)*Metric(3,5))/2. + P(2,4)*P(6,1)*Metric(1,4)*Metric(3,5) - (P(2,5)*P(6,1)*Metric(1,4)*Metric(3,5))/2. - (P(2,6)*P(6,1)*Metric(1,4)*Metric(3,5))/2. + (P(2,1)*P(6,2)*Metric(1,4)*Metric(3,5))/2. + (3*P(2,3)*P(6,2)*Metric(1,4)*Metric(3,5))/2. - P(2,4)*P(6,2)*Metric(1,4)*Metric(3,5) - (P(2,5)*P(6,2)*Metric(1,4)*Metric(3,5))/2. + (P(2,5)*P(6,3)*Metric(1,4)*Metric(3,5))/2. - (P(2,6)*P(6,3)*Metric(1,4)*Metric(3,5))/2. + (P(2,1)*P(6,4)*Metric(1,4)*Metric(3,5))/2. - P(2,3)*P(6,4)*Metric(1,4)*Metric(3,5) + (P(2,5)*P(6,4)*Metric(1,4)*Metric(3,5))/2. + (P(2,6)*P(6,4)*Metric(1,4)*Metric(3,5))/2. - (P(2,1)*P(6,5)*Metric(1,4)*Metric(3,5))/2. + P(2,6)*P(6,5)*Metric(1,4)*Metric(3,5) - (P(2,3)*P(4,1)*Metric(1,6)*Metric(3,5))/2. - P(2,4)*P(4,1)*Metric(1,6)*Metric(3,5) + (P(2,5)*P(4,1)*Metric(1,6)*Metric(3,5))/2. + (P(2,6)*P(4,1)*Metric(1,6)*Metric(3,5))/2. + (P(2,1)*P(4,2)*Metric(1,6)*Metric(3,5))/2. - P(2,3)*P(4,2)*Metric(1,6)*Metric(3,5) + (P(2,5)*P(4,2)*Metric(1,6)*Metric(3,5))/2. - (P(2,6)*P(4,2)*Metric(1,6)*Metric(3,5))/2. - (P(2,1)*P(4,3)*Metric(1,6)*Metric(3,5))/2. + (P(2,4)*P(4,3)*Metric(1,6)*Metric(3,5))/2. + (P(2,3)*P(4,5)*Metric(1,6)*Metric(3,5))/2. - (P(2,4)*P(4,5)*Metric(1,6)*Metric(3,5))/2. + (P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5))/2. + (P(2,4)*P(4,6)*Metric(1,6)*Metric(3,5))/2. - P(2,5)*P(4,6)*Metric(1,6)*Metric(3,5) + (P(1,2)*P(6,1)*Metric(2,4)*Metric(3,5))/2. + (3*P(1,3)*P(6,1)*Metric(2,4)*Metric(3,5))/2. - P(1,4)*P(6,1)*Metric(2,4)*Metric(3,5) - (P(1,5)*P(6,1)*Metric(2,4)*Metric(3,5))/2. + (P(1,3)*P(6,2)*Metric(2,4)*Metric(3,5))/2. + P(1,4)*P(6,2)*Metric(2,4)*Metric(3,5) - (P(1,5)*P(6,2)*Metric(2,4)*Metric(3,5))/2. - (P(1,6)*P(6,2)*Metric(2,4)*Metric(3,5))/2. + (P(1,5)*P(6,3)*Metric(2,4)*Metric(3,5))/2. - (P(1,6)*P(6,3)*Metric(2,4)*Metric(3,5))/2. + (P(1,2)*P(6,4)*Metric(2,4)*Metric(3,5))/2. - P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) + (P(1,5)*P(6,4)*Metric(2,4)*Metric(3,5))/2. + (P(1,6)*P(6,4)*Metric(2,4)*Metric(3,5))/2. - (P(1,2)*P(6,5)*Metric(2,4)*Metric(3,5))/2. + P(1,6)*P(6,5)*Metric(2,4)*Metric(3,5) - (P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (3*P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - (P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) + (P(1,2)*P(4,1)*Metric(2,6)*Metric(3,5))/2. - P(1,3)*P(4,1)*Metric(2,6)*Metric(3,5) + (P(1,5)*P(4,1)*Metric(2,6)*Metric(3,5))/2. - (P(1,6)*P(4,1)*Metric(2,6)*Metric(3,5))/2. - (P(1,3)*P(4,2)*Metric(2,6)*Metric(3,5))/2. - P(1,4)*P(4,2)*Metric(2,6)*Metric(3,5) + (P(1,5)*P(4,2)*Metric(2,6)*Metric(3,5))/2. + (P(1,6)*P(4,2)*Metric(2,6)*Metric(3,5))/2. - (P(1,2)*P(4,3)*Metric(2,6)*Metric(3,5))/2. + (P(1,4)*P(4,3)*Metric(2,6)*Metric(3,5))/2. + (P(1,3)*P(4,5)*Metric(2,6)*Metric(3,5))/2. - (P(1,4)*P(4,5)*Metric(2,6)*Metric(3,5))/2. + (P(1,3)*P(4,6)*Metric(2,6)*Metric(3,5))/2. + (P(1,4)*P(4,6)*Metric(2,6)*Metric(3,5))/2. - P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) - (P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) - (3*P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) - (P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - (P(4,2)*P(5,1)*Metric(1,2)*Metric(3,6))/2. + (P(4,3)*P(5,1)*Metric(1,2)*Metric(3,6))/2. - (P(4,1)*P(5,2)*Metric(1,2)*Metric(3,6))/2. + (P(4,3)*P(5,2)*Metric(1,2)*Metric(3,6))/2. + P(4,5)*P(5,3)*Metric(1,2)*Metric(3,6) - P(4,6)*P(5,3)*Metric(1,2)*Metric(3,6) - (P(4,1)*P(5,4)*Metric(1,2)*Metric(3,6))/2. - (P(4,2)*P(5,4)*Metric(1,2)*Metric(3,6))/2. - P(4,3)*P(5,4)*Metric(1,2)*Metric(3,6) + P(4,6)*P(5,4)*Metric(1,2)*Metric(3,6) + (P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6))/2. + (P(4,2)*P(5,6)*Metric(1,2)*Metric(3,6))/2. - 2*P(4,5)*P(5,6)*Metric(1,2)*Metric(3,6) + (P(2,3)*P(5,1)*Metric(1,4)*Metric(3,6))/2. + P(2,4)*P(5,1)*Metric(1,4)*Metric(3,6) - (P(2,5)*P(5,1)*Metric(1,4)*Metric(3,6))/2. - (P(2,6)*P(5,1)*Metric(1,4)*Metric(3,6))/2. + (P(2,1)*P(5,2)*Metric(1,4)*Metric(3,6))/2. + (3*P(2,3)*P(5,2)*Metric(1,4)*Metric(3,6))/2. - P(2,4)*P(5,2)*Metric(1,4)*Metric(3,6) - (P(2,6)*P(5,2)*Metric(1,4)*Metric(3,6))/2. - (P(2,5)*P(5,3)*Metric(1,4)*Metric(3,6))/2. + (P(2,6)*P(5,3)*Metric(1,4)*Metric(3,6))/2. + (P(2,1)*P(5,4)*Metric(1,4)*Metric(3,6))/2. - P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6) + (P(2,5)*P(5,4)*Metric(1,4)*Metric(3,6))/2. + (P(2,6)*P(5,4)*Metric(1,4)*Metric(3,6))/2. - (P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6))/2. + P(2,5)*P(5,6)*Metric(1,4)*Metric(3,6) - (P(2,3)*P(4,1)*Metric(1,5)*Metric(3,6))/2. - P(2,4)*P(4,1)*Metric(1,5)*Metric(3,6) + (P(2,5)*P(4,1)*Metric(1,5)*Metric(3,6))/2. + (P(2,6)*P(4,1)*Metric(1,5)*Metric(3,6))/2. + (P(2,1)*P(4,2)*Metric(1,5)*Metric(3,6))/2. - P(2,3)*P(4,2)*Metric(1,5)*Metric(3,6) - (P(2,5)*P(4,2)*Metric(1,5)*Metric(3,6))/2. + (P(2,6)*P(4,2)*Metric(1,5)*Metric(3,6))/2. - (P(2,1)*P(4,3)*Metric(1,5)*Metric(3,6))/2. + (P(2,4)*P(4,3)*Metric(1,5)*Metric(3,6))/2. + (P(2,3)*P(4,5)*Metric(1,5)*Metric(3,6))/2. + (P(2,4)*P(4,5)*Metric(1,5)*Metric(3,6))/2. - P(2,6)*P(4,5)*Metric(1,5)*Metric(3,6) + (P(2,3)*P(4,6)*Metric(1,5)*Metric(3,6))/2. - (P(2,4)*P(4,6)*Metric(1,5)*Metric(3,6))/2. + (P(1,2)*P(5,1)*Metric(2,4)*Metric(3,6))/2. + (3*P(1,3)*P(5,1)*Metric(2,4)*Metric(3,6))/2. - P(1,4)*P(5,1)*Metric(2,4)*Metric(3,6) - (P(1,6)*P(5,1)*Metric(2,4)*Metric(3,6))/2. + (P(1,3)*P(5,2)*Metric(2,4)*Metric(3,6))/2. + P(1,4)*P(5,2)*Metric(2,4)*Metric(3,6) - (P(1,5)*P(5,2)*Metric(2,4)*Metric(3,6))/2. - (P(1,6)*P(5,2)*Metric(2,4)*Metric(3,6))/2. - (P(1,5)*P(5,3)*Metric(2,4)*Metric(3,6))/2. + (P(1,6)*P(5,3)*Metric(2,4)*Metric(3,6))/2. + (P(1,2)*P(5,4)*Metric(2,4)*Metric(3,6))/2. - P(1,3)*P(5,4)*Metric(2,4)*Metric(3,6) + (P(1,5)*P(5,4)*Metric(2,4)*Metric(3,6))/2. + (P(1,6)*P(5,4)*Metric(2,4)*Metric(3,6))/2. - (P(1,2)*P(5,6)*Metric(2,4)*Metric(3,6))/2. + P(1,5)*P(5,6)*Metric(2,4)*Metric(3,6) - (P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (3*P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) - (P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + (P(1,2)*P(4,1)*Metric(2,5)*Metric(3,6))/2. - P(1,3)*P(4,1)*Metric(2,5)*Metric(3,6) - (P(1,5)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6))/2. - (P(1,3)*P(4,2)*Metric(2,5)*Metric(3,6))/2. - P(1,4)*P(4,2)*Metric(2,5)*Metric(3,6) + (P(1,5)*P(4,2)*Metric(2,5)*Metric(3,6))/2. + (P(1,6)*P(4,2)*Metric(2,5)*Metric(3,6))/2. - (P(1,2)*P(4,3)*Metric(2,5)*Metric(3,6))/2. + (P(1,4)*P(4,3)*Metric(2,5)*Metric(3,6))/2. + (P(1,3)*P(4,5)*Metric(2,5)*Metric(3,6))/2. + (P(1,4)*P(4,5)*Metric(2,5)*Metric(3,6))/2. - P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) + (P(1,3)*P(4,6)*Metric(2,5)*Metric(3,6))/2. - (P(1,4)*P(4,6)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6) - (3*P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) - (P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - (P(3,2)*P(6,1)*Metric(1,2)*Metric(4,5))/2. + (P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5))/2. - (P(3,1)*P(6,2)*Metric(1,2)*Metric(4,5))/2. + (P(3,4)*P(6,2)*Metric(1,2)*Metric(4,5))/2. - (P(3,1)*P(6,3)*Metric(1,2)*Metric(4,5))/2. - (P(3,2)*P(6,3)*Metric(1,2)*Metric(4,5))/2. - P(3,4)*P(6,3)*Metric(1,2)*Metric(4,5) + P(3,5)*P(6,3)*Metric(1,2)*Metric(4,5) - P(3,5)*P(6,4)*Metric(1,2)*Metric(4,5) + P(3,6)*P(6,4)*Metric(1,2)*Metric(4,5) + (P(3,1)*P(6,5)*Metric(1,2)*Metric(4,5))/2. + (P(3,2)*P(6,5)*Metric(1,2)*Metric(4,5))/2. - 2*P(3,6)*P(6,5)*Metric(1,2)*Metric(4,5) + P(2,3)*P(6,1)*Metric(1,3)*Metric(4,5) + (P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5))/2. - (P(2,5)*P(6,1)*Metric(1,3)*Metric(4,5))/2. - (P(2,6)*P(6,1)*Metric(1,3)*Metric(4,5))/2. + (P(2,1)*P(6,2)*Metric(1,3)*Metric(4,5))/2. - P(2,3)*P(6,2)*Metric(1,3)*Metric(4,5) + (3*P(2,4)*P(6,2)*Metric(1,3)*Metric(4,5))/2. - (P(2,5)*P(6,2)*Metric(1,3)*Metric(4,5))/2. + (P(2,1)*P(6,3)*Metric(1,3)*Metric(4,5))/2. - P(2,4)*P(6,3)*Metric(1,3)*Metric(4,5) + (P(2,5)*P(6,3)*Metric(1,3)*Metric(4,5))/2. + (P(2,6)*P(6,3)*Metric(1,3)*Metric(4,5))/2. + (P(2,5)*P(6,4)*Metric(1,3)*Metric(4,5))/2. - (P(2,6)*P(6,4)*Metric(1,3)*Metric(4,5))/2. - (P(2,1)*P(6,5)*Metric(1,3)*Metric(4,5))/2. + P(2,6)*P(6,5)*Metric(1,3)*Metric(4,5) - P(2,3)*P(3,1)*Metric(1,6)*Metric(4,5) - (P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5))/2. + (P(2,5)*P(3,1)*Metric(1,6)*Metric(4,5))/2. + (P(2,6)*P(3,1)*Metric(1,6)*Metric(4,5))/2. + (P(2,1)*P(3,2)*Metric(1,6)*Metric(4,5))/2. - P(2,4)*P(3,2)*Metric(1,6)*Metric(4,5) + (P(2,5)*P(3,2)*Metric(1,6)*Metric(4,5))/2. - (P(2,6)*P(3,2)*Metric(1,6)*Metric(4,5))/2. - (P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5))/2. + (P(2,3)*P(3,4)*Metric(1,6)*Metric(4,5))/2. - (P(2,3)*P(3,5)*Metric(1,6)*Metric(4,5))/2. + (P(2,4)*P(3,5)*Metric(1,6)*Metric(4,5))/2. + (P(2,3)*P(3,6)*Metric(1,6)*Metric(4,5))/2. + (P(2,4)*P(3,6)*Metric(1,6)*Metric(4,5))/2. - P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) + (P(1,2)*P(6,1)*Metric(2,3)*Metric(4,5))/2. - P(1,3)*P(6,1)*Metric(2,3)*Metric(4,5) + (3*P(1,4)*P(6,1)*Metric(2,3)*Metric(4,5))/2. - (P(1,5)*P(6,1)*Metric(2,3)*Metric(4,5))/2. + P(1,3)*P(6,2)*Metric(2,3)*Metric(4,5) + (P(1,4)*P(6,2)*Metric(2,3)*Metric(4,5))/2. - (P(1,5)*P(6,2)*Metric(2,3)*Metric(4,5))/2. - (P(1,6)*P(6,2)*Metric(2,3)*Metric(4,5))/2. + (P(1,2)*P(6,3)*Metric(2,3)*Metric(4,5))/2. - P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5) + (P(1,5)*P(6,3)*Metric(2,3)*Metric(4,5))/2. + (P(1,6)*P(6,3)*Metric(2,3)*Metric(4,5))/2. + (P(1,5)*P(6,4)*Metric(2,3)*Metric(4,5))/2. - (P(1,6)*P(6,4)*Metric(2,3)*Metric(4,5))/2. - (P(1,2)*P(6,5)*Metric(2,3)*Metric(4,5))/2. + P(1,6)*P(6,5)*Metric(2,3)*Metric(4,5) - (P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) - (3*P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) - (P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + (P(1,2)*P(3,1)*Metric(2,6)*Metric(4,5))/2. - P(1,4)*P(3,1)*Metric(2,6)*Metric(4,5) + (P(1,5)*P(3,1)*Metric(2,6)*Metric(4,5))/2. - (P(1,6)*P(3,1)*Metric(2,6)*Metric(4,5))/2. - P(1,3)*P(3,2)*Metric(2,6)*Metric(4,5) - (P(1,4)*P(3,2)*Metric(2,6)*Metric(4,5))/2. + (P(1,5)*P(3,2)*Metric(2,6)*Metric(4,5))/2. + (P(1,6)*P(3,2)*Metric(2,6)*Metric(4,5))/2. - (P(1,2)*P(3,4)*Metric(2,6)*Metric(4,5))/2. + (P(1,3)*P(3,4)*Metric(2,6)*Metric(4,5))/2. - (P(1,3)*P(3,5)*Metric(2,6)*Metric(4,5))/2. + (P(1,4)*P(3,5)*Metric(2,6)*Metric(4,5))/2. + (P(1,3)*P(3,6)*Metric(2,6)*Metric(4,5))/2. + (P(1,4)*P(3,6)*Metric(2,6)*Metric(4,5))/2. - P(1,5)*P(3,6)*Metric(2,6)*Metric(4,5) - (P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) - (3*P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - (P(1,3)*P(2,1)*Metric(3,6)*Metric(4,5))/2. - (P(1,4)*P(2,1)*Metric(3,6)*Metric(4,5))/2. - (P(1,2)*P(2,3)*Metric(3,6)*Metric(4,5))/2. + P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5) - (P(1,5)*P(2,3)*Metric(3,6)*Metric(4,5))/2. - (P(1,6)*P(2,3)*Metric(3,6)*Metric(4,5))/2. - (P(1,2)*P(2,4)*Metric(3,6)*Metric(4,5))/2. + P(1,3)*P(2,4)*Metric(3,6)*Metric(4,5) - (P(1,5)*P(2,4)*Metric(3,6)*Metric(4,5))/2. - (P(1,6)*P(2,4)*Metric(3,6)*Metric(4,5))/2. - (P(1,3)*P(2,5)*Metric(3,6)*Metric(4,5))/2. - (P(1,4)*P(2,5)*Metric(3,6)*Metric(4,5))/2. + P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) - (P(1,3)*P(2,6)*Metric(3,6)*Metric(4,5))/2. - (P(1,4)*P(2,6)*Metric(3,6)*Metric(4,5))/2. + P(1,5)*P(2,6)*Metric(3,6)*Metric(4,5) + (P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + (P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + (P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - (P(3,2)*P(5,1)*Metric(1,2)*Metric(4,6))/2. + (P(3,4)*P(5,1)*Metric(1,2)*Metric(4,6))/2. - (P(3,1)*P(5,2)*Metric(1,2)*Metric(4,6))/2. + (P(3,4)*P(5,2)*Metric(1,2)*Metric(4,6))/2. - (P(3,1)*P(5,3)*Metric(1,2)*Metric(4,6))/2. - (P(3,2)*P(5,3)*Metric(1,2)*Metric(4,6))/2. - P(3,4)*P(5,3)*Metric(1,2)*Metric(4,6) + P(3,6)*P(5,3)*Metric(1,2)*Metric(4,6) + P(3,5)*P(5,4)*Metric(1,2)*Metric(4,6) - P(3,6)*P(5,4)*Metric(1,2)*Metric(4,6) + (P(3,1)*P(5,6)*Metric(1,2)*Metric(4,6))/2. + (P(3,2)*P(5,6)*Metric(1,2)*Metric(4,6))/2. - 2*P(3,5)*P(5,6)*Metric(1,2)*Metric(4,6) + P(2,3)*P(5,1)*Metric(1,3)*Metric(4,6) + (P(2,4)*P(5,1)*Metric(1,3)*Metric(4,6))/2. - (P(2,5)*P(5,1)*Metric(1,3)*Metric(4,6))/2. - (P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6))/2. + (P(2,1)*P(5,2)*Metric(1,3)*Metric(4,6))/2. - P(2,3)*P(5,2)*Metric(1,3)*Metric(4,6) + (3*P(2,4)*P(5,2)*Metric(1,3)*Metric(4,6))/2. - (P(2,6)*P(5,2)*Metric(1,3)*Metric(4,6))/2. + (P(2,1)*P(5,3)*Metric(1,3)*Metric(4,6))/2. - P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) + (P(2,5)*P(5,3)*Metric(1,3)*Metric(4,6))/2. + (P(2,6)*P(5,3)*Metric(1,3)*Metric(4,6))/2. - (P(2,5)*P(5,4)*Metric(1,3)*Metric(4,6))/2. + (P(2,6)*P(5,4)*Metric(1,3)*Metric(4,6))/2. - (P(2,1)*P(5,6)*Metric(1,3)*Metric(4,6))/2. + P(2,5)*P(5,6)*Metric(1,3)*Metric(4,6) - P(2,3)*P(3,1)*Metric(1,5)*Metric(4,6) - (P(2,4)*P(3,1)*Metric(1,5)*Metric(4,6))/2. + (P(2,5)*P(3,1)*Metric(1,5)*Metric(4,6))/2. + (P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6))/2. + (P(2,1)*P(3,2)*Metric(1,5)*Metric(4,6))/2. - P(2,4)*P(3,2)*Metric(1,5)*Metric(4,6) - (P(2,5)*P(3,2)*Metric(1,5)*Metric(4,6))/2. + (P(2,6)*P(3,2)*Metric(1,5)*Metric(4,6))/2. - (P(2,1)*P(3,4)*Metric(1,5)*Metric(4,6))/2. + (P(2,3)*P(3,4)*Metric(1,5)*Metric(4,6))/2. + (P(2,3)*P(3,5)*Metric(1,5)*Metric(4,6))/2. + (P(2,4)*P(3,5)*Metric(1,5)*Metric(4,6))/2. - P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) - (P(2,3)*P(3,6)*Metric(1,5)*Metric(4,6))/2. + (P(2,4)*P(3,6)*Metric(1,5)*Metric(4,6))/2. + (P(1,2)*P(5,1)*Metric(2,3)*Metric(4,6))/2. - P(1,3)*P(5,1)*Metric(2,3)*Metric(4,6) + (3*P(1,4)*P(5,1)*Metric(2,3)*Metric(4,6))/2. - (P(1,6)*P(5,1)*Metric(2,3)*Metric(4,6))/2. + P(1,3)*P(5,2)*Metric(2,3)*Metric(4,6) + (P(1,4)*P(5,2)*Metric(2,3)*Metric(4,6))/2. - (P(1,5)*P(5,2)*Metric(2,3)*Metric(4,6))/2. - (P(1,6)*P(5,2)*Metric(2,3)*Metric(4,6))/2. + (P(1,2)*P(5,3)*Metric(2,3)*Metric(4,6))/2. - P(1,4)*P(5,3)*Metric(2,3)*Metric(4,6) + (P(1,5)*P(5,3)*Metric(2,3)*Metric(4,6))/2. + (P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6))/2. - (P(1,5)*P(5,4)*Metric(2,3)*Metric(4,6))/2. + (P(1,6)*P(5,4)*Metric(2,3)*Metric(4,6))/2. - (P(1,2)*P(5,6)*Metric(2,3)*Metric(4,6))/2. + P(1,5)*P(5,6)*Metric(2,3)*Metric(4,6) - (P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) - (3*P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) - (P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + (P(1,2)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - P(1,4)*P(3,1)*Metric(2,5)*Metric(4,6) - (P(1,5)*P(3,1)*Metric(2,5)*Metric(4,6))/2. + (P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - P(1,3)*P(3,2)*Metric(2,5)*Metric(4,6) - (P(1,4)*P(3,2)*Metric(2,5)*Metric(4,6))/2. + (P(1,5)*P(3,2)*Metric(2,5)*Metric(4,6))/2. + (P(1,6)*P(3,2)*Metric(2,5)*Metric(4,6))/2. - (P(1,2)*P(3,4)*Metric(2,5)*Metric(4,6))/2. + (P(1,3)*P(3,4)*Metric(2,5)*Metric(4,6))/2. + (P(1,3)*P(3,5)*Metric(2,5)*Metric(4,6))/2. + (P(1,4)*P(3,5)*Metric(2,5)*Metric(4,6))/2. - P(1,6)*P(3,5)*Metric(2,5)*Metric(4,6) - (P(1,3)*P(3,6)*Metric(2,5)*Metric(4,6))/2. + (P(1,4)*P(3,6)*Metric(2,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6) - (3*P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - (P(1,3)*P(2,1)*Metric(3,5)*Metric(4,6))/2. - (P(1,4)*P(2,1)*Metric(3,5)*Metric(4,6))/2. - (P(1,2)*P(2,3)*Metric(3,5)*Metric(4,6))/2. + P(1,4)*P(2,3)*Metric(3,5)*Metric(4,6) - (P(1,5)*P(2,3)*Metric(3,5)*Metric(4,6))/2. - (P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6))/2. - (P(1,2)*P(2,4)*Metric(3,5)*Metric(4,6))/2. + P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6) - (P(1,5)*P(2,4)*Metric(3,5)*Metric(4,6))/2. - (P(1,6)*P(2,4)*Metric(3,5)*Metric(4,6))/2. - (P(1,3)*P(2,5)*Metric(3,5)*Metric(4,6))/2. - (P(1,4)*P(2,5)*Metric(3,5)*Metric(4,6))/2. + P(1,6)*P(2,5)*Metric(3,5)*Metric(4,6) - (P(1,3)*P(2,6)*Metric(3,5)*Metric(4,6))/2. - (P(1,4)*P(2,6)*Metric(3,5)*Metric(4,6))/2. + P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6) + (P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + (P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + (P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(3,2)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,4)*P(4,1)*Metric(1,2)*Metric(5,6) - (P(3,5)*P(4,1)*Metric(1,2)*Metric(5,6))/2. - (P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6))/2. + P(3,1)*P(4,2)*Metric(1,2)*Metric(5,6) + P(3,4)*P(4,2)*Metric(1,2)*Metric(5,6) - (P(3,5)*P(4,2)*Metric(1,2)*Metric(5,6))/2. - (P(3,6)*P(4,2)*Metric(1,2)*Metric(5,6))/2. + P(3,1)*P(4,3)*Metric(1,2)*Metric(5,6) + P(3,2)*P(4,3)*Metric(1,2)*Metric(5,6) - (P(3,1)*P(4,5)*Metric(1,2)*Metric(5,6))/2. - (P(3,2)*P(4,5)*Metric(1,2)*Metric(5,6))/2. + 2*P(3,6)*P(4,5)*Metric(1,2)*Metric(5,6) - (P(3,1)*P(4,6)*Metric(1,2)*Metric(5,6))/2. - (P(3,2)*P(4,6)*Metric(1,2)*Metric(5,6))/2. + 2*P(3,5)*P(4,6)*Metric(1,2)*Metric(5,6) - 2*P(2,3)*P(4,1)*Metric(1,3)*Metric(5,6) + 2*P(2,4)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,1)*P(4,2)*Metric(1,3)*Metric(5,6) + 2*P(2,3)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,1)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,4)*P(4,3)*Metric(1,3)*Metric(5,6) + (P(2,5)*P(4,3)*Metric(1,3)*Metric(5,6))/2. + (P(2,6)*P(4,3)*Metric(1,3)*Metric(5,6))/2. + (P(2,1)*P(4,5)*Metric(1,3)*Metric(5,6))/2. - P(2,6)*P(4,5)*Metric(1,3)*Metric(5,6) + (P(2,1)*P(4,6)*Metric(1,3)*Metric(5,6))/2. - P(2,5)*P(4,6)*Metric(1,3)*Metric(5,6) + 2*P(2,3)*P(3,1)*Metric(1,4)*Metric(5,6) - 2*P(2,4)*P(3,1)*Metric(1,4)*Metric(5,6) - P(2,1)*P(3,2)*Metric(1,4)*Metric(5,6) + 2*P(2,4)*P(3,2)*Metric(1,4)*Metric(5,6) - P(2,1)*P(3,4)*Metric(1,4)*Metric(5,6) - P(2,3)*P(3,4)*Metric(1,4)*Metric(5,6) + (P(2,5)*P(3,4)*Metric(1,4)*Metric(5,6))/2. + (P(2,6)*P(3,4)*Metric(1,4)*Metric(5,6))/2. + (P(2,1)*P(3,5)*Metric(1,4)*Metric(5,6))/2. - P(2,6)*P(3,5)*Metric(1,4)*Metric(5,6) + (P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6))/2. - P(2,5)*P(3,6)*Metric(1,4)*Metric(5,6) - P(1,2)*P(4,1)*Metric(2,3)*Metric(5,6) + 2*P(1,3)*P(4,1)*Metric(2,3)*Metric(5,6) - 2*P(1,3)*P(4,2)*Metric(2,3)*Metric(5,6) + 2*P(1,4)*P(4,2)*Metric(2,3)*Metric(5,6) - P(1,2)*P(4,3)*Metric(2,3)*Metric(5,6) - P(1,4)*P(4,3)*Metric(2,3)*Metric(5,6) + (P(1,5)*P(4,3)*Metric(2,3)*Metric(5,6))/2. + (P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6))/2. + (P(1,2)*P(4,5)*Metric(2,3)*Metric(5,6))/2. - P(1,6)*P(4,5)*Metric(2,3)*Metric(5,6) + (P(1,2)*P(4,6)*Metric(2,3)*Metric(5,6))/2. - P(1,5)*P(4,6)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(1,2)*P(3,1)*Metric(2,4)*Metric(5,6) + 2*P(1,4)*P(3,1)*Metric(2,4)*Metric(5,6) + 2*P(1,3)*P(3,2)*Metric(2,4)*Metric(5,6) - 2*P(1,4)*P(3,2)*Metric(2,4)*Metric(5,6) - P(1,2)*P(3,4)*Metric(2,4)*Metric(5,6) - P(1,3)*P(3,4)*Metric(2,4)*Metric(5,6) + (P(1,5)*P(3,4)*Metric(2,4)*Metric(5,6))/2. + (P(1,6)*P(3,4)*Metric(2,4)*Metric(5,6))/2. + (P(1,2)*P(3,5)*Metric(2,4)*Metric(5,6))/2. - P(1,6)*P(3,5)*Metric(2,4)*Metric(5,6) + (P(1,2)*P(3,6)*Metric(2,4)*Metric(5,6))/2. - P(1,5)*P(3,6)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(1,3)*P(2,1)*Metric(3,4)*Metric(5,6) + P(1,4)*P(2,1)*Metric(3,4)*Metric(5,6) + P(1,2)*P(2,3)*Metric(3,4)*Metric(5,6) + P(1,4)*P(2,3)*Metric(3,4)*Metric(5,6) - (P(1,5)*P(2,3)*Metric(3,4)*Metric(5,6))/2. - (P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6))/2. + P(1,2)*P(2,4)*Metric(3,4)*Metric(5,6) + P(1,3)*P(2,4)*Metric(3,4)*Metric(5,6) - (P(1,5)*P(2,4)*Metric(3,4)*Metric(5,6))/2. - (P(1,6)*P(2,4)*Metric(3,4)*Metric(5,6))/2. - (P(1,3)*P(2,5)*Metric(3,4)*Metric(5,6))/2. - (P(1,4)*P(2,5)*Metric(3,4)*Metric(5,6))/2. + 2*P(1,6)*P(2,5)*Metric(3,4)*Metric(5,6) - (P(1,3)*P(2,6)*Metric(3,4)*Metric(5,6))/2. - (P(1,4)*P(2,6)*Metric(3,4)*Metric(5,6))/2. + 2*P(1,5)*P(2,6)*Metric(3,4)*Metric(5,6) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV43 = Lorentz(name = 'VVVVVV43',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,4)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,4)*Metric(1,4)*Metric(2,3) - (P(4,3)*P(6,2)*Metric(1,5)*Metric(2,3))/2. - (P(4,2)*P(6,3)*Metric(1,5)*Metric(2,3))/2. - P(4,1)*P(6,4)*Metric(1,5)*Metric(2,3) + (P(4,2)*P(6,4)*Metric(1,5)*Metric(2,3))/2. + (P(4,3)*P(6,4)*Metric(1,5)*Metric(2,3))/2. - (P(4,3)*P(5,2)*Metric(1,6)*Metric(2,3))/2. - (P(4,2)*P(5,3)*Metric(1,6)*Metric(2,3))/2. - P(4,1)*P(5,4)*Metric(1,6)*Metric(2,3) + (P(4,2)*P(5,4)*Metric(1,6)*Metric(2,3))/2. + (P(4,3)*P(5,4)*Metric(1,6)*Metric(2,3))/2. + P(5,3)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,2)*P(6,4)*Metric(1,3)*Metric(2,4) - (P(3,4)*P(6,2)*Metric(1,5)*Metric(2,4))/2. - P(3,1)*P(6,3)*Metric(1,5)*Metric(2,4) + (P(3,2)*P(6,3)*Metric(1,5)*Metric(2,4))/2. + (P(3,4)*P(6,3)*Metric(1,5)*Metric(2,4))/2. - (P(3,2)*P(6,4)*Metric(1,5)*Metric(2,4))/2. - (P(3,4)*P(5,2)*Metric(1,6)*Metric(2,4))/2. - P(3,1)*P(5,3)*Metric(1,6)*Metric(2,4) + (P(3,2)*P(5,3)*Metric(1,6)*Metric(2,4))/2. + (P(3,4)*P(5,3)*Metric(1,6)*Metric(2,4))/2. - (P(3,2)*P(5,4)*Metric(1,6)*Metric(2,4))/2. - (P(4,3)*P(6,1)*Metric(1,3)*Metric(2,5))/2. - (P(4,1)*P(6,3)*Metric(1,3)*Metric(2,5))/2. + (P(4,1)*P(6,4)*Metric(1,3)*Metric(2,5))/2. - P(4,2)*P(6,4)*Metric(1,3)*Metric(2,5) + (P(4,3)*P(6,4)*Metric(1,3)*Metric(2,5))/2. - (P(3,4)*P(6,1)*Metric(1,4)*Metric(2,5))/2. + (P(3,1)*P(6,3)*Metric(1,4)*Metric(2,5))/2. - P(3,2)*P(6,3)*Metric(1,4)*Metric(2,5) + (P(3,4)*P(6,3)*Metric(1,4)*Metric(2,5))/2. - (P(3,1)*P(6,4)*Metric(1,4)*Metric(2,5))/2. + (P(3,4)*P(4,1)*Metric(1,6)*Metric(2,5))/2. + (P(3,4)*P(4,2)*Metric(1,6)*Metric(2,5))/2. + (P(3,1)*P(4,3)*Metric(1,6)*Metric(2,5))/2. + (P(3,2)*P(4,3)*Metric(1,6)*Metric(2,5))/2. - (P(4,3)*P(5,1)*Metric(1,3)*Metric(2,6))/2. - (P(4,1)*P(5,3)*Metric(1,3)*Metric(2,6))/2. + (P(4,1)*P(5,4)*Metric(1,3)*Metric(2,6))/2. - P(4,2)*P(5,4)*Metric(1,3)*Metric(2,6) + (P(4,3)*P(5,4)*Metric(1,3)*Metric(2,6))/2. - (P(3,4)*P(5,1)*Metric(1,4)*Metric(2,6))/2. + (P(3,1)*P(5,3)*Metric(1,4)*Metric(2,6))/2. - P(3,2)*P(5,3)*Metric(1,4)*Metric(2,6) + (P(3,4)*P(5,3)*Metric(1,4)*Metric(2,6))/2. - (P(3,1)*P(5,4)*Metric(1,4)*Metric(2,6))/2. + (P(3,4)*P(4,1)*Metric(1,5)*Metric(2,6))/2. + (P(3,4)*P(4,2)*Metric(1,5)*Metric(2,6))/2. + (P(3,1)*P(4,3)*Metric(1,5)*Metric(2,6))/2. + (P(3,2)*P(4,3)*Metric(1,5)*Metric(2,6))/2. + P(5,2)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,2)*Metric(1,2)*Metric(3,4) + P(5,4)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,3)*P(6,4)*Metric(1,2)*Metric(3,4) - P(2,1)*P(6,2)*Metric(1,5)*Metric(3,4) + (P(2,3)*P(6,2)*Metric(1,5)*Metric(3,4))/2. + (P(2,4)*P(6,2)*Metric(1,5)*Metric(3,4))/2. - (P(2,4)*P(6,3)*Metric(1,5)*Metric(3,4))/2. - (P(2,3)*P(6,4)*Metric(1,5)*Metric(3,4))/2. - P(2,1)*P(5,2)*Metric(1,6)*Metric(3,4) + (P(2,3)*P(5,2)*Metric(1,6)*Metric(3,4))/2. + (P(2,4)*P(5,2)*Metric(1,6)*Metric(3,4))/2. - (P(2,4)*P(5,3)*Metric(1,6)*Metric(3,4))/2. - (P(2,3)*P(5,4)*Metric(1,6)*Metric(3,4))/2. - P(1,2)*P(6,1)*Metric(2,5)*Metric(3,4) + (P(1,3)*P(6,1)*Metric(2,5)*Metric(3,4))/2. + (P(1,4)*P(6,1)*Metric(2,5)*Metric(3,4))/2. - (P(1,4)*P(6,3)*Metric(2,5)*Metric(3,4))/2. - (P(1,3)*P(6,4)*Metric(2,5)*Metric(3,4))/2. + P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) - (P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - P(1,2)*P(5,1)*Metric(2,6)*Metric(3,4) + (P(1,3)*P(5,1)*Metric(2,6)*Metric(3,4))/2. + (P(1,4)*P(5,1)*Metric(2,6)*Metric(3,4))/2. - (P(1,4)*P(5,3)*Metric(2,6)*Metric(3,4))/2. - (P(1,3)*P(5,4)*Metric(2,6)*Metric(3,4))/2. + P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,6)*Metric(3,4) - (P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(4,2)*P(6,1)*Metric(1,2)*Metric(3,5))/2. - (P(4,1)*P(6,2)*Metric(1,2)*Metric(3,5))/2. + (P(4,1)*P(6,4)*Metric(1,2)*Metric(3,5))/2. + (P(4,2)*P(6,4)*Metric(1,2)*Metric(3,5))/2. - P(4,3)*P(6,4)*Metric(1,2)*Metric(3,5) - (P(2,4)*P(6,1)*Metric(1,4)*Metric(3,5))/2. + (P(2,1)*P(6,2)*Metric(1,4)*Metric(3,5))/2. - P(2,3)*P(6,2)*Metric(1,4)*Metric(3,5) + (P(2,4)*P(6,2)*Metric(1,4)*Metric(3,5))/2. - (P(2,1)*P(6,4)*Metric(1,4)*Metric(3,5))/2. + (P(2,4)*P(4,1)*Metric(1,6)*Metric(3,5))/2. + (P(2,1)*P(4,2)*Metric(1,6)*Metric(3,5))/2. + (P(2,3)*P(4,2)*Metric(1,6)*Metric(3,5))/2. + (P(2,4)*P(4,3)*Metric(1,6)*Metric(3,5))/2. + (P(1,2)*P(6,1)*Metric(2,4)*Metric(3,5))/2. - P(1,3)*P(6,1)*Metric(2,4)*Metric(3,5) + (P(1,4)*P(6,1)*Metric(2,4)*Metric(3,5))/2. - (P(1,4)*P(6,2)*Metric(2,4)*Metric(3,5))/2. - (P(1,2)*P(6,4)*Metric(2,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - (P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(1,2)*P(4,1)*Metric(2,6)*Metric(3,5))/2. + (P(1,3)*P(4,1)*Metric(2,6)*Metric(3,5))/2. + (P(1,4)*P(4,2)*Metric(2,6)*Metric(3,5))/2. + (P(1,4)*P(4,3)*Metric(2,6)*Metric(3,5))/2. - (P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) - (P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(4,2)*P(5,1)*Metric(1,2)*Metric(3,6))/2. - (P(4,1)*P(5,2)*Metric(1,2)*Metric(3,6))/2. + (P(4,1)*P(5,4)*Metric(1,2)*Metric(3,6))/2. + (P(4,2)*P(5,4)*Metric(1,2)*Metric(3,6))/2. - P(4,3)*P(5,4)*Metric(1,2)*Metric(3,6) - (P(2,4)*P(5,1)*Metric(1,4)*Metric(3,6))/2. + (P(2,1)*P(5,2)*Metric(1,4)*Metric(3,6))/2. - P(2,3)*P(5,2)*Metric(1,4)*Metric(3,6) + (P(2,4)*P(5,2)*Metric(1,4)*Metric(3,6))/2. - (P(2,1)*P(5,4)*Metric(1,4)*Metric(3,6))/2. + (P(2,4)*P(4,1)*Metric(1,5)*Metric(3,6))/2. + (P(2,1)*P(4,2)*Metric(1,5)*Metric(3,6))/2. + (P(2,3)*P(4,2)*Metric(1,5)*Metric(3,6))/2. + (P(2,4)*P(4,3)*Metric(1,5)*Metric(3,6))/2. + (P(1,2)*P(5,1)*Metric(2,4)*Metric(3,6))/2. - P(1,3)*P(5,1)*Metric(2,4)*Metric(3,6) + (P(1,4)*P(5,1)*Metric(2,4)*Metric(3,6))/2. - (P(1,4)*P(5,2)*Metric(2,4)*Metric(3,6))/2. - (P(1,2)*P(5,4)*Metric(2,4)*Metric(3,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6) - (P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(1,2)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(1,3)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(1,4)*P(4,2)*Metric(2,5)*Metric(3,6))/2. + (P(1,4)*P(4,3)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6) - (P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(3,2)*P(6,1)*Metric(1,2)*Metric(4,5))/2. - (P(3,1)*P(6,2)*Metric(1,2)*Metric(4,5))/2. + (P(3,1)*P(6,3)*Metric(1,2)*Metric(4,5))/2. + (P(3,2)*P(6,3)*Metric(1,2)*Metric(4,5))/2. - P(3,4)*P(6,3)*Metric(1,2)*Metric(4,5) - (P(2,3)*P(6,1)*Metric(1,3)*Metric(4,5))/2. + (P(2,1)*P(6,2)*Metric(1,3)*Metric(4,5))/2. + (P(2,3)*P(6,2)*Metric(1,3)*Metric(4,5))/2. - P(2,4)*P(6,2)*Metric(1,3)*Metric(4,5) - (P(2,1)*P(6,3)*Metric(1,3)*Metric(4,5))/2. + (P(2,3)*P(3,1)*Metric(1,6)*Metric(4,5))/2. + (P(2,1)*P(3,2)*Metric(1,6)*Metric(4,5))/2. + (P(2,4)*P(3,2)*Metric(1,6)*Metric(4,5))/2. + (P(2,3)*P(3,4)*Metric(1,6)*Metric(4,5))/2. + (P(1,2)*P(6,1)*Metric(2,3)*Metric(4,5))/2. + (P(1,3)*P(6,1)*Metric(2,3)*Metric(4,5))/2. - P(1,4)*P(6,1)*Metric(2,3)*Metric(4,5) - (P(1,3)*P(6,2)*Metric(2,3)*Metric(4,5))/2. - (P(1,2)*P(6,3)*Metric(2,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) - (P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(1,2)*P(3,1)*Metric(2,6)*Metric(4,5))/2. + (P(1,4)*P(3,1)*Metric(2,6)*Metric(4,5))/2. + (P(1,3)*P(3,2)*Metric(2,6)*Metric(4,5))/2. + (P(1,3)*P(3,4)*Metric(2,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) - (P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(1,3)*P(2,1)*Metric(3,6)*Metric(4,5))/2. + (P(1,4)*P(2,1)*Metric(3,6)*Metric(4,5))/2. + (P(1,2)*P(2,3)*Metric(3,6)*Metric(4,5))/2. + (P(1,2)*P(2,4)*Metric(3,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. - (P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. - (P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) - (P(3,2)*P(5,1)*Metric(1,2)*Metric(4,6))/2. - (P(3,1)*P(5,2)*Metric(1,2)*Metric(4,6))/2. + (P(3,1)*P(5,3)*Metric(1,2)*Metric(4,6))/2. + (P(3,2)*P(5,3)*Metric(1,2)*Metric(4,6))/2. - P(3,4)*P(5,3)*Metric(1,2)*Metric(4,6) - (P(2,3)*P(5,1)*Metric(1,3)*Metric(4,6))/2. + (P(2,1)*P(5,2)*Metric(1,3)*Metric(4,6))/2. + (P(2,3)*P(5,2)*Metric(1,3)*Metric(4,6))/2. - P(2,4)*P(5,2)*Metric(1,3)*Metric(4,6) - (P(2,1)*P(5,3)*Metric(1,3)*Metric(4,6))/2. + (P(2,3)*P(3,1)*Metric(1,5)*Metric(4,6))/2. + (P(2,1)*P(3,2)*Metric(1,5)*Metric(4,6))/2. + (P(2,4)*P(3,2)*Metric(1,5)*Metric(4,6))/2. + (P(2,3)*P(3,4)*Metric(1,5)*Metric(4,6))/2. + (P(1,2)*P(5,1)*Metric(2,3)*Metric(4,6))/2. + (P(1,3)*P(5,1)*Metric(2,3)*Metric(4,6))/2. - P(1,4)*P(5,1)*Metric(2,3)*Metric(4,6) - (P(1,3)*P(5,2)*Metric(2,3)*Metric(4,6))/2. - (P(1,2)*P(5,3)*Metric(2,3)*Metric(4,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) - (P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(1,2)*P(3,1)*Metric(2,5)*Metric(4,6))/2. + (P(1,4)*P(3,1)*Metric(2,5)*Metric(4,6))/2. + (P(1,3)*P(3,2)*Metric(2,5)*Metric(4,6))/2. + (P(1,3)*P(3,4)*Metric(2,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6) - (P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(1,3)*P(2,1)*Metric(3,5)*Metric(4,6))/2. + (P(1,4)*P(2,1)*Metric(3,5)*Metric(4,6))/2. + (P(1,2)*P(2,3)*Metric(3,5)*Metric(4,6))/2. + (P(1,2)*P(2,4)*Metric(3,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(3,2)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,4)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,1)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,4)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,1)*P(4,3)*Metric(1,2)*Metric(5,6) - P(3,2)*P(4,3)*Metric(1,2)*Metric(5,6) + P(2,3)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,4)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,1)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,3)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,1)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,4)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,3)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,4)*P(3,1)*Metric(1,4)*Metric(5,6) - P(2,1)*P(3,2)*Metric(1,4)*Metric(5,6) - P(2,4)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,4)*Metric(1,4)*Metric(5,6) - P(2,3)*P(3,4)*Metric(1,4)*Metric(5,6) - P(1,2)*P(4,1)*Metric(2,3)*Metric(5,6) - P(1,3)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,3)*P(4,2)*Metric(2,3)*Metric(5,6) - P(1,4)*P(4,2)*Metric(2,3)*Metric(5,6) + P(1,2)*P(4,3)*Metric(2,3)*Metric(5,6) - P(1,4)*P(4,3)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(1,2)*P(3,1)*Metric(2,4)*Metric(5,6) - P(1,4)*P(3,1)*Metric(2,4)*Metric(5,6) - P(1,3)*P(3,2)*Metric(2,4)*Metric(5,6) + P(1,4)*P(3,2)*Metric(2,4)*Metric(5,6) + P(1,2)*P(3,4)*Metric(2,4)*Metric(5,6) - P(1,3)*P(3,4)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(1,3)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,2)*P(2,3)*Metric(3,4)*Metric(5,6) + P(1,4)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,2)*P(2,4)*Metric(3,4)*Metric(5,6) + P(1,3)*P(2,4)*Metric(3,4)*Metric(5,6) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV44 = Lorentz(name = 'VVVVVV44',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) - P(5,3)*P(6,2)*Metric(1,3)*Metric(2,4) - P(5,1)*P(6,4)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) + P(3,5)*P(6,2)*Metric(1,5)*Metric(2,4) + P(3,1)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,5)*P(6,4)*Metric(1,5)*Metric(2,4) + 2*P(3,5)*P(5,3)*Metric(1,6)*Metric(2,4) + P(4,1)*P(6,2)*Metric(1,3)*Metric(2,5) - P(4,3)*P(6,2)*Metric(1,3)*Metric(2,5) - P(4,1)*P(6,5)*Metric(1,3)*Metric(2,5) + P(4,3)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,1)*P(6,2)*Metric(1,4)*Metric(2,5) + P(3,4)*P(6,2)*Metric(1,4)*Metric(2,5) + P(3,1)*P(6,5)*Metric(1,4)*Metric(2,5) - P(3,4)*P(6,5)*Metric(1,4)*Metric(2,5) + 2*P(3,4)*P(4,3)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) - P(4,1)*P(5,2)*Metric(1,3)*Metric(2,6) + P(4,3)*P(5,2)*Metric(1,3)*Metric(2,6) + P(4,2)*P(5,3)*Metric(1,3)*Metric(2,6) - P(4,6)*P(5,3)*Metric(1,3)*Metric(2,6) + P(4,1)*P(5,6)*Metric(1,3)*Metric(2,6) - P(4,3)*P(5,6)*Metric(1,3)*Metric(2,6) + P(3,1)*P(5,2)*Metric(1,4)*Metric(2,6) - P(3,4)*P(5,2)*Metric(1,4)*Metric(2,6) - P(3,5)*P(5,3)*Metric(1,4)*Metric(2,6) - P(3,1)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,4)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) - P(3,5)*P(4,2)*Metric(1,5)*Metric(2,6) - P(3,4)*P(4,3)*Metric(1,5)*Metric(2,6) - P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) + P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) + P(5,1)*P(6,3)*Metric(1,2)*Metric(3,4) - P(5,2)*P(6,3)*Metric(1,2)*Metric(3,4) - P(5,1)*P(6,4)*Metric(1,2)*Metric(3,4) + P(5,2)*P(6,4)*Metric(1,2)*Metric(3,4) - P(2,1)*P(6,3)*Metric(1,5)*Metric(3,4) + P(2,5)*P(6,3)*Metric(1,5)*Metric(3,4) + P(2,1)*P(6,4)*Metric(1,5)*Metric(3,4) - P(2,5)*P(6,4)*Metric(1,5)*Metric(3,4) + 2*P(2,5)*P(5,2)*Metric(1,6)*Metric(3,4) + P(1,6)*P(6,1)*Metric(2,5)*Metric(3,4) + P(1,3)*P(6,2)*Metric(2,5)*Metric(3,4) - P(1,4)*P(6,2)*Metric(2,5)*Metric(3,4) + P(1,2)*P(6,3)*Metric(2,5)*Metric(3,4) - P(1,5)*P(6,3)*Metric(2,5)*Metric(3,4) - P(1,2)*P(6,4)*Metric(2,5)*Metric(3,4) + P(1,5)*P(6,4)*Metric(2,5)*Metric(3,4) - P(1,3)*P(6,5)*Metric(2,5)*Metric(3,4) + P(1,4)*P(6,5)*Metric(2,5)*Metric(3,4) - 2*P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(1,3)*P(5,2)*Metric(2,6)*Metric(3,4) + P(1,4)*P(5,2)*Metric(2,6)*Metric(3,4) + P(1,3)*P(5,6)*Metric(2,6)*Metric(3,4) - P(1,4)*P(5,6)*Metric(2,6)*Metric(3,4) + P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(4,1)*P(6,3)*Metric(1,2)*Metric(3,5) - P(4,2)*P(6,3)*Metric(1,2)*Metric(3,5) - P(4,1)*P(6,5)*Metric(1,2)*Metric(3,5) + P(4,2)*P(6,5)*Metric(1,2)*Metric(3,5) - P(2,1)*P(6,3)*Metric(1,4)*Metric(3,5) + P(2,4)*P(6,3)*Metric(1,4)*Metric(3,5) + P(2,1)*P(6,5)*Metric(1,4)*Metric(3,5) - P(2,4)*P(6,5)*Metric(1,4)*Metric(3,5) + 2*P(2,4)*P(4,2)*Metric(1,6)*Metric(3,5) + P(1,6)*P(6,1)*Metric(2,4)*Metric(3,5) + P(1,3)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,5)*P(6,2)*Metric(2,4)*Metric(3,5) + P(1,2)*P(6,3)*Metric(2,4)*Metric(3,5) - P(1,4)*P(6,3)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) + P(1,5)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,2)*P(6,5)*Metric(2,4)*Metric(3,5) + P(1,4)*P(6,5)*Metric(2,4)*Metric(3,5) - 2*P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(1,3)*P(4,2)*Metric(2,6)*Metric(3,5) + P(1,5)*P(4,2)*Metric(2,6)*Metric(3,5) + P(1,3)*P(4,6)*Metric(2,6)*Metric(3,5) - P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(4,3)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,6)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,3)*P(5,2)*Metric(1,2)*Metric(3,6) - P(4,6)*P(5,2)*Metric(1,2)*Metric(3,6) - P(4,1)*P(5,3)*Metric(1,2)*Metric(3,6) + P(4,2)*P(5,3)*Metric(1,2)*Metric(3,6) + P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) - P(4,2)*P(5,6)*Metric(1,2)*Metric(3,6) - P(2,5)*P(5,2)*Metric(1,4)*Metric(3,6) + P(2,1)*P(5,3)*Metric(1,4)*Metric(3,6) - P(2,4)*P(5,3)*Metric(1,4)*Metric(3,6) - P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) + P(2,4)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,4)*P(4,2)*Metric(1,5)*Metric(3,6) + P(2,1)*P(4,3)*Metric(1,5)*Metric(3,6) - P(2,5)*P(4,3)*Metric(1,5)*Metric(3,6) - P(2,1)*P(4,6)*Metric(1,5)*Metric(3,6) + P(2,5)*P(4,6)*Metric(1,5)*Metric(3,6) - P(1,2)*P(5,3)*Metric(2,4)*Metric(3,6) + P(1,4)*P(5,3)*Metric(2,4)*Metric(3,6) + P(1,2)*P(5,6)*Metric(2,4)*Metric(3,6) - P(1,4)*P(5,6)*Metric(2,4)*Metric(3,6) + P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(1,2)*P(4,3)*Metric(2,5)*Metric(3,6) + P(1,5)*P(4,3)*Metric(2,5)*Metric(3,6) + P(1,2)*P(4,6)*Metric(2,5)*Metric(3,6) - P(1,5)*P(4,6)*Metric(2,5)*Metric(3,6) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 2*P(1,6)*P(6,1)*Metric(2,3)*Metric(4,5) + 2*P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(3,4)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,6)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,4)*P(5,2)*Metric(1,2)*Metric(4,6) + P(3,6)*P(5,2)*Metric(1,2)*Metric(4,6) - P(3,5)*P(5,3)*Metric(1,2)*Metric(4,6) + P(2,4)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,5)*P(5,2)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) + P(2,6)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,4)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) - P(2,1)*P(3,4)*Metric(1,5)*Metric(4,6) + P(2,5)*P(3,4)*Metric(1,5)*Metric(4,6) + P(2,4)*P(3,5)*Metric(1,5)*Metric(4,6) - P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,6)*Metric(1,5)*Metric(4,6) - P(2,5)*P(3,6)*Metric(1,5)*Metric(4,6) + P(1,2)*P(3,4)*Metric(2,5)*Metric(4,6) - P(1,5)*P(3,4)*Metric(2,5)*Metric(4,6) - P(1,2)*P(3,6)*Metric(2,5)*Metric(4,6) + P(1,5)*P(3,6)*Metric(2,5)*Metric(4,6) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6) - P(1,5)*P(2,4)*Metric(3,5)*Metric(4,6) - P(1,3)*P(2,6)*Metric(3,5)*Metric(4,6) + P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6) + P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(3,5)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,5)*P(4,2)*Metric(1,2)*Metric(5,6) + P(3,6)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,4)*P(4,3)*Metric(1,2)*Metric(5,6) + P(2,5)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,4)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,5)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,6)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,5)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,5)*P(3,4)*Metric(1,4)*Metric(5,6) - P(2,6)*P(3,4)*Metric(1,4)*Metric(5,6) - P(2,1)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,4)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) - P(2,4)*P(3,6)*Metric(1,4)*Metric(5,6) + P(1,2)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,4)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,2)*P(3,6)*Metric(2,4)*Metric(5,6) + P(1,4)*P(3,6)*Metric(2,4)*Metric(5,6) + P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(1,3)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,3)*P(2,6)*Metric(3,4)*Metric(5,6) + P(1,4)*P(2,6)*Metric(3,4)*Metric(5,6) + P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV45 = Lorentz(name = 'VVVVVV45',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(3,6)*P(6,3)*Metric(1,5)*Metric(2,4) + P(3,5)*P(5,3)*Metric(1,6)*Metric(2,4) + P(3,6)*P(6,3)*Metric(1,4)*Metric(2,5) + P(3,4)*P(4,3)*Metric(1,6)*Metric(2,5) + P(3,5)*P(5,3)*Metric(1,4)*Metric(2,6) + P(3,4)*P(4,3)*Metric(1,5)*Metric(2,6) + P(2,6)*P(6,2)*Metric(1,5)*Metric(3,4) + P(2,5)*P(5,2)*Metric(1,6)*Metric(3,4) + P(1,6)*P(6,1)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(1,5)*P(5,1)*Metric(2,6)*Metric(3,4) - P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(2,6)*P(6,2)*Metric(1,4)*Metric(3,5) + P(2,4)*P(4,2)*Metric(1,6)*Metric(3,5) + P(1,6)*P(6,1)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(1,4)*P(4,1)*Metric(2,6)*Metric(3,5) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(2,5)*P(5,2)*Metric(1,4)*Metric(3,6) + P(2,4)*P(4,2)*Metric(1,5)*Metric(3,6) + P(1,5)*P(5,1)*Metric(2,4)*Metric(3,6) - P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(1,4)*P(4,1)*Metric(2,5)*Metric(3,6) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 2*P(3,6)*P(6,3)*Metric(1,2)*Metric(4,5) - 2*P(2,6)*P(6,2)*Metric(1,3)*Metric(4,5) - 2*P(1,6)*P(6,1)*Metric(2,3)*Metric(4,5) + 2*P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(3,5)*P(5,3)*Metric(1,2)*Metric(4,6) - 2*P(2,5)*P(5,2)*Metric(1,3)*Metric(4,6) - 2*P(1,5)*P(5,1)*Metric(2,3)*Metric(4,6) + 2*P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) + 2*P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(3,4)*P(4,3)*Metric(1,2)*Metric(5,6) - 2*P(2,4)*P(4,2)*Metric(1,3)*Metric(5,6) - 2*P(1,4)*P(4,1)*Metric(2,3)*Metric(5,6) + 2*P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) + 2*P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV46 = Lorentz(name = 'VVVVVV46',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(3,4)*P(4,3)*Metric(1,6)*Metric(2,5) + P(3,4)*P(4,3)*Metric(1,5)*Metric(2,6) - P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(2,4)*P(4,2)*Metric(1,6)*Metric(3,5) - P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(1,4)*P(4,1)*Metric(2,6)*Metric(3,5) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(2,4)*P(4,2)*Metric(1,5)*Metric(3,6) - P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(1,4)*P(4,1)*Metric(2,5)*Metric(3,6) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(2,3)*P(3,2)*Metric(1,6)*Metric(4,5) - P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(1,3)*P(3,1)*Metric(2,6)*Metric(4,5) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(1,2)*P(2,1)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(2,3)*P(3,2)*Metric(1,5)*Metric(4,6) - P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(1,3)*P(3,1)*Metric(2,5)*Metric(4,6) - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(1,2)*P(2,1)*Metric(3,5)*Metric(4,6) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(3,4)*P(4,3)*Metric(1,2)*Metric(5,6) - 2*P(2,4)*P(4,2)*Metric(1,3)*Metric(5,6) - 2*P(2,3)*P(3,2)*Metric(1,4)*Metric(5,6) - 2*P(1,4)*P(4,1)*Metric(2,3)*Metric(5,6) + 2*P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) + 2*P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(1,3)*P(3,1)*Metric(2,4)*Metric(5,6) + 2*P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(1,2)*P(2,1)*Metric(3,4)*Metric(5,6) + 2*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV47 = Lorentz(name = 'VVVVVV47',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,4)*P(6,1)*Metric(1,4)*Metric(2,3) - P(5,6)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,4)*Metric(1,4)*Metric(2,3) - P(5,1)*P(6,5)*Metric(1,4)*Metric(2,3) + P(4,5)*P(6,1)*Metric(1,5)*Metric(2,3) - P(4,6)*P(6,1)*Metric(1,5)*Metric(2,3) - P(4,1)*P(6,4)*Metric(1,5)*Metric(2,3) + P(4,1)*P(6,5)*Metric(1,5)*Metric(2,3) - P(4,5)*P(5,1)*Metric(1,6)*Metric(2,3) + P(4,6)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,4)*Metric(1,6)*Metric(2,3) + P(4,1)*P(5,6)*Metric(1,6)*Metric(2,3) + (P(5,6)*P(6,1)*Metric(1,3)*Metric(2,4))/2. + (P(5,1)*P(6,5)*Metric(1,3)*Metric(2,4))/2. - (P(3,5)*P(6,1)*Metric(1,5)*Metric(2,4))/2. + (P(3,6)*P(6,1)*Metric(1,5)*Metric(2,4))/2. - (P(3,1)*P(6,5)*Metric(1,5)*Metric(2,4))/2. + (P(3,5)*P(5,1)*Metric(1,6)*Metric(2,4))/2. - (P(3,6)*P(5,1)*Metric(1,6)*Metric(2,4))/2. - (P(3,1)*P(5,6)*Metric(1,6)*Metric(2,4))/2. + (P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5))/2. + (P(4,1)*P(6,4)*Metric(1,3)*Metric(2,5))/2. - (P(3,4)*P(6,1)*Metric(1,4)*Metric(2,5))/2. + (P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5))/2. - (P(3,1)*P(6,4)*Metric(1,4)*Metric(2,5))/2. + (P(3,4)*P(4,1)*Metric(1,6)*Metric(2,5))/2. - (P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5))/2. - (P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5))/2. + (P(4,5)*P(5,1)*Metric(1,3)*Metric(2,6))/2. + (P(4,1)*P(5,4)*Metric(1,3)*Metric(2,6))/2. - (P(3,4)*P(5,1)*Metric(1,4)*Metric(2,6))/2. + (P(3,5)*P(5,1)*Metric(1,4)*Metric(2,6))/2. - (P(3,1)*P(5,4)*Metric(1,4)*Metric(2,6))/2. + (P(3,4)*P(4,1)*Metric(1,5)*Metric(2,6))/2. - (P(3,5)*P(4,1)*Metric(1,5)*Metric(2,6))/2. - (P(3,1)*P(4,5)*Metric(1,5)*Metric(2,6))/2. + (P(5,6)*P(6,1)*Metric(1,2)*Metric(3,4))/2. + (P(5,1)*P(6,5)*Metric(1,2)*Metric(3,4))/2. - (P(2,5)*P(6,1)*Metric(1,5)*Metric(3,4))/2. + (P(2,6)*P(6,1)*Metric(1,5)*Metric(3,4))/2. - (P(2,1)*P(6,5)*Metric(1,5)*Metric(3,4))/2. + (P(2,5)*P(5,1)*Metric(1,6)*Metric(3,4))/2. - (P(2,6)*P(5,1)*Metric(1,6)*Metric(3,4))/2. - (P(2,1)*P(5,6)*Metric(1,6)*Metric(3,4))/2. + (P(1,4)*P(6,1)*Metric(2,5)*Metric(3,4))/2. + (P(1,5)*P(6,1)*Metric(2,5)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. + (P(1,4)*P(5,1)*Metric(2,6)*Metric(3,4))/2. + (P(1,6)*P(5,1)*Metric(2,6)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(4,6)*P(6,1)*Metric(1,2)*Metric(3,5))/2. + (P(4,1)*P(6,4)*Metric(1,2)*Metric(3,5))/2. - (P(2,4)*P(6,1)*Metric(1,4)*Metric(3,5))/2. + (P(2,6)*P(6,1)*Metric(1,4)*Metric(3,5))/2. - (P(2,1)*P(6,4)*Metric(1,4)*Metric(3,5))/2. + (P(2,4)*P(4,1)*Metric(1,6)*Metric(3,5))/2. - (P(2,6)*P(4,1)*Metric(1,6)*Metric(3,5))/2. - (P(2,1)*P(4,6)*Metric(1,6)*Metric(3,5))/2. + (P(1,4)*P(6,1)*Metric(2,4)*Metric(3,5))/2. + (P(1,5)*P(6,1)*Metric(2,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(1,5)*P(4,1)*Metric(2,6)*Metric(3,5))/2. + (P(1,6)*P(4,1)*Metric(2,6)*Metric(3,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(4,5)*P(5,1)*Metric(1,2)*Metric(3,6))/2. + (P(4,1)*P(5,4)*Metric(1,2)*Metric(3,6))/2. - (P(2,4)*P(5,1)*Metric(1,4)*Metric(3,6))/2. + (P(2,5)*P(5,1)*Metric(1,4)*Metric(3,6))/2. - (P(2,1)*P(5,4)*Metric(1,4)*Metric(3,6))/2. + (P(2,4)*P(4,1)*Metric(1,5)*Metric(3,6))/2. - (P(2,5)*P(4,1)*Metric(1,5)*Metric(3,6))/2. - (P(2,1)*P(4,5)*Metric(1,5)*Metric(3,6))/2. + (P(1,4)*P(5,1)*Metric(2,4)*Metric(3,6))/2. + (P(1,6)*P(5,1)*Metric(2,4)*Metric(3,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(1,5)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - P(3,6)*P(6,1)*Metric(1,2)*Metric(4,5) - P(2,6)*P(6,1)*Metric(1,3)*Metric(4,5) + P(2,6)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,6)*Metric(1,6)*Metric(4,5) - P(1,4)*P(6,1)*Metric(2,3)*Metric(4,5) - P(1,5)*P(6,1)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + (P(1,4)*P(3,1)*Metric(2,6)*Metric(4,5))/2. + (P(1,5)*P(3,1)*Metric(2,6)*Metric(4,5))/2. - P(1,6)*P(3,1)*Metric(2,6)*Metric(4,5) - (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + (P(1,4)*P(2,1)*Metric(3,6)*Metric(4,5))/2. + (P(1,5)*P(2,1)*Metric(3,6)*Metric(4,5))/2. - P(1,6)*P(2,1)*Metric(3,6)*Metric(4,5) - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(3,5)*P(5,1)*Metric(1,2)*Metric(4,6) - P(2,5)*P(5,1)*Metric(1,3)*Metric(4,6) + P(2,5)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,5)*Metric(1,5)*Metric(4,6) - P(1,4)*P(5,1)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,1)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + (P(1,4)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - P(1,5)*P(3,1)*Metric(2,5)*Metric(4,6) + (P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) - (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(1,4)*P(2,1)*Metric(3,5)*Metric(4,6))/2. - P(1,5)*P(2,1)*Metric(3,5)*Metric(4,6) + (P(1,6)*P(2,1)*Metric(3,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - P(3,4)*P(4,1)*Metric(1,2)*Metric(5,6) - P(2,4)*P(4,1)*Metric(1,3)*Metric(5,6) + P(2,4)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,4)*Metric(1,4)*Metric(5,6) - P(1,5)*P(4,1)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,1)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(1,4)*P(3,1)*Metric(2,4)*Metric(5,6) + (P(1,5)*P(3,1)*Metric(2,4)*Metric(5,6))/2. + (P(1,6)*P(3,1)*Metric(2,4)*Metric(5,6))/2. + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - P(1,4)*P(2,1)*Metric(3,4)*Metric(5,6) + (P(1,5)*P(2,1)*Metric(3,4)*Metric(5,6))/2. + (P(1,6)*P(2,1)*Metric(3,4)*Metric(5,6))/2. + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) - (P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVV48 = Lorentz(name = 'VVVVVV48',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,6)*P(6,1)*Metric(1,4)*Metric(2,3) + P(4,6)*P(6,1)*Metric(1,5)*Metric(2,3) - P(4,6)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,6)*Metric(1,6)*Metric(2,3) - (P(5,6)*P(6,1)*Metric(1,3)*Metric(2,4))/2. - (P(3,6)*P(6,1)*Metric(1,5)*Metric(2,4))/2. + (P(3,6)*P(5,1)*Metric(1,6)*Metric(2,4))/2. + (P(3,1)*P(5,6)*Metric(1,6)*Metric(2,4))/2. - (P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5))/2. - (P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5))/2. + (P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5))/2. + (P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5))/2. - (P(5,6)*P(6,1)*Metric(1,2)*Metric(3,4))/2. - (P(2,6)*P(6,1)*Metric(1,5)*Metric(3,4))/2. + (P(2,6)*P(5,1)*Metric(1,6)*Metric(3,4))/2. + (P(2,1)*P(5,6)*Metric(1,6)*Metric(3,4))/2. - (P(1,6)*P(5,1)*Metric(2,6)*Metric(3,4))/2. + (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(4,6)*P(6,1)*Metric(1,2)*Metric(3,5))/2. - (P(2,6)*P(6,1)*Metric(1,4)*Metric(3,5))/2. + (P(2,6)*P(4,1)*Metric(1,6)*Metric(3,5))/2. + (P(2,1)*P(4,6)*Metric(1,6)*Metric(3,5))/2. - (P(1,6)*P(4,1)*Metric(2,6)*Metric(3,5))/2. + (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(1,6)*P(5,1)*Metric(2,4)*Metric(3,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + P(3,6)*P(6,1)*Metric(1,2)*Metric(4,5) + P(2,6)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,6)*P(3,1)*Metric(1,6)*Metric(4,5) - P(2,1)*P(3,6)*Metric(1,6)*Metric(4,5) + P(1,6)*P(3,1)*Metric(2,6)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(1,6)*P(2,1)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(1,6)*P(5,1)*Metric(2,3)*Metric(4,6) - P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - (P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(1,6)*P(2,1)*Metric(3,5)*Metric(4,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + P(1,6)*P(4,1)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - (P(1,6)*P(3,1)*Metric(2,4)*Metric(5,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(1,6)*P(2,1)*Metric(3,4)*Metric(5,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVV49 = Lorentz(name = 'VVVVVV49',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,6)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,6)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,5)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,5)*Metric(1,4)*Metric(2,3) - P(4,5)*P(6,1)*Metric(1,5)*Metric(2,3) + P(4,6)*P(6,1)*Metric(1,5)*Metric(2,3) - 2*P(4,6)*P(6,2)*Metric(1,5)*Metric(2,3) - P(4,1)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,5)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,1)*Metric(1,6)*Metric(2,3) - 2*P(4,5)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,6)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,6)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,5)*Metric(1,3)*Metric(2,4) + P(5,2)*P(6,5)*Metric(1,3)*Metric(2,4) - P(3,5)*P(6,1)*Metric(1,5)*Metric(2,4) + P(3,6)*P(6,1)*Metric(1,5)*Metric(2,4) - 2*P(3,6)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,1)*P(6,5)*Metric(1,5)*Metric(2,4) + P(3,5)*P(5,1)*Metric(1,6)*Metric(2,4) - P(3,6)*P(5,1)*Metric(1,6)*Metric(2,4) - 2*P(3,5)*P(5,2)*Metric(1,6)*Metric(2,4) - P(3,1)*P(5,6)*Metric(1,6)*Metric(2,4) - 2*P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5) - P(4,5)*P(6,2)*Metric(1,3)*Metric(2,5) + P(4,6)*P(6,2)*Metric(1,3)*Metric(2,5) - P(4,2)*P(6,5)*Metric(1,3)*Metric(2,5) - 2*P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,5)*P(6,2)*Metric(1,4)*Metric(2,5) + P(3,6)*P(6,2)*Metric(1,4)*Metric(2,5) - P(3,2)*P(6,5)*Metric(1,4)*Metric(2,5) + 2*P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5) + 2*P(3,5)*P(4,2)*Metric(1,6)*Metric(2,5) + 2*P(3,2)*P(4,5)*Metric(1,6)*Metric(2,5) + 2*P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5) - 2*P(4,5)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,5)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,6)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,2)*P(5,6)*Metric(1,3)*Metric(2,6) - 2*P(3,5)*P(5,1)*Metric(1,4)*Metric(2,6) + P(3,5)*P(5,2)*Metric(1,4)*Metric(2,6) - P(3,6)*P(5,2)*Metric(1,4)*Metric(2,6) - P(3,2)*P(5,6)*Metric(1,4)*Metric(2,6) + 2*P(3,5)*P(4,1)*Metric(1,5)*Metric(2,6) + 2*P(3,6)*P(4,2)*Metric(1,5)*Metric(2,6) + 2*P(3,1)*P(4,5)*Metric(1,5)*Metric(2,6) + 2*P(3,2)*P(4,6)*Metric(1,5)*Metric(2,6) - 2*P(5,6)*P(6,1)*Metric(1,2)*Metric(3,4) - 2*P(5,6)*P(6,2)*Metric(1,2)*Metric(3,4) - 2*P(5,1)*P(6,5)*Metric(1,2)*Metric(3,4) - 2*P(5,2)*P(6,5)*Metric(1,2)*Metric(3,4) + 2*P(2,5)*P(6,1)*Metric(1,5)*Metric(3,4) - 2*P(2,6)*P(6,1)*Metric(1,5)*Metric(3,4) - 2*P(2,5)*P(6,2)*Metric(1,5)*Metric(3,4) + 2*P(2,1)*P(6,5)*Metric(1,5)*Metric(3,4) - 2*P(2,5)*P(5,1)*Metric(1,6)*Metric(3,4) + 2*P(2,6)*P(5,1)*Metric(1,6)*Metric(3,4) - 2*P(2,6)*P(5,2)*Metric(1,6)*Metric(3,4) + 2*P(2,1)*P(5,6)*Metric(1,6)*Metric(3,4) - 2*P(1,5)*P(6,1)*Metric(2,5)*Metric(3,4) + 2*P(1,5)*P(6,2)*Metric(2,5)*Metric(3,4) - 2*P(1,6)*P(6,2)*Metric(2,5)*Metric(3,4) + 2*P(1,2)*P(6,5)*Metric(2,5)*Metric(3,4) + 2*P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + 2*P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(1,6)*P(5,1)*Metric(2,6)*Metric(3,4) - 2*P(1,5)*P(5,2)*Metric(2,6)*Metric(3,4) + 2*P(1,6)*P(5,2)*Metric(2,6)*Metric(3,4) + 2*P(1,2)*P(5,6)*Metric(2,6)*Metric(3,4) + 2*P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(4,6)*P(6,1)*Metric(1,2)*Metric(3,5) + P(4,6)*P(6,2)*Metric(1,2)*Metric(3,5) + P(2,6)*P(6,1)*Metric(1,4)*Metric(3,5) + P(2,5)*P(6,2)*Metric(1,4)*Metric(3,5) - P(2,6)*P(4,1)*Metric(1,6)*Metric(3,5) - 2*P(2,5)*P(4,2)*Metric(1,6)*Metric(3,5) + P(2,6)*P(4,2)*Metric(1,6)*Metric(3,5) - P(2,1)*P(4,6)*Metric(1,6)*Metric(3,5) + P(1,5)*P(6,1)*Metric(2,4)*Metric(3,5) + P(1,6)*P(6,2)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + 2*P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(1,5)*P(4,1)*Metric(2,6)*Metric(3,5) + P(1,6)*P(4,1)*Metric(2,6)*Metric(3,5) - P(1,6)*P(4,2)*Metric(2,6)*Metric(3,5) - P(1,2)*P(4,6)*Metric(2,6)*Metric(3,5) + 2*P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(4,5)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,5)*P(5,2)*Metric(1,2)*Metric(3,6) + P(2,5)*P(5,1)*Metric(1,4)*Metric(3,6) + P(2,6)*P(5,2)*Metric(1,4)*Metric(3,6) - P(2,5)*P(4,1)*Metric(1,5)*Metric(3,6) + P(2,5)*P(4,2)*Metric(1,5)*Metric(3,6) - 2*P(2,6)*P(4,2)*Metric(1,5)*Metric(3,6) - P(2,1)*P(4,5)*Metric(1,5)*Metric(3,6) + P(1,6)*P(5,1)*Metric(2,4)*Metric(3,6) + P(1,5)*P(5,2)*Metric(2,4)*Metric(3,6) - P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + 2*P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(1,5)*P(4,1)*Metric(2,5)*Metric(3,6) - 2*P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,5)*P(4,2)*Metric(2,5)*Metric(3,6) - P(1,2)*P(4,5)*Metric(2,5)*Metric(3,6) - P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(3,6)*P(6,1)*Metric(1,2)*Metric(4,5) + P(3,6)*P(6,2)*Metric(1,2)*Metric(4,5) + P(2,6)*P(6,1)*Metric(1,3)*Metric(4,5) + P(2,5)*P(6,2)*Metric(1,3)*Metric(4,5) - P(2,6)*P(3,1)*Metric(1,6)*Metric(4,5) - 2*P(2,5)*P(3,2)*Metric(1,6)*Metric(4,5) + P(2,6)*P(3,2)*Metric(1,6)*Metric(4,5) - P(2,1)*P(3,6)*Metric(1,6)*Metric(4,5) + P(1,5)*P(6,1)*Metric(2,3)*Metric(4,5) + P(1,6)*P(6,2)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(1,5)*P(3,1)*Metric(2,6)*Metric(4,5) + P(1,6)*P(3,1)*Metric(2,6)*Metric(4,5) - P(1,6)*P(3,2)*Metric(2,6)*Metric(4,5) - P(1,2)*P(3,6)*Metric(2,6)*Metric(4,5) + 2*P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(1,5)*P(2,1)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,1)*Metric(3,6)*Metric(4,5) + P(1,2)*P(2,5)*Metric(3,6)*Metric(4,5) + P(1,2)*P(2,6)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(3,5)*P(5,1)*Metric(1,2)*Metric(4,6) + P(3,5)*P(5,2)*Metric(1,2)*Metric(4,6) + P(2,5)*P(5,1)*Metric(1,3)*Metric(4,6) + P(2,6)*P(5,2)*Metric(1,3)*Metric(4,6) - P(2,5)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,5)*P(3,2)*Metric(1,5)*Metric(4,6) - 2*P(2,6)*P(3,2)*Metric(1,5)*Metric(4,6) - P(2,1)*P(3,5)*Metric(1,5)*Metric(4,6) + P(1,6)*P(5,1)*Metric(2,3)*Metric(4,6) + P(1,5)*P(5,2)*Metric(2,3)*Metric(4,6) - P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + 2*P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(1,5)*P(3,1)*Metric(2,5)*Metric(4,6) - 2*P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6) - P(1,5)*P(3,2)*Metric(2,5)*Metric(4,6) - P(1,2)*P(3,5)*Metric(2,5)*Metric(4,6) - P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(1,5)*P(2,1)*Metric(3,5)*Metric(4,6) + P(1,6)*P(2,1)*Metric(3,5)*Metric(4,6) + P(1,2)*P(2,5)*Metric(3,5)*Metric(4,6) + P(1,2)*P(2,6)*Metric(3,5)*Metric(4,6) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(2,5)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,6)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,5)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,2)*Metric(1,4)*Metric(5,6) + P(1,5)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,1)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(1,5)*P(3,1)*Metric(2,4)*Metric(5,6) + P(1,6)*P(3,1)*Metric(2,4)*Metric(5,6) - P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(1,5)*P(2,1)*Metric(3,4)*Metric(5,6) - 2*P(1,6)*P(2,1)*Metric(3,4)*Metric(5,6) - 2*P(1,2)*P(2,5)*Metric(3,4)*Metric(5,6) - 2*P(1,2)*P(2,6)*Metric(3,4)*Metric(5,6) + 2*P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV50 = Lorentz(name = 'VVVVVV50',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,6)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,6)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,5)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,5)*Metric(1,4)*Metric(2,3) - P(4,5)*P(6,1)*Metric(1,5)*Metric(2,3) + P(4,6)*P(6,1)*Metric(1,5)*Metric(2,3) - 2*P(4,6)*P(6,2)*Metric(1,5)*Metric(2,3) - P(4,1)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,6)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,5)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,1)*Metric(1,6)*Metric(2,3) - 2*P(4,5)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,6)*Metric(1,6)*Metric(2,3) + P(4,5)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,6)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,6)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,5)*Metric(1,3)*Metric(2,4) + P(5,2)*P(6,5)*Metric(1,3)*Metric(2,4) - P(3,5)*P(6,1)*Metric(1,5)*Metric(2,4) + P(3,6)*P(6,1)*Metric(1,5)*Metric(2,4) - 2*P(3,6)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,1)*P(6,5)*Metric(1,5)*Metric(2,4) + P(3,6)*P(6,5)*Metric(1,5)*Metric(2,4) + P(3,5)*P(5,1)*Metric(1,6)*Metric(2,4) - P(3,6)*P(5,1)*Metric(1,6)*Metric(2,4) - 2*P(3,5)*P(5,2)*Metric(1,6)*Metric(2,4) - P(3,1)*P(5,6)*Metric(1,6)*Metric(2,4) + P(3,5)*P(5,6)*Metric(1,6)*Metric(2,4) - 2*P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5) - P(4,5)*P(6,2)*Metric(1,3)*Metric(2,5) + P(4,6)*P(6,2)*Metric(1,3)*Metric(2,5) - P(4,2)*P(6,5)*Metric(1,3)*Metric(2,5) + P(4,6)*P(6,5)*Metric(1,3)*Metric(2,5) - 2*P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,5)*P(6,2)*Metric(1,4)*Metric(2,5) + P(3,6)*P(6,2)*Metric(1,4)*Metric(2,5) - P(3,2)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,6)*P(6,5)*Metric(1,4)*Metric(2,5) + 2*P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5) + 2*P(3,5)*P(4,2)*Metric(1,6)*Metric(2,5) + 2*P(3,2)*P(4,5)*Metric(1,6)*Metric(2,5) + 2*P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5) - 2*P(4,5)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,5)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,6)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,2)*P(5,6)*Metric(1,3)*Metric(2,6) + P(4,5)*P(5,6)*Metric(1,3)*Metric(2,6) - 2*P(3,5)*P(5,1)*Metric(1,4)*Metric(2,6) + P(3,5)*P(5,2)*Metric(1,4)*Metric(2,6) - P(3,6)*P(5,2)*Metric(1,4)*Metric(2,6) - P(3,2)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,5)*P(5,6)*Metric(1,4)*Metric(2,6) + 2*P(3,5)*P(4,1)*Metric(1,5)*Metric(2,6) + 2*P(3,6)*P(4,2)*Metric(1,5)*Metric(2,6) + 2*P(3,1)*P(4,5)*Metric(1,5)*Metric(2,6) + 2*P(3,2)*P(4,6)*Metric(1,5)*Metric(2,6) + 2*P(5,2)*P(6,1)*Metric(1,2)*Metric(3,4) - 2*P(5,6)*P(6,1)*Metric(1,2)*Metric(3,4) + 2*P(5,1)*P(6,2)*Metric(1,2)*Metric(3,4) - 2*P(5,6)*P(6,2)*Metric(1,2)*Metric(3,4) - 2*P(5,1)*P(6,5)*Metric(1,2)*Metric(3,4) - 2*P(5,2)*P(6,5)*Metric(1,2)*Metric(3,4) + 2*P(2,5)*P(6,1)*Metric(1,5)*Metric(3,4) - 2*P(2,6)*P(6,1)*Metric(1,5)*Metric(3,4) - 2*P(2,1)*P(6,2)*Metric(1,5)*Metric(3,4) - 2*P(2,5)*P(6,2)*Metric(1,5)*Metric(3,4) + 2*P(2,1)*P(6,5)*Metric(1,5)*Metric(3,4) - 2*P(2,6)*P(6,5)*Metric(1,5)*Metric(3,4) - 2*P(2,5)*P(5,1)*Metric(1,6)*Metric(3,4) + 2*P(2,6)*P(5,1)*Metric(1,6)*Metric(3,4) - 2*P(2,1)*P(5,2)*Metric(1,6)*Metric(3,4) - 2*P(2,6)*P(5,2)*Metric(1,6)*Metric(3,4) + 2*P(2,1)*P(5,6)*Metric(1,6)*Metric(3,4) - 2*P(2,5)*P(5,6)*Metric(1,6)*Metric(3,4) - 2*P(1,2)*P(6,1)*Metric(2,5)*Metric(3,4) - 2*P(1,5)*P(6,1)*Metric(2,5)*Metric(3,4) + 2*P(1,5)*P(6,2)*Metric(2,5)*Metric(3,4) - 2*P(1,6)*P(6,2)*Metric(2,5)*Metric(3,4) + 2*P(1,2)*P(6,5)*Metric(2,5)*Metric(3,4) - 2*P(1,6)*P(6,5)*Metric(2,5)*Metric(3,4) + 2*P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) + 2*P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + 2*P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + 2*P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(1,2)*P(5,1)*Metric(2,6)*Metric(3,4) - 2*P(1,6)*P(5,1)*Metric(2,6)*Metric(3,4) - 2*P(1,5)*P(5,2)*Metric(2,6)*Metric(3,4) + 2*P(1,6)*P(5,2)*Metric(2,6)*Metric(3,4) + 2*P(1,2)*P(5,6)*Metric(2,6)*Metric(3,4) - 2*P(1,5)*P(5,6)*Metric(2,6)*Metric(3,4) + 2*P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(4,2)*P(6,1)*Metric(1,2)*Metric(3,5) + P(4,6)*P(6,1)*Metric(1,2)*Metric(3,5) - P(4,1)*P(6,2)*Metric(1,2)*Metric(3,5) + P(4,6)*P(6,2)*Metric(1,2)*Metric(3,5) - 2*P(4,6)*P(6,5)*Metric(1,2)*Metric(3,5) + P(2,6)*P(6,1)*Metric(1,4)*Metric(3,5) + P(2,1)*P(6,2)*Metric(1,4)*Metric(3,5) + P(2,5)*P(6,2)*Metric(1,4)*Metric(3,5) + P(2,6)*P(6,5)*Metric(1,4)*Metric(3,5) - P(2,6)*P(4,1)*Metric(1,6)*Metric(3,5) + P(2,1)*P(4,2)*Metric(1,6)*Metric(3,5) - 2*P(2,5)*P(4,2)*Metric(1,6)*Metric(3,5) + P(2,6)*P(4,2)*Metric(1,6)*Metric(3,5) - P(2,1)*P(4,6)*Metric(1,6)*Metric(3,5) + P(1,2)*P(6,1)*Metric(2,4)*Metric(3,5) + P(1,5)*P(6,1)*Metric(2,4)*Metric(3,5) + P(1,6)*P(6,2)*Metric(2,4)*Metric(3,5) + P(1,6)*P(6,5)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + 2*P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(1,2)*P(4,1)*Metric(2,6)*Metric(3,5) - 2*P(1,5)*P(4,1)*Metric(2,6)*Metric(3,5) + P(1,6)*P(4,1)*Metric(2,6)*Metric(3,5) - P(1,6)*P(4,2)*Metric(2,6)*Metric(3,5) - P(1,2)*P(4,6)*Metric(2,6)*Metric(3,5) - P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 2*P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(4,2)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,5)*P(5,1)*Metric(1,2)*Metric(3,6) - P(4,1)*P(5,2)*Metric(1,2)*Metric(3,6) + P(4,5)*P(5,2)*Metric(1,2)*Metric(3,6) - 2*P(4,5)*P(5,6)*Metric(1,2)*Metric(3,6) + P(2,5)*P(5,1)*Metric(1,4)*Metric(3,6) + P(2,1)*P(5,2)*Metric(1,4)*Metric(3,6) + P(2,6)*P(5,2)*Metric(1,4)*Metric(3,6) + P(2,5)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,5)*P(4,1)*Metric(1,5)*Metric(3,6) + P(2,1)*P(4,2)*Metric(1,5)*Metric(3,6) + P(2,5)*P(4,2)*Metric(1,5)*Metric(3,6) - 2*P(2,6)*P(4,2)*Metric(1,5)*Metric(3,6) - P(2,1)*P(4,5)*Metric(1,5)*Metric(3,6) + P(1,2)*P(5,1)*Metric(2,4)*Metric(3,6) + P(1,6)*P(5,1)*Metric(2,4)*Metric(3,6) + P(1,5)*P(5,2)*Metric(2,4)*Metric(3,6) + P(1,5)*P(5,6)*Metric(2,4)*Metric(3,6) - P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + 2*P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(1,2)*P(4,1)*Metric(2,5)*Metric(3,6) + P(1,5)*P(4,1)*Metric(2,5)*Metric(3,6) - 2*P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,5)*P(4,2)*Metric(2,5)*Metric(3,6) - P(1,2)*P(4,5)*Metric(2,5)*Metric(3,6) - P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(3,2)*P(6,1)*Metric(1,2)*Metric(4,5) + P(3,6)*P(6,1)*Metric(1,2)*Metric(4,5) - P(3,1)*P(6,2)*Metric(1,2)*Metric(4,5) + P(3,6)*P(6,2)*Metric(1,2)*Metric(4,5) - 2*P(3,6)*P(6,5)*Metric(1,2)*Metric(4,5) + P(2,6)*P(6,1)*Metric(1,3)*Metric(4,5) + P(2,1)*P(6,2)*Metric(1,3)*Metric(4,5) + P(2,5)*P(6,2)*Metric(1,3)*Metric(4,5) + P(2,6)*P(6,5)*Metric(1,3)*Metric(4,5) - P(2,6)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,2)*Metric(1,6)*Metric(4,5) - 2*P(2,5)*P(3,2)*Metric(1,6)*Metric(4,5) + P(2,6)*P(3,2)*Metric(1,6)*Metric(4,5) - P(2,1)*P(3,6)*Metric(1,6)*Metric(4,5) + P(1,2)*P(6,1)*Metric(2,3)*Metric(4,5) + P(1,5)*P(6,1)*Metric(2,3)*Metric(4,5) + P(1,6)*P(6,2)*Metric(2,3)*Metric(4,5) + P(1,6)*P(6,5)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(1,2)*P(3,1)*Metric(2,6)*Metric(4,5) - 2*P(1,5)*P(3,1)*Metric(2,6)*Metric(4,5) + P(1,6)*P(3,1)*Metric(2,6)*Metric(4,5) - P(1,6)*P(3,2)*Metric(2,6)*Metric(4,5) - P(1,2)*P(3,6)*Metric(2,6)*Metric(4,5) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(1,5)*P(2,1)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,1)*Metric(3,6)*Metric(4,5) + P(1,2)*P(2,5)*Metric(3,6)*Metric(4,5) + P(1,2)*P(2,6)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(3,2)*P(5,1)*Metric(1,2)*Metric(4,6) + P(3,5)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,1)*P(5,2)*Metric(1,2)*Metric(4,6) + P(3,5)*P(5,2)*Metric(1,2)*Metric(4,6) - 2*P(3,5)*P(5,6)*Metric(1,2)*Metric(4,6) + P(2,5)*P(5,1)*Metric(1,3)*Metric(4,6) + P(2,1)*P(5,2)*Metric(1,3)*Metric(4,6) + P(2,6)*P(5,2)*Metric(1,3)*Metric(4,6) + P(2,5)*P(5,6)*Metric(1,3)*Metric(4,6) - P(2,5)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,2)*Metric(1,5)*Metric(4,6) + P(2,5)*P(3,2)*Metric(1,5)*Metric(4,6) - 2*P(2,6)*P(3,2)*Metric(1,5)*Metric(4,6) - P(2,1)*P(3,5)*Metric(1,5)*Metric(4,6) + P(1,2)*P(5,1)*Metric(2,3)*Metric(4,6) + P(1,6)*P(5,1)*Metric(2,3)*Metric(4,6) + P(1,5)*P(5,2)*Metric(2,3)*Metric(4,6) + P(1,5)*P(5,6)*Metric(2,3)*Metric(4,6) - P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + 2*P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(1,2)*P(3,1)*Metric(2,5)*Metric(4,6) + P(1,5)*P(3,1)*Metric(2,5)*Metric(4,6) - 2*P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6) - P(1,5)*P(3,2)*Metric(2,5)*Metric(4,6) - P(1,2)*P(3,5)*Metric(2,5)*Metric(4,6) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(1,5)*P(2,1)*Metric(3,5)*Metric(4,6) + P(1,6)*P(2,1)*Metric(3,5)*Metric(4,6) + P(1,2)*P(2,5)*Metric(3,5)*Metric(4,6) + P(1,2)*P(2,6)*Metric(3,5)*Metric(4,6) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(3,2)*P(4,1)*Metric(1,2)*Metric(5,6) + 2*P(3,1)*P(4,2)*Metric(1,2)*Metric(5,6) + 2*P(3,6)*P(4,5)*Metric(1,2)*Metric(5,6) + 2*P(3,5)*P(4,6)*Metric(1,2)*Metric(5,6) - 2*P(2,1)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,5)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,6)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,5)*Metric(1,3)*Metric(5,6) - P(2,5)*P(4,6)*Metric(1,3)*Metric(5,6) - 2*P(2,1)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,5)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,2)*Metric(1,4)*Metric(5,6) - P(2,6)*P(3,5)*Metric(1,4)*Metric(5,6) - P(2,5)*P(3,6)*Metric(1,4)*Metric(5,6) - 2*P(1,2)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,5)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,1)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,5)*Metric(2,3)*Metric(5,6) - P(1,5)*P(4,6)*Metric(2,3)*Metric(5,6) + 2*P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(1,2)*P(3,1)*Metric(2,4)*Metric(5,6) + P(1,5)*P(3,1)*Metric(2,4)*Metric(5,6) + P(1,6)*P(3,1)*Metric(2,4)*Metric(5,6) - P(1,6)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,5)*P(3,6)*Metric(2,4)*Metric(5,6) + 2*P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(1,5)*P(2,1)*Metric(3,4)*Metric(5,6) - 2*P(1,6)*P(2,1)*Metric(3,4)*Metric(5,6) - 2*P(1,2)*P(2,5)*Metric(3,4)*Metric(5,6) + 2*P(1,6)*P(2,5)*Metric(3,4)*Metric(5,6) - 2*P(1,2)*P(2,6)*Metric(3,4)*Metric(5,6) + 2*P(1,5)*P(2,6)*Metric(3,4)*Metric(5,6) + 2*P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV51 = Lorentz(name = 'VVVVVV51',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = '2*P(5,6)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,2)*Metric(1,4)*Metric(2,3) - P(5,6)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,3)*Metric(1,4)*Metric(2,3) - P(5,6)*P(6,3)*Metric(1,4)*Metric(2,3) + 2*P(4,6)*P(6,1)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,2)*Metric(1,5)*Metric(2,3) - P(4,6)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,2)*P(6,3)*Metric(1,5)*Metric(2,3) - P(4,6)*P(6,3)*Metric(1,5)*Metric(2,3) - 2*P(4,6)*P(5,1)*Metric(1,6)*Metric(2,3) - 2*P(4,3)*P(5,2)*Metric(1,6)*Metric(2,3) - 2*P(4,2)*P(5,3)*Metric(1,6)*Metric(2,3) - 2*P(4,1)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,3)*P(6,1)*Metric(1,3)*Metric(2,4) - P(5,6)*P(6,1)*Metric(1,3)*Metric(2,4) + 2*P(5,6)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,3)*Metric(1,3)*Metric(2,4) - P(5,6)*P(6,3)*Metric(1,3)*Metric(2,4) - P(3,6)*P(6,1)*Metric(1,5)*Metric(2,4) - P(3,6)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,1)*P(6,3)*Metric(1,5)*Metric(2,4) - P(3,2)*P(6,3)*Metric(1,5)*Metric(2,4) + P(3,6)*P(5,1)*Metric(1,6)*Metric(2,4) - P(3,1)*P(5,3)*Metric(1,6)*Metric(2,4) + 2*P(3,2)*P(5,3)*Metric(1,6)*Metric(2,4) - P(3,6)*P(5,3)*Metric(1,6)*Metric(2,4) + P(3,1)*P(5,6)*Metric(1,6)*Metric(2,4) + P(4,3)*P(6,1)*Metric(1,3)*Metric(2,5) - P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5) + 2*P(4,6)*P(6,2)*Metric(1,3)*Metric(2,5) + P(4,1)*P(6,3)*Metric(1,3)*Metric(2,5) - P(4,6)*P(6,3)*Metric(1,3)*Metric(2,5) - P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,6)*P(6,2)*Metric(1,4)*Metric(2,5) - P(3,1)*P(6,3)*Metric(1,4)*Metric(2,5) - P(3,2)*P(6,3)*Metric(1,4)*Metric(2,5) + P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5) - P(3,1)*P(4,3)*Metric(1,6)*Metric(2,5) + 2*P(3,2)*P(4,3)*Metric(1,6)*Metric(2,5) - P(3,6)*P(4,3)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5) - 2*P(4,3)*P(5,1)*Metric(1,3)*Metric(2,6) - 2*P(4,6)*P(5,2)*Metric(1,3)*Metric(2,6) - 2*P(4,1)*P(5,3)*Metric(1,3)*Metric(2,6) - 2*P(4,2)*P(5,6)*Metric(1,3)*Metric(2,6) + P(3,6)*P(5,2)*Metric(1,4)*Metric(2,6) + 2*P(3,1)*P(5,3)*Metric(1,4)*Metric(2,6) - P(3,2)*P(5,3)*Metric(1,4)*Metric(2,6) - P(3,6)*P(5,3)*Metric(1,4)*Metric(2,6) + P(3,2)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,6)*P(4,2)*Metric(1,5)*Metric(2,6) + 2*P(3,1)*P(4,3)*Metric(1,5)*Metric(2,6) - P(3,2)*P(4,3)*Metric(1,5)*Metric(2,6) - P(3,6)*P(4,3)*Metric(1,5)*Metric(2,6) + P(3,2)*P(4,6)*Metric(1,5)*Metric(2,6) + P(5,2)*P(6,1)*Metric(1,2)*Metric(3,4) - P(5,6)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,2)*Metric(1,2)*Metric(3,4) - P(5,6)*P(6,2)*Metric(1,2)*Metric(3,4) + 2*P(5,6)*P(6,3)*Metric(1,2)*Metric(3,4) - P(2,6)*P(6,1)*Metric(1,5)*Metric(3,4) - P(2,1)*P(6,2)*Metric(1,5)*Metric(3,4) - P(2,3)*P(6,2)*Metric(1,5)*Metric(3,4) - P(2,6)*P(6,3)*Metric(1,5)*Metric(3,4) + P(2,6)*P(5,1)*Metric(1,6)*Metric(3,4) - P(2,1)*P(5,2)*Metric(1,6)*Metric(3,4) + 2*P(2,3)*P(5,2)*Metric(1,6)*Metric(3,4) - P(2,6)*P(5,2)*Metric(1,6)*Metric(3,4) + P(2,1)*P(5,6)*Metric(1,6)*Metric(3,4) - P(1,2)*P(6,1)*Metric(2,5)*Metric(3,4) - P(1,3)*P(6,1)*Metric(2,5)*Metric(3,4) - P(1,6)*P(6,2)*Metric(2,5)*Metric(3,4) - P(1,6)*P(6,3)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(1,2)*P(5,1)*Metric(2,6)*Metric(3,4) + 2*P(1,3)*P(5,1)*Metric(2,6)*Metric(3,4) - P(1,6)*P(5,1)*Metric(2,6)*Metric(3,4) + P(1,6)*P(5,2)*Metric(2,6)*Metric(3,4) + P(1,2)*P(5,6)*Metric(2,6)*Metric(3,4) + P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(4,2)*P(6,1)*Metric(1,2)*Metric(3,5) - P(4,6)*P(6,1)*Metric(1,2)*Metric(3,5) + P(4,1)*P(6,2)*Metric(1,2)*Metric(3,5) - P(4,6)*P(6,2)*Metric(1,2)*Metric(3,5) + 2*P(4,6)*P(6,3)*Metric(1,2)*Metric(3,5) - P(2,6)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,1)*P(6,2)*Metric(1,4)*Metric(3,5) - P(2,3)*P(6,2)*Metric(1,4)*Metric(3,5) - P(2,6)*P(6,3)*Metric(1,4)*Metric(3,5) + P(2,6)*P(4,1)*Metric(1,6)*Metric(3,5) - P(2,1)*P(4,2)*Metric(1,6)*Metric(3,5) + 2*P(2,3)*P(4,2)*Metric(1,6)*Metric(3,5) - P(2,6)*P(4,2)*Metric(1,6)*Metric(3,5) + P(2,1)*P(4,6)*Metric(1,6)*Metric(3,5) - P(1,2)*P(6,1)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,1)*Metric(2,4)*Metric(3,5) - P(1,6)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,6)*P(6,3)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(1,2)*P(4,1)*Metric(2,6)*Metric(3,5) + 2*P(1,3)*P(4,1)*Metric(2,6)*Metric(3,5) - P(1,6)*P(4,1)*Metric(2,6)*Metric(3,5) + P(1,6)*P(4,2)*Metric(2,6)*Metric(3,5) + P(1,2)*P(4,6)*Metric(2,6)*Metric(3,5) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,6)*Metric(3,5) - 2*P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - 2*P(4,2)*P(5,1)*Metric(1,2)*Metric(3,6) - 2*P(4,1)*P(5,2)*Metric(1,2)*Metric(3,6) - 2*P(4,6)*P(5,3)*Metric(1,2)*Metric(3,6) - 2*P(4,3)*P(5,6)*Metric(1,2)*Metric(3,6) + 2*P(2,1)*P(5,2)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,2)*Metric(1,4)*Metric(3,6) - P(2,6)*P(5,2)*Metric(1,4)*Metric(3,6) + P(2,6)*P(5,3)*Metric(1,4)*Metric(3,6) + P(2,3)*P(5,6)*Metric(1,4)*Metric(3,6) + 2*P(2,1)*P(4,2)*Metric(1,5)*Metric(3,6) - P(2,3)*P(4,2)*Metric(1,5)*Metric(3,6) - P(2,6)*P(4,2)*Metric(1,5)*Metric(3,6) + P(2,6)*P(4,3)*Metric(1,5)*Metric(3,6) + P(2,3)*P(4,6)*Metric(1,5)*Metric(3,6) + 2*P(1,2)*P(5,1)*Metric(2,4)*Metric(3,6) - P(1,3)*P(5,1)*Metric(2,4)*Metric(3,6) - P(1,6)*P(5,1)*Metric(2,4)*Metric(3,6) + P(1,6)*P(5,3)*Metric(2,4)*Metric(3,6) + P(1,3)*P(5,6)*Metric(2,4)*Metric(3,6) - 2*P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + 2*P(1,2)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,3)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6) + P(1,6)*P(4,3)*Metric(2,5)*Metric(3,6) + P(1,3)*P(4,6)*Metric(2,5)*Metric(3,6) - 2*P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 2*P(3,2)*P(6,1)*Metric(1,2)*Metric(4,5) + 2*P(3,6)*P(6,1)*Metric(1,2)*Metric(4,5) - 2*P(3,1)*P(6,2)*Metric(1,2)*Metric(4,5) + 2*P(3,6)*P(6,2)*Metric(1,2)*Metric(4,5) + 2*P(3,1)*P(6,3)*Metric(1,2)*Metric(4,5) + 2*P(3,2)*P(6,3)*Metric(1,2)*Metric(4,5) - 2*P(2,3)*P(6,1)*Metric(1,3)*Metric(4,5) + 2*P(2,6)*P(6,1)*Metric(1,3)*Metric(4,5) + 2*P(2,1)*P(6,2)*Metric(1,3)*Metric(4,5) + 2*P(2,3)*P(6,2)*Metric(1,3)*Metric(4,5) - 2*P(2,1)*P(6,3)*Metric(1,3)*Metric(4,5) + 2*P(2,6)*P(6,3)*Metric(1,3)*Metric(4,5) + 2*P(2,3)*P(3,1)*Metric(1,6)*Metric(4,5) - 2*P(2,6)*P(3,1)*Metric(1,6)*Metric(4,5) + 2*P(2,1)*P(3,2)*Metric(1,6)*Metric(4,5) + 2*P(2,6)*P(3,2)*Metric(1,6)*Metric(4,5) - 2*P(2,1)*P(3,6)*Metric(1,6)*Metric(4,5) + 2*P(2,3)*P(3,6)*Metric(1,6)*Metric(4,5) + 2*P(1,2)*P(6,1)*Metric(2,3)*Metric(4,5) + 2*P(1,3)*P(6,1)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*P(6,2)*Metric(2,3)*Metric(4,5) + 2*P(1,6)*P(6,2)*Metric(2,3)*Metric(4,5) - 2*P(1,2)*P(6,3)*Metric(2,3)*Metric(4,5) + 2*P(1,6)*P(6,3)*Metric(2,3)*Metric(4,5) - 2*P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(1,2)*P(3,1)*Metric(2,6)*Metric(4,5) + 2*P(1,6)*P(3,1)*Metric(2,6)*Metric(4,5) + 2*P(1,3)*P(3,2)*Metric(2,6)*Metric(4,5) - 2*P(1,6)*P(3,2)*Metric(2,6)*Metric(4,5) - 2*P(1,2)*P(3,6)*Metric(2,6)*Metric(4,5) + 2*P(1,3)*P(3,6)*Metric(2,6)*Metric(4,5) - 2*P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,6)*Metric(4,5) - 2*P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) - 2*P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - 2*P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(1,3)*P(2,1)*Metric(3,6)*Metric(4,5) + 2*P(1,6)*P(2,1)*Metric(3,6)*Metric(4,5) + 2*P(1,2)*P(2,3)*Metric(3,6)*Metric(4,5) - 2*P(1,6)*P(2,3)*Metric(3,6)*Metric(4,5) + 2*P(1,2)*P(2,6)*Metric(3,6)*Metric(4,5) - 2*P(1,3)*P(2,6)*Metric(3,6)*Metric(4,5) - 2*P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(3,2)*P(5,1)*Metric(1,2)*Metric(4,6) + P(3,1)*P(5,2)*Metric(1,2)*Metric(4,6) - P(3,1)*P(5,3)*Metric(1,2)*Metric(4,6) - P(3,2)*P(5,3)*Metric(1,2)*Metric(4,6) + 2*P(3,6)*P(5,3)*Metric(1,2)*Metric(4,6) + P(2,3)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,1)*P(5,2)*Metric(1,3)*Metric(4,6) - P(2,3)*P(5,2)*Metric(1,3)*Metric(4,6) + 2*P(2,6)*P(5,2)*Metric(1,3)*Metric(4,6) + P(2,1)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,3)*P(3,1)*Metric(1,5)*Metric(4,6) - P(2,1)*P(3,2)*Metric(1,5)*Metric(4,6) - P(2,6)*P(3,2)*Metric(1,5)*Metric(4,6) - P(2,3)*P(3,6)*Metric(1,5)*Metric(4,6) - P(1,2)*P(5,1)*Metric(2,3)*Metric(4,6) - P(1,3)*P(5,1)*Metric(2,3)*Metric(4,6) + 2*P(1,6)*P(5,1)*Metric(2,3)*Metric(4,6) + P(1,3)*P(5,2)*Metric(2,3)*Metric(4,6) + P(1,2)*P(5,3)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) - 2*P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(1,2)*P(3,1)*Metric(2,5)*Metric(4,6) - P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6) - P(1,3)*P(3,2)*Metric(2,5)*Metric(4,6) - P(1,3)*P(3,6)*Metric(2,5)*Metric(4,6) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - 2*P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(1,3)*P(2,1)*Metric(3,5)*Metric(4,6) - P(1,6)*P(2,1)*Metric(3,5)*Metric(4,6) - P(1,2)*P(2,3)*Metric(3,5)*Metric(4,6) - P(1,2)*P(2,6)*Metric(3,5)*Metric(4,6) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(3,2)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,1)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,1)*P(4,3)*Metric(1,2)*Metric(5,6) - P(3,2)*P(4,3)*Metric(1,2)*Metric(5,6) + 2*P(3,6)*P(4,3)*Metric(1,2)*Metric(5,6) + P(2,3)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,1)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,3)*P(4,2)*Metric(1,3)*Metric(5,6) + 2*P(2,6)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,1)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,3)*P(3,1)*Metric(1,4)*Metric(5,6) - P(2,1)*P(3,2)*Metric(1,4)*Metric(5,6) - P(2,6)*P(3,2)*Metric(1,4)*Metric(5,6) - P(2,3)*P(3,6)*Metric(1,4)*Metric(5,6) - P(1,2)*P(4,1)*Metric(2,3)*Metric(5,6) - P(1,3)*P(4,1)*Metric(2,3)*Metric(5,6) + 2*P(1,6)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,3)*P(4,2)*Metric(2,3)*Metric(5,6) + P(1,2)*P(4,3)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(1,2)*P(3,1)*Metric(2,4)*Metric(5,6) - P(1,6)*P(3,1)*Metric(2,4)*Metric(5,6) - P(1,3)*P(3,2)*Metric(2,4)*Metric(5,6) - P(1,3)*P(3,6)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(1,3)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,6)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,2)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,2)*P(2,6)*Metric(3,4)*Metric(5,6) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV52 = Lorentz(name = 'VVVVVV52',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,6)*P(6,1)*Metric(1,4)*Metric(2,3) - (P(5,6)*P(6,2)*Metric(1,4)*Metric(2,3))/2. - (P(5,6)*P(6,3)*Metric(1,4)*Metric(2,3))/2. + P(4,6)*P(6,1)*Metric(1,5)*Metric(2,3) - (P(4,6)*P(6,2)*Metric(1,5)*Metric(2,3))/2. - (P(4,6)*P(6,3)*Metric(1,5)*Metric(2,3))/2. - P(4,6)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,6)*Metric(1,6)*Metric(2,3) - (P(5,6)*P(6,1)*Metric(1,3)*Metric(2,4))/2. + P(5,6)*P(6,2)*Metric(1,3)*Metric(2,4) - (P(5,6)*P(6,3)*Metric(1,3)*Metric(2,4))/2. - (P(3,6)*P(6,1)*Metric(1,5)*Metric(2,4))/2. - (P(3,6)*P(6,2)*Metric(1,5)*Metric(2,4))/2. + (P(3,6)*P(5,1)*Metric(1,6)*Metric(2,4))/2. - (P(3,6)*P(5,3)*Metric(1,6)*Metric(2,4))/2. + (P(3,1)*P(5,6)*Metric(1,6)*Metric(2,4))/2. - (P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5))/2. + P(4,6)*P(6,2)*Metric(1,3)*Metric(2,5) - (P(4,6)*P(6,3)*Metric(1,3)*Metric(2,5))/2. - (P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5))/2. - (P(3,6)*P(6,2)*Metric(1,4)*Metric(2,5))/2. + (P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5))/2. - (P(3,6)*P(4,3)*Metric(1,6)*Metric(2,5))/2. + (P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5))/2. - P(4,6)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,2)*P(5,6)*Metric(1,3)*Metric(2,6) + (P(3,6)*P(5,2)*Metric(1,4)*Metric(2,6))/2. - (P(3,6)*P(5,3)*Metric(1,4)*Metric(2,6))/2. + (P(3,2)*P(5,6)*Metric(1,4)*Metric(2,6))/2. + (P(3,6)*P(4,2)*Metric(1,5)*Metric(2,6))/2. - (P(3,6)*P(4,3)*Metric(1,5)*Metric(2,6))/2. + (P(3,2)*P(4,6)*Metric(1,5)*Metric(2,6))/2. - (P(5,6)*P(6,1)*Metric(1,2)*Metric(3,4))/2. - (P(5,6)*P(6,2)*Metric(1,2)*Metric(3,4))/2. + P(5,6)*P(6,3)*Metric(1,2)*Metric(3,4) - (P(2,6)*P(6,1)*Metric(1,5)*Metric(3,4))/2. - (P(2,6)*P(6,3)*Metric(1,5)*Metric(3,4))/2. + (P(2,6)*P(5,1)*Metric(1,6)*Metric(3,4))/2. - (P(2,6)*P(5,2)*Metric(1,6)*Metric(3,4))/2. + (P(2,1)*P(5,6)*Metric(1,6)*Metric(3,4))/2. - (P(1,6)*P(6,2)*Metric(2,5)*Metric(3,4))/2. - (P(1,6)*P(6,3)*Metric(2,5)*Metric(3,4))/2. + (P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. + (P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(1,6)*P(5,1)*Metric(2,6)*Metric(3,4))/2. + (P(1,6)*P(5,2)*Metric(2,6)*Metric(3,4))/2. + (P(1,2)*P(5,6)*Metric(2,6)*Metric(3,4))/2. + (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(4,6)*P(6,1)*Metric(1,2)*Metric(3,5))/2. - (P(4,6)*P(6,2)*Metric(1,2)*Metric(3,5))/2. + P(4,6)*P(6,3)*Metric(1,2)*Metric(3,5) - (P(2,6)*P(6,1)*Metric(1,4)*Metric(3,5))/2. - (P(2,6)*P(6,3)*Metric(1,4)*Metric(3,5))/2. + (P(2,6)*P(4,1)*Metric(1,6)*Metric(3,5))/2. - (P(2,6)*P(4,2)*Metric(1,6)*Metric(3,5))/2. + (P(2,1)*P(4,6)*Metric(1,6)*Metric(3,5))/2. - (P(1,6)*P(6,2)*Metric(2,4)*Metric(3,5))/2. - (P(1,6)*P(6,3)*Metric(2,4)*Metric(3,5))/2. + (P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(1,6)*P(4,1)*Metric(2,6)*Metric(3,5))/2. + (P(1,6)*P(4,2)*Metric(2,6)*Metric(3,5))/2. + (P(1,2)*P(4,6)*Metric(2,6)*Metric(3,5))/2. + (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - P(4,6)*P(5,3)*Metric(1,2)*Metric(3,6) - P(4,3)*P(5,6)*Metric(1,2)*Metric(3,6) - (P(2,6)*P(5,2)*Metric(1,4)*Metric(3,6))/2. + (P(2,6)*P(5,3)*Metric(1,4)*Metric(3,6))/2. + (P(2,3)*P(5,6)*Metric(1,4)*Metric(3,6))/2. - (P(2,6)*P(4,2)*Metric(1,5)*Metric(3,6))/2. + (P(2,6)*P(4,3)*Metric(1,5)*Metric(3,6))/2. + (P(2,3)*P(4,6)*Metric(1,5)*Metric(3,6))/2. - (P(1,6)*P(5,1)*Metric(2,4)*Metric(3,6))/2. + (P(1,6)*P(5,3)*Metric(2,4)*Metric(3,6))/2. + (P(1,3)*P(5,6)*Metric(2,4)*Metric(3,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(1,6)*P(4,3)*Metric(2,5)*Metric(3,6))/2. + (P(1,3)*P(4,6)*Metric(2,5)*Metric(3,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + P(3,6)*P(6,1)*Metric(1,2)*Metric(4,5) + P(3,6)*P(6,2)*Metric(1,2)*Metric(4,5) + P(2,6)*P(6,1)*Metric(1,3)*Metric(4,5) + P(2,6)*P(6,3)*Metric(1,3)*Metric(4,5) - P(2,6)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,6)*P(3,2)*Metric(1,6)*Metric(4,5) - P(2,1)*P(3,6)*Metric(1,6)*Metric(4,5) + P(2,3)*P(3,6)*Metric(1,6)*Metric(4,5) + P(1,6)*P(6,2)*Metric(2,3)*Metric(4,5) + P(1,6)*P(6,3)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(1,6)*P(3,1)*Metric(2,6)*Metric(4,5) - P(1,6)*P(3,2)*Metric(2,6)*Metric(4,5) - P(1,2)*P(3,6)*Metric(2,6)*Metric(4,5) + P(1,3)*P(3,6)*Metric(2,6)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(1,6)*P(2,1)*Metric(3,6)*Metric(4,5) - P(1,6)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,2)*P(2,6)*Metric(3,6)*Metric(4,5) - P(1,3)*P(2,6)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(3,6)*P(5,3)*Metric(1,2)*Metric(4,6) + P(2,6)*P(5,2)*Metric(1,3)*Metric(4,6) - (P(2,6)*P(3,2)*Metric(1,5)*Metric(4,6))/2. - (P(2,3)*P(3,6)*Metric(1,5)*Metric(4,6))/2. + P(1,6)*P(5,1)*Metric(2,3)*Metric(4,6) - P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + (P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - (P(1,3)*P(3,6)*Metric(2,5)*Metric(4,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + (P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(1,6)*P(2,1)*Metric(3,5)*Metric(4,6))/2. - (P(1,2)*P(2,6)*Metric(3,5)*Metric(4,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + (P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(3,6)*P(4,3)*Metric(1,2)*Metric(5,6) + P(2,6)*P(4,2)*Metric(1,3)*Metric(5,6) - (P(2,6)*P(3,2)*Metric(1,4)*Metric(5,6))/2. - (P(2,3)*P(3,6)*Metric(1,4)*Metric(5,6))/2. + P(1,6)*P(4,1)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + (P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6))/2. + (P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6))/2. - (P(1,6)*P(3,1)*Metric(2,4)*Metric(5,6))/2. - (P(1,3)*P(3,6)*Metric(2,4)*Metric(5,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + (P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(1,6)*P(2,1)*Metric(3,4)*Metric(5,6))/2. - (P(1,2)*P(2,6)*Metric(3,4)*Metric(5,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. + (P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. - P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV53 = Lorentz(name = 'VVVVVV53',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = '2*P(5,4)*P(6,1)*Metric(1,4)*Metric(2,3) + 2*P(5,6)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,2)*Metric(1,4)*Metric(2,3) - P(5,4)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,6)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,3)*Metric(1,4)*Metric(2,3) - P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,6)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,5)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,5)*Metric(1,4)*Metric(2,3) + 2*P(5,4)*P(6,5)*Metric(1,4)*Metric(2,3) + 2*P(4,5)*P(6,1)*Metric(1,5)*Metric(2,3) + 2*P(4,6)*P(6,1)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,2)*Metric(1,5)*Metric(2,3) - P(4,5)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,6)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,2)*P(6,3)*Metric(1,5)*Metric(2,3) - P(4,5)*P(6,3)*Metric(1,5)*Metric(2,3) + P(4,6)*P(6,3)*Metric(1,5)*Metric(2,3) + P(4,2)*P(6,4)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,4)*Metric(1,5)*Metric(2,3) + 2*P(4,5)*P(6,4)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*P(5,1)*Metric(1,6)*Metric(2,3) - 2*P(4,6)*P(5,1)*Metric(1,6)*Metric(2,3) - 2*P(4,3)*P(5,2)*Metric(1,6)*Metric(2,3) - 2*P(4,5)*P(5,2)*Metric(1,6)*Metric(2,3) - 2*P(4,2)*P(5,3)*Metric(1,6)*Metric(2,3) - 2*P(4,5)*P(5,3)*Metric(1,6)*Metric(2,3) - 2*P(4,1)*P(5,4)*Metric(1,6)*Metric(2,3) - 2*P(4,2)*P(5,4)*Metric(1,6)*Metric(2,3) - 2*P(4,3)*P(5,4)*Metric(1,6)*Metric(2,3) - 2*P(4,6)*P(5,4)*Metric(1,6)*Metric(2,3) - 2*P(4,1)*P(5,6)*Metric(1,6)*Metric(2,3) - 2*P(4,5)*P(5,6)*Metric(1,6)*Metric(2,3) - P(5,3)*P(6,1)*Metric(1,3)*Metric(2,4) - P(5,6)*P(6,1)*Metric(1,3)*Metric(2,4) - P(5,4)*P(6,2)*Metric(1,3)*Metric(2,4) - P(5,6)*P(6,2)*Metric(1,3)*Metric(2,4) - P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) - P(5,3)*P(6,5)*Metric(1,3)*Metric(2,4) - P(5,4)*P(6,5)*Metric(1,3)*Metric(2,4) - P(3,5)*P(6,1)*Metric(1,5)*Metric(2,4) - P(3,6)*P(6,1)*Metric(1,5)*Metric(2,4) - P(3,5)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,2)*P(6,3)*Metric(1,5)*Metric(2,4) - P(3,5)*P(6,3)*Metric(1,5)*Metric(2,4) - P(3,2)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,6)*P(6,4)*Metric(1,5)*Metric(2,4) + P(3,5)*P(5,1)*Metric(1,6)*Metric(2,4) + P(3,6)*P(5,1)*Metric(1,6)*Metric(2,4) + P(3,1)*P(5,3)*Metric(1,6)*Metric(2,4) + 2*P(3,2)*P(5,3)*Metric(1,6)*Metric(2,4) + P(3,6)*P(5,3)*Metric(1,6)*Metric(2,4) + 2*P(3,2)*P(5,4)*Metric(1,6)*Metric(2,4) + 2*P(3,5)*P(5,4)*Metric(1,6)*Metric(2,4) + P(3,1)*P(5,6)*Metric(1,6)*Metric(2,4) + P(3,5)*P(5,6)*Metric(1,6)*Metric(2,4) - P(4,3)*P(6,1)*Metric(1,3)*Metric(2,5) - P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5) - P(4,5)*P(6,2)*Metric(1,3)*Metric(2,5) - P(4,6)*P(6,2)*Metric(1,3)*Metric(2,5) - P(4,3)*P(6,4)*Metric(1,3)*Metric(2,5) - P(4,5)*P(6,4)*Metric(1,3)*Metric(2,5) - P(4,3)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,4)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,4)*P(6,2)*Metric(1,4)*Metric(2,5) - P(3,2)*P(6,3)*Metric(1,4)*Metric(2,5) - P(3,4)*P(6,3)*Metric(1,4)*Metric(2,5) - P(3,2)*P(6,5)*Metric(1,4)*Metric(2,5) - P(3,6)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,4)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,3)*Metric(1,6)*Metric(2,5) + 2*P(3,2)*P(4,3)*Metric(1,6)*Metric(2,5) + P(3,6)*P(4,3)*Metric(1,6)*Metric(2,5) + 2*P(3,2)*P(4,5)*Metric(1,6)*Metric(2,5) + 2*P(3,4)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5) + P(3,4)*P(4,6)*Metric(1,6)*Metric(2,5) + P(4,3)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,5)*P(5,1)*Metric(1,3)*Metric(2,6) - P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,5)*P(5,2)*Metric(1,3)*Metric(2,6) + P(4,6)*P(5,2)*Metric(1,3)*Metric(2,6) + P(4,1)*P(5,3)*Metric(1,3)*Metric(2,6) + P(4,5)*P(5,3)*Metric(1,3)*Metric(2,6) + P(4,1)*P(5,4)*Metric(1,3)*Metric(2,6) + P(4,2)*P(5,4)*Metric(1,3)*Metric(2,6) + P(4,3)*P(5,4)*Metric(1,3)*Metric(2,6) + P(4,6)*P(5,4)*Metric(1,3)*Metric(2,6) - P(4,1)*P(5,6)*Metric(1,3)*Metric(2,6) + P(4,2)*P(5,6)*Metric(1,3)*Metric(2,6) + P(4,5)*P(5,6)*Metric(1,3)*Metric(2,6) + P(3,4)*P(5,2)*Metric(1,4)*Metric(2,6) - P(3,1)*P(5,3)*Metric(1,4)*Metric(2,6) - P(3,2)*P(5,3)*Metric(1,4)*Metric(2,6) - P(3,1)*P(5,4)*Metric(1,4)*Metric(2,6) + P(3,2)*P(5,4)*Metric(1,4)*Metric(2,6) - P(3,5)*P(5,4)*Metric(1,4)*Metric(2,6) + P(3,1)*P(5,6)*Metric(1,4)*Metric(2,6) - P(3,2)*P(5,6)*Metric(1,4)*Metric(2,6) - P(3,5)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,5)*P(4,2)*Metric(1,5)*Metric(2,6) - P(3,1)*P(4,3)*Metric(1,5)*Metric(2,6) - P(3,2)*P(4,3)*Metric(1,5)*Metric(2,6) - P(3,1)*P(4,5)*Metric(1,5)*Metric(2,6) + P(3,2)*P(4,5)*Metric(1,5)*Metric(2,6) - P(3,4)*P(4,5)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) - P(3,2)*P(4,6)*Metric(1,5)*Metric(2,6) - P(3,4)*P(4,6)*Metric(1,5)*Metric(2,6) - P(5,2)*P(6,1)*Metric(1,2)*Metric(3,4) - P(5,6)*P(6,1)*Metric(1,2)*Metric(3,4) - P(5,4)*P(6,3)*Metric(1,2)*Metric(3,4) - P(5,6)*P(6,3)*Metric(1,2)*Metric(3,4) - P(5,2)*P(6,4)*Metric(1,2)*Metric(3,4) - P(5,2)*P(6,5)*Metric(1,2)*Metric(3,4) - P(5,4)*P(6,5)*Metric(1,2)*Metric(3,4) - P(2,5)*P(6,1)*Metric(1,5)*Metric(3,4) - P(2,6)*P(6,1)*Metric(1,5)*Metric(3,4) - P(2,3)*P(6,2)*Metric(1,5)*Metric(3,4) - P(2,5)*P(6,2)*Metric(1,5)*Metric(3,4) - P(2,5)*P(6,3)*Metric(1,5)*Metric(3,4) - P(2,3)*P(6,4)*Metric(1,5)*Metric(3,4) - P(2,6)*P(6,4)*Metric(1,5)*Metric(3,4) + P(2,5)*P(5,1)*Metric(1,6)*Metric(3,4) + P(2,6)*P(5,1)*Metric(1,6)*Metric(3,4) + P(2,1)*P(5,2)*Metric(1,6)*Metric(3,4) + 2*P(2,3)*P(5,2)*Metric(1,6)*Metric(3,4) + P(2,6)*P(5,2)*Metric(1,6)*Metric(3,4) + 2*P(2,3)*P(5,4)*Metric(1,6)*Metric(3,4) + 2*P(2,5)*P(5,4)*Metric(1,6)*Metric(3,4) + P(2,1)*P(5,6)*Metric(1,6)*Metric(3,4) + P(2,5)*P(5,6)*Metric(1,6)*Metric(3,4) + P(1,2)*P(6,1)*Metric(2,5)*Metric(3,4) + P(1,3)*P(6,1)*Metric(2,5)*Metric(3,4) + P(1,4)*P(6,1)*Metric(2,5)*Metric(3,4) + P(1,5)*P(6,1)*Metric(2,5)*Metric(3,4) + P(1,4)*P(6,2)*Metric(2,5)*Metric(3,4) + P(1,5)*P(6,2)*Metric(2,5)*Metric(3,4) + P(1,6)*P(6,2)*Metric(2,5)*Metric(3,4) + P(1,4)*P(6,3)*Metric(2,5)*Metric(3,4) + P(1,5)*P(6,3)*Metric(2,5)*Metric(3,4) + P(1,6)*P(6,3)*Metric(2,5)*Metric(3,4) + P(1,2)*P(6,4)*Metric(2,5)*Metric(3,4) + P(1,3)*P(6,4)*Metric(2,5)*Metric(3,4) + P(1,6)*P(6,4)*Metric(2,5)*Metric(3,4) + P(1,2)*P(6,5)*Metric(2,5)*Metric(3,4) + P(1,3)*P(6,5)*Metric(2,5)*Metric(3,4) + P(1,6)*P(6,5)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(1,3)*P(5,1)*Metric(2,6)*Metric(3,4) - P(1,6)*P(5,1)*Metric(2,6)*Metric(3,4) - P(1,4)*P(5,2)*Metric(2,6)*Metric(3,4) - P(1,5)*P(5,2)*Metric(2,6)*Metric(3,4) - P(1,6)*P(5,2)*Metric(2,6)*Metric(3,4) - P(1,3)*P(5,4)*Metric(2,6)*Metric(3,4) - P(1,5)*P(5,4)*Metric(2,6)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(4,2)*P(6,1)*Metric(1,2)*Metric(3,5) - P(4,6)*P(6,1)*Metric(1,2)*Metric(3,5) - P(4,5)*P(6,3)*Metric(1,2)*Metric(3,5) - P(4,6)*P(6,3)*Metric(1,2)*Metric(3,5) - P(4,2)*P(6,4)*Metric(1,2)*Metric(3,5) - P(4,5)*P(6,4)*Metric(1,2)*Metric(3,5) - P(4,2)*P(6,5)*Metric(1,2)*Metric(3,5) - P(2,4)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,6)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,3)*P(6,2)*Metric(1,4)*Metric(3,5) - P(2,4)*P(6,2)*Metric(1,4)*Metric(3,5) - P(2,4)*P(6,3)*Metric(1,4)*Metric(3,5) - P(2,3)*P(6,5)*Metric(1,4)*Metric(3,5) - P(2,6)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,4)*P(4,1)*Metric(1,6)*Metric(3,5) + P(2,6)*P(4,1)*Metric(1,6)*Metric(3,5) + P(2,1)*P(4,2)*Metric(1,6)*Metric(3,5) + 2*P(2,3)*P(4,2)*Metric(1,6)*Metric(3,5) + P(2,6)*P(4,2)*Metric(1,6)*Metric(3,5) + 2*P(2,3)*P(4,5)*Metric(1,6)*Metric(3,5) + 2*P(2,4)*P(4,5)*Metric(1,6)*Metric(3,5) + P(2,1)*P(4,6)*Metric(1,6)*Metric(3,5) + P(2,4)*P(4,6)*Metric(1,6)*Metric(3,5) + P(1,2)*P(6,1)*Metric(2,4)*Metric(3,5) + P(1,3)*P(6,1)*Metric(2,4)*Metric(3,5) + P(1,4)*P(6,1)*Metric(2,4)*Metric(3,5) + P(1,5)*P(6,1)*Metric(2,4)*Metric(3,5) + P(1,4)*P(6,2)*Metric(2,4)*Metric(3,5) + P(1,5)*P(6,2)*Metric(2,4)*Metric(3,5) + P(1,6)*P(6,2)*Metric(2,4)*Metric(3,5) + P(1,4)*P(6,3)*Metric(2,4)*Metric(3,5) + P(1,5)*P(6,3)*Metric(2,4)*Metric(3,5) + P(1,6)*P(6,3)*Metric(2,4)*Metric(3,5) + P(1,2)*P(6,4)*Metric(2,4)*Metric(3,5) + P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) + P(1,6)*P(6,4)*Metric(2,4)*Metric(3,5) + P(1,2)*P(6,5)*Metric(2,4)*Metric(3,5) + P(1,3)*P(6,5)*Metric(2,4)*Metric(3,5) + P(1,6)*P(6,5)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(1,3)*P(4,1)*Metric(2,6)*Metric(3,5) - P(1,6)*P(4,1)*Metric(2,6)*Metric(3,5) - P(1,4)*P(4,2)*Metric(2,6)*Metric(3,5) - P(1,5)*P(4,2)*Metric(2,6)*Metric(3,5) - P(1,6)*P(4,2)*Metric(2,6)*Metric(3,5) - P(1,3)*P(4,5)*Metric(2,6)*Metric(3,5) - P(1,4)*P(4,5)*Metric(2,6)*Metric(3,5) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(4,2)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,5)*P(5,1)*Metric(1,2)*Metric(3,6) - P(4,6)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,1)*P(5,2)*Metric(1,2)*Metric(3,6) + P(4,5)*P(5,2)*Metric(1,2)*Metric(3,6) + P(4,5)*P(5,3)*Metric(1,2)*Metric(3,6) + P(4,6)*P(5,3)*Metric(1,2)*Metric(3,6) + P(4,1)*P(5,4)*Metric(1,2)*Metric(3,6) + P(4,2)*P(5,4)*Metric(1,2)*Metric(3,6) + P(4,3)*P(5,4)*Metric(1,2)*Metric(3,6) + P(4,6)*P(5,4)*Metric(1,2)*Metric(3,6) - P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) + P(4,3)*P(5,6)*Metric(1,2)*Metric(3,6) + P(4,5)*P(5,6)*Metric(1,2)*Metric(3,6) - P(2,1)*P(5,2)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,2)*Metric(1,4)*Metric(3,6) + P(2,4)*P(5,3)*Metric(1,4)*Metric(3,6) - P(2,1)*P(5,4)*Metric(1,4)*Metric(3,6) + P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6) - P(2,5)*P(5,4)*Metric(1,4)*Metric(3,6) + P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,5)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,1)*P(4,2)*Metric(1,5)*Metric(3,6) - P(2,3)*P(4,2)*Metric(1,5)*Metric(3,6) + P(2,5)*P(4,3)*Metric(1,5)*Metric(3,6) - P(2,1)*P(4,5)*Metric(1,5)*Metric(3,6) + P(2,3)*P(4,5)*Metric(1,5)*Metric(3,6) - P(2,4)*P(4,5)*Metric(1,5)*Metric(3,6) + P(2,1)*P(4,6)*Metric(1,5)*Metric(3,6) - P(2,3)*P(4,6)*Metric(1,5)*Metric(3,6) - P(2,4)*P(4,6)*Metric(1,5)*Metric(3,6) - P(1,2)*P(5,1)*Metric(2,4)*Metric(3,6) - P(1,6)*P(5,1)*Metric(2,4)*Metric(3,6) - P(1,4)*P(5,3)*Metric(2,4)*Metric(3,6) - P(1,5)*P(5,3)*Metric(2,4)*Metric(3,6) - P(1,6)*P(5,3)*Metric(2,4)*Metric(3,6) - P(1,2)*P(5,4)*Metric(2,4)*Metric(3,6) - P(1,5)*P(5,4)*Metric(2,4)*Metric(3,6) + P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(1,2)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,4)*P(4,3)*Metric(2,5)*Metric(3,6) - P(1,5)*P(4,3)*Metric(2,5)*Metric(3,6) - P(1,6)*P(4,3)*Metric(2,5)*Metric(3,6) - P(1,2)*P(4,5)*Metric(2,5)*Metric(3,6) - P(1,4)*P(4,5)*Metric(2,5)*Metric(3,6) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(3,2)*P(6,1)*Metric(1,2)*Metric(4,5) + 2*P(3,6)*P(6,1)*Metric(1,2)*Metric(4,5) + 2*P(3,2)*P(6,3)*Metric(1,2)*Metric(4,5) + P(3,4)*P(6,3)*Metric(1,2)*Metric(4,5) + P(3,5)*P(6,3)*Metric(1,2)*Metric(4,5) - P(3,2)*P(6,4)*Metric(1,2)*Metric(4,5) + P(3,5)*P(6,4)*Metric(1,2)*Metric(4,5) + P(3,6)*P(6,4)*Metric(1,2)*Metric(4,5) - P(3,2)*P(6,5)*Metric(1,2)*Metric(4,5) + P(3,4)*P(6,5)*Metric(1,2)*Metric(4,5) + P(3,6)*P(6,5)*Metric(1,2)*Metric(4,5) + 2*P(2,3)*P(6,1)*Metric(1,3)*Metric(4,5) + 2*P(2,6)*P(6,1)*Metric(1,3)*Metric(4,5) + 2*P(2,3)*P(6,2)*Metric(1,3)*Metric(4,5) + P(2,4)*P(6,2)*Metric(1,3)*Metric(4,5) + P(2,5)*P(6,2)*Metric(1,3)*Metric(4,5) - P(2,3)*P(6,4)*Metric(1,3)*Metric(4,5) + P(2,5)*P(6,4)*Metric(1,3)*Metric(4,5) + P(2,6)*P(6,4)*Metric(1,3)*Metric(4,5) - P(2,3)*P(6,5)*Metric(1,3)*Metric(4,5) + P(2,4)*P(6,5)*Metric(1,3)*Metric(4,5) + P(2,6)*P(6,5)*Metric(1,3)*Metric(4,5) - 2*P(2,3)*P(3,1)*Metric(1,6)*Metric(4,5) - 2*P(2,6)*P(3,1)*Metric(1,6)*Metric(4,5) - 2*P(2,1)*P(3,2)*Metric(1,6)*Metric(4,5) - 2*P(2,4)*P(3,2)*Metric(1,6)*Metric(4,5) - 2*P(2,5)*P(3,2)*Metric(1,6)*Metric(4,5) - 2*P(2,6)*P(3,2)*Metric(1,6)*Metric(4,5) - 2*P(2,3)*P(3,4)*Metric(1,6)*Metric(4,5) - 2*P(2,5)*P(3,4)*Metric(1,6)*Metric(4,5) - 2*P(2,3)*P(3,5)*Metric(1,6)*Metric(4,5) - 2*P(2,4)*P(3,5)*Metric(1,6)*Metric(4,5) - 2*P(2,1)*P(3,6)*Metric(1,6)*Metric(4,5) - 2*P(2,3)*P(3,6)*Metric(1,6)*Metric(4,5) - 2*P(1,2)*P(6,1)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*P(6,1)*Metric(2,3)*Metric(4,5) - 2*P(1,4)*P(6,1)*Metric(2,3)*Metric(4,5) - 2*P(1,5)*P(6,1)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*P(6,2)*Metric(2,3)*Metric(4,5) + P(1,4)*P(6,2)*Metric(2,3)*Metric(4,5) + P(1,5)*P(6,2)*Metric(2,3)*Metric(4,5) - 2*P(1,6)*P(6,2)*Metric(2,3)*Metric(4,5) - 2*P(1,2)*P(6,3)*Metric(2,3)*Metric(4,5) + P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5) + P(1,5)*P(6,3)*Metric(2,3)*Metric(4,5) - 2*P(1,6)*P(6,3)*Metric(2,3)*Metric(4,5) + P(1,2)*P(6,4)*Metric(2,3)*Metric(4,5) + P(1,3)*P(6,4)*Metric(2,3)*Metric(4,5) - 2*P(1,5)*P(6,4)*Metric(2,3)*Metric(4,5) - 2*P(1,6)*P(6,4)*Metric(2,3)*Metric(4,5) + P(1,2)*P(6,5)*Metric(2,3)*Metric(4,5) + P(1,3)*P(6,5)*Metric(2,3)*Metric(4,5) - 2*P(1,4)*P(6,5)*Metric(2,3)*Metric(4,5) - 2*P(1,6)*P(6,5)*Metric(2,3)*Metric(4,5) + 2*P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(1,4)*P(3,1)*Metric(2,6)*Metric(4,5) + P(1,5)*P(3,1)*Metric(2,6)*Metric(4,5) + 2*P(1,6)*P(3,1)*Metric(2,6)*Metric(4,5) + 2*P(1,3)*P(3,2)*Metric(2,6)*Metric(4,5) - P(1,4)*P(3,2)*Metric(2,6)*Metric(4,5) - P(1,5)*P(3,2)*Metric(2,6)*Metric(4,5) + 2*P(1,6)*P(3,2)*Metric(2,6)*Metric(4,5) + P(1,3)*P(3,4)*Metric(2,6)*Metric(4,5) + P(1,5)*P(3,4)*Metric(2,6)*Metric(4,5) + P(1,3)*P(3,5)*Metric(2,6)*Metric(4,5) + P(1,4)*P(3,5)*Metric(2,6)*Metric(4,5) - 2*P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) - 2*P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(1,4)*P(2,1)*Metric(3,6)*Metric(4,5) + P(1,5)*P(2,1)*Metric(3,6)*Metric(4,5) + 2*P(1,6)*P(2,1)*Metric(3,6)*Metric(4,5) + 2*P(1,2)*P(2,3)*Metric(3,6)*Metric(4,5) - P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5) - P(1,5)*P(2,3)*Metric(3,6)*Metric(4,5) + 2*P(1,6)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,2)*P(2,4)*Metric(3,6)*Metric(4,5) + P(1,5)*P(2,4)*Metric(3,6)*Metric(4,5) + P(1,2)*P(2,5)*Metric(3,6)*Metric(4,5) + P(1,4)*P(2,5)*Metric(3,6)*Metric(4,5) - 2*P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(3,2)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,5)*P(5,1)*Metric(1,2)*Metric(4,6) + P(3,6)*P(5,1)*Metric(1,2)*Metric(4,6) + P(3,4)*P(5,2)*Metric(1,2)*Metric(4,6) - P(3,2)*P(5,3)*Metric(1,2)*Metric(4,6) - P(3,6)*P(5,3)*Metric(1,2)*Metric(4,6) + P(3,2)*P(5,4)*Metric(1,2)*Metric(4,6) - P(3,5)*P(5,4)*Metric(1,2)*Metric(4,6) - P(3,6)*P(5,4)*Metric(1,2)*Metric(4,6) - P(2,3)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,5)*P(5,1)*Metric(1,3)*Metric(4,6) + P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,3)*P(5,2)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,2)*Metric(1,3)*Metric(4,6) + P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) + P(2,3)*P(5,4)*Metric(1,3)*Metric(4,6) - P(2,5)*P(5,4)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,4)*Metric(1,3)*Metric(4,6) + P(2,3)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,5)*P(3,1)*Metric(1,5)*Metric(4,6) - P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,2)*Metric(1,5)*Metric(4,6) + P(2,4)*P(3,2)*Metric(1,5)*Metric(4,6) + P(2,5)*P(3,2)*Metric(1,5)*Metric(4,6) + P(2,6)*P(3,2)*Metric(1,5)*Metric(4,6) + P(2,3)*P(3,4)*Metric(1,5)*Metric(4,6) + P(2,6)*P(3,4)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,5)*Metric(1,5)*Metric(4,6) + P(2,3)*P(3,5)*Metric(1,5)*Metric(4,6) - P(2,1)*P(3,6)*Metric(1,5)*Metric(4,6) + P(2,3)*P(3,6)*Metric(1,5)*Metric(4,6) + P(2,4)*P(3,6)*Metric(1,5)*Metric(4,6) + P(1,2)*P(5,1)*Metric(2,3)*Metric(4,6) + P(1,3)*P(5,1)*Metric(2,3)*Metric(4,6) + 2*P(1,6)*P(5,1)*Metric(2,3)*Metric(4,6) + P(1,3)*P(5,2)*Metric(2,3)*Metric(4,6) + P(1,5)*P(5,2)*Metric(2,3)*Metric(4,6) + P(1,2)*P(5,3)*Metric(2,3)*Metric(4,6) + P(1,5)*P(5,3)*Metric(2,3)*Metric(4,6) - P(1,2)*P(5,4)*Metric(2,3)*Metric(4,6) - P(1,3)*P(5,4)*Metric(2,3)*Metric(4,6) + 2*P(1,5)*P(5,4)*Metric(2,3)*Metric(4,6) + 2*P(1,6)*P(5,4)*Metric(2,3)*Metric(4,6) - P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - 2*P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - 2*P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(1,5)*P(3,1)*Metric(2,5)*Metric(4,6) - P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6) - P(1,3)*P(3,2)*Metric(2,5)*Metric(4,6) - P(1,5)*P(3,2)*Metric(2,5)*Metric(4,6) - P(1,2)*P(3,4)*Metric(2,5)*Metric(4,6) - P(1,3)*P(3,4)*Metric(2,5)*Metric(4,6) - P(1,6)*P(3,4)*Metric(2,5)*Metric(4,6) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(1,5)*P(2,1)*Metric(3,5)*Metric(4,6) - P(1,6)*P(2,1)*Metric(3,5)*Metric(4,6) - P(1,2)*P(2,3)*Metric(3,5)*Metric(4,6) - P(1,5)*P(2,3)*Metric(3,5)*Metric(4,6) - P(1,2)*P(2,4)*Metric(3,5)*Metric(4,6) - P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6) - P(1,6)*P(2,4)*Metric(3,5)*Metric(4,6) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(3,2)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,4)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,5)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,2)*P(4,3)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,3)*Metric(1,2)*Metric(5,6) + P(3,2)*P(4,5)*Metric(1,2)*Metric(5,6) - P(3,4)*P(4,5)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,5)*Metric(1,2)*Metric(5,6) - P(2,3)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,4)*P(4,1)*Metric(1,3)*Metric(5,6) + P(2,6)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,3)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,5)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,3)*P(4,5)*Metric(1,3)*Metric(5,6) - P(2,4)*P(4,5)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,5)*Metric(1,3)*Metric(5,6) + P(2,3)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,4)*P(3,1)*Metric(1,4)*Metric(5,6) - P(2,6)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,4)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,5)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,3)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,3)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,5)*Metric(1,4)*Metric(5,6) - P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) + P(2,3)*P(3,6)*Metric(1,4)*Metric(5,6) + P(2,5)*P(3,6)*Metric(1,4)*Metric(5,6) + P(1,2)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,3)*P(4,1)*Metric(2,3)*Metric(5,6) + 2*P(1,6)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,3)*P(4,2)*Metric(2,3)*Metric(5,6) + P(1,4)*P(4,2)*Metric(2,3)*Metric(5,6) + P(1,2)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,4)*P(4,3)*Metric(2,3)*Metric(5,6) - P(1,2)*P(4,5)*Metric(2,3)*Metric(5,6) - P(1,3)*P(4,5)*Metric(2,3)*Metric(5,6) + 2*P(1,4)*P(4,5)*Metric(2,3)*Metric(5,6) + 2*P(1,6)*P(4,5)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(1,4)*P(3,1)*Metric(2,4)*Metric(5,6) - P(1,6)*P(3,1)*Metric(2,4)*Metric(5,6) - P(1,3)*P(3,2)*Metric(2,4)*Metric(5,6) - P(1,4)*P(3,2)*Metric(2,4)*Metric(5,6) - P(1,2)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,3)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,6)*P(3,5)*Metric(2,4)*Metric(5,6) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(1,4)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,6)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,2)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,2)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,3)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,6)*P(2,5)*Metric(3,4)*Metric(5,6) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV54 = Lorentz(name = 'VVVVVV54',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,4)*P(6,1)*Metric(1,4)*Metric(2,3) - P(5,6)*P(6,1)*Metric(1,4)*Metric(2,3) + (P(5,6)*P(6,2)*Metric(1,4)*Metric(2,3))/2. + (P(5,6)*P(6,3)*Metric(1,4)*Metric(2,3))/2. + P(5,1)*P(6,4)*Metric(1,4)*Metric(2,3) - P(5,1)*P(6,5)*Metric(1,4)*Metric(2,3) + (P(5,2)*P(6,5)*Metric(1,4)*Metric(2,3))/2. + (P(5,3)*P(6,5)*Metric(1,4)*Metric(2,3))/2. + P(4,5)*P(6,1)*Metric(1,5)*Metric(2,3) - P(4,6)*P(6,1)*Metric(1,5)*Metric(2,3) + (P(4,6)*P(6,2)*Metric(1,5)*Metric(2,3))/2. + (P(4,6)*P(6,3)*Metric(1,5)*Metric(2,3))/2. - P(4,1)*P(6,4)*Metric(1,5)*Metric(2,3) + (P(4,2)*P(6,4)*Metric(1,5)*Metric(2,3))/2. + (P(4,3)*P(6,4)*Metric(1,5)*Metric(2,3))/2. + P(4,1)*P(6,5)*Metric(1,5)*Metric(2,3) - P(4,5)*P(5,1)*Metric(1,6)*Metric(2,3) + P(4,6)*P(5,1)*Metric(1,6)*Metric(2,3) + (P(4,5)*P(5,2)*Metric(1,6)*Metric(2,3))/2. + (P(4,5)*P(5,3)*Metric(1,6)*Metric(2,3))/2. - P(4,1)*P(5,4)*Metric(1,6)*Metric(2,3) + (P(4,2)*P(5,4)*Metric(1,6)*Metric(2,3))/2. + (P(4,3)*P(5,4)*Metric(1,6)*Metric(2,3))/2. + P(4,1)*P(5,6)*Metric(1,6)*Metric(2,3) + (P(5,6)*P(6,1)*Metric(1,3)*Metric(2,4))/2. + P(5,4)*P(6,2)*Metric(1,3)*Metric(2,4) - P(5,6)*P(6,2)*Metric(1,3)*Metric(2,4) + (P(5,6)*P(6,3)*Metric(1,3)*Metric(2,4))/2. + P(5,2)*P(6,4)*Metric(1,3)*Metric(2,4) + (P(5,1)*P(6,5)*Metric(1,3)*Metric(2,4))/2. - P(5,2)*P(6,5)*Metric(1,3)*Metric(2,4) + (P(5,3)*P(6,5)*Metric(1,3)*Metric(2,4))/2. - (P(3,5)*P(6,1)*Metric(1,5)*Metric(2,4))/2. + (P(3,6)*P(6,1)*Metric(1,5)*Metric(2,4))/2. - (P(3,4)*P(6,2)*Metric(1,5)*Metric(2,4))/2. + (P(3,6)*P(6,2)*Metric(1,5)*Metric(2,4))/2. + (P(3,4)*P(6,3)*Metric(1,5)*Metric(2,4))/2. + (P(3,5)*P(6,3)*Metric(1,5)*Metric(2,4))/2. - (P(3,2)*P(6,4)*Metric(1,5)*Metric(2,4))/2. - (P(3,1)*P(6,5)*Metric(1,5)*Metric(2,4))/2. + (P(3,5)*P(5,1)*Metric(1,6)*Metric(2,4))/2. - (P(3,6)*P(5,1)*Metric(1,6)*Metric(2,4))/2. - (P(3,4)*P(5,2)*Metric(1,6)*Metric(2,4))/2. + (P(3,5)*P(5,2)*Metric(1,6)*Metric(2,4))/2. + (P(3,4)*P(5,3)*Metric(1,6)*Metric(2,4))/2. + (P(3,6)*P(5,3)*Metric(1,6)*Metric(2,4))/2. - (P(3,2)*P(5,4)*Metric(1,6)*Metric(2,4))/2. - (P(3,1)*P(5,6)*Metric(1,6)*Metric(2,4))/2. + (P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5))/2. + P(4,5)*P(6,2)*Metric(1,3)*Metric(2,5) - P(4,6)*P(6,2)*Metric(1,3)*Metric(2,5) + (P(4,6)*P(6,3)*Metric(1,3)*Metric(2,5))/2. + (P(4,1)*P(6,4)*Metric(1,3)*Metric(2,5))/2. - P(4,2)*P(6,4)*Metric(1,3)*Metric(2,5) + (P(4,3)*P(6,4)*Metric(1,3)*Metric(2,5))/2. + P(4,2)*P(6,5)*Metric(1,3)*Metric(2,5) - (P(3,4)*P(6,1)*Metric(1,4)*Metric(2,5))/2. + (P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5))/2. - (P(3,5)*P(6,2)*Metric(1,4)*Metric(2,5))/2. + (P(3,6)*P(6,2)*Metric(1,4)*Metric(2,5))/2. + (P(3,4)*P(6,3)*Metric(1,4)*Metric(2,5))/2. + (P(3,5)*P(6,3)*Metric(1,4)*Metric(2,5))/2. - (P(3,1)*P(6,4)*Metric(1,4)*Metric(2,5))/2. - (P(3,2)*P(6,5)*Metric(1,4)*Metric(2,5))/2. + (P(3,4)*P(4,1)*Metric(1,6)*Metric(2,5))/2. - (P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5))/2. + (P(3,4)*P(4,2)*Metric(1,6)*Metric(2,5))/2. - (P(3,5)*P(4,2)*Metric(1,6)*Metric(2,5))/2. + (P(3,5)*P(4,3)*Metric(1,6)*Metric(2,5))/2. + (P(3,6)*P(4,3)*Metric(1,6)*Metric(2,5))/2. - (P(3,2)*P(4,5)*Metric(1,6)*Metric(2,5))/2. - (P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5))/2. + (P(4,5)*P(5,1)*Metric(1,3)*Metric(2,6))/2. - P(4,5)*P(5,2)*Metric(1,3)*Metric(2,6) + P(4,6)*P(5,2)*Metric(1,3)*Metric(2,6) + (P(4,5)*P(5,3)*Metric(1,3)*Metric(2,6))/2. + (P(4,1)*P(5,4)*Metric(1,3)*Metric(2,6))/2. - P(4,2)*P(5,4)*Metric(1,3)*Metric(2,6) + (P(4,3)*P(5,4)*Metric(1,3)*Metric(2,6))/2. + P(4,2)*P(5,6)*Metric(1,3)*Metric(2,6) - (P(3,4)*P(5,1)*Metric(1,4)*Metric(2,6))/2. + (P(3,5)*P(5,1)*Metric(1,4)*Metric(2,6))/2. + (P(3,5)*P(5,2)*Metric(1,4)*Metric(2,6))/2. - (P(3,6)*P(5,2)*Metric(1,4)*Metric(2,6))/2. + (P(3,4)*P(5,3)*Metric(1,4)*Metric(2,6))/2. + (P(3,6)*P(5,3)*Metric(1,4)*Metric(2,6))/2. - (P(3,1)*P(5,4)*Metric(1,4)*Metric(2,6))/2. - (P(3,2)*P(5,6)*Metric(1,4)*Metric(2,6))/2. + (P(3,4)*P(4,1)*Metric(1,5)*Metric(2,6))/2. - (P(3,5)*P(4,1)*Metric(1,5)*Metric(2,6))/2. + (P(3,4)*P(4,2)*Metric(1,5)*Metric(2,6))/2. - (P(3,6)*P(4,2)*Metric(1,5)*Metric(2,6))/2. + (P(3,5)*P(4,3)*Metric(1,5)*Metric(2,6))/2. + (P(3,6)*P(4,3)*Metric(1,5)*Metric(2,6))/2. - (P(3,1)*P(4,5)*Metric(1,5)*Metric(2,6))/2. - (P(3,2)*P(4,6)*Metric(1,5)*Metric(2,6))/2. + (P(5,6)*P(6,1)*Metric(1,2)*Metric(3,4))/2. + (P(5,6)*P(6,2)*Metric(1,2)*Metric(3,4))/2. + P(5,4)*P(6,3)*Metric(1,2)*Metric(3,4) - P(5,6)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,3)*P(6,4)*Metric(1,2)*Metric(3,4) + (P(5,1)*P(6,5)*Metric(1,2)*Metric(3,4))/2. + (P(5,2)*P(6,5)*Metric(1,2)*Metric(3,4))/2. - P(5,3)*P(6,5)*Metric(1,2)*Metric(3,4) - (P(2,5)*P(6,1)*Metric(1,5)*Metric(3,4))/2. + (P(2,6)*P(6,1)*Metric(1,5)*Metric(3,4))/2. + (P(2,4)*P(6,2)*Metric(1,5)*Metric(3,4))/2. + (P(2,5)*P(6,2)*Metric(1,5)*Metric(3,4))/2. - (P(2,4)*P(6,3)*Metric(1,5)*Metric(3,4))/2. + (P(2,6)*P(6,3)*Metric(1,5)*Metric(3,4))/2. - (P(2,3)*P(6,4)*Metric(1,5)*Metric(3,4))/2. - (P(2,1)*P(6,5)*Metric(1,5)*Metric(3,4))/2. + (P(2,5)*P(5,1)*Metric(1,6)*Metric(3,4))/2. - (P(2,6)*P(5,1)*Metric(1,6)*Metric(3,4))/2. + (P(2,4)*P(5,2)*Metric(1,6)*Metric(3,4))/2. + (P(2,6)*P(5,2)*Metric(1,6)*Metric(3,4))/2. - (P(2,4)*P(5,3)*Metric(1,6)*Metric(3,4))/2. + (P(2,5)*P(5,3)*Metric(1,6)*Metric(3,4))/2. - (P(2,3)*P(5,4)*Metric(1,6)*Metric(3,4))/2. - (P(2,1)*P(5,6)*Metric(1,6)*Metric(3,4))/2. + (P(1,4)*P(6,1)*Metric(2,5)*Metric(3,4))/2. + (P(1,5)*P(6,1)*Metric(2,5)*Metric(3,4))/2. - (P(1,5)*P(6,2)*Metric(2,5)*Metric(3,4))/2. + (P(1,6)*P(6,2)*Metric(2,5)*Metric(3,4))/2. - (P(1,4)*P(6,3)*Metric(2,5)*Metric(3,4))/2. + (P(1,6)*P(6,3)*Metric(2,5)*Metric(3,4))/2. - (P(1,3)*P(6,4)*Metric(2,5)*Metric(3,4))/2. - (P(1,2)*P(6,5)*Metric(2,5)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. + (P(1,4)*P(5,1)*Metric(2,6)*Metric(3,4))/2. + (P(1,6)*P(5,1)*Metric(2,6)*Metric(3,4))/2. + (P(1,5)*P(5,2)*Metric(2,6)*Metric(3,4))/2. - (P(1,6)*P(5,2)*Metric(2,6)*Metric(3,4))/2. - (P(1,4)*P(5,3)*Metric(2,6)*Metric(3,4))/2. + (P(1,5)*P(5,3)*Metric(2,6)*Metric(3,4))/2. - (P(1,3)*P(5,4)*Metric(2,6)*Metric(3,4))/2. - (P(1,2)*P(5,6)*Metric(2,6)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(4,6)*P(6,1)*Metric(1,2)*Metric(3,5))/2. + (P(4,6)*P(6,2)*Metric(1,2)*Metric(3,5))/2. + P(4,5)*P(6,3)*Metric(1,2)*Metric(3,5) - P(4,6)*P(6,3)*Metric(1,2)*Metric(3,5) + (P(4,1)*P(6,4)*Metric(1,2)*Metric(3,5))/2. + (P(4,2)*P(6,4)*Metric(1,2)*Metric(3,5))/2. - P(4,3)*P(6,4)*Metric(1,2)*Metric(3,5) + P(4,3)*P(6,5)*Metric(1,2)*Metric(3,5) - (P(2,4)*P(6,1)*Metric(1,4)*Metric(3,5))/2. + (P(2,6)*P(6,1)*Metric(1,4)*Metric(3,5))/2. + (P(2,4)*P(6,2)*Metric(1,4)*Metric(3,5))/2. + (P(2,5)*P(6,2)*Metric(1,4)*Metric(3,5))/2. - (P(2,5)*P(6,3)*Metric(1,4)*Metric(3,5))/2. + (P(2,6)*P(6,3)*Metric(1,4)*Metric(3,5))/2. - (P(2,1)*P(6,4)*Metric(1,4)*Metric(3,5))/2. - (P(2,3)*P(6,5)*Metric(1,4)*Metric(3,5))/2. + (P(2,4)*P(4,1)*Metric(1,6)*Metric(3,5))/2. - (P(2,6)*P(4,1)*Metric(1,6)*Metric(3,5))/2. + (P(2,5)*P(4,2)*Metric(1,6)*Metric(3,5))/2. + (P(2,6)*P(4,2)*Metric(1,6)*Metric(3,5))/2. + (P(2,4)*P(4,3)*Metric(1,6)*Metric(3,5))/2. - (P(2,5)*P(4,3)*Metric(1,6)*Metric(3,5))/2. - (P(2,3)*P(4,5)*Metric(1,6)*Metric(3,5))/2. - (P(2,1)*P(4,6)*Metric(1,6)*Metric(3,5))/2. + (P(1,4)*P(6,1)*Metric(2,4)*Metric(3,5))/2. + (P(1,5)*P(6,1)*Metric(2,4)*Metric(3,5))/2. - (P(1,4)*P(6,2)*Metric(2,4)*Metric(3,5))/2. + (P(1,6)*P(6,2)*Metric(2,4)*Metric(3,5))/2. - (P(1,5)*P(6,3)*Metric(2,4)*Metric(3,5))/2. + (P(1,6)*P(6,3)*Metric(2,4)*Metric(3,5))/2. - (P(1,2)*P(6,4)*Metric(2,4)*Metric(3,5))/2. - (P(1,3)*P(6,5)*Metric(2,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(1,5)*P(4,1)*Metric(2,6)*Metric(3,5))/2. + (P(1,6)*P(4,1)*Metric(2,6)*Metric(3,5))/2. + (P(1,4)*P(4,2)*Metric(2,6)*Metric(3,5))/2. - (P(1,6)*P(4,2)*Metric(2,6)*Metric(3,5))/2. + (P(1,4)*P(4,3)*Metric(2,6)*Metric(3,5))/2. - (P(1,5)*P(4,3)*Metric(2,6)*Metric(3,5))/2. - (P(1,3)*P(4,5)*Metric(2,6)*Metric(3,5))/2. - (P(1,2)*P(4,6)*Metric(2,6)*Metric(3,5))/2. - (P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(4,5)*P(5,1)*Metric(1,2)*Metric(3,6))/2. + (P(4,5)*P(5,2)*Metric(1,2)*Metric(3,6))/2. - P(4,5)*P(5,3)*Metric(1,2)*Metric(3,6) + P(4,6)*P(5,3)*Metric(1,2)*Metric(3,6) + (P(4,1)*P(5,4)*Metric(1,2)*Metric(3,6))/2. + (P(4,2)*P(5,4)*Metric(1,2)*Metric(3,6))/2. - P(4,3)*P(5,4)*Metric(1,2)*Metric(3,6) + P(4,3)*P(5,6)*Metric(1,2)*Metric(3,6) - (P(2,4)*P(5,1)*Metric(1,4)*Metric(3,6))/2. + (P(2,5)*P(5,1)*Metric(1,4)*Metric(3,6))/2. + (P(2,4)*P(5,2)*Metric(1,4)*Metric(3,6))/2. + (P(2,6)*P(5,2)*Metric(1,4)*Metric(3,6))/2. + (P(2,5)*P(5,3)*Metric(1,4)*Metric(3,6))/2. - (P(2,6)*P(5,3)*Metric(1,4)*Metric(3,6))/2. - (P(2,1)*P(5,4)*Metric(1,4)*Metric(3,6))/2. - (P(2,3)*P(5,6)*Metric(1,4)*Metric(3,6))/2. + (P(2,4)*P(4,1)*Metric(1,5)*Metric(3,6))/2. - (P(2,5)*P(4,1)*Metric(1,5)*Metric(3,6))/2. + (P(2,5)*P(4,2)*Metric(1,5)*Metric(3,6))/2. + (P(2,6)*P(4,2)*Metric(1,5)*Metric(3,6))/2. + (P(2,4)*P(4,3)*Metric(1,5)*Metric(3,6))/2. - (P(2,6)*P(4,3)*Metric(1,5)*Metric(3,6))/2. - (P(2,1)*P(4,5)*Metric(1,5)*Metric(3,6))/2. - (P(2,3)*P(4,6)*Metric(1,5)*Metric(3,6))/2. + (P(1,4)*P(5,1)*Metric(2,4)*Metric(3,6))/2. + (P(1,6)*P(5,1)*Metric(2,4)*Metric(3,6))/2. - (P(1,4)*P(5,2)*Metric(2,4)*Metric(3,6))/2. + (P(1,5)*P(5,2)*Metric(2,4)*Metric(3,6))/2. + (P(1,5)*P(5,3)*Metric(2,4)*Metric(3,6))/2. - (P(1,6)*P(5,3)*Metric(2,4)*Metric(3,6))/2. - (P(1,2)*P(5,4)*Metric(2,4)*Metric(3,6))/2. - (P(1,3)*P(5,6)*Metric(2,4)*Metric(3,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(1,5)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(1,4)*P(4,2)*Metric(2,5)*Metric(3,6))/2. - (P(1,5)*P(4,2)*Metric(2,5)*Metric(3,6))/2. + (P(1,4)*P(4,3)*Metric(2,5)*Metric(3,6))/2. - (P(1,6)*P(4,3)*Metric(2,5)*Metric(3,6))/2. - (P(1,2)*P(4,5)*Metric(2,5)*Metric(3,6))/2. - (P(1,3)*P(4,6)*Metric(2,5)*Metric(3,6))/2. - (P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - P(3,6)*P(6,1)*Metric(1,2)*Metric(4,5) - P(3,6)*P(6,2)*Metric(1,2)*Metric(4,5) - P(3,4)*P(6,3)*Metric(1,2)*Metric(4,5) - P(3,5)*P(6,3)*Metric(1,2)*Metric(4,5) - P(2,6)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,4)*P(6,2)*Metric(1,3)*Metric(4,5) - P(2,5)*P(6,2)*Metric(1,3)*Metric(4,5) - P(2,6)*P(6,3)*Metric(1,3)*Metric(4,5) + P(2,6)*P(3,1)*Metric(1,6)*Metric(4,5) + (P(2,4)*P(3,2)*Metric(1,6)*Metric(4,5))/2. + (P(2,5)*P(3,2)*Metric(1,6)*Metric(4,5))/2. - P(2,6)*P(3,2)*Metric(1,6)*Metric(4,5) + (P(2,3)*P(3,4)*Metric(1,6)*Metric(4,5))/2. + (P(2,3)*P(3,5)*Metric(1,6)*Metric(4,5))/2. + P(2,1)*P(3,6)*Metric(1,6)*Metric(4,5) - P(2,3)*P(3,6)*Metric(1,6)*Metric(4,5) - P(1,4)*P(6,1)*Metric(2,3)*Metric(4,5) - P(1,5)*P(6,1)*Metric(2,3)*Metric(4,5) - P(1,6)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,6)*P(6,3)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) - (P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) - (P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + (P(1,4)*P(3,1)*Metric(2,6)*Metric(4,5))/2. + (P(1,5)*P(3,1)*Metric(2,6)*Metric(4,5))/2. - P(1,6)*P(3,1)*Metric(2,6)*Metric(4,5) + P(1,6)*P(3,2)*Metric(2,6)*Metric(4,5) + (P(1,3)*P(3,4)*Metric(2,6)*Metric(4,5))/2. + (P(1,3)*P(3,5)*Metric(2,6)*Metric(4,5))/2. + P(1,2)*P(3,6)*Metric(2,6)*Metric(4,5) - P(1,3)*P(3,6)*Metric(2,6)*Metric(4,5) - (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) - (P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) - (P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + (P(1,4)*P(2,1)*Metric(3,6)*Metric(4,5))/2. + (P(1,5)*P(2,1)*Metric(3,6)*Metric(4,5))/2. - P(1,6)*P(2,1)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,3)*Metric(3,6)*Metric(4,5) + (P(1,2)*P(2,4)*Metric(3,6)*Metric(4,5))/2. + (P(1,2)*P(2,5)*Metric(3,6)*Metric(4,5))/2. - P(1,2)*P(2,6)*Metric(3,6)*Metric(4,5) + P(1,3)*P(2,6)*Metric(3,6)*Metric(4,5) - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. - (P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) - (P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. - (P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(3,5)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,5)*P(5,2)*Metric(1,2)*Metric(4,6) - P(3,4)*P(5,3)*Metric(1,2)*Metric(4,6) - P(3,6)*P(5,3)*Metric(1,2)*Metric(4,6) - P(2,5)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,2)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,2)*Metric(1,3)*Metric(4,6) - P(2,5)*P(5,3)*Metric(1,3)*Metric(4,6) + P(2,5)*P(3,1)*Metric(1,5)*Metric(4,6) + (P(2,4)*P(3,2)*Metric(1,5)*Metric(4,6))/2. - P(2,5)*P(3,2)*Metric(1,5)*Metric(4,6) + (P(2,6)*P(3,2)*Metric(1,5)*Metric(4,6))/2. + (P(2,3)*P(3,4)*Metric(1,5)*Metric(4,6))/2. + P(2,1)*P(3,5)*Metric(1,5)*Metric(4,6) - P(2,3)*P(3,5)*Metric(1,5)*Metric(4,6) + (P(2,3)*P(3,6)*Metric(1,5)*Metric(4,6))/2. - P(1,4)*P(5,1)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,1)*Metric(2,3)*Metric(4,6) - P(1,5)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,5)*P(5,3)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) - (P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - (P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(1,4)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - P(1,5)*P(3,1)*Metric(2,5)*Metric(4,6) + (P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6))/2. + P(1,5)*P(3,2)*Metric(2,5)*Metric(4,6) + (P(1,3)*P(3,4)*Metric(2,5)*Metric(4,6))/2. + P(1,2)*P(3,5)*Metric(2,5)*Metric(4,6) - P(1,3)*P(3,5)*Metric(2,5)*Metric(4,6) + (P(1,3)*P(3,6)*Metric(2,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6) - (P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) - (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - (P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(1,4)*P(2,1)*Metric(3,5)*Metric(4,6))/2. - P(1,5)*P(2,1)*Metric(3,5)*Metric(4,6) + (P(1,6)*P(2,1)*Metric(3,5)*Metric(4,6))/2. + P(1,5)*P(2,3)*Metric(3,5)*Metric(4,6) + (P(1,2)*P(2,4)*Metric(3,5)*Metric(4,6))/2. - P(1,2)*P(2,5)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,5)*Metric(3,5)*Metric(4,6) + (P(1,2)*P(2,6)*Metric(3,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(3,4)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,4)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,5)*P(4,3)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,3)*Metric(1,2)*Metric(5,6) - P(2,4)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,5)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,4)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,4)*P(3,1)*Metric(1,4)*Metric(5,6) - P(2,4)*P(3,2)*Metric(1,4)*Metric(5,6) + (P(2,5)*P(3,2)*Metric(1,4)*Metric(5,6))/2. + (P(2,6)*P(3,2)*Metric(1,4)*Metric(5,6))/2. + P(2,1)*P(3,4)*Metric(1,4)*Metric(5,6) - P(2,3)*P(3,4)*Metric(1,4)*Metric(5,6) + (P(2,3)*P(3,5)*Metric(1,4)*Metric(5,6))/2. + (P(2,3)*P(3,6)*Metric(1,4)*Metric(5,6))/2. - P(1,5)*P(4,1)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,1)*Metric(2,3)*Metric(5,6) - P(1,4)*P(4,2)*Metric(2,3)*Metric(5,6) - P(1,4)*P(4,3)*Metric(2,3)*Metric(5,6) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6))/2. - (P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6))/2. + P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - (P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6))/2. - (P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6))/2. - P(1,4)*P(3,1)*Metric(2,4)*Metric(5,6) + (P(1,5)*P(3,1)*Metric(2,4)*Metric(5,6))/2. + (P(1,6)*P(3,1)*Metric(2,4)*Metric(5,6))/2. + P(1,4)*P(3,2)*Metric(2,4)*Metric(5,6) + P(1,2)*P(3,4)*Metric(2,4)*Metric(5,6) - P(1,3)*P(3,4)*Metric(2,4)*Metric(5,6) + (P(1,3)*P(3,5)*Metric(2,4)*Metric(5,6))/2. + (P(1,3)*P(3,6)*Metric(2,4)*Metric(5,6))/2. + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - (P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - (P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - P(1,4)*P(2,1)*Metric(3,4)*Metric(5,6) + (P(1,5)*P(2,1)*Metric(3,4)*Metric(5,6))/2. + (P(1,6)*P(2,1)*Metric(3,4)*Metric(5,6))/2. + P(1,4)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,2)*P(2,4)*Metric(3,4)*Metric(5,6) + P(1,3)*P(2,4)*Metric(3,4)*Metric(5,6) + (P(1,2)*P(2,5)*Metric(3,4)*Metric(5,6))/2. + (P(1,2)*P(2,6)*Metric(3,4)*Metric(5,6))/2. + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) - (P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. - (P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. + P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) - (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. - (P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. + P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV55 = Lorentz(name = 'VVVVVV55',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) - P(5,4)*P(6,1)*Metric(1,4)*Metric(2,3) - P(5,6)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,2)*Metric(1,4)*Metric(2,3) - P(5,3)*P(6,2)*Metric(1,4)*Metric(2,3) - P(5,6)*P(6,2)*Metric(1,4)*Metric(2,3) - P(5,2)*P(6,3)*Metric(1,4)*Metric(2,3) - P(5,6)*P(6,3)*Metric(1,4)*Metric(2,3) - P(5,1)*P(6,4)*Metric(1,4)*Metric(2,3) - P(5,6)*P(6,4)*Metric(1,4)*Metric(2,3) - P(5,1)*P(6,5)*Metric(1,4)*Metric(2,3) - P(5,2)*P(6,5)*Metric(1,4)*Metric(2,3) - P(5,3)*P(6,5)*Metric(1,4)*Metric(2,3) - P(5,4)*P(6,5)*Metric(1,4)*Metric(2,3) - P(4,1)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,6)*P(6,2)*Metric(1,5)*Metric(2,3) - P(4,5)*P(6,3)*Metric(1,5)*Metric(2,3) + P(4,1)*P(6,4)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,4)*Metric(1,5)*Metric(2,3) + P(4,1)*P(6,5)*Metric(1,5)*Metric(2,3) - P(4,3)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,6)*P(6,5)*Metric(1,5)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) + P(4,3)*P(5,2)*Metric(1,6)*Metric(2,3) + P(4,5)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3) + P(4,1)*P(5,4)*Metric(1,6)*Metric(2,3) + P(4,3)*P(5,4)*Metric(1,6)*Metric(2,3) + P(4,1)*P(5,6)*Metric(1,6)*Metric(2,3) - P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3) + P(4,5)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,2)*P(6,1)*Metric(1,3)*Metric(2,4) - P(5,3)*P(6,1)*Metric(1,3)*Metric(2,4) - P(5,6)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) - P(5,4)*P(6,2)*Metric(1,3)*Metric(2,4) - P(5,6)*P(6,2)*Metric(1,3)*Metric(2,4) - P(5,1)*P(6,3)*Metric(1,3)*Metric(2,4) - P(5,6)*P(6,3)*Metric(1,3)*Metric(2,4) - P(5,2)*P(6,4)*Metric(1,3)*Metric(2,4) - P(5,6)*P(6,4)*Metric(1,3)*Metric(2,4) - P(5,1)*P(6,5)*Metric(1,3)*Metric(2,4) - P(5,2)*P(6,5)*Metric(1,3)*Metric(2,4) - P(5,3)*P(6,5)*Metric(1,3)*Metric(2,4) - P(5,4)*P(6,5)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) + P(3,4)*P(6,2)*Metric(1,5)*Metric(2,4) + P(3,6)*P(6,2)*Metric(1,5)*Metric(2,4) + P(3,1)*P(6,3)*Metric(1,5)*Metric(2,4) + P(3,4)*P(6,3)*Metric(1,5)*Metric(2,4) - P(3,5)*P(6,4)*Metric(1,5)*Metric(2,4) + P(3,1)*P(6,5)*Metric(1,5)*Metric(2,4) - P(3,4)*P(6,5)*Metric(1,5)*Metric(2,4) + P(3,6)*P(6,5)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,2)*Metric(1,6)*Metric(2,4) + P(3,4)*P(5,2)*Metric(1,6)*Metric(2,4) + P(3,5)*P(5,2)*Metric(1,6)*Metric(2,4) + P(3,1)*P(5,3)*Metric(1,6)*Metric(2,4) + P(3,4)*P(5,3)*Metric(1,6)*Metric(2,4) - P(3,6)*P(5,4)*Metric(1,6)*Metric(2,4) + P(3,1)*P(5,6)*Metric(1,6)*Metric(2,4) - P(3,4)*P(5,6)*Metric(1,6)*Metric(2,4) + P(3,5)*P(5,6)*Metric(1,6)*Metric(2,4) - P(4,2)*P(6,1)*Metric(1,3)*Metric(2,5) + P(4,3)*P(6,1)*Metric(1,3)*Metric(2,5) + P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5) - P(4,5)*P(6,3)*Metric(1,3)*Metric(2,5) + P(4,2)*P(6,4)*Metric(1,3)*Metric(2,5) + P(4,3)*P(6,4)*Metric(1,3)*Metric(2,5) + P(4,2)*P(6,5)*Metric(1,3)*Metric(2,5) - P(4,3)*P(6,5)*Metric(1,3)*Metric(2,5) + P(4,6)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) + P(3,4)*P(6,1)*Metric(1,4)*Metric(2,5) + P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5) + P(3,2)*P(6,3)*Metric(1,4)*Metric(2,5) + P(3,4)*P(6,3)*Metric(1,4)*Metric(2,5) - P(3,5)*P(6,4)*Metric(1,4)*Metric(2,5) + P(3,2)*P(6,5)*Metric(1,4)*Metric(2,5) - P(3,4)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,6)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) - P(3,4)*P(4,1)*Metric(1,6)*Metric(2,5) - P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,2)*Metric(1,6)*Metric(2,5) - P(3,4)*P(4,2)*Metric(1,6)*Metric(2,5) - P(3,5)*P(4,2)*Metric(1,6)*Metric(2,5) - P(3,1)*P(4,3)*Metric(1,6)*Metric(2,5) - P(3,2)*P(4,3)*Metric(1,6)*Metric(2,5) - P(3,5)*P(4,3)*Metric(1,6)*Metric(2,5) - P(3,6)*P(4,3)*Metric(1,6)*Metric(2,5) - P(3,2)*P(4,5)*Metric(1,6)*Metric(2,5) - P(3,4)*P(4,5)*Metric(1,6)*Metric(2,5) - P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5) - P(3,4)*P(4,6)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,3)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,5)*P(5,1)*Metric(1,3)*Metric(2,6) - P(4,6)*P(5,3)*Metric(1,3)*Metric(2,6) + P(4,2)*P(5,4)*Metric(1,3)*Metric(2,6) + P(4,3)*P(5,4)*Metric(1,3)*Metric(2,6) + P(4,2)*P(5,6)*Metric(1,3)*Metric(2,6) - P(4,3)*P(5,6)*Metric(1,3)*Metric(2,6) + P(4,5)*P(5,6)*Metric(1,3)*Metric(2,6) - P(3,2)*P(5,1)*Metric(1,4)*Metric(2,6) + P(3,4)*P(5,1)*Metric(1,4)*Metric(2,6) + P(3,5)*P(5,1)*Metric(1,4)*Metric(2,6) + P(3,2)*P(5,3)*Metric(1,4)*Metric(2,6) + P(3,4)*P(5,3)*Metric(1,4)*Metric(2,6) - P(3,6)*P(5,4)*Metric(1,4)*Metric(2,6) + P(3,2)*P(5,6)*Metric(1,4)*Metric(2,6) - P(3,4)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,5)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,2)*P(4,1)*Metric(1,5)*Metric(2,6) - P(3,4)*P(4,1)*Metric(1,5)*Metric(2,6) - P(3,5)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) - P(3,4)*P(4,2)*Metric(1,5)*Metric(2,6) - P(3,6)*P(4,2)*Metric(1,5)*Metric(2,6) - P(3,1)*P(4,3)*Metric(1,5)*Metric(2,6) - P(3,2)*P(4,3)*Metric(1,5)*Metric(2,6) - P(3,5)*P(4,3)*Metric(1,5)*Metric(2,6) - P(3,6)*P(4,3)*Metric(1,5)*Metric(2,6) - P(3,1)*P(4,5)*Metric(1,5)*Metric(2,6) - P(3,4)*P(4,5)*Metric(1,5)*Metric(2,6) - P(3,2)*P(4,6)*Metric(1,5)*Metric(2,6) - P(3,4)*P(4,6)*Metric(1,5)*Metric(2,6) + 2*P(5,2)*P(6,1)*Metric(1,2)*Metric(3,4) + 2*P(5,6)*P(6,1)*Metric(1,2)*Metric(3,4) + 2*P(5,1)*P(6,2)*Metric(1,2)*Metric(3,4) + 2*P(5,6)*P(6,2)*Metric(1,2)*Metric(3,4) + 2*P(5,4)*P(6,3)*Metric(1,2)*Metric(3,4) + 2*P(5,6)*P(6,3)*Metric(1,2)*Metric(3,4) + 2*P(5,3)*P(6,4)*Metric(1,2)*Metric(3,4) + 2*P(5,6)*P(6,4)*Metric(1,2)*Metric(3,4) + 2*P(5,1)*P(6,5)*Metric(1,2)*Metric(3,4) + 2*P(5,2)*P(6,5)*Metric(1,2)*Metric(3,4) + 2*P(5,3)*P(6,5)*Metric(1,2)*Metric(3,4) + 2*P(5,4)*P(6,5)*Metric(1,2)*Metric(3,4) - 2*P(2,1)*P(6,2)*Metric(1,5)*Metric(3,4) - P(2,3)*P(6,2)*Metric(1,5)*Metric(3,4) - P(2,4)*P(6,2)*Metric(1,5)*Metric(3,4) - P(2,4)*P(6,3)*Metric(1,5)*Metric(3,4) - P(2,6)*P(6,3)*Metric(1,5)*Metric(3,4) - P(2,3)*P(6,4)*Metric(1,5)*Metric(3,4) - P(2,6)*P(6,4)*Metric(1,5)*Metric(3,4) - 2*P(2,1)*P(6,5)*Metric(1,5)*Metric(3,4) + P(2,3)*P(6,5)*Metric(1,5)*Metric(3,4) + P(2,4)*P(6,5)*Metric(1,5)*Metric(3,4) - 2*P(2,6)*P(6,5)*Metric(1,5)*Metric(3,4) - 2*P(2,1)*P(5,2)*Metric(1,6)*Metric(3,4) - P(2,3)*P(5,2)*Metric(1,6)*Metric(3,4) - P(2,4)*P(5,2)*Metric(1,6)*Metric(3,4) - P(2,4)*P(5,3)*Metric(1,6)*Metric(3,4) - P(2,5)*P(5,3)*Metric(1,6)*Metric(3,4) - P(2,3)*P(5,4)*Metric(1,6)*Metric(3,4) - P(2,5)*P(5,4)*Metric(1,6)*Metric(3,4) - 2*P(2,1)*P(5,6)*Metric(1,6)*Metric(3,4) + P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4) + P(2,4)*P(5,6)*Metric(1,6)*Metric(3,4) - 2*P(2,5)*P(5,6)*Metric(1,6)*Metric(3,4) - 2*P(1,2)*P(6,1)*Metric(2,5)*Metric(3,4) - P(1,3)*P(6,1)*Metric(2,5)*Metric(3,4) - P(1,4)*P(6,1)*Metric(2,5)*Metric(3,4) - P(1,4)*P(6,3)*Metric(2,5)*Metric(3,4) - P(1,6)*P(6,3)*Metric(2,5)*Metric(3,4) - P(1,3)*P(6,4)*Metric(2,5)*Metric(3,4) - P(1,6)*P(6,4)*Metric(2,5)*Metric(3,4) - 2*P(1,2)*P(6,5)*Metric(2,5)*Metric(3,4) + P(1,3)*P(6,5)*Metric(2,5)*Metric(3,4) + P(1,4)*P(6,5)*Metric(2,5)*Metric(3,4) - 2*P(1,6)*P(6,5)*Metric(2,5)*Metric(3,4) + 2*P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + 2*P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(1,2)*P(5,1)*Metric(2,6)*Metric(3,4) - P(1,3)*P(5,1)*Metric(2,6)*Metric(3,4) - P(1,4)*P(5,1)*Metric(2,6)*Metric(3,4) - P(1,4)*P(5,3)*Metric(2,6)*Metric(3,4) - P(1,5)*P(5,3)*Metric(2,6)*Metric(3,4) - P(1,3)*P(5,4)*Metric(2,6)*Metric(3,4) - P(1,5)*P(5,4)*Metric(2,6)*Metric(3,4) - 2*P(1,2)*P(5,6)*Metric(2,6)*Metric(3,4) + P(1,3)*P(5,6)*Metric(2,6)*Metric(3,4) + P(1,4)*P(5,6)*Metric(2,6)*Metric(3,4) - 2*P(1,5)*P(5,6)*Metric(2,6)*Metric(3,4) + 2*P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(4,2)*P(6,1)*Metric(1,2)*Metric(3,5) - P(4,6)*P(6,1)*Metric(1,2)*Metric(3,5) - P(4,1)*P(6,2)*Metric(1,2)*Metric(3,5) - P(4,6)*P(6,2)*Metric(1,2)*Metric(3,5) - P(4,1)*P(6,4)*Metric(1,2)*Metric(3,5) - P(4,2)*P(6,4)*Metric(1,2)*Metric(3,5) - 2*P(4,3)*P(6,4)*Metric(1,2)*Metric(3,5) - 2*P(4,3)*P(6,5)*Metric(1,2)*Metric(3,5) - 2*P(4,6)*P(6,5)*Metric(1,2)*Metric(3,5) + P(2,1)*P(6,2)*Metric(1,4)*Metric(3,5) + P(2,3)*P(6,2)*Metric(1,4)*Metric(3,5) + P(2,1)*P(6,4)*Metric(1,4)*Metric(3,5) + P(2,5)*P(6,4)*Metric(1,4)*Metric(3,5) + P(2,6)*P(6,4)*Metric(1,4)*Metric(3,5) + P(2,3)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,6)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,1)*P(4,2)*Metric(1,6)*Metric(3,5) + P(2,5)*P(4,2)*Metric(1,6)*Metric(3,5) + P(2,4)*P(4,3)*Metric(1,6)*Metric(3,5) + P(2,5)*P(4,3)*Metric(1,6)*Metric(3,5) + P(2,1)*P(4,6)*Metric(1,6)*Metric(3,5) + P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5) + P(2,4)*P(4,6)*Metric(1,6)*Metric(3,5) + P(1,2)*P(6,1)*Metric(2,4)*Metric(3,5) + P(1,3)*P(6,1)*Metric(2,4)*Metric(3,5) + P(1,2)*P(6,4)*Metric(2,4)*Metric(3,5) + P(1,5)*P(6,4)*Metric(2,4)*Metric(3,5) + P(1,6)*P(6,4)*Metric(2,4)*Metric(3,5) + P(1,3)*P(6,5)*Metric(2,4)*Metric(3,5) + P(1,6)*P(6,5)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(1,2)*P(4,1)*Metric(2,6)*Metric(3,5) + P(1,5)*P(4,1)*Metric(2,6)*Metric(3,5) + P(1,4)*P(4,3)*Metric(2,6)*Metric(3,5) + P(1,5)*P(4,3)*Metric(2,6)*Metric(3,5) + P(1,2)*P(4,6)*Metric(2,6)*Metric(3,5) + P(1,3)*P(4,6)*Metric(2,6)*Metric(3,5) + P(1,4)*P(4,6)*Metric(2,6)*Metric(3,5) - P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(4,2)*P(5,1)*Metric(1,2)*Metric(3,6) - P(4,5)*P(5,1)*Metric(1,2)*Metric(3,6) - P(4,1)*P(5,2)*Metric(1,2)*Metric(3,6) - P(4,5)*P(5,2)*Metric(1,2)*Metric(3,6) - P(4,1)*P(5,4)*Metric(1,2)*Metric(3,6) - P(4,2)*P(5,4)*Metric(1,2)*Metric(3,6) - 2*P(4,3)*P(5,4)*Metric(1,2)*Metric(3,6) - 2*P(4,3)*P(5,6)*Metric(1,2)*Metric(3,6) - 2*P(4,5)*P(5,6)*Metric(1,2)*Metric(3,6) + P(2,1)*P(5,2)*Metric(1,4)*Metric(3,6) + P(2,3)*P(5,2)*Metric(1,4)*Metric(3,6) + P(2,1)*P(5,4)*Metric(1,4)*Metric(3,6) + P(2,5)*P(5,4)*Metric(1,4)*Metric(3,6) + P(2,6)*P(5,4)*Metric(1,4)*Metric(3,6) + P(2,3)*P(5,6)*Metric(1,4)*Metric(3,6) + P(2,5)*P(5,6)*Metric(1,4)*Metric(3,6) + P(2,1)*P(4,2)*Metric(1,5)*Metric(3,6) + P(2,6)*P(4,2)*Metric(1,5)*Metric(3,6) + P(2,4)*P(4,3)*Metric(1,5)*Metric(3,6) + P(2,6)*P(4,3)*Metric(1,5)*Metric(3,6) + P(2,1)*P(4,5)*Metric(1,5)*Metric(3,6) + P(2,3)*P(4,5)*Metric(1,5)*Metric(3,6) + P(2,4)*P(4,5)*Metric(1,5)*Metric(3,6) + P(1,2)*P(5,1)*Metric(2,4)*Metric(3,6) + P(1,3)*P(5,1)*Metric(2,4)*Metric(3,6) + P(1,2)*P(5,4)*Metric(2,4)*Metric(3,6) + P(1,5)*P(5,4)*Metric(2,4)*Metric(3,6) + P(1,6)*P(5,4)*Metric(2,4)*Metric(3,6) + P(1,3)*P(5,6)*Metric(2,4)*Metric(3,6) + P(1,5)*P(5,6)*Metric(2,4)*Metric(3,6) - P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(1,2)*P(4,1)*Metric(2,5)*Metric(3,6) + P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6) + P(1,4)*P(4,3)*Metric(2,5)*Metric(3,6) + P(1,6)*P(4,3)*Metric(2,5)*Metric(3,6) + P(1,2)*P(4,5)*Metric(2,5)*Metric(3,6) + P(1,3)*P(4,5)*Metric(2,5)*Metric(3,6) + P(1,4)*P(4,5)*Metric(2,5)*Metric(3,6) - P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(3,2)*P(6,1)*Metric(1,2)*Metric(4,5) - P(3,6)*P(6,1)*Metric(1,2)*Metric(4,5) - P(3,1)*P(6,2)*Metric(1,2)*Metric(4,5) - P(3,6)*P(6,2)*Metric(1,2)*Metric(4,5) - P(3,1)*P(6,3)*Metric(1,2)*Metric(4,5) - P(3,2)*P(6,3)*Metric(1,2)*Metric(4,5) - 2*P(3,4)*P(6,3)*Metric(1,2)*Metric(4,5) - 2*P(3,4)*P(6,5)*Metric(1,2)*Metric(4,5) - 2*P(3,6)*P(6,5)*Metric(1,2)*Metric(4,5) + P(2,1)*P(6,2)*Metric(1,3)*Metric(4,5) + P(2,4)*P(6,2)*Metric(1,3)*Metric(4,5) + P(2,1)*P(6,3)*Metric(1,3)*Metric(4,5) + P(2,5)*P(6,3)*Metric(1,3)*Metric(4,5) + P(2,6)*P(6,3)*Metric(1,3)*Metric(4,5) + P(2,4)*P(6,5)*Metric(1,3)*Metric(4,5) + P(2,6)*P(6,5)*Metric(1,3)*Metric(4,5) + P(2,1)*P(3,2)*Metric(1,6)*Metric(4,5) + P(2,5)*P(3,2)*Metric(1,6)*Metric(4,5) + P(2,3)*P(3,4)*Metric(1,6)*Metric(4,5) + P(2,5)*P(3,4)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,6)*Metric(1,6)*Metric(4,5) + P(2,3)*P(3,6)*Metric(1,6)*Metric(4,5) + P(2,4)*P(3,6)*Metric(1,6)*Metric(4,5) + P(1,2)*P(6,1)*Metric(2,3)*Metric(4,5) + P(1,4)*P(6,1)*Metric(2,3)*Metric(4,5) + P(1,2)*P(6,3)*Metric(2,3)*Metric(4,5) + P(1,5)*P(6,3)*Metric(2,3)*Metric(4,5) + P(1,6)*P(6,3)*Metric(2,3)*Metric(4,5) + P(1,4)*P(6,5)*Metric(2,3)*Metric(4,5) + P(1,6)*P(6,5)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(1,2)*P(3,1)*Metric(2,6)*Metric(4,5) + P(1,5)*P(3,1)*Metric(2,6)*Metric(4,5) + P(1,3)*P(3,4)*Metric(2,6)*Metric(4,5) + P(1,5)*P(3,4)*Metric(2,6)*Metric(4,5) + P(1,2)*P(3,6)*Metric(2,6)*Metric(4,5) + P(1,3)*P(3,6)*Metric(2,6)*Metric(4,5) + P(1,4)*P(3,6)*Metric(2,6)*Metric(4,5) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(1,3)*P(2,1)*Metric(3,6)*Metric(4,5) - P(1,4)*P(2,1)*Metric(3,6)*Metric(4,5) - P(1,5)*P(2,1)*Metric(3,6)*Metric(4,5) - P(1,6)*P(2,1)*Metric(3,6)*Metric(4,5) - P(1,2)*P(2,3)*Metric(3,6)*Metric(4,5) - P(1,5)*P(2,3)*Metric(3,6)*Metric(4,5) - P(1,6)*P(2,3)*Metric(3,6)*Metric(4,5) - P(1,2)*P(2,4)*Metric(3,6)*Metric(4,5) - P(1,5)*P(2,4)*Metric(3,6)*Metric(4,5) - P(1,6)*P(2,4)*Metric(3,6)*Metric(4,5) - P(1,2)*P(2,5)*Metric(3,6)*Metric(4,5) - P(1,3)*P(2,5)*Metric(3,6)*Metric(4,5) - P(1,4)*P(2,5)*Metric(3,6)*Metric(4,5) - P(1,2)*P(2,6)*Metric(3,6)*Metric(4,5) - P(1,3)*P(2,6)*Metric(3,6)*Metric(4,5) - P(1,4)*P(2,6)*Metric(3,6)*Metric(4,5) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(3,2)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,5)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,1)*P(5,2)*Metric(1,2)*Metric(4,6) - P(3,5)*P(5,2)*Metric(1,2)*Metric(4,6) - P(3,1)*P(5,3)*Metric(1,2)*Metric(4,6) - P(3,2)*P(5,3)*Metric(1,2)*Metric(4,6) - 2*P(3,4)*P(5,3)*Metric(1,2)*Metric(4,6) - 2*P(3,4)*P(5,6)*Metric(1,2)*Metric(4,6) - 2*P(3,5)*P(5,6)*Metric(1,2)*Metric(4,6) + P(2,1)*P(5,2)*Metric(1,3)*Metric(4,6) + P(2,4)*P(5,2)*Metric(1,3)*Metric(4,6) + P(2,1)*P(5,3)*Metric(1,3)*Metric(4,6) + P(2,5)*P(5,3)*Metric(1,3)*Metric(4,6) + P(2,6)*P(5,3)*Metric(1,3)*Metric(4,6) + P(2,4)*P(5,6)*Metric(1,3)*Metric(4,6) + P(2,5)*P(5,6)*Metric(1,3)*Metric(4,6) + P(2,1)*P(3,2)*Metric(1,5)*Metric(4,6) + P(2,6)*P(3,2)*Metric(1,5)*Metric(4,6) + P(2,3)*P(3,4)*Metric(1,5)*Metric(4,6) + P(2,6)*P(3,4)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,5)*Metric(1,5)*Metric(4,6) + P(2,3)*P(3,5)*Metric(1,5)*Metric(4,6) + P(2,4)*P(3,5)*Metric(1,5)*Metric(4,6) + P(1,2)*P(5,1)*Metric(2,3)*Metric(4,6) + P(1,4)*P(5,1)*Metric(2,3)*Metric(4,6) + P(1,2)*P(5,3)*Metric(2,3)*Metric(4,6) + P(1,5)*P(5,3)*Metric(2,3)*Metric(4,6) + P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6) + P(1,4)*P(5,6)*Metric(2,3)*Metric(4,6) + P(1,5)*P(5,6)*Metric(2,3)*Metric(4,6) - P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(1,2)*P(3,1)*Metric(2,5)*Metric(4,6) + P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6) + P(1,3)*P(3,4)*Metric(2,5)*Metric(4,6) + P(1,6)*P(3,4)*Metric(2,5)*Metric(4,6) + P(1,2)*P(3,5)*Metric(2,5)*Metric(4,6) + P(1,3)*P(3,5)*Metric(2,5)*Metric(4,6) + P(1,4)*P(3,5)*Metric(2,5)*Metric(4,6) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(1,3)*P(2,1)*Metric(3,5)*Metric(4,6) - P(1,4)*P(2,1)*Metric(3,5)*Metric(4,6) - P(1,5)*P(2,1)*Metric(3,5)*Metric(4,6) - P(1,6)*P(2,1)*Metric(3,5)*Metric(4,6) - P(1,2)*P(2,3)*Metric(3,5)*Metric(4,6) - P(1,5)*P(2,3)*Metric(3,5)*Metric(4,6) - P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6) - P(1,2)*P(2,4)*Metric(3,5)*Metric(4,6) - P(1,5)*P(2,4)*Metric(3,5)*Metric(4,6) - P(1,6)*P(2,4)*Metric(3,5)*Metric(4,6) - P(1,2)*P(2,5)*Metric(3,5)*Metric(4,6) - P(1,3)*P(2,5)*Metric(3,5)*Metric(4,6) - P(1,4)*P(2,5)*Metric(3,5)*Metric(4,6) - P(1,2)*P(2,6)*Metric(3,5)*Metric(4,6) - P(1,3)*P(2,6)*Metric(3,5)*Metric(4,6) - P(1,4)*P(2,6)*Metric(3,5)*Metric(4,6) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(3,2)*P(4,1)*Metric(1,2)*Metric(5,6) + 2*P(3,4)*P(4,1)*Metric(1,2)*Metric(5,6) + 2*P(3,1)*P(4,2)*Metric(1,2)*Metric(5,6) + 2*P(3,4)*P(4,2)*Metric(1,2)*Metric(5,6) + 2*P(3,1)*P(4,3)*Metric(1,2)*Metric(5,6) + 2*P(3,2)*P(4,3)*Metric(1,2)*Metric(5,6) + 2*P(3,5)*P(4,3)*Metric(1,2)*Metric(5,6) + 2*P(3,6)*P(4,3)*Metric(1,2)*Metric(5,6) + 2*P(3,4)*P(4,5)*Metric(1,2)*Metric(5,6) + 2*P(3,6)*P(4,5)*Metric(1,2)*Metric(5,6) + 2*P(3,4)*P(4,6)*Metric(1,2)*Metric(5,6) + 2*P(3,5)*P(4,6)*Metric(1,2)*Metric(5,6) - 2*P(2,1)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,5)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,2)*Metric(1,3)*Metric(5,6) - 2*P(2,1)*P(4,3)*Metric(1,3)*Metric(5,6) - 2*P(2,4)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,5)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,6)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,4)*P(4,5)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,5)*Metric(1,3)*Metric(5,6) - P(2,4)*P(4,6)*Metric(1,3)*Metric(5,6) - P(2,5)*P(4,6)*Metric(1,3)*Metric(5,6) - 2*P(2,1)*P(3,2)*Metric(1,4)*Metric(5,6) - P(2,5)*P(3,2)*Metric(1,4)*Metric(5,6) - P(2,6)*P(3,2)*Metric(1,4)*Metric(5,6) - 2*P(2,1)*P(3,4)*Metric(1,4)*Metric(5,6) - 2*P(2,3)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,5)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,4)*Metric(1,4)*Metric(5,6) - P(2,3)*P(3,5)*Metric(1,4)*Metric(5,6) - P(2,6)*P(3,5)*Metric(1,4)*Metric(5,6) - P(2,3)*P(3,6)*Metric(1,4)*Metric(5,6) - P(2,5)*P(3,6)*Metric(1,4)*Metric(5,6) - 2*P(1,2)*P(4,1)*Metric(2,3)*Metric(5,6) - P(1,5)*P(4,1)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,1)*Metric(2,3)*Metric(5,6) - 2*P(1,2)*P(4,3)*Metric(2,3)*Metric(5,6) - 2*P(1,4)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,5)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6) - P(1,4)*P(4,5)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,5)*Metric(2,3)*Metric(5,6) - P(1,4)*P(4,6)*Metric(2,3)*Metric(5,6) - P(1,5)*P(4,6)*Metric(2,3)*Metric(5,6) + 2*P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) + 2*P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(1,2)*P(3,1)*Metric(2,4)*Metric(5,6) - P(1,5)*P(3,1)*Metric(2,4)*Metric(5,6) - P(1,6)*P(3,1)*Metric(2,4)*Metric(5,6) - 2*P(1,2)*P(3,4)*Metric(2,4)*Metric(5,6) - 2*P(1,3)*P(3,4)*Metric(2,4)*Metric(5,6) + P(1,5)*P(3,4)*Metric(2,4)*Metric(5,6) + P(1,6)*P(3,4)*Metric(2,4)*Metric(5,6) - P(1,3)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,6)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,3)*P(3,6)*Metric(2,4)*Metric(5,6) - P(1,5)*P(3,6)*Metric(2,4)*Metric(5,6) + 2*P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(1,3)*P(2,1)*Metric(3,4)*Metric(5,6) + 2*P(1,4)*P(2,1)*Metric(3,4)*Metric(5,6) + 2*P(1,5)*P(2,1)*Metric(3,4)*Metric(5,6) + 2*P(1,6)*P(2,1)*Metric(3,4)*Metric(5,6) + 2*P(1,2)*P(2,3)*Metric(3,4)*Metric(5,6) + 2*P(1,4)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,5)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6) + 2*P(1,2)*P(2,4)*Metric(3,4)*Metric(5,6) + 2*P(1,3)*P(2,4)*Metric(3,4)*Metric(5,6) - P(1,5)*P(2,4)*Metric(3,4)*Metric(5,6) - P(1,6)*P(2,4)*Metric(3,4)*Metric(5,6) + 2*P(1,2)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,3)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,5)*Metric(3,4)*Metric(5,6) + 2*P(1,6)*P(2,5)*Metric(3,4)*Metric(5,6) + 2*P(1,2)*P(2,6)*Metric(3,4)*Metric(5,6) - P(1,3)*P(2,6)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,6)*Metric(3,4)*Metric(5,6) + 2*P(1,5)*P(2,6)*Metric(3,4)*Metric(5,6) - 2*P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV56 = Lorentz(name = 'VVVVVV56',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) - (P(5,3)*P(6,1)*Metric(1,4)*Metric(2,3))/2. - (P(5,4)*P(6,1)*Metric(1,4)*Metric(2,3))/2. + P(5,1)*P(6,2)*Metric(1,4)*Metric(2,3) - (P(5,3)*P(6,2)*Metric(1,4)*Metric(2,3))/2. - (P(5,4)*P(6,2)*Metric(1,4)*Metric(2,3))/2. - (P(5,1)*P(6,3)*Metric(1,4)*Metric(2,3))/2. - (P(5,2)*P(6,3)*Metric(1,4)*Metric(2,3))/2. + P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3) - (P(5,6)*P(6,3)*Metric(1,4)*Metric(2,3))/2. - (P(5,1)*P(6,4)*Metric(1,4)*Metric(2,3))/2. - (P(5,2)*P(6,4)*Metric(1,4)*Metric(2,3))/2. + P(5,3)*P(6,4)*Metric(1,4)*Metric(2,3) - (P(5,6)*P(6,4)*Metric(1,4)*Metric(2,3))/2. - (P(5,3)*P(6,5)*Metric(1,4)*Metric(2,3))/2. - (P(5,4)*P(6,5)*Metric(1,4)*Metric(2,3))/2. + (P(4,5)*P(6,1)*Metric(1,5)*Metric(2,3))/2. - (P(4,6)*P(6,1)*Metric(1,5)*Metric(2,3))/2. - P(4,1)*P(6,2)*Metric(1,5)*Metric(2,3) + (P(4,5)*P(6,2)*Metric(1,5)*Metric(2,3))/2. + (P(4,6)*P(6,2)*Metric(1,5)*Metric(2,3))/2. + (P(4,1)*P(6,3)*Metric(1,5)*Metric(2,3))/2. + (P(4,2)*P(6,3)*Metric(1,5)*Metric(2,3))/2. - (P(4,5)*P(6,3)*Metric(1,5)*Metric(2,3))/2. - P(4,6)*P(6,3)*Metric(1,5)*Metric(2,3) + (P(4,1)*P(6,4)*Metric(1,5)*Metric(2,3))/2. - (P(4,2)*P(6,4)*Metric(1,5)*Metric(2,3))/2. + (P(4,3)*P(6,4)*Metric(1,5)*Metric(2,3))/2. - P(4,5)*P(6,4)*Metric(1,5)*Metric(2,3) - (P(4,3)*P(6,5)*Metric(1,5)*Metric(2,3))/2. + (P(4,6)*P(6,5)*Metric(1,5)*Metric(2,3))/2. - (P(4,5)*P(5,1)*Metric(1,6)*Metric(2,3))/2. + (P(4,6)*P(5,1)*Metric(1,6)*Metric(2,3))/2. - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) + (P(4,5)*P(5,2)*Metric(1,6)*Metric(2,3))/2. + (P(4,6)*P(5,2)*Metric(1,6)*Metric(2,3))/2. + (P(4,1)*P(5,3)*Metric(1,6)*Metric(2,3))/2. + (P(4,2)*P(5,3)*Metric(1,6)*Metric(2,3))/2. - P(4,5)*P(5,3)*Metric(1,6)*Metric(2,3) - (P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3))/2. + (P(4,1)*P(5,4)*Metric(1,6)*Metric(2,3))/2. - (P(4,2)*P(5,4)*Metric(1,6)*Metric(2,3))/2. + (P(4,3)*P(5,4)*Metric(1,6)*Metric(2,3))/2. - P(4,6)*P(5,4)*Metric(1,6)*Metric(2,3) - (P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3))/2. + (P(4,5)*P(5,6)*Metric(1,6)*Metric(2,3))/2. + P(5,2)*P(6,1)*Metric(1,3)*Metric(2,4) - (P(5,3)*P(6,1)*Metric(1,3)*Metric(2,4))/2. - (P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4))/2. + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) - (P(5,3)*P(6,2)*Metric(1,3)*Metric(2,4))/2. - (P(5,4)*P(6,2)*Metric(1,3)*Metric(2,4))/2. - (P(5,1)*P(6,3)*Metric(1,3)*Metric(2,4))/2. - (P(5,2)*P(6,3)*Metric(1,3)*Metric(2,4))/2. + P(5,4)*P(6,3)*Metric(1,3)*Metric(2,4) - (P(5,6)*P(6,3)*Metric(1,3)*Metric(2,4))/2. - (P(5,1)*P(6,4)*Metric(1,3)*Metric(2,4))/2. - (P(5,2)*P(6,4)*Metric(1,3)*Metric(2,4))/2. + P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) - (P(5,6)*P(6,4)*Metric(1,3)*Metric(2,4))/2. - (P(5,3)*P(6,5)*Metric(1,3)*Metric(2,4))/2. - (P(5,4)*P(6,5)*Metric(1,3)*Metric(2,4))/2. + (P(3,5)*P(6,1)*Metric(1,5)*Metric(2,4))/2. - (P(3,6)*P(6,1)*Metric(1,5)*Metric(2,4))/2. - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) + (P(3,5)*P(6,2)*Metric(1,5)*Metric(2,4))/2. + (P(3,6)*P(6,2)*Metric(1,5)*Metric(2,4))/2. + (P(3,1)*P(6,3)*Metric(1,5)*Metric(2,4))/2. - (P(3,2)*P(6,3)*Metric(1,5)*Metric(2,4))/2. + (P(3,4)*P(6,3)*Metric(1,5)*Metric(2,4))/2. - P(3,5)*P(6,3)*Metric(1,5)*Metric(2,4) + (P(3,1)*P(6,4)*Metric(1,5)*Metric(2,4))/2. + (P(3,2)*P(6,4)*Metric(1,5)*Metric(2,4))/2. - (P(3,5)*P(6,4)*Metric(1,5)*Metric(2,4))/2. - P(3,6)*P(6,4)*Metric(1,5)*Metric(2,4) - (P(3,4)*P(6,5)*Metric(1,5)*Metric(2,4))/2. + (P(3,6)*P(6,5)*Metric(1,5)*Metric(2,4))/2. - (P(3,5)*P(5,1)*Metric(1,6)*Metric(2,4))/2. + (P(3,6)*P(5,1)*Metric(1,6)*Metric(2,4))/2. - P(3,1)*P(5,2)*Metric(1,6)*Metric(2,4) + (P(3,5)*P(5,2)*Metric(1,6)*Metric(2,4))/2. + (P(3,6)*P(5,2)*Metric(1,6)*Metric(2,4))/2. + (P(3,1)*P(5,3)*Metric(1,6)*Metric(2,4))/2. - (P(3,2)*P(5,3)*Metric(1,6)*Metric(2,4))/2. + (P(3,4)*P(5,3)*Metric(1,6)*Metric(2,4))/2. - P(3,6)*P(5,3)*Metric(1,6)*Metric(2,4) + (P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4))/2. + (P(3,2)*P(5,4)*Metric(1,6)*Metric(2,4))/2. - P(3,5)*P(5,4)*Metric(1,6)*Metric(2,4) - (P(3,6)*P(5,4)*Metric(1,6)*Metric(2,4))/2. - (P(3,4)*P(5,6)*Metric(1,6)*Metric(2,4))/2. + (P(3,5)*P(5,6)*Metric(1,6)*Metric(2,4))/2. - P(4,2)*P(6,1)*Metric(1,3)*Metric(2,5) + (P(4,5)*P(6,1)*Metric(1,3)*Metric(2,5))/2. + (P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5))/2. + (P(4,5)*P(6,2)*Metric(1,3)*Metric(2,5))/2. - (P(4,6)*P(6,2)*Metric(1,3)*Metric(2,5))/2. + (P(4,1)*P(6,3)*Metric(1,3)*Metric(2,5))/2. + (P(4,2)*P(6,3)*Metric(1,3)*Metric(2,5))/2. - (P(4,5)*P(6,3)*Metric(1,3)*Metric(2,5))/2. - P(4,6)*P(6,3)*Metric(1,3)*Metric(2,5) - (P(4,1)*P(6,4)*Metric(1,3)*Metric(2,5))/2. + (P(4,2)*P(6,4)*Metric(1,3)*Metric(2,5))/2. + (P(4,3)*P(6,4)*Metric(1,3)*Metric(2,5))/2. - P(4,5)*P(6,4)*Metric(1,3)*Metric(2,5) - (P(4,3)*P(6,5)*Metric(1,3)*Metric(2,5))/2. + (P(4,6)*P(6,5)*Metric(1,3)*Metric(2,5))/2. - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) + (P(3,5)*P(6,1)*Metric(1,4)*Metric(2,5))/2. + (P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5))/2. + (P(3,5)*P(6,2)*Metric(1,4)*Metric(2,5))/2. - (P(3,6)*P(6,2)*Metric(1,4)*Metric(2,5))/2. - (P(3,1)*P(6,3)*Metric(1,4)*Metric(2,5))/2. + (P(3,2)*P(6,3)*Metric(1,4)*Metric(2,5))/2. + (P(3,4)*P(6,3)*Metric(1,4)*Metric(2,5))/2. - P(3,5)*P(6,3)*Metric(1,4)*Metric(2,5) + (P(3,1)*P(6,4)*Metric(1,4)*Metric(2,5))/2. + (P(3,2)*P(6,4)*Metric(1,4)*Metric(2,5))/2. - (P(3,5)*P(6,4)*Metric(1,4)*Metric(2,5))/2. - P(3,6)*P(6,4)*Metric(1,4)*Metric(2,5) - (P(3,4)*P(6,5)*Metric(1,4)*Metric(2,5))/2. + (P(3,6)*P(6,5)*Metric(1,4)*Metric(2,5))/2. + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) - (P(3,5)*P(4,1)*Metric(1,6)*Metric(2,5))/2. - (P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5))/2. + P(3,1)*P(4,2)*Metric(1,6)*Metric(2,5) - (P(3,5)*P(4,2)*Metric(1,6)*Metric(2,5))/2. - (P(3,6)*P(4,2)*Metric(1,6)*Metric(2,5))/2. - (P(3,5)*P(4,3)*Metric(1,6)*Metric(2,5))/2. - (P(3,6)*P(4,3)*Metric(1,6)*Metric(2,5))/2. - (P(3,1)*P(4,5)*Metric(1,6)*Metric(2,5))/2. - (P(3,2)*P(4,5)*Metric(1,6)*Metric(2,5))/2. - (P(3,4)*P(4,5)*Metric(1,6)*Metric(2,5))/2. + P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) - (P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5))/2. - (P(3,2)*P(4,6)*Metric(1,6)*Metric(2,5))/2. - (P(3,4)*P(4,6)*Metric(1,6)*Metric(2,5))/2. + P(3,5)*P(4,6)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) + (P(4,5)*P(5,1)*Metric(1,3)*Metric(2,6))/2. + (P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6))/2. - (P(4,5)*P(5,2)*Metric(1,3)*Metric(2,6))/2. + (P(4,6)*P(5,2)*Metric(1,3)*Metric(2,6))/2. + (P(4,1)*P(5,3)*Metric(1,3)*Metric(2,6))/2. + (P(4,2)*P(5,3)*Metric(1,3)*Metric(2,6))/2. - P(4,5)*P(5,3)*Metric(1,3)*Metric(2,6) - (P(4,6)*P(5,3)*Metric(1,3)*Metric(2,6))/2. - (P(4,1)*P(5,4)*Metric(1,3)*Metric(2,6))/2. + (P(4,2)*P(5,4)*Metric(1,3)*Metric(2,6))/2. + (P(4,3)*P(5,4)*Metric(1,3)*Metric(2,6))/2. - P(4,6)*P(5,4)*Metric(1,3)*Metric(2,6) - (P(4,3)*P(5,6)*Metric(1,3)*Metric(2,6))/2. + (P(4,5)*P(5,6)*Metric(1,3)*Metric(2,6))/2. - P(3,2)*P(5,1)*Metric(1,4)*Metric(2,6) + (P(3,5)*P(5,1)*Metric(1,4)*Metric(2,6))/2. + (P(3,6)*P(5,1)*Metric(1,4)*Metric(2,6))/2. - (P(3,5)*P(5,2)*Metric(1,4)*Metric(2,6))/2. + (P(3,6)*P(5,2)*Metric(1,4)*Metric(2,6))/2. - (P(3,1)*P(5,3)*Metric(1,4)*Metric(2,6))/2. + (P(3,2)*P(5,3)*Metric(1,4)*Metric(2,6))/2. + (P(3,4)*P(5,3)*Metric(1,4)*Metric(2,6))/2. - P(3,6)*P(5,3)*Metric(1,4)*Metric(2,6) + (P(3,1)*P(5,4)*Metric(1,4)*Metric(2,6))/2. + (P(3,2)*P(5,4)*Metric(1,4)*Metric(2,6))/2. - P(3,5)*P(5,4)*Metric(1,4)*Metric(2,6) - (P(3,6)*P(5,4)*Metric(1,4)*Metric(2,6))/2. - (P(3,4)*P(5,6)*Metric(1,4)*Metric(2,6))/2. + (P(3,5)*P(5,6)*Metric(1,4)*Metric(2,6))/2. + P(3,2)*P(4,1)*Metric(1,5)*Metric(2,6) - (P(3,5)*P(4,1)*Metric(1,5)*Metric(2,6))/2. - (P(3,6)*P(4,1)*Metric(1,5)*Metric(2,6))/2. + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) - (P(3,5)*P(4,2)*Metric(1,5)*Metric(2,6))/2. - (P(3,6)*P(4,2)*Metric(1,5)*Metric(2,6))/2. - (P(3,5)*P(4,3)*Metric(1,5)*Metric(2,6))/2. - (P(3,6)*P(4,3)*Metric(1,5)*Metric(2,6))/2. - (P(3,1)*P(4,5)*Metric(1,5)*Metric(2,6))/2. - (P(3,2)*P(4,5)*Metric(1,5)*Metric(2,6))/2. - (P(3,4)*P(4,5)*Metric(1,5)*Metric(2,6))/2. + P(3,6)*P(4,5)*Metric(1,5)*Metric(2,6) - (P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6))/2. - (P(3,2)*P(4,6)*Metric(1,5)*Metric(2,6))/2. - (P(3,4)*P(4,6)*Metric(1,5)*Metric(2,6))/2. + P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) + 2*P(5,2)*P(6,1)*Metric(1,2)*Metric(3,4) - (P(5,3)*P(6,1)*Metric(1,2)*Metric(3,4))/2. - (P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4))/2. + 2*P(5,1)*P(6,2)*Metric(1,2)*Metric(3,4) - (P(5,3)*P(6,2)*Metric(1,2)*Metric(3,4))/2. - (P(5,4)*P(6,2)*Metric(1,2)*Metric(3,4))/2. - (P(5,1)*P(6,3)*Metric(1,2)*Metric(3,4))/2. - (P(5,2)*P(6,3)*Metric(1,2)*Metric(3,4))/2. + P(5,4)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,6)*P(6,3)*Metric(1,2)*Metric(3,4) - (P(5,1)*P(6,4)*Metric(1,2)*Metric(3,4))/2. - (P(5,2)*P(6,4)*Metric(1,2)*Metric(3,4))/2. + P(5,3)*P(6,4)*Metric(1,2)*Metric(3,4) + P(5,6)*P(6,4)*Metric(1,2)*Metric(3,4) + P(5,3)*P(6,5)*Metric(1,2)*Metric(3,4) + P(5,4)*P(6,5)*Metric(1,2)*Metric(3,4) - P(2,5)*P(6,1)*Metric(1,5)*Metric(3,4) + P(2,6)*P(6,1)*Metric(1,5)*Metric(3,4) - 2*P(2,1)*P(6,2)*Metric(1,5)*Metric(3,4) + P(2,5)*P(6,2)*Metric(1,5)*Metric(3,4) + (P(2,1)*P(6,3)*Metric(1,5)*Metric(3,4))/2. - (P(2,4)*P(6,3)*Metric(1,5)*Metric(3,4))/2. - (P(2,6)*P(6,3)*Metric(1,5)*Metric(3,4))/2. + (P(2,1)*P(6,4)*Metric(1,5)*Metric(3,4))/2. - (P(2,3)*P(6,4)*Metric(1,5)*Metric(3,4))/2. - (P(2,6)*P(6,4)*Metric(1,5)*Metric(3,4))/2. + (P(2,3)*P(6,5)*Metric(1,5)*Metric(3,4))/2. + (P(2,4)*P(6,5)*Metric(1,5)*Metric(3,4))/2. - P(2,6)*P(6,5)*Metric(1,5)*Metric(3,4) + P(2,5)*P(5,1)*Metric(1,6)*Metric(3,4) - P(2,6)*P(5,1)*Metric(1,6)*Metric(3,4) - 2*P(2,1)*P(5,2)*Metric(1,6)*Metric(3,4) + P(2,6)*P(5,2)*Metric(1,6)*Metric(3,4) + (P(2,1)*P(5,3)*Metric(1,6)*Metric(3,4))/2. - (P(2,4)*P(5,3)*Metric(1,6)*Metric(3,4))/2. - (P(2,5)*P(5,3)*Metric(1,6)*Metric(3,4))/2. + (P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4))/2. - (P(2,3)*P(5,4)*Metric(1,6)*Metric(3,4))/2. - (P(2,5)*P(5,4)*Metric(1,6)*Metric(3,4))/2. + (P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4))/2. + (P(2,4)*P(5,6)*Metric(1,6)*Metric(3,4))/2. - P(2,5)*P(5,6)*Metric(1,6)*Metric(3,4) - 2*P(1,2)*P(6,1)*Metric(2,5)*Metric(3,4) + P(1,5)*P(6,1)*Metric(2,5)*Metric(3,4) - P(1,5)*P(6,2)*Metric(2,5)*Metric(3,4) + P(1,6)*P(6,2)*Metric(2,5)*Metric(3,4) + (P(1,2)*P(6,3)*Metric(2,5)*Metric(3,4))/2. - (P(1,4)*P(6,3)*Metric(2,5)*Metric(3,4))/2. - (P(1,6)*P(6,3)*Metric(2,5)*Metric(3,4))/2. + (P(1,2)*P(6,4)*Metric(2,5)*Metric(3,4))/2. - (P(1,3)*P(6,4)*Metric(2,5)*Metric(3,4))/2. - (P(1,6)*P(6,4)*Metric(2,5)*Metric(3,4))/2. + (P(1,3)*P(6,5)*Metric(2,5)*Metric(3,4))/2. + (P(1,4)*P(6,5)*Metric(2,5)*Metric(3,4))/2. - P(1,6)*P(6,5)*Metric(2,5)*Metric(3,4) + 2*P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + (P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. + (P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + (P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. + (P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. + P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(1,2)*P(5,1)*Metric(2,6)*Metric(3,4) + P(1,6)*P(5,1)*Metric(2,6)*Metric(3,4) + P(1,5)*P(5,2)*Metric(2,6)*Metric(3,4) - P(1,6)*P(5,2)*Metric(2,6)*Metric(3,4) + (P(1,2)*P(5,3)*Metric(2,6)*Metric(3,4))/2. - (P(1,4)*P(5,3)*Metric(2,6)*Metric(3,4))/2. - (P(1,5)*P(5,3)*Metric(2,6)*Metric(3,4))/2. + (P(1,2)*P(5,4)*Metric(2,6)*Metric(3,4))/2. - (P(1,3)*P(5,4)*Metric(2,6)*Metric(3,4))/2. - (P(1,5)*P(5,4)*Metric(2,6)*Metric(3,4))/2. + (P(1,3)*P(5,6)*Metric(2,6)*Metric(3,4))/2. + (P(1,4)*P(5,6)*Metric(2,6)*Metric(3,4))/2. - P(1,5)*P(5,6)*Metric(2,6)*Metric(3,4) + 2*P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) + (P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + (P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(4,2)*P(6,1)*Metric(1,2)*Metric(3,5) + (P(4,3)*P(6,1)*Metric(1,2)*Metric(3,5))/2. - P(4,1)*P(6,2)*Metric(1,2)*Metric(3,5) + (P(4,3)*P(6,2)*Metric(1,2)*Metric(3,5))/2. - 2*P(4,5)*P(6,3)*Metric(1,2)*Metric(3,5) + 2*P(4,6)*P(6,3)*Metric(1,2)*Metric(3,5) - P(4,3)*P(6,4)*Metric(1,2)*Metric(3,5) + 2*P(4,5)*P(6,4)*Metric(1,2)*Metric(3,5) + (P(4,1)*P(6,5)*Metric(1,2)*Metric(3,5))/2. + (P(4,2)*P(6,5)*Metric(1,2)*Metric(3,5))/2. - P(4,3)*P(6,5)*Metric(1,2)*Metric(3,5) - P(4,6)*P(6,5)*Metric(1,2)*Metric(3,5) + (P(2,3)*P(6,1)*Metric(1,4)*Metric(3,5))/2. + (P(2,4)*P(6,1)*Metric(1,4)*Metric(3,5))/2. - (P(2,5)*P(6,1)*Metric(1,4)*Metric(3,5))/2. - (P(2,6)*P(6,1)*Metric(1,4)*Metric(3,5))/2. + P(2,1)*P(6,2)*Metric(1,4)*Metric(3,5) + (P(2,3)*P(6,2)*Metric(1,4)*Metric(3,5))/2. - (P(2,4)*P(6,2)*Metric(1,4)*Metric(3,5))/2. - (P(2,5)*P(6,2)*Metric(1,4)*Metric(3,5))/2. + P(2,5)*P(6,3)*Metric(1,4)*Metric(3,5) - P(2,6)*P(6,3)*Metric(1,4)*Metric(3,5) - P(2,3)*P(6,4)*Metric(1,4)*Metric(3,5) + (P(2,5)*P(6,4)*Metric(1,4)*Metric(3,5))/2. + (3*P(2,6)*P(6,4)*Metric(1,4)*Metric(3,5))/2. - (P(2,1)*P(6,5)*Metric(1,4)*Metric(3,5))/2. + (P(2,3)*P(6,5)*Metric(1,4)*Metric(3,5))/2. + (P(2,6)*P(6,5)*Metric(1,4)*Metric(3,5))/2. - (P(2,3)*P(4,1)*Metric(1,6)*Metric(3,5))/2. - (P(2,4)*P(4,1)*Metric(1,6)*Metric(3,5))/2. + (P(2,5)*P(4,1)*Metric(1,6)*Metric(3,5))/2. + (P(2,6)*P(4,1)*Metric(1,6)*Metric(3,5))/2. + P(2,1)*P(4,2)*Metric(1,6)*Metric(3,5) - (P(2,3)*P(4,2)*Metric(1,6)*Metric(3,5))/2. + (P(2,5)*P(4,2)*Metric(1,6)*Metric(3,5))/2. - (P(2,6)*P(4,2)*Metric(1,6)*Metric(3,5))/2. - (P(2,1)*P(4,3)*Metric(1,6)*Metric(3,5))/2. + (P(2,4)*P(4,3)*Metric(1,6)*Metric(3,5))/2. + (P(2,5)*P(4,3)*Metric(1,6)*Metric(3,5))/2. + P(2,3)*P(4,5)*Metric(1,6)*Metric(3,5) - P(2,4)*P(4,5)*Metric(1,6)*Metric(3,5) + (P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5))/2. + (3*P(2,4)*P(4,6)*Metric(1,6)*Metric(3,5))/2. - P(2,5)*P(4,6)*Metric(1,6)*Metric(3,5) + P(1,2)*P(6,1)*Metric(2,4)*Metric(3,5) + (P(1,3)*P(6,1)*Metric(2,4)*Metric(3,5))/2. - (P(1,4)*P(6,1)*Metric(2,4)*Metric(3,5))/2. - (P(1,5)*P(6,1)*Metric(2,4)*Metric(3,5))/2. + (P(1,3)*P(6,2)*Metric(2,4)*Metric(3,5))/2. + (P(1,4)*P(6,2)*Metric(2,4)*Metric(3,5))/2. - (P(1,5)*P(6,2)*Metric(2,4)*Metric(3,5))/2. - (P(1,6)*P(6,2)*Metric(2,4)*Metric(3,5))/2. + P(1,5)*P(6,3)*Metric(2,4)*Metric(3,5) - P(1,6)*P(6,3)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) + (P(1,5)*P(6,4)*Metric(2,4)*Metric(3,5))/2. + (3*P(1,6)*P(6,4)*Metric(2,4)*Metric(3,5))/2. - (P(1,2)*P(6,5)*Metric(2,4)*Metric(3,5))/2. + (P(1,3)*P(6,5)*Metric(2,4)*Metric(3,5))/2. + (P(1,6)*P(6,5)*Metric(2,4)*Metric(3,5))/2. - P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) - (P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + (P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - (3*P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + P(1,2)*P(4,1)*Metric(2,6)*Metric(3,5) - (P(1,3)*P(4,1)*Metric(2,6)*Metric(3,5))/2. + (P(1,5)*P(4,1)*Metric(2,6)*Metric(3,5))/2. - (P(1,6)*P(4,1)*Metric(2,6)*Metric(3,5))/2. - (P(1,3)*P(4,2)*Metric(2,6)*Metric(3,5))/2. - (P(1,4)*P(4,2)*Metric(2,6)*Metric(3,5))/2. + (P(1,5)*P(4,2)*Metric(2,6)*Metric(3,5))/2. + (P(1,6)*P(4,2)*Metric(2,6)*Metric(3,5))/2. - (P(1,2)*P(4,3)*Metric(2,6)*Metric(3,5))/2. + (P(1,4)*P(4,3)*Metric(2,6)*Metric(3,5))/2. + (P(1,5)*P(4,3)*Metric(2,6)*Metric(3,5))/2. + P(1,3)*P(4,5)*Metric(2,6)*Metric(3,5) - P(1,4)*P(4,5)*Metric(2,6)*Metric(3,5) + (P(1,3)*P(4,6)*Metric(2,6)*Metric(3,5))/2. + (3*P(1,4)*P(4,6)*Metric(2,6)*Metric(3,5))/2. - P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) - P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,6)*Metric(3,5) + (P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) + (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - (3*P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - P(4,2)*P(5,1)*Metric(1,2)*Metric(3,6) + (P(4,3)*P(5,1)*Metric(1,2)*Metric(3,6))/2. - P(4,1)*P(5,2)*Metric(1,2)*Metric(3,6) + (P(4,3)*P(5,2)*Metric(1,2)*Metric(3,6))/2. + 2*P(4,5)*P(5,3)*Metric(1,2)*Metric(3,6) - 2*P(4,6)*P(5,3)*Metric(1,2)*Metric(3,6) - P(4,3)*P(5,4)*Metric(1,2)*Metric(3,6) + 2*P(4,6)*P(5,4)*Metric(1,2)*Metric(3,6) + (P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6))/2. + (P(4,2)*P(5,6)*Metric(1,2)*Metric(3,6))/2. - P(4,3)*P(5,6)*Metric(1,2)*Metric(3,6) - P(4,5)*P(5,6)*Metric(1,2)*Metric(3,6) + (P(2,3)*P(5,1)*Metric(1,4)*Metric(3,6))/2. + (P(2,4)*P(5,1)*Metric(1,4)*Metric(3,6))/2. - (P(2,5)*P(5,1)*Metric(1,4)*Metric(3,6))/2. - (P(2,6)*P(5,1)*Metric(1,4)*Metric(3,6))/2. + P(2,1)*P(5,2)*Metric(1,4)*Metric(3,6) + (P(2,3)*P(5,2)*Metric(1,4)*Metric(3,6))/2. - (P(2,4)*P(5,2)*Metric(1,4)*Metric(3,6))/2. - (P(2,6)*P(5,2)*Metric(1,4)*Metric(3,6))/2. - P(2,5)*P(5,3)*Metric(1,4)*Metric(3,6) + P(2,6)*P(5,3)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6) + (3*P(2,5)*P(5,4)*Metric(1,4)*Metric(3,6))/2. + (P(2,6)*P(5,4)*Metric(1,4)*Metric(3,6))/2. - (P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6))/2. + (P(2,3)*P(5,6)*Metric(1,4)*Metric(3,6))/2. + (P(2,5)*P(5,6)*Metric(1,4)*Metric(3,6))/2. - (P(2,3)*P(4,1)*Metric(1,5)*Metric(3,6))/2. - (P(2,4)*P(4,1)*Metric(1,5)*Metric(3,6))/2. + (P(2,5)*P(4,1)*Metric(1,5)*Metric(3,6))/2. + (P(2,6)*P(4,1)*Metric(1,5)*Metric(3,6))/2. + P(2,1)*P(4,2)*Metric(1,5)*Metric(3,6) - (P(2,3)*P(4,2)*Metric(1,5)*Metric(3,6))/2. - (P(2,5)*P(4,2)*Metric(1,5)*Metric(3,6))/2. + (P(2,6)*P(4,2)*Metric(1,5)*Metric(3,6))/2. - (P(2,1)*P(4,3)*Metric(1,5)*Metric(3,6))/2. + (P(2,4)*P(4,3)*Metric(1,5)*Metric(3,6))/2. + (P(2,6)*P(4,3)*Metric(1,5)*Metric(3,6))/2. + (P(2,3)*P(4,5)*Metric(1,5)*Metric(3,6))/2. + (3*P(2,4)*P(4,5)*Metric(1,5)*Metric(3,6))/2. - P(2,6)*P(4,5)*Metric(1,5)*Metric(3,6) + P(2,3)*P(4,6)*Metric(1,5)*Metric(3,6) - P(2,4)*P(4,6)*Metric(1,5)*Metric(3,6) + P(1,2)*P(5,1)*Metric(2,4)*Metric(3,6) + (P(1,3)*P(5,1)*Metric(2,4)*Metric(3,6))/2. - (P(1,4)*P(5,1)*Metric(2,4)*Metric(3,6))/2. - (P(1,6)*P(5,1)*Metric(2,4)*Metric(3,6))/2. + (P(1,3)*P(5,2)*Metric(2,4)*Metric(3,6))/2. + (P(1,4)*P(5,2)*Metric(2,4)*Metric(3,6))/2. - (P(1,5)*P(5,2)*Metric(2,4)*Metric(3,6))/2. - (P(1,6)*P(5,2)*Metric(2,4)*Metric(3,6))/2. - P(1,5)*P(5,3)*Metric(2,4)*Metric(3,6) + P(1,6)*P(5,3)*Metric(2,4)*Metric(3,6) - P(1,3)*P(5,4)*Metric(2,4)*Metric(3,6) + (3*P(1,5)*P(5,4)*Metric(2,4)*Metric(3,6))/2. + (P(1,6)*P(5,4)*Metric(2,4)*Metric(3,6))/2. - (P(1,2)*P(5,6)*Metric(2,4)*Metric(3,6))/2. + (P(1,3)*P(5,6)*Metric(2,4)*Metric(3,6))/2. + (P(1,5)*P(5,6)*Metric(2,4)*Metric(3,6))/2. - P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,4)*Metric(3,6) - (P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) - (3*P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - (P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + P(1,2)*P(4,1)*Metric(2,5)*Metric(3,6) - (P(1,3)*P(4,1)*Metric(2,5)*Metric(3,6))/2. - (P(1,5)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6))/2. - (P(1,3)*P(4,2)*Metric(2,5)*Metric(3,6))/2. - (P(1,4)*P(4,2)*Metric(2,5)*Metric(3,6))/2. + (P(1,5)*P(4,2)*Metric(2,5)*Metric(3,6))/2. + (P(1,6)*P(4,2)*Metric(2,5)*Metric(3,6))/2. - (P(1,2)*P(4,3)*Metric(2,5)*Metric(3,6))/2. + (P(1,4)*P(4,3)*Metric(2,5)*Metric(3,6))/2. + (P(1,6)*P(4,3)*Metric(2,5)*Metric(3,6))/2. + (P(1,3)*P(4,5)*Metric(2,5)*Metric(3,6))/2. + (3*P(1,4)*P(4,5)*Metric(2,5)*Metric(3,6))/2. - P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) + P(1,3)*P(4,6)*Metric(2,5)*Metric(3,6) - P(1,4)*P(4,6)*Metric(2,5)*Metric(3,6) - P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,5)*Metric(3,6) + (P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) - (3*P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - (P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - P(3,2)*P(6,1)*Metric(1,2)*Metric(4,5) + (P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5))/2. - P(3,1)*P(6,2)*Metric(1,2)*Metric(4,5) + (P(3,4)*P(6,2)*Metric(1,2)*Metric(4,5))/2. - P(3,4)*P(6,3)*Metric(1,2)*Metric(4,5) + 2*P(3,5)*P(6,3)*Metric(1,2)*Metric(4,5) - 2*P(3,5)*P(6,4)*Metric(1,2)*Metric(4,5) + 2*P(3,6)*P(6,4)*Metric(1,2)*Metric(4,5) + (P(3,1)*P(6,5)*Metric(1,2)*Metric(4,5))/2. + (P(3,2)*P(6,5)*Metric(1,2)*Metric(4,5))/2. - P(3,4)*P(6,5)*Metric(1,2)*Metric(4,5) - P(3,6)*P(6,5)*Metric(1,2)*Metric(4,5) + (P(2,3)*P(6,1)*Metric(1,3)*Metric(4,5))/2. + (P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5))/2. - (P(2,5)*P(6,1)*Metric(1,3)*Metric(4,5))/2. - (P(2,6)*P(6,1)*Metric(1,3)*Metric(4,5))/2. + P(2,1)*P(6,2)*Metric(1,3)*Metric(4,5) - (P(2,3)*P(6,2)*Metric(1,3)*Metric(4,5))/2. + (P(2,4)*P(6,2)*Metric(1,3)*Metric(4,5))/2. - (P(2,5)*P(6,2)*Metric(1,3)*Metric(4,5))/2. - P(2,4)*P(6,3)*Metric(1,3)*Metric(4,5) + (P(2,5)*P(6,3)*Metric(1,3)*Metric(4,5))/2. + (3*P(2,6)*P(6,3)*Metric(1,3)*Metric(4,5))/2. + P(2,5)*P(6,4)*Metric(1,3)*Metric(4,5) - P(2,6)*P(6,4)*Metric(1,3)*Metric(4,5) - (P(2,1)*P(6,5)*Metric(1,3)*Metric(4,5))/2. + (P(2,4)*P(6,5)*Metric(1,3)*Metric(4,5))/2. + (P(2,6)*P(6,5)*Metric(1,3)*Metric(4,5))/2. - (P(2,3)*P(3,1)*Metric(1,6)*Metric(4,5))/2. - (P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5))/2. + (P(2,5)*P(3,1)*Metric(1,6)*Metric(4,5))/2. + (P(2,6)*P(3,1)*Metric(1,6)*Metric(4,5))/2. + P(2,1)*P(3,2)*Metric(1,6)*Metric(4,5) - (P(2,4)*P(3,2)*Metric(1,6)*Metric(4,5))/2. + (P(2,5)*P(3,2)*Metric(1,6)*Metric(4,5))/2. - (P(2,6)*P(3,2)*Metric(1,6)*Metric(4,5))/2. - (P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5))/2. + (P(2,3)*P(3,4)*Metric(1,6)*Metric(4,5))/2. + (P(2,5)*P(3,4)*Metric(1,6)*Metric(4,5))/2. - P(2,3)*P(3,5)*Metric(1,6)*Metric(4,5) + P(2,4)*P(3,5)*Metric(1,6)*Metric(4,5) + (3*P(2,3)*P(3,6)*Metric(1,6)*Metric(4,5))/2. + (P(2,4)*P(3,6)*Metric(1,6)*Metric(4,5))/2. - P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) + P(1,2)*P(6,1)*Metric(2,3)*Metric(4,5) - (P(1,3)*P(6,1)*Metric(2,3)*Metric(4,5))/2. + (P(1,4)*P(6,1)*Metric(2,3)*Metric(4,5))/2. - (P(1,5)*P(6,1)*Metric(2,3)*Metric(4,5))/2. + (P(1,3)*P(6,2)*Metric(2,3)*Metric(4,5))/2. + (P(1,4)*P(6,2)*Metric(2,3)*Metric(4,5))/2. - (P(1,5)*P(6,2)*Metric(2,3)*Metric(4,5))/2. - (P(1,6)*P(6,2)*Metric(2,3)*Metric(4,5))/2. - P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5) + (P(1,5)*P(6,3)*Metric(2,3)*Metric(4,5))/2. + (3*P(1,6)*P(6,3)*Metric(2,3)*Metric(4,5))/2. + P(1,5)*P(6,4)*Metric(2,3)*Metric(4,5) - P(1,6)*P(6,4)*Metric(2,3)*Metric(4,5) - (P(1,2)*P(6,5)*Metric(2,3)*Metric(4,5))/2. + (P(1,4)*P(6,5)*Metric(2,3)*Metric(4,5))/2. + (P(1,6)*P(6,5)*Metric(2,3)*Metric(4,5))/2. - P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,3)*Metric(4,5) + (P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + (P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (3*P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - (P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + P(1,2)*P(3,1)*Metric(2,6)*Metric(4,5) - (P(1,4)*P(3,1)*Metric(2,6)*Metric(4,5))/2. + (P(1,5)*P(3,1)*Metric(2,6)*Metric(4,5))/2. - (P(1,6)*P(3,1)*Metric(2,6)*Metric(4,5))/2. - (P(1,3)*P(3,2)*Metric(2,6)*Metric(4,5))/2. - (P(1,4)*P(3,2)*Metric(2,6)*Metric(4,5))/2. + (P(1,5)*P(3,2)*Metric(2,6)*Metric(4,5))/2. + (P(1,6)*P(3,2)*Metric(2,6)*Metric(4,5))/2. - (P(1,2)*P(3,4)*Metric(2,6)*Metric(4,5))/2. + (P(1,3)*P(3,4)*Metric(2,6)*Metric(4,5))/2. + (P(1,5)*P(3,4)*Metric(2,6)*Metric(4,5))/2. - P(1,3)*P(3,5)*Metric(2,6)*Metric(4,5) + P(1,4)*P(3,5)*Metric(2,6)*Metric(4,5) + (3*P(1,3)*P(3,6)*Metric(2,6)*Metric(4,5))/2. + (P(1,4)*P(3,6)*Metric(2,6)*Metric(4,5))/2. - P(1,5)*P(3,6)*Metric(2,6)*Metric(4,5) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,6)*Metric(4,5) + (P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) + (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (3*P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - (P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5) - (P(1,5)*P(2,3)*Metric(3,6)*Metric(4,5))/2. - (3*P(1,6)*P(2,3)*Metric(3,6)*Metric(4,5))/2. + P(1,3)*P(2,4)*Metric(3,6)*Metric(4,5) - (3*P(1,5)*P(2,4)*Metric(3,6)*Metric(4,5))/2. - (P(1,6)*P(2,4)*Metric(3,6)*Metric(4,5))/2. - (P(1,3)*P(2,5)*Metric(3,6)*Metric(4,5))/2. - (3*P(1,4)*P(2,5)*Metric(3,6)*Metric(4,5))/2. + P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) - (3*P(1,3)*P(2,6)*Metric(3,6)*Metric(4,5))/2. - (P(1,4)*P(2,6)*Metric(3,6)*Metric(4,5))/2. + P(1,5)*P(2,6)*Metric(3,6)*Metric(4,5) + P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(3,2)*P(5,1)*Metric(1,2)*Metric(4,6) + (P(3,4)*P(5,1)*Metric(1,2)*Metric(4,6))/2. - P(3,1)*P(5,2)*Metric(1,2)*Metric(4,6) + (P(3,4)*P(5,2)*Metric(1,2)*Metric(4,6))/2. - P(3,4)*P(5,3)*Metric(1,2)*Metric(4,6) + 2*P(3,6)*P(5,3)*Metric(1,2)*Metric(4,6) + 2*P(3,5)*P(5,4)*Metric(1,2)*Metric(4,6) - 2*P(3,6)*P(5,4)*Metric(1,2)*Metric(4,6) + (P(3,1)*P(5,6)*Metric(1,2)*Metric(4,6))/2. + (P(3,2)*P(5,6)*Metric(1,2)*Metric(4,6))/2. - P(3,4)*P(5,6)*Metric(1,2)*Metric(4,6) - P(3,5)*P(5,6)*Metric(1,2)*Metric(4,6) + (P(2,3)*P(5,1)*Metric(1,3)*Metric(4,6))/2. + (P(2,4)*P(5,1)*Metric(1,3)*Metric(4,6))/2. - (P(2,5)*P(5,1)*Metric(1,3)*Metric(4,6))/2. - (P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6))/2. + P(2,1)*P(5,2)*Metric(1,3)*Metric(4,6) - (P(2,3)*P(5,2)*Metric(1,3)*Metric(4,6))/2. + (P(2,4)*P(5,2)*Metric(1,3)*Metric(4,6))/2. - (P(2,6)*P(5,2)*Metric(1,3)*Metric(4,6))/2. - P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) + (3*P(2,5)*P(5,3)*Metric(1,3)*Metric(4,6))/2. + (P(2,6)*P(5,3)*Metric(1,3)*Metric(4,6))/2. - P(2,5)*P(5,4)*Metric(1,3)*Metric(4,6) + P(2,6)*P(5,4)*Metric(1,3)*Metric(4,6) - (P(2,1)*P(5,6)*Metric(1,3)*Metric(4,6))/2. + (P(2,4)*P(5,6)*Metric(1,3)*Metric(4,6))/2. + (P(2,5)*P(5,6)*Metric(1,3)*Metric(4,6))/2. - (P(2,3)*P(3,1)*Metric(1,5)*Metric(4,6))/2. - (P(2,4)*P(3,1)*Metric(1,5)*Metric(4,6))/2. + (P(2,5)*P(3,1)*Metric(1,5)*Metric(4,6))/2. + (P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6))/2. + P(2,1)*P(3,2)*Metric(1,5)*Metric(4,6) - (P(2,4)*P(3,2)*Metric(1,5)*Metric(4,6))/2. - (P(2,5)*P(3,2)*Metric(1,5)*Metric(4,6))/2. + (P(2,6)*P(3,2)*Metric(1,5)*Metric(4,6))/2. - (P(2,1)*P(3,4)*Metric(1,5)*Metric(4,6))/2. + (P(2,3)*P(3,4)*Metric(1,5)*Metric(4,6))/2. + (P(2,6)*P(3,4)*Metric(1,5)*Metric(4,6))/2. + (3*P(2,3)*P(3,5)*Metric(1,5)*Metric(4,6))/2. + (P(2,4)*P(3,5)*Metric(1,5)*Metric(4,6))/2. - P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) - P(2,3)*P(3,6)*Metric(1,5)*Metric(4,6) + P(2,4)*P(3,6)*Metric(1,5)*Metric(4,6) + P(1,2)*P(5,1)*Metric(2,3)*Metric(4,6) - (P(1,3)*P(5,1)*Metric(2,3)*Metric(4,6))/2. + (P(1,4)*P(5,1)*Metric(2,3)*Metric(4,6))/2. - (P(1,6)*P(5,1)*Metric(2,3)*Metric(4,6))/2. + (P(1,3)*P(5,2)*Metric(2,3)*Metric(4,6))/2. + (P(1,4)*P(5,2)*Metric(2,3)*Metric(4,6))/2. - (P(1,5)*P(5,2)*Metric(2,3)*Metric(4,6))/2. - (P(1,6)*P(5,2)*Metric(2,3)*Metric(4,6))/2. - P(1,4)*P(5,3)*Metric(2,3)*Metric(4,6) + (3*P(1,5)*P(5,3)*Metric(2,3)*Metric(4,6))/2. + (P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6))/2. - P(1,5)*P(5,4)*Metric(2,3)*Metric(4,6) + P(1,6)*P(5,4)*Metric(2,3)*Metric(4,6) - (P(1,2)*P(5,6)*Metric(2,3)*Metric(4,6))/2. + (P(1,4)*P(5,6)*Metric(2,3)*Metric(4,6))/2. + (P(1,5)*P(5,6)*Metric(2,3)*Metric(4,6))/2. - P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,3)*Metric(4,6) + (P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (3*P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) + (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - (P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + P(1,2)*P(3,1)*Metric(2,5)*Metric(4,6) - (P(1,4)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - (P(1,5)*P(3,1)*Metric(2,5)*Metric(4,6))/2. + (P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - (P(1,3)*P(3,2)*Metric(2,5)*Metric(4,6))/2. - (P(1,4)*P(3,2)*Metric(2,5)*Metric(4,6))/2. + (P(1,5)*P(3,2)*Metric(2,5)*Metric(4,6))/2. + (P(1,6)*P(3,2)*Metric(2,5)*Metric(4,6))/2. - (P(1,2)*P(3,4)*Metric(2,5)*Metric(4,6))/2. + (P(1,3)*P(3,4)*Metric(2,5)*Metric(4,6))/2. + (P(1,6)*P(3,4)*Metric(2,5)*Metric(4,6))/2. + (3*P(1,3)*P(3,5)*Metric(2,5)*Metric(4,6))/2. + (P(1,4)*P(3,5)*Metric(2,5)*Metric(4,6))/2. - P(1,6)*P(3,5)*Metric(2,5)*Metric(4,6) - P(1,3)*P(3,6)*Metric(2,5)*Metric(4,6) + P(1,4)*P(3,6)*Metric(2,5)*Metric(4,6) - P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,5)*Metric(4,6) + (P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (3*P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) - (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - (P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(1,4)*P(2,3)*Metric(3,5)*Metric(4,6) - (3*P(1,5)*P(2,3)*Metric(3,5)*Metric(4,6))/2. - (P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6))/2. + P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6) - (P(1,5)*P(2,4)*Metric(3,5)*Metric(4,6))/2. - (3*P(1,6)*P(2,4)*Metric(3,5)*Metric(4,6))/2. - (3*P(1,3)*P(2,5)*Metric(3,5)*Metric(4,6))/2. - (P(1,4)*P(2,5)*Metric(3,5)*Metric(4,6))/2. + P(1,6)*P(2,5)*Metric(3,5)*Metric(4,6) - (P(1,3)*P(2,6)*Metric(3,5)*Metric(4,6))/2. - (3*P(1,4)*P(2,6)*Metric(3,5)*Metric(4,6))/2. + P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6) + P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(3,2)*P(4,1)*Metric(1,2)*Metric(5,6) - (P(3,5)*P(4,1)*Metric(1,2)*Metric(5,6))/2. - (P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6))/2. + 2*P(3,1)*P(4,2)*Metric(1,2)*Metric(5,6) - (P(3,5)*P(4,2)*Metric(1,2)*Metric(5,6))/2. - (P(3,6)*P(4,2)*Metric(1,2)*Metric(5,6))/2. + P(3,5)*P(4,3)*Metric(1,2)*Metric(5,6) + P(3,6)*P(4,3)*Metric(1,2)*Metric(5,6) - (P(3,1)*P(4,5)*Metric(1,2)*Metric(5,6))/2. - (P(3,2)*P(4,5)*Metric(1,2)*Metric(5,6))/2. + P(3,4)*P(4,5)*Metric(1,2)*Metric(5,6) + P(3,6)*P(4,5)*Metric(1,2)*Metric(5,6) - (P(3,1)*P(4,6)*Metric(1,2)*Metric(5,6))/2. - (P(3,2)*P(4,6)*Metric(1,2)*Metric(5,6))/2. + P(3,4)*P(4,6)*Metric(1,2)*Metric(5,6) + P(3,5)*P(4,6)*Metric(1,2)*Metric(5,6) - P(2,3)*P(4,1)*Metric(1,3)*Metric(5,6) + P(2,4)*P(4,1)*Metric(1,3)*Metric(5,6) - 2*P(2,1)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,3)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,4)*P(4,3)*Metric(1,3)*Metric(5,6) + (P(2,5)*P(4,3)*Metric(1,3)*Metric(5,6))/2. + (P(2,6)*P(4,3)*Metric(1,3)*Metric(5,6))/2. + (P(2,1)*P(4,5)*Metric(1,3)*Metric(5,6))/2. - (P(2,4)*P(4,5)*Metric(1,3)*Metric(5,6))/2. - (P(2,6)*P(4,5)*Metric(1,3)*Metric(5,6))/2. + (P(2,1)*P(4,6)*Metric(1,3)*Metric(5,6))/2. - (P(2,4)*P(4,6)*Metric(1,3)*Metric(5,6))/2. - (P(2,5)*P(4,6)*Metric(1,3)*Metric(5,6))/2. + P(2,3)*P(3,1)*Metric(1,4)*Metric(5,6) - P(2,4)*P(3,1)*Metric(1,4)*Metric(5,6) - 2*P(2,1)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,4)*P(3,2)*Metric(1,4)*Metric(5,6) - P(2,3)*P(3,4)*Metric(1,4)*Metric(5,6) + (P(2,5)*P(3,4)*Metric(1,4)*Metric(5,6))/2. + (P(2,6)*P(3,4)*Metric(1,4)*Metric(5,6))/2. + (P(2,1)*P(3,5)*Metric(1,4)*Metric(5,6))/2. - (P(2,3)*P(3,5)*Metric(1,4)*Metric(5,6))/2. - (P(2,6)*P(3,5)*Metric(1,4)*Metric(5,6))/2. + (P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6))/2. - (P(2,3)*P(3,6)*Metric(1,4)*Metric(5,6))/2. - (P(2,5)*P(3,6)*Metric(1,4)*Metric(5,6))/2. - 2*P(1,2)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,3)*P(4,1)*Metric(2,3)*Metric(5,6) - P(1,3)*P(4,2)*Metric(2,3)*Metric(5,6) + P(1,4)*P(4,2)*Metric(2,3)*Metric(5,6) - P(1,4)*P(4,3)*Metric(2,3)*Metric(5,6) + (P(1,5)*P(4,3)*Metric(2,3)*Metric(5,6))/2. + (P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6))/2. + (P(1,2)*P(4,5)*Metric(2,3)*Metric(5,6))/2. - (P(1,4)*P(4,5)*Metric(2,3)*Metric(5,6))/2. - (P(1,6)*P(4,5)*Metric(2,3)*Metric(5,6))/2. + (P(1,2)*P(4,6)*Metric(2,3)*Metric(5,6))/2. - (P(1,4)*P(4,6)*Metric(2,3)*Metric(5,6))/2. - (P(1,5)*P(4,6)*Metric(2,3)*Metric(5,6))/2. + 2*P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) + (P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6))/2. + (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6))/2. + (P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6))/2. + (P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6))/2. - 2*P(1,2)*P(3,1)*Metric(2,4)*Metric(5,6) + P(1,4)*P(3,1)*Metric(2,4)*Metric(5,6) + P(1,3)*P(3,2)*Metric(2,4)*Metric(5,6) - P(1,4)*P(3,2)*Metric(2,4)*Metric(5,6) - P(1,3)*P(3,4)*Metric(2,4)*Metric(5,6) + (P(1,5)*P(3,4)*Metric(2,4)*Metric(5,6))/2. + (P(1,6)*P(3,4)*Metric(2,4)*Metric(5,6))/2. + (P(1,2)*P(3,5)*Metric(2,4)*Metric(5,6))/2. - (P(1,3)*P(3,5)*Metric(2,4)*Metric(5,6))/2. - (P(1,6)*P(3,5)*Metric(2,4)*Metric(5,6))/2. + (P(1,2)*P(3,6)*Metric(2,4)*Metric(5,6))/2. - (P(1,3)*P(3,6)*Metric(2,4)*Metric(5,6))/2. - (P(1,5)*P(3,6)*Metric(2,4)*Metric(5,6))/2. + 2*P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + (P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + (P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + (P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + P(1,4)*P(2,3)*Metric(3,4)*Metric(5,6) - (P(1,5)*P(2,3)*Metric(3,4)*Metric(5,6))/2. - (P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6))/2. + P(1,3)*P(2,4)*Metric(3,4)*Metric(5,6) - (P(1,5)*P(2,4)*Metric(3,4)*Metric(5,6))/2. - (P(1,6)*P(2,4)*Metric(3,4)*Metric(5,6))/2. - (P(1,3)*P(2,5)*Metric(3,4)*Metric(5,6))/2. - (P(1,4)*P(2,5)*Metric(3,4)*Metric(5,6))/2. + P(1,6)*P(2,5)*Metric(3,4)*Metric(5,6) - (P(1,3)*P(2,6)*Metric(3,4)*Metric(5,6))/2. - (P(1,4)*P(2,6)*Metric(3,4)*Metric(5,6))/2. + P(1,5)*P(2,6)*Metric(3,4)*Metric(5,6) - P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) - P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) - P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) - P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV57 = Lorentz(name = 'VVVVVV57',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,4)*P(6,1)*Metric(1,4)*Metric(2,3) - P(5,6)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,4)*Metric(1,4)*Metric(2,3) - P(5,6)*P(6,4)*Metric(1,4)*Metric(2,3) - P(5,1)*P(6,5)*Metric(1,4)*Metric(2,3) - P(5,4)*P(6,5)*Metric(1,4)*Metric(2,3) + P(4,5)*P(6,1)*Metric(1,5)*Metric(2,3) - P(4,6)*P(6,1)*Metric(1,5)*Metric(2,3) - P(4,1)*P(6,4)*Metric(1,5)*Metric(2,3) - P(4,5)*P(6,4)*Metric(1,5)*Metric(2,3) + P(4,1)*P(6,5)*Metric(1,5)*Metric(2,3) - P(4,6)*P(6,5)*Metric(1,5)*Metric(2,3) - P(4,5)*P(5,1)*Metric(1,6)*Metric(2,3) + P(4,6)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,4)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,4)*Metric(1,6)*Metric(2,3) + P(4,1)*P(5,6)*Metric(1,6)*Metric(2,3) - P(4,5)*P(5,6)*Metric(1,6)*Metric(2,3) + (P(5,6)*P(6,1)*Metric(1,3)*Metric(2,4))/2. + (P(5,6)*P(6,4)*Metric(1,3)*Metric(2,4))/2. + (P(5,1)*P(6,5)*Metric(1,3)*Metric(2,4))/2. + (P(5,4)*P(6,5)*Metric(1,3)*Metric(2,4))/2. - (P(3,5)*P(6,1)*Metric(1,5)*Metric(2,4))/2. + (P(3,6)*P(6,1)*Metric(1,5)*Metric(2,4))/2. - P(3,6)*P(6,4)*Metric(1,5)*Metric(2,4) - (P(3,1)*P(6,5)*Metric(1,5)*Metric(2,4))/2. + (P(3,6)*P(6,5)*Metric(1,5)*Metric(2,4))/2. + (P(3,5)*P(5,1)*Metric(1,6)*Metric(2,4))/2. - (P(3,6)*P(5,1)*Metric(1,6)*Metric(2,4))/2. - P(3,5)*P(5,4)*Metric(1,6)*Metric(2,4) - (P(3,1)*P(5,6)*Metric(1,6)*Metric(2,4))/2. + (P(3,5)*P(5,6)*Metric(1,6)*Metric(2,4))/2. + (P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5))/2. + (P(4,1)*P(6,4)*Metric(1,3)*Metric(2,5))/2. + (P(4,5)*P(6,4)*Metric(1,3)*Metric(2,5))/2. + (P(4,6)*P(6,5)*Metric(1,3)*Metric(2,5))/2. - (P(3,4)*P(6,1)*Metric(1,4)*Metric(2,5))/2. + (P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5))/2. - (P(3,1)*P(6,4)*Metric(1,4)*Metric(2,5))/2. + (P(3,6)*P(6,4)*Metric(1,4)*Metric(2,5))/2. - P(3,6)*P(6,5)*Metric(1,4)*Metric(2,5) + (P(3,4)*P(4,1)*Metric(1,6)*Metric(2,5))/2. - (P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5))/2. - P(3,4)*P(4,5)*Metric(1,6)*Metric(2,5) - (P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5))/2. + (P(3,4)*P(4,6)*Metric(1,6)*Metric(2,5))/2. + (P(4,5)*P(5,1)*Metric(1,3)*Metric(2,6))/2. + (P(4,1)*P(5,4)*Metric(1,3)*Metric(2,6))/2. + (P(4,6)*P(5,4)*Metric(1,3)*Metric(2,6))/2. + (P(4,5)*P(5,6)*Metric(1,3)*Metric(2,6))/2. - (P(3,4)*P(5,1)*Metric(1,4)*Metric(2,6))/2. + (P(3,5)*P(5,1)*Metric(1,4)*Metric(2,6))/2. - (P(3,1)*P(5,4)*Metric(1,4)*Metric(2,6))/2. + (P(3,5)*P(5,4)*Metric(1,4)*Metric(2,6))/2. - P(3,5)*P(5,6)*Metric(1,4)*Metric(2,6) + (P(3,4)*P(4,1)*Metric(1,5)*Metric(2,6))/2. - (P(3,5)*P(4,1)*Metric(1,5)*Metric(2,6))/2. - (P(3,1)*P(4,5)*Metric(1,5)*Metric(2,6))/2. + (P(3,4)*P(4,5)*Metric(1,5)*Metric(2,6))/2. - P(3,4)*P(4,6)*Metric(1,5)*Metric(2,6) + (P(5,6)*P(6,1)*Metric(1,2)*Metric(3,4))/2. + (P(5,6)*P(6,4)*Metric(1,2)*Metric(3,4))/2. + (P(5,1)*P(6,5)*Metric(1,2)*Metric(3,4))/2. + (P(5,4)*P(6,5)*Metric(1,2)*Metric(3,4))/2. - (P(2,5)*P(6,1)*Metric(1,5)*Metric(3,4))/2. + (P(2,6)*P(6,1)*Metric(1,5)*Metric(3,4))/2. - P(2,6)*P(6,4)*Metric(1,5)*Metric(3,4) - (P(2,1)*P(6,5)*Metric(1,5)*Metric(3,4))/2. + (P(2,6)*P(6,5)*Metric(1,5)*Metric(3,4))/2. + (P(2,5)*P(5,1)*Metric(1,6)*Metric(3,4))/2. - (P(2,6)*P(5,1)*Metric(1,6)*Metric(3,4))/2. - P(2,5)*P(5,4)*Metric(1,6)*Metric(3,4) - (P(2,1)*P(5,6)*Metric(1,6)*Metric(3,4))/2. + (P(2,5)*P(5,6)*Metric(1,6)*Metric(3,4))/2. + (P(1,4)*P(6,1)*Metric(2,5)*Metric(3,4))/2. + (P(1,5)*P(6,1)*Metric(2,5)*Metric(3,4))/2. + (P(1,6)*P(6,4)*Metric(2,5)*Metric(3,4))/2. + (P(1,6)*P(6,5)*Metric(2,5)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. + P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - (P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. + (P(1,4)*P(5,1)*Metric(2,6)*Metric(3,4))/2. + (P(1,6)*P(5,1)*Metric(2,6)*Metric(3,4))/2. + (P(1,5)*P(5,4)*Metric(2,6)*Metric(3,4))/2. + (P(1,5)*P(5,6)*Metric(2,6)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - (P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(4,6)*P(6,1)*Metric(1,2)*Metric(3,5))/2. + (P(4,1)*P(6,4)*Metric(1,2)*Metric(3,5))/2. + (P(4,5)*P(6,4)*Metric(1,2)*Metric(3,5))/2. + (P(4,6)*P(6,5)*Metric(1,2)*Metric(3,5))/2. - (P(2,4)*P(6,1)*Metric(1,4)*Metric(3,5))/2. + (P(2,6)*P(6,1)*Metric(1,4)*Metric(3,5))/2. - (P(2,1)*P(6,4)*Metric(1,4)*Metric(3,5))/2. + (P(2,6)*P(6,4)*Metric(1,4)*Metric(3,5))/2. - P(2,6)*P(6,5)*Metric(1,4)*Metric(3,5) + (P(2,4)*P(4,1)*Metric(1,6)*Metric(3,5))/2. - (P(2,6)*P(4,1)*Metric(1,6)*Metric(3,5))/2. - P(2,4)*P(4,5)*Metric(1,6)*Metric(3,5) - (P(2,1)*P(4,6)*Metric(1,6)*Metric(3,5))/2. + (P(2,4)*P(4,6)*Metric(1,6)*Metric(3,5))/2. + (P(1,4)*P(6,1)*Metric(2,4)*Metric(3,5))/2. + (P(1,5)*P(6,1)*Metric(2,4)*Metric(3,5))/2. + (P(1,6)*P(6,4)*Metric(2,4)*Metric(3,5))/2. + (P(1,6)*P(6,5)*Metric(2,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - (P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(1,5)*P(4,1)*Metric(2,6)*Metric(3,5))/2. + (P(1,6)*P(4,1)*Metric(2,6)*Metric(3,5))/2. + (P(1,4)*P(4,5)*Metric(2,6)*Metric(3,5))/2. + (P(1,4)*P(4,6)*Metric(2,6)*Metric(3,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + (P(4,5)*P(5,1)*Metric(1,2)*Metric(3,6))/2. + (P(4,1)*P(5,4)*Metric(1,2)*Metric(3,6))/2. + (P(4,6)*P(5,4)*Metric(1,2)*Metric(3,6))/2. + (P(4,5)*P(5,6)*Metric(1,2)*Metric(3,6))/2. - (P(2,4)*P(5,1)*Metric(1,4)*Metric(3,6))/2. + (P(2,5)*P(5,1)*Metric(1,4)*Metric(3,6))/2. - (P(2,1)*P(5,4)*Metric(1,4)*Metric(3,6))/2. + (P(2,5)*P(5,4)*Metric(1,4)*Metric(3,6))/2. - P(2,5)*P(5,6)*Metric(1,4)*Metric(3,6) + (P(2,4)*P(4,1)*Metric(1,5)*Metric(3,6))/2. - (P(2,5)*P(4,1)*Metric(1,5)*Metric(3,6))/2. - (P(2,1)*P(4,5)*Metric(1,5)*Metric(3,6))/2. + (P(2,4)*P(4,5)*Metric(1,5)*Metric(3,6))/2. - P(2,4)*P(4,6)*Metric(1,5)*Metric(3,6) + (P(1,4)*P(5,1)*Metric(2,4)*Metric(3,6))/2. + (P(1,6)*P(5,1)*Metric(2,4)*Metric(3,6))/2. + (P(1,5)*P(5,4)*Metric(2,4)*Metric(3,6))/2. + (P(1,5)*P(5,6)*Metric(2,4)*Metric(3,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - (P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(1,5)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(1,4)*P(4,5)*Metric(2,5)*Metric(3,6))/2. + (P(1,4)*P(4,6)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(3,6)*P(6,1)*Metric(1,2)*Metric(4,5) - (P(3,5)*P(6,4)*Metric(1,2)*Metric(4,5))/2. + (P(3,6)*P(6,4)*Metric(1,2)*Metric(4,5))/2. - (P(3,4)*P(6,5)*Metric(1,2)*Metric(4,5))/2. + (P(3,6)*P(6,5)*Metric(1,2)*Metric(4,5))/2. - P(2,6)*P(6,1)*Metric(1,3)*Metric(4,5) - (P(2,5)*P(6,4)*Metric(1,3)*Metric(4,5))/2. + (P(2,6)*P(6,4)*Metric(1,3)*Metric(4,5))/2. - (P(2,4)*P(6,5)*Metric(1,3)*Metric(4,5))/2. + (P(2,6)*P(6,5)*Metric(1,3)*Metric(4,5))/2. + P(2,6)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,5)*P(3,4)*Metric(1,6)*Metric(4,5) + P(2,4)*P(3,5)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,6)*Metric(1,6)*Metric(4,5) - P(1,4)*P(6,1)*Metric(2,3)*Metric(4,5) - P(1,5)*P(6,1)*Metric(2,3)*Metric(4,5) + P(1,5)*P(6,4)*Metric(2,3)*Metric(4,5) - P(1,6)*P(6,4)*Metric(2,3)*Metric(4,5) + P(1,4)*P(6,5)*Metric(2,3)*Metric(4,5) - P(1,6)*P(6,5)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + (P(1,4)*P(3,1)*Metric(2,6)*Metric(4,5))/2. + (P(1,5)*P(3,1)*Metric(2,6)*Metric(4,5))/2. - P(1,6)*P(3,1)*Metric(2,6)*Metric(4,5) - (P(1,5)*P(3,4)*Metric(2,6)*Metric(4,5))/2. - (P(1,4)*P(3,5)*Metric(2,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - (P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(1,4)*P(2,1)*Metric(3,6)*Metric(4,5))/2. + (P(1,5)*P(2,1)*Metric(3,6)*Metric(4,5))/2. - P(1,6)*P(2,1)*Metric(3,6)*Metric(4,5) - (P(1,5)*P(2,4)*Metric(3,6)*Metric(4,5))/2. - (P(1,4)*P(2,5)*Metric(3,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - (P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. - (P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. - P(3,5)*P(5,1)*Metric(1,2)*Metric(4,6) + (P(3,5)*P(5,4)*Metric(1,2)*Metric(4,6))/2. - (P(3,6)*P(5,4)*Metric(1,2)*Metric(4,6))/2. - (P(3,4)*P(5,6)*Metric(1,2)*Metric(4,6))/2. + (P(3,5)*P(5,6)*Metric(1,2)*Metric(4,6))/2. - P(2,5)*P(5,1)*Metric(1,3)*Metric(4,6) + (P(2,5)*P(5,4)*Metric(1,3)*Metric(4,6))/2. - (P(2,6)*P(5,4)*Metric(1,3)*Metric(4,6))/2. - (P(2,4)*P(5,6)*Metric(1,3)*Metric(4,6))/2. + (P(2,5)*P(5,6)*Metric(1,3)*Metric(4,6))/2. + P(2,5)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,6)*P(3,4)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,5)*Metric(1,5)*Metric(4,6) + P(2,4)*P(3,6)*Metric(1,5)*Metric(4,6) - P(1,4)*P(5,1)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,1)*Metric(2,3)*Metric(4,6) - P(1,5)*P(5,4)*Metric(2,3)*Metric(4,6) + P(1,6)*P(5,4)*Metric(2,3)*Metric(4,6) + P(1,4)*P(5,6)*Metric(2,3)*Metric(4,6) - P(1,5)*P(5,6)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + (P(1,4)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - P(1,5)*P(3,1)*Metric(2,5)*Metric(4,6) + (P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - (P(1,6)*P(3,4)*Metric(2,5)*Metric(4,6))/2. - (P(1,4)*P(3,6)*Metric(2,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) - (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(1,4)*P(2,1)*Metric(3,5)*Metric(4,6))/2. - P(1,5)*P(2,1)*Metric(3,5)*Metric(4,6) + (P(1,6)*P(2,1)*Metric(3,5)*Metric(4,6))/2. - (P(1,6)*P(2,4)*Metric(3,5)*Metric(4,6))/2. - (P(1,4)*P(2,6)*Metric(3,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - (P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - P(3,4)*P(4,1)*Metric(1,2)*Metric(5,6) + (P(3,4)*P(4,5)*Metric(1,2)*Metric(5,6))/2. - (P(3,6)*P(4,5)*Metric(1,2)*Metric(5,6))/2. + (P(3,4)*P(4,6)*Metric(1,2)*Metric(5,6))/2. - (P(3,5)*P(4,6)*Metric(1,2)*Metric(5,6))/2. - P(2,4)*P(4,1)*Metric(1,3)*Metric(5,6) + (P(2,4)*P(4,5)*Metric(1,3)*Metric(5,6))/2. - (P(2,6)*P(4,5)*Metric(1,3)*Metric(5,6))/2. + (P(2,4)*P(4,6)*Metric(1,3)*Metric(5,6))/2. - (P(2,5)*P(4,6)*Metric(1,3)*Metric(5,6))/2. + P(2,4)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,5)*P(3,6)*Metric(1,4)*Metric(5,6) - P(1,5)*P(4,1)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,1)*Metric(2,3)*Metric(5,6) - P(1,4)*P(4,5)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,5)*Metric(2,3)*Metric(5,6) - P(1,4)*P(4,6)*Metric(2,3)*Metric(5,6) + P(1,5)*P(4,6)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(1,4)*P(3,1)*Metric(2,4)*Metric(5,6) + (P(1,5)*P(3,1)*Metric(2,4)*Metric(5,6))/2. + (P(1,6)*P(3,1)*Metric(2,4)*Metric(5,6))/2. - (P(1,6)*P(3,5)*Metric(2,4)*Metric(5,6))/2. - (P(1,5)*P(3,6)*Metric(2,4)*Metric(5,6))/2. + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - P(1,4)*P(2,1)*Metric(3,4)*Metric(5,6) + (P(1,5)*P(2,1)*Metric(3,4)*Metric(5,6))/2. + (P(1,6)*P(2,1)*Metric(3,4)*Metric(5,6))/2. - (P(1,6)*P(2,5)*Metric(3,4)*Metric(5,6))/2. - (P(1,5)*P(2,6)*Metric(3,4)*Metric(5,6))/2. + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) - (P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. - (P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. - (P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVV58 = Lorentz(name = 'VVVVVV58',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,6)*P(6,4)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,5)*Metric(1,4)*Metric(2,3) + P(4,5)*P(6,4)*Metric(1,5)*Metric(2,3) + P(4,6)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,6)*P(5,4)*Metric(1,6)*Metric(2,3) + P(4,5)*P(5,6)*Metric(1,6)*Metric(2,3) - (P(5,6)*P(6,4)*Metric(1,3)*Metric(2,4))/2. - (P(5,4)*P(6,5)*Metric(1,3)*Metric(2,4))/2. + P(3,6)*P(6,4)*Metric(1,5)*Metric(2,4) - (P(3,6)*P(6,5)*Metric(1,5)*Metric(2,4))/2. + P(3,5)*P(5,4)*Metric(1,6)*Metric(2,4) - (P(3,5)*P(5,6)*Metric(1,6)*Metric(2,4))/2. - (P(4,5)*P(6,4)*Metric(1,3)*Metric(2,5))/2. - (P(4,6)*P(6,5)*Metric(1,3)*Metric(2,5))/2. - (P(3,6)*P(6,4)*Metric(1,4)*Metric(2,5))/2. + P(3,6)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,4)*P(4,5)*Metric(1,6)*Metric(2,5) - (P(3,4)*P(4,6)*Metric(1,6)*Metric(2,5))/2. - (P(4,6)*P(5,4)*Metric(1,3)*Metric(2,6))/2. - (P(4,5)*P(5,6)*Metric(1,3)*Metric(2,6))/2. - (P(3,5)*P(5,4)*Metric(1,4)*Metric(2,6))/2. + P(3,5)*P(5,6)*Metric(1,4)*Metric(2,6) - (P(3,4)*P(4,5)*Metric(1,5)*Metric(2,6))/2. + P(3,4)*P(4,6)*Metric(1,5)*Metric(2,6) - (P(5,6)*P(6,4)*Metric(1,2)*Metric(3,4))/2. - (P(5,4)*P(6,5)*Metric(1,2)*Metric(3,4))/2. + P(2,6)*P(6,4)*Metric(1,5)*Metric(3,4) - (P(2,6)*P(6,5)*Metric(1,5)*Metric(3,4))/2. + P(2,5)*P(5,4)*Metric(1,6)*Metric(3,4) - (P(2,5)*P(5,6)*Metric(1,6)*Metric(3,4))/2. - (P(1,6)*P(6,4)*Metric(2,5)*Metric(3,4))/2. - (P(1,6)*P(6,5)*Metric(2,5)*Metric(3,4))/2. - P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + (P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. + (P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(1,5)*P(5,4)*Metric(2,6)*Metric(3,4))/2. - (P(1,5)*P(5,6)*Metric(2,6)*Metric(3,4))/2. + (P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + (P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(4,5)*P(6,4)*Metric(1,2)*Metric(3,5))/2. - (P(4,6)*P(6,5)*Metric(1,2)*Metric(3,5))/2. - (P(2,6)*P(6,4)*Metric(1,4)*Metric(3,5))/2. + P(2,6)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,4)*P(4,5)*Metric(1,6)*Metric(3,5) - (P(2,4)*P(4,6)*Metric(1,6)*Metric(3,5))/2. - (P(1,6)*P(6,4)*Metric(2,4)*Metric(3,5))/2. - (P(1,6)*P(6,5)*Metric(2,4)*Metric(3,5))/2. - P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + (P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(1,4)*P(4,5)*Metric(2,6)*Metric(3,5))/2. - (P(1,4)*P(4,6)*Metric(2,6)*Metric(3,5))/2. + (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - (P(4,6)*P(5,4)*Metric(1,2)*Metric(3,6))/2. - (P(4,5)*P(5,6)*Metric(1,2)*Metric(3,6))/2. - (P(2,5)*P(5,4)*Metric(1,4)*Metric(3,6))/2. + P(2,5)*P(5,6)*Metric(1,4)*Metric(3,6) - (P(2,4)*P(4,5)*Metric(1,5)*Metric(3,6))/2. + P(2,4)*P(4,6)*Metric(1,5)*Metric(3,6) - (P(1,5)*P(5,4)*Metric(2,4)*Metric(3,6))/2. - (P(1,5)*P(5,6)*Metric(2,4)*Metric(3,6))/2. + (P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + (P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(1,4)*P(4,5)*Metric(2,5)*Metric(3,6))/2. - (P(1,4)*P(4,6)*Metric(2,5)*Metric(3,6))/2. + (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + (P(3,5)*P(6,4)*Metric(1,2)*Metric(4,5))/2. - (P(3,6)*P(6,4)*Metric(1,2)*Metric(4,5))/2. + (P(3,4)*P(6,5)*Metric(1,2)*Metric(4,5))/2. - (P(3,6)*P(6,5)*Metric(1,2)*Metric(4,5))/2. + (P(2,5)*P(6,4)*Metric(1,3)*Metric(4,5))/2. - (P(2,6)*P(6,4)*Metric(1,3)*Metric(4,5))/2. + (P(2,4)*P(6,5)*Metric(1,3)*Metric(4,5))/2. - (P(2,6)*P(6,5)*Metric(1,3)*Metric(4,5))/2. - P(2,5)*P(3,4)*Metric(1,6)*Metric(4,5) - P(2,4)*P(3,5)*Metric(1,6)*Metric(4,5) - P(1,5)*P(6,4)*Metric(2,3)*Metric(4,5) + P(1,6)*P(6,4)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,5)*Metric(2,3)*Metric(4,5) + P(1,6)*P(6,5)*Metric(2,3)*Metric(4,5) - P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + (P(1,5)*P(3,4)*Metric(2,6)*Metric(4,5))/2. + (P(1,4)*P(3,5)*Metric(2,6)*Metric(4,5))/2. + (P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(1,5)*P(2,4)*Metric(3,6)*Metric(4,5))/2. + (P(1,4)*P(2,5)*Metric(3,6)*Metric(4,5))/2. + (P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + (P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. - (P(3,5)*P(5,4)*Metric(1,2)*Metric(4,6))/2. + (P(3,6)*P(5,4)*Metric(1,2)*Metric(4,6))/2. + (P(3,4)*P(5,6)*Metric(1,2)*Metric(4,6))/2. - (P(3,5)*P(5,6)*Metric(1,2)*Metric(4,6))/2. - (P(2,5)*P(5,4)*Metric(1,3)*Metric(4,6))/2. + (P(2,6)*P(5,4)*Metric(1,3)*Metric(4,6))/2. + (P(2,4)*P(5,6)*Metric(1,3)*Metric(4,6))/2. - (P(2,5)*P(5,6)*Metric(1,3)*Metric(4,6))/2. - P(2,6)*P(3,4)*Metric(1,5)*Metric(4,6) - P(2,4)*P(3,6)*Metric(1,5)*Metric(4,6) + P(1,5)*P(5,4)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,4)*Metric(2,3)*Metric(4,6) - P(1,4)*P(5,6)*Metric(2,3)*Metric(4,6) + P(1,5)*P(5,6)*Metric(2,3)*Metric(4,6) - P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + (P(1,6)*P(3,4)*Metric(2,5)*Metric(4,6))/2. + (P(1,4)*P(3,6)*Metric(2,5)*Metric(4,6))/2. + (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(1,6)*P(2,4)*Metric(3,5)*Metric(4,6))/2. + (P(1,4)*P(2,6)*Metric(3,5)*Metric(4,6))/2. + (P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + (P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(3,4)*P(4,5)*Metric(1,2)*Metric(5,6))/2. + (P(3,6)*P(4,5)*Metric(1,2)*Metric(5,6))/2. - (P(3,4)*P(4,6)*Metric(1,2)*Metric(5,6))/2. + (P(3,5)*P(4,6)*Metric(1,2)*Metric(5,6))/2. - (P(2,4)*P(4,5)*Metric(1,3)*Metric(5,6))/2. + (P(2,6)*P(4,5)*Metric(1,3)*Metric(5,6))/2. - (P(2,4)*P(4,6)*Metric(1,3)*Metric(5,6))/2. + (P(2,5)*P(4,6)*Metric(1,3)*Metric(5,6))/2. - P(2,6)*P(3,5)*Metric(1,4)*Metric(5,6) - P(2,5)*P(3,6)*Metric(1,4)*Metric(5,6) + P(1,4)*P(4,5)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,5)*Metric(2,3)*Metric(5,6) + P(1,4)*P(4,6)*Metric(2,3)*Metric(5,6) - P(1,5)*P(4,6)*Metric(2,3)*Metric(5,6) - P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + (P(1,6)*P(3,5)*Metric(2,4)*Metric(5,6))/2. + (P(1,5)*P(3,6)*Metric(2,4)*Metric(5,6))/2. + (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + (P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + (P(1,6)*P(2,5)*Metric(3,4)*Metric(5,6))/2. + (P(1,5)*P(2,6)*Metric(3,4)*Metric(5,6))/2. + (P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. + (P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVV59 = Lorentz(name = 'VVVVVV59',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,1)*Metric(1,4)*Metric(2,3) - 4*P(5,6)*P(6,1)*Metric(1,4)*Metric(2,3) - P(5,3)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,2)*Metric(1,4)*Metric(2,3) - P(5,2)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3) - 2*P(5,1)*P(6,4)*Metric(1,4)*Metric(2,3) + 2*P(5,6)*P(6,4)*Metric(1,4)*Metric(2,3) + 2*P(5,1)*P(6,5)*Metric(1,4)*Metric(2,3) - P(5,2)*P(6,5)*Metric(1,4)*Metric(2,3) - P(5,3)*P(6,5)*Metric(1,4)*Metric(2,3) - 2*P(5,4)*P(6,5)*Metric(1,4)*Metric(2,3) + P(4,2)*P(6,1)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,1)*Metric(1,5)*Metric(2,3) - 4*P(4,6)*P(6,1)*Metric(1,5)*Metric(2,3) - P(4,3)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,5)*P(6,2)*Metric(1,5)*Metric(2,3) - P(4,2)*P(6,3)*Metric(1,5)*Metric(2,3) + P(4,5)*P(6,3)*Metric(1,5)*Metric(2,3) + 2*P(4,1)*P(6,4)*Metric(1,5)*Metric(2,3) - P(4,2)*P(6,4)*Metric(1,5)*Metric(2,3) - P(4,3)*P(6,4)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*P(6,4)*Metric(1,5)*Metric(2,3) - 2*P(4,1)*P(6,5)*Metric(1,5)*Metric(2,3) + 2*P(4,6)*P(6,5)*Metric(1,5)*Metric(2,3) - P(4,2)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,3)*P(5,1)*Metric(1,6)*Metric(2,3) + 4*P(4,6)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) + 2*P(4,3)*P(5,2)*Metric(1,6)*Metric(2,3) + 2*P(4,5)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,3)*Metric(1,6)*Metric(2,3) + 2*P(4,2)*P(5,3)*Metric(1,6)*Metric(2,3) + 2*P(4,5)*P(5,3)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3) + 2*P(4,2)*P(5,4)*Metric(1,6)*Metric(2,3) + 2*P(4,3)*P(5,4)*Metric(1,6)*Metric(2,3) + 4*P(4,1)*P(5,6)*Metric(1,6)*Metric(2,3) - P(4,2)*P(5,6)*Metric(1,6)*Metric(2,3) - P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3) - P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4) + 2*P(5,6)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) - 2*P(5,3)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,6)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,3)*Metric(1,3)*Metric(2,4) - P(5,6)*P(6,3)*Metric(1,3)*Metric(2,4) - P(5,1)*P(6,4)*Metric(1,3)*Metric(2,4) + 2*P(5,2)*P(6,4)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) - P(5,6)*P(6,4)*Metric(1,3)*Metric(2,4) - P(5,1)*P(6,5)*Metric(1,3)*Metric(2,4) - 2*P(5,2)*P(6,5)*Metric(1,3)*Metric(2,4) + 3*P(5,3)*P(6,5)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,5)*Metric(1,3)*Metric(2,4) - P(3,2)*P(6,1)*Metric(1,5)*Metric(2,4) + 2*P(3,6)*P(6,1)*Metric(1,5)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) + 2*P(3,4)*P(6,2)*Metric(1,5)*Metric(2,4) + P(3,5)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,6)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,1)*P(6,3)*Metric(1,5)*Metric(2,4) + P(3,2)*P(6,3)*Metric(1,5)*Metric(2,4) - 2*P(3,4)*P(6,3)*Metric(1,5)*Metric(2,4) + 3*P(3,5)*P(6,3)*Metric(1,5)*Metric(2,4) + P(3,1)*P(6,4)*Metric(1,5)*Metric(2,4) + P(3,2)*P(6,4)*Metric(1,5)*Metric(2,4) - 2*P(3,5)*P(6,4)*Metric(1,5)*Metric(2,4) + P(3,6)*P(6,4)*Metric(1,5)*Metric(2,4) + P(3,1)*P(6,5)*Metric(1,5)*Metric(2,4) - P(3,6)*P(6,5)*Metric(1,5)*Metric(2,4) + P(3,2)*P(5,1)*Metric(1,6)*Metric(2,4) - 2*P(3,6)*P(5,1)*Metric(1,6)*Metric(2,4) - 4*P(3,4)*P(5,2)*Metric(1,6)*Metric(2,4) + 4*P(3,5)*P(5,2)*Metric(1,6)*Metric(2,4) - 2*P(3,2)*P(5,3)*Metric(1,6)*Metric(2,4) + 4*P(3,4)*P(5,3)*Metric(1,6)*Metric(2,4) + P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4) - 2*P(3,2)*P(5,4)*Metric(1,6)*Metric(2,4) - 2*P(3,5)*P(5,4)*Metric(1,6)*Metric(2,4) + P(3,6)*P(5,4)*Metric(1,6)*Metric(2,4) - 2*P(3,1)*P(5,6)*Metric(1,6)*Metric(2,4) + P(3,2)*P(5,6)*Metric(1,6)*Metric(2,4) - P(4,5)*P(6,1)*Metric(1,3)*Metric(2,5) + 2*P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5) + P(4,1)*P(6,2)*Metric(1,3)*Metric(2,5) - 2*P(4,3)*P(6,2)*Metric(1,3)*Metric(2,5) + P(4,5)*P(6,2)*Metric(1,3)*Metric(2,5) + P(4,6)*P(6,2)*Metric(1,3)*Metric(2,5) + P(4,1)*P(6,3)*Metric(1,3)*Metric(2,5) - P(4,6)*P(6,3)*Metric(1,3)*Metric(2,5) - P(4,1)*P(6,4)*Metric(1,3)*Metric(2,5) - 2*P(4,2)*P(6,4)*Metric(1,3)*Metric(2,5) + 3*P(4,3)*P(6,4)*Metric(1,3)*Metric(2,5) + P(4,5)*P(6,4)*Metric(1,3)*Metric(2,5) - P(4,1)*P(6,5)*Metric(1,3)*Metric(2,5) + 2*P(4,2)*P(6,5)*Metric(1,3)*Metric(2,5) + P(4,3)*P(6,5)*Metric(1,3)*Metric(2,5) - P(4,6)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) + 2*P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,1)*P(6,2)*Metric(1,4)*Metric(2,5) + P(3,4)*P(6,2)*Metric(1,4)*Metric(2,5) + 2*P(3,5)*P(6,2)*Metric(1,4)*Metric(2,5) - P(3,6)*P(6,2)*Metric(1,4)*Metric(2,5) - P(3,1)*P(6,3)*Metric(1,4)*Metric(2,5) + P(3,2)*P(6,3)*Metric(1,4)*Metric(2,5) + 3*P(3,4)*P(6,3)*Metric(1,4)*Metric(2,5) - 2*P(3,5)*P(6,3)*Metric(1,4)*Metric(2,5) + P(3,1)*P(6,4)*Metric(1,4)*Metric(2,5) - P(3,6)*P(6,4)*Metric(1,4)*Metric(2,5) + P(3,1)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,2)*P(6,5)*Metric(1,4)*Metric(2,5) - 2*P(3,4)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,6)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) - 2*P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5) + 4*P(3,4)*P(4,2)*Metric(1,6)*Metric(2,5) - 4*P(3,5)*P(4,2)*Metric(1,6)*Metric(2,5) - 2*P(3,2)*P(4,3)*Metric(1,6)*Metric(2,5) + 4*P(3,5)*P(4,3)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,5)*Metric(1,6)*Metric(2,5) - 2*P(3,2)*P(4,5)*Metric(1,6)*Metric(2,5) - 2*P(3,4)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) - 2*P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5) + P(3,2)*P(4,6)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) - P(4,3)*P(5,1)*Metric(1,3)*Metric(2,6) + 2*P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) - P(4,1)*P(5,2)*Metric(1,3)*Metric(2,6) + 2*P(4,3)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,5)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,6)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,1)*P(5,3)*Metric(1,3)*Metric(2,6) + 2*P(4,2)*P(5,3)*Metric(1,3)*Metric(2,6) - P(4,5)*P(5,3)*Metric(1,3)*Metric(2,6) - P(4,6)*P(5,3)*Metric(1,3)*Metric(2,6) - P(4,2)*P(5,4)*Metric(1,3)*Metric(2,6) - P(4,3)*P(5,4)*Metric(1,3)*Metric(2,6) + 2*P(4,1)*P(5,6)*Metric(1,3)*Metric(2,6) - P(4,2)*P(5,6)*Metric(1,3)*Metric(2,6) - P(4,3)*P(5,6)*Metric(1,3)*Metric(2,6) + P(3,4)*P(5,1)*Metric(1,4)*Metric(2,6) - P(3,5)*P(5,1)*Metric(1,4)*Metric(2,6) + P(3,1)*P(5,2)*Metric(1,4)*Metric(2,6) - P(3,4)*P(5,2)*Metric(1,4)*Metric(2,6) - 2*P(3,5)*P(5,2)*Metric(1,4)*Metric(2,6) + P(3,6)*P(5,2)*Metric(1,4)*Metric(2,6) + P(3,1)*P(5,3)*Metric(1,4)*Metric(2,6) + P(3,2)*P(5,3)*Metric(1,4)*Metric(2,6) - 2*P(3,4)*P(5,3)*Metric(1,4)*Metric(2,6) - P(3,6)*P(5,3)*Metric(1,4)*Metric(2,6) - P(3,2)*P(5,4)*Metric(1,4)*Metric(2,6) + P(3,5)*P(5,4)*Metric(1,4)*Metric(2,6) - 2*P(3,1)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,4)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,5)*P(5,6)*Metric(1,4)*Metric(2,6) - P(3,4)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,5)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) - 2*P(3,4)*P(4,2)*Metric(1,5)*Metric(2,6) - P(3,5)*P(4,2)*Metric(1,5)*Metric(2,6) + P(3,6)*P(4,2)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,3)*Metric(1,5)*Metric(2,6) + P(3,2)*P(4,3)*Metric(1,5)*Metric(2,6) - 2*P(3,5)*P(4,3)*Metric(1,5)*Metric(2,6) - P(3,6)*P(4,3)*Metric(1,5)*Metric(2,6) - P(3,2)*P(4,5)*Metric(1,5)*Metric(2,6) + P(3,4)*P(4,5)*Metric(1,5)*Metric(2,6) - 2*P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) + P(3,4)*P(4,6)*Metric(1,5)*Metric(2,6) + P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) - P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4) + 2*P(5,6)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,2)*Metric(1,2)*Metric(3,4) - P(5,6)*P(6,2)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,3)*Metric(1,2)*Metric(3,4) - 2*P(5,2)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,4)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,6)*P(6,3)*Metric(1,2)*Metric(3,4) - P(5,1)*P(6,4)*Metric(1,2)*Metric(3,4) + P(5,2)*P(6,4)*Metric(1,2)*Metric(3,4) + 2*P(5,3)*P(6,4)*Metric(1,2)*Metric(3,4) - P(5,6)*P(6,4)*Metric(1,2)*Metric(3,4) - P(5,1)*P(6,5)*Metric(1,2)*Metric(3,4) + 3*P(5,2)*P(6,5)*Metric(1,2)*Metric(3,4) - 2*P(5,3)*P(6,5)*Metric(1,2)*Metric(3,4) + P(5,4)*P(6,5)*Metric(1,2)*Metric(3,4) - P(2,3)*P(6,1)*Metric(1,5)*Metric(3,4) + 2*P(2,6)*P(6,1)*Metric(1,5)*Metric(3,4) - P(2,1)*P(6,2)*Metric(1,5)*Metric(3,4) + P(2,3)*P(6,2)*Metric(1,5)*Metric(3,4) - 2*P(2,4)*P(6,2)*Metric(1,5)*Metric(3,4) + 3*P(2,5)*P(6,2)*Metric(1,5)*Metric(3,4) - P(2,1)*P(6,3)*Metric(1,5)*Metric(3,4) + 2*P(2,4)*P(6,3)*Metric(1,5)*Metric(3,4) + P(2,5)*P(6,3)*Metric(1,5)*Metric(3,4) - P(2,6)*P(6,3)*Metric(1,5)*Metric(3,4) + P(2,1)*P(6,4)*Metric(1,5)*Metric(3,4) + P(2,3)*P(6,4)*Metric(1,5)*Metric(3,4) - 2*P(2,5)*P(6,4)*Metric(1,5)*Metric(3,4) + P(2,6)*P(6,4)*Metric(1,5)*Metric(3,4) + P(2,1)*P(6,5)*Metric(1,5)*Metric(3,4) - P(2,6)*P(6,5)*Metric(1,5)*Metric(3,4) + P(2,3)*P(5,1)*Metric(1,6)*Metric(3,4) - 2*P(2,6)*P(5,1)*Metric(1,6)*Metric(3,4) - 2*P(2,3)*P(5,2)*Metric(1,6)*Metric(3,4) + 4*P(2,4)*P(5,2)*Metric(1,6)*Metric(3,4) - 4*P(2,4)*P(5,3)*Metric(1,6)*Metric(3,4) + 4*P(2,5)*P(5,3)*Metric(1,6)*Metric(3,4) + P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4) - 2*P(2,3)*P(5,4)*Metric(1,6)*Metric(3,4) - 2*P(2,5)*P(5,4)*Metric(1,6)*Metric(3,4) + P(2,6)*P(5,4)*Metric(1,6)*Metric(3,4) - 2*P(2,1)*P(5,6)*Metric(1,6)*Metric(3,4) + P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4) + 2*P(1,3)*P(6,2)*Metric(2,5)*Metric(3,4) - P(1,4)*P(6,2)*Metric(2,5)*Metric(3,4) - 3*P(1,5)*P(6,2)*Metric(2,5)*Metric(3,4) + 2*P(1,2)*P(6,3)*Metric(2,5)*Metric(3,4) - 3*P(1,4)*P(6,3)*Metric(2,5)*Metric(3,4) - P(1,5)*P(6,3)*Metric(2,5)*Metric(3,4) - P(1,2)*P(6,4)*Metric(2,5)*Metric(3,4) - 3*P(1,3)*P(6,4)*Metric(2,5)*Metric(3,4) + 2*P(1,5)*P(6,4)*Metric(2,5)*Metric(3,4) - 3*P(1,2)*P(6,5)*Metric(2,5)*Metric(3,4) - P(1,3)*P(6,5)*Metric(2,5)*Metric(3,4) + 2*P(1,4)*P(6,5)*Metric(2,5)*Metric(3,4) + 2*P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 4*P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 4*P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + 2*P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(1,2)*P(5,1)*Metric(2,6)*Metric(3,4) + P(1,3)*P(5,1)*Metric(2,6)*Metric(3,4) - P(1,4)*P(5,1)*Metric(2,6)*Metric(3,4) + 2*P(1,6)*P(5,1)*Metric(2,6)*Metric(3,4) - 2*P(1,3)*P(5,2)*Metric(2,6)*Metric(3,4) + P(1,4)*P(5,2)*Metric(2,6)*Metric(3,4) + 3*P(1,5)*P(5,2)*Metric(2,6)*Metric(3,4) + 2*P(1,4)*P(5,3)*Metric(2,6)*Metric(3,4) - 2*P(1,5)*P(5,3)*Metric(2,6)*Metric(3,4) + P(1,3)*P(5,4)*Metric(2,6)*Metric(3,4) + P(1,5)*P(5,4)*Metric(2,6)*Metric(3,4) - P(1,6)*P(5,4)*Metric(2,6)*Metric(3,4) + P(1,2)*P(5,6)*Metric(2,6)*Metric(3,4) + P(1,3)*P(5,6)*Metric(2,6)*Metric(3,4) - P(1,4)*P(5,6)*Metric(2,6)*Metric(3,4) - P(1,5)*P(5,6)*Metric(2,6)*Metric(3,4) + P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 3*P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(4,5)*P(6,1)*Metric(1,2)*Metric(3,5) + 2*P(4,6)*P(6,1)*Metric(1,2)*Metric(3,5) + P(4,1)*P(6,2)*Metric(1,2)*Metric(3,5) - P(4,6)*P(6,2)*Metric(1,2)*Metric(3,5) + P(4,1)*P(6,3)*Metric(1,2)*Metric(3,5) - 2*P(4,2)*P(6,3)*Metric(1,2)*Metric(3,5) + P(4,5)*P(6,3)*Metric(1,2)*Metric(3,5) + P(4,6)*P(6,3)*Metric(1,2)*Metric(3,5) - P(4,1)*P(6,4)*Metric(1,2)*Metric(3,5) + 3*P(4,2)*P(6,4)*Metric(1,2)*Metric(3,5) - 2*P(4,3)*P(6,4)*Metric(1,2)*Metric(3,5) + P(4,5)*P(6,4)*Metric(1,2)*Metric(3,5) - P(4,1)*P(6,5)*Metric(1,2)*Metric(3,5) + P(4,2)*P(6,5)*Metric(1,2)*Metric(3,5) + 2*P(4,3)*P(6,5)*Metric(1,2)*Metric(3,5) - P(4,6)*P(6,5)*Metric(1,2)*Metric(3,5) - P(2,3)*P(6,1)*Metric(1,4)*Metric(3,5) + 2*P(2,6)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,1)*P(6,2)*Metric(1,4)*Metric(3,5) + P(2,3)*P(6,2)*Metric(1,4)*Metric(3,5) + 3*P(2,4)*P(6,2)*Metric(1,4)*Metric(3,5) - 2*P(2,5)*P(6,2)*Metric(1,4)*Metric(3,5) - P(2,1)*P(6,3)*Metric(1,4)*Metric(3,5) + P(2,4)*P(6,3)*Metric(1,4)*Metric(3,5) + 2*P(2,5)*P(6,3)*Metric(1,4)*Metric(3,5) - P(2,6)*P(6,3)*Metric(1,4)*Metric(3,5) + P(2,1)*P(6,4)*Metric(1,4)*Metric(3,5) - P(2,6)*P(6,4)*Metric(1,4)*Metric(3,5) + P(2,1)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,3)*P(6,5)*Metric(1,4)*Metric(3,5) - 2*P(2,4)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,6)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,3)*P(4,1)*Metric(1,6)*Metric(3,5) - 2*P(2,6)*P(4,1)*Metric(1,6)*Metric(3,5) - 2*P(2,3)*P(4,2)*Metric(1,6)*Metric(3,5) + 4*P(2,5)*P(4,2)*Metric(1,6)*Metric(3,5) + 4*P(2,4)*P(4,3)*Metric(1,6)*Metric(3,5) - 4*P(2,5)*P(4,3)*Metric(1,6)*Metric(3,5) + P(2,1)*P(4,5)*Metric(1,6)*Metric(3,5) - 2*P(2,3)*P(4,5)*Metric(1,6)*Metric(3,5) - 2*P(2,4)*P(4,5)*Metric(1,6)*Metric(3,5) + P(2,6)*P(4,5)*Metric(1,6)*Metric(3,5) - 2*P(2,1)*P(4,6)*Metric(1,6)*Metric(3,5) + P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5) + 2*P(1,3)*P(6,2)*Metric(2,4)*Metric(3,5) - 3*P(1,4)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,5)*P(6,2)*Metric(2,4)*Metric(3,5) + 2*P(1,2)*P(6,3)*Metric(2,4)*Metric(3,5) - P(1,4)*P(6,3)*Metric(2,4)*Metric(3,5) - 3*P(1,5)*P(6,3)*Metric(2,4)*Metric(3,5) - 3*P(1,2)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) + 2*P(1,5)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,2)*P(6,5)*Metric(2,4)*Metric(3,5) - 3*P(1,3)*P(6,5)*Metric(2,4)*Metric(3,5) + 2*P(1,4)*P(6,5)*Metric(2,4)*Metric(3,5) + 2*P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 4*P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 4*P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + 2*P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(1,2)*P(4,1)*Metric(2,6)*Metric(3,5) + P(1,3)*P(4,1)*Metric(2,6)*Metric(3,5) - P(1,5)*P(4,1)*Metric(2,6)*Metric(3,5) + 2*P(1,6)*P(4,1)*Metric(2,6)*Metric(3,5) - 2*P(1,3)*P(4,2)*Metric(2,6)*Metric(3,5) + 3*P(1,4)*P(4,2)*Metric(2,6)*Metric(3,5) + P(1,5)*P(4,2)*Metric(2,6)*Metric(3,5) - 2*P(1,4)*P(4,3)*Metric(2,6)*Metric(3,5) + 2*P(1,5)*P(4,3)*Metric(2,6)*Metric(3,5) + P(1,3)*P(4,5)*Metric(2,6)*Metric(3,5) + P(1,4)*P(4,5)*Metric(2,6)*Metric(3,5) - P(1,6)*P(4,5)*Metric(2,6)*Metric(3,5) + P(1,2)*P(4,6)*Metric(2,6)*Metric(3,5) + P(1,3)*P(4,6)*Metric(2,6)*Metric(3,5) - P(1,4)*P(4,6)*Metric(2,6)*Metric(3,5) - P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) - 3*P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 2*P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 2*P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - 2*P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(4,2)*P(5,1)*Metric(1,2)*Metric(3,6) - P(4,3)*P(5,1)*Metric(1,2)*Metric(3,6) + 2*P(4,6)*P(5,1)*Metric(1,2)*Metric(3,6) - P(4,1)*P(5,2)*Metric(1,2)*Metric(3,6) + 2*P(4,3)*P(5,2)*Metric(1,2)*Metric(3,6) - P(4,5)*P(5,2)*Metric(1,2)*Metric(3,6) - P(4,6)*P(5,2)*Metric(1,2)*Metric(3,6) - P(4,1)*P(5,3)*Metric(1,2)*Metric(3,6) + 2*P(4,2)*P(5,3)*Metric(1,2)*Metric(3,6) - P(4,5)*P(5,3)*Metric(1,2)*Metric(3,6) - P(4,6)*P(5,3)*Metric(1,2)*Metric(3,6) - P(4,2)*P(5,4)*Metric(1,2)*Metric(3,6) - P(4,3)*P(5,4)*Metric(1,2)*Metric(3,6) + 2*P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) - P(4,2)*P(5,6)*Metric(1,2)*Metric(3,6) - P(4,3)*P(5,6)*Metric(1,2)*Metric(3,6) + P(2,4)*P(5,1)*Metric(1,4)*Metric(3,6) - P(2,5)*P(5,1)*Metric(1,4)*Metric(3,6) + P(2,1)*P(5,2)*Metric(1,4)*Metric(3,6) + P(2,3)*P(5,2)*Metric(1,4)*Metric(3,6) - 2*P(2,4)*P(5,2)*Metric(1,4)*Metric(3,6) - P(2,6)*P(5,2)*Metric(1,4)*Metric(3,6) + P(2,1)*P(5,3)*Metric(1,4)*Metric(3,6) - P(2,4)*P(5,3)*Metric(1,4)*Metric(3,6) - 2*P(2,5)*P(5,3)*Metric(1,4)*Metric(3,6) + P(2,6)*P(5,3)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6) + P(2,5)*P(5,4)*Metric(1,4)*Metric(3,6) - 2*P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) + P(2,4)*P(5,6)*Metric(1,4)*Metric(3,6) + P(2,5)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,4)*P(4,1)*Metric(1,5)*Metric(3,6) + P(2,5)*P(4,1)*Metric(1,5)*Metric(3,6) + P(2,1)*P(4,2)*Metric(1,5)*Metric(3,6) + P(2,3)*P(4,2)*Metric(1,5)*Metric(3,6) - 2*P(2,5)*P(4,2)*Metric(1,5)*Metric(3,6) - P(2,6)*P(4,2)*Metric(1,5)*Metric(3,6) + P(2,1)*P(4,3)*Metric(1,5)*Metric(3,6) - 2*P(2,4)*P(4,3)*Metric(1,5)*Metric(3,6) - P(2,5)*P(4,3)*Metric(1,5)*Metric(3,6) + P(2,6)*P(4,3)*Metric(1,5)*Metric(3,6) - P(2,3)*P(4,5)*Metric(1,5)*Metric(3,6) + P(2,4)*P(4,5)*Metric(1,5)*Metric(3,6) - 2*P(2,1)*P(4,6)*Metric(1,5)*Metric(3,6) + P(2,4)*P(4,6)*Metric(1,5)*Metric(3,6) + P(2,5)*P(4,6)*Metric(1,5)*Metric(3,6) + P(1,2)*P(5,1)*Metric(2,4)*Metric(3,6) - P(1,3)*P(5,1)*Metric(2,4)*Metric(3,6) - P(1,4)*P(5,1)*Metric(2,4)*Metric(3,6) + 2*P(1,6)*P(5,1)*Metric(2,4)*Metric(3,6) + 2*P(1,4)*P(5,2)*Metric(2,4)*Metric(3,6) - 2*P(1,5)*P(5,2)*Metric(2,4)*Metric(3,6) - 2*P(1,2)*P(5,3)*Metric(2,4)*Metric(3,6) + P(1,4)*P(5,3)*Metric(2,4)*Metric(3,6) + 3*P(1,5)*P(5,3)*Metric(2,4)*Metric(3,6) + P(1,2)*P(5,4)*Metric(2,4)*Metric(3,6) + P(1,5)*P(5,4)*Metric(2,4)*Metric(3,6) - P(1,6)*P(5,4)*Metric(2,4)*Metric(3,6) + P(1,2)*P(5,6)*Metric(2,4)*Metric(3,6) + P(1,3)*P(5,6)*Metric(2,4)*Metric(3,6) - P(1,4)*P(5,6)*Metric(2,4)*Metric(3,6) - P(1,5)*P(5,6)*Metric(2,4)*Metric(3,6) - P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) + 2*P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) + 2*P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) - 3*P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) - 2*P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(1,2)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,3)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,5)*P(4,1)*Metric(2,5)*Metric(3,6) + 2*P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6) - 2*P(1,4)*P(4,2)*Metric(2,5)*Metric(3,6) + 2*P(1,5)*P(4,2)*Metric(2,5)*Metric(3,6) - 2*P(1,2)*P(4,3)*Metric(2,5)*Metric(3,6) + 3*P(1,4)*P(4,3)*Metric(2,5)*Metric(3,6) + P(1,5)*P(4,3)*Metric(2,5)*Metric(3,6) + P(1,2)*P(4,5)*Metric(2,5)*Metric(3,6) + P(1,4)*P(4,5)*Metric(2,5)*Metric(3,6) - P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) + P(1,2)*P(4,6)*Metric(2,5)*Metric(3,6) + P(1,3)*P(4,6)*Metric(2,5)*Metric(3,6) - P(1,4)*P(4,6)*Metric(2,5)*Metric(3,6) - P(1,5)*P(4,6)*Metric(2,5)*Metric(3,6) - P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 3*P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 2*P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5) + P(3,5)*P(6,1)*Metric(1,2)*Metric(4,5) - 4*P(3,6)*P(6,1)*Metric(1,2)*Metric(4,5) - 2*P(3,1)*P(6,2)*Metric(1,2)*Metric(4,5) + 2*P(3,6)*P(6,2)*Metric(1,2)*Metric(4,5) + 2*P(3,1)*P(6,3)*Metric(1,2)*Metric(4,5) - 2*P(3,2)*P(6,3)*Metric(1,2)*Metric(4,5) - P(3,4)*P(6,3)*Metric(1,2)*Metric(4,5) - P(3,5)*P(6,3)*Metric(1,2)*Metric(4,5) + P(3,2)*P(6,4)*Metric(1,2)*Metric(4,5) - P(3,5)*P(6,4)*Metric(1,2)*Metric(4,5) + P(3,2)*P(6,5)*Metric(1,2)*Metric(4,5) - P(3,4)*P(6,5)*Metric(1,2)*Metric(4,5) + P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5) + P(2,5)*P(6,1)*Metric(1,3)*Metric(4,5) - 4*P(2,6)*P(6,1)*Metric(1,3)*Metric(4,5) + 2*P(2,1)*P(6,2)*Metric(1,3)*Metric(4,5) - 2*P(2,3)*P(6,2)*Metric(1,3)*Metric(4,5) - P(2,4)*P(6,2)*Metric(1,3)*Metric(4,5) - P(2,5)*P(6,2)*Metric(1,3)*Metric(4,5) - 2*P(2,1)*P(6,3)*Metric(1,3)*Metric(4,5) + 2*P(2,6)*P(6,3)*Metric(1,3)*Metric(4,5) + P(2,3)*P(6,4)*Metric(1,3)*Metric(4,5) - P(2,5)*P(6,4)*Metric(1,3)*Metric(4,5) + P(2,3)*P(6,5)*Metric(1,3)*Metric(4,5) - P(2,4)*P(6,5)*Metric(1,3)*Metric(4,5) - P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,1)*Metric(1,6)*Metric(4,5) + 4*P(2,6)*P(3,1)*Metric(1,6)*Metric(4,5) + 2*P(2,4)*P(3,2)*Metric(1,6)*Metric(4,5) + 2*P(2,5)*P(3,2)*Metric(1,6)*Metric(4,5) - P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5) + 2*P(2,3)*P(3,4)*Metric(1,6)*Metric(4,5) + 2*P(2,5)*P(3,4)*Metric(1,6)*Metric(4,5) - P(2,6)*P(3,4)*Metric(1,6)*Metric(4,5) - P(2,1)*P(3,5)*Metric(1,6)*Metric(4,5) + 2*P(2,3)*P(3,5)*Metric(1,6)*Metric(4,5) + 2*P(2,4)*P(3,5)*Metric(1,6)*Metric(4,5) - P(2,6)*P(3,5)*Metric(1,6)*Metric(4,5) + 4*P(2,1)*P(3,6)*Metric(1,6)*Metric(4,5) - P(2,4)*P(3,6)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) + 2*P(1,3)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,5)*P(6,2)*Metric(2,3)*Metric(4,5) + 2*P(1,2)*P(6,3)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5) - P(1,5)*P(6,3)*Metric(2,3)*Metric(4,5) - P(1,2)*P(6,4)*Metric(2,3)*Metric(4,5) - P(1,3)*P(6,4)*Metric(2,3)*Metric(4,5) + 2*P(1,5)*P(6,4)*Metric(2,3)*Metric(4,5) - P(1,2)*P(6,5)*Metric(2,3)*Metric(4,5) - P(1,3)*P(6,5)*Metric(2,3)*Metric(4,5) + 2*P(1,4)*P(6,5)*Metric(2,3)*Metric(4,5) - 2*P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(1,2)*P(3,1)*Metric(2,6)*Metric(4,5) - 4*P(1,6)*P(3,1)*Metric(2,6)*Metric(4,5) - 2*P(1,3)*P(3,2)*Metric(2,6)*Metric(4,5) + P(1,4)*P(3,2)*Metric(2,6)*Metric(4,5) + P(1,5)*P(3,2)*Metric(2,6)*Metric(4,5) - P(1,3)*P(3,4)*Metric(2,6)*Metric(4,5) - P(1,5)*P(3,4)*Metric(2,6)*Metric(4,5) + P(1,6)*P(3,4)*Metric(2,6)*Metric(4,5) - P(1,3)*P(3,5)*Metric(2,6)*Metric(4,5) - P(1,4)*P(3,5)*Metric(2,6)*Metric(4,5) + P(1,6)*P(3,5)*Metric(2,6)*Metric(4,5) - 2*P(1,2)*P(3,6)*Metric(2,6)*Metric(4,5) + 2*P(1,3)*P(3,6)*Metric(2,6)*Metric(4,5) - 2*P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 4*P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - 2*P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(1,3)*P(2,1)*Metric(3,6)*Metric(4,5) - 4*P(1,6)*P(2,1)*Metric(3,6)*Metric(4,5) - 2*P(1,2)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,5)*P(2,3)*Metric(3,6)*Metric(4,5) - P(1,2)*P(2,4)*Metric(3,6)*Metric(4,5) - P(1,5)*P(2,4)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,4)*Metric(3,6)*Metric(4,5) - P(1,2)*P(2,5)*Metric(3,6)*Metric(4,5) - P(1,4)*P(2,5)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) + 2*P(1,2)*P(2,6)*Metric(3,6)*Metric(4,5) - 2*P(1,3)*P(2,6)*Metric(3,6)*Metric(4,5) - 2*P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 4*P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(3,4)*P(5,1)*Metric(1,2)*Metric(4,6) + P(3,5)*P(5,1)*Metric(1,2)*Metric(4,6) - 2*P(3,6)*P(5,1)*Metric(1,2)*Metric(4,6) + P(3,1)*P(5,2)*Metric(1,2)*Metric(4,6) - P(3,4)*P(5,2)*Metric(1,2)*Metric(4,6) - 2*P(3,5)*P(5,2)*Metric(1,2)*Metric(4,6) + P(3,6)*P(5,2)*Metric(1,2)*Metric(4,6) - P(3,1)*P(5,3)*Metric(1,2)*Metric(4,6) + P(3,2)*P(5,3)*Metric(1,2)*Metric(4,6) - 2*P(3,4)*P(5,3)*Metric(1,2)*Metric(4,6) + P(3,6)*P(5,3)*Metric(1,2)*Metric(4,6) - P(3,2)*P(5,4)*Metric(1,2)*Metric(4,6) + P(3,5)*P(5,4)*Metric(1,2)*Metric(4,6) + P(3,4)*P(5,6)*Metric(1,2)*Metric(4,6) - P(3,5)*P(5,6)*Metric(1,2)*Metric(4,6) + P(2,4)*P(5,1)*Metric(1,3)*Metric(4,6) + P(2,5)*P(5,1)*Metric(1,3)*Metric(4,6) - 2*P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,1)*P(5,2)*Metric(1,3)*Metric(4,6) + P(2,3)*P(5,2)*Metric(1,3)*Metric(4,6) - 2*P(2,4)*P(5,2)*Metric(1,3)*Metric(4,6) + P(2,6)*P(5,2)*Metric(1,3)*Metric(4,6) + P(2,1)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) - 2*P(2,5)*P(5,3)*Metric(1,3)*Metric(4,6) + P(2,6)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,3)*P(5,4)*Metric(1,3)*Metric(4,6) + P(2,5)*P(5,4)*Metric(1,3)*Metric(4,6) + P(2,4)*P(5,6)*Metric(1,3)*Metric(4,6) - P(2,5)*P(5,6)*Metric(1,3)*Metric(4,6) - P(2,4)*P(3,1)*Metric(1,5)*Metric(4,6) - P(2,5)*P(3,1)*Metric(1,5)*Metric(4,6) + 2*P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) - P(2,4)*P(3,2)*Metric(1,5)*Metric(4,6) - P(2,5)*P(3,2)*Metric(1,5)*Metric(4,6) - P(2,1)*P(3,4)*Metric(1,5)*Metric(4,6) - P(2,3)*P(3,4)*Metric(1,5)*Metric(4,6) + 2*P(2,5)*P(3,4)*Metric(1,5)*Metric(4,6) - P(2,6)*P(3,4)*Metric(1,5)*Metric(4,6) - P(2,1)*P(3,5)*Metric(1,5)*Metric(4,6) - P(2,3)*P(3,5)*Metric(1,5)*Metric(4,6) + 2*P(2,4)*P(3,5)*Metric(1,5)*Metric(4,6) - P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) + 2*P(2,1)*P(3,6)*Metric(1,5)*Metric(4,6) - P(2,4)*P(3,6)*Metric(1,5)*Metric(4,6) - P(2,5)*P(3,6)*Metric(1,5)*Metric(4,6) + 2*P(1,4)*P(5,1)*Metric(2,3)*Metric(4,6) - 4*P(1,6)*P(5,1)*Metric(2,3)*Metric(4,6) - P(1,3)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,5)*P(5,2)*Metric(2,3)*Metric(4,6) + P(1,6)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,2)*P(5,3)*Metric(2,3)*Metric(4,6) - P(1,5)*P(5,3)*Metric(2,3)*Metric(4,6) + P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6) + P(1,2)*P(5,4)*Metric(2,3)*Metric(4,6) + P(1,3)*P(5,4)*Metric(2,3)*Metric(4,6) - 2*P(1,5)*P(5,4)*Metric(2,3)*Metric(4,6) - 2*P(1,4)*P(5,6)*Metric(2,3)*Metric(4,6) + 2*P(1,5)*P(5,6)*Metric(2,3)*Metric(4,6) - 2*P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) + 2*P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) + 4*P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - 2*P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(1,2)*P(3,1)*Metric(2,5)*Metric(4,6) - P(1,4)*P(3,1)*Metric(2,5)*Metric(4,6) + P(1,5)*P(3,1)*Metric(2,5)*Metric(4,6) + 2*P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6) + P(1,3)*P(3,2)*Metric(2,5)*Metric(4,6) + P(1,5)*P(3,2)*Metric(2,5)*Metric(4,6) - P(1,6)*P(3,2)*Metric(2,5)*Metric(4,6) + P(1,2)*P(3,4)*Metric(2,5)*Metric(4,6) + 3*P(1,3)*P(3,4)*Metric(2,5)*Metric(4,6) - 2*P(1,5)*P(3,4)*Metric(2,5)*Metric(4,6) + 2*P(1,2)*P(3,5)*Metric(2,5)*Metric(4,6) - 2*P(1,3)*P(3,5)*Metric(2,5)*Metric(4,6) - P(1,2)*P(3,6)*Metric(2,5)*Metric(4,6) - P(1,3)*P(3,6)*Metric(2,5)*Metric(4,6) + P(1,4)*P(3,6)*Metric(2,5)*Metric(4,6) + P(1,5)*P(3,6)*Metric(2,5)*Metric(4,6) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6) - 3*P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) - 2*P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(1,3)*P(2,1)*Metric(3,5)*Metric(4,6) - P(1,4)*P(2,1)*Metric(3,5)*Metric(4,6) + P(1,5)*P(2,1)*Metric(3,5)*Metric(4,6) + 2*P(1,6)*P(2,1)*Metric(3,5)*Metric(4,6) + P(1,2)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,5)*P(2,3)*Metric(3,5)*Metric(4,6) - P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6) + 3*P(1,2)*P(2,4)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6) - 2*P(1,5)*P(2,4)*Metric(3,5)*Metric(4,6) - 2*P(1,2)*P(2,5)*Metric(3,5)*Metric(4,6) + 2*P(1,3)*P(2,5)*Metric(3,5)*Metric(4,6) - P(1,2)*P(2,6)*Metric(3,5)*Metric(4,6) - P(1,3)*P(2,6)*Metric(3,5)*Metric(4,6) + P(1,4)*P(2,6)*Metric(3,5)*Metric(4,6) + P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 3*P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(3,4)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,5)*P(4,1)*Metric(1,2)*Metric(5,6) - 2*P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,1)*P(4,2)*Metric(1,2)*Metric(5,6) - 2*P(3,4)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,5)*P(4,2)*Metric(1,2)*Metric(5,6) + P(3,6)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,1)*P(4,3)*Metric(1,2)*Metric(5,6) + P(3,2)*P(4,3)*Metric(1,2)*Metric(5,6) - 2*P(3,5)*P(4,3)*Metric(1,2)*Metric(5,6) + P(3,6)*P(4,3)*Metric(1,2)*Metric(5,6) - P(3,2)*P(4,5)*Metric(1,2)*Metric(5,6) + P(3,4)*P(4,5)*Metric(1,2)*Metric(5,6) - P(3,4)*P(4,6)*Metric(1,2)*Metric(5,6) + P(3,5)*P(4,6)*Metric(1,2)*Metric(5,6) + P(2,4)*P(4,1)*Metric(1,3)*Metric(5,6) + P(2,5)*P(4,1)*Metric(1,3)*Metric(5,6) - 2*P(2,6)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,1)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,3)*P(4,2)*Metric(1,3)*Metric(5,6) - 2*P(2,5)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,6)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,1)*P(4,3)*Metric(1,3)*Metric(5,6) - 2*P(2,4)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,5)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,6)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,3)*P(4,5)*Metric(1,3)*Metric(5,6) + P(2,4)*P(4,5)*Metric(1,3)*Metric(5,6) - P(2,4)*P(4,6)*Metric(1,3)*Metric(5,6) + P(2,5)*P(4,6)*Metric(1,3)*Metric(5,6) - P(2,4)*P(3,1)*Metric(1,4)*Metric(5,6) - P(2,5)*P(3,1)*Metric(1,4)*Metric(5,6) + 2*P(2,6)*P(3,1)*Metric(1,4)*Metric(5,6) - P(2,4)*P(3,2)*Metric(1,4)*Metric(5,6) - P(2,5)*P(3,2)*Metric(1,4)*Metric(5,6) - P(2,1)*P(3,4)*Metric(1,4)*Metric(5,6) - P(2,3)*P(3,4)*Metric(1,4)*Metric(5,6) + 2*P(2,5)*P(3,4)*Metric(1,4)*Metric(5,6) - P(2,6)*P(3,4)*Metric(1,4)*Metric(5,6) - P(2,1)*P(3,5)*Metric(1,4)*Metric(5,6) - P(2,3)*P(3,5)*Metric(1,4)*Metric(5,6) + 2*P(2,4)*P(3,5)*Metric(1,4)*Metric(5,6) - P(2,6)*P(3,5)*Metric(1,4)*Metric(5,6) + 2*P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) - P(2,4)*P(3,6)*Metric(1,4)*Metric(5,6) - P(2,5)*P(3,6)*Metric(1,4)*Metric(5,6) + 2*P(1,5)*P(4,1)*Metric(2,3)*Metric(5,6) - 4*P(1,6)*P(4,1)*Metric(2,3)*Metric(5,6) - P(1,3)*P(4,2)*Metric(2,3)*Metric(5,6) - P(1,4)*P(4,2)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,2)*Metric(2,3)*Metric(5,6) - P(1,2)*P(4,3)*Metric(2,3)*Metric(5,6) - P(1,4)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,2)*P(4,5)*Metric(2,3)*Metric(5,6) + P(1,3)*P(4,5)*Metric(2,3)*Metric(5,6) - 2*P(1,4)*P(4,5)*Metric(2,3)*Metric(5,6) + 2*P(1,4)*P(4,6)*Metric(2,3)*Metric(5,6) - 2*P(1,5)*P(4,6)*Metric(2,3)*Metric(5,6) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) + 2*P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) + 4*P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(1,2)*P(3,1)*Metric(2,4)*Metric(5,6) + P(1,4)*P(3,1)*Metric(2,4)*Metric(5,6) - P(1,5)*P(3,1)*Metric(2,4)*Metric(5,6) + 2*P(1,6)*P(3,1)*Metric(2,4)*Metric(5,6) + P(1,3)*P(3,2)*Metric(2,4)*Metric(5,6) + P(1,4)*P(3,2)*Metric(2,4)*Metric(5,6) - P(1,6)*P(3,2)*Metric(2,4)*Metric(5,6) + 2*P(1,2)*P(3,4)*Metric(2,4)*Metric(5,6) - 2*P(1,3)*P(3,4)*Metric(2,4)*Metric(5,6) + P(1,2)*P(3,5)*Metric(2,4)*Metric(5,6) + 3*P(1,3)*P(3,5)*Metric(2,4)*Metric(5,6) - 2*P(1,4)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,2)*P(3,6)*Metric(2,4)*Metric(5,6) - P(1,3)*P(3,6)*Metric(2,4)*Metric(5,6) + P(1,4)*P(3,6)*Metric(2,4)*Metric(5,6) + P(1,5)*P(3,6)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 3*P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(1,3)*P(2,1)*Metric(3,4)*Metric(5,6) + P(1,4)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,5)*P(2,1)*Metric(3,4)*Metric(5,6) + 2*P(1,6)*P(2,1)*Metric(3,4)*Metric(5,6) + P(1,2)*P(2,3)*Metric(3,4)*Metric(5,6) + P(1,4)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6) - 2*P(1,2)*P(2,4)*Metric(3,4)*Metric(5,6) + 2*P(1,3)*P(2,4)*Metric(3,4)*Metric(5,6) + 3*P(1,2)*P(2,5)*Metric(3,4)*Metric(5,6) + P(1,3)*P(2,5)*Metric(3,4)*Metric(5,6) - 2*P(1,4)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,2)*P(2,6)*Metric(3,4)*Metric(5,6) - P(1,3)*P(2,6)*Metric(3,4)*Metric(5,6) + P(1,4)*P(2,6)*Metric(3,4)*Metric(5,6) + P(1,5)*P(2,6)*Metric(3,4)*Metric(5,6) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 3*P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) - P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) - P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV60 = Lorentz(name = 'VVVVVV60',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,6)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,6)*P(6,4)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,5)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,5)*Metric(1,4)*Metric(2,3) + P(4,6)*P(6,3)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,4)*Metric(1,5)*Metric(2,3) + P(4,5)*P(6,4)*Metric(1,5)*Metric(2,3) + P(4,6)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,5)*P(5,3)*Metric(1,6)*Metric(2,3) + P(4,3)*P(5,4)*Metric(1,6)*Metric(2,3) + P(4,6)*P(5,4)*Metric(1,6)*Metric(2,3) + P(4,5)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,6)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,6)*P(6,4)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,5)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,5)*Metric(1,3)*Metric(2,4) + P(3,4)*P(6,3)*Metric(1,5)*Metric(2,4) + P(3,5)*P(6,3)*Metric(1,5)*Metric(2,4) + P(3,6)*P(6,4)*Metric(1,5)*Metric(2,4) + P(3,6)*P(6,5)*Metric(1,5)*Metric(2,4) + P(3,4)*P(5,3)*Metric(1,6)*Metric(2,4) + P(3,6)*P(5,3)*Metric(1,6)*Metric(2,4) + P(3,5)*P(5,4)*Metric(1,6)*Metric(2,4) + P(3,5)*P(5,6)*Metric(1,6)*Metric(2,4) + P(4,6)*P(6,3)*Metric(1,3)*Metric(2,5) + P(4,3)*P(6,4)*Metric(1,3)*Metric(2,5) + P(4,5)*P(6,4)*Metric(1,3)*Metric(2,5) + P(4,6)*P(6,5)*Metric(1,3)*Metric(2,5) + P(3,4)*P(6,3)*Metric(1,4)*Metric(2,5) + P(3,5)*P(6,3)*Metric(1,4)*Metric(2,5) + P(3,6)*P(6,4)*Metric(1,4)*Metric(2,5) + P(3,6)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,5)*P(4,3)*Metric(1,6)*Metric(2,5) + P(3,6)*P(4,3)*Metric(1,6)*Metric(2,5) + P(3,4)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,4)*P(4,6)*Metric(1,6)*Metric(2,5) + P(4,5)*P(5,3)*Metric(1,3)*Metric(2,6) + P(4,3)*P(5,4)*Metric(1,3)*Metric(2,6) + P(4,6)*P(5,4)*Metric(1,3)*Metric(2,6) + P(4,5)*P(5,6)*Metric(1,3)*Metric(2,6) + P(3,4)*P(5,3)*Metric(1,4)*Metric(2,6) + P(3,6)*P(5,3)*Metric(1,4)*Metric(2,6) + P(3,5)*P(5,4)*Metric(1,4)*Metric(2,6) + P(3,5)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,5)*P(4,3)*Metric(1,5)*Metric(2,6) + P(3,6)*P(4,3)*Metric(1,5)*Metric(2,6) + P(3,4)*P(4,5)*Metric(1,5)*Metric(2,6) + P(3,4)*P(4,6)*Metric(1,5)*Metric(2,6) + 2*P(5,4)*P(6,3)*Metric(1,2)*Metric(3,4) - 2*P(5,6)*P(6,3)*Metric(1,2)*Metric(3,4) + 2*P(5,3)*P(6,4)*Metric(1,2)*Metric(3,4) - 2*P(5,6)*P(6,4)*Metric(1,2)*Metric(3,4) - 2*P(5,3)*P(6,5)*Metric(1,2)*Metric(3,4) - 2*P(5,4)*P(6,5)*Metric(1,2)*Metric(3,4) - P(2,4)*P(6,3)*Metric(1,5)*Metric(3,4) + P(2,6)*P(6,3)*Metric(1,5)*Metric(3,4) - P(2,3)*P(6,4)*Metric(1,5)*Metric(3,4) + P(2,6)*P(6,4)*Metric(1,5)*Metric(3,4) - 2*P(2,6)*P(6,5)*Metric(1,5)*Metric(3,4) - P(2,4)*P(5,3)*Metric(1,6)*Metric(3,4) + P(2,5)*P(5,3)*Metric(1,6)*Metric(3,4) - P(2,3)*P(5,4)*Metric(1,6)*Metric(3,4) + P(2,5)*P(5,4)*Metric(1,6)*Metric(3,4) - 2*P(2,5)*P(5,6)*Metric(1,6)*Metric(3,4) - P(1,4)*P(6,3)*Metric(2,5)*Metric(3,4) + P(1,6)*P(6,3)*Metric(2,5)*Metric(3,4) - P(1,3)*P(6,4)*Metric(2,5)*Metric(3,4) + P(1,6)*P(6,4)*Metric(2,5)*Metric(3,4) - 2*P(1,6)*P(6,5)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + 2*P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(1,4)*P(5,3)*Metric(2,6)*Metric(3,4) + P(1,5)*P(5,3)*Metric(2,6)*Metric(3,4) - P(1,3)*P(5,4)*Metric(2,6)*Metric(3,4) + P(1,5)*P(5,4)*Metric(2,6)*Metric(3,4) - 2*P(1,5)*P(5,6)*Metric(2,6)*Metric(3,4) - P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(4,5)*P(6,3)*Metric(1,2)*Metric(3,5) - 2*P(4,6)*P(6,3)*Metric(1,2)*Metric(3,5) - 2*P(4,3)*P(6,4)*Metric(1,2)*Metric(3,5) - 2*P(4,5)*P(6,4)*Metric(1,2)*Metric(3,5) + 2*P(4,3)*P(6,5)*Metric(1,2)*Metric(3,5) - 2*P(4,6)*P(6,5)*Metric(1,2)*Metric(3,5) - P(2,5)*P(6,3)*Metric(1,4)*Metric(3,5) + P(2,6)*P(6,3)*Metric(1,4)*Metric(3,5) - 2*P(2,6)*P(6,4)*Metric(1,4)*Metric(3,5) - P(2,3)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,6)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,4)*P(4,3)*Metric(1,6)*Metric(3,5) - P(2,5)*P(4,3)*Metric(1,6)*Metric(3,5) - P(2,3)*P(4,5)*Metric(1,6)*Metric(3,5) + P(2,4)*P(4,5)*Metric(1,6)*Metric(3,5) - 2*P(2,4)*P(4,6)*Metric(1,6)*Metric(3,5) - P(1,5)*P(6,3)*Metric(2,4)*Metric(3,5) + P(1,6)*P(6,3)*Metric(2,4)*Metric(3,5) - 2*P(1,6)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,5)*Metric(2,4)*Metric(3,5) + P(1,6)*P(6,5)*Metric(2,4)*Metric(3,5) - P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) + 2*P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(1,4)*P(4,3)*Metric(2,6)*Metric(3,5) - P(1,5)*P(4,3)*Metric(2,6)*Metric(3,5) - P(1,3)*P(4,5)*Metric(2,6)*Metric(3,5) + P(1,4)*P(4,5)*Metric(2,6)*Metric(3,5) - 2*P(1,4)*P(4,6)*Metric(2,6)*Metric(3,5) - P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 2*P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - 2*P(4,5)*P(5,3)*Metric(1,2)*Metric(3,6) + 2*P(4,6)*P(5,3)*Metric(1,2)*Metric(3,6) - 2*P(4,3)*P(5,4)*Metric(1,2)*Metric(3,6) - 2*P(4,6)*P(5,4)*Metric(1,2)*Metric(3,6) + 2*P(4,3)*P(5,6)*Metric(1,2)*Metric(3,6) - 2*P(4,5)*P(5,6)*Metric(1,2)*Metric(3,6) + P(2,5)*P(5,3)*Metric(1,4)*Metric(3,6) - P(2,6)*P(5,3)*Metric(1,4)*Metric(3,6) - 2*P(2,5)*P(5,4)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,6)*Metric(1,4)*Metric(3,6) + P(2,5)*P(5,6)*Metric(1,4)*Metric(3,6) + P(2,4)*P(4,3)*Metric(1,5)*Metric(3,6) - P(2,6)*P(4,3)*Metric(1,5)*Metric(3,6) - 2*P(2,4)*P(4,5)*Metric(1,5)*Metric(3,6) - P(2,3)*P(4,6)*Metric(1,5)*Metric(3,6) + P(2,4)*P(4,6)*Metric(1,5)*Metric(3,6) + P(1,5)*P(5,3)*Metric(2,4)*Metric(3,6) - P(1,6)*P(5,3)*Metric(2,4)*Metric(3,6) - 2*P(1,5)*P(5,4)*Metric(2,4)*Metric(3,6) - P(1,3)*P(5,6)*Metric(2,4)*Metric(3,6) + P(1,5)*P(5,6)*Metric(2,4)*Metric(3,6) - P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) + 2*P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(1,4)*P(4,3)*Metric(2,5)*Metric(3,6) - P(1,6)*P(4,3)*Metric(2,5)*Metric(3,6) - 2*P(1,4)*P(4,5)*Metric(2,5)*Metric(3,6) - P(1,3)*P(4,6)*Metric(2,5)*Metric(3,6) + P(1,4)*P(4,6)*Metric(2,5)*Metric(3,6) - P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 2*P(3,4)*P(6,3)*Metric(1,2)*Metric(4,5) - 2*P(3,5)*P(6,3)*Metric(1,2)*Metric(4,5) + 2*P(3,5)*P(6,4)*Metric(1,2)*Metric(4,5) - 2*P(3,6)*P(6,4)*Metric(1,2)*Metric(4,5) + 2*P(3,4)*P(6,5)*Metric(1,2)*Metric(4,5) - 2*P(3,6)*P(6,5)*Metric(1,2)*Metric(4,5) - 2*P(2,6)*P(6,3)*Metric(1,3)*Metric(4,5) - P(2,5)*P(6,4)*Metric(1,3)*Metric(4,5) + P(2,6)*P(6,4)*Metric(1,3)*Metric(4,5) - P(2,4)*P(6,5)*Metric(1,3)*Metric(4,5) + P(2,6)*P(6,5)*Metric(1,3)*Metric(4,5) + P(2,3)*P(3,4)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,4)*Metric(1,6)*Metric(4,5) + P(2,3)*P(3,5)*Metric(1,6)*Metric(4,5) - P(2,4)*P(3,5)*Metric(1,6)*Metric(4,5) - 2*P(2,3)*P(3,6)*Metric(1,6)*Metric(4,5) - 2*P(1,6)*P(6,3)*Metric(2,3)*Metric(4,5) - P(1,5)*P(6,4)*Metric(2,3)*Metric(4,5) + P(1,6)*P(6,4)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,5)*Metric(2,3)*Metric(4,5) + P(1,6)*P(6,5)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(1,3)*P(3,4)*Metric(2,6)*Metric(4,5) - P(1,5)*P(3,4)*Metric(2,6)*Metric(4,5) + P(1,3)*P(3,5)*Metric(2,6)*Metric(4,5) - P(1,4)*P(3,5)*Metric(2,6)*Metric(4,5) - 2*P(1,3)*P(3,6)*Metric(2,6)*Metric(4,5) - P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(1,6)*P(2,3)*Metric(3,6)*Metric(4,5) + 2*P(1,5)*P(2,4)*Metric(3,6)*Metric(4,5) + 2*P(1,4)*P(2,5)*Metric(3,6)*Metric(4,5) + 2*P(1,3)*P(2,6)*Metric(3,6)*Metric(4,5) + 2*P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(3,4)*P(5,3)*Metric(1,2)*Metric(4,6) - 2*P(3,6)*P(5,3)*Metric(1,2)*Metric(4,6) - 2*P(3,5)*P(5,4)*Metric(1,2)*Metric(4,6) + 2*P(3,6)*P(5,4)*Metric(1,2)*Metric(4,6) + 2*P(3,4)*P(5,6)*Metric(1,2)*Metric(4,6) - 2*P(3,5)*P(5,6)*Metric(1,2)*Metric(4,6) - 2*P(2,5)*P(5,3)*Metric(1,3)*Metric(4,6) + P(2,5)*P(5,4)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,4)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,6)*Metric(1,3)*Metric(4,6) + P(2,5)*P(5,6)*Metric(1,3)*Metric(4,6) + P(2,3)*P(3,4)*Metric(1,5)*Metric(4,6) - P(2,6)*P(3,4)*Metric(1,5)*Metric(4,6) - 2*P(2,3)*P(3,5)*Metric(1,5)*Metric(4,6) + P(2,3)*P(3,6)*Metric(1,5)*Metric(4,6) - P(2,4)*P(3,6)*Metric(1,5)*Metric(4,6) - 2*P(1,5)*P(5,3)*Metric(2,3)*Metric(4,6) + P(1,5)*P(5,4)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,4)*Metric(2,3)*Metric(4,6) - P(1,4)*P(5,6)*Metric(2,3)*Metric(4,6) + P(1,5)*P(5,6)*Metric(2,3)*Metric(4,6) - P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) + 2*P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(1,3)*P(3,4)*Metric(2,5)*Metric(4,6) - P(1,6)*P(3,4)*Metric(2,5)*Metric(4,6) - 2*P(1,3)*P(3,5)*Metric(2,5)*Metric(4,6) + P(1,3)*P(3,6)*Metric(2,5)*Metric(4,6) - P(1,4)*P(3,6)*Metric(2,5)*Metric(4,6) - P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(1,5)*P(2,3)*Metric(3,5)*Metric(4,6) + 2*P(1,6)*P(2,4)*Metric(3,5)*Metric(4,6) + 2*P(1,3)*P(2,5)*Metric(3,5)*Metric(4,6) + 2*P(1,4)*P(2,6)*Metric(3,5)*Metric(4,6) + 2*P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(3,5)*P(4,3)*Metric(1,2)*Metric(5,6) - 2*P(3,6)*P(4,3)*Metric(1,2)*Metric(5,6) - 2*P(3,4)*P(4,5)*Metric(1,2)*Metric(5,6) + 2*P(3,6)*P(4,5)*Metric(1,2)*Metric(5,6) - 2*P(3,4)*P(4,6)*Metric(1,2)*Metric(5,6) + 2*P(3,5)*P(4,6)*Metric(1,2)*Metric(5,6) - 2*P(2,4)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,4)*P(4,5)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,5)*Metric(1,3)*Metric(5,6) + P(2,4)*P(4,6)*Metric(1,3)*Metric(5,6) - P(2,5)*P(4,6)*Metric(1,3)*Metric(5,6) - 2*P(2,3)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,3)*P(3,5)*Metric(1,4)*Metric(5,6) - P(2,6)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,3)*P(3,6)*Metric(1,4)*Metric(5,6) - P(2,5)*P(3,6)*Metric(1,4)*Metric(5,6) - 2*P(1,4)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,4)*P(4,5)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,5)*Metric(2,3)*Metric(5,6) + P(1,4)*P(4,6)*Metric(2,3)*Metric(5,6) - P(1,5)*P(4,6)*Metric(2,3)*Metric(5,6) + 2*P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(1,3)*P(3,4)*Metric(2,4)*Metric(5,6) + P(1,3)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,6)*P(3,5)*Metric(2,4)*Metric(5,6) + P(1,3)*P(3,6)*Metric(2,4)*Metric(5,6) - P(1,5)*P(3,6)*Metric(2,4)*Metric(5,6) + 2*P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(1,4)*P(2,3)*Metric(3,4)*Metric(5,6) + 2*P(1,3)*P(2,4)*Metric(3,4)*Metric(5,6) + 2*P(1,6)*P(2,5)*Metric(3,4)*Metric(5,6) + 2*P(1,5)*P(2,6)*Metric(3,4)*Metric(5,6) + 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV61 = Lorentz(name = 'VVVVVV61',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,3)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,6)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,6)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,6)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,4)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,4)*Metric(1,4)*Metric(2,3) + P(5,6)*P(6,4)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,5)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,5)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,5)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,5)*Metric(1,4)*Metric(2,3) - P(4,3)*P(6,2)*Metric(1,5)*Metric(2,3) - P(4,6)*P(6,2)*Metric(1,5)*Metric(2,3) - P(4,1)*P(6,3)*Metric(1,5)*Metric(2,3) - P(4,1)*P(6,4)*Metric(1,5)*Metric(2,3) - P(4,3)*P(6,4)*Metric(1,5)*Metric(2,3) - P(4,1)*P(6,5)*Metric(1,5)*Metric(2,3) - P(4,6)*P(6,5)*Metric(1,5)*Metric(2,3) - P(4,3)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,5)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,3)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,4)*Metric(1,6)*Metric(2,3) - P(4,3)*P(5,4)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,6)*Metric(1,6)*Metric(2,3) - P(4,5)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,3)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,6)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,6)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,2)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,6)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,4)*Metric(1,3)*Metric(2,4) + P(5,2)*P(6,4)*Metric(1,3)*Metric(2,4) + P(5,6)*P(6,4)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,5)*Metric(1,3)*Metric(2,4) + P(5,2)*P(6,5)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,5)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,5)*Metric(1,3)*Metric(2,4) - P(3,4)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,6)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,1)*P(6,3)*Metric(1,5)*Metric(2,4) - P(3,4)*P(6,3)*Metric(1,5)*Metric(2,4) - P(3,1)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,1)*P(6,5)*Metric(1,5)*Metric(2,4) - P(3,6)*P(6,5)*Metric(1,5)*Metric(2,4) - P(3,4)*P(5,2)*Metric(1,6)*Metric(2,4) - P(3,5)*P(5,2)*Metric(1,6)*Metric(2,4) - P(3,1)*P(5,3)*Metric(1,6)*Metric(2,4) - P(3,4)*P(5,3)*Metric(1,6)*Metric(2,4) - P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4) - P(3,1)*P(5,6)*Metric(1,6)*Metric(2,4) - P(3,5)*P(5,6)*Metric(1,6)*Metric(2,4) - P(4,3)*P(6,1)*Metric(1,3)*Metric(2,5) - P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5) - P(4,2)*P(6,3)*Metric(1,3)*Metric(2,5) - P(4,2)*P(6,4)*Metric(1,3)*Metric(2,5) - P(4,3)*P(6,4)*Metric(1,3)*Metric(2,5) - P(4,2)*P(6,5)*Metric(1,3)*Metric(2,5) - P(4,6)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,4)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,2)*P(6,3)*Metric(1,4)*Metric(2,5) - P(3,4)*P(6,3)*Metric(1,4)*Metric(2,5) - P(3,2)*P(6,4)*Metric(1,4)*Metric(2,5) - P(3,2)*P(6,5)*Metric(1,4)*Metric(2,5) - P(3,6)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,4)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,4)*P(4,2)*Metric(1,6)*Metric(2,5) + P(3,5)*P(4,2)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,3)*Metric(1,6)*Metric(2,5) + P(3,2)*P(4,3)*Metric(1,6)*Metric(2,5) + P(3,5)*P(4,3)*Metric(1,6)*Metric(2,5) + P(3,6)*P(4,3)*Metric(1,6)*Metric(2,5) + P(3,2)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,4)*P(4,5)*Metric(1,6)*Metric(2,5) - P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5) + P(3,4)*P(4,6)*Metric(1,6)*Metric(2,5) - P(3,5)*P(4,6)*Metric(1,6)*Metric(2,5) - P(4,3)*P(5,1)*Metric(1,3)*Metric(2,6) - P(4,5)*P(5,1)*Metric(1,3)*Metric(2,6) - P(4,2)*P(5,3)*Metric(1,3)*Metric(2,6) - P(4,2)*P(5,4)*Metric(1,3)*Metric(2,6) - P(4,3)*P(5,4)*Metric(1,3)*Metric(2,6) - P(4,2)*P(5,6)*Metric(1,3)*Metric(2,6) - P(4,5)*P(5,6)*Metric(1,3)*Metric(2,6) - P(3,4)*P(5,1)*Metric(1,4)*Metric(2,6) - P(3,5)*P(5,1)*Metric(1,4)*Metric(2,6) - P(3,2)*P(5,3)*Metric(1,4)*Metric(2,6) - P(3,4)*P(5,3)*Metric(1,4)*Metric(2,6) - P(3,2)*P(5,4)*Metric(1,4)*Metric(2,6) - P(3,2)*P(5,6)*Metric(1,4)*Metric(2,6) - P(3,5)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,4)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,5)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,4)*P(4,2)*Metric(1,5)*Metric(2,6) + P(3,6)*P(4,2)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,3)*Metric(1,5)*Metric(2,6) + P(3,2)*P(4,3)*Metric(1,5)*Metric(2,6) + P(3,5)*P(4,3)*Metric(1,5)*Metric(2,6) + P(3,6)*P(4,3)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,5)*Metric(1,5)*Metric(2,6) + P(3,4)*P(4,5)*Metric(1,5)*Metric(2,6) - P(3,6)*P(4,5)*Metric(1,5)*Metric(2,6) + P(3,2)*P(4,6)*Metric(1,5)*Metric(2,6) + P(3,4)*P(4,6)*Metric(1,5)*Metric(2,6) - P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) - 2*P(5,2)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,3)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4) - 2*P(5,6)*P(6,1)*Metric(1,2)*Metric(3,4) - 2*P(5,1)*P(6,2)*Metric(1,2)*Metric(3,4) + P(5,3)*P(6,2)*Metric(1,2)*Metric(3,4) + P(5,4)*P(6,2)*Metric(1,2)*Metric(3,4) - 2*P(5,6)*P(6,2)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,2)*P(6,3)*Metric(1,2)*Metric(3,4) - 2*P(5,4)*P(6,3)*Metric(1,2)*Metric(3,4) - 2*P(5,6)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,4)*Metric(1,2)*Metric(3,4) + P(5,2)*P(6,4)*Metric(1,2)*Metric(3,4) - 2*P(5,3)*P(6,4)*Metric(1,2)*Metric(3,4) - 2*P(5,6)*P(6,4)*Metric(1,2)*Metric(3,4) - 2*P(5,1)*P(6,5)*Metric(1,2)*Metric(3,4) - 2*P(5,2)*P(6,5)*Metric(1,2)*Metric(3,4) - 2*P(5,3)*P(6,5)*Metric(1,2)*Metric(3,4) - 2*P(5,4)*P(6,5)*Metric(1,2)*Metric(3,4) + 2*P(2,1)*P(6,2)*Metric(1,5)*Metric(3,4) + P(2,3)*P(6,2)*Metric(1,5)*Metric(3,4) + P(2,4)*P(6,2)*Metric(1,5)*Metric(3,4) - P(2,1)*P(6,3)*Metric(1,5)*Metric(3,4) + P(2,4)*P(6,3)*Metric(1,5)*Metric(3,4) + P(2,6)*P(6,3)*Metric(1,5)*Metric(3,4) - P(2,1)*P(6,4)*Metric(1,5)*Metric(3,4) + P(2,3)*P(6,4)*Metric(1,5)*Metric(3,4) + P(2,6)*P(6,4)*Metric(1,5)*Metric(3,4) + 2*P(2,1)*P(6,5)*Metric(1,5)*Metric(3,4) + 2*P(2,6)*P(6,5)*Metric(1,5)*Metric(3,4) + 2*P(2,1)*P(5,2)*Metric(1,6)*Metric(3,4) + P(2,3)*P(5,2)*Metric(1,6)*Metric(3,4) + P(2,4)*P(5,2)*Metric(1,6)*Metric(3,4) - P(2,1)*P(5,3)*Metric(1,6)*Metric(3,4) + P(2,4)*P(5,3)*Metric(1,6)*Metric(3,4) + P(2,5)*P(5,3)*Metric(1,6)*Metric(3,4) - P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4) + P(2,3)*P(5,4)*Metric(1,6)*Metric(3,4) + P(2,5)*P(5,4)*Metric(1,6)*Metric(3,4) + 2*P(2,1)*P(5,6)*Metric(1,6)*Metric(3,4) + 2*P(2,5)*P(5,6)*Metric(1,6)*Metric(3,4) + 2*P(1,2)*P(6,1)*Metric(2,5)*Metric(3,4) + P(1,3)*P(6,1)*Metric(2,5)*Metric(3,4) + P(1,4)*P(6,1)*Metric(2,5)*Metric(3,4) - P(1,2)*P(6,3)*Metric(2,5)*Metric(3,4) + P(1,4)*P(6,3)*Metric(2,5)*Metric(3,4) + P(1,6)*P(6,3)*Metric(2,5)*Metric(3,4) - P(1,2)*P(6,4)*Metric(2,5)*Metric(3,4) + P(1,3)*P(6,4)*Metric(2,5)*Metric(3,4) + P(1,6)*P(6,4)*Metric(2,5)*Metric(3,4) + 2*P(1,2)*P(6,5)*Metric(2,5)*Metric(3,4) + 2*P(1,6)*P(6,5)*Metric(2,5)*Metric(3,4) - 2*P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + 2*P(1,2)*P(5,1)*Metric(2,6)*Metric(3,4) + P(1,3)*P(5,1)*Metric(2,6)*Metric(3,4) + P(1,4)*P(5,1)*Metric(2,6)*Metric(3,4) - P(1,2)*P(5,3)*Metric(2,6)*Metric(3,4) + P(1,4)*P(5,3)*Metric(2,6)*Metric(3,4) + P(1,5)*P(5,3)*Metric(2,6)*Metric(3,4) - P(1,2)*P(5,4)*Metric(2,6)*Metric(3,4) + P(1,3)*P(5,4)*Metric(2,6)*Metric(3,4) + P(1,5)*P(5,4)*Metric(2,6)*Metric(3,4) + 2*P(1,2)*P(5,6)*Metric(2,6)*Metric(3,4) + 2*P(1,5)*P(5,6)*Metric(2,6)*Metric(3,4) - 2*P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(4,2)*P(6,1)*Metric(1,2)*Metric(3,5) - P(4,3)*P(6,1)*Metric(1,2)*Metric(3,5) + P(4,6)*P(6,1)*Metric(1,2)*Metric(3,5) + P(4,1)*P(6,2)*Metric(1,2)*Metric(3,5) - P(4,3)*P(6,2)*Metric(1,2)*Metric(3,5) + P(4,6)*P(6,2)*Metric(1,2)*Metric(3,5) + P(4,1)*P(6,4)*Metric(1,2)*Metric(3,5) + P(4,2)*P(6,4)*Metric(1,2)*Metric(3,5) + 2*P(4,3)*P(6,4)*Metric(1,2)*Metric(3,5) + 2*P(4,3)*P(6,5)*Metric(1,2)*Metric(3,5) + 2*P(4,6)*P(6,5)*Metric(1,2)*Metric(3,5) - P(2,3)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,1)*P(6,2)*Metric(1,4)*Metric(3,5) - P(2,3)*P(6,2)*Metric(1,4)*Metric(3,5) - P(2,1)*P(6,4)*Metric(1,4)*Metric(3,5) - P(2,6)*P(6,4)*Metric(1,4)*Metric(3,5) - P(2,3)*P(6,5)*Metric(1,4)*Metric(3,5) - P(2,6)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,3)*P(4,1)*Metric(1,6)*Metric(3,5) - P(2,1)*P(4,2)*Metric(1,6)*Metric(3,5) - P(2,5)*P(4,2)*Metric(1,6)*Metric(3,5) + P(2,1)*P(4,3)*Metric(1,6)*Metric(3,5) - P(2,4)*P(4,3)*Metric(1,6)*Metric(3,5) - P(2,5)*P(4,3)*Metric(1,6)*Metric(3,5) - P(2,1)*P(4,6)*Metric(1,6)*Metric(3,5) - P(2,4)*P(4,6)*Metric(1,6)*Metric(3,5) + P(2,5)*P(4,6)*Metric(1,6)*Metric(3,5) - P(1,2)*P(6,1)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,1)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,2)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,6)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,5)*Metric(2,4)*Metric(3,5) - P(1,6)*P(6,5)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(1,2)*P(4,1)*Metric(2,6)*Metric(3,5) - P(1,5)*P(4,1)*Metric(2,6)*Metric(3,5) + P(1,3)*P(4,2)*Metric(2,6)*Metric(3,5) + P(1,2)*P(4,3)*Metric(2,6)*Metric(3,5) - P(1,4)*P(4,3)*Metric(2,6)*Metric(3,5) - P(1,5)*P(4,3)*Metric(2,6)*Metric(3,5) - P(1,2)*P(4,6)*Metric(2,6)*Metric(3,5) - P(1,4)*P(4,6)*Metric(2,6)*Metric(3,5) + P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(4,2)*P(5,1)*Metric(1,2)*Metric(3,6) - P(4,3)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,5)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,1)*P(5,2)*Metric(1,2)*Metric(3,6) - P(4,3)*P(5,2)*Metric(1,2)*Metric(3,6) + P(4,5)*P(5,2)*Metric(1,2)*Metric(3,6) + P(4,1)*P(5,4)*Metric(1,2)*Metric(3,6) + P(4,2)*P(5,4)*Metric(1,2)*Metric(3,6) + 2*P(4,3)*P(5,4)*Metric(1,2)*Metric(3,6) + 2*P(4,3)*P(5,6)*Metric(1,2)*Metric(3,6) + 2*P(4,5)*P(5,6)*Metric(1,2)*Metric(3,6) - P(2,3)*P(5,1)*Metric(1,4)*Metric(3,6) - P(2,1)*P(5,2)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,2)*Metric(1,4)*Metric(3,6) - P(2,1)*P(5,4)*Metric(1,4)*Metric(3,6) - P(2,5)*P(5,4)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,5)*P(5,6)*Metric(1,4)*Metric(3,6) + P(2,3)*P(4,1)*Metric(1,5)*Metric(3,6) - P(2,1)*P(4,2)*Metric(1,5)*Metric(3,6) - P(2,6)*P(4,2)*Metric(1,5)*Metric(3,6) + P(2,1)*P(4,3)*Metric(1,5)*Metric(3,6) - P(2,4)*P(4,3)*Metric(1,5)*Metric(3,6) - P(2,6)*P(4,3)*Metric(1,5)*Metric(3,6) - P(2,1)*P(4,5)*Metric(1,5)*Metric(3,6) - P(2,4)*P(4,5)*Metric(1,5)*Metric(3,6) + P(2,6)*P(4,5)*Metric(1,5)*Metric(3,6) - P(1,2)*P(5,1)*Metric(2,4)*Metric(3,6) - P(1,3)*P(5,1)*Metric(2,4)*Metric(3,6) - P(1,3)*P(5,2)*Metric(2,4)*Metric(3,6) - P(1,2)*P(5,4)*Metric(2,4)*Metric(3,6) - P(1,5)*P(5,4)*Metric(2,4)*Metric(3,6) - P(1,3)*P(5,6)*Metric(2,4)*Metric(3,6) - P(1,5)*P(5,6)*Metric(2,4)*Metric(3,6) + P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(1,2)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6) + P(1,3)*P(4,2)*Metric(2,5)*Metric(3,6) + P(1,2)*P(4,3)*Metric(2,5)*Metric(3,6) - P(1,4)*P(4,3)*Metric(2,5)*Metric(3,6) - P(1,6)*P(4,3)*Metric(2,5)*Metric(3,6) - P(1,2)*P(4,5)*Metric(2,5)*Metric(3,6) - P(1,4)*P(4,5)*Metric(2,5)*Metric(3,6) + P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(3,2)*P(6,1)*Metric(1,2)*Metric(4,5) - P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5) + P(3,6)*P(6,1)*Metric(1,2)*Metric(4,5) + P(3,1)*P(6,2)*Metric(1,2)*Metric(4,5) - P(3,4)*P(6,2)*Metric(1,2)*Metric(4,5) + P(3,6)*P(6,2)*Metric(1,2)*Metric(4,5) + P(3,1)*P(6,3)*Metric(1,2)*Metric(4,5) + P(3,2)*P(6,3)*Metric(1,2)*Metric(4,5) + 2*P(3,4)*P(6,3)*Metric(1,2)*Metric(4,5) + 2*P(3,4)*P(6,5)*Metric(1,2)*Metric(4,5) + 2*P(3,6)*P(6,5)*Metric(1,2)*Metric(4,5) - P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,1)*P(6,2)*Metric(1,3)*Metric(4,5) - P(2,4)*P(6,2)*Metric(1,3)*Metric(4,5) - P(2,1)*P(6,3)*Metric(1,3)*Metric(4,5) - P(2,6)*P(6,3)*Metric(1,3)*Metric(4,5) - P(2,4)*P(6,5)*Metric(1,3)*Metric(4,5) - P(2,6)*P(6,5)*Metric(1,3)*Metric(4,5) + P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5) - P(2,1)*P(3,2)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,2)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5) - P(2,3)*P(3,4)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,4)*Metric(1,6)*Metric(4,5) - P(2,1)*P(3,6)*Metric(1,6)*Metric(4,5) - P(2,3)*P(3,6)*Metric(1,6)*Metric(4,5) + P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) - P(1,2)*P(6,1)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,1)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,2)*P(6,3)*Metric(2,3)*Metric(4,5) - P(1,6)*P(6,3)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,5)*Metric(2,3)*Metric(4,5) - P(1,6)*P(6,5)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(1,2)*P(3,1)*Metric(2,6)*Metric(4,5) - P(1,5)*P(3,1)*Metric(2,6)*Metric(4,5) + P(1,4)*P(3,2)*Metric(2,6)*Metric(4,5) + P(1,2)*P(3,4)*Metric(2,6)*Metric(4,5) - P(1,3)*P(3,4)*Metric(2,6)*Metric(4,5) - P(1,5)*P(3,4)*Metric(2,6)*Metric(4,5) - P(1,2)*P(3,6)*Metric(2,6)*Metric(4,5) - P(1,3)*P(3,6)*Metric(2,6)*Metric(4,5) + P(1,5)*P(3,6)*Metric(2,6)*Metric(4,5) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(1,3)*P(2,1)*Metric(3,6)*Metric(4,5) + P(1,4)*P(2,1)*Metric(3,6)*Metric(4,5) + P(1,5)*P(2,1)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,1)*Metric(3,6)*Metric(4,5) + P(1,2)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,2)*P(2,4)*Metric(3,6)*Metric(4,5) + P(1,5)*P(2,4)*Metric(3,6)*Metric(4,5) + P(1,2)*P(2,5)*Metric(3,6)*Metric(4,5) + P(1,4)*P(2,5)*Metric(3,6)*Metric(4,5) - P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) + P(1,2)*P(2,6)*Metric(3,6)*Metric(4,5) + P(1,3)*P(2,6)*Metric(3,6)*Metric(4,5) - P(1,5)*P(2,6)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(3,2)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,4)*P(5,1)*Metric(1,2)*Metric(4,6) + P(3,5)*P(5,1)*Metric(1,2)*Metric(4,6) + P(3,1)*P(5,2)*Metric(1,2)*Metric(4,6) - P(3,4)*P(5,2)*Metric(1,2)*Metric(4,6) + P(3,5)*P(5,2)*Metric(1,2)*Metric(4,6) + P(3,1)*P(5,3)*Metric(1,2)*Metric(4,6) + P(3,2)*P(5,3)*Metric(1,2)*Metric(4,6) + 2*P(3,4)*P(5,3)*Metric(1,2)*Metric(4,6) + 2*P(3,4)*P(5,6)*Metric(1,2)*Metric(4,6) + 2*P(3,5)*P(5,6)*Metric(1,2)*Metric(4,6) - P(2,4)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,1)*P(5,2)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,2)*Metric(1,3)*Metric(4,6) - P(2,1)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,5)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,6)*Metric(1,3)*Metric(4,6) - P(2,5)*P(5,6)*Metric(1,3)*Metric(4,6) + P(2,4)*P(3,1)*Metric(1,5)*Metric(4,6) - P(2,1)*P(3,2)*Metric(1,5)*Metric(4,6) - P(2,6)*P(3,2)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,4)*Metric(1,5)*Metric(4,6) - P(2,3)*P(3,4)*Metric(1,5)*Metric(4,6) - P(2,6)*P(3,4)*Metric(1,5)*Metric(4,6) - P(2,1)*P(3,5)*Metric(1,5)*Metric(4,6) - P(2,3)*P(3,5)*Metric(1,5)*Metric(4,6) + P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) - P(1,2)*P(5,1)*Metric(2,3)*Metric(4,6) - P(1,4)*P(5,1)*Metric(2,3)*Metric(4,6) - P(1,4)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,2)*P(5,3)*Metric(2,3)*Metric(4,6) - P(1,5)*P(5,3)*Metric(2,3)*Metric(4,6) - P(1,4)*P(5,6)*Metric(2,3)*Metric(4,6) - P(1,5)*P(5,6)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(1,2)*P(3,1)*Metric(2,5)*Metric(4,6) - P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6) + P(1,4)*P(3,2)*Metric(2,5)*Metric(4,6) + P(1,2)*P(3,4)*Metric(2,5)*Metric(4,6) - P(1,3)*P(3,4)*Metric(2,5)*Metric(4,6) - P(1,6)*P(3,4)*Metric(2,5)*Metric(4,6) - P(1,2)*P(3,5)*Metric(2,5)*Metric(4,6) - P(1,3)*P(3,5)*Metric(2,5)*Metric(4,6) + P(1,6)*P(3,5)*Metric(2,5)*Metric(4,6) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(1,3)*P(2,1)*Metric(3,5)*Metric(4,6) + P(1,4)*P(2,1)*Metric(3,5)*Metric(4,6) + P(1,5)*P(2,1)*Metric(3,5)*Metric(4,6) + P(1,6)*P(2,1)*Metric(3,5)*Metric(4,6) + P(1,2)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,5)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,2)*P(2,4)*Metric(3,5)*Metric(4,6) + P(1,6)*P(2,4)*Metric(3,5)*Metric(4,6) + P(1,2)*P(2,5)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,5)*Metric(3,5)*Metric(4,6) - P(1,6)*P(2,5)*Metric(3,5)*Metric(4,6) + P(1,2)*P(2,6)*Metric(3,5)*Metric(4,6) + P(1,4)*P(2,6)*Metric(3,5)*Metric(4,6) - P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6) - P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(3,2)*P(4,1)*Metric(1,2)*Metric(5,6) - 2*P(3,4)*P(4,1)*Metric(1,2)*Metric(5,6) - 2*P(3,1)*P(4,2)*Metric(1,2)*Metric(5,6) - 2*P(3,4)*P(4,2)*Metric(1,2)*Metric(5,6) - 2*P(3,1)*P(4,3)*Metric(1,2)*Metric(5,6) - 2*P(3,2)*P(4,3)*Metric(1,2)*Metric(5,6) - 2*P(3,5)*P(4,3)*Metric(1,2)*Metric(5,6) - 2*P(3,6)*P(4,3)*Metric(1,2)*Metric(5,6) - 2*P(3,4)*P(4,5)*Metric(1,2)*Metric(5,6) - 2*P(3,6)*P(4,5)*Metric(1,2)*Metric(5,6) - 2*P(3,4)*P(4,6)*Metric(1,2)*Metric(5,6) - 2*P(3,5)*P(4,6)*Metric(1,2)*Metric(5,6) + 2*P(2,1)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,5)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,6)*P(4,2)*Metric(1,3)*Metric(5,6) + 2*P(2,1)*P(4,3)*Metric(1,3)*Metric(5,6) + 2*P(2,4)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,4)*P(4,5)*Metric(1,3)*Metric(5,6) + P(2,6)*P(4,5)*Metric(1,3)*Metric(5,6) + P(2,4)*P(4,6)*Metric(1,3)*Metric(5,6) + P(2,5)*P(4,6)*Metric(1,3)*Metric(5,6) + 2*P(2,1)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,5)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,2)*Metric(1,4)*Metric(5,6) + 2*P(2,1)*P(3,4)*Metric(1,4)*Metric(5,6) + 2*P(2,3)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,3)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,3)*P(3,6)*Metric(1,4)*Metric(5,6) + P(2,5)*P(3,6)*Metric(1,4)*Metric(5,6) + 2*P(1,2)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,5)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,1)*Metric(2,3)*Metric(5,6) + 2*P(1,2)*P(4,3)*Metric(2,3)*Metric(5,6) + 2*P(1,4)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,4)*P(4,5)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,5)*Metric(2,3)*Metric(5,6) + P(1,4)*P(4,6)*Metric(2,3)*Metric(5,6) + P(1,5)*P(4,6)*Metric(2,3)*Metric(5,6) - 2*P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + 2*P(1,2)*P(3,1)*Metric(2,4)*Metric(5,6) + P(1,5)*P(3,1)*Metric(2,4)*Metric(5,6) + P(1,6)*P(3,1)*Metric(2,4)*Metric(5,6) + 2*P(1,2)*P(3,4)*Metric(2,4)*Metric(5,6) + 2*P(1,3)*P(3,4)*Metric(2,4)*Metric(5,6) + P(1,3)*P(3,5)*Metric(2,4)*Metric(5,6) + P(1,6)*P(3,5)*Metric(2,4)*Metric(5,6) + P(1,3)*P(3,6)*Metric(2,4)*Metric(5,6) + P(1,5)*P(3,6)*Metric(2,4)*Metric(5,6) - 2*P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(1,3)*P(2,1)*Metric(3,4)*Metric(5,6) - 2*P(1,4)*P(2,1)*Metric(3,4)*Metric(5,6) - 2*P(1,5)*P(2,1)*Metric(3,4)*Metric(5,6) - 2*P(1,6)*P(2,1)*Metric(3,4)*Metric(5,6) - 2*P(1,2)*P(2,3)*Metric(3,4)*Metric(5,6) - 2*P(1,4)*P(2,3)*Metric(3,4)*Metric(5,6) - 2*P(1,2)*P(2,4)*Metric(3,4)*Metric(5,6) - 2*P(1,3)*P(2,4)*Metric(3,4)*Metric(5,6) - 2*P(1,2)*P(2,5)*Metric(3,4)*Metric(5,6) - 2*P(1,6)*P(2,5)*Metric(3,4)*Metric(5,6) - 2*P(1,2)*P(2,6)*Metric(3,4)*Metric(5,6) - 2*P(1,5)*P(2,6)*Metric(3,4)*Metric(5,6) + 2*P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV62 = Lorentz(name = 'VVVVVV62',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,6)*P(6,5)*Metric(1,4)*Metric(2,3) + P(4,6)*P(6,4)*Metric(1,5)*Metric(2,3) + P(4,5)*P(5,4)*Metric(1,6)*Metric(2,3) - (P(5,6)*P(6,5)*Metric(1,3)*Metric(2,4))/2. - (P(4,6)*P(6,4)*Metric(1,3)*Metric(2,5))/2. - (P(4,5)*P(5,4)*Metric(1,3)*Metric(2,6))/2. - (P(5,6)*P(6,5)*Metric(1,2)*Metric(3,4))/2. - (P(4,6)*P(6,4)*Metric(1,2)*Metric(3,5))/2. - (P(4,5)*P(5,4)*Metric(1,2)*Metric(3,6))/2. - P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. - P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + (P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + (P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + (P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVV63 = Lorentz(name = 'VVVVVV63',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,6)*P(6,5)*Metric(1,4)*Metric(2,3) + P(4,6)*P(6,4)*Metric(1,5)*Metric(2,3) + P(4,5)*P(5,4)*Metric(1,6)*Metric(2,3) - (P(5,6)*P(6,5)*Metric(1,3)*Metric(2,4))/2. - (P(4,6)*P(6,4)*Metric(1,3)*Metric(2,5))/2. - (P(4,5)*P(5,4)*Metric(1,3)*Metric(2,6))/2. - (P(5,6)*P(6,5)*Metric(1,2)*Metric(3,4))/2. - (P(1,6)*P(6,1)*Metric(2,5)*Metric(3,4))/2. + (P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(1,5)*P(5,1)*Metric(2,6)*Metric(3,4))/2. + (P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(4,6)*P(6,4)*Metric(1,2)*Metric(3,5))/2. - (P(1,6)*P(6,1)*Metric(2,4)*Metric(3,5))/2. + (P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(1,4)*P(4,1)*Metric(2,6)*Metric(3,5))/2. + (P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(4,5)*P(5,4)*Metric(1,2)*Metric(3,6))/2. - (P(1,5)*P(5,1)*Metric(2,4)*Metric(3,6))/2. + (P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(1,4)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + P(1,6)*P(6,1)*Metric(2,3)*Metric(4,5) - P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + P(1,5)*P(5,1)*Metric(2,3)*Metric(4,6) - P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + (P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + P(1,4)*P(4,1)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + (P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + (P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVV64 = Lorentz(name = 'VVVVVV64',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,1)*Metric(1,4)*Metric(2,3) + 2*P(5,4)*P(6,2)*Metric(1,4)*Metric(2,3) + 2*P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3) + 2*P(5,6)*P(6,5)*Metric(1,4)*Metric(2,3) + P(4,2)*P(6,1)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,1)*Metric(1,5)*Metric(2,3) + 2*P(4,5)*P(6,2)*Metric(1,5)*Metric(2,3) + 2*P(4,5)*P(6,3)*Metric(1,5)*Metric(2,3) + 2*P(4,6)*P(6,4)*Metric(1,5)*Metric(2,3) - P(4,2)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,3)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,3)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3) - 4*P(4,5)*P(5,4)*Metric(1,6)*Metric(2,3) - P(4,2)*P(5,6)*Metric(1,6)*Metric(2,3) - P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3) - P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4) - P(5,3)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) - P(5,6)*P(6,5)*Metric(1,3)*Metric(2,4) - P(3,2)*P(6,1)*Metric(1,5)*Metric(2,4) + P(3,5)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,6)*P(6,3)*Metric(1,5)*Metric(2,4) - P(3,5)*P(6,4)*Metric(1,5)*Metric(2,4) + P(3,2)*P(5,1)*Metric(1,6)*Metric(2,4) + 2*P(3,5)*P(5,3)*Metric(1,6)*Metric(2,4) + P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4) + P(3,6)*P(5,4)*Metric(1,6)*Metric(2,4) + P(3,2)*P(5,6)*Metric(1,6)*Metric(2,4) - P(4,5)*P(6,1)*Metric(1,3)*Metric(2,5) - P(4,3)*P(6,2)*Metric(1,3)*Metric(2,5) - P(4,6)*P(6,4)*Metric(1,3)*Metric(2,5) + P(4,3)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) + P(3,4)*P(6,2)*Metric(1,4)*Metric(2,5) - P(3,6)*P(6,3)*Metric(1,4)*Metric(2,5) - P(3,4)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) + 2*P(3,4)*P(4,3)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,2)*P(4,6)*Metric(1,6)*Metric(2,5) + 2*P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,3)*P(5,2)*Metric(1,3)*Metric(2,6) + P(4,2)*P(5,3)*Metric(1,3)*Metric(2,6) + 2*P(4,5)*P(5,4)*Metric(1,3)*Metric(2,6) + 2*P(4,1)*P(5,6)*Metric(1,3)*Metric(2,6) - P(3,4)*P(5,2)*Metric(1,4)*Metric(2,6) - P(3,5)*P(5,3)*Metric(1,4)*Metric(2,6) - 2*P(3,2)*P(5,4)*Metric(1,4)*Metric(2,6) - 2*P(3,1)*P(5,6)*Metric(1,4)*Metric(2,6) - P(3,5)*P(4,2)*Metric(1,5)*Metric(2,6) - P(3,4)*P(4,3)*Metric(1,5)*Metric(2,6) - 2*P(3,2)*P(4,5)*Metric(1,5)*Metric(2,6) - 2*P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) - P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4) - P(5,2)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,2)*P(6,4)*Metric(1,2)*Metric(3,4) - P(5,6)*P(6,5)*Metric(1,2)*Metric(3,4) - P(2,3)*P(6,1)*Metric(1,5)*Metric(3,4) - P(2,6)*P(6,2)*Metric(1,5)*Metric(3,4) + P(2,5)*P(6,3)*Metric(1,5)*Metric(3,4) - P(2,5)*P(6,4)*Metric(1,5)*Metric(3,4) + P(2,3)*P(5,1)*Metric(1,6)*Metric(3,4) + 2*P(2,5)*P(5,2)*Metric(1,6)*Metric(3,4) + P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4) + P(2,6)*P(5,4)*Metric(1,6)*Metric(3,4) + P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4) + 2*P(1,6)*P(6,1)*Metric(2,5)*Metric(3,4) + P(1,3)*P(6,2)*Metric(2,5)*Metric(3,4) - P(1,4)*P(6,2)*Metric(2,5)*Metric(3,4) + P(1,2)*P(6,3)*Metric(2,5)*Metric(3,4) - P(1,5)*P(6,3)*Metric(2,5)*Metric(3,4) - P(1,2)*P(6,4)*Metric(2,5)*Metric(3,4) + P(1,5)*P(6,4)*Metric(2,5)*Metric(3,4) - P(1,3)*P(6,5)*Metric(2,5)*Metric(3,4) + P(1,4)*P(6,5)*Metric(2,5)*Metric(3,4) - 2*P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(1,5)*P(5,1)*Metric(2,6)*Metric(3,4) - P(1,3)*P(5,2)*Metric(2,6)*Metric(3,4) + P(1,4)*P(5,2)*Metric(2,6)*Metric(3,4) - P(1,6)*P(5,4)*Metric(2,6)*Metric(3,4) + P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(4,5)*P(6,1)*Metric(1,2)*Metric(3,5) - P(4,2)*P(6,3)*Metric(1,2)*Metric(3,5) - P(4,6)*P(6,4)*Metric(1,2)*Metric(3,5) + P(4,2)*P(6,5)*Metric(1,2)*Metric(3,5) - P(2,3)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,6)*P(6,2)*Metric(1,4)*Metric(3,5) + P(2,4)*P(6,3)*Metric(1,4)*Metric(3,5) - P(2,4)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,3)*P(4,1)*Metric(1,6)*Metric(3,5) + 2*P(2,4)*P(4,2)*Metric(1,6)*Metric(3,5) + P(2,1)*P(4,5)*Metric(1,6)*Metric(3,5) + P(2,6)*P(4,5)*Metric(1,6)*Metric(3,5) + P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5) + 2*P(1,6)*P(6,1)*Metric(2,4)*Metric(3,5) + P(1,3)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,5)*P(6,2)*Metric(2,4)*Metric(3,5) + P(1,2)*P(6,3)*Metric(2,4)*Metric(3,5) - P(1,4)*P(6,3)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) + P(1,5)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,2)*P(6,5)*Metric(2,4)*Metric(3,5) + P(1,4)*P(6,5)*Metric(2,4)*Metric(3,5) - 2*P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(1,4)*P(4,1)*Metric(2,6)*Metric(3,5) - P(1,3)*P(4,2)*Metric(2,6)*Metric(3,5) + P(1,5)*P(4,2)*Metric(2,6)*Metric(3,5) - P(1,6)*P(4,5)*Metric(2,6)*Metric(3,5) + P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 2*P(4,6)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,3)*P(5,2)*Metric(1,2)*Metric(3,6) + P(4,2)*P(5,3)*Metric(1,2)*Metric(3,6) + 2*P(4,5)*P(5,4)*Metric(1,2)*Metric(3,6) + 2*P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) - P(2,5)*P(5,2)*Metric(1,4)*Metric(3,6) - P(2,4)*P(5,3)*Metric(1,4)*Metric(3,6) - 2*P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6) - 2*P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,4)*P(4,2)*Metric(1,5)*Metric(3,6) - P(2,5)*P(4,3)*Metric(1,5)*Metric(3,6) - 2*P(2,3)*P(4,5)*Metric(1,5)*Metric(3,6) - 2*P(2,1)*P(4,6)*Metric(1,5)*Metric(3,6) - P(1,5)*P(5,1)*Metric(2,4)*Metric(3,6) - P(1,2)*P(5,3)*Metric(2,4)*Metric(3,6) + P(1,4)*P(5,3)*Metric(2,4)*Metric(3,6) - P(1,6)*P(5,4)*Metric(2,4)*Metric(3,6) + P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(1,4)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,2)*P(4,3)*Metric(2,5)*Metric(3,6) + P(1,5)*P(4,3)*Metric(2,5)*Metric(3,6) - P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) + P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5) + P(3,5)*P(6,1)*Metric(1,2)*Metric(4,5) + 2*P(3,6)*P(6,3)*Metric(1,2)*Metric(4,5) + 2*P(3,2)*P(6,4)*Metric(1,2)*Metric(4,5) + 2*P(3,2)*P(6,5)*Metric(1,2)*Metric(4,5) + P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5) + P(2,5)*P(6,1)*Metric(1,3)*Metric(4,5) + 2*P(2,6)*P(6,2)*Metric(1,3)*Metric(4,5) + 2*P(2,3)*P(6,4)*Metric(1,3)*Metric(4,5) + 2*P(2,3)*P(6,5)*Metric(1,3)*Metric(4,5) - P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,1)*Metric(1,6)*Metric(4,5) - 4*P(2,3)*P(3,2)*Metric(1,6)*Metric(4,5) - P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5) - P(2,6)*P(3,4)*Metric(1,6)*Metric(4,5) - P(2,1)*P(3,5)*Metric(1,6)*Metric(4,5) - P(2,6)*P(3,5)*Metric(1,6)*Metric(4,5) - P(2,4)*P(3,6)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) - 4*P(1,6)*P(6,1)*Metric(2,3)*Metric(4,5) - 2*P(1,4)*P(6,2)*Metric(2,3)*Metric(4,5) - 2*P(1,5)*P(6,2)*Metric(2,3)*Metric(4,5) - 2*P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5) - 2*P(1,5)*P(6,3)*Metric(2,3)*Metric(4,5) - 2*P(1,2)*P(6,4)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*P(6,4)*Metric(2,3)*Metric(4,5) - 2*P(1,2)*P(6,5)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*P(6,5)*Metric(2,3)*Metric(4,5) + 4*P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 4*P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 4*P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(1,3)*P(3,1)*Metric(2,6)*Metric(4,5) + 2*P(1,4)*P(3,2)*Metric(2,6)*Metric(4,5) + 2*P(1,5)*P(3,2)*Metric(2,6)*Metric(4,5) + P(1,6)*P(3,4)*Metric(2,6)*Metric(4,5) + P(1,6)*P(3,5)*Metric(2,6)*Metric(4,5) - 2*P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) - 2*P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) - 2*P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(1,2)*P(2,1)*Metric(3,6)*Metric(4,5) + 2*P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5) + 2*P(1,5)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,4)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) - 2*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(3,6)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,4)*P(5,2)*Metric(1,2)*Metric(4,6) - P(3,5)*P(5,3)*Metric(1,2)*Metric(4,6) - 2*P(3,2)*P(5,4)*Metric(1,2)*Metric(4,6) - 2*P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,5)*P(5,2)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) - 2*P(2,3)*P(5,4)*Metric(1,3)*Metric(4,6) + 2*P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) + 2*P(2,3)*P(3,2)*Metric(1,5)*Metric(4,6) + P(2,5)*P(3,4)*Metric(1,5)*Metric(4,6) + P(2,4)*P(3,5)*Metric(1,5)*Metric(4,6) + 2*P(2,1)*P(3,6)*Metric(1,5)*Metric(4,6) + 2*P(1,5)*P(5,1)*Metric(2,3)*Metric(4,6) + P(1,6)*P(5,2)*Metric(2,3)*Metric(4,6) + P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6) + 2*P(1,2)*P(5,4)*Metric(2,3)*Metric(4,6) + 2*P(1,3)*P(5,4)*Metric(2,3)*Metric(4,6) - 2*P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) - 2*P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - 2*P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(1,3)*P(3,1)*Metric(2,5)*Metric(4,6) - P(1,6)*P(3,2)*Metric(2,5)*Metric(4,6) + P(1,2)*P(3,4)*Metric(2,5)*Metric(4,6) - P(1,5)*P(3,4)*Metric(2,5)*Metric(4,6) + P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(1,2)*P(2,1)*Metric(3,5)*Metric(4,6) - P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6) - P(1,5)*P(2,4)*Metric(3,5)*Metric(4,6) + P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,5)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,4)*P(4,3)*Metric(1,2)*Metric(5,6) - 2*P(3,2)*P(4,5)*Metric(1,2)*Metric(5,6) - 2*P(2,6)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,4)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,5)*P(4,3)*Metric(1,3)*Metric(5,6) - 2*P(2,3)*P(4,5)*Metric(1,3)*Metric(5,6) + 2*P(2,6)*P(3,1)*Metric(1,4)*Metric(5,6) + 2*P(2,3)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,5)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,4)*P(3,5)*Metric(1,4)*Metric(5,6) + 2*P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) + 2*P(1,4)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,2)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6) + 2*P(1,2)*P(4,5)*Metric(2,3)*Metric(5,6) + 2*P(1,3)*P(4,5)*Metric(2,3)*Metric(5,6) - 2*P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(1,3)*P(3,1)*Metric(2,4)*Metric(5,6) - P(1,6)*P(3,2)*Metric(2,4)*Metric(5,6) + P(1,2)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,4)*P(3,5)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(1,2)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6) + P(1,3)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,5)*Metric(3,4)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV65 = Lorentz(name = 'VVVVVV65',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,6)*P(6,5)*Metric(1,4)*Metric(2,3) + P(5,6)*P(6,5)*Metric(1,3)*Metric(2,4) - 2*P(5,6)*P(6,5)*Metric(1,2)*Metric(3,4) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV66 = Lorentz(name = 'VVVVVV66',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) - P(5,3)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,2)*Metric(1,4)*Metric(2,3) - P(5,4)*P(6,2)*Metric(1,4)*Metric(2,3) - P(5,1)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3) - P(5,2)*P(6,4)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,4)*Metric(1,4)*Metric(2,3) + P(5,6)*P(6,5)*Metric(1,4)*Metric(2,3) - P(4,1)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,5)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,1)*P(6,3)*Metric(1,5)*Metric(2,3) - P(4,5)*P(6,3)*Metric(1,5)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) + P(4,6)*P(5,2)*Metric(1,6)*Metric(2,3) + P(4,1)*P(5,3)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3) + P(5,2)*P(6,1)*Metric(1,3)*Metric(2,4) - P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) - P(5,3)*P(6,2)*Metric(1,3)*Metric(2,4) - P(5,2)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,3)*Metric(1,3)*Metric(2,4) - P(5,1)*P(6,4)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) + P(5,6)*P(6,5)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) + P(3,5)*P(6,2)*Metric(1,5)*Metric(2,4) + P(3,1)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,5)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,2)*Metric(1,6)*Metric(2,4) + P(3,6)*P(5,2)*Metric(1,6)*Metric(2,4) + P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4) - P(3,6)*P(5,4)*Metric(1,6)*Metric(2,4) - P(4,2)*P(6,1)*Metric(1,3)*Metric(2,5) + P(4,5)*P(6,1)*Metric(1,3)*Metric(2,5) + P(4,2)*P(6,3)*Metric(1,3)*Metric(2,5) - P(4,5)*P(6,3)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) + P(3,5)*P(6,1)*Metric(1,4)*Metric(2,5) + P(3,2)*P(6,4)*Metric(1,4)*Metric(2,5) - P(3,5)*P(6,4)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) - P(3,5)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,2)*Metric(1,6)*Metric(2,5) - P(3,6)*P(4,2)*Metric(1,6)*Metric(2,5) - P(3,1)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) - P(3,2)*P(4,6)*Metric(1,6)*Metric(2,5) + P(3,5)*P(4,6)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,2)*P(5,3)*Metric(1,3)*Metric(2,6) - P(4,6)*P(5,3)*Metric(1,3)*Metric(2,6) - P(3,2)*P(5,1)*Metric(1,4)*Metric(2,6) + P(3,6)*P(5,1)*Metric(1,4)*Metric(2,6) + P(3,2)*P(5,4)*Metric(1,4)*Metric(2,6) - P(3,6)*P(5,4)*Metric(1,4)*Metric(2,6) + P(3,2)*P(4,1)*Metric(1,5)*Metric(2,6) - P(3,6)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) - P(3,5)*P(4,2)*Metric(1,5)*Metric(2,6) - P(3,2)*P(4,5)*Metric(1,5)*Metric(2,6) + P(3,6)*P(4,5)*Metric(1,5)*Metric(2,6) - P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) + P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) - 2*P(5,6)*P(6,5)*Metric(1,2)*Metric(3,4) + P(2,3)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,5)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,3)*P(6,4)*Metric(1,4)*Metric(3,5) + P(2,5)*P(6,4)*Metric(1,4)*Metric(3,5) - P(2,3)*P(4,1)*Metric(1,6)*Metric(3,5) + P(2,5)*P(4,1)*Metric(1,6)*Metric(3,5) - P(2,4)*P(4,2)*Metric(1,6)*Metric(3,5) + P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5) - P(2,5)*P(4,6)*Metric(1,6)*Metric(3,5) + P(1,3)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,5)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) + P(1,5)*P(6,4)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(1,4)*P(4,1)*Metric(2,6)*Metric(3,5) - P(1,3)*P(4,2)*Metric(2,6)*Metric(3,5) + P(1,5)*P(4,2)*Metric(2,6)*Metric(3,5) + P(1,3)*P(4,6)*Metric(2,6)*Metric(3,5) - P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) + P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(2,3)*P(5,1)*Metric(1,4)*Metric(3,6) - P(2,6)*P(5,1)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6) + P(2,6)*P(5,4)*Metric(1,4)*Metric(3,6) - P(2,3)*P(4,1)*Metric(1,5)*Metric(3,6) + P(2,6)*P(4,1)*Metric(1,5)*Metric(3,6) - P(2,4)*P(4,2)*Metric(1,5)*Metric(3,6) + P(2,3)*P(4,5)*Metric(1,5)*Metric(3,6) - P(2,6)*P(4,5)*Metric(1,5)*Metric(3,6) + P(1,3)*P(5,2)*Metric(2,4)*Metric(3,6) - P(1,6)*P(5,2)*Metric(2,4)*Metric(3,6) - P(1,3)*P(5,4)*Metric(2,4)*Metric(3,6) + P(1,6)*P(5,4)*Metric(2,4)*Metric(3,6) + P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(1,4)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,3)*P(4,2)*Metric(2,5)*Metric(3,6) + P(1,6)*P(4,2)*Metric(2,5)*Metric(3,6) + P(1,3)*P(4,5)*Metric(2,5)*Metric(3,6) - P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) + P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,5)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,4)*P(6,3)*Metric(1,3)*Metric(4,5) + P(2,5)*P(6,3)*Metric(1,3)*Metric(4,5) - P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,5)*P(3,1)*Metric(1,6)*Metric(4,5) - P(2,3)*P(3,2)*Metric(1,6)*Metric(4,5) + P(2,4)*P(3,6)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) + P(1,4)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,5)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5) + P(1,5)*P(6,3)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(1,3)*P(3,1)*Metric(2,6)*Metric(4,5) - P(1,4)*P(3,2)*Metric(2,6)*Metric(4,5) + P(1,5)*P(3,2)*Metric(2,6)*Metric(4,5) + P(1,4)*P(3,6)*Metric(2,6)*Metric(4,5) - P(1,5)*P(3,6)*Metric(2,6)*Metric(4,5) + P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5) - P(1,5)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,3)*P(2,4)*Metric(3,6)*Metric(4,5) - P(1,6)*P(2,4)*Metric(3,6)*Metric(4,5) - P(1,3)*P(2,5)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) - P(1,4)*P(2,6)*Metric(3,6)*Metric(4,5) + P(1,5)*P(2,6)*Metric(3,6)*Metric(4,5) + P(2,4)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) + P(2,6)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,4)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) - P(2,3)*P(3,2)*Metric(1,5)*Metric(4,6) + P(2,4)*P(3,5)*Metric(1,5)*Metric(4,6) - P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) + P(1,4)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,4)*P(5,3)*Metric(2,3)*Metric(4,6) + P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6) + P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(1,3)*P(3,1)*Metric(2,5)*Metric(4,6) - P(1,4)*P(3,2)*Metric(2,5)*Metric(4,6) + P(1,6)*P(3,2)*Metric(2,5)*Metric(4,6) + P(1,4)*P(3,5)*Metric(2,5)*Metric(4,6) - P(1,6)*P(3,5)*Metric(2,5)*Metric(4,6) + P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(1,4)*P(2,3)*Metric(3,5)*Metric(4,6) - P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6) - P(1,5)*P(2,4)*Metric(3,5)*Metric(4,6) - P(1,4)*P(2,5)*Metric(3,5)*Metric(4,6) + P(1,6)*P(2,5)*Metric(3,5)*Metric(4,6) - P(1,3)*P(2,6)*Metric(3,5)*Metric(4,6) + P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6) + 2*P(2,4)*P(4,2)*Metric(1,3)*Metric(5,6) + 2*P(2,3)*P(3,2)*Metric(1,4)*Metric(5,6) + 2*P(1,4)*P(4,1)*Metric(2,3)*Metric(5,6) - 2*P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + 2*P(1,3)*P(3,1)*Metric(2,4)*Metric(5,6) - 2*P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV67 = Lorentz(name = 'VVVVVV67',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,6)*P(6,5)*Metric(1,4)*Metric(2,3) + P(5,6)*P(6,5)*Metric(1,3)*Metric(2,4) - 2*P(5,6)*P(6,5)*Metric(1,2)*Metric(3,4) - 2*P(2,6)*P(6,2)*Metric(1,5)*Metric(3,4) - 2*P(2,5)*P(5,2)*Metric(1,6)*Metric(3,4) - 2*P(1,6)*P(6,1)*Metric(2,5)*Metric(3,4) + 2*P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + 2*P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(1,5)*P(5,1)*Metric(2,6)*Metric(3,4) + 2*P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(2,6)*P(6,2)*Metric(1,4)*Metric(3,5) + P(1,6)*P(6,1)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(2,5)*P(5,2)*Metric(1,4)*Metric(3,6) + P(1,5)*P(5,1)*Metric(2,4)*Metric(3,6) - P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(2,6)*P(6,2)*Metric(1,3)*Metric(4,5) + P(1,6)*P(6,1)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(1,2)*P(2,1)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(2,5)*P(5,2)*Metric(1,3)*Metric(4,6) + P(1,5)*P(5,1)*Metric(2,3)*Metric(4,6) - P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(1,2)*P(2,1)*Metric(3,5)*Metric(4,6) - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(1,2)*P(2,1)*Metric(3,4)*Metric(5,6) + 2*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV68 = Lorentz(name = 'VVVVVV68',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,6)*P(6,5)*Metric(1,4)*Metric(2,3) + P(4,6)*P(6,4)*Metric(1,5)*Metric(2,3) + P(4,5)*P(5,4)*Metric(1,6)*Metric(2,3) + P(5,6)*P(6,5)*Metric(1,3)*Metric(2,4) + P(3,6)*P(6,3)*Metric(1,5)*Metric(2,4) + P(3,5)*P(5,3)*Metric(1,6)*Metric(2,4) + P(4,6)*P(6,4)*Metric(1,3)*Metric(2,5) + P(3,6)*P(6,3)*Metric(1,4)*Metric(2,5) + P(3,4)*P(4,3)*Metric(1,6)*Metric(2,5) + P(4,5)*P(5,4)*Metric(1,3)*Metric(2,6) + P(3,5)*P(5,3)*Metric(1,4)*Metric(2,6) + P(3,4)*P(4,3)*Metric(1,5)*Metric(2,6) - 2*P(5,6)*P(6,5)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(4,6)*P(6,4)*Metric(1,2)*Metric(3,5) - P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - 2*P(4,5)*P(5,4)*Metric(1,2)*Metric(3,6) - P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 2*P(3,6)*P(6,3)*Metric(1,2)*Metric(4,5) - P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(3,5)*P(5,3)*Metric(1,2)*Metric(4,6) - P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(3,4)*P(4,3)*Metric(1,2)*Metric(5,6) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV69 = Lorentz(name = 'VVVVVV69',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,2)*Metric(1,4)*Metric(2,3) + (P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3))/2. + (P(5,3)*P(6,4)*Metric(1,4)*Metric(2,3))/2. + P(5,6)*P(6,5)*Metric(1,4)*Metric(2,3) - P(4,1)*P(6,2)*Metric(1,5)*Metric(2,3) - (P(4,5)*P(6,3)*Metric(1,5)*Metric(2,3))/2. - (P(4,6)*P(6,4)*Metric(1,5)*Metric(2,3))/2. - P(4,3)*P(6,5)*Metric(1,5)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) - (P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3))/2. - (P(4,5)*P(5,4)*Metric(1,6)*Metric(2,3))/2. - P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,2)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) + (P(5,4)*P(6,3)*Metric(1,3)*Metric(2,4))/2. + (P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4))/2. + P(5,6)*P(6,5)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) - (P(3,6)*P(6,3)*Metric(1,5)*Metric(2,4))/2. - (P(3,5)*P(6,4)*Metric(1,5)*Metric(2,4))/2. - P(3,4)*P(6,5)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,2)*Metric(1,6)*Metric(2,4) - (P(3,5)*P(5,3)*Metric(1,6)*Metric(2,4))/2. - (P(3,6)*P(5,4)*Metric(1,6)*Metric(2,4))/2. - P(3,4)*P(5,6)*Metric(1,6)*Metric(2,4) - P(4,2)*P(6,1)*Metric(1,3)*Metric(2,5) - (P(4,5)*P(6,3)*Metric(1,3)*Metric(2,5))/2. - (P(4,6)*P(6,4)*Metric(1,3)*Metric(2,5))/2. - P(4,3)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) - (P(3,6)*P(6,3)*Metric(1,4)*Metric(2,5))/2. - (P(3,5)*P(6,4)*Metric(1,4)*Metric(2,5))/2. - P(3,4)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,2)*Metric(1,6)*Metric(2,5) + P(3,4)*P(4,3)*Metric(1,6)*Metric(2,5) + (P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5))/2. + (P(3,5)*P(4,6)*Metric(1,6)*Metric(2,5))/2. - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) - (P(4,6)*P(5,3)*Metric(1,3)*Metric(2,6))/2. - (P(4,5)*P(5,4)*Metric(1,3)*Metric(2,6))/2. - P(4,3)*P(5,6)*Metric(1,3)*Metric(2,6) - P(3,2)*P(5,1)*Metric(1,4)*Metric(2,6) - (P(3,5)*P(5,3)*Metric(1,4)*Metric(2,6))/2. - (P(3,6)*P(5,4)*Metric(1,4)*Metric(2,6))/2. - P(3,4)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,2)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) + P(3,4)*P(4,3)*Metric(1,5)*Metric(2,6) + (P(3,6)*P(4,5)*Metric(1,5)*Metric(2,6))/2. + (P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6))/2. - (P(5,3)*P(6,1)*Metric(1,2)*Metric(3,4))/2. - (P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4))/2. - (P(5,3)*P(6,2)*Metric(1,2)*Metric(3,4))/2. - (P(5,4)*P(6,2)*Metric(1,2)*Metric(3,4))/2. - (P(5,1)*P(6,3)*Metric(1,2)*Metric(3,4))/2. - (P(5,2)*P(6,3)*Metric(1,2)*Metric(3,4))/2. - (P(5,1)*P(6,4)*Metric(1,2)*Metric(3,4))/2. - (P(5,2)*P(6,4)*Metric(1,2)*Metric(3,4))/2. - 2*P(5,6)*P(6,5)*Metric(1,2)*Metric(3,4) + P(2,6)*P(6,2)*Metric(1,5)*Metric(3,4) + (P(2,1)*P(6,3)*Metric(1,5)*Metric(3,4))/2. + (P(2,1)*P(6,4)*Metric(1,5)*Metric(3,4))/2. + P(2,3)*P(6,5)*Metric(1,5)*Metric(3,4) + P(2,4)*P(6,5)*Metric(1,5)*Metric(3,4) + P(2,5)*P(5,2)*Metric(1,6)*Metric(3,4) + (P(2,1)*P(5,3)*Metric(1,6)*Metric(3,4))/2. + (P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4))/2. + P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4) + P(2,4)*P(5,6)*Metric(1,6)*Metric(3,4) + P(1,6)*P(6,1)*Metric(2,5)*Metric(3,4) + (P(1,2)*P(6,3)*Metric(2,5)*Metric(3,4))/2. + (P(1,2)*P(6,4)*Metric(2,5)*Metric(3,4))/2. + P(1,3)*P(6,5)*Metric(2,5)*Metric(3,4) + P(1,4)*P(6,5)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(1,5)*P(5,1)*Metric(2,6)*Metric(3,4) + (P(1,2)*P(5,3)*Metric(2,6)*Metric(3,4))/2. + (P(1,2)*P(5,4)*Metric(2,6)*Metric(3,4))/2. + P(1,3)*P(5,6)*Metric(2,6)*Metric(3,4) + P(1,4)*P(5,6)*Metric(2,6)*Metric(3,4) - P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + (P(4,3)*P(6,1)*Metric(1,2)*Metric(3,5))/2. + (P(4,3)*P(6,2)*Metric(1,2)*Metric(3,5))/2. + P(4,6)*P(6,4)*Metric(1,2)*Metric(3,5) + (P(4,1)*P(6,5)*Metric(1,2)*Metric(3,5))/2. + (P(4,2)*P(6,5)*Metric(1,2)*Metric(3,5))/2. - (P(2,6)*P(6,2)*Metric(1,4)*Metric(3,5))/2. - (P(2,3)*P(6,4)*Metric(1,4)*Metric(3,5))/2. + (P(2,5)*P(6,4)*Metric(1,4)*Metric(3,5))/2. - (P(2,1)*P(6,5)*Metric(1,4)*Metric(3,5))/2. - (P(2,4)*P(4,2)*Metric(1,6)*Metric(3,5))/2. - (P(2,1)*P(4,3)*Metric(1,6)*Metric(3,5))/2. + (P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5))/2. - (P(2,5)*P(4,6)*Metric(1,6)*Metric(3,5))/2. - (P(1,6)*P(6,1)*Metric(2,4)*Metric(3,5))/2. - (P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5))/2. + (P(1,5)*P(6,4)*Metric(2,4)*Metric(3,5))/2. - (P(1,2)*P(6,5)*Metric(2,4)*Metric(3,5))/2. + (P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(1,4)*P(4,1)*Metric(2,6)*Metric(3,5))/2. - (P(1,2)*P(4,3)*Metric(2,6)*Metric(3,5))/2. + (P(1,3)*P(4,6)*Metric(2,6)*Metric(3,5))/2. - (P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5))/2. + (P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(4,3)*P(5,1)*Metric(1,2)*Metric(3,6))/2. + (P(4,3)*P(5,2)*Metric(1,2)*Metric(3,6))/2. + P(4,5)*P(5,4)*Metric(1,2)*Metric(3,6) + (P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6))/2. + (P(4,2)*P(5,6)*Metric(1,2)*Metric(3,6))/2. - (P(2,5)*P(5,2)*Metric(1,4)*Metric(3,6))/2. - (P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6))/2. + (P(2,6)*P(5,4)*Metric(1,4)*Metric(3,6))/2. - (P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6))/2. - (P(2,4)*P(4,2)*Metric(1,5)*Metric(3,6))/2. - (P(2,1)*P(4,3)*Metric(1,5)*Metric(3,6))/2. + (P(2,3)*P(4,5)*Metric(1,5)*Metric(3,6))/2. - (P(2,6)*P(4,5)*Metric(1,5)*Metric(3,6))/2. - (P(1,5)*P(5,1)*Metric(2,4)*Metric(3,6))/2. - (P(1,3)*P(5,4)*Metric(2,4)*Metric(3,6))/2. + (P(1,6)*P(5,4)*Metric(2,4)*Metric(3,6))/2. - (P(1,2)*P(5,6)*Metric(2,4)*Metric(3,6))/2. + (P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(1,4)*P(4,1)*Metric(2,5)*Metric(3,6))/2. - (P(1,2)*P(4,3)*Metric(2,5)*Metric(3,6))/2. + (P(1,3)*P(4,5)*Metric(2,5)*Metric(3,6))/2. - (P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6))/2. + (P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5))/2. + (P(3,4)*P(6,2)*Metric(1,2)*Metric(4,5))/2. + P(3,6)*P(6,3)*Metric(1,2)*Metric(4,5) + (P(3,1)*P(6,5)*Metric(1,2)*Metric(4,5))/2. + (P(3,2)*P(6,5)*Metric(1,2)*Metric(4,5))/2. - (P(2,6)*P(6,2)*Metric(1,3)*Metric(4,5))/2. - (P(2,4)*P(6,3)*Metric(1,3)*Metric(4,5))/2. + (P(2,5)*P(6,3)*Metric(1,3)*Metric(4,5))/2. - (P(2,1)*P(6,5)*Metric(1,3)*Metric(4,5))/2. - (P(2,3)*P(3,2)*Metric(1,6)*Metric(4,5))/2. - (P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5))/2. + (P(2,4)*P(3,6)*Metric(1,6)*Metric(4,5))/2. - (P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5))/2. - (P(1,6)*P(6,1)*Metric(2,3)*Metric(4,5))/2. - (P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5))/2. + (P(1,5)*P(6,3)*Metric(2,3)*Metric(4,5))/2. - (P(1,2)*P(6,5)*Metric(2,3)*Metric(4,5))/2. + (P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(1,3)*P(3,1)*Metric(2,6)*Metric(4,5))/2. - (P(1,2)*P(3,4)*Metric(2,6)*Metric(4,5))/2. + (P(1,4)*P(3,6)*Metric(2,6)*Metric(4,5))/2. - (P(1,5)*P(3,6)*Metric(2,6)*Metric(4,5))/2. + (P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + P(1,2)*P(2,1)*Metric(3,6)*Metric(4,5) + (P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5))/2. - (P(1,5)*P(2,3)*Metric(3,6)*Metric(4,5))/2. + (P(1,3)*P(2,4)*Metric(3,6)*Metric(4,5))/2. - (P(1,6)*P(2,4)*Metric(3,6)*Metric(4,5))/2. - (P(1,3)*P(2,5)*Metric(3,6)*Metric(4,5))/2. + (P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5))/2. - (P(1,4)*P(2,6)*Metric(3,6)*Metric(4,5))/2. + (P(1,5)*P(2,6)*Metric(3,6)*Metric(4,5))/2. - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + (P(3,4)*P(5,1)*Metric(1,2)*Metric(4,6))/2. + (P(3,4)*P(5,2)*Metric(1,2)*Metric(4,6))/2. + P(3,5)*P(5,3)*Metric(1,2)*Metric(4,6) + (P(3,1)*P(5,6)*Metric(1,2)*Metric(4,6))/2. + (P(3,2)*P(5,6)*Metric(1,2)*Metric(4,6))/2. - (P(2,5)*P(5,2)*Metric(1,3)*Metric(4,6))/2. - (P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6))/2. + (P(2,6)*P(5,3)*Metric(1,3)*Metric(4,6))/2. - (P(2,1)*P(5,6)*Metric(1,3)*Metric(4,6))/2. - (P(2,3)*P(3,2)*Metric(1,5)*Metric(4,6))/2. - (P(2,1)*P(3,4)*Metric(1,5)*Metric(4,6))/2. + (P(2,4)*P(3,5)*Metric(1,5)*Metric(4,6))/2. - (P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6))/2. - (P(1,5)*P(5,1)*Metric(2,3)*Metric(4,6))/2. - (P(1,4)*P(5,3)*Metric(2,3)*Metric(4,6))/2. + (P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6))/2. - (P(1,2)*P(5,6)*Metric(2,3)*Metric(4,6))/2. + (P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(1,3)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - (P(1,2)*P(3,4)*Metric(2,5)*Metric(4,6))/2. + (P(1,4)*P(3,5)*Metric(2,5)*Metric(4,6))/2. - (P(1,6)*P(3,5)*Metric(2,5)*Metric(4,6))/2. + (P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(1,2)*P(2,1)*Metric(3,5)*Metric(4,6) + (P(1,4)*P(2,3)*Metric(3,5)*Metric(4,6))/2. - (P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6))/2. + (P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6))/2. - (P(1,5)*P(2,4)*Metric(3,5)*Metric(4,6))/2. - (P(1,4)*P(2,5)*Metric(3,5)*Metric(4,6))/2. + (P(1,6)*P(2,5)*Metric(3,5)*Metric(4,6))/2. - (P(1,3)*P(2,6)*Metric(3,5)*Metric(4,6))/2. + (P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6))/2. - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - (P(3,5)*P(4,1)*Metric(1,2)*Metric(5,6))/2. - (P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6))/2. - (P(3,5)*P(4,2)*Metric(1,2)*Metric(5,6))/2. - (P(3,6)*P(4,2)*Metric(1,2)*Metric(5,6))/2. - 2*P(3,4)*P(4,3)*Metric(1,2)*Metric(5,6) - (P(3,1)*P(4,5)*Metric(1,2)*Metric(5,6))/2. - (P(3,2)*P(4,5)*Metric(1,2)*Metric(5,6))/2. - (P(3,1)*P(4,6)*Metric(1,2)*Metric(5,6))/2. - (P(3,2)*P(4,6)*Metric(1,2)*Metric(5,6))/2. + P(2,4)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,5)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,6)*P(4,3)*Metric(1,3)*Metric(5,6) + (P(2,1)*P(4,5)*Metric(1,3)*Metric(5,6))/2. + (P(2,1)*P(4,6)*Metric(1,3)*Metric(5,6))/2. + P(2,3)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,5)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,4)*Metric(1,4)*Metric(5,6) + (P(2,1)*P(3,5)*Metric(1,4)*Metric(5,6))/2. + (P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6))/2. + P(1,4)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,5)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6) + (P(1,2)*P(4,5)*Metric(2,3)*Metric(5,6))/2. + (P(1,2)*P(4,6)*Metric(2,3)*Metric(5,6))/2. - P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(1,3)*P(3,1)*Metric(2,4)*Metric(5,6) + P(1,5)*P(3,4)*Metric(2,4)*Metric(5,6) + P(1,6)*P(3,4)*Metric(2,4)*Metric(5,6) + (P(1,2)*P(3,5)*Metric(2,4)*Metric(5,6))/2. + (P(1,2)*P(3,6)*Metric(2,4)*Metric(5,6))/2. - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(1,2)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,5)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,5)*P(2,4)*Metric(3,4)*Metric(5,6) - P(1,6)*P(2,4)*Metric(3,4)*Metric(5,6) - P(1,3)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,3)*P(2,6)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,6)*Metric(3,4)*Metric(5,6) + 2*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV70 = Lorentz(name = 'VVVVVV70',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) - P(5,3)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,2)*Metric(1,4)*Metric(2,3) - P(5,4)*P(6,2)*Metric(1,4)*Metric(2,3) - P(5,1)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3) - P(5,2)*P(6,4)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,4)*Metric(1,4)*Metric(2,3) + 2*P(5,6)*P(6,5)*Metric(1,4)*Metric(2,3) - P(4,1)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,1)*P(6,3)*Metric(1,5)*Metric(2,3) - P(4,6)*P(6,4)*Metric(1,5)*Metric(2,3) - P(4,3)*P(6,5)*Metric(1,5)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) + P(4,1)*P(5,3)*Metric(1,6)*Metric(2,3) - P(4,5)*P(5,4)*Metric(1,6)*Metric(2,3) - P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,2)*P(6,1)*Metric(1,3)*Metric(2,4) - P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) - P(5,3)*P(6,2)*Metric(1,3)*Metric(2,4) - P(5,2)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,3)*Metric(1,3)*Metric(2,4) - P(5,1)*P(6,4)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) + 2*P(5,6)*P(6,5)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,6)*P(6,3)*Metric(1,5)*Metric(2,4) + P(3,1)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,4)*P(6,5)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,2)*Metric(1,6)*Metric(2,4) - P(3,5)*P(5,3)*Metric(1,6)*Metric(2,4) + P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4) - P(3,4)*P(5,6)*Metric(1,6)*Metric(2,4) - P(4,2)*P(6,1)*Metric(1,3)*Metric(2,5) + P(4,2)*P(6,3)*Metric(1,3)*Metric(2,5) - P(4,6)*P(6,4)*Metric(1,3)*Metric(2,5) - P(4,3)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,6)*P(6,3)*Metric(1,4)*Metric(2,5) + P(3,2)*P(6,4)*Metric(1,4)*Metric(2,5) - P(3,4)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,2)*Metric(1,6)*Metric(2,5) + 2*P(3,4)*P(4,3)*Metric(1,6)*Metric(2,5) + 2*P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) + 2*P(3,5)*P(4,6)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,2)*P(5,3)*Metric(1,3)*Metric(2,6) - P(4,5)*P(5,4)*Metric(1,3)*Metric(2,6) - P(4,3)*P(5,6)*Metric(1,3)*Metric(2,6) - P(3,2)*P(5,1)*Metric(1,4)*Metric(2,6) - P(3,5)*P(5,3)*Metric(1,4)*Metric(2,6) + P(3,2)*P(5,4)*Metric(1,4)*Metric(2,6) - P(3,4)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,2)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) + 2*P(3,4)*P(4,3)*Metric(1,5)*Metric(2,6) + 2*P(3,6)*P(4,5)*Metric(1,5)*Metric(2,6) + 2*P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) - 2*P(5,3)*P(6,1)*Metric(1,2)*Metric(3,4) - 2*P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4) - 2*P(5,3)*P(6,2)*Metric(1,2)*Metric(3,4) - 2*P(5,4)*P(6,2)*Metric(1,2)*Metric(3,4) - 2*P(5,1)*P(6,3)*Metric(1,2)*Metric(3,4) - 2*P(5,2)*P(6,3)*Metric(1,2)*Metric(3,4) - 2*P(5,1)*P(6,4)*Metric(1,2)*Metric(3,4) - 2*P(5,2)*P(6,4)*Metric(1,2)*Metric(3,4) - 4*P(5,6)*P(6,5)*Metric(1,2)*Metric(3,4) + 2*P(2,6)*P(6,2)*Metric(1,5)*Metric(3,4) + 2*P(2,1)*P(6,3)*Metric(1,5)*Metric(3,4) + 2*P(2,1)*P(6,4)*Metric(1,5)*Metric(3,4) + P(2,3)*P(6,5)*Metric(1,5)*Metric(3,4) + P(2,4)*P(6,5)*Metric(1,5)*Metric(3,4) + 2*P(2,5)*P(5,2)*Metric(1,6)*Metric(3,4) + 2*P(2,1)*P(5,3)*Metric(1,6)*Metric(3,4) + 2*P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4) + P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4) + P(2,4)*P(5,6)*Metric(1,6)*Metric(3,4) + 2*P(1,6)*P(6,1)*Metric(2,5)*Metric(3,4) + 2*P(1,2)*P(6,3)*Metric(2,5)*Metric(3,4) + 2*P(1,2)*P(6,4)*Metric(2,5)*Metric(3,4) + P(1,3)*P(6,5)*Metric(2,5)*Metric(3,4) + P(1,4)*P(6,5)*Metric(2,5)*Metric(3,4) - 2*P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + 2*P(1,5)*P(5,1)*Metric(2,6)*Metric(3,4) + 2*P(1,2)*P(5,3)*Metric(2,6)*Metric(3,4) + 2*P(1,2)*P(5,4)*Metric(2,6)*Metric(3,4) + P(1,3)*P(5,6)*Metric(2,6)*Metric(3,4) + P(1,4)*P(5,6)*Metric(2,6)*Metric(3,4) - 2*P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(4,3)*P(6,1)*Metric(1,2)*Metric(3,5) + 2*P(4,3)*P(6,2)*Metric(1,2)*Metric(3,5) + 2*P(4,6)*P(6,4)*Metric(1,2)*Metric(3,5) + P(4,1)*P(6,5)*Metric(1,2)*Metric(3,5) + P(4,2)*P(6,5)*Metric(1,2)*Metric(3,5) + P(2,3)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,6)*P(6,2)*Metric(1,4)*Metric(3,5) - P(2,3)*P(6,4)*Metric(1,4)*Metric(3,5) - P(2,1)*P(6,5)*Metric(1,4)*Metric(3,5) - P(2,3)*P(4,1)*Metric(1,6)*Metric(3,5) - P(2,4)*P(4,2)*Metric(1,6)*Metric(3,5) - 2*P(2,1)*P(4,3)*Metric(1,6)*Metric(3,5) - 2*P(2,5)*P(4,6)*Metric(1,6)*Metric(3,5) - P(1,6)*P(6,1)*Metric(2,4)*Metric(3,5) + P(1,3)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,2)*P(6,5)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(1,4)*P(4,1)*Metric(2,6)*Metric(3,5) - P(1,3)*P(4,2)*Metric(2,6)*Metric(3,5) - 2*P(1,2)*P(4,3)*Metric(2,6)*Metric(3,5) - 2*P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) + P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 2*P(4,3)*P(5,1)*Metric(1,2)*Metric(3,6) + 2*P(4,3)*P(5,2)*Metric(1,2)*Metric(3,6) + 2*P(4,5)*P(5,4)*Metric(1,2)*Metric(3,6) + P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) + P(4,2)*P(5,6)*Metric(1,2)*Metric(3,6) + P(2,3)*P(5,1)*Metric(1,4)*Metric(3,6) - P(2,5)*P(5,2)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6) - P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,3)*P(4,1)*Metric(1,5)*Metric(3,6) - P(2,4)*P(4,2)*Metric(1,5)*Metric(3,6) - 2*P(2,1)*P(4,3)*Metric(1,5)*Metric(3,6) - 2*P(2,6)*P(4,5)*Metric(1,5)*Metric(3,6) - P(1,5)*P(5,1)*Metric(2,4)*Metric(3,6) + P(1,3)*P(5,2)*Metric(2,4)*Metric(3,6) - P(1,3)*P(5,4)*Metric(2,4)*Metric(3,6) - P(1,2)*P(5,6)*Metric(2,4)*Metric(3,6) + P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(1,4)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,3)*P(4,2)*Metric(2,5)*Metric(3,6) - 2*P(1,2)*P(4,3)*Metric(2,5)*Metric(3,6) - 2*P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) + P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5) + 2*P(3,4)*P(6,2)*Metric(1,2)*Metric(4,5) + 2*P(3,6)*P(6,3)*Metric(1,2)*Metric(4,5) + P(3,1)*P(6,5)*Metric(1,2)*Metric(4,5) + P(3,2)*P(6,5)*Metric(1,2)*Metric(4,5) + P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,6)*P(6,2)*Metric(1,3)*Metric(4,5) - P(2,4)*P(6,3)*Metric(1,3)*Metric(4,5) - P(2,1)*P(6,5)*Metric(1,3)*Metric(4,5) - P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5) - P(2,3)*P(3,2)*Metric(1,6)*Metric(4,5) - 2*P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5) - 2*P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) - P(1,6)*P(6,1)*Metric(2,3)*Metric(4,5) + P(1,4)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5) - P(1,2)*P(6,5)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(1,3)*P(3,1)*Metric(2,6)*Metric(4,5) - P(1,4)*P(3,2)*Metric(2,6)*Metric(4,5) - 2*P(1,2)*P(3,4)*Metric(2,6)*Metric(4,5) - 2*P(1,5)*P(3,6)*Metric(2,6)*Metric(4,5) + P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(1,2)*P(2,1)*Metric(3,6)*Metric(4,5) + P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,3)*P(2,4)*Metric(3,6)*Metric(4,5) + 2*P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) + 2*P(1,5)*P(2,6)*Metric(3,6)*Metric(4,5) - 2*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(3,4)*P(5,1)*Metric(1,2)*Metric(4,6) + 2*P(3,4)*P(5,2)*Metric(1,2)*Metric(4,6) + 2*P(3,5)*P(5,3)*Metric(1,2)*Metric(4,6) + P(3,1)*P(5,6)*Metric(1,2)*Metric(4,6) + P(3,2)*P(5,6)*Metric(1,2)*Metric(4,6) + P(2,4)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,5)*P(5,2)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,1)*P(5,6)*Metric(1,3)*Metric(4,6) - P(2,4)*P(3,1)*Metric(1,5)*Metric(4,6) - P(2,3)*P(3,2)*Metric(1,5)*Metric(4,6) - 2*P(2,1)*P(3,4)*Metric(1,5)*Metric(4,6) - 2*P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) - P(1,5)*P(5,1)*Metric(2,3)*Metric(4,6) + P(1,4)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,4)*P(5,3)*Metric(2,3)*Metric(4,6) - P(1,2)*P(5,6)*Metric(2,3)*Metric(4,6) + P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(1,3)*P(3,1)*Metric(2,5)*Metric(4,6) - P(1,4)*P(3,2)*Metric(2,5)*Metric(4,6) - 2*P(1,2)*P(3,4)*Metric(2,5)*Metric(4,6) - 2*P(1,6)*P(3,5)*Metric(2,5)*Metric(4,6) + P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(1,2)*P(2,1)*Metric(3,5)*Metric(4,6) + P(1,4)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6) + 2*P(1,6)*P(2,5)*Metric(3,5)*Metric(4,6) + 2*P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6) - 2*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(3,5)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,5)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,2)*Metric(1,2)*Metric(5,6) - 4*P(3,4)*P(4,3)*Metric(1,2)*Metric(5,6) - P(3,1)*P(4,5)*Metric(1,2)*Metric(5,6) - P(3,2)*P(4,5)*Metric(1,2)*Metric(5,6) - P(3,1)*P(4,6)*Metric(1,2)*Metric(5,6) - P(3,2)*P(4,6)*Metric(1,2)*Metric(5,6) + 2*P(2,4)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,5)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,6)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,1)*P(4,5)*Metric(1,3)*Metric(5,6) + P(2,1)*P(4,6)*Metric(1,3)*Metric(5,6) + 2*P(2,3)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,5)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) + 2*P(1,4)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,5)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,2)*P(4,5)*Metric(2,3)*Metric(5,6) + P(1,2)*P(4,6)*Metric(2,3)*Metric(5,6) - 2*P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + 2*P(1,3)*P(3,1)*Metric(2,4)*Metric(5,6) + P(1,5)*P(3,4)*Metric(2,4)*Metric(5,6) + P(1,6)*P(3,4)*Metric(2,4)*Metric(5,6) + P(1,2)*P(3,5)*Metric(2,4)*Metric(5,6) + P(1,2)*P(3,6)*Metric(2,4)*Metric(5,6) - 2*P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 4*P(1,2)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,5)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,5)*P(2,4)*Metric(3,4)*Metric(5,6) - P(1,6)*P(2,4)*Metric(3,4)*Metric(5,6) - P(1,3)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,3)*P(2,6)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,6)*Metric(3,4)*Metric(5,6) + 4*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 4*P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 4*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVSSSS1 = Lorentz(name = 'VVVSSSS1',
                   spins = [ 3, 3, 3, 1, 1, 1, 1 ],
                   structure = 'P(2,4)*Metric(1,3) + P(2,5)*Metric(1,3) + P(2,6)*Metric(1,3) + P(2,7)*Metric(1,3) - P(1,4)*Metric(2,3) - P(1,5)*Metric(2,3) - P(1,6)*Metric(2,3) - P(1,7)*Metric(2,3)')

VVVVSSS1 = Lorentz(name = 'VVVVSSS1',
                   spins = [ 3, 3, 3, 3, 1, 1, 1 ],
                   structure = 'Metric(1,4)*Metric(2,3) + Metric(1,3)*Metric(2,4)')

VVVVSSS2 = Lorentz(name = 'VVVVSSS2',
                   spins = [ 3, 3, 3, 3, 1, 1, 1 ],
                   structure = 'Metric(1,2)*Metric(3,4)')

VVVVSSS3 = Lorentz(name = 'VVVVSSS3',
                   spins = [ 3, 3, 3, 3, 1, 1, 1 ],
                   structure = 'Metric(1,4)*Metric(2,3) + Metric(1,3)*Metric(2,4) + Metric(1,2)*Metric(3,4)')

VVVVVSS1 = Lorentz(name = 'VVVVVSS1',
                   spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5)')

VVVVVSS2 = Lorentz(name = 'VVVVVSS2',
                   spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5)')

VVVVVSS3 = Lorentz(name = 'VVVVVSS3',
                   spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(4,3)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(2,5)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,4)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5)')

VVVVVSS4 = Lorentz(name = 'VVVVVSS4',
                   spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) + 4*P(3,1)*Metric(1,2)*Metric(4,5) - 4*P(2,1)*Metric(1,3)*Metric(4,5)')

VVVVVSS5 = Lorentz(name = 'VVVVVSS5',
                   spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(2,5)*Metric(1,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,4)*Metric(1,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(3,1)*Metric(1,2)*Metric(4,5) - 2*P(2,1)*Metric(1,3)*Metric(4,5)')

VVVVVSS6 = Lorentz(name = 'VVVVVSS6',
                   spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5)')

VVVVVSS7 = Lorentz(name = 'VVVVVSS7',
                   spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,5)*Metric(1,5)*Metric(2,4) + P(3,4)*Metric(1,4)*Metric(2,5) - P(2,5)*Metric(1,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) - P(2,4)*Metric(1,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5)')

VVVVVSS8 = Lorentz(name = 'VVVVVSS8',
                   spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - (P(5,4)*Metric(1,3)*Metric(2,4))/2. - P(3,1)*Metric(1,5)*Metric(2,4) - P(3,4)*Metric(1,5)*Metric(2,4) + (P(3,5)*Metric(1,5)*Metric(2,4))/2. + P(4,1)*Metric(1,3)*Metric(2,5) - (P(4,5)*Metric(1,3)*Metric(2,5))/2. - P(3,1)*Metric(1,4)*Metric(2,5) + (P(3,4)*Metric(1,4)*Metric(2,5))/2. - P(3,5)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + (P(5,4)*Metric(1,2)*Metric(3,4))/2. + P(2,1)*Metric(1,5)*Metric(3,4) + P(2,4)*Metric(1,5)*Metric(3,4) - (P(2,5)*Metric(1,5)*Metric(3,4))/2. - (P(1,4)*Metric(2,5)*Metric(3,4))/2. + (P(1,5)*Metric(2,5)*Metric(3,4))/2. - P(4,1)*Metric(1,2)*Metric(3,5) + (P(4,5)*Metric(1,2)*Metric(3,5))/2. + P(2,1)*Metric(1,4)*Metric(3,5) - (P(2,4)*Metric(1,4)*Metric(3,5))/2. + P(2,5)*Metric(1,4)*Metric(3,5) + (P(1,4)*Metric(2,4)*Metric(3,5))/2. - (P(1,5)*Metric(2,4)*Metric(3,5))/2. + 2*P(3,1)*Metric(1,2)*Metric(4,5) - (P(3,4)*Metric(1,2)*Metric(4,5))/2. - (P(3,5)*Metric(1,2)*Metric(4,5))/2. - 2*P(2,1)*Metric(1,3)*Metric(4,5) + (P(2,4)*Metric(1,3)*Metric(4,5))/2. + (P(2,5)*Metric(1,3)*Metric(4,5))/2.')

VVVVVSS9 = Lorentz(name = 'VVVVVSS9',
                   spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) - 2*P(3,4)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(4,5)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(3,5)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(5,4)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) + 2*P(2,4)*Metric(1,5)*Metric(3,4) - P(2,5)*Metric(1,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(4,5)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,4)*Metric(1,4)*Metric(3,5) + 2*P(2,5)*Metric(1,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) - P(3,4)*Metric(1,2)*Metric(4,5) - P(3,5)*Metric(1,2)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) + P(2,5)*Metric(1,3)*Metric(4,5)')

VVVVVSS10 = Lorentz(name = 'VVVVVSS10',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - 3*P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(5,6)*Metric(1,3)*Metric(2,4) + P(5,7)*Metric(1,3)*Metric(2,4) + 3*P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - 2*P(3,4)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) - P(3,6)*Metric(1,5)*Metric(2,4) - P(3,7)*Metric(1,5)*Metric(2,4) - 3*P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) + P(4,6)*Metric(1,3)*Metric(2,5) + P(4,7)*Metric(1,3)*Metric(2,5) + 3*P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(3,5)*Metric(1,4)*Metric(2,5) - P(3,6)*Metric(1,4)*Metric(2,5) - P(3,7)*Metric(1,4)*Metric(2,5) + 3*P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(5,4)*Metric(1,2)*Metric(3,4) - P(5,6)*Metric(1,2)*Metric(3,4) - P(5,7)*Metric(1,2)*Metric(3,4) - 3*P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + 2*P(2,4)*Metric(1,5)*Metric(3,4) - P(2,5)*Metric(1,5)*Metric(3,4) + P(2,6)*Metric(1,5)*Metric(3,4) + P(2,7)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) + 3*P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(4,5)*Metric(1,2)*Metric(3,5) - P(4,6)*Metric(1,2)*Metric(3,5) - P(4,7)*Metric(1,2)*Metric(3,5) - 3*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - P(2,4)*Metric(1,4)*Metric(3,5) + 2*P(2,5)*Metric(1,4)*Metric(3,5) + P(2,6)*Metric(1,4)*Metric(3,5) + P(2,7)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) - 4*P(3,1)*Metric(1,2)*Metric(4,5) + P(3,4)*Metric(1,2)*Metric(4,5) + P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(3,6)*Metric(1,2)*Metric(4,5) + 2*P(3,7)*Metric(1,2)*Metric(4,5) + 4*P(2,1)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(2,6)*Metric(1,3)*Metric(4,5) - 2*P(2,7)*Metric(1,3)*Metric(4,5)')

VVVVVSS11 = Lorentz(name = 'VVVVVSS11',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + (P(5,4)*Metric(1,3)*Metric(2,4))/2. + (P(5,6)*Metric(1,3)*Metric(2,4))/2. + (P(5,7)*Metric(1,3)*Metric(2,4))/2. + 2*P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(3,4)*Metric(1,5)*Metric(2,4) + (P(3,5)*Metric(1,5)*Metric(2,4))/2. - (P(3,6)*Metric(1,5)*Metric(2,4))/2. - (P(3,7)*Metric(1,5)*Metric(2,4))/2. - 2*P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + (P(4,5)*Metric(1,3)*Metric(2,5))/2. + (P(4,6)*Metric(1,3)*Metric(2,5))/2. + (P(4,7)*Metric(1,3)*Metric(2,5))/2. + 2*P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + (P(3,4)*Metric(1,4)*Metric(2,5))/2. - P(3,5)*Metric(1,4)*Metric(2,5) - (P(3,6)*Metric(1,4)*Metric(2,5))/2. - (P(3,7)*Metric(1,4)*Metric(2,5))/2. + 2*P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - (P(5,4)*Metric(1,2)*Metric(3,4))/2. - (P(5,6)*Metric(1,2)*Metric(3,4))/2. - (P(5,7)*Metric(1,2)*Metric(3,4))/2. - 2*P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + P(2,4)*Metric(1,5)*Metric(3,4) - (P(2,5)*Metric(1,5)*Metric(3,4))/2. + (P(2,6)*Metric(1,5)*Metric(3,4))/2. + (P(2,7)*Metric(1,5)*Metric(3,4))/2. + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - (P(1,4)*Metric(2,5)*Metric(3,4))/2. + (P(1,5)*Metric(2,5)*Metric(3,4))/2. + 2*P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - (P(4,5)*Metric(1,2)*Metric(3,5))/2. - (P(4,6)*Metric(1,2)*Metric(3,5))/2. - (P(4,7)*Metric(1,2)*Metric(3,5))/2. - 2*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - (P(2,4)*Metric(1,4)*Metric(3,5))/2. + P(2,5)*Metric(1,4)*Metric(3,5) + (P(2,6)*Metric(1,4)*Metric(3,5))/2. + (P(2,7)*Metric(1,4)*Metric(3,5))/2. + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5) + (P(1,4)*Metric(2,4)*Metric(3,5))/2. - (P(1,5)*Metric(2,4)*Metric(3,5))/2. - 2*P(3,1)*Metric(1,2)*Metric(4,5) + (P(3,4)*Metric(1,2)*Metric(4,5))/2. + (P(3,5)*Metric(1,2)*Metric(4,5))/2. + P(3,6)*Metric(1,2)*Metric(4,5) + P(3,7)*Metric(1,2)*Metric(4,5) + 2*P(2,1)*Metric(1,3)*Metric(4,5) - (P(2,4)*Metric(1,3)*Metric(4,5))/2. - (P(2,5)*Metric(1,3)*Metric(4,5))/2. - P(2,6)*Metric(1,3)*Metric(4,5) - P(2,7)*Metric(1,3)*Metric(4,5)')

VVVVVSS12 = Lorentz(name = 'VVVVVSS12',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) - P(3,1)*Metric(1,2)*Metric(4,5) - P(3,2)*Metric(1,2)*Metric(4,5) + P(2,1)*Metric(1,3)*Metric(4,5) + P(1,2)*Metric(2,3)*Metric(4,5)')

VVVVVSS13 = Lorentz(name = 'VVVVVSS13',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,1)*Metric(1,4)*Metric(2,3) - P(5,2)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) - 2*P(4,2)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) + 2*P(3,2)*Metric(1,5)*Metric(2,4) - 2*P(4,1)*Metric(1,3)*Metric(2,5) - P(4,2)*Metric(1,3)*Metric(2,5) + 2*P(3,1)*Metric(1,4)*Metric(2,5) + P(3,2)*Metric(1,4)*Metric(2,5) + P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) - P(3,1)*Metric(1,2)*Metric(4,5) - P(3,2)*Metric(1,2)*Metric(4,5) + P(2,1)*Metric(1,3)*Metric(4,5) + P(1,2)*Metric(2,3)*Metric(4,5)')

VVVVVSS14 = Lorentz(name = 'VVVVVSS14',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(2,5)*Metric(1,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) + P(2,4)*Metric(1,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) + P(2,3)*Metric(1,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5)')

VVVVVSS15 = Lorentz(name = 'VVVVVSS15',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(3,1)*Metric(1,2)*Metric(4,5) - P(3,2)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) + P(2,3)*Metric(1,3)*Metric(4,5) + P(1,2)*Metric(2,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5)')

VVVVVSS16 = Lorentz(name = 'VVVVVSS16',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(2,5)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,4)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) - P(3,2)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) + P(2,3)*Metric(1,3)*Metric(4,5) + P(1,2)*Metric(2,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5)')

VVVVVSS17 = Lorentz(name = 'VVVVVSS17',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(5,1)*Metric(1,2)*Metric(3,4) - 2*P(5,2)*Metric(1,2)*Metric(3,4) + 2*P(5,3)*Metric(1,2)*Metric(3,4) + 2*P(5,4)*Metric(1,2)*Metric(3,4) + 2*P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 2*P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) - 2*P(4,3)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) - 2*P(3,4)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5)')

VVVVVSS18 = Lorentz(name = 'VVVVVSS18',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) - P(4,3)*Metric(1,5)*Metric(2,3) + 2*P(4,5)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) - P(3,4)*Metric(1,5)*Metric(2,4) + 2*P(3,5)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) - P(4,3)*Metric(1,3)*Metric(2,5) + 2*P(4,5)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + 2*P(3,5)*Metric(1,4)*Metric(2,5) + 2*P(5,1)*Metric(1,2)*Metric(3,4) + 2*P(5,2)*Metric(1,2)*Metric(3,4) - 2*P(5,3)*Metric(1,2)*Metric(3,4) - 2*P(5,4)*Metric(1,2)*Metric(3,4) - 2*P(2,1)*Metric(1,5)*Metric(3,4) + P(2,3)*Metric(1,5)*Metric(3,4) + P(2,4)*Metric(1,5)*Metric(3,4) - 2*P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) + 2*P(4,3)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) - 2*P(2,5)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - 2*P(1,5)*Metric(2,4)*Metric(3,5) - P(3,1)*Metric(1,2)*Metric(4,5) - P(3,2)*Metric(1,2)*Metric(4,5) + 2*P(3,4)*Metric(1,2)*Metric(4,5) + P(2,1)*Metric(1,3)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) - 2*P(2,5)*Metric(1,3)*Metric(4,5) + P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) - 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS19 = Lorentz(name = 'VVVVVSS19',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(4,5)*Metric(1,5)*Metric(2,3) + P(3,5)*Metric(1,5)*Metric(2,4) + P(4,5)*Metric(1,3)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,5)*Metric(1,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) - P(2,5)*Metric(1,3)*Metric(4,5) - P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS20 = Lorentz(name = 'VVVVVSS20',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + P(4,5)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(3,5)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) + P(2,3)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) + P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) - P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS21 = Lorentz(name = 'VVVVVSS21',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS22 = Lorentz(name = 'VVVVVSS22',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - 2*P(5,1)*Metric(1,2)*Metric(3,4) + 2*P(5,2)*Metric(1,2)*Metric(3,4) + 2*P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) - 2*P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 2*P(4,1)*Metric(1,2)*Metric(3,5) + 2*P(4,2)*Metric(1,2)*Metric(3,5) + 2*P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) - 2*P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - 2*P(3,1)*Metric(1,2)*Metric(4,5) + 2*P(3,2)*Metric(1,2)*Metric(4,5) + 2*P(2,1)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS23 = Lorentz(name = 'VVVVVSS23',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 4*P(2,5)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 4*P(1,5)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) + 4*P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - 4*P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + 4*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 4*P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS24 = Lorentz(name = 'VVVVVSS24',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 2*P(2,5)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 2*P(1,5)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - 2*P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS25 = Lorentz(name = 'VVVVVSS25',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - (2*P(5,1)*Metric(1,2)*Metric(3,4))/3. + (2*P(5,2)*Metric(1,2)*Metric(3,4))/3. + (2*P(2,1)*Metric(1,5)*Metric(3,4))/3. - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + (4*P(2,5)*Metric(1,5)*Metric(3,4))/3. - (2*P(1,2)*Metric(2,5)*Metric(3,4))/3. + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - (4*P(1,5)*Metric(2,5)*Metric(3,4))/3. - (2*P(4,1)*Metric(1,2)*Metric(3,5))/3. + (2*P(4,2)*Metric(1,2)*Metric(3,5))/3. + (2*P(2,1)*Metric(1,4)*Metric(3,5))/3. - P(2,3)*Metric(1,4)*Metric(3,5) + (4*P(2,4)*Metric(1,4)*Metric(3,5))/3. - P(2,5)*Metric(1,4)*Metric(3,5) - (2*P(1,2)*Metric(2,4)*Metric(3,5))/3. + P(1,3)*Metric(2,4)*Metric(3,5) - (4*P(1,4)*Metric(2,4)*Metric(3,5))/3. + P(1,5)*Metric(2,4)*Metric(3,5) - (2*P(3,1)*Metric(1,2)*Metric(4,5))/3. + (2*P(3,2)*Metric(1,2)*Metric(4,5))/3. + (2*P(2,1)*Metric(1,3)*Metric(4,5))/3. + (4*P(2,3)*Metric(1,3)*Metric(4,5))/3. - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - (2*P(1,2)*Metric(2,3)*Metric(4,5))/3. - (4*P(1,3)*Metric(2,3)*Metric(4,5))/3. + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS26 = Lorentz(name = 'VVVVVSS26',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(2,5)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) + P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS27 = Lorentz(name = 'VVVVVSS27',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(5,2)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(2,5)*Metric(1,5)*Metric(3,4) - P(1,2)*Metric(2,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(1,5)*Metric(2,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) + P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) + P(2,1)*Metric(1,3)*Metric(4,5) + P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5) - P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS28 = Lorentz(name = 'VVVVVSS28',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,1)*Metric(1,4)*Metric(2,3) + P(5,2)*Metric(1,4)*Metric(2,3) - P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + 3*P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*Metric(1,5)*Metric(2,3) + P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) - P(5,3)*Metric(1,3)*Metric(2,4) - P(5,4)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + 3*P(3,4)*Metric(1,5)*Metric(2,4) - 2*P(3,5)*Metric(1,5)*Metric(2,4) - P(4,2)*Metric(1,3)*Metric(2,5) + 3*P(4,3)*Metric(1,3)*Metric(2,5) - 2*P(4,5)*Metric(1,3)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) + 3*P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(3,5)*Metric(1,4)*Metric(2,5) - 6*P(5,1)*Metric(1,2)*Metric(3,4) - 6*P(5,2)*Metric(1,2)*Metric(3,4) + 6*P(5,3)*Metric(1,2)*Metric(3,4) + 6*P(5,4)*Metric(1,2)*Metric(3,4) + 6*P(2,1)*Metric(1,5)*Metric(3,4) - 3*P(2,3)*Metric(1,5)*Metric(3,4) - 3*P(2,4)*Metric(1,5)*Metric(3,4) + 6*P(1,2)*Metric(2,5)*Metric(3,4) - 3*P(1,3)*Metric(2,5)*Metric(3,4) - 3*P(1,4)*Metric(2,5)*Metric(3,4) + 3*P(4,1)*Metric(1,2)*Metric(3,5) + 3*P(4,2)*Metric(1,2)*Metric(3,5) - 6*P(4,3)*Metric(1,2)*Metric(3,5) - 3*P(2,1)*Metric(1,4)*Metric(3,5) + P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(2,5)*Metric(1,4)*Metric(3,5) - 3*P(1,2)*Metric(2,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + 2*P(1,5)*Metric(2,4)*Metric(3,5) + 3*P(3,1)*Metric(1,2)*Metric(4,5) + 3*P(3,2)*Metric(1,2)*Metric(4,5) - 6*P(3,4)*Metric(1,2)*Metric(4,5) - 3*P(2,1)*Metric(1,3)*Metric(4,5) + P(2,4)*Metric(1,3)*Metric(4,5) + 2*P(2,5)*Metric(1,3)*Metric(4,5) - 3*P(1,2)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS29 = Lorentz(name = 'VVVVVSS29',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,2)*Metric(1,4)*Metric(2,3) + P(5,3)*Metric(1,4)*Metric(2,3) - 2*P(5,4)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(5,4)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(4,5)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(3,2)*Metric(1,2)*Metric(4,5) - P(3,4)*Metric(1,2)*Metric(4,5) - P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,2)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*Metric(2,3)*Metric(4,5) + 2*P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS30 = Lorentz(name = 'VVVVVSS30',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,2)*Metric(1,4)*Metric(2,3) + P(5,3)*Metric(1,4)*Metric(2,3) - 2*P(5,4)*Metric(1,4)*Metric(2,3) + P(4,2)*Metric(1,5)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(4,5)*Metric(1,5)*Metric(2,3) - 2*P(5,1)*Metric(1,3)*Metric(2,4) + P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + 2*P(3,1)*Metric(1,5)*Metric(2,4) - P(3,2)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - 2*P(4,1)*Metric(1,3)*Metric(2,5) + P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) + 2*P(3,1)*Metric(1,4)*Metric(2,5) - P(3,2)*Metric(1,4)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(5,1)*Metric(1,2)*Metric(3,4) + P(5,2)*Metric(1,2)*Metric(3,4) + P(5,4)*Metric(1,2)*Metric(3,4) + 2*P(2,1)*Metric(1,5)*Metric(3,4) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,5)*Metric(1,5)*Metric(3,4) - P(1,2)*Metric(2,5)*Metric(3,4) - P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) + P(1,5)*Metric(2,5)*Metric(3,4) - 2*P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) + P(4,5)*Metric(1,2)*Metric(3,5) + 2*P(2,1)*Metric(1,4)*Metric(3,5) - P(2,3)*Metric(1,4)*Metric(3,5) - P(2,4)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5) - P(1,3)*Metric(2,4)*Metric(3,5) + P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(3,2)*Metric(1,2)*Metric(4,5) - P(3,4)*Metric(1,2)*Metric(4,5) - P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,2)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*Metric(2,3)*Metric(4,5) + 2*P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS31 = Lorentz(name = 'VVVVVSS31',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,1)*Metric(1,4)*Metric(2,3) - P(5,2)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) + 2*P(4,2)*Metric(1,5)*Metric(2,3) - P(4,6)*Metric(1,5)*Metric(2,3) - P(4,7)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(5,2)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) - 2*P(3,2)*Metric(1,5)*Metric(2,4) + P(3,6)*Metric(1,5)*Metric(2,4) + P(3,7)*Metric(1,5)*Metric(2,4) + 2*P(4,1)*Metric(1,3)*Metric(2,5) - P(4,2)*Metric(1,3)*Metric(2,5) - P(4,6)*Metric(1,3)*Metric(2,5) - P(4,7)*Metric(1,3)*Metric(2,5) - 2*P(3,1)*Metric(1,4)*Metric(2,5) + P(3,2)*Metric(1,4)*Metric(2,5) + P(3,6)*Metric(1,4)*Metric(2,5) + P(3,7)*Metric(1,4)*Metric(2,5) - P(4,1)*Metric(1,2)*Metric(3,5) - P(4,2)*Metric(1,2)*Metric(3,5) + 2*P(4,6)*Metric(1,2)*Metric(3,5) + 2*P(4,7)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) - P(2,6)*Metric(1,4)*Metric(3,5) - P(2,7)*Metric(1,4)*Metric(3,5) + P(1,2)*Metric(2,4)*Metric(3,5) - P(1,6)*Metric(2,4)*Metric(3,5) - P(1,7)*Metric(2,4)*Metric(3,5) + P(3,1)*Metric(1,2)*Metric(4,5) + P(3,2)*Metric(1,2)*Metric(4,5) - 2*P(3,6)*Metric(1,2)*Metric(4,5) - 2*P(3,7)*Metric(1,2)*Metric(4,5) - P(2,1)*Metric(1,3)*Metric(4,5) + P(2,6)*Metric(1,3)*Metric(4,5) + P(2,7)*Metric(1,3)*Metric(4,5) - P(1,2)*Metric(2,3)*Metric(4,5) + P(1,6)*Metric(2,3)*Metric(4,5) + P(1,7)*Metric(2,3)*Metric(4,5)')

VVVVVVS1 = Lorentz(name = 'VVVVVVS1',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,4)*Metric(3,5) + Metric(1,4)*Metric(2,6)*Metric(3,5) + Metric(1,5)*Metric(2,4)*Metric(3,6) + Metric(1,4)*Metric(2,5)*Metric(3,6) + Metric(1,6)*Metric(2,3)*Metric(4,5) + Metric(1,3)*Metric(2,6)*Metric(4,5) - 4*Metric(1,2)*Metric(3,6)*Metric(4,5) + Metric(1,5)*Metric(2,3)*Metric(4,6) + Metric(1,3)*Metric(2,5)*Metric(4,6) - 4*Metric(1,2)*Metric(3,5)*Metric(4,6)')

VVVVVVS2 = Lorentz(name = 'VVVVVVS2',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + Metric(1,2)*Metric(3,5)*Metric(4,6)')

VVVVVVS3 = Lorentz(name = 'VVVVVVS3',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) + 2*Metric(1,6)*Metric(2,3)*Metric(4,5) - Metric(1,3)*Metric(2,6)*Metric(4,5) - Metric(1,2)*Metric(3,6)*Metric(4,5) - Metric(1,5)*Metric(2,3)*Metric(4,6) - Metric(1,4)*Metric(2,3)*Metric(5,6)')

VVVVVVS4 = Lorentz(name = 'VVVVVVS4',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) + Metric(1,4)*Metric(2,6)*Metric(3,5) + Metric(1,5)*Metric(2,4)*Metric(3,6) + Metric(1,4)*Metric(2,5)*Metric(3,6) + Metric(1,6)*Metric(2,3)*Metric(4,5) + Metric(1,3)*Metric(2,6)*Metric(4,5) - 4*Metric(1,2)*Metric(3,6)*Metric(4,5) + Metric(1,5)*Metric(2,3)*Metric(4,6) + Metric(1,3)*Metric(2,5)*Metric(4,6) - 4*Metric(1,2)*Metric(3,5)*Metric(4,6) + Metric(1,4)*Metric(2,3)*Metric(5,6) + Metric(1,3)*Metric(2,4)*Metric(5,6) - 4*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVVS5 = Lorentz(name = 'VVVVVVS5',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,4)*Metric(2,3)*Metric(5,6) + Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVVS6 = Lorentz(name = 'VVVVVVS6',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/4. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/4. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/4. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/4. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/4. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/4. - (Metric(1,5)*Metric(2,3)*Metric(4,6))/4. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/4. + Metric(1,4)*Metric(2,3)*Metric(5,6) + Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVVS7 = Lorentz(name = 'VVVVVVS7',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - Metric(1,2)*Metric(3,6)*Metric(4,5) - Metric(1,2)*Metric(3,5)*Metric(4,6) + Metric(1,4)*Metric(2,3)*Metric(5,6) + Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVVS8 = Lorentz(name = 'VVVVVVS8',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (7*Metric(1,6)*Metric(2,4)*Metric(3,5))/18. - (7*Metric(1,4)*Metric(2,6)*Metric(3,5))/18. - (7*Metric(1,5)*Metric(2,4)*Metric(3,6))/18. - (7*Metric(1,4)*Metric(2,5)*Metric(3,6))/18. - (7*Metric(1,6)*Metric(2,3)*Metric(4,5))/18. - (7*Metric(1,3)*Metric(2,6)*Metric(4,5))/18. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (7*Metric(1,5)*Metric(2,3)*Metric(4,6))/18. - (7*Metric(1,3)*Metric(2,5)*Metric(4,6))/18. + Metric(1,2)*Metric(3,5)*Metric(4,6) + (4*Metric(1,4)*Metric(2,3)*Metric(5,6))/9. + (4*Metric(1,3)*Metric(2,4)*Metric(5,6))/9. - (16*Metric(1,2)*Metric(3,4)*Metric(5,6))/9.')

VVVVVVS9 = Lorentz(name = 'VVVVVVS9',
                   spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                   structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/6. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/6. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/6. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/6. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/6. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/6. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (Metric(1,5)*Metric(2,3)*Metric(4,6))/6. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/6. + Metric(1,2)*Metric(3,5)*Metric(4,6) - (2*Metric(1,4)*Metric(2,3)*Metric(5,6))/3. - (2*Metric(1,3)*Metric(2,4)*Metric(5,6))/3. - (4*Metric(1,2)*Metric(3,4)*Metric(5,6))/3.')

VVVVVVS10 = Lorentz(name = 'VVVVVVS10',
                    spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                    structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) - (Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + Metric(1,2)*Metric(3,6)*Metric(4,5) - (Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + Metric(1,2)*Metric(3,5)*Metric(4,6) + (2*Metric(1,4)*Metric(2,3)*Metric(5,6))/3. + (2*Metric(1,3)*Metric(2,4)*Metric(5,6))/3. - (4*Metric(1,2)*Metric(3,4)*Metric(5,6))/3.')

VVVVVVS11 = Lorentz(name = 'VVVVVVS11',
                    spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                    structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) - Metric(1,5)*Metric(2,6)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) - Metric(1,4)*Metric(2,6)*Metric(3,5) - Metric(1,5)*Metric(2,4)*Metric(3,6) - Metric(1,4)*Metric(2,5)*Metric(3,6) - 6*Metric(1,6)*Metric(2,3)*Metric(4,5) + 3*Metric(1,3)*Metric(2,6)*Metric(4,5) + 3*Metric(1,2)*Metric(3,6)*Metric(4,5) + 3*Metric(1,5)*Metric(2,3)*Metric(4,6) - Metric(1,3)*Metric(2,5)*Metric(4,6) - Metric(1,2)*Metric(3,5)*Metric(4,6) + 3*Metric(1,4)*Metric(2,3)*Metric(5,6) - Metric(1,3)*Metric(2,4)*Metric(5,6) - Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVVS12 = Lorentz(name = 'VVVVVVS12',
                    spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                    structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) + Metric(1,5)*Metric(2,6)*Metric(3,4) + Metric(1,6)*Metric(2,4)*Metric(3,5) + Metric(1,4)*Metric(2,6)*Metric(3,5) + Metric(1,5)*Metric(2,4)*Metric(3,6) + Metric(1,4)*Metric(2,5)*Metric(3,6) - (2*Metric(1,6)*Metric(2,3)*Metric(4,5))/3. - (2*Metric(1,3)*Metric(2,6)*Metric(4,5))/3. - (2*Metric(1,2)*Metric(3,6)*Metric(4,5))/3. - (2*Metric(1,5)*Metric(2,3)*Metric(4,6))/3. - (2*Metric(1,3)*Metric(2,5)*Metric(4,6))/3. - (2*Metric(1,2)*Metric(3,5)*Metric(4,6))/3. - (2*Metric(1,4)*Metric(2,3)*Metric(5,6))/3. - (2*Metric(1,3)*Metric(2,4)*Metric(5,6))/3. - (2*Metric(1,2)*Metric(3,4)*Metric(5,6))/3.')

VVVVVVS13 = Lorentz(name = 'VVVVVVS13',
                    spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                    structure = 'Metric(1,6)*Metric(2,3)*Metric(4,5) - (Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + Metric(1,5)*Metric(2,3)*Metric(4,6) - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + Metric(1,4)*Metric(2,3)*Metric(5,6) - (Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVVS14 = Lorentz(name = 'VVVVVVS14',
                    spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                    structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) - (Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + Metric(1,6)*Metric(2,4)*Metric(3,5) - (Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - 2*Metric(1,6)*Metric(2,3)*Metric(4,5) + Metric(1,3)*Metric(2,6)*Metric(4,5) + Metric(1,2)*Metric(3,6)*Metric(4,5) + Metric(1,5)*Metric(2,3)*Metric(4,6) - (Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + Metric(1,4)*Metric(2,3)*Metric(5,6) - (Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVVS15 = Lorentz(name = 'VVVVVVS15',
                    spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                    structure = 'Metric(1,6)*Metric(2,5)*Metric(3,4) - (Metric(1,5)*Metric(2,6)*Metric(3,4))/4. + Metric(1,6)*Metric(2,4)*Metric(3,5) - (Metric(1,4)*Metric(2,6)*Metric(3,5))/4. - (Metric(1,5)*Metric(2,4)*Metric(3,6))/4. - (Metric(1,4)*Metric(2,5)*Metric(3,6))/4. - (Metric(1,3)*Metric(2,5)*Metric(4,6))/4. - (Metric(1,2)*Metric(3,5)*Metric(4,6))/4. - (Metric(1,3)*Metric(2,4)*Metric(5,6))/4. - (Metric(1,2)*Metric(3,4)*Metric(5,6))/4.')

VVVVVVS16 = Lorentz(name = 'VVVVVVS16',
                    spins = [ 3, 3, 3, 3, 3, 3, 1 ],
                    structure = 'Metric(1,6)*Metric(2,4)*Metric(3,5) + Metric(1,4)*Metric(2,6)*Metric(3,5) + Metric(1,5)*Metric(2,4)*Metric(3,6) + Metric(1,4)*Metric(2,5)*Metric(3,6) + Metric(1,6)*Metric(2,3)*Metric(4,5) + Metric(1,3)*Metric(2,6)*Metric(4,5) + Metric(1,5)*Metric(2,3)*Metric(4,6) + Metric(1,3)*Metric(2,5)*Metric(4,6) - 5*Metric(1,4)*Metric(2,3)*Metric(5,6) - 5*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVVV1 = Lorentz(name = 'VVVVVVV1',
                   spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(7,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(7,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(7,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(7,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(6,2)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(6,3)*Metric(1,7)*Metric(2,5)*Metric(3,4) - P(6,4)*Metric(1,7)*Metric(2,5)*Metric(3,4) - P(6,5)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(7,1)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(7,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(7,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(7,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(5,1)*Metric(1,7)*Metric(2,6)*Metric(3,4) - P(5,2)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(5,6)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(5,7)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(6,1)*Metric(1,5)*Metric(2,7)*Metric(3,4) + P(6,3)*Metric(1,5)*Metric(2,7)*Metric(3,4) - P(6,4)*Metric(1,5)*Metric(2,7)*Metric(3,4) - P(6,5)*Metric(1,5)*Metric(2,7)*Metric(3,4) - P(5,1)*Metric(1,6)*Metric(2,7)*Metric(3,4) - P(5,2)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(5,6)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(5,7)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(7,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(7,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(7,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(7,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(6,2)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(6,3)*Metric(1,7)*Metric(2,4)*Metric(3,5) - P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5) - P(6,5)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(7,1)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(7,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(7,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(7,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(4,1)*Metric(1,7)*Metric(2,6)*Metric(3,5) - P(4,2)*Metric(1,7)*Metric(2,6)*Metric(3,5) + P(4,6)*Metric(1,7)*Metric(2,6)*Metric(3,5) + P(4,7)*Metric(1,7)*Metric(2,6)*Metric(3,5) + P(6,1)*Metric(1,4)*Metric(2,7)*Metric(3,5) + P(6,3)*Metric(1,4)*Metric(2,7)*Metric(3,5) - P(6,4)*Metric(1,4)*Metric(2,7)*Metric(3,5) - P(6,5)*Metric(1,4)*Metric(2,7)*Metric(3,5) - P(4,1)*Metric(1,6)*Metric(2,7)*Metric(3,5) - P(4,2)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(4,6)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(4,7)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(7,1)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(7,2)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(7,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(7,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(5,1)*Metric(1,7)*Metric(2,4)*Metric(3,6) - P(5,3)*Metric(1,7)*Metric(2,4)*Metric(3,6) + P(5,6)*Metric(1,7)*Metric(2,4)*Metric(3,6) + P(5,7)*Metric(1,7)*Metric(2,4)*Metric(3,6) + P(7,1)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(7,2)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(7,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(7,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(4,1)*Metric(1,7)*Metric(2,5)*Metric(3,6) - P(4,3)*Metric(1,7)*Metric(2,5)*Metric(3,6) + P(4,6)*Metric(1,7)*Metric(2,5)*Metric(3,6) + P(4,7)*Metric(1,7)*Metric(2,5)*Metric(3,6) - P(5,2)*Metric(1,4)*Metric(2,7)*Metric(3,6) - P(5,3)*Metric(1,4)*Metric(2,7)*Metric(3,6) + P(5,6)*Metric(1,4)*Metric(2,7)*Metric(3,6) + P(5,7)*Metric(1,4)*Metric(2,7)*Metric(3,6) - P(4,2)*Metric(1,5)*Metric(2,7)*Metric(3,6) - P(4,3)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(4,6)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(4,7)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(6,1)*Metric(1,5)*Metric(2,4)*Metric(3,7) + P(6,2)*Metric(1,5)*Metric(2,4)*Metric(3,7) - P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7) - P(6,5)*Metric(1,5)*Metric(2,4)*Metric(3,7) - P(5,1)*Metric(1,6)*Metric(2,4)*Metric(3,7) - P(5,3)*Metric(1,6)*Metric(2,4)*Metric(3,7) + P(5,6)*Metric(1,6)*Metric(2,4)*Metric(3,7) + P(5,7)*Metric(1,6)*Metric(2,4)*Metric(3,7) + P(6,1)*Metric(1,4)*Metric(2,5)*Metric(3,7) + P(6,2)*Metric(1,4)*Metric(2,5)*Metric(3,7) - P(6,4)*Metric(1,4)*Metric(2,5)*Metric(3,7) - P(6,5)*Metric(1,4)*Metric(2,5)*Metric(3,7) - P(4,1)*Metric(1,6)*Metric(2,5)*Metric(3,7) - P(4,3)*Metric(1,6)*Metric(2,5)*Metric(3,7) + P(4,6)*Metric(1,6)*Metric(2,5)*Metric(3,7) + P(4,7)*Metric(1,6)*Metric(2,5)*Metric(3,7) - P(5,2)*Metric(1,4)*Metric(2,6)*Metric(3,7) - P(5,3)*Metric(1,4)*Metric(2,6)*Metric(3,7) + P(5,6)*Metric(1,4)*Metric(2,6)*Metric(3,7) + P(5,7)*Metric(1,4)*Metric(2,6)*Metric(3,7) - P(4,2)*Metric(1,5)*Metric(2,6)*Metric(3,7) - P(4,3)*Metric(1,5)*Metric(2,6)*Metric(3,7) + P(4,6)*Metric(1,5)*Metric(2,6)*Metric(3,7) + P(4,7)*Metric(1,5)*Metric(2,6)*Metric(3,7) - 2*P(7,1)*Metric(1,5)*Metric(2,3)*Metric(4,6) + 2*P(7,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) + 2*P(5,1)*Metric(1,7)*Metric(2,3)*Metric(4,6) - 2*P(5,7)*Metric(1,7)*Metric(2,3)*Metric(4,6) - 2*P(7,2)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(7,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(3,4)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(3,6)*Metric(1,7)*Metric(2,5)*Metric(4,6) + 2*P(5,2)*Metric(1,3)*Metric(2,7)*Metric(4,6) - 2*P(5,7)*Metric(1,3)*Metric(2,7)*Metric(4,6) + P(3,4)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(3,6)*Metric(1,5)*Metric(2,7)*Metric(4,6) - 2*P(7,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(7,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,6)*Metric(1,7)*Metric(3,5)*Metric(4,6) + P(1,4)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,6) + 2*P(5,3)*Metric(1,2)*Metric(3,7)*Metric(4,6) - 2*P(5,7)*Metric(1,2)*Metric(3,7)*Metric(4,6) + P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,6)*Metric(1,5)*Metric(3,7)*Metric(4,6) + P(1,4)*Metric(2,5)*Metric(3,7)*Metric(4,6) - P(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,6) - 2*P(6,1)*Metric(1,5)*Metric(2,3)*Metric(4,7) + 2*P(6,5)*Metric(1,5)*Metric(2,3)*Metric(4,7) + 2*P(5,1)*Metric(1,6)*Metric(2,3)*Metric(4,7) - 2*P(5,6)*Metric(1,6)*Metric(2,3)*Metric(4,7) - 2*P(6,2)*Metric(1,3)*Metric(2,5)*Metric(4,7) + 2*P(6,5)*Metric(1,3)*Metric(2,5)*Metric(4,7) + P(3,4)*Metric(1,6)*Metric(2,5)*Metric(4,7) - P(3,7)*Metric(1,6)*Metric(2,5)*Metric(4,7) + 2*P(5,2)*Metric(1,3)*Metric(2,6)*Metric(4,7) - 2*P(5,6)*Metric(1,3)*Metric(2,6)*Metric(4,7) + P(3,4)*Metric(1,5)*Metric(2,6)*Metric(4,7) - P(3,7)*Metric(1,5)*Metric(2,6)*Metric(4,7) - 2*P(6,3)*Metric(1,2)*Metric(3,5)*Metric(4,7) + 2*P(6,5)*Metric(1,2)*Metric(3,5)*Metric(4,7) + P(2,4)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(2,7)*Metric(1,6)*Metric(3,5)*Metric(4,7) + P(1,4)*Metric(2,6)*Metric(3,5)*Metric(4,7) - P(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,7) + 2*P(5,3)*Metric(1,2)*Metric(3,6)*Metric(4,7) - 2*P(5,6)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(2,4)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(2,7)*Metric(1,5)*Metric(3,6)*Metric(4,7) + P(1,4)*Metric(2,5)*Metric(3,6)*Metric(4,7) - P(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,7) - 2*P(7,1)*Metric(1,4)*Metric(2,3)*Metric(5,6) + 2*P(7,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) + 2*P(4,1)*Metric(1,7)*Metric(2,3)*Metric(5,6) - 2*P(4,7)*Metric(1,7)*Metric(2,3)*Metric(5,6) - 2*P(7,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(7,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(3,5)*Metric(1,7)*Metric(2,4)*Metric(5,6) - P(3,6)*Metric(1,7)*Metric(2,4)*Metric(5,6) + 2*P(4,2)*Metric(1,3)*Metric(2,7)*Metric(5,6) - 2*P(4,7)*Metric(1,3)*Metric(2,7)*Metric(5,6) + P(3,5)*Metric(1,4)*Metric(2,7)*Metric(5,6) - P(3,6)*Metric(1,4)*Metric(2,7)*Metric(5,6) - 2*P(7,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(7,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(2,5)*Metric(1,7)*Metric(3,4)*Metric(5,6) - P(2,6)*Metric(1,7)*Metric(3,4)*Metric(5,6) + P(1,5)*Metric(2,7)*Metric(3,4)*Metric(5,6) - P(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,6) + 2*P(4,3)*Metric(1,2)*Metric(3,7)*Metric(5,6) - 2*P(4,7)*Metric(1,2)*Metric(3,7)*Metric(5,6) + P(2,5)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(2,6)*Metric(1,4)*Metric(3,7)*Metric(5,6) + P(1,5)*Metric(2,4)*Metric(3,7)*Metric(5,6) - P(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,6) - 2*P(3,4)*Metric(1,2)*Metric(4,7)*Metric(5,6) - 2*P(3,5)*Metric(1,2)*Metric(4,7)*Metric(5,6) + 2*P(3,6)*Metric(1,2)*Metric(4,7)*Metric(5,6) + 2*P(3,7)*Metric(1,2)*Metric(4,7)*Metric(5,6) - 2*P(2,4)*Metric(1,3)*Metric(4,7)*Metric(5,6) - 2*P(2,5)*Metric(1,3)*Metric(4,7)*Metric(5,6) + 2*P(2,6)*Metric(1,3)*Metric(4,7)*Metric(5,6) + 2*P(2,7)*Metric(1,3)*Metric(4,7)*Metric(5,6) - 2*P(1,4)*Metric(2,3)*Metric(4,7)*Metric(5,6) - 2*P(1,5)*Metric(2,3)*Metric(4,7)*Metric(5,6) + 2*P(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,6) + 2*P(1,7)*Metric(2,3)*Metric(4,7)*Metric(5,6) - 2*P(6,1)*Metric(1,4)*Metric(2,3)*Metric(5,7) + 2*P(6,4)*Metric(1,4)*Metric(2,3)*Metric(5,7) + 2*P(4,1)*Metric(1,6)*Metric(2,3)*Metric(5,7) - 2*P(4,6)*Metric(1,6)*Metric(2,3)*Metric(5,7) - 2*P(6,2)*Metric(1,3)*Metric(2,4)*Metric(5,7) + 2*P(6,4)*Metric(1,3)*Metric(2,4)*Metric(5,7) + P(3,5)*Metric(1,6)*Metric(2,4)*Metric(5,7) - P(3,7)*Metric(1,6)*Metric(2,4)*Metric(5,7) + 2*P(4,2)*Metric(1,3)*Metric(2,6)*Metric(5,7) - 2*P(4,6)*Metric(1,3)*Metric(2,6)*Metric(5,7) + P(3,5)*Metric(1,4)*Metric(2,6)*Metric(5,7) - P(3,7)*Metric(1,4)*Metric(2,6)*Metric(5,7) - 2*P(6,3)*Metric(1,2)*Metric(3,4)*Metric(5,7) + 2*P(6,4)*Metric(1,2)*Metric(3,4)*Metric(5,7) + P(2,5)*Metric(1,6)*Metric(3,4)*Metric(5,7) - P(2,7)*Metric(1,6)*Metric(3,4)*Metric(5,7) + P(1,5)*Metric(2,6)*Metric(3,4)*Metric(5,7) - P(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,7) + 2*P(4,3)*Metric(1,2)*Metric(3,6)*Metric(5,7) - 2*P(4,6)*Metric(1,2)*Metric(3,6)*Metric(5,7) + P(2,5)*Metric(1,4)*Metric(3,6)*Metric(5,7) - P(2,7)*Metric(1,4)*Metric(3,6)*Metric(5,7) + P(1,5)*Metric(2,4)*Metric(3,6)*Metric(5,7) - P(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,7) - 2*P(3,4)*Metric(1,2)*Metric(4,6)*Metric(5,7) - 2*P(3,5)*Metric(1,2)*Metric(4,6)*Metric(5,7) + 2*P(3,6)*Metric(1,2)*Metric(4,6)*Metric(5,7) + 2*P(3,7)*Metric(1,2)*Metric(4,6)*Metric(5,7) - 2*P(2,4)*Metric(1,3)*Metric(4,6)*Metric(5,7) - 2*P(2,5)*Metric(1,3)*Metric(4,6)*Metric(5,7) + 2*P(2,6)*Metric(1,3)*Metric(4,6)*Metric(5,7) + 2*P(2,7)*Metric(1,3)*Metric(4,6)*Metric(5,7) - 2*P(1,4)*Metric(2,3)*Metric(4,6)*Metric(5,7) - 2*P(1,5)*Metric(2,3)*Metric(4,6)*Metric(5,7) + 2*P(1,6)*Metric(2,3)*Metric(4,6)*Metric(5,7) + 2*P(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,7)')

VVVVVVV2 = Lorentz(name = 'VVVVVVV2',
                   spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(7,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(7,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(7,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(7,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(6,2)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(6,3)*Metric(1,7)*Metric(2,5)*Metric(3,4) - P(6,4)*Metric(1,7)*Metric(2,5)*Metric(3,4) - P(6,5)*Metric(1,7)*Metric(2,5)*Metric(3,4) - (P(7,3)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(7,4)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - P(5,2)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(5,6)*Metric(1,7)*Metric(2,6)*Metric(3,4) - (P(6,3)*Metric(1,5)*Metric(2,7)*Metric(3,4))/2. + (P(6,4)*Metric(1,5)*Metric(2,7)*Metric(3,4))/2. - P(5,2)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(5,7)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(7,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(7,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(7,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(7,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(6,2)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(6,3)*Metric(1,7)*Metric(2,4)*Metric(3,5) - P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5) - P(6,5)*Metric(1,7)*Metric(2,4)*Metric(3,5) - (P(7,3)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(7,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - P(4,2)*Metric(1,7)*Metric(2,6)*Metric(3,5) + P(4,6)*Metric(1,7)*Metric(2,6)*Metric(3,5) - (P(6,3)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. + (P(6,5)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. - P(4,2)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(4,7)*Metric(1,6)*Metric(2,7)*Metric(3,5) - (P(7,2)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(7,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - P(5,3)*Metric(1,7)*Metric(2,4)*Metric(3,6) + P(5,6)*Metric(1,7)*Metric(2,4)*Metric(3,6) - (P(7,2)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(7,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - P(4,3)*Metric(1,7)*Metric(2,5)*Metric(3,6) + P(4,6)*Metric(1,7)*Metric(2,5)*Metric(3,6) + (P(5,2)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. + (P(5,3)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. - (P(5,6)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. - (P(5,7)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. + (P(4,2)*Metric(1,5)*Metric(2,7)*Metric(3,6))/2. + (P(4,3)*Metric(1,5)*Metric(2,7)*Metric(3,6))/2. - (P(4,6)*Metric(1,5)*Metric(2,7)*Metric(3,6))/2. - (P(4,7)*Metric(1,5)*Metric(2,7)*Metric(3,6))/2. - (P(6,2)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. + (P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. - P(5,3)*Metric(1,6)*Metric(2,4)*Metric(3,7) + P(5,7)*Metric(1,6)*Metric(2,4)*Metric(3,7) - (P(6,2)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. + (P(6,5)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. - P(4,3)*Metric(1,6)*Metric(2,5)*Metric(3,7) + P(4,7)*Metric(1,6)*Metric(2,5)*Metric(3,7) + (P(5,2)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. + (P(5,3)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. - (P(5,6)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. - (P(5,7)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. + (P(4,2)*Metric(1,5)*Metric(2,6)*Metric(3,7))/2. + (P(4,3)*Metric(1,5)*Metric(2,6)*Metric(3,7))/2. - (P(4,6)*Metric(1,5)*Metric(2,6)*Metric(3,7))/2. - (P(4,7)*Metric(1,5)*Metric(2,6)*Metric(3,7))/2. - (P(7,2)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(7,5)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(3,4)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(3,6)*Metric(1,7)*Metric(2,5)*Metric(4,6) - (P(5,1)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. + (P(5,2)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. + (P(5,3)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. - (P(5,7)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. + (P(3,1)*Metric(1,5)*Metric(2,7)*Metric(4,6))/2. - (P(3,4)*Metric(1,5)*Metric(2,7)*Metric(4,6))/2. - (P(3,5)*Metric(1,5)*Metric(2,7)*Metric(4,6))/2. + (P(3,6)*Metric(1,5)*Metric(2,7)*Metric(4,6))/2. - (P(7,3)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + (P(7,5)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,6)*Metric(1,7)*Metric(3,5)*Metric(4,6) - (P(1,3)*Metric(2,7)*Metric(3,5)*Metric(4,6))/2. + (P(1,5)*Metric(2,7)*Metric(3,5)*Metric(4,6))/2. - (P(5,1)*Metric(1,2)*Metric(3,7)*Metric(4,6))/2. + (P(5,2)*Metric(1,2)*Metric(3,7)*Metric(4,6))/2. + (P(5,3)*Metric(1,2)*Metric(3,7)*Metric(4,6))/2. - (P(5,7)*Metric(1,2)*Metric(3,7)*Metric(4,6))/2. + (P(2,1)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. - (P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. - (P(2,5)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. + (P(2,6)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. - (P(1,2)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. + (P(1,5)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. - (P(6,2)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. + (P(6,5)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. + P(3,4)*Metric(1,6)*Metric(2,5)*Metric(4,7) - P(3,7)*Metric(1,6)*Metric(2,5)*Metric(4,7) - (P(5,1)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. + (P(5,2)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. + (P(5,3)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. - (P(5,6)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. + (P(3,1)*Metric(1,5)*Metric(2,6)*Metric(4,7))/2. - (P(3,4)*Metric(1,5)*Metric(2,6)*Metric(4,7))/2. - (P(3,5)*Metric(1,5)*Metric(2,6)*Metric(4,7))/2. + (P(3,7)*Metric(1,5)*Metric(2,6)*Metric(4,7))/2. - (P(6,3)*Metric(1,2)*Metric(3,5)*Metric(4,7))/2. + (P(6,5)*Metric(1,2)*Metric(3,5)*Metric(4,7))/2. + P(2,4)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(2,7)*Metric(1,6)*Metric(3,5)*Metric(4,7) - (P(1,3)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (P(1,5)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. - (P(5,1)*Metric(1,2)*Metric(3,6)*Metric(4,7))/2. + (P(5,2)*Metric(1,2)*Metric(3,6)*Metric(4,7))/2. + (P(5,3)*Metric(1,2)*Metric(3,6)*Metric(4,7))/2. - (P(5,6)*Metric(1,2)*Metric(3,6)*Metric(4,7))/2. + (P(2,1)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. - (P(2,4)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. - (P(2,5)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. + (P(2,7)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. - (P(1,2)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. + (P(1,5)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. - (P(7,2)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + (P(7,4)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + P(3,5)*Metric(1,7)*Metric(2,4)*Metric(5,6) - P(3,6)*Metric(1,7)*Metric(2,4)*Metric(5,6) - (P(4,1)*Metric(1,3)*Metric(2,7)*Metric(5,6))/2. + (P(4,2)*Metric(1,3)*Metric(2,7)*Metric(5,6))/2. + (P(4,3)*Metric(1,3)*Metric(2,7)*Metric(5,6))/2. - (P(4,7)*Metric(1,3)*Metric(2,7)*Metric(5,6))/2. + (P(3,1)*Metric(1,4)*Metric(2,7)*Metric(5,6))/2. - (P(3,4)*Metric(1,4)*Metric(2,7)*Metric(5,6))/2. - (P(3,5)*Metric(1,4)*Metric(2,7)*Metric(5,6))/2. + (P(3,6)*Metric(1,4)*Metric(2,7)*Metric(5,6))/2. - (P(7,3)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. + (P(7,4)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. + P(2,5)*Metric(1,7)*Metric(3,4)*Metric(5,6) - P(2,6)*Metric(1,7)*Metric(3,4)*Metric(5,6) - (P(1,3)*Metric(2,7)*Metric(3,4)*Metric(5,6))/2. + (P(1,4)*Metric(2,7)*Metric(3,4)*Metric(5,6))/2. - (P(4,1)*Metric(1,2)*Metric(3,7)*Metric(5,6))/2. + (P(4,2)*Metric(1,2)*Metric(3,7)*Metric(5,6))/2. + (P(4,3)*Metric(1,2)*Metric(3,7)*Metric(5,6))/2. - (P(4,7)*Metric(1,2)*Metric(3,7)*Metric(5,6))/2. + (P(2,1)*Metric(1,4)*Metric(3,7)*Metric(5,6))/2. - (P(2,4)*Metric(1,4)*Metric(3,7)*Metric(5,6))/2. - (P(2,5)*Metric(1,4)*Metric(3,7)*Metric(5,6))/2. + (P(2,6)*Metric(1,4)*Metric(3,7)*Metric(5,6))/2. - (P(1,2)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. + (P(1,4)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. - (P(3,4)*Metric(1,2)*Metric(4,7)*Metric(5,6))/2. - (P(3,5)*Metric(1,2)*Metric(4,7)*Metric(5,6))/2. + (P(3,6)*Metric(1,2)*Metric(4,7)*Metric(5,6))/2. + (P(3,7)*Metric(1,2)*Metric(4,7)*Metric(5,6))/2. - (P(2,4)*Metric(1,3)*Metric(4,7)*Metric(5,6))/2. - (P(2,5)*Metric(1,3)*Metric(4,7)*Metric(5,6))/2. + (P(2,6)*Metric(1,3)*Metric(4,7)*Metric(5,6))/2. + (P(2,7)*Metric(1,3)*Metric(4,7)*Metric(5,6))/2. - (P(6,2)*Metric(1,3)*Metric(2,4)*Metric(5,7))/2. + (P(6,4)*Metric(1,3)*Metric(2,4)*Metric(5,7))/2. + P(3,5)*Metric(1,6)*Metric(2,4)*Metric(5,7) - P(3,7)*Metric(1,6)*Metric(2,4)*Metric(5,7) - (P(4,1)*Metric(1,3)*Metric(2,6)*Metric(5,7))/2. + (P(4,2)*Metric(1,3)*Metric(2,6)*Metric(5,7))/2. + (P(4,3)*Metric(1,3)*Metric(2,6)*Metric(5,7))/2. - (P(4,6)*Metric(1,3)*Metric(2,6)*Metric(5,7))/2. + (P(3,1)*Metric(1,4)*Metric(2,6)*Metric(5,7))/2. - (P(3,4)*Metric(1,4)*Metric(2,6)*Metric(5,7))/2. - (P(3,5)*Metric(1,4)*Metric(2,6)*Metric(5,7))/2. + (P(3,7)*Metric(1,4)*Metric(2,6)*Metric(5,7))/2. - (P(6,3)*Metric(1,2)*Metric(3,4)*Metric(5,7))/2. + (P(6,4)*Metric(1,2)*Metric(3,4)*Metric(5,7))/2. + P(2,5)*Metric(1,6)*Metric(3,4)*Metric(5,7) - P(2,7)*Metric(1,6)*Metric(3,4)*Metric(5,7) - (P(1,3)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. + (P(1,4)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. - (P(4,1)*Metric(1,2)*Metric(3,6)*Metric(5,7))/2. + (P(4,2)*Metric(1,2)*Metric(3,6)*Metric(5,7))/2. + (P(4,3)*Metric(1,2)*Metric(3,6)*Metric(5,7))/2. - (P(4,6)*Metric(1,2)*Metric(3,6)*Metric(5,7))/2. + (P(2,1)*Metric(1,4)*Metric(3,6)*Metric(5,7))/2. - (P(2,4)*Metric(1,4)*Metric(3,6)*Metric(5,7))/2. - (P(2,5)*Metric(1,4)*Metric(3,6)*Metric(5,7))/2. + (P(2,7)*Metric(1,4)*Metric(3,6)*Metric(5,7))/2. - (P(1,2)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. + (P(1,4)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. - (P(3,4)*Metric(1,2)*Metric(4,6)*Metric(5,7))/2. - (P(3,5)*Metric(1,2)*Metric(4,6)*Metric(5,7))/2. + (P(3,6)*Metric(1,2)*Metric(4,6)*Metric(5,7))/2. + (P(3,7)*Metric(1,2)*Metric(4,6)*Metric(5,7))/2. - (P(2,4)*Metric(1,3)*Metric(4,6)*Metric(5,7))/2. - (P(2,5)*Metric(1,3)*Metric(4,6)*Metric(5,7))/2. + (P(2,6)*Metric(1,3)*Metric(4,6)*Metric(5,7))/2. + (P(2,7)*Metric(1,3)*Metric(4,6)*Metric(5,7))/2. + P(5,1)*Metric(1,3)*Metric(2,4)*Metric(6,7) - P(5,3)*Metric(1,3)*Metric(2,4)*Metric(6,7) - P(3,1)*Metric(1,5)*Metric(2,4)*Metric(6,7) + P(3,5)*Metric(1,5)*Metric(2,4)*Metric(6,7) + P(4,1)*Metric(1,3)*Metric(2,5)*Metric(6,7) - P(4,3)*Metric(1,3)*Metric(2,5)*Metric(6,7) - P(3,1)*Metric(1,4)*Metric(2,5)*Metric(6,7) + P(3,4)*Metric(1,4)*Metric(2,5)*Metric(6,7) + P(5,1)*Metric(1,2)*Metric(3,4)*Metric(6,7) - P(5,2)*Metric(1,2)*Metric(3,4)*Metric(6,7) - P(2,1)*Metric(1,5)*Metric(3,4)*Metric(6,7) + P(2,5)*Metric(1,5)*Metric(3,4)*Metric(6,7) + P(1,2)*Metric(2,5)*Metric(3,4)*Metric(6,7) + P(1,3)*Metric(2,5)*Metric(3,4)*Metric(6,7) - P(1,4)*Metric(2,5)*Metric(3,4)*Metric(6,7) - P(1,5)*Metric(2,5)*Metric(3,4)*Metric(6,7) + P(4,1)*Metric(1,2)*Metric(3,5)*Metric(6,7) - P(4,2)*Metric(1,2)*Metric(3,5)*Metric(6,7) - P(2,1)*Metric(1,4)*Metric(3,5)*Metric(6,7) + P(2,4)*Metric(1,4)*Metric(3,5)*Metric(6,7) + P(1,2)*Metric(2,4)*Metric(3,5)*Metric(6,7) + P(1,3)*Metric(2,4)*Metric(3,5)*Metric(6,7) - P(1,4)*Metric(2,4)*Metric(3,5)*Metric(6,7) - P(1,5)*Metric(2,4)*Metric(3,5)*Metric(6,7)')

VVVVVVV3 = Lorentz(name = 'VVVVVVV3',
                   spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(7,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(7,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(7,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(6,3)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(6,4)*Metric(1,7)*Metric(2,5)*Metric(3,4) - 2*P(6,5)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(7,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(7,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(7,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(5,3)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(5,4)*Metric(1,7)*Metric(2,6)*Metric(3,4) - 2*P(5,6)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(6,3)*Metric(1,5)*Metric(2,7)*Metric(3,4) + P(6,4)*Metric(1,5)*Metric(2,7)*Metric(3,4) - 2*P(6,7)*Metric(1,5)*Metric(2,7)*Metric(3,4) + P(5,3)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(5,4)*Metric(1,6)*Metric(2,7)*Metric(3,4) - 2*P(5,7)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(7,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(7,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(7,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(6,2)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5) - 2*P(6,5)*Metric(1,7)*Metric(2,4)*Metric(3,5) - 2*P(7,1)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(7,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(7,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 2*P(4,1)*Metric(1,7)*Metric(2,6)*Metric(3,5) - P(4,2)*Metric(1,7)*Metric(2,6)*Metric(3,5) - P(4,3)*Metric(1,7)*Metric(2,6)*Metric(3,5) - 2*P(6,1)*Metric(1,4)*Metric(2,7)*Metric(3,5) + P(6,5)*Metric(1,4)*Metric(2,7)*Metric(3,5) + P(6,7)*Metric(1,4)*Metric(2,7)*Metric(3,5) + 2*P(4,1)*Metric(1,6)*Metric(2,7)*Metric(3,5) - P(4,2)*Metric(1,6)*Metric(2,7)*Metric(3,5) - P(4,3)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(7,2)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(7,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) - 2*P(7,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(5,2)*Metric(1,7)*Metric(2,4)*Metric(3,6) + P(5,4)*Metric(1,7)*Metric(2,4)*Metric(3,6) - 2*P(5,6)*Metric(1,7)*Metric(2,4)*Metric(3,6) - 2*P(7,1)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(7,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(7,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(4,1)*Metric(1,7)*Metric(2,5)*Metric(3,6) - P(4,2)*Metric(1,7)*Metric(2,5)*Metric(3,6) - P(4,3)*Metric(1,7)*Metric(2,5)*Metric(3,6) - 2*P(5,1)*Metric(1,4)*Metric(2,7)*Metric(3,6) + P(5,6)*Metric(1,4)*Metric(2,7)*Metric(3,6) + P(5,7)*Metric(1,4)*Metric(2,7)*Metric(3,6) + 2*P(4,1)*Metric(1,5)*Metric(2,7)*Metric(3,6) - P(4,2)*Metric(1,5)*Metric(2,7)*Metric(3,6) - P(4,3)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(6,2)*Metric(1,5)*Metric(2,4)*Metric(3,7) + P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7) - 2*P(6,7)*Metric(1,5)*Metric(2,4)*Metric(3,7) + P(5,2)*Metric(1,6)*Metric(2,4)*Metric(3,7) + P(5,4)*Metric(1,6)*Metric(2,4)*Metric(3,7) - 2*P(5,7)*Metric(1,6)*Metric(2,4)*Metric(3,7) - 2*P(6,1)*Metric(1,4)*Metric(2,5)*Metric(3,7) + P(6,5)*Metric(1,4)*Metric(2,5)*Metric(3,7) + P(6,7)*Metric(1,4)*Metric(2,5)*Metric(3,7) + 2*P(4,1)*Metric(1,6)*Metric(2,5)*Metric(3,7) - P(4,2)*Metric(1,6)*Metric(2,5)*Metric(3,7) - P(4,3)*Metric(1,6)*Metric(2,5)*Metric(3,7) - 2*P(5,1)*Metric(1,4)*Metric(2,6)*Metric(3,7) + P(5,6)*Metric(1,4)*Metric(2,6)*Metric(3,7) + P(5,7)*Metric(1,4)*Metric(2,6)*Metric(3,7) + 2*P(4,1)*Metric(1,5)*Metric(2,6)*Metric(3,7) - P(4,2)*Metric(1,5)*Metric(2,6)*Metric(3,7) - P(4,3)*Metric(1,5)*Metric(2,6)*Metric(3,7) + P(7,2)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(7,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(7,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(6,2)*Metric(1,7)*Metric(2,3)*Metric(4,5) + P(6,3)*Metric(1,7)*Metric(2,3)*Metric(4,5) - 2*P(6,5)*Metric(1,7)*Metric(2,3)*Metric(4,5) - 2*P(7,1)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(7,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(7,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(3,1)*Metric(1,7)*Metric(2,6)*Metric(4,5) - P(3,2)*Metric(1,7)*Metric(2,6)*Metric(4,5) - P(3,4)*Metric(1,7)*Metric(2,6)*Metric(4,5) - 2*P(6,1)*Metric(1,3)*Metric(2,7)*Metric(4,5) + P(6,5)*Metric(1,3)*Metric(2,7)*Metric(4,5) + P(6,7)*Metric(1,3)*Metric(2,7)*Metric(4,5) + 2*P(3,1)*Metric(1,6)*Metric(2,7)*Metric(4,5) - P(3,2)*Metric(1,6)*Metric(2,7)*Metric(4,5) - P(3,4)*Metric(1,6)*Metric(2,7)*Metric(4,5) - 2*P(7,1)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(7,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(7,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(2,1)*Metric(1,7)*Metric(3,6)*Metric(4,5) - P(2,3)*Metric(1,7)*Metric(3,6)*Metric(4,5) - P(2,4)*Metric(1,7)*Metric(3,6)*Metric(4,5) - 2*P(6,1)*Metric(1,2)*Metric(3,7)*Metric(4,5) + P(6,5)*Metric(1,2)*Metric(3,7)*Metric(4,5) + P(6,7)*Metric(1,2)*Metric(3,7)*Metric(4,5) + 2*P(2,1)*Metric(1,6)*Metric(3,7)*Metric(4,5) - P(2,3)*Metric(1,6)*Metric(3,7)*Metric(4,5) - P(2,4)*Metric(1,6)*Metric(3,7)*Metric(4,5) + P(7,2)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(7,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) - 2*P(7,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(5,2)*Metric(1,7)*Metric(2,3)*Metric(4,6) + P(5,3)*Metric(1,7)*Metric(2,3)*Metric(4,6) - 2*P(5,6)*Metric(1,7)*Metric(2,3)*Metric(4,6) - 2*P(7,1)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(7,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(7,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(3,1)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(3,2)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(3,4)*Metric(1,7)*Metric(2,5)*Metric(4,6) - 2*P(5,1)*Metric(1,3)*Metric(2,7)*Metric(4,6) + P(5,6)*Metric(1,3)*Metric(2,7)*Metric(4,6) + P(5,7)*Metric(1,3)*Metric(2,7)*Metric(4,6) + 2*P(3,1)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(3,2)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(3,4)*Metric(1,5)*Metric(2,7)*Metric(4,6) - 2*P(7,1)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(7,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(7,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(2,1)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,3)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6) - 2*P(5,1)*Metric(1,2)*Metric(3,7)*Metric(4,6) + P(5,6)*Metric(1,2)*Metric(3,7)*Metric(4,6) + P(5,7)*Metric(1,2)*Metric(3,7)*Metric(4,6) + 2*P(2,1)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,3)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6) + P(6,2)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(6,3)*Metric(1,5)*Metric(2,3)*Metric(4,7) - 2*P(6,7)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(5,2)*Metric(1,6)*Metric(2,3)*Metric(4,7) + P(5,3)*Metric(1,6)*Metric(2,3)*Metric(4,7) - 2*P(5,7)*Metric(1,6)*Metric(2,3)*Metric(4,7) - 2*P(6,1)*Metric(1,3)*Metric(2,5)*Metric(4,7) + P(6,5)*Metric(1,3)*Metric(2,5)*Metric(4,7) + P(6,7)*Metric(1,3)*Metric(2,5)*Metric(4,7) + 2*P(3,1)*Metric(1,6)*Metric(2,5)*Metric(4,7) - P(3,2)*Metric(1,6)*Metric(2,5)*Metric(4,7) - P(3,4)*Metric(1,6)*Metric(2,5)*Metric(4,7) - 2*P(5,1)*Metric(1,3)*Metric(2,6)*Metric(4,7) + P(5,6)*Metric(1,3)*Metric(2,6)*Metric(4,7) + P(5,7)*Metric(1,3)*Metric(2,6)*Metric(4,7) + 2*P(3,1)*Metric(1,5)*Metric(2,6)*Metric(4,7) - P(3,2)*Metric(1,5)*Metric(2,6)*Metric(4,7) - P(3,4)*Metric(1,5)*Metric(2,6)*Metric(4,7) - 2*P(6,1)*Metric(1,2)*Metric(3,5)*Metric(4,7) + P(6,5)*Metric(1,2)*Metric(3,5)*Metric(4,7) + P(6,7)*Metric(1,2)*Metric(3,5)*Metric(4,7) + 2*P(2,1)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(2,3)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(2,4)*Metric(1,6)*Metric(3,5)*Metric(4,7) - 2*P(5,1)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(5,6)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(5,7)*Metric(1,2)*Metric(3,6)*Metric(4,7) + 2*P(2,1)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(2,3)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(2,4)*Metric(1,5)*Metric(3,6)*Metric(4,7) + 4*P(7,1)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(7,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(7,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 4*P(4,1)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 2*P(4,5)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 2*P(4,6)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 4*P(7,1)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(7,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(7,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 4*P(3,1)*Metric(1,7)*Metric(2,4)*Metric(5,6) + 2*P(3,5)*Metric(1,7)*Metric(2,4)*Metric(5,6) + 2*P(3,6)*Metric(1,7)*Metric(2,4)*Metric(5,6) + 2*P(4,2)*Metric(1,3)*Metric(2,7)*Metric(5,6) - P(4,5)*Metric(1,3)*Metric(2,7)*Metric(5,6) - P(4,6)*Metric(1,3)*Metric(2,7)*Metric(5,6) + 2*P(3,2)*Metric(1,4)*Metric(2,7)*Metric(5,6) - P(3,5)*Metric(1,4)*Metric(2,7)*Metric(5,6) - P(3,6)*Metric(1,4)*Metric(2,7)*Metric(5,6) + 4*P(7,1)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(7,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(7,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 4*P(2,1)*Metric(1,7)*Metric(3,4)*Metric(5,6) + 2*P(2,5)*Metric(1,7)*Metric(3,4)*Metric(5,6) + 2*P(2,6)*Metric(1,7)*Metric(3,4)*Metric(5,6) + 2*P(4,3)*Metric(1,2)*Metric(3,7)*Metric(5,6) - P(4,5)*Metric(1,2)*Metric(3,7)*Metric(5,6) - P(4,6)*Metric(1,2)*Metric(3,7)*Metric(5,6) + 2*P(2,3)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(2,5)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(2,6)*Metric(1,4)*Metric(3,7)*Metric(5,6) + 2*P(3,4)*Metric(1,2)*Metric(4,7)*Metric(5,6) - P(3,5)*Metric(1,2)*Metric(4,7)*Metric(5,6) - P(3,6)*Metric(1,2)*Metric(4,7)*Metric(5,6) + 2*P(2,4)*Metric(1,3)*Metric(4,7)*Metric(5,6) - P(2,5)*Metric(1,3)*Metric(4,7)*Metric(5,6) - P(2,6)*Metric(1,3)*Metric(4,7)*Metric(5,6) + 4*P(6,1)*Metric(1,4)*Metric(2,3)*Metric(5,7) - 2*P(6,2)*Metric(1,4)*Metric(2,3)*Metric(5,7) - 2*P(6,3)*Metric(1,4)*Metric(2,3)*Metric(5,7) - 4*P(4,1)*Metric(1,6)*Metric(2,3)*Metric(5,7) + 2*P(4,5)*Metric(1,6)*Metric(2,3)*Metric(5,7) + 2*P(4,7)*Metric(1,6)*Metric(2,3)*Metric(5,7) + 4*P(6,1)*Metric(1,3)*Metric(2,4)*Metric(5,7) - 2*P(6,2)*Metric(1,3)*Metric(2,4)*Metric(5,7) - 2*P(6,4)*Metric(1,3)*Metric(2,4)*Metric(5,7) - 4*P(3,1)*Metric(1,6)*Metric(2,4)*Metric(5,7) + 2*P(3,5)*Metric(1,6)*Metric(2,4)*Metric(5,7) + 2*P(3,7)*Metric(1,6)*Metric(2,4)*Metric(5,7) + 2*P(4,2)*Metric(1,3)*Metric(2,6)*Metric(5,7) - P(4,5)*Metric(1,3)*Metric(2,6)*Metric(5,7) - P(4,7)*Metric(1,3)*Metric(2,6)*Metric(5,7) + 2*P(3,2)*Metric(1,4)*Metric(2,6)*Metric(5,7) - P(3,5)*Metric(1,4)*Metric(2,6)*Metric(5,7) - P(3,7)*Metric(1,4)*Metric(2,6)*Metric(5,7) + 4*P(6,1)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 2*P(6,3)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 2*P(6,4)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 4*P(2,1)*Metric(1,6)*Metric(3,4)*Metric(5,7) + 2*P(2,5)*Metric(1,6)*Metric(3,4)*Metric(5,7) + 2*P(2,7)*Metric(1,6)*Metric(3,4)*Metric(5,7) + 2*P(4,3)*Metric(1,2)*Metric(3,6)*Metric(5,7) - P(4,5)*Metric(1,2)*Metric(3,6)*Metric(5,7) - P(4,7)*Metric(1,2)*Metric(3,6)*Metric(5,7) + 2*P(2,3)*Metric(1,4)*Metric(3,6)*Metric(5,7) - P(2,5)*Metric(1,4)*Metric(3,6)*Metric(5,7) - P(2,7)*Metric(1,4)*Metric(3,6)*Metric(5,7) + 2*P(3,4)*Metric(1,2)*Metric(4,6)*Metric(5,7) - P(3,5)*Metric(1,2)*Metric(4,6)*Metric(5,7) - P(3,7)*Metric(1,2)*Metric(4,6)*Metric(5,7) + 2*P(2,4)*Metric(1,3)*Metric(4,6)*Metric(5,7) - P(2,5)*Metric(1,3)*Metric(4,6)*Metric(5,7) - P(2,7)*Metric(1,3)*Metric(4,6)*Metric(5,7) + 4*P(5,1)*Metric(1,4)*Metric(2,3)*Metric(6,7) - 2*P(5,2)*Metric(1,4)*Metric(2,3)*Metric(6,7) - 2*P(5,3)*Metric(1,4)*Metric(2,3)*Metric(6,7) - 4*P(4,1)*Metric(1,5)*Metric(2,3)*Metric(6,7) + 2*P(4,6)*Metric(1,5)*Metric(2,3)*Metric(6,7) + 2*P(4,7)*Metric(1,5)*Metric(2,3)*Metric(6,7) + 4*P(5,1)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 2*P(5,2)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 2*P(5,4)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 4*P(3,1)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(3,6)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(3,7)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(4,2)*Metric(1,3)*Metric(2,5)*Metric(6,7) - P(4,6)*Metric(1,3)*Metric(2,5)*Metric(6,7) - P(4,7)*Metric(1,3)*Metric(2,5)*Metric(6,7) + 2*P(3,2)*Metric(1,4)*Metric(2,5)*Metric(6,7) - P(3,6)*Metric(1,4)*Metric(2,5)*Metric(6,7) - P(3,7)*Metric(1,4)*Metric(2,5)*Metric(6,7) + 4*P(5,1)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 2*P(5,3)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 2*P(5,4)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 4*P(2,1)*Metric(1,5)*Metric(3,4)*Metric(6,7) + 2*P(2,6)*Metric(1,5)*Metric(3,4)*Metric(6,7) + 2*P(2,7)*Metric(1,5)*Metric(3,4)*Metric(6,7) + 2*P(4,3)*Metric(1,2)*Metric(3,5)*Metric(6,7) - P(4,6)*Metric(1,2)*Metric(3,5)*Metric(6,7) - P(4,7)*Metric(1,2)*Metric(3,5)*Metric(6,7) + 2*P(2,3)*Metric(1,4)*Metric(3,5)*Metric(6,7) - P(2,6)*Metric(1,4)*Metric(3,5)*Metric(6,7) - P(2,7)*Metric(1,4)*Metric(3,5)*Metric(6,7) + 2*P(3,4)*Metric(1,2)*Metric(4,5)*Metric(6,7) - P(3,6)*Metric(1,2)*Metric(4,5)*Metric(6,7) - P(3,7)*Metric(1,2)*Metric(4,5)*Metric(6,7) + 2*P(2,4)*Metric(1,3)*Metric(4,5)*Metric(6,7) - P(2,6)*Metric(1,3)*Metric(4,5)*Metric(6,7) - P(2,7)*Metric(1,3)*Metric(4,5)*Metric(6,7)')

VVVVVVV4 = Lorentz(name = 'VVVVVVV4',
                   spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(7,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(7,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(7,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(6,3)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(6,4)*Metric(1,7)*Metric(2,5)*Metric(3,4) - 2*P(6,5)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(7,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(7,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(7,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(5,3)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(5,4)*Metric(1,7)*Metric(2,6)*Metric(3,4) - 2*P(5,6)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(6,3)*Metric(1,5)*Metric(2,7)*Metric(3,4) + P(6,4)*Metric(1,5)*Metric(2,7)*Metric(3,4) - 2*P(6,7)*Metric(1,5)*Metric(2,7)*Metric(3,4) + P(5,3)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(5,4)*Metric(1,6)*Metric(2,7)*Metric(3,4) - 2*P(5,7)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(7,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(7,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(7,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(6,2)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5) - 2*P(6,5)*Metric(1,7)*Metric(2,4)*Metric(3,5) - 4*P(7,1)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 2*P(7,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(7,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(7,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 4*P(4,1)*Metric(1,7)*Metric(2,6)*Metric(3,5) - P(4,2)*Metric(1,7)*Metric(2,6)*Metric(3,5) - P(4,3)*Metric(1,7)*Metric(2,6)*Metric(3,5) - 2*P(4,7)*Metric(1,7)*Metric(2,6)*Metric(3,5) - 4*P(6,1)*Metric(1,4)*Metric(2,7)*Metric(3,5) + 2*P(6,4)*Metric(1,4)*Metric(2,7)*Metric(3,5) + P(6,5)*Metric(1,4)*Metric(2,7)*Metric(3,5) + P(6,7)*Metric(1,4)*Metric(2,7)*Metric(3,5) + 4*P(4,1)*Metric(1,6)*Metric(2,7)*Metric(3,5) - P(4,2)*Metric(1,6)*Metric(2,7)*Metric(3,5) - P(4,3)*Metric(1,6)*Metric(2,7)*Metric(3,5) - 2*P(4,6)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(7,2)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(7,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) - 2*P(7,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(5,2)*Metric(1,7)*Metric(2,4)*Metric(3,6) + P(5,4)*Metric(1,7)*Metric(2,4)*Metric(3,6) - 2*P(5,6)*Metric(1,7)*Metric(2,4)*Metric(3,6) - 4*P(7,1)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(7,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(7,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(7,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 4*P(4,1)*Metric(1,7)*Metric(2,5)*Metric(3,6) - P(4,2)*Metric(1,7)*Metric(2,5)*Metric(3,6) - P(4,3)*Metric(1,7)*Metric(2,5)*Metric(3,6) - 2*P(4,7)*Metric(1,7)*Metric(2,5)*Metric(3,6) - 4*P(5,1)*Metric(1,4)*Metric(2,7)*Metric(3,6) + 2*P(5,4)*Metric(1,4)*Metric(2,7)*Metric(3,6) + P(5,6)*Metric(1,4)*Metric(2,7)*Metric(3,6) + P(5,7)*Metric(1,4)*Metric(2,7)*Metric(3,6) + 4*P(4,1)*Metric(1,5)*Metric(2,7)*Metric(3,6) - P(4,2)*Metric(1,5)*Metric(2,7)*Metric(3,6) - P(4,3)*Metric(1,5)*Metric(2,7)*Metric(3,6) - 2*P(4,5)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(6,2)*Metric(1,5)*Metric(2,4)*Metric(3,7) + P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7) - 2*P(6,7)*Metric(1,5)*Metric(2,4)*Metric(3,7) + P(5,2)*Metric(1,6)*Metric(2,4)*Metric(3,7) + P(5,4)*Metric(1,6)*Metric(2,4)*Metric(3,7) - 2*P(5,7)*Metric(1,6)*Metric(2,4)*Metric(3,7) - 4*P(6,1)*Metric(1,4)*Metric(2,5)*Metric(3,7) + 2*P(6,4)*Metric(1,4)*Metric(2,5)*Metric(3,7) + P(6,5)*Metric(1,4)*Metric(2,5)*Metric(3,7) + P(6,7)*Metric(1,4)*Metric(2,5)*Metric(3,7) + 4*P(4,1)*Metric(1,6)*Metric(2,5)*Metric(3,7) - P(4,2)*Metric(1,6)*Metric(2,5)*Metric(3,7) - P(4,3)*Metric(1,6)*Metric(2,5)*Metric(3,7) - 2*P(4,6)*Metric(1,6)*Metric(2,5)*Metric(3,7) - 4*P(5,1)*Metric(1,4)*Metric(2,6)*Metric(3,7) + 2*P(5,4)*Metric(1,4)*Metric(2,6)*Metric(3,7) + P(5,6)*Metric(1,4)*Metric(2,6)*Metric(3,7) + P(5,7)*Metric(1,4)*Metric(2,6)*Metric(3,7) + 4*P(4,1)*Metric(1,5)*Metric(2,6)*Metric(3,7) - P(4,2)*Metric(1,5)*Metric(2,6)*Metric(3,7) - P(4,3)*Metric(1,5)*Metric(2,6)*Metric(3,7) - 2*P(4,5)*Metric(1,5)*Metric(2,6)*Metric(3,7) + P(7,2)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(7,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(7,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(6,2)*Metric(1,7)*Metric(2,3)*Metric(4,5) + P(6,3)*Metric(1,7)*Metric(2,3)*Metric(4,5) - 2*P(6,5)*Metric(1,7)*Metric(2,3)*Metric(4,5) - 4*P(7,1)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(7,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(7,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(7,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 4*P(3,1)*Metric(1,7)*Metric(2,6)*Metric(4,5) - P(3,2)*Metric(1,7)*Metric(2,6)*Metric(4,5) - P(3,4)*Metric(1,7)*Metric(2,6)*Metric(4,5) - 2*P(3,7)*Metric(1,7)*Metric(2,6)*Metric(4,5) - 4*P(6,1)*Metric(1,3)*Metric(2,7)*Metric(4,5) + 2*P(6,3)*Metric(1,3)*Metric(2,7)*Metric(4,5) + P(6,5)*Metric(1,3)*Metric(2,7)*Metric(4,5) + P(6,7)*Metric(1,3)*Metric(2,7)*Metric(4,5) + 4*P(3,1)*Metric(1,6)*Metric(2,7)*Metric(4,5) - P(3,2)*Metric(1,6)*Metric(2,7)*Metric(4,5) - P(3,4)*Metric(1,6)*Metric(2,7)*Metric(4,5) - 2*P(3,6)*Metric(1,6)*Metric(2,7)*Metric(4,5) - 4*P(7,1)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(7,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(7,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(7,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 4*P(2,1)*Metric(1,7)*Metric(3,6)*Metric(4,5) - P(2,3)*Metric(1,7)*Metric(3,6)*Metric(4,5) - P(2,4)*Metric(1,7)*Metric(3,6)*Metric(4,5) - 2*P(2,7)*Metric(1,7)*Metric(3,6)*Metric(4,5) - 2*P(1,2)*Metric(2,7)*Metric(3,6)*Metric(4,5) - 2*P(1,3)*Metric(2,7)*Metric(3,6)*Metric(4,5) - 2*P(1,4)*Metric(2,7)*Metric(3,6)*Metric(4,5) + 2*P(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,5) + 2*P(1,6)*Metric(2,7)*Metric(3,6)*Metric(4,5) + 2*P(1,7)*Metric(2,7)*Metric(3,6)*Metric(4,5) - 4*P(6,1)*Metric(1,2)*Metric(3,7)*Metric(4,5) + 2*P(6,2)*Metric(1,2)*Metric(3,7)*Metric(4,5) + P(6,5)*Metric(1,2)*Metric(3,7)*Metric(4,5) + P(6,7)*Metric(1,2)*Metric(3,7)*Metric(4,5) + 4*P(2,1)*Metric(1,6)*Metric(3,7)*Metric(4,5) - P(2,3)*Metric(1,6)*Metric(3,7)*Metric(4,5) - P(2,4)*Metric(1,6)*Metric(3,7)*Metric(4,5) - 2*P(2,6)*Metric(1,6)*Metric(3,7)*Metric(4,5) - 2*P(1,2)*Metric(2,6)*Metric(3,7)*Metric(4,5) - 2*P(1,3)*Metric(2,6)*Metric(3,7)*Metric(4,5) - 2*P(1,4)*Metric(2,6)*Metric(3,7)*Metric(4,5) + 2*P(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,5) + 2*P(1,6)*Metric(2,6)*Metric(3,7)*Metric(4,5) + 2*P(1,7)*Metric(2,6)*Metric(3,7)*Metric(4,5) + P(7,2)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(7,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) - 2*P(7,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(5,2)*Metric(1,7)*Metric(2,3)*Metric(4,6) + P(5,3)*Metric(1,7)*Metric(2,3)*Metric(4,6) - 2*P(5,6)*Metric(1,7)*Metric(2,3)*Metric(4,6) - 4*P(7,1)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(7,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(7,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(7,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 4*P(3,1)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(3,2)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(3,4)*Metric(1,7)*Metric(2,5)*Metric(4,6) - 2*P(3,7)*Metric(1,7)*Metric(2,5)*Metric(4,6) - 4*P(5,1)*Metric(1,3)*Metric(2,7)*Metric(4,6) + 2*P(5,3)*Metric(1,3)*Metric(2,7)*Metric(4,6) + P(5,6)*Metric(1,3)*Metric(2,7)*Metric(4,6) + P(5,7)*Metric(1,3)*Metric(2,7)*Metric(4,6) + 4*P(3,1)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(3,2)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(3,4)*Metric(1,5)*Metric(2,7)*Metric(4,6) - 2*P(3,5)*Metric(1,5)*Metric(2,7)*Metric(4,6) - 4*P(7,1)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(7,2)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(7,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(7,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 4*P(2,1)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,3)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6) - 2*P(2,7)*Metric(1,7)*Metric(3,5)*Metric(4,6) - 2*P(1,2)*Metric(2,7)*Metric(3,5)*Metric(4,6) - 2*P(1,3)*Metric(2,7)*Metric(3,5)*Metric(4,6) - 2*P(1,4)*Metric(2,7)*Metric(3,5)*Metric(4,6) + 2*P(1,5)*Metric(2,7)*Metric(3,5)*Metric(4,6) + 2*P(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,6) + 2*P(1,7)*Metric(2,7)*Metric(3,5)*Metric(4,6) - 4*P(5,1)*Metric(1,2)*Metric(3,7)*Metric(4,6) + 2*P(5,2)*Metric(1,2)*Metric(3,7)*Metric(4,6) + P(5,6)*Metric(1,2)*Metric(3,7)*Metric(4,6) + P(5,7)*Metric(1,2)*Metric(3,7)*Metric(4,6) + 4*P(2,1)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,3)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6) - 2*P(2,5)*Metric(1,5)*Metric(3,7)*Metric(4,6) - 2*P(1,2)*Metric(2,5)*Metric(3,7)*Metric(4,6) - 2*P(1,3)*Metric(2,5)*Metric(3,7)*Metric(4,6) - 2*P(1,4)*Metric(2,5)*Metric(3,7)*Metric(4,6) + 2*P(1,5)*Metric(2,5)*Metric(3,7)*Metric(4,6) + 2*P(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,6) + 2*P(1,7)*Metric(2,5)*Metric(3,7)*Metric(4,6) + P(6,2)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(6,3)*Metric(1,5)*Metric(2,3)*Metric(4,7) - 2*P(6,7)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(5,2)*Metric(1,6)*Metric(2,3)*Metric(4,7) + P(5,3)*Metric(1,6)*Metric(2,3)*Metric(4,7) - 2*P(5,7)*Metric(1,6)*Metric(2,3)*Metric(4,7) - 4*P(6,1)*Metric(1,3)*Metric(2,5)*Metric(4,7) + 2*P(6,3)*Metric(1,3)*Metric(2,5)*Metric(4,7) + P(6,5)*Metric(1,3)*Metric(2,5)*Metric(4,7) + P(6,7)*Metric(1,3)*Metric(2,5)*Metric(4,7) + 4*P(3,1)*Metric(1,6)*Metric(2,5)*Metric(4,7) - P(3,2)*Metric(1,6)*Metric(2,5)*Metric(4,7) - P(3,4)*Metric(1,6)*Metric(2,5)*Metric(4,7) - 2*P(3,6)*Metric(1,6)*Metric(2,5)*Metric(4,7) - 4*P(5,1)*Metric(1,3)*Metric(2,6)*Metric(4,7) + 2*P(5,3)*Metric(1,3)*Metric(2,6)*Metric(4,7) + P(5,6)*Metric(1,3)*Metric(2,6)*Metric(4,7) + P(5,7)*Metric(1,3)*Metric(2,6)*Metric(4,7) + 4*P(3,1)*Metric(1,5)*Metric(2,6)*Metric(4,7) - P(3,2)*Metric(1,5)*Metric(2,6)*Metric(4,7) - P(3,4)*Metric(1,5)*Metric(2,6)*Metric(4,7) - 2*P(3,5)*Metric(1,5)*Metric(2,6)*Metric(4,7) - 4*P(6,1)*Metric(1,2)*Metric(3,5)*Metric(4,7) + 2*P(6,2)*Metric(1,2)*Metric(3,5)*Metric(4,7) + P(6,5)*Metric(1,2)*Metric(3,5)*Metric(4,7) + P(6,7)*Metric(1,2)*Metric(3,5)*Metric(4,7) + 4*P(2,1)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(2,3)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(2,4)*Metric(1,6)*Metric(3,5)*Metric(4,7) - 2*P(2,6)*Metric(1,6)*Metric(3,5)*Metric(4,7) - 2*P(1,2)*Metric(2,6)*Metric(3,5)*Metric(4,7) - 2*P(1,3)*Metric(2,6)*Metric(3,5)*Metric(4,7) - 2*P(1,4)*Metric(2,6)*Metric(3,5)*Metric(4,7) + 2*P(1,5)*Metric(2,6)*Metric(3,5)*Metric(4,7) + 2*P(1,6)*Metric(2,6)*Metric(3,5)*Metric(4,7) + 2*P(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,7) - 4*P(5,1)*Metric(1,2)*Metric(3,6)*Metric(4,7) + 2*P(5,2)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(5,6)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(5,7)*Metric(1,2)*Metric(3,6)*Metric(4,7) + 4*P(2,1)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(2,3)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(2,4)*Metric(1,5)*Metric(3,6)*Metric(4,7) - 2*P(2,5)*Metric(1,5)*Metric(3,6)*Metric(4,7) - 2*P(1,2)*Metric(2,5)*Metric(3,6)*Metric(4,7) - 2*P(1,3)*Metric(2,5)*Metric(3,6)*Metric(4,7) - 2*P(1,4)*Metric(2,5)*Metric(3,6)*Metric(4,7) + 2*P(1,5)*Metric(2,5)*Metric(3,6)*Metric(4,7) + 2*P(1,6)*Metric(2,5)*Metric(3,6)*Metric(4,7) + 2*P(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,7) + 8*P(7,1)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(7,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(7,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 4*P(7,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 8*P(4,1)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 2*P(4,5)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 2*P(4,6)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 4*P(4,7)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 8*P(7,1)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(7,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 4*P(7,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(7,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 8*P(3,1)*Metric(1,7)*Metric(2,4)*Metric(5,6) + 2*P(3,5)*Metric(1,7)*Metric(2,4)*Metric(5,6) + 2*P(3,6)*Metric(1,7)*Metric(2,4)*Metric(5,6) + 4*P(3,7)*Metric(1,7)*Metric(2,4)*Metric(5,6) + 2*P(4,2)*Metric(1,3)*Metric(2,7)*Metric(5,6) - P(4,5)*Metric(1,3)*Metric(2,7)*Metric(5,6) - P(4,6)*Metric(1,3)*Metric(2,7)*Metric(5,6) + 2*P(3,2)*Metric(1,4)*Metric(2,7)*Metric(5,6) - P(3,5)*Metric(1,4)*Metric(2,7)*Metric(5,6) - P(3,6)*Metric(1,4)*Metric(2,7)*Metric(5,6) + 8*P(7,1)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 4*P(7,2)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(7,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(7,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 8*P(2,1)*Metric(1,7)*Metric(3,4)*Metric(5,6) + 2*P(2,5)*Metric(1,7)*Metric(3,4)*Metric(5,6) + 2*P(2,6)*Metric(1,7)*Metric(3,4)*Metric(5,6) + 4*P(2,7)*Metric(1,7)*Metric(3,4)*Metric(5,6) + 4*P(1,2)*Metric(2,7)*Metric(3,4)*Metric(5,6) - 4*P(1,7)*Metric(2,7)*Metric(3,4)*Metric(5,6) + 2*P(4,3)*Metric(1,2)*Metric(3,7)*Metric(5,6) - P(4,5)*Metric(1,2)*Metric(3,7)*Metric(5,6) - P(4,6)*Metric(1,2)*Metric(3,7)*Metric(5,6) + 2*P(2,3)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(2,5)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(2,6)*Metric(1,4)*Metric(3,7)*Metric(5,6) + 4*P(1,3)*Metric(2,4)*Metric(3,7)*Metric(5,6) - 4*P(1,7)*Metric(2,4)*Metric(3,7)*Metric(5,6) + 2*P(3,4)*Metric(1,2)*Metric(4,7)*Metric(5,6) - P(3,5)*Metric(1,2)*Metric(4,7)*Metric(5,6) - P(3,6)*Metric(1,2)*Metric(4,7)*Metric(5,6) + 2*P(2,4)*Metric(1,3)*Metric(4,7)*Metric(5,6) - P(2,5)*Metric(1,3)*Metric(4,7)*Metric(5,6) - P(2,6)*Metric(1,3)*Metric(4,7)*Metric(5,6) + 4*P(1,4)*Metric(2,3)*Metric(4,7)*Metric(5,6) - 4*P(1,7)*Metric(2,3)*Metric(4,7)*Metric(5,6) + 8*P(6,1)*Metric(1,4)*Metric(2,3)*Metric(5,7) - 2*P(6,2)*Metric(1,4)*Metric(2,3)*Metric(5,7) - 2*P(6,3)*Metric(1,4)*Metric(2,3)*Metric(5,7) - 4*P(6,4)*Metric(1,4)*Metric(2,3)*Metric(5,7) - 8*P(4,1)*Metric(1,6)*Metric(2,3)*Metric(5,7) + 2*P(4,5)*Metric(1,6)*Metric(2,3)*Metric(5,7) + 4*P(4,6)*Metric(1,6)*Metric(2,3)*Metric(5,7) + 2*P(4,7)*Metric(1,6)*Metric(2,3)*Metric(5,7) + 8*P(6,1)*Metric(1,3)*Metric(2,4)*Metric(5,7) - 2*P(6,2)*Metric(1,3)*Metric(2,4)*Metric(5,7) - 4*P(6,3)*Metric(1,3)*Metric(2,4)*Metric(5,7) - 2*P(6,4)*Metric(1,3)*Metric(2,4)*Metric(5,7) - 8*P(3,1)*Metric(1,6)*Metric(2,4)*Metric(5,7) + 2*P(3,5)*Metric(1,6)*Metric(2,4)*Metric(5,7) + 4*P(3,6)*Metric(1,6)*Metric(2,4)*Metric(5,7) + 2*P(3,7)*Metric(1,6)*Metric(2,4)*Metric(5,7) + 2*P(4,2)*Metric(1,3)*Metric(2,6)*Metric(5,7) - P(4,5)*Metric(1,3)*Metric(2,6)*Metric(5,7) - P(4,7)*Metric(1,3)*Metric(2,6)*Metric(5,7) + 2*P(3,2)*Metric(1,4)*Metric(2,6)*Metric(5,7) - P(3,5)*Metric(1,4)*Metric(2,6)*Metric(5,7) - P(3,7)*Metric(1,4)*Metric(2,6)*Metric(5,7) + 8*P(6,1)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 4*P(6,2)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 2*P(6,3)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 2*P(6,4)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 8*P(2,1)*Metric(1,6)*Metric(3,4)*Metric(5,7) + 2*P(2,5)*Metric(1,6)*Metric(3,4)*Metric(5,7) + 4*P(2,6)*Metric(1,6)*Metric(3,4)*Metric(5,7) + 2*P(2,7)*Metric(1,6)*Metric(3,4)*Metric(5,7) + 4*P(1,2)*Metric(2,6)*Metric(3,4)*Metric(5,7) - 4*P(1,6)*Metric(2,6)*Metric(3,4)*Metric(5,7) + 2*P(4,3)*Metric(1,2)*Metric(3,6)*Metric(5,7) - P(4,5)*Metric(1,2)*Metric(3,6)*Metric(5,7) - P(4,7)*Metric(1,2)*Metric(3,6)*Metric(5,7) + 2*P(2,3)*Metric(1,4)*Metric(3,6)*Metric(5,7) - P(2,5)*Metric(1,4)*Metric(3,6)*Metric(5,7) - P(2,7)*Metric(1,4)*Metric(3,6)*Metric(5,7) + 4*P(1,3)*Metric(2,4)*Metric(3,6)*Metric(5,7) - 4*P(1,6)*Metric(2,4)*Metric(3,6)*Metric(5,7) + 2*P(3,4)*Metric(1,2)*Metric(4,6)*Metric(5,7) - P(3,5)*Metric(1,2)*Metric(4,6)*Metric(5,7) - P(3,7)*Metric(1,2)*Metric(4,6)*Metric(5,7) + 2*P(2,4)*Metric(1,3)*Metric(4,6)*Metric(5,7) - P(2,5)*Metric(1,3)*Metric(4,6)*Metric(5,7) - P(2,7)*Metric(1,3)*Metric(4,6)*Metric(5,7) + 4*P(1,4)*Metric(2,3)*Metric(4,6)*Metric(5,7) - 4*P(1,6)*Metric(2,3)*Metric(4,6)*Metric(5,7) + 8*P(5,1)*Metric(1,4)*Metric(2,3)*Metric(6,7) - 2*P(5,2)*Metric(1,4)*Metric(2,3)*Metric(6,7) - 2*P(5,3)*Metric(1,4)*Metric(2,3)*Metric(6,7) - 4*P(5,4)*Metric(1,4)*Metric(2,3)*Metric(6,7) - 8*P(4,1)*Metric(1,5)*Metric(2,3)*Metric(6,7) + 4*P(4,5)*Metric(1,5)*Metric(2,3)*Metric(6,7) + 2*P(4,6)*Metric(1,5)*Metric(2,3)*Metric(6,7) + 2*P(4,7)*Metric(1,5)*Metric(2,3)*Metric(6,7) + 8*P(5,1)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 2*P(5,2)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 4*P(5,3)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 2*P(5,4)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 8*P(3,1)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 4*P(3,5)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(3,6)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(3,7)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(4,2)*Metric(1,3)*Metric(2,5)*Metric(6,7) - P(4,6)*Metric(1,3)*Metric(2,5)*Metric(6,7) - P(4,7)*Metric(1,3)*Metric(2,5)*Metric(6,7) + 2*P(3,2)*Metric(1,4)*Metric(2,5)*Metric(6,7) - P(3,6)*Metric(1,4)*Metric(2,5)*Metric(6,7) - P(3,7)*Metric(1,4)*Metric(2,5)*Metric(6,7) + 8*P(5,1)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 4*P(5,2)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 2*P(5,3)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 2*P(5,4)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 8*P(2,1)*Metric(1,5)*Metric(3,4)*Metric(6,7) + 4*P(2,5)*Metric(1,5)*Metric(3,4)*Metric(6,7) + 2*P(2,6)*Metric(1,5)*Metric(3,4)*Metric(6,7) + 2*P(2,7)*Metric(1,5)*Metric(3,4)*Metric(6,7) + 4*P(1,2)*Metric(2,5)*Metric(3,4)*Metric(6,7) - 4*P(1,5)*Metric(2,5)*Metric(3,4)*Metric(6,7) + 2*P(4,3)*Metric(1,2)*Metric(3,5)*Metric(6,7) - P(4,6)*Metric(1,2)*Metric(3,5)*Metric(6,7) - P(4,7)*Metric(1,2)*Metric(3,5)*Metric(6,7) + 2*P(2,3)*Metric(1,4)*Metric(3,5)*Metric(6,7) - P(2,6)*Metric(1,4)*Metric(3,5)*Metric(6,7) - P(2,7)*Metric(1,4)*Metric(3,5)*Metric(6,7) + 4*P(1,3)*Metric(2,4)*Metric(3,5)*Metric(6,7) - 4*P(1,5)*Metric(2,4)*Metric(3,5)*Metric(6,7) + 2*P(3,4)*Metric(1,2)*Metric(4,5)*Metric(6,7) - P(3,6)*Metric(1,2)*Metric(4,5)*Metric(6,7) - P(3,7)*Metric(1,2)*Metric(4,5)*Metric(6,7) + 2*P(2,4)*Metric(1,3)*Metric(4,5)*Metric(6,7) - P(2,6)*Metric(1,3)*Metric(4,5)*Metric(6,7) - P(2,7)*Metric(1,3)*Metric(4,5)*Metric(6,7) + 4*P(1,4)*Metric(2,3)*Metric(4,5)*Metric(6,7) - 4*P(1,5)*Metric(2,3)*Metric(4,5)*Metric(6,7)')

VVVVVVV5 = Lorentz(name = 'VVVVVVV5',
                   spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(7,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(7,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(7,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(7,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(6,2)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(6,3)*Metric(1,7)*Metric(2,5)*Metric(3,4) - P(6,4)*Metric(1,7)*Metric(2,5)*Metric(3,4) - P(6,5)*Metric(1,7)*Metric(2,5)*Metric(3,4) - (P(7,1)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(7,3)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(7,4)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(7,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(5,1)*Metric(1,7)*Metric(2,6)*Metric(3,4))/2. - P(5,2)*Metric(1,7)*Metric(2,6)*Metric(3,4) + (P(5,7)*Metric(1,7)*Metric(2,6)*Metric(3,4))/2. - (P(6,1)*Metric(1,5)*Metric(2,7)*Metric(3,4))/2. - (P(6,3)*Metric(1,5)*Metric(2,7)*Metric(3,4))/2. + (P(6,4)*Metric(1,5)*Metric(2,7)*Metric(3,4))/2. + (P(6,7)*Metric(1,5)*Metric(2,7)*Metric(3,4))/2. + (P(5,1)*Metric(1,6)*Metric(2,7)*Metric(3,4))/2. - P(5,2)*Metric(1,6)*Metric(2,7)*Metric(3,4) + (P(5,6)*Metric(1,6)*Metric(2,7)*Metric(3,4))/2. + P(7,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(7,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(7,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(7,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(6,2)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(6,3)*Metric(1,7)*Metric(2,4)*Metric(3,5) - P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5) - P(6,5)*Metric(1,7)*Metric(2,4)*Metric(3,5) - (P(7,1)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(7,3)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(7,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(7,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(4,1)*Metric(1,7)*Metric(2,6)*Metric(3,5))/2. - P(4,2)*Metric(1,7)*Metric(2,6)*Metric(3,5) + (P(4,7)*Metric(1,7)*Metric(2,6)*Metric(3,5))/2. - (P(6,1)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. - (P(6,3)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. + (P(6,5)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. + (P(6,7)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. + (P(4,1)*Metric(1,6)*Metric(2,7)*Metric(3,5))/2. - P(4,2)*Metric(1,6)*Metric(2,7)*Metric(3,5) + (P(4,6)*Metric(1,6)*Metric(2,7)*Metric(3,5))/2. - (P(7,1)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(7,2)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(7,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(7,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(5,1)*Metric(1,7)*Metric(2,4)*Metric(3,6))/2. - P(5,3)*Metric(1,7)*Metric(2,4)*Metric(3,6) + (P(5,7)*Metric(1,7)*Metric(2,4)*Metric(3,6))/2. - (P(7,1)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(7,2)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(7,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(7,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(4,1)*Metric(1,7)*Metric(2,5)*Metric(3,6))/2. - P(4,3)*Metric(1,7)*Metric(2,5)*Metric(3,6) + (P(4,7)*Metric(1,7)*Metric(2,5)*Metric(3,6))/2. + (P(5,2)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. + (P(5,3)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. - P(5,4)*Metric(1,4)*Metric(2,7)*Metric(3,6) + (P(4,2)*Metric(1,5)*Metric(2,7)*Metric(3,6))/2. + (P(4,3)*Metric(1,5)*Metric(2,7)*Metric(3,6))/2. - P(4,5)*Metric(1,5)*Metric(2,7)*Metric(3,6) - (P(6,1)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. - (P(6,2)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. + (P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. + (P(6,7)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. + (P(5,1)*Metric(1,6)*Metric(2,4)*Metric(3,7))/2. - P(5,3)*Metric(1,6)*Metric(2,4)*Metric(3,7) + (P(5,6)*Metric(1,6)*Metric(2,4)*Metric(3,7))/2. - (P(6,1)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. - (P(6,2)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. + (P(6,5)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. + (P(6,7)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. + (P(4,1)*Metric(1,6)*Metric(2,5)*Metric(3,7))/2. - P(4,3)*Metric(1,6)*Metric(2,5)*Metric(3,7) + (P(4,6)*Metric(1,6)*Metric(2,5)*Metric(3,7))/2. + (P(5,2)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. + (P(5,3)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. - P(5,4)*Metric(1,4)*Metric(2,6)*Metric(3,7) + (P(4,2)*Metric(1,5)*Metric(2,6)*Metric(3,7))/2. + (P(4,3)*Metric(1,5)*Metric(2,6)*Metric(3,7))/2. - P(4,5)*Metric(1,5)*Metric(2,6)*Metric(3,7) + 2*P(7,2)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(7,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(7,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(7,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(6,2)*Metric(1,7)*Metric(2,3)*Metric(4,5) + 2*P(6,3)*Metric(1,7)*Metric(2,3)*Metric(4,5) - 2*P(6,4)*Metric(1,7)*Metric(2,3)*Metric(4,5) - 2*P(6,5)*Metric(1,7)*Metric(2,3)*Metric(4,5) - P(7,1)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(7,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(7,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(7,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(3,1)*Metric(1,7)*Metric(2,6)*Metric(4,5) - 2*P(3,2)*Metric(1,7)*Metric(2,6)*Metric(4,5) + P(3,7)*Metric(1,7)*Metric(2,6)*Metric(4,5) - P(6,1)*Metric(1,3)*Metric(2,7)*Metric(4,5) + P(6,4)*Metric(1,3)*Metric(2,7)*Metric(4,5) + P(6,5)*Metric(1,3)*Metric(2,7)*Metric(4,5) - P(6,7)*Metric(1,3)*Metric(2,7)*Metric(4,5) + P(3,1)*Metric(1,6)*Metric(2,7)*Metric(4,5) - 2*P(3,2)*Metric(1,6)*Metric(2,7)*Metric(4,5) + P(3,6)*Metric(1,6)*Metric(2,7)*Metric(4,5) - P(7,1)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(7,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(7,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(7,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(2,1)*Metric(1,7)*Metric(3,6)*Metric(4,5) - 2*P(2,3)*Metric(1,7)*Metric(3,6)*Metric(4,5) + P(2,7)*Metric(1,7)*Metric(3,6)*Metric(4,5) + P(1,4)*Metric(2,7)*Metric(3,6)*Metric(4,5) + P(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,6)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,7)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(6,1)*Metric(1,2)*Metric(3,7)*Metric(4,5) + P(6,4)*Metric(1,2)*Metric(3,7)*Metric(4,5) + P(6,5)*Metric(1,2)*Metric(3,7)*Metric(4,5) - P(6,7)*Metric(1,2)*Metric(3,7)*Metric(4,5) + P(2,1)*Metric(1,6)*Metric(3,7)*Metric(4,5) - 2*P(2,3)*Metric(1,6)*Metric(3,7)*Metric(4,5) + P(2,6)*Metric(1,6)*Metric(3,7)*Metric(4,5) + P(1,4)*Metric(2,6)*Metric(3,7)*Metric(4,5) + P(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,5) - P(1,6)*Metric(2,6)*Metric(3,7)*Metric(4,5) - P(1,7)*Metric(2,6)*Metric(3,7)*Metric(4,5) + P(7,1)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(7,2)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(7,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(7,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(5,1)*Metric(1,7)*Metric(2,3)*Metric(4,6) + 2*P(5,4)*Metric(1,7)*Metric(2,3)*Metric(4,6) - P(5,7)*Metric(1,7)*Metric(2,3)*Metric(4,6) + (P(7,1)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(7,2)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(7,5)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(7,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(3,1)*Metric(1,7)*Metric(2,5)*Metric(4,6))/2. + P(3,4)*Metric(1,7)*Metric(2,5)*Metric(4,6) - (P(3,7)*Metric(1,7)*Metric(2,5)*Metric(4,6))/2. + (P(5,2)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. + (P(5,3)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. - P(5,4)*Metric(1,3)*Metric(2,7)*Metric(4,6) + P(3,2)*Metric(1,5)*Metric(2,7)*Metric(4,6) - (P(3,4)*Metric(1,5)*Metric(2,7)*Metric(4,6))/2. - (P(3,5)*Metric(1,5)*Metric(2,7)*Metric(4,6))/2. + (P(7,1)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(7,3)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + (P(7,5)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(7,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(2,1)*Metric(1,7)*Metric(3,5)*Metric(4,6))/2. + P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6) - (P(2,7)*Metric(1,7)*Metric(3,5)*Metric(4,6))/2. - (P(1,3)*Metric(2,7)*Metric(3,5)*Metric(4,6))/2. + (P(1,5)*Metric(2,7)*Metric(3,5)*Metric(4,6))/2. - (P(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,6))/2. + (P(1,7)*Metric(2,7)*Metric(3,5)*Metric(4,6))/2. + (P(5,2)*Metric(1,2)*Metric(3,7)*Metric(4,6))/2. + (P(5,3)*Metric(1,2)*Metric(3,7)*Metric(4,6))/2. - P(5,4)*Metric(1,2)*Metric(3,7)*Metric(4,6) + P(2,3)*Metric(1,5)*Metric(3,7)*Metric(4,6) - (P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. - (P(2,5)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. - (P(1,2)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. + (P(1,5)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. - (P(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. + (P(1,7)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. + P(6,1)*Metric(1,5)*Metric(2,3)*Metric(4,7) - P(6,2)*Metric(1,5)*Metric(2,3)*Metric(4,7) - P(6,3)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(6,7)*Metric(1,5)*Metric(2,3)*Metric(4,7) - P(5,1)*Metric(1,6)*Metric(2,3)*Metric(4,7) + 2*P(5,4)*Metric(1,6)*Metric(2,3)*Metric(4,7) - P(5,6)*Metric(1,6)*Metric(2,3)*Metric(4,7) + (P(6,1)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. - (P(6,2)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. + (P(6,5)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. - (P(6,7)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. - (P(3,1)*Metric(1,6)*Metric(2,5)*Metric(4,7))/2. + P(3,4)*Metric(1,6)*Metric(2,5)*Metric(4,7) - (P(3,6)*Metric(1,6)*Metric(2,5)*Metric(4,7))/2. + (P(5,2)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. + (P(5,3)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. - P(5,4)*Metric(1,3)*Metric(2,6)*Metric(4,7) + P(3,2)*Metric(1,5)*Metric(2,6)*Metric(4,7) - (P(3,4)*Metric(1,5)*Metric(2,6)*Metric(4,7))/2. - (P(3,5)*Metric(1,5)*Metric(2,6)*Metric(4,7))/2. + (P(6,1)*Metric(1,2)*Metric(3,5)*Metric(4,7))/2. - (P(6,3)*Metric(1,2)*Metric(3,5)*Metric(4,7))/2. + (P(6,5)*Metric(1,2)*Metric(3,5)*Metric(4,7))/2. - (P(6,7)*Metric(1,2)*Metric(3,5)*Metric(4,7))/2. - (P(2,1)*Metric(1,6)*Metric(3,5)*Metric(4,7))/2. + P(2,4)*Metric(1,6)*Metric(3,5)*Metric(4,7) - (P(2,6)*Metric(1,6)*Metric(3,5)*Metric(4,7))/2. - (P(1,3)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (P(1,5)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (P(1,6)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. - (P(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (P(5,2)*Metric(1,2)*Metric(3,6)*Metric(4,7))/2. + (P(5,3)*Metric(1,2)*Metric(3,6)*Metric(4,7))/2. - P(5,4)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(2,3)*Metric(1,5)*Metric(3,6)*Metric(4,7) - (P(2,4)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. - (P(2,5)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. - (P(1,2)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. + (P(1,5)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. + (P(1,6)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. - (P(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. + P(7,1)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(7,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(7,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(7,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(4,1)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 2*P(4,5)*Metric(1,7)*Metric(2,3)*Metric(5,6) - P(4,7)*Metric(1,7)*Metric(2,3)*Metric(5,6) + (P(7,1)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(7,2)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + (P(7,4)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(7,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(3,1)*Metric(1,7)*Metric(2,4)*Metric(5,6))/2. + P(3,5)*Metric(1,7)*Metric(2,4)*Metric(5,6) - (P(3,7)*Metric(1,7)*Metric(2,4)*Metric(5,6))/2. + (P(4,2)*Metric(1,3)*Metric(2,7)*Metric(5,6))/2. + (P(4,3)*Metric(1,3)*Metric(2,7)*Metric(5,6))/2. - P(4,5)*Metric(1,3)*Metric(2,7)*Metric(5,6) + P(3,2)*Metric(1,4)*Metric(2,7)*Metric(5,6) - (P(3,4)*Metric(1,4)*Metric(2,7)*Metric(5,6))/2. - (P(3,5)*Metric(1,4)*Metric(2,7)*Metric(5,6))/2. + (P(7,1)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. - (P(7,3)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. + (P(7,4)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. - (P(7,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. - (P(2,1)*Metric(1,7)*Metric(3,4)*Metric(5,6))/2. + P(2,5)*Metric(1,7)*Metric(3,4)*Metric(5,6) - (P(2,7)*Metric(1,7)*Metric(3,4)*Metric(5,6))/2. - (P(1,3)*Metric(2,7)*Metric(3,4)*Metric(5,6))/2. + (P(1,4)*Metric(2,7)*Metric(3,4)*Metric(5,6))/2. - (P(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,6))/2. + (P(1,7)*Metric(2,7)*Metric(3,4)*Metric(5,6))/2. + (P(4,2)*Metric(1,2)*Metric(3,7)*Metric(5,6))/2. + (P(4,3)*Metric(1,2)*Metric(3,7)*Metric(5,6))/2. - P(4,5)*Metric(1,2)*Metric(3,7)*Metric(5,6) + P(2,3)*Metric(1,4)*Metric(3,7)*Metric(5,6) - (P(2,4)*Metric(1,4)*Metric(3,7)*Metric(5,6))/2. - (P(2,5)*Metric(1,4)*Metric(3,7)*Metric(5,6))/2. - (P(1,2)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. + (P(1,4)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. - (P(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. + (P(1,7)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. + P(3,2)*Metric(1,2)*Metric(4,7)*Metric(5,6) - (P(3,4)*Metric(1,2)*Metric(4,7)*Metric(5,6))/2. - (P(3,5)*Metric(1,2)*Metric(4,7)*Metric(5,6))/2. + P(2,3)*Metric(1,3)*Metric(4,7)*Metric(5,6) - (P(2,4)*Metric(1,3)*Metric(4,7)*Metric(5,6))/2. - (P(2,5)*Metric(1,3)*Metric(4,7)*Metric(5,6))/2. - P(1,2)*Metric(2,3)*Metric(4,7)*Metric(5,6) - P(1,3)*Metric(2,3)*Metric(4,7)*Metric(5,6) + P(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,6) + P(1,7)*Metric(2,3)*Metric(4,7)*Metric(5,6) + P(6,1)*Metric(1,4)*Metric(2,3)*Metric(5,7) - P(6,2)*Metric(1,4)*Metric(2,3)*Metric(5,7) - P(6,3)*Metric(1,4)*Metric(2,3)*Metric(5,7) + P(6,7)*Metric(1,4)*Metric(2,3)*Metric(5,7) - P(4,1)*Metric(1,6)*Metric(2,3)*Metric(5,7) + 2*P(4,5)*Metric(1,6)*Metric(2,3)*Metric(5,7) - P(4,6)*Metric(1,6)*Metric(2,3)*Metric(5,7) + (P(6,1)*Metric(1,3)*Metric(2,4)*Metric(5,7))/2. - (P(6,2)*Metric(1,3)*Metric(2,4)*Metric(5,7))/2. + (P(6,4)*Metric(1,3)*Metric(2,4)*Metric(5,7))/2. - (P(6,7)*Metric(1,3)*Metric(2,4)*Metric(5,7))/2. - (P(3,1)*Metric(1,6)*Metric(2,4)*Metric(5,7))/2. + P(3,5)*Metric(1,6)*Metric(2,4)*Metric(5,7) - (P(3,6)*Metric(1,6)*Metric(2,4)*Metric(5,7))/2. + (P(4,2)*Metric(1,3)*Metric(2,6)*Metric(5,7))/2. + (P(4,3)*Metric(1,3)*Metric(2,6)*Metric(5,7))/2. - P(4,5)*Metric(1,3)*Metric(2,6)*Metric(5,7) + P(3,2)*Metric(1,4)*Metric(2,6)*Metric(5,7) - (P(3,4)*Metric(1,4)*Metric(2,6)*Metric(5,7))/2. - (P(3,5)*Metric(1,4)*Metric(2,6)*Metric(5,7))/2. + (P(6,1)*Metric(1,2)*Metric(3,4)*Metric(5,7))/2. - (P(6,3)*Metric(1,2)*Metric(3,4)*Metric(5,7))/2. + (P(6,4)*Metric(1,2)*Metric(3,4)*Metric(5,7))/2. - (P(6,7)*Metric(1,2)*Metric(3,4)*Metric(5,7))/2. - (P(2,1)*Metric(1,6)*Metric(3,4)*Metric(5,7))/2. + P(2,5)*Metric(1,6)*Metric(3,4)*Metric(5,7) - (P(2,6)*Metric(1,6)*Metric(3,4)*Metric(5,7))/2. - (P(1,3)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. + (P(1,4)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. + (P(1,6)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. - (P(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. + (P(4,2)*Metric(1,2)*Metric(3,6)*Metric(5,7))/2. + (P(4,3)*Metric(1,2)*Metric(3,6)*Metric(5,7))/2. - P(4,5)*Metric(1,2)*Metric(3,6)*Metric(5,7) + P(2,3)*Metric(1,4)*Metric(3,6)*Metric(5,7) - (P(2,4)*Metric(1,4)*Metric(3,6)*Metric(5,7))/2. - (P(2,5)*Metric(1,4)*Metric(3,6)*Metric(5,7))/2. - (P(1,2)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. + (P(1,4)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. + (P(1,6)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. - (P(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. + P(3,2)*Metric(1,2)*Metric(4,6)*Metric(5,7) - (P(3,4)*Metric(1,2)*Metric(4,6)*Metric(5,7))/2. - (P(3,5)*Metric(1,2)*Metric(4,6)*Metric(5,7))/2. + P(2,3)*Metric(1,3)*Metric(4,6)*Metric(5,7) - (P(2,4)*Metric(1,3)*Metric(4,6)*Metric(5,7))/2. - (P(2,5)*Metric(1,3)*Metric(4,6)*Metric(5,7))/2. - P(1,2)*Metric(2,3)*Metric(4,6)*Metric(5,7) - P(1,3)*Metric(2,3)*Metric(4,6)*Metric(5,7) + P(1,6)*Metric(2,3)*Metric(4,6)*Metric(5,7) + P(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,7) + 2*P(5,4)*Metric(1,4)*Metric(2,3)*Metric(6,7) - P(5,6)*Metric(1,4)*Metric(2,3)*Metric(6,7) - P(5,7)*Metric(1,4)*Metric(2,3)*Metric(6,7) + 2*P(4,5)*Metric(1,5)*Metric(2,3)*Metric(6,7) - P(4,6)*Metric(1,5)*Metric(2,3)*Metric(6,7) - P(4,7)*Metric(1,5)*Metric(2,3)*Metric(6,7) - P(5,3)*Metric(1,3)*Metric(2,4)*Metric(6,7) + (P(5,6)*Metric(1,3)*Metric(2,4)*Metric(6,7))/2. + (P(5,7)*Metric(1,3)*Metric(2,4)*Metric(6,7))/2. + P(3,5)*Metric(1,5)*Metric(2,4)*Metric(6,7) - (P(3,6)*Metric(1,5)*Metric(2,4)*Metric(6,7))/2. - (P(3,7)*Metric(1,5)*Metric(2,4)*Metric(6,7))/2. - P(4,3)*Metric(1,3)*Metric(2,5)*Metric(6,7) + (P(4,6)*Metric(1,3)*Metric(2,5)*Metric(6,7))/2. + (P(4,7)*Metric(1,3)*Metric(2,5)*Metric(6,7))/2. + P(3,4)*Metric(1,4)*Metric(2,5)*Metric(6,7) - (P(3,6)*Metric(1,4)*Metric(2,5)*Metric(6,7))/2. - (P(3,7)*Metric(1,4)*Metric(2,5)*Metric(6,7))/2. - P(5,2)*Metric(1,2)*Metric(3,4)*Metric(6,7) + (P(5,6)*Metric(1,2)*Metric(3,4)*Metric(6,7))/2. + (P(5,7)*Metric(1,2)*Metric(3,4)*Metric(6,7))/2. + P(2,5)*Metric(1,5)*Metric(3,4)*Metric(6,7) - (P(2,6)*Metric(1,5)*Metric(3,4)*Metric(6,7))/2. - (P(2,7)*Metric(1,5)*Metric(3,4)*Metric(6,7))/2. + P(1,2)*Metric(2,5)*Metric(3,4)*Metric(6,7) + P(1,3)*Metric(2,5)*Metric(3,4)*Metric(6,7) - P(1,4)*Metric(2,5)*Metric(3,4)*Metric(6,7) - P(1,5)*Metric(2,5)*Metric(3,4)*Metric(6,7) - P(4,2)*Metric(1,2)*Metric(3,5)*Metric(6,7) + (P(4,6)*Metric(1,2)*Metric(3,5)*Metric(6,7))/2. + (P(4,7)*Metric(1,2)*Metric(3,5)*Metric(6,7))/2. + P(2,4)*Metric(1,4)*Metric(3,5)*Metric(6,7) - (P(2,6)*Metric(1,4)*Metric(3,5)*Metric(6,7))/2. - (P(2,7)*Metric(1,4)*Metric(3,5)*Metric(6,7))/2. + P(1,2)*Metric(2,4)*Metric(3,5)*Metric(6,7) + P(1,3)*Metric(2,4)*Metric(3,5)*Metric(6,7) - P(1,4)*Metric(2,4)*Metric(3,5)*Metric(6,7) - P(1,5)*Metric(2,4)*Metric(3,5)*Metric(6,7) - 2*P(3,2)*Metric(1,2)*Metric(4,5)*Metric(6,7) + P(3,6)*Metric(1,2)*Metric(4,5)*Metric(6,7) + P(3,7)*Metric(1,2)*Metric(4,5)*Metric(6,7) - 2*P(2,3)*Metric(1,3)*Metric(4,5)*Metric(6,7) + P(2,6)*Metric(1,3)*Metric(4,5)*Metric(6,7) + P(2,7)*Metric(1,3)*Metric(4,5)*Metric(6,7) + 2*P(1,2)*Metric(2,3)*Metric(4,5)*Metric(6,7) + 2*P(1,3)*Metric(2,3)*Metric(4,5)*Metric(6,7) - 2*P(1,4)*Metric(2,3)*Metric(4,5)*Metric(6,7) - 2*P(1,5)*Metric(2,3)*Metric(4,5)*Metric(6,7)')

VVVVVVV6 = Lorentz(name = 'VVVVVVV6',
                   spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(7,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(7,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(6,2)*Metric(1,7)*Metric(2,4)*Metric(3,5) + 2*P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(7,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(7,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 2*P(4,2)*Metric(1,7)*Metric(2,6)*Metric(3,5) - 2*P(4,6)*Metric(1,7)*Metric(2,6)*Metric(3,5) - 2*P(6,1)*Metric(1,4)*Metric(2,7)*Metric(3,5) + 2*P(6,4)*Metric(1,4)*Metric(2,7)*Metric(3,5) + 2*P(4,1)*Metric(1,6)*Metric(2,7)*Metric(3,5) - 2*P(4,6)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(7,3)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(7,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - 2*P(5,2)*Metric(1,7)*Metric(2,4)*Metric(3,6) + 2*P(5,4)*Metric(1,7)*Metric(2,4)*Metric(3,6) + P(7,3)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(7,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(4,2)*Metric(1,7)*Metric(2,5)*Metric(3,6) - 2*P(4,5)*Metric(1,7)*Metric(2,5)*Metric(3,6) - 2*P(5,1)*Metric(1,4)*Metric(2,7)*Metric(3,6) + 2*P(5,4)*Metric(1,4)*Metric(2,7)*Metric(3,6) + 2*P(4,1)*Metric(1,5)*Metric(2,7)*Metric(3,6) - 2*P(4,5)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(6,2)*Metric(1,5)*Metric(2,4)*Metric(3,7) - P(6,3)*Metric(1,5)*Metric(2,4)*Metric(3,7) - P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7) + P(6,7)*Metric(1,5)*Metric(2,4)*Metric(3,7) + P(5,2)*Metric(1,6)*Metric(2,4)*Metric(3,7) - P(5,3)*Metric(1,6)*Metric(2,4)*Metric(3,7) - P(5,4)*Metric(1,6)*Metric(2,4)*Metric(3,7) + P(5,7)*Metric(1,6)*Metric(2,4)*Metric(3,7) + P(6,1)*Metric(1,4)*Metric(2,5)*Metric(3,7) - P(6,3)*Metric(1,4)*Metric(2,5)*Metric(3,7) - P(6,4)*Metric(1,4)*Metric(2,5)*Metric(3,7) + P(6,7)*Metric(1,4)*Metric(2,5)*Metric(3,7) - P(4,1)*Metric(1,6)*Metric(2,5)*Metric(3,7) - P(4,2)*Metric(1,6)*Metric(2,5)*Metric(3,7) + P(4,5)*Metric(1,6)*Metric(2,5)*Metric(3,7) + P(4,6)*Metric(1,6)*Metric(2,5)*Metric(3,7) + P(5,1)*Metric(1,4)*Metric(2,6)*Metric(3,7) - P(5,3)*Metric(1,4)*Metric(2,6)*Metric(3,7) - P(5,4)*Metric(1,4)*Metric(2,6)*Metric(3,7) + P(5,7)*Metric(1,4)*Metric(2,6)*Metric(3,7) - P(4,1)*Metric(1,5)*Metric(2,6)*Metric(3,7) - P(4,2)*Metric(1,5)*Metric(2,6)*Metric(3,7) + P(4,5)*Metric(1,5)*Metric(2,6)*Metric(3,7) + P(4,6)*Metric(1,5)*Metric(2,6)*Metric(3,7) + P(7,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(7,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(6,2)*Metric(1,7)*Metric(2,3)*Metric(4,5) + 2*P(6,3)*Metric(1,7)*Metric(2,3)*Metric(4,5) + P(7,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(7,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(3,2)*Metric(1,7)*Metric(2,6)*Metric(4,5) - 2*P(3,6)*Metric(1,7)*Metric(2,6)*Metric(4,5) - 2*P(6,1)*Metric(1,3)*Metric(2,7)*Metric(4,5) + 2*P(6,3)*Metric(1,3)*Metric(2,7)*Metric(4,5) + 2*P(3,1)*Metric(1,6)*Metric(2,7)*Metric(4,5) - 2*P(3,6)*Metric(1,6)*Metric(2,7)*Metric(4,5) - 2*P(7,3)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(7,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(7,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(7,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(2,3)*Metric(1,7)*Metric(3,6)*Metric(4,5) - 2*P(2,4)*Metric(1,7)*Metric(3,6)*Metric(4,5) + 2*P(2,5)*Metric(1,7)*Metric(3,6)*Metric(4,5) + 2*P(2,6)*Metric(1,7)*Metric(3,6)*Metric(4,5) - 2*P(1,3)*Metric(2,7)*Metric(3,6)*Metric(4,5) - 2*P(1,4)*Metric(2,7)*Metric(3,6)*Metric(4,5) + 2*P(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,5) + 2*P(1,6)*Metric(2,7)*Metric(3,6)*Metric(4,5) + 2*P(6,3)*Metric(1,2)*Metric(3,7)*Metric(4,5) - 2*P(6,7)*Metric(1,2)*Metric(3,7)*Metric(4,5) + P(2,4)*Metric(1,6)*Metric(3,7)*Metric(4,5) - P(2,5)*Metric(1,6)*Metric(3,7)*Metric(4,5) + P(1,4)*Metric(2,6)*Metric(3,7)*Metric(4,5) - P(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,5) + P(7,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(7,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - 2*P(5,2)*Metric(1,7)*Metric(2,3)*Metric(4,6) + 2*P(5,3)*Metric(1,7)*Metric(2,3)*Metric(4,6) + P(7,4)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(7,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(3,2)*Metric(1,7)*Metric(2,5)*Metric(4,6) - 2*P(3,5)*Metric(1,7)*Metric(2,5)*Metric(4,6) - 2*P(5,1)*Metric(1,3)*Metric(2,7)*Metric(4,6) + 2*P(5,3)*Metric(1,3)*Metric(2,7)*Metric(4,6) + 2*P(3,1)*Metric(1,5)*Metric(2,7)*Metric(4,6) - 2*P(3,5)*Metric(1,5)*Metric(2,7)*Metric(4,6) - 2*P(7,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(7,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(7,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(7,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(2,3)*Metric(1,7)*Metric(3,5)*Metric(4,6) - 2*P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6) + 2*P(2,5)*Metric(1,7)*Metric(3,5)*Metric(4,6) + 2*P(2,6)*Metric(1,7)*Metric(3,5)*Metric(4,6) - 2*P(1,3)*Metric(2,7)*Metric(3,5)*Metric(4,6) - 2*P(1,4)*Metric(2,7)*Metric(3,5)*Metric(4,6) + 2*P(1,5)*Metric(2,7)*Metric(3,5)*Metric(4,6) + 2*P(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,6) + 2*P(5,3)*Metric(1,2)*Metric(3,7)*Metric(4,6) - 2*P(5,7)*Metric(1,2)*Metric(3,7)*Metric(4,6) + P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,6)*Metric(1,5)*Metric(3,7)*Metric(4,6) + P(1,4)*Metric(2,5)*Metric(3,7)*Metric(4,6) - P(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,6) + P(6,2)*Metric(1,5)*Metric(2,3)*Metric(4,7) - P(6,3)*Metric(1,5)*Metric(2,3)*Metric(4,7) - P(6,4)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(6,7)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(5,2)*Metric(1,6)*Metric(2,3)*Metric(4,7) - P(5,3)*Metric(1,6)*Metric(2,3)*Metric(4,7) - P(5,4)*Metric(1,6)*Metric(2,3)*Metric(4,7) + P(5,7)*Metric(1,6)*Metric(2,3)*Metric(4,7) + P(6,1)*Metric(1,3)*Metric(2,5)*Metric(4,7) - P(6,3)*Metric(1,3)*Metric(2,5)*Metric(4,7) - P(6,4)*Metric(1,3)*Metric(2,5)*Metric(4,7) + P(6,7)*Metric(1,3)*Metric(2,5)*Metric(4,7) - P(3,1)*Metric(1,6)*Metric(2,5)*Metric(4,7) - P(3,2)*Metric(1,6)*Metric(2,5)*Metric(4,7) + P(3,5)*Metric(1,6)*Metric(2,5)*Metric(4,7) + P(3,6)*Metric(1,6)*Metric(2,5)*Metric(4,7) + P(5,1)*Metric(1,3)*Metric(2,6)*Metric(4,7) - P(5,3)*Metric(1,3)*Metric(2,6)*Metric(4,7) - P(5,4)*Metric(1,3)*Metric(2,6)*Metric(4,7) + P(5,7)*Metric(1,3)*Metric(2,6)*Metric(4,7) - P(3,1)*Metric(1,5)*Metric(2,6)*Metric(4,7) - P(3,2)*Metric(1,5)*Metric(2,6)*Metric(4,7) + P(3,5)*Metric(1,5)*Metric(2,6)*Metric(4,7) + P(3,6)*Metric(1,5)*Metric(2,6)*Metric(4,7) + 2*P(6,4)*Metric(1,2)*Metric(3,5)*Metric(4,7) - 2*P(6,7)*Metric(1,2)*Metric(3,5)*Metric(4,7) + P(2,3)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(2,5)*Metric(1,6)*Metric(3,5)*Metric(4,7) + P(1,3)*Metric(2,6)*Metric(3,5)*Metric(4,7) - P(1,5)*Metric(2,6)*Metric(3,5)*Metric(4,7) + 2*P(5,4)*Metric(1,2)*Metric(3,6)*Metric(4,7) - 2*P(5,7)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(2,3)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(2,6)*Metric(1,5)*Metric(3,6)*Metric(4,7) + P(1,3)*Metric(2,5)*Metric(3,6)*Metric(4,7) - P(1,6)*Metric(2,5)*Metric(3,6)*Metric(4,7) + P(6,1)*Metric(1,4)*Metric(2,3)*Metric(5,7) + P(6,2)*Metric(1,4)*Metric(2,3)*Metric(5,7) - P(6,3)*Metric(1,4)*Metric(2,3)*Metric(5,7) - P(6,4)*Metric(1,4)*Metric(2,3)*Metric(5,7) - P(4,1)*Metric(1,6)*Metric(2,3)*Metric(5,7) + P(4,5)*Metric(1,6)*Metric(2,3)*Metric(5,7) + P(4,6)*Metric(1,6)*Metric(2,3)*Metric(5,7) - P(4,7)*Metric(1,6)*Metric(2,3)*Metric(5,7) + P(6,1)*Metric(1,3)*Metric(2,4)*Metric(5,7) + P(6,2)*Metric(1,3)*Metric(2,4)*Metric(5,7) - P(6,3)*Metric(1,3)*Metric(2,4)*Metric(5,7) - P(6,4)*Metric(1,3)*Metric(2,4)*Metric(5,7) - P(3,1)*Metric(1,6)*Metric(2,4)*Metric(5,7) + P(3,5)*Metric(1,6)*Metric(2,4)*Metric(5,7) + P(3,6)*Metric(1,6)*Metric(2,4)*Metric(5,7) - P(3,7)*Metric(1,6)*Metric(2,4)*Metric(5,7) - P(4,2)*Metric(1,3)*Metric(2,6)*Metric(5,7) + P(4,5)*Metric(1,3)*Metric(2,6)*Metric(5,7) + P(4,6)*Metric(1,3)*Metric(2,6)*Metric(5,7) - P(4,7)*Metric(1,3)*Metric(2,6)*Metric(5,7) - P(3,2)*Metric(1,4)*Metric(2,6)*Metric(5,7) + P(3,5)*Metric(1,4)*Metric(2,6)*Metric(5,7) + P(3,6)*Metric(1,4)*Metric(2,6)*Metric(5,7) - P(3,7)*Metric(1,4)*Metric(2,6)*Metric(5,7) - 2*P(4,5)*Metric(1,2)*Metric(3,6)*Metric(5,7) + 2*P(4,7)*Metric(1,2)*Metric(3,6)*Metric(5,7) + P(2,3)*Metric(1,4)*Metric(3,6)*Metric(5,7) - P(2,6)*Metric(1,4)*Metric(3,6)*Metric(5,7) + P(1,3)*Metric(2,4)*Metric(3,6)*Metric(5,7) - P(1,6)*Metric(2,4)*Metric(3,6)*Metric(5,7) - 2*P(3,5)*Metric(1,2)*Metric(4,6)*Metric(5,7) + 2*P(3,7)*Metric(1,2)*Metric(4,6)*Metric(5,7) + P(2,4)*Metric(1,3)*Metric(4,6)*Metric(5,7) - P(2,6)*Metric(1,3)*Metric(4,6)*Metric(5,7) + P(1,4)*Metric(2,3)*Metric(4,6)*Metric(5,7) - P(1,6)*Metric(2,3)*Metric(4,6)*Metric(5,7) + P(5,1)*Metric(1,4)*Metric(2,3)*Metric(6,7) + P(5,2)*Metric(1,4)*Metric(2,3)*Metric(6,7) - P(5,3)*Metric(1,4)*Metric(2,3)*Metric(6,7) - P(5,4)*Metric(1,4)*Metric(2,3)*Metric(6,7) - P(4,1)*Metric(1,5)*Metric(2,3)*Metric(6,7) + P(4,5)*Metric(1,5)*Metric(2,3)*Metric(6,7) + P(4,6)*Metric(1,5)*Metric(2,3)*Metric(6,7) - P(4,7)*Metric(1,5)*Metric(2,3)*Metric(6,7) + P(5,1)*Metric(1,3)*Metric(2,4)*Metric(6,7) + P(5,2)*Metric(1,3)*Metric(2,4)*Metric(6,7) - P(5,3)*Metric(1,3)*Metric(2,4)*Metric(6,7) - P(5,4)*Metric(1,3)*Metric(2,4)*Metric(6,7) - P(3,1)*Metric(1,5)*Metric(2,4)*Metric(6,7) + P(3,5)*Metric(1,5)*Metric(2,4)*Metric(6,7) + P(3,6)*Metric(1,5)*Metric(2,4)*Metric(6,7) - P(3,7)*Metric(1,5)*Metric(2,4)*Metric(6,7) - P(4,2)*Metric(1,3)*Metric(2,5)*Metric(6,7) + P(4,5)*Metric(1,3)*Metric(2,5)*Metric(6,7) + P(4,6)*Metric(1,3)*Metric(2,5)*Metric(6,7) - P(4,7)*Metric(1,3)*Metric(2,5)*Metric(6,7) - P(3,2)*Metric(1,4)*Metric(2,5)*Metric(6,7) + P(3,5)*Metric(1,4)*Metric(2,5)*Metric(6,7) + P(3,6)*Metric(1,4)*Metric(2,5)*Metric(6,7) - P(3,7)*Metric(1,4)*Metric(2,5)*Metric(6,7) - 2*P(4,6)*Metric(1,2)*Metric(3,5)*Metric(6,7) + 2*P(4,7)*Metric(1,2)*Metric(3,5)*Metric(6,7) + P(2,3)*Metric(1,4)*Metric(3,5)*Metric(6,7) - P(2,5)*Metric(1,4)*Metric(3,5)*Metric(6,7) + P(1,3)*Metric(2,4)*Metric(3,5)*Metric(6,7) - P(1,5)*Metric(2,4)*Metric(3,5)*Metric(6,7) - 2*P(3,6)*Metric(1,2)*Metric(4,5)*Metric(6,7) + 2*P(3,7)*Metric(1,2)*Metric(4,5)*Metric(6,7) + P(2,4)*Metric(1,3)*Metric(4,5)*Metric(6,7) - P(2,5)*Metric(1,3)*Metric(4,5)*Metric(6,7) + P(1,4)*Metric(2,3)*Metric(4,5)*Metric(6,7) - P(1,5)*Metric(2,3)*Metric(4,5)*Metric(6,7)')

VVVVVVV7 = Lorentz(name = 'VVVVVVV7',
                   spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(7,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(7,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(7,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(7,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(6,2)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(6,3)*Metric(1,7)*Metric(2,5)*Metric(3,4) - P(6,4)*Metric(1,7)*Metric(2,5)*Metric(3,4) - P(6,5)*Metric(1,7)*Metric(2,5)*Metric(3,4) - (P(7,1)*Metric(1,5)*Metric(2,6)*Metric(3,4))/6. - (P(7,3)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(7,4)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(7,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/6. + (P(5,1)*Metric(1,7)*Metric(2,6)*Metric(3,4))/6. - P(5,2)*Metric(1,7)*Metric(2,6)*Metric(3,4) + (2*P(5,6)*Metric(1,7)*Metric(2,6)*Metric(3,4))/3. + (P(5,7)*Metric(1,7)*Metric(2,6)*Metric(3,4))/6. - (P(6,1)*Metric(1,5)*Metric(2,7)*Metric(3,4))/6. - (P(6,3)*Metric(1,5)*Metric(2,7)*Metric(3,4))/2. + (P(6,4)*Metric(1,5)*Metric(2,7)*Metric(3,4))/2. + (P(6,7)*Metric(1,5)*Metric(2,7)*Metric(3,4))/6. + (P(5,1)*Metric(1,6)*Metric(2,7)*Metric(3,4))/6. - P(5,2)*Metric(1,6)*Metric(2,7)*Metric(3,4) + (P(5,6)*Metric(1,6)*Metric(2,7)*Metric(3,4))/6. + (2*P(5,7)*Metric(1,6)*Metric(2,7)*Metric(3,4))/3. + P(7,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(7,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(7,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(7,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(6,2)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(6,3)*Metric(1,7)*Metric(2,4)*Metric(3,5) - P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5) - P(6,5)*Metric(1,7)*Metric(2,4)*Metric(3,5) - (P(7,1)*Metric(1,4)*Metric(2,6)*Metric(3,5))/6. - (P(7,3)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(7,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(7,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/6. + (P(4,1)*Metric(1,7)*Metric(2,6)*Metric(3,5))/6. - P(4,2)*Metric(1,7)*Metric(2,6)*Metric(3,5) + (2*P(4,6)*Metric(1,7)*Metric(2,6)*Metric(3,5))/3. + (P(4,7)*Metric(1,7)*Metric(2,6)*Metric(3,5))/6. - (P(6,1)*Metric(1,4)*Metric(2,7)*Metric(3,5))/6. - (P(6,3)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. + (P(6,5)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. + (P(6,7)*Metric(1,4)*Metric(2,7)*Metric(3,5))/6. + (P(4,1)*Metric(1,6)*Metric(2,7)*Metric(3,5))/6. - P(4,2)*Metric(1,6)*Metric(2,7)*Metric(3,5) + (P(4,6)*Metric(1,6)*Metric(2,7)*Metric(3,5))/6. + (2*P(4,7)*Metric(1,6)*Metric(2,7)*Metric(3,5))/3. - (P(7,1)*Metric(1,5)*Metric(2,4)*Metric(3,6))/6. - (P(7,2)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(7,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(7,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/6. + (P(5,1)*Metric(1,7)*Metric(2,4)*Metric(3,6))/6. - P(5,3)*Metric(1,7)*Metric(2,4)*Metric(3,6) + (2*P(5,6)*Metric(1,7)*Metric(2,4)*Metric(3,6))/3. + (P(5,7)*Metric(1,7)*Metric(2,4)*Metric(3,6))/6. - (P(7,1)*Metric(1,4)*Metric(2,5)*Metric(3,6))/6. - (P(7,2)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(7,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(7,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/6. + (P(4,1)*Metric(1,7)*Metric(2,5)*Metric(3,6))/6. - P(4,3)*Metric(1,7)*Metric(2,5)*Metric(3,6) + (2*P(4,6)*Metric(1,7)*Metric(2,5)*Metric(3,6))/3. + (P(4,7)*Metric(1,7)*Metric(2,5)*Metric(3,6))/6. + (P(5,2)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. + (P(5,3)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. - (P(5,4)*Metric(1,4)*Metric(2,7)*Metric(3,6))/3. - (P(5,6)*Metric(1,4)*Metric(2,7)*Metric(3,6))/3. - (P(5,7)*Metric(1,4)*Metric(2,7)*Metric(3,6))/3. + (P(4,2)*Metric(1,5)*Metric(2,7)*Metric(3,6))/2. + (P(4,3)*Metric(1,5)*Metric(2,7)*Metric(3,6))/2. - (P(4,5)*Metric(1,5)*Metric(2,7)*Metric(3,6))/3. - (P(4,6)*Metric(1,5)*Metric(2,7)*Metric(3,6))/3. - (P(4,7)*Metric(1,5)*Metric(2,7)*Metric(3,6))/3. - (P(6,1)*Metric(1,5)*Metric(2,4)*Metric(3,7))/6. - (P(6,2)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. + (P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. + (P(6,7)*Metric(1,5)*Metric(2,4)*Metric(3,7))/6. + (P(5,1)*Metric(1,6)*Metric(2,4)*Metric(3,7))/6. - P(5,3)*Metric(1,6)*Metric(2,4)*Metric(3,7) + (P(5,6)*Metric(1,6)*Metric(2,4)*Metric(3,7))/6. + (2*P(5,7)*Metric(1,6)*Metric(2,4)*Metric(3,7))/3. - (P(6,1)*Metric(1,4)*Metric(2,5)*Metric(3,7))/6. - (P(6,2)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. + (P(6,5)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. + (P(6,7)*Metric(1,4)*Metric(2,5)*Metric(3,7))/6. + (P(4,1)*Metric(1,6)*Metric(2,5)*Metric(3,7))/6. - P(4,3)*Metric(1,6)*Metric(2,5)*Metric(3,7) + (P(4,6)*Metric(1,6)*Metric(2,5)*Metric(3,7))/6. + (2*P(4,7)*Metric(1,6)*Metric(2,5)*Metric(3,7))/3. + (P(5,2)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. + (P(5,3)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. - (P(5,4)*Metric(1,4)*Metric(2,6)*Metric(3,7))/3. - (P(5,6)*Metric(1,4)*Metric(2,6)*Metric(3,7))/3. - (P(5,7)*Metric(1,4)*Metric(2,6)*Metric(3,7))/3. + (P(4,2)*Metric(1,5)*Metric(2,6)*Metric(3,7))/2. + (P(4,3)*Metric(1,5)*Metric(2,6)*Metric(3,7))/2. - (P(4,5)*Metric(1,5)*Metric(2,6)*Metric(3,7))/3. - (P(4,6)*Metric(1,5)*Metric(2,6)*Metric(3,7))/3. - (P(4,7)*Metric(1,5)*Metric(2,6)*Metric(3,7))/3. + (2*P(7,2)*Metric(1,6)*Metric(2,3)*Metric(4,5))/3. + (2*P(7,3)*Metric(1,6)*Metric(2,3)*Metric(4,5))/3. - (2*P(7,4)*Metric(1,6)*Metric(2,3)*Metric(4,5))/3. - (2*P(7,5)*Metric(1,6)*Metric(2,3)*Metric(4,5))/3. + (2*P(6,2)*Metric(1,7)*Metric(2,3)*Metric(4,5))/3. + (2*P(6,3)*Metric(1,7)*Metric(2,3)*Metric(4,5))/3. - (2*P(6,4)*Metric(1,7)*Metric(2,3)*Metric(4,5))/3. - (2*P(6,5)*Metric(1,7)*Metric(2,3)*Metric(4,5))/3. - (P(7,1)*Metric(1,3)*Metric(2,6)*Metric(4,5))/3. + (P(7,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/3. + (P(7,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/3. - (P(7,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/3. + (P(3,1)*Metric(1,7)*Metric(2,6)*Metric(4,5))/3. - (2*P(3,2)*Metric(1,7)*Metric(2,6)*Metric(4,5))/3. + (P(3,7)*Metric(1,7)*Metric(2,6)*Metric(4,5))/3. - (P(6,1)*Metric(1,3)*Metric(2,7)*Metric(4,5))/3. + (P(6,4)*Metric(1,3)*Metric(2,7)*Metric(4,5))/3. + (P(6,5)*Metric(1,3)*Metric(2,7)*Metric(4,5))/3. - (P(6,7)*Metric(1,3)*Metric(2,7)*Metric(4,5))/3. + (P(3,1)*Metric(1,6)*Metric(2,7)*Metric(4,5))/3. - (2*P(3,2)*Metric(1,6)*Metric(2,7)*Metric(4,5))/3. + (P(3,6)*Metric(1,6)*Metric(2,7)*Metric(4,5))/3. - (P(7,1)*Metric(1,2)*Metric(3,6)*Metric(4,5))/3. + (P(7,4)*Metric(1,2)*Metric(3,6)*Metric(4,5))/3. + (P(7,5)*Metric(1,2)*Metric(3,6)*Metric(4,5))/3. - (P(7,6)*Metric(1,2)*Metric(3,6)*Metric(4,5))/3. + (P(2,1)*Metric(1,7)*Metric(3,6)*Metric(4,5))/3. - (2*P(2,3)*Metric(1,7)*Metric(3,6)*Metric(4,5))/3. + (P(2,7)*Metric(1,7)*Metric(3,6)*Metric(4,5))/3. + (P(1,4)*Metric(2,7)*Metric(3,6)*Metric(4,5))/3. + (P(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,5))/3. - (P(1,6)*Metric(2,7)*Metric(3,6)*Metric(4,5))/3. - (P(1,7)*Metric(2,7)*Metric(3,6)*Metric(4,5))/3. - (P(6,1)*Metric(1,2)*Metric(3,7)*Metric(4,5))/3. + (P(6,4)*Metric(1,2)*Metric(3,7)*Metric(4,5))/3. + (P(6,5)*Metric(1,2)*Metric(3,7)*Metric(4,5))/3. - (P(6,7)*Metric(1,2)*Metric(3,7)*Metric(4,5))/3. + (P(2,1)*Metric(1,6)*Metric(3,7)*Metric(4,5))/3. - (2*P(2,3)*Metric(1,6)*Metric(3,7)*Metric(4,5))/3. + (P(2,6)*Metric(1,6)*Metric(3,7)*Metric(4,5))/3. + (P(1,4)*Metric(2,6)*Metric(3,7)*Metric(4,5))/3. + (P(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,5))/3. - (P(1,6)*Metric(2,6)*Metric(3,7)*Metric(4,5))/3. - (P(1,7)*Metric(2,6)*Metric(3,7)*Metric(4,5))/3. + (P(7,1)*Metric(1,5)*Metric(2,3)*Metric(4,6))/3. - (P(7,2)*Metric(1,5)*Metric(2,3)*Metric(4,6))/3. - (P(7,3)*Metric(1,5)*Metric(2,3)*Metric(4,6))/3. + (P(7,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/3. - (P(5,1)*Metric(1,7)*Metric(2,3)*Metric(4,6))/3. + (2*P(5,4)*Metric(1,7)*Metric(2,3)*Metric(4,6))/3. - (P(5,7)*Metric(1,7)*Metric(2,3)*Metric(4,6))/3. + (P(7,1)*Metric(1,3)*Metric(2,5)*Metric(4,6))/6. - (P(7,2)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(7,5)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(7,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/6. - (P(3,1)*Metric(1,7)*Metric(2,5)*Metric(4,6))/6. + P(3,4)*Metric(1,7)*Metric(2,5)*Metric(4,6) - (2*P(3,6)*Metric(1,7)*Metric(2,5)*Metric(4,6))/3. - (P(3,7)*Metric(1,7)*Metric(2,5)*Metric(4,6))/6. - (P(5,1)*Metric(1,3)*Metric(2,7)*Metric(4,6))/3. + (P(5,2)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. + (P(5,3)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. - (P(5,4)*Metric(1,3)*Metric(2,7)*Metric(4,6))/3. - (P(5,7)*Metric(1,3)*Metric(2,7)*Metric(4,6))/3. + (P(3,1)*Metric(1,5)*Metric(2,7)*Metric(4,6))/3. + (P(3,2)*Metric(1,5)*Metric(2,7)*Metric(4,6))/3. - (P(3,4)*Metric(1,5)*Metric(2,7)*Metric(4,6))/2. - (P(3,5)*Metric(1,5)*Metric(2,7)*Metric(4,6))/2. + (P(3,6)*Metric(1,5)*Metric(2,7)*Metric(4,6))/3. + (P(7,1)*Metric(1,2)*Metric(3,5)*Metric(4,6))/6. - (P(7,3)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + (P(7,5)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(7,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/6. - (P(2,1)*Metric(1,7)*Metric(3,5)*Metric(4,6))/6. + P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6) - (2*P(2,6)*Metric(1,7)*Metric(3,5)*Metric(4,6))/3. - (P(2,7)*Metric(1,7)*Metric(3,5)*Metric(4,6))/6. - (P(1,3)*Metric(2,7)*Metric(3,5)*Metric(4,6))/2. + (P(1,5)*Metric(2,7)*Metric(3,5)*Metric(4,6))/2. - (P(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,6))/6. + (P(1,7)*Metric(2,7)*Metric(3,5)*Metric(4,6))/6. - (P(5,1)*Metric(1,2)*Metric(3,7)*Metric(4,6))/3. + (P(5,2)*Metric(1,2)*Metric(3,7)*Metric(4,6))/2. + (P(5,3)*Metric(1,2)*Metric(3,7)*Metric(4,6))/2. - (P(5,4)*Metric(1,2)*Metric(3,7)*Metric(4,6))/3. - (P(5,7)*Metric(1,2)*Metric(3,7)*Metric(4,6))/3. + (P(2,1)*Metric(1,5)*Metric(3,7)*Metric(4,6))/3. + (P(2,3)*Metric(1,5)*Metric(3,7)*Metric(4,6))/3. - (P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. - (P(2,5)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. + (P(2,6)*Metric(1,5)*Metric(3,7)*Metric(4,6))/3. - (P(1,2)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. + (P(1,5)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. - (P(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,6))/6. + (P(1,7)*Metric(2,5)*Metric(3,7)*Metric(4,6))/6. + (P(6,1)*Metric(1,5)*Metric(2,3)*Metric(4,7))/3. - (P(6,2)*Metric(1,5)*Metric(2,3)*Metric(4,7))/3. - (P(6,3)*Metric(1,5)*Metric(2,3)*Metric(4,7))/3. + (P(6,7)*Metric(1,5)*Metric(2,3)*Metric(4,7))/3. - (P(5,1)*Metric(1,6)*Metric(2,3)*Metric(4,7))/3. + (2*P(5,4)*Metric(1,6)*Metric(2,3)*Metric(4,7))/3. - (P(5,6)*Metric(1,6)*Metric(2,3)*Metric(4,7))/3. + (P(6,1)*Metric(1,3)*Metric(2,5)*Metric(4,7))/6. - (P(6,2)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. + (P(6,5)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. - (P(6,7)*Metric(1,3)*Metric(2,5)*Metric(4,7))/6. - (P(3,1)*Metric(1,6)*Metric(2,5)*Metric(4,7))/6. + P(3,4)*Metric(1,6)*Metric(2,5)*Metric(4,7) - (P(3,6)*Metric(1,6)*Metric(2,5)*Metric(4,7))/6. - (2*P(3,7)*Metric(1,6)*Metric(2,5)*Metric(4,7))/3. - (P(5,1)*Metric(1,3)*Metric(2,6)*Metric(4,7))/3. + (P(5,2)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. + (P(5,3)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. - (P(5,4)*Metric(1,3)*Metric(2,6)*Metric(4,7))/3. - (P(5,6)*Metric(1,3)*Metric(2,6)*Metric(4,7))/3. + (P(3,1)*Metric(1,5)*Metric(2,6)*Metric(4,7))/3. + (P(3,2)*Metric(1,5)*Metric(2,6)*Metric(4,7))/3. - (P(3,4)*Metric(1,5)*Metric(2,6)*Metric(4,7))/2. - (P(3,5)*Metric(1,5)*Metric(2,6)*Metric(4,7))/2. + (P(3,7)*Metric(1,5)*Metric(2,6)*Metric(4,7))/3. + (P(6,1)*Metric(1,2)*Metric(3,5)*Metric(4,7))/6. - (P(6,3)*Metric(1,2)*Metric(3,5)*Metric(4,7))/2. + (P(6,5)*Metric(1,2)*Metric(3,5)*Metric(4,7))/2. - (P(6,7)*Metric(1,2)*Metric(3,5)*Metric(4,7))/6. - (P(2,1)*Metric(1,6)*Metric(3,5)*Metric(4,7))/6. + P(2,4)*Metric(1,6)*Metric(3,5)*Metric(4,7) - (P(2,6)*Metric(1,6)*Metric(3,5)*Metric(4,7))/6. - (2*P(2,7)*Metric(1,6)*Metric(3,5)*Metric(4,7))/3. - (P(1,3)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (P(1,5)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (P(1,6)*Metric(2,6)*Metric(3,5)*Metric(4,7))/6. - (P(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,7))/6. - (P(5,1)*Metric(1,2)*Metric(3,6)*Metric(4,7))/3. + (P(5,2)*Metric(1,2)*Metric(3,6)*Metric(4,7))/2. + (P(5,3)*Metric(1,2)*Metric(3,6)*Metric(4,7))/2. - (P(5,4)*Metric(1,2)*Metric(3,6)*Metric(4,7))/3. - (P(5,6)*Metric(1,2)*Metric(3,6)*Metric(4,7))/3. + (P(2,1)*Metric(1,5)*Metric(3,6)*Metric(4,7))/3. + (P(2,3)*Metric(1,5)*Metric(3,6)*Metric(4,7))/3. - (P(2,4)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. - (P(2,5)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. + (P(2,7)*Metric(1,5)*Metric(3,6)*Metric(4,7))/3. - (P(1,2)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. + (P(1,5)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. + (P(1,6)*Metric(2,5)*Metric(3,6)*Metric(4,7))/6. - (P(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,7))/6. + (P(7,1)*Metric(1,4)*Metric(2,3)*Metric(5,6))/3. - (P(7,2)*Metric(1,4)*Metric(2,3)*Metric(5,6))/3. - (P(7,3)*Metric(1,4)*Metric(2,3)*Metric(5,6))/3. + (P(7,6)*Metric(1,4)*Metric(2,3)*Metric(5,6))/3. - (P(4,1)*Metric(1,7)*Metric(2,3)*Metric(5,6))/3. + (2*P(4,5)*Metric(1,7)*Metric(2,3)*Metric(5,6))/3. - (P(4,7)*Metric(1,7)*Metric(2,3)*Metric(5,6))/3. + (P(7,1)*Metric(1,3)*Metric(2,4)*Metric(5,6))/6. - (P(7,2)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + (P(7,4)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(7,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/6. - (P(3,1)*Metric(1,7)*Metric(2,4)*Metric(5,6))/6. + P(3,5)*Metric(1,7)*Metric(2,4)*Metric(5,6) - (2*P(3,6)*Metric(1,7)*Metric(2,4)*Metric(5,6))/3. - (P(3,7)*Metric(1,7)*Metric(2,4)*Metric(5,6))/6. - (P(4,1)*Metric(1,3)*Metric(2,7)*Metric(5,6))/3. + (P(4,2)*Metric(1,3)*Metric(2,7)*Metric(5,6))/2. + (P(4,3)*Metric(1,3)*Metric(2,7)*Metric(5,6))/2. - (P(4,5)*Metric(1,3)*Metric(2,7)*Metric(5,6))/3. - (P(4,7)*Metric(1,3)*Metric(2,7)*Metric(5,6))/3. + (P(3,1)*Metric(1,4)*Metric(2,7)*Metric(5,6))/3. + (P(3,2)*Metric(1,4)*Metric(2,7)*Metric(5,6))/3. - (P(3,4)*Metric(1,4)*Metric(2,7)*Metric(5,6))/2. - (P(3,5)*Metric(1,4)*Metric(2,7)*Metric(5,6))/2. + (P(3,6)*Metric(1,4)*Metric(2,7)*Metric(5,6))/3. + (P(7,1)*Metric(1,2)*Metric(3,4)*Metric(5,6))/6. - (P(7,3)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. + (P(7,4)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. - (P(7,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/6. - (P(2,1)*Metric(1,7)*Metric(3,4)*Metric(5,6))/6. + P(2,5)*Metric(1,7)*Metric(3,4)*Metric(5,6) - (2*P(2,6)*Metric(1,7)*Metric(3,4)*Metric(5,6))/3. - (P(2,7)*Metric(1,7)*Metric(3,4)*Metric(5,6))/6. - (P(1,3)*Metric(2,7)*Metric(3,4)*Metric(5,6))/2. + (P(1,4)*Metric(2,7)*Metric(3,4)*Metric(5,6))/2. - (P(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,6))/6. + (P(1,7)*Metric(2,7)*Metric(3,4)*Metric(5,6))/6. - (P(4,1)*Metric(1,2)*Metric(3,7)*Metric(5,6))/3. + (P(4,2)*Metric(1,2)*Metric(3,7)*Metric(5,6))/2. + (P(4,3)*Metric(1,2)*Metric(3,7)*Metric(5,6))/2. - (P(4,5)*Metric(1,2)*Metric(3,7)*Metric(5,6))/3. - (P(4,7)*Metric(1,2)*Metric(3,7)*Metric(5,6))/3. + (P(2,1)*Metric(1,4)*Metric(3,7)*Metric(5,6))/3. + (P(2,3)*Metric(1,4)*Metric(3,7)*Metric(5,6))/3. - (P(2,4)*Metric(1,4)*Metric(3,7)*Metric(5,6))/2. - (P(2,5)*Metric(1,4)*Metric(3,7)*Metric(5,6))/2. + (P(2,6)*Metric(1,4)*Metric(3,7)*Metric(5,6))/3. - (P(1,2)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. + (P(1,4)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. - (P(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,6))/6. + (P(1,7)*Metric(2,4)*Metric(3,7)*Metric(5,6))/6. + (P(3,2)*Metric(1,2)*Metric(4,7)*Metric(5,6))/3. - (P(3,4)*Metric(1,2)*Metric(4,7)*Metric(5,6))/2. - (P(3,5)*Metric(1,2)*Metric(4,7)*Metric(5,6))/2. + (P(3,6)*Metric(1,2)*Metric(4,7)*Metric(5,6))/3. + (P(3,7)*Metric(1,2)*Metric(4,7)*Metric(5,6))/3. + (P(2,3)*Metric(1,3)*Metric(4,7)*Metric(5,6))/3. - (P(2,4)*Metric(1,3)*Metric(4,7)*Metric(5,6))/2. - (P(2,5)*Metric(1,3)*Metric(4,7)*Metric(5,6))/2. + (P(2,6)*Metric(1,3)*Metric(4,7)*Metric(5,6))/3. + (P(2,7)*Metric(1,3)*Metric(4,7)*Metric(5,6))/3. - (P(1,2)*Metric(2,3)*Metric(4,7)*Metric(5,6))/3. - (P(1,3)*Metric(2,3)*Metric(4,7)*Metric(5,6))/3. + (P(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,6))/3. + (P(1,7)*Metric(2,3)*Metric(4,7)*Metric(5,6))/3. + (P(6,1)*Metric(1,4)*Metric(2,3)*Metric(5,7))/3. - (P(6,2)*Metric(1,4)*Metric(2,3)*Metric(5,7))/3. - (P(6,3)*Metric(1,4)*Metric(2,3)*Metric(5,7))/3. + (P(6,7)*Metric(1,4)*Metric(2,3)*Metric(5,7))/3. - (P(4,1)*Metric(1,6)*Metric(2,3)*Metric(5,7))/3. + (2*P(4,5)*Metric(1,6)*Metric(2,3)*Metric(5,7))/3. - (P(4,6)*Metric(1,6)*Metric(2,3)*Metric(5,7))/3. + (P(6,1)*Metric(1,3)*Metric(2,4)*Metric(5,7))/6. - (P(6,2)*Metric(1,3)*Metric(2,4)*Metric(5,7))/2. + (P(6,4)*Metric(1,3)*Metric(2,4)*Metric(5,7))/2. - (P(6,7)*Metric(1,3)*Metric(2,4)*Metric(5,7))/6. - (P(3,1)*Metric(1,6)*Metric(2,4)*Metric(5,7))/6. + P(3,5)*Metric(1,6)*Metric(2,4)*Metric(5,7) - (P(3,6)*Metric(1,6)*Metric(2,4)*Metric(5,7))/6. - (2*P(3,7)*Metric(1,6)*Metric(2,4)*Metric(5,7))/3. - (P(4,1)*Metric(1,3)*Metric(2,6)*Metric(5,7))/3. + (P(4,2)*Metric(1,3)*Metric(2,6)*Metric(5,7))/2. + (P(4,3)*Metric(1,3)*Metric(2,6)*Metric(5,7))/2. - (P(4,5)*Metric(1,3)*Metric(2,6)*Metric(5,7))/3. - (P(4,6)*Metric(1,3)*Metric(2,6)*Metric(5,7))/3. + (P(3,1)*Metric(1,4)*Metric(2,6)*Metric(5,7))/3. + (P(3,2)*Metric(1,4)*Metric(2,6)*Metric(5,7))/3. - (P(3,4)*Metric(1,4)*Metric(2,6)*Metric(5,7))/2. - (P(3,5)*Metric(1,4)*Metric(2,6)*Metric(5,7))/2. + (P(3,7)*Metric(1,4)*Metric(2,6)*Metric(5,7))/3. + (P(6,1)*Metric(1,2)*Metric(3,4)*Metric(5,7))/6. - (P(6,3)*Metric(1,2)*Metric(3,4)*Metric(5,7))/2. + (P(6,4)*Metric(1,2)*Metric(3,4)*Metric(5,7))/2. - (P(6,7)*Metric(1,2)*Metric(3,4)*Metric(5,7))/6. - (P(2,1)*Metric(1,6)*Metric(3,4)*Metric(5,7))/6. + P(2,5)*Metric(1,6)*Metric(3,4)*Metric(5,7) - (P(2,6)*Metric(1,6)*Metric(3,4)*Metric(5,7))/6. - (2*P(2,7)*Metric(1,6)*Metric(3,4)*Metric(5,7))/3. - (P(1,3)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. + (P(1,4)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. + (P(1,6)*Metric(2,6)*Metric(3,4)*Metric(5,7))/6. - (P(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,7))/6. - (P(4,1)*Metric(1,2)*Metric(3,6)*Metric(5,7))/3. + (P(4,2)*Metric(1,2)*Metric(3,6)*Metric(5,7))/2. + (P(4,3)*Metric(1,2)*Metric(3,6)*Metric(5,7))/2. - (P(4,5)*Metric(1,2)*Metric(3,6)*Metric(5,7))/3. - (P(4,6)*Metric(1,2)*Metric(3,6)*Metric(5,7))/3. + (P(2,1)*Metric(1,4)*Metric(3,6)*Metric(5,7))/3. + (P(2,3)*Metric(1,4)*Metric(3,6)*Metric(5,7))/3. - (P(2,4)*Metric(1,4)*Metric(3,6)*Metric(5,7))/2. - (P(2,5)*Metric(1,4)*Metric(3,6)*Metric(5,7))/2. + (P(2,7)*Metric(1,4)*Metric(3,6)*Metric(5,7))/3. - (P(1,2)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. + (P(1,4)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. + (P(1,6)*Metric(2,4)*Metric(3,6)*Metric(5,7))/6. - (P(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,7))/6. + (P(3,2)*Metric(1,2)*Metric(4,6)*Metric(5,7))/3. - (P(3,4)*Metric(1,2)*Metric(4,6)*Metric(5,7))/2. - (P(3,5)*Metric(1,2)*Metric(4,6)*Metric(5,7))/2. + (P(3,6)*Metric(1,2)*Metric(4,6)*Metric(5,7))/3. + (P(3,7)*Metric(1,2)*Metric(4,6)*Metric(5,7))/3. + (P(2,3)*Metric(1,3)*Metric(4,6)*Metric(5,7))/3. - (P(2,4)*Metric(1,3)*Metric(4,6)*Metric(5,7))/2. - (P(2,5)*Metric(1,3)*Metric(4,6)*Metric(5,7))/2. + (P(2,6)*Metric(1,3)*Metric(4,6)*Metric(5,7))/3. + (P(2,7)*Metric(1,3)*Metric(4,6)*Metric(5,7))/3. - (P(1,2)*Metric(2,3)*Metric(4,6)*Metric(5,7))/3. - (P(1,3)*Metric(2,3)*Metric(4,6)*Metric(5,7))/3. + (P(1,6)*Metric(2,3)*Metric(4,6)*Metric(5,7))/3. + (P(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,7))/3. + (2*P(5,4)*Metric(1,4)*Metric(2,3)*Metric(6,7))/3. - (P(5,6)*Metric(1,4)*Metric(2,3)*Metric(6,7))/3. - (P(5,7)*Metric(1,4)*Metric(2,3)*Metric(6,7))/3. + (2*P(4,5)*Metric(1,5)*Metric(2,3)*Metric(6,7))/3. - (P(4,6)*Metric(1,5)*Metric(2,3)*Metric(6,7))/3. - (P(4,7)*Metric(1,5)*Metric(2,3)*Metric(6,7))/3. + (2*P(5,1)*Metric(1,3)*Metric(2,4)*Metric(6,7))/3. - P(5,3)*Metric(1,3)*Metric(2,4)*Metric(6,7) + (P(5,6)*Metric(1,3)*Metric(2,4)*Metric(6,7))/6. + (P(5,7)*Metric(1,3)*Metric(2,4)*Metric(6,7))/6. - (2*P(3,1)*Metric(1,5)*Metric(2,4)*Metric(6,7))/3. + P(3,5)*Metric(1,5)*Metric(2,4)*Metric(6,7) - (P(3,6)*Metric(1,5)*Metric(2,4)*Metric(6,7))/6. - (P(3,7)*Metric(1,5)*Metric(2,4)*Metric(6,7))/6. + (2*P(4,1)*Metric(1,3)*Metric(2,5)*Metric(6,7))/3. - P(4,3)*Metric(1,3)*Metric(2,5)*Metric(6,7) + (P(4,6)*Metric(1,3)*Metric(2,5)*Metric(6,7))/6. + (P(4,7)*Metric(1,3)*Metric(2,5)*Metric(6,7))/6. - (2*P(3,1)*Metric(1,4)*Metric(2,5)*Metric(6,7))/3. + P(3,4)*Metric(1,4)*Metric(2,5)*Metric(6,7) - (P(3,6)*Metric(1,4)*Metric(2,5)*Metric(6,7))/6. - (P(3,7)*Metric(1,4)*Metric(2,5)*Metric(6,7))/6. + (2*P(5,1)*Metric(1,2)*Metric(3,4)*Metric(6,7))/3. - P(5,2)*Metric(1,2)*Metric(3,4)*Metric(6,7) + (P(5,6)*Metric(1,2)*Metric(3,4)*Metric(6,7))/6. + (P(5,7)*Metric(1,2)*Metric(3,4)*Metric(6,7))/6. - (2*P(2,1)*Metric(1,5)*Metric(3,4)*Metric(6,7))/3. + P(2,5)*Metric(1,5)*Metric(3,4)*Metric(6,7) - (P(2,6)*Metric(1,5)*Metric(3,4)*Metric(6,7))/6. - (P(2,7)*Metric(1,5)*Metric(3,4)*Metric(6,7))/6. + P(1,2)*Metric(2,5)*Metric(3,4)*Metric(6,7) + P(1,3)*Metric(2,5)*Metric(3,4)*Metric(6,7) - P(1,4)*Metric(2,5)*Metric(3,4)*Metric(6,7) - P(1,5)*Metric(2,5)*Metric(3,4)*Metric(6,7) + (2*P(4,1)*Metric(1,2)*Metric(3,5)*Metric(6,7))/3. - P(4,2)*Metric(1,2)*Metric(3,5)*Metric(6,7) + (P(4,6)*Metric(1,2)*Metric(3,5)*Metric(6,7))/6. + (P(4,7)*Metric(1,2)*Metric(3,5)*Metric(6,7))/6. - (2*P(2,1)*Metric(1,4)*Metric(3,5)*Metric(6,7))/3. + P(2,4)*Metric(1,4)*Metric(3,5)*Metric(6,7) - (P(2,6)*Metric(1,4)*Metric(3,5)*Metric(6,7))/6. - (P(2,7)*Metric(1,4)*Metric(3,5)*Metric(6,7))/6. + P(1,2)*Metric(2,4)*Metric(3,5)*Metric(6,7) + P(1,3)*Metric(2,4)*Metric(3,5)*Metric(6,7) - P(1,4)*Metric(2,4)*Metric(3,5)*Metric(6,7) - P(1,5)*Metric(2,4)*Metric(3,5)*Metric(6,7) - (2*P(3,2)*Metric(1,2)*Metric(4,5)*Metric(6,7))/3. + (P(3,6)*Metric(1,2)*Metric(4,5)*Metric(6,7))/3. + (P(3,7)*Metric(1,2)*Metric(4,5)*Metric(6,7))/3. - (2*P(2,3)*Metric(1,3)*Metric(4,5)*Metric(6,7))/3. + (P(2,6)*Metric(1,3)*Metric(4,5)*Metric(6,7))/3. + (P(2,7)*Metric(1,3)*Metric(4,5)*Metric(6,7))/3. + (2*P(1,2)*Metric(2,3)*Metric(4,5)*Metric(6,7))/3. + (2*P(1,3)*Metric(2,3)*Metric(4,5)*Metric(6,7))/3. - (2*P(1,4)*Metric(2,3)*Metric(4,5)*Metric(6,7))/3. - (2*P(1,5)*Metric(2,3)*Metric(4,5)*Metric(6,7))/3.')

VVVVVVV8 = Lorentz(name = 'VVVVVVV8',
                   spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(7,1)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(7,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(4,1)*Metric(1,7)*Metric(2,6)*Metric(3,5) + P(4,7)*Metric(1,7)*Metric(2,6)*Metric(3,5) + P(6,1)*Metric(1,4)*Metric(2,7)*Metric(3,5) - P(6,4)*Metric(1,4)*Metric(2,7)*Metric(3,5) - P(4,1)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(4,6)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(7,1)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(7,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(4,1)*Metric(1,7)*Metric(2,5)*Metric(3,6) + P(4,7)*Metric(1,7)*Metric(2,5)*Metric(3,6) + P(5,1)*Metric(1,4)*Metric(2,7)*Metric(3,6) - P(5,4)*Metric(1,4)*Metric(2,7)*Metric(3,6) - P(4,1)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(4,5)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(6,1)*Metric(1,4)*Metric(2,5)*Metric(3,7) - P(6,4)*Metric(1,4)*Metric(2,5)*Metric(3,7) - P(4,1)*Metric(1,6)*Metric(2,5)*Metric(3,7) + P(4,6)*Metric(1,6)*Metric(2,5)*Metric(3,7) + P(5,1)*Metric(1,4)*Metric(2,6)*Metric(3,7) - P(5,4)*Metric(1,4)*Metric(2,6)*Metric(3,7) - P(4,1)*Metric(1,5)*Metric(2,6)*Metric(3,7) + P(4,5)*Metric(1,5)*Metric(2,6)*Metric(3,7) + P(7,1)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(7,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(3,1)*Metric(1,7)*Metric(2,6)*Metric(4,5) + P(3,7)*Metric(1,7)*Metric(2,6)*Metric(4,5) + P(6,1)*Metric(1,3)*Metric(2,7)*Metric(4,5) - P(6,3)*Metric(1,3)*Metric(2,7)*Metric(4,5) - P(3,1)*Metric(1,6)*Metric(2,7)*Metric(4,5) + P(3,6)*Metric(1,6)*Metric(2,7)*Metric(4,5) + P(7,1)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(7,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(2,1)*Metric(1,7)*Metric(3,6)*Metric(4,5) + P(2,7)*Metric(1,7)*Metric(3,6)*Metric(4,5) + P(1,2)*Metric(2,7)*Metric(3,6)*Metric(4,5) + P(1,3)*Metric(2,7)*Metric(3,6)*Metric(4,5) + P(1,4)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,6)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,7)*Metric(2,7)*Metric(3,6)*Metric(4,5) + P(6,1)*Metric(1,2)*Metric(3,7)*Metric(4,5) - P(6,2)*Metric(1,2)*Metric(3,7)*Metric(4,5) - P(2,1)*Metric(1,6)*Metric(3,7)*Metric(4,5) + P(2,6)*Metric(1,6)*Metric(3,7)*Metric(4,5) + P(1,2)*Metric(2,6)*Metric(3,7)*Metric(4,5) + P(1,3)*Metric(2,6)*Metric(3,7)*Metric(4,5) + P(1,4)*Metric(2,6)*Metric(3,7)*Metric(4,5) - P(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,5) - P(1,6)*Metric(2,6)*Metric(3,7)*Metric(4,5) - P(1,7)*Metric(2,6)*Metric(3,7)*Metric(4,5) + P(7,1)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(7,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(3,1)*Metric(1,7)*Metric(2,5)*Metric(4,6) + P(3,7)*Metric(1,7)*Metric(2,5)*Metric(4,6) + P(5,1)*Metric(1,3)*Metric(2,7)*Metric(4,6) - P(5,3)*Metric(1,3)*Metric(2,7)*Metric(4,6) - P(3,1)*Metric(1,5)*Metric(2,7)*Metric(4,6) + P(3,5)*Metric(1,5)*Metric(2,7)*Metric(4,6) + P(7,1)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(7,2)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(2,1)*Metric(1,7)*Metric(3,5)*Metric(4,6) + P(2,7)*Metric(1,7)*Metric(3,5)*Metric(4,6) + P(1,2)*Metric(2,7)*Metric(3,5)*Metric(4,6) + P(1,3)*Metric(2,7)*Metric(3,5)*Metric(4,6) + P(1,4)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(1,5)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(1,7)*Metric(2,7)*Metric(3,5)*Metric(4,6) + P(5,1)*Metric(1,2)*Metric(3,7)*Metric(4,6) - P(5,2)*Metric(1,2)*Metric(3,7)*Metric(4,6) - P(2,1)*Metric(1,5)*Metric(3,7)*Metric(4,6) + P(2,5)*Metric(1,5)*Metric(3,7)*Metric(4,6) + P(1,2)*Metric(2,5)*Metric(3,7)*Metric(4,6) + P(1,3)*Metric(2,5)*Metric(3,7)*Metric(4,6) + P(1,4)*Metric(2,5)*Metric(3,7)*Metric(4,6) - P(1,5)*Metric(2,5)*Metric(3,7)*Metric(4,6) - P(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,6) - P(1,7)*Metric(2,5)*Metric(3,7)*Metric(4,6) + P(6,1)*Metric(1,3)*Metric(2,5)*Metric(4,7) - P(6,3)*Metric(1,3)*Metric(2,5)*Metric(4,7) - P(3,1)*Metric(1,6)*Metric(2,5)*Metric(4,7) + P(3,6)*Metric(1,6)*Metric(2,5)*Metric(4,7) + P(5,1)*Metric(1,3)*Metric(2,6)*Metric(4,7) - P(5,3)*Metric(1,3)*Metric(2,6)*Metric(4,7) - P(3,1)*Metric(1,5)*Metric(2,6)*Metric(4,7) + P(3,5)*Metric(1,5)*Metric(2,6)*Metric(4,7) + P(6,1)*Metric(1,2)*Metric(3,5)*Metric(4,7) - P(6,2)*Metric(1,2)*Metric(3,5)*Metric(4,7) - P(2,1)*Metric(1,6)*Metric(3,5)*Metric(4,7) + P(2,6)*Metric(1,6)*Metric(3,5)*Metric(4,7) + P(1,2)*Metric(2,6)*Metric(3,5)*Metric(4,7) + P(1,3)*Metric(2,6)*Metric(3,5)*Metric(4,7) + P(1,4)*Metric(2,6)*Metric(3,5)*Metric(4,7) - P(1,5)*Metric(2,6)*Metric(3,5)*Metric(4,7) - P(1,6)*Metric(2,6)*Metric(3,5)*Metric(4,7) - P(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,7) + P(5,1)*Metric(1,2)*Metric(3,6)*Metric(4,7) - P(5,2)*Metric(1,2)*Metric(3,6)*Metric(4,7) - P(2,1)*Metric(1,5)*Metric(3,6)*Metric(4,7) + P(2,5)*Metric(1,5)*Metric(3,6)*Metric(4,7) + P(1,2)*Metric(2,5)*Metric(3,6)*Metric(4,7) + P(1,3)*Metric(2,5)*Metric(3,6)*Metric(4,7) + P(1,4)*Metric(2,5)*Metric(3,6)*Metric(4,7) - P(1,5)*Metric(2,5)*Metric(3,6)*Metric(4,7) - P(1,6)*Metric(2,5)*Metric(3,6)*Metric(4,7) - P(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,7) - 2*P(7,1)*Metric(1,4)*Metric(2,3)*Metric(5,6) + 2*P(7,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) + 2*P(4,1)*Metric(1,7)*Metric(2,3)*Metric(5,6) - 2*P(4,7)*Metric(1,7)*Metric(2,3)*Metric(5,6) - 2*P(7,1)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(7,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(3,1)*Metric(1,7)*Metric(2,4)*Metric(5,6) - 2*P(3,7)*Metric(1,7)*Metric(2,4)*Metric(5,6) - 2*P(7,1)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(7,2)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(2,1)*Metric(1,7)*Metric(3,4)*Metric(5,6) - 2*P(2,7)*Metric(1,7)*Metric(3,4)*Metric(5,6) - 2*P(1,2)*Metric(2,7)*Metric(3,4)*Metric(5,6) + 2*P(1,7)*Metric(2,7)*Metric(3,4)*Metric(5,6) - 2*P(1,3)*Metric(2,4)*Metric(3,7)*Metric(5,6) + 2*P(1,7)*Metric(2,4)*Metric(3,7)*Metric(5,6) - 2*P(1,4)*Metric(2,3)*Metric(4,7)*Metric(5,6) + 2*P(1,7)*Metric(2,3)*Metric(4,7)*Metric(5,6) - 2*P(6,1)*Metric(1,4)*Metric(2,3)*Metric(5,7) + 2*P(6,4)*Metric(1,4)*Metric(2,3)*Metric(5,7) + 2*P(4,1)*Metric(1,6)*Metric(2,3)*Metric(5,7) - 2*P(4,6)*Metric(1,6)*Metric(2,3)*Metric(5,7) - 2*P(6,1)*Metric(1,3)*Metric(2,4)*Metric(5,7) + 2*P(6,3)*Metric(1,3)*Metric(2,4)*Metric(5,7) + 2*P(3,1)*Metric(1,6)*Metric(2,4)*Metric(5,7) - 2*P(3,6)*Metric(1,6)*Metric(2,4)*Metric(5,7) - 2*P(6,1)*Metric(1,2)*Metric(3,4)*Metric(5,7) + 2*P(6,2)*Metric(1,2)*Metric(3,4)*Metric(5,7) + 2*P(2,1)*Metric(1,6)*Metric(3,4)*Metric(5,7) - 2*P(2,6)*Metric(1,6)*Metric(3,4)*Metric(5,7) - 2*P(1,2)*Metric(2,6)*Metric(3,4)*Metric(5,7) + 2*P(1,6)*Metric(2,6)*Metric(3,4)*Metric(5,7) - 2*P(1,3)*Metric(2,4)*Metric(3,6)*Metric(5,7) + 2*P(1,6)*Metric(2,4)*Metric(3,6)*Metric(5,7) - 2*P(1,4)*Metric(2,3)*Metric(4,6)*Metric(5,7) + 2*P(1,6)*Metric(2,3)*Metric(4,6)*Metric(5,7) - 2*P(5,1)*Metric(1,4)*Metric(2,3)*Metric(6,7) + 2*P(5,4)*Metric(1,4)*Metric(2,3)*Metric(6,7) + 2*P(4,1)*Metric(1,5)*Metric(2,3)*Metric(6,7) - 2*P(4,5)*Metric(1,5)*Metric(2,3)*Metric(6,7) - 2*P(5,1)*Metric(1,3)*Metric(2,4)*Metric(6,7) + 2*P(5,3)*Metric(1,3)*Metric(2,4)*Metric(6,7) + 2*P(3,1)*Metric(1,5)*Metric(2,4)*Metric(6,7) - 2*P(3,5)*Metric(1,5)*Metric(2,4)*Metric(6,7) - 2*P(5,1)*Metric(1,2)*Metric(3,4)*Metric(6,7) + 2*P(5,2)*Metric(1,2)*Metric(3,4)*Metric(6,7) + 2*P(2,1)*Metric(1,5)*Metric(3,4)*Metric(6,7) - 2*P(2,5)*Metric(1,5)*Metric(3,4)*Metric(6,7) - 2*P(1,2)*Metric(2,5)*Metric(3,4)*Metric(6,7) + 2*P(1,5)*Metric(2,5)*Metric(3,4)*Metric(6,7) - 2*P(1,3)*Metric(2,4)*Metric(3,5)*Metric(6,7) + 2*P(1,5)*Metric(2,4)*Metric(3,5)*Metric(6,7) - 2*P(1,4)*Metric(2,3)*Metric(4,5)*Metric(6,7) + 2*P(1,5)*Metric(2,3)*Metric(4,5)*Metric(6,7)')

VVVVVVV9 = Lorentz(name = 'VVVVVVV9',
                   spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(7,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(7,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(6,2)*Metric(1,7)*Metric(2,4)*Metric(3,5) - P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(7,1)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(7,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(4,1)*Metric(1,7)*Metric(2,6)*Metric(3,5) - P(4,2)*Metric(1,7)*Metric(2,6)*Metric(3,5) + P(4,6)*Metric(1,7)*Metric(2,6)*Metric(3,5) + P(4,7)*Metric(1,7)*Metric(2,6)*Metric(3,5) + P(6,1)*Metric(1,4)*Metric(2,7)*Metric(3,5) - P(6,4)*Metric(1,4)*Metric(2,7)*Metric(3,5) - P(4,1)*Metric(1,6)*Metric(2,7)*Metric(3,5) - P(4,2)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(4,6)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(4,7)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(7,2)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(7,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(5,2)*Metric(1,7)*Metric(2,4)*Metric(3,6) - P(5,4)*Metric(1,7)*Metric(2,4)*Metric(3,6) + P(7,1)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(7,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(4,1)*Metric(1,7)*Metric(2,5)*Metric(3,6) - P(4,2)*Metric(1,7)*Metric(2,5)*Metric(3,6) + P(4,5)*Metric(1,7)*Metric(2,5)*Metric(3,6) + P(4,7)*Metric(1,7)*Metric(2,5)*Metric(3,6) + P(5,1)*Metric(1,4)*Metric(2,7)*Metric(3,6) - P(5,4)*Metric(1,4)*Metric(2,7)*Metric(3,6) - P(4,1)*Metric(1,5)*Metric(2,7)*Metric(3,6) - P(4,2)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(4,5)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(4,7)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(6,2)*Metric(1,5)*Metric(2,4)*Metric(3,7) - P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7) + P(5,2)*Metric(1,6)*Metric(2,4)*Metric(3,7) - P(5,4)*Metric(1,6)*Metric(2,4)*Metric(3,7) + P(6,1)*Metric(1,4)*Metric(2,5)*Metric(3,7) - P(6,4)*Metric(1,4)*Metric(2,5)*Metric(3,7) - P(4,1)*Metric(1,6)*Metric(2,5)*Metric(3,7) - P(4,2)*Metric(1,6)*Metric(2,5)*Metric(3,7) + P(4,5)*Metric(1,6)*Metric(2,5)*Metric(3,7) + P(4,6)*Metric(1,6)*Metric(2,5)*Metric(3,7) + P(5,1)*Metric(1,4)*Metric(2,6)*Metric(3,7) - P(5,4)*Metric(1,4)*Metric(2,6)*Metric(3,7) - P(4,1)*Metric(1,5)*Metric(2,6)*Metric(3,7) - P(4,2)*Metric(1,5)*Metric(2,6)*Metric(3,7) + P(4,5)*Metric(1,5)*Metric(2,6)*Metric(3,7) + P(4,6)*Metric(1,5)*Metric(2,6)*Metric(3,7) + P(7,2)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(7,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(6,2)*Metric(1,7)*Metric(2,3)*Metric(4,5) - P(6,3)*Metric(1,7)*Metric(2,3)*Metric(4,5) + P(7,1)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(7,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(3,1)*Metric(1,7)*Metric(2,6)*Metric(4,5) - P(3,2)*Metric(1,7)*Metric(2,6)*Metric(4,5) + P(3,6)*Metric(1,7)*Metric(2,6)*Metric(4,5) + P(3,7)*Metric(1,7)*Metric(2,6)*Metric(4,5) + P(6,1)*Metric(1,3)*Metric(2,7)*Metric(4,5) - P(6,3)*Metric(1,3)*Metric(2,7)*Metric(4,5) - P(3,1)*Metric(1,6)*Metric(2,7)*Metric(4,5) - P(3,2)*Metric(1,6)*Metric(2,7)*Metric(4,5) + P(3,6)*Metric(1,6)*Metric(2,7)*Metric(4,5) + P(3,7)*Metric(1,6)*Metric(2,7)*Metric(4,5) + P(2,3)*Metric(1,7)*Metric(3,6)*Metric(4,5) + P(2,4)*Metric(1,7)*Metric(3,6)*Metric(4,5) - P(2,5)*Metric(1,7)*Metric(3,6)*Metric(4,5) - P(2,6)*Metric(1,7)*Metric(3,6)*Metric(4,5) + P(1,3)*Metric(2,7)*Metric(3,6)*Metric(4,5) + P(1,4)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,6)*Metric(2,7)*Metric(3,6)*Metric(4,5) + P(2,3)*Metric(1,6)*Metric(3,7)*Metric(4,5) + P(2,4)*Metric(1,6)*Metric(3,7)*Metric(4,5) - P(2,5)*Metric(1,6)*Metric(3,7)*Metric(4,5) - P(2,7)*Metric(1,6)*Metric(3,7)*Metric(4,5) + P(1,3)*Metric(2,6)*Metric(3,7)*Metric(4,5) + P(1,4)*Metric(2,6)*Metric(3,7)*Metric(4,5) - P(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,5) - P(1,7)*Metric(2,6)*Metric(3,7)*Metric(4,5) + P(7,2)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(7,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(5,2)*Metric(1,7)*Metric(2,3)*Metric(4,6) - P(5,3)*Metric(1,7)*Metric(2,3)*Metric(4,6) + P(7,1)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(7,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(3,1)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(3,2)*Metric(1,7)*Metric(2,5)*Metric(4,6) + P(3,5)*Metric(1,7)*Metric(2,5)*Metric(4,6) + P(3,7)*Metric(1,7)*Metric(2,5)*Metric(4,6) + P(5,1)*Metric(1,3)*Metric(2,7)*Metric(4,6) - P(5,3)*Metric(1,3)*Metric(2,7)*Metric(4,6) - P(3,1)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(3,2)*Metric(1,5)*Metric(2,7)*Metric(4,6) + P(3,5)*Metric(1,5)*Metric(2,7)*Metric(4,6) + P(3,7)*Metric(1,5)*Metric(2,7)*Metric(4,6) + P(2,3)*Metric(1,7)*Metric(3,5)*Metric(4,6) + P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,5)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,6)*Metric(1,7)*Metric(3,5)*Metric(4,6) + P(1,3)*Metric(2,7)*Metric(3,5)*Metric(4,6) + P(1,4)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(1,5)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,6) + P(2,3)*Metric(1,5)*Metric(3,7)*Metric(4,6) + P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,6)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,7)*Metric(1,5)*Metric(3,7)*Metric(4,6) + P(1,3)*Metric(2,5)*Metric(3,7)*Metric(4,6) + P(1,4)*Metric(2,5)*Metric(3,7)*Metric(4,6) - P(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,6) - P(1,7)*Metric(2,5)*Metric(3,7)*Metric(4,6) + P(6,2)*Metric(1,5)*Metric(2,3)*Metric(4,7) - P(6,3)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(5,2)*Metric(1,6)*Metric(2,3)*Metric(4,7) - P(5,3)*Metric(1,6)*Metric(2,3)*Metric(4,7) + P(6,1)*Metric(1,3)*Metric(2,5)*Metric(4,7) - P(6,3)*Metric(1,3)*Metric(2,5)*Metric(4,7) - P(3,1)*Metric(1,6)*Metric(2,5)*Metric(4,7) - P(3,2)*Metric(1,6)*Metric(2,5)*Metric(4,7) + P(3,5)*Metric(1,6)*Metric(2,5)*Metric(4,7) + P(3,6)*Metric(1,6)*Metric(2,5)*Metric(4,7) + P(5,1)*Metric(1,3)*Metric(2,6)*Metric(4,7) - P(5,3)*Metric(1,3)*Metric(2,6)*Metric(4,7) - P(3,1)*Metric(1,5)*Metric(2,6)*Metric(4,7) - P(3,2)*Metric(1,5)*Metric(2,6)*Metric(4,7) + P(3,5)*Metric(1,5)*Metric(2,6)*Metric(4,7) + P(3,6)*Metric(1,5)*Metric(2,6)*Metric(4,7) + P(2,3)*Metric(1,6)*Metric(3,5)*Metric(4,7) + P(2,4)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(2,5)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(2,7)*Metric(1,6)*Metric(3,5)*Metric(4,7) + P(1,3)*Metric(2,6)*Metric(3,5)*Metric(4,7) + P(1,4)*Metric(2,6)*Metric(3,5)*Metric(4,7) - P(1,5)*Metric(2,6)*Metric(3,5)*Metric(4,7) - P(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,7) + P(2,3)*Metric(1,5)*Metric(3,6)*Metric(4,7) + P(2,4)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(2,6)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(2,7)*Metric(1,5)*Metric(3,6)*Metric(4,7) + P(1,3)*Metric(2,5)*Metric(3,6)*Metric(4,7) + P(1,4)*Metric(2,5)*Metric(3,6)*Metric(4,7) - P(1,6)*Metric(2,5)*Metric(3,6)*Metric(4,7) - P(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,7) - 2*P(7,1)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(7,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) + 2*P(7,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) + 2*P(7,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) + 2*P(4,1)*Metric(1,7)*Metric(2,3)*Metric(5,6) - 2*P(4,7)*Metric(1,7)*Metric(2,3)*Metric(5,6) - 2*P(7,1)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(7,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(7,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(7,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(3,1)*Metric(1,7)*Metric(2,4)*Metric(5,6) - 2*P(3,7)*Metric(1,7)*Metric(2,4)*Metric(5,6) + 2*P(4,2)*Metric(1,3)*Metric(2,7)*Metric(5,6) - 2*P(4,7)*Metric(1,3)*Metric(2,7)*Metric(5,6) + 2*P(3,2)*Metric(1,4)*Metric(2,7)*Metric(5,6) - 2*P(3,7)*Metric(1,4)*Metric(2,7)*Metric(5,6) - 2*P(2,3)*Metric(1,4)*Metric(3,7)*Metric(5,6) + 2*P(2,7)*Metric(1,4)*Metric(3,7)*Metric(5,6) - 2*P(1,3)*Metric(2,4)*Metric(3,7)*Metric(5,6) + 2*P(1,7)*Metric(2,4)*Metric(3,7)*Metric(5,6) - 2*P(2,4)*Metric(1,3)*Metric(4,7)*Metric(5,6) + 2*P(2,7)*Metric(1,3)*Metric(4,7)*Metric(5,6) - 2*P(1,4)*Metric(2,3)*Metric(4,7)*Metric(5,6) + 2*P(1,7)*Metric(2,3)*Metric(4,7)*Metric(5,6) - 2*P(6,1)*Metric(1,4)*Metric(2,3)*Metric(5,7) - 2*P(6,2)*Metric(1,4)*Metric(2,3)*Metric(5,7) + 2*P(6,3)*Metric(1,4)*Metric(2,3)*Metric(5,7) + 2*P(6,4)*Metric(1,4)*Metric(2,3)*Metric(5,7) + 2*P(4,1)*Metric(1,6)*Metric(2,3)*Metric(5,7) - 2*P(4,6)*Metric(1,6)*Metric(2,3)*Metric(5,7) - 2*P(6,1)*Metric(1,3)*Metric(2,4)*Metric(5,7) - 2*P(6,2)*Metric(1,3)*Metric(2,4)*Metric(5,7) + 2*P(6,3)*Metric(1,3)*Metric(2,4)*Metric(5,7) + 2*P(6,4)*Metric(1,3)*Metric(2,4)*Metric(5,7) + 2*P(3,1)*Metric(1,6)*Metric(2,4)*Metric(5,7) - 2*P(3,6)*Metric(1,6)*Metric(2,4)*Metric(5,7) + 2*P(4,2)*Metric(1,3)*Metric(2,6)*Metric(5,7) - 2*P(4,6)*Metric(1,3)*Metric(2,6)*Metric(5,7) + 2*P(3,2)*Metric(1,4)*Metric(2,6)*Metric(5,7) - 2*P(3,6)*Metric(1,4)*Metric(2,6)*Metric(5,7) - 2*P(2,3)*Metric(1,4)*Metric(3,6)*Metric(5,7) + 2*P(2,6)*Metric(1,4)*Metric(3,6)*Metric(5,7) - 2*P(1,3)*Metric(2,4)*Metric(3,6)*Metric(5,7) + 2*P(1,6)*Metric(2,4)*Metric(3,6)*Metric(5,7) - 2*P(2,4)*Metric(1,3)*Metric(4,6)*Metric(5,7) + 2*P(2,6)*Metric(1,3)*Metric(4,6)*Metric(5,7) - 2*P(1,4)*Metric(2,3)*Metric(4,6)*Metric(5,7) + 2*P(1,6)*Metric(2,3)*Metric(4,6)*Metric(5,7) - 2*P(5,1)*Metric(1,4)*Metric(2,3)*Metric(6,7) - 2*P(5,2)*Metric(1,4)*Metric(2,3)*Metric(6,7) + 2*P(5,3)*Metric(1,4)*Metric(2,3)*Metric(6,7) + 2*P(5,4)*Metric(1,4)*Metric(2,3)*Metric(6,7) + 2*P(4,1)*Metric(1,5)*Metric(2,3)*Metric(6,7) - 2*P(4,5)*Metric(1,5)*Metric(2,3)*Metric(6,7) - 2*P(5,1)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 2*P(5,2)*Metric(1,3)*Metric(2,4)*Metric(6,7) + 2*P(5,3)*Metric(1,3)*Metric(2,4)*Metric(6,7) + 2*P(5,4)*Metric(1,3)*Metric(2,4)*Metric(6,7) + 2*P(3,1)*Metric(1,5)*Metric(2,4)*Metric(6,7) - 2*P(3,5)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(4,2)*Metric(1,3)*Metric(2,5)*Metric(6,7) - 2*P(4,5)*Metric(1,3)*Metric(2,5)*Metric(6,7) + 2*P(3,2)*Metric(1,4)*Metric(2,5)*Metric(6,7) - 2*P(3,5)*Metric(1,4)*Metric(2,5)*Metric(6,7) - 2*P(2,3)*Metric(1,4)*Metric(3,5)*Metric(6,7) + 2*P(2,5)*Metric(1,4)*Metric(3,5)*Metric(6,7) - 2*P(1,3)*Metric(2,4)*Metric(3,5)*Metric(6,7) + 2*P(1,5)*Metric(2,4)*Metric(3,5)*Metric(6,7) - 2*P(2,4)*Metric(1,3)*Metric(4,5)*Metric(6,7) + 2*P(2,5)*Metric(1,3)*Metric(4,5)*Metric(6,7) - 2*P(1,4)*Metric(2,3)*Metric(4,5)*Metric(6,7) + 2*P(1,5)*Metric(2,3)*Metric(4,5)*Metric(6,7)')

VVVVVVV10 = Lorentz(name = 'VVVVVVV10',
                    spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                    structure = 'P(6,4)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(6,5)*Metric(1,7)*Metric(2,5)*Metric(3,4) - 2*P(6,7)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(5,4)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(5,6)*Metric(1,7)*Metric(2,6)*Metric(3,4) - 2*P(5,7)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(6,4)*Metric(1,5)*Metric(2,7)*Metric(3,4) + P(6,5)*Metric(1,5)*Metric(2,7)*Metric(3,4) - 2*P(6,7)*Metric(1,5)*Metric(2,7)*Metric(3,4) + P(5,4)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(5,6)*Metric(1,6)*Metric(2,7)*Metric(3,4) - 2*P(5,7)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(6,5)*Metric(1,7)*Metric(2,4)*Metric(3,5) - 2*P(6,7)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(4,5)*Metric(1,7)*Metric(2,6)*Metric(3,5) + P(4,6)*Metric(1,7)*Metric(2,6)*Metric(3,5) - 2*P(4,7)*Metric(1,7)*Metric(2,6)*Metric(3,5) + P(6,4)*Metric(1,4)*Metric(2,7)*Metric(3,5) + P(6,5)*Metric(1,4)*Metric(2,7)*Metric(3,5) - 2*P(6,7)*Metric(1,4)*Metric(2,7)*Metric(3,5) + P(4,5)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(4,6)*Metric(1,6)*Metric(2,7)*Metric(3,5) - 2*P(4,7)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(5,4)*Metric(1,7)*Metric(2,4)*Metric(3,6) + P(5,6)*Metric(1,7)*Metric(2,4)*Metric(3,6) - 2*P(5,7)*Metric(1,7)*Metric(2,4)*Metric(3,6) + P(4,5)*Metric(1,7)*Metric(2,5)*Metric(3,6) + P(4,6)*Metric(1,7)*Metric(2,5)*Metric(3,6) - 2*P(4,7)*Metric(1,7)*Metric(2,5)*Metric(3,6) + P(5,4)*Metric(1,4)*Metric(2,7)*Metric(3,6) + P(5,6)*Metric(1,4)*Metric(2,7)*Metric(3,6) - 2*P(5,7)*Metric(1,4)*Metric(2,7)*Metric(3,6) + P(4,5)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(4,6)*Metric(1,5)*Metric(2,7)*Metric(3,6) - 2*P(4,7)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7) + P(6,5)*Metric(1,5)*Metric(2,4)*Metric(3,7) - 2*P(6,7)*Metric(1,5)*Metric(2,4)*Metric(3,7) + P(5,4)*Metric(1,6)*Metric(2,4)*Metric(3,7) + P(5,6)*Metric(1,6)*Metric(2,4)*Metric(3,7) - 2*P(5,7)*Metric(1,6)*Metric(2,4)*Metric(3,7) + P(6,4)*Metric(1,4)*Metric(2,5)*Metric(3,7) + P(6,5)*Metric(1,4)*Metric(2,5)*Metric(3,7) - 2*P(6,7)*Metric(1,4)*Metric(2,5)*Metric(3,7) + P(4,5)*Metric(1,6)*Metric(2,5)*Metric(3,7) + P(4,6)*Metric(1,6)*Metric(2,5)*Metric(3,7) - 2*P(4,7)*Metric(1,6)*Metric(2,5)*Metric(3,7) + P(5,4)*Metric(1,4)*Metric(2,6)*Metric(3,7) + P(5,6)*Metric(1,4)*Metric(2,6)*Metric(3,7) - 2*P(5,7)*Metric(1,4)*Metric(2,6)*Metric(3,7) + P(4,5)*Metric(1,5)*Metric(2,6)*Metric(3,7) + P(4,6)*Metric(1,5)*Metric(2,6)*Metric(3,7) - 2*P(4,7)*Metric(1,5)*Metric(2,6)*Metric(3,7) - 2*P(6,2)*Metric(1,7)*Metric(2,3)*Metric(4,5) - 2*P(6,3)*Metric(1,7)*Metric(2,3)*Metric(4,5) + 4*P(6,7)*Metric(1,7)*Metric(2,3)*Metric(4,5) + 2*P(3,2)*Metric(1,7)*Metric(2,6)*Metric(4,5) - P(3,4)*Metric(1,7)*Metric(2,6)*Metric(4,5) - P(3,5)*Metric(1,7)*Metric(2,6)*Metric(4,5) - 2*P(6,1)*Metric(1,3)*Metric(2,7)*Metric(4,5) - 2*P(6,3)*Metric(1,3)*Metric(2,7)*Metric(4,5) + 4*P(6,7)*Metric(1,3)*Metric(2,7)*Metric(4,5) + 2*P(3,1)*Metric(1,6)*Metric(2,7)*Metric(4,5) - P(3,4)*Metric(1,6)*Metric(2,7)*Metric(4,5) - P(3,5)*Metric(1,6)*Metric(2,7)*Metric(4,5) + 2*P(2,3)*Metric(1,7)*Metric(3,6)*Metric(4,5) - P(2,4)*Metric(1,7)*Metric(3,6)*Metric(4,5) - P(2,5)*Metric(1,7)*Metric(3,6)*Metric(4,5) + 2*P(1,3)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,4)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,5) - 2*P(6,1)*Metric(1,2)*Metric(3,7)*Metric(4,5) - 2*P(6,2)*Metric(1,2)*Metric(3,7)*Metric(4,5) + 4*P(6,7)*Metric(1,2)*Metric(3,7)*Metric(4,5) + 2*P(2,1)*Metric(1,6)*Metric(3,7)*Metric(4,5) - P(2,4)*Metric(1,6)*Metric(3,7)*Metric(4,5) - P(2,5)*Metric(1,6)*Metric(3,7)*Metric(4,5) + 2*P(1,2)*Metric(2,6)*Metric(3,7)*Metric(4,5) - P(1,4)*Metric(2,6)*Metric(3,7)*Metric(4,5) - P(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,5) - 2*P(5,2)*Metric(1,7)*Metric(2,3)*Metric(4,6) - 2*P(5,3)*Metric(1,7)*Metric(2,3)*Metric(4,6) + 4*P(5,7)*Metric(1,7)*Metric(2,3)*Metric(4,6) + 2*P(3,2)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(3,4)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(3,6)*Metric(1,7)*Metric(2,5)*Metric(4,6) - 2*P(5,1)*Metric(1,3)*Metric(2,7)*Metric(4,6) - 2*P(5,3)*Metric(1,3)*Metric(2,7)*Metric(4,6) + 4*P(5,7)*Metric(1,3)*Metric(2,7)*Metric(4,6) + 2*P(3,1)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(3,4)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(3,6)*Metric(1,5)*Metric(2,7)*Metric(4,6) + 2*P(2,3)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,6)*Metric(1,7)*Metric(3,5)*Metric(4,6) + 2*P(1,3)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(1,4)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,6) - 2*P(5,1)*Metric(1,2)*Metric(3,7)*Metric(4,6) - 2*P(5,2)*Metric(1,2)*Metric(3,7)*Metric(4,6) + 4*P(5,7)*Metric(1,2)*Metric(3,7)*Metric(4,6) + 2*P(2,1)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,6)*Metric(1,5)*Metric(3,7)*Metric(4,6) + 2*P(1,2)*Metric(2,5)*Metric(3,7)*Metric(4,6) - P(1,4)*Metric(2,5)*Metric(3,7)*Metric(4,6) - P(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,6) + P(6,2)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(6,3)*Metric(1,5)*Metric(2,3)*Metric(4,7) - 2*P(6,5)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(5,2)*Metric(1,6)*Metric(2,3)*Metric(4,7) + P(5,3)*Metric(1,6)*Metric(2,3)*Metric(4,7) - 2*P(5,6)*Metric(1,6)*Metric(2,3)*Metric(4,7) + P(6,1)*Metric(1,3)*Metric(2,5)*Metric(4,7) + P(6,3)*Metric(1,3)*Metric(2,5)*Metric(4,7) - 2*P(6,5)*Metric(1,3)*Metric(2,5)*Metric(4,7) - P(3,1)*Metric(1,6)*Metric(2,5)*Metric(4,7) - P(3,2)*Metric(1,6)*Metric(2,5)*Metric(4,7) + 2*P(3,7)*Metric(1,6)*Metric(2,5)*Metric(4,7) + P(5,1)*Metric(1,3)*Metric(2,6)*Metric(4,7) + P(5,3)*Metric(1,3)*Metric(2,6)*Metric(4,7) - 2*P(5,6)*Metric(1,3)*Metric(2,6)*Metric(4,7) - P(3,1)*Metric(1,5)*Metric(2,6)*Metric(4,7) - P(3,2)*Metric(1,5)*Metric(2,6)*Metric(4,7) + 2*P(3,7)*Metric(1,5)*Metric(2,6)*Metric(4,7) + P(6,1)*Metric(1,2)*Metric(3,5)*Metric(4,7) + P(6,2)*Metric(1,2)*Metric(3,5)*Metric(4,7) - 2*P(6,5)*Metric(1,2)*Metric(3,5)*Metric(4,7) - P(2,1)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(2,3)*Metric(1,6)*Metric(3,5)*Metric(4,7) + 2*P(2,7)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(1,2)*Metric(2,6)*Metric(3,5)*Metric(4,7) - P(1,3)*Metric(2,6)*Metric(3,5)*Metric(4,7) + 2*P(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,7) + P(5,1)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(5,2)*Metric(1,2)*Metric(3,6)*Metric(4,7) - 2*P(5,6)*Metric(1,2)*Metric(3,6)*Metric(4,7) - P(2,1)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(2,3)*Metric(1,5)*Metric(3,6)*Metric(4,7) + 2*P(2,7)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(1,2)*Metric(2,5)*Metric(3,6)*Metric(4,7) - P(1,3)*Metric(2,5)*Metric(3,6)*Metric(4,7) + 2*P(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,7) - 2*P(4,2)*Metric(1,7)*Metric(2,3)*Metric(5,6) - 2*P(4,3)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 4*P(4,7)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 2*P(3,2)*Metric(1,7)*Metric(2,4)*Metric(5,6) - P(3,5)*Metric(1,7)*Metric(2,4)*Metric(5,6) - P(3,6)*Metric(1,7)*Metric(2,4)*Metric(5,6) - 2*P(4,1)*Metric(1,3)*Metric(2,7)*Metric(5,6) - 2*P(4,3)*Metric(1,3)*Metric(2,7)*Metric(5,6) + 4*P(4,7)*Metric(1,3)*Metric(2,7)*Metric(5,6) + 2*P(3,1)*Metric(1,4)*Metric(2,7)*Metric(5,6) - P(3,5)*Metric(1,4)*Metric(2,7)*Metric(5,6) - P(3,6)*Metric(1,4)*Metric(2,7)*Metric(5,6) + 2*P(2,3)*Metric(1,7)*Metric(3,4)*Metric(5,6) - P(2,5)*Metric(1,7)*Metric(3,4)*Metric(5,6) - P(2,6)*Metric(1,7)*Metric(3,4)*Metric(5,6) + 2*P(1,3)*Metric(2,7)*Metric(3,4)*Metric(5,6) - P(1,5)*Metric(2,7)*Metric(3,4)*Metric(5,6) - P(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,6) - 2*P(4,1)*Metric(1,2)*Metric(3,7)*Metric(5,6) - 2*P(4,2)*Metric(1,2)*Metric(3,7)*Metric(5,6) + 4*P(4,7)*Metric(1,2)*Metric(3,7)*Metric(5,6) + 2*P(2,1)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(2,5)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(2,6)*Metric(1,4)*Metric(3,7)*Metric(5,6) + 2*P(1,2)*Metric(2,4)*Metric(3,7)*Metric(5,6) - P(1,5)*Metric(2,4)*Metric(3,7)*Metric(5,6) - P(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,6) + 2*P(3,5)*Metric(1,2)*Metric(4,7)*Metric(5,6) + 2*P(3,6)*Metric(1,2)*Metric(4,7)*Metric(5,6) - 4*P(3,7)*Metric(1,2)*Metric(4,7)*Metric(5,6) + 2*P(2,5)*Metric(1,3)*Metric(4,7)*Metric(5,6) + 2*P(2,6)*Metric(1,3)*Metric(4,7)*Metric(5,6) - 4*P(2,7)*Metric(1,3)*Metric(4,7)*Metric(5,6) + 2*P(1,5)*Metric(2,3)*Metric(4,7)*Metric(5,6) + 2*P(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,6) - 4*P(1,7)*Metric(2,3)*Metric(4,7)*Metric(5,6) + P(6,2)*Metric(1,4)*Metric(2,3)*Metric(5,7) + P(6,3)*Metric(1,4)*Metric(2,3)*Metric(5,7) - 2*P(6,4)*Metric(1,4)*Metric(2,3)*Metric(5,7) + P(4,2)*Metric(1,6)*Metric(2,3)*Metric(5,7) + P(4,3)*Metric(1,6)*Metric(2,3)*Metric(5,7) - 2*P(4,6)*Metric(1,6)*Metric(2,3)*Metric(5,7) + P(6,1)*Metric(1,3)*Metric(2,4)*Metric(5,7) + P(6,3)*Metric(1,3)*Metric(2,4)*Metric(5,7) - 2*P(6,4)*Metric(1,3)*Metric(2,4)*Metric(5,7) - P(3,1)*Metric(1,6)*Metric(2,4)*Metric(5,7) - P(3,2)*Metric(1,6)*Metric(2,4)*Metric(5,7) + 2*P(3,7)*Metric(1,6)*Metric(2,4)*Metric(5,7) + P(4,1)*Metric(1,3)*Metric(2,6)*Metric(5,7) + P(4,3)*Metric(1,3)*Metric(2,6)*Metric(5,7) - 2*P(4,6)*Metric(1,3)*Metric(2,6)*Metric(5,7) - P(3,1)*Metric(1,4)*Metric(2,6)*Metric(5,7) - P(3,2)*Metric(1,4)*Metric(2,6)*Metric(5,7) + 2*P(3,7)*Metric(1,4)*Metric(2,6)*Metric(5,7) + P(6,1)*Metric(1,2)*Metric(3,4)*Metric(5,7) + P(6,2)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 2*P(6,4)*Metric(1,2)*Metric(3,4)*Metric(5,7) - P(2,1)*Metric(1,6)*Metric(3,4)*Metric(5,7) - P(2,3)*Metric(1,6)*Metric(3,4)*Metric(5,7) + 2*P(2,7)*Metric(1,6)*Metric(3,4)*Metric(5,7) - P(1,2)*Metric(2,6)*Metric(3,4)*Metric(5,7) - P(1,3)*Metric(2,6)*Metric(3,4)*Metric(5,7) + 2*P(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,7) + P(4,1)*Metric(1,2)*Metric(3,6)*Metric(5,7) + P(4,2)*Metric(1,2)*Metric(3,6)*Metric(5,7) - 2*P(4,6)*Metric(1,2)*Metric(3,6)*Metric(5,7) - P(2,1)*Metric(1,4)*Metric(3,6)*Metric(5,7) - P(2,3)*Metric(1,4)*Metric(3,6)*Metric(5,7) + 2*P(2,7)*Metric(1,4)*Metric(3,6)*Metric(5,7) - P(1,2)*Metric(2,4)*Metric(3,6)*Metric(5,7) - P(1,3)*Metric(2,4)*Metric(3,6)*Metric(5,7) + 2*P(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,7) + 2*P(3,4)*Metric(1,2)*Metric(4,6)*Metric(5,7) + 2*P(3,6)*Metric(1,2)*Metric(4,6)*Metric(5,7) - 4*P(3,7)*Metric(1,2)*Metric(4,6)*Metric(5,7) + 2*P(2,4)*Metric(1,3)*Metric(4,6)*Metric(5,7) + 2*P(2,6)*Metric(1,3)*Metric(4,6)*Metric(5,7) - 4*P(2,7)*Metric(1,3)*Metric(4,6)*Metric(5,7) + 2*P(1,4)*Metric(2,3)*Metric(4,6)*Metric(5,7) + 2*P(1,6)*Metric(2,3)*Metric(4,6)*Metric(5,7) - 4*P(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,7) + P(5,2)*Metric(1,4)*Metric(2,3)*Metric(6,7) + P(5,3)*Metric(1,4)*Metric(2,3)*Metric(6,7) - 2*P(5,4)*Metric(1,4)*Metric(2,3)*Metric(6,7) + P(4,2)*Metric(1,5)*Metric(2,3)*Metric(6,7) + P(4,3)*Metric(1,5)*Metric(2,3)*Metric(6,7) - 2*P(4,5)*Metric(1,5)*Metric(2,3)*Metric(6,7) + P(5,1)*Metric(1,3)*Metric(2,4)*Metric(6,7) + P(5,3)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 2*P(5,4)*Metric(1,3)*Metric(2,4)*Metric(6,7) - P(3,1)*Metric(1,5)*Metric(2,4)*Metric(6,7) - P(3,2)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(3,7)*Metric(1,5)*Metric(2,4)*Metric(6,7) + P(4,1)*Metric(1,3)*Metric(2,5)*Metric(6,7) + P(4,3)*Metric(1,3)*Metric(2,5)*Metric(6,7) - 2*P(4,5)*Metric(1,3)*Metric(2,5)*Metric(6,7) - P(3,1)*Metric(1,4)*Metric(2,5)*Metric(6,7) - P(3,2)*Metric(1,4)*Metric(2,5)*Metric(6,7) + 2*P(3,7)*Metric(1,4)*Metric(2,5)*Metric(6,7) + P(5,1)*Metric(1,2)*Metric(3,4)*Metric(6,7) + P(5,2)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 2*P(5,4)*Metric(1,2)*Metric(3,4)*Metric(6,7) - P(2,1)*Metric(1,5)*Metric(3,4)*Metric(6,7) - P(2,3)*Metric(1,5)*Metric(3,4)*Metric(6,7) + 2*P(2,7)*Metric(1,5)*Metric(3,4)*Metric(6,7) - P(1,2)*Metric(2,5)*Metric(3,4)*Metric(6,7) - P(1,3)*Metric(2,5)*Metric(3,4)*Metric(6,7) + 2*P(1,7)*Metric(2,5)*Metric(3,4)*Metric(6,7) + P(4,1)*Metric(1,2)*Metric(3,5)*Metric(6,7) + P(4,2)*Metric(1,2)*Metric(3,5)*Metric(6,7) - 2*P(4,5)*Metric(1,2)*Metric(3,5)*Metric(6,7) - P(2,1)*Metric(1,4)*Metric(3,5)*Metric(6,7) - P(2,3)*Metric(1,4)*Metric(3,5)*Metric(6,7) + 2*P(2,7)*Metric(1,4)*Metric(3,5)*Metric(6,7) - P(1,2)*Metric(2,4)*Metric(3,5)*Metric(6,7) - P(1,3)*Metric(2,4)*Metric(3,5)*Metric(6,7) + 2*P(1,7)*Metric(2,4)*Metric(3,5)*Metric(6,7) + 2*P(3,4)*Metric(1,2)*Metric(4,5)*Metric(6,7) + 2*P(3,5)*Metric(1,2)*Metric(4,5)*Metric(6,7) - 4*P(3,7)*Metric(1,2)*Metric(4,5)*Metric(6,7) + 2*P(2,4)*Metric(1,3)*Metric(4,5)*Metric(6,7) + 2*P(2,5)*Metric(1,3)*Metric(4,5)*Metric(6,7) - 4*P(2,7)*Metric(1,3)*Metric(4,5)*Metric(6,7) + 2*P(1,4)*Metric(2,3)*Metric(4,5)*Metric(6,7) + 2*P(1,5)*Metric(2,3)*Metric(4,5)*Metric(6,7) - 4*P(1,7)*Metric(2,3)*Metric(4,5)*Metric(6,7)')

VVVVVVV11 = Lorentz(name = 'VVVVVVV11',
                    spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                    structure = 'P(7,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(7,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(7,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(6,4)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(6,5)*Metric(1,7)*Metric(2,5)*Metric(3,4) - 2*P(6,7)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(7,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(7,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(7,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(5,4)*Metric(1,7)*Metric(2,6)*Metric(3,4) - P(5,6)*Metric(1,7)*Metric(2,6)*Metric(3,4) - P(5,7)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(6,4)*Metric(1,5)*Metric(2,7)*Metric(3,4) + P(6,5)*Metric(1,5)*Metric(2,7)*Metric(3,4) - 2*P(6,7)*Metric(1,5)*Metric(2,7)*Metric(3,4) + 2*P(5,4)*Metric(1,6)*Metric(2,7)*Metric(3,4) - P(5,6)*Metric(1,6)*Metric(2,7)*Metric(3,4) - P(5,7)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(7,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(7,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(7,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(6,5)*Metric(1,7)*Metric(2,4)*Metric(3,5) - 2*P(6,7)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(7,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(7,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - 2*P(7,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 2*P(4,5)*Metric(1,7)*Metric(2,6)*Metric(3,5) - P(4,6)*Metric(1,7)*Metric(2,6)*Metric(3,5) - P(4,7)*Metric(1,7)*Metric(2,6)*Metric(3,5) + P(6,4)*Metric(1,4)*Metric(2,7)*Metric(3,5) + P(6,5)*Metric(1,4)*Metric(2,7)*Metric(3,5) - 2*P(6,7)*Metric(1,4)*Metric(2,7)*Metric(3,5) + 2*P(4,5)*Metric(1,6)*Metric(2,7)*Metric(3,5) - P(4,6)*Metric(1,6)*Metric(2,7)*Metric(3,5) - P(4,7)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(7,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(7,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) - 2*P(7,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + 2*P(5,4)*Metric(1,7)*Metric(2,4)*Metric(3,6) - P(5,6)*Metric(1,7)*Metric(2,4)*Metric(3,6) - P(5,7)*Metric(1,7)*Metric(2,4)*Metric(3,6) + P(7,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(7,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 2*P(7,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(4,5)*Metric(1,7)*Metric(2,5)*Metric(3,6) - P(4,6)*Metric(1,7)*Metric(2,5)*Metric(3,6) - P(4,7)*Metric(1,7)*Metric(2,5)*Metric(3,6) + 2*P(5,4)*Metric(1,4)*Metric(2,7)*Metric(3,6) - P(5,6)*Metric(1,4)*Metric(2,7)*Metric(3,6) - P(5,7)*Metric(1,4)*Metric(2,7)*Metric(3,6) + 2*P(4,5)*Metric(1,5)*Metric(2,7)*Metric(3,6) - P(4,6)*Metric(1,5)*Metric(2,7)*Metric(3,6) - P(4,7)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7) + P(6,5)*Metric(1,5)*Metric(2,4)*Metric(3,7) - 2*P(6,7)*Metric(1,5)*Metric(2,4)*Metric(3,7) + 2*P(5,4)*Metric(1,6)*Metric(2,4)*Metric(3,7) - P(5,6)*Metric(1,6)*Metric(2,4)*Metric(3,7) - P(5,7)*Metric(1,6)*Metric(2,4)*Metric(3,7) + P(6,4)*Metric(1,4)*Metric(2,5)*Metric(3,7) + P(6,5)*Metric(1,4)*Metric(2,5)*Metric(3,7) - 2*P(6,7)*Metric(1,4)*Metric(2,5)*Metric(3,7) + 2*P(4,5)*Metric(1,6)*Metric(2,5)*Metric(3,7) - P(4,6)*Metric(1,6)*Metric(2,5)*Metric(3,7) - P(4,7)*Metric(1,6)*Metric(2,5)*Metric(3,7) + 2*P(5,4)*Metric(1,4)*Metric(2,6)*Metric(3,7) - P(5,6)*Metric(1,4)*Metric(2,6)*Metric(3,7) - P(5,7)*Metric(1,4)*Metric(2,6)*Metric(3,7) + 2*P(4,5)*Metric(1,5)*Metric(2,6)*Metric(3,7) - P(4,6)*Metric(1,5)*Metric(2,6)*Metric(3,7) - P(4,7)*Metric(1,5)*Metric(2,6)*Metric(3,7) - 2*P(7,2)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(7,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 4*P(7,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(6,2)*Metric(1,7)*Metric(2,3)*Metric(4,5) - 2*P(6,3)*Metric(1,7)*Metric(2,3)*Metric(4,5) + 4*P(6,7)*Metric(1,7)*Metric(2,3)*Metric(4,5) - 2*P(7,1)*Metric(1,3)*Metric(2,6)*Metric(4,5) - 2*P(7,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 4*P(7,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(3,1)*Metric(1,7)*Metric(2,6)*Metric(4,5) + 2*P(3,2)*Metric(1,7)*Metric(2,6)*Metric(4,5) - 2*P(3,4)*Metric(1,7)*Metric(2,6)*Metric(4,5) - 2*P(3,5)*Metric(1,7)*Metric(2,6)*Metric(4,5) - 2*P(6,1)*Metric(1,3)*Metric(2,7)*Metric(4,5) - 2*P(6,3)*Metric(1,3)*Metric(2,7)*Metric(4,5) + 4*P(6,7)*Metric(1,3)*Metric(2,7)*Metric(4,5) + 2*P(3,1)*Metric(1,6)*Metric(2,7)*Metric(4,5) + 2*P(3,2)*Metric(1,6)*Metric(2,7)*Metric(4,5) - 2*P(3,4)*Metric(1,6)*Metric(2,7)*Metric(4,5) - 2*P(3,5)*Metric(1,6)*Metric(2,7)*Metric(4,5) - 2*P(7,1)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(7,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 4*P(7,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(2,1)*Metric(1,7)*Metric(3,6)*Metric(4,5) + 2*P(2,3)*Metric(1,7)*Metric(3,6)*Metric(4,5) - 2*P(2,4)*Metric(1,7)*Metric(3,6)*Metric(4,5) - 2*P(2,5)*Metric(1,7)*Metric(3,6)*Metric(4,5) + 2*P(1,2)*Metric(2,7)*Metric(3,6)*Metric(4,5) + 2*P(1,3)*Metric(2,7)*Metric(3,6)*Metric(4,5) - 2*P(1,4)*Metric(2,7)*Metric(3,6)*Metric(4,5) - 2*P(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,5) - 2*P(6,1)*Metric(1,2)*Metric(3,7)*Metric(4,5) - 2*P(6,2)*Metric(1,2)*Metric(3,7)*Metric(4,5) + 4*P(6,7)*Metric(1,2)*Metric(3,7)*Metric(4,5) + 2*P(2,1)*Metric(1,6)*Metric(3,7)*Metric(4,5) + 2*P(2,3)*Metric(1,6)*Metric(3,7)*Metric(4,5) - 2*P(2,4)*Metric(1,6)*Metric(3,7)*Metric(4,5) - 2*P(2,5)*Metric(1,6)*Metric(3,7)*Metric(4,5) + 2*P(1,2)*Metric(2,6)*Metric(3,7)*Metric(4,5) + 2*P(1,3)*Metric(2,6)*Metric(3,7)*Metric(4,5) - 2*P(1,4)*Metric(2,6)*Metric(3,7)*Metric(4,5) - 2*P(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,5) + P(7,2)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(7,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) - 2*P(7,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(5,2)*Metric(1,7)*Metric(2,3)*Metric(4,6) - P(5,3)*Metric(1,7)*Metric(2,3)*Metric(4,6) + 2*P(5,7)*Metric(1,7)*Metric(2,3)*Metric(4,6) + P(7,1)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(7,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) - 2*P(7,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(3,1)*Metric(1,7)*Metric(2,5)*Metric(4,6) + P(3,2)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(3,4)*Metric(1,7)*Metric(2,5)*Metric(4,6) + P(3,6)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(5,1)*Metric(1,3)*Metric(2,7)*Metric(4,6) - P(5,3)*Metric(1,3)*Metric(2,7)*Metric(4,6) + 2*P(5,7)*Metric(1,3)*Metric(2,7)*Metric(4,6) + P(3,1)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(3,2)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(3,4)*Metric(1,5)*Metric(2,7)*Metric(4,6) + P(3,6)*Metric(1,5)*Metric(2,7)*Metric(4,6) + P(7,1)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(7,2)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(7,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(2,1)*Metric(1,7)*Metric(3,5)*Metric(4,6) + P(2,3)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6) + P(2,6)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(1,2)*Metric(2,7)*Metric(3,5)*Metric(4,6) + P(1,3)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(1,4)*Metric(2,7)*Metric(3,5)*Metric(4,6) + P(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(5,1)*Metric(1,2)*Metric(3,7)*Metric(4,6) - P(5,2)*Metric(1,2)*Metric(3,7)*Metric(4,6) + 2*P(5,7)*Metric(1,2)*Metric(3,7)*Metric(4,6) + P(2,1)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,3)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6) + P(2,6)*Metric(1,5)*Metric(3,7)*Metric(4,6) + P(1,2)*Metric(2,5)*Metric(3,7)*Metric(4,6) - P(1,3)*Metric(2,5)*Metric(3,7)*Metric(4,6) - P(1,4)*Metric(2,5)*Metric(3,7)*Metric(4,6) + P(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,6) + P(6,2)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(6,3)*Metric(1,5)*Metric(2,3)*Metric(4,7) - 2*P(6,5)*Metric(1,5)*Metric(2,3)*Metric(4,7) - P(5,2)*Metric(1,6)*Metric(2,3)*Metric(4,7) - P(5,3)*Metric(1,6)*Metric(2,3)*Metric(4,7) + 2*P(5,6)*Metric(1,6)*Metric(2,3)*Metric(4,7) + P(6,1)*Metric(1,3)*Metric(2,5)*Metric(4,7) + P(6,3)*Metric(1,3)*Metric(2,5)*Metric(4,7) - 2*P(6,5)*Metric(1,3)*Metric(2,5)*Metric(4,7) - P(3,1)*Metric(1,6)*Metric(2,5)*Metric(4,7) + P(3,2)*Metric(1,6)*Metric(2,5)*Metric(4,7) - P(3,4)*Metric(1,6)*Metric(2,5)*Metric(4,7) + P(3,7)*Metric(1,6)*Metric(2,5)*Metric(4,7) - P(5,1)*Metric(1,3)*Metric(2,6)*Metric(4,7) - P(5,3)*Metric(1,3)*Metric(2,6)*Metric(4,7) + 2*P(5,6)*Metric(1,3)*Metric(2,6)*Metric(4,7) + P(3,1)*Metric(1,5)*Metric(2,6)*Metric(4,7) - P(3,2)*Metric(1,5)*Metric(2,6)*Metric(4,7) - P(3,4)*Metric(1,5)*Metric(2,6)*Metric(4,7) + P(3,7)*Metric(1,5)*Metric(2,6)*Metric(4,7) + P(6,1)*Metric(1,2)*Metric(3,5)*Metric(4,7) + P(6,2)*Metric(1,2)*Metric(3,5)*Metric(4,7) - 2*P(6,5)*Metric(1,2)*Metric(3,5)*Metric(4,7) - P(2,1)*Metric(1,6)*Metric(3,5)*Metric(4,7) + P(2,3)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(2,4)*Metric(1,6)*Metric(3,5)*Metric(4,7) + P(2,7)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(1,2)*Metric(2,6)*Metric(3,5)*Metric(4,7) + P(1,3)*Metric(2,6)*Metric(3,5)*Metric(4,7) - P(1,4)*Metric(2,6)*Metric(3,5)*Metric(4,7) + P(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,7) - P(5,1)*Metric(1,2)*Metric(3,6)*Metric(4,7) - P(5,2)*Metric(1,2)*Metric(3,6)*Metric(4,7) + 2*P(5,6)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(2,1)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(2,3)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(2,4)*Metric(1,5)*Metric(3,6)*Metric(4,7) + P(2,7)*Metric(1,5)*Metric(3,6)*Metric(4,7) + P(1,2)*Metric(2,5)*Metric(3,6)*Metric(4,7) - P(1,3)*Metric(2,5)*Metric(3,6)*Metric(4,7) - P(1,4)*Metric(2,5)*Metric(3,6)*Metric(4,7) + P(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,7) + P(7,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(7,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(7,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(4,2)*Metric(1,7)*Metric(2,3)*Metric(5,6) - P(4,3)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 2*P(4,7)*Metric(1,7)*Metric(2,3)*Metric(5,6) + P(7,1)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(7,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(7,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(3,1)*Metric(1,7)*Metric(2,4)*Metric(5,6) + P(3,2)*Metric(1,7)*Metric(2,4)*Metric(5,6) - P(3,5)*Metric(1,7)*Metric(2,4)*Metric(5,6) + P(3,6)*Metric(1,7)*Metric(2,4)*Metric(5,6) - P(4,1)*Metric(1,3)*Metric(2,7)*Metric(5,6) - P(4,3)*Metric(1,3)*Metric(2,7)*Metric(5,6) + 2*P(4,7)*Metric(1,3)*Metric(2,7)*Metric(5,6) + P(3,1)*Metric(1,4)*Metric(2,7)*Metric(5,6) - P(3,2)*Metric(1,4)*Metric(2,7)*Metric(5,6) - P(3,5)*Metric(1,4)*Metric(2,7)*Metric(5,6) + P(3,6)*Metric(1,4)*Metric(2,7)*Metric(5,6) + P(7,1)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(7,2)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(7,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) - P(2,1)*Metric(1,7)*Metric(3,4)*Metric(5,6) + P(2,3)*Metric(1,7)*Metric(3,4)*Metric(5,6) - P(2,5)*Metric(1,7)*Metric(3,4)*Metric(5,6) + P(2,6)*Metric(1,7)*Metric(3,4)*Metric(5,6) - P(1,2)*Metric(2,7)*Metric(3,4)*Metric(5,6) + P(1,3)*Metric(2,7)*Metric(3,4)*Metric(5,6) - P(1,5)*Metric(2,7)*Metric(3,4)*Metric(5,6) + P(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,6) - P(4,1)*Metric(1,2)*Metric(3,7)*Metric(5,6) - P(4,2)*Metric(1,2)*Metric(3,7)*Metric(5,6) + 2*P(4,7)*Metric(1,2)*Metric(3,7)*Metric(5,6) + P(2,1)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(2,3)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(2,5)*Metric(1,4)*Metric(3,7)*Metric(5,6) + P(2,6)*Metric(1,4)*Metric(3,7)*Metric(5,6) + P(1,2)*Metric(2,4)*Metric(3,7)*Metric(5,6) - P(1,3)*Metric(2,4)*Metric(3,7)*Metric(5,6) - P(1,5)*Metric(2,4)*Metric(3,7)*Metric(5,6) + P(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,6) + 2*P(3,4)*Metric(1,2)*Metric(4,7)*Metric(5,6) + 2*P(3,5)*Metric(1,2)*Metric(4,7)*Metric(5,6) - 2*P(3,6)*Metric(1,2)*Metric(4,7)*Metric(5,6) - 2*P(3,7)*Metric(1,2)*Metric(4,7)*Metric(5,6) + 2*P(2,4)*Metric(1,3)*Metric(4,7)*Metric(5,6) + 2*P(2,5)*Metric(1,3)*Metric(4,7)*Metric(5,6) - 2*P(2,6)*Metric(1,3)*Metric(4,7)*Metric(5,6) - 2*P(2,7)*Metric(1,3)*Metric(4,7)*Metric(5,6) + 2*P(1,4)*Metric(2,3)*Metric(4,7)*Metric(5,6) + 2*P(1,5)*Metric(2,3)*Metric(4,7)*Metric(5,6) - 2*P(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,6) - 2*P(1,7)*Metric(2,3)*Metric(4,7)*Metric(5,6) + P(6,2)*Metric(1,4)*Metric(2,3)*Metric(5,7) + P(6,3)*Metric(1,4)*Metric(2,3)*Metric(5,7) - 2*P(6,4)*Metric(1,4)*Metric(2,3)*Metric(5,7) - P(4,2)*Metric(1,6)*Metric(2,3)*Metric(5,7) - P(4,3)*Metric(1,6)*Metric(2,3)*Metric(5,7) + 2*P(4,6)*Metric(1,6)*Metric(2,3)*Metric(5,7) + P(6,1)*Metric(1,3)*Metric(2,4)*Metric(5,7) + P(6,3)*Metric(1,3)*Metric(2,4)*Metric(5,7) - 2*P(6,4)*Metric(1,3)*Metric(2,4)*Metric(5,7) - P(3,1)*Metric(1,6)*Metric(2,4)*Metric(5,7) + P(3,2)*Metric(1,6)*Metric(2,4)*Metric(5,7) - P(3,5)*Metric(1,6)*Metric(2,4)*Metric(5,7) + P(3,7)*Metric(1,6)*Metric(2,4)*Metric(5,7) - P(4,1)*Metric(1,3)*Metric(2,6)*Metric(5,7) - P(4,3)*Metric(1,3)*Metric(2,6)*Metric(5,7) + 2*P(4,6)*Metric(1,3)*Metric(2,6)*Metric(5,7) + P(3,1)*Metric(1,4)*Metric(2,6)*Metric(5,7) - P(3,2)*Metric(1,4)*Metric(2,6)*Metric(5,7) - P(3,5)*Metric(1,4)*Metric(2,6)*Metric(5,7) + P(3,7)*Metric(1,4)*Metric(2,6)*Metric(5,7) + P(6,1)*Metric(1,2)*Metric(3,4)*Metric(5,7) + P(6,2)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 2*P(6,4)*Metric(1,2)*Metric(3,4)*Metric(5,7) - P(2,1)*Metric(1,6)*Metric(3,4)*Metric(5,7) + P(2,3)*Metric(1,6)*Metric(3,4)*Metric(5,7) - P(2,5)*Metric(1,6)*Metric(3,4)*Metric(5,7) + P(2,7)*Metric(1,6)*Metric(3,4)*Metric(5,7) - P(1,2)*Metric(2,6)*Metric(3,4)*Metric(5,7) + P(1,3)*Metric(2,6)*Metric(3,4)*Metric(5,7) - P(1,5)*Metric(2,6)*Metric(3,4)*Metric(5,7) + P(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,7) - P(4,1)*Metric(1,2)*Metric(3,6)*Metric(5,7) - P(4,2)*Metric(1,2)*Metric(3,6)*Metric(5,7) + 2*P(4,6)*Metric(1,2)*Metric(3,6)*Metric(5,7) + P(2,1)*Metric(1,4)*Metric(3,6)*Metric(5,7) - P(2,3)*Metric(1,4)*Metric(3,6)*Metric(5,7) - P(2,5)*Metric(1,4)*Metric(3,6)*Metric(5,7) + P(2,7)*Metric(1,4)*Metric(3,6)*Metric(5,7) + P(1,2)*Metric(2,4)*Metric(3,6)*Metric(5,7) - P(1,3)*Metric(2,4)*Metric(3,6)*Metric(5,7) - P(1,5)*Metric(2,4)*Metric(3,6)*Metric(5,7) + P(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,7) + 2*P(3,4)*Metric(1,2)*Metric(4,6)*Metric(5,7) + 2*P(3,5)*Metric(1,2)*Metric(4,6)*Metric(5,7) - 2*P(3,6)*Metric(1,2)*Metric(4,6)*Metric(5,7) - 2*P(3,7)*Metric(1,2)*Metric(4,6)*Metric(5,7) + 2*P(2,4)*Metric(1,3)*Metric(4,6)*Metric(5,7) + 2*P(2,5)*Metric(1,3)*Metric(4,6)*Metric(5,7) - 2*P(2,6)*Metric(1,3)*Metric(4,6)*Metric(5,7) - 2*P(2,7)*Metric(1,3)*Metric(4,6)*Metric(5,7) + 2*P(1,4)*Metric(2,3)*Metric(4,6)*Metric(5,7) + 2*P(1,5)*Metric(2,3)*Metric(4,6)*Metric(5,7) - 2*P(1,6)*Metric(2,3)*Metric(4,6)*Metric(5,7) - 2*P(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,7) + 2*P(5,2)*Metric(1,4)*Metric(2,3)*Metric(6,7) + 2*P(5,3)*Metric(1,4)*Metric(2,3)*Metric(6,7) - 4*P(5,4)*Metric(1,4)*Metric(2,3)*Metric(6,7) + 2*P(4,2)*Metric(1,5)*Metric(2,3)*Metric(6,7) + 2*P(4,3)*Metric(1,5)*Metric(2,3)*Metric(6,7) - 4*P(4,5)*Metric(1,5)*Metric(2,3)*Metric(6,7) + 2*P(5,1)*Metric(1,3)*Metric(2,4)*Metric(6,7) + 2*P(5,3)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 4*P(5,4)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 2*P(3,1)*Metric(1,5)*Metric(2,4)*Metric(6,7) - 2*P(3,2)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(3,6)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(3,7)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(4,1)*Metric(1,3)*Metric(2,5)*Metric(6,7) + 2*P(4,3)*Metric(1,3)*Metric(2,5)*Metric(6,7) - 4*P(4,5)*Metric(1,3)*Metric(2,5)*Metric(6,7) - 2*P(3,1)*Metric(1,4)*Metric(2,5)*Metric(6,7) - 2*P(3,2)*Metric(1,4)*Metric(2,5)*Metric(6,7) + 2*P(3,6)*Metric(1,4)*Metric(2,5)*Metric(6,7) + 2*P(3,7)*Metric(1,4)*Metric(2,5)*Metric(6,7) + 2*P(5,1)*Metric(1,2)*Metric(3,4)*Metric(6,7) + 2*P(5,2)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 4*P(5,4)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 2*P(2,1)*Metric(1,5)*Metric(3,4)*Metric(6,7) - 2*P(2,3)*Metric(1,5)*Metric(3,4)*Metric(6,7) + 2*P(2,6)*Metric(1,5)*Metric(3,4)*Metric(6,7) + 2*P(2,7)*Metric(1,5)*Metric(3,4)*Metric(6,7) - 2*P(1,2)*Metric(2,5)*Metric(3,4)*Metric(6,7) - 2*P(1,3)*Metric(2,5)*Metric(3,4)*Metric(6,7) + 2*P(1,6)*Metric(2,5)*Metric(3,4)*Metric(6,7) + 2*P(1,7)*Metric(2,5)*Metric(3,4)*Metric(6,7) + 2*P(4,1)*Metric(1,2)*Metric(3,5)*Metric(6,7) + 2*P(4,2)*Metric(1,2)*Metric(3,5)*Metric(6,7) - 4*P(4,5)*Metric(1,2)*Metric(3,5)*Metric(6,7) - 2*P(2,1)*Metric(1,4)*Metric(3,5)*Metric(6,7) - 2*P(2,3)*Metric(1,4)*Metric(3,5)*Metric(6,7) + 2*P(2,6)*Metric(1,4)*Metric(3,5)*Metric(6,7) + 2*P(2,7)*Metric(1,4)*Metric(3,5)*Metric(6,7) - 2*P(1,2)*Metric(2,4)*Metric(3,5)*Metric(6,7) - 2*P(1,3)*Metric(2,4)*Metric(3,5)*Metric(6,7) + 2*P(1,6)*Metric(2,4)*Metric(3,5)*Metric(6,7) + 2*P(1,7)*Metric(2,4)*Metric(3,5)*Metric(6,7) + 4*P(3,4)*Metric(1,2)*Metric(4,5)*Metric(6,7) + 4*P(3,5)*Metric(1,2)*Metric(4,5)*Metric(6,7) - 4*P(3,6)*Metric(1,2)*Metric(4,5)*Metric(6,7) - 4*P(3,7)*Metric(1,2)*Metric(4,5)*Metric(6,7) + 4*P(2,4)*Metric(1,3)*Metric(4,5)*Metric(6,7) + 4*P(2,5)*Metric(1,3)*Metric(4,5)*Metric(6,7) - 4*P(2,6)*Metric(1,3)*Metric(4,5)*Metric(6,7) - 4*P(2,7)*Metric(1,3)*Metric(4,5)*Metric(6,7) + 4*P(1,4)*Metric(2,3)*Metric(4,5)*Metric(6,7) + 4*P(1,5)*Metric(2,3)*Metric(4,5)*Metric(6,7) - 4*P(1,6)*Metric(2,3)*Metric(4,5)*Metric(6,7) - 4*P(1,7)*Metric(2,3)*Metric(4,5)*Metric(6,7)')

VVVVVVV12 = Lorentz(name = 'VVVVVVV12',
                    spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                    structure = 'P(7,1)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(7,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(7,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(7,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(6,1)*Metric(1,7)*Metric(2,5)*Metric(3,4) + 2*P(6,5)*Metric(1,7)*Metric(2,5)*Metric(3,4) - P(6,7)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(7,1)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(7,2)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(7,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(7,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(5,1)*Metric(1,7)*Metric(2,6)*Metric(3,4) + 2*P(5,6)*Metric(1,7)*Metric(2,6)*Metric(3,4) - P(5,7)*Metric(1,7)*Metric(2,6)*Metric(3,4) - P(6,2)*Metric(1,5)*Metric(2,7)*Metric(3,4) + 2*P(6,5)*Metric(1,5)*Metric(2,7)*Metric(3,4) - P(6,7)*Metric(1,5)*Metric(2,7)*Metric(3,4) - P(5,2)*Metric(1,6)*Metric(2,7)*Metric(3,4) + 2*P(5,6)*Metric(1,6)*Metric(2,7)*Metric(3,4) - P(5,7)*Metric(1,6)*Metric(2,7)*Metric(3,4) - (P(7,1)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(7,2)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(7,3)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(7,5)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(6,1)*Metric(1,7)*Metric(2,4)*Metric(3,5))/2. - P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5) + (P(6,7)*Metric(1,7)*Metric(2,4)*Metric(3,5))/2. + (P(7,1)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(7,2)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(7,3)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(7,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(4,1)*Metric(1,7)*Metric(2,6)*Metric(3,5))/2. + P(4,6)*Metric(1,7)*Metric(2,6)*Metric(3,5) - (P(4,7)*Metric(1,7)*Metric(2,6)*Metric(3,5))/2. + (P(6,2)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. - P(6,4)*Metric(1,4)*Metric(2,7)*Metric(3,5) + (P(6,7)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. - (P(4,2)*Metric(1,6)*Metric(2,7)*Metric(3,5))/2. + P(4,6)*Metric(1,6)*Metric(2,7)*Metric(3,5) - (P(4,7)*Metric(1,6)*Metric(2,7)*Metric(3,5))/2. - (P(7,1)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(7,2)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(7,3)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(7,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(5,1)*Metric(1,7)*Metric(2,4)*Metric(3,6))/2. - P(5,4)*Metric(1,7)*Metric(2,4)*Metric(3,6) + (P(5,7)*Metric(1,7)*Metric(2,4)*Metric(3,6))/2. + (P(7,1)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(7,2)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(7,3)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(7,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(4,1)*Metric(1,7)*Metric(2,5)*Metric(3,6))/2. + P(4,5)*Metric(1,7)*Metric(2,5)*Metric(3,6) - (P(4,7)*Metric(1,7)*Metric(2,5)*Metric(3,6))/2. + (P(5,2)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. - P(5,4)*Metric(1,4)*Metric(2,7)*Metric(3,6) + (P(5,7)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. - (P(4,2)*Metric(1,5)*Metric(2,7)*Metric(3,6))/2. + P(4,5)*Metric(1,5)*Metric(2,7)*Metric(3,6) - (P(4,7)*Metric(1,5)*Metric(2,7)*Metric(3,6))/2. + (P(6,3)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. + (P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. - P(6,5)*Metric(1,5)*Metric(2,4)*Metric(3,7) + (P(5,3)*Metric(1,6)*Metric(2,4)*Metric(3,7))/2. + (P(5,4)*Metric(1,6)*Metric(2,4)*Metric(3,7))/2. - P(5,6)*Metric(1,6)*Metric(2,4)*Metric(3,7) + (P(6,3)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. + (P(6,4)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. - P(6,5)*Metric(1,4)*Metric(2,5)*Metric(3,7) + P(4,3)*Metric(1,6)*Metric(2,5)*Metric(3,7) - (P(4,5)*Metric(1,6)*Metric(2,5)*Metric(3,7))/2. - (P(4,6)*Metric(1,6)*Metric(2,5)*Metric(3,7))/2. + (P(5,3)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. + (P(5,4)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. - P(5,6)*Metric(1,4)*Metric(2,6)*Metric(3,7) + P(4,3)*Metric(1,5)*Metric(2,6)*Metric(3,7) - (P(4,5)*Metric(1,5)*Metric(2,6)*Metric(3,7))/2. - (P(4,6)*Metric(1,5)*Metric(2,6)*Metric(3,7))/2. - (P(7,1)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(7,2)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(7,4)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(7,5)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(6,1)*Metric(1,7)*Metric(2,3)*Metric(4,5))/2. - P(6,3)*Metric(1,7)*Metric(2,3)*Metric(4,5) + (P(6,7)*Metric(1,7)*Metric(2,3)*Metric(4,5))/2. + (P(7,1)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(7,2)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(7,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(7,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(3,1)*Metric(1,7)*Metric(2,6)*Metric(4,5))/2. + P(3,6)*Metric(1,7)*Metric(2,6)*Metric(4,5) - (P(3,7)*Metric(1,7)*Metric(2,6)*Metric(4,5))/2. + (P(6,2)*Metric(1,3)*Metric(2,7)*Metric(4,5))/2. - P(6,3)*Metric(1,3)*Metric(2,7)*Metric(4,5) + (P(6,7)*Metric(1,3)*Metric(2,7)*Metric(4,5))/2. - (P(3,2)*Metric(1,6)*Metric(2,7)*Metric(4,5))/2. + P(3,6)*Metric(1,6)*Metric(2,7)*Metric(4,5) - (P(3,7)*Metric(1,6)*Metric(2,7)*Metric(4,5))/2. + P(7,3)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(7,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(7,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(7,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(2,3)*Metric(1,7)*Metric(3,6)*Metric(4,5) + P(2,4)*Metric(1,7)*Metric(3,6)*Metric(4,5) - P(2,5)*Metric(1,7)*Metric(3,6)*Metric(4,5) - P(2,6)*Metric(1,7)*Metric(3,6)*Metric(4,5) + P(1,3)*Metric(2,7)*Metric(3,6)*Metric(4,5) + P(1,4)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,6)*Metric(2,7)*Metric(3,6)*Metric(4,5) + (P(6,1)*Metric(1,2)*Metric(3,7)*Metric(4,5))/2. + (P(6,2)*Metric(1,2)*Metric(3,7)*Metric(4,5))/2. - P(6,3)*Metric(1,2)*Metric(3,7)*Metric(4,5) - (P(2,1)*Metric(1,6)*Metric(3,7)*Metric(4,5))/2. - (P(2,4)*Metric(1,6)*Metric(3,7)*Metric(4,5))/2. + (P(2,5)*Metric(1,6)*Metric(3,7)*Metric(4,5))/2. + (P(2,7)*Metric(1,6)*Metric(3,7)*Metric(4,5))/2. - (P(1,2)*Metric(2,6)*Metric(3,7)*Metric(4,5))/2. - (P(1,4)*Metric(2,6)*Metric(3,7)*Metric(4,5))/2. + (P(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,5))/2. + (P(1,7)*Metric(2,6)*Metric(3,7)*Metric(4,5))/2. - (P(7,1)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(7,2)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(7,4)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(7,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(5,1)*Metric(1,7)*Metric(2,3)*Metric(4,6))/2. - P(5,3)*Metric(1,7)*Metric(2,3)*Metric(4,6) + (P(5,7)*Metric(1,7)*Metric(2,3)*Metric(4,6))/2. + (P(7,1)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(7,2)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(7,4)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(7,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(3,1)*Metric(1,7)*Metric(2,5)*Metric(4,6))/2. + P(3,5)*Metric(1,7)*Metric(2,5)*Metric(4,6) - (P(3,7)*Metric(1,7)*Metric(2,5)*Metric(4,6))/2. + (P(5,2)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. - P(5,3)*Metric(1,3)*Metric(2,7)*Metric(4,6) + (P(5,7)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. - (P(3,2)*Metric(1,5)*Metric(2,7)*Metric(4,6))/2. + P(3,5)*Metric(1,5)*Metric(2,7)*Metric(4,6) - (P(3,7)*Metric(1,5)*Metric(2,7)*Metric(4,6))/2. + P(7,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(7,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(7,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(7,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(2,3)*Metric(1,7)*Metric(3,5)*Metric(4,6) + P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,5)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,6)*Metric(1,7)*Metric(3,5)*Metric(4,6) + P(1,3)*Metric(2,7)*Metric(3,5)*Metric(4,6) + P(1,4)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(1,5)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,6) + (P(5,1)*Metric(1,2)*Metric(3,7)*Metric(4,6))/2. + (P(5,2)*Metric(1,2)*Metric(3,7)*Metric(4,6))/2. - P(5,3)*Metric(1,2)*Metric(3,7)*Metric(4,6) - (P(2,1)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. - (P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. + (P(2,6)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. + (P(2,7)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. - (P(1,2)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. - (P(1,4)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. + (P(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. + (P(1,7)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. + (P(6,3)*Metric(1,5)*Metric(2,3)*Metric(4,7))/2. + (P(6,4)*Metric(1,5)*Metric(2,3)*Metric(4,7))/2. - P(6,5)*Metric(1,5)*Metric(2,3)*Metric(4,7) + (P(5,3)*Metric(1,6)*Metric(2,3)*Metric(4,7))/2. + (P(5,4)*Metric(1,6)*Metric(2,3)*Metric(4,7))/2. - P(5,6)*Metric(1,6)*Metric(2,3)*Metric(4,7) + (P(6,3)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. + (P(6,4)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. - P(6,5)*Metric(1,3)*Metric(2,5)*Metric(4,7) + P(3,4)*Metric(1,6)*Metric(2,5)*Metric(4,7) - (P(3,5)*Metric(1,6)*Metric(2,5)*Metric(4,7))/2. - (P(3,6)*Metric(1,6)*Metric(2,5)*Metric(4,7))/2. + (P(5,3)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. + (P(5,4)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. - P(5,6)*Metric(1,3)*Metric(2,6)*Metric(4,7) + P(3,4)*Metric(1,5)*Metric(2,6)*Metric(4,7) - (P(3,5)*Metric(1,5)*Metric(2,6)*Metric(4,7))/2. - (P(3,6)*Metric(1,5)*Metric(2,6)*Metric(4,7))/2. + (P(6,1)*Metric(1,2)*Metric(3,5)*Metric(4,7))/2. + (P(6,2)*Metric(1,2)*Metric(3,5)*Metric(4,7))/2. - P(6,4)*Metric(1,2)*Metric(3,5)*Metric(4,7) - (P(2,1)*Metric(1,6)*Metric(3,5)*Metric(4,7))/2. - (P(2,3)*Metric(1,6)*Metric(3,5)*Metric(4,7))/2. + (P(2,5)*Metric(1,6)*Metric(3,5)*Metric(4,7))/2. + (P(2,7)*Metric(1,6)*Metric(3,5)*Metric(4,7))/2. - (P(1,2)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. - (P(1,3)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (P(1,5)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (P(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (P(5,1)*Metric(1,2)*Metric(3,6)*Metric(4,7))/2. + (P(5,2)*Metric(1,2)*Metric(3,6)*Metric(4,7))/2. - P(5,4)*Metric(1,2)*Metric(3,6)*Metric(4,7) - (P(2,1)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. - (P(2,3)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. + (P(2,6)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. + (P(2,7)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. - (P(1,2)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. - (P(1,3)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. + (P(1,6)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. + (P(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. - P(7,1)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(7,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(7,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(7,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(4,1)*Metric(1,7)*Metric(2,3)*Metric(5,6) - 2*P(4,3)*Metric(1,7)*Metric(2,3)*Metric(5,6) + P(4,7)*Metric(1,7)*Metric(2,3)*Metric(5,6) - P(7,1)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(7,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(7,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(7,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(3,1)*Metric(1,7)*Metric(2,4)*Metric(5,6) - 2*P(3,4)*Metric(1,7)*Metric(2,4)*Metric(5,6) + P(3,7)*Metric(1,7)*Metric(2,4)*Metric(5,6) + P(4,2)*Metric(1,3)*Metric(2,7)*Metric(5,6) - 2*P(4,3)*Metric(1,3)*Metric(2,7)*Metric(5,6) + P(4,7)*Metric(1,3)*Metric(2,7)*Metric(5,6) + P(3,2)*Metric(1,4)*Metric(2,7)*Metric(5,6) - 2*P(3,4)*Metric(1,4)*Metric(2,7)*Metric(5,6) + P(3,7)*Metric(1,4)*Metric(2,7)*Metric(5,6) + 2*P(7,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(7,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(7,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(7,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(2,3)*Metric(1,7)*Metric(3,4)*Metric(5,6) + 2*P(2,4)*Metric(1,7)*Metric(3,4)*Metric(5,6) - 2*P(2,5)*Metric(1,7)*Met