# This file was automatically created by FeynRules 2.3.14
# Mathematica version: 9.0 for Mac OS X x86 (64-bit) (November 20, 2012)
# Date: Tue 5 Sep 2017 03:34:30


from object_library import all_lorentz, Lorentz

from function_library import complexconjugate, re, im, csc, sec, acsc, asec, cot
try:
   import form_factors as ForFac 
except ImportError:
   pass


UUV4 = Lorentz(name = 'UUV4',
               spins = [ -1, -1, 3 ],
               structure = 'P(3,2) + P(3,3)')

SSS4 = Lorentz(name = 'SSS4',
               spins = [ 1, 1, 1 ],
               structure = '1')

FFS4 = Lorentz(name = 'FFS4',
               spins = [ 2, 2, 1 ],
               structure = 'ProjM(2,1) + ProjP(2,1)')

FFV16 = Lorentz(name = 'FFV16',
                spins = [ 2, 2, 3 ],
                structure = 'Gamma(3,2,1)')

FFV17 = Lorentz(name = 'FFV17',
                spins = [ 2, 2, 3 ],
                structure = 'Gamma(3,2,-1)*ProjM(-1,1)')

FFV18 = Lorentz(name = 'FFV18',
                spins = [ 2, 2, 3 ],
                structure = 'Gamma(3,2,-1)*ProjM(-1,1) - 2*Gamma(3,2,-1)*ProjP(-1,1)')

FFV19 = Lorentz(name = 'FFV19',
                spins = [ 2, 2, 3 ],
                structure = 'Gamma(3,2,-1)*ProjM(-1,1) + 2*Gamma(3,2,-1)*ProjP(-1,1)')

FFV20 = Lorentz(name = 'FFV20',
                spins = [ 2, 2, 3 ],
                structure = 'Gamma(3,2,-1)*ProjM(-1,1) + 4*Gamma(3,2,-1)*ProjP(-1,1)')

VVS4 = Lorentz(name = 'VVS4',
               spins = [ 3, 3, 1 ],
               structure = 'Metric(1,2)')

VVV4 = Lorentz(name = 'VVV4',
               spins = [ 3, 3, 3 ],
               structure = 'P(3,1)*Metric(1,2) - P(3,2)*Metric(1,2) - P(2,1)*Metric(1,3) + P(2,3)*Metric(1,3) + P(1,2)*Metric(2,3) - P(1,3)*Metric(2,3)')

SSSS4 = Lorentz(name = 'SSSS4',
                spins = [ 1, 1, 1, 1 ],
                structure = '1')

VVSS4 = Lorentz(name = 'VVSS4',
                spins = [ 3, 3, 1, 1 ],
                structure = 'Metric(1,2)')

VVVV28 = Lorentz(name = 'VVVV28',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) - Metric(1,3)*Metric(2,4)')

VVVV29 = Lorentz(name = 'VVVV29',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) + Metric(1,3)*Metric(2,4) - 2*Metric(1,2)*Metric(3,4)')

VVVV30 = Lorentz(name = 'VVVV30',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) - Metric(1,2)*Metric(3,4)')

VVVV31 = Lorentz(name = 'VVVV31',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,3)*Metric(2,4) - Metric(1,2)*Metric(3,4)')

VVVV32 = Lorentz(name = 'VVVV32',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) - (Metric(1,3)*Metric(2,4))/2. - (Metric(1,2)*Metric(3,4))/2.')

VVVV33 = Lorentz(name = 'VVVV33',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,3)*P(2,4)*P(3,2)*P(4,1) + P(1,2)*P(2,3)*P(3,4)*P(4,1) + P(1,4)*P(2,3)*P(3,1)*P(4,2) + P(1,4)*P(2,1)*P(3,2)*P(4,3) + P(-1,3)*P(-1,4)*P(3,2)*P(4,1)*Metric(1,2) - P(-1,2)*P(-1,3)*P(3,4)*P(4,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*P(4,3)*Metric(1,2) + P(-1,2)*P(-1,4)*P(2,3)*P(4,1)*Metric(1,3) - P(-1,2)*P(-1,3)*P(2,4)*P(4,1)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*P(4,2)*Metric(1,3) - P(-1,2)*P(-1,4)*P(2,3)*P(3,1)*Metric(1,4) + P(-1,2)*P(-1,3)*P(2,4)*P(3,1)*Metric(1,4) - P(-1,3)*P(-1,4)*P(2,1)*P(3,2)*Metric(1,4) - P(-1,1)*P(-1,3)*P(2,4)*P(3,2)*Metric(1,4) + P(-1,2)*P(-1,3)*P(2,1)*P(3,4)*Metric(1,4) - P(-1,1)*P(-1,2)*P(2,3)*P(3,4)*Metric(1,4) - P(-1,3)*P(-1,4)*P(1,2)*P(4,1)*Metric(2,3) - P(-1,2)*P(-1,4)*P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,3)*P(4,2)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,4)*P(4,2)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,2)*P(4,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*P(4,3)*Metric(2,3) + P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,3)*P(1,4)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,4)*P(1,3)*P(3,2)*Metric(2,4) + P(-1,1)*P(-1,3)*P(1,4)*P(3,2)*Metric(2,4) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,3)*P(1,4)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,4)*P(1,2)*P(2,3)*Metric(3,4) + P(-1,1)*P(-1,2)*P(1,4)*P(2,3)*Metric(3,4) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV34 = Lorentz(name = 'VVVV34',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,3)*P(2,4)*P(3,2)*P(4,1) + (P(1,2)*P(2,3)*P(3,4)*P(4,1))/2. + P(1,4)*P(2,3)*P(3,1)*P(4,2) + (P(1,3)*P(2,1)*P(3,4)*P(4,2))/2. + (P(1,2)*P(2,4)*P(3,1)*P(4,3))/2. + (P(1,4)*P(2,1)*P(3,2)*P(4,3))/2. + (P(-1,3)*P(-1,4)*P(3,2)*P(4,1)*Metric(1,2))/2. - (P(-1,2)*P(-1,3)*P(3,4)*P(4,1)*Metric(1,2))/2. + (P(-1,3)*P(-1,4)*P(3,1)*P(4,2)*Metric(1,2))/2. - (P(-1,1)*P(-1,3)*P(3,4)*P(4,2)*Metric(1,2))/2. - (P(-1,2)*P(-1,4)*P(3,1)*P(4,3)*Metric(1,2))/2. - (P(-1,1)*P(-1,4)*P(3,2)*P(4,3)*Metric(1,2))/2. + P(-1,2)*P(-1,4)*P(2,3)*P(4,1)*Metric(1,3) - P(-1,2)*P(-1,3)*P(2,4)*P(4,1)*Metric(1,3) - (P(-1,3)*P(-1,4)*P(2,1)*P(4,2)*Metric(1,3))/2. - P(-1,1)*P(-1,4)*P(2,3)*P(4,2)*Metric(1,3) + (P(-1,2)*P(-1,4)*P(2,1)*P(4,3)*Metric(1,3))/2. - (P(-1,1)*P(-1,2)*P(2,4)*P(4,3)*Metric(1,3))/2. - P(-1,2)*P(-1,4)*P(2,3)*P(3,1)*Metric(1,4) + P(-1,2)*P(-1,3)*P(2,4)*P(3,1)*Metric(1,4) - (P(-1,3)*P(-1,4)*P(2,1)*P(3,2)*Metric(1,4))/2. - P(-1,1)*P(-1,3)*P(2,4)*P(3,2)*Metric(1,4) + (P(-1,2)*P(-1,3)*P(2,1)*P(3,4)*Metric(1,4))/2. - (P(-1,1)*P(-1,2)*P(2,3)*P(3,4)*Metric(1,4))/2. - (P(-1,3)*P(-1,4)*P(1,2)*P(4,1)*Metric(2,3))/2. - P(-1,2)*P(-1,4)*P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,3)*P(4,2)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,4)*P(4,2)*Metric(2,3) + (P(-1,1)*P(-1,4)*P(1,2)*P(4,3)*Metric(2,3))/2. - (P(-1,1)*P(-1,2)*P(1,4)*P(4,3)*Metric(2,3))/2. + (P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3))/2. + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - (P(-1,3)*P(-1,4)*P(1,2)*P(3,1)*Metric(2,4))/2. - P(-1,2)*P(-1,3)*P(1,4)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,4)*P(1,3)*P(3,2)*Metric(2,4) + P(-1,1)*P(-1,3)*P(1,4)*P(3,2)*Metric(2,4) + (P(-1,1)*P(-1,3)*P(1,2)*P(3,4)*Metric(2,4))/2. - (P(-1,1)*P(-1,2)*P(1,3)*P(3,4)*Metric(2,4))/2. + (P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4))/2. + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - (P(-1,2)*P(-1,4)*P(1,3)*P(2,1)*Metric(3,4))/2. - (P(-1,2)*P(-1,3)*P(1,4)*P(2,1)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*P(1,2)*P(2,3)*Metric(3,4))/2. + (P(-1,1)*P(-1,2)*P(1,4)*P(2,3)*Metric(3,4))/2. - (P(-1,1)*P(-1,3)*P(1,2)*P(2,4)*Metric(3,4))/2. + (P(-1,1)*P(-1,2)*P(1,3)*P(2,4)*Metric(3,4))/2. + (P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4))/2. + (P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4))/2.')

VVVV35 = Lorentz(name = 'VVVV35',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,2)*P(2,3)*P(3,4)*P(4,1) + P(1,3)*P(2,1)*P(3,4)*P(4,2) + P(1,2)*P(2,4)*P(3,1)*P(4,3) + P(1,4)*P(2,1)*P(3,2)*P(4,3) + P(-1,3)*P(-1,4)*P(3,2)*P(4,1)*Metric(1,2) - P(-1,2)*P(-1,3)*P(3,4)*P(4,1)*Metric(1,2) + P(-1,3)*P(-1,4)*P(3,1)*P(4,2)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,4)*P(4,2)*Metric(1,2) - P(-1,2)*P(-1,4)*P(3,1)*P(4,3)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*P(4,3)*Metric(1,2) - P(-1,3)*P(-1,4)*P(2,1)*P(4,2)*Metric(1,3) + P(-1,2)*P(-1,4)*P(2,1)*P(4,3)*Metric(1,3) - P(-1,1)*P(-1,2)*P(2,4)*P(4,3)*Metric(1,3) - P(-1,3)*P(-1,4)*P(2,1)*P(3,2)*Metric(1,4) + P(-1,2)*P(-1,3)*P(2,1)*P(3,4)*Metric(1,4) - P(-1,1)*P(-1,2)*P(2,3)*P(3,4)*Metric(1,4) - P(-1,3)*P(-1,4)*P(1,2)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,2)*P(4,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*P(4,3)*Metric(2,3) + P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,4)*P(1,2)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,3)*P(1,2)*P(3,4)*Metric(2,4) - P(-1,1)*P(-1,2)*P(1,3)*P(3,4)*Metric(2,4) + P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*P(1,3)*P(2,1)*Metric(3,4) - P(-1,2)*P(-1,3)*P(1,4)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,4)*P(1,2)*P(2,3)*Metric(3,4) + P(-1,1)*P(-1,2)*P(1,4)*P(2,3)*Metric(3,4) - P(-1,1)*P(-1,3)*P(1,2)*P(2,4)*Metric(3,4) + P(-1,1)*P(-1,2)*P(1,3)*P(2,4)*Metric(3,4) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV36 = Lorentz(name = 'VVVV36',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,3)*P(2,4)*P(3,2)*P(4,1) + P(1,2)*P(2,3)*P(3,4)*P(4,1) + P(1,4)*P(2,3)*P(3,1)*P(4,2) + P(1,3)*P(2,1)*P(3,4)*P(4,2) + P(1,2)*P(2,4)*P(3,1)*P(4,3) + P(1,4)*P(2,1)*P(3,2)*P(4,3) + P(-1,3)*P(-1,4)*P(3,2)*P(4,1)*Metric(1,2) - P(-1,2)*P(-1,3)*P(3,4)*P(4,1)*Metric(1,2) + P(-1,3)*P(-1,4)*P(3,1)*P(4,2)*Metric(1,2) - P(-1,1)*P(-1,3)*P(3,4)*P(4,2)*Metric(1,2) - P(-1,2)*P(-1,4)*P(3,1)*P(4,3)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*P(4,3)*Metric(1,2) + P(-1,2)*P(-1,4)*P(2,3)*P(4,1)*Metric(1,3) - P(-1,2)*P(-1,3)*P(2,4)*P(4,1)*Metric(1,3) - P(-1,3)*P(-1,4)*P(2,1)*P(4,2)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*P(4,2)*Metric(1,3) + P(-1,2)*P(-1,4)*P(2,1)*P(4,3)*Metric(1,3) - P(-1,1)*P(-1,2)*P(2,4)*P(4,3)*Metric(1,3) - P(-1,2)*P(-1,4)*P(2,3)*P(3,1)*Metric(1,4) + P(-1,2)*P(-1,3)*P(2,4)*P(3,1)*Metric(1,4) - P(-1,3)*P(-1,4)*P(2,1)*P(3,2)*Metric(1,4) - P(-1,1)*P(-1,3)*P(2,4)*P(3,2)*Metric(1,4) + P(-1,2)*P(-1,3)*P(2,1)*P(3,4)*Metric(1,4) - P(-1,1)*P(-1,2)*P(2,3)*P(3,4)*Metric(1,4) - P(-1,3)*P(-1,4)*P(1,2)*P(4,1)*Metric(2,3) - P(-1,2)*P(-1,4)*P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,3)*P(4,2)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,4)*P(4,2)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,2)*P(4,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*P(4,3)*Metric(2,3) + P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,4)*P(1,2)*P(3,1)*Metric(2,4) - P(-1,2)*P(-1,3)*P(1,4)*P(3,1)*Metric(2,4) - P(-1,1)*P(-1,4)*P(1,3)*P(3,2)*Metric(2,4) + P(-1,1)*P(-1,3)*P(1,4)*P(3,2)*Metric(2,4) + P(-1,1)*P(-1,3)*P(1,2)*P(3,4)*Metric(2,4) - P(-1,1)*P(-1,2)*P(1,3)*P(3,4)*Metric(2,4) + P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*P(1,3)*P(2,1)*Metric(3,4) - P(-1,2)*P(-1,3)*P(1,4)*P(2,1)*Metric(3,4) - P(-1,1)*P(-1,4)*P(1,2)*P(2,3)*Metric(3,4) + P(-1,1)*P(-1,2)*P(1,4)*P(2,3)*Metric(3,4) - P(-1,1)*P(-1,3)*P(1,2)*P(2,4)*Metric(3,4) + P(-1,1)*P(-1,2)*P(1,3)*P(2,4)*Metric(3,4) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVV19 = Lorentz(name = 'VVVVV19',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = '-(P(3,4)*P(4,2)*P(5,1)*Metric(1,2)) + P(3,5)*P(4,2)*P(5,1)*Metric(1,2) + P(3,2)*P(4,3)*P(5,1)*Metric(1,2) - P(3,2)*P(4,5)*P(5,1)*Metric(1,2) - P(3,4)*P(4,1)*P(5,2)*Metric(1,2) + P(3,5)*P(4,1)*P(5,2)*Metric(1,2) + P(3,1)*P(4,3)*P(5,2)*Metric(1,2) - P(3,1)*P(4,5)*P(5,2)*Metric(1,2) - P(3,2)*P(4,1)*P(5,3)*Metric(1,2) - P(3,1)*P(4,2)*P(5,3)*Metric(1,2) + P(3,2)*P(4,1)*P(5,4)*Metric(1,2) + P(3,1)*P(4,2)*P(5,4)*Metric(1,2) - P(2,1)*P(4,3)*P(5,2)*Metric(1,3) + P(2,1)*P(4,5)*P(5,2)*Metric(1,3) + P(2,1)*P(4,2)*P(5,3)*Metric(1,3) - P(2,1)*P(4,2)*P(5,4)*Metric(1,3) + P(2,1)*P(3,4)*P(5,2)*Metric(1,4) - P(2,1)*P(3,5)*P(5,2)*Metric(1,4) + P(2,1)*P(3,2)*P(5,3)*Metric(1,4) - P(2,1)*P(3,2)*P(5,4)*Metric(1,4) + P(2,1)*P(3,4)*P(4,2)*Metric(1,5) - P(2,1)*P(3,5)*P(4,2)*Metric(1,5) - P(2,1)*P(3,2)*P(4,3)*Metric(1,5) + P(2,1)*P(3,2)*P(4,5)*Metric(1,5) - P(1,2)*P(4,3)*P(5,1)*Metric(2,3) + P(1,2)*P(4,5)*P(5,1)*Metric(2,3) + P(1,2)*P(4,1)*P(5,3)*Metric(2,3) - P(1,2)*P(4,1)*P(5,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,2)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,5)*Metric(2,3) + P(1,2)*P(3,4)*P(5,1)*Metric(2,4) - P(1,2)*P(3,5)*P(5,1)*Metric(2,4) + P(1,2)*P(3,1)*P(5,3)*Metric(2,4) - P(1,2)*P(3,1)*P(5,4)*Metric(2,4) - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,2)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,2)*P(3,4)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,5)*Metric(2,4) + P(1,2)*P(3,4)*P(4,1)*Metric(2,5) - P(1,2)*P(3,5)*P(4,1)*Metric(2,5) - P(1,2)*P(3,1)*P(4,3)*Metric(2,5) + P(1,2)*P(3,1)*P(4,5)*Metric(2,5) + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,2)*P(3,4)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,2)*P(2,3)*P(5,1)*Metric(3,4) - P(1,2)*P(2,4)*P(5,1)*Metric(3,4) + P(1,3)*P(2,1)*P(5,2)*Metric(3,4) - P(1,4)*P(2,1)*P(5,2)*Metric(3,4) - P(-1,2)*P(-1,3)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,3)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(1,3)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,2)*P(1,4)*Metric(2,5)*Metric(3,4) - P(1,2)*P(2,3)*P(4,1)*Metric(3,5) + P(1,2)*P(2,5)*P(4,1)*Metric(3,5) - P(1,3)*P(2,1)*P(4,2)*Metric(3,5) + P(1,5)*P(2,1)*P(4,2)*Metric(3,5) + P(-1,2)*P(-1,3)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,3)*P(4,2)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,3)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,2)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,2)*P(2,3)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,3)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,2)*P(1,3)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,4)*Metric(3,5) + P(1,2)*P(2,4)*P(3,1)*Metric(4,5) - P(1,2)*P(2,5)*P(3,1)*Metric(4,5) + P(1,4)*P(2,1)*P(3,2)*Metric(4,5) - P(1,5)*P(2,1)*P(3,2)*Metric(4,5) - P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV20 = Lorentz(name = 'VVVVV20',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,5)*P(4,2)*P(5,1)*Metric(1,2) - P(3,5)*P(4,3)*P(5,1)*Metric(1,2) - P(3,2)*P(4,5)*P(5,1)*Metric(1,2) + P(3,4)*P(4,5)*P(5,1)*Metric(1,2) + P(3,4)*P(4,1)*P(5,2)*Metric(1,2) - P(3,4)*P(4,1)*P(5,3)*Metric(1,2) - P(3,2)*P(4,1)*P(5,4)*Metric(1,2) + P(3,5)*P(4,1)*P(5,4)*Metric(1,2) + P(2,5)*P(4,2)*P(5,1)*Metric(1,3) - P(2,5)*P(4,3)*P(5,1)*Metric(1,3) + P(2,3)*P(4,5)*P(5,1)*Metric(1,3) - P(2,4)*P(4,5)*P(5,1)*Metric(1,3) + P(2,4)*P(4,1)*P(5,2)*Metric(1,3) - P(2,4)*P(4,1)*P(5,3)*Metric(1,3) + P(2,3)*P(4,1)*P(5,4)*Metric(1,3) - P(2,5)*P(4,1)*P(5,4)*Metric(1,3) + P(2,4)*P(3,2)*P(5,1)*Metric(1,4) - P(2,5)*P(3,2)*P(5,1)*Metric(1,4) - P(2,3)*P(3,4)*P(5,1)*Metric(1,4) + 2*P(2,5)*P(3,4)*P(5,1)*Metric(1,4) + P(2,3)*P(3,5)*P(5,1)*Metric(1,4) - 2*P(2,4)*P(3,5)*P(5,1)*Metric(1,4) - P(2,4)*P(3,1)*P(5,2)*Metric(1,4) - P(2,1)*P(3,4)*P(5,2)*Metric(1,4) + P(2,4)*P(3,1)*P(5,3)*Metric(1,4) + P(2,1)*P(3,4)*P(5,3)*Metric(1,4) - P(2,3)*P(3,1)*P(5,4)*Metric(1,4) + P(2,5)*P(3,1)*P(5,4)*Metric(1,4) + P(2,1)*P(3,2)*P(5,4)*Metric(1,4) - P(2,1)*P(3,5)*P(5,4)*Metric(1,4) - P(2,4)*P(3,2)*P(4,1)*Metric(1,5) + P(2,5)*P(3,2)*P(4,1)*Metric(1,5) + P(2,3)*P(3,4)*P(4,1)*Metric(1,5) - 2*P(2,5)*P(3,4)*P(4,1)*Metric(1,5) - P(2,3)*P(3,5)*P(4,1)*Metric(1,5) + 2*P(2,4)*P(3,5)*P(4,1)*Metric(1,5) - P(2,5)*P(3,1)*P(4,2)*Metric(1,5) - P(2,1)*P(3,5)*P(4,2)*Metric(1,5) + P(2,5)*P(3,1)*P(4,3)*Metric(1,5) + P(2,1)*P(3,5)*P(4,3)*Metric(1,5) - P(2,3)*P(3,1)*P(4,5)*Metric(1,5) + P(2,4)*P(3,1)*P(4,5)*Metric(1,5) + P(2,1)*P(3,2)*P(4,5)*Metric(1,5) - P(2,1)*P(3,4)*P(4,5)*Metric(1,5) + P(1,4)*P(4,2)*P(5,1)*Metric(2,3) - P(1,4)*P(4,3)*P(5,1)*Metric(2,3) + P(1,2)*P(4,5)*P(5,1)*Metric(2,3) - P(1,3)*P(4,5)*P(5,1)*Metric(2,3) + P(1,5)*P(4,1)*P(5,2)*Metric(2,3) - P(1,5)*P(4,1)*P(5,3)*Metric(2,3) + P(1,2)*P(4,1)*P(5,4)*Metric(2,3) - P(1,3)*P(4,1)*P(5,4)*Metric(2,3) - P(-1,2)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,3)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,4)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,4)*P(4,3)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) - P(1,4)*P(3,2)*P(5,1)*Metric(2,4) - P(1,2)*P(3,5)*P(5,1)*Metric(2,4) + 2*P(1,4)*P(3,5)*P(5,1)*Metric(2,4) + P(1,4)*P(3,1)*P(5,2)*Metric(2,4) - P(1,5)*P(3,1)*P(5,2)*Metric(2,4) - P(1,4)*P(3,1)*P(5,3)*Metric(2,4) + P(1,5)*P(3,1)*P(5,4)*Metric(2,4) - P(-1,2)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,5)*Metric(2,4) - 2*P(-1,1)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - P(1,5)*P(3,2)*P(4,1)*Metric(2,5) - P(1,2)*P(3,4)*P(4,1)*Metric(2,5) + 2*P(1,5)*P(3,4)*P(4,1)*Metric(2,5) - P(1,4)*P(3,1)*P(4,2)*Metric(2,5) + P(1,5)*P(3,1)*P(4,2)*Metric(2,5) - P(1,5)*P(3,1)*P(4,3)*Metric(2,5) + P(1,4)*P(3,1)*P(4,5)*Metric(2,5) - P(-1,2)*P(-1,4)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,4)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,4)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,2)*P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(-1,1)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(1,4)*P(2,3)*P(5,1)*Metric(3,4) + P(1,3)*P(2,5)*P(5,1)*Metric(3,4) - 2*P(1,4)*P(2,5)*P(5,1)*Metric(3,4) + P(1,4)*P(2,1)*P(5,2)*Metric(3,4) - P(1,4)*P(2,1)*P(5,3)*Metric(3,4) + P(1,5)*P(2,1)*P(5,3)*Metric(3,4) - P(1,5)*P(2,1)*P(5,4)*Metric(3,4) + P(-1,3)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*P(5,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4) + 2*P(-1,1)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,5)*Metric(3,4) + 2*P(-1,1)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4) - 2*P(-1,1)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + P(1,5)*P(2,3)*P(4,1)*Metric(3,5) + P(1,3)*P(2,4)*P(4,1)*Metric(3,5) - 2*P(1,5)*P(2,4)*P(4,1)*Metric(3,5) + P(1,5)*P(2,1)*P(4,2)*Metric(3,5) + P(1,4)*P(2,1)*P(4,3)*Metric(3,5) - P(1,5)*P(2,1)*P(4,3)*Metric(3,5) - P(1,4)*P(2,1)*P(4,5)*Metric(3,5) + P(-1,3)*P(-1,4)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,4)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,4)*P(4,3)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) - P(-1,3)*P(-1,4)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,3)*P(2,4)*Metric(1,4)*Metric(3,5) + 2*P(-1,1)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,3)*P(1,4)*Metric(2,4)*Metric(3,5) - 2*P(-1,1)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(-1,1)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) + P(1,4)*P(2,3)*P(3,1)*Metric(4,5) + P(1,5)*P(2,3)*P(3,1)*Metric(4,5) - P(1,5)*P(2,4)*P(3,1)*Metric(4,5) - P(1,4)*P(2,5)*P(3,1)*Metric(4,5) - P(1,4)*P(2,1)*P(3,2)*Metric(4,5) - P(1,5)*P(2,1)*P(3,2)*Metric(4,5) + P(1,5)*P(2,1)*P(3,4)*Metric(4,5) + P(1,4)*P(2,1)*P(3,5)*Metric(4,5) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV21 = Lorentz(name = 'VVVVV21',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = '-(P(3,4)*P(4,2)*P(5,1)*Metric(1,2))/2. + (P(3,5)*P(4,2)*P(5,1)*Metric(1,2))/2. + P(3,2)*P(4,3)*P(5,1)*Metric(1,2) - (P(3,2)*P(4,5)*P(5,1)*Metric(1,2))/2. - (P(3,4)*P(4,1)*P(5,2)*Metric(1,2))/2. + (P(3,5)*P(4,1)*P(5,2)*Metric(1,2))/2. + P(3,1)*P(4,3)*P(5,2)*Metric(1,2) - (P(3,1)*P(4,5)*P(5,2)*Metric(1,2))/2. - P(3,2)*P(4,1)*P(5,3)*Metric(1,2) - P(3,1)*P(4,2)*P(5,3)*Metric(1,2) + (P(3,1)*P(4,5)*P(5,3)*Metric(1,2))/2. + (P(3,2)*P(4,5)*P(5,3)*Metric(1,2))/2. + (P(3,2)*P(4,1)*P(5,4)*Metric(1,2))/2. + (P(3,1)*P(4,2)*P(5,4)*Metric(1,2))/2. - (P(3,1)*P(4,3)*P(5,4)*Metric(1,2))/2. - (P(3,2)*P(4,3)*P(5,4)*Metric(1,2))/2. + P(2,3)*P(4,2)*P(5,1)*Metric(1,3) - (P(2,4)*P(4,3)*P(5,1)*Metric(1,3))/2. + (P(2,5)*P(4,3)*P(5,1)*Metric(1,3))/2. - (P(2,3)*P(4,5)*P(5,1)*Metric(1,3))/2. - P(2,3)*P(4,1)*P(5,2)*Metric(1,3) - P(2,1)*P(4,3)*P(5,2)*Metric(1,3) + (P(2,1)*P(4,5)*P(5,2)*Metric(1,3))/2. + (P(2,3)*P(4,5)*P(5,2)*Metric(1,3))/2. - (P(2,4)*P(4,1)*P(5,3)*Metric(1,3))/2. + (P(2,5)*P(4,1)*P(5,3)*Metric(1,3))/2. + P(2,1)*P(4,2)*P(5,3)*Metric(1,3) - (P(2,1)*P(4,5)*P(5,3)*Metric(1,3))/2. + (P(2,3)*P(4,1)*P(5,4)*Metric(1,3))/2. - (P(2,1)*P(4,2)*P(5,4)*Metric(1,3))/2. - (P(2,3)*P(4,2)*P(5,4)*Metric(1,3))/2. + (P(2,1)*P(4,3)*P(5,4)*Metric(1,3))/2. + P(2,3)*P(3,1)*P(5,2)*Metric(1,4) + (P(2,1)*P(3,4)*P(5,2)*Metric(1,4))/2. - (P(2,3)*P(3,4)*P(5,2)*Metric(1,4))/2. - (P(2,1)*P(3,5)*P(5,2)*Metric(1,4))/2. + (P(2,4)*P(3,1)*P(5,3)*Metric(1,4))/2. - (P(2,5)*P(3,1)*P(5,3)*Metric(1,4))/2. + P(2,1)*P(3,2)*P(5,3)*Metric(1,4) - (P(2,4)*P(3,2)*P(5,3)*Metric(1,4))/2. - (P(2,3)*P(3,1)*P(5,4)*Metric(1,4))/2. - (P(2,1)*P(3,2)*P(5,4)*Metric(1,4))/2. - P(2,3)*P(3,1)*P(4,2)*Metric(1,5) + (P(2,1)*P(3,4)*P(4,2)*Metric(1,5))/2. - (P(2,1)*P(3,5)*P(4,2)*Metric(1,5))/2. + (P(2,3)*P(3,5)*P(4,2)*Metric(1,5))/2. + (P(2,4)*P(3,1)*P(4,3)*Metric(1,5))/2. - (P(2,5)*P(3,1)*P(4,3)*Metric(1,5))/2. - P(2,1)*P(3,2)*P(4,3)*Metric(1,5) + (P(2,5)*P(3,2)*P(4,3)*Metric(1,5))/2. + (P(2,3)*P(3,1)*P(4,5)*Metric(1,5))/2. + (P(2,1)*P(3,2)*P(4,5)*Metric(1,5))/2. - P(1,3)*P(4,2)*P(5,1)*Metric(2,3) - P(1,2)*P(4,3)*P(5,1)*Metric(2,3) + (P(1,2)*P(4,5)*P(5,1)*Metric(2,3))/2. + (P(1,3)*P(4,5)*P(5,1)*Metric(2,3))/2. + P(1,3)*P(4,1)*P(5,2)*Metric(2,3) - (P(1,4)*P(4,3)*P(5,2)*Metric(2,3))/2. + (P(1,5)*P(4,3)*P(5,2)*Metric(2,3))/2. - (P(1,3)*P(4,5)*P(5,2)*Metric(2,3))/2. + P(1,2)*P(4,1)*P(5,3)*Metric(2,3) - (P(1,4)*P(4,2)*P(5,3)*Metric(2,3))/2. + (P(1,5)*P(4,2)*P(5,3)*Metric(2,3))/2. - (P(1,2)*P(4,5)*P(5,3)*Metric(2,3))/2. - (P(1,2)*P(4,1)*P(5,4)*Metric(2,3))/2. - (P(1,3)*P(4,1)*P(5,4)*Metric(2,3))/2. + (P(1,3)*P(4,2)*P(5,4)*Metric(2,3))/2. + (P(1,2)*P(4,3)*P(5,4)*Metric(2,3))/2. - P(-1,1)*P(-1,3)*P(5,2)*Metric(1,4)*Metric(2,3) + (P(-1,3)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3))/2. - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,4)*Metric(2,3) + (P(-1,2)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,2)*P(5,4)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,3)*P(5,4)*Metric(1,4)*Metric(2,3))/2. + P(-1,1)*P(-1,3)*P(4,2)*Metric(1,5)*Metric(2,3) - (P(-1,3)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3))/2. + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,5)*Metric(2,3) - (P(-1,2)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3))/2. - (P(-1,1)*P(-1,2)*P(4,5)*Metric(1,5)*Metric(2,3))/2. - (P(-1,1)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3))/2. + P(1,3)*P(3,2)*P(5,1)*Metric(2,4) + (P(1,2)*P(3,4)*P(5,1)*Metric(2,4))/2. - (P(1,3)*P(3,4)*P(5,1)*Metric(2,4))/2. - (P(1,2)*P(3,5)*P(5,1)*Metric(2,4))/2. + P(1,2)*P(3,1)*P(5,3)*Metric(2,4) - (P(1,4)*P(3,1)*P(5,3)*Metric(2,4))/2. + (P(1,4)*P(3,2)*P(5,3)*Metric(2,4))/2. - (P(1,5)*P(3,2)*P(5,3)*Metric(2,4))/2. - (P(1,2)*P(3,1)*P(5,4)*Metric(2,4))/2. - (P(1,3)*P(3,2)*P(5,4)*Metric(2,4))/2. - P(-1,2)*P(-1,3)*P(5,1)*Metric(1,3)*Metric(2,4) + (P(-1,3)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4))/2. - P(-1,1)*P(-1,2)*P(5,3)*Metric(1,3)*Metric(2,4) + (P(-1,1)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,2)*P(5,4)*Metric(1,3)*Metric(2,4))/2. + (P(-1,2)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4))/2. + P(-1,2)*P(-1,3)*P(3,1)*Metric(1,5)*Metric(2,4) - (P(-1,3)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4))/2. - P(-1,1)*P(-1,3)*P(3,2)*Metric(1,5)*Metric(2,4) + (P(-1,3)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4))/2. - (P(-1,1)*P(-1,2)*P(3,4)*Metric(1,5)*Metric(2,4))/2. + (P(-1,1)*P(-1,3)*P(3,4)*Metric(1,5)*Metric(2,4))/2. + (P(-1,1)*P(-1,2)*P(3,5)*Metric(1,5)*Metric(2,4))/2. - (P(-1,2)*P(-1,3)*P(3,5)*Metric(1,5)*Metric(2,4))/2. - P(1,3)*P(3,2)*P(4,1)*Metric(2,5) + (P(1,2)*P(3,4)*P(4,1)*Metric(2,5))/2. - (P(1,2)*P(3,5)*P(4,1)*Metric(2,5))/2. + (P(1,3)*P(3,5)*P(4,1)*Metric(2,5))/2. - P(1,2)*P(3,1)*P(4,3)*Metric(2,5) + (P(1,5)*P(3,1)*P(4,3)*Metric(2,5))/2. + (P(1,4)*P(3,2)*P(4,3)*Metric(2,5))/2. - (P(1,5)*P(3,2)*P(4,3)*Metric(2,5))/2. + (P(1,2)*P(3,1)*P(4,5)*Metric(2,5))/2. + (P(1,3)*P(3,2)*P(4,5)*Metric(2,5))/2. + P(-1,2)*P(-1,3)*P(4,1)*Metric(1,3)*Metric(2,5) - (P(-1,3)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5))/2. + P(-1,1)*P(-1,2)*P(4,3)*Metric(1,3)*Metric(2,5) - (P(-1,1)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5))/2. - (P(-1,1)*P(-1,2)*P(4,5)*Metric(1,3)*Metric(2,5))/2. - (P(-1,2)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5))/2. - P(-1,2)*P(-1,3)*P(3,1)*Metric(1,4)*Metric(2,5) + (P(-1,3)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5))/2. + P(-1,1)*P(-1,3)*P(3,2)*Metric(1,4)*Metric(2,5) - (P(-1,3)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5))/2. - (P(-1,1)*P(-1,2)*P(3,4)*Metric(1,4)*Metric(2,5))/2. + (P(-1,2)*P(-1,3)*P(3,4)*Metric(1,4)*Metric(2,5))/2. + (P(-1,1)*P(-1,2)*P(3,5)*Metric(1,4)*Metric(2,5))/2. - (P(-1,1)*P(-1,3)*P(3,5)*Metric(1,4)*Metric(2,5))/2. + P(1,2)*P(2,3)*P(5,1)*Metric(3,4) - (P(1,2)*P(2,4)*P(5,1)*Metric(3,4))/2. + (P(1,3)*P(2,4)*P(5,1)*Metric(3,4))/2. - (P(1,3)*P(2,5)*P(5,1)*Metric(3,4))/2. + P(1,3)*P(2,1)*P(5,2)*Metric(3,4) - (P(1,4)*P(2,1)*P(5,2)*Metric(3,4))/2. + (P(1,4)*P(2,3)*P(5,2)*Metric(3,4))/2. - (P(1,5)*P(2,3)*P(5,2)*Metric(3,4))/2. - (P(1,3)*P(2,1)*P(5,4)*Metric(3,4))/2. - (P(1,2)*P(2,3)*P(5,4)*Metric(3,4))/2. - P(-1,2)*P(-1,3)*P(5,1)*Metric(1,2)*Metric(3,4) + (P(-1,2)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4))/2. - P(-1,1)*P(-1,3)*P(5,2)*Metric(1,2)*Metric(3,4) + (P(-1,1)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4))/2. + (P(-1,1)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4))/2. + (P(-1,2)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4))/2. + P(-1,2)*P(-1,3)*P(2,1)*Metric(1,5)*Metric(3,4) - (P(-1,2)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4))/2. - P(-1,1)*P(-1,2)*P(2,3)*Metric(1,5)*Metric(3,4) + (P(-1,2)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4))/2. + (P(-1,1)*P(-1,2)*P(2,4)*Metric(1,5)*Metric(3,4))/2. - (P(-1,1)*P(-1,3)*P(2,4)*Metric(1,5)*Metric(3,4))/2. + (P(-1,1)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4))/2. - (P(-1,2)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4))/2. + P(-1,1)*P(-1,3)*P(1,2)*Metric(2,5)*Metric(3,4) - (P(-1,1)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4))/2. - P(-1,1)*P(-1,2)*P(1,3)*Metric(2,5)*Metric(3,4) + (P(-1,1)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4))/2. + (P(-1,1)*P(-1,2)*P(1,4)*Metric(2,5)*Metric(3,4))/2. - (P(-1,2)*P(-1,3)*P(1,4)*Metric(2,5)*Metric(3,4))/2. - (P(-1,1)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4))/2. + (P(-1,2)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4))/2. - P(1,2)*P(2,3)*P(4,1)*Metric(3,5) + (P(1,3)*P(2,4)*P(4,1)*Metric(3,5))/2. + (P(1,2)*P(2,5)*P(4,1)*Metric(3,5))/2. - (P(1,3)*P(2,5)*P(4,1)*Metric(3,5))/2. - P(1,3)*P(2,1)*P(4,2)*Metric(3,5) + (P(1,5)*P(2,1)*P(4,2)*Metric(3,5))/2. + (P(1,4)*P(2,3)*P(4,2)*Metric(3,5))/2. - (P(1,5)*P(2,3)*P(4,2)*Metric(3,5))/2. + (P(1,3)*P(2,1)*P(4,5)*Metric(3,5))/2. + (P(1,2)*P(2,3)*P(4,5)*Metric(3,5))/2. + P(-1,2)*P(-1,3)*P(4,1)*Metric(1,2)*Metric(3,5) - (P(-1,2)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5))/2. + P(-1,1)*P(-1,3)*P(4,2)*Metric(1,2)*Metric(3,5) - (P(-1,1)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5))/2. - (P(-1,1)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5))/2. - (P(-1,2)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5))/2. - P(-1,2)*P(-1,3)*P(2,1)*Metric(1,4)*Metric(3,5) + (P(-1,2)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5))/2. + P(-1,1)*P(-1,2)*P(2,3)*Metric(1,4)*Metric(3,5) - (P(-1,2)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,3)*P(2,4)*Metric(1,4)*Metric(3,5))/2. + (P(-1,2)*P(-1,3)*P(2,4)*Metric(1,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,2)*P(2,5)*Metric(1,4)*Metric(3,5))/2. + (P(-1,1)*P(-1,3)*P(2,5)*Metric(1,4)*Metric(3,5))/2. - P(-1,1)*P(-1,3)*P(1,2)*Metric(2,4)*Metric(3,5) + (P(-1,1)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5))/2. + P(-1,1)*P(-1,2)*P(1,3)*Metric(2,4)*Metric(3,5) - (P(-1,1)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5))/2. + (P(-1,1)*P(-1,3)*P(1,4)*Metric(2,4)*Metric(3,5))/2. - (P(-1,2)*P(-1,3)*P(1,4)*Metric(2,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,2)*P(1,5)*Metric(2,4)*Metric(3,5))/2. + (P(-1,2)*P(-1,3)*P(1,5)*Metric(2,4)*Metric(3,5))/2. + (P(1,4)*P(2,3)*P(3,1)*Metric(4,5))/2. - (P(1,5)*P(2,3)*P(3,1)*Metric(4,5))/2. + (P(1,2)*P(2,4)*P(3,1)*Metric(4,5))/2. - (P(1,2)*P(2,5)*P(3,1)*Metric(4,5))/2. + (P(1,4)*P(2,1)*P(3,2)*Metric(4,5))/2. - (P(1,5)*P(2,1)*P(3,2)*Metric(4,5))/2. + (P(1,3)*P(2,4)*P(3,2)*Metric(4,5))/2. - (P(1,3)*P(2,5)*P(3,2)*Metric(4,5))/2. + (P(1,3)*P(2,1)*P(3,4)*Metric(4,5))/2. + (P(1,2)*P(2,3)*P(3,4)*Metric(4,5))/2. - (P(1,3)*P(2,1)*P(3,5)*Metric(4,5))/2. - (P(1,2)*P(2,3)*P(3,5)*Metric(4,5))/2. - (P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5))/2. + (P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5))/2. + (P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5))/2. - (P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5))/2. - (P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5))/2. + (P(-1,3)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5))/2. + (P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5))/2. - (P(-1,3)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5))/2. - (P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5))/2. - (P(-1,2)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5))/2. + (P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5))/2. + (P(-1,2)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5))/2. + (P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5))/2. - (P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5))/2. - (P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5))/2. + (P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3)*Metric(4,5))/2. + (P(-1,2)*P(-1,4)*P(2,3)*Metric(1,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5))/2. - (P(-1,2)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3)*Metric(4,5))/2. - (P(-1,2)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3)*Metric(4,5))/2. + (P(-1,2)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5))/2. - (P(-1,3)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5))/2. + (P(-1,3)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3)*Metric(4,5))/2. - (P(-1,2)*P(-1,4)*P(1,3)*Metric(2,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5))/2. + (P(-1,2)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5))/2.')

VVVVV22 = Lorentz(name = 'VVVVV22',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,5)*P(4,2)*P(5,1)*Metric(1,2) - P(3,5)*P(4,3)*P(5,1)*Metric(1,2) - P(3,2)*P(4,5)*P(5,1)*Metric(1,2) + P(3,4)*P(4,5)*P(5,1)*Metric(1,2) + P(3,5)*P(4,1)*P(5,2)*Metric(1,2) - P(3,5)*P(4,3)*P(5,2)*Metric(1,2) - P(3,1)*P(4,5)*P(5,2)*Metric(1,2) + P(3,4)*P(4,5)*P(5,2)*Metric(1,2) + 2*P(2,5)*P(4,2)*P(5,1)*Metric(1,3) - P(2,5)*P(4,3)*P(5,1)*Metric(1,3) + P(2,3)*P(4,5)*P(5,1)*Metric(1,3) - P(2,4)*P(4,5)*P(5,1)*Metric(1,3) + P(2,1)*P(4,5)*P(5,2)*Metric(1,3) - P(2,3)*P(4,5)*P(5,2)*Metric(1,3) - P(2,5)*P(4,2)*P(5,3)*Metric(1,3) - 2*P(2,5)*P(3,2)*P(5,1)*Metric(1,4) + P(2,5)*P(3,4)*P(5,1)*Metric(1,4) + P(2,3)*P(3,5)*P(5,1)*Metric(1,4) - P(2,4)*P(3,5)*P(5,1)*Metric(1,4) - P(2,1)*P(3,5)*P(5,2)*Metric(1,4) + P(2,4)*P(3,5)*P(5,2)*Metric(1,4) + P(2,5)*P(3,2)*P(5,4)*Metric(1,4) + 2*P(2,5)*P(3,2)*P(4,1)*Metric(1,5) - P(2,5)*P(3,4)*P(4,1)*Metric(1,5) - P(2,3)*P(3,5)*P(4,1)*Metric(1,5) + P(2,4)*P(3,5)*P(4,1)*Metric(1,5) - 2*P(2,5)*P(3,1)*P(4,2)*Metric(1,5) + P(2,5)*P(3,4)*P(4,2)*Metric(1,5) - P(2,1)*P(3,5)*P(4,2)*Metric(1,5) + P(2,5)*P(3,1)*P(4,3)*Metric(1,5) - P(2,5)*P(3,2)*P(4,3)*Metric(1,5) + P(2,1)*P(3,5)*P(4,3)*Metric(1,5) - P(2,3)*P(3,1)*P(4,5)*Metric(1,5) + P(2,4)*P(3,1)*P(4,5)*Metric(1,5) + P(2,1)*P(3,2)*P(4,5)*Metric(1,5) - P(2,1)*P(3,4)*P(4,5)*Metric(1,5) + P(1,2)*P(4,5)*P(5,1)*Metric(2,3) - P(1,3)*P(4,5)*P(5,1)*Metric(2,3) + 2*P(1,5)*P(4,1)*P(5,2)*Metric(2,3) - P(1,5)*P(4,3)*P(5,2)*Metric(2,3) + P(1,3)*P(4,5)*P(5,2)*Metric(2,3) - P(1,4)*P(4,5)*P(5,2)*Metric(2,3) - P(1,5)*P(4,1)*P(5,3)*Metric(2,3) + 2*P(-1,2)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) - 2*P(-1,1)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) - 2*P(-1,2)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,3)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,2)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) - P(1,2)*P(3,5)*P(5,1)*Metric(2,4) + P(1,4)*P(3,5)*P(5,1)*Metric(2,4) - 2*P(1,5)*P(3,1)*P(5,2)*Metric(2,4) + P(1,5)*P(3,4)*P(5,2)*Metric(2,4) + P(1,3)*P(3,5)*P(5,2)*Metric(2,4) - P(1,4)*P(3,5)*P(5,2)*Metric(2,4) + P(1,5)*P(3,1)*P(5,4)*Metric(2,4) - 2*P(-1,2)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) + 2*P(-1,1)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) + 2*P(-1,2)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - 2*P(1,5)*P(3,2)*P(4,1)*Metric(2,5) + P(1,5)*P(3,4)*P(4,1)*Metric(2,5) - P(1,2)*P(3,5)*P(4,1)*Metric(2,5) + 2*P(1,5)*P(3,1)*P(4,2)*Metric(2,5) - P(1,5)*P(3,4)*P(4,2)*Metric(2,5) - P(1,3)*P(3,5)*P(4,2)*Metric(2,5) + P(1,4)*P(3,5)*P(4,2)*Metric(2,5) - P(1,5)*P(3,1)*P(4,3)*Metric(2,5) + P(1,5)*P(3,2)*P(4,3)*Metric(2,5) + P(1,2)*P(3,5)*P(4,3)*Metric(2,5) + P(1,2)*P(3,1)*P(4,5)*Metric(2,5) - P(1,3)*P(3,2)*P(4,5)*Metric(2,5) + P(1,4)*P(3,2)*P(4,5)*Metric(2,5) - P(1,2)*P(3,4)*P(4,5)*Metric(2,5) - 2*P(-1,1)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,3)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,2)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) + 2*P(-1,1)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,2)*P(3,5)*Metric(1,4)*Metric(2,5) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,3)*P(2,5)*P(5,1)*Metric(3,4) - P(1,4)*P(2,5)*P(5,1)*Metric(3,4) + P(1,5)*P(2,3)*P(5,2)*Metric(3,4) - P(1,5)*P(2,4)*P(5,2)*Metric(3,4) + P(1,5)*P(2,1)*P(5,3)*Metric(3,4) + P(1,2)*P(2,5)*P(5,3)*Metric(3,4) - P(1,5)*P(2,1)*P(5,4)*Metric(3,4) - P(1,2)*P(2,5)*P(5,4)*Metric(3,4) + P(-1,3)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,2)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,3)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) - P(-1,2)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) - P(-1,3)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,3)*P(1,5)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + P(1,5)*P(2,3)*P(4,1)*Metric(3,5) - P(1,5)*P(2,4)*P(4,1)*Metric(3,5) + P(1,2)*P(2,5)*P(4,1)*Metric(3,5) + P(1,5)*P(2,1)*P(4,2)*Metric(3,5) + P(1,3)*P(2,5)*P(4,2)*Metric(3,5) - P(1,4)*P(2,5)*P(4,2)*Metric(3,5) - P(1,5)*P(2,1)*P(4,3)*Metric(3,5) - P(1,2)*P(2,5)*P(4,3)*Metric(3,5) - P(-1,2)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - P(-1,2)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(2,5)*Metric(1,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) + P(1,5)*P(2,3)*P(3,1)*Metric(4,5) - P(1,5)*P(2,4)*P(3,1)*Metric(4,5) - P(1,2)*P(2,5)*P(3,1)*Metric(4,5) - P(1,5)*P(2,1)*P(3,2)*Metric(4,5) + P(1,3)*P(2,5)*P(3,2)*Metric(4,5) - P(1,4)*P(2,5)*P(3,2)*Metric(4,5) + P(1,5)*P(2,1)*P(3,4)*Metric(4,5) + P(1,2)*P(2,5)*P(3,4)*Metric(4,5) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,2)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV23 = Lorentz(name = 'VVVVV23',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,4)*P(4,5)*P(5,1)*Metric(1,2) - P(3,4)*P(4,5)*P(5,2)*Metric(1,2) + P(3,5)*P(4,1)*P(5,4)*Metric(1,2) - P(3,5)*P(4,2)*P(5,4)*Metric(1,2) - P(2,4)*P(4,5)*P(5,1)*Metric(1,3) + P(2,4)*P(4,5)*P(5,3)*Metric(1,3) - P(2,5)*P(4,1)*P(5,4)*Metric(1,3) + P(2,5)*P(4,3)*P(5,4)*Metric(1,3) + P(2,5)*P(3,1)*P(5,4)*Metric(1,4) - P(2,5)*P(3,2)*P(5,4)*Metric(1,4) - P(2,1)*P(3,5)*P(5,4)*Metric(1,4) + P(2,3)*P(3,5)*P(5,4)*Metric(1,4) + P(2,4)*P(3,1)*P(4,5)*Metric(1,5) - P(2,4)*P(3,2)*P(4,5)*Metric(1,5) - P(2,1)*P(3,4)*P(4,5)*Metric(1,5) + P(2,3)*P(3,4)*P(4,5)*Metric(1,5) + P(1,4)*P(4,5)*P(5,2)*Metric(2,3) - P(1,4)*P(4,5)*P(5,3)*Metric(2,3) + P(1,5)*P(4,2)*P(5,4)*Metric(2,3) - P(1,5)*P(4,3)*P(5,4)*Metric(2,3) - P(-1,4)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,4)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) - P(-1,3)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) - P(-1,4)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,4)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) + P(-1,2)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) + P(1,5)*P(3,1)*P(5,4)*Metric(2,4) - P(1,5)*P(3,2)*P(5,4)*Metric(2,4) + P(1,2)*P(3,5)*P(5,4)*Metric(2,4) - P(1,3)*P(3,5)*P(5,4)*Metric(2,4) + P(-1,4)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) - P(-1,4)*P(-1,5)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) + P(-1,4)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) + P(1,4)*P(3,1)*P(4,5)*Metric(2,5) - P(1,4)*P(3,2)*P(4,5)*Metric(2,5) + P(1,2)*P(3,4)*P(4,5)*Metric(2,5) - P(1,3)*P(3,4)*P(4,5)*Metric(2,5) + P(-1,4)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,4)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,3)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,4)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) - P(1,5)*P(2,1)*P(5,4)*Metric(3,4) + P(1,5)*P(2,3)*P(5,4)*Metric(3,4) + P(1,2)*P(2,5)*P(5,4)*Metric(3,4) - P(1,3)*P(2,5)*P(5,4)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,4)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,4)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,4)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*P(2,1)*P(4,5)*Metric(3,5) + P(1,4)*P(2,3)*P(4,5)*Metric(3,5) + P(1,2)*P(2,4)*P(4,5)*Metric(3,5) - P(1,3)*P(2,4)*P(4,5)*Metric(3,5) - P(-1,4)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,4)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,4)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) - P(-1,4)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(1,3)*Metric(2,4)*Metric(3,5) - P(1,5)*P(2,4)*P(3,1)*Metric(4,5) - P(1,4)*P(2,5)*P(3,1)*Metric(4,5) + P(1,5)*P(2,4)*P(3,2)*Metric(4,5) + P(1,4)*P(2,5)*P(3,2)*Metric(4,5) + P(1,5)*P(2,1)*P(3,4)*Metric(4,5) - P(1,5)*P(2,3)*P(3,4)*Metric(4,5) - P(1,2)*P(2,5)*P(3,4)*Metric(4,5) + P(1,3)*P(2,5)*P(3,4)*Metric(4,5) + P(1,4)*P(2,1)*P(3,5)*Metric(4,5) - P(1,4)*P(2,3)*P(3,5)*Metric(4,5) - P(1,2)*P(2,4)*P(3,5)*Metric(4,5) + P(1,3)*P(2,4)*P(3,5)*Metric(4,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,3)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5) + P(-1,3)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV24 = Lorentz(name = 'VVVVV24',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,5)*P(4,3)*P(5,1)*Metric(1,2) + P(3,4)*P(4,5)*P(5,1)*Metric(1,2) - P(3,5)*P(4,3)*P(5,2)*Metric(1,2) - P(3,4)*P(4,5)*P(5,2)*Metric(1,2) + P(3,4)*P(4,1)*P(5,3)*Metric(1,2) - P(3,4)*P(4,2)*P(5,3)*Metric(1,2) + P(3,1)*P(4,5)*P(5,3)*Metric(1,2) - P(3,2)*P(4,5)*P(5,3)*Metric(1,2) + P(3,5)*P(4,1)*P(5,4)*Metric(1,2) - P(3,5)*P(4,2)*P(5,4)*Metric(1,2) + P(3,1)*P(4,3)*P(5,4)*Metric(1,2) - P(3,2)*P(4,3)*P(5,4)*Metric(1,2) + P(2,4)*P(4,3)*P(5,1)*Metric(1,3) - P(2,4)*P(4,5)*P(5,1)*Metric(1,3) - P(2,4)*P(4,3)*P(5,2)*Metric(1,3) + P(2,5)*P(4,1)*P(5,3)*Metric(1,3) - P(2,5)*P(4,2)*P(5,3)*Metric(1,3) - P(2,1)*P(4,5)*P(5,3)*Metric(1,3) + 2*P(2,4)*P(4,5)*P(5,3)*Metric(1,3) - P(2,5)*P(4,1)*P(5,4)*Metric(1,3) - P(2,1)*P(4,3)*P(5,4)*Metric(1,3) + 2*P(2,5)*P(4,3)*P(5,4)*Metric(1,3) + P(2,3)*P(3,4)*P(5,1)*Metric(1,4) - P(2,3)*P(3,5)*P(5,1)*Metric(1,4) - P(2,3)*P(3,4)*P(5,2)*Metric(1,4) - P(2,5)*P(3,1)*P(5,3)*Metric(1,4) - P(2,1)*P(3,4)*P(5,3)*Metric(1,4) + 2*P(2,5)*P(3,4)*P(5,3)*Metric(1,4) + P(2,5)*P(3,1)*P(5,4)*Metric(1,4) - P(2,5)*P(3,2)*P(5,4)*Metric(1,4) - P(2,1)*P(3,5)*P(5,4)*Metric(1,4) + 2*P(2,3)*P(3,5)*P(5,4)*Metric(1,4) - P(2,3)*P(3,4)*P(4,1)*Metric(1,5) + P(2,3)*P(3,5)*P(4,1)*Metric(1,5) - P(2,3)*P(3,5)*P(4,2)*Metric(1,5) - P(2,4)*P(3,1)*P(4,3)*Metric(1,5) - P(2,1)*P(3,5)*P(4,3)*Metric(1,5) + 2*P(2,4)*P(3,5)*P(4,3)*Metric(1,5) + P(2,4)*P(3,1)*P(4,5)*Metric(1,5) - P(2,4)*P(3,2)*P(4,5)*Metric(1,5) - P(2,1)*P(3,4)*P(4,5)*Metric(1,5) + 2*P(2,3)*P(3,4)*P(4,5)*Metric(1,5) + P(1,4)*P(4,3)*P(5,1)*Metric(2,3) - P(1,4)*P(4,3)*P(5,2)*Metric(2,3) + P(1,4)*P(4,5)*P(5,2)*Metric(2,3) + P(1,5)*P(4,1)*P(5,3)*Metric(2,3) - P(1,5)*P(4,2)*P(5,3)*Metric(2,3) + P(1,2)*P(4,5)*P(5,3)*Metric(2,3) - 2*P(1,4)*P(4,5)*P(5,3)*Metric(2,3) + P(1,5)*P(4,2)*P(5,4)*Metric(2,3) + P(1,2)*P(4,3)*P(5,4)*Metric(2,3) - 2*P(1,5)*P(4,3)*P(5,4)*Metric(2,3) - P(-1,3)*P(-1,4)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,5)*P(5,1)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,4)*P(-1,5)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) + 2*P(-1,4)*P(-1,5)*P(5,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) - 2*P(-1,3)*P(-1,5)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*P(4,1)*Metric(1,5)*Metric(2,3) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,3)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) - P(-1,4)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) - P(-1,1)*P(-1,4)*P(4,3)*Metric(1,5)*Metric(2,3) + 2*P(-1,4)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) + P(-1,2)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) - 2*P(-1,3)*P(-1,4)*P(4,5)*Metric(1,5)*Metric(2,3) + P(1,3)*P(3,4)*P(5,1)*Metric(2,4) - P(1,3)*P(3,4)*P(5,2)*Metric(2,4) + P(1,3)*P(3,5)*P(5,2)*Metric(2,4) + P(1,5)*P(3,2)*P(5,3)*Metric(2,4) + P(1,2)*P(3,4)*P(5,3)*Metric(2,4) - 2*P(1,5)*P(3,4)*P(5,3)*Metric(2,4) + P(1,5)*P(3,1)*P(5,4)*Metric(2,4) - P(1,5)*P(3,2)*P(5,4)*Metric(2,4) + P(1,2)*P(3,5)*P(5,4)*Metric(2,4) - 2*P(1,3)*P(3,5)*P(5,4)*Metric(2,4) - P(-1,3)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,4)*P(-1,5)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*P(5,2)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,5)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*P(5,3)*Metric(1,3)*Metric(2,4) - 2*P(-1,4)*P(-1,5)*P(5,3)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) + 2*P(-1,3)*P(-1,5)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,3)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,4)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,3)*P(3,4)*Metric(1,5)*Metric(2,4) + 2*P(-1,3)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) + P(-1,2)*P(-1,3)*P(3,5)*Metric(1,5)*Metric(2,4) - 2*P(-1,3)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) + P(1,3)*P(3,5)*P(4,1)*Metric(2,5) + P(1,3)*P(3,4)*P(4,2)*Metric(2,5) - P(1,3)*P(3,5)*P(4,2)*Metric(2,5) + P(1,4)*P(3,2)*P(4,3)*Metric(2,5) + P(1,2)*P(3,5)*P(4,3)*Metric(2,5) - 2*P(1,4)*P(3,5)*P(4,3)*Metric(2,5) + P(1,4)*P(3,1)*P(4,5)*Metric(2,5) - P(1,4)*P(3,2)*P(4,5)*Metric(2,5) + P(1,2)*P(3,4)*P(4,5)*Metric(2,5) - 2*P(1,3)*P(3,4)*P(4,5)*Metric(2,5) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) + P(-1,4)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,3)*P(-1,4)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,3)*P(-1,5)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,4)*P(4,3)*Metric(1,3)*Metric(2,5) - 2*P(-1,4)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) + 2*P(-1,3)*P(-1,4)*P(4,5)*Metric(1,3)*Metric(2,5) + P(-1,3)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,4)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,3)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,4)*P(-1,5)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,2)*P(-1,3)*P(3,4)*Metric(1,4)*Metric(2,5) - 2*P(-1,3)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) - P(-1,1)*P(-1,3)*P(3,5)*Metric(1,4)*Metric(2,5) + 2*P(-1,3)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) - P(1,4)*P(2,3)*P(5,1)*Metric(3,4) - P(1,3)*P(2,4)*P(5,1)*Metric(3,4) + P(1,4)*P(2,3)*P(5,2)*Metric(3,4) + P(1,3)*P(2,4)*P(5,2)*Metric(3,4) + P(1,4)*P(2,1)*P(5,3)*Metric(3,4) - P(1,5)*P(2,1)*P(5,3)*Metric(3,4) - P(1,2)*P(2,4)*P(5,3)*Metric(3,4) + 2*P(1,5)*P(2,4)*P(5,3)*Metric(3,4) + P(1,2)*P(2,5)*P(5,3)*Metric(3,4) - 2*P(1,4)*P(2,5)*P(5,3)*Metric(3,4) + P(1,3)*P(2,1)*P(5,4)*Metric(3,4) - P(1,5)*P(2,1)*P(5,4)*Metric(3,4) - P(1,2)*P(2,3)*P(5,4)*Metric(3,4) + 2*P(1,5)*P(2,3)*P(5,4)*Metric(3,4) + P(1,2)*P(2,5)*P(5,4)*Metric(3,4) - 2*P(1,3)*P(2,5)*P(5,4)*Metric(3,4) - P(-1,3)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,4)*P(-1,5)*P(5,2)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,4)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*P(5,3)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,5)*Metric(3,4) - 2*P(-1,4)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,1)*P(-1,3)*P(2,4)*Metric(1,5)*Metric(3,4) - 2*P(-1,3)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) - P(-1,3)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,4)*P(-1,5)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,4)*P(1,3)*Metric(2,5)*Metric(3,4) + 2*P(-1,4)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,3)*P(1,4)*Metric(2,5)*Metric(3,4) + 2*P(-1,3)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) - P(1,5)*P(2,3)*P(4,1)*Metric(3,5) - P(1,3)*P(2,5)*P(4,1)*Metric(3,5) + P(1,5)*P(2,3)*P(4,2)*Metric(3,5) + P(1,3)*P(2,5)*P(4,2)*Metric(3,5) - P(1,4)*P(2,1)*P(4,3)*Metric(3,5) + P(1,5)*P(2,1)*P(4,3)*Metric(3,5) + P(1,2)*P(2,4)*P(4,3)*Metric(3,5) - 2*P(1,5)*P(2,4)*P(4,3)*Metric(3,5) - P(1,2)*P(2,5)*P(4,3)*Metric(3,5) + 2*P(1,4)*P(2,5)*P(4,3)*Metric(3,5) + P(1,3)*P(2,1)*P(4,5)*Metric(3,5) - P(1,4)*P(2,1)*P(4,5)*Metric(3,5) - P(1,2)*P(2,3)*P(4,5)*Metric(3,5) + 2*P(1,4)*P(2,3)*P(4,5)*Metric(3,5) + P(1,2)*P(2,4)*P(4,5)*Metric(3,5) - 2*P(1,3)*P(2,4)*P(4,5)*Metric(3,5) - P(-1,3)*P(-1,4)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,4)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,4)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,4)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,4)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,4)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,5)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,2)*P(-1,3)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) - P(-1,2)*P(-1,4)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,4)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) - 2*P(-1,4)*P(-1,5)*P(2,3)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,3)*P(2,5)*Metric(1,4)*Metric(3,5) - 2*P(-1,3)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,4)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,4)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,4)*Metric(3,5) + 2*P(-1,4)*P(-1,5)*P(1,3)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,3)*P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(-1,3)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) - P(1,5)*P(2,4)*P(3,1)*Metric(4,5) - P(1,4)*P(2,5)*P(3,1)*Metric(4,5) + P(1,5)*P(2,4)*P(3,2)*Metric(4,5) + P(1,4)*P(2,5)*P(3,2)*Metric(4,5) - P(1,3)*P(2,1)*P(3,4)*Metric(4,5) + P(1,5)*P(2,1)*P(3,4)*Metric(4,5) + P(1,2)*P(2,3)*P(3,4)*Metric(4,5) - 2*P(1,5)*P(2,3)*P(3,4)*Metric(4,5) - P(1,2)*P(2,5)*P(3,4)*Metric(4,5) + 2*P(1,3)*P(2,5)*P(3,4)*Metric(4,5) - P(1,3)*P(2,1)*P(3,5)*Metric(4,5) + P(1,4)*P(2,1)*P(3,5)*Metric(4,5) + P(1,2)*P(2,3)*P(3,5)*Metric(4,5) - 2*P(1,4)*P(2,3)*P(3,5)*Metric(4,5) - P(1,2)*P(2,4)*P(3,5)*Metric(4,5) + 2*P(1,3)*P(2,4)*P(3,5)*Metric(4,5) - P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2)*Metric(4,5) - P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,4)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,3)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,5)*P(3,4)*Metric(1,2)*Metric(4,5) + P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,2)*P(-1,3)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) + P(-1,2)*P(-1,4)*P(3,5)*Metric(1,2)*Metric(4,5) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) - 2*P(-1,3)*P(-1,5)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(-1,3)*P(-1,4)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,3)*P(-1,4)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(-1,3)*P(-1,5)*P(1,4)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5) + 2*P(-1,3)*P(-1,4)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVV30 = Lorentz(name = 'VVVVVV30',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,2)*Metric(1,2)*Metric(3,4) - P(2,1)*P(6,2)*Metric(1,5)*Metric(3,4) - P(2,1)*P(5,2)*Metric(1,6)*Metric(3,4) - P(1,2)*P(6,1)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(1,2)*P(5,1)*Metric(2,6)*Metric(3,4) + P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,6)*Metric(3,4) - (P(4,2)*P(6,1)*Metric(1,2)*Metric(3,5))/2. - (P(4,1)*P(6,2)*Metric(1,2)*Metric(3,5))/2. + (P(2,1)*P(6,2)*Metric(1,4)*Metric(3,5))/2. + (P(2,1)*P(4,2)*Metric(1,6)*Metric(3,5))/2. + (P(1,2)*P(6,1)*Metric(2,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(1,2)*P(4,1)*Metric(2,6)*Metric(3,5))/2. - (P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(4,2)*P(5,1)*Metric(1,2)*Metric(3,6))/2. - (P(4,1)*P(5,2)*Metric(1,2)*Metric(3,6))/2. + (P(2,1)*P(5,2)*Metric(1,4)*Metric(3,6))/2. + (P(2,1)*P(4,2)*Metric(1,5)*Metric(3,6))/2. + (P(1,2)*P(5,1)*Metric(2,4)*Metric(3,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(1,2)*P(4,1)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(3,2)*P(6,1)*Metric(1,2)*Metric(4,5))/2. - (P(3,1)*P(6,2)*Metric(1,2)*Metric(4,5))/2. + (P(2,1)*P(6,2)*Metric(1,3)*Metric(4,5))/2. + (P(2,1)*P(3,2)*Metric(1,6)*Metric(4,5))/2. + (P(1,2)*P(6,1)*Metric(2,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(1,2)*P(3,1)*Metric(2,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(3,2)*P(5,1)*Metric(1,2)*Metric(4,6))/2. - (P(3,1)*P(5,2)*Metric(1,2)*Metric(4,6))/2. + (P(2,1)*P(5,2)*Metric(1,3)*Metric(4,6))/2. + (P(2,1)*P(3,2)*Metric(1,5)*Metric(4,6))/2. + (P(1,2)*P(5,1)*Metric(2,3)*Metric(4,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(1,2)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(3,2)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,1)*P(4,2)*Metric(1,2)*Metric(5,6) - P(2,1)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,1)*P(3,2)*Metric(1,4)*Metric(5,6) - P(1,2)*P(4,1)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(1,2)*P(3,1)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)*Metric(5,6)')

VVVVVV31 = Lorentz(name = 'VVVVVV31',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(4,6)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,5)*P(5,6)*Metric(1,6)*Metric(2,3) + P(3,6)*P(6,5)*Metric(1,5)*Metric(2,4) + P(3,5)*P(5,6)*Metric(1,6)*Metric(2,4) + P(4,6)*P(6,5)*Metric(1,3)*Metric(2,5) + P(3,6)*P(6,5)*Metric(1,4)*Metric(2,5) + P(4,5)*P(5,6)*Metric(1,3)*Metric(2,6) + P(3,5)*P(5,6)*Metric(1,4)*Metric(2,6) - 2*P(2,6)*P(6,5)*Metric(1,5)*Metric(3,4) - 2*P(2,5)*P(5,6)*Metric(1,6)*Metric(3,4) - 2*P(1,6)*P(6,5)*Metric(2,5)*Metric(3,4) + 2*P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(1,5)*P(5,6)*Metric(2,6)*Metric(3,4) + 2*P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(4,6)*P(6,5)*Metric(1,2)*Metric(3,5) + P(2,6)*P(6,5)*Metric(1,4)*Metric(3,5) + P(1,6)*P(6,5)*Metric(2,4)*Metric(3,5) - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - 2*P(4,5)*P(5,6)*Metric(1,2)*Metric(3,6) + P(2,5)*P(5,6)*Metric(1,4)*Metric(3,6) + P(1,5)*P(5,6)*Metric(2,4)*Metric(3,6) - P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 2*P(3,6)*P(6,5)*Metric(1,2)*Metric(4,5) + P(2,6)*P(6,5)*Metric(1,3)*Metric(4,5) + P(1,6)*P(6,5)*Metric(2,3)*Metric(4,5) - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(3,5)*P(5,6)*Metric(1,2)*Metric(4,6) + P(2,5)*P(5,6)*Metric(1,3)*Metric(4,6) + P(1,5)*P(5,6)*Metric(2,3)*Metric(4,6) - P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(3,6)*P(4,5)*Metric(1,2)*Metric(5,6) + 2*P(3,5)*P(4,6)*Metric(1,2)*Metric(5,6) - P(2,6)*P(4,5)*Metric(1,3)*Metric(5,6) - P(2,5)*P(4,6)*Metric(1,3)*Metric(5,6) - P(2,6)*P(3,5)*Metric(1,4)*Metric(5,6) - P(2,5)*P(3,6)*Metric(1,4)*Metric(5,6) - P(1,6)*P(4,5)*Metric(2,3)*Metric(5,6) - P(1,5)*P(4,6)*Metric(2,3)*Metric(5,6) - P(1,6)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,5)*P(3,6)*Metric(2,4)*Metric(5,6) + 2*P(1,6)*P(2,5)*Metric(3,4)*Metric(5,6) + 2*P(1,5)*P(2,6)*Metric(3,4)*Metric(5,6)')

VVVVVV32 = Lorentz(name = 'VVVVVV32',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,3)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,3)*Metric(1,4)*Metric(2,3) + P(4,3)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,2)*P(6,3)*Metric(1,5)*Metric(2,3) - 2*P(4,3)*P(5,2)*Metric(1,6)*Metric(2,3) - 2*P(4,2)*P(5,3)*Metric(1,6)*Metric(2,3) + P(5,3)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,3)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,3)*Metric(1,5)*Metric(2,4) - P(3,2)*P(6,3)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,3)*Metric(1,6)*Metric(2,4) + 2*P(3,2)*P(5,3)*Metric(1,6)*Metric(2,4) + P(4,3)*P(6,1)*Metric(1,3)*Metric(2,5) + P(4,1)*P(6,3)*Metric(1,3)*Metric(2,5) - P(3,1)*P(6,3)*Metric(1,4)*Metric(2,5) - P(3,2)*P(6,3)*Metric(1,4)*Metric(2,5) - P(3,1)*P(4,3)*Metric(1,6)*Metric(2,5) + 2*P(3,2)*P(4,3)*Metric(1,6)*Metric(2,5) - 2*P(4,3)*P(5,1)*Metric(1,3)*Metric(2,6) - 2*P(4,1)*P(5,3)*Metric(1,3)*Metric(2,6) + 2*P(3,1)*P(5,3)*Metric(1,4)*Metric(2,6) - P(3,2)*P(5,3)*Metric(1,4)*Metric(2,6) + 2*P(3,1)*P(4,3)*Metric(1,5)*Metric(2,6) - P(3,2)*P(4,3)*Metric(1,5)*Metric(2,6) + P(5,2)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,2)*Metric(1,2)*Metric(3,4) - P(2,1)*P(6,2)*Metric(1,5)*Metric(3,4) - P(2,3)*P(6,2)*Metric(1,5)*Metric(3,4) - P(2,1)*P(5,2)*Metric(1,6)*Metric(3,4) + 2*P(2,3)*P(5,2)*Metric(1,6)*Metric(3,4) - P(1,2)*P(6,1)*Metric(2,5)*Metric(3,4) - P(1,3)*P(6,1)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(1,2)*P(5,1)*Metric(2,6)*Metric(3,4) + 2*P(1,3)*P(5,1)*Metric(2,6)*Metric(3,4) + P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(4,2)*P(6,1)*Metric(1,2)*Metric(3,5) + P(4,1)*P(6,2)*Metric(1,2)*Metric(3,5) - P(2,1)*P(6,2)*Metric(1,4)*Metric(3,5) - P(2,3)*P(6,2)*Metric(1,4)*Metric(3,5) - P(2,1)*P(4,2)*Metric(1,6)*Metric(3,5) + 2*P(2,3)*P(4,2)*Metric(1,6)*Metric(3,5) - P(1,2)*P(6,1)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,1)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(1,2)*P(4,1)*Metric(2,6)*Metric(3,5) + 2*P(1,3)*P(4,1)*Metric(2,6)*Metric(3,5) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,6)*Metric(3,5) - 2*P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) - 2*P(4,2)*P(5,1)*Metric(1,2)*Metric(3,6) - 2*P(4,1)*P(5,2)*Metric(1,2)*Metric(3,6) + 2*P(2,1)*P(5,2)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,2)*Metric(1,4)*Metric(3,6) + 2*P(2,1)*P(4,2)*Metric(1,5)*Metric(3,6) - P(2,3)*P(4,2)*Metric(1,5)*Metric(3,6) + 2*P(1,2)*P(5,1)*Metric(2,4)*Metric(3,6) - P(1,3)*P(5,1)*Metric(2,4)*Metric(3,6) - 2*P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6) + 2*P(1,2)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,3)*P(4,1)*Metric(2,5)*Metric(3,6) - 2*P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 2*P(3,2)*P(6,1)*Metric(1,2)*Metric(4,5) - 2*P(3,1)*P(6,2)*Metric(1,2)*Metric(4,5) + 2*P(3,1)*P(6,3)*Metric(1,2)*Metric(4,5) + 2*P(3,2)*P(6,3)*Metric(1,2)*Metric(4,5) - 2*P(2,3)*P(6,1)*Metric(1,3)*Metric(4,5) + 2*P(2,1)*P(6,2)*Metric(1,3)*Metric(4,5) + 2*P(2,3)*P(6,2)*Metric(1,3)*Metric(4,5) - 2*P(2,1)*P(6,3)*Metric(1,3)*Metric(4,5) + 2*P(2,3)*P(3,1)*Metric(1,6)*Metric(4,5) + 2*P(2,1)*P(3,2)*Metric(1,6)*Metric(4,5) + 2*P(1,2)*P(6,1)*Metric(2,3)*Metric(4,5) + 2*P(1,3)*P(6,1)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*P(6,2)*Metric(2,3)*Metric(4,5) - 2*P(1,2)*P(6,3)*Metric(2,3)*Metric(4,5) - 2*P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(1,2)*P(3,1)*Metric(2,6)*Metric(4,5) + 2*P(1,3)*P(3,2)*Metric(2,6)*Metric(4,5) - 2*P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,6)*Metric(4,5) - 2*P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(1,3)*P(2,1)*Metric(3,6)*Metric(4,5) + 2*P(1,2)*P(2,3)*Metric(3,6)*Metric(4,5) - 2*P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(3,2)*P(5,1)*Metric(1,2)*Metric(4,6) + P(3,1)*P(5,2)*Metric(1,2)*Metric(4,6) - P(3,1)*P(5,3)*Metric(1,2)*Metric(4,6) - P(3,2)*P(5,3)*Metric(1,2)*Metric(4,6) + P(2,3)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,1)*P(5,2)*Metric(1,3)*Metric(4,6) - P(2,3)*P(5,2)*Metric(1,3)*Metric(4,6) + P(2,1)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,3)*P(3,1)*Metric(1,5)*Metric(4,6) - P(2,1)*P(3,2)*Metric(1,5)*Metric(4,6) - P(1,2)*P(5,1)*Metric(2,3)*Metric(4,6) - P(1,3)*P(5,1)*Metric(2,3)*Metric(4,6) + P(1,3)*P(5,2)*Metric(2,3)*Metric(4,6) + P(1,2)*P(5,3)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(1,2)*P(3,1)*Metric(2,5)*Metric(4,6) - P(1,3)*P(3,2)*Metric(2,5)*Metric(4,6) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(1,3)*P(2,1)*Metric(3,5)*Metric(4,6) - P(1,2)*P(2,3)*Metric(3,5)*Metric(4,6) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(3,2)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,1)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,1)*P(4,3)*Metric(1,2)*Metric(5,6) - P(3,2)*P(4,3)*Metric(1,2)*Metric(5,6) + P(2,3)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,1)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,3)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,1)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,3)*P(3,1)*Metric(1,4)*Metric(5,6) - P(2,1)*P(3,2)*Metric(1,4)*Metric(5,6) - P(1,2)*P(4,1)*Metric(2,3)*Metric(5,6) - P(1,3)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,3)*P(4,2)*Metric(2,3)*Metric(5,6) + P(1,2)*P(4,3)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(1,2)*P(3,1)*Metric(2,4)*Metric(5,6) - P(1,3)*P(3,2)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(1,3)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,2)*P(2,3)*Metric(3,4)*Metric(5,6) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV33 = Lorentz(name = 'VVVVVV33',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,4)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,4)*Metric(1,4)*Metric(2,3) - (P(4,3)*P(6,2)*Metric(1,5)*Metric(2,3))/2. - (P(4,2)*P(6,3)*Metric(1,5)*Metric(2,3))/2. - P(4,1)*P(6,4)*Metric(1,5)*Metric(2,3) + (P(4,2)*P(6,4)*Metric(1,5)*Metric(2,3))/2. + (P(4,3)*P(6,4)*Metric(1,5)*Metric(2,3))/2. - (P(4,3)*P(5,2)*Metric(1,6)*Metric(2,3))/2. - (P(4,2)*P(5,3)*Metric(1,6)*Metric(2,3))/2. - P(4,1)*P(5,4)*Metric(1,6)*Metric(2,3) + (P(4,2)*P(5,4)*Metric(1,6)*Metric(2,3))/2. + (P(4,3)*P(5,4)*Metric(1,6)*Metric(2,3))/2. + P(5,3)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,2)*P(6,4)*Metric(1,3)*Metric(2,4) - (P(3,4)*P(6,2)*Metric(1,5)*Metric(2,4))/2. - P(3,1)*P(6,3)*Metric(1,5)*Metric(2,4) + (P(3,2)*P(6,3)*Metric(1,5)*Metric(2,4))/2. + (P(3,4)*P(6,3)*Metric(1,5)*Metric(2,4))/2. - (P(3,2)*P(6,4)*Metric(1,5)*Metric(2,4))/2. - (P(3,4)*P(5,2)*Metric(1,6)*Metric(2,4))/2. - P(3,1)*P(5,3)*Metric(1,6)*Metric(2,4) + (P(3,2)*P(5,3)*Metric(1,6)*Metric(2,4))/2. + (P(3,4)*P(5,3)*Metric(1,6)*Metric(2,4))/2. - (P(3,2)*P(5,4)*Metric(1,6)*Metric(2,4))/2. - (P(4,3)*P(6,1)*Metric(1,3)*Metric(2,5))/2. - (P(4,1)*P(6,3)*Metric(1,3)*Metric(2,5))/2. + (P(4,1)*P(6,4)*Metric(1,3)*Metric(2,5))/2. - P(4,2)*P(6,4)*Metric(1,3)*Metric(2,5) + (P(4,3)*P(6,4)*Metric(1,3)*Metric(2,5))/2. - (P(3,4)*P(6,1)*Metric(1,4)*Metric(2,5))/2. + (P(3,1)*P(6,3)*Metric(1,4)*Metric(2,5))/2. - P(3,2)*P(6,3)*Metric(1,4)*Metric(2,5) + (P(3,4)*P(6,3)*Metric(1,4)*Metric(2,5))/2. - (P(3,1)*P(6,4)*Metric(1,4)*Metric(2,5))/2. + (P(3,4)*P(4,1)*Metric(1,6)*Metric(2,5))/2. + (P(3,4)*P(4,2)*Metric(1,6)*Metric(2,5))/2. + (P(3,1)*P(4,3)*Metric(1,6)*Metric(2,5))/2. + (P(3,2)*P(4,3)*Metric(1,6)*Metric(2,5))/2. - (P(4,3)*P(5,1)*Metric(1,3)*Metric(2,6))/2. - (P(4,1)*P(5,3)*Metric(1,3)*Metric(2,6))/2. + (P(4,1)*P(5,4)*Metric(1,3)*Metric(2,6))/2. - P(4,2)*P(5,4)*Metric(1,3)*Metric(2,6) + (P(4,3)*P(5,4)*Metric(1,3)*Metric(2,6))/2. - (P(3,4)*P(5,1)*Metric(1,4)*Metric(2,6))/2. + (P(3,1)*P(5,3)*Metric(1,4)*Metric(2,6))/2. - P(3,2)*P(5,3)*Metric(1,4)*Metric(2,6) + (P(3,4)*P(5,3)*Metric(1,4)*Metric(2,6))/2. - (P(3,1)*P(5,4)*Metric(1,4)*Metric(2,6))/2. + (P(3,4)*P(4,1)*Metric(1,5)*Metric(2,6))/2. + (P(3,4)*P(4,2)*Metric(1,5)*Metric(2,6))/2. + (P(3,1)*P(4,3)*Metric(1,5)*Metric(2,6))/2. + (P(3,2)*P(4,3)*Metric(1,5)*Metric(2,6))/2. + P(5,2)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,2)*Metric(1,2)*Metric(3,4) + P(5,4)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,3)*P(6,4)*Metric(1,2)*Metric(3,4) - P(2,1)*P(6,2)*Metric(1,5)*Metric(3,4) + (P(2,3)*P(6,2)*Metric(1,5)*Metric(3,4))/2. + (P(2,4)*P(6,2)*Metric(1,5)*Metric(3,4))/2. - (P(2,4)*P(6,3)*Metric(1,5)*Metric(3,4))/2. - (P(2,3)*P(6,4)*Metric(1,5)*Metric(3,4))/2. - P(2,1)*P(5,2)*Metric(1,6)*Metric(3,4) + (P(2,3)*P(5,2)*Metric(1,6)*Metric(3,4))/2. + (P(2,4)*P(5,2)*Metric(1,6)*Metric(3,4))/2. - (P(2,4)*P(5,3)*Metric(1,6)*Metric(3,4))/2. - (P(2,3)*P(5,4)*Metric(1,6)*Metric(3,4))/2. - P(1,2)*P(6,1)*Metric(2,5)*Metric(3,4) + (P(1,3)*P(6,1)*Metric(2,5)*Metric(3,4))/2. + (P(1,4)*P(6,1)*Metric(2,5)*Metric(3,4))/2. - (P(1,4)*P(6,3)*Metric(2,5)*Metric(3,4))/2. - (P(1,3)*P(6,4)*Metric(2,5)*Metric(3,4))/2. + P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) - (P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - P(1,2)*P(5,1)*Metric(2,6)*Metric(3,4) + (P(1,3)*P(5,1)*Metric(2,6)*Metric(3,4))/2. + (P(1,4)*P(5,1)*Metric(2,6)*Metric(3,4))/2. - (P(1,4)*P(5,3)*Metric(2,6)*Metric(3,4))/2. - (P(1,3)*P(5,4)*Metric(2,6)*Metric(3,4))/2. + P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,6)*Metric(3,4) - (P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(4,2)*P(6,1)*Metric(1,2)*Metric(3,5))/2. - (P(4,1)*P(6,2)*Metric(1,2)*Metric(3,5))/2. + (P(4,1)*P(6,4)*Metric(1,2)*Metric(3,5))/2. + (P(4,2)*P(6,4)*Metric(1,2)*Metric(3,5))/2. - P(4,3)*P(6,4)*Metric(1,2)*Metric(3,5) - (P(2,4)*P(6,1)*Metric(1,4)*Metric(3,5))/2. + (P(2,1)*P(6,2)*Metric(1,4)*Metric(3,5))/2. - P(2,3)*P(6,2)*Metric(1,4)*Metric(3,5) + (P(2,4)*P(6,2)*Metric(1,4)*Metric(3,5))/2. - (P(2,1)*P(6,4)*Metric(1,4)*Metric(3,5))/2. + (P(2,4)*P(4,1)*Metric(1,6)*Metric(3,5))/2. + (P(2,1)*P(4,2)*Metric(1,6)*Metric(3,5))/2. + (P(2,3)*P(4,2)*Metric(1,6)*Metric(3,5))/2. + (P(2,4)*P(4,3)*Metric(1,6)*Metric(3,5))/2. + (P(1,2)*P(6,1)*Metric(2,4)*Metric(3,5))/2. - P(1,3)*P(6,1)*Metric(2,4)*Metric(3,5) + (P(1,4)*P(6,1)*Metric(2,4)*Metric(3,5))/2. - (P(1,4)*P(6,2)*Metric(2,4)*Metric(3,5))/2. - (P(1,2)*P(6,4)*Metric(2,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - (P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(1,2)*P(4,1)*Metric(2,6)*Metric(3,5))/2. + (P(1,3)*P(4,1)*Metric(2,6)*Metric(3,5))/2. + (P(1,4)*P(4,2)*Metric(2,6)*Metric(3,5))/2. + (P(1,4)*P(4,3)*Metric(2,6)*Metric(3,5))/2. - (P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,6)*Metric(3,5) - (P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(4,2)*P(5,1)*Metric(1,2)*Metric(3,6))/2. - (P(4,1)*P(5,2)*Metric(1,2)*Metric(3,6))/2. + (P(4,1)*P(5,4)*Metric(1,2)*Metric(3,6))/2. + (P(4,2)*P(5,4)*Metric(1,2)*Metric(3,6))/2. - P(4,3)*P(5,4)*Metric(1,2)*Metric(3,6) - (P(2,4)*P(5,1)*Metric(1,4)*Metric(3,6))/2. + (P(2,1)*P(5,2)*Metric(1,4)*Metric(3,6))/2. - P(2,3)*P(5,2)*Metric(1,4)*Metric(3,6) + (P(2,4)*P(5,2)*Metric(1,4)*Metric(3,6))/2. - (P(2,1)*P(5,4)*Metric(1,4)*Metric(3,6))/2. + (P(2,4)*P(4,1)*Metric(1,5)*Metric(3,6))/2. + (P(2,1)*P(4,2)*Metric(1,5)*Metric(3,6))/2. + (P(2,3)*P(4,2)*Metric(1,5)*Metric(3,6))/2. + (P(2,4)*P(4,3)*Metric(1,5)*Metric(3,6))/2. + (P(1,2)*P(5,1)*Metric(2,4)*Metric(3,6))/2. - P(1,3)*P(5,1)*Metric(2,4)*Metric(3,6) + (P(1,4)*P(5,1)*Metric(2,4)*Metric(3,6))/2. - (P(1,4)*P(5,2)*Metric(2,4)*Metric(3,6))/2. - (P(1,2)*P(5,4)*Metric(2,4)*Metric(3,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6) - (P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(1,2)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(1,3)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(1,4)*P(4,2)*Metric(2,5)*Metric(3,6))/2. + (P(1,4)*P(4,3)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,5)*Metric(3,6) - (P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(3,2)*P(6,1)*Metric(1,2)*Metric(4,5))/2. - (P(3,1)*P(6,2)*Metric(1,2)*Metric(4,5))/2. + (P(3,1)*P(6,3)*Metric(1,2)*Metric(4,5))/2. + (P(3,2)*P(6,3)*Metric(1,2)*Metric(4,5))/2. - P(3,4)*P(6,3)*Metric(1,2)*Metric(4,5) - (P(2,3)*P(6,1)*Metric(1,3)*Metric(4,5))/2. + (P(2,1)*P(6,2)*Metric(1,3)*Metric(4,5))/2. + (P(2,3)*P(6,2)*Metric(1,3)*Metric(4,5))/2. - P(2,4)*P(6,2)*Metric(1,3)*Metric(4,5) - (P(2,1)*P(6,3)*Metric(1,3)*Metric(4,5))/2. + (P(2,3)*P(3,1)*Metric(1,6)*Metric(4,5))/2. + (P(2,1)*P(3,2)*Metric(1,6)*Metric(4,5))/2. + (P(2,4)*P(3,2)*Metric(1,6)*Metric(4,5))/2. + (P(2,3)*P(3,4)*Metric(1,6)*Metric(4,5))/2. + (P(1,2)*P(6,1)*Metric(2,3)*Metric(4,5))/2. + (P(1,3)*P(6,1)*Metric(2,3)*Metric(4,5))/2. - P(1,4)*P(6,1)*Metric(2,3)*Metric(4,5) - (P(1,3)*P(6,2)*Metric(2,3)*Metric(4,5))/2. - (P(1,2)*P(6,3)*Metric(2,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,2)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(-1,1)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) - (P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(1,2)*P(3,1)*Metric(2,6)*Metric(4,5))/2. + (P(1,4)*P(3,1)*Metric(2,6)*Metric(4,5))/2. + (P(1,3)*P(3,2)*Metric(2,6)*Metric(4,5))/2. + (P(1,3)*P(3,4)*Metric(2,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) - (P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(1,3)*P(2,1)*Metric(3,6)*Metric(4,5))/2. + (P(1,4)*P(2,1)*Metric(3,6)*Metric(4,5))/2. + (P(1,2)*P(2,3)*Metric(3,6)*Metric(4,5))/2. + (P(1,2)*P(2,4)*Metric(3,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. - (P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. - (P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) - (P(3,2)*P(5,1)*Metric(1,2)*Metric(4,6))/2. - (P(3,1)*P(5,2)*Metric(1,2)*Metric(4,6))/2. + (P(3,1)*P(5,3)*Metric(1,2)*Metric(4,6))/2. + (P(3,2)*P(5,3)*Metric(1,2)*Metric(4,6))/2. - P(3,4)*P(5,3)*Metric(1,2)*Metric(4,6) - (P(2,3)*P(5,1)*Metric(1,3)*Metric(4,6))/2. + (P(2,1)*P(5,2)*Metric(1,3)*Metric(4,6))/2. + (P(2,3)*P(5,2)*Metric(1,3)*Metric(4,6))/2. - P(2,4)*P(5,2)*Metric(1,3)*Metric(4,6) - (P(2,1)*P(5,3)*Metric(1,3)*Metric(4,6))/2. + (P(2,3)*P(3,1)*Metric(1,5)*Metric(4,6))/2. + (P(2,1)*P(3,2)*Metric(1,5)*Metric(4,6))/2. + (P(2,4)*P(3,2)*Metric(1,5)*Metric(4,6))/2. + (P(2,3)*P(3,4)*Metric(1,5)*Metric(4,6))/2. + (P(1,2)*P(5,1)*Metric(2,3)*Metric(4,6))/2. + (P(1,3)*P(5,1)*Metric(2,3)*Metric(4,6))/2. - P(1,4)*P(5,1)*Metric(2,3)*Metric(4,6) - (P(1,3)*P(5,2)*Metric(2,3)*Metric(4,6))/2. - (P(1,2)*P(5,3)*Metric(2,3)*Metric(4,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(-1,1)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) - (P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(1,2)*P(3,1)*Metric(2,5)*Metric(4,6))/2. + (P(1,4)*P(3,1)*Metric(2,5)*Metric(4,6))/2. + (P(1,3)*P(3,2)*Metric(2,5)*Metric(4,6))/2. + (P(1,3)*P(3,4)*Metric(2,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6) - (P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(1,3)*P(2,1)*Metric(3,5)*Metric(4,6))/2. + (P(1,4)*P(2,1)*Metric(3,5)*Metric(4,6))/2. + (P(1,2)*P(2,3)*Metric(3,5)*Metric(4,6))/2. + (P(1,2)*P(2,4)*Metric(3,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(3,2)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,4)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,1)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,4)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,1)*P(4,3)*Metric(1,2)*Metric(5,6) - P(3,2)*P(4,3)*Metric(1,2)*Metric(5,6) + P(2,3)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,4)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,1)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,3)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,1)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,4)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,3)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,4)*P(3,1)*Metric(1,4)*Metric(5,6) - P(2,1)*P(3,2)*Metric(1,4)*Metric(5,6) - P(2,4)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,4)*Metric(1,4)*Metric(5,6) - P(2,3)*P(3,4)*Metric(1,4)*Metric(5,6) - P(1,2)*P(4,1)*Metric(2,3)*Metric(5,6) - P(1,3)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,3)*P(4,2)*Metric(2,3)*Metric(5,6) - P(1,4)*P(4,2)*Metric(2,3)*Metric(5,6) + P(1,2)*P(4,3)*Metric(2,3)*Metric(5,6) - P(1,4)*P(4,3)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(1,2)*P(3,1)*Metric(2,4)*Metric(5,6) - P(1,4)*P(3,1)*Metric(2,4)*Metric(5,6) - P(1,3)*P(3,2)*Metric(2,4)*Metric(5,6) + P(1,4)*P(3,2)*Metric(2,4)*Metric(5,6) + P(1,2)*P(3,4)*Metric(2,4)*Metric(5,6) - P(1,3)*P(3,4)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(1,3)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,2)*P(2,3)*Metric(3,4)*Metric(5,6) + P(1,4)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,2)*P(2,4)*Metric(3,4)*Metric(5,6) + P(1,3)*P(2,4)*Metric(3,4)*Metric(5,6) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV34 = Lorentz(name = 'VVVVVV34',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,4)*P(6,1)*Metric(1,4)*Metric(2,3) - P(5,6)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,4)*Metric(1,4)*Metric(2,3) - P(5,1)*P(6,5)*Metric(1,4)*Metric(2,3) + P(4,5)*P(6,1)*Metric(1,5)*Metric(2,3) - P(4,6)*P(6,1)*Metric(1,5)*Metric(2,3) - P(4,1)*P(6,4)*Metric(1,5)*Metric(2,3) + P(4,1)*P(6,5)*Metric(1,5)*Metric(2,3) - P(4,5)*P(5,1)*Metric(1,6)*Metric(2,3) + P(4,6)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,4)*Metric(1,6)*Metric(2,3) + P(4,1)*P(5,6)*Metric(1,6)*Metric(2,3) + (P(5,6)*P(6,1)*Metric(1,3)*Metric(2,4))/2. + (P(5,1)*P(6,5)*Metric(1,3)*Metric(2,4))/2. - (P(3,5)*P(6,1)*Metric(1,5)*Metric(2,4))/2. + (P(3,6)*P(6,1)*Metric(1,5)*Metric(2,4))/2. - (P(3,1)*P(6,5)*Metric(1,5)*Metric(2,4))/2. + (P(3,5)*P(5,1)*Metric(1,6)*Metric(2,4))/2. - (P(3,6)*P(5,1)*Metric(1,6)*Metric(2,4))/2. - (P(3,1)*P(5,6)*Metric(1,6)*Metric(2,4))/2. + (P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5))/2. + (P(4,1)*P(6,4)*Metric(1,3)*Metric(2,5))/2. - (P(3,4)*P(6,1)*Metric(1,4)*Metric(2,5))/2. + (P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5))/2. - (P(3,1)*P(6,4)*Metric(1,4)*Metric(2,5))/2. + (P(3,4)*P(4,1)*Metric(1,6)*Metric(2,5))/2. - (P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5))/2. - (P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5))/2. + (P(4,5)*P(5,1)*Metric(1,3)*Metric(2,6))/2. + (P(4,1)*P(5,4)*Metric(1,3)*Metric(2,6))/2. - (P(3,4)*P(5,1)*Metric(1,4)*Metric(2,6))/2. + (P(3,5)*P(5,1)*Metric(1,4)*Metric(2,6))/2. - (P(3,1)*P(5,4)*Metric(1,4)*Metric(2,6))/2. + (P(3,4)*P(4,1)*Metric(1,5)*Metric(2,6))/2. - (P(3,5)*P(4,1)*Metric(1,5)*Metric(2,6))/2. - (P(3,1)*P(4,5)*Metric(1,5)*Metric(2,6))/2. + (P(5,6)*P(6,1)*Metric(1,2)*Metric(3,4))/2. + (P(5,1)*P(6,5)*Metric(1,2)*Metric(3,4))/2. - (P(2,5)*P(6,1)*Metric(1,5)*Metric(3,4))/2. + (P(2,6)*P(6,1)*Metric(1,5)*Metric(3,4))/2. - (P(2,1)*P(6,5)*Metric(1,5)*Metric(3,4))/2. + (P(2,5)*P(5,1)*Metric(1,6)*Metric(3,4))/2. - (P(2,6)*P(5,1)*Metric(1,6)*Metric(3,4))/2. - (P(2,1)*P(5,6)*Metric(1,6)*Metric(3,4))/2. + (P(1,4)*P(6,1)*Metric(2,5)*Metric(3,4))/2. + (P(1,5)*P(6,1)*Metric(2,5)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. + (P(1,4)*P(5,1)*Metric(2,6)*Metric(3,4))/2. + (P(1,6)*P(5,1)*Metric(2,6)*Metric(3,4))/2. - (P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(4,6)*P(6,1)*Metric(1,2)*Metric(3,5))/2. + (P(4,1)*P(6,4)*Metric(1,2)*Metric(3,5))/2. - (P(2,4)*P(6,1)*Metric(1,4)*Metric(3,5))/2. + (P(2,6)*P(6,1)*Metric(1,4)*Metric(3,5))/2. - (P(2,1)*P(6,4)*Metric(1,4)*Metric(3,5))/2. + (P(2,4)*P(4,1)*Metric(1,6)*Metric(3,5))/2. - (P(2,6)*P(4,1)*Metric(1,6)*Metric(3,5))/2. - (P(2,1)*P(4,6)*Metric(1,6)*Metric(3,5))/2. + (P(1,4)*P(6,1)*Metric(2,4)*Metric(3,5))/2. + (P(1,5)*P(6,1)*Metric(2,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(1,5)*P(4,1)*Metric(2,6)*Metric(3,5))/2. + (P(1,6)*P(4,1)*Metric(2,6)*Metric(3,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(4,5)*P(5,1)*Metric(1,2)*Metric(3,6))/2. + (P(4,1)*P(5,4)*Metric(1,2)*Metric(3,6))/2. - (P(2,4)*P(5,1)*Metric(1,4)*Metric(3,6))/2. + (P(2,5)*P(5,1)*Metric(1,4)*Metric(3,6))/2. - (P(2,1)*P(5,4)*Metric(1,4)*Metric(3,6))/2. + (P(2,4)*P(4,1)*Metric(1,5)*Metric(3,6))/2. - (P(2,5)*P(4,1)*Metric(1,5)*Metric(3,6))/2. - (P(2,1)*P(4,5)*Metric(1,5)*Metric(3,6))/2. + (P(1,4)*P(5,1)*Metric(2,4)*Metric(3,6))/2. + (P(1,6)*P(5,1)*Metric(2,4)*Metric(3,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(1,5)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - P(3,6)*P(6,1)*Metric(1,2)*Metric(4,5) - P(2,6)*P(6,1)*Metric(1,3)*Metric(4,5) + P(2,6)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,6)*Metric(1,6)*Metric(4,5) - P(1,4)*P(6,1)*Metric(2,3)*Metric(4,5) - P(1,5)*P(6,1)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + (P(1,4)*P(3,1)*Metric(2,6)*Metric(4,5))/2. + (P(1,5)*P(3,1)*Metric(2,6)*Metric(4,5))/2. - P(1,6)*P(3,1)*Metric(2,6)*Metric(4,5) - (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + (P(1,4)*P(2,1)*Metric(3,6)*Metric(4,5))/2. + (P(1,5)*P(2,1)*Metric(3,6)*Metric(4,5))/2. - P(1,6)*P(2,1)*Metric(3,6)*Metric(4,5) - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. - (P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(3,5)*P(5,1)*Metric(1,2)*Metric(4,6) - P(2,5)*P(5,1)*Metric(1,3)*Metric(4,6) + P(2,5)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,5)*Metric(1,5)*Metric(4,6) - P(1,4)*P(5,1)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,1)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + (P(1,4)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - P(1,5)*P(3,1)*Metric(2,5)*Metric(4,6) + (P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) - (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(1,4)*P(2,1)*Metric(3,5)*Metric(4,6))/2. - P(1,5)*P(2,1)*Metric(3,5)*Metric(4,6) + (P(1,6)*P(2,1)*Metric(3,5)*Metric(4,6))/2. - (P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - P(3,4)*P(4,1)*Metric(1,2)*Metric(5,6) - P(2,4)*P(4,1)*Metric(1,3)*Metric(5,6) + P(2,4)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,4)*Metric(1,4)*Metric(5,6) - P(1,5)*P(4,1)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,1)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(1,4)*P(3,1)*Metric(2,4)*Metric(5,6) + (P(1,5)*P(3,1)*Metric(2,4)*Metric(5,6))/2. + (P(1,6)*P(3,1)*Metric(2,4)*Metric(5,6))/2. + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - P(1,4)*P(2,1)*Metric(3,4)*Metric(5,6) + (P(1,5)*P(2,1)*Metric(3,4)*Metric(5,6))/2. + (P(1,6)*P(2,1)*Metric(3,4)*Metric(5,6))/2. + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) - (P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. - (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVV35 = Lorentz(name = 'VVVVVV35',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,6)*P(6,1)*Metric(1,4)*Metric(2,3) + P(4,6)*P(6,1)*Metric(1,5)*Metric(2,3) - P(4,6)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,6)*Metric(1,6)*Metric(2,3) - (P(5,6)*P(6,1)*Metric(1,3)*Metric(2,4))/2. - (P(3,6)*P(6,1)*Metric(1,5)*Metric(2,4))/2. + (P(3,6)*P(5,1)*Metric(1,6)*Metric(2,4))/2. + (P(3,1)*P(5,6)*Metric(1,6)*Metric(2,4))/2. - (P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5))/2. - (P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5))/2. + (P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5))/2. + (P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5))/2. - (P(5,6)*P(6,1)*Metric(1,2)*Metric(3,4))/2. - (P(2,6)*P(6,1)*Metric(1,5)*Metric(3,4))/2. + (P(2,6)*P(5,1)*Metric(1,6)*Metric(3,4))/2. + (P(2,1)*P(5,6)*Metric(1,6)*Metric(3,4))/2. - (P(1,6)*P(5,1)*Metric(2,6)*Metric(3,4))/2. + (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(4,6)*P(6,1)*Metric(1,2)*Metric(3,5))/2. - (P(2,6)*P(6,1)*Metric(1,4)*Metric(3,5))/2. + (P(2,6)*P(4,1)*Metric(1,6)*Metric(3,5))/2. + (P(2,1)*P(4,6)*Metric(1,6)*Metric(3,5))/2. - (P(1,6)*P(4,1)*Metric(2,6)*Metric(3,5))/2. + (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(1,6)*P(5,1)*Metric(2,4)*Metric(3,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + P(3,6)*P(6,1)*Metric(1,2)*Metric(4,5) + P(2,6)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,6)*P(3,1)*Metric(1,6)*Metric(4,5) - P(2,1)*P(3,6)*Metric(1,6)*Metric(4,5) + P(1,6)*P(3,1)*Metric(2,6)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(1,6)*P(2,1)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(1,6)*P(5,1)*Metric(2,3)*Metric(4,6) - P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - (P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(1,6)*P(2,1)*Metric(3,5)*Metric(4,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + P(1,6)*P(4,1)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - (P(1,6)*P(3,1)*Metric(2,4)*Metric(5,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(1,6)*P(2,1)*Metric(3,4)*Metric(5,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVV36 = Lorentz(name = 'VVVVVV36',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,6)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,6)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,5)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,5)*Metric(1,4)*Metric(2,3) - P(4,5)*P(6,1)*Metric(1,5)*Metric(2,3) + P(4,6)*P(6,1)*Metric(1,5)*Metric(2,3) - 2*P(4,6)*P(6,2)*Metric(1,5)*Metric(2,3) - P(4,1)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,5)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,1)*Metric(1,6)*Metric(2,3) - 2*P(4,5)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,6)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,6)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,5)*Metric(1,3)*Metric(2,4) + P(5,2)*P(6,5)*Metric(1,3)*Metric(2,4) - P(3,5)*P(6,1)*Metric(1,5)*Metric(2,4) + P(3,6)*P(6,1)*Metric(1,5)*Metric(2,4) - 2*P(3,6)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,1)*P(6,5)*Metric(1,5)*Metric(2,4) + P(3,5)*P(5,1)*Metric(1,6)*Metric(2,4) - P(3,6)*P(5,1)*Metric(1,6)*Metric(2,4) - 2*P(3,5)*P(5,2)*Metric(1,6)*Metric(2,4) - P(3,1)*P(5,6)*Metric(1,6)*Metric(2,4) - 2*P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5) - P(4,5)*P(6,2)*Metric(1,3)*Metric(2,5) + P(4,6)*P(6,2)*Metric(1,3)*Metric(2,5) - P(4,2)*P(6,5)*Metric(1,3)*Metric(2,5) - 2*P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,5)*P(6,2)*Metric(1,4)*Metric(2,5) + P(3,6)*P(6,2)*Metric(1,4)*Metric(2,5) - P(3,2)*P(6,5)*Metric(1,4)*Metric(2,5) + 2*P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5) + 2*P(3,5)*P(4,2)*Metric(1,6)*Metric(2,5) + 2*P(3,2)*P(4,5)*Metric(1,6)*Metric(2,5) + 2*P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5) - 2*P(4,5)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,5)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,6)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,2)*P(5,6)*Metric(1,3)*Metric(2,6) - 2*P(3,5)*P(5,1)*Metric(1,4)*Metric(2,6) + P(3,5)*P(5,2)*Metric(1,4)*Metric(2,6) - P(3,6)*P(5,2)*Metric(1,4)*Metric(2,6) - P(3,2)*P(5,6)*Metric(1,4)*Metric(2,6) + 2*P(3,5)*P(4,1)*Metric(1,5)*Metric(2,6) + 2*P(3,6)*P(4,2)*Metric(1,5)*Metric(2,6) + 2*P(3,1)*P(4,5)*Metric(1,5)*Metric(2,6) + 2*P(3,2)*P(4,6)*Metric(1,5)*Metric(2,6) - 2*P(5,6)*P(6,1)*Metric(1,2)*Metric(3,4) - 2*P(5,6)*P(6,2)*Metric(1,2)*Metric(3,4) - 2*P(5,1)*P(6,5)*Metric(1,2)*Metric(3,4) - 2*P(5,2)*P(6,5)*Metric(1,2)*Metric(3,4) + 2*P(2,5)*P(6,1)*Metric(1,5)*Metric(3,4) - 2*P(2,6)*P(6,1)*Metric(1,5)*Metric(3,4) - 2*P(2,5)*P(6,2)*Metric(1,5)*Metric(3,4) + 2*P(2,1)*P(6,5)*Metric(1,5)*Metric(3,4) - 2*P(2,5)*P(5,1)*Metric(1,6)*Metric(3,4) + 2*P(2,6)*P(5,1)*Metric(1,6)*Metric(3,4) - 2*P(2,6)*P(5,2)*Metric(1,6)*Metric(3,4) + 2*P(2,1)*P(5,6)*Metric(1,6)*Metric(3,4) - 2*P(1,5)*P(6,1)*Metric(2,5)*Metric(3,4) + 2*P(1,5)*P(6,2)*Metric(2,5)*Metric(3,4) - 2*P(1,6)*P(6,2)*Metric(2,5)*Metric(3,4) + 2*P(1,2)*P(6,5)*Metric(2,5)*Metric(3,4) + 2*P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + 2*P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(1,6)*P(5,1)*Metric(2,6)*Metric(3,4) - 2*P(1,5)*P(5,2)*Metric(2,6)*Metric(3,4) + 2*P(1,6)*P(5,2)*Metric(2,6)*Metric(3,4) + 2*P(1,2)*P(5,6)*Metric(2,6)*Metric(3,4) + 2*P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(4,6)*P(6,1)*Metric(1,2)*Metric(3,5) + P(4,6)*P(6,2)*Metric(1,2)*Metric(3,5) + P(2,6)*P(6,1)*Metric(1,4)*Metric(3,5) + P(2,5)*P(6,2)*Metric(1,4)*Metric(3,5) - P(2,6)*P(4,1)*Metric(1,6)*Metric(3,5) - 2*P(2,5)*P(4,2)*Metric(1,6)*Metric(3,5) + P(2,6)*P(4,2)*Metric(1,6)*Metric(3,5) - P(2,1)*P(4,6)*Metric(1,6)*Metric(3,5) + P(1,5)*P(6,1)*Metric(2,4)*Metric(3,5) + P(1,6)*P(6,2)*Metric(2,4)*Metric(3,5) - P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + 2*P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(1,5)*P(4,1)*Metric(2,6)*Metric(3,5) + P(1,6)*P(4,1)*Metric(2,6)*Metric(3,5) - P(1,6)*P(4,2)*Metric(2,6)*Metric(3,5) - P(1,2)*P(4,6)*Metric(2,6)*Metric(3,5) + 2*P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(4,5)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,5)*P(5,2)*Metric(1,2)*Metric(3,6) + P(2,5)*P(5,1)*Metric(1,4)*Metric(3,6) + P(2,6)*P(5,2)*Metric(1,4)*Metric(3,6) - P(2,5)*P(4,1)*Metric(1,5)*Metric(3,6) + P(2,5)*P(4,2)*Metric(1,5)*Metric(3,6) - 2*P(2,6)*P(4,2)*Metric(1,5)*Metric(3,6) - P(2,1)*P(4,5)*Metric(1,5)*Metric(3,6) + P(1,6)*P(5,1)*Metric(2,4)*Metric(3,6) + P(1,5)*P(5,2)*Metric(2,4)*Metric(3,6) - P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + 2*P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(1,5)*P(4,1)*Metric(2,5)*Metric(3,6) - 2*P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,5)*P(4,2)*Metric(2,5)*Metric(3,6) - P(1,2)*P(4,5)*Metric(2,5)*Metric(3,6) - P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(3,6)*P(6,1)*Metric(1,2)*Metric(4,5) + P(3,6)*P(6,2)*Metric(1,2)*Metric(4,5) + P(2,6)*P(6,1)*Metric(1,3)*Metric(4,5) + P(2,5)*P(6,2)*Metric(1,3)*Metric(4,5) - P(2,6)*P(3,1)*Metric(1,6)*Metric(4,5) - 2*P(2,5)*P(3,2)*Metric(1,6)*Metric(4,5) + P(2,6)*P(3,2)*Metric(1,6)*Metric(4,5) - P(2,1)*P(3,6)*Metric(1,6)*Metric(4,5) + P(1,5)*P(6,1)*Metric(2,3)*Metric(4,5) + P(1,6)*P(6,2)*Metric(2,3)*Metric(4,5) - P(-1,1)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(1,5)*P(3,1)*Metric(2,6)*Metric(4,5) + P(1,6)*P(3,1)*Metric(2,6)*Metric(4,5) - P(1,6)*P(3,2)*Metric(2,6)*Metric(4,5) - P(1,2)*P(3,6)*Metric(2,6)*Metric(4,5) + 2*P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(1,5)*P(2,1)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,1)*Metric(3,6)*Metric(4,5) + P(1,2)*P(2,5)*Metric(3,6)*Metric(4,5) + P(1,2)*P(2,6)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(3,5)*P(5,1)*Metric(1,2)*Metric(4,6) + P(3,5)*P(5,2)*Metric(1,2)*Metric(4,6) + P(2,5)*P(5,1)*Metric(1,3)*Metric(4,6) + P(2,6)*P(5,2)*Metric(1,3)*Metric(4,6) - P(2,5)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,5)*P(3,2)*Metric(1,5)*Metric(4,6) - 2*P(2,6)*P(3,2)*Metric(1,5)*Metric(4,6) - P(2,1)*P(3,5)*Metric(1,5)*Metric(4,6) + P(1,6)*P(5,1)*Metric(2,3)*Metric(4,6) + P(1,5)*P(5,2)*Metric(2,3)*Metric(4,6) - P(-1,2)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + 2*P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(1,5)*P(3,1)*Metric(2,5)*Metric(4,6) - 2*P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6) - P(1,5)*P(3,2)*Metric(2,5)*Metric(4,6) - P(1,2)*P(3,5)*Metric(2,5)*Metric(4,6) - P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(1,5)*P(2,1)*Metric(3,5)*Metric(4,6) + P(1,6)*P(2,1)*Metric(3,5)*Metric(4,6) + P(1,2)*P(2,5)*Metric(3,5)*Metric(4,6) + P(1,2)*P(2,6)*Metric(3,5)*Metric(4,6) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(2,5)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,6)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,5)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,2)*Metric(1,4)*Metric(5,6) + P(1,5)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,1)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(1,5)*P(3,1)*Metric(2,4)*Metric(5,6) + P(1,6)*P(3,1)*Metric(2,4)*Metric(5,6) - P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(1,5)*P(2,1)*Metric(3,4)*Metric(5,6) - 2*P(1,6)*P(2,1)*Metric(3,4)*Metric(5,6) - 2*P(1,2)*P(2,5)*Metric(3,4)*Metric(5,6) - 2*P(1,2)*P(2,6)*Metric(3,4)*Metric(5,6) + 2*P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV37 = Lorentz(name = 'VVVVVV37',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,6)*P(6,1)*Metric(1,4)*Metric(2,3) - (P(5,6)*P(6,2)*Metric(1,4)*Metric(2,3))/2. - (P(5,6)*P(6,3)*Metric(1,4)*Metric(2,3))/2. + P(4,6)*P(6,1)*Metric(1,5)*Metric(2,3) - (P(4,6)*P(6,2)*Metric(1,5)*Metric(2,3))/2. - (P(4,6)*P(6,3)*Metric(1,5)*Metric(2,3))/2. - P(4,6)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,6)*Metric(1,6)*Metric(2,3) - (P(5,6)*P(6,1)*Metric(1,3)*Metric(2,4))/2. + P(5,6)*P(6,2)*Metric(1,3)*Metric(2,4) - (P(5,6)*P(6,3)*Metric(1,3)*Metric(2,4))/2. - (P(3,6)*P(6,1)*Metric(1,5)*Metric(2,4))/2. - (P(3,6)*P(6,2)*Metric(1,5)*Metric(2,4))/2. + (P(3,6)*P(5,1)*Metric(1,6)*Metric(2,4))/2. - (P(3,6)*P(5,3)*Metric(1,6)*Metric(2,4))/2. + (P(3,1)*P(5,6)*Metric(1,6)*Metric(2,4))/2. - (P(4,6)*P(6,1)*Metric(1,3)*Metric(2,5))/2. + P(4,6)*P(6,2)*Metric(1,3)*Metric(2,5) - (P(4,6)*P(6,3)*Metric(1,3)*Metric(2,5))/2. - (P(3,6)*P(6,1)*Metric(1,4)*Metric(2,5))/2. - (P(3,6)*P(6,2)*Metric(1,4)*Metric(2,5))/2. + (P(3,6)*P(4,1)*Metric(1,6)*Metric(2,5))/2. - (P(3,6)*P(4,3)*Metric(1,6)*Metric(2,5))/2. + (P(3,1)*P(4,6)*Metric(1,6)*Metric(2,5))/2. - P(4,6)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,2)*P(5,6)*Metric(1,3)*Metric(2,6) + (P(3,6)*P(5,2)*Metric(1,4)*Metric(2,6))/2. - (P(3,6)*P(5,3)*Metric(1,4)*Metric(2,6))/2. + (P(3,2)*P(5,6)*Metric(1,4)*Metric(2,6))/2. + (P(3,6)*P(4,2)*Metric(1,5)*Metric(2,6))/2. - (P(3,6)*P(4,3)*Metric(1,5)*Metric(2,6))/2. + (P(3,2)*P(4,6)*Metric(1,5)*Metric(2,6))/2. - (P(5,6)*P(6,1)*Metric(1,2)*Metric(3,4))/2. - (P(5,6)*P(6,2)*Metric(1,2)*Metric(3,4))/2. + P(5,6)*P(6,3)*Metric(1,2)*Metric(3,4) - (P(2,6)*P(6,1)*Metric(1,5)*Metric(3,4))/2. - (P(2,6)*P(6,3)*Metric(1,5)*Metric(3,4))/2. + (P(2,6)*P(5,1)*Metric(1,6)*Metric(3,4))/2. - (P(2,6)*P(5,2)*Metric(1,6)*Metric(3,4))/2. + (P(2,1)*P(5,6)*Metric(1,6)*Metric(3,4))/2. - (P(1,6)*P(6,2)*Metric(2,5)*Metric(3,4))/2. - (P(1,6)*P(6,3)*Metric(2,5)*Metric(3,4))/2. + (P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. + (P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(1,6)*P(5,1)*Metric(2,6)*Metric(3,4))/2. + (P(1,6)*P(5,2)*Metric(2,6)*Metric(3,4))/2. + (P(1,2)*P(5,6)*Metric(2,6)*Metric(3,4))/2. + (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(4,6)*P(6,1)*Metric(1,2)*Metric(3,5))/2. - (P(4,6)*P(6,2)*Metric(1,2)*Metric(3,5))/2. + P(4,6)*P(6,3)*Metric(1,2)*Metric(3,5) - (P(2,6)*P(6,1)*Metric(1,4)*Metric(3,5))/2. - (P(2,6)*P(6,3)*Metric(1,4)*Metric(3,5))/2. + (P(2,6)*P(4,1)*Metric(1,6)*Metric(3,5))/2. - (P(2,6)*P(4,2)*Metric(1,6)*Metric(3,5))/2. + (P(2,1)*P(4,6)*Metric(1,6)*Metric(3,5))/2. - (P(1,6)*P(6,2)*Metric(2,4)*Metric(3,5))/2. - (P(1,6)*P(6,3)*Metric(2,4)*Metric(3,5))/2. + (P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(1,6)*P(4,1)*Metric(2,6)*Metric(3,5))/2. + (P(1,6)*P(4,2)*Metric(2,6)*Metric(3,5))/2. + (P(1,2)*P(4,6)*Metric(2,6)*Metric(3,5))/2. + (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - P(4,6)*P(5,3)*Metric(1,2)*Metric(3,6) - P(4,3)*P(5,6)*Metric(1,2)*Metric(3,6) - (P(2,6)*P(5,2)*Metric(1,4)*Metric(3,6))/2. + (P(2,6)*P(5,3)*Metric(1,4)*Metric(3,6))/2. + (P(2,3)*P(5,6)*Metric(1,4)*Metric(3,6))/2. - (P(2,6)*P(4,2)*Metric(1,5)*Metric(3,6))/2. + (P(2,6)*P(4,3)*Metric(1,5)*Metric(3,6))/2. + (P(2,3)*P(4,6)*Metric(1,5)*Metric(3,6))/2. - (P(1,6)*P(5,1)*Metric(2,4)*Metric(3,6))/2. + (P(1,6)*P(5,3)*Metric(2,4)*Metric(3,6))/2. + (P(1,3)*P(5,6)*Metric(2,4)*Metric(3,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(1,6)*P(4,1)*Metric(2,5)*Metric(3,6))/2. + (P(1,6)*P(4,3)*Metric(2,5)*Metric(3,6))/2. + (P(1,3)*P(4,6)*Metric(2,5)*Metric(3,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + P(3,6)*P(6,1)*Metric(1,2)*Metric(4,5) + P(3,6)*P(6,2)*Metric(1,2)*Metric(4,5) + P(2,6)*P(6,1)*Metric(1,3)*Metric(4,5) + P(2,6)*P(6,3)*Metric(1,3)*Metric(4,5) - P(2,6)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,6)*P(3,2)*Metric(1,6)*Metric(4,5) - P(2,1)*P(3,6)*Metric(1,6)*Metric(4,5) + P(2,3)*P(3,6)*Metric(1,6)*Metric(4,5) + P(1,6)*P(6,2)*Metric(2,3)*Metric(4,5) + P(1,6)*P(6,3)*Metric(2,3)*Metric(4,5) - P(-1,2)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(1,6)*P(3,1)*Metric(2,6)*Metric(4,5) - P(1,6)*P(3,2)*Metric(2,6)*Metric(4,5) - P(1,2)*P(3,6)*Metric(2,6)*Metric(4,5) + P(1,3)*P(3,6)*Metric(2,6)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(1,6)*P(2,1)*Metric(3,6)*Metric(4,5) - P(1,6)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,2)*P(2,6)*Metric(3,6)*Metric(4,5) - P(1,3)*P(2,6)*Metric(3,6)*Metric(4,5) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(3,6)*P(5,3)*Metric(1,2)*Metric(4,6) + P(2,6)*P(5,2)*Metric(1,3)*Metric(4,6) - (P(2,6)*P(3,2)*Metric(1,5)*Metric(4,6))/2. - (P(2,3)*P(3,6)*Metric(1,5)*Metric(4,6))/2. + P(1,6)*P(5,1)*Metric(2,3)*Metric(4,6) - P(-1,1)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + (P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(1,6)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - (P(1,3)*P(3,6)*Metric(2,5)*Metric(4,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + (P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(1,6)*P(2,1)*Metric(3,5)*Metric(4,6))/2. - (P(1,2)*P(2,6)*Metric(3,5)*Metric(4,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + (P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(3,6)*P(4,3)*Metric(1,2)*Metric(5,6) + P(2,6)*P(4,2)*Metric(1,3)*Metric(5,6) - (P(2,6)*P(3,2)*Metric(1,4)*Metric(5,6))/2. - (P(2,3)*P(3,6)*Metric(1,4)*Metric(5,6))/2. + P(1,6)*P(4,1)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + (P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6))/2. + (P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6))/2. - (P(1,6)*P(3,1)*Metric(2,4)*Metric(5,6))/2. - (P(1,3)*P(3,6)*Metric(2,4)*Metric(5,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + (P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(1,6)*P(2,1)*Metric(3,4)*Metric(5,6))/2. - (P(1,2)*P(2,6)*Metric(3,4)*Metric(5,6))/2. + (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. + (P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. - P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV38 = Lorentz(name = 'VVVVVV38',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,6)*P(6,4)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,5)*Metric(1,4)*Metric(2,3) + P(4,5)*P(6,4)*Metric(1,5)*Metric(2,3) + P(4,6)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,6)*P(5,4)*Metric(1,6)*Metric(2,3) + P(4,5)*P(5,6)*Metric(1,6)*Metric(2,3) - (P(5,6)*P(6,4)*Metric(1,3)*Metric(2,4))/2. - (P(5,4)*P(6,5)*Metric(1,3)*Metric(2,4))/2. + P(3,6)*P(6,4)*Metric(1,5)*Metric(2,4) - (P(3,6)*P(6,5)*Metric(1,5)*Metric(2,4))/2. + P(3,5)*P(5,4)*Metric(1,6)*Metric(2,4) - (P(3,5)*P(5,6)*Metric(1,6)*Metric(2,4))/2. - (P(4,5)*P(6,4)*Metric(1,3)*Metric(2,5))/2. - (P(4,6)*P(6,5)*Metric(1,3)*Metric(2,5))/2. - (P(3,6)*P(6,4)*Metric(1,4)*Metric(2,5))/2. + P(3,6)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,4)*P(4,5)*Metric(1,6)*Metric(2,5) - (P(3,4)*P(4,6)*Metric(1,6)*Metric(2,5))/2. - (P(4,6)*P(5,4)*Metric(1,3)*Metric(2,6))/2. - (P(4,5)*P(5,6)*Metric(1,3)*Metric(2,6))/2. - (P(3,5)*P(5,4)*Metric(1,4)*Metric(2,6))/2. + P(3,5)*P(5,6)*Metric(1,4)*Metric(2,6) - (P(3,4)*P(4,5)*Metric(1,5)*Metric(2,6))/2. + P(3,4)*P(4,6)*Metric(1,5)*Metric(2,6) - (P(5,6)*P(6,4)*Metric(1,2)*Metric(3,4))/2. - (P(5,4)*P(6,5)*Metric(1,2)*Metric(3,4))/2. + P(2,6)*P(6,4)*Metric(1,5)*Metric(3,4) - (P(2,6)*P(6,5)*Metric(1,5)*Metric(3,4))/2. + P(2,5)*P(5,4)*Metric(1,6)*Metric(3,4) - (P(2,5)*P(5,6)*Metric(1,6)*Metric(3,4))/2. - (P(1,6)*P(6,4)*Metric(2,5)*Metric(3,4))/2. - (P(1,6)*P(6,5)*Metric(2,5)*Metric(3,4))/2. - P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + (P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. + (P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4))/2. - (P(1,5)*P(5,4)*Metric(2,6)*Metric(3,4))/2. - (P(1,5)*P(5,6)*Metric(2,6)*Metric(3,4))/2. + (P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + (P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(4,5)*P(6,4)*Metric(1,2)*Metric(3,5))/2. - (P(4,6)*P(6,5)*Metric(1,2)*Metric(3,5))/2. - (P(2,6)*P(6,4)*Metric(1,4)*Metric(3,5))/2. + P(2,6)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,4)*P(4,5)*Metric(1,6)*Metric(3,5) - (P(2,4)*P(4,6)*Metric(1,6)*Metric(3,5))/2. - (P(1,6)*P(6,4)*Metric(2,4)*Metric(3,5))/2. - (P(1,6)*P(6,5)*Metric(2,4)*Metric(3,5))/2. - P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + (P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(1,4)*P(4,5)*Metric(2,6)*Metric(3,5))/2. - (P(1,4)*P(4,6)*Metric(2,6)*Metric(3,5))/2. + (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - (P(4,6)*P(5,4)*Metric(1,2)*Metric(3,6))/2. - (P(4,5)*P(5,6)*Metric(1,2)*Metric(3,6))/2. - (P(2,5)*P(5,4)*Metric(1,4)*Metric(3,6))/2. + P(2,5)*P(5,6)*Metric(1,4)*Metric(3,6) - (P(2,4)*P(4,5)*Metric(1,5)*Metric(3,6))/2. + P(2,4)*P(4,6)*Metric(1,5)*Metric(3,6) - (P(1,5)*P(5,4)*Metric(2,4)*Metric(3,6))/2. - (P(1,5)*P(5,6)*Metric(2,4)*Metric(3,6))/2. + (P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + (P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(1,4)*P(4,5)*Metric(2,5)*Metric(3,6))/2. - (P(1,4)*P(4,6)*Metric(2,5)*Metric(3,6))/2. + (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + (P(3,5)*P(6,4)*Metric(1,2)*Metric(4,5))/2. - (P(3,6)*P(6,4)*Metric(1,2)*Metric(4,5))/2. + (P(3,4)*P(6,5)*Metric(1,2)*Metric(4,5))/2. - (P(3,6)*P(6,5)*Metric(1,2)*Metric(4,5))/2. + (P(2,5)*P(6,4)*Metric(1,3)*Metric(4,5))/2. - (P(2,6)*P(6,4)*Metric(1,3)*Metric(4,5))/2. + (P(2,4)*P(6,5)*Metric(1,3)*Metric(4,5))/2. - (P(2,6)*P(6,5)*Metric(1,3)*Metric(4,5))/2. - P(2,5)*P(3,4)*Metric(1,6)*Metric(4,5) - P(2,4)*P(3,5)*Metric(1,6)*Metric(4,5) - P(1,5)*P(6,4)*Metric(2,3)*Metric(4,5) + P(1,6)*P(6,4)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,5)*Metric(2,3)*Metric(4,5) + P(1,6)*P(6,5)*Metric(2,3)*Metric(4,5) - P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + (P(1,5)*P(3,4)*Metric(2,6)*Metric(4,5))/2. + (P(1,4)*P(3,5)*Metric(2,6)*Metric(4,5))/2. + (P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(1,5)*P(2,4)*Metric(3,6)*Metric(4,5))/2. + (P(1,4)*P(2,5)*Metric(3,6)*Metric(4,5))/2. + (P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. + (P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5))/2. - (P(3,5)*P(5,4)*Metric(1,2)*Metric(4,6))/2. + (P(3,6)*P(5,4)*Metric(1,2)*Metric(4,6))/2. + (P(3,4)*P(5,6)*Metric(1,2)*Metric(4,6))/2. - (P(3,5)*P(5,6)*Metric(1,2)*Metric(4,6))/2. - (P(2,5)*P(5,4)*Metric(1,3)*Metric(4,6))/2. + (P(2,6)*P(5,4)*Metric(1,3)*Metric(4,6))/2. + (P(2,4)*P(5,6)*Metric(1,3)*Metric(4,6))/2. - (P(2,5)*P(5,6)*Metric(1,3)*Metric(4,6))/2. - P(2,6)*P(3,4)*Metric(1,5)*Metric(4,6) - P(2,4)*P(3,6)*Metric(1,5)*Metric(4,6) + P(1,5)*P(5,4)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,4)*Metric(2,3)*Metric(4,6) - P(1,4)*P(5,6)*Metric(2,3)*Metric(4,6) + P(1,5)*P(5,6)*Metric(2,3)*Metric(4,6) - P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + (P(1,6)*P(3,4)*Metric(2,5)*Metric(4,6))/2. + (P(1,4)*P(3,6)*Metric(2,5)*Metric(4,6))/2. + (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(1,6)*P(2,4)*Metric(3,5)*Metric(4,6))/2. + (P(1,4)*P(2,6)*Metric(3,5)*Metric(4,6))/2. + (P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + (P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(3,4)*P(4,5)*Metric(1,2)*Metric(5,6))/2. + (P(3,6)*P(4,5)*Metric(1,2)*Metric(5,6))/2. - (P(3,4)*P(4,6)*Metric(1,2)*Metric(5,6))/2. + (P(3,5)*P(4,6)*Metric(1,2)*Metric(5,6))/2. - (P(2,4)*P(4,5)*Metric(1,3)*Metric(5,6))/2. + (P(2,6)*P(4,5)*Metric(1,3)*Metric(5,6))/2. - (P(2,4)*P(4,6)*Metric(1,3)*Metric(5,6))/2. + (P(2,5)*P(4,6)*Metric(1,3)*Metric(5,6))/2. - P(2,6)*P(3,5)*Metric(1,4)*Metric(5,6) - P(2,5)*P(3,6)*Metric(1,4)*Metric(5,6) + P(1,4)*P(4,5)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,5)*Metric(2,3)*Metric(5,6) + P(1,4)*P(4,6)*Metric(2,3)*Metric(5,6) - P(1,5)*P(4,6)*Metric(2,3)*Metric(5,6) - P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + (P(1,6)*P(3,5)*Metric(2,4)*Metric(5,6))/2. + (P(1,5)*P(3,6)*Metric(2,4)*Metric(5,6))/2. + (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + (P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + (P(1,6)*P(2,5)*Metric(3,4)*Metric(5,6))/2. + (P(1,5)*P(2,6)*Metric(3,4)*Metric(5,6))/2. + (P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. + (P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2.')

VVVVVV39 = Lorentz(name = 'VVVVVV39',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,6)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,6)*P(6,4)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,5)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,5)*Metric(1,4)*Metric(2,3) + P(4,6)*P(6,3)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,4)*Metric(1,5)*Metric(2,3) + P(4,5)*P(6,4)*Metric(1,5)*Metric(2,3) + P(4,6)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,5)*P(5,3)*Metric(1,6)*Metric(2,3) + P(4,3)*P(5,4)*Metric(1,6)*Metric(2,3) + P(4,6)*P(5,4)*Metric(1,6)*Metric(2,3) + P(4,5)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,6)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,6)*P(6,4)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,5)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,5)*Metric(1,3)*Metric(2,4) + P(3,4)*P(6,3)*Metric(1,5)*Metric(2,4) + P(3,5)*P(6,3)*Metric(1,5)*Metric(2,4) + P(3,6)*P(6,4)*Metric(1,5)*Metric(2,4) + P(3,6)*P(6,5)*Metric(1,5)*Metric(2,4) + P(3,4)*P(5,3)*Metric(1,6)*Metric(2,4) + P(3,6)*P(5,3)*Metric(1,6)*Metric(2,4) + P(3,5)*P(5,4)*Metric(1,6)*Metric(2,4) + P(3,5)*P(5,6)*Metric(1,6)*Metric(2,4) + P(4,6)*P(6,3)*Metric(1,3)*Metric(2,5) + P(4,3)*P(6,4)*Metric(1,3)*Metric(2,5) + P(4,5)*P(6,4)*Metric(1,3)*Metric(2,5) + P(4,6)*P(6,5)*Metric(1,3)*Metric(2,5) + P(3,4)*P(6,3)*Metric(1,4)*Metric(2,5) + P(3,5)*P(6,3)*Metric(1,4)*Metric(2,5) + P(3,6)*P(6,4)*Metric(1,4)*Metric(2,5) + P(3,6)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,5)*P(4,3)*Metric(1,6)*Metric(2,5) + P(3,6)*P(4,3)*Metric(1,6)*Metric(2,5) + P(3,4)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,4)*P(4,6)*Metric(1,6)*Metric(2,5) + P(4,5)*P(5,3)*Metric(1,3)*Metric(2,6) + P(4,3)*P(5,4)*Metric(1,3)*Metric(2,6) + P(4,6)*P(5,4)*Metric(1,3)*Metric(2,6) + P(4,5)*P(5,6)*Metric(1,3)*Metric(2,6) + P(3,4)*P(5,3)*Metric(1,4)*Metric(2,6) + P(3,6)*P(5,3)*Metric(1,4)*Metric(2,6) + P(3,5)*P(5,4)*Metric(1,4)*Metric(2,6) + P(3,5)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,5)*P(4,3)*Metric(1,5)*Metric(2,6) + P(3,6)*P(4,3)*Metric(1,5)*Metric(2,6) + P(3,4)*P(4,5)*Metric(1,5)*Metric(2,6) + P(3,4)*P(4,6)*Metric(1,5)*Metric(2,6) + 2*P(5,4)*P(6,3)*Metric(1,2)*Metric(3,4) - 2*P(5,6)*P(6,3)*Metric(1,2)*Metric(3,4) + 2*P(5,3)*P(6,4)*Metric(1,2)*Metric(3,4) - 2*P(5,6)*P(6,4)*Metric(1,2)*Metric(3,4) - 2*P(5,3)*P(6,5)*Metric(1,2)*Metric(3,4) - 2*P(5,4)*P(6,5)*Metric(1,2)*Metric(3,4) - P(2,4)*P(6,3)*Metric(1,5)*Metric(3,4) + P(2,6)*P(6,3)*Metric(1,5)*Metric(3,4) - P(2,3)*P(6,4)*Metric(1,5)*Metric(3,4) + P(2,6)*P(6,4)*Metric(1,5)*Metric(3,4) - 2*P(2,6)*P(6,5)*Metric(1,5)*Metric(3,4) - P(2,4)*P(5,3)*Metric(1,6)*Metric(3,4) + P(2,5)*P(5,3)*Metric(1,6)*Metric(3,4) - P(2,3)*P(5,4)*Metric(1,6)*Metric(3,4) + P(2,5)*P(5,4)*Metric(1,6)*Metric(3,4) - 2*P(2,5)*P(5,6)*Metric(1,6)*Metric(3,4) - P(1,4)*P(6,3)*Metric(2,5)*Metric(3,4) + P(1,6)*P(6,3)*Metric(2,5)*Metric(3,4) - P(1,3)*P(6,4)*Metric(2,5)*Metric(3,4) + P(1,6)*P(6,4)*Metric(2,5)*Metric(3,4) - 2*P(1,6)*P(6,5)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + 2*P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(1,4)*P(5,3)*Metric(2,6)*Metric(3,4) + P(1,5)*P(5,3)*Metric(2,6)*Metric(3,4) - P(1,3)*P(5,4)*Metric(2,6)*Metric(3,4) + P(1,5)*P(5,4)*Metric(2,6)*Metric(3,4) - 2*P(1,5)*P(5,6)*Metric(2,6)*Metric(3,4) - P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(4,5)*P(6,3)*Metric(1,2)*Metric(3,5) - 2*P(4,6)*P(6,3)*Metric(1,2)*Metric(3,5) - 2*P(4,3)*P(6,4)*Metric(1,2)*Metric(3,5) - 2*P(4,5)*P(6,4)*Metric(1,2)*Metric(3,5) + 2*P(4,3)*P(6,5)*Metric(1,2)*Metric(3,5) - 2*P(4,6)*P(6,5)*Metric(1,2)*Metric(3,5) - P(2,5)*P(6,3)*Metric(1,4)*Metric(3,5) + P(2,6)*P(6,3)*Metric(1,4)*Metric(3,5) - 2*P(2,6)*P(6,4)*Metric(1,4)*Metric(3,5) - P(2,3)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,6)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,4)*P(4,3)*Metric(1,6)*Metric(3,5) - P(2,5)*P(4,3)*Metric(1,6)*Metric(3,5) - P(2,3)*P(4,5)*Metric(1,6)*Metric(3,5) + P(2,4)*P(4,5)*Metric(1,6)*Metric(3,5) - 2*P(2,4)*P(4,6)*Metric(1,6)*Metric(3,5) - P(1,5)*P(6,3)*Metric(2,4)*Metric(3,5) + P(1,6)*P(6,3)*Metric(2,4)*Metric(3,5) - 2*P(1,6)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,5)*Metric(2,4)*Metric(3,5) + P(1,6)*P(6,5)*Metric(2,4)*Metric(3,5) - P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) + 2*P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(1,4)*P(4,3)*Metric(2,6)*Metric(3,5) - P(1,5)*P(4,3)*Metric(2,6)*Metric(3,5) - P(1,3)*P(4,5)*Metric(2,6)*Metric(3,5) + P(1,4)*P(4,5)*Metric(2,6)*Metric(3,5) - 2*P(1,4)*P(4,6)*Metric(2,6)*Metric(3,5) - P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 2*P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) - 2*P(4,5)*P(5,3)*Metric(1,2)*Metric(3,6) + 2*P(4,6)*P(5,3)*Metric(1,2)*Metric(3,6) - 2*P(4,3)*P(5,4)*Metric(1,2)*Metric(3,6) - 2*P(4,6)*P(5,4)*Metric(1,2)*Metric(3,6) + 2*P(4,3)*P(5,6)*Metric(1,2)*Metric(3,6) - 2*P(4,5)*P(5,6)*Metric(1,2)*Metric(3,6) + P(2,5)*P(5,3)*Metric(1,4)*Metric(3,6) - P(2,6)*P(5,3)*Metric(1,4)*Metric(3,6) - 2*P(2,5)*P(5,4)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,6)*Metric(1,4)*Metric(3,6) + P(2,5)*P(5,6)*Metric(1,4)*Metric(3,6) + P(2,4)*P(4,3)*Metric(1,5)*Metric(3,6) - P(2,6)*P(4,3)*Metric(1,5)*Metric(3,6) - 2*P(2,4)*P(4,5)*Metric(1,5)*Metric(3,6) - P(2,3)*P(4,6)*Metric(1,5)*Metric(3,6) + P(2,4)*P(4,6)*Metric(1,5)*Metric(3,6) + P(1,5)*P(5,3)*Metric(2,4)*Metric(3,6) - P(1,6)*P(5,3)*Metric(2,4)*Metric(3,6) - 2*P(1,5)*P(5,4)*Metric(2,4)*Metric(3,6) - P(1,3)*P(5,6)*Metric(2,4)*Metric(3,6) + P(1,5)*P(5,6)*Metric(2,4)*Metric(3,6) - P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) + 2*P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(1,4)*P(4,3)*Metric(2,5)*Metric(3,6) - P(1,6)*P(4,3)*Metric(2,5)*Metric(3,6) - 2*P(1,4)*P(4,5)*Metric(2,5)*Metric(3,6) - P(1,3)*P(4,6)*Metric(2,5)*Metric(3,6) + P(1,4)*P(4,6)*Metric(2,5)*Metric(3,6) - P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 2*P(3,4)*P(6,3)*Metric(1,2)*Metric(4,5) - 2*P(3,5)*P(6,3)*Metric(1,2)*Metric(4,5) + 2*P(3,5)*P(6,4)*Metric(1,2)*Metric(4,5) - 2*P(3,6)*P(6,4)*Metric(1,2)*Metric(4,5) + 2*P(3,4)*P(6,5)*Metric(1,2)*Metric(4,5) - 2*P(3,6)*P(6,5)*Metric(1,2)*Metric(4,5) - 2*P(2,6)*P(6,3)*Metric(1,3)*Metric(4,5) - P(2,5)*P(6,4)*Metric(1,3)*Metric(4,5) + P(2,6)*P(6,4)*Metric(1,3)*Metric(4,5) - P(2,4)*P(6,5)*Metric(1,3)*Metric(4,5) + P(2,6)*P(6,5)*Metric(1,3)*Metric(4,5) + P(2,3)*P(3,4)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,4)*Metric(1,6)*Metric(4,5) + P(2,3)*P(3,5)*Metric(1,6)*Metric(4,5) - P(2,4)*P(3,5)*Metric(1,6)*Metric(4,5) - 2*P(2,3)*P(3,6)*Metric(1,6)*Metric(4,5) - 2*P(1,6)*P(6,3)*Metric(2,3)*Metric(4,5) - P(1,5)*P(6,4)*Metric(2,3)*Metric(4,5) + P(1,6)*P(6,4)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,5)*Metric(2,3)*Metric(4,5) + P(1,6)*P(6,5)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(-1,3)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,4)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(-1,5)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(1,3)*P(3,4)*Metric(2,6)*Metric(4,5) - P(1,5)*P(3,4)*Metric(2,6)*Metric(4,5) + P(1,3)*P(3,5)*Metric(2,6)*Metric(4,5) - P(1,4)*P(3,5)*Metric(2,6)*Metric(4,5) - 2*P(1,3)*P(3,6)*Metric(2,6)*Metric(4,5) - P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(1,6)*P(2,3)*Metric(3,6)*Metric(4,5) + 2*P(1,5)*P(2,4)*Metric(3,6)*Metric(4,5) + 2*P(1,4)*P(2,5)*Metric(3,6)*Metric(4,5) + 2*P(1,3)*P(2,6)*Metric(3,6)*Metric(4,5) + 2*P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(3,4)*P(5,3)*Metric(1,2)*Metric(4,6) - 2*P(3,6)*P(5,3)*Metric(1,2)*Metric(4,6) - 2*P(3,5)*P(5,4)*Metric(1,2)*Metric(4,6) + 2*P(3,6)*P(5,4)*Metric(1,2)*Metric(4,6) + 2*P(3,4)*P(5,6)*Metric(1,2)*Metric(4,6) - 2*P(3,5)*P(5,6)*Metric(1,2)*Metric(4,6) - 2*P(2,5)*P(5,3)*Metric(1,3)*Metric(4,6) + P(2,5)*P(5,4)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,4)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,6)*Metric(1,3)*Metric(4,6) + P(2,5)*P(5,6)*Metric(1,3)*Metric(4,6) + P(2,3)*P(3,4)*Metric(1,5)*Metric(4,6) - P(2,6)*P(3,4)*Metric(1,5)*Metric(4,6) - 2*P(2,3)*P(3,5)*Metric(1,5)*Metric(4,6) + P(2,3)*P(3,6)*Metric(1,5)*Metric(4,6) - P(2,4)*P(3,6)*Metric(1,5)*Metric(4,6) - 2*P(1,5)*P(5,3)*Metric(2,3)*Metric(4,6) + P(1,5)*P(5,4)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,4)*Metric(2,3)*Metric(4,6) - P(1,4)*P(5,6)*Metric(2,3)*Metric(4,6) + P(1,5)*P(5,6)*Metric(2,3)*Metric(4,6) - P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,3)*Metric(4,6) + 2*P(-1,3)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,4)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(-1,5)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(1,3)*P(3,4)*Metric(2,5)*Metric(4,6) - P(1,6)*P(3,4)*Metric(2,5)*Metric(4,6) - 2*P(1,3)*P(3,5)*Metric(2,5)*Metric(4,6) + P(1,3)*P(3,6)*Metric(2,5)*Metric(4,6) - P(1,4)*P(3,6)*Metric(2,5)*Metric(4,6) - P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(1,5)*P(2,3)*Metric(3,5)*Metric(4,6) + 2*P(1,6)*P(2,4)*Metric(3,5)*Metric(4,6) + 2*P(1,3)*P(2,5)*Metric(3,5)*Metric(4,6) + 2*P(1,4)*P(2,6)*Metric(3,5)*Metric(4,6) + 2*P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(3,5)*P(4,3)*Metric(1,2)*Metric(5,6) - 2*P(3,6)*P(4,3)*Metric(1,2)*Metric(5,6) - 2*P(3,4)*P(4,5)*Metric(1,2)*Metric(5,6) + 2*P(3,6)*P(4,5)*Metric(1,2)*Metric(5,6) - 2*P(3,4)*P(4,6)*Metric(1,2)*Metric(5,6) + 2*P(3,5)*P(4,6)*Metric(1,2)*Metric(5,6) - 2*P(2,4)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,4)*P(4,5)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,5)*Metric(1,3)*Metric(5,6) + P(2,4)*P(4,6)*Metric(1,3)*Metric(5,6) - P(2,5)*P(4,6)*Metric(1,3)*Metric(5,6) - 2*P(2,3)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,3)*P(3,5)*Metric(1,4)*Metric(5,6) - P(2,6)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,3)*P(3,6)*Metric(1,4)*Metric(5,6) - P(2,5)*P(3,6)*Metric(1,4)*Metric(5,6) - 2*P(1,4)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,4)*P(4,5)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,5)*Metric(2,3)*Metric(5,6) + P(1,4)*P(4,6)*Metric(2,3)*Metric(5,6) - P(1,5)*P(4,6)*Metric(2,3)*Metric(5,6) + 2*P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(1,3)*P(3,4)*Metric(2,4)*Metric(5,6) + P(1,3)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,6)*P(3,5)*Metric(2,4)*Metric(5,6) + P(1,3)*P(3,6)*Metric(2,4)*Metric(5,6) - P(1,5)*P(3,6)*Metric(2,4)*Metric(5,6) + 2*P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + 2*P(1,4)*P(2,3)*Metric(3,4)*Metric(5,6) + 2*P(1,3)*P(2,4)*Metric(3,4)*Metric(5,6) + 2*P(1,6)*P(2,5)*Metric(3,4)*Metric(5,6) + 2*P(1,5)*P(2,6)*Metric(3,4)*Metric(5,6) + 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

