# This file was automatically created by FeynRules 2.3.14
# Mathematica version: 9.0 for Mac OS X x86 (64-bit) (November 20, 2012)
# Date: Thu 31 Aug 2017 20:35:21


from object_library import all_lorentz, Lorentz

from function_library import complexconjugate, re, im, csc, sec, acsc, asec, cot
try:
   import form_factors as ForFac 
except ImportError:
   pass


UUV7 = Lorentz(name = 'UUV7',
               spins = [ -1, -1, 3 ],
               structure = 'P(3,2) + P(3,3)')

SSS7 = Lorentz(name = 'SSS7',
               spins = [ 1, 1, 1 ],
               structure = '1')

FFS7 = Lorentz(name = 'FFS7',
               spins = [ 2, 2, 1 ],
               structure = 'ProjM(2,1) + ProjP(2,1)')

FFV29 = Lorentz(name = 'FFV29',
                spins = [ 2, 2, 3 ],
                structure = 'Gamma(3,2,1)')

FFV30 = Lorentz(name = 'FFV30',
                spins = [ 2, 2, 3 ],
                structure = 'Gamma(3,2,-1)*ProjM(-1,1)')

FFV31 = Lorentz(name = 'FFV31',
                spins = [ 2, 2, 3 ],
                structure = 'Gamma(3,2,-1)*ProjM(-1,1) - 2*Gamma(3,2,-1)*ProjP(-1,1)')

FFV32 = Lorentz(name = 'FFV32',
                spins = [ 2, 2, 3 ],
                structure = 'Gamma(3,2,-1)*ProjM(-1,1) + 2*Gamma(3,2,-1)*ProjP(-1,1)')

FFV33 = Lorentz(name = 'FFV33',
                spins = [ 2, 2, 3 ],
                structure = 'Gamma(3,2,-1)*ProjM(-1,1) + 4*Gamma(3,2,-1)*ProjP(-1,1)')

VVS7 = Lorentz(name = 'VVS7',
               spins = [ 3, 3, 1 ],
               structure = 'Metric(1,2)')

VVV7 = Lorentz(name = 'VVV7',
               spins = [ 3, 3, 3 ],
               structure = 'P(3,1)*Metric(1,2) - P(3,2)*Metric(1,2) - P(2,1)*Metric(1,3) + P(2,3)*Metric(1,3) + P(1,2)*Metric(2,3) - P(1,3)*Metric(2,3)')

SSSS8 = Lorentz(name = 'SSSS8',
                spins = [ 1, 1, 1, 1 ],
                structure = '1')

VVSS15 = Lorentz(name = 'VVSS15',
                 spins = [ 3, 3, 1, 1 ],
                 structure = 'Metric(1,2)')

VVSS16 = Lorentz(name = 'VVSS16',
                 spins = [ 3, 3, 1, 1 ],
                 structure = '-(P(-1,2)*P(-1,4)*P(1,3)*P(2,1)) - P(-1,2)*P(-1,3)*P(1,4)*P(2,1) - P(-1,1)*P(-1,4)*P(1,2)*P(2,3) + P(-1,1)*P(-1,2)*P(1,4)*P(2,3) - P(-1,1)*P(-1,3)*P(1,2)*P(2,4) + P(-1,1)*P(-1,2)*P(1,3)*P(2,4) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,2) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,2)')

VVVS4 = Lorentz(name = 'VVVS4',
                spins = [ 3, 3, 3, 1 ],
                structure = 'P(1,4)*P(2,3)*P(3,1) - P(1,2)*P(2,4)*P(3,1) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)')

VVVS5 = Lorentz(name = 'VVVS5',
                spins = [ 3, 3, 3, 1 ],
                structure = 'P(1,4)*P(2,3)*P(3,1) - P(1,2)*P(2,4)*P(3,1) + P(1,4)*P(2,1)*P(3,2) - P(1,3)*P(2,1)*P(3,4) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) - P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2) + P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)')

VVVS6 = Lorentz(name = 'VVVS6',
                spins = [ 3, 3, 3, 1 ],
                structure = 'P(1,4)*P(2,3)*P(3,1) - P(1,2)*P(2,3)*P(3,4) - P(-1,3)*P(-1,4)*P(3,2)*Metric(1,2) + P(-1,2)*P(-1,3)*P(3,4)*Metric(1,2) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) + P(-1,3)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3)')

VVVV62 = Lorentz(name = 'VVVV62',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) - Metric(1,3)*Metric(2,4)')

VVVV63 = Lorentz(name = 'VVVV63',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)')

VVVV64 = Lorentz(name = 'VVVV64',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,1)*P(4,2)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) - P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) + P(1,4)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4)')

VVVV65 = Lorentz(name = 'VVVV65',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) + Metric(1,3)*Metric(2,4) - 2*Metric(1,2)*Metric(3,4)')

VVVV66 = Lorentz(name = 'VVVV66',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) - Metric(1,2)*Metric(3,4)')

VVVV67 = Lorentz(name = 'VVVV67',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,3)*Metric(2,4) - Metric(1,2)*Metric(3,4)')

VVVV68 = Lorentz(name = 'VVVV68',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) - (Metric(1,3)*Metric(2,4))/2. - (Metric(1,2)*Metric(3,4))/2.')

VVVV69 = Lorentz(name = 'VVVV69',
                 spins = [ 3, 3, 3, 3 ],
                 structure = '-(P(3,4)*P(4,1)*Metric(1,2)) + P(3,1)*P(4,2)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(1,4)*P(2,1)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV70 = Lorentz(name = 'VVVV70',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV71 = Lorentz(name = 'VVVV71',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,4)*P(4,2)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) - P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) + P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) + P(1,3)*P(4,1)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(1,4)*P(3,1)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,2)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV72 = Lorentz(name = 'VVVV72',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,4)*P(4,2)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) - P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) + P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) + P(1,3)*P(4,1)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) - P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(1,4)*P(3,1)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) + P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVV73 = Lorentz(name = 'VVVV73',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,4)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) - P(3,2)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,4)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(1,3)*P(4,2)*Metric(2,3) - P(1,4)*P(4,2)*Metric(2,3) + P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) - P(1,3)*P(3,2)*Metric(2,4) + P(1,4)*P(3,2)*Metric(2,4) + P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) - P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) - P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVSS6 = Lorentz(name = 'VVVSS6',
                 spins = [ 3, 3, 3, 1, 1 ],
                 structure = 'P(1,4)*P(2,3)*P(3,1) + P(1,5)*P(2,3)*P(3,1) - P(1,2)*P(2,4)*P(3,1) - P(1,5)*P(2,4)*P(3,1) - P(1,2)*P(2,5)*P(3,1) - P(1,4)*P(2,5)*P(3,1) + P(1,5)*P(2,1)*P(3,4) + P(1,4)*P(2,1)*P(3,5) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,5)*P(3,4)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,5)*Metric(1,2) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,5)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3) + P(-1,1)*P(-1,4)*P(2,5)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) + P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3)')

VVVSS7 = Lorentz(name = 'VVVSS7',
                 spins = [ 3, 3, 3, 1, 1 ],
                 structure = 'P(1,4)*P(2,3)*P(3,1) + P(1,5)*P(2,3)*P(3,1) - P(1,2)*P(2,4)*P(3,1) - P(1,2)*P(2,5)*P(3,1) + P(1,4)*P(2,1)*P(3,2) + P(1,5)*P(2,1)*P(3,2) - P(1,3)*P(2,1)*P(3,4) - P(1,3)*P(2,1)*P(3,5) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,2) - P(-1,3)*P(-1,4)*P(3,1)*Metric(1,2) + P(-1,2)*P(-1,5)*P(3,1)*Metric(1,2) - P(-1,3)*P(-1,5)*P(3,1)*Metric(1,2) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,1)*P(-1,5)*P(3,2)*Metric(1,2) + P(-1,1)*P(-1,3)*P(3,4)*Metric(1,2) + P(-1,1)*P(-1,3)*P(3,5)*Metric(1,2) - P(-1,2)*P(-1,4)*P(2,1)*Metric(1,3) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,3) - P(-1,2)*P(-1,5)*P(2,1)*Metric(1,3) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,4)*Metric(1,3) + P(-1,1)*P(-1,2)*P(2,5)*Metric(1,3) + P(-1,1)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,1)*P(-1,5)*P(1,2)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) + P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,4)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3) - P(-1,1)*P(-1,2)*P(1,5)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3)')

VVVSS8 = Lorentz(name = 'VVVSS8',
                 spins = [ 3, 3, 3, 1, 1 ],
                 structure = 'P(1,4)*P(2,3)*P(3,1) + P(1,5)*P(2,3)*P(3,1) - P(1,2)*P(2,3)*P(3,4) + P(1,5)*P(2,3)*P(3,4) - P(1,3)*P(2,5)*P(3,4) - P(1,2)*P(2,3)*P(3,5) + P(1,4)*P(2,3)*P(3,5) - P(1,3)*P(2,4)*P(3,5) - P(-1,3)*P(-1,4)*P(3,2)*Metric(1,2) - P(-1,3)*P(-1,5)*P(3,2)*Metric(1,2) + P(-1,2)*P(-1,3)*P(3,4)*Metric(1,2) + P(-1,2)*P(-1,3)*P(3,5)*Metric(1,2) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,3) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,3) + P(-1,3)*P(-1,5)*P(2,4)*Metric(1,3) + P(-1,3)*P(-1,4)*P(2,5)*Metric(1,3) + P(-1,3)*P(-1,4)*P(1,2)*Metric(2,3) + P(-1,3)*P(-1,5)*P(1,2)*Metric(2,3) + P(-1,1)*P(-1,4)*P(1,3)*Metric(2,3) + P(-1,1)*P(-1,5)*P(1,3)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,4)*Metric(2,3) - P(-1,3)*P(-1,5)*P(1,4)*Metric(2,3) - P(-1,1)*P(-1,3)*P(1,5)*Metric(2,3) - P(-1,3)*P(-1,4)*P(1,5)*Metric(2,3)')

VVVVS34 = Lorentz(name = 'VVVVS34',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)')

VVVVS35 = Lorentz(name = 'VVVVS35',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVS36 = Lorentz(name = 'VVVVS36',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,4)*P(4,2)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) - P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) - (P(2,5)*P(4,3)*Metric(1,3))/2. + (P(2,4)*P(4,5)*Metric(1,3))/2. + P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) - (P(2,5)*P(3,4)*Metric(1,4))/2. + (P(2,3)*P(3,5)*Metric(1,4))/2. + P(1,3)*P(4,1)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) + (P(1,5)*P(4,3)*Metric(2,3))/2. - (P(1,4)*P(4,5)*Metric(2,3))/2. - P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - (P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + P(1,4)*P(3,1)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) + (P(1,5)*P(3,4)*Metric(2,4))/2. - (P(1,3)*P(3,5)*Metric(2,4))/2. - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + (P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. - (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + P(1,2)*P(2,3)*Metric(3,4) - (P(1,5)*P(2,3)*Metric(3,4))/2. + P(1,2)*P(2,4)*Metric(3,4) - (P(1,5)*P(2,4)*Metric(3,4))/2. + (P(1,3)*P(2,5)*Metric(3,4))/2. + (P(1,4)*P(2,5)*Metric(3,4))/2. - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVS37 = Lorentz(name = 'VVVVS37',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,4)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) - P(3,2)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,4)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(1,3)*P(4,2)*Metric(2,3) - P(1,4)*P(4,2)*Metric(2,3) + P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) - P(1,3)*P(3,2)*Metric(2,4) + P(1,4)*P(3,2)*Metric(2,4) + P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) - P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) - P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVS38 = Lorentz(name = 'VVVVS38',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = '(P(3,5)*P(4,1)*Metric(1,2))/2. + P(3,1)*P(4,2)*Metric(1,2) - P(3,1)*P(4,5)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) - (3*P(2,5)*P(4,1)*Metric(1,3))/2. - P(2,1)*P(4,2)*Metric(1,3) + P(2,1)*P(4,5)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) + (3*P(2,5)*P(3,1)*Metric(1,4))/2. - (P(2,1)*P(3,5)*Metric(1,4))/2. - P(1,3)*P(4,1)*Metric(2,3) - P(1,5)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) + P(1,4)*P(3,1)*Metric(2,4) + (P(1,5)*P(3,1)*Metric(2,4))/2. + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(1,5)*P(2,1)*Metric(3,4))/2. - (P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4))/2.')

VVVVS39 = Lorentz(name = 'VVVVS39',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,5)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,5)*P(4,2)*Metric(1,2) + P(2,5)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,5)*P(4,2)*Metric(1,3) - P(2,5)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) + P(2,1)*P(3,5)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,5)*P(4,1)*Metric(2,3) + P(1,5)*P(4,2)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,5)*P(3,2)*Metric(2,4) + P(1,2)*P(3,5)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(1,5)*P(2,1)*Metric(3,4) + P(1,2)*P(2,5)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVS40 = Lorentz(name = 'VVVVS40',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = 'P(3,4)*P(4,2)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) + P(3,5)*P(4,3)*Metric(1,2) + P(3,4)*P(4,5)*Metric(1,2) - P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - (P(2,5)*P(4,3)*Metric(1,3))/2. + P(2,3)*P(4,5)*Metric(1,3) - (P(2,4)*P(4,5)*Metric(1,3))/2. + P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - (P(2,5)*P(3,4)*Metric(1,4))/2. - (P(2,3)*P(3,5)*Metric(1,4))/2. + P(2,4)*P(3,5)*Metric(1,4) + P(1,3)*P(4,1)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) + (3*P(1,5)*P(4,3)*Metric(2,3))/2. - P(1,3)*P(4,5)*Metric(2,3) - (P(1,4)*P(4,5)*Metric(2,3))/2. - P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) + (P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + P(1,4)*P(3,1)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) + (3*P(1,5)*P(3,4)*Metric(2,4))/2. - (P(1,3)*P(3,5)*Metric(2,4))/2. - P(1,4)*P(3,5)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) + (P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) - (3*P(1,5)*P(2,3)*Metric(3,4))/2. + P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) - (3*P(1,5)*P(2,4)*Metric(3,4))/2. + (P(1,3)*P(2,5)*Metric(3,4))/2. + (P(1,4)*P(2,5)*Metric(3,4))/2. - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVS41 = Lorentz(name = 'VVVVS41',
                  spins = [ 3, 3, 3, 3, 1 ],
                  structure = '-(P(3,4)*P(4,1)*Metric(1,2)) + (P(3,5)*P(4,1)*Metric(1,2))/2. + P(3,1)*P(4,2)*Metric(1,2) - P(3,4)*P(4,5)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - (P(2,5)*P(4,1)*Metric(1,3))/2. - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + (P(2,5)*P(3,1)*Metric(1,4))/2. + P(2,1)*P(3,4)*Metric(1,4) - P(2,5)*P(3,4)*Metric(1,4) - (P(2,1)*P(3,5)*Metric(1,4))/2. - P(1,3)*P(4,1)*Metric(2,3) + P(1,4)*P(4,5)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - (P(1,5)*P(3,1)*Metric(2,4))/2. + P(1,5)*P(3,4)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. - P(1,4)*P(2,1)*Metric(3,4) + (P(1,5)*P(2,1)*Metric(3,4))/2. - P(1,5)*P(2,4)*Metric(3,4) + P(1,4)*P(2,5)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - (P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4))/2. + P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4)')

VVVVV18 = Lorentz(name = 'VVVVV18',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5)')

VVVVV19 = Lorentz(name = 'VVVVV19',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) - P(4,2)*Metric(1,5)*Metric(2,3) + P(5,2)*Metric(1,3)*Metric(2,4) + P(3,2)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) - P(4,2)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5)')

VVVVV20 = Lorentz(name = 'VVVVV20',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) + 4*P(3,1)*Metric(1,2)*Metric(4,5) - 4*P(2,1)*Metric(1,3)*Metric(4,5)')

VVVVV21 = Lorentz(name = 'VVVVV21',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(4,5)*Metric(1,5)*Metric(2,3) + P(3,5)*Metric(1,5)*Metric(2,4) + P(4,5)*Metric(1,3)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,5)*Metric(1,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) - P(2,5)*Metric(1,3)*Metric(4,5) - P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV22 = Lorentz(name = 'VVVVV22',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,4)*Metric(1,4)*Metric(2,3) + P(4,5)*Metric(1,5)*Metric(2,3) - (P(5,1)*Metric(1,3)*Metric(2,4))/2. + (P(3,1)*Metric(1,5)*Metric(2,4))/2. + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - (P(4,1)*Metric(1,3)*Metric(2,5))/2. + (P(3,1)*Metric(1,4)*Metric(2,5))/2. - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) + (P(5,1)*Metric(1,2)*Metric(3,4))/2. - P(5,4)*Metric(1,2)*Metric(3,4) - (P(2,1)*Metric(1,5)*Metric(3,4))/2. - P(2,4)*Metric(1,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) + (P(4,1)*Metric(1,2)*Metric(3,5))/2. - P(4,5)*Metric(1,2)*Metric(3,5) - (P(2,1)*Metric(1,4)*Metric(3,5))/2. - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + P(3,4)*Metric(1,2)*Metric(4,5) + P(3,5)*Metric(1,2)*Metric(4,5) - P(1,4)*Metric(2,3)*Metric(4,5) - P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV23 = Lorentz(name = 'VVVVV23',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,4)*Metric(1,4)*Metric(2,3) + P(4,5)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(5,4)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(4,5)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - 2*P(3,1)*Metric(1,2)*Metric(4,5) + P(3,4)*Metric(1,2)*Metric(4,5) + P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(2,1)*Metric(1,3)*Metric(4,5) - P(1,4)*Metric(2,3)*Metric(4,5) - P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV24 = Lorentz(name = 'VVVVV24',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV25 = Lorentz(name = 'VVVVV25',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 4*P(2,5)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 4*P(1,5)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) + 4*P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - 4*P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + 4*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 4*P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV26 = Lorentz(name = 'VVVVV26',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 2*P(2,5)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 2*P(1,5)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - 2*P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVSS36 = Lorentz(name = 'VVVVSS36',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(2,1)*P(4,2)*Metric(1,3) - P(2,1)*P(3,2)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4)')

VVVVSS37 = Lorentz(name = 'VVVVSS37',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVSS38 = Lorentz(name = 'VVVVSS38',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,4)*P(4,2)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) - P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) - (P(2,5)*P(4,3)*Metric(1,3))/2. - (P(2,6)*P(4,3)*Metric(1,3))/2. + (P(2,4)*P(4,5)*Metric(1,3))/2. + (P(2,4)*P(4,6)*Metric(1,3))/2. + P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) - (P(2,5)*P(3,4)*Metric(1,4))/2. - (P(2,6)*P(3,4)*Metric(1,4))/2. + (P(2,3)*P(3,5)*Metric(1,4))/2. + (P(2,3)*P(3,6)*Metric(1,4))/2. + P(1,3)*P(4,1)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) + (P(1,5)*P(4,3)*Metric(2,3))/2. + (P(1,6)*P(4,3)*Metric(2,3))/2. - (P(1,4)*P(4,5)*Metric(2,3))/2. - (P(1,4)*P(4,6)*Metric(2,3))/2. - P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - (P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. - (P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. + (P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. + P(1,4)*P(3,1)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) + (P(1,5)*P(3,4)*Metric(2,4))/2. + (P(1,6)*P(3,4)*Metric(2,4))/2. - (P(1,3)*P(3,5)*Metric(2,4))/2. - (P(1,3)*P(3,6)*Metric(2,4))/2. - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + (P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. - (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. - (P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + P(1,2)*P(2,3)*Metric(3,4) - (P(1,5)*P(2,3)*Metric(3,4))/2. - (P(1,6)*P(2,3)*Metric(3,4))/2. + P(1,2)*P(2,4)*Metric(3,4) - (P(1,5)*P(2,4)*Metric(3,4))/2. - (P(1,6)*P(2,4)*Metric(3,4))/2. + (P(1,3)*P(2,5)*Metric(3,4))/2. + (P(1,4)*P(2,5)*Metric(3,4))/2. + (P(1,3)*P(2,6)*Metric(3,4))/2. + (P(1,4)*P(2,6)*Metric(3,4))/2. - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVSS39 = Lorentz(name = 'VVVVSS39',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,4)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,4)*P(4,2)*Metric(1,2) - P(3,1)*P(4,3)*Metric(1,2) - P(3,2)*P(4,3)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - P(2,4)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(4,2)*Metric(1,3) + P(2,1)*P(4,3)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + P(2,4)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) - P(2,4)*P(3,2)*Metric(1,4) + P(2,1)*P(3,4)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,3)*P(4,1)*Metric(2,3) + P(1,3)*P(4,2)*Metric(2,3) - P(1,4)*P(4,2)*Metric(2,3) + P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,2)*P(-1,4)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,4)*P(3,1)*Metric(2,4) - P(1,3)*P(3,2)*Metric(2,4) + P(1,4)*P(3,2)*Metric(2,4) + P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) - P(1,3)*P(2,1)*Metric(3,4) - P(1,4)*P(2,1)*Metric(3,4) - P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) - P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) + P(-1,1)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) + P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4)')

VVVVSS40 = Lorentz(name = 'VVVVSS40',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = '(P(3,5)*P(4,1)*Metric(1,2))/2. + (P(3,6)*P(4,1)*Metric(1,2))/2. + P(3,1)*P(4,2)*Metric(1,2) - P(3,1)*P(4,5)*Metric(1,2) - P(3,1)*P(4,6)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) - (3*P(2,5)*P(4,1)*Metric(1,3))/2. - (3*P(2,6)*P(4,1)*Metric(1,3))/2. - P(2,1)*P(4,2)*Metric(1,3) + P(2,1)*P(4,5)*Metric(1,3) + P(2,1)*P(4,6)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) + (3*P(2,5)*P(3,1)*Metric(1,4))/2. + (3*P(2,6)*P(3,1)*Metric(1,4))/2. - (P(2,1)*P(3,5)*Metric(1,4))/2. - (P(2,1)*P(3,6)*Metric(1,4))/2. - P(1,3)*P(4,1)*Metric(2,3) - P(1,5)*P(4,1)*Metric(2,3) - P(1,6)*P(4,1)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) + P(1,4)*P(3,1)*Metric(2,4) + (P(1,5)*P(3,1)*Metric(2,4))/2. + (P(1,6)*P(3,1)*Metric(2,4))/2. + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) - (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. - (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + (P(1,5)*P(2,1)*Metric(3,4))/2. + (P(1,6)*P(2,1)*Metric(3,4))/2. - (P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4))/2. - (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4))/2.')

VVVVSS41 = Lorentz(name = 'VVVVSS41',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,2)*P(4,1)*Metric(1,2) - P(3,5)*P(4,1)*Metric(1,2) - P(3,6)*P(4,1)*Metric(1,2) + P(3,1)*P(4,2)*Metric(1,2) - P(3,5)*P(4,2)*Metric(1,2) - P(3,6)*P(4,2)*Metric(1,2) + P(2,5)*P(4,1)*Metric(1,3) + P(2,6)*P(4,1)*Metric(1,3) - P(2,1)*P(4,2)*Metric(1,3) - P(2,5)*P(4,2)*Metric(1,3) - P(2,6)*P(4,2)*Metric(1,3) - P(2,5)*P(3,1)*Metric(1,4) - P(2,6)*P(3,1)*Metric(1,4) - P(2,1)*P(3,2)*Metric(1,4) + P(2,1)*P(3,5)*Metric(1,4) + P(2,1)*P(3,6)*Metric(1,4) - P(1,2)*P(4,1)*Metric(2,3) - P(1,5)*P(4,1)*Metric(2,3) - P(1,6)*P(4,1)*Metric(2,3) + P(1,5)*P(4,2)*Metric(2,3) + P(1,6)*P(4,2)*Metric(2,3) + P(-1,1)*P(-1,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,6)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - P(1,5)*P(3,2)*Metric(2,4) - P(1,6)*P(3,2)*Metric(2,4) + P(1,2)*P(3,5)*Metric(2,4) + P(1,2)*P(3,6)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,4) + P(1,5)*P(2,1)*Metric(3,4) + P(1,6)*P(2,1)*Metric(3,4) + P(1,2)*P(2,5)*Metric(3,4) + P(1,2)*P(2,6)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS42 = Lorentz(name = 'VVVVSS42',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = 'P(3,4)*P(4,2)*Metric(1,2) + P(3,2)*P(4,3)*Metric(1,2) + P(3,5)*P(4,3)*Metric(1,2) + P(3,6)*P(4,3)*Metric(1,2) + P(3,4)*P(4,5)*Metric(1,2) + P(3,4)*P(4,6)*Metric(1,2) - P(2,3)*P(4,1)*Metric(1,3) + P(2,4)*P(4,1)*Metric(1,3) - P(2,4)*P(4,3)*Metric(1,3) - (P(2,5)*P(4,3)*Metric(1,3))/2. - (P(2,6)*P(4,3)*Metric(1,3))/2. + P(2,3)*P(4,5)*Metric(1,3) - (P(2,4)*P(4,5)*Metric(1,3))/2. + P(2,3)*P(4,6)*Metric(1,3) - (P(2,4)*P(4,6)*Metric(1,3))/2. + P(2,3)*P(3,1)*Metric(1,4) - P(2,4)*P(3,1)*Metric(1,4) - P(2,3)*P(3,4)*Metric(1,4) - (P(2,5)*P(3,4)*Metric(1,4))/2. - (P(2,6)*P(3,4)*Metric(1,4))/2. - (P(2,3)*P(3,5)*Metric(1,4))/2. + P(2,4)*P(3,5)*Metric(1,4) - (P(2,3)*P(3,6)*Metric(1,4))/2. + P(2,4)*P(3,6)*Metric(1,4) + P(1,3)*P(4,1)*Metric(2,3) - P(1,2)*P(4,3)*Metric(2,3) - P(1,4)*P(4,3)*Metric(2,3) + (3*P(1,5)*P(4,3)*Metric(2,3))/2. + (3*P(1,6)*P(4,3)*Metric(2,3))/2. - P(1,3)*P(4,5)*Metric(2,3) - (P(1,4)*P(4,5)*Metric(2,3))/2. - P(1,3)*P(4,6)*Metric(2,3) - (P(1,4)*P(4,6)*Metric(2,3))/2. - P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) + P(-1,3)*P(-1,4)*Metric(1,4)*Metric(2,3) + (P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3))/2. + (P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. + (P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3))/2. + P(1,4)*P(3,1)*Metric(2,4) - P(1,2)*P(3,4)*Metric(2,4) - P(1,3)*P(3,4)*Metric(2,4) + (3*P(1,5)*P(3,4)*Metric(2,4))/2. + (3*P(1,6)*P(3,4)*Metric(2,4))/2. - (P(1,3)*P(3,5)*Metric(2,4))/2. - P(1,4)*P(3,5)*Metric(2,4) - (P(1,3)*P(3,6)*Metric(2,4))/2. - P(1,4)*P(3,6)*Metric(2,4) - P(-1,1)*P(-1,4)*Metric(1,3)*Metric(2,4) + P(-1,3)*P(-1,4)*Metric(1,3)*Metric(2,4) + (P(-1,3)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,3)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + (P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. + P(1,2)*P(2,3)*Metric(3,4) + P(1,4)*P(2,3)*Metric(3,4) - (3*P(1,5)*P(2,3)*Metric(3,4))/2. - (3*P(1,6)*P(2,3)*Metric(3,4))/2. + P(1,2)*P(2,4)*Metric(3,4) + P(1,3)*P(2,4)*Metric(3,4) - (3*P(1,5)*P(2,4)*Metric(3,4))/2. - (3*P(1,6)*P(2,4)*Metric(3,4))/2. + (P(1,3)*P(2,5)*Metric(3,4))/2. + (P(1,4)*P(2,5)*Metric(3,4))/2. + (P(1,3)*P(2,6)*Metric(3,4))/2. + (P(1,4)*P(2,6)*Metric(3,4))/2. - P(-1,2)*P(-1,3)*Metric(1,2)*Metric(3,4) - P(-1,2)*P(-1,4)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,4) - P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVSS43 = Lorentz(name = 'VVVVSS43',
                   spins = [ 3, 3, 3, 3, 1, 1 ],
                   structure = '-(P(3,4)*P(4,1)*Metric(1,2)) + (P(3,5)*P(4,1)*Metric(1,2))/2. + (P(3,6)*P(4,1)*Metric(1,2))/2. + P(3,1)*P(4,2)*Metric(1,2) - P(3,4)*P(4,5)*Metric(1,2) - P(3,4)*P(4,6)*Metric(1,2) + P(2,3)*P(4,1)*Metric(1,3) - (P(2,5)*P(4,1)*Metric(1,3))/2. - (P(2,6)*P(4,1)*Metric(1,3))/2. - P(2,1)*P(4,2)*Metric(1,3) - P(2,3)*P(3,1)*Metric(1,4) + (P(2,5)*P(3,1)*Metric(1,4))/2. + (P(2,6)*P(3,1)*Metric(1,4))/2. + P(2,1)*P(3,4)*Metric(1,4) - P(2,5)*P(3,4)*Metric(1,4) - P(2,6)*P(3,4)*Metric(1,4) - (P(2,1)*P(3,5)*Metric(1,4))/2. - (P(2,1)*P(3,6)*Metric(1,4))/2. - P(1,3)*P(4,1)*Metric(2,3) + P(1,4)*P(4,5)*Metric(2,3) + P(1,4)*P(4,6)*Metric(2,3) + P(-1,1)*P(-1,3)*Metric(1,4)*Metric(2,3) - P(-1,4)*P(-1,5)*Metric(1,4)*Metric(2,3) - P(-1,4)*P(-1,6)*Metric(1,4)*Metric(2,3) - P(1,2)*P(3,1)*Metric(2,4) - (P(1,5)*P(3,1)*Metric(2,4))/2. - (P(1,6)*P(3,1)*Metric(2,4))/2. + P(1,5)*P(3,4)*Metric(2,4) + P(1,6)*P(3,4)*Metric(2,4) + P(-1,1)*P(-1,2)*Metric(1,3)*Metric(2,4) + (P(-1,1)*P(-1,5)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,6)*Metric(1,3)*Metric(2,4))/2. - P(1,4)*P(2,1)*Metric(3,4) + (P(1,5)*P(2,1)*Metric(3,4))/2. + (P(1,6)*P(2,1)*Metric(3,4))/2. - P(1,5)*P(2,4)*Metric(3,4) - P(1,6)*P(2,4)*Metric(3,4) + P(1,4)*P(2,5)*Metric(3,4) + P(1,4)*P(2,6)*Metric(3,4) + P(-1,1)*P(-1,4)*Metric(1,2)*Metric(3,4) - (P(-1,1)*P(-1,5)*Metric(1,2)*Metric(3,4))/2. + P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,4) - (P(-1,1)*P(-1,6)*Metric(1,2)*Metric(3,4))/2. + P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,4)')

VVVVVS18 = Lorentz(name = 'VVVVVS18',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5)')

VVVVVS19 = Lorentz(name = 'VVVVVS19',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,1)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) - P(4,2)*Metric(1,5)*Metric(2,3) + P(5,2)*Metric(1,3)*Metric(2,4) + P(3,2)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) - P(4,2)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5)')

VVVVVS20 = Lorentz(name = 'VVVVVS20',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) + 4*P(3,1)*Metric(1,2)*Metric(4,5) - 4*P(2,1)*Metric(1,3)*Metric(4,5)')

VVVVVS21 = Lorentz(name = 'VVVVVS21',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(4,5)*Metric(1,5)*Metric(2,3) + P(3,5)*Metric(1,5)*Metric(2,4) + P(4,5)*Metric(1,3)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,5)*Metric(1,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) - P(2,5)*Metric(1,3)*Metric(4,5) - P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS22 = Lorentz(name = 'VVVVVS22',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,4)*Metric(1,4)*Metric(2,3) + P(4,5)*Metric(1,5)*Metric(2,3) - (P(5,1)*Metric(1,3)*Metric(2,4))/2. + (P(3,1)*Metric(1,5)*Metric(2,4))/2. + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - (P(4,1)*Metric(1,3)*Metric(2,5))/2. + (P(3,1)*Metric(1,4)*Metric(2,5))/2. - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) + (P(5,1)*Metric(1,2)*Metric(3,4))/2. - P(5,4)*Metric(1,2)*Metric(3,4) - (P(2,1)*Metric(1,5)*Metric(3,4))/2. - P(2,4)*Metric(1,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) + (P(4,1)*Metric(1,2)*Metric(3,5))/2. - P(4,5)*Metric(1,2)*Metric(3,5) - (P(2,1)*Metric(1,4)*Metric(3,5))/2. - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + P(3,4)*Metric(1,2)*Metric(4,5) + P(3,5)*Metric(1,2)*Metric(4,5) - P(1,4)*Metric(2,3)*Metric(4,5) - P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS23 = Lorentz(name = 'VVVVVS23',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,4)*Metric(1,4)*Metric(2,3) + P(4,5)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(5,4)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(4,5)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - 2*P(3,1)*Metric(1,2)*Metric(4,5) + P(3,4)*Metric(1,2)*Metric(4,5) + P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(2,1)*Metric(1,3)*Metric(4,5) - P(1,4)*Metric(2,3)*Metric(4,5) - P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS24 = Lorentz(name = 'VVVVVS24',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS25 = Lorentz(name = 'VVVVVS25',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 4*P(2,5)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 4*P(1,5)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) + 4*P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - 4*P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + 4*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 4*P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVS26 = Lorentz(name = 'VVVVVS26',
                   spins = [ 3, 3, 3, 3, 3, 1 ],
                   structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 2*P(2,5)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 2*P(1,5)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - 2*P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS18 = Lorentz(name = 'VVVVVSS18',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5)')

VVVVVSS19 = Lorentz(name = 'VVVVVSS19',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,1)*Metric(1,4)*Metric(2,3) - P(4,1)*Metric(1,5)*Metric(2,3) - P(4,2)*Metric(1,5)*Metric(2,3) + P(5,2)*Metric(1,3)*Metric(2,4) + P(3,2)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) - P(4,2)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) - P(5,2)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) + P(1,2)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) + P(4,2)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) - P(1,2)*Metric(2,4)*Metric(3,5)')

VVVVVSS20 = Lorentz(name = 'VVVVVSS20',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,1)*Metric(1,3)*Metric(2,4) - P(3,1)*Metric(1,5)*Metric(2,4) + P(4,1)*Metric(1,3)*Metric(2,5) - P(3,1)*Metric(1,4)*Metric(2,5) - P(5,1)*Metric(1,2)*Metric(3,4) + P(2,1)*Metric(1,5)*Metric(3,4) - P(4,1)*Metric(1,2)*Metric(3,5) + P(2,1)*Metric(1,4)*Metric(3,5) + 4*P(3,1)*Metric(1,2)*Metric(4,5) - 4*P(2,1)*Metric(1,3)*Metric(4,5)')

VVVVVSS21 = Lorentz(name = 'VVVVVSS21',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(4,5)*Metric(1,5)*Metric(2,3) + P(3,5)*Metric(1,5)*Metric(2,4) + P(4,5)*Metric(1,3)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,5)*Metric(1,4)*Metric(3,5) - P(1,5)*Metric(2,4)*Metric(3,5) - P(2,5)*Metric(1,3)*Metric(4,5) - P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS22 = Lorentz(name = 'VVVVVSS22',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,4)*Metric(1,4)*Metric(2,3) + P(4,5)*Metric(1,5)*Metric(2,3) - (P(5,1)*Metric(1,3)*Metric(2,4))/2. + (P(3,1)*Metric(1,5)*Metric(2,4))/2. + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - (P(4,1)*Metric(1,3)*Metric(2,5))/2. + (P(3,1)*Metric(1,4)*Metric(2,5))/2. - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) + (P(5,1)*Metric(1,2)*Metric(3,4))/2. - P(5,4)*Metric(1,2)*Metric(3,4) - (P(2,1)*Metric(1,5)*Metric(3,4))/2. - P(2,4)*Metric(1,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) + (P(4,1)*Metric(1,2)*Metric(3,5))/2. - P(4,5)*Metric(1,2)*Metric(3,5) - (P(2,1)*Metric(1,4)*Metric(3,5))/2. - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + P(3,4)*Metric(1,2)*Metric(4,5) + P(3,5)*Metric(1,2)*Metric(4,5) - P(1,4)*Metric(2,3)*Metric(4,5) - P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS23 = Lorentz(name = 'VVVVVSS23',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,4)*Metric(1,4)*Metric(2,3) + P(4,5)*Metric(1,5)*Metric(2,3) - P(5,1)*Metric(1,3)*Metric(2,4) + P(3,1)*Metric(1,5)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,1)*Metric(1,3)*Metric(2,5) + P(3,1)*Metric(1,4)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) + P(5,1)*Metric(1,2)*Metric(3,4) - P(5,4)*Metric(1,2)*Metric(3,4) - P(2,1)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) + P(4,1)*Metric(1,2)*Metric(3,5) - P(4,5)*Metric(1,2)*Metric(3,5) - P(2,1)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - 2*P(3,1)*Metric(1,2)*Metric(4,5) + P(3,4)*Metric(1,2)*Metric(4,5) + P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(2,1)*Metric(1,3)*Metric(4,5) - P(1,4)*Metric(2,3)*Metric(4,5) - P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS24 = Lorentz(name = 'VVVVVSS24',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS25 = Lorentz(name = 'VVVVVSS25',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 4*P(2,5)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 4*P(1,5)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) + 4*P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - 4*P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + 4*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 4*P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVSS26 = Lorentz(name = 'VVVVVSS26',
                    spins = [ 3, 3, 3, 3, 3, 1, 1 ],
                    structure = 'P(5,3)*Metric(1,4)*Metric(2,3) - P(5,4)*Metric(1,4)*Metric(2,3) + P(4,3)*Metric(1,5)*Metric(2,3) - P(4,5)*Metric(1,5)*Metric(2,3) - P(5,3)*Metric(1,3)*Metric(2,4) + P(5,4)*Metric(1,3)*Metric(2,4) + P(3,4)*Metric(1,5)*Metric(2,4) - P(3,5)*Metric(1,5)*Metric(2,4) - P(4,3)*Metric(1,3)*Metric(2,5) + P(4,5)*Metric(1,3)*Metric(2,5) - P(3,4)*Metric(1,4)*Metric(2,5) + P(3,5)*Metric(1,4)*Metric(2,5) - P(2,3)*Metric(1,5)*Metric(3,4) - P(2,4)*Metric(1,5)*Metric(3,4) + 2*P(2,5)*Metric(1,5)*Metric(3,4) + P(1,3)*Metric(2,5)*Metric(3,4) + P(1,4)*Metric(2,5)*Metric(3,4) - 2*P(1,5)*Metric(2,5)*Metric(3,4) - P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(2,4)*Metric(1,4)*Metric(3,5) - P(2,5)*Metric(1,4)*Metric(3,5) + P(1,3)*Metric(2,4)*Metric(3,5) - 2*P(1,4)*Metric(2,4)*Metric(3,5) + P(1,5)*Metric(2,4)*Metric(3,5) + 2*P(2,3)*Metric(1,3)*Metric(4,5) - P(2,4)*Metric(1,3)*Metric(4,5) - P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(1,3)*Metric(2,3)*Metric(4,5) + P(1,4)*Metric(2,3)*Metric(4,5) + P(1,5)*Metric(2,3)*Metric(4,5)')

