# This file was automatically created by FeynRules 2.3.14
# Mathematica version: 9.0 for Mac OS X x86 (64-bit) (November 20, 2012)
# Date: Sat 2 Sep 2017 03:14:09


from object_library import all_lorentz, Lorentz

from function_library import complexconjugate, re, im, csc, sec, acsc, asec, cot
try:
   import form_factors as ForFac 
except ImportError:
   pass


UUV2 = Lorentz(name = 'UUV2',
               spins = [ -1, -1, 3 ],
               structure = 'P(3,2) + P(3,3)')

SSS2 = Lorentz(name = 'SSS2',
               spins = [ 1, 1, 1 ],
               structure = '1')

FFS2 = Lorentz(name = 'FFS2',
               spins = [ 2, 2, 1 ],
               structure = 'ProjM(2,1) + ProjP(2,1)')

FFV6 = Lorentz(name = 'FFV6',
               spins = [ 2, 2, 3 ],
               structure = 'Gamma(3,2,1)')

FFV7 = Lorentz(name = 'FFV7',
               spins = [ 2, 2, 3 ],
               structure = 'Gamma(3,2,-1)*ProjM(-1,1)')

FFV8 = Lorentz(name = 'FFV8',
               spins = [ 2, 2, 3 ],
               structure = 'Gamma(3,2,-1)*ProjM(-1,1) - 2*Gamma(3,2,-1)*ProjP(-1,1)')

FFV9 = Lorentz(name = 'FFV9',
               spins = [ 2, 2, 3 ],
               structure = 'Gamma(3,2,-1)*ProjM(-1,1) + 2*Gamma(3,2,-1)*ProjP(-1,1)')

FFV10 = Lorentz(name = 'FFV10',
                spins = [ 2, 2, 3 ],
                structure = 'Gamma(3,2,-1)*ProjM(-1,1) + 4*Gamma(3,2,-1)*ProjP(-1,1)')

VVS2 = Lorentz(name = 'VVS2',
               spins = [ 3, 3, 1 ],
               structure = 'Metric(1,2)')

VVV2 = Lorentz(name = 'VVV2',
               spins = [ 3, 3, 3 ],
               structure = 'P(3,1)*Metric(1,2) - P(3,2)*Metric(1,2) - P(2,1)*Metric(1,3) + P(2,3)*Metric(1,3) + P(1,2)*Metric(2,3) - P(1,3)*Metric(2,3)')

SSSS2 = Lorentz(name = 'SSSS2',
                spins = [ 1, 1, 1, 1 ],
                structure = '1')

VVSS2 = Lorentz(name = 'VVSS2',
                spins = [ 3, 3, 1, 1 ],
                structure = 'Metric(1,2)')

VVVV10 = Lorentz(name = 'VVVV10',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) - Metric(1,3)*Metric(2,4)')

VVVV11 = Lorentz(name = 'VVVV11',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,4)*P(2,3)*P(3,2)*P(4,1) + P(1,3)*P(2,4)*P(3,1)*P(4,2) - P(-1,1)*P(-1,3)*P(2,4)*P(4,2)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*P(3,2)*Metric(1,4) - P(-1,2)*P(-1,3)*P(1,4)*P(4,1)*Metric(2,3) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,4)*P(1,3)*P(3,1)*Metric(2,4) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4)')

VVVV12 = Lorentz(name = 'VVVV12',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) + Metric(1,3)*Metric(2,4) - 2*Metric(1,2)*Metric(3,4)')

VVVV13 = Lorentz(name = 'VVVV13',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) - Metric(1,2)*Metric(3,4)')

VVVV14 = Lorentz(name = 'VVVV14',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,3)*Metric(2,4) - Metric(1,2)*Metric(3,4)')

VVVV15 = Lorentz(name = 'VVVV15',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'Metric(1,4)*Metric(2,3) - (Metric(1,3)*Metric(2,4))/2. - (Metric(1,2)*Metric(3,4))/2.')

VVVV16 = Lorentz(name = 'VVVV16',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,3)*P(2,4)*P(3,1)*P(4,2) + P(1,2)*P(2,1)*P(3,4)*P(4,3) - P(-1,1)*P(-1,2)*P(3,4)*P(4,3)*Metric(1,2) - P(-1,1)*P(-1,3)*P(2,4)*P(4,2)*Metric(1,3) - P(-1,2)*P(-1,4)*P(1,3)*P(3,1)*Metric(2,4) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,4)*P(1,2)*P(2,1)*Metric(3,4) + P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVV17 = Lorentz(name = 'VVVV17',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,4)*P(2,3)*P(3,2)*P(4,1) + P(1,3)*P(2,4)*P(3,1)*P(4,2) + P(1,2)*P(2,1)*P(3,4)*P(4,3) - P(-1,1)*P(-1,2)*P(3,4)*P(4,3)*Metric(1,2) - P(-1,1)*P(-1,3)*P(2,4)*P(4,2)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*P(3,2)*Metric(1,4) - P(-1,2)*P(-1,3)*P(1,4)*P(4,1)*Metric(2,3) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,4)*P(1,3)*P(3,1)*Metric(2,4) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) - P(-1,3)*P(-1,4)*P(1,2)*P(2,1)*Metric(3,4) + P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVV18 = Lorentz(name = 'VVVV18',
                 spins = [ 3, 3, 3, 3 ],
                 structure = 'P(1,4)*P(2,3)*P(3,2)*P(4,1) + P(1,3)*P(2,4)*P(3,1)*P(4,2) + 2*P(1,2)*P(2,1)*P(3,4)*P(4,3) - 2*P(-1,1)*P(-1,2)*P(3,4)*P(4,3)*Metric(1,2) - P(-1,1)*P(-1,3)*P(2,4)*P(4,2)*Metric(1,3) - P(-1,1)*P(-1,4)*P(2,3)*P(3,2)*Metric(1,4) - P(-1,2)*P(-1,3)*P(1,4)*P(4,1)*Metric(2,3) + P(-2,2)*P(-2,3)*P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,4)*P(1,3)*P(3,1)*Metric(2,4) + P(-2,2)*P(-2,4)*P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4) - 2*P(-1,3)*P(-1,4)*P(1,2)*P(2,1)*Metric(3,4) + 2*P(-2,3)*P(-2,4)*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)')

VVVVV7 = Lorentz(name = 'VVVVV7',
                 spins = [ 3, 3, 3, 3, 3 ],
                 structure = 'P(3,4)*P(4,3)*P(5,1)*Metric(1,2) + P(3,4)*P(4,3)*P(5,2)*Metric(1,2) - P(3,5)*P(4,1)*P(5,3)*Metric(1,2) - P(3,5)*P(4,2)*P(5,3)*Metric(1,2) + P(2,4)*P(4,2)*P(5,1)*Metric(1,3) - P(2,5)*P(4,1)*P(5,2)*Metric(1,3) - P(2,5)*P(4,3)*P(5,2)*Metric(1,3) + P(2,4)*P(4,2)*P(5,3)*Metric(1,3) - 2*P(2,3)*P(3,2)*P(5,1)*Metric(1,4) + P(2,5)*P(3,1)*P(5,2)*Metric(1,4) + P(2,1)*P(3,5)*P(5,3)*Metric(1,4) + 2*P(2,3)*P(3,2)*P(4,1)*Metric(1,5) - P(2,4)*P(3,1)*P(4,2)*Metric(1,5) - P(2,1)*P(3,4)*P(4,3)*Metric(1,5) - P(1,5)*P(4,2)*P(5,1)*Metric(2,3) - P(1,5)*P(4,3)*P(5,1)*Metric(2,3) + P(1,4)*P(4,1)*P(5,2)*Metric(2,3) + P(1,4)*P(4,1)*P(5,3)*Metric(2,3) + 2*P(-1,2)*P(-1,3)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3) - 2*P(-1,2)*P(-1,3)*P(4,1)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) + P(1,5)*P(3,2)*P(5,1)*Metric(2,4) - 2*P(1,3)*P(3,1)*P(5,2)*Metric(2,4) + P(1,2)*P(3,5)*P(5,3)*Metric(2,4) - P(-1,2)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) + 2*P(-1,1)*P(-1,3)*P(5,2)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) - P(-1,1)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) - P(1,4)*P(3,2)*P(4,1)*Metric(2,5) + 2*P(1,3)*P(3,1)*P(4,2)*Metric(2,5) - P(1,2)*P(3,4)*P(4,3)*Metric(2,5) + P(-1,2)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - 2*P(-1,1)*P(-1,3)*P(4,2)*Metric(1,3)*Metric(2,5) + P(-1,2)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) - P(-1,2)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5) + P(1,5)*P(2,3)*P(5,1)*Metric(3,4) + P(1,3)*P(2,5)*P(5,2)*Metric(3,4) - 2*P(1,2)*P(2,1)*P(5,3)*Metric(3,4) - P(-1,3)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) + 2*P(-1,1)*P(-1,2)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,3)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) - P(1,4)*P(2,3)*P(4,1)*Metric(3,5) - P(1,3)*P(2,4)*P(4,2)*Metric(3,5) + 2*P(1,2)*P(2,1)*P(4,3)*Metric(3,5) + P(-1,3)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) - 2*P(-1,1)*P(-1,2)*P(4,3)*Metric(1,2)*Metric(3,5) - P(-1,3)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,1)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5)')

VVVVV8 = Lorentz(name = 'VVVVV8',
                 spins = [ 3, 3, 3, 3, 3 ],
                 structure = 'P(3,4)*P(4,3)*P(5,1)*Metric(1,2) + P(3,5)*P(4,1)*P(5,3)*Metric(1,2) - 2*P(3,1)*P(4,5)*P(5,4)*Metric(1,2) - P(2,4)*P(4,2)*P(5,1)*Metric(1,3) - P(2,5)*P(4,1)*P(5,2)*Metric(1,3) + 2*P(2,1)*P(4,5)*P(5,4)*Metric(1,3) + P(2,5)*P(3,1)*P(5,2)*Metric(1,4) + P(2,5)*P(3,4)*P(5,2)*Metric(1,4) - P(2,1)*P(3,5)*P(5,3)*Metric(1,4) - P(2,4)*P(3,5)*P(5,3)*Metric(1,4) + P(2,4)*P(3,1)*P(4,2)*Metric(1,5) + P(2,4)*P(3,5)*P(4,2)*Metric(1,5) - P(2,1)*P(3,4)*P(4,3)*Metric(1,5) - P(2,5)*P(3,4)*P(4,3)*Metric(1,5) - 2*P(1,5)*P(3,4)*P(5,1)*Metric(2,4) + P(1,4)*P(3,5)*P(5,3)*Metric(2,4) + P(1,3)*P(3,1)*P(5,4)*Metric(2,4) + P(-1,2)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,2)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) + 2*P(-1,1)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - 2*P(1,4)*P(3,5)*P(4,1)*Metric(2,5) + P(1,5)*P(3,4)*P(4,3)*Metric(2,5) + P(1,3)*P(3,1)*P(4,5)*Metric(2,5) + P(-1,2)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,2)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + 2*P(-1,1)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + 2*P(1,5)*P(2,4)*P(5,1)*Metric(3,4) - P(1,4)*P(2,5)*P(5,2)*Metric(3,4) - P(1,2)*P(2,1)*P(5,4)*Metric(3,4) - P(-1,3)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,2)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) - 2*P(-1,1)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) + P(-1,3)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + 2*P(1,4)*P(2,5)*P(4,1)*Metric(3,5) - P(1,5)*P(2,4)*P(4,2)*Metric(3,5) - P(1,2)*P(2,1)*P(4,5)*Metric(3,5) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,2)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) + P(-1,3)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - 2*P(-1,1)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) - P(-1,3)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) - P(1,3)*P(2,4)*P(3,1)*Metric(4,5) - P(1,3)*P(2,5)*P(3,1)*Metric(4,5) + P(1,2)*P(2,1)*P(3,4)*Metric(4,5) + P(1,2)*P(2,1)*P(3,5)*Metric(4,5) + 2*P(-1,4)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,2)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,2)*P(3,5)*Metric(1,2)*Metric(4,5) - 2*P(-1,4)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5)')

VVVVV9 = Lorentz(name = 'VVVVV9',
                 spins = [ 3, 3, 3, 3, 3 ],
                 structure = 'P(3,5)*P(4,1)*P(5,3)*Metric(1,2) + P(3,5)*P(4,2)*P(5,3)*Metric(1,2) - P(3,1)*P(4,5)*P(5,4)*Metric(1,2) - P(3,2)*P(4,5)*P(5,4)*Metric(1,2) + P(2,4)*P(4,2)*P(5,1)*Metric(1,3) - 2*P(2,5)*P(4,1)*P(5,2)*Metric(1,3) + P(2,1)*P(4,5)*P(5,4)*Metric(1,3) - P(2,3)*P(3,2)*P(5,1)*Metric(1,4) + 2*P(2,5)*P(3,1)*P(5,2)*Metric(1,4) - P(2,1)*P(3,5)*P(5,3)*Metric(1,4) + P(2,3)*P(3,2)*P(4,1)*Metric(1,5) - P(2,4)*P(3,1)*P(4,2)*Metric(1,5) - P(2,4)*P(3,5)*P(4,2)*Metric(1,5) + P(2,3)*P(3,2)*P(4,5)*Metric(1,5) - 2*P(1,5)*P(4,2)*P(5,1)*Metric(2,3) + P(1,4)*P(4,1)*P(5,2)*Metric(2,3) + P(1,2)*P(4,5)*P(5,4)*Metric(2,3) + P(-1,2)*P(-1,3)*P(5,1)*Metric(1,4)*Metric(2,3) - P(-1,1)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,3)*P(4,1)*Metric(1,5)*Metric(2,3) + 2*P(-1,1)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) + 2*P(1,5)*P(3,2)*P(5,1)*Metric(2,4) - P(1,3)*P(3,1)*P(5,2)*Metric(2,4) - P(1,2)*P(3,5)*P(5,3)*Metric(2,4) - P(-1,2)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,3)*P(5,2)*Metric(1,3)*Metric(2,4) + P(-1,2)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4) - 2*P(-1,1)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,2)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - P(1,4)*P(3,2)*P(4,1)*Metric(2,5) - P(1,4)*P(3,5)*P(4,1)*Metric(2,5) + P(1,3)*P(3,1)*P(4,2)*Metric(2,5) + P(1,3)*P(3,1)*P(4,5)*Metric(2,5) + 2*P(-1,2)*P(-1,5)*P(4,1)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,3)*P(4,2)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) - 2*P(-1,2)*P(-1,5)*P(3,1)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,4)*P(2,5)*P(4,1)*Metric(3,5) + P(1,5)*P(2,4)*P(4,2)*Metric(3,5) - 2*P(1,2)*P(2,1)*P(4,5)*Metric(3,5) - P(-1,3)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5) - P(-1,3)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + 2*P(-1,1)*P(-1,2)*P(4,5)*Metric(1,2)*Metric(3,5) + P(-1,3)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) + P(-1,3)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) - P(1,3)*P(2,5)*P(3,1)*Metric(4,5) - P(1,5)*P(2,3)*P(3,2)*Metric(4,5) + 2*P(1,2)*P(2,1)*P(3,5)*Metric(4,5) + P(-1,4)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5) + P(-1,4)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) - 2*P(-1,1)*P(-1,2)*P(3,5)*Metric(1,2)*Metric(4,5) - P(-1,4)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5) + P(-1,1)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5) - P(-1,4)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV10 = Lorentz(name = 'VVVVV10',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,4)*P(4,3)*P(5,1)*Metric(1,2) + P(3,4)*P(4,3)*P(5,2)*Metric(1,2) - (P(3,5)*P(4,1)*P(5,3)*Metric(1,2))/2. - (P(3,5)*P(4,2)*P(5,3)*Metric(1,2))/2. - (P(3,1)*P(4,5)*P(5,4)*Metric(1,2))/2. - (P(3,2)*P(4,5)*P(5,4)*Metric(1,2))/2. - (P(2,4)*P(4,2)*P(5,1)*Metric(1,3))/2. - (P(2,5)*P(4,3)*P(5,2)*Metric(1,3))/2. + (P(2,4)*P(4,2)*P(5,3)*Metric(1,3))/2. + (P(2,1)*P(4,5)*P(5,4)*Metric(1,3))/2. - (P(2,3)*P(3,2)*P(5,1)*Metric(1,4))/2. - (P(2,5)*P(3,4)*P(5,2)*Metric(1,4))/2. + (P(2,1)*P(3,5)*P(5,3)*Metric(1,4))/2. + (P(2,3)*P(3,2)*P(5,4)*Metric(1,4))/2. + (P(2,3)*P(3,2)*P(4,1)*Metric(1,5))/2. + (P(2,4)*P(3,1)*P(4,2)*Metric(1,5))/2. - P(2,1)*P(3,4)*P(4,3)*Metric(1,5) - (P(1,5)*P(4,3)*P(5,1)*Metric(2,3))/2. - (P(1,4)*P(4,1)*P(5,2)*Metric(2,3))/2. + (P(1,4)*P(4,1)*P(5,3)*Metric(2,3))/2. + (P(1,2)*P(4,5)*P(5,4)*Metric(2,3))/2. + (P(-1,2)*P(-1,3)*P(5,1)*Metric(1,4)*Metric(2,3))/2. + (P(-1,1)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3))/2. - (P(-1,1)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3))/2. - (P(-1,2)*P(-1,3)*P(5,4)*Metric(1,4)*Metric(2,3))/2. - (P(-1,2)*P(-1,3)*P(4,1)*Metric(1,5)*Metric(2,3))/2. + (P(-1,1)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3))/2. - (P(1,5)*P(3,4)*P(5,1)*Metric(2,4))/2. - (P(1,3)*P(3,1)*P(5,2)*Metric(2,4))/2. + (P(1,2)*P(3,5)*P(5,3)*Metric(2,4))/2. + (P(1,3)*P(3,1)*P(5,4)*Metric(2,4))/2. + (P(-1,2)*P(-1,4)*P(5,1)*Metric(1,3)*Metric(2,4))/2. + (P(-1,1)*P(-1,3)*P(5,2)*Metric(1,3)*Metric(2,4))/2. - (P(-1,2)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4))/2. - (P(-1,1)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4))/2. - (P(-1,2)*P(-1,4)*P(3,1)*Metric(1,5)*Metric(2,4))/2. + (P(-1,1)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4))/2. + (P(1,4)*P(3,2)*P(4,1)*Metric(2,5))/2. + (P(1,3)*P(3,1)*P(4,2)*Metric(2,5))/2. - P(1,2)*P(3,4)*P(4,3)*Metric(2,5) - (P(-1,1)*P(-1,3)*P(4,2)*Metric(1,3)*Metric(2,5))/2. + (P(-1,2)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5))/2. - (P(-1,1)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5))/2. + (P(-1,2)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5))/2. + (P(1,5)*P(2,3)*P(5,1)*Metric(3,4))/2. + (P(1,5)*P(2,4)*P(5,1)*Metric(3,4))/2. + (P(1,3)*P(2,5)*P(5,2)*Metric(3,4))/2. + (P(1,4)*P(2,5)*P(5,2)*Metric(3,4))/2. - P(1,2)*P(2,1)*P(5,3)*Metric(3,4) - P(1,2)*P(2,1)*P(5,4)*Metric(3,4) - P(-1,3)*P(-1,4)*P(5,1)*Metric(1,2)*Metric(3,4) - P(-1,3)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,2)*P(5,3)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,2)*P(5,4)*Metric(1,2)*Metric(3,4) + P(-1,3)*P(-1,4)*P(2,1)*Metric(1,5)*Metric(3,4) - (P(-1,1)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4))/2. - (P(-1,1)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4))/2. + P(-1,3)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) - (P(-1,2)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4))/2. - (P(-1,2)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4))/2. - (P(1,4)*P(2,3)*P(4,1)*Metric(3,5))/2. - (P(1,3)*P(2,4)*P(4,2)*Metric(3,5))/2. + P(1,2)*P(2,1)*P(4,3)*Metric(3,5) + (P(-1,3)*P(-1,5)*P(4,1)*Metric(1,2)*Metric(3,5))/2. + (P(-1,3)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5))/2. - P(-1,1)*P(-1,2)*P(4,3)*Metric(1,2)*Metric(3,5) - (P(-1,3)*P(-1,5)*P(2,1)*Metric(1,4)*Metric(3,5))/2. + (P(-1,1)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5))/2. - (P(-1,3)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5))/2. + (P(-1,2)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5))/2. - (P(1,3)*P(2,4)*P(3,1)*Metric(4,5))/2. - (P(1,4)*P(2,3)*P(3,2)*Metric(4,5))/2. + P(1,2)*P(2,1)*P(3,4)*Metric(4,5) + (P(-1,4)*P(-1,5)*P(3,1)*Metric(1,2)*Metric(4,5))/2. + (P(-1,4)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5))/2. - P(-1,1)*P(-1,2)*P(3,4)*Metric(1,2)*Metric(4,5) - (P(-1,4)*P(-1,5)*P(2,1)*Metric(1,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5))/2. - (P(-1,4)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5))/2. + (P(-1,2)*P(-1,3)*P(1,4)*Metric(2,3)*Metric(4,5))/2.')

VVVVV11 = Lorentz(name = 'VVVVV11',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(2,5)*P(4,3)*P(5,2)*Metric(1,3) + P(2,4)*P(4,2)*P(5,3)*Metric(1,3) - 2*P(2,3)*P(4,5)*P(5,4)*Metric(1,3) + P(2,5)*P(3,4)*P(5,2)*Metric(1,4) - 2*P(2,4)*P(3,5)*P(5,3)*Metric(1,4) + P(2,3)*P(3,2)*P(5,4)*Metric(1,4) + P(2,4)*P(3,5)*P(4,2)*Metric(1,5) - 2*P(2,5)*P(3,4)*P(4,3)*Metric(1,5) + P(2,3)*P(3,2)*P(4,5)*Metric(1,5) - P(1,5)*P(4,3)*P(5,1)*Metric(2,3) - P(1,4)*P(4,1)*P(5,3)*Metric(2,3) + 2*P(1,3)*P(4,5)*P(5,4)*Metric(2,3) + P(-1,1)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3) - P(-1,2)*P(-1,3)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) - P(-1,2)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) - P(1,5)*P(3,4)*P(5,1)*Metric(2,4) + 2*P(1,4)*P(3,5)*P(5,3)*Metric(2,4) - P(1,3)*P(3,1)*P(5,4)*Metric(2,4) - P(-1,2)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,5)*P(3,4)*Metric(1,5)*Metric(2,4) - P(-1,2)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) - P(1,4)*P(3,5)*P(4,1)*Metric(2,5) + 2*P(1,5)*P(3,4)*P(4,3)*Metric(2,5) - P(1,3)*P(3,1)*P(4,5)*Metric(2,5) - P(-1,2)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,2)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(-1,1)*P(-1,4)*P(3,5)*Metric(1,4)*Metric(2,5) + P(1,5)*P(2,3)*P(5,1)*Metric(3,4) + P(1,5)*P(2,4)*P(5,1)*Metric(3,4) - P(1,3)*P(2,5)*P(5,2)*Metric(3,4) - P(1,4)*P(2,5)*P(5,2)*Metric(3,4) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) - P(-1,1)*P(-1,5)*P(2,4)*Metric(1,5)*Metric(3,4) + 2*P(-1,3)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) - 2*P(-1,3)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + P(1,4)*P(2,3)*P(4,1)*Metric(3,5) + P(1,4)*P(2,5)*P(4,1)*Metric(3,5) - P(1,3)*P(2,4)*P(4,2)*Metric(3,5) - P(1,5)*P(2,4)*P(4,2)*Metric(3,5) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5) + 2*P(-1,3)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) - P(-1,1)*P(-1,4)*P(2,5)*Metric(1,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5) - 2*P(-1,3)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) + P(1,3)*P(2,4)*P(3,1)*Metric(4,5) + P(1,3)*P(2,5)*P(3,1)*Metric(4,5) - P(1,4)*P(2,3)*P(3,2)*Metric(4,5) - P(1,5)*P(2,3)*P(3,2)*Metric(4,5) + 2*P(-1,4)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(-1,4)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,3)*P(1,4)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVV12 = Lorentz(name = 'VVVVV12',
                  spins = [ 3, 3, 3, 3, 3 ],
                  structure = 'P(3,4)*P(4,3)*P(5,2)*Metric(1,2) + P(3,5)*P(4,2)*P(5,3)*Metric(1,2) - 2*P(3,2)*P(4,5)*P(5,4)*Metric(1,2) + P(2,5)*P(4,3)*P(5,2)*Metric(1,3) + P(2,4)*P(4,2)*P(5,3)*Metric(1,3) - 2*P(2,3)*P(4,5)*P(5,4)*Metric(1,3) - P(2,5)*P(3,4)*P(5,2)*Metric(1,4) - P(2,4)*P(3,5)*P(5,3)*Metric(1,4) + 2*P(2,3)*P(3,2)*P(5,4)*Metric(1,4) - P(2,4)*P(3,5)*P(4,2)*Metric(1,5) - P(2,5)*P(3,4)*P(4,3)*Metric(1,5) + 2*P(2,3)*P(3,2)*P(4,5)*Metric(1,5) - P(1,5)*P(4,2)*P(5,1)*Metric(2,3) - P(1,5)*P(4,3)*P(5,1)*Metric(2,3) - P(1,4)*P(4,1)*P(5,2)*Metric(2,3) - P(1,4)*P(4,1)*P(5,3)*Metric(2,3) + 2*P(1,2)*P(4,5)*P(5,4)*Metric(2,3) + 2*P(1,3)*P(4,5)*P(5,4)*Metric(2,3) + P(-1,1)*P(-1,4)*P(5,2)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,4)*P(5,3)*Metric(1,4)*Metric(2,3) - 2*P(-1,2)*P(-1,3)*P(5,4)*Metric(1,4)*Metric(2,3) + P(-1,1)*P(-1,5)*P(4,2)*Metric(1,5)*Metric(2,3) + P(-1,1)*P(-1,5)*P(4,3)*Metric(1,5)*Metric(2,3) - 2*P(-1,2)*P(-1,3)*P(4,5)*Metric(1,5)*Metric(2,3) + P(1,5)*P(3,2)*P(5,1)*Metric(2,4) - P(1,2)*P(3,5)*P(5,3)*Metric(2,4) + P(1,4)*P(3,5)*P(5,3)*Metric(2,4) - P(1,3)*P(3,1)*P(5,4)*Metric(2,4) - P(-1,2)*P(-1,4)*P(5,3)*Metric(1,3)*Metric(2,4) + P(-1,1)*P(-1,3)*P(5,4)*Metric(1,3)*Metric(2,4) - P(-1,1)*P(-1,5)*P(3,2)*Metric(1,5)*Metric(2,4) + P(-1,2)*P(-1,4)*P(3,5)*Metric(1,5)*Metric(2,4) + P(1,4)*P(3,2)*P(4,1)*Metric(2,5) - P(1,2)*P(3,4)*P(4,3)*Metric(2,5) + P(1,5)*P(3,4)*P(4,3)*Metric(2,5) - P(1,3)*P(3,1)*P(4,5)*Metric(2,5) - P(-1,2)*P(-1,5)*P(4,3)*Metric(1,3)*Metric(2,5) + P(-1,1)*P(-1,3)*P(4,5)*Metric(1,3)*Metric(2,5) - P(-1,1)*P(-1,4)*P(3,2)*Metric(1,4)*Metric(2,5) + P(-1,2)*P(-1,5)*P(3,4)*Metric(1,4)*Metric(2,5) + P(1,5)*P(2,3)*P(5,1)*Metric(3,4) - P(1,3)*P(2,5)*P(5,2)*Metric(3,4) + P(1,4)*P(2,5)*P(5,2)*Metric(3,4) - P(1,2)*P(2,1)*P(5,4)*Metric(3,4) - P(-1,3)*P(-1,4)*P(5,2)*Metric(1,2)*Metric(3,4) + P(-1,1)*P(-1,2)*P(5,4)*Metric(1,2)*Metric(3,4) - P(-1,1)*P(-1,5)*P(2,3)*Metric(1,5)*Metric(3,4) + P(-1,3)*P(-1,4)*P(2,5)*Metric(1,5)*Metric(3,4) + P(-1,3)*P(-1,4)*P(1,2)*Metric(2,5)*Metric(3,4) + P(-1,2)*P(-1,5)*P(1,3)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,5)*P(1,4)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,4)*P(1,5)*Metric(2,5)*Metric(3,4) + P(1,4)*P(2,3)*P(4,1)*Metric(3,5) - P(1,3)*P(2,4)*P(4,2)*Metric(3,5) + P(1,5)*P(2,4)*P(4,2)*Metric(3,5) - P(1,2)*P(2,1)*P(4,5)*Metric(3,5) - P(-1,3)*P(-1,5)*P(4,2)*Metric(1,2)*Metric(3,5) + P(-1,1)*P(-1,2)*P(4,5)*Metric(1,2)*Metric(3,5) - P(-1,1)*P(-1,4)*P(2,3)*Metric(1,4)*Metric(3,5) + P(-1,3)*P(-1,5)*P(2,4)*Metric(1,4)*Metric(3,5) + P(-1,3)*P(-1,5)*P(1,2)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,4)*P(1,3)*Metric(2,4)*Metric(3,5) - P(-1,3)*P(-1,5)*P(1,4)*Metric(2,4)*Metric(3,5) - P(-1,2)*P(-1,4)*P(1,5)*Metric(2,4)*Metric(3,5) + P(1,3)*P(2,4)*P(3,1)*Metric(4,5) + P(1,3)*P(2,5)*P(3,1)*Metric(4,5) - 2*P(1,4)*P(2,3)*P(3,2)*Metric(4,5) - 2*P(1,5)*P(2,3)*P(3,2)*Metric(4,5) + P(1,2)*P(2,1)*P(3,4)*Metric(4,5) + P(1,2)*P(2,1)*P(3,5)*Metric(4,5) + 2*P(-1,4)*P(-1,5)*P(3,2)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,2)*P(3,4)*Metric(1,2)*Metric(4,5) - P(-1,1)*P(-1,2)*P(3,5)*Metric(1,2)*Metric(4,5) + 2*P(-1,4)*P(-1,5)*P(2,3)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(2,4)*Metric(1,3)*Metric(4,5) - P(-1,1)*P(-1,3)*P(2,5)*Metric(1,3)*Metric(4,5) - 2*P(-1,4)*P(-1,5)*P(1,2)*Metric(2,3)*Metric(4,5) - 2*P(-1,4)*P(-1,5)*P(1,3)*Metric(2,3)*Metric(4,5) + 2*P(-1,2)*P(-1,3)*P(1,4)*Metric(2,3)*Metric(4,5) + 2*P(-1,2)*P(-1,3)*P(1,5)*Metric(2,3)*Metric(4,5)')

VVVVVV10 = Lorentz(name = 'VVVVVV10',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,4)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,4)*Metric(1,4)*Metric(2,3) - P(4,1)*P(6,2)*Metric(1,5)*Metric(2,3) - P(4,1)*P(6,3)*Metric(1,5)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,3)*Metric(1,6)*Metric(2,3) + P(5,2)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,2)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,4)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,1)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,2)*Metric(1,6)*Metric(2,4) - P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4) - P(4,2)*P(6,1)*Metric(1,3)*Metric(2,5) - P(4,2)*P(6,3)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,2)*P(6,4)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,2)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) - P(4,2)*P(5,3)*Metric(1,3)*Metric(2,6) - P(3,2)*P(5,1)*Metric(1,4)*Metric(2,6) - P(3,2)*P(5,4)*Metric(1,4)*Metric(2,6) + P(3,2)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) + P(5,3)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,3)*P(6,2)*Metric(1,2)*Metric(3,4) + P(5,4)*P(6,2)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,2)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,4)*Metric(1,2)*Metric(3,4) + P(5,2)*P(6,4)*Metric(1,2)*Metric(3,4) - P(2,1)*P(6,3)*Metric(1,5)*Metric(3,4) - P(2,1)*P(6,4)*Metric(1,5)*Metric(3,4) - P(2,1)*P(5,3)*Metric(1,6)*Metric(3,4) - P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4) - P(1,2)*P(6,3)*Metric(2,5)*Metric(3,4) - P(1,2)*P(6,4)*Metric(2,5)*Metric(3,4) - P(1,2)*P(5,3)*Metric(2,6)*Metric(3,4) - P(1,2)*P(5,4)*Metric(2,6)*Metric(3,4) - P(4,3)*P(6,1)*Metric(1,2)*Metric(3,5) - P(4,3)*P(6,2)*Metric(1,2)*Metric(3,5) - P(2,3)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,3)*P(6,4)*Metric(1,4)*Metric(3,5) + P(2,3)*P(4,1)*Metric(1,6)*Metric(3,5) + P(2,1)*P(4,3)*Metric(1,6)*Metric(3,5) - P(1,3)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) + P(1,3)*P(4,2)*Metric(2,6)*Metric(3,5) + P(1,2)*P(4,3)*Metric(2,6)*Metric(3,5) - P(4,3)*P(5,1)*Metric(1,2)*Metric(3,6) - P(4,3)*P(5,2)*Metric(1,2)*Metric(3,6) - P(2,3)*P(5,1)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6) + P(2,3)*P(4,1)*Metric(1,5)*Metric(3,6) + P(2,1)*P(4,3)*Metric(1,5)*Metric(3,6) - P(1,3)*P(5,2)*Metric(2,4)*Metric(3,6) - P(1,3)*P(5,4)*Metric(2,4)*Metric(3,6) + P(1,3)*P(4,2)*Metric(2,5)*Metric(3,6) + P(1,2)*P(4,3)*Metric(2,5)*Metric(3,6) - P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5) - P(3,4)*P(6,2)*Metric(1,2)*Metric(4,5) - P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,4)*P(6,3)*Metric(1,3)*Metric(4,5) + P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5) - P(1,4)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5) + P(1,4)*P(3,2)*Metric(2,6)*Metric(4,5) + P(1,2)*P(3,4)*Metric(2,6)*Metric(4,5) + P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,3)*P(2,4)*Metric(3,6)*Metric(4,5) - P(3,4)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,4)*P(5,2)*Metric(1,2)*Metric(4,6) - P(2,4)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) + P(2,4)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,4)*Metric(1,5)*Metric(4,6) - P(1,4)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,4)*P(5,3)*Metric(2,3)*Metric(4,6) + P(1,4)*P(3,2)*Metric(2,5)*Metric(4,6) + P(1,2)*P(3,4)*Metric(2,5)*Metric(4,6) + P(1,4)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6)')

VVVVVV11 = Lorentz(name = 'VVVVVV11',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,2)*Metric(1,4)*Metric(2,3) - P(4,1)*P(6,2)*Metric(1,5)*Metric(2,3) - P(4,5)*P(6,2)*Metric(1,5)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,2)*Metric(1,6)*Metric(2,3) + P(5,2)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,5)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,2)*Metric(1,6)*Metric(2,4) - P(3,6)*P(5,2)*Metric(1,6)*Metric(2,4) - P(4,2)*P(6,1)*Metric(1,3)*Metric(2,5) - P(4,5)*P(6,1)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,5)*P(6,1)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,5)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,2)*Metric(1,6)*Metric(2,5) + P(3,6)*P(4,2)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,2)*P(4,6)*Metric(1,6)*Metric(2,5) + P(3,5)*P(4,6)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) - P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) - P(3,2)*P(5,1)*Metric(1,4)*Metric(2,6) - P(3,6)*P(5,1)*Metric(1,4)*Metric(2,6) + P(3,2)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,6)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) + P(3,5)*P(4,2)*Metric(1,5)*Metric(2,6) + P(3,2)*P(4,5)*Metric(1,5)*Metric(2,6) + P(3,6)*P(4,5)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) + P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) - P(4,1)*P(6,5)*Metric(1,2)*Metric(3,5) - P(4,2)*P(6,5)*Metric(1,2)*Metric(3,5) + P(2,5)*P(6,1)*Metric(1,4)*Metric(3,5) + P(2,1)*P(6,5)*Metric(1,4)*Metric(3,5) - P(2,5)*P(4,1)*Metric(1,6)*Metric(3,5) - P(2,5)*P(4,6)*Metric(1,6)*Metric(3,5) + P(1,5)*P(6,2)*Metric(2,4)*Metric(3,5) + P(1,2)*P(6,5)*Metric(2,4)*Metric(3,5) - P(1,5)*P(4,2)*Metric(2,6)*Metric(3,5) - P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) - P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) - P(4,2)*P(5,6)*Metric(1,2)*Metric(3,6) + P(2,6)*P(5,1)*Metric(1,4)*Metric(3,6) + P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,6)*P(4,1)*Metric(1,5)*Metric(3,6) - P(2,6)*P(4,5)*Metric(1,5)*Metric(3,6) + P(1,6)*P(5,2)*Metric(2,4)*Metric(3,6) + P(1,2)*P(5,6)*Metric(2,4)*Metric(3,6) - P(1,6)*P(4,2)*Metric(2,5)*Metric(3,6) - P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) - P(3,1)*P(6,5)*Metric(1,2)*Metric(4,5) - P(3,2)*P(6,5)*Metric(1,2)*Metric(4,5) + P(2,5)*P(6,1)*Metric(1,3)*Metric(4,5) + P(2,1)*P(6,5)*Metric(1,3)*Metric(4,5) - P(2,5)*P(3,1)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) + P(1,5)*P(6,2)*Metric(2,3)*Metric(4,5) + P(1,2)*P(6,5)*Metric(2,3)*Metric(4,5) - P(1,5)*P(3,2)*Metric(2,6)*Metric(4,5) - P(1,5)*P(3,6)*Metric(2,6)*Metric(4,5) + P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) + P(1,5)*P(2,6)*Metric(3,6)*Metric(4,5) - P(3,1)*P(5,6)*Metric(1,2)*Metric(4,6) - P(3,2)*P(5,6)*Metric(1,2)*Metric(4,6) + P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) + P(2,1)*P(5,6)*Metric(1,3)*Metric(4,6) - P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) - P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) + P(1,6)*P(5,2)*Metric(2,3)*Metric(4,6) + P(1,2)*P(5,6)*Metric(2,3)*Metric(4,6) - P(1,6)*P(3,2)*Metric(2,5)*Metric(4,6) - P(1,6)*P(3,5)*Metric(2,5)*Metric(4,6) + P(1,6)*P(2,5)*Metric(3,5)*Metric(4,6) + P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6) + P(3,5)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,5)*P(4,2)*Metric(1,2)*Metric(5,6) + P(3,6)*P(4,2)*Metric(1,2)*Metric(5,6) + P(3,1)*P(4,5)*Metric(1,2)*Metric(5,6) + P(3,2)*P(4,5)*Metric(1,2)*Metric(5,6) + P(3,1)*P(4,6)*Metric(1,2)*Metric(5,6) + P(3,2)*P(4,6)*Metric(1,2)*Metric(5,6) - P(2,1)*P(4,5)*Metric(1,3)*Metric(5,6) - P(2,1)*P(4,6)*Metric(1,3)*Metric(5,6) - P(2,1)*P(3,5)*Metric(1,4)*Metric(5,6) - P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) - P(1,2)*P(4,5)*Metric(2,3)*Metric(5,6) - P(1,2)*P(4,6)*Metric(2,3)*Metric(5,6) - P(1,2)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,2)*P(3,6)*Metric(2,4)*Metric(5,6)')

VVVVVV12 = Lorentz(name = 'VVVVVV12',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,1)*Metric(1,4)*Metric(2,3) + P(4,2)*P(6,1)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,1)*Metric(1,5)*Metric(2,3) - P(4,2)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,3)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,3)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3) - P(4,2)*P(5,6)*Metric(1,6)*Metric(2,3) - P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,2)*Metric(1,3)*Metric(2,4) - P(3,2)*P(6,1)*Metric(1,5)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) + P(3,2)*P(5,1)*Metric(1,6)*Metric(2,4) + P(3,2)*P(5,6)*Metric(1,6)*Metric(2,4) + P(4,1)*P(6,2)*Metric(1,3)*Metric(2,5) + P(4,3)*P(6,2)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,1)*P(6,2)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,2)*P(4,6)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) - P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) - P(4,1)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,3)*P(5,2)*Metric(1,3)*Metric(2,6) - P(4,2)*P(5,3)*Metric(1,3)*Metric(2,6) - P(4,6)*P(5,3)*Metric(1,3)*Metric(2,6) - P(4,1)*P(5,6)*Metric(1,3)*Metric(2,6) - P(4,3)*P(5,6)*Metric(1,3)*Metric(2,6) + P(3,1)*P(5,2)*Metric(1,4)*Metric(2,6) + P(3,1)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) + P(5,1)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,2)*P(6,3)*Metric(1,2)*Metric(3,4) - P(2,3)*P(6,1)*Metric(1,5)*Metric(3,4) - P(2,1)*P(6,3)*Metric(1,5)*Metric(3,4) + P(2,3)*P(5,1)*Metric(1,6)*Metric(3,4) + P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4) - P(1,3)*P(6,2)*Metric(2,5)*Metric(3,4) - P(1,2)*P(6,3)*Metric(2,5)*Metric(3,4) + P(1,3)*P(5,2)*Metric(2,6)*Metric(3,4) + P(1,3)*P(5,6)*Metric(2,6)*Metric(3,4) + P(4,1)*P(6,3)*Metric(1,2)*Metric(3,5) + P(4,2)*P(6,3)*Metric(1,2)*Metric(3,5) - P(2,3)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,1)*P(6,3)*Metric(1,4)*Metric(3,5) + P(2,3)*P(4,1)*Metric(1,6)*Metric(3,5) + P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5) - P(1,3)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,2)*P(6,3)*Metric(2,4)*Metric(3,5) + P(1,3)*P(4,2)*Metric(2,6)*Metric(3,5) + P(1,3)*P(4,6)*Metric(2,6)*Metric(3,5) - P(4,3)*P(5,1)*Metric(1,2)*Metric(3,6) - P(4,6)*P(5,1)*Metric(1,2)*Metric(3,6) - P(4,3)*P(5,2)*Metric(1,2)*Metric(3,6) - P(4,6)*P(5,2)*Metric(1,2)*Metric(3,6) - P(4,1)*P(5,3)*Metric(1,2)*Metric(3,6) - P(4,2)*P(5,3)*Metric(1,2)*Metric(3,6) - P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) - P(4,2)*P(5,6)*Metric(1,2)*Metric(3,6) + P(2,1)*P(5,3)*Metric(1,4)*Metric(3,6) + P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) + P(2,1)*P(4,3)*Metric(1,5)*Metric(3,6) + P(2,1)*P(4,6)*Metric(1,5)*Metric(3,6) + P(1,2)*P(5,3)*Metric(2,4)*Metric(3,6) + P(1,2)*P(5,6)*Metric(2,4)*Metric(3,6) + P(1,2)*P(4,3)*Metric(2,5)*Metric(3,6) + P(1,2)*P(4,6)*Metric(2,5)*Metric(3,6) + P(3,6)*P(5,1)*Metric(1,2)*Metric(4,6) + P(3,6)*P(5,2)*Metric(1,2)*Metric(4,6) + P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) + P(2,6)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) - P(2,1)*P(3,6)*Metric(1,5)*Metric(4,6) + P(1,6)*P(5,2)*Metric(2,3)*Metric(4,6) + P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6) - P(1,6)*P(3,2)*Metric(2,5)*Metric(4,6) - P(1,2)*P(3,6)*Metric(2,5)*Metric(4,6) - P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6) - P(1,3)*P(2,6)*Metric(3,5)*Metric(4,6) + P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) + P(3,6)*P(4,2)*Metric(1,2)*Metric(5,6) + P(2,6)*P(4,1)*Metric(1,3)*Metric(5,6) + P(2,6)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,6)*P(3,1)*Metric(1,4)*Metric(5,6) - P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) + P(1,6)*P(4,2)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6) - P(1,6)*P(3,2)*Metric(2,4)*Metric(5,6) - P(1,2)*P(3,6)*Metric(2,4)*Metric(5,6) - P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,3)*P(2,6)*Metric(3,4)*Metric(5,6)')

VVVVVV13 = Lorentz(name = 'VVVVVV13',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,4)*P(6,2)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,2)*P(6,4)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,4)*Metric(1,4)*Metric(2,3) + P(4,5)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,5)*P(6,3)*Metric(1,5)*Metric(2,3) + P(4,2)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,6)*P(5,2)*Metric(1,6)*Metric(2,3) + P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3) + P(4,2)*P(5,6)*Metric(1,6)*Metric(2,3) + P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,4)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,2)*P(6,5)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4) - P(3,2)*P(5,6)*Metric(1,6)*Metric(2,4) + P(4,5)*P(6,1)*Metric(1,3)*Metric(2,5) + P(4,5)*P(6,3)*Metric(1,3)*Metric(2,5) + P(4,1)*P(6,5)*Metric(1,3)*Metric(2,5) + P(4,3)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,4)*Metric(1,4)*Metric(2,5) - P(3,1)*P(6,5)*Metric(1,4)*Metric(2,5) - P(3,1)*P(4,5)*Metric(1,6)*Metric(2,5) - P(3,2)*P(4,6)*Metric(1,6)*Metric(2,5) + P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,6)*P(5,3)*Metric(1,3)*Metric(2,6) + P(4,1)*P(5,6)*Metric(1,3)*Metric(2,6) + P(4,3)*P(5,6)*Metric(1,3)*Metric(2,6) - P(3,2)*P(5,4)*Metric(1,4)*Metric(2,6) - P(3,1)*P(5,6)*Metric(1,4)*Metric(2,6) - P(3,2)*P(4,5)*Metric(1,5)*Metric(2,6) - P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) + P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,4)*P(6,2)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,4)*Metric(1,2)*Metric(3,4) + P(5,2)*P(6,4)*Metric(1,2)*Metric(3,4) - P(2,1)*P(6,4)*Metric(1,5)*Metric(3,4) - P(2,3)*P(6,5)*Metric(1,5)*Metric(3,4) - P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4) - P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4) - P(1,2)*P(6,4)*Metric(2,5)*Metric(3,4) - P(1,3)*P(6,5)*Metric(2,5)*Metric(3,4) - P(1,2)*P(5,4)*Metric(2,6)*Metric(3,4) - P(1,3)*P(5,6)*Metric(2,6)*Metric(3,4) + P(4,5)*P(6,1)*Metric(1,2)*Metric(3,5) + P(4,5)*P(6,2)*Metric(1,2)*Metric(3,5) + P(4,1)*P(6,5)*Metric(1,2)*Metric(3,5) + P(4,2)*P(6,5)*Metric(1,2)*Metric(3,5) - P(2,3)*P(6,4)*Metric(1,4)*Metric(3,5) - P(2,1)*P(6,5)*Metric(1,4)*Metric(3,5) - P(2,1)*P(4,5)*Metric(1,6)*Metric(3,5) - P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5) - P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,2)*P(6,5)*Metric(2,4)*Metric(3,5) - P(1,2)*P(4,5)*Metric(2,6)*Metric(3,5) - P(1,3)*P(4,6)*Metric(2,6)*Metric(3,5) + P(4,6)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,6)*P(5,2)*Metric(1,2)*Metric(3,6) + P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) + P(4,2)*P(5,6)*Metric(1,2)*Metric(3,6) - P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6) - P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,3)*P(4,5)*Metric(1,5)*Metric(3,6) - P(2,1)*P(4,6)*Metric(1,5)*Metric(3,6) - P(1,3)*P(5,4)*Metric(2,4)*Metric(3,6) - P(1,2)*P(5,6)*Metric(2,4)*Metric(3,6) - P(1,3)*P(4,5)*Metric(2,5)*Metric(3,6) - P(1,2)*P(4,6)*Metric(2,5)*Metric(3,6) - P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5) - P(3,5)*P(6,1)*Metric(1,2)*Metric(4,5) - P(3,4)*P(6,2)*Metric(1,2)*Metric(4,5) - P(3,5)*P(6,2)*Metric(1,2)*Metric(4,5) - P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,5)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,4)*P(6,3)*Metric(1,3)*Metric(4,5) - P(2,5)*P(6,3)*Metric(1,3)*Metric(4,5) + P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,5)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,5)*Metric(1,6)*Metric(4,5) - P(1,4)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,5)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5) - P(1,5)*P(6,3)*Metric(2,3)*Metric(4,5) + P(1,4)*P(3,2)*Metric(2,6)*Metric(4,5) + P(1,5)*P(3,2)*Metric(2,6)*Metric(4,5) + P(1,2)*P(3,4)*Metric(2,6)*Metric(4,5) + P(1,2)*P(3,5)*Metric(2,6)*Metric(4,5) + P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,5)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,3)*P(2,4)*Metric(3,6)*Metric(4,5) + P(1,3)*P(2,5)*Metric(3,6)*Metric(4,5) - P(3,4)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,6)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,4)*P(5,2)*Metric(1,2)*Metric(4,6) - P(3,6)*P(5,2)*Metric(1,2)*Metric(4,6) - P(2,4)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,3)*Metric(1,3)*Metric(4,6) + P(2,4)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,4)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,6)*Metric(1,5)*Metric(4,6) - P(1,4)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,4)*P(5,3)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6) + P(1,4)*P(3,2)*Metric(2,5)*Metric(4,6) + P(1,6)*P(3,2)*Metric(2,5)*Metric(4,6) + P(1,2)*P(3,4)*Metric(2,5)*Metric(4,6) + P(1,2)*P(3,6)*Metric(2,5)*Metric(4,6) + P(1,4)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,6)*Metric(3,5)*Metric(4,6) - P(3,5)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,5)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,2)*Metric(1,2)*Metric(5,6) - P(2,5)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,5)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,5)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) - P(1,5)*P(4,2)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,2)*Metric(2,3)*Metric(5,6) - P(1,5)*P(4,3)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,5)*P(3,2)*Metric(2,4)*Metric(5,6) + P(1,6)*P(3,2)*Metric(2,4)*Metric(5,6) + P(1,2)*P(3,5)*Metric(2,4)*Metric(5,6) + P(1,2)*P(3,6)*Metric(2,4)*Metric(5,6) + P(1,5)*P(2,3)*Metric(3,4)*Metric(5,6) + P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6) + P(1,3)*P(2,5)*Metric(3,4)*Metric(5,6) + P(1,3)*P(2,6)*Metric(3,4)*Metric(5,6)')

VVVVVV14 = Lorentz(name = 'VVVVVV14',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,4)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,5)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4) - P(3,6)*P(5,4)*Metric(1,6)*Metric(2,4) + P(4,5)*P(6,1)*Metric(1,3)*Metric(2,5) + P(4,1)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,1)*P(6,5)*Metric(1,4)*Metric(2,5) - P(3,4)*P(6,5)*Metric(1,4)*Metric(2,5) - P(3,1)*P(4,5)*Metric(1,6)*Metric(2,5) - P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) + P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,1)*P(5,6)*Metric(1,3)*Metric(2,6) - P(3,1)*P(5,6)*Metric(1,4)*Metric(2,6) - P(3,4)*P(5,6)*Metric(1,4)*Metric(2,6) - P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) - P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) + P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4) + P(5,1)*P(6,4)*Metric(1,2)*Metric(3,4) - P(2,1)*P(6,4)*Metric(1,5)*Metric(3,4) - P(2,5)*P(6,4)*Metric(1,5)*Metric(3,4) - P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4) - P(2,6)*P(5,4)*Metric(1,6)*Metric(3,4) + P(1,5)*P(6,4)*Metric(2,5)*Metric(3,4) + P(1,4)*P(6,5)*Metric(2,5)*Metric(3,4) + P(1,6)*P(5,4)*Metric(2,6)*Metric(3,4) + P(1,4)*P(5,6)*Metric(2,6)*Metric(3,4) + P(4,5)*P(6,1)*Metric(1,2)*Metric(3,5) + P(4,1)*P(6,5)*Metric(1,2)*Metric(3,5) - P(2,1)*P(6,5)*Metric(1,4)*Metric(3,5) - P(2,4)*P(6,5)*Metric(1,4)*Metric(3,5) - P(2,1)*P(4,5)*Metric(1,6)*Metric(3,5) - P(2,6)*P(4,5)*Metric(1,6)*Metric(3,5) + P(1,5)*P(6,4)*Metric(2,4)*Metric(3,5) + P(1,4)*P(6,5)*Metric(2,4)*Metric(3,5) + P(1,6)*P(4,5)*Metric(2,6)*Metric(3,5) + P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) + P(4,6)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) - P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,4)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,1)*P(4,6)*Metric(1,5)*Metric(3,6) - P(2,5)*P(4,6)*Metric(1,5)*Metric(3,6) + P(1,6)*P(5,4)*Metric(2,4)*Metric(3,6) + P(1,4)*P(5,6)*Metric(2,4)*Metric(3,6) + P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) + P(1,5)*P(4,6)*Metric(2,5)*Metric(3,6) - P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5) - P(3,5)*P(6,1)*Metric(1,2)*Metric(4,5) - P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,5)*P(6,1)*Metric(1,3)*Metric(4,5) + P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,5)*P(3,1)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5) + P(2,6)*P(3,4)*Metric(1,6)*Metric(4,5) + P(2,1)*P(3,5)*Metric(1,6)*Metric(4,5) + P(2,6)*P(3,5)*Metric(1,6)*Metric(4,5) + P(2,4)*P(3,6)*Metric(1,6)*Metric(4,5) + P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) - P(1,6)*P(3,4)*Metric(2,6)*Metric(4,5) - P(1,6)*P(3,5)*Metric(2,6)*Metric(4,5) - P(1,6)*P(2,4)*Metric(3,6)*Metric(4,5) - P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) - P(3,4)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,6)*P(5,1)*Metric(1,2)*Metric(4,6) - P(2,4)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) + P(2,4)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,4)*Metric(1,5)*Metric(4,6) + P(2,5)*P(3,4)*Metric(1,5)*Metric(4,6) + P(2,4)*P(3,5)*Metric(1,5)*Metric(4,6) + P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) + P(2,1)*P(3,6)*Metric(1,5)*Metric(4,6) + P(2,5)*P(3,6)*Metric(1,5)*Metric(4,6) - P(1,5)*P(3,4)*Metric(2,5)*Metric(4,6) - P(1,5)*P(3,6)*Metric(2,5)*Metric(4,6) - P(1,5)*P(2,4)*Metric(3,5)*Metric(4,6) - P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6) - P(3,5)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) - P(2,5)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,1)*Metric(1,3)*Metric(5,6) + P(2,5)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,1)*Metric(1,4)*Metric(5,6) + P(2,5)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,4)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) + P(2,4)*P(3,6)*Metric(1,4)*Metric(5,6) - P(1,4)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,4)*P(3,6)*Metric(2,4)*Metric(5,6) - P(1,4)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,6)*Metric(3,4)*Metric(5,6)')

VVVVVV15 = Lorentz(name = 'VVVVVV15',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,4)*Metric(1,4)*Metric(2,3) + P(4,5)*P(6,3)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,5)*Metric(1,5)*Metric(2,3) + P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3) + P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,4)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) + P(3,5)*P(6,4)*Metric(1,5)*Metric(2,4) + P(3,4)*P(6,5)*Metric(1,5)*Metric(2,4) + P(3,6)*P(5,4)*Metric(1,6)*Metric(2,4) + P(3,4)*P(5,6)*Metric(1,6)*Metric(2,4) + P(4,5)*P(6,3)*Metric(1,3)*Metric(2,5) + P(4,3)*P(6,5)*Metric(1,3)*Metric(2,5) + P(3,5)*P(6,4)*Metric(1,4)*Metric(2,5) + P(3,4)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,5)*P(4,6)*Metric(1,6)*Metric(2,5) + P(4,6)*P(5,3)*Metric(1,3)*Metric(2,6) + P(4,3)*P(5,6)*Metric(1,3)*Metric(2,6) + P(3,6)*P(5,4)*Metric(1,4)*Metric(2,6) + P(3,4)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,6)*P(4,5)*Metric(1,5)*Metric(2,6) + P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) - P(2,3)*P(6,5)*Metric(1,5)*Metric(3,4) - P(2,4)*P(6,5)*Metric(1,5)*Metric(3,4) - P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4) - P(2,4)*P(5,6)*Metric(1,6)*Metric(3,4) - P(1,3)*P(6,5)*Metric(2,5)*Metric(3,4) - P(1,4)*P(6,5)*Metric(2,5)*Metric(3,4) - P(1,3)*P(5,6)*Metric(2,6)*Metric(3,4) - P(1,4)*P(5,6)*Metric(2,6)*Metric(3,4) - P(2,3)*P(6,4)*Metric(1,4)*Metric(3,5) - P(2,5)*P(6,4)*Metric(1,4)*Metric(3,5) - P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5) - P(2,5)*P(4,6)*Metric(1,6)*Metric(3,5) - P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,5)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,3)*P(4,6)*Metric(2,6)*Metric(3,5) - P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) - P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6) - P(2,6)*P(5,4)*Metric(1,4)*Metric(3,6) - P(2,3)*P(4,5)*Metric(1,5)*Metric(3,6) - P(2,6)*P(4,5)*Metric(1,5)*Metric(3,6) - P(1,3)*P(5,4)*Metric(2,4)*Metric(3,6) - P(1,6)*P(5,4)*Metric(2,4)*Metric(3,6) - P(1,3)*P(4,5)*Metric(2,5)*Metric(3,6) - P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) - P(2,4)*P(6,3)*Metric(1,3)*Metric(4,5) - P(2,5)*P(6,3)*Metric(1,3)*Metric(4,5) - P(2,4)*P(3,6)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) - P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5) - P(1,5)*P(6,3)*Metric(2,3)*Metric(4,5) - P(1,4)*P(3,6)*Metric(2,6)*Metric(4,5) - P(1,5)*P(3,6)*Metric(2,6)*Metric(4,5) + P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,5)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,3)*P(2,4)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,4)*Metric(3,6)*Metric(4,5) + P(1,3)*P(2,5)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) + P(1,4)*P(2,6)*Metric(3,6)*Metric(4,5) + P(1,5)*P(2,6)*Metric(3,6)*Metric(4,5) - P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,6)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,4)*P(3,5)*Metric(1,5)*Metric(4,6) - P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) - P(1,4)*P(5,3)*Metric(2,3)*Metric(4,6) - P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6) - P(1,4)*P(3,5)*Metric(2,5)*Metric(4,6) - P(1,6)*P(3,5)*Metric(2,5)*Metric(4,6) + P(1,4)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6) + P(1,5)*P(2,4)*Metric(3,5)*Metric(4,6) + P(1,4)*P(2,5)*Metric(3,5)*Metric(4,6) + P(1,6)*P(2,5)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,6)*Metric(3,5)*Metric(4,6) + P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6) - P(2,5)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,6)*P(4,3)*Metric(1,3)*Metric(5,6) - P(2,5)*P(3,4)*Metric(1,4)*Metric(5,6) - P(2,6)*P(3,4)*Metric(1,4)*Metric(5,6) - P(1,5)*P(4,3)*Metric(2,3)*Metric(5,6) - P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6) - P(1,5)*P(3,4)*Metric(2,4)*Metric(5,6) - P(1,6)*P(3,4)*Metric(2,4)*Metric(5,6) + P(1,5)*P(2,3)*Metric(3,4)*Metric(5,6) + P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6) + P(1,5)*P(2,4)*Metric(3,4)*Metric(5,6) + P(1,6)*P(2,4)*Metric(3,4)*Metric(5,6) + P(1,3)*P(2,5)*Metric(3,4)*Metric(5,6) + P(1,4)*P(2,5)*Metric(3,4)*Metric(5,6) + P(1,3)*P(2,6)*Metric(3,4)*Metric(5,6) + P(1,4)*P(2,6)*Metric(3,4)*Metric(5,6)')

VVVVVV16 = Lorentz(name = 'VVVVVV16',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,1)*Metric(1,4)*Metric(2,3) + 2*P(5,4)*P(6,2)*Metric(1,4)*Metric(2,3) + 2*P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3) + 2*P(5,6)*P(6,5)*Metric(1,4)*Metric(2,3) + P(4,2)*P(6,1)*Metric(1,5)*Metric(2,3) + P(4,3)*P(6,1)*Metric(1,5)*Metric(2,3) + 2*P(4,5)*P(6,2)*Metric(1,5)*Metric(2,3) + 2*P(4,5)*P(6,3)*Metric(1,5)*Metric(2,3) + 2*P(4,6)*P(6,4)*Metric(1,5)*Metric(2,3) - P(4,2)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,3)*P(5,1)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,2)*Metric(1,6)*Metric(2,3) - P(4,1)*P(5,3)*Metric(1,6)*Metric(2,3) - P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3) - 4*P(4,5)*P(5,4)*Metric(1,6)*Metric(2,3) - P(4,2)*P(5,6)*Metric(1,6)*Metric(2,3) - P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3) - P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4) - P(5,3)*P(6,2)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) - P(5,6)*P(6,5)*Metric(1,3)*Metric(2,4) - P(3,2)*P(6,1)*Metric(1,5)*Metric(2,4) + P(3,5)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,6)*P(6,3)*Metric(1,5)*Metric(2,4) - P(3,5)*P(6,4)*Metric(1,5)*Metric(2,4) + P(3,2)*P(5,1)*Metric(1,6)*Metric(2,4) + 2*P(3,5)*P(5,3)*Metric(1,6)*Metric(2,4) + P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4) + P(3,6)*P(5,4)*Metric(1,6)*Metric(2,4) + P(3,2)*P(5,6)*Metric(1,6)*Metric(2,4) - P(4,5)*P(6,1)*Metric(1,3)*Metric(2,5) - P(4,3)*P(6,2)*Metric(1,3)*Metric(2,5) - P(4,6)*P(6,4)*Metric(1,3)*Metric(2,5) + P(4,3)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) + P(3,4)*P(6,2)*Metric(1,4)*Metric(2,5) - P(3,6)*P(6,3)*Metric(1,4)*Metric(2,5) - P(3,4)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) + 2*P(3,4)*P(4,3)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) + P(3,2)*P(4,6)*Metric(1,6)*Metric(2,5) + 2*P(4,6)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,3)*P(5,2)*Metric(1,3)*Metric(2,6) + P(4,2)*P(5,3)*Metric(1,3)*Metric(2,6) + 2*P(4,5)*P(5,4)*Metric(1,3)*Metric(2,6) + 2*P(4,1)*P(5,6)*Metric(1,3)*Metric(2,6) - P(3,4)*P(5,2)*Metric(1,4)*Metric(2,6) - P(3,5)*P(5,3)*Metric(1,4)*Metric(2,6) - 2*P(3,2)*P(5,4)*Metric(1,4)*Metric(2,6) - 2*P(3,1)*P(5,6)*Metric(1,4)*Metric(2,6) - P(3,5)*P(4,2)*Metric(1,5)*Metric(2,6) - P(3,4)*P(4,3)*Metric(1,5)*Metric(2,6) - 2*P(3,2)*P(4,5)*Metric(1,5)*Metric(2,6) - 2*P(3,1)*P(4,6)*Metric(1,5)*Metric(2,6) - P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4) - P(5,2)*P(6,3)*Metric(1,2)*Metric(3,4) + P(5,2)*P(6,4)*Metric(1,2)*Metric(3,4) - P(5,6)*P(6,5)*Metric(1,2)*Metric(3,4) - P(2,3)*P(6,1)*Metric(1,5)*Metric(3,4) - P(2,6)*P(6,2)*Metric(1,5)*Metric(3,4) + P(2,5)*P(6,3)*Metric(1,5)*Metric(3,4) - P(2,5)*P(6,4)*Metric(1,5)*Metric(3,4) + P(2,3)*P(5,1)*Metric(1,6)*Metric(3,4) + 2*P(2,5)*P(5,2)*Metric(1,6)*Metric(3,4) + P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4) + P(2,6)*P(5,4)*Metric(1,6)*Metric(3,4) + P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4) + 2*P(1,6)*P(6,1)*Metric(2,5)*Metric(3,4) + P(1,3)*P(6,2)*Metric(2,5)*Metric(3,4) - P(1,4)*P(6,2)*Metric(2,5)*Metric(3,4) + P(1,2)*P(6,3)*Metric(2,5)*Metric(3,4) - P(1,5)*P(6,3)*Metric(2,5)*Metric(3,4) - P(1,2)*P(6,4)*Metric(2,5)*Metric(3,4) + P(1,5)*P(6,4)*Metric(2,5)*Metric(3,4) - P(1,3)*P(6,5)*Metric(2,5)*Metric(3,4) + P(1,4)*P(6,5)*Metric(2,5)*Metric(3,4) - 2*P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(1,5)*P(5,1)*Metric(2,6)*Metric(3,4) - P(1,3)*P(5,2)*Metric(2,6)*Metric(3,4) + P(1,4)*P(5,2)*Metric(2,6)*Metric(3,4) - P(1,6)*P(5,4)*Metric(2,6)*Metric(3,4) + P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(4,5)*P(6,1)*Metric(1,2)*Metric(3,5) - P(4,2)*P(6,3)*Metric(1,2)*Metric(3,5) - P(4,6)*P(6,4)*Metric(1,2)*Metric(3,5) + P(4,2)*P(6,5)*Metric(1,2)*Metric(3,5) - P(2,3)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,6)*P(6,2)*Metric(1,4)*Metric(3,5) + P(2,4)*P(6,3)*Metric(1,4)*Metric(3,5) - P(2,4)*P(6,5)*Metric(1,4)*Metric(3,5) + P(2,3)*P(4,1)*Metric(1,6)*Metric(3,5) + 2*P(2,4)*P(4,2)*Metric(1,6)*Metric(3,5) + P(2,1)*P(4,5)*Metric(1,6)*Metric(3,5) + P(2,6)*P(4,5)*Metric(1,6)*Metric(3,5) + P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5) + 2*P(1,6)*P(6,1)*Metric(2,4)*Metric(3,5) + P(1,3)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,5)*P(6,2)*Metric(2,4)*Metric(3,5) + P(1,2)*P(6,3)*Metric(2,4)*Metric(3,5) - P(1,4)*P(6,3)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) + P(1,5)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,2)*P(6,5)*Metric(2,4)*Metric(3,5) + P(1,4)*P(6,5)*Metric(2,4)*Metric(3,5) - 2*P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(1,4)*P(4,1)*Metric(2,6)*Metric(3,5) - P(1,3)*P(4,2)*Metric(2,6)*Metric(3,5) + P(1,5)*P(4,2)*Metric(2,6)*Metric(3,5) - P(1,6)*P(4,5)*Metric(2,6)*Metric(3,5) + P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 2*P(4,6)*P(5,1)*Metric(1,2)*Metric(3,6) + P(4,3)*P(5,2)*Metric(1,2)*Metric(3,6) + P(4,2)*P(5,3)*Metric(1,2)*Metric(3,6) + 2*P(4,5)*P(5,4)*Metric(1,2)*Metric(3,6) + 2*P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) - P(2,5)*P(5,2)*Metric(1,4)*Metric(3,6) - P(2,4)*P(5,3)*Metric(1,4)*Metric(3,6) - 2*P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6) - 2*P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,4)*P(4,2)*Metric(1,5)*Metric(3,6) - P(2,5)*P(4,3)*Metric(1,5)*Metric(3,6) - 2*P(2,3)*P(4,5)*Metric(1,5)*Metric(3,6) - 2*P(2,1)*P(4,6)*Metric(1,5)*Metric(3,6) - P(1,5)*P(5,1)*Metric(2,4)*Metric(3,6) - P(1,2)*P(5,3)*Metric(2,4)*Metric(3,6) + P(1,4)*P(5,3)*Metric(2,4)*Metric(3,6) - P(1,6)*P(5,4)*Metric(2,4)*Metric(3,6) + P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(1,4)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,2)*P(4,3)*Metric(2,5)*Metric(3,6) + P(1,5)*P(4,3)*Metric(2,5)*Metric(3,6) - P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) + P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5) + P(3,5)*P(6,1)*Metric(1,2)*Metric(4,5) + 2*P(3,6)*P(6,3)*Metric(1,2)*Metric(4,5) + 2*P(3,2)*P(6,4)*Metric(1,2)*Metric(4,5) + 2*P(3,2)*P(6,5)*Metric(1,2)*Metric(4,5) + P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5) + P(2,5)*P(6,1)*Metric(1,3)*Metric(4,5) + 2*P(2,6)*P(6,2)*Metric(1,3)*Metric(4,5) + 2*P(2,3)*P(6,4)*Metric(1,3)*Metric(4,5) + 2*P(2,3)*P(6,5)*Metric(1,3)*Metric(4,5) - P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,1)*Metric(1,6)*Metric(4,5) - 4*P(2,3)*P(3,2)*Metric(1,6)*Metric(4,5) - P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5) - P(2,6)*P(3,4)*Metric(1,6)*Metric(4,5) - P(2,1)*P(3,5)*Metric(1,6)*Metric(4,5) - P(2,6)*P(3,5)*Metric(1,6)*Metric(4,5) - P(2,4)*P(3,6)*Metric(1,6)*Metric(4,5) - P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) - 4*P(1,6)*P(6,1)*Metric(2,3)*Metric(4,5) - 2*P(1,4)*P(6,2)*Metric(2,3)*Metric(4,5) - 2*P(1,5)*P(6,2)*Metric(2,3)*Metric(4,5) - 2*P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5) - 2*P(1,5)*P(6,3)*Metric(2,3)*Metric(4,5) - 2*P(1,2)*P(6,4)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*P(6,4)*Metric(2,3)*Metric(4,5) - 2*P(1,2)*P(6,5)*Metric(2,3)*Metric(4,5) - 2*P(1,3)*P(6,5)*Metric(2,3)*Metric(4,5) + 4*P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 4*P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 4*P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(1,3)*P(3,1)*Metric(2,6)*Metric(4,5) + 2*P(1,4)*P(3,2)*Metric(2,6)*Metric(4,5) + 2*P(1,5)*P(3,2)*Metric(2,6)*Metric(4,5) + P(1,6)*P(3,4)*Metric(2,6)*Metric(4,5) + P(1,6)*P(3,5)*Metric(2,6)*Metric(4,5) - 2*P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) - 2*P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) - 2*P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(1,2)*P(2,1)*Metric(3,6)*Metric(4,5) + 2*P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5) + 2*P(1,5)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,4)*Metric(3,6)*Metric(4,5) + P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) - 2*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(3,6)*P(5,1)*Metric(1,2)*Metric(4,6) - P(3,4)*P(5,2)*Metric(1,2)*Metric(4,6) - P(3,5)*P(5,3)*Metric(1,2)*Metric(4,6) - 2*P(3,2)*P(5,4)*Metric(1,2)*Metric(4,6) - 2*P(2,6)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,5)*P(5,2)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) - 2*P(2,3)*P(5,4)*Metric(1,3)*Metric(4,6) + 2*P(2,6)*P(3,1)*Metric(1,5)*Metric(4,6) + 2*P(2,3)*P(3,2)*Metric(1,5)*Metric(4,6) + P(2,5)*P(3,4)*Metric(1,5)*Metric(4,6) + P(2,4)*P(3,5)*Metric(1,5)*Metric(4,6) + 2*P(2,1)*P(3,6)*Metric(1,5)*Metric(4,6) + 2*P(1,5)*P(5,1)*Metric(2,3)*Metric(4,6) + P(1,6)*P(5,2)*Metric(2,3)*Metric(4,6) + P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6) + 2*P(1,2)*P(5,4)*Metric(2,3)*Metric(4,6) + 2*P(1,3)*P(5,4)*Metric(2,3)*Metric(4,6) - 2*P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) - 2*P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - 2*P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(1,3)*P(3,1)*Metric(2,5)*Metric(4,6) - P(1,6)*P(3,2)*Metric(2,5)*Metric(4,6) + P(1,2)*P(3,4)*Metric(2,5)*Metric(4,6) - P(1,5)*P(3,4)*Metric(2,5)*Metric(4,6) + P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(1,2)*P(2,1)*Metric(3,5)*Metric(4,6) - P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6) - P(1,5)*P(2,4)*Metric(3,5)*Metric(4,6) + P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,5)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,4)*P(4,3)*Metric(1,2)*Metric(5,6) - 2*P(3,2)*P(4,5)*Metric(1,2)*Metric(5,6) - 2*P(2,6)*P(4,1)*Metric(1,3)*Metric(5,6) - P(2,4)*P(4,2)*Metric(1,3)*Metric(5,6) - P(2,5)*P(4,3)*Metric(1,3)*Metric(5,6) - 2*P(2,3)*P(4,5)*Metric(1,3)*Metric(5,6) + 2*P(2,6)*P(3,1)*Metric(1,4)*Metric(5,6) + 2*P(2,3)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,5)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,4)*P(3,5)*Metric(1,4)*Metric(5,6) + 2*P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) + 2*P(1,4)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,2)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6) + 2*P(1,2)*P(4,5)*Metric(2,3)*Metric(5,6) + 2*P(1,3)*P(4,5)*Metric(2,3)*Metric(5,6) - 2*P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(1,3)*P(3,1)*Metric(2,4)*Metric(5,6) - P(1,6)*P(3,2)*Metric(2,4)*Metric(5,6) + P(1,2)*P(3,5)*Metric(2,4)*Metric(5,6) - P(1,4)*P(3,5)*Metric(2,4)*Metric(5,6) + P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(1,2)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6) + P(1,3)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,5)*Metric(3,4)*Metric(5,6) + P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV17 = Lorentz(name = 'VVVVVV17',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,2)*Metric(1,4)*Metric(2,3) + (P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3))/2. + (P(5,3)*P(6,4)*Metric(1,4)*Metric(2,3))/2. + P(5,6)*P(6,5)*Metric(1,4)*Metric(2,3) - P(4,1)*P(6,2)*Metric(1,5)*Metric(2,3) - (P(4,5)*P(6,3)*Metric(1,5)*Metric(2,3))/2. - (P(4,6)*P(6,4)*Metric(1,5)*Metric(2,3))/2. - P(4,3)*P(6,5)*Metric(1,5)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) - (P(4,6)*P(5,3)*Metric(1,6)*Metric(2,3))/2. - (P(4,5)*P(5,4)*Metric(1,6)*Metric(2,3))/2. - P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,2)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) + (P(5,4)*P(6,3)*Metric(1,3)*Metric(2,4))/2. + (P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4))/2. + P(5,6)*P(6,5)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) - (P(3,6)*P(6,3)*Metric(1,5)*Metric(2,4))/2. - (P(3,5)*P(6,4)*Metric(1,5)*Metric(2,4))/2. - P(3,4)*P(6,5)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,2)*Metric(1,6)*Metric(2,4) - (P(3,5)*P(5,3)*Metric(1,6)*Metric(2,4))/2. - (P(3,6)*P(5,4)*Metric(1,6)*Metric(2,4))/2. - P(3,4)*P(5,6)*Metric(1,6)*Metric(2,4) - P(4,2)*P(6,1)*Metric(1,3)*Metric(2,5) - (P(4,5)*P(6,3)*Metric(1,3)*Metric(2,5))/2. - (P(4,6)*P(6,4)*Metric(1,3)*Metric(2,5))/2. - P(4,3)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) - (P(3,6)*P(6,3)*Metric(1,4)*Metric(2,5))/2. - (P(3,5)*P(6,4)*Metric(1,4)*Metric(2,5))/2. - P(3,4)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,2)*Metric(1,6)*Metric(2,5) + P(3,4)*P(4,3)*Metric(1,6)*Metric(2,5) + (P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5))/2. + (P(3,5)*P(4,6)*Metric(1,6)*Metric(2,5))/2. - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) - (P(4,6)*P(5,3)*Metric(1,3)*Metric(2,6))/2. - (P(4,5)*P(5,4)*Metric(1,3)*Metric(2,6))/2. - P(4,3)*P(5,6)*Metric(1,3)*Metric(2,6) - P(3,2)*P(5,1)*Metric(1,4)*Metric(2,6) - (P(3,5)*P(5,3)*Metric(1,4)*Metric(2,6))/2. - (P(3,6)*P(5,4)*Metric(1,4)*Metric(2,6))/2. - P(3,4)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,2)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) + P(3,4)*P(4,3)*Metric(1,5)*Metric(2,6) + (P(3,6)*P(4,5)*Metric(1,5)*Metric(2,6))/2. + (P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6))/2. - (P(5,3)*P(6,1)*Metric(1,2)*Metric(3,4))/2. - (P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4))/2. - (P(5,3)*P(6,2)*Metric(1,2)*Metric(3,4))/2. - (P(5,4)*P(6,2)*Metric(1,2)*Metric(3,4))/2. - (P(5,1)*P(6,3)*Metric(1,2)*Metric(3,4))/2. - (P(5,2)*P(6,3)*Metric(1,2)*Metric(3,4))/2. - (P(5,1)*P(6,4)*Metric(1,2)*Metric(3,4))/2. - (P(5,2)*P(6,4)*Metric(1,2)*Metric(3,4))/2. - 2*P(5,6)*P(6,5)*Metric(1,2)*Metric(3,4) + P(2,6)*P(6,2)*Metric(1,5)*Metric(3,4) + (P(2,1)*P(6,3)*Metric(1,5)*Metric(3,4))/2. + (P(2,1)*P(6,4)*Metric(1,5)*Metric(3,4))/2. + P(2,3)*P(6,5)*Metric(1,5)*Metric(3,4) + P(2,4)*P(6,5)*Metric(1,5)*Metric(3,4) + P(2,5)*P(5,2)*Metric(1,6)*Metric(3,4) + (P(2,1)*P(5,3)*Metric(1,6)*Metric(3,4))/2. + (P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4))/2. + P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4) + P(2,4)*P(5,6)*Metric(1,6)*Metric(3,4) + P(1,6)*P(6,1)*Metric(2,5)*Metric(3,4) + (P(1,2)*P(6,3)*Metric(2,5)*Metric(3,4))/2. + (P(1,2)*P(6,4)*Metric(2,5)*Metric(3,4))/2. + P(1,3)*P(6,5)*Metric(2,5)*Metric(3,4) + P(1,4)*P(6,5)*Metric(2,5)*Metric(3,4) - P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(1,5)*P(5,1)*Metric(2,6)*Metric(3,4) + (P(1,2)*P(5,3)*Metric(2,6)*Metric(3,4))/2. + (P(1,2)*P(5,4)*Metric(2,6)*Metric(3,4))/2. + P(1,3)*P(5,6)*Metric(2,6)*Metric(3,4) + P(1,4)*P(5,6)*Metric(2,6)*Metric(3,4) - P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + (P(4,3)*P(6,1)*Metric(1,2)*Metric(3,5))/2. + (P(4,3)*P(6,2)*Metric(1,2)*Metric(3,5))/2. + P(4,6)*P(6,4)*Metric(1,2)*Metric(3,5) + (P(4,1)*P(6,5)*Metric(1,2)*Metric(3,5))/2. + (P(4,2)*P(6,5)*Metric(1,2)*Metric(3,5))/2. - (P(2,6)*P(6,2)*Metric(1,4)*Metric(3,5))/2. - (P(2,3)*P(6,4)*Metric(1,4)*Metric(3,5))/2. + (P(2,5)*P(6,4)*Metric(1,4)*Metric(3,5))/2. - (P(2,1)*P(6,5)*Metric(1,4)*Metric(3,5))/2. - (P(2,4)*P(4,2)*Metric(1,6)*Metric(3,5))/2. - (P(2,1)*P(4,3)*Metric(1,6)*Metric(3,5))/2. + (P(2,3)*P(4,6)*Metric(1,6)*Metric(3,5))/2. - (P(2,5)*P(4,6)*Metric(1,6)*Metric(3,5))/2. - (P(1,6)*P(6,1)*Metric(2,4)*Metric(3,5))/2. - (P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5))/2. + (P(1,5)*P(6,4)*Metric(2,4)*Metric(3,5))/2. - (P(1,2)*P(6,5)*Metric(2,4)*Metric(3,5))/2. + (P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(1,4)*P(4,1)*Metric(2,6)*Metric(3,5))/2. - (P(1,2)*P(4,3)*Metric(2,6)*Metric(3,5))/2. + (P(1,3)*P(4,6)*Metric(2,6)*Metric(3,5))/2. - (P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5))/2. + (P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(4,3)*P(5,1)*Metric(1,2)*Metric(3,6))/2. + (P(4,3)*P(5,2)*Metric(1,2)*Metric(3,6))/2. + P(4,5)*P(5,4)*Metric(1,2)*Metric(3,6) + (P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6))/2. + (P(4,2)*P(5,6)*Metric(1,2)*Metric(3,6))/2. - (P(2,5)*P(5,2)*Metric(1,4)*Metric(3,6))/2. - (P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6))/2. + (P(2,6)*P(5,4)*Metric(1,4)*Metric(3,6))/2. - (P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6))/2. - (P(2,4)*P(4,2)*Metric(1,5)*Metric(3,6))/2. - (P(2,1)*P(4,3)*Metric(1,5)*Metric(3,6))/2. + (P(2,3)*P(4,5)*Metric(1,5)*Metric(3,6))/2. - (P(2,6)*P(4,5)*Metric(1,5)*Metric(3,6))/2. - (P(1,5)*P(5,1)*Metric(2,4)*Metric(3,6))/2. - (P(1,3)*P(5,4)*Metric(2,4)*Metric(3,6))/2. + (P(1,6)*P(5,4)*Metric(2,4)*Metric(3,6))/2. - (P(1,2)*P(5,6)*Metric(2,4)*Metric(3,6))/2. + (P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(1,4)*P(4,1)*Metric(2,5)*Metric(3,6))/2. - (P(1,2)*P(4,3)*Metric(2,5)*Metric(3,6))/2. + (P(1,3)*P(4,5)*Metric(2,5)*Metric(3,6))/2. - (P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6))/2. + (P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5))/2. + (P(3,4)*P(6,2)*Metric(1,2)*Metric(4,5))/2. + P(3,6)*P(6,3)*Metric(1,2)*Metric(4,5) + (P(3,1)*P(6,5)*Metric(1,2)*Metric(4,5))/2. + (P(3,2)*P(6,5)*Metric(1,2)*Metric(4,5))/2. - (P(2,6)*P(6,2)*Metric(1,3)*Metric(4,5))/2. - (P(2,4)*P(6,3)*Metric(1,3)*Metric(4,5))/2. + (P(2,5)*P(6,3)*Metric(1,3)*Metric(4,5))/2. - (P(2,1)*P(6,5)*Metric(1,3)*Metric(4,5))/2. - (P(2,3)*P(3,2)*Metric(1,6)*Metric(4,5))/2. - (P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5))/2. + (P(2,4)*P(3,6)*Metric(1,6)*Metric(4,5))/2. - (P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5))/2. - (P(1,6)*P(6,1)*Metric(2,3)*Metric(4,5))/2. - (P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5))/2. + (P(1,5)*P(6,3)*Metric(2,3)*Metric(4,5))/2. - (P(1,2)*P(6,5)*Metric(2,3)*Metric(4,5))/2. + (P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(1,3)*P(3,1)*Metric(2,6)*Metric(4,5))/2. - (P(1,2)*P(3,4)*Metric(2,6)*Metric(4,5))/2. + (P(1,4)*P(3,6)*Metric(2,6)*Metric(4,5))/2. - (P(1,5)*P(3,6)*Metric(2,6)*Metric(4,5))/2. + (P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + P(1,2)*P(2,1)*Metric(3,6)*Metric(4,5) + (P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5))/2. - (P(1,5)*P(2,3)*Metric(3,6)*Metric(4,5))/2. + (P(1,3)*P(2,4)*Metric(3,6)*Metric(4,5))/2. - (P(1,6)*P(2,4)*Metric(3,6)*Metric(4,5))/2. - (P(1,3)*P(2,5)*Metric(3,6)*Metric(4,5))/2. + (P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5))/2. - (P(1,4)*P(2,6)*Metric(3,6)*Metric(4,5))/2. + (P(1,5)*P(2,6)*Metric(3,6)*Metric(4,5))/2. - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + (P(3,4)*P(5,1)*Metric(1,2)*Metric(4,6))/2. + (P(3,4)*P(5,2)*Metric(1,2)*Metric(4,6))/2. + P(3,5)*P(5,3)*Metric(1,2)*Metric(4,6) + (P(3,1)*P(5,6)*Metric(1,2)*Metric(4,6))/2. + (P(3,2)*P(5,6)*Metric(1,2)*Metric(4,6))/2. - (P(2,5)*P(5,2)*Metric(1,3)*Metric(4,6))/2. - (P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6))/2. + (P(2,6)*P(5,3)*Metric(1,3)*Metric(4,6))/2. - (P(2,1)*P(5,6)*Metric(1,3)*Metric(4,6))/2. - (P(2,3)*P(3,2)*Metric(1,5)*Metric(4,6))/2. - (P(2,1)*P(3,4)*Metric(1,5)*Metric(4,6))/2. + (P(2,4)*P(3,5)*Metric(1,5)*Metric(4,6))/2. - (P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6))/2. - (P(1,5)*P(5,1)*Metric(2,3)*Metric(4,6))/2. - (P(1,4)*P(5,3)*Metric(2,3)*Metric(4,6))/2. + (P(1,6)*P(5,3)*Metric(2,3)*Metric(4,6))/2. - (P(1,2)*P(5,6)*Metric(2,3)*Metric(4,6))/2. + (P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(1,3)*P(3,1)*Metric(2,5)*Metric(4,6))/2. - (P(1,2)*P(3,4)*Metric(2,5)*Metric(4,6))/2. + (P(1,4)*P(3,5)*Metric(2,5)*Metric(4,6))/2. - (P(1,6)*P(3,5)*Metric(2,5)*Metric(4,6))/2. + (P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + P(1,2)*P(2,1)*Metric(3,5)*Metric(4,6) + (P(1,4)*P(2,3)*Metric(3,5)*Metric(4,6))/2. - (P(1,6)*P(2,3)*Metric(3,5)*Metric(4,6))/2. + (P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6))/2. - (P(1,5)*P(2,4)*Metric(3,5)*Metric(4,6))/2. - (P(1,4)*P(2,5)*Metric(3,5)*Metric(4,6))/2. + (P(1,6)*P(2,5)*Metric(3,5)*Metric(4,6))/2. - (P(1,3)*P(2,6)*Metric(3,5)*Metric(4,6))/2. + (P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6))/2. - P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - (P(3,5)*P(4,1)*Metric(1,2)*Metric(5,6))/2. - (P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6))/2. - (P(3,5)*P(4,2)*Metric(1,2)*Metric(5,6))/2. - (P(3,6)*P(4,2)*Metric(1,2)*Metric(5,6))/2. - 2*P(3,4)*P(4,3)*Metric(1,2)*Metric(5,6) - (P(3,1)*P(4,5)*Metric(1,2)*Metric(5,6))/2. - (P(3,2)*P(4,5)*Metric(1,2)*Metric(5,6))/2. - (P(3,1)*P(4,6)*Metric(1,2)*Metric(5,6))/2. - (P(3,2)*P(4,6)*Metric(1,2)*Metric(5,6))/2. + P(2,4)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,5)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,6)*P(4,3)*Metric(1,3)*Metric(5,6) + (P(2,1)*P(4,5)*Metric(1,3)*Metric(5,6))/2. + (P(2,1)*P(4,6)*Metric(1,3)*Metric(5,6))/2. + P(2,3)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,5)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,4)*Metric(1,4)*Metric(5,6) + (P(2,1)*P(3,5)*Metric(1,4)*Metric(5,6))/2. + (P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6))/2. + P(1,4)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,5)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6) + (P(1,2)*P(4,5)*Metric(2,3)*Metric(5,6))/2. + (P(1,2)*P(4,6)*Metric(2,3)*Metric(5,6))/2. - P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(1,3)*P(3,1)*Metric(2,4)*Metric(5,6) + P(1,5)*P(3,4)*Metric(2,4)*Metric(5,6) + P(1,6)*P(3,4)*Metric(2,4)*Metric(5,6) + (P(1,2)*P(3,5)*Metric(2,4)*Metric(5,6))/2. + (P(1,2)*P(3,6)*Metric(2,4)*Metric(5,6))/2. - P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(1,2)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,5)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,5)*P(2,4)*Metric(3,4)*Metric(5,6) - P(1,6)*P(2,4)*Metric(3,4)*Metric(5,6) - P(1,3)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,3)*P(2,6)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,6)*Metric(3,4)*Metric(5,6) + 2*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVV18 = Lorentz(name = 'VVVVVV18',
                   spins = [ 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(5,2)*P(6,1)*Metric(1,4)*Metric(2,3) - P(5,3)*P(6,1)*Metric(1,4)*Metric(2,3) + P(5,1)*P(6,2)*Metric(1,4)*Metric(2,3) - P(5,4)*P(6,2)*Metric(1,4)*Metric(2,3) - P(5,1)*P(6,3)*Metric(1,4)*Metric(2,3) + P(5,4)*P(6,3)*Metric(1,4)*Metric(2,3) - P(5,2)*P(6,4)*Metric(1,4)*Metric(2,3) + P(5,3)*P(6,4)*Metric(1,4)*Metric(2,3) + 2*P(5,6)*P(6,5)*Metric(1,4)*Metric(2,3) - P(4,1)*P(6,2)*Metric(1,5)*Metric(2,3) + P(4,1)*P(6,3)*Metric(1,5)*Metric(2,3) - P(4,6)*P(6,4)*Metric(1,5)*Metric(2,3) - P(4,3)*P(6,5)*Metric(1,5)*Metric(2,3) - P(4,1)*P(5,2)*Metric(1,6)*Metric(2,3) + P(4,1)*P(5,3)*Metric(1,6)*Metric(2,3) - P(4,5)*P(5,4)*Metric(1,6)*Metric(2,3) - P(4,3)*P(5,6)*Metric(1,6)*Metric(2,3) + P(5,2)*P(6,1)*Metric(1,3)*Metric(2,4) - P(5,4)*P(6,1)*Metric(1,3)*Metric(2,4) + P(5,1)*P(6,2)*Metric(1,3)*Metric(2,4) - P(5,3)*P(6,2)*Metric(1,3)*Metric(2,4) - P(5,2)*P(6,3)*Metric(1,3)*Metric(2,4) + P(5,4)*P(6,3)*Metric(1,3)*Metric(2,4) - P(5,1)*P(6,4)*Metric(1,3)*Metric(2,4) + P(5,3)*P(6,4)*Metric(1,3)*Metric(2,4) + 2*P(5,6)*P(6,5)*Metric(1,3)*Metric(2,4) - P(3,1)*P(6,2)*Metric(1,5)*Metric(2,4) - P(3,6)*P(6,3)*Metric(1,5)*Metric(2,4) + P(3,1)*P(6,4)*Metric(1,5)*Metric(2,4) - P(3,4)*P(6,5)*Metric(1,5)*Metric(2,4) - P(3,1)*P(5,2)*Metric(1,6)*Metric(2,4) - P(3,5)*P(5,3)*Metric(1,6)*Metric(2,4) + P(3,1)*P(5,4)*Metric(1,6)*Metric(2,4) - P(3,4)*P(5,6)*Metric(1,6)*Metric(2,4) - P(4,2)*P(6,1)*Metric(1,3)*Metric(2,5) + P(4,2)*P(6,3)*Metric(1,3)*Metric(2,5) - P(4,6)*P(6,4)*Metric(1,3)*Metric(2,5) - P(4,3)*P(6,5)*Metric(1,3)*Metric(2,5) - P(3,2)*P(6,1)*Metric(1,4)*Metric(2,5) - P(3,6)*P(6,3)*Metric(1,4)*Metric(2,5) + P(3,2)*P(6,4)*Metric(1,4)*Metric(2,5) - P(3,4)*P(6,5)*Metric(1,4)*Metric(2,5) + P(3,2)*P(4,1)*Metric(1,6)*Metric(2,5) + P(3,1)*P(4,2)*Metric(1,6)*Metric(2,5) + 2*P(3,4)*P(4,3)*Metric(1,6)*Metric(2,5) + 2*P(3,6)*P(4,5)*Metric(1,6)*Metric(2,5) + 2*P(3,5)*P(4,6)*Metric(1,6)*Metric(2,5) - P(4,2)*P(5,1)*Metric(1,3)*Metric(2,6) + P(4,2)*P(5,3)*Metric(1,3)*Metric(2,6) - P(4,5)*P(5,4)*Metric(1,3)*Metric(2,6) - P(4,3)*P(5,6)*Metric(1,3)*Metric(2,6) - P(3,2)*P(5,1)*Metric(1,4)*Metric(2,6) - P(3,5)*P(5,3)*Metric(1,4)*Metric(2,6) + P(3,2)*P(5,4)*Metric(1,4)*Metric(2,6) - P(3,4)*P(5,6)*Metric(1,4)*Metric(2,6) + P(3,2)*P(4,1)*Metric(1,5)*Metric(2,6) + P(3,1)*P(4,2)*Metric(1,5)*Metric(2,6) + 2*P(3,4)*P(4,3)*Metric(1,5)*Metric(2,6) + 2*P(3,6)*P(4,5)*Metric(1,5)*Metric(2,6) + 2*P(3,5)*P(4,6)*Metric(1,5)*Metric(2,6) - 2*P(5,3)*P(6,1)*Metric(1,2)*Metric(3,4) - 2*P(5,4)*P(6,1)*Metric(1,2)*Metric(3,4) - 2*P(5,3)*P(6,2)*Metric(1,2)*Metric(3,4) - 2*P(5,4)*P(6,2)*Metric(1,2)*Metric(3,4) - 2*P(5,1)*P(6,3)*Metric(1,2)*Metric(3,4) - 2*P(5,2)*P(6,3)*Metric(1,2)*Metric(3,4) - 2*P(5,1)*P(6,4)*Metric(1,2)*Metric(3,4) - 2*P(5,2)*P(6,4)*Metric(1,2)*Metric(3,4) - 4*P(5,6)*P(6,5)*Metric(1,2)*Metric(3,4) + 2*P(2,6)*P(6,2)*Metric(1,5)*Metric(3,4) + 2*P(2,1)*P(6,3)*Metric(1,5)*Metric(3,4) + 2*P(2,1)*P(6,4)*Metric(1,5)*Metric(3,4) + P(2,3)*P(6,5)*Metric(1,5)*Metric(3,4) + P(2,4)*P(6,5)*Metric(1,5)*Metric(3,4) + 2*P(2,5)*P(5,2)*Metric(1,6)*Metric(3,4) + 2*P(2,1)*P(5,3)*Metric(1,6)*Metric(3,4) + 2*P(2,1)*P(5,4)*Metric(1,6)*Metric(3,4) + P(2,3)*P(5,6)*Metric(1,6)*Metric(3,4) + P(2,4)*P(5,6)*Metric(1,6)*Metric(3,4) + 2*P(1,6)*P(6,1)*Metric(2,5)*Metric(3,4) + 2*P(1,2)*P(6,3)*Metric(2,5)*Metric(3,4) + 2*P(1,2)*P(6,4)*Metric(2,5)*Metric(3,4) + P(1,3)*P(6,5)*Metric(2,5)*Metric(3,4) + P(1,4)*P(6,5)*Metric(2,5)*Metric(3,4) - 2*P(-1,3)*P(-1,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(-1,2)*P(-1,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + 2*P(1,5)*P(5,1)*Metric(2,6)*Metric(3,4) + 2*P(1,2)*P(5,3)*Metric(2,6)*Metric(3,4) + 2*P(1,2)*P(5,4)*Metric(2,6)*Metric(3,4) + P(1,3)*P(5,6)*Metric(2,6)*Metric(3,4) + P(1,4)*P(5,6)*Metric(2,6)*Metric(3,4) - 2*P(-1,3)*P(-1,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(-1,2)*P(-1,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(4,3)*P(6,1)*Metric(1,2)*Metric(3,5) + 2*P(4,3)*P(6,2)*Metric(1,2)*Metric(3,5) + 2*P(4,6)*P(6,4)*Metric(1,2)*Metric(3,5) + P(4,1)*P(6,5)*Metric(1,2)*Metric(3,5) + P(4,2)*P(6,5)*Metric(1,2)*Metric(3,5) + P(2,3)*P(6,1)*Metric(1,4)*Metric(3,5) - P(2,6)*P(6,2)*Metric(1,4)*Metric(3,5) - P(2,3)*P(6,4)*Metric(1,4)*Metric(3,5) - P(2,1)*P(6,5)*Metric(1,4)*Metric(3,5) - P(2,3)*P(4,1)*Metric(1,6)*Metric(3,5) - P(2,4)*P(4,2)*Metric(1,6)*Metric(3,5) - 2*P(2,1)*P(4,3)*Metric(1,6)*Metric(3,5) - 2*P(2,5)*P(4,6)*Metric(1,6)*Metric(3,5) - P(1,6)*P(6,1)*Metric(2,4)*Metric(3,5) + P(1,3)*P(6,2)*Metric(2,4)*Metric(3,5) - P(1,3)*P(6,4)*Metric(2,4)*Metric(3,5) - P(1,2)*P(6,5)*Metric(2,4)*Metric(3,5) + P(-1,2)*P(-1,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(-1,3)*P(-1,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(1,4)*P(4,1)*Metric(2,6)*Metric(3,5) - P(1,3)*P(4,2)*Metric(2,6)*Metric(3,5) - 2*P(1,2)*P(4,3)*Metric(2,6)*Metric(3,5) - 2*P(1,5)*P(4,6)*Metric(2,6)*Metric(3,5) + P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,3)*P(-1,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(-1,2)*P(-1,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 2*P(4,3)*P(5,1)*Metric(1,2)*Metric(3,6) + 2*P(4,3)*P(5,2)*Metric(1,2)*Metric(3,6) + 2*P(4,5)*P(5,4)*Metric(1,2)*Metric(3,6) + P(4,1)*P(5,6)*Metric(1,2)*Metric(3,6) + P(4,2)*P(5,6)*Metric(1,2)*Metric(3,6) + P(2,3)*P(5,1)*Metric(1,4)*Metric(3,6) - P(2,5)*P(5,2)*Metric(1,4)*Metric(3,6) - P(2,3)*P(5,4)*Metric(1,4)*Metric(3,6) - P(2,1)*P(5,6)*Metric(1,4)*Metric(3,6) - P(2,3)*P(4,1)*Metric(1,5)*Metric(3,6) - P(2,4)*P(4,2)*Metric(1,5)*Metric(3,6) - 2*P(2,1)*P(4,3)*Metric(1,5)*Metric(3,6) - 2*P(2,6)*P(4,5)*Metric(1,5)*Metric(3,6) - P(1,5)*P(5,1)*Metric(2,4)*Metric(3,6) + P(1,3)*P(5,2)*Metric(2,4)*Metric(3,6) - P(1,3)*P(5,4)*Metric(2,4)*Metric(3,6) - P(1,2)*P(5,6)*Metric(2,4)*Metric(3,6) + P(-1,2)*P(-1,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(-1,3)*P(-1,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) - P(1,4)*P(4,1)*Metric(2,5)*Metric(3,6) - P(1,3)*P(4,2)*Metric(2,5)*Metric(3,6) - 2*P(1,2)*P(4,3)*Metric(2,5)*Metric(3,6) - 2*P(1,6)*P(4,5)*Metric(2,5)*Metric(3,6) + P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,2)*P(-1,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(-1,3)*P(-1,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(3,4)*P(6,1)*Metric(1,2)*Metric(4,5) + 2*P(3,4)*P(6,2)*Metric(1,2)*Metric(4,5) + 2*P(3,6)*P(6,3)*Metric(1,2)*Metric(4,5) + P(3,1)*P(6,5)*Metric(1,2)*Metric(4,5) + P(3,2)*P(6,5)*Metric(1,2)*Metric(4,5) + P(2,4)*P(6,1)*Metric(1,3)*Metric(4,5) - P(2,6)*P(6,2)*Metric(1,3)*Metric(4,5) - P(2,4)*P(6,3)*Metric(1,3)*Metric(4,5) - P(2,1)*P(6,5)*Metric(1,3)*Metric(4,5) - P(2,4)*P(3,1)*Metric(1,6)*Metric(4,5) - P(2,3)*P(3,2)*Metric(1,6)*Metric(4,5) - 2*P(2,1)*P(3,4)*Metric(1,6)*Metric(4,5) - 2*P(2,5)*P(3,6)*Metric(1,6)*Metric(4,5) - P(1,6)*P(6,1)*Metric(2,3)*Metric(4,5) + P(1,4)*P(6,2)*Metric(2,3)*Metric(4,5) - P(1,4)*P(6,3)*Metric(2,3)*Metric(4,5) - P(1,2)*P(6,5)*Metric(2,3)*Metric(4,5) + P(-1,2)*P(-1,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(-1,4)*P(-1,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(-1,1)*P(-1,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - P(1,3)*P(3,1)*Metric(2,6)*Metric(4,5) - P(1,4)*P(3,2)*Metric(2,6)*Metric(4,5) - 2*P(1,2)*P(3,4)*Metric(2,6)*Metric(4,5) - 2*P(1,5)*P(3,6)*Metric(2,6)*Metric(4,5) + P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(-1,4)*P(-1,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(-1,2)*P(-1,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(1,2)*P(2,1)*Metric(3,6)*Metric(4,5) + P(1,4)*P(2,3)*Metric(3,6)*Metric(4,5) + P(1,3)*P(2,4)*Metric(3,6)*Metric(4,5) + 2*P(1,6)*P(2,5)*Metric(3,6)*Metric(4,5) + 2*P(1,5)*P(2,6)*Metric(3,6)*Metric(4,5) - 2*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,4)*P(-1,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(-1,3)*P(-1,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(3,4)*P(5,1)*Metric(1,2)*Metric(4,6) + 2*P(3,4)*P(5,2)*Metric(1,2)*Metric(4,6) + 2*P(3,5)*P(5,3)*Metric(1,2)*Metric(4,6) + P(3,1)*P(5,6)*Metric(1,2)*Metric(4,6) + P(3,2)*P(5,6)*Metric(1,2)*Metric(4,6) + P(2,4)*P(5,1)*Metric(1,3)*Metric(4,6) - P(2,5)*P(5,2)*Metric(1,3)*Metric(4,6) - P(2,4)*P(5,3)*Metric(1,3)*Metric(4,6) - P(2,1)*P(5,6)*Metric(1,3)*Metric(4,6) - P(2,4)*P(3,1)*Metric(1,5)*Metric(4,6) - P(2,3)*P(3,2)*Metric(1,5)*Metric(4,6) - 2*P(2,1)*P(3,4)*Metric(1,5)*Metric(4,6) - 2*P(2,6)*P(3,5)*Metric(1,5)*Metric(4,6) - P(1,5)*P(5,1)*Metric(2,3)*Metric(4,6) + P(1,4)*P(5,2)*Metric(2,3)*Metric(4,6) - P(1,4)*P(5,3)*Metric(2,3)*Metric(4,6) - P(1,2)*P(5,6)*Metric(2,3)*Metric(4,6) + P(-1,2)*P(-1,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,1)*P(-1,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(-1,4)*P(-1,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(1,3)*P(3,1)*Metric(2,5)*Metric(4,6) - P(1,4)*P(3,2)*Metric(2,5)*Metric(4,6) - 2*P(1,2)*P(3,4)*Metric(2,5)*Metric(4,6) - 2*P(1,6)*P(3,5)*Metric(2,5)*Metric(4,6) + P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,2)*P(-1,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(-1,4)*P(-1,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(1,2)*P(2,1)*Metric(3,5)*Metric(4,6) + P(1,4)*P(2,3)*Metric(3,5)*Metric(4,6) + P(1,3)*P(2,4)*Metric(3,5)*Metric(4,6) + 2*P(1,6)*P(2,5)*Metric(3,5)*Metric(4,6) + 2*P(1,5)*P(2,6)*Metric(3,5)*Metric(4,6) - 2*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(-1,3)*P(-1,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(-1,4)*P(-1,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(3,5)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,1)*Metric(1,2)*Metric(5,6) - P(3,5)*P(4,2)*Metric(1,2)*Metric(5,6) - P(3,6)*P(4,2)*Metric(1,2)*Metric(5,6) - 4*P(3,4)*P(4,3)*Metric(1,2)*Metric(5,6) - P(3,1)*P(4,5)*Metric(1,2)*Metric(5,6) - P(3,2)*P(4,5)*Metric(1,2)*Metric(5,6) - P(3,1)*P(4,6)*Metric(1,2)*Metric(5,6) - P(3,2)*P(4,6)*Metric(1,2)*Metric(5,6) + 2*P(2,4)*P(4,2)*Metric(1,3)*Metric(5,6) + P(2,5)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,6)*P(4,3)*Metric(1,3)*Metric(5,6) + P(2,1)*P(4,5)*Metric(1,3)*Metric(5,6) + P(2,1)*P(4,6)*Metric(1,3)*Metric(5,6) + 2*P(2,3)*P(3,2)*Metric(1,4)*Metric(5,6) + P(2,5)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,6)*P(3,4)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,5)*Metric(1,4)*Metric(5,6) + P(2,1)*P(3,6)*Metric(1,4)*Metric(5,6) + 2*P(1,4)*P(4,1)*Metric(2,3)*Metric(5,6) + P(1,5)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,6)*P(4,3)*Metric(2,3)*Metric(5,6) + P(1,2)*P(4,5)*Metric(2,3)*Metric(5,6) + P(1,2)*P(4,6)*Metric(2,3)*Metric(5,6) - 2*P(-1,2)*P(-1,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,1)*P(-1,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(-1,5)*P(-1,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + 2*P(1,3)*P(3,1)*Metric(2,4)*Metric(5,6) + P(1,5)*P(3,4)*Metric(2,4)*Metric(5,6) + P(1,6)*P(3,4)*Metric(2,4)*Metric(5,6) + P(1,2)*P(3,5)*Metric(2,4)*Metric(5,6) + P(1,2)*P(3,6)*Metric(2,4)*Metric(5,6) - 2*P(-1,1)*P(-1,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(-1,2)*P(-1,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(-1,5)*P(-1,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 4*P(1,2)*P(2,1)*Metric(3,4)*Metric(5,6) - P(1,5)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,6)*P(2,3)*Metric(3,4)*Metric(5,6) - P(1,5)*P(2,4)*Metric(3,4)*Metric(5,6) - P(1,6)*P(2,4)*Metric(3,4)*Metric(5,6) - P(1,3)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,5)*Metric(3,4)*Metric(5,6) - P(1,3)*P(2,6)*Metric(3,4)*Metric(5,6) - P(1,4)*P(2,6)*Metric(3,4)*Metric(5,6) + 4*P(-1,1)*P(-1,2)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 4*P(-1,3)*P(-1,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 4*P(-1,5)*P(-1,6)*Metric(1,2)*Metric(3,4)*Metric(5,6)')

VVVVVVV7 = Lorentz(name = 'VVVVVVV7',
                   spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(7,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(7,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(7,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(6,3)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(6,4)*Metric(1,7)*Metric(2,5)*Metric(3,4) - 2*P(6,5)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(7,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(7,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(7,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(5,3)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(5,4)*Metric(1,7)*Metric(2,6)*Metric(3,4) - 2*P(5,6)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(6,3)*Metric(1,5)*Metric(2,7)*Metric(3,4) + P(6,4)*Metric(1,5)*Metric(2,7)*Metric(3,4) - 2*P(6,7)*Metric(1,5)*Metric(2,7)*Metric(3,4) + P(5,3)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(5,4)*Metric(1,6)*Metric(2,7)*Metric(3,4) - 2*P(5,7)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(7,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(7,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(7,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(6,2)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5) - 2*P(6,5)*Metric(1,7)*Metric(2,4)*Metric(3,5) - 2*P(7,1)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(7,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(7,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 2*P(4,1)*Metric(1,7)*Metric(2,6)*Metric(3,5) - P(4,2)*Metric(1,7)*Metric(2,6)*Metric(3,5) - P(4,3)*Metric(1,7)*Metric(2,6)*Metric(3,5) - 2*P(6,1)*Metric(1,4)*Metric(2,7)*Metric(3,5) + P(6,5)*Metric(1,4)*Metric(2,7)*Metric(3,5) + P(6,7)*Metric(1,4)*Metric(2,7)*Metric(3,5) + 2*P(4,1)*Metric(1,6)*Metric(2,7)*Metric(3,5) - P(4,2)*Metric(1,6)*Metric(2,7)*Metric(3,5) - P(4,3)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(7,2)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(7,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) - 2*P(7,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(5,2)*Metric(1,7)*Metric(2,4)*Metric(3,6) + P(5,4)*Metric(1,7)*Metric(2,4)*Metric(3,6) - 2*P(5,6)*Metric(1,7)*Metric(2,4)*Metric(3,6) - 2*P(7,1)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(7,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(7,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(4,1)*Metric(1,7)*Metric(2,5)*Metric(3,6) - P(4,2)*Metric(1,7)*Metric(2,5)*Metric(3,6) - P(4,3)*Metric(1,7)*Metric(2,5)*Metric(3,6) - 2*P(5,1)*Metric(1,4)*Metric(2,7)*Metric(3,6) + P(5,6)*Metric(1,4)*Metric(2,7)*Metric(3,6) + P(5,7)*Metric(1,4)*Metric(2,7)*Metric(3,6) + 2*P(4,1)*Metric(1,5)*Metric(2,7)*Metric(3,6) - P(4,2)*Metric(1,5)*Metric(2,7)*Metric(3,6) - P(4,3)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(6,2)*Metric(1,5)*Metric(2,4)*Metric(3,7) + P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7) - 2*P(6,7)*Metric(1,5)*Metric(2,4)*Metric(3,7) + P(5,2)*Metric(1,6)*Metric(2,4)*Metric(3,7) + P(5,4)*Metric(1,6)*Metric(2,4)*Metric(3,7) - 2*P(5,7)*Metric(1,6)*Metric(2,4)*Metric(3,7) - 2*P(6,1)*Metric(1,4)*Metric(2,5)*Metric(3,7) + P(6,5)*Metric(1,4)*Metric(2,5)*Metric(3,7) + P(6,7)*Metric(1,4)*Metric(2,5)*Metric(3,7) + 2*P(4,1)*Metric(1,6)*Metric(2,5)*Metric(3,7) - P(4,2)*Metric(1,6)*Metric(2,5)*Metric(3,7) - P(4,3)*Metric(1,6)*Metric(2,5)*Metric(3,7) - 2*P(5,1)*Metric(1,4)*Metric(2,6)*Metric(3,7) + P(5,6)*Metric(1,4)*Metric(2,6)*Metric(3,7) + P(5,7)*Metric(1,4)*Metric(2,6)*Metric(3,7) + 2*P(4,1)*Metric(1,5)*Metric(2,6)*Metric(3,7) - P(4,2)*Metric(1,5)*Metric(2,6)*Metric(3,7) - P(4,3)*Metric(1,5)*Metric(2,6)*Metric(3,7) + P(7,2)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(7,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(7,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + P(6,2)*Metric(1,7)*Metric(2,3)*Metric(4,5) + P(6,3)*Metric(1,7)*Metric(2,3)*Metric(4,5) - 2*P(6,5)*Metric(1,7)*Metric(2,3)*Metric(4,5) - 2*P(7,1)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(7,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(7,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(3,1)*Metric(1,7)*Metric(2,6)*Metric(4,5) - P(3,2)*Metric(1,7)*Metric(2,6)*Metric(4,5) - P(3,4)*Metric(1,7)*Metric(2,6)*Metric(4,5) - 2*P(6,1)*Metric(1,3)*Metric(2,7)*Metric(4,5) + P(6,5)*Metric(1,3)*Metric(2,7)*Metric(4,5) + P(6,7)*Metric(1,3)*Metric(2,7)*Metric(4,5) + 2*P(3,1)*Metric(1,6)*Metric(2,7)*Metric(4,5) - P(3,2)*Metric(1,6)*Metric(2,7)*Metric(4,5) - P(3,4)*Metric(1,6)*Metric(2,7)*Metric(4,5) - 2*P(7,1)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(7,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(7,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(2,1)*Metric(1,7)*Metric(3,6)*Metric(4,5) - P(2,3)*Metric(1,7)*Metric(3,6)*Metric(4,5) - P(2,4)*Metric(1,7)*Metric(3,6)*Metric(4,5) - 2*P(6,1)*Metric(1,2)*Metric(3,7)*Metric(4,5) + P(6,5)*Metric(1,2)*Metric(3,7)*Metric(4,5) + P(6,7)*Metric(1,2)*Metric(3,7)*Metric(4,5) + 2*P(2,1)*Metric(1,6)*Metric(3,7)*Metric(4,5) - P(2,3)*Metric(1,6)*Metric(3,7)*Metric(4,5) - P(2,4)*Metric(1,6)*Metric(3,7)*Metric(4,5) + P(7,2)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(7,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) - 2*P(7,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(5,2)*Metric(1,7)*Metric(2,3)*Metric(4,6) + P(5,3)*Metric(1,7)*Metric(2,3)*Metric(4,6) - 2*P(5,6)*Metric(1,7)*Metric(2,3)*Metric(4,6) - 2*P(7,1)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(7,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(7,6)*Metric(1,3)*Metric(2,5)*Metric(4,6) + 2*P(3,1)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(3,2)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(3,4)*Metric(1,7)*Metric(2,5)*Metric(4,6) - 2*P(5,1)*Metric(1,3)*Metric(2,7)*Metric(4,6) + P(5,6)*Metric(1,3)*Metric(2,7)*Metric(4,6) + P(5,7)*Metric(1,3)*Metric(2,7)*Metric(4,6) + 2*P(3,1)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(3,2)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(3,4)*Metric(1,5)*Metric(2,7)*Metric(4,6) - 2*P(7,1)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(7,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(7,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + 2*P(2,1)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,3)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6) - 2*P(5,1)*Metric(1,2)*Metric(3,7)*Metric(4,6) + P(5,6)*Metric(1,2)*Metric(3,7)*Metric(4,6) + P(5,7)*Metric(1,2)*Metric(3,7)*Metric(4,6) + 2*P(2,1)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,3)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6) + P(6,2)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(6,3)*Metric(1,5)*Metric(2,3)*Metric(4,7) - 2*P(6,7)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(5,2)*Metric(1,6)*Metric(2,3)*Metric(4,7) + P(5,3)*Metric(1,6)*Metric(2,3)*Metric(4,7) - 2*P(5,7)*Metric(1,6)*Metric(2,3)*Metric(4,7) - 2*P(6,1)*Metric(1,3)*Metric(2,5)*Metric(4,7) + P(6,5)*Metric(1,3)*Metric(2,5)*Metric(4,7) + P(6,7)*Metric(1,3)*Metric(2,5)*Metric(4,7) + 2*P(3,1)*Metric(1,6)*Metric(2,5)*Metric(4,7) - P(3,2)*Metric(1,6)*Metric(2,5)*Metric(4,7) - P(3,4)*Metric(1,6)*Metric(2,5)*Metric(4,7) - 2*P(5,1)*Metric(1,3)*Metric(2,6)*Metric(4,7) + P(5,6)*Metric(1,3)*Metric(2,6)*Metric(4,7) + P(5,7)*Metric(1,3)*Metric(2,6)*Metric(4,7) + 2*P(3,1)*Metric(1,5)*Metric(2,6)*Metric(4,7) - P(3,2)*Metric(1,5)*Metric(2,6)*Metric(4,7) - P(3,4)*Metric(1,5)*Metric(2,6)*Metric(4,7) - 2*P(6,1)*Metric(1,2)*Metric(3,5)*Metric(4,7) + P(6,5)*Metric(1,2)*Metric(3,5)*Metric(4,7) + P(6,7)*Metric(1,2)*Metric(3,5)*Metric(4,7) + 2*P(2,1)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(2,3)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(2,4)*Metric(1,6)*Metric(3,5)*Metric(4,7) - 2*P(5,1)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(5,6)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(5,7)*Metric(1,2)*Metric(3,6)*Metric(4,7) + 2*P(2,1)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(2,3)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(2,4)*Metric(1,5)*Metric(3,6)*Metric(4,7) + 4*P(7,1)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(7,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(7,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 4*P(4,1)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 2*P(4,5)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 2*P(4,6)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 4*P(7,1)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(7,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(7,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 4*P(3,1)*Metric(1,7)*Metric(2,4)*Metric(5,6) + 2*P(3,5)*Metric(1,7)*Metric(2,4)*Metric(5,6) + 2*P(3,6)*Metric(1,7)*Metric(2,4)*Metric(5,6) + 2*P(4,2)*Metric(1,3)*Metric(2,7)*Metric(5,6) - P(4,5)*Metric(1,3)*Metric(2,7)*Metric(5,6) - P(4,6)*Metric(1,3)*Metric(2,7)*Metric(5,6) + 2*P(3,2)*Metric(1,4)*Metric(2,7)*Metric(5,6) - P(3,5)*Metric(1,4)*Metric(2,7)*Metric(5,6) - P(3,6)*Metric(1,4)*Metric(2,7)*Metric(5,6) + 4*P(7,1)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(7,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(7,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 4*P(2,1)*Metric(1,7)*Metric(3,4)*Metric(5,6) + 2*P(2,5)*Metric(1,7)*Metric(3,4)*Metric(5,6) + 2*P(2,6)*Metric(1,7)*Metric(3,4)*Metric(5,6) + 2*P(4,3)*Metric(1,2)*Metric(3,7)*Metric(5,6) - P(4,5)*Metric(1,2)*Metric(3,7)*Metric(5,6) - P(4,6)*Metric(1,2)*Metric(3,7)*Metric(5,6) + 2*P(2,3)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(2,5)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(2,6)*Metric(1,4)*Metric(3,7)*Metric(5,6) + 2*P(3,4)*Metric(1,2)*Metric(4,7)*Metric(5,6) - P(3,5)*Metric(1,2)*Metric(4,7)*Metric(5,6) - P(3,6)*Metric(1,2)*Metric(4,7)*Metric(5,6) + 2*P(2,4)*Metric(1,3)*Metric(4,7)*Metric(5,6) - P(2,5)*Metric(1,3)*Metric(4,7)*Metric(5,6) - P(2,6)*Metric(1,3)*Metric(4,7)*Metric(5,6) + 4*P(6,1)*Metric(1,4)*Metric(2,3)*Metric(5,7) - 2*P(6,2)*Metric(1,4)*Metric(2,3)*Metric(5,7) - 2*P(6,3)*Metric(1,4)*Metric(2,3)*Metric(5,7) - 4*P(4,1)*Metric(1,6)*Metric(2,3)*Metric(5,7) + 2*P(4,5)*Metric(1,6)*Metric(2,3)*Metric(5,7) + 2*P(4,7)*Metric(1,6)*Metric(2,3)*Metric(5,7) + 4*P(6,1)*Metric(1,3)*Metric(2,4)*Metric(5,7) - 2*P(6,2)*Metric(1,3)*Metric(2,4)*Metric(5,7) - 2*P(6,4)*Metric(1,3)*Metric(2,4)*Metric(5,7) - 4*P(3,1)*Metric(1,6)*Metric(2,4)*Metric(5,7) + 2*P(3,5)*Metric(1,6)*Metric(2,4)*Metric(5,7) + 2*P(3,7)*Metric(1,6)*Metric(2,4)*Metric(5,7) + 2*P(4,2)*Metric(1,3)*Metric(2,6)*Metric(5,7) - P(4,5)*Metric(1,3)*Metric(2,6)*Metric(5,7) - P(4,7)*Metric(1,3)*Metric(2,6)*Metric(5,7) + 2*P(3,2)*Metric(1,4)*Metric(2,6)*Metric(5,7) - P(3,5)*Metric(1,4)*Metric(2,6)*Metric(5,7) - P(3,7)*Metric(1,4)*Metric(2,6)*Metric(5,7) + 4*P(6,1)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 2*P(6,3)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 2*P(6,4)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 4*P(2,1)*Metric(1,6)*Metric(3,4)*Metric(5,7) + 2*P(2,5)*Metric(1,6)*Metric(3,4)*Metric(5,7) + 2*P(2,7)*Metric(1,6)*Metric(3,4)*Metric(5,7) + 2*P(4,3)*Metric(1,2)*Metric(3,6)*Metric(5,7) - P(4,5)*Metric(1,2)*Metric(3,6)*Metric(5,7) - P(4,7)*Metric(1,2)*Metric(3,6)*Metric(5,7) + 2*P(2,3)*Metric(1,4)*Metric(3,6)*Metric(5,7) - P(2,5)*Metric(1,4)*Metric(3,6)*Metric(5,7) - P(2,7)*Metric(1,4)*Metric(3,6)*Metric(5,7) + 2*P(3,4)*Metric(1,2)*Metric(4,6)*Metric(5,7) - P(3,5)*Metric(1,2)*Metric(4,6)*Metric(5,7) - P(3,7)*Metric(1,2)*Metric(4,6)*Metric(5,7) + 2*P(2,4)*Metric(1,3)*Metric(4,6)*Metric(5,7) - P(2,5)*Metric(1,3)*Metric(4,6)*Metric(5,7) - P(2,7)*Metric(1,3)*Metric(4,6)*Metric(5,7) + 4*P(5,1)*Metric(1,4)*Metric(2,3)*Metric(6,7) - 2*P(5,2)*Metric(1,4)*Metric(2,3)*Metric(6,7) - 2*P(5,3)*Metric(1,4)*Metric(2,3)*Metric(6,7) - 4*P(4,1)*Metric(1,5)*Metric(2,3)*Metric(6,7) + 2*P(4,6)*Metric(1,5)*Metric(2,3)*Metric(6,7) + 2*P(4,7)*Metric(1,5)*Metric(2,3)*Metric(6,7) + 4*P(5,1)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 2*P(5,2)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 2*P(5,4)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 4*P(3,1)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(3,6)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(3,7)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(4,2)*Metric(1,3)*Metric(2,5)*Metric(6,7) - P(4,6)*Metric(1,3)*Metric(2,5)*Metric(6,7) - P(4,7)*Metric(1,3)*Metric(2,5)*Metric(6,7) + 2*P(3,2)*Metric(1,4)*Metric(2,5)*Metric(6,7) - P(3,6)*Metric(1,4)*Metric(2,5)*Metric(6,7) - P(3,7)*Metric(1,4)*Metric(2,5)*Metric(6,7) + 4*P(5,1)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 2*P(5,3)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 2*P(5,4)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 4*P(2,1)*Metric(1,5)*Metric(3,4)*Metric(6,7) + 2*P(2,6)*Metric(1,5)*Metric(3,4)*Metric(6,7) + 2*P(2,7)*Metric(1,5)*Metric(3,4)*Metric(6,7) + 2*P(4,3)*Metric(1,2)*Metric(3,5)*Metric(6,7) - P(4,6)*Metric(1,2)*Metric(3,5)*Metric(6,7) - P(4,7)*Metric(1,2)*Metric(3,5)*Metric(6,7) + 2*P(2,3)*Metric(1,4)*Metric(3,5)*Metric(6,7) - P(2,6)*Metric(1,4)*Metric(3,5)*Metric(6,7) - P(2,7)*Metric(1,4)*Metric(3,5)*Metric(6,7) + 2*P(3,4)*Metric(1,2)*Metric(4,5)*Metric(6,7) - P(3,6)*Metric(1,2)*Metric(4,5)*Metric(6,7) - P(3,7)*Metric(1,2)*Metric(4,5)*Metric(6,7) + 2*P(2,4)*Metric(1,3)*Metric(4,5)*Metric(6,7) - P(2,6)*Metric(1,3)*Metric(4,5)*Metric(6,7) - P(2,7)*Metric(1,3)*Metric(4,5)*Metric(6,7)')

VVVVVVV8 = Lorentz(name = 'VVVVVVV8',
                   spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(7,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(7,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(7,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(7,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(6,2)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(6,3)*Metric(1,7)*Metric(2,5)*Metric(3,4) - P(6,4)*Metric(1,7)*Metric(2,5)*Metric(3,4) - P(6,5)*Metric(1,7)*Metric(2,5)*Metric(3,4) - (P(7,1)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. - (P(7,3)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(7,4)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(7,6)*Metric(1,5)*Metric(2,6)*Metric(3,4))/2. + (P(5,1)*Metric(1,7)*Metric(2,6)*Metric(3,4))/2. - P(5,2)*Metric(1,7)*Metric(2,6)*Metric(3,4) + (P(5,7)*Metric(1,7)*Metric(2,6)*Metric(3,4))/2. - (P(6,1)*Metric(1,5)*Metric(2,7)*Metric(3,4))/2. - (P(6,3)*Metric(1,5)*Metric(2,7)*Metric(3,4))/2. + (P(6,4)*Metric(1,5)*Metric(2,7)*Metric(3,4))/2. + (P(6,7)*Metric(1,5)*Metric(2,7)*Metric(3,4))/2. + (P(5,1)*Metric(1,6)*Metric(2,7)*Metric(3,4))/2. - P(5,2)*Metric(1,6)*Metric(2,7)*Metric(3,4) + (P(5,6)*Metric(1,6)*Metric(2,7)*Metric(3,4))/2. + P(7,2)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(7,3)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(7,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) - P(7,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(6,2)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(6,3)*Metric(1,7)*Metric(2,4)*Metric(3,5) - P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5) - P(6,5)*Metric(1,7)*Metric(2,4)*Metric(3,5) - (P(7,1)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(7,3)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(7,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(7,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(4,1)*Metric(1,7)*Metric(2,6)*Metric(3,5))/2. - P(4,2)*Metric(1,7)*Metric(2,6)*Metric(3,5) + (P(4,7)*Metric(1,7)*Metric(2,6)*Metric(3,5))/2. - (P(6,1)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. - (P(6,3)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. + (P(6,5)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. + (P(6,7)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. + (P(4,1)*Metric(1,6)*Metric(2,7)*Metric(3,5))/2. - P(4,2)*Metric(1,6)*Metric(2,7)*Metric(3,5) + (P(4,6)*Metric(1,6)*Metric(2,7)*Metric(3,5))/2. - (P(7,1)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(7,2)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(7,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(7,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(5,1)*Metric(1,7)*Metric(2,4)*Metric(3,6))/2. - P(5,3)*Metric(1,7)*Metric(2,4)*Metric(3,6) + (P(5,7)*Metric(1,7)*Metric(2,4)*Metric(3,6))/2. - (P(7,1)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(7,2)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(7,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(7,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(4,1)*Metric(1,7)*Metric(2,5)*Metric(3,6))/2. - P(4,3)*Metric(1,7)*Metric(2,5)*Metric(3,6) + (P(4,7)*Metric(1,7)*Metric(2,5)*Metric(3,6))/2. + (P(5,2)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. + (P(5,3)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. - P(5,4)*Metric(1,4)*Metric(2,7)*Metric(3,6) + (P(4,2)*Metric(1,5)*Metric(2,7)*Metric(3,6))/2. + (P(4,3)*Metric(1,5)*Metric(2,7)*Metric(3,6))/2. - P(4,5)*Metric(1,5)*Metric(2,7)*Metric(3,6) - (P(6,1)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. - (P(6,2)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. + (P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. + (P(6,7)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. + (P(5,1)*Metric(1,6)*Metric(2,4)*Metric(3,7))/2. - P(5,3)*Metric(1,6)*Metric(2,4)*Metric(3,7) + (P(5,6)*Metric(1,6)*Metric(2,4)*Metric(3,7))/2. - (P(6,1)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. - (P(6,2)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. + (P(6,5)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. + (P(6,7)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. + (P(4,1)*Metric(1,6)*Metric(2,5)*Metric(3,7))/2. - P(4,3)*Metric(1,6)*Metric(2,5)*Metric(3,7) + (P(4,6)*Metric(1,6)*Metric(2,5)*Metric(3,7))/2. + (P(5,2)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. + (P(5,3)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. - P(5,4)*Metric(1,4)*Metric(2,6)*Metric(3,7) + (P(4,2)*Metric(1,5)*Metric(2,6)*Metric(3,7))/2. + (P(4,3)*Metric(1,5)*Metric(2,6)*Metric(3,7))/2. - P(4,5)*Metric(1,5)*Metric(2,6)*Metric(3,7) + 2*P(7,2)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(7,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(7,4)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(7,5)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 2*P(6,2)*Metric(1,7)*Metric(2,3)*Metric(4,5) + 2*P(6,3)*Metric(1,7)*Metric(2,3)*Metric(4,5) - 2*P(6,4)*Metric(1,7)*Metric(2,3)*Metric(4,5) - 2*P(6,5)*Metric(1,7)*Metric(2,3)*Metric(4,5) - P(7,1)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(7,4)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(7,5)*Metric(1,3)*Metric(2,6)*Metric(4,5) - P(7,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + P(3,1)*Metric(1,7)*Metric(2,6)*Metric(4,5) - 2*P(3,2)*Metric(1,7)*Metric(2,6)*Metric(4,5) + P(3,7)*Metric(1,7)*Metric(2,6)*Metric(4,5) - P(6,1)*Metric(1,3)*Metric(2,7)*Metric(4,5) + P(6,4)*Metric(1,3)*Metric(2,7)*Metric(4,5) + P(6,5)*Metric(1,3)*Metric(2,7)*Metric(4,5) - P(6,7)*Metric(1,3)*Metric(2,7)*Metric(4,5) + P(3,1)*Metric(1,6)*Metric(2,7)*Metric(4,5) - 2*P(3,2)*Metric(1,6)*Metric(2,7)*Metric(4,5) + P(3,6)*Metric(1,6)*Metric(2,7)*Metric(4,5) - P(7,1)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(7,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(7,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(7,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(2,1)*Metric(1,7)*Metric(3,6)*Metric(4,5) - 2*P(2,3)*Metric(1,7)*Metric(3,6)*Metric(4,5) + P(2,7)*Metric(1,7)*Metric(3,6)*Metric(4,5) + P(1,4)*Metric(2,7)*Metric(3,6)*Metric(4,5) + P(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,6)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,7)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(6,1)*Metric(1,2)*Metric(3,7)*Metric(4,5) + P(6,4)*Metric(1,2)*Metric(3,7)*Metric(4,5) + P(6,5)*Metric(1,2)*Metric(3,7)*Metric(4,5) - P(6,7)*Metric(1,2)*Metric(3,7)*Metric(4,5) + P(2,1)*Metric(1,6)*Metric(3,7)*Metric(4,5) - 2*P(2,3)*Metric(1,6)*Metric(3,7)*Metric(4,5) + P(2,6)*Metric(1,6)*Metric(3,7)*Metric(4,5) + P(1,4)*Metric(2,6)*Metric(3,7)*Metric(4,5) + P(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,5) - P(1,6)*Metric(2,6)*Metric(3,7)*Metric(4,5) - P(1,7)*Metric(2,6)*Metric(3,7)*Metric(4,5) + P(7,1)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(7,2)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(7,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(7,6)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(5,1)*Metric(1,7)*Metric(2,3)*Metric(4,6) + 2*P(5,4)*Metric(1,7)*Metric(2,3)*Metric(4,6) - P(5,7)*Metric(1,7)*Metric(2,3)*Metric(4,6) + (P(7,1)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(7,2)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(7,5)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(7,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(3,1)*Metric(1,7)*Metric(2,5)*Metric(4,6))/2. + P(3,4)*Metric(1,7)*Metric(2,5)*Metric(4,6) - (P(3,7)*Metric(1,7)*Metric(2,5)*Metric(4,6))/2. + (P(5,2)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. + (P(5,3)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. - P(5,4)*Metric(1,3)*Metric(2,7)*Metric(4,6) + P(3,2)*Metric(1,5)*Metric(2,7)*Metric(4,6) - (P(3,4)*Metric(1,5)*Metric(2,7)*Metric(4,6))/2. - (P(3,5)*Metric(1,5)*Metric(2,7)*Metric(4,6))/2. + (P(7,1)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(7,3)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. + (P(7,5)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(7,6)*Metric(1,2)*Metric(3,5)*Metric(4,6))/2. - (P(2,1)*Metric(1,7)*Metric(3,5)*Metric(4,6))/2. + P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6) - (P(2,7)*Metric(1,7)*Metric(3,5)*Metric(4,6))/2. - (P(1,3)*Metric(2,7)*Metric(3,5)*Metric(4,6))/2. + (P(1,5)*Metric(2,7)*Metric(3,5)*Metric(4,6))/2. - (P(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,6))/2. + (P(1,7)*Metric(2,7)*Metric(3,5)*Metric(4,6))/2. + (P(5,2)*Metric(1,2)*Metric(3,7)*Metric(4,6))/2. + (P(5,3)*Metric(1,2)*Metric(3,7)*Metric(4,6))/2. - P(5,4)*Metric(1,2)*Metric(3,7)*Metric(4,6) + P(2,3)*Metric(1,5)*Metric(3,7)*Metric(4,6) - (P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. - (P(2,5)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. - (P(1,2)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. + (P(1,5)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. - (P(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. + (P(1,7)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. + P(6,1)*Metric(1,5)*Metric(2,3)*Metric(4,7) - P(6,2)*Metric(1,5)*Metric(2,3)*Metric(4,7) - P(6,3)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(6,7)*Metric(1,5)*Metric(2,3)*Metric(4,7) - P(5,1)*Metric(1,6)*Metric(2,3)*Metric(4,7) + 2*P(5,4)*Metric(1,6)*Metric(2,3)*Metric(4,7) - P(5,6)*Metric(1,6)*Metric(2,3)*Metric(4,7) + (P(6,1)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. - (P(6,2)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. + (P(6,5)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. - (P(6,7)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. - (P(3,1)*Metric(1,6)*Metric(2,5)*Metric(4,7))/2. + P(3,4)*Metric(1,6)*Metric(2,5)*Metric(4,7) - (P(3,6)*Metric(1,6)*Metric(2,5)*Metric(4,7))/2. + (P(5,2)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. + (P(5,3)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. - P(5,4)*Metric(1,3)*Metric(2,6)*Metric(4,7) + P(3,2)*Metric(1,5)*Metric(2,6)*Metric(4,7) - (P(3,4)*Metric(1,5)*Metric(2,6)*Metric(4,7))/2. - (P(3,5)*Metric(1,5)*Metric(2,6)*Metric(4,7))/2. + (P(6,1)*Metric(1,2)*Metric(3,5)*Metric(4,7))/2. - (P(6,3)*Metric(1,2)*Metric(3,5)*Metric(4,7))/2. + (P(6,5)*Metric(1,2)*Metric(3,5)*Metric(4,7))/2. - (P(6,7)*Metric(1,2)*Metric(3,5)*Metric(4,7))/2. - (P(2,1)*Metric(1,6)*Metric(3,5)*Metric(4,7))/2. + P(2,4)*Metric(1,6)*Metric(3,5)*Metric(4,7) - (P(2,6)*Metric(1,6)*Metric(3,5)*Metric(4,7))/2. - (P(1,3)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (P(1,5)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (P(1,6)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. - (P(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (P(5,2)*Metric(1,2)*Metric(3,6)*Metric(4,7))/2. + (P(5,3)*Metric(1,2)*Metric(3,6)*Metric(4,7))/2. - P(5,4)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(2,3)*Metric(1,5)*Metric(3,6)*Metric(4,7) - (P(2,4)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. - (P(2,5)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. - (P(1,2)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. + (P(1,5)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. + (P(1,6)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. - (P(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. + P(7,1)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(7,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(7,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(7,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(4,1)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 2*P(4,5)*Metric(1,7)*Metric(2,3)*Metric(5,6) - P(4,7)*Metric(1,7)*Metric(2,3)*Metric(5,6) + (P(7,1)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(7,2)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. + (P(7,4)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(7,6)*Metric(1,3)*Metric(2,4)*Metric(5,6))/2. - (P(3,1)*Metric(1,7)*Metric(2,4)*Metric(5,6))/2. + P(3,5)*Metric(1,7)*Metric(2,4)*Metric(5,6) - (P(3,7)*Metric(1,7)*Metric(2,4)*Metric(5,6))/2. + (P(4,2)*Metric(1,3)*Metric(2,7)*Metric(5,6))/2. + (P(4,3)*Metric(1,3)*Metric(2,7)*Metric(5,6))/2. - P(4,5)*Metric(1,3)*Metric(2,7)*Metric(5,6) + P(3,2)*Metric(1,4)*Metric(2,7)*Metric(5,6) - (P(3,4)*Metric(1,4)*Metric(2,7)*Metric(5,6))/2. - (P(3,5)*Metric(1,4)*Metric(2,7)*Metric(5,6))/2. + (P(7,1)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. - (P(7,3)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. + (P(7,4)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. - (P(7,6)*Metric(1,2)*Metric(3,4)*Metric(5,6))/2. - (P(2,1)*Metric(1,7)*Metric(3,4)*Metric(5,6))/2. + P(2,5)*Metric(1,7)*Metric(3,4)*Metric(5,6) - (P(2,7)*Metric(1,7)*Metric(3,4)*Metric(5,6))/2. - (P(1,3)*Metric(2,7)*Metric(3,4)*Metric(5,6))/2. + (P(1,4)*Metric(2,7)*Metric(3,4)*Metric(5,6))/2. - (P(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,6))/2. + (P(1,7)*Metric(2,7)*Metric(3,4)*Metric(5,6))/2. + (P(4,2)*Metric(1,2)*Metric(3,7)*Metric(5,6))/2. + (P(4,3)*Metric(1,2)*Metric(3,7)*Metric(5,6))/2. - P(4,5)*Metric(1,2)*Metric(3,7)*Metric(5,6) + P(2,3)*Metric(1,4)*Metric(3,7)*Metric(5,6) - (P(2,4)*Metric(1,4)*Metric(3,7)*Metric(5,6))/2. - (P(2,5)*Metric(1,4)*Metric(3,7)*Metric(5,6))/2. - (P(1,2)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. + (P(1,4)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. - (P(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. + (P(1,7)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. + P(3,2)*Metric(1,2)*Metric(4,7)*Metric(5,6) - (P(3,4)*Metric(1,2)*Metric(4,7)*Metric(5,6))/2. - (P(3,5)*Metric(1,2)*Metric(4,7)*Metric(5,6))/2. + P(2,3)*Metric(1,3)*Metric(4,7)*Metric(5,6) - (P(2,4)*Metric(1,3)*Metric(4,7)*Metric(5,6))/2. - (P(2,5)*Metric(1,3)*Metric(4,7)*Metric(5,6))/2. - P(1,2)*Metric(2,3)*Metric(4,7)*Metric(5,6) - P(1,3)*Metric(2,3)*Metric(4,7)*Metric(5,6) + P(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,6) + P(1,7)*Metric(2,3)*Metric(4,7)*Metric(5,6) + P(6,1)*Metric(1,4)*Metric(2,3)*Metric(5,7) - P(6,2)*Metric(1,4)*Metric(2,3)*Metric(5,7) - P(6,3)*Metric(1,4)*Metric(2,3)*Metric(5,7) + P(6,7)*Metric(1,4)*Metric(2,3)*Metric(5,7) - P(4,1)*Metric(1,6)*Metric(2,3)*Metric(5,7) + 2*P(4,5)*Metric(1,6)*Metric(2,3)*Metric(5,7) - P(4,6)*Metric(1,6)*Metric(2,3)*Metric(5,7) + (P(6,1)*Metric(1,3)*Metric(2,4)*Metric(5,7))/2. - (P(6,2)*Metric(1,3)*Metric(2,4)*Metric(5,7))/2. + (P(6,4)*Metric(1,3)*Metric(2,4)*Metric(5,7))/2. - (P(6,7)*Metric(1,3)*Metric(2,4)*Metric(5,7))/2. - (P(3,1)*Metric(1,6)*Metric(2,4)*Metric(5,7))/2. + P(3,5)*Metric(1,6)*Metric(2,4)*Metric(5,7) - (P(3,6)*Metric(1,6)*Metric(2,4)*Metric(5,7))/2. + (P(4,2)*Metric(1,3)*Metric(2,6)*Metric(5,7))/2. + (P(4,3)*Metric(1,3)*Metric(2,6)*Metric(5,7))/2. - P(4,5)*Metric(1,3)*Metric(2,6)*Metric(5,7) + P(3,2)*Metric(1,4)*Metric(2,6)*Metric(5,7) - (P(3,4)*Metric(1,4)*Metric(2,6)*Metric(5,7))/2. - (P(3,5)*Metric(1,4)*Metric(2,6)*Metric(5,7))/2. + (P(6,1)*Metric(1,2)*Metric(3,4)*Metric(5,7))/2. - (P(6,3)*Metric(1,2)*Metric(3,4)*Metric(5,7))/2. + (P(6,4)*Metric(1,2)*Metric(3,4)*Metric(5,7))/2. - (P(6,7)*Metric(1,2)*Metric(3,4)*Metric(5,7))/2. - (P(2,1)*Metric(1,6)*Metric(3,4)*Metric(5,7))/2. + P(2,5)*Metric(1,6)*Metric(3,4)*Metric(5,7) - (P(2,6)*Metric(1,6)*Metric(3,4)*Metric(5,7))/2. - (P(1,3)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. + (P(1,4)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. + (P(1,6)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. - (P(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. + (P(4,2)*Metric(1,2)*Metric(3,6)*Metric(5,7))/2. + (P(4,3)*Metric(1,2)*Metric(3,6)*Metric(5,7))/2. - P(4,5)*Metric(1,2)*Metric(3,6)*Metric(5,7) + P(2,3)*Metric(1,4)*Metric(3,6)*Metric(5,7) - (P(2,4)*Metric(1,4)*Metric(3,6)*Metric(5,7))/2. - (P(2,5)*Metric(1,4)*Metric(3,6)*Metric(5,7))/2. - (P(1,2)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. + (P(1,4)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. + (P(1,6)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. - (P(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. + P(3,2)*Metric(1,2)*Metric(4,6)*Metric(5,7) - (P(3,4)*Metric(1,2)*Metric(4,6)*Metric(5,7))/2. - (P(3,5)*Metric(1,2)*Metric(4,6)*Metric(5,7))/2. + P(2,3)*Metric(1,3)*Metric(4,6)*Metric(5,7) - (P(2,4)*Metric(1,3)*Metric(4,6)*Metric(5,7))/2. - (P(2,5)*Metric(1,3)*Metric(4,6)*Metric(5,7))/2. - P(1,2)*Metric(2,3)*Metric(4,6)*Metric(5,7) - P(1,3)*Metric(2,3)*Metric(4,6)*Metric(5,7) + P(1,6)*Metric(2,3)*Metric(4,6)*Metric(5,7) + P(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,7) + 2*P(5,4)*Metric(1,4)*Metric(2,3)*Metric(6,7) - P(5,6)*Metric(1,4)*Metric(2,3)*Metric(6,7) - P(5,7)*Metric(1,4)*Metric(2,3)*Metric(6,7) + 2*P(4,5)*Metric(1,5)*Metric(2,3)*Metric(6,7) - P(4,6)*Metric(1,5)*Metric(2,3)*Metric(6,7) - P(4,7)*Metric(1,5)*Metric(2,3)*Metric(6,7) - P(5,3)*Metric(1,3)*Metric(2,4)*Metric(6,7) + (P(5,6)*Metric(1,3)*Metric(2,4)*Metric(6,7))/2. + (P(5,7)*Metric(1,3)*Metric(2,4)*Metric(6,7))/2. + P(3,5)*Metric(1,5)*Metric(2,4)*Metric(6,7) - (P(3,6)*Metric(1,5)*Metric(2,4)*Metric(6,7))/2. - (P(3,7)*Metric(1,5)*Metric(2,4)*Metric(6,7))/2. - P(4,3)*Metric(1,3)*Metric(2,5)*Metric(6,7) + (P(4,6)*Metric(1,3)*Metric(2,5)*Metric(6,7))/2. + (P(4,7)*Metric(1,3)*Metric(2,5)*Metric(6,7))/2. + P(3,4)*Metric(1,4)*Metric(2,5)*Metric(6,7) - (P(3,6)*Metric(1,4)*Metric(2,5)*Metric(6,7))/2. - (P(3,7)*Metric(1,4)*Metric(2,5)*Metric(6,7))/2. - P(5,2)*Metric(1,2)*Metric(3,4)*Metric(6,7) + (P(5,6)*Metric(1,2)*Metric(3,4)*Metric(6,7))/2. + (P(5,7)*Metric(1,2)*Metric(3,4)*Metric(6,7))/2. + P(2,5)*Metric(1,5)*Metric(3,4)*Metric(6,7) - (P(2,6)*Metric(1,5)*Metric(3,4)*Metric(6,7))/2. - (P(2,7)*Metric(1,5)*Metric(3,4)*Metric(6,7))/2. + P(1,2)*Metric(2,5)*Metric(3,4)*Metric(6,7) + P(1,3)*Metric(2,5)*Metric(3,4)*Metric(6,7) - P(1,4)*Metric(2,5)*Metric(3,4)*Metric(6,7) - P(1,5)*Metric(2,5)*Metric(3,4)*Metric(6,7) - P(4,2)*Metric(1,2)*Metric(3,5)*Metric(6,7) + (P(4,6)*Metric(1,2)*Metric(3,5)*Metric(6,7))/2. + (P(4,7)*Metric(1,2)*Metric(3,5)*Metric(6,7))/2. + P(2,4)*Metric(1,4)*Metric(3,5)*Metric(6,7) - (P(2,6)*Metric(1,4)*Metric(3,5)*Metric(6,7))/2. - (P(2,7)*Metric(1,4)*Metric(3,5)*Metric(6,7))/2. + P(1,2)*Metric(2,4)*Metric(3,5)*Metric(6,7) + P(1,3)*Metric(2,4)*Metric(3,5)*Metric(6,7) - P(1,4)*Metric(2,4)*Metric(3,5)*Metric(6,7) - P(1,5)*Metric(2,4)*Metric(3,5)*Metric(6,7) - 2*P(3,2)*Metric(1,2)*Metric(4,5)*Metric(6,7) + P(3,6)*Metric(1,2)*Metric(4,5)*Metric(6,7) + P(3,7)*Metric(1,2)*Metric(4,5)*Metric(6,7) - 2*P(2,3)*Metric(1,3)*Metric(4,5)*Metric(6,7) + P(2,6)*Metric(1,3)*Metric(4,5)*Metric(6,7) + P(2,7)*Metric(1,3)*Metric(4,5)*Metric(6,7) + 2*P(1,2)*Metric(2,3)*Metric(4,5)*Metric(6,7) + 2*P(1,3)*Metric(2,3)*Metric(4,5)*Metric(6,7) - 2*P(1,4)*Metric(2,3)*Metric(4,5)*Metric(6,7) - 2*P(1,5)*Metric(2,3)*Metric(4,5)*Metric(6,7)')

VVVVVVV9 = Lorentz(name = 'VVVVVVV9',
                   spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                   structure = 'P(6,4)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(6,5)*Metric(1,7)*Metric(2,5)*Metric(3,4) - 2*P(6,7)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(5,4)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(5,6)*Metric(1,7)*Metric(2,6)*Metric(3,4) - 2*P(5,7)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(6,4)*Metric(1,5)*Metric(2,7)*Metric(3,4) + P(6,5)*Metric(1,5)*Metric(2,7)*Metric(3,4) - 2*P(6,7)*Metric(1,5)*Metric(2,7)*Metric(3,4) + P(5,4)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(5,6)*Metric(1,6)*Metric(2,7)*Metric(3,4) - 2*P(5,7)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(6,5)*Metric(1,7)*Metric(2,4)*Metric(3,5) - 2*P(6,7)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(4,5)*Metric(1,7)*Metric(2,6)*Metric(3,5) + P(4,6)*Metric(1,7)*Metric(2,6)*Metric(3,5) - 2*P(4,7)*Metric(1,7)*Metric(2,6)*Metric(3,5) + P(6,4)*Metric(1,4)*Metric(2,7)*Metric(3,5) + P(6,5)*Metric(1,4)*Metric(2,7)*Metric(3,5) - 2*P(6,7)*Metric(1,4)*Metric(2,7)*Metric(3,5) + P(4,5)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(4,6)*Metric(1,6)*Metric(2,7)*Metric(3,5) - 2*P(4,7)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(5,4)*Metric(1,7)*Metric(2,4)*Metric(3,6) + P(5,6)*Metric(1,7)*Metric(2,4)*Metric(3,6) - 2*P(5,7)*Metric(1,7)*Metric(2,4)*Metric(3,6) + P(4,5)*Metric(1,7)*Metric(2,5)*Metric(3,6) + P(4,6)*Metric(1,7)*Metric(2,5)*Metric(3,6) - 2*P(4,7)*Metric(1,7)*Metric(2,5)*Metric(3,6) + P(5,4)*Metric(1,4)*Metric(2,7)*Metric(3,6) + P(5,6)*Metric(1,4)*Metric(2,7)*Metric(3,6) - 2*P(5,7)*Metric(1,4)*Metric(2,7)*Metric(3,6) + P(4,5)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(4,6)*Metric(1,5)*Metric(2,7)*Metric(3,6) - 2*P(4,7)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7) + P(6,5)*Metric(1,5)*Metric(2,4)*Metric(3,7) - 2*P(6,7)*Metric(1,5)*Metric(2,4)*Metric(3,7) + P(5,4)*Metric(1,6)*Metric(2,4)*Metric(3,7) + P(5,6)*Metric(1,6)*Metric(2,4)*Metric(3,7) - 2*P(5,7)*Metric(1,6)*Metric(2,4)*Metric(3,7) + P(6,4)*Metric(1,4)*Metric(2,5)*Metric(3,7) + P(6,5)*Metric(1,4)*Metric(2,5)*Metric(3,7) - 2*P(6,7)*Metric(1,4)*Metric(2,5)*Metric(3,7) + P(4,5)*Metric(1,6)*Metric(2,5)*Metric(3,7) + P(4,6)*Metric(1,6)*Metric(2,5)*Metric(3,7) - 2*P(4,7)*Metric(1,6)*Metric(2,5)*Metric(3,7) + P(5,4)*Metric(1,4)*Metric(2,6)*Metric(3,7) + P(5,6)*Metric(1,4)*Metric(2,6)*Metric(3,7) - 2*P(5,7)*Metric(1,4)*Metric(2,6)*Metric(3,7) + P(4,5)*Metric(1,5)*Metric(2,6)*Metric(3,7) + P(4,6)*Metric(1,5)*Metric(2,6)*Metric(3,7) - 2*P(4,7)*Metric(1,5)*Metric(2,6)*Metric(3,7) - 2*P(6,2)*Metric(1,7)*Metric(2,3)*Metric(4,5) - 2*P(6,3)*Metric(1,7)*Metric(2,3)*Metric(4,5) + 4*P(6,7)*Metric(1,7)*Metric(2,3)*Metric(4,5) + 2*P(3,2)*Metric(1,7)*Metric(2,6)*Metric(4,5) - P(3,4)*Metric(1,7)*Metric(2,6)*Metric(4,5) - P(3,5)*Metric(1,7)*Metric(2,6)*Metric(4,5) - 2*P(6,1)*Metric(1,3)*Metric(2,7)*Metric(4,5) - 2*P(6,3)*Metric(1,3)*Metric(2,7)*Metric(4,5) + 4*P(6,7)*Metric(1,3)*Metric(2,7)*Metric(4,5) + 2*P(3,1)*Metric(1,6)*Metric(2,7)*Metric(4,5) - P(3,4)*Metric(1,6)*Metric(2,7)*Metric(4,5) - P(3,5)*Metric(1,6)*Metric(2,7)*Metric(4,5) + 2*P(2,3)*Metric(1,7)*Metric(3,6)*Metric(4,5) - P(2,4)*Metric(1,7)*Metric(3,6)*Metric(4,5) - P(2,5)*Metric(1,7)*Metric(3,6)*Metric(4,5) + 2*P(1,3)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,4)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,5) - 2*P(6,1)*Metric(1,2)*Metric(3,7)*Metric(4,5) - 2*P(6,2)*Metric(1,2)*Metric(3,7)*Metric(4,5) + 4*P(6,7)*Metric(1,2)*Metric(3,7)*Metric(4,5) + 2*P(2,1)*Metric(1,6)*Metric(3,7)*Metric(4,5) - P(2,4)*Metric(1,6)*Metric(3,7)*Metric(4,5) - P(2,5)*Metric(1,6)*Metric(3,7)*Metric(4,5) + 2*P(1,2)*Metric(2,6)*Metric(3,7)*Metric(4,5) - P(1,4)*Metric(2,6)*Metric(3,7)*Metric(4,5) - P(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,5) - 2*P(5,2)*Metric(1,7)*Metric(2,3)*Metric(4,6) - 2*P(5,3)*Metric(1,7)*Metric(2,3)*Metric(4,6) + 4*P(5,7)*Metric(1,7)*Metric(2,3)*Metric(4,6) + 2*P(3,2)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(3,4)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(3,6)*Metric(1,7)*Metric(2,5)*Metric(4,6) - 2*P(5,1)*Metric(1,3)*Metric(2,7)*Metric(4,6) - 2*P(5,3)*Metric(1,3)*Metric(2,7)*Metric(4,6) + 4*P(5,7)*Metric(1,3)*Metric(2,7)*Metric(4,6) + 2*P(3,1)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(3,4)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(3,6)*Metric(1,5)*Metric(2,7)*Metric(4,6) + 2*P(2,3)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,6)*Metric(1,7)*Metric(3,5)*Metric(4,6) + 2*P(1,3)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(1,4)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,6) - 2*P(5,1)*Metric(1,2)*Metric(3,7)*Metric(4,6) - 2*P(5,2)*Metric(1,2)*Metric(3,7)*Metric(4,6) + 4*P(5,7)*Metric(1,2)*Metric(3,7)*Metric(4,6) + 2*P(2,1)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,6)*Metric(1,5)*Metric(3,7)*Metric(4,6) + 2*P(1,2)*Metric(2,5)*Metric(3,7)*Metric(4,6) - P(1,4)*Metric(2,5)*Metric(3,7)*Metric(4,6) - P(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,6) + P(6,2)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(6,3)*Metric(1,5)*Metric(2,3)*Metric(4,7) - 2*P(6,5)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(5,2)*Metric(1,6)*Metric(2,3)*Metric(4,7) + P(5,3)*Metric(1,6)*Metric(2,3)*Metric(4,7) - 2*P(5,6)*Metric(1,6)*Metric(2,3)*Metric(4,7) + P(6,1)*Metric(1,3)*Metric(2,5)*Metric(4,7) + P(6,3)*Metric(1,3)*Metric(2,5)*Metric(4,7) - 2*P(6,5)*Metric(1,3)*Metric(2,5)*Metric(4,7) - P(3,1)*Metric(1,6)*Metric(2,5)*Metric(4,7) - P(3,2)*Metric(1,6)*Metric(2,5)*Metric(4,7) + 2*P(3,7)*Metric(1,6)*Metric(2,5)*Metric(4,7) + P(5,1)*Metric(1,3)*Metric(2,6)*Metric(4,7) + P(5,3)*Metric(1,3)*Metric(2,6)*Metric(4,7) - 2*P(5,6)*Metric(1,3)*Metric(2,6)*Metric(4,7) - P(3,1)*Metric(1,5)*Metric(2,6)*Metric(4,7) - P(3,2)*Metric(1,5)*Metric(2,6)*Metric(4,7) + 2*P(3,7)*Metric(1,5)*Metric(2,6)*Metric(4,7) + P(6,1)*Metric(1,2)*Metric(3,5)*Metric(4,7) + P(6,2)*Metric(1,2)*Metric(3,5)*Metric(4,7) - 2*P(6,5)*Metric(1,2)*Metric(3,5)*Metric(4,7) - P(2,1)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(2,3)*Metric(1,6)*Metric(3,5)*Metric(4,7) + 2*P(2,7)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(1,2)*Metric(2,6)*Metric(3,5)*Metric(4,7) - P(1,3)*Metric(2,6)*Metric(3,5)*Metric(4,7) + 2*P(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,7) + P(5,1)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(5,2)*Metric(1,2)*Metric(3,6)*Metric(4,7) - 2*P(5,6)*Metric(1,2)*Metric(3,6)*Metric(4,7) - P(2,1)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(2,3)*Metric(1,5)*Metric(3,6)*Metric(4,7) + 2*P(2,7)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(1,2)*Metric(2,5)*Metric(3,6)*Metric(4,7) - P(1,3)*Metric(2,5)*Metric(3,6)*Metric(4,7) + 2*P(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,7) - 2*P(4,2)*Metric(1,7)*Metric(2,3)*Metric(5,6) - 2*P(4,3)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 4*P(4,7)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 2*P(3,2)*Metric(1,7)*Metric(2,4)*Metric(5,6) - P(3,5)*Metric(1,7)*Metric(2,4)*Metric(5,6) - P(3,6)*Metric(1,7)*Metric(2,4)*Metric(5,6) - 2*P(4,1)*Metric(1,3)*Metric(2,7)*Metric(5,6) - 2*P(4,3)*Metric(1,3)*Metric(2,7)*Metric(5,6) + 4*P(4,7)*Metric(1,3)*Metric(2,7)*Metric(5,6) + 2*P(3,1)*Metric(1,4)*Metric(2,7)*Metric(5,6) - P(3,5)*Metric(1,4)*Metric(2,7)*Metric(5,6) - P(3,6)*Metric(1,4)*Metric(2,7)*Metric(5,6) + 2*P(2,3)*Metric(1,7)*Metric(3,4)*Metric(5,6) - P(2,5)*Metric(1,7)*Metric(3,4)*Metric(5,6) - P(2,6)*Metric(1,7)*Metric(3,4)*Metric(5,6) + 2*P(1,3)*Metric(2,7)*Metric(3,4)*Metric(5,6) - P(1,5)*Metric(2,7)*Metric(3,4)*Metric(5,6) - P(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,6) - 2*P(4,1)*Metric(1,2)*Metric(3,7)*Metric(5,6) - 2*P(4,2)*Metric(1,2)*Metric(3,7)*Metric(5,6) + 4*P(4,7)*Metric(1,2)*Metric(3,7)*Metric(5,6) + 2*P(2,1)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(2,5)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(2,6)*Metric(1,4)*Metric(3,7)*Metric(5,6) + 2*P(1,2)*Metric(2,4)*Metric(3,7)*Metric(5,6) - P(1,5)*Metric(2,4)*Metric(3,7)*Metric(5,6) - P(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,6) + 2*P(3,5)*Metric(1,2)*Metric(4,7)*Metric(5,6) + 2*P(3,6)*Metric(1,2)*Metric(4,7)*Metric(5,6) - 4*P(3,7)*Metric(1,2)*Metric(4,7)*Metric(5,6) + 2*P(2,5)*Metric(1,3)*Metric(4,7)*Metric(5,6) + 2*P(2,6)*Metric(1,3)*Metric(4,7)*Metric(5,6) - 4*P(2,7)*Metric(1,3)*Metric(4,7)*Metric(5,6) + 2*P(1,5)*Metric(2,3)*Metric(4,7)*Metric(5,6) + 2*P(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,6) - 4*P(1,7)*Metric(2,3)*Metric(4,7)*Metric(5,6) + P(6,2)*Metric(1,4)*Metric(2,3)*Metric(5,7) + P(6,3)*Metric(1,4)*Metric(2,3)*Metric(5,7) - 2*P(6,4)*Metric(1,4)*Metric(2,3)*Metric(5,7) + P(4,2)*Metric(1,6)*Metric(2,3)*Metric(5,7) + P(4,3)*Metric(1,6)*Metric(2,3)*Metric(5,7) - 2*P(4,6)*Metric(1,6)*Metric(2,3)*Metric(5,7) + P(6,1)*Metric(1,3)*Metric(2,4)*Metric(5,7) + P(6,3)*Metric(1,3)*Metric(2,4)*Metric(5,7) - 2*P(6,4)*Metric(1,3)*Metric(2,4)*Metric(5,7) - P(3,1)*Metric(1,6)*Metric(2,4)*Metric(5,7) - P(3,2)*Metric(1,6)*Metric(2,4)*Metric(5,7) + 2*P(3,7)*Metric(1,6)*Metric(2,4)*Metric(5,7) + P(4,1)*Metric(1,3)*Metric(2,6)*Metric(5,7) + P(4,3)*Metric(1,3)*Metric(2,6)*Metric(5,7) - 2*P(4,6)*Metric(1,3)*Metric(2,6)*Metric(5,7) - P(3,1)*Metric(1,4)*Metric(2,6)*Metric(5,7) - P(3,2)*Metric(1,4)*Metric(2,6)*Metric(5,7) + 2*P(3,7)*Metric(1,4)*Metric(2,6)*Metric(5,7) + P(6,1)*Metric(1,2)*Metric(3,4)*Metric(5,7) + P(6,2)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 2*P(6,4)*Metric(1,2)*Metric(3,4)*Metric(5,7) - P(2,1)*Metric(1,6)*Metric(3,4)*Metric(5,7) - P(2,3)*Metric(1,6)*Metric(3,4)*Metric(5,7) + 2*P(2,7)*Metric(1,6)*Metric(3,4)*Metric(5,7) - P(1,2)*Metric(2,6)*Metric(3,4)*Metric(5,7) - P(1,3)*Metric(2,6)*Metric(3,4)*Metric(5,7) + 2*P(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,7) + P(4,1)*Metric(1,2)*Metric(3,6)*Metric(5,7) + P(4,2)*Metric(1,2)*Metric(3,6)*Metric(5,7) - 2*P(4,6)*Metric(1,2)*Metric(3,6)*Metric(5,7) - P(2,1)*Metric(1,4)*Metric(3,6)*Metric(5,7) - P(2,3)*Metric(1,4)*Metric(3,6)*Metric(5,7) + 2*P(2,7)*Metric(1,4)*Metric(3,6)*Metric(5,7) - P(1,2)*Metric(2,4)*Metric(3,6)*Metric(5,7) - P(1,3)*Metric(2,4)*Metric(3,6)*Metric(5,7) + 2*P(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,7) + 2*P(3,4)*Metric(1,2)*Metric(4,6)*Metric(5,7) + 2*P(3,6)*Metric(1,2)*Metric(4,6)*Metric(5,7) - 4*P(3,7)*Metric(1,2)*Metric(4,6)*Metric(5,7) + 2*P(2,4)*Metric(1,3)*Metric(4,6)*Metric(5,7) + 2*P(2,6)*Metric(1,3)*Metric(4,6)*Metric(5,7) - 4*P(2,7)*Metric(1,3)*Metric(4,6)*Metric(5,7) + 2*P(1,4)*Metric(2,3)*Metric(4,6)*Metric(5,7) + 2*P(1,6)*Metric(2,3)*Metric(4,6)*Metric(5,7) - 4*P(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,7) + P(5,2)*Metric(1,4)*Metric(2,3)*Metric(6,7) + P(5,3)*Metric(1,4)*Metric(2,3)*Metric(6,7) - 2*P(5,4)*Metric(1,4)*Metric(2,3)*Metric(6,7) + P(4,2)*Metric(1,5)*Metric(2,3)*Metric(6,7) + P(4,3)*Metric(1,5)*Metric(2,3)*Metric(6,7) - 2*P(4,5)*Metric(1,5)*Metric(2,3)*Metric(6,7) + P(5,1)*Metric(1,3)*Metric(2,4)*Metric(6,7) + P(5,3)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 2*P(5,4)*Metric(1,3)*Metric(2,4)*Metric(6,7) - P(3,1)*Metric(1,5)*Metric(2,4)*Metric(6,7) - P(3,2)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(3,7)*Metric(1,5)*Metric(2,4)*Metric(6,7) + P(4,1)*Metric(1,3)*Metric(2,5)*Metric(6,7) + P(4,3)*Metric(1,3)*Metric(2,5)*Metric(6,7) - 2*P(4,5)*Metric(1,3)*Metric(2,5)*Metric(6,7) - P(3,1)*Metric(1,4)*Metric(2,5)*Metric(6,7) - P(3,2)*Metric(1,4)*Metric(2,5)*Metric(6,7) + 2*P(3,7)*Metric(1,4)*Metric(2,5)*Metric(6,7) + P(5,1)*Metric(1,2)*Metric(3,4)*Metric(6,7) + P(5,2)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 2*P(5,4)*Metric(1,2)*Metric(3,4)*Metric(6,7) - P(2,1)*Metric(1,5)*Metric(3,4)*Metric(6,7) - P(2,3)*Metric(1,5)*Metric(3,4)*Metric(6,7) + 2*P(2,7)*Metric(1,5)*Metric(3,4)*Metric(6,7) - P(1,2)*Metric(2,5)*Metric(3,4)*Metric(6,7) - P(1,3)*Metric(2,5)*Metric(3,4)*Metric(6,7) + 2*P(1,7)*Metric(2,5)*Metric(3,4)*Metric(6,7) + P(4,1)*Metric(1,2)*Metric(3,5)*Metric(6,7) + P(4,2)*Metric(1,2)*Metric(3,5)*Metric(6,7) - 2*P(4,5)*Metric(1,2)*Metric(3,5)*Metric(6,7) - P(2,1)*Metric(1,4)*Metric(3,5)*Metric(6,7) - P(2,3)*Metric(1,4)*Metric(3,5)*Metric(6,7) + 2*P(2,7)*Metric(1,4)*Metric(3,5)*Metric(6,7) - P(1,2)*Metric(2,4)*Metric(3,5)*Metric(6,7) - P(1,3)*Metric(2,4)*Metric(3,5)*Metric(6,7) + 2*P(1,7)*Metric(2,4)*Metric(3,5)*Metric(6,7) + 2*P(3,4)*Metric(1,2)*Metric(4,5)*Metric(6,7) + 2*P(3,5)*Metric(1,2)*Metric(4,5)*Metric(6,7) - 4*P(3,7)*Metric(1,2)*Metric(4,5)*Metric(6,7) + 2*P(2,4)*Metric(1,3)*Metric(4,5)*Metric(6,7) + 2*P(2,5)*Metric(1,3)*Metric(4,5)*Metric(6,7) - 4*P(2,7)*Metric(1,3)*Metric(4,5)*Metric(6,7) + 2*P(1,4)*Metric(2,3)*Metric(4,5)*Metric(6,7) + 2*P(1,5)*Metric(2,3)*Metric(4,5)*Metric(6,7) - 4*P(1,7)*Metric(2,3)*Metric(4,5)*Metric(6,7)')

VVVVVVV10 = Lorentz(name = 'VVVVVVV10',
                    spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                    structure = 'P(7,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(7,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - 2*P(7,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(6,4)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(6,5)*Metric(1,7)*Metric(2,5)*Metric(3,4) - 2*P(6,7)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(7,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(7,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - 2*P(7,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + 2*P(5,4)*Metric(1,7)*Metric(2,6)*Metric(3,4) - P(5,6)*Metric(1,7)*Metric(2,6)*Metric(3,4) - P(5,7)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(6,4)*Metric(1,5)*Metric(2,7)*Metric(3,4) + P(6,5)*Metric(1,5)*Metric(2,7)*Metric(3,4) - 2*P(6,7)*Metric(1,5)*Metric(2,7)*Metric(3,4) + 2*P(5,4)*Metric(1,6)*Metric(2,7)*Metric(3,4) - P(5,6)*Metric(1,6)*Metric(2,7)*Metric(3,4) - P(5,7)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(7,4)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(7,5)*Metric(1,6)*Metric(2,4)*Metric(3,5) - 2*P(7,6)*Metric(1,6)*Metric(2,4)*Metric(3,5) + P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(6,5)*Metric(1,7)*Metric(2,4)*Metric(3,5) - 2*P(6,7)*Metric(1,7)*Metric(2,4)*Metric(3,5) + P(7,4)*Metric(1,4)*Metric(2,6)*Metric(3,5) + P(7,5)*Metric(1,4)*Metric(2,6)*Metric(3,5) - 2*P(7,6)*Metric(1,4)*Metric(2,6)*Metric(3,5) + 2*P(4,5)*Metric(1,7)*Metric(2,6)*Metric(3,5) - P(4,6)*Metric(1,7)*Metric(2,6)*Metric(3,5) - P(4,7)*Metric(1,7)*Metric(2,6)*Metric(3,5) + P(6,4)*Metric(1,4)*Metric(2,7)*Metric(3,5) + P(6,5)*Metric(1,4)*Metric(2,7)*Metric(3,5) - 2*P(6,7)*Metric(1,4)*Metric(2,7)*Metric(3,5) + 2*P(4,5)*Metric(1,6)*Metric(2,7)*Metric(3,5) - P(4,6)*Metric(1,6)*Metric(2,7)*Metric(3,5) - P(4,7)*Metric(1,6)*Metric(2,7)*Metric(3,5) + P(7,4)*Metric(1,5)*Metric(2,4)*Metric(3,6) + P(7,5)*Metric(1,5)*Metric(2,4)*Metric(3,6) - 2*P(7,6)*Metric(1,5)*Metric(2,4)*Metric(3,6) + 2*P(5,4)*Metric(1,7)*Metric(2,4)*Metric(3,6) - P(5,6)*Metric(1,7)*Metric(2,4)*Metric(3,6) - P(5,7)*Metric(1,7)*Metric(2,4)*Metric(3,6) + P(7,4)*Metric(1,4)*Metric(2,5)*Metric(3,6) + P(7,5)*Metric(1,4)*Metric(2,5)*Metric(3,6) - 2*P(7,6)*Metric(1,4)*Metric(2,5)*Metric(3,6) + 2*P(4,5)*Metric(1,7)*Metric(2,5)*Metric(3,6) - P(4,6)*Metric(1,7)*Metric(2,5)*Metric(3,6) - P(4,7)*Metric(1,7)*Metric(2,5)*Metric(3,6) + 2*P(5,4)*Metric(1,4)*Metric(2,7)*Metric(3,6) - P(5,6)*Metric(1,4)*Metric(2,7)*Metric(3,6) - P(5,7)*Metric(1,4)*Metric(2,7)*Metric(3,6) + 2*P(4,5)*Metric(1,5)*Metric(2,7)*Metric(3,6) - P(4,6)*Metric(1,5)*Metric(2,7)*Metric(3,6) - P(4,7)*Metric(1,5)*Metric(2,7)*Metric(3,6) + P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7) + P(6,5)*Metric(1,5)*Metric(2,4)*Metric(3,7) - 2*P(6,7)*Metric(1,5)*Metric(2,4)*Metric(3,7) + 2*P(5,4)*Metric(1,6)*Metric(2,4)*Metric(3,7) - P(5,6)*Metric(1,6)*Metric(2,4)*Metric(3,7) - P(5,7)*Metric(1,6)*Metric(2,4)*Metric(3,7) + P(6,4)*Metric(1,4)*Metric(2,5)*Metric(3,7) + P(6,5)*Metric(1,4)*Metric(2,5)*Metric(3,7) - 2*P(6,7)*Metric(1,4)*Metric(2,5)*Metric(3,7) + 2*P(4,5)*Metric(1,6)*Metric(2,5)*Metric(3,7) - P(4,6)*Metric(1,6)*Metric(2,5)*Metric(3,7) - P(4,7)*Metric(1,6)*Metric(2,5)*Metric(3,7) + 2*P(5,4)*Metric(1,4)*Metric(2,6)*Metric(3,7) - P(5,6)*Metric(1,4)*Metric(2,6)*Metric(3,7) - P(5,7)*Metric(1,4)*Metric(2,6)*Metric(3,7) + 2*P(4,5)*Metric(1,5)*Metric(2,6)*Metric(3,7) - P(4,6)*Metric(1,5)*Metric(2,6)*Metric(3,7) - P(4,7)*Metric(1,5)*Metric(2,6)*Metric(3,7) - 2*P(7,2)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(7,3)*Metric(1,6)*Metric(2,3)*Metric(4,5) + 4*P(7,6)*Metric(1,6)*Metric(2,3)*Metric(4,5) - 2*P(6,2)*Metric(1,7)*Metric(2,3)*Metric(4,5) - 2*P(6,3)*Metric(1,7)*Metric(2,3)*Metric(4,5) + 4*P(6,7)*Metric(1,7)*Metric(2,3)*Metric(4,5) - 2*P(7,1)*Metric(1,3)*Metric(2,6)*Metric(4,5) - 2*P(7,3)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 4*P(7,6)*Metric(1,3)*Metric(2,6)*Metric(4,5) + 2*P(3,1)*Metric(1,7)*Metric(2,6)*Metric(4,5) + 2*P(3,2)*Metric(1,7)*Metric(2,6)*Metric(4,5) - 2*P(3,4)*Metric(1,7)*Metric(2,6)*Metric(4,5) - 2*P(3,5)*Metric(1,7)*Metric(2,6)*Metric(4,5) - 2*P(6,1)*Metric(1,3)*Metric(2,7)*Metric(4,5) - 2*P(6,3)*Metric(1,3)*Metric(2,7)*Metric(4,5) + 4*P(6,7)*Metric(1,3)*Metric(2,7)*Metric(4,5) + 2*P(3,1)*Metric(1,6)*Metric(2,7)*Metric(4,5) + 2*P(3,2)*Metric(1,6)*Metric(2,7)*Metric(4,5) - 2*P(3,4)*Metric(1,6)*Metric(2,7)*Metric(4,5) - 2*P(3,5)*Metric(1,6)*Metric(2,7)*Metric(4,5) - 2*P(7,1)*Metric(1,2)*Metric(3,6)*Metric(4,5) - 2*P(7,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 4*P(7,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + 2*P(2,1)*Metric(1,7)*Metric(3,6)*Metric(4,5) + 2*P(2,3)*Metric(1,7)*Metric(3,6)*Metric(4,5) - 2*P(2,4)*Metric(1,7)*Metric(3,6)*Metric(4,5) - 2*P(2,5)*Metric(1,7)*Metric(3,6)*Metric(4,5) + 2*P(1,2)*Metric(2,7)*Metric(3,6)*Metric(4,5) + 2*P(1,3)*Metric(2,7)*Metric(3,6)*Metric(4,5) - 2*P(1,4)*Metric(2,7)*Metric(3,6)*Metric(4,5) - 2*P(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,5) - 2*P(6,1)*Metric(1,2)*Metric(3,7)*Metric(4,5) - 2*P(6,2)*Metric(1,2)*Metric(3,7)*Metric(4,5) + 4*P(6,7)*Metric(1,2)*Metric(3,7)*Metric(4,5) + 2*P(2,1)*Metric(1,6)*Metric(3,7)*Metric(4,5) + 2*P(2,3)*Metric(1,6)*Metric(3,7)*Metric(4,5) - 2*P(2,4)*Metric(1,6)*Metric(3,7)*Metric(4,5) - 2*P(2,5)*Metric(1,6)*Metric(3,7)*Metric(4,5) + 2*P(1,2)*Metric(2,6)*Metric(3,7)*Metric(4,5) + 2*P(1,3)*Metric(2,6)*Metric(3,7)*Metric(4,5) - 2*P(1,4)*Metric(2,6)*Metric(3,7)*Metric(4,5) - 2*P(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,5) + P(7,2)*Metric(1,5)*Metric(2,3)*Metric(4,6) + P(7,3)*Metric(1,5)*Metric(2,3)*Metric(4,6) - 2*P(7,5)*Metric(1,5)*Metric(2,3)*Metric(4,6) - P(5,2)*Metric(1,7)*Metric(2,3)*Metric(4,6) - P(5,3)*Metric(1,7)*Metric(2,3)*Metric(4,6) + 2*P(5,7)*Metric(1,7)*Metric(2,3)*Metric(4,6) + P(7,1)*Metric(1,3)*Metric(2,5)*Metric(4,6) + P(7,3)*Metric(1,3)*Metric(2,5)*Metric(4,6) - 2*P(7,5)*Metric(1,3)*Metric(2,5)*Metric(4,6) - P(3,1)*Metric(1,7)*Metric(2,5)*Metric(4,6) + P(3,2)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(3,4)*Metric(1,7)*Metric(2,5)*Metric(4,6) + P(3,6)*Metric(1,7)*Metric(2,5)*Metric(4,6) - P(5,1)*Metric(1,3)*Metric(2,7)*Metric(4,6) - P(5,3)*Metric(1,3)*Metric(2,7)*Metric(4,6) + 2*P(5,7)*Metric(1,3)*Metric(2,7)*Metric(4,6) + P(3,1)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(3,2)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(3,4)*Metric(1,5)*Metric(2,7)*Metric(4,6) + P(3,6)*Metric(1,5)*Metric(2,7)*Metric(4,6) + P(7,1)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(7,2)*Metric(1,2)*Metric(3,5)*Metric(4,6) - 2*P(7,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(2,1)*Metric(1,7)*Metric(3,5)*Metric(4,6) + P(2,3)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6) + P(2,6)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(1,2)*Metric(2,7)*Metric(3,5)*Metric(4,6) + P(1,3)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(1,4)*Metric(2,7)*Metric(3,5)*Metric(4,6) + P(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(5,1)*Metric(1,2)*Metric(3,7)*Metric(4,6) - P(5,2)*Metric(1,2)*Metric(3,7)*Metric(4,6) + 2*P(5,7)*Metric(1,2)*Metric(3,7)*Metric(4,6) + P(2,1)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,3)*Metric(1,5)*Metric(3,7)*Metric(4,6) - P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6) + P(2,6)*Metric(1,5)*Metric(3,7)*Metric(4,6) + P(1,2)*Metric(2,5)*Metric(3,7)*Metric(4,6) - P(1,3)*Metric(2,5)*Metric(3,7)*Metric(4,6) - P(1,4)*Metric(2,5)*Metric(3,7)*Metric(4,6) + P(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,6) + P(6,2)*Metric(1,5)*Metric(2,3)*Metric(4,7) + P(6,3)*Metric(1,5)*Metric(2,3)*Metric(4,7) - 2*P(6,5)*Metric(1,5)*Metric(2,3)*Metric(4,7) - P(5,2)*Metric(1,6)*Metric(2,3)*Metric(4,7) - P(5,3)*Metric(1,6)*Metric(2,3)*Metric(4,7) + 2*P(5,6)*Metric(1,6)*Metric(2,3)*Metric(4,7) + P(6,1)*Metric(1,3)*Metric(2,5)*Metric(4,7) + P(6,3)*Metric(1,3)*Metric(2,5)*Metric(4,7) - 2*P(6,5)*Metric(1,3)*Metric(2,5)*Metric(4,7) - P(3,1)*Metric(1,6)*Metric(2,5)*Metric(4,7) + P(3,2)*Metric(1,6)*Metric(2,5)*Metric(4,7) - P(3,4)*Metric(1,6)*Metric(2,5)*Metric(4,7) + P(3,7)*Metric(1,6)*Metric(2,5)*Metric(4,7) - P(5,1)*Metric(1,3)*Metric(2,6)*Metric(4,7) - P(5,3)*Metric(1,3)*Metric(2,6)*Metric(4,7) + 2*P(5,6)*Metric(1,3)*Metric(2,6)*Metric(4,7) + P(3,1)*Metric(1,5)*Metric(2,6)*Metric(4,7) - P(3,2)*Metric(1,5)*Metric(2,6)*Metric(4,7) - P(3,4)*Metric(1,5)*Metric(2,6)*Metric(4,7) + P(3,7)*Metric(1,5)*Metric(2,6)*Metric(4,7) + P(6,1)*Metric(1,2)*Metric(3,5)*Metric(4,7) + P(6,2)*Metric(1,2)*Metric(3,5)*Metric(4,7) - 2*P(6,5)*Metric(1,2)*Metric(3,5)*Metric(4,7) - P(2,1)*Metric(1,6)*Metric(3,5)*Metric(4,7) + P(2,3)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(2,4)*Metric(1,6)*Metric(3,5)*Metric(4,7) + P(2,7)*Metric(1,6)*Metric(3,5)*Metric(4,7) - P(1,2)*Metric(2,6)*Metric(3,5)*Metric(4,7) + P(1,3)*Metric(2,6)*Metric(3,5)*Metric(4,7) - P(1,4)*Metric(2,6)*Metric(3,5)*Metric(4,7) + P(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,7) - P(5,1)*Metric(1,2)*Metric(3,6)*Metric(4,7) - P(5,2)*Metric(1,2)*Metric(3,6)*Metric(4,7) + 2*P(5,6)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(2,1)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(2,3)*Metric(1,5)*Metric(3,6)*Metric(4,7) - P(2,4)*Metric(1,5)*Metric(3,6)*Metric(4,7) + P(2,7)*Metric(1,5)*Metric(3,6)*Metric(4,7) + P(1,2)*Metric(2,5)*Metric(3,6)*Metric(4,7) - P(1,3)*Metric(2,5)*Metric(3,6)*Metric(4,7) - P(1,4)*Metric(2,5)*Metric(3,6)*Metric(4,7) + P(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,7) + P(7,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(7,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - 2*P(7,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(4,2)*Metric(1,7)*Metric(2,3)*Metric(5,6) - P(4,3)*Metric(1,7)*Metric(2,3)*Metric(5,6) + 2*P(4,7)*Metric(1,7)*Metric(2,3)*Metric(5,6) + P(7,1)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(7,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) - 2*P(7,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(3,1)*Metric(1,7)*Metric(2,4)*Metric(5,6) + P(3,2)*Metric(1,7)*Metric(2,4)*Metric(5,6) - P(3,5)*Metric(1,7)*Metric(2,4)*Metric(5,6) + P(3,6)*Metric(1,7)*Metric(2,4)*Metric(5,6) - P(4,1)*Metric(1,3)*Metric(2,7)*Metric(5,6) - P(4,3)*Metric(1,3)*Metric(2,7)*Metric(5,6) + 2*P(4,7)*Metric(1,3)*Metric(2,7)*Metric(5,6) + P(3,1)*Metric(1,4)*Metric(2,7)*Metric(5,6) - P(3,2)*Metric(1,4)*Metric(2,7)*Metric(5,6) - P(3,5)*Metric(1,4)*Metric(2,7)*Metric(5,6) + P(3,6)*Metric(1,4)*Metric(2,7)*Metric(5,6) + P(7,1)*Metric(1,2)*Metric(3,4)*Metric(5,6) + P(7,2)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(7,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) - P(2,1)*Metric(1,7)*Metric(3,4)*Metric(5,6) + P(2,3)*Metric(1,7)*Metric(3,4)*Metric(5,6) - P(2,5)*Metric(1,7)*Metric(3,4)*Metric(5,6) + P(2,6)*Metric(1,7)*Metric(3,4)*Metric(5,6) - P(1,2)*Metric(2,7)*Metric(3,4)*Metric(5,6) + P(1,3)*Metric(2,7)*Metric(3,4)*Metric(5,6) - P(1,5)*Metric(2,7)*Metric(3,4)*Metric(5,6) + P(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,6) - P(4,1)*Metric(1,2)*Metric(3,7)*Metric(5,6) - P(4,2)*Metric(1,2)*Metric(3,7)*Metric(5,6) + 2*P(4,7)*Metric(1,2)*Metric(3,7)*Metric(5,6) + P(2,1)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(2,3)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(2,5)*Metric(1,4)*Metric(3,7)*Metric(5,6) + P(2,6)*Metric(1,4)*Metric(3,7)*Metric(5,6) + P(1,2)*Metric(2,4)*Metric(3,7)*Metric(5,6) - P(1,3)*Metric(2,4)*Metric(3,7)*Metric(5,6) - P(1,5)*Metric(2,4)*Metric(3,7)*Metric(5,6) + P(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,6) + 2*P(3,4)*Metric(1,2)*Metric(4,7)*Metric(5,6) + 2*P(3,5)*Metric(1,2)*Metric(4,7)*Metric(5,6) - 2*P(3,6)*Metric(1,2)*Metric(4,7)*Metric(5,6) - 2*P(3,7)*Metric(1,2)*Metric(4,7)*Metric(5,6) + 2*P(2,4)*Metric(1,3)*Metric(4,7)*Metric(5,6) + 2*P(2,5)*Metric(1,3)*Metric(4,7)*Metric(5,6) - 2*P(2,6)*Metric(1,3)*Metric(4,7)*Metric(5,6) - 2*P(2,7)*Metric(1,3)*Metric(4,7)*Metric(5,6) + 2*P(1,4)*Metric(2,3)*Metric(4,7)*Metric(5,6) + 2*P(1,5)*Metric(2,3)*Metric(4,7)*Metric(5,6) - 2*P(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,6) - 2*P(1,7)*Metric(2,3)*Metric(4,7)*Metric(5,6) + P(6,2)*Metric(1,4)*Metric(2,3)*Metric(5,7) + P(6,3)*Metric(1,4)*Metric(2,3)*Metric(5,7) - 2*P(6,4)*Metric(1,4)*Metric(2,3)*Metric(5,7) - P(4,2)*Metric(1,6)*Metric(2,3)*Metric(5,7) - P(4,3)*Metric(1,6)*Metric(2,3)*Metric(5,7) + 2*P(4,6)*Metric(1,6)*Metric(2,3)*Metric(5,7) + P(6,1)*Metric(1,3)*Metric(2,4)*Metric(5,7) + P(6,3)*Metric(1,3)*Metric(2,4)*Metric(5,7) - 2*P(6,4)*Metric(1,3)*Metric(2,4)*Metric(5,7) - P(3,1)*Metric(1,6)*Metric(2,4)*Metric(5,7) + P(3,2)*Metric(1,6)*Metric(2,4)*Metric(5,7) - P(3,5)*Metric(1,6)*Metric(2,4)*Metric(5,7) + P(3,7)*Metric(1,6)*Metric(2,4)*Metric(5,7) - P(4,1)*Metric(1,3)*Metric(2,6)*Metric(5,7) - P(4,3)*Metric(1,3)*Metric(2,6)*Metric(5,7) + 2*P(4,6)*Metric(1,3)*Metric(2,6)*Metric(5,7) + P(3,1)*Metric(1,4)*Metric(2,6)*Metric(5,7) - P(3,2)*Metric(1,4)*Metric(2,6)*Metric(5,7) - P(3,5)*Metric(1,4)*Metric(2,6)*Metric(5,7) + P(3,7)*Metric(1,4)*Metric(2,6)*Metric(5,7) + P(6,1)*Metric(1,2)*Metric(3,4)*Metric(5,7) + P(6,2)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 2*P(6,4)*Metric(1,2)*Metric(3,4)*Metric(5,7) - P(2,1)*Metric(1,6)*Metric(3,4)*Metric(5,7) + P(2,3)*Metric(1,6)*Metric(3,4)*Metric(5,7) - P(2,5)*Metric(1,6)*Metric(3,4)*Metric(5,7) + P(2,7)*Metric(1,6)*Metric(3,4)*Metric(5,7) - P(1,2)*Metric(2,6)*Metric(3,4)*Metric(5,7) + P(1,3)*Metric(2,6)*Metric(3,4)*Metric(5,7) - P(1,5)*Metric(2,6)*Metric(3,4)*Metric(5,7) + P(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,7) - P(4,1)*Metric(1,2)*Metric(3,6)*Metric(5,7) - P(4,2)*Metric(1,2)*Metric(3,6)*Metric(5,7) + 2*P(4,6)*Metric(1,2)*Metric(3,6)*Metric(5,7) + P(2,1)*Metric(1,4)*Metric(3,6)*Metric(5,7) - P(2,3)*Metric(1,4)*Metric(3,6)*Metric(5,7) - P(2,5)*Metric(1,4)*Metric(3,6)*Metric(5,7) + P(2,7)*Metric(1,4)*Metric(3,6)*Metric(5,7) + P(1,2)*Metric(2,4)*Metric(3,6)*Metric(5,7) - P(1,3)*Metric(2,4)*Metric(3,6)*Metric(5,7) - P(1,5)*Metric(2,4)*Metric(3,6)*Metric(5,7) + P(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,7) + 2*P(3,4)*Metric(1,2)*Metric(4,6)*Metric(5,7) + 2*P(3,5)*Metric(1,2)*Metric(4,6)*Metric(5,7) - 2*P(3,6)*Metric(1,2)*Metric(4,6)*Metric(5,7) - 2*P(3,7)*Metric(1,2)*Metric(4,6)*Metric(5,7) + 2*P(2,4)*Metric(1,3)*Metric(4,6)*Metric(5,7) + 2*P(2,5)*Metric(1,3)*Metric(4,6)*Metric(5,7) - 2*P(2,6)*Metric(1,3)*Metric(4,6)*Metric(5,7) - 2*P(2,7)*Metric(1,3)*Metric(4,6)*Metric(5,7) + 2*P(1,4)*Metric(2,3)*Metric(4,6)*Metric(5,7) + 2*P(1,5)*Metric(2,3)*Metric(4,6)*Metric(5,7) - 2*P(1,6)*Metric(2,3)*Metric(4,6)*Metric(5,7) - 2*P(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,7) + 2*P(5,2)*Metric(1,4)*Metric(2,3)*Metric(6,7) + 2*P(5,3)*Metric(1,4)*Metric(2,3)*Metric(6,7) - 4*P(5,4)*Metric(1,4)*Metric(2,3)*Metric(6,7) + 2*P(4,2)*Metric(1,5)*Metric(2,3)*Metric(6,7) + 2*P(4,3)*Metric(1,5)*Metric(2,3)*Metric(6,7) - 4*P(4,5)*Metric(1,5)*Metric(2,3)*Metric(6,7) + 2*P(5,1)*Metric(1,3)*Metric(2,4)*Metric(6,7) + 2*P(5,3)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 4*P(5,4)*Metric(1,3)*Metric(2,4)*Metric(6,7) - 2*P(3,1)*Metric(1,5)*Metric(2,4)*Metric(6,7) - 2*P(3,2)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(3,6)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(3,7)*Metric(1,5)*Metric(2,4)*Metric(6,7) + 2*P(4,1)*Metric(1,3)*Metric(2,5)*Metric(6,7) + 2*P(4,3)*Metric(1,3)*Metric(2,5)*Metric(6,7) - 4*P(4,5)*Metric(1,3)*Metric(2,5)*Metric(6,7) - 2*P(3,1)*Metric(1,4)*Metric(2,5)*Metric(6,7) - 2*P(3,2)*Metric(1,4)*Metric(2,5)*Metric(6,7) + 2*P(3,6)*Metric(1,4)*Metric(2,5)*Metric(6,7) + 2*P(3,7)*Metric(1,4)*Metric(2,5)*Metric(6,7) + 2*P(5,1)*Metric(1,2)*Metric(3,4)*Metric(6,7) + 2*P(5,2)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 4*P(5,4)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 2*P(2,1)*Metric(1,5)*Metric(3,4)*Metric(6,7) - 2*P(2,3)*Metric(1,5)*Metric(3,4)*Metric(6,7) + 2*P(2,6)*Metric(1,5)*Metric(3,4)*Metric(6,7) + 2*P(2,7)*Metric(1,5)*Metric(3,4)*Metric(6,7) - 2*P(1,2)*Metric(2,5)*Metric(3,4)*Metric(6,7) - 2*P(1,3)*Metric(2,5)*Metric(3,4)*Metric(6,7) + 2*P(1,6)*Metric(2,5)*Metric(3,4)*Metric(6,7) + 2*P(1,7)*Metric(2,5)*Metric(3,4)*Metric(6,7) + 2*P(4,1)*Metric(1,2)*Metric(3,5)*Metric(6,7) + 2*P(4,2)*Metric(1,2)*Metric(3,5)*Metric(6,7) - 4*P(4,5)*Metric(1,2)*Metric(3,5)*Metric(6,7) - 2*P(2,1)*Metric(1,4)*Metric(3,5)*Metric(6,7) - 2*P(2,3)*Metric(1,4)*Metric(3,5)*Metric(6,7) + 2*P(2,6)*Metric(1,4)*Metric(3,5)*Metric(6,7) + 2*P(2,7)*Metric(1,4)*Metric(3,5)*Metric(6,7) - 2*P(1,2)*Metric(2,4)*Metric(3,5)*Metric(6,7) - 2*P(1,3)*Metric(2,4)*Metric(3,5)*Metric(6,7) + 2*P(1,6)*Metric(2,4)*Metric(3,5)*Metric(6,7) + 2*P(1,7)*Metric(2,4)*Metric(3,5)*Metric(6,7) + 4*P(3,4)*Metric(1,2)*Metric(4,5)*Metric(6,7) + 4*P(3,5)*Metric(1,2)*Metric(4,5)*Metric(6,7) - 4*P(3,6)*Metric(1,2)*Metric(4,5)*Metric(6,7) - 4*P(3,7)*Metric(1,2)*Metric(4,5)*Metric(6,7) + 4*P(2,4)*Metric(1,3)*Metric(4,5)*Metric(6,7) + 4*P(2,5)*Metric(1,3)*Metric(4,5)*Metric(6,7) - 4*P(2,6)*Metric(1,3)*Metric(4,5)*Metric(6,7) - 4*P(2,7)*Metric(1,3)*Metric(4,5)*Metric(6,7) + 4*P(1,4)*Metric(2,3)*Metric(4,5)*Metric(6,7) + 4*P(1,5)*Metric(2,3)*Metric(4,5)*Metric(6,7) - 4*P(1,6)*Metric(2,3)*Metric(4,5)*Metric(6,7) - 4*P(1,7)*Metric(2,3)*Metric(4,5)*Metric(6,7)')

VVVVVVV11 = Lorentz(name = 'VVVVVVV11',
                    spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                    structure = 'P(7,1)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(7,2)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(7,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(7,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(6,1)*Metric(1,7)*Metric(2,5)*Metric(3,4) + 2*P(6,5)*Metric(1,7)*Metric(2,5)*Metric(3,4) - P(6,7)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(7,1)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(7,2)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(7,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(7,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(5,1)*Metric(1,7)*Metric(2,6)*Metric(3,4) + 2*P(5,6)*Metric(1,7)*Metric(2,6)*Metric(3,4) - P(5,7)*Metric(1,7)*Metric(2,6)*Metric(3,4) - P(6,2)*Metric(1,5)*Metric(2,7)*Metric(3,4) + 2*P(6,5)*Metric(1,5)*Metric(2,7)*Metric(3,4) - P(6,7)*Metric(1,5)*Metric(2,7)*Metric(3,4) - P(5,2)*Metric(1,6)*Metric(2,7)*Metric(3,4) + 2*P(5,6)*Metric(1,6)*Metric(2,7)*Metric(3,4) - P(5,7)*Metric(1,6)*Metric(2,7)*Metric(3,4) - (P(7,1)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(7,2)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(7,3)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(7,5)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(6,1)*Metric(1,7)*Metric(2,4)*Metric(3,5))/2. - P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5) + (P(6,7)*Metric(1,7)*Metric(2,4)*Metric(3,5))/2. + (P(7,1)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(7,2)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(7,3)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(7,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(4,1)*Metric(1,7)*Metric(2,6)*Metric(3,5))/2. + P(4,6)*Metric(1,7)*Metric(2,6)*Metric(3,5) - (P(4,7)*Metric(1,7)*Metric(2,6)*Metric(3,5))/2. + (P(6,2)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. - P(6,4)*Metric(1,4)*Metric(2,7)*Metric(3,5) + (P(6,7)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. - (P(4,2)*Metric(1,6)*Metric(2,7)*Metric(3,5))/2. + P(4,6)*Metric(1,6)*Metric(2,7)*Metric(3,5) - (P(4,7)*Metric(1,6)*Metric(2,7)*Metric(3,5))/2. - (P(7,1)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(7,2)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(7,3)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(7,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(5,1)*Metric(1,7)*Metric(2,4)*Metric(3,6))/2. - P(5,4)*Metric(1,7)*Metric(2,4)*Metric(3,6) + (P(5,7)*Metric(1,7)*Metric(2,4)*Metric(3,6))/2. + (P(7,1)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(7,2)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(7,3)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(7,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(4,1)*Metric(1,7)*Metric(2,5)*Metric(3,6))/2. + P(4,5)*Metric(1,7)*Metric(2,5)*Metric(3,6) - (P(4,7)*Metric(1,7)*Metric(2,5)*Metric(3,6))/2. + (P(5,2)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. - P(5,4)*Metric(1,4)*Metric(2,7)*Metric(3,6) + (P(5,7)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. - (P(4,2)*Metric(1,5)*Metric(2,7)*Metric(3,6))/2. + P(4,5)*Metric(1,5)*Metric(2,7)*Metric(3,6) - (P(4,7)*Metric(1,5)*Metric(2,7)*Metric(3,6))/2. + (P(6,3)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. + (P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. - P(6,5)*Metric(1,5)*Metric(2,4)*Metric(3,7) + (P(5,3)*Metric(1,6)*Metric(2,4)*Metric(3,7))/2. + (P(5,4)*Metric(1,6)*Metric(2,4)*Metric(3,7))/2. - P(5,6)*Metric(1,6)*Metric(2,4)*Metric(3,7) + (P(6,3)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. + (P(6,4)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. - P(6,5)*Metric(1,4)*Metric(2,5)*Metric(3,7) + P(4,3)*Metric(1,6)*Metric(2,5)*Metric(3,7) - (P(4,5)*Metric(1,6)*Metric(2,5)*Metric(3,7))/2. - (P(4,6)*Metric(1,6)*Metric(2,5)*Metric(3,7))/2. + (P(5,3)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. + (P(5,4)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. - P(5,6)*Metric(1,4)*Metric(2,6)*Metric(3,7) + P(4,3)*Metric(1,5)*Metric(2,6)*Metric(3,7) - (P(4,5)*Metric(1,5)*Metric(2,6)*Metric(3,7))/2. - (P(4,6)*Metric(1,5)*Metric(2,6)*Metric(3,7))/2. - (P(7,1)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(7,2)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(7,4)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(7,5)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(6,1)*Metric(1,7)*Metric(2,3)*Metric(4,5))/2. - P(6,3)*Metric(1,7)*Metric(2,3)*Metric(4,5) + (P(6,7)*Metric(1,7)*Metric(2,3)*Metric(4,5))/2. + (P(7,1)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(7,2)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(7,4)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(7,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(3,1)*Metric(1,7)*Metric(2,6)*Metric(4,5))/2. + P(3,6)*Metric(1,7)*Metric(2,6)*Metric(4,5) - (P(3,7)*Metric(1,7)*Metric(2,6)*Metric(4,5))/2. + (P(6,2)*Metric(1,3)*Metric(2,7)*Metric(4,5))/2. - P(6,3)*Metric(1,3)*Metric(2,7)*Metric(4,5) + (P(6,7)*Metric(1,3)*Metric(2,7)*Metric(4,5))/2. - (P(3,2)*Metric(1,6)*Metric(2,7)*Metric(4,5))/2. + P(3,6)*Metric(1,6)*Metric(2,7)*Metric(4,5) - (P(3,7)*Metric(1,6)*Metric(2,7)*Metric(4,5))/2. + P(7,3)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(7,4)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(7,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(7,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(2,3)*Metric(1,7)*Metric(3,6)*Metric(4,5) + P(2,4)*Metric(1,7)*Metric(3,6)*Metric(4,5) - P(2,5)*Metric(1,7)*Metric(3,6)*Metric(4,5) - P(2,6)*Metric(1,7)*Metric(3,6)*Metric(4,5) + P(1,3)*Metric(2,7)*Metric(3,6)*Metric(4,5) + P(1,4)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,5) - P(1,6)*Metric(2,7)*Metric(3,6)*Metric(4,5) + (P(6,1)*Metric(1,2)*Metric(3,7)*Metric(4,5))/2. + (P(6,2)*Metric(1,2)*Metric(3,7)*Metric(4,5))/2. - P(6,3)*Metric(1,2)*Metric(3,7)*Metric(4,5) - (P(2,1)*Metric(1,6)*Metric(3,7)*Metric(4,5))/2. - (P(2,4)*Metric(1,6)*Metric(3,7)*Metric(4,5))/2. + (P(2,5)*Metric(1,6)*Metric(3,7)*Metric(4,5))/2. + (P(2,7)*Metric(1,6)*Metric(3,7)*Metric(4,5))/2. - (P(1,2)*Metric(2,6)*Metric(3,7)*Metric(4,5))/2. - (P(1,4)*Metric(2,6)*Metric(3,7)*Metric(4,5))/2. + (P(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,5))/2. + (P(1,7)*Metric(2,6)*Metric(3,7)*Metric(4,5))/2. - (P(7,1)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(7,2)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(7,4)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(7,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(5,1)*Metric(1,7)*Metric(2,3)*Metric(4,6))/2. - P(5,3)*Metric(1,7)*Metric(2,3)*Metric(4,6) + (P(5,7)*Metric(1,7)*Metric(2,3)*Metric(4,6))/2. + (P(7,1)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(7,2)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(7,4)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(7,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(3,1)*Metric(1,7)*Metric(2,5)*Metric(4,6))/2. + P(3,5)*Metric(1,7)*Metric(2,5)*Metric(4,6) - (P(3,7)*Metric(1,7)*Metric(2,5)*Metric(4,6))/2. + (P(5,2)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. - P(5,3)*Metric(1,3)*Metric(2,7)*Metric(4,6) + (P(5,7)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. - (P(3,2)*Metric(1,5)*Metric(2,7)*Metric(4,6))/2. + P(3,5)*Metric(1,5)*Metric(2,7)*Metric(4,6) - (P(3,7)*Metric(1,5)*Metric(2,7)*Metric(4,6))/2. + P(7,3)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(7,4)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(7,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(7,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(2,3)*Metric(1,7)*Metric(3,5)*Metric(4,6) + P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,5)*Metric(1,7)*Metric(3,5)*Metric(4,6) - P(2,6)*Metric(1,7)*Metric(3,5)*Metric(4,6) + P(1,3)*Metric(2,7)*Metric(3,5)*Metric(4,6) + P(1,4)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(1,5)*Metric(2,7)*Metric(3,5)*Metric(4,6) - P(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,6) + (P(5,1)*Metric(1,2)*Metric(3,7)*Metric(4,6))/2. + (P(5,2)*Metric(1,2)*Metric(3,7)*Metric(4,6))/2. - P(5,3)*Metric(1,2)*Metric(3,7)*Metric(4,6) - (P(2,1)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. - (P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. + (P(2,6)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. + (P(2,7)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. - (P(1,2)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. - (P(1,4)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. + (P(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. + (P(1,7)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. + (P(6,3)*Metric(1,5)*Metric(2,3)*Metric(4,7))/2. + (P(6,4)*Metric(1,5)*Metric(2,3)*Metric(4,7))/2. - P(6,5)*Metric(1,5)*Metric(2,3)*Metric(4,7) + (P(5,3)*Metric(1,6)*Metric(2,3)*Metric(4,7))/2. + (P(5,4)*Metric(1,6)*Metric(2,3)*Metric(4,7))/2. - P(5,6)*Metric(1,6)*Metric(2,3)*Metric(4,7) + (P(6,3)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. + (P(6,4)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. - P(6,5)*Metric(1,3)*Metric(2,5)*Metric(4,7) + P(3,4)*Metric(1,6)*Metric(2,5)*Metric(4,7) - (P(3,5)*Metric(1,6)*Metric(2,5)*Metric(4,7))/2. - (P(3,6)*Metric(1,6)*Metric(2,5)*Metric(4,7))/2. + (P(5,3)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. + (P(5,4)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. - P(5,6)*Metric(1,3)*Metric(2,6)*Metric(4,7) + P(3,4)*Metric(1,5)*Metric(2,6)*Metric(4,7) - (P(3,5)*Metric(1,5)*Metric(2,6)*Metric(4,7))/2. - (P(3,6)*Metric(1,5)*Metric(2,6)*Metric(4,7))/2. + (P(6,1)*Metric(1,2)*Metric(3,5)*Metric(4,7))/2. + (P(6,2)*Metric(1,2)*Metric(3,5)*Metric(4,7))/2. - P(6,4)*Metric(1,2)*Metric(3,5)*Metric(4,7) - (P(2,1)*Metric(1,6)*Metric(3,5)*Metric(4,7))/2. - (P(2,3)*Metric(1,6)*Metric(3,5)*Metric(4,7))/2. + (P(2,5)*Metric(1,6)*Metric(3,5)*Metric(4,7))/2. + (P(2,7)*Metric(1,6)*Metric(3,5)*Metric(4,7))/2. - (P(1,2)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. - (P(1,3)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (P(1,5)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (P(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (P(5,1)*Metric(1,2)*Metric(3,6)*Metric(4,7))/2. + (P(5,2)*Metric(1,2)*Metric(3,6)*Metric(4,7))/2. - P(5,4)*Metric(1,2)*Metric(3,6)*Metric(4,7) - (P(2,1)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. - (P(2,3)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. + (P(2,6)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. + (P(2,7)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. - (P(1,2)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. - (P(1,3)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. + (P(1,6)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. + (P(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. - P(7,1)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(7,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(7,5)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(7,6)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(4,1)*Metric(1,7)*Metric(2,3)*Metric(5,6) - 2*P(4,3)*Metric(1,7)*Metric(2,3)*Metric(5,6) + P(4,7)*Metric(1,7)*Metric(2,3)*Metric(5,6) - P(7,1)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(7,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(7,5)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(7,6)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(3,1)*Metric(1,7)*Metric(2,4)*Metric(5,6) - 2*P(3,4)*Metric(1,7)*Metric(2,4)*Metric(5,6) + P(3,7)*Metric(1,7)*Metric(2,4)*Metric(5,6) + P(4,2)*Metric(1,3)*Metric(2,7)*Metric(5,6) - 2*P(4,3)*Metric(1,3)*Metric(2,7)*Metric(5,6) + P(4,7)*Metric(1,3)*Metric(2,7)*Metric(5,6) + P(3,2)*Metric(1,4)*Metric(2,7)*Metric(5,6) - 2*P(3,4)*Metric(1,4)*Metric(2,7)*Metric(5,6) + P(3,7)*Metric(1,4)*Metric(2,7)*Metric(5,6) + 2*P(7,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(7,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(7,5)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(7,6)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(2,3)*Metric(1,7)*Metric(3,4)*Metric(5,6) + 2*P(2,4)*Metric(1,7)*Metric(3,4)*Metric(5,6) - 2*P(2,5)*Metric(1,7)*Metric(3,4)*Metric(5,6) - 2*P(2,6)*Metric(1,7)*Metric(3,4)*Metric(5,6) + 2*P(1,3)*Metric(2,7)*Metric(3,4)*Metric(5,6) + 2*P(1,4)*Metric(2,7)*Metric(3,4)*Metric(5,6) - 2*P(1,5)*Metric(2,7)*Metric(3,4)*Metric(5,6) - 2*P(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,6) + P(4,1)*Metric(1,2)*Metric(3,7)*Metric(5,6) + P(4,2)*Metric(1,2)*Metric(3,7)*Metric(5,6) - 2*P(4,3)*Metric(1,2)*Metric(3,7)*Metric(5,6) - P(2,1)*Metric(1,4)*Metric(3,7)*Metric(5,6) + P(2,5)*Metric(1,4)*Metric(3,7)*Metric(5,6) + P(2,6)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(2,7)*Metric(1,4)*Metric(3,7)*Metric(5,6) - P(1,2)*Metric(2,4)*Metric(3,7)*Metric(5,6) + P(1,5)*Metric(2,4)*Metric(3,7)*Metric(5,6) + P(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,6) - P(1,7)*Metric(2,4)*Metric(3,7)*Metric(5,6) + P(3,1)*Metric(1,2)*Metric(4,7)*Metric(5,6) + P(3,2)*Metric(1,2)*Metric(4,7)*Metric(5,6) - 2*P(3,4)*Metric(1,2)*Metric(4,7)*Metric(5,6) - P(2,1)*Metric(1,3)*Metric(4,7)*Metric(5,6) + P(2,5)*Metric(1,3)*Metric(4,7)*Metric(5,6) + P(2,6)*Metric(1,3)*Metric(4,7)*Metric(5,6) - P(2,7)*Metric(1,3)*Metric(4,7)*Metric(5,6) - P(1,2)*Metric(2,3)*Metric(4,7)*Metric(5,6) + P(1,5)*Metric(2,3)*Metric(4,7)*Metric(5,6) + P(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,6) - P(1,7)*Metric(2,3)*Metric(4,7)*Metric(5,6) + (P(6,3)*Metric(1,4)*Metric(2,3)*Metric(5,7))/2. + (P(6,4)*Metric(1,4)*Metric(2,3)*Metric(5,7))/2. - P(6,5)*Metric(1,4)*Metric(2,3)*Metric(5,7) + P(4,3)*Metric(1,6)*Metric(2,3)*Metric(5,7) - (P(4,5)*Metric(1,6)*Metric(2,3)*Metric(5,7))/2. - (P(4,6)*Metric(1,6)*Metric(2,3)*Metric(5,7))/2. + (P(6,3)*Metric(1,3)*Metric(2,4)*Metric(5,7))/2. + (P(6,4)*Metric(1,3)*Metric(2,4)*Metric(5,7))/2. - P(6,5)*Metric(1,3)*Metric(2,4)*Metric(5,7) + P(3,4)*Metric(1,6)*Metric(2,4)*Metric(5,7) - (P(3,5)*Metric(1,6)*Metric(2,4)*Metric(5,7))/2. - (P(3,6)*Metric(1,6)*Metric(2,4)*Metric(5,7))/2. + P(4,3)*Metric(1,3)*Metric(2,6)*Metric(5,7) - (P(4,5)*Metric(1,3)*Metric(2,6)*Metric(5,7))/2. - (P(4,6)*Metric(1,3)*Metric(2,6)*Metric(5,7))/2. + P(3,4)*Metric(1,4)*Metric(2,6)*Metric(5,7) - (P(3,5)*Metric(1,4)*Metric(2,6)*Metric(5,7))/2. - (P(3,6)*Metric(1,4)*Metric(2,6)*Metric(5,7))/2. - P(6,1)*Metric(1,2)*Metric(3,4)*Metric(5,7) - P(6,2)*Metric(1,2)*Metric(3,4)*Metric(5,7) + 2*P(6,5)*Metric(1,2)*Metric(3,4)*Metric(5,7) + P(2,1)*Metric(1,6)*Metric(3,4)*Metric(5,7) - P(2,3)*Metric(1,6)*Metric(3,4)*Metric(5,7) - P(2,4)*Metric(1,6)*Metric(3,4)*Metric(5,7) + P(2,7)*Metric(1,6)*Metric(3,4)*Metric(5,7) + P(1,2)*Metric(2,6)*Metric(3,4)*Metric(5,7) - P(1,3)*Metric(2,6)*Metric(3,4)*Metric(5,7) - P(1,4)*Metric(2,6)*Metric(3,4)*Metric(5,7) + P(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,7) - (P(4,1)*Metric(1,2)*Metric(3,6)*Metric(5,7))/2. - (P(4,2)*Metric(1,2)*Metric(3,6)*Metric(5,7))/2. + P(4,5)*Metric(1,2)*Metric(3,6)*Metric(5,7) + (P(2,1)*Metric(1,4)*Metric(3,6)*Metric(5,7))/2. - (P(2,3)*Metric(1,4)*Metric(3,6)*Metric(5,7))/2. + (P(2,6)*Metric(1,4)*Metric(3,6)*Metric(5,7))/2. - (P(2,7)*Metric(1,4)*Metric(3,6)*Metric(5,7))/2. + (P(1,2)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. - (P(1,3)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. + (P(1,6)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. - (P(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. - (P(3,1)*Metric(1,2)*Metric(4,6)*Metric(5,7))/2. - (P(3,2)*Metric(1,2)*Metric(4,6)*Metric(5,7))/2. + P(3,5)*Metric(1,2)*Metric(4,6)*Metric(5,7) + (P(2,1)*Metric(1,3)*Metric(4,6)*Metric(5,7))/2. - (P(2,4)*Metric(1,3)*Metric(4,6)*Metric(5,7))/2. + (P(2,6)*Metric(1,3)*Metric(4,6)*Metric(5,7))/2. - (P(2,7)*Metric(1,3)*Metric(4,6)*Metric(5,7))/2. + (P(1,2)*Metric(2,3)*Metric(4,6)*Metric(5,7))/2. - (P(1,4)*Metric(2,3)*Metric(4,6)*Metric(5,7))/2. + (P(1,6)*Metric(2,3)*Metric(4,6)*Metric(5,7))/2. - (P(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,7))/2. + (P(5,3)*Metric(1,4)*Metric(2,3)*Metric(6,7))/2. + (P(5,4)*Metric(1,4)*Metric(2,3)*Metric(6,7))/2. - P(5,6)*Metric(1,4)*Metric(2,3)*Metric(6,7) + P(4,3)*Metric(1,5)*Metric(2,3)*Metric(6,7) - (P(4,5)*Metric(1,5)*Metric(2,3)*Metric(6,7))/2. - (P(4,6)*Metric(1,5)*Metric(2,3)*Metric(6,7))/2. + (P(5,3)*Metric(1,3)*Metric(2,4)*Metric(6,7))/2. + (P(5,4)*Metric(1,3)*Metric(2,4)*Metric(6,7))/2. - P(5,6)*Metric(1,3)*Metric(2,4)*Metric(6,7) + P(3,4)*Metric(1,5)*Metric(2,4)*Metric(6,7) - (P(3,5)*Metric(1,5)*Metric(2,4)*Metric(6,7))/2. - (P(3,6)*Metric(1,5)*Metric(2,4)*Metric(6,7))/2. + P(4,3)*Metric(1,3)*Metric(2,5)*Metric(6,7) - (P(4,5)*Metric(1,3)*Metric(2,5)*Metric(6,7))/2. - (P(4,6)*Metric(1,3)*Metric(2,5)*Metric(6,7))/2. + P(3,4)*Metric(1,4)*Metric(2,5)*Metric(6,7) - (P(3,5)*Metric(1,4)*Metric(2,5)*Metric(6,7))/2. - (P(3,6)*Metric(1,4)*Metric(2,5)*Metric(6,7))/2. - P(5,1)*Metric(1,2)*Metric(3,4)*Metric(6,7) - P(5,2)*Metric(1,2)*Metric(3,4)*Metric(6,7) + 2*P(5,6)*Metric(1,2)*Metric(3,4)*Metric(6,7) + P(2,1)*Metric(1,5)*Metric(3,4)*Metric(6,7) - P(2,3)*Metric(1,5)*Metric(3,4)*Metric(6,7) - P(2,4)*Metric(1,5)*Metric(3,4)*Metric(6,7) + P(2,7)*Metric(1,5)*Metric(3,4)*Metric(6,7) + P(1,2)*Metric(2,5)*Metric(3,4)*Metric(6,7) - P(1,3)*Metric(2,5)*Metric(3,4)*Metric(6,7) - P(1,4)*Metric(2,5)*Metric(3,4)*Metric(6,7) + P(1,7)*Metric(2,5)*Metric(3,4)*Metric(6,7) - (P(4,1)*Metric(1,2)*Metric(3,5)*Metric(6,7))/2. - (P(4,2)*Metric(1,2)*Metric(3,5)*Metric(6,7))/2. + P(4,6)*Metric(1,2)*Metric(3,5)*Metric(6,7) + (P(2,1)*Metric(1,4)*Metric(3,5)*Metric(6,7))/2. - (P(2,3)*Metric(1,4)*Metric(3,5)*Metric(6,7))/2. + (P(2,5)*Metric(1,4)*Metric(3,5)*Metric(6,7))/2. - (P(2,7)*Metric(1,4)*Metric(3,5)*Metric(6,7))/2. + (P(1,2)*Metric(2,4)*Metric(3,5)*Metric(6,7))/2. - (P(1,3)*Metric(2,4)*Metric(3,5)*Metric(6,7))/2. + (P(1,5)*Metric(2,4)*Metric(3,5)*Metric(6,7))/2. - (P(1,7)*Metric(2,4)*Metric(3,5)*Metric(6,7))/2. - (P(3,1)*Metric(1,2)*Metric(4,5)*Metric(6,7))/2. - (P(3,2)*Metric(1,2)*Metric(4,5)*Metric(6,7))/2. + P(3,6)*Metric(1,2)*Metric(4,5)*Metric(6,7) + (P(2,1)*Metric(1,3)*Metric(4,5)*Metric(6,7))/2. - (P(2,4)*Metric(1,3)*Metric(4,5)*Metric(6,7))/2. + (P(2,5)*Metric(1,3)*Metric(4,5)*Metric(6,7))/2. - (P(2,7)*Metric(1,3)*Metric(4,5)*Metric(6,7))/2. + (P(1,2)*Metric(2,3)*Metric(4,5)*Metric(6,7))/2. - (P(1,4)*Metric(2,3)*Metric(4,5)*Metric(6,7))/2. + (P(1,5)*Metric(2,3)*Metric(4,5)*Metric(6,7))/2. - (P(1,7)*Metric(2,3)*Metric(4,5)*Metric(6,7))/2.')

VVVVVVV12 = Lorentz(name = 'VVVVVVV12',
                    spins = [ 3, 3, 3, 3, 3, 3, 3 ],
                    structure = 'P(7,3)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(7,4)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(7,5)*Metric(1,6)*Metric(2,5)*Metric(3,4) - P(7,6)*Metric(1,6)*Metric(2,5)*Metric(3,4) + P(6,3)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(6,4)*Metric(1,7)*Metric(2,5)*Metric(3,4) - P(6,5)*Metric(1,7)*Metric(2,5)*Metric(3,4) - P(6,7)*Metric(1,7)*Metric(2,5)*Metric(3,4) + P(7,3)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(7,4)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(7,5)*Metric(1,5)*Metric(2,6)*Metric(3,4) - P(7,6)*Metric(1,5)*Metric(2,6)*Metric(3,4) + P(5,3)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(5,4)*Metric(1,7)*Metric(2,6)*Metric(3,4) - P(5,6)*Metric(1,7)*Metric(2,6)*Metric(3,4) - P(5,7)*Metric(1,7)*Metric(2,6)*Metric(3,4) + P(6,3)*Metric(1,5)*Metric(2,7)*Metric(3,4) + P(6,4)*Metric(1,5)*Metric(2,7)*Metric(3,4) - P(6,5)*Metric(1,5)*Metric(2,7)*Metric(3,4) - P(6,7)*Metric(1,5)*Metric(2,7)*Metric(3,4) + P(5,3)*Metric(1,6)*Metric(2,7)*Metric(3,4) + P(5,4)*Metric(1,6)*Metric(2,7)*Metric(3,4) - P(5,6)*Metric(1,6)*Metric(2,7)*Metric(3,4) - P(5,7)*Metric(1,6)*Metric(2,7)*Metric(3,4) - (P(7,2)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(7,4)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(7,5)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. + (P(7,6)*Metric(1,6)*Metric(2,4)*Metric(3,5))/2. - (P(6,2)*Metric(1,7)*Metric(2,4)*Metric(3,5))/2. + (P(6,4)*Metric(1,7)*Metric(2,4)*Metric(3,5))/2. - (P(6,5)*Metric(1,7)*Metric(2,4)*Metric(3,5))/2. + (P(6,7)*Metric(1,7)*Metric(2,4)*Metric(3,5))/2. - (P(7,1)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(7,4)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. - (P(7,5)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(7,6)*Metric(1,4)*Metric(2,6)*Metric(3,5))/2. + (P(4,1)*Metric(1,7)*Metric(2,6)*Metric(3,5))/2. + (P(4,2)*Metric(1,7)*Metric(2,6)*Metric(3,5))/2. - P(4,3)*Metric(1,7)*Metric(2,6)*Metric(3,5) - (P(6,1)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. + (P(6,4)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. - (P(6,5)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. + (P(6,7)*Metric(1,4)*Metric(2,7)*Metric(3,5))/2. + (P(4,1)*Metric(1,6)*Metric(2,7)*Metric(3,5))/2. + (P(4,2)*Metric(1,6)*Metric(2,7)*Metric(3,5))/2. - P(4,3)*Metric(1,6)*Metric(2,7)*Metric(3,5) - (P(7,2)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(7,4)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. + (P(7,5)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(7,6)*Metric(1,5)*Metric(2,4)*Metric(3,6))/2. - (P(5,2)*Metric(1,7)*Metric(2,4)*Metric(3,6))/2. + (P(5,4)*Metric(1,7)*Metric(2,4)*Metric(3,6))/2. - (P(5,6)*Metric(1,7)*Metric(2,4)*Metric(3,6))/2. + (P(5,7)*Metric(1,7)*Metric(2,4)*Metric(3,6))/2. - (P(7,1)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(7,4)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(7,5)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. - (P(7,6)*Metric(1,4)*Metric(2,5)*Metric(3,6))/2. + (P(4,1)*Metric(1,7)*Metric(2,5)*Metric(3,6))/2. + (P(4,2)*Metric(1,7)*Metric(2,5)*Metric(3,6))/2. - P(4,3)*Metric(1,7)*Metric(2,5)*Metric(3,6) - (P(5,1)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. + (P(5,4)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. - (P(5,6)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. + (P(5,7)*Metric(1,4)*Metric(2,7)*Metric(3,6))/2. + (P(4,1)*Metric(1,5)*Metric(2,7)*Metric(3,6))/2. + (P(4,2)*Metric(1,5)*Metric(2,7)*Metric(3,6))/2. - P(4,3)*Metric(1,5)*Metric(2,7)*Metric(3,6) - (P(6,2)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. + (P(6,4)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. + (P(6,5)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. - (P(6,7)*Metric(1,5)*Metric(2,4)*Metric(3,7))/2. - (P(5,2)*Metric(1,6)*Metric(2,4)*Metric(3,7))/2. + (P(5,4)*Metric(1,6)*Metric(2,4)*Metric(3,7))/2. + (P(5,6)*Metric(1,6)*Metric(2,4)*Metric(3,7))/2. - (P(5,7)*Metric(1,6)*Metric(2,4)*Metric(3,7))/2. - (P(6,1)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. + (P(6,4)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. + (P(6,5)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. - (P(6,7)*Metric(1,4)*Metric(2,5)*Metric(3,7))/2. + (P(4,1)*Metric(1,6)*Metric(2,5)*Metric(3,7))/2. + (P(4,2)*Metric(1,6)*Metric(2,5)*Metric(3,7))/2. - P(4,3)*Metric(1,6)*Metric(2,5)*Metric(3,7) - (P(5,1)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. + (P(5,4)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. + (P(5,6)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. - (P(5,7)*Metric(1,4)*Metric(2,6)*Metric(3,7))/2. + (P(4,1)*Metric(1,5)*Metric(2,6)*Metric(3,7))/2. + (P(4,2)*Metric(1,5)*Metric(2,6)*Metric(3,7))/2. - P(4,3)*Metric(1,5)*Metric(2,6)*Metric(3,7) - (P(7,2)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(7,3)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(7,5)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. + (P(7,6)*Metric(1,6)*Metric(2,3)*Metric(4,5))/2. - (P(6,2)*Metric(1,7)*Metric(2,3)*Metric(4,5))/2. + (P(6,3)*Metric(1,7)*Metric(2,3)*Metric(4,5))/2. - (P(6,5)*Metric(1,7)*Metric(2,3)*Metric(4,5))/2. + (P(6,7)*Metric(1,7)*Metric(2,3)*Metric(4,5))/2. - (P(7,1)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(7,3)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. - (P(7,5)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(7,6)*Metric(1,3)*Metric(2,6)*Metric(4,5))/2. + (P(3,1)*Metric(1,7)*Metric(2,6)*Metric(4,5))/2. + (P(3,2)*Metric(1,7)*Metric(2,6)*Metric(4,5))/2. - P(3,4)*Metric(1,7)*Metric(2,6)*Metric(4,5) - (P(6,1)*Metric(1,3)*Metric(2,7)*Metric(4,5))/2. + (P(6,3)*Metric(1,3)*Metric(2,7)*Metric(4,5))/2. - (P(6,5)*Metric(1,3)*Metric(2,7)*Metric(4,5))/2. + (P(6,7)*Metric(1,3)*Metric(2,7)*Metric(4,5))/2. + (P(3,1)*Metric(1,6)*Metric(2,7)*Metric(4,5))/2. + (P(3,2)*Metric(1,6)*Metric(2,7)*Metric(4,5))/2. - P(3,4)*Metric(1,6)*Metric(2,7)*Metric(4,5) - P(7,1)*Metric(1,2)*Metric(3,6)*Metric(4,5) - P(7,2)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(7,5)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(7,6)*Metric(1,2)*Metric(3,6)*Metric(4,5) + P(2,1)*Metric(1,7)*Metric(3,6)*Metric(4,5) - (P(2,3)*Metric(1,7)*Metric(3,6)*Metric(4,5))/2. - (P(2,4)*Metric(1,7)*Metric(3,6)*Metric(4,5))/2. + P(1,2)*Metric(2,7)*Metric(3,6)*Metric(4,5) - (P(1,3)*Metric(2,7)*Metric(3,6)*Metric(4,5))/2. - (P(1,4)*Metric(2,7)*Metric(3,6)*Metric(4,5))/2. - P(6,1)*Metric(1,2)*Metric(3,7)*Metric(4,5) - P(6,2)*Metric(1,2)*Metric(3,7)*Metric(4,5) + P(6,5)*Metric(1,2)*Metric(3,7)*Metric(4,5) + P(6,7)*Metric(1,2)*Metric(3,7)*Metric(4,5) + P(2,1)*Metric(1,6)*Metric(3,7)*Metric(4,5) - (P(2,3)*Metric(1,6)*Metric(3,7)*Metric(4,5))/2. - (P(2,4)*Metric(1,6)*Metric(3,7)*Metric(4,5))/2. + P(1,2)*Metric(2,6)*Metric(3,7)*Metric(4,5) - (P(1,3)*Metric(2,6)*Metric(3,7)*Metric(4,5))/2. - (P(1,4)*Metric(2,6)*Metric(3,7)*Metric(4,5))/2. - (P(7,2)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(7,3)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. + (P(7,5)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(7,6)*Metric(1,5)*Metric(2,3)*Metric(4,6))/2. - (P(5,2)*Metric(1,7)*Metric(2,3)*Metric(4,6))/2. + (P(5,3)*Metric(1,7)*Metric(2,3)*Metric(4,6))/2. - (P(5,6)*Metric(1,7)*Metric(2,3)*Metric(4,6))/2. + (P(5,7)*Metric(1,7)*Metric(2,3)*Metric(4,6))/2. - (P(7,1)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(7,3)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(7,5)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. - (P(7,6)*Metric(1,3)*Metric(2,5)*Metric(4,6))/2. + (P(3,1)*Metric(1,7)*Metric(2,5)*Metric(4,6))/2. + (P(3,2)*Metric(1,7)*Metric(2,5)*Metric(4,6))/2. - P(3,4)*Metric(1,7)*Metric(2,5)*Metric(4,6) - (P(5,1)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. + (P(5,3)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. - (P(5,6)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. + (P(5,7)*Metric(1,3)*Metric(2,7)*Metric(4,6))/2. + (P(3,1)*Metric(1,5)*Metric(2,7)*Metric(4,6))/2. + (P(3,2)*Metric(1,5)*Metric(2,7)*Metric(4,6))/2. - P(3,4)*Metric(1,5)*Metric(2,7)*Metric(4,6) - P(7,1)*Metric(1,2)*Metric(3,5)*Metric(4,6) - P(7,2)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(7,5)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(7,6)*Metric(1,2)*Metric(3,5)*Metric(4,6) + P(2,1)*Metric(1,7)*Metric(3,5)*Metric(4,6) - (P(2,3)*Metric(1,7)*Metric(3,5)*Metric(4,6))/2. - (P(2,4)*Metric(1,7)*Metric(3,5)*Metric(4,6))/2. + P(1,2)*Metric(2,7)*Metric(3,5)*Metric(4,6) - (P(1,3)*Metric(2,7)*Metric(3,5)*Metric(4,6))/2. - (P(1,4)*Metric(2,7)*Metric(3,5)*Metric(4,6))/2. - P(5,1)*Metric(1,2)*Metric(3,7)*Metric(4,6) - P(5,2)*Metric(1,2)*Metric(3,7)*Metric(4,6) + P(5,6)*Metric(1,2)*Metric(3,7)*Metric(4,6) + P(5,7)*Metric(1,2)*Metric(3,7)*Metric(4,6) + P(2,1)*Metric(1,5)*Metric(3,7)*Metric(4,6) - (P(2,3)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. - (P(2,4)*Metric(1,5)*Metric(3,7)*Metric(4,6))/2. + P(1,2)*Metric(2,5)*Metric(3,7)*Metric(4,6) - (P(1,3)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. - (P(1,4)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. - (P(6,2)*Metric(1,5)*Metric(2,3)*Metric(4,7))/2. + (P(6,3)*Metric(1,5)*Metric(2,3)*Metric(4,7))/2. + (P(6,5)*Metric(1,5)*Metric(2,3)*Metric(4,7))/2. - (P(6,7)*Metric(1,5)*Metric(2,3)*Metric(4,7))/2. - (P(5,2)*Metric(1,6)*Metric(2,3)*Metric(4,7))/2. + (P(5,3)*Metric(1,6)*Metric(2,3)*Metric(4,7))/2. + (P(5,6)*Metric(1,6)*Metric(2,3)*Metric(4,7))/2. - (P(5,7)*Metric(1,6)*Metric(2,3)*Metric(4,7))/2. - (P(6,1)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. + (P(6,3)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. + (P(6,5)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. - (P(6,7)*Metric(1,3)*Metric(2,5)*Metric(4,7))/2. + (P(3,1)*Metric(1,6)*Metric(2,5)*Metric(4,7))/2. + (P(3,2)*Metric(1,6)*Metric(2,5)*Metric(4,7))/2. - P(3,4)*Metric(1,6)*Metric(2,5)*Metric(4,7) - (P(5,1)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. + (P(5,3)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. + (P(5,6)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. - (P(5,7)*Metric(1,3)*Metric(2,6)*Metric(4,7))/2. + (P(3,1)*Metric(1,5)*Metric(2,6)*Metric(4,7))/2. + (P(3,2)*Metric(1,5)*Metric(2,6)*Metric(4,7))/2. - P(3,4)*Metric(1,5)*Metric(2,6)*Metric(4,7) - P(6,1)*Metric(1,2)*Metric(3,5)*Metric(4,7) - P(6,2)*Metric(1,2)*Metric(3,5)*Metric(4,7) + P(6,5)*Metric(1,2)*Metric(3,5)*Metric(4,7) + P(6,7)*Metric(1,2)*Metric(3,5)*Metric(4,7) + P(2,1)*Metric(1,6)*Metric(3,5)*Metric(4,7) - (P(2,3)*Metric(1,6)*Metric(3,5)*Metric(4,7))/2. - (P(2,4)*Metric(1,6)*Metric(3,5)*Metric(4,7))/2. + P(1,2)*Metric(2,6)*Metric(3,5)*Metric(4,7) - (P(1,3)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. - (P(1,4)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. - P(5,1)*Metric(1,2)*Metric(3,6)*Metric(4,7) - P(5,2)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(5,6)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(5,7)*Metric(1,2)*Metric(3,6)*Metric(4,7) + P(2,1)*Metric(1,5)*Metric(3,6)*Metric(4,7) - (P(2,3)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. - (P(2,4)*Metric(1,5)*Metric(3,6)*Metric(4,7))/2. + P(1,2)*Metric(2,5)*Metric(3,6)*Metric(4,7) - (P(1,3)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. - (P(1,4)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. + P(7,1)*Metric(1,4)*Metric(2,3)*Metric(5,6) + P(7,2)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(7,3)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(7,4)*Metric(1,4)*Metric(2,3)*Metric(5,6) - P(4,1)*Metric(1,7)*Metric(2,3)*Metric(5,6) + (P(4,5)*Metric(1,7)*Metric(2,3)*Metric(5,6))/2. + (P(4,6)*Metric(1,7)*Metric(2,3)*Metric(5,6))/2. + P(7,1)*Metric(1,3)*Metric(2,4)*Metric(5,6) + P(7,2)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(7,3)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(7,4)*Metric(1,3)*Metric(2,4)*Metric(5,6) - P(3,1)*Metric(1,7)*Metric(2,4)*Metric(5,6) + (P(3,5)*Metric(1,7)*Metric(2,4)*Metric(5,6))/2. + (P(3,6)*Metric(1,7)*Metric(2,4)*Metric(5,6))/2. - P(4,2)*Metric(1,3)*Metric(2,7)*Metric(5,6) + (P(4,5)*Metric(1,3)*Metric(2,7)*Metric(5,6))/2. + (P(4,6)*Metric(1,3)*Metric(2,7)*Metric(5,6))/2. - P(3,2)*Metric(1,4)*Metric(2,7)*Metric(5,6) + (P(3,5)*Metric(1,4)*Metric(2,7)*Metric(5,6))/2. + (P(3,6)*Metric(1,4)*Metric(2,7)*Metric(5,6))/2. + 2*P(7,1)*Metric(1,2)*Metric(3,4)*Metric(5,6) + 2*P(7,2)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(7,3)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(7,4)*Metric(1,2)*Metric(3,4)*Metric(5,6) - 2*P(2,1)*Metric(1,7)*Metric(3,4)*Metric(5,6) + P(2,5)*Metric(1,7)*Metric(3,4)*Metric(5,6) + P(2,6)*Metric(1,7)*Metric(3,4)*Metric(5,6) - 2*P(1,2)*Metric(2,7)*Metric(3,4)*Metric(5,6) + P(1,5)*Metric(2,7)*Metric(3,4)*Metric(5,6) + P(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,6) + 2*P(4,3)*Metric(1,2)*Metric(3,7)*Metric(5,6) - P(4,5)*Metric(1,2)*Metric(3,7)*Metric(5,6) - P(4,6)*Metric(1,2)*Metric(3,7)*Metric(5,6) + P(2,3)*Metric(1,4)*Metric(3,7)*Metric(5,6) - (P(2,5)*Metric(1,4)*Metric(3,7)*Metric(5,6))/2. - (P(2,6)*Metric(1,4)*Metric(3,7)*Metric(5,6))/2. + P(1,3)*Metric(2,4)*Metric(3,7)*Metric(5,6) - (P(1,5)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. - (P(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. + 2*P(3,4)*Metric(1,2)*Metric(4,7)*Metric(5,6) - P(3,5)*Metric(1,2)*Metric(4,7)*Metric(5,6) - P(3,6)*Metric(1,2)*Metric(4,7)*Metric(5,6) + P(2,4)*Metric(1,3)*Metric(4,7)*Metric(5,6) - (P(2,5)*Metric(1,3)*Metric(4,7)*Metric(5,6))/2. - (P(2,6)*Metric(1,3)*Metric(4,7)*Metric(5,6))/2. + P(1,4)*Metric(2,3)*Metric(4,7)*Metric(5,6) - (P(1,5)*Metric(2,3)*Metric(4,7)*Metric(5,6))/2. - (P(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,6))/2. + P(6,1)*Metric(1,4)*Metric(2,3)*Metric(5,7) + P(6,2)*Metric(1,4)*Metric(2,3)*Metric(5,7) - P(6,3)*Metric(1,4)*Metric(2,3)*Metric(5,7) - P(6,4)*Metric(1,4)*Metric(2,3)*Metric(5,7) - P(4,1)*Metric(1,6)*Metric(2,3)*Metric(5,7) + (P(4,5)*Metric(1,6)*Metric(2,3)*Metric(5,7))/2. + (P(4,7)*Metric(1,6)*Metric(2,3)*Metric(5,7))/2. + P(6,1)*Metric(1,3)*Metric(2,4)*Metric(5,7) + P(6,2)*Metric(1,3)*Metric(2,4)*Metric(5,7) - P(6,3)*Metric(1,3)*Metric(2,4)*Metric(5,7) - P(6,4)*Metric(1,3)*Metric(2,4)*Metric(5,7) - P(3,1)*Metric(1,6)*Metric(2,4)*Metric(5,7) + (P(3,5)*Metric(1,6)*Metric(2,4)*Metric(5,7))/2. + (P(3,7)*Metric(1,6)*Metric(2,4)*Metric(5,7))/2. - P(4,2)*Metric(1,3)*Metric(2,6)*Metric(5,7) + (P(4,5)*Metric(1,3)*Metric(2,6)*Metric(5,7))/2. + (P(4,7)*Metric(1,3)*Metric(2,6)*Metric(5,7))/2. - P(3,2)*Metric(1,4)*Metric(2,6)*Metric(5,7) + (P(3,5)*Metric(1,4)*Metric(2,6)*Metric(5,7))/2. + (P(3,7)*Metric(1,4)*Metric(2,6)*Metric(5,7))/2. + 2*P(6,1)*Metric(1,2)*Metric(3,4)*Metric(5,7) + 2*P(6,2)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 2*P(6,3)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 2*P(6,4)*Metric(1,2)*Metric(3,4)*Metric(5,7) - 2*P(2,1)*Metric(1,6)*Metric(3,4)*Metric(5,7) + P(2,5)*Metric(1,6)*Metric(3,4)*Metric(5,7) + P(2,7)*Metric(1,6)*Metric(3,4)*Metric(5,7) - 2*P(1,2)*Metric(2,6)*Metric(3,4)*Metric(5,7) + P(1,5)*Metric(2,6)*Metric(3,4)*Metric(5,7) + P(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,7) + 2*P(4,3)*Metric(1,2)*Metric(3,6)*Metric(5,7) - P(4,5)*Metric(1,2)*Metric(3,6)*Metric(5,7) - P(4,7)*Metric(1,2)*Metric(3,6)*Metric(5,7) + P(2,3)*Metric(1,4)*Metric(3,6)*Metric(5,7) - (P(2,5)*Metric(1,4)*Metric(3,6)*Metric(5,7))/2. - (P(2,7)*Metric(1,4)*Metric(3,6)*Metric(5,7))/2. + P(1,3)*Metric(2,4)*Metric(3,6)*Metric(5,7) - (P(1,5)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. - (P(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. + 2*P(3,4)*Metric(1,2)*Metric(4,6)*Metric(5,7) - P(3,5)*Metric(1,2)*Metric(4,6)*Metric(5,7) - P(3,7)*Metric(1,2)*Metric(4,6)*Metric(5,7) + P(2,4)*Metric(1,3)*Metric(4,6)*Metric(5,7) - (P(2,5)*Metric(1,3)*Metric(4,6)*Metric(5,7))/2. - (P(2,7)*Metric(1,3)*Metric(4,6)*Metric(5,7))/2. + P(1,4)*Metric(2,3)*Metric(4,6)*Metric(5,7) - (P(1,5)*Metric(2,3)*Metric(4,6)*Metric(5,7))/2. - (P(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,7))/2. + P(5,1)*Metric(1,4)*Metric(2,3)*Metric(6,7) + P(5,2)*Metric(1,4)*Metric(2,3)*Metric(6,7) - P(5,3)*Metric(1,4)*Metric(2,3)*Metric(6,7) - P(5,4)*Metric(1,4)*Metric(2,3)*Metric(6,7) - P(4,1)*Metric(1,5)*Metric(2,3)*Metric(6,7) + (P(4,6)*Metric(1,5)*Metric(2,3)*Metric(6,7))/2. + (P(4,7)*Metric(1,5)*Metric(2,3)*Metric(6,7))/2. + P(5,1)*Metric(1,3)*Metric(2,4)*Metric(6,7) + P(5,2)*Metric(1,3)*Metric(2,4)*Metric(6,7) - P(5,3)*Metric(1,3)*Metric(2,4)*Metric(6,7) - P(5,4)*Metric(1,3)*Metric(2,4)*Metric(6,7) - P(3,1)*Metric(1,5)*Metric(2,4)*Metric(6,7) + (P(3,6)*Metric(1,5)*Metric(2,4)*Metric(6,7))/2. + (P(3,7)*Metric(1,5)*Metric(2,4)*Metric(6,7))/2. - P(4,2)*Metric(1,3)*Metric(2,5)*Metric(6,7) + (P(4,6)*Metric(1,3)*Metric(2,5)*Metric(6,7))/2. + (P(4,7)*Metric(1,3)*Metric(2,5)*Metric(6,7))/2. - P(3,2)*Metric(1,4)*Metric(2,5)*Metric(6,7) + (P(3,6)*Metric(1,4)*Metric(2,5)*Metric(6,7))/2. + (P(3,7)*Metric(1,4)*Metric(2,5)*Metric(6,7))/2. + 2*P(5,1)*Metric(1,2)*Metric(3,4)*Metric(6,7) + 2*P(5,2)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 2*P(5,3)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 2*P(5,4)*Metric(1,2)*Metric(3,4)*Metric(6,7) - 2*P(2,1)*Metric(1,5)*Metric(3,4)*Metric(6,7) + P(2,6)*Metric(1,5)*Metric(3,4)*Metric(6,7) + P(2,7)*Metric(1,5)*Metric(3,4)*Metric(6,7) - 2*P(1,2)*Metric(2,5)*Metric(3,4)*Metric(6,7) + P(1,6)*Metric(2,5)*Metric(3,4)*Metric(6,7) + P(1,7)*Metric(2,5)*Metric(3,4)*Metric(6,7) + 2*P(4,3)*Metric(1,2)*Metric(3,5)*Metric(6,7) - P(4,6)*Metric(1,2)*Metric(3,5)*Metric(6,7) - P(4,7)*Metric(1,2)*Metric(3,5)*Metric(6,7) + P(2,3)*Metric(1,4)*Metric(3,5)*Metric(6,7) - (P(2,6)*Metric(1,4)*Metric(3,5)*Metric(6,7))/2. - (P(2,7)*Metric(1,4)*Metric(3,5)*Metric(6,7))/2. + P(1,3)*Metric(2,4)*Metric(3,5)*Metric(6,7) - (P(1,6)*Metric(2,4)*Metric(3,5)*Metric(6,7))/2. - (P(1,7)*Metric(2,4)*Metric(3,5)*Metric(6,7))/2. + 2*P(3,4)*Metric(1,2)*Metric(4,5)*Metric(6,7) - P(3,6)*Metric(1,2)*Metric(4,5)*Metric(6,7) - P(3,7)*Metric(1,2)*Metric(4,5)*Metric(6,7) + P(2,4)*Metric(1,3)*Metric(4,5)*Metric(6,7) - (P(2,6)*Metric(1,3)*Metric(4,5)*Metric(6,7))/2. - (P(2,7)*Metric(1,3)*Metric(4,5)*Metric(6,7))/2. + P(1,4)*Metric(2,3)*Metric(4,5)*Metric(6,7) - (P(1,6)*Metric(2,3)*Metric(4,5)*Metric(6,7))/2. - (P(1,7)*Metric(2,3)*Metric(4,5)*Metric(6,7))/2.')

VVVVVVVV10 = Lorentz(name = 'VVVVVVVV10',
                     spins = [ 3, 3, 3, 3, 3, 3, 3, 3 ],
                     structure = 'Metric(1,8)*Metric(2,7)*Metric(3,6)*Metric(4,5) + Metric(1,7)*Metric(2,8)*Metric(3,6)*Metric(4,5) + Metric(1,8)*Metric(2,6)*Metric(3,7)*Metric(4,5) + Metric(1,6)*Metric(2,8)*Metric(3,7)*Metric(4,5) + Metric(1,7)*Metric(2,6)*Metric(3,8)*Metric(4,5) + Metric(1,6)*Metric(2,7)*Metric(3,8)*Metric(4,5) + Metric(1,8)*Metric(2,7)*Metric(3,5)*Metric(4,6) + Metric(1,7)*Metric(2,8)*Metric(3,5)*Metric(4,6) + Metric(1,8)*Metric(2,5)*Metric(3,7)*Metric(4,6) + Metric(1,5)*Metric(2,8)*Metric(3,7)*Metric(4,6) + Metric(1,7)*Metric(2,5)*Metric(3,8)*Metric(4,6) + Metric(1,5)*Metric(2,7)*Metric(3,8)*Metric(4,6) - (Metric(1,8)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. - (Metric(1,6)*Metric(2,8)*Metric(3,5)*Metric(4,7))/2. - (Metric(1,8)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. - (Metric(1,5)*Metric(2,8)*Metric(3,6)*Metric(4,7))/2. - (Metric(1,6)*Metric(2,5)*Metric(3,8)*Metric(4,7))/2. - (Metric(1,5)*Metric(2,6)*Metric(3,8)*Metric(4,7))/2. - (Metric(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,8))/2. - (Metric(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,8))/2. - (Metric(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,8))/2. - (Metric(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,8))/2. - (Metric(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,8))/2. - (Metric(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,8))/2. + Metric(1,8)*Metric(2,7)*Metric(3,4)*Metric(5,6) + Metric(1,7)*Metric(2,8)*Metric(3,4)*Metric(5,6) + Metric(1,8)*Metric(2,4)*Metric(3,7)*Metric(5,6) + Metric(1,4)*Metric(2,8)*Metric(3,7)*Metric(5,6) + Metric(1,7)*Metric(2,4)*Metric(3,8)*Metric(5,6) + Metric(1,4)*Metric(2,7)*Metric(3,8)*Metric(5,6) - Metric(1,8)*Metric(2,3)*Metric(4,7)*Metric(5,6) - Metric(1,3)*Metric(2,8)*Metric(4,7)*Metric(5,6) - Metric(1,2)*Metric(3,8)*Metric(4,7)*Metric(5,6) - Metric(1,7)*Metric(2,3)*Metric(4,8)*Metric(5,6) - Metric(1,3)*Metric(2,7)*Metric(4,8)*Metric(5,6) - Metric(1,2)*Metric(3,7)*Metric(4,8)*Metric(5,6) - (Metric(1,8)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. - (Metric(1,6)*Metric(2,8)*Metric(3,4)*Metric(5,7))/2. - (Metric(1,8)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. - (Metric(1,4)*Metric(2,8)*Metric(3,6)*Metric(5,7))/2. - (Metric(1,6)*Metric(2,4)*Metric(3,8)*Metric(5,7))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,8)*Metric(5,7))/2. - Metric(1,8)*Metric(2,3)*Metric(4,6)*Metric(5,7) - Metric(1,3)*Metric(2,8)*Metric(4,6)*Metric(5,7) - Metric(1,2)*Metric(3,8)*Metric(4,6)*Metric(5,7) + Metric(1,6)*Metric(2,3)*Metric(4,8)*Metric(5,7) + Metric(1,3)*Metric(2,6)*Metric(4,8)*Metric(5,7) + Metric(1,2)*Metric(3,6)*Metric(4,8)*Metric(5,7) - (Metric(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,8))/2. - (Metric(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,8))/2. - (Metric(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,8))/2. - (Metric(1,4)*Metric(2,7)*Metric(3,6)*Metric(5,8))/2. - (Metric(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,8))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,7)*Metric(5,8))/2. - Metric(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,8) - Metric(1,3)*Metric(2,7)*Metric(4,6)*Metric(5,8) - Metric(1,2)*Metric(3,7)*Metric(4,6)*Metric(5,8) + Metric(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,8) + Metric(1,3)*Metric(2,6)*Metric(4,7)*Metric(5,8) + Metric(1,2)*Metric(3,6)*Metric(4,7)*Metric(5,8) - (Metric(1,8)*Metric(2,5)*Metric(3,4)*Metric(6,7))/2. - (Metric(1,5)*Metric(2,8)*Metric(3,4)*Metric(6,7))/2. - (Metric(1,8)*Metric(2,4)*Metric(3,5)*Metric(6,7))/2. - (Metric(1,4)*Metric(2,8)*Metric(3,5)*Metric(6,7))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,8)*Metric(6,7))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,8)*Metric(6,7))/2. - Metric(1,8)*Metric(2,3)*Metric(4,5)*Metric(6,7) - Metric(1,3)*Metric(2,8)*Metric(4,5)*Metric(6,7) - Metric(1,2)*Metric(3,8)*Metric(4,5)*Metric(6,7) + Metric(1,5)*Metric(2,3)*Metric(4,8)*Metric(6,7) + Metric(1,3)*Metric(2,5)*Metric(4,8)*Metric(6,7) + Metric(1,2)*Metric(3,5)*Metric(4,8)*Metric(6,7) + Metric(1,4)*Metric(2,3)*Metric(5,8)*Metric(6,7) + Metric(1,3)*Metric(2,4)*Metric(5,8)*Metric(6,7) + Metric(1,2)*Metric(3,4)*Metric(5,8)*Metric(6,7) - (Metric(1,7)*Metric(2,5)*Metric(3,4)*Metric(6,8))/2. - (Metric(1,5)*Metric(2,7)*Metric(3,4)*Metric(6,8))/2. - (Metric(1,7)*Metric(2,4)*Metric(3,5)*Metric(6,8))/2. - (Metric(1,4)*Metric(2,7)*Metric(3,5)*Metric(6,8))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,7)*Metric(6,8))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,7)*Metric(6,8))/2. - Metric(1,7)*Metric(2,3)*Metric(4,5)*Metric(6,8) - Metric(1,3)*Metric(2,7)*Metric(4,5)*Metric(6,8) - Metric(1,2)*Metric(3,7)*Metric(4,5)*Metric(6,8) + Metric(1,5)*Metric(2,3)*Metric(4,7)*Metric(6,8) + Metric(1,3)*Metric(2,5)*Metric(4,7)*Metric(6,8) + Metric(1,2)*Metric(3,5)*Metric(4,7)*Metric(6,8) + Metric(1,4)*Metric(2,3)*Metric(5,7)*Metric(6,8) + Metric(1,3)*Metric(2,4)*Metric(5,7)*Metric(6,8) + Metric(1,2)*Metric(3,4)*Metric(5,7)*Metric(6,8)')

VVVVVVVV11 = Lorentz(name = 'VVVVVVVV11',
                     spins = [ 3, 3, 3, 3, 3, 3, 3, 3 ],
                     structure = 'Metric(1,8)*Metric(2,7)*Metric(3,6)*Metric(4,5) + Metric(1,7)*Metric(2,8)*Metric(3,6)*Metric(4,5) + Metric(1,8)*Metric(2,6)*Metric(3,7)*Metric(4,5) + Metric(1,6)*Metric(2,8)*Metric(3,7)*Metric(4,5) + Metric(1,7)*Metric(2,6)*Metric(3,8)*Metric(4,5) + Metric(1,6)*Metric(2,7)*Metric(3,8)*Metric(4,5) + Metric(1,8)*Metric(2,7)*Metric(3,5)*Metric(4,6) + Metric(1,7)*Metric(2,8)*Metric(3,5)*Metric(4,6) - (Metric(1,8)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. - (Metric(1,5)*Metric(2,8)*Metric(3,7)*Metric(4,6))/2. - (Metric(1,7)*Metric(2,5)*Metric(3,8)*Metric(4,6))/2. - (Metric(1,5)*Metric(2,7)*Metric(3,8)*Metric(4,6))/2. + Metric(1,8)*Metric(2,6)*Metric(3,5)*Metric(4,7) + Metric(1,6)*Metric(2,8)*Metric(3,5)*Metric(4,7) - (Metric(1,8)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. - (Metric(1,5)*Metric(2,8)*Metric(3,6)*Metric(4,7))/2. - (Metric(1,6)*Metric(2,5)*Metric(3,8)*Metric(4,7))/2. - (Metric(1,5)*Metric(2,6)*Metric(3,8)*Metric(4,7))/2. + Metric(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,8) + Metric(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,8) - (Metric(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,8))/2. - (Metric(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,8))/2. - (Metric(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,8))/2. - (Metric(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,8))/2. + Metric(1,8)*Metric(2,7)*Metric(3,4)*Metric(5,6) + Metric(1,7)*Metric(2,8)*Metric(3,4)*Metric(5,6) - (Metric(1,8)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. - (Metric(1,4)*Metric(2,8)*Metric(3,7)*Metric(5,6))/2. - (Metric(1,7)*Metric(2,4)*Metric(3,8)*Metric(5,6))/2. - (Metric(1,4)*Metric(2,7)*Metric(3,8)*Metric(5,6))/2. - (Metric(1,8)*Metric(2,3)*Metric(4,7)*Metric(5,6))/2. - (Metric(1,3)*Metric(2,8)*Metric(4,7)*Metric(5,6))/2. - (Metric(1,7)*Metric(2,3)*Metric(4,8)*Metric(5,6))/2. - (Metric(1,3)*Metric(2,7)*Metric(4,8)*Metric(5,6))/2. + Metric(1,8)*Metric(2,6)*Metric(3,4)*Metric(5,7) + Metric(1,6)*Metric(2,8)*Metric(3,4)*Metric(5,7) - (Metric(1,8)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. - (Metric(1,4)*Metric(2,8)*Metric(3,6)*Metric(5,7))/2. - (Metric(1,6)*Metric(2,4)*Metric(3,8)*Metric(5,7))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,8)*Metric(5,7))/2. - (Metric(1,8)*Metric(2,3)*Metric(4,6)*Metric(5,7))/2. - (Metric(1,3)*Metric(2,8)*Metric(4,6)*Metric(5,7))/2. - (Metric(1,6)*Metric(2,3)*Metric(4,8)*Metric(5,7))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,8)*Metric(5,7))/2. + Metric(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,8) + Metric(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,8) - (Metric(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,8))/2. - (Metric(1,4)*Metric(2,7)*Metric(3,6)*Metric(5,8))/2. - (Metric(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,8))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,7)*Metric(5,8))/2. - (Metric(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,8))/2. - (Metric(1,3)*Metric(2,7)*Metric(4,6)*Metric(5,8))/2. - (Metric(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,8))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,7)*Metric(5,8))/2. - Metric(1,8)*Metric(2,5)*Metric(3,4)*Metric(6,7) - Metric(1,5)*Metric(2,8)*Metric(3,4)*Metric(6,7) - Metric(1,8)*Metric(2,4)*Metric(3,5)*Metric(6,7) - Metric(1,4)*Metric(2,8)*Metric(3,5)*Metric(6,7) + Metric(1,5)*Metric(2,4)*Metric(3,8)*Metric(6,7) + Metric(1,4)*Metric(2,5)*Metric(3,8)*Metric(6,7) - Metric(1,8)*Metric(2,3)*Metric(4,5)*Metric(6,7) - Metric(1,3)*Metric(2,8)*Metric(4,5)*Metric(6,7) + Metric(1,5)*Metric(2,3)*Metric(4,8)*Metric(6,7) + Metric(1,3)*Metric(2,5)*Metric(4,8)*Metric(6,7) + Metric(1,4)*Metric(2,3)*Metric(5,8)*Metric(6,7) + Metric(1,3)*Metric(2,4)*Metric(5,8)*Metric(6,7) - Metric(1,7)*Metric(2,5)*Metric(3,4)*Metric(6,8) - Metric(1,5)*Metric(2,7)*Metric(3,4)*Metric(6,8) - Metric(1,7)*Metric(2,4)*Metric(3,5)*Metric(6,8) - Metric(1,4)*Metric(2,7)*Metric(3,5)*Metric(6,8) + Metric(1,5)*Metric(2,4)*Metric(3,7)*Metric(6,8) + Metric(1,4)*Metric(2,5)*Metric(3,7)*Metric(6,8) - Metric(1,7)*Metric(2,3)*Metric(4,5)*Metric(6,8) - Metric(1,3)*Metric(2,7)*Metric(4,5)*Metric(6,8) + Metric(1,5)*Metric(2,3)*Metric(4,7)*Metric(6,8) + Metric(1,3)*Metric(2,5)*Metric(4,7)*Metric(6,8) + Metric(1,4)*Metric(2,3)*Metric(5,7)*Metric(6,8) + Metric(1,3)*Metric(2,4)*Metric(5,7)*Metric(6,8) - Metric(1,6)*Metric(2,5)*Metric(3,4)*Metric(7,8) - Metric(1,5)*Metric(2,6)*Metric(3,4)*Metric(7,8) - Metric(1,6)*Metric(2,4)*Metric(3,5)*Metric(7,8) - Metric(1,4)*Metric(2,6)*Metric(3,5)*Metric(7,8) + Metric(1,5)*Metric(2,4)*Metric(3,6)*Metric(7,8) + Metric(1,4)*Metric(2,5)*Metric(3,6)*Metric(7,8) - Metric(1,6)*Metric(2,3)*Metric(4,5)*Metric(7,8) - Metric(1,3)*Metric(2,6)*Metric(4,5)*Metric(7,8) + Metric(1,5)*Metric(2,3)*Metric(4,6)*Metric(7,8) + Metric(1,3)*Metric(2,5)*Metric(4,6)*Metric(7,8) + Metric(1,4)*Metric(2,3)*Metric(5,6)*Metric(7,8) + Metric(1,3)*Metric(2,4)*Metric(5,6)*Metric(7,8)')

VVVVVVVV12 = Lorentz(name = 'VVVVVVVV12',
                     spins = [ 3, 3, 3, 3, 3, 3, 3, 3 ],
                     structure = 'Metric(1,8)*Metric(2,7)*Metric(3,6)*Metric(4,5) + Metric(1,7)*Metric(2,8)*Metric(3,6)*Metric(4,5) + Metric(1,8)*Metric(2,6)*Metric(3,7)*Metric(4,5) + Metric(1,6)*Metric(2,8)*Metric(3,7)*Metric(4,5) + Metric(1,7)*Metric(2,6)*Metric(3,8)*Metric(4,5) + Metric(1,6)*Metric(2,7)*Metric(3,8)*Metric(4,5) + (Metric(1,8)*Metric(2,7)*Metric(3,5)*Metric(4,6))/2. + (Metric(1,7)*Metric(2,8)*Metric(3,5)*Metric(4,6))/2. + (Metric(1,8)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. + (Metric(1,5)*Metric(2,8)*Metric(3,7)*Metric(4,6))/2. + (Metric(1,7)*Metric(2,5)*Metric(3,8)*Metric(4,6))/2. + (Metric(1,5)*Metric(2,7)*Metric(3,8)*Metric(4,6))/2. + (Metric(1,8)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (Metric(1,6)*Metric(2,8)*Metric(3,5)*Metric(4,7))/2. + (Metric(1,8)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. + (Metric(1,5)*Metric(2,8)*Metric(3,6)*Metric(4,7))/2. + (Metric(1,6)*Metric(2,5)*Metric(3,8)*Metric(4,7))/2. + (Metric(1,5)*Metric(2,6)*Metric(3,8)*Metric(4,7))/2. - Metric(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,8) - Metric(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,8) - Metric(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,8) - Metric(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,8) - Metric(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,8) - Metric(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,8) + (Metric(1,8)*Metric(2,7)*Metric(3,4)*Metric(5,6))/2. + (Metric(1,7)*Metric(2,8)*Metric(3,4)*Metric(5,6))/2. + (Metric(1,8)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. + (Metric(1,4)*Metric(2,8)*Metric(3,7)*Metric(5,6))/2. + (Metric(1,7)*Metric(2,4)*Metric(3,8)*Metric(5,6))/2. + (Metric(1,4)*Metric(2,7)*Metric(3,8)*Metric(5,6))/2. - 2*Metric(1,8)*Metric(2,3)*Metric(4,7)*Metric(5,6) - 2*Metric(1,3)*Metric(2,8)*Metric(4,7)*Metric(5,6) - 2*Metric(1,2)*Metric(3,8)*Metric(4,7)*Metric(5,6) + (Metric(1,7)*Metric(2,3)*Metric(4,8)*Metric(5,6))/2. + (Metric(1,3)*Metric(2,7)*Metric(4,8)*Metric(5,6))/2. + (Metric(1,2)*Metric(3,7)*Metric(4,8)*Metric(5,6))/2. + (Metric(1,8)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. + (Metric(1,6)*Metric(2,8)*Metric(3,4)*Metric(5,7))/2. + (Metric(1,8)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. + (Metric(1,4)*Metric(2,8)*Metric(3,6)*Metric(5,7))/2. + (Metric(1,6)*Metric(2,4)*Metric(3,8)*Metric(5,7))/2. + (Metric(1,4)*Metric(2,6)*Metric(3,8)*Metric(5,7))/2. - 2*Metric(1,8)*Metric(2,3)*Metric(4,6)*Metric(5,7) - 2*Metric(1,3)*Metric(2,8)*Metric(4,6)*Metric(5,7) - 2*Metric(1,2)*Metric(3,8)*Metric(4,6)*Metric(5,7) + (Metric(1,6)*Metric(2,3)*Metric(4,8)*Metric(5,7))/2. + (Metric(1,3)*Metric(2,6)*Metric(4,8)*Metric(5,7))/2. + (Metric(1,2)*Metric(3,6)*Metric(4,8)*Metric(5,7))/2. - Metric(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,8) - Metric(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,8) - Metric(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,8) - Metric(1,4)*Metric(2,7)*Metric(3,6)*Metric(5,8) - Metric(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,8) - Metric(1,4)*Metric(2,6)*Metric(3,7)*Metric(5,8) + (Metric(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,8))/2. + (Metric(1,3)*Metric(2,7)*Metric(4,6)*Metric(5,8))/2. + (Metric(1,2)*Metric(3,7)*Metric(4,6)*Metric(5,8))/2. + (Metric(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,8))/2. + (Metric(1,3)*Metric(2,6)*Metric(4,7)*Metric(5,8))/2. + (Metric(1,2)*Metric(3,6)*Metric(4,7)*Metric(5,8))/2. + Metric(1,8)*Metric(2,5)*Metric(3,4)*Metric(6,7) + Metric(1,5)*Metric(2,8)*Metric(3,4)*Metric(6,7) + Metric(1,8)*Metric(2,4)*Metric(3,5)*Metric(6,7) + Metric(1,4)*Metric(2,8)*Metric(3,5)*Metric(6,7) + Metric(1,5)*Metric(2,4)*Metric(3,8)*Metric(6,7) + Metric(1,4)*Metric(2,5)*Metric(3,8)*Metric(6,7) - 4*Metric(1,8)*Metric(2,3)*Metric(4,5)*Metric(6,7) - 4*Metric(1,3)*Metric(2,8)*Metric(4,5)*Metric(6,7) - 4*Metric(1,2)*Metric(3,8)*Metric(4,5)*Metric(6,7) + Metric(1,5)*Metric(2,3)*Metric(4,8)*Metric(6,7) + Metric(1,3)*Metric(2,5)*Metric(4,8)*Metric(6,7) + Metric(1,2)*Metric(3,5)*Metric(4,8)*Metric(6,7) + Metric(1,4)*Metric(2,3)*Metric(5,8)*Metric(6,7) + Metric(1,3)*Metric(2,4)*Metric(5,8)*Metric(6,7) + Metric(1,2)*Metric(3,4)*Metric(5,8)*Metric(6,7) - Metric(1,7)*Metric(2,5)*Metric(3,4)*Metric(6,8) - Metric(1,5)*Metric(2,7)*Metric(3,4)*Metric(6,8) - Metric(1,7)*Metric(2,4)*Metric(3,5)*Metric(6,8) - Metric(1,4)*Metric(2,7)*Metric(3,5)*Metric(6,8) - Metric(1,5)*Metric(2,4)*Metric(3,7)*Metric(6,8) - Metric(1,4)*Metric(2,5)*Metric(3,7)*Metric(6,8) + Metric(1,7)*Metric(2,3)*Metric(4,5)*Metric(6,8) + Metric(1,3)*Metric(2,7)*Metric(4,5)*Metric(6,8) + Metric(1,2)*Metric(3,7)*Metric(4,5)*Metric(6,8) + (Metric(1,5)*Metric(2,3)*Metric(4,7)*Metric(6,8))/2. + (Metric(1,3)*Metric(2,5)*Metric(4,7)*Metric(6,8))/2. + (Metric(1,2)*Metric(3,5)*Metric(4,7)*Metric(6,8))/2. + (Metric(1,4)*Metric(2,3)*Metric(5,7)*Metric(6,8))/2. + (Metric(1,3)*Metric(2,4)*Metric(5,7)*Metric(6,8))/2. + (Metric(1,2)*Metric(3,4)*Metric(5,7)*Metric(6,8))/2. - Metric(1,6)*Metric(2,5)*Metric(3,4)*Metric(7,8) - Metric(1,5)*Metric(2,6)*Metric(3,4)*Metric(7,8) - Metric(1,6)*Metric(2,4)*Metric(3,5)*Metric(7,8) - Metric(1,4)*Metric(2,6)*Metric(3,5)*Metric(7,8) - Metric(1,5)*Metric(2,4)*Metric(3,6)*Metric(7,8) - Metric(1,4)*Metric(2,5)*Metric(3,6)*Metric(7,8) + Metric(1,6)*Metric(2,3)*Metric(4,5)*Metric(7,8) + Metric(1,3)*Metric(2,6)*Metric(4,5)*Metric(7,8) + Metric(1,2)*Metric(3,6)*Metric(4,5)*Metric(7,8) + (Metric(1,5)*Metric(2,3)*Metric(4,6)*Metric(7,8))/2. + (Metric(1,3)*Metric(2,5)*Metric(4,6)*Metric(7,8))/2. + (Metric(1,2)*Metric(3,5)*Metric(4,6)*Metric(7,8))/2. + (Metric(1,4)*Metric(2,3)*Metric(5,6)*Metric(7,8))/2. + (Metric(1,3)*Metric(2,4)*Metric(5,6)*Metric(7,8))/2. + (Metric(1,2)*Metric(3,4)*Metric(5,6)*Metric(7,8))/2.')

VVVVVVVV13 = Lorentz(name = 'VVVVVVVV13',
                     spins = [ 3, 3, 3, 3, 3, 3, 3, 3 ],
                     structure = 'Metric(1,8)*Metric(2,7)*Metric(3,6)*Metric(4,5) + Metric(1,7)*Metric(2,8)*Metric(3,6)*Metric(4,5) + Metric(1,8)*Metric(2,6)*Metric(3,7)*Metric(4,5) + Metric(1,6)*Metric(2,8)*Metric(3,7)*Metric(4,5) + Metric(1,7)*Metric(2,6)*Metric(3,8)*Metric(4,5) + Metric(1,6)*Metric(2,7)*Metric(3,8)*Metric(4,5) + (Metric(1,8)*Metric(2,7)*Metric(3,5)*Metric(4,6))/2. + (Metric(1,7)*Metric(2,8)*Metric(3,5)*Metric(4,6))/2. + (Metric(1,8)*Metric(2,5)*Metric(3,7)*Metric(4,6))/2. - Metric(1,5)*Metric(2,8)*Metric(3,7)*Metric(4,6) + (Metric(1,7)*Metric(2,5)*Metric(3,8)*Metric(4,6))/2. - Metric(1,5)*Metric(2,7)*Metric(3,8)*Metric(4,6) + (Metric(1,8)*Metric(2,6)*Metric(3,5)*Metric(4,7))/2. + (Metric(1,6)*Metric(2,8)*Metric(3,5)*Metric(4,7))/2. + (Metric(1,8)*Metric(2,5)*Metric(3,6)*Metric(4,7))/2. - Metric(1,5)*Metric(2,8)*Metric(3,6)*Metric(4,7) + (Metric(1,6)*Metric(2,5)*Metric(3,8)*Metric(4,7))/2. - Metric(1,5)*Metric(2,6)*Metric(3,8)*Metric(4,7) + (Metric(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,8))/2. + (Metric(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,8))/2. + (Metric(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,8))/2. - Metric(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,8) + (Metric(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,8))/2. - Metric(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,8) + (Metric(1,8)*Metric(2,7)*Metric(3,4)*Metric(5,6))/2. + (Metric(1,7)*Metric(2,8)*Metric(3,4)*Metric(5,6))/2. + (Metric(1,8)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. - Metric(1,4)*Metric(2,8)*Metric(3,7)*Metric(5,6) + (Metric(1,7)*Metric(2,4)*Metric(3,8)*Metric(5,6))/2. - Metric(1,4)*Metric(2,7)*Metric(3,8)*Metric(5,6) + Metric(1,8)*Metric(2,3)*Metric(4,7)*Metric(5,6) - Metric(1,3)*Metric(2,8)*Metric(4,7)*Metric(5,6) - Metric(1,2)*Metric(3,8)*Metric(4,7)*Metric(5,6) + Metric(1,7)*Metric(2,3)*Metric(4,8)*Metric(5,6) - Metric(1,3)*Metric(2,7)*Metric(4,8)*Metric(5,6) - Metric(1,2)*Metric(3,7)*Metric(4,8)*Metric(5,6) + (Metric(1,8)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. + (Metric(1,6)*Metric(2,8)*Metric(3,4)*Metric(5,7))/2. + (Metric(1,8)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. - Metric(1,4)*Metric(2,8)*Metric(3,6)*Metric(5,7) + (Metric(1,6)*Metric(2,4)*Metric(3,8)*Metric(5,7))/2. - Metric(1,4)*Metric(2,6)*Metric(3,8)*Metric(5,7) + Metric(1,8)*Metric(2,3)*Metric(4,6)*Metric(5,7) - Metric(1,3)*Metric(2,8)*Metric(4,6)*Metric(5,7) - Metric(1,2)*Metric(3,8)*Metric(4,6)*Metric(5,7) + Metric(1,6)*Metric(2,3)*Metric(4,8)*Metric(5,7) - Metric(1,3)*Metric(2,6)*Metric(4,8)*Metric(5,7) - Metric(1,2)*Metric(3,6)*Metric(4,8)*Metric(5,7) + (Metric(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,8))/2. + (Metric(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,8))/2. + (Metric(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,8))/2. - Metric(1,4)*Metric(2,7)*Metric(3,6)*Metric(5,8) + (Metric(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,8))/2. - Metric(1,4)*Metric(2,6)*Metric(3,7)*Metric(5,8) + Metric(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,8) - Metric(1,3)*Metric(2,7)*Metric(4,6)*Metric(5,8) - Metric(1,2)*Metric(3,7)*Metric(4,6)*Metric(5,8) + Metric(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,8) - Metric(1,3)*Metric(2,6)*Metric(4,7)*Metric(5,8) - Metric(1,2)*Metric(3,6)*Metric(4,7)*Metric(5,8) - 2*Metric(1,8)*Metric(2,5)*Metric(3,4)*Metric(6,7) + (Metric(1,5)*Metric(2,8)*Metric(3,4)*Metric(6,7))/2. - 2*Metric(1,8)*Metric(2,4)*Metric(3,5)*Metric(6,7) + (Metric(1,4)*Metric(2,8)*Metric(3,5)*Metric(6,7))/2. + (Metric(1,5)*Metric(2,4)*Metric(3,8)*Metric(6,7))/2. + (Metric(1,4)*Metric(2,5)*Metric(3,8)*Metric(6,7))/2. - 4*Metric(1,8)*Metric(2,3)*Metric(4,5)*Metric(6,7) + Metric(1,3)*Metric(2,8)*Metric(4,5)*Metric(6,7) + Metric(1,2)*Metric(3,8)*Metric(4,5)*Metric(6,7) + Metric(1,5)*Metric(2,3)*Metric(4,8)*Metric(6,7) + (Metric(1,3)*Metric(2,5)*Metric(4,8)*Metric(6,7))/2. + (Metric(1,2)*Metric(3,5)*Metric(4,8)*Metric(6,7))/2. + Metric(1,4)*Metric(2,3)*Metric(5,8)*Metric(6,7) + (Metric(1,3)*Metric(2,4)*Metric(5,8)*Metric(6,7))/2. + (Metric(1,2)*Metric(3,4)*Metric(5,8)*Metric(6,7))/2. - 2*Metric(1,7)*Metric(2,5)*Metric(3,4)*Metric(6,8) + (Metric(1,5)*Metric(2,7)*Metric(3,4)*Metric(6,8))/2. - 2*Metric(1,7)*Metric(2,4)*Metric(3,5)*Metric(6,8) + (Metric(1,4)*Metric(2,7)*Metric(3,5)*Metric(6,8))/2. + (Metric(1,5)*Metric(2,4)*Metric(3,7)*Metric(6,8))/2. + (Metric(1,4)*Metric(2,5)*Metric(3,7)*Metric(6,8))/2. - 4*Metric(1,7)*Metric(2,3)*Metric(4,5)*Metric(6,8) + Metric(1,3)*Metric(2,7)*Metric(4,5)*Metric(6,8) + Metric(1,2)*Metric(3,7)*Metric(4,5)*Metric(6,8) + Metric(1,5)*Metric(2,3)*Metric(4,7)*Metric(6,8) + (Metric(1,3)*Metric(2,5)*Metric(4,7)*Metric(6,8))/2. + (Metric(1,2)*Metric(3,5)*Metric(4,7)*Metric(6,8))/2. + Metric(1,4)*Metric(2,3)*Metric(5,7)*Metric(6,8) + (Metric(1,3)*Metric(2,4)*Metric(5,7)*Metric(6,8))/2. + (Metric(1,2)*Metric(3,4)*Metric(5,7)*Metric(6,8))/2. - 2*Metric(1,6)*Metric(2,5)*Metric(3,4)*Metric(7,8) + (Metric(1,5)*Metric(2,6)*Metric(3,4)*Metric(7,8))/2. - 2*Metric(1,6)*Metric(2,4)*Metric(3,5)*Metric(7,8) + (Metric(1,4)*Metric(2,6)*Metric(3,5)*Metric(7,8))/2. + (Metric(1,5)*Metric(2,4)*Metric(3,6)*Metric(7,8))/2. + (Metric(1,4)*Metric(2,5)*Metric(3,6)*Metric(7,8))/2. - 4*Metric(1,6)*Metric(2,3)*Metric(4,5)*Metric(7,8) + Metric(1,3)*Metric(2,6)*Metric(4,5)*Metric(7,8) + Metric(1,2)*Metric(3,6)*Metric(4,5)*Metric(7,8) + Metric(1,5)*Metric(2,3)*Metric(4,6)*Metric(7,8) + (Metric(1,3)*Metric(2,5)*Metric(4,6)*Metric(7,8))/2. + (Metric(1,2)*Metric(3,5)*Metric(4,6)*Metric(7,8))/2. + Metric(1,4)*Metric(2,3)*Metric(5,6)*Metric(7,8) + (Metric(1,3)*Metric(2,4)*Metric(5,6)*Metric(7,8))/2. + (Metric(1,2)*Metric(3,4)*Metric(5,6)*Metric(7,8))/2.')

VVVVVVVV14 = Lorentz(name = 'VVVVVVVV14',
                     spins = [ 3, 3, 3, 3, 3, 3, 3, 3 ],
                     structure = 'Metric(1,8)*Metric(2,7)*Metric(3,6)*Metric(4,5) + Metric(1,7)*Metric(2,8)*Metric(3,6)*Metric(4,5) - (Metric(1,8)*Metric(2,6)*Metric(3,7)*Metric(4,5))/4. - (Metric(1,6)*Metric(2,8)*Metric(3,7)*Metric(4,5))/4. - (Metric(1,7)*Metric(2,6)*Metric(3,8)*Metric(4,5))/4. - (Metric(1,6)*Metric(2,7)*Metric(3,8)*Metric(4,5))/4. + Metric(1,8)*Metric(2,7)*Metric(3,5)*Metric(4,6) + Metric(1,7)*Metric(2,8)*Metric(3,5)*Metric(4,6) - (Metric(1,8)*Metric(2,5)*Metric(3,7)*Metric(4,6))/4. - (Metric(1,5)*Metric(2,8)*Metric(3,7)*Metric(4,6))/4. - (Metric(1,7)*Metric(2,5)*Metric(3,8)*Metric(4,6))/4. - (Metric(1,5)*Metric(2,7)*Metric(3,8)*Metric(4,6))/4. - (Metric(1,8)*Metric(2,6)*Metric(3,5)*Metric(4,7))/4. - (Metric(1,6)*Metric(2,8)*Metric(3,5)*Metric(4,7))/4. - (Metric(1,8)*Metric(2,5)*Metric(3,6)*Metric(4,7))/4. - (Metric(1,5)*Metric(2,8)*Metric(3,6)*Metric(4,7))/4. + (Metric(1,6)*Metric(2,5)*Metric(3,8)*Metric(4,7))/2. + (Metric(1,5)*Metric(2,6)*Metric(3,8)*Metric(4,7))/2. - (Metric(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,8))/4. - (Metric(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,8))/4. - (Metric(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,8))/4. - (Metric(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,8))/4. + (Metric(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,8))/2. + (Metric(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,8))/2. + 2*Metric(1,8)*Metric(2,7)*Metric(3,4)*Metric(5,6) + 2*Metric(1,7)*Metric(2,8)*Metric(3,4)*Metric(5,6) - (Metric(1,8)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. - (Metric(1,4)*Metric(2,8)*Metric(3,7)*Metric(5,6))/2. - (Metric(1,7)*Metric(2,4)*Metric(3,8)*Metric(5,6))/2. - (Metric(1,4)*Metric(2,7)*Metric(3,8)*Metric(5,6))/2. - (Metric(1,8)*Metric(2,3)*Metric(4,7)*Metric(5,6))/2. - (Metric(1,3)*Metric(2,8)*Metric(4,7)*Metric(5,6))/2. - (Metric(1,2)*Metric(3,8)*Metric(4,7)*Metric(5,6))/2. - (Metric(1,7)*Metric(2,3)*Metric(4,8)*Metric(5,6))/2. - (Metric(1,3)*Metric(2,7)*Metric(4,8)*Metric(5,6))/2. - (Metric(1,2)*Metric(3,7)*Metric(4,8)*Metric(5,6))/2. - (Metric(1,8)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. - (Metric(1,6)*Metric(2,8)*Metric(3,4)*Metric(5,7))/2. - (Metric(1,8)*Metric(2,4)*Metric(3,6)*Metric(5,7))/4. - (Metric(1,4)*Metric(2,8)*Metric(3,6)*Metric(5,7))/4. + (Metric(1,6)*Metric(2,4)*Metric(3,8)*Metric(5,7))/2. + (Metric(1,4)*Metric(2,6)*Metric(3,8)*Metric(5,7))/2. - (Metric(1,8)*Metric(2,3)*Metric(4,6)*Metric(5,7))/4. - (Metric(1,3)*Metric(2,8)*Metric(4,6)*Metric(5,7))/4. - (Metric(1,2)*Metric(3,8)*Metric(4,6)*Metric(5,7))/4. + (Metric(1,6)*Metric(2,3)*Metric(4,8)*Metric(5,7))/2. + (Metric(1,3)*Metric(2,6)*Metric(4,8)*Metric(5,7))/2. - (Metric(1,2)*Metric(3,6)*Metric(4,8)*Metric(5,7))/4. - (Metric(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,8))/2. - (Metric(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,8))/2. - (Metric(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,8))/4. - (Metric(1,4)*Metric(2,7)*Metric(3,6)*Metric(5,8))/4. + (Metric(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,8))/2. + (Metric(1,4)*Metric(2,6)*Metric(3,7)*Metric(5,8))/2. - (Metric(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,8))/4. - (Metric(1,3)*Metric(2,7)*Metric(4,6)*Metric(5,8))/4. - (Metric(1,2)*Metric(3,7)*Metric(4,6)*Metric(5,8))/4. + (Metric(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,8))/2. + (Metric(1,3)*Metric(2,6)*Metric(4,7)*Metric(5,8))/2. - (Metric(1,2)*Metric(3,6)*Metric(4,7)*Metric(5,8))/4. - (Metric(1,8)*Metric(2,5)*Metric(3,4)*Metric(6,7))/2. - (Metric(1,5)*Metric(2,8)*Metric(3,4)*Metric(6,7))/2. - (Metric(1,8)*Metric(2,4)*Metric(3,5)*Metric(6,7))/4. - (Metric(1,4)*Metric(2,8)*Metric(3,5)*Metric(6,7))/4. + (Metric(1,5)*Metric(2,4)*Metric(3,8)*Metric(6,7))/2. + (Metric(1,4)*Metric(2,5)*Metric(3,8)*Metric(6,7))/2. - (Metric(1,8)*Metric(2,3)*Metric(4,5)*Metric(6,7))/4. - (Metric(1,3)*Metric(2,8)*Metric(4,5)*Metric(6,7))/4. - (Metric(1,2)*Metric(3,8)*Metric(4,5)*Metric(6,7))/4. + (Metric(1,5)*Metric(2,3)*Metric(4,8)*Metric(6,7))/2. + (Metric(1,3)*Metric(2,5)*Metric(4,8)*Metric(6,7))/2. - (Metric(1,2)*Metric(3,5)*Metric(4,8)*Metric(6,7))/4. + (Metric(1,4)*Metric(2,3)*Metric(5,8)*Metric(6,7))/2. + (Metric(1,3)*Metric(2,4)*Metric(5,8)*Metric(6,7))/2. - (Metric(1,2)*Metric(3,4)*Metric(5,8)*Metric(6,7))/2. - (Metric(1,7)*Metric(2,5)*Metric(3,4)*Metric(6,8))/2. - (Metric(1,5)*Metric(2,7)*Metric(3,4)*Metric(6,8))/2. - (Metric(1,7)*Metric(2,4)*Metric(3,5)*Metric(6,8))/4. - (Metric(1,4)*Metric(2,7)*Metric(3,5)*Metric(6,8))/4. + (Metric(1,5)*Metric(2,4)*Metric(3,7)*Metric(6,8))/2. + (Metric(1,4)*Metric(2,5)*Metric(3,7)*Metric(6,8))/2. - (Metric(1,7)*Metric(2,3)*Metric(4,5)*Metric(6,8))/4. - (Metric(1,3)*Metric(2,7)*Metric(4,5)*Metric(6,8))/4. - (Metric(1,2)*Metric(3,7)*Metric(4,5)*Metric(6,8))/4. + (Metric(1,5)*Metric(2,3)*Metric(4,7)*Metric(6,8))/2. + (Metric(1,3)*Metric(2,5)*Metric(4,7)*Metric(6,8))/2. - (Metric(1,2)*Metric(3,5)*Metric(4,7)*Metric(6,8))/4. + (Metric(1,4)*Metric(2,3)*Metric(5,7)*Metric(6,8))/2. + (Metric(1,3)*Metric(2,4)*Metric(5,7)*Metric(6,8))/2. - (Metric(1,2)*Metric(3,4)*Metric(5,7)*Metric(6,8))/2. - (Metric(1,6)*Metric(2,5)*Metric(3,4)*Metric(7,8))/2. - (Metric(1,5)*Metric(2,6)*Metric(3,4)*Metric(7,8))/2. - (Metric(1,6)*Metric(2,4)*Metric(3,5)*Metric(7,8))/4. - (Metric(1,4)*Metric(2,6)*Metric(3,5)*Metric(7,8))/4. - (Metric(1,5)*Metric(2,4)*Metric(3,6)*Metric(7,8))/4. - (Metric(1,4)*Metric(2,5)*Metric(3,6)*Metric(7,8))/4. - (Metric(1,6)*Metric(2,3)*Metric(4,5)*Metric(7,8))/4. - (Metric(1,3)*Metric(2,6)*Metric(4,5)*Metric(7,8))/4. + Metric(1,2)*Metric(3,6)*Metric(4,5)*Metric(7,8) - (Metric(1,5)*Metric(2,3)*Metric(4,6)*Metric(7,8))/4. - (Metric(1,3)*Metric(2,5)*Metric(4,6)*Metric(7,8))/4. + Metric(1,2)*Metric(3,5)*Metric(4,6)*Metric(7,8) - (Metric(1,4)*Metric(2,3)*Metric(5,6)*Metric(7,8))/2. - (Metric(1,3)*Metric(2,4)*Metric(5,6)*Metric(7,8))/2. + 2*Metric(1,2)*Metric(3,4)*Metric(5,6)*Metric(7,8)')

VVVVVVVV15 = Lorentz(name = 'VVVVVVVV15',
                     spins = [ 3, 3, 3, 3, 3, 3, 3, 3 ],
                     structure = 'Metric(1,7)*Metric(2,8)*Metric(3,6)*Metric(4,5) + Metric(1,6)*Metric(2,8)*Metric(3,7)*Metric(4,5) + Metric(1,7)*Metric(2,6)*Metric(3,8)*Metric(4,5) + Metric(1,6)*Metric(2,7)*Metric(3,8)*Metric(4,5) + Metric(1,7)*Metric(2,8)*Metric(3,5)*Metric(4,6) + Metric(1,5)*Metric(2,8)*Metric(3,7)*Metric(4,6) + Metric(1,7)*Metric(2,5)*Metric(3,8)*Metric(4,6) + Metric(1,5)*Metric(2,7)*Metric(3,8)*Metric(4,6) + Metric(1,6)*Metric(2,8)*Metric(3,5)*Metric(4,7) + Metric(1,5)*Metric(2,8)*Metric(3,6)*Metric(4,7) + Metric(1,6)*Metric(2,5)*Metric(3,8)*Metric(4,7) + Metric(1,5)*Metric(2,6)*Metric(3,8)*Metric(4,7) + Metric(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,8) + Metric(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,8) + Metric(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,8) + Metric(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,8) + Metric(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,8) + Metric(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,8) + 2*Metric(1,7)*Metric(2,8)*Metric(3,4)*Metric(5,6) - 2*Metric(1,4)*Metric(2,8)*Metric(3,7)*Metric(5,6) + 2*Metric(1,7)*Metric(2,4)*Metric(3,8)*Metric(5,6) - 2*Metric(1,4)*Metric(2,7)*Metric(3,8)*Metric(5,6) - 2*Metric(1,3)*Metric(2,8)*Metric(4,7)*Metric(5,6) - 2*Metric(1,2)*Metric(3,8)*Metric(4,7)*Metric(5,6) + 2*Metric(1,7)*Metric(2,3)*Metric(4,8)*Metric(5,6) - 2*Metric(1,3)*Metric(2,7)*Metric(4,8)*Metric(5,6) - 2*Metric(1,2)*Metric(3,7)*Metric(4,8)*Metric(5,6) + 2*Metric(1,6)*Metric(2,8)*Metric(3,4)*Metric(5,7) - 2*Metric(1,4)*Metric(2,8)*Metric(3,6)*Metric(5,7) + 2*Metric(1,6)*Metric(2,4)*Metric(3,8)*Metric(5,7) - 2*Metric(1,4)*Metric(2,6)*Metric(3,8)*Metric(5,7) - 2*Metric(1,3)*Metric(2,8)*Metric(4,6)*Metric(5,7) - 2*Metric(1,2)*Metric(3,8)*Metric(4,6)*Metric(5,7) + 2*Metric(1,6)*Metric(2,3)*Metric(4,8)*Metric(5,7) - 2*Metric(1,3)*Metric(2,6)*Metric(4,8)*Metric(5,7) - 2*Metric(1,2)*Metric(3,6)*Metric(4,8)*Metric(5,7) - 2*Metric(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,8) - 2*Metric(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,8) - 2*Metric(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,8) + Metric(1,4)*Metric(2,7)*Metric(3,6)*Metric(5,8) - 2*Metric(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,8) + Metric(1,4)*Metric(2,6)*Metric(3,7)*Metric(5,8) - 2*Metric(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,8) + Metric(1,3)*Metric(2,7)*Metric(4,6)*Metric(5,8) + Metric(1,2)*Metric(3,7)*Metric(4,6)*Metric(5,8) - 2*Metric(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,8) + Metric(1,3)*Metric(2,6)*Metric(4,7)*Metric(5,8) + Metric(1,2)*Metric(3,6)*Metric(4,7)*Metric(5,8) + 2*Metric(1,5)*Metric(2,8)*Metric(3,4)*Metric(6,7) - 2*Metric(1,4)*Metric(2,8)*Metric(3,5)*Metric(6,7) + 2*Metric(1,5)*Metric(2,4)*Metric(3,8)*Metric(6,7) - 2*Metric(1,4)*Metric(2,5)*Metric(3,8)*Metric(6,7) - 2*Metric(1,3)*Metric(2,8)*Metric(4,5)*Metric(6,7) - 2*Metric(1,2)*Metric(3,8)*Metric(4,5)*Metric(6,7) + 2*Metric(1,5)*Metric(2,3)*Metric(4,8)*Metric(6,7) - 2*Metric(1,3)*Metric(2,5)*Metric(4,8)*Metric(6,7) - 2*Metric(1,2)*Metric(3,5)*Metric(4,8)*Metric(6,7) + 2*Metric(1,4)*Metric(2,3)*Metric(5,8)*Metric(6,7) + 2*Metric(1,3)*Metric(2,4)*Metric(5,8)*Metric(6,7) + 2*Metric(1,2)*Metric(3,4)*Metric(5,8)*Metric(6,7) - 2*Metric(1,7)*Metric(2,5)*Metric(3,4)*Metric(6,8) - 2*Metric(1,5)*Metric(2,7)*Metric(3,4)*Metric(6,8) - 2*Metric(1,7)*Metric(2,4)*Metric(3,5)*Metric(6,8) + Metric(1,4)*Metric(2,7)*Metric(3,5)*Metric(6,8) - 2*Metric(1,5)*Metric(2,4)*Metric(3,7)*Metric(6,8) + Metric(1,4)*Metric(2,5)*Metric(3,7)*Metric(6,8) - 2*Metric(1,7)*Metric(2,3)*Metric(4,5)*Metric(6,8) + Metric(1,3)*Metric(2,7)*Metric(4,5)*Metric(6,8) + Metric(1,2)*Metric(3,7)*Metric(4,5)*Metric(6,8) - 2*Metric(1,5)*Metric(2,3)*Metric(4,7)*Metric(6,8) + Metric(1,3)*Metric(2,5)*Metric(4,7)*Metric(6,8) + Metric(1,2)*Metric(3,5)*Metric(4,7)*Metric(6,8) + 2*Metric(1,4)*Metric(2,3)*Metric(5,7)*Metric(6,8) + 2*Metric(1,3)*Metric(2,4)*Metric(5,7)*Metric(6,8) + 2*Metric(1,2)*Metric(3,4)*Metric(5,7)*Metric(6,8) - 2*Metric(1,6)*Metric(2,5)*Metric(3,4)*Metric(7,8) - 2*Metric(1,5)*Metric(2,6)*Metric(3,4)*Metric(7,8) - 2*Metric(1,6)*Metric(2,4)*Metric(3,5)*Metric(7,8) + Metric(1,4)*Metric(2,6)*Metric(3,5)*Metric(7,8) - 2*Metric(1,5)*Metric(2,4)*Metric(3,6)*Metric(7,8) + Metric(1,4)*Metric(2,5)*Metric(3,6)*Metric(7,8) - 2*Metric(1,6)*Metric(2,3)*Metric(4,5)*Metric(7,8) + Metric(1,3)*Metric(2,6)*Metric(4,5)*Metric(7,8) + Metric(1,2)*Metric(3,6)*Metric(4,5)*Metric(7,8) - 2*Metric(1,5)*Metric(2,3)*Metric(4,6)*Metric(7,8) + Metric(1,3)*Metric(2,5)*Metric(4,6)*Metric(7,8) + Metric(1,2)*Metric(3,5)*Metric(4,6)*Metric(7,8) + 2*Metric(1,4)*Metric(2,3)*Metric(5,6)*Metric(7,8) + 2*Metric(1,3)*Metric(2,4)*Metric(5,6)*Metric(7,8) + 2*Metric(1,2)*Metric(3,4)*Metric(5,6)*Metric(7,8)')

VVVVVVVV16 = Lorentz(name = 'VVVVVVVV16',
                     spins = [ 3, 3, 3, 3, 3, 3, 3, 3 ],
                     structure = 'Metric(1,8)*Metric(2,7)*Metric(3,6)*Metric(4,5) + Metric(1,7)*Metric(2,8)*Metric(3,6)*Metric(4,5) + Metric(1,8)*Metric(2,6)*Metric(3,7)*Metric(4,5) + Metric(1,6)*Metric(2,8)*Metric(3,7)*Metric(4,5) + Metric(1,7)*Metric(2,6)*Metric(3,8)*Metric(4,5) + Metric(1,6)*Metric(2,7)*Metric(3,8)*Metric(4,5) + Metric(1,8)*Metric(2,7)*Metric(3,5)*Metric(4,6) + Metric(1,7)*Metric(2,8)*Metric(3,5)*Metric(4,6) + Metric(1,8)*Metric(2,5)*Metric(3,7)*Metric(4,6) + Metric(1,5)*Metric(2,8)*Metric(3,7)*Metric(4,6) + Metric(1,7)*Metric(2,5)*Metric(3,8)*Metric(4,6) + Metric(1,5)*Metric(2,7)*Metric(3,8)*Metric(4,6) + Metric(1,8)*Metric(2,6)*Metric(3,5)*Metric(4,7) + Metric(1,6)*Metric(2,8)*Metric(3,5)*Metric(4,7) + Metric(1,8)*Metric(2,5)*Metric(3,6)*Metric(4,7) + Metric(1,5)*Metric(2,8)*Metric(3,6)*Metric(4,7) + Metric(1,6)*Metric(2,5)*Metric(3,8)*Metric(4,7) + Metric(1,5)*Metric(2,6)*Metric(3,8)*Metric(4,7) + Metric(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,8) + Metric(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,8) + Metric(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,8) + Metric(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,8) + Metric(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,8) + Metric(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,8) - (2*Metric(1,8)*Metric(2,7)*Metric(3,4)*Metric(5,6))/3. - (2*Metric(1,7)*Metric(2,8)*Metric(3,4)*Metric(5,6))/3. - (2*Metric(1,8)*Metric(2,4)*Metric(3,7)*Metric(5,6))/3. - (2*Metric(1,4)*Metric(2,8)*Metric(3,7)*Metric(5,6))/3. - (2*Metric(1,7)*Metric(2,4)*Metric(3,8)*Metric(5,6))/3. - (2*Metric(1,4)*Metric(2,7)*Metric(3,8)*Metric(5,6))/3. - (2*Metric(1,8)*Metric(2,3)*Metric(4,7)*Metric(5,6))/3. - (2*Metric(1,3)*Metric(2,8)*Metric(4,7)*Metric(5,6))/3. - (2*Metric(1,2)*Metric(3,8)*Metric(4,7)*Metric(5,6))/3. - (2*Metric(1,7)*Metric(2,3)*Metric(4,8)*Metric(5,6))/3. - (2*Metric(1,3)*Metric(2,7)*Metric(4,8)*Metric(5,6))/3. - (2*Metric(1,2)*Metric(3,7)*Metric(4,8)*Metric(5,6))/3. - (2*Metric(1,8)*Metric(2,6)*Metric(3,4)*Metric(5,7))/3. - (2*Metric(1,6)*Metric(2,8)*Metric(3,4)*Metric(5,7))/3. - (2*Metric(1,8)*Metric(2,4)*Metric(3,6)*Metric(5,7))/3. - (2*Metric(1,4)*Metric(2,8)*Metric(3,6)*Metric(5,7))/3. - (2*Metric(1,6)*Metric(2,4)*Metric(3,8)*Metric(5,7))/3. - (2*Metric(1,4)*Metric(2,6)*Metric(3,8)*Metric(5,7))/3. - (2*Metric(1,8)*Metric(2,3)*Metric(4,6)*Metric(5,7))/3. - (2*Metric(1,3)*Metric(2,8)*Metric(4,6)*Metric(5,7))/3. - (2*Metric(1,2)*Metric(3,8)*Metric(4,6)*Metric(5,7))/3. - (2*Metric(1,6)*Metric(2,3)*Metric(4,8)*Metric(5,7))/3. - (2*Metric(1,3)*Metric(2,6)*Metric(4,8)*Metric(5,7))/3. - (2*Metric(1,2)*Metric(3,6)*Metric(4,8)*Metric(5,7))/3. - (2*Metric(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,8))/3. - (2*Metric(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,8))/3. - (2*Metric(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,8))/3. - (2*Metric(1,4)*Metric(2,7)*Metric(3,6)*Metric(5,8))/3. - (2*Metric(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,8))/3. - (2*Metric(1,4)*Metric(2,6)*Metric(3,7)*Metric(5,8))/3. - (2*Metric(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,8))/3. - (2*Metric(1,3)*Metric(2,7)*Metric(4,6)*Metric(5,8))/3. - (2*Metric(1,2)*Metric(3,7)*Metric(4,6)*Metric(5,8))/3. - (2*Metric(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,8))/3. - (2*Metric(1,3)*Metric(2,6)*Metric(4,7)*Metric(5,8))/3. - (2*Metric(1,2)*Metric(3,6)*Metric(4,7)*Metric(5,8))/3. - (2*Metric(1,8)*Metric(2,5)*Metric(3,4)*Metric(6,7))/3. - (2*Metric(1,5)*Metric(2,8)*Metric(3,4)*Metric(6,7))/3. - (2*Metric(1,8)*Metric(2,4)*Metric(3,5)*Metric(6,7))/3. - (2*Metric(1,4)*Metric(2,8)*Metric(3,5)*Metric(6,7))/3. - (2*Metric(1,5)*Metric(2,4)*Metric(3,8)*Metric(6,7))/3. - (2*Metric(1,4)*Metric(2,5)*Metric(3,8)*Metric(6,7))/3. - (2*Metric(1,8)*Metric(2,3)*Metric(4,5)*Metric(6,7))/3. - (2*Metric(1,3)*Metric(2,8)*Metric(4,5)*Metric(6,7))/3. - (2*Metric(1,2)*Metric(3,8)*Metric(4,5)*Metric(6,7))/3. - (2*Metric(1,5)*Metric(2,3)*Metric(4,8)*Metric(6,7))/3. - (2*Metric(1,3)*Metric(2,5)*Metric(4,8)*Metric(6,7))/3. - (2*Metric(1,2)*Metric(3,5)*Metric(4,8)*Metric(6,7))/3. + (8*Metric(1,4)*Metric(2,3)*Metric(5,8)*Metric(6,7))/3. + (8*Metric(1,3)*Metric(2,4)*Metric(5,8)*Metric(6,7))/3. + (8*Metric(1,2)*Metric(3,4)*Metric(5,8)*Metric(6,7))/3. - (2*Metric(1,7)*Metric(2,5)*Metric(3,4)*Metric(6,8))/3. - (2*Metric(1,5)*Metric(2,7)*Metric(3,4)*Metric(6,8))/3. - (2*Metric(1,7)*Metric(2,4)*Metric(3,5)*Metric(6,8))/3. - (2*Metric(1,4)*Metric(2,7)*Metric(3,5)*Metric(6,8))/3. - (2*Metric(1,5)*Metric(2,4)*Metric(3,7)*Metric(6,8))/3. - (2*Metric(1,4)*Metric(2,5)*Metric(3,7)*Metric(6,8))/3. - (2*Metric(1,7)*Metric(2,3)*Metric(4,5)*Metric(6,8))/3. - (2*Metric(1,3)*Metric(2,7)*Metric(4,5)*Metric(6,8))/3. - (2*Metric(1,2)*Metric(3,7)*Metric(4,5)*Metric(6,8))/3. - (2*Metric(1,5)*Metric(2,3)*Metric(4,7)*Metric(6,8))/3. - (2*Metric(1,3)*Metric(2,5)*Metric(4,7)*Metric(6,8))/3. - (2*Metric(1,2)*Metric(3,5)*Metric(4,7)*Metric(6,8))/3. + (8*Metric(1,4)*Metric(2,3)*Metric(5,7)*Metric(6,8))/3. + (8*Metric(1,3)*Metric(2,4)*Metric(5,7)*Metric(6,8))/3. + (8*Metric(1,2)*Metric(3,4)*Metric(5,7)*Metric(6,8))/3. - (2*Metric(1,6)*Metric(2,5)*Metric(3,4)*Metric(7,8))/3. - (2*Metric(1,5)*Metric(2,6)*Metric(3,4)*Metric(7,8))/3. - (2*Metric(1,6)*Metric(2,4)*Metric(3,5)*Metric(7,8))/3. - (2*Metric(1,4)*Metric(2,6)*Metric(3,5)*Metric(7,8))/3. - (2*Metric(1,5)*Metric(2,4)*Metric(3,6)*Metric(7,8))/3. - (2*Metric(1,4)*Metric(2,5)*Metric(3,6)*Metric(7,8))/3. - (2*Metric(1,6)*Metric(2,3)*Metric(4,5)*Metric(7,8))/3. - (2*Metric(1,3)*Metric(2,6)*Metric(4,5)*Metric(7,8))/3. - (2*Metric(1,2)*Metric(3,6)*Metric(4,5)*Metric(7,8))/3. - (2*Metric(1,5)*Metric(2,3)*Metric(4,6)*Metric(7,8))/3. - (2*Metric(1,3)*Metric(2,5)*Metric(4,6)*Metric(7,8))/3. - (2*Metric(1,2)*Metric(3,5)*Metric(4,6)*Metric(7,8))/3. + (8*Metric(1,4)*Metric(2,3)*Metric(5,6)*Metric(7,8))/3. + (8*Metric(1,3)*Metric(2,4)*Metric(5,6)*Metric(7,8))/3. + (8*Metric(1,2)*Metric(3,4)*Metric(5,6)*Metric(7,8))/3.')

VVVVVVVV17 = Lorentz(name = 'VVVVVVVV17',
                     spins = [ 3, 3, 3, 3, 3, 3, 3, 3 ],
                     structure = 'Metric(1,8)*Metric(2,7)*Metric(3,6)*Metric(4,5) + Metric(1,7)*Metric(2,8)*Metric(3,6)*Metric(4,5) + Metric(1,8)*Metric(2,6)*Metric(3,7)*Metric(4,5) + Metric(1,6)*Metric(2,8)*Metric(3,7)*Metric(4,5) + Metric(1,7)*Metric(2,6)*Metric(3,8)*Metric(4,5) + Metric(1,6)*Metric(2,7)*Metric(3,8)*Metric(4,5) + Metric(1,8)*Metric(2,7)*Metric(3,5)*Metric(4,6) + Metric(1,7)*Metric(2,8)*Metric(3,5)*Metric(4,6) + Metric(1,8)*Metric(2,5)*Metric(3,7)*Metric(4,6) + Metric(1,5)*Metric(2,8)*Metric(3,7)*Metric(4,6) + Metric(1,7)*Metric(2,5)*Metric(3,8)*Metric(4,6) + Metric(1,5)*Metric(2,7)*Metric(3,8)*Metric(4,6) + Metric(1,8)*Metric(2,6)*Metric(3,5)*Metric(4,7) + Metric(1,6)*Metric(2,8)*Metric(3,5)*Metric(4,7) + Metric(1,8)*Metric(2,5)*Metric(3,6)*Metric(4,7) + Metric(1,5)*Metric(2,8)*Metric(3,6)*Metric(4,7) + Metric(1,6)*Metric(2,5)*Metric(3,8)*Metric(4,7) + Metric(1,5)*Metric(2,6)*Metric(3,8)*Metric(4,7) + Metric(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,8) + Metric(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,8) + Metric(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,8) + Metric(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,8) + Metric(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,8) + Metric(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,8) - Metric(1,8)*Metric(2,7)*Metric(3,4)*Metric(5,6) - Metric(1,7)*Metric(2,8)*Metric(3,4)*Metric(5,6) - (Metric(1,8)*Metric(2,4)*Metric(3,7)*Metric(5,6))/2. - (Metric(1,4)*Metric(2,8)*Metric(3,7)*Metric(5,6))/2. - (Metric(1,7)*Metric(2,4)*Metric(3,8)*Metric(5,6))/2. - (Metric(1,4)*Metric(2,7)*Metric(3,8)*Metric(5,6))/2. - (Metric(1,8)*Metric(2,3)*Metric(4,7)*Metric(5,6))/2. - (Metric(1,3)*Metric(2,8)*Metric(4,7)*Metric(5,6))/2. - Metric(1,2)*Metric(3,8)*Metric(4,7)*Metric(5,6) - (Metric(1,7)*Metric(2,3)*Metric(4,8)*Metric(5,6))/2. - (Metric(1,3)*Metric(2,7)*Metric(4,8)*Metric(5,6))/2. - Metric(1,2)*Metric(3,7)*Metric(4,8)*Metric(5,6) - Metric(1,8)*Metric(2,6)*Metric(3,4)*Metric(5,7) - Metric(1,6)*Metric(2,8)*Metric(3,4)*Metric(5,7) - (Metric(1,8)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. - (Metric(1,4)*Metric(2,8)*Metric(3,6)*Metric(5,7))/2. - (Metric(1,6)*Metric(2,4)*Metric(3,8)*Metric(5,7))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,8)*Metric(5,7))/2. - (Metric(1,8)*Metric(2,3)*Metric(4,6)*Metric(5,7))/2. - (Metric(1,3)*Metric(2,8)*Metric(4,6)*Metric(5,7))/2. - Metric(1,2)*Metric(3,8)*Metric(4,6)*Metric(5,7) - (Metric(1,6)*Metric(2,3)*Metric(4,8)*Metric(5,7))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,8)*Metric(5,7))/2. - Metric(1,2)*Metric(3,6)*Metric(4,8)*Metric(5,7) - Metric(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,8) - Metric(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,8) - (Metric(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,8))/2. - (Metric(1,4)*Metric(2,7)*Metric(3,6)*Metric(5,8))/2. - (Metric(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,8))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,7)*Metric(5,8))/2. - (Metric(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,8))/2. - (Metric(1,3)*Metric(2,7)*Metric(4,6)*Metric(5,8))/2. - Metric(1,2)*Metric(3,7)*Metric(4,6)*Metric(5,8) - (Metric(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,8))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,7)*Metric(5,8))/2. - Metric(1,2)*Metric(3,6)*Metric(4,7)*Metric(5,8) - Metric(1,8)*Metric(2,5)*Metric(3,4)*Metric(6,7) - Metric(1,5)*Metric(2,8)*Metric(3,4)*Metric(6,7) - (Metric(1,8)*Metric(2,4)*Metric(3,5)*Metric(6,7))/2. - (Metric(1,4)*Metric(2,8)*Metric(3,5)*Metric(6,7))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,8)*Metric(6,7))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,8)*Metric(6,7))/2. - (Metric(1,8)*Metric(2,3)*Metric(4,5)*Metric(6,7))/2. - (Metric(1,3)*Metric(2,8)*Metric(4,5)*Metric(6,7))/2. - Metric(1,2)*Metric(3,8)*Metric(4,5)*Metric(6,7) - (Metric(1,5)*Metric(2,3)*Metric(4,8)*Metric(6,7))/2. - (Metric(1,3)*Metric(2,5)*Metric(4,8)*Metric(6,7))/2. - Metric(1,2)*Metric(3,5)*Metric(4,8)*Metric(6,7) + 2*Metric(1,4)*Metric(2,3)*Metric(5,8)*Metric(6,7) + 2*Metric(1,3)*Metric(2,4)*Metric(5,8)*Metric(6,7) + 4*Metric(1,2)*Metric(3,4)*Metric(5,8)*Metric(6,7) - Metric(1,7)*Metric(2,5)*Metric(3,4)*Metric(6,8) - Metric(1,5)*Metric(2,7)*Metric(3,4)*Metric(6,8) - (Metric(1,7)*Metric(2,4)*Metric(3,5)*Metric(6,8))/2. - (Metric(1,4)*Metric(2,7)*Metric(3,5)*Metric(6,8))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,7)*Metric(6,8))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,7)*Metric(6,8))/2. - (Metric(1,7)*Metric(2,3)*Metric(4,5)*Metric(6,8))/2. - (Metric(1,3)*Metric(2,7)*Metric(4,5)*Metric(6,8))/2. - Metric(1,2)*Metric(3,7)*Metric(4,5)*Metric(6,8) - (Metric(1,5)*Metric(2,3)*Metric(4,7)*Metric(6,8))/2. - (Metric(1,3)*Metric(2,5)*Metric(4,7)*Metric(6,8))/2. - Metric(1,2)*Metric(3,5)*Metric(4,7)*Metric(6,8) + 2*Metric(1,4)*Metric(2,3)*Metric(5,7)*Metric(6,8) + 2*Metric(1,3)*Metric(2,4)*Metric(5,7)*Metric(6,8) + 4*Metric(1,2)*Metric(3,4)*Metric(5,7)*Metric(6,8) - Metric(1,6)*Metric(2,5)*Metric(3,4)*Metric(7,8) - Metric(1,5)*Metric(2,6)*Metric(3,4)*Metric(7,8) - (Metric(1,6)*Metric(2,4)*Metric(3,5)*Metric(7,8))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,5)*Metric(7,8))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,6)*Metric(7,8))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,6)*Metric(7,8))/2. - (Metric(1,6)*Metric(2,3)*Metric(4,5)*Metric(7,8))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,5)*Metric(7,8))/2. - Metric(1,2)*Metric(3,6)*Metric(4,5)*Metric(7,8) - (Metric(1,5)*Metric(2,3)*Metric(4,6)*Metric(7,8))/2. - (Metric(1,3)*Metric(2,5)*Metric(4,6)*Metric(7,8))/2. - Metric(1,2)*Metric(3,5)*Metric(4,6)*Metric(7,8) + 2*Metric(1,4)*Metric(2,3)*Metric(5,6)*Metric(7,8) + 2*Metric(1,3)*Metric(2,4)*Metric(5,6)*Metric(7,8) + 4*Metric(1,2)*Metric(3,4)*Metric(5,6)*Metric(7,8)')

VVVVVVVV18 = Lorentz(name = 'VVVVVVVV18',
                     spins = [ 3, 3, 3, 3, 3, 3, 3, 3 ],
                     structure = 'Metric(1,8)*Metric(2,7)*Metric(3,6)*Metric(4,5) + Metric(1,7)*Metric(2,8)*Metric(3,6)*Metric(4,5) + Metric(1,8)*Metric(2,6)*Metric(3,7)*Metric(4,5) + Metric(1,6)*Metric(2,8)*Metric(3,7)*Metric(4,5) + Metric(1,7)*Metric(2,6)*Metric(3,8)*Metric(4,5) + Metric(1,6)*Metric(2,7)*Metric(3,8)*Metric(4,5) + Metric(1,8)*Metric(2,7)*Metric(3,5)*Metric(4,6) + Metric(1,7)*Metric(2,8)*Metric(3,5)*Metric(4,6) + Metric(1,8)*Metric(2,5)*Metric(3,7)*Metric(4,6) + Metric(1,5)*Metric(2,8)*Metric(3,7)*Metric(4,6) + Metric(1,7)*Metric(2,5)*Metric(3,8)*Metric(4,6) + Metric(1,5)*Metric(2,7)*Metric(3,8)*Metric(4,6) + Metric(1,8)*Metric(2,6)*Metric(3,5)*Metric(4,7) + Metric(1,6)*Metric(2,8)*Metric(3,5)*Metric(4,7) + Metric(1,8)*Metric(2,5)*Metric(3,6)*Metric(4,7) + Metric(1,5)*Metric(2,8)*Metric(3,6)*Metric(4,7) + Metric(1,6)*Metric(2,5)*Metric(3,8)*Metric(4,7) + Metric(1,5)*Metric(2,6)*Metric(3,8)*Metric(4,7) + Metric(1,7)*Metric(2,6)*Metric(3,5)*Metric(4,8) + Metric(1,6)*Metric(2,7)*Metric(3,5)*Metric(4,8) + Metric(1,7)*Metric(2,5)*Metric(3,6)*Metric(4,8) + Metric(1,5)*Metric(2,7)*Metric(3,6)*Metric(4,8) + Metric(1,6)*Metric(2,5)*Metric(3,7)*Metric(4,8) + Metric(1,5)*Metric(2,6)*Metric(3,7)*Metric(4,8) - Metric(1,8)*Metric(2,7)*Metric(3,4)*Metric(5,6) - Metric(1,7)*Metric(2,8)*Metric(3,4)*Metric(5,6) - Metric(1,8)*Metric(2,4)*Metric(3,7)*Metric(5,6) - Metric(1,4)*Metric(2,8)*Metric(3,7)*Metric(5,6) - Metric(1,7)*Metric(2,4)*Metric(3,8)*Metric(5,6) - Metric(1,4)*Metric(2,7)*Metric(3,8)*Metric(5,6) - Metric(1,8)*Metric(2,3)*Metric(4,7)*Metric(5,6) - Metric(1,3)*Metric(2,8)*Metric(4,7)*Metric(5,6) - Metric(1,2)*Metric(3,8)*Metric(4,7)*Metric(5,6) - Metric(1,7)*Metric(2,3)*Metric(4,8)*Metric(5,6) - Metric(1,3)*Metric(2,7)*Metric(4,8)*Metric(5,6) - Metric(1,2)*Metric(3,7)*Metric(4,8)*Metric(5,6) - (Metric(1,8)*Metric(2,6)*Metric(3,4)*Metric(5,7))/2. - (Metric(1,6)*Metric(2,8)*Metric(3,4)*Metric(5,7))/2. - (Metric(1,8)*Metric(2,4)*Metric(3,6)*Metric(5,7))/2. - (Metric(1,4)*Metric(2,8)*Metric(3,6)*Metric(5,7))/2. - (Metric(1,6)*Metric(2,4)*Metric(3,8)*Metric(5,7))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,8)*Metric(5,7))/2. - (Metric(1,8)*Metric(2,3)*Metric(4,6)*Metric(5,7))/2. - (Metric(1,3)*Metric(2,8)*Metric(4,6)*Metric(5,7))/2. - (Metric(1,2)*Metric(3,8)*Metric(4,6)*Metric(5,7))/2. - (Metric(1,6)*Metric(2,3)*Metric(4,8)*Metric(5,7))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,8)*Metric(5,7))/2. - (Metric(1,2)*Metric(3,6)*Metric(4,8)*Metric(5,7))/2. - (Metric(1,7)*Metric(2,6)*Metric(3,4)*Metric(5,8))/2. - (Metric(1,6)*Metric(2,7)*Metric(3,4)*Metric(5,8))/2. - (Metric(1,7)*Metric(2,4)*Metric(3,6)*Metric(5,8))/2. - (Metric(1,4)*Metric(2,7)*Metric(3,6)*Metric(5,8))/2. - (Metric(1,6)*Metric(2,4)*Metric(3,7)*Metric(5,8))/2. - (Metric(1,4)*Metric(2,6)*Metric(3,7)*Metric(5,8))/2. - (Metric(1,7)*Metric(2,3)*Metric(4,6)*Metric(5,8))/2. - (Metric(1,3)*Metric(2,7)*Metric(4,6)*Metric(5,8))/2. - (Metric(1,2)*Metric(3,7)*Metric(4,6)*Metric(5,8))/2. - (Metric(1,6)*Metric(2,3)*Metric(4,7)*Metric(5,8))/2. - (Metric(1,3)*Metric(2,6)*Metric(4,7)*Metric(5,8))/2. - (Metric(1,2)*Metric(3,6)*Metric(4,7)*Metric(5,8))/2. - (Metric(1,8)*Metric(2,5)*Metric(3,4)*Metric(6,7))/2. - (Metric(1,5)*Metric(2,8)*Metric(3,4)*Metric(6,7))/2. - (Metric(1,8)*Metric(2,4)*Metric(3,5)*Metric(6,7))/2. - (Metric(1,4)*Metric(2,8)*Metric(3,5)*Metric(6,7))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,8)*Metric(6,7))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,8)*Metric(6,7))/2. - (Metric(1,8)*Metric(2,3)*Metric(4,5)*Metric(6,7))/2. - (Metric(1,3)*Metric(2,8)*Metric(4,5)*Metric(6,7))/2. - (Metric(1,2)*Metric(3,8)*Metric(4,5)*Metric(6,7))/2. - (Metric(1,5)*Metric(2,3)*Metric(4,8)*Metric(6,7))/2. - (Metric(1,3)*Metric(2,5)*Metric(4,8)*Metric(6,7))/2. - (Metric(1,2)*Metric(3,5)*Metric(4,8)*Metric(6,7))/2. + 2*Metric(1,4)*Metric(2,3)*Metric(5,8)*Metric(6,7) + 2*Metric(1,3)*Metric(2,4)*Metric(5,8)*Metric(6,7) + 2*Metric(1,2)*Metric(3,4)*Metric(5,8)*Metric(6,7) - (Metric(1,7)*Metric(2,5)*Metric(3,4)*Metric(6,8))/2. - (Metric(1,5)*Metric(2,7)*Metric(3,4)*Metric(6,8))/2. - (Metric(1,7)*Metric(2,4)*Metric(3,5)*Metric(6,8))/2. - (Metric(1,4)*Metric(2,7)*Metric(3,5)*Metric(6,8))/2. - (Metric(1,5)*Metric(2,4)*Metric(3,7)*Metric(6,8))/2. - (Metric(1,4)*Metric(2,5)*Metric(3,7)*Metric(6,8))/2. - (Metric(1,7)*Metric(2,3)*Metric(4,5)*Metric(6,8))/2. - (Metric(1,3)*Metric(2,7)*Metric(4,5)*Metric(6,8))/2. - (Metric(1,2)*Metric(3,7)*Metric(4,5)*Metric(6,8))/2. - (Metric(1,5)*Metric(2,3)*Metric(4,7)*Metric(6,8))/2. - (Metric(1,3)*Metric(2,5)*Metric(4,7)*Metric(6,8))/2. - (Metric(1,2)*Metric(3,5)*Metric(4,7)*Metric(6,8))/2. + 2*Metric(1,4)*Metric(2,3)*Metric(5,7)*Metric(6,8) + 2*Metric(1,3)*Metric(2,4)*Metric(5,7)*Metric(6,8) + 2*Metric(1,2)*Metric(3,4)*Metric(5,7)*Metric(6,8) - Metric(1,6)*Metric(2,5)*Metric(3,4)*Metric(7,8) - Metric(1,5)*Metric(2,6)*Metric(3,4)*Metric(7,8) - Metric(1,6)*Metric(2,4)*Metric(3,5)*Metric(7,8) - Metric(1,4)*Metric(2,6)*Metric(3,5)*Metric(7,8) - Metric(1,5)*Metric(2,4)*Metric(3,6)*Metric(7,8) - Metric(1,4)*Metric(2,5)*Metric(3,6)*Metric(7,8) - Metric(1,6)*Metric(2,3)*Metric(4,5)*Metric(7,8) - Metric(1,3)*Metric(2,6)*Metric(4,5)*Metric(7,8) - Metric(1,2)*Metric(3,6)*Metric(4,5)*Metric(7,8) - Metric(1,5)*Metric(2,3)*Metric(4,6)*Metric(7,8) - Metric(1,3)*Metric(2,5)*Metric(4,6)*Metric(7,8) - Metric(1,2)*Metric(3,5)*Metric(4,6)*Metric(7,8) + 4*Metric(1,4)*Metric(2,3)*Metric(5,6)*Metric(7,8) + 4*Metric(1,3)*Metric(2,4)*Metric(5,6)*Metric(7,8) + 4*Metric(1,2)*Metric(3,4)*Metric(5,6)*Metric(7,8)')

