(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     32573,        851]
NotebookOptionsPosition[     28844,        719]
NotebookOutlinePosition[     29219,        736]
CellTagsIndexPosition[     29176,        733]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 StyleBox[
  RowBox[{"ASperGe", ":", "\n", 
   RowBox[{"The", " ", "Standard", " ", "Model"}]}], "Title"]], "Input",
 CellChangeTimes->{{3.5680339537906218`*^9, 3.568033968185855*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.568033973654759*^9, 3.568033980105204*^9}}],

Cell[CellGroupData[{

Cell["Set the path", "Section",
 CellChangeTimes->{{3.568033987624649*^9, 3.568033993662871*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", " ", "=", " ", 
   RowBox[{
   "SetDirectory", "[", "\"\<<< address of the package >>\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\<<< address of the model file>>\>\"", "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.5682895637105637`*^9, 3.568289566692581*^9}, {
  3.568289649203005*^9, 3.568289655625462*^9}, {3.568291435394949*^9, 
  3.5682914356093397`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{3.568095958334152*^9, 3.568096021939089*^9, 
  3.568100925694777*^9, 3.568101045448378*^9, 3.568101154665114*^9, 
  3.568101279129108*^9, 3.568102503716906*^9, 3.5681025891129093`*^9, 
  3.568103265561078*^9, 3.568103693691141*^9, 3.568120378681642*^9, 
  3.568286429397833*^9, 3.568286566995369*^9, 3.56828691128162*^9, 
  3.5682871123683167`*^9, 3.568287895271542*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"1.7.132\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"27 January 2013\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "1.7.132", " (" "27 January 2013", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568095958334152*^9, 3.568096021939089*^9, 
  3.568100925694777*^9, 3.568101045448378*^9, 3.568101154665114*^9, 
  3.568101279129108*^9, 3.568102503716906*^9, 3.5681025891129093`*^9, 
  3.568103265561078*^9, 3.568103693691141*^9, 3.568120378681642*^9, 
  3.568286429397833*^9, 3.568286566995369*^9, 3.56828691128162*^9, 
  3.5682871123683167`*^9, 3.56828789527454*^9}],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{3.568095958334152*^9, 3.568096021939089*^9, 
  3.568100925694777*^9, 3.568101045448378*^9, 3.568101154665114*^9, 
  3.568101279129108*^9, 3.568102503716906*^9, 3.5681025891129093`*^9, 
  3.568103265561078*^9, 3.568103693691141*^9, 3.568120378681642*^9, 
  3.568286429397833*^9, 3.568286566995369*^9, 3.56828691128162*^9, 
  3.5682871123683167`*^9, 3.568287895277705*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.568095958334152*^9, 3.568096021939089*^9, 
  3.568100925694777*^9, 3.568101045448378*^9, 3.568101154665114*^9, 
  3.568101279129108*^9, 3.568102503716906*^9, 3.5681025891129093`*^9, 
  3.568103265561078*^9, 3.568103693691141*^9, 3.568120378681642*^9, 
  3.568286429397833*^9, 3.568286566995369*^9, 3.56828691128162*^9, 
  3.5682871123683167`*^9, 3.56828789528133*^9}],

Cell[BoxData["\<\"Please cite: Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{3.568095958334152*^9, 3.568096021939089*^9, 
  3.568100925694777*^9, 3.568101045448378*^9, 3.568101154665114*^9, 
  3.568101279129108*^9, 3.568102503716906*^9, 3.5681025891129093`*^9, 
  3.568103265561078*^9, 3.568103693691141*^9, 3.568120378681642*^9, 
  3.568286429397833*^9, 3.568286566995369*^9, 3.56828691128162*^9, 
  3.5682871123683167`*^9, 3.568287895284048*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{3.568095958334152*^9, 3.568096021939089*^9, 
  3.568100925694777*^9, 3.568101045448378*^9, 3.568101154665114*^9, 
  3.568101279129108*^9, 3.568102503716906*^9, 3.5681025891129093`*^9, 
  3.568103265561078*^9, 3.568103693691141*^9, 3.568120378681642*^9, 
  3.568286429397833*^9, 3.568286566995369*^9, 3.56828691128162*^9, 
  3.5682871123683167`*^9, 3.568287895286697*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.568095958334152*^9, 3.568096021939089*^9, 
  3.568100925694777*^9, 3.568101045448378*^9, 3.568101154665114*^9, 
  3.568101279129108*^9, 3.568102503716906*^9, 3.5681025891129093`*^9, 
  3.568103265561078*^9, 3.568103693691141*^9, 3.568120378681642*^9, 
  3.568286429397833*^9, 3.568286566995369*^9, 3.56828691128162*^9, 
  3.5682871123683167`*^9, 3.568287895291132*^9}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{3.568095958334152*^9, 3.568096021939089*^9, 
  3.568100925694777*^9, 3.568101045448378*^9, 3.568101154665114*^9, 
  3.568101279129108*^9, 3.568102503716906*^9, 3.5681025891129093`*^9, 
  3.568103265561078*^9, 3.568103693691141*^9, 3.568120378681642*^9, 
  3.568286429397833*^9, 3.568286566995369*^9, 3.56828691128162*^9, 
  3.5682871123683167`*^9, 3.5682878952950363`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import the model", "Section",
 CellChangeTimes->{{3.568034009758786*^9, 3.5680340152778673`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadModel", "[", "\"\<SM_mix.fr\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$FeynRulesPath", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.568034045483623*^9, 3.5680340463555202`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.5681009310402403`*^9, 3.56810105716776*^9, 3.5681011600962467`*^9, 
  3.568101284277884*^9, 3.56810250890549*^9, 3.568102594350691*^9, 
  3.568103274473949*^9, 3.568103700352043*^9, 3.568120385812242*^9, 
  3.568286435570959*^9, 3.568286574176463*^9, 3.568286916976327*^9, 
  3.5682871177530212`*^9, 3.568287900719614*^9}],

Cell[BoxData["\<\"N. Christensen\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.5681009310402403`*^9, 3.56810105716776*^9, 3.5681011600962467`*^9, 
  3.568101284277884*^9, 3.56810250890549*^9, 3.568102594350691*^9, 
  3.568103274473949*^9, 3.568103700352043*^9, 3.568120385812242*^9, 
  3.568286435570959*^9, 3.568286574176463*^9, 3.568286916976327*^9, 
  3.5682871177530212`*^9, 3.568287900721627*^9}],

Cell[BoxData["\<\"C. Duhr\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.5681009310402403`*^9, 3.56810105716776*^9, 3.5681011600962467`*^9, 
  3.568101284277884*^9, 3.56810250890549*^9, 3.568102594350691*^9, 
  3.568103274473949*^9, 3.568103700352043*^9, 3.568120385812242*^9, 
  3.568286435570959*^9, 3.568286574176463*^9, 3.568286916976327*^9, 
  3.5682871177530212`*^9, 3.568287900723536*^9}],

Cell[BoxData["\<\"B. Fuks\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.5681009310402403`*^9, 3.56810105716776*^9, 3.5681011600962467`*^9, 
  3.568101284277884*^9, 3.56810250890549*^9, 3.568102594350691*^9, 
  3.568103274473949*^9, 3.568103700352043*^9, 3.568120385812242*^9, 
  3.568286435570959*^9, 3.568286574176463*^9, 3.568286916976327*^9, 
  3.5682871177530212`*^9, 3.568287900725472*^9}],

Cell[BoxData["\<\"A. Alloul\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.5681009310402403`*^9, 3.56810105716776*^9, 3.5681011600962467`*^9, 
  3.568101284277884*^9, 3.56810250890549*^9, 3.568102594350691*^9, 
  3.568103274473949*^9, 3.568103700352043*^9, 3.568120385812242*^9, 
  3.568286435570959*^9, 3.568286574176463*^9, 3.568286916976327*^9, 
  3.5682871177530212`*^9, 3.568287900727406*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0.0\"\>"}],
  SequenceForm["Model Version: ", "1.0.0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.5681009310402403`*^9, 3.56810105716776*^9, 3.5681011600962467`*^9, 
  3.568101284277884*^9, 3.56810250890549*^9, 3.568102594350691*^9, 
  3.568103274473949*^9, 3.568103700352043*^9, 3.568120385812242*^9, 
  3.568286435570959*^9, 3.568286574176463*^9, 3.568286916976327*^9, 
  3.5682871177530212`*^9, 3.568287900729546*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be/view/Main/StandardModel\"\>\
"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.5681009310402403`*^9, 3.56810105716776*^9, 3.5681011600962467`*^9, 
  3.568101284277884*^9, 3.56810250890549*^9, 3.568102594350691*^9, 
  3.568103274473949*^9, 3.568103700352043*^9, 3.568120385812242*^9, 
  3.568286435570959*^9, 3.568286574176463*^9, 3.568286916976327*^9, 
  3.5682871177530212`*^9, 3.568287900731626*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.5681009310402403`*^9, 3.56810105716776*^9, 3.5681011600962467`*^9, 
  3.568101284277884*^9, 3.56810250890549*^9, 3.568102594350691*^9, 
  3.568103274473949*^9, 3.568103700352043*^9, 3.568120385812242*^9, 
  3.568286435570959*^9, 3.568286574176463*^9, 3.568286916976327*^9, 
  3.5682871177530212`*^9, 3.568287900733724*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.5681009310402403`*^9, 3.56810105716776*^9, 3.5681011600962467`*^9, 
  3.568101284277884*^9, 3.56810250890549*^9, 3.568102594350691*^9, 
  3.568103274473949*^9, 3.568103700352043*^9, 3.568120385812242*^9, 
  3.568286435570959*^9, 3.568286574176463*^9, 3.568286916976327*^9, 
  3.5682871177530212`*^9, 3.568287900735792*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.5681009310402403`*^9, 3.56810105716776*^9, 3.5681011600962467`*^9, 
  3.568101284277884*^9, 3.56810250890549*^9, 3.568102594350691*^9, 
  3.568103274473949*^9, 3.568103700352043*^9, 3.568120385812242*^9, 
  3.568286435570959*^9, 3.568286574176463*^9, 3.568286916976327*^9, 
  3.5682871177530212`*^9, 3.568287900738043*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.5681009310402403`*^9, 3.56810105716776*^9, 3.5681011600962467`*^9, 
  3.568101284277884*^9, 3.56810250890549*^9, 3.568102594350691*^9, 
  3.568103274473949*^9, 3.568103700352043*^9, 3.568120385812242*^9, 
  3.568286435570959*^9, 3.568286574176463*^9, 3.568286916976327*^9, 
  3.5682871177530212`*^9, 3.568287900901767*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.5681009310402403`*^9, 3.56810105716776*^9, 3.5681011600962467`*^9, 
  3.568101284277884*^9, 3.56810250890549*^9, 3.568102594350691*^9, 
  3.568103274473949*^9, 3.568103700352043*^9, 3.568120385812242*^9, 
  3.568286435570959*^9, 3.568286574176463*^9, 3.568286916976327*^9, 
  3.5682871177530212`*^9, 3.568287900904603*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"SM_mix\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "SM_mix", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.5681009310402403`*^9, 3.56810105716776*^9, 3.5681011600962467`*^9, 
  3.568101284277884*^9, 3.56810250890549*^9, 3.568102594350691*^9, 
  3.568103274473949*^9, 3.568103700352043*^9, 3.568120385812242*^9, 
  3.568286435570959*^9, 3.568286574176463*^9, 3.568286916976327*^9, 
  3.5682871177530212`*^9, 3.568287900967903*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compute the tree level mass matrices", "Section",
 CellChangeTimes->{{3.568034056025237*^9, 3.568034063631463*^9}}],

Cell[CellGroupData[{

Cell["Compute all the mass matrices", "Subsection",
 CellChangeTimes->{{3.5680340709677258`*^9, 3.568034078079522*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComputeMassMatrix", "[", "LSM", "]"}]], "Input",
 CellChangeTimes->{{3.568034079329033*^9, 3.56803408777775*^9}, {
  3.568034188373899*^9, 3.568034193957204*^9}, {3.568095980320429*^9, 
  3.568095991696084*^9}, {3.568096030607581*^9, 3.568096031918537*^9}, {
  3.5682864380047293`*^9, 3.568286438643549*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Index expansion ...\"\>"], "Print",
 CellChangeTimes->{3.568096032659218*^9, 3.568100933964387*^9, 
  3.568101059710713*^9, 3.56810116256713*^9, 3.568101286883093*^9, 
  3.568102511819727*^9, 3.568102597299*^9, 3.568103279476478*^9, 
  3.568103702910067*^9, 3.5681203906013813`*^9, 3.568286439201359*^9, 
  3.568286576797214*^9, 3.568286920833621*^9, 3.568287120459396*^9, 
  3.5682879046078587`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  => done in \"\>", "\[InvisibleSpace]", "0.2005079999999997`",
    "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["  => done in ", 0.2005079999999997, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568096032659218*^9, 3.568100933964387*^9, 
  3.568101059710713*^9, 3.56810116256713*^9, 3.568101286883093*^9, 
  3.568102511819727*^9, 3.568102597299*^9, 3.568103279476478*^9, 
  3.568103702910067*^9, 3.5681203906013813`*^9, 3.568286439201359*^9, 
  3.568286576797214*^9, 3.568286920833621*^9, 3.568287120459396*^9, 
  3.568287904805529*^9}],

Cell[BoxData["\<\"Tree level mass matrix computations achieved. Only the mass \
matrices necessary for the C++ code have been computed.\"\>"], "Print",
 CellChangeTimes->{3.568096032659218*^9, 3.568100933964387*^9, 
  3.568101059710713*^9, 3.56810116256713*^9, 3.568101286883093*^9, 
  3.568102511819727*^9, 3.568102597299*^9, 3.568103279476478*^9, 
  3.568103702910067*^9, 3.5681203906013813`*^9, 3.568286439201359*^9, 
  3.568286576797214*^9, 3.568286920833621*^9, 3.568287120459396*^9, 
  3.568287904876062*^9}],

Cell[BoxData["\<\"Check FR$MassMatrices for the list of the MixingIDs.\"\>"], \
"Print",
 CellChangeTimes->{3.568096032659218*^9, 3.568100933964387*^9, 
  3.568101059710713*^9, 3.56810116256713*^9, 3.568101286883093*^9, 
  3.568102511819727*^9, 3.568102597299*^9, 3.568103279476478*^9, 
  3.568103702910067*^9, 3.5681203906013813`*^9, 3.568286439201359*^9, 
  3.568286576797214*^9, 3.568286920833621*^9, 3.568287120459396*^9, 
  3.568287904878598*^9}],

Cell[BoxData["\<\"Use MassMatrix[ MixingID ], GaugeBasis[ MixingID ], \
MassBasis[ MixingID ], BlockName[ MixingID ] and MatrixSymbol[ MixingID ] for \
more information on the results.\"\>"], "Print",
 CellChangeTimes->{3.568096032659218*^9, 3.568100933964387*^9, 
  3.568101059710713*^9, 3.56810116256713*^9, 3.568101286883093*^9, 
  3.568102511819727*^9, 3.568102597299*^9, 3.568103279476478*^9, 
  3.568103702910067*^9, 3.5681203906013813`*^9, 3.568286439201359*^9, 
  3.568286576797214*^9, 3.568286920833621*^9, 3.568287120459396*^9, 
  3.568287904881762*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Compute all the mass matrices without generation of the output about the mass \
matrices\
\>", "Subsection",
 CellChangeTimes->{{3.568096058356905*^9, 3.568096068613702*^9}}],

Cell[BoxData[
 RowBox[{"ComputeMassMatrix", "[", 
  RowBox[{"LSM", ",", " ", 
   RowBox[{"ScreenOutput", " ", "\[Rule]", " ", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.568096075110293*^9, 3.5680960919641237`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Compute only the mass matrix of the A, Z mixing (1u)\
\>", "Subsection",
 CellChangeTimes->{{3.568034091791587*^9, 3.568034103135004*^9}, {
  3.568034169446822*^9, 3.568034176724732*^9}, {3.5680342380739393`*^9, 
  3.5680342448739557`*^9}, {3.568096182769602*^9, 3.568096184263101*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComputeMassMatrix", "[", 
  RowBox[{"LSM", ",", " ", 
   RowBox[{"Mix", "->", "\"\<1u\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.568034177974084*^9, 3.568034208533511*^9}, {
  3.568096100709914*^9, 3.5680961058370113`*^9}, {3.5680961501077957`*^9, 
  3.56809615112292*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Index expansion ...\"\>"], "Print",
 CellChangeTimes->{3.5680961517635517`*^9, 3.5682879170124273`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  => done in \"\>", "\[InvisibleSpace]", 
   "0.20047899999999963`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["  => done in ", 0.20047899999999963`, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5680961517635517`*^9, 3.568287917211713*^9}],

Cell[BoxData["\<\"Computation of the tree level mass matrix for the mixing id \
1u achieved.\"\>"], "Print",
 CellChangeTimes->{3.5680961517635517`*^9, 3.568287917283279*^9}],

Cell[BoxData["\<\"For the results, use MassMatrix[ 1u ], GaugeBasis[ 1u ], \
MassBasis[ 1u ], BlockName [ 1u ] and MatrixSymbol [ 1u ].\"\>"], "Print",
 CellChangeTimes->{3.5680961517635517`*^9, 3.568287917285993*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SubsuperscriptBox["g", "1", "2"], " ", 
       SuperscriptBox["vev", "2"]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       SubscriptBox["g", "1"], " ", 
       SubscriptBox["g", "w"], " ", 
       SuperscriptBox["vev", "2"]}]},
     {
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       SubscriptBox["g", "1"], " ", 
       SubscriptBox["g", "w"], " ", 
       SuperscriptBox["vev", "2"]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SuperscriptBox["vev", "2"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.5680961517635517`*^9, 3.568287917319626*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ask for all the information about the A, Z mixing (1u)\
\>", "Subsection",
 CellChangeTimes->{{3.56803422194046*^9, 3.56803425080986*^9}, {
  3.5680961867350807`*^9, 3.568096188327422*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MixingSummary", "[", "\"\<1u\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.568034252584323*^9, 3.568034259451329*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Gauge basis = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"B", ",", 
     SubscriptBox["Wi", "3"]}], "}"}]}],
  SequenceForm["Gauge basis = ", {$CellContext`B, 
    $CellContext`Wi[3]}],
  Editable->False]], "Print",
 CellChangeTimes->{3.56809618938696*^9, 3.56828792117336*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Mass basis = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"A", ",", "Z"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\nBlock = \"\>", "\[InvisibleSpace]", "WEAKMIX",
    "\[InvisibleSpace]", "\<\"\\nSymbol = \"\>", "\[InvisibleSpace]", "UG"}],
  SequenceForm[
  "Mass basis = ", {$CellContext`A, $CellContext`Z}, 
   "\nBlock = ", $CellContext`WEAKMIX, "\nSymbol = ", $CellContext`UG],
  Editable->False]], "Print",
 CellChangeTimes->{3.56809618938696*^9, 3.568287921176338*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared mass matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         FractionBox["1", "4"], " ", 
         SubsuperscriptBox["g", "1", "2"], " ", 
         SuperscriptBox["vev", "2"]}], 
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "4"]}], " ", 
         SubscriptBox["g", "1"], " ", 
         SubscriptBox["g", "w"], " ", 
         SuperscriptBox["vev", "2"]}]},
       {
        RowBox[{
         RowBox[{"-", 
          FractionBox["1", "4"]}], " ", 
         SubscriptBox["g", "1"], " ", 
         SubscriptBox["g", "w"], " ", 
         SuperscriptBox["vev", "2"]}], 
        RowBox[{
         FractionBox["1", "4"], " ", 
         SubsuperscriptBox["g", "w", "2"], " ", 
         SuperscriptBox["vev", "2"]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Squared mass matrix = ", 
   MatrixForm[{{
     Rational[1, 4] FeynRules`g1^2 $CellContext`vev^2, Rational[-1, 4] 
      FeynRules`g1 $CellContext`gw $CellContext`vev^2}, {
     Rational[-1, 4] FeynRules`g1 $CellContext`gw $CellContext`vev^2, 
      Rational[1, 4] $CellContext`gw^2 $CellContext`vev^2}}]],
  Editable->False]], "Print",
 CellChangeTimes->{3.56809618938696*^9, 3.568287921179467*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The mixing matrix = \"\>", "\[InvisibleSpace]", 
   TagBox["\<\"Please use the numerical code.\"\>",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["The mixing matrix = ", 
   MatrixForm["Please use the numerical code."]],
  Editable->False]], "Print",
 CellChangeTimes->{3.56809618938696*^9, 3.568287921181972*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Write the ASperGe package", "Section",
 CellChangeTimes->{{3.568034265705269*^9, 3.568034271048539*^9}}],

Cell[CellGroupData[{

Cell["\<\
Write the output for all mass matrices to the folder \
\[OpenCurlyQuote]SM_mix_MD\[CloseCurlyQuote] in $FeynRulesPath\
\>", "Subsection",
 CellChangeTimes->{{3.5680962205673933`*^9, 3.5680962369473886`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteASperGe", "[", "LSM", "]"}]], "Input",
 CellChangeTimes->{{3.568096225027586*^9, 3.568096233868973*^9}, {
  3.568286443494081*^9, 3.568286443964463*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Parameters.cpp and Parameters.hpp output is finished.\\n \
They have been stored in /Users/Karen/trunk/feynrules-development/SM_mix_MD\"\
\>"], "Print",
 CellChangeTimes->{
  3.5681009412877607`*^9, 3.568101064592959*^9, 3.568101168769639*^9, 
   3.568101292709557*^9, 3.568102533241076*^9, 3.5681026016340227`*^9, 
   3.568103288476488*^9, 3.5681037100204353`*^9, 3.568286444830323*^9, 
   3.568286581926799*^9, 3.568286925229847*^9, 3.568287063527371*^9, {
   3.568287105525797*^9, 3.56828712622892*^9}, 3.568287933120255*^9}],

Cell[BoxData["\<\"Checking parameter list...\"\>"], "Print",
 CellChangeTimes->{
  3.5681009412877607`*^9, 3.568101064592959*^9, 3.568101168769639*^9, 
   3.568101292709557*^9, 3.568102533241076*^9, 3.5681026016340227`*^9, 
   3.568103288476488*^9, 3.5681037100204353`*^9, 3.568286444830323*^9, 
   3.568286581926799*^9, 3.568286925229847*^9, 3.568287063527371*^9, {
   3.568287105525797*^9, 3.56828712622892*^9}, 3.568287933156661*^9}],

Cell[BoxData["\<\"Warning: Goldstone bosons will be ignored.\"\>"], "Print",
 CellChangeTimes->{
  3.5681009412877607`*^9, 3.568101064592959*^9, 3.568101168769639*^9, 
   3.568101292709557*^9, 3.568102533241076*^9, 3.5681026016340227`*^9, 
   3.568103288476488*^9, 3.5681037100204353`*^9, 3.568286444830323*^9, 
   3.568286581926799*^9, 3.568286925229847*^9, 3.568287063527371*^9, {
   3.568287105525797*^9, 3.56828712622892*^9}, 3.568287933161182*^9}],

Cell[BoxData["\<\"Warning: Ghost fields will be ignored.\"\>"], "Print",
 CellChangeTimes->{
  3.5681009412877607`*^9, 3.568101064592959*^9, 3.568101168769639*^9, 
   3.568101292709557*^9, 3.568102533241076*^9, 3.5681026016340227`*^9, 
   3.568103288476488*^9, 3.5681037100204353`*^9, 3.568286444830323*^9, 
   3.568286581926799*^9, 3.568286925229847*^9, 3.568287063527371*^9, {
   3.568287105525797*^9, 3.56828712622892*^9}, 3.568287933163574*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Output written on \"\>", 
   "\[InvisibleSpace]", "\<\"input/externals.dat\"\>"}],
  SequenceForm["Output written on ", "input/externals.dat"],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5681009412877607`*^9, 3.568101064592959*^9, 3.568101168769639*^9, 
   3.568101292709557*^9, 3.568102533241076*^9, 3.5681026016340227`*^9, 
   3.568103288476488*^9, 3.5681037100204353`*^9, 3.568286444830323*^9, 
   3.568286581926799*^9, 3.568286925229847*^9, 3.568287063527371*^9, {
   3.568287105525797*^9, 3.56828712622892*^9}, 3.5682879331660547`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Write the output to the folder \[OpenCurlyQuote]SM\[CloseCurlyQuote] in \
$FeynRulesPath only for the A,Z mixing (1u)\
\>", "Subsection",
 CellChangeTimes->{{3.568096247910824*^9, 3.568096269824924*^9}, {
  3.568096357314967*^9, 3.568096357774859*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteASperGe", "[", 
  RowBox[{"LSM", ",", " ", 
   RowBox[{"Output", "\[Rule]", "\"\<SM\>\""}], ",", " ", 
   RowBox[{"Mix", "\[Rule]", " ", "\"\<1u\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5680343410263853`*^9, 3.5680343452721643`*^9}, {
  3.568096361840968*^9, 3.568096369463834*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       SubsuperscriptBox["g", "1", "2"], " ", 
       SuperscriptBox["vev", "2"]}], 
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       SubscriptBox["g", "1"], " ", 
       SubscriptBox["g", "w"], " ", 
       SuperscriptBox["vev", "2"]}]},
     {
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", 
       SubscriptBox["g", "1"], " ", 
       SubscriptBox["g", "w"], " ", 
       SuperscriptBox["vev", "2"]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       SubsuperscriptBox["g", "w", "2"], " ", 
       SuperscriptBox["vev", "2"]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.568102517093158*^9, 3.5681203992615223`*^9, 
  3.568287935301374*^9}],

Cell[BoxData["\<\"Parameters.cpp and Parameters.hpp output is finished.\\n \
They have been stored in /Users/Karen/trunk/feynrules-development/SM\"\>"], \
"Print",
 CellChangeTimes->{3.568102517093158*^9, 3.5681203992615223`*^9, 
  3.5682879353580027`*^9}],

Cell[BoxData["\<\"Checking parameter list...\"\>"], "Print",
 CellChangeTimes->{3.568102517093158*^9, 3.5681203992615223`*^9, 
  3.5682879353606567`*^9}],

Cell[BoxData["\<\"Warning: Goldstone bosons will be ignored.\"\>"], "Print",
 CellChangeTimes->{3.568102517093158*^9, 3.5681203992615223`*^9, 
  3.568287935363282*^9}],

Cell[BoxData["\<\"Warning: Ghost fields will be ignored.\"\>"], "Print",
 CellChangeTimes->{3.568102517093158*^9, 3.5681203992615223`*^9, 
  3.5682879353657427`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Output written on \"\>", 
   "\[InvisibleSpace]", "\<\"input/externals.dat\"\>"}],
  SequenceForm["Output written on ", "input/externals.dat"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568102517093158*^9, 3.5681203992615223`*^9, 
  3.568287935369274*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Compile and excecute ASperGe and
load the output file back into FeynRules\
\>", "Section",
 CellChangeTimes->{3.568034375175974*^9}],

Cell[BoxData[
 RowBox[{"RunASperGe", "[", "]"}]], "Input",
 CellChangeTimes->{{3.568034380231674*^9, 3.5680343839741983`*^9}}]
}, Open  ]]
},
WindowSize->{835, 715},
WindowMargins->{{52, Automatic}, {Automatic, 0}},
ShowSelection->True,
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (August 26, \
2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 198, 4, 99, "Input"],
Cell[758, 26, 118, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[901, 32, 97, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[1023, 37, 524, 13, 58, "Input"],
Cell[CellGroupData[{
Cell[1572, 54, 439, 6, 20, "Print"],
Cell[2014, 62, 719, 13, 20, "Print"],
Cell[2736, 77, 491, 7, 20, "Print"],
Cell[3230, 86, 424, 6, 20, "Print"],
Cell[3657, 94, 495, 7, 20, "Print"],
Cell[4155, 103, 455, 6, 20, "Print"],
Cell[4613, 111, 425, 6, 20, "Print"],
Cell[5041, 119, 494, 7, 20, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[5596, 133, 103, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[5724, 138, 266, 6, 43, "Input"],
Cell[CellGroupData[{
Cell[6015, 148, 465, 6, 20, "Print"],
Cell[6483, 156, 439, 6, 20, "Print"],
Cell[6925, 164, 432, 6, 20, "Print"],
Cell[7360, 172, 432, 6, 20, "Print"],
Cell[7795, 180, 434, 6, 20, "Print"],
Cell[8232, 188, 575, 10, 20, "Print"],
Cell[8810, 200, 482, 7, 20, "Print"],
Cell[9295, 209, 473, 7, 20, "Print"],
Cell[9771, 218, 425, 6, 20, "Print"],
Cell[10199, 226, 455, 6, 20, "Print"],
Cell[10657, 234, 458, 6, 20, "Print"],
Cell[11118, 242, 456, 6, 20, "Print"],
Cell[11577, 250, 621, 11, 36, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[12259, 268, 121, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[12405, 273, 119, 1, 34, "Subsection"],
Cell[CellGroupData[{
Cell[12549, 278, 332, 5, 27, "Input"],
Cell[CellGroupData[{
Cell[12906, 287, 418, 6, 20, "Print"],
Cell[13327, 295, 619, 11, 20, "Print"],
Cell[13949, 308, 514, 7, 36, "Print"],
Cell[14466, 317, 451, 7, 20, "Print"],
Cell[14920, 326, 563, 8, 36, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[15544, 341, 184, 4, 34, "Subsection"],
Cell[15731, 347, 223, 4, 27, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[15991, 356, 296, 5, 34, "Subsection"],
Cell[CellGroupData[{
Cell[16312, 365, 303, 6, 27, "Input"],
Cell[CellGroupData[{
Cell[16640, 375, 121, 1, 20, "Print"],
Cell[16764, 378, 325, 6, 20, "Print"],
Cell[17092, 386, 174, 2, 20, "Print"],
Cell[17269, 390, 217, 2, 36, "Print"],
Cell[17489, 394, 1276, 38, 56, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[18826, 439, 199, 4, 34, "Subsection"],
Cell[CellGroupData[{
Cell[19050, 447, 141, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[19216, 453, 341, 9, 20, "Print"],
Cell[19560, 464, 536, 11, 51, "Print"],
Cell[20099, 477, 1778, 47, 56, "Print"],
Cell[21880, 526, 391, 9, 20, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[22344, 543, 110, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[22479, 548, 217, 4, 35, "Subsection"],
Cell[CellGroupData[{
Cell[22721, 556, 182, 3, 27, "Input"],
Cell[CellGroupData[{
Cell[22928, 563, 546, 8, 36, "Print"],
Cell[23477, 573, 436, 6, 20, "Print"],
Cell[23916, 581, 452, 6, 20, "Print"],
Cell[24371, 589, 448, 6, 20, "Print"],
Cell[24822, 597, 600, 11, 20, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25483, 615, 262, 5, 35, "Subsection"],
Cell[CellGroupData[{
Cell[25770, 624, 319, 6, 27, "Input"],
Cell[CellGroupData[{
Cell[26114, 634, 1301, 39, 56, "Print"],
Cell[27418, 675, 256, 4, 36, "Print"],
Cell[27677, 681, 153, 2, 20, "Print"],
Cell[27833, 685, 167, 2, 20, "Print"],
Cell[28003, 689, 165, 2, 20, "Print"],
Cell[28171, 693, 313, 7, 20, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[28557, 708, 142, 4, 89, "Section"],
Cell[28702, 714, 126, 2, 27, "Input"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
