(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[     31607,        900]
NotebookOptionsPosition[     28108,        773]
NotebookOutlinePosition[     28462,        789]
CellTagsIndexPosition[     28419,        786]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
ASperGe:
The Two-Higgs-Doublet Model\
\>", "Title",
 CellChangeTimes->{{3.5678552816101*^9, 3.5678553411857243`*^9}, {
  3.567855585658388*^9, 3.567855586280493*^9}, {3.568094017817658*^9, 
  3.568094022181663*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.567855348415655*^9, 3.567855350834606*^9}}],

Cell[CellGroupData[{

Cell["Set the path", "Section",
 CellChangeTimes->{{3.56785531856068*^9, 3.567855344393437*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", " ", "=", " ", 
   RowBox[{
   "SetDirectory", "[", "\"\<<< address of the package >>\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\<<< address of the model file >>\>\"", "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.567862017826684*^9, 3.567862020512813*^9}, {
  3.567862072745294*^9, 3.567862099825725*^9}, {3.568293595866456*^9, 
  3.568293621441877*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{
  3.567862106393355*^9, 3.568032097277495*^9, 3.568093569924898*^9, {
   3.5680938564749527`*^9, 3.5680938787686234`*^9}, 3.568095912005393*^9, 
   3.568096511733856*^9, 3.5682935538776083`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"1.7.134\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"27 January 2013\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "1.7.134", " (" "27 January 2013", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.567862106393355*^9, 3.568032097277495*^9, 3.568093569924898*^9, {
   3.5680938564749527`*^9, 3.5680938787686234`*^9}, 3.568095912005393*^9, 
   3.568096511733856*^9, 3.5682935538810253`*^9}],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{
  3.567862106393355*^9, 3.568032097277495*^9, 3.568093569924898*^9, {
   3.5680938564749527`*^9, 3.5680938787686234`*^9}, 3.568095912005393*^9, 
   3.568096511733856*^9, 3.5682935538841057`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.567862106393355*^9, 3.568032097277495*^9, 3.568093569924898*^9, {
   3.5680938564749527`*^9, 3.5680938787686234`*^9}, 3.568095912005393*^9, 
   3.568096511733856*^9, 3.5682935538873873`*^9}],

Cell[BoxData["\<\"Please cite: Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{
  3.567862106393355*^9, 3.568032097277495*^9, 3.568093569924898*^9, {
   3.5680938564749527`*^9, 3.5680938787686234`*^9}, 3.568095912005393*^9, 
   3.568096511733856*^9, 3.568293553891555*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{
  3.567862106393355*^9, 3.568032097277495*^9, 3.568093569924898*^9, {
   3.5680938564749527`*^9, 3.5680938787686234`*^9}, 3.568095912005393*^9, 
   3.568096511733856*^9, 3.568293553895336*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{
  3.567862106393355*^9, 3.568032097277495*^9, 3.568093569924898*^9, {
   3.5680938564749527`*^9, 3.5680938787686234`*^9}, 3.568095912005393*^9, 
   3.568096511733856*^9, 3.568293553898706*^9}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{
  3.567862106393355*^9, 3.568032097277495*^9, 3.568093569924898*^9, {
   3.5680938564749527`*^9, 3.5680938787686234`*^9}, 3.568095912005393*^9, 
   3.568096511733856*^9, 3.568293553901369*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import the model", "Section",
 CellChangeTimes->{{3.567855368640649*^9, 3.5678553714967747`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadModel", "[", "\"\<2HDM_mix.fr\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$FeynRulesPath", "]"}], ";"}]}], "Input"],

Cell[CellGroupData[{

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.568093884068632*^9, 3.568095917489497*^9, 
  3.568096517242443*^9, 3.568293561865912*^9}],

Cell[BoxData["\<\"K. De Causmaecker\"\>"], "Print",
 CellChangeTimes->{3.568093884068632*^9, 3.568095917489497*^9, 
  3.568096517242443*^9, 3.568293561869576*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0.0\"\>"}],
  SequenceForm["Model Version: ", "1.0.0"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568093884068632*^9, 3.568095917489497*^9, 
  3.568096517242443*^9, 3.56829356187389*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.568093884068632*^9, 3.568095917489497*^9, 
  3.568096517242443*^9, 3.568293561876544*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.568093884068632*^9, 3.568095917489497*^9, 
  3.568096517242443*^9, 3.5682935618804493`*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.568093884068632*^9, 3.568095917489497*^9, 
  3.568096517242443*^9, 3.568293561885044*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.568093884068632*^9, 3.568095917489497*^9, 
  3.568096517242443*^9, 3.5682935620747223`*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.568093884068632*^9, 3.568095917489497*^9, 
  3.568096517242443*^9, 3.5682935620996113`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"2HDM_mix\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "2HDM_mix", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568093884068632*^9, 3.568095917489497*^9, 
  3.568096517242443*^9, 3.568293562174679*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compute the tree level mass matrices", "Section",
 CellChangeTimes->{{3.567855382889579*^9, 3.567855388328291*^9}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Compute all the mass matrices", "Subsection"]], \
"Subsubsection",
 CellChangeTimes->{{3.567855393721282*^9, 3.567855397792397*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComputeTreeLevelMassMatrix", "[", "L2HDM", "]"}]], "Input",
 CellChangeTimes->{{3.568035094618717*^9, 3.568035125565981*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Index expansion ...\"\>"], "Print",
 CellChangeTimes->{{3.568035102003182*^9, 3.568035110486939*^9}, 
   3.568093596316161*^9, {3.568093888110133*^9, 3.568093906582636*^9}, 
   3.568093942054863*^9, 3.56809592057561*^9, 3.568096519641309*^9, 
   3.568293564042506*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  => done in \"\>", "\[InvisibleSpace]", "0.627605`", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["  => done in ", 0.627605, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.568035102003182*^9, 3.568035110486939*^9}, 
   3.568093596316161*^9, {3.568093888110133*^9, 3.568093906582636*^9}, 
   3.568093942054863*^9, 3.56809592057561*^9, 3.568096519641309*^9, 
   3.5682935646694183`*^9}],

Cell[BoxData["\<\"Tree level mass matrix computations achieved. Only the mass \
matrices necessary for the C++ code have been computed.\"\>"], "Print",
 CellChangeTimes->{{3.568035102003182*^9, 3.568035110486939*^9}, 
   3.568093596316161*^9, {3.568093888110133*^9, 3.568093906582636*^9}, 
   3.568093942054863*^9, 3.56809592057561*^9, 3.568096519641309*^9, 
   3.568293565074601*^9}],

Cell[BoxData["\<\"Check FR$MassMatrices for the list of the MixingIDs.\"\>"], \
"Print",
 CellChangeTimes->{{3.568035102003182*^9, 3.568035110486939*^9}, 
   3.568093596316161*^9, {3.568093888110133*^9, 3.568093906582636*^9}, 
   3.568093942054863*^9, 3.56809592057561*^9, 3.568096519641309*^9, 
   3.568293565076906*^9}],

Cell[BoxData["\<\"Use MassMatrix[ MixingID ], GaugeBasis[ MixingID ], \
MassBasis[ MixingID ], BlockName[ MixingID ] and MatrixSymbol[ MixingID ] for \
more information on the results.\"\>"], "Print",
 CellChangeTimes->{{3.568035102003182*^9, 3.568035110486939*^9}, 
   3.568093596316161*^9, {3.568093888110133*^9, 3.568093906582636*^9}, 
   3.568093942054863*^9, 3.56809592057561*^9, 3.568096519641309*^9, 
   3.5682935650794163`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Compute all the mass matrices without generation of the output about the mass \
matrices\
\>", "Subsection",
 CellChangeTimes->{{3.5680352005369177`*^9, 3.568035215142868*^9}, {
  3.56809361626239*^9, 3.568093620750354*^9}}],

Cell[BoxData[
 RowBox[{"ComputeTreeLevelMassMatrix", "[", 
  RowBox[{"L2HDM", ",", " ", 
   RowBox[{"ScreenOutput", "\[Rule]", " ", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.568035137500168*^9, 3.568035158886353*^9}}],

Cell[CellGroupData[{

Cell[TextData[StyleBox["Compute only the mass matrix of mixing of the neutral \
Higgses (1s)", "Subsection"]], "Subsubsection",
 CellChangeTimes->{{3.5678554211273003`*^9, 3.567855435470812*^9}, {
  3.568093674230916*^9, 3.568093681100155*^9}, {3.5680937152983913`*^9, 
  3.568093723634061*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComputeTreeLevelMassMatrix", "[", 
  RowBox[{"L2HDM", ",", " ", 
   RowBox[{"Mix", "\[Rule]", "\"\<1s\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.568032145034424*^9, 3.568032146074194*^9}, {
  3.568093642312999*^9, 3.5680936439442167`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Index expansion ...\"\>"], "Print",
 CellChangeTimes->{3.568032146920103*^9, 3.568093699459681*^9, 
  3.5680939136317167`*^9, 3.5680939682239017`*^9, 3.568095927447856*^9, 
  3.568096567491313*^9, 3.568293571684527*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  => done in \"\>", "\[InvisibleSpace]", "0.6513780000000002`",
    "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["  => done in ", 0.6513780000000002, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568032146920103*^9, 3.568093699459681*^9, 
  3.5680939136317167`*^9, 3.5680939682239017`*^9, 3.568095927447856*^9, 
  3.568096567491313*^9, 3.5682935723352137`*^9}],

Cell[BoxData["\<\"Computation of the tree level mass matrix for the mixing id \
1s achieved.\"\>"], "Print",
 CellChangeTimes->{3.568032146920103*^9, 3.568093699459681*^9, 
  3.5680939136317167`*^9, 3.5680939682239017`*^9, 3.568095927447856*^9, 
  3.568096567491313*^9, 3.568293572505595*^9}],

Cell[BoxData["\<\"For the results, use MassMatrix[ 1s ], GaugeBasis[ 1s ], \
MassBasis[ 1s ], BlockName [ 1s ] and MatrixSymbol [ 1s ].\"\>"], "Print",
 CellChangeTimes->{3.568032146920103*^9, 3.568093699459681*^9, 
  3.5680939136317167`*^9, 3.5680939682239017`*^9, 3.568095927447856*^9, 
  3.568096567491313*^9, 3.5682935725091248`*^9}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"mu1", "+", 
       RowBox[{"3", " ", "lambda1", " ", 
        SuperscriptBox["vev1", "2"]}]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "mu3"}], "+", 
         RowBox[{"3", " ", "lambda6", " ", 
          SuperscriptBox["vev1", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["vev1", "2"], " ", 
          SuperscriptBox["lambda6", "\<\"*\"\>"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["mu3", "\<\"*\"\>"]}]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "mu3"}], "+", 
         RowBox[{"3", " ", "lambda6", " ", 
          SuperscriptBox["vev1", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["vev1", "2"], " ", 
          SuperscriptBox["lambda6", "\<\"*\"\>"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["mu3", "\<\"*\"\>"]}]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "mu3"}], "+", 
         RowBox[{"3", " ", "lambda6", " ", 
          SuperscriptBox["vev1", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["vev1", "2"], " ", 
          SuperscriptBox["lambda6", "\<\"*\"\>"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["mu3", "\<\"*\"\>"]}]}], ")"}]}], 
      RowBox[{"mu2", "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"lambda3", "+", "lambda4", "+", 
          RowBox[{"2", " ", "lambda5"}]}], ")"}], " ", 
        SuperscriptBox["vev1", "2"]}]}], "0"},
     {
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "mu3"}], "+", 
         RowBox[{"3", " ", "lambda6", " ", 
          SuperscriptBox["vev1", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["vev1", "2"], " ", 
          SuperscriptBox["lambda6", "\<\"*\"\>"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["mu3", "\<\"*\"\>"]}]}], ")"}]}], "0", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "mu2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"lambda3", "+", "lambda4", "-", 
            RowBox[{"2", " ", "lambda5"}]}], ")"}], " ", 
          SuperscriptBox["vev1", "2"]}]}], ")"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.568032146920103*^9, 3.568093699459681*^9, 
  3.5680939136317167`*^9, 3.5680939682239017`*^9, 3.568095927447856*^9, 
  3.568096567491313*^9, 3.5682935725637627`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Ask for all the information about the mixing of the neutral Higgses (1s)\
\>", "Subsection",
 CellChangeTimes->{{3.56785545031773*^9, 3.567855460702108*^9}, {
  3.568093685467507*^9, 3.568093729338764*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MixingSummary", "[", "\"\<1s\>\"", "]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Gauge basis = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"H0", ",", "R0", ",", "I0"}], "}"}]}],
  SequenceForm[
  "Gauge basis = ", {$CellContext`H0, $CellContext`R0, $CellContext`I0}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5680937028476753`*^9, {3.568093956653385*^9, 3.568093971205803*^9}, 
   3.568095930253375*^9, {3.568096552576515*^9, 3.5680965701244593`*^9}, 
   3.568293574230373*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Mass basis = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"h1", ",", "h2", ",", "h3"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\nBlock = \"\>", "\[InvisibleSpace]", "NHMIX", 
   "\[InvisibleSpace]", "\<\"\\nSymbol = \"\>", "\[InvisibleSpace]", "NH"}],
  SequenceForm[
  "Mass basis = ", {$CellContext`h1, $CellContext`h2, $CellContext`h3}, 
   "\nBlock = ", $CellContext`NHMIX, "\nSymbol = ", $CellContext`NH],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5680937028476753`*^9, {3.568093956653385*^9, 3.568093971205803*^9}, 
   3.568095930253375*^9, {3.568096552576515*^9, 3.5680965701244593`*^9}, 
   3.5682935742319736`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared mass matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{"mu1", "+", 
         RowBox[{"3", " ", "lambda1", " ", 
          SuperscriptBox["vev1", "2"]}]}], 
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "mu3"}], "+", 
           RowBox[{"3", " ", "lambda6", " ", 
            SuperscriptBox["vev1", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["vev1", "2"], " ", 
            SuperscriptBox["lambda6", "\<\"*\"\>"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["mu3", "\<\"*\"\>"]}]}], ")"}]}], 
        RowBox[{
         FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "mu3"}], "+", 
           RowBox[{"3", " ", "lambda6", " ", 
            SuperscriptBox["vev1", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["vev1", "2"], " ", 
            SuperscriptBox["lambda6", "\<\"*\"\>"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["mu3", "\<\"*\"\>"]}]}], ")"}]}]},
       {
        RowBox[{
         FractionBox["1", "4"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "mu3"}], "+", 
           RowBox[{"3", " ", "lambda6", " ", 
            SuperscriptBox["vev1", "2"]}], "+", 
           RowBox[{"3", " ", 
            SuperscriptBox["vev1", "2"], " ", 
            SuperscriptBox["lambda6", "\<\"*\"\>"]}], "+", 
           RowBox[{"2", " ", 
            SuperscriptBox["mu3", "\<\"*\"\>"]}]}], ")"}]}], 
        RowBox[{"mu2", "+", 
         RowBox[{
          FractionBox["1", "2"], " ", 
          RowBox[{"(", 
           RowBox[{"lambda3", "+", "lambda4", "+", 
            RowBox[{"2", " ", "lambda5"}]}], ")"}], " ", 
          SuperscriptBox["vev1", "2"]}]}], "0"},
       {
        RowBox[{
         FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "mu3"}], "+", 
           RowBox[{"3", " ", "lambda6", " ", 
            SuperscriptBox["vev1", "2"]}], "-", 
           RowBox[{"3", " ", 
            SuperscriptBox["vev1", "2"], " ", 
            SuperscriptBox["lambda6", "\<\"*\"\>"]}], "-", 
           RowBox[{"2", " ", 
            SuperscriptBox["mu3", "\<\"*\"\>"]}]}], ")"}]}], "0", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", "mu2"}], "+", 
           RowBox[{
            RowBox[{"(", 
             RowBox[{"lambda3", "+", "lambda4", "-", 
              RowBox[{"2", " ", "lambda5"}]}], ")"}], " ", 
            SuperscriptBox["vev1", "2"]}]}], ")"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["Squared mass matrix = ", 
   MatrixForm[{{
     FeynRules`mu1 + 3 $CellContext`lambda1 $CellContext`vev1^2, 
      Rational[1, 4] (2 $CellContext`mu3 + 
       3 $CellContext`lambda6 $CellContext`vev1^2 + 
       3 $CellContext`vev1^2 Conjugate[$CellContext`lambda6] + 
       2 Conjugate[$CellContext`mu3]), Complex[0, 
        Rational[1, 4]] (2 $CellContext`mu3 + 
       3 $CellContext`lambda6 $CellContext`vev1^2 - 3 $CellContext`vev1^2 
       Conjugate[$CellContext`lambda6] - 2 Conjugate[$CellContext`mu3])}, {
     Rational[1, 4] (2 $CellContext`mu3 + 
       3 $CellContext`lambda6 $CellContext`vev1^2 + 
       3 $CellContext`vev1^2 Conjugate[$CellContext`lambda6] + 
       2 Conjugate[$CellContext`mu3]), FeynRules`mu2 + 
      Rational[1, 2] ($CellContext`lambda3 + $CellContext`lambda4 + 
        2 $CellContext`lambda5) $CellContext`vev1^2, 0}, {Complex[0, 
        Rational[1, 4]] (2 $CellContext`mu3 + 
       3 $CellContext`lambda6 $CellContext`vev1^2 - 3 $CellContext`vev1^2 
       Conjugate[$CellContext`lambda6] - 2 Conjugate[$CellContext`mu3]), 0, 
      Rational[1, 2] (
       2 FeynRules`mu2 + ($CellContext`lambda3 + $CellContext`lambda4 - 
         2 $CellContext`lambda5) $CellContext`vev1^2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5680937028476753`*^9, {3.568093956653385*^9, 3.568093971205803*^9}, 
   3.568095930253375*^9, {3.568096552576515*^9, 3.5680965701244593`*^9}, 
   3.568293574234605*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"The mixing matrix = \"\>", "\[InvisibleSpace]", 
   TagBox["\<\"Please use the numerical code.\"\>",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["The mixing matrix = ", 
   MatrixForm["Please use the numerical code."]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.5680937028476753`*^9, {3.568093956653385*^9, 3.568093971205803*^9}, 
   3.568095930253375*^9, {3.568096552576515*^9, 3.5680965701244593`*^9}, 
   3.568293574237418*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Write the ASperGE package", "Section",
 CellChangeTimes->{{3.567855490212146*^9, 3.5678554958361464`*^9}}],

Cell[CellGroupData[{

Cell["\<\
Write the output for all mass matrices to the folder \
\[OpenCurlyQuote]2HDM_mix_MD\[CloseCurlyQuote] in $FeynRulesPath\
\>", "Subsection",
 CellChangeTimes->{{3.568035248605268*^9, 3.5680352719368563`*^9}, {
  3.568035342262802*^9, 3.568035362863311*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteASperGe", "[", "L2HDM", "]"}]], "Input",
 CellChangeTimes->{{3.568035279856433*^9, 3.568035287557234*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Parameters.cpp and Parameters.hpp output is finished.\\n \
They have been stored in /Users/Karen/trunk/feynrules-development/2HDM_mix_MD\
\"\>"], "Print",
 CellChangeTimes->{3.5682935784949207`*^9}],

Cell[BoxData["\<\"Checking parameter list...\"\>"], "Print",
 CellChangeTimes->{3.5682935785269203`*^9}],

Cell[BoxData["\<\"Warning: Ghost fields will be ignored.\"\>"], "Print",
 CellChangeTimes->{3.568293578529491*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Output written on \"\>", 
   "\[InvisibleSpace]", "\<\"input/externals.dat\"\>"}],
  SequenceForm["Output written on ", "input/externals.dat"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568293578531893*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Write the output to the folder \[OpenCurlyQuote]2HDM\[CloseCurlyQuote] in \
$FeynRulesPath only for the mixing \[OpenCurlyQuote]1s\[CloseCurlyQuote]
For mutliple mixings use e.g. Mix -> {\[OpenCurlyDoubleQuote]1s\
\[CloseCurlyDoubleQuote], \[OpenCurlyDoubleQuote]2s\[CloseCurlyDoubleQuote]}\
\>", "Subsection",
 CellChangeTimes->{{3.568035291371396*^9, 3.56803531000459*^9}, {
  3.5680353661825333`*^9, 3.568035413797114*^9}, {3.5680934954740963`*^9, 
  3.568093532566071*^9}, {3.568096444862878*^9, 3.568096445036433*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteASperGe", "[", 
  RowBox[{"L2HDM", ",", " ", 
   RowBox[{"Output", "\[Rule]", "\"\<2HDM\>\""}], ",", " ", 
   RowBox[{"Mix", "\[Rule]", "\"\<1s\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.568035418086753*^9, 3.5680354407144623`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{"mu1", "+", 
       RowBox[{"3", " ", "lambda1", " ", 
        SuperscriptBox["vev1", "2"]}]}], 
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "mu3"}], "+", 
         RowBox[{"3", " ", "lambda6", " ", 
          SuperscriptBox["vev1", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["vev1", "2"], " ", 
          SuperscriptBox["lambda6", "\<\"*\"\>"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["mu3", "\<\"*\"\>"]}]}], ")"}]}], 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "mu3"}], "+", 
         RowBox[{"3", " ", "lambda6", " ", 
          SuperscriptBox["vev1", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["vev1", "2"], " ", 
          SuperscriptBox["lambda6", "\<\"*\"\>"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["mu3", "\<\"*\"\>"]}]}], ")"}]}]},
     {
      RowBox[{
       FractionBox["1", "4"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "mu3"}], "+", 
         RowBox[{"3", " ", "lambda6", " ", 
          SuperscriptBox["vev1", "2"]}], "+", 
         RowBox[{"3", " ", 
          SuperscriptBox["vev1", "2"], " ", 
          SuperscriptBox["lambda6", "\<\"*\"\>"]}], "+", 
         RowBox[{"2", " ", 
          SuperscriptBox["mu3", "\<\"*\"\>"]}]}], ")"}]}], 
      RowBox[{"mu2", "+", 
       RowBox[{
        FractionBox["1", "2"], " ", 
        RowBox[{"(", 
         RowBox[{"lambda3", "+", "lambda4", "+", 
          RowBox[{"2", " ", "lambda5"}]}], ")"}], " ", 
        SuperscriptBox["vev1", "2"]}]}], "0"},
     {
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "mu3"}], "+", 
         RowBox[{"3", " ", "lambda6", " ", 
          SuperscriptBox["vev1", "2"]}], "-", 
         RowBox[{"3", " ", 
          SuperscriptBox["vev1", "2"], " ", 
          SuperscriptBox["lambda6", "\<\"*\"\>"]}], "-", 
         RowBox[{"2", " ", 
          SuperscriptBox["mu3", "\<\"*\"\>"]}]}], ")"}]}], "0", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", "mu2"}], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{"lambda3", "+", "lambda4", "-", 
            RowBox[{"2", " ", "lambda5"}]}], ")"}], " ", 
          SuperscriptBox["vev1", "2"]}]}], ")"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.568293581864567*^9}],

Cell[BoxData["\<\"Parameters.cpp and Parameters.hpp output is finished.\\n \
They have been stored in /Users/Karen/trunk/feynrules-development/2HDM\"\>"], \
"Print",
 CellChangeTimes->{3.568293581978196*^9}],

Cell[BoxData["\<\"Checking parameter list...\"\>"], "Print",
 CellChangeTimes->{3.568293582003612*^9}],

Cell[BoxData["\<\"Warning: Ghost fields will be ignored.\"\>"], "Print",
 CellChangeTimes->{3.568293582005931*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Output written on \"\>", 
   "\[InvisibleSpace]", "\<\"input/externals.dat\"\>"}],
  SequenceForm["Output written on ", "input/externals.dat"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568293582008362*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Compile and excecute ASperGe and
load the output file back into FeynRules\
\>", "Section",
 CellChangeTimes->{{3.5678555212604*^9, 3.567855543609857*^9}}],

Cell[BoxData[
 RowBox[{"RunASperGe", "[", "]"}]], "Input",
 CellChangeTimes->{{3.56785554597211*^9, 3.567855549491005*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{740, 656},
WindowMargins->{{Automatic, 26}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (August 26, \
2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 225, 6, 123, "Title"],
Cell[807, 30, 118, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[950, 36, 96, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[1071, 41, 521, 13, 58, "Input"],
Cell[CellGroupData[{
Cell[1617, 58, 264, 4, 20, "Print"],
Cell[1884, 64, 545, 11, 20, "Print"],
Cell[2432, 77, 316, 5, 20, "Print"],
Cell[2751, 84, 250, 4, 20, "Print"],
Cell[3004, 90, 318, 5, 20, "Print"],
Cell[3325, 97, 278, 4, 20, "Print"],
Cell[3606, 103, 248, 4, 20, "Print"],
Cell[3857, 109, 315, 5, 20, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[4233, 121, 103, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[4361, 126, 200, 5, 43, "Input"],
Cell[CellGroupData[{
Cell[4586, 135, 185, 2, 20, "Print"],
Cell[4774, 139, 162, 2, 20, "Print"],
Cell[4939, 143, 294, 6, 20, "Print"],
Cell[5236, 151, 193, 3, 20, "Print"],
Cell[5432, 156, 147, 2, 20, "Print"],
Cell[5582, 160, 175, 2, 20, "Print"],
Cell[5760, 164, 180, 2, 20, "Print"],
Cell[5943, 168, 178, 2, 20, "Print"],
Cell[6124, 172, 345, 7, 36, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[6530, 186, 121, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[6676, 191, 156, 2, 26, "Subsubsection"],
Cell[CellGroupData[{
Cell[6857, 197, 149, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[7031, 203, 286, 4, 20, "Print"],
Cell[7320, 209, 471, 9, 20, "Print"],
Cell[7794, 220, 384, 5, 36, "Print"],
Cell[8181, 227, 321, 5, 20, "Print"],
Cell[8505, 234, 435, 6, 51, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9001, 247, 234, 5, 34, "Subsection"],
Cell[9238, 254, 227, 4, 27, "Input"],
Cell[CellGroupData[{
Cell[9490, 262, 295, 4, 26, "Subsubsection"],
Cell[CellGroupData[{
Cell[9810, 270, 269, 5, 27, "Input"],
Cell[CellGroupData[{
Cell[10104, 279, 237, 3, 20, "Print"],
Cell[10344, 284, 442, 8, 20, "Print"],
Cell[10789, 294, 292, 4, 20, "Print"],
Cell[11084, 300, 337, 4, 36, "Print"],
Cell[11424, 306, 3272, 89, 80, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14769, 403, 216, 4, 34, "Subsection"],
Cell[CellGroupData[{
Cell[15010, 411, 75, 1, 27, "Input"],
Cell[CellGroupData[{
Cell[15110, 416, 472, 11, 20, "Print"],
Cell[15585, 429, 696, 14, 51, "Print"],
Cell[16284, 445, 4803, 115, 80, "Print"],
Cell[21090, 562, 521, 12, 20, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[21684, 582, 112, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[21821, 587, 266, 5, 35, "Subsection"],
Cell[CellGroupData[{
Cell[22112, 596, 135, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[22272, 602, 216, 3, 36, "Print"],
Cell[22491, 607, 104, 1, 20, "Print"],
Cell[22598, 610, 114, 1, 20, "Print"],
Cell[22715, 613, 264, 6, 20, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[23040, 626, 533, 8, 50, "Subsection"],
Cell[CellGroupData[{
Cell[23598, 638, 267, 5, 27, "Input"],
Cell[CellGroupData[{
Cell[23890, 647, 3128, 87, 80, "Print"],
Cell[27021, 736, 207, 3, 36, "Print"],
Cell[27231, 741, 102, 1, 20, "Print"],
Cell[27336, 744, 114, 1, 20, "Print"],
Cell[27453, 747, 264, 6, 20, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[27790, 761, 164, 4, 89, "Section"],
Cell[27957, 767, 123, 2, 27, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
