(* *********************************************************** *)
(* *****                                                 ***** *)
(* *****  FeynRules model file: LRSM w/Higgs triplets    ***** *)
(* *****  Authors: A. Alloul, B. Fuks                    ***** *)
(* *****                                                 ***** *)
(* *********************************************************** *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "LRSM";

M$Information = { 
 Authors -> {"Adam Alloul", "Benjamin Fuks", "Michel Rausch de Traubenberg"}, 
 Emails -> {"adam.alloul@iphc.cnrs.fr", "benjamin.fuks@iphc.cnrs.fr","michel.rausch@iphc.cnrs.fr"}, 
 Institutions -> {"IPHC Strasbourg / University of Strasbourg"}, 
 Date -> "02.01.13", Version->"1.05", References -> "A. Alloul, K. De Causmaecker, J. D'Hondt, B. Fuks, M. Rausch de Traubenberg, EPJC (2013), arXiv: 1301.5932 [hep-ph]", URLs -> "https://feynrules.irmp.ucl.ac.be/raw-attachment/wiki/ASperGe/LRSM_mix.fr" 
};

(* Change log *)
(* v1.05 02.01.13 : Fixed mixings in neutrinos sector *)
(* v1.05 02.01.13 : Added yl2 and corrected a sign in the higgs potential *)
(* v1.04 22.01.13 : Added yq2 to the yukawa lagrangian *)
(* v1.03 22.01.13 : Fixed mixing relations for quarks and leptons and added the square for mu1 and mu2 in scalar pot *)
(* v1.02 22.11.12 : Added the minimization equations for the bilinear terms *)
(* v1.01 15.11.12 : minus instead of a plus in front of the kinetic terms of the higgses -> corrected *) 
(*Remove the epsilons in the yukawa*)

(* ************************** *)
(* *****  Gauge groups  ***** *)
(* ************************** *)
M$GaugeGroups = {
 U1BL == { Abelian -> True,  CouplingConstant -> gBL, GaugeBoson -> B, Charge->YBL },
 SU2L == { Abelian -> False, CouplingConstant -> gL,  GaugeBoson -> WLi, StructureConstant -> epL, Representations -> {TL,SU2DL}, 
   Definitions -> {TL[Index[SU2WL,a_],b__]->PauliSigma[Index[SU2WL,a],b]/2, epL->Eps} },  
 SU2R == { Abelian -> False, CouplingConstant -> gR,  GaugeBoson -> WRi, StructureConstant -> epR, Representations -> {TR,SU2DR}, 
   Definitions -> {TR[Index[SU2WR,a_],i_,j_]->-PauliSigma[Index[SU2WR,a],j,i]/2, epR->Eps} },
 SU3C == { Abelian -> False, CouplingConstant -> gs,  GaugeBoson -> G,   StructureConstant -> f,   Representations -> {T,Colour} }
};


(* ************************** *)
(* *** Interaction orders *** *)
(* ************************** *)
M$InteractionOrderHierarchy = { {QCD, 1}, {QED, 2} };


(* ************************** *)
(* ***** vevs & mixings ***** *)
(* ************************** *)

M$vevs = { {hL[1], vL/Sqrt[2]},	{hL[2], -I vL/Sqrt[2]}, {hR[1], vR/Sqrt[2]}, {hR[2], -I*vR/Sqrt[2]}, {DeltaL0, vL}, {DeltaR0, vR}, {h1[1,1], v1}, {h1[2,2], v1p} };
	

M$MixingsDescription={

(* *********************************************************** *)
(* ****                     Gauge Bosons                  **** *)
(* *********************************************************** *)	
(* First step: from triplet to T3 eigenstates *)
 Mix["1a"] == { MassBasis -> {WL, WLbar}, GaugeBasis -> {WLi[1], WLi[2]}, Value -> {{1/Sqrt[2], -I/Sqrt[2]}, {1/Sqrt[2], I/Sqrt[2]}} },
 Mix["1b"] == { MassBasis -> {WR, WRbar}, GaugeBasis -> {WRi[1], WRi[2]}, Value -> {{1/Sqrt[2], -I/Sqrt[2]}, {1/Sqrt[2], I/Sqrt[2]}} },

(* Second step: from T3 eigenstates to mass-eigenstates *)
 Mix["1c"] == { MassBasis -> {A, Z, Zp}, GaugeBasis -> {WLi[3], WRi[3], B}, MixingMatrix->UVN, BlockName->VNMix},
 Mix["1d"] == { MassBasis -> {W, Wp},    GaugeBasis -> {WL, WR},            MixingMatrix->UVC, BlockName->VCMix},

(* *********************************************************** *)
(* ****                       Higgses                     **** *)
(* *********************************************************** *)	
(* First step: from triplet to T3 eigenstates *)
 Mix["2a"] == { MassBasis -> {DeltaLpp,DeltaL0}, GaugeBasis -> {hL[1],hL[2]}, Value -> { {1/Sqrt[2],-I/Sqrt[2]},{1/Sqrt[2],I/Sqrt[2]} }},
 Mix["2b"] == { MassBasis -> {DeltaRpp,DeltaR0}, GaugeBasis -> {hR[1],hR[2]}, Value -> { {1/Sqrt[2],-I/Sqrt[2]},{1/Sqrt[2],I/Sqrt[2]} }},

(* Second step: from T3 eigenstates to mass-eigenstates *)
 Mix["2c"] == { MassBasis -> {DH1,DH2}, GaugeBasis -> {DeltaLpp,DeltaRpp}, MixingMatrix->UHD, BlockName->HDMix},
 Mix["2d"] == { MassBasis -> {GP1,GP2,H1,H2}, GaugeBasis -> {hL[3],hR[3],h1[1,2], h1bar[2,1]}, MixingMatrix->UHC, BlockName -> HCMix},
 Mix["2e"] == { MassBasis -> {{h01,h02,h03,h04},{G01,G02,a01,a02}}, GaugeBasis->{DeltaL0,DeltaR0,h1[1,1],h1[2,2]}, MixingMatrix->{UHN,UAN}, BlockName->{HMix,AMix}},

(* *********************************************************** *)
(* ****                       Fermions                    **** *)
(* *********************************************************** *)	

 Mix["4a"] == {MassBasis -> {dq[1, _], dq[2, _], dq[3, _]}, GaugeBasis -> {{QL[2, 1, _], QL[2, 2, _], QL[2, 3, _]}, {CC[QR][2,1, _], CC[QR][2,2, _], CC[QR][2,3, _]}}, 
               MixingMatrix -> {CKML, CKMR}, BlockName->{VCKML,VCKMR}, Inverse -> {True,True} },

 Mix["4b"] == {MassBasis -> {uq[1, _], uq[2, _], uq[3, _]}, GaugeBasis -> {{QL[1, 1, _], QL[1, 2, _], QL[1, 3, _]}, {CC[QR][1,1, _], CC[QR][1,2, _], CC[QR][1,3, _]}}, 
                 Value -> {{{1,0,0},{0,1,0},{0,0,1}},{{1,0,0},{0,1,0},{0,0,1}}}},

 Mix["5a"] == {MassBasis -> {l[1], l[2], l[3]}, GaugeBasis -> {{LL[2, 1], LL[2, 2], LL[2, 3]}, {CC[LR][2,1], CC[LR][2,2], CC[LR][2,3]}},
                 Value -> {{{1,0,0},{0,1,0},{0,0,1}},{{1,0,0},{0,1,0},{0,0,1}}}},  

 Mix["5b"] == {MassBasis -> {vl[1], vl[2], vl[3],Nl[1], Nl[2],Nl[3]}, 
               GaugeBasis -> {{LL[1, 1], LL[1, 2], LL[1, 3],LR[1,1],LR[1,2],LR[1,3]},
                              {CC[LL][1, 1], CC[LL][1, 2], CC[LL][1, 3],CC[LR][1, 1], CC[LR][1, 2], CC[LR][1, 3]}     }, 
               MixingMatrix -> {PMNSL, PMNSR}, BlockName -> {PMNSMIX, PMNSRMIX}} 
  
};



(* ************************** *)
(* *****    Indices     ***** *)
(* ************************** *)
(* Gauge indices *)
IndexRange[Index[SU2WL]]   = Unfold[Range[3]];   IndexStyle[SU2WL,j];
IndexRange[Index[SU2WR]]   = Unfold[Range[3]];   IndexStyle[SU2WR,j];   
IndexRange[Index[SU2DL]]   = Unfold[Range[2]];   IndexStyle[SU2DL,k];   
IndexRange[Index[SU2DR]]   = Unfold[Range[2]];   IndexStyle[SU2DR,k];   
IndexRange[Index[Gluon ]]  = NoUnfold[Range[8]]; IndexStyle[Gluon, a];  
IndexRange[Index[Colour ]] = NoUnfold[Range[3]]; IndexStyle[Colour, m]; 

(* "Generation" indices *)
IndexRange[Index[GEN ]] = Range[3]; IndexStyle[GEN, f];
IndexRange[Index[SHIG]] = Range[4]; IndexStyle[SHIG,n];
IndexRange[Index[PHIG]] = Range[2]; IndexStyle[PHIG,n];
IndexRange[Index[CHIG]] = Range[2]; IndexStyle[CHIG,n];
IndexRange[Index[DHIG]] = Range[2]; IndexStyle[DHIG,n]; 


(* ************************** *)
(* *****     Fields     ***** *)
(* ************************** *)
M$ClassesDescription = {
	
(* *********************************************************** *)
(* ****              Unphysical Gauge Bosons              **** *)
(* *********************************************************** *)	
(* SU(2) triplets and U(1) *)
 V[11] == { ClassName->B,   Unphysical->True, SelfConjugate->True },            
 V[12] == { ClassName->WLi, Unphysical->True, SelfConjugate->True, Indices->{Index[SU2WL]}, FlavorIndex->SU2WL},                            
 V[13] == { ClassName->WRi, Unphysical->True, SelfConjugate->True, Indices->{Index[SU2WR]}, FlavorIndex->SU2WR},
(* T3 eigenstates *)
 V[22] == { ClassName->WL,  Unphysical->True, SelfConjugate->False},                            
 V[23] == { ClassName->WR,  Unphysical->True, SelfConjugate->False},

(* *********************************************************** *)
(* ****               Physical Gauge Bosons               **** *)
(* *********************************************************** *)
(* Neutral weak bosons *)
 V[1] == { ClassName->A,  SelfConjugate->True,  Mass->0,   Width->0,   ParticleName->"a",   PDG->22, PropagatorLabel->"A",  PropagatorType->Sine, PropagatorArrow->None},
 V[2] == { ClassName->Z,  SelfConjugate->True,  Mass->MZ,  Width->WZ,  ParticleName->"Z",   PDG->23, PropagatorLabel->"Z", PropagatorType->Sine, PropagatorArrow->None},
 V[3] == { ClassName->Zp, SelfConjugate->True,  Mass->MZp, Width->WZp, ParticleName->"Zp",  PDG->32, PropagatorLabel->"Zp", PropagatorType->Sine, PropagatorArrow->None},
(* Charge weak bosons *)
 V[4] == { ClassName->W,  SelfConjugate->False, Mass->MW,  Width->WW,  ParticleName->"W+",  PDG->24, PropagatorLabel->"W", PropagatorType->Sine, 
    PropagatorArrow->Forward, AntiParticleName->"W-",  QuantumNumbers->{Q->1} },
 V[5] == { ClassName->Wp, SelfConjugate->False, Mass->MWp, Width->WWp, ParticleName->"Wp+", PDG->34, PropagatorLabel->"Wp", PropagatorType->Sine, 
    PropagatorArrow->Forward, AntiParticleName->"Wp-", QuantumNumbers->{Q->1} },
(* QCD *)
 V[6] == { ClassName->G,  SelfConjugate->True,  Mass->0,   Width->0,   ParticleName->"g",   PDG->21, PropagatorLabel->"G", PropagatorType->C,    PropagatorArrow->None, 
    Indices->{Index[Gluon]} },

(* *********************************************************** *)
(* ****                 Unphysical higgses                **** *)
(* *********************************************************** *)
(* Bidoublets, triplets, singlet *)
S[21] == { ClassName->h1, Unphysical->True, SelfConjugate->False, Indices->{Index[SU2DL],Index[SU2DR]}, FlavorIndex->SU2DL},
S[22] == { ClassName->hL, Unphysical->True, SelfConjugate->False, Indices->{Index[SU2WL]}, FlavorIndex->SU2WL, QuantumNumbers->{YBL->1} },              
S[23] == { ClassName->hR, Unphysical->True, SelfConjugate->False, Indices->{Index[SU2WR]}, FlavorIndex->SU2WR, QuantumNumbers->{YBL->1} },

(* T3 eigenstates for the triplets *)
S[221] == { ClassName -> DeltaL0, Unphysical -> True, SelfConjugate -> False}, 
S[222] == { ClassName -> DeltaLpp, Unphysical -> True, SelfConjugate -> False}, 
S[231] == { ClassName -> DeltaR0, Unphysical -> True, SelfConjugate -> False}, 
S[232] == { ClassName -> DeltaRpp, Unphysical -> True, SelfConjugate -> False}, 

(* *********************************************************** *)
(* ****                   Physical higgses                **** *)
(* *********************************************************** *)
(* Four neutral scalars*)
 S[1] == { ClassName->h0, SelfConjugate->True, Indices->{Index[SHIG]}, FlavorIndex->SHIG, ClassMembers->{h01,h02,h03,h04}, 
   Mass->{Mh0,Mh01,Mh02,Mh03,Mh04}, Width->{Wh01,Wh02,Wh03,Wh04,Wh05}, PDG->{25,35,45,9000025}, 
   ParticleName->{"h01","h02","h03","h04"}, PropagatorLabel->{"h0","h01","h02","h03","h04"}, PropagatorType->ScalarDash, PropagatorArrow->None},

(*Two neutral pseudoscalars*)
 S[2] == { ClassName->a0, SelfConjugate->True, Indices->{Index[PHIG]}, FlavorIndex->PHIG, ClassMembers->{a01,a02}, 
   Mass->{MA0,MA01}, Width->{WA01,WA02}, PDG->{36,46}, 
   ParticleName->{"a01","a02"}, PropagatorLabel->{"a0","a01","a02"}, PropagatorType->ScalarDash,  PropagatorArrow->None},

(*Two singly charged*)            
 S[3] == { ClassName->H, SelfConjugate->False, Indices->{Index[CHIG]}, FlavorIndex->CHIG, ClassMembers->{H1,H2}, 
   Mass->{MH,MH1,MH2}, Width->{WH1,WH2}, PDG->{37,9000037}, QuantumNumbers->{Q-> 1}, 
   ParticleName->{"H1+","H2+"}, AntiParticleName->{"H1-","H2-"}, PropagatorLabel->{"H","H1","H2"}, PropagatorType->ScalarDash, PropagatorArrow->Forward },

(*Two doubly charged*)            
 S[4] == { ClassName->DH, SelfConjugate->False, Indices->{Index[DHIG]}, FlavorIndex->DHIG, ClassMembers->{DH1,DH2}, 
   Mass->{MDH,MDH1,MDH2}, Width->{WDH1,WDH2}, PDG->{9000055,9000056}, QuantumNumbers->{Q-> 2}, 
   ParticleName->{"H1++","H2++"}, AntiParticleName->{"H1--","H2--"}, PropagatorLabel->{"DH","DH1","DH2"}, PropagatorType->ScalarDash, PropagatorArrow->Forward},

(* Goldstones *)
 S[10] == { ClassName->G01, SelfConjugate->True, Goldstone->Z, Mass->MZ, Width->WG01, PDG->250,
   ParticleName->"G01", PropagatorLabel->"G01", PropagatorType->D, PropagatorArrow->None },
 S[11] == { ClassName->G02, SelfConjugate->True, Goldstone->Zp, Mass->MZp, Width->WG02, PDG->251,
   ParticleName->"G02", PropagatorLabel->"G02", PropagatorType->D, PropagatorArrow->None },
 S[12] == { ClassName->GP1, SelfConjugate->False, Goldstone->W, Mass->MW, Width->WGP1, PDG->252, QuantumNumbers->{Q->1}, 
   ParticleName -> "G1+", AntiParticleName->"G1-", PropagatorLabel->"GP1", PropagatorType->D, PropagatorArrow->None },
 S[13] == { ClassName->GP2, SelfConjugate->False, Goldstone->Wp, Mass->MWp, Width->WGP2, PDG->253, QuantumNumbers->{Q->1}, 
   ParticleName -> "G2+", AntiParticleName->"G2-", PropagatorLabel->"GP2", PropagatorType->D, PropagatorArrow->None },



(* *********************************************************** *)
(* ****              Unphysical Dirac Fermions            **** *)
(* *********************************************************** *)
F[31] == { ClassName->LL, Unphysical->True, SelfConjugate->False, Indices->{Index[SU2DL],Index[GEN]},                FlavorIndex->SU2DL, QuantumNumbers->{YBL->-1/2} },
F[32] == { ClassName->LR, Unphysical->True, SelfConjugate->False, Indices->{Index[SU2DR],Index[GEN]},                FlavorIndex->SU2DR, QuantumNumbers->{YBL-> 1/2} },
F[13] == { ClassName->QL, Unphysical->True, SelfConjugate->False, Indices->{Index[SU2DL],Index[GEN],Index[Colour ]}, FlavorIndex->SU2DL, QuantumNumbers->{YBL -> 1/6}},
F[34] == { ClassName->QR, Unphysical->True, SelfConjugate->False, Indices->{Index[SU2DR],Index[GEN],Index[Colour]},  FlavorIndex->SU2DR, QuantumNumbers->{YBL-> -1/6}},



(* *********************************************************** *)
(* ****               Physical Dirac Fermions             **** *)
(* *********************************************************** *)

 F[5] == { ClassName->vl, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, ParticleName->{"ve","vm","vt"}, AntiParticleName->{"ve~","vm~","vt~"},
           ClassMembers->{ve,vm,vt}, Mass->{Mvl,Mve,Mvm,Mvt}, Width->0, PDG->{12,14,16}, PropagatorLabel->{"v","ve","vm","vt"}, PropagatorType->Straight, PropagatorArrow->Forward},

 F[6] == { ClassName->Nl, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, ParticleName->{"Ne","Nm","Nt"}, AntiParticleName->{"Ne~","Nm~","Nt~"},
           ClassMembers->{Ne,Nm,Nt}, Mass->{MNl,MNe,MNm,MNt}, Width->{WNl,WNe,WNm,WNt}, PDG->{6000012,6000014,6000016}, PropagatorLabel->{"Nl","Ne","Nm","Nt"}, PropagatorType->Straight, PropagatorArrow->Forward},

 F[7] == { ClassName->l, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, QuantumNumbers->{Q->-1}, ParticleName->{"e-","mu-","tau-"}, AntiParticleName->{"e+","mu+","tau+"},
           ClassMembers->{e,m,ta}, Mass->{Ml,Me,Mm,Mta}, Width->0, PDG->{11,13,15}, PropagatorLabel->{"l","e","mu","tau"}, PropagatorType->Straight, PropagatorArrow->Forward},

 F[8] == { ClassName->uq, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]}, FlavorIndex->GEN, QuantumNumbers->{Q-> 2/3}, ParticleName->{"u","c","t"}, AntiParticleName->{"u~","c~","t~"},
           ClassMembers->{u,c,t}, Mass->{Muq,MU,MC,MT}, Width->{Wuq,0,0,WT}, PDG->{2,4,6}, PropagatorLabel->{"uq","u","c","t"}, PropagatorType->Straight, PropagatorArrow->Forward},

 F[9] == { ClassName->dq, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]}, FlavorIndex->GEN, QuantumNumbers->{Q->-1/3}, ParticleName->{"d","s","b"}, AntiParticleName->{"d~","s~","b~"},
           ClassMembers->{d,s,b}, Mass->{Mdq,MD,MS,MB}, Width->0, PDG->{1,3,5}, PropagatorLabel->{"dq","d","s","b"}, PropagatorType->Straight, PropagatorArrow->Forward}
};


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {
	
(* *********************************************************** *)
(* ****                     Higgses vevs                  **** *)
(* *********************************************************** *)	
	(* *)
 vR  == { TeX->Subscript[v,"R"],        ParameterType->External, ComplexParameter->False, BlockName->FRVevs, OrderBlock->1, Value -> 1000, InteractionOrder->{QED,-1}, Description->"SU(2)_R Higgs triplet vacuum expectation value"},

 vL  == { TeX->Subscript[v,"L"],        ParameterType->External, ComplexParameter->False, InteractionOrder->{QED,-1}, BlockName -> FRVevs, OrderBlock -> 2, Value -> 0, Description->"SU(2)_L Higgs triplet vacuum expectation value"},

 v1  == { TeX->Subscript[v,1],          ParameterType->External, ComplexParameter->False, InteractionOrder->{QED,-1},BlockName -> FRVevs, OrderBlock -> 3, Value -> 248, Description->"Higgs bidoublet vacuum expectation value"},

 v1p == { TeX->Subsuperscript[v,1,"'"], ParameterType->External, ComplexParameter->False, InteractionOrder->{QED,-1}, BlockName -> FRVevs, OrderBlock -> 4, Value -> 0,Description->"Higgs bidoublet second vacuum expectation value"},


(* *********************************************************** *)
(* ****                 Coupling constants                **** *)
(* *********************************************************** *)	
(* External parameters *)
 aEWM1 == { TeX->Subsuperscript[\[Alpha],w,-1], ParameterType->External, ComplexParameter->False, BlockName->SMINPUTS, OrderBlock->1, Value->127.9, InteractionOrder->{QED,-2}, Description->"Inverse of the EW coupling constant at the Z pole"},
 aS    == { TeX->Subscript[\[Alpha],s],         ParameterType->External, ComplexParameter->False, BlockName->SMINPUTS, OrderBlock->5, InteractionOrder->{QCD, 2}, Description->"Strong coupling constant at the Z pole."},
 gR    == { TeX->Subscript[g,R],                ParameterType->External, ComplexParameter->False, BlockName->Gauge, OrderBlock->4, Value ->  0.646482210, InteractionOrder->{QED, 1}, Description->"SU(2)_R coupling constant at the Z pole"},

 gL == { TeX->Subscript[g,L],  ParameterType->External, ComplexParameter->False, BlockName -> Gauge, OrderBlock -> 2, Value->0.646482210,                 InteractionOrder->{QED,1}, Description->"SU(2)_L coupling constant at the Z pole"},
 gY == { TeX->Subscript[g,Y],  ParameterType->External, ComplexParameter->False, BlockName -> Gauge, OrderBlock -> 1, Value-> 0.360966847,       InteractionOrder->{QED,1}, Description->"U(1)Y coupling constant at the Z pole"},

(* *********************************************************** *)
(* ****                 Electroweak mixings               **** *)
(* *********************************************************** *)	
 (* Internal parameters *)
 gBL== { TeX->Subscript[g,B-L],ParameterType->Internal, ComplexParameter->False, Value->gY gR/Sqrt[gR^2-gY^2], InteractionOrder->{QED,1}, Description->"U(1)_{B-L} coupling constant at the Z pole"},

 gs == { TeX->Subscript[g,s],  ParameterType->Internal, ComplexParameter->False, Value->Sqrt[4 Pi aS],         InteractionOrder->{QCD,1}, ParameterName->G, Description->"Strong coupling constant"},

(* *********************************************************** *)
(* ****                       Yukawas                     **** *)
(* *********************************************************** *)	

(* External parameters *)
 Ryq1 == { ParameterType->External,  ComplexParameter->False, BlockName->YQ1,    Indices->{Index[GEN],Index[GEN]}, Description->"Quark Yukawa matrix 1 (real part)"},
 Iyq1 == { ParameterType->External,  ComplexParameter->False, BlockName->IMYQ1,  Indices->{Index[GEN],Index[GEN]}, Description->"Quark Yukawa matrix 1 (imaginary part)"},

 Ryq2 == { ParameterType->External,  ComplexParameter->False, BlockName->YQ2,    Indices->{Index[GEN],Index[GEN]}, Description->"Quark Yukawa matrix 2 (real part)"},
 Iyq2 == { ParameterType->External,  ComplexParameter->False, BlockName->IMYQ2,  Indices->{Index[GEN],Index[GEN]}, Description->"Quark Yukawa matrix 2 (imaginary part)"},

 Ryl1 == { ParameterType->External,  ComplexParameter->False, BlockName->YL1,    Indices->{Index[GEN],Index[GEN]}, Description->"Lepton Yukawa matrix 1 (real part)"},
 Iyl1 == { ParameterType->External,  ComplexParameter->False, BlockName->IMYL1,  Indices->{Index[GEN],Index[GEN]}, Description->"Lepton Yukawa matrix 1 (imaginary part)"},

 Ryl2 == { ParameterType->External,  ComplexParameter->False, BlockName->YL2,    Indices->{Index[GEN],Index[GEN]}, Description->"Lepton Yukawa matrix 2 (real part)"},
 Iyl2 == { ParameterType->External,  ComplexParameter->False, BlockName->IMYL2,  Indices->{Index[GEN],Index[GEN]}, Description->"Lepton Yukawa matrix 2 (imaginary part)"},

 Ryl3 == { ParameterType->External,  ComplexParameter->False, BlockName->YL3,    Indices->{Index[GEN],Index[GEN]}, Description->"Lepton Yukawa matrix 3 (real part)"},
 Iyl3 == { ParameterType->External,  ComplexParameter->False, BlockName->IMYL3,  Indices->{Index[GEN],Index[GEN]}, Description->"Lepton Yukawa matrix 3 (imaginary part)"},

 Ryl4 == { ParameterType->External,  ComplexParameter->False, BlockName->YL4,    Indices->{Index[GEN],Index[GEN]}, Description->"Lepton Yukawa matrix 4 (real part)"},
 Iyl4 == { ParameterType->External,  ComplexParameter->False, BlockName->IMYL4,  Indices->{Index[GEN],Index[GEN]}, Description->"Lepton Yukawa matrix 4 (imaginary part)"},


(* Quartic terms for bidoublets *)
 RLAM1 == { ParameterType->External, ComplexParameter->False, BlockName->HLAM,   OrderBlock->1,                    Description->"1st bidoublet quartic term  (real part)"},
 ILAM1 == { ParameterType->External, ComplexParameter->False, BlockName->IMHLAM, OrderBlock->1,                    Description->"1st bidoublet quartic term (imaginary part)"},

 RLAM2 == { ParameterType->External, ComplexParameter->False, BlockName->HLAM,   OrderBlock->2,                    Description->"2nd bidoublet quartic term(real part)"},
 ILAM2 == { ParameterType->External, ComplexParameter->False, BlockName->IMHLAM, OrderBlock->2,                    Description-> "2nd bidoublet quartic term (imaginary part)"},

 RLAM3 == { ParameterType->External, ComplexParameter->False, BlockName->HLAM,   OrderBlock->3,                    Description->"3rd bidoublet quartic term  (real part)"},
 ILAM3 == { ParameterType->External, ComplexParameter->False, BlockName->IMHLAM, OrderBlock->3,                    Description->"3rd bidoublet quartic term  (imaginary part)"},

 RLAM4 == { ParameterType->External, ComplexParameter->False, BlockName->HLAM,   OrderBlock->4,                    Description->"4th bidoublet quartic term  (real part)"},
 ILAM4 == { ParameterType->External, ComplexParameter->False, BlockName->IMHLAM, OrderBlock->4,                    Description->"4th bidoublet quartic term  (imaginary part)"},

 RLAM5 == { ParameterType->External, ComplexParameter->False, BlockName->HLAM,   OrderBlock->5,                    Description->"5th bidoublet quartic term  (real part)"},
 ILAM5 == { ParameterType->External, ComplexParameter->False, BlockName->IMHLAM, OrderBlock->5,                    Description->"5th bidoublet quartic term  (imaginary part)"},

 RLAM6 == { ParameterType->External, ComplexParameter->False, BlockName->HLAM,   OrderBlock->6,                    Description->"6th bidoublet quartic term  (real part)"},
 ILAM6 == { ParameterType->External, ComplexParameter->False, BlockName->IMHLAM, OrderBlock->6,                    Description->"6th bidoublet quartic term  (imaginary part)"},

(* Quartic terms for triplets *)
 RRHO1 == { ParameterType->External, ComplexParameter->False, BlockName->HRHO,   OrderBlock->1,                    Description->"1st triplet quartic term  (real part)"},
 IRHO1 == { ParameterType->External, ComplexParameter->False, BlockName->IMRHO,  OrderBlock->1,                    Description->"1st triplet  quartic term  (imaginary part)"},

 RRHO2 == { ParameterType->External, ComplexParameter->False, BlockName->HRHO,   OrderBlock->2,                    Description->"2nd triplet quartic term  (real part)"},
 IRHO2 == { ParameterType->External, ComplexParameter->False, BlockName->IMRHO,  OrderBlock->2,                    Description->"2nd triplet  quartic term  (imaginary part)"},

 RRHO3 == { ParameterType->External, ComplexParameter->False, BlockName->HRHO,   OrderBlock->3,                    Description->"3rd triplet quartic term  (real part)"},
 IRHO3 == { ParameterType->External, ComplexParameter->False, BlockName->IMRHO,  OrderBlock->3,                    Description->"3rd triplet  quartic term  (imaginary part)"},

(* Quartic terms for bidoublets-triplets *)
 RAL1 == { ParameterType->External, ComplexParameter->False, BlockName->HAL,   OrderBlock->1,                    Description->"1st bidoubet-triplets quartic term  (real part)"},
 IAL1 == { ParameterType->External, ComplexParameter->False, BlockName->IMAL,  OrderBlock->1,                    Description->"1st bidoubet-triplets quartic term (imaginary part)"},

 RAL2 == { ParameterType->External, ComplexParameter->False, BlockName->HAL,   OrderBlock->2,                    Description->"2nd bidoubet-triplets quartic term  (real part)"},
 IAL2 == { ParameterType->External, ComplexParameter->False, BlockName->IMAL,  OrderBlock->2,                    Description->"2nd bidoubet-triplets quartic term (imaginary part)"},

 RAL3 == { ParameterType->External, ComplexParameter->False, BlockName->HAL,   OrderBlock->3,                    Description->"3rd bidoubet-triplets quartic term  (real part)"},
 IAL3 == { ParameterType->External, ComplexParameter->False, BlockName->IMAL,  OrderBlock->3,                    Description->"3rd bidoubet-triplets quartic term (imaginary part)"},



(* Internal parameters *)
 yq1  == { TeX->Superscript[y,q1],      ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, Unitary->True,Value->{yq1[i_,j_]:>Ryq1[i,j]+I*Iyq1[i,j]}, InteractionOrder->{QED,1}, 
Description-> "Quark Yukawa matrix 1"},

 yq2  == { TeX->Superscript[y,q2],      ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, Unitary->True,Value->{yq2[i_,j_]:>Ryq2[i,j]+I*Iyq2[i,j]}, InteractionOrder->{QED,1}, Description-> "Quark Yukawa matrix 2"},

 yl1  == { TeX->Superscript[y,l1],      ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, Unitary->True,Value->{yl1[i_,j_]:>Ryl1[i,j]+I*Iyl1[i,j]}, InteractionOrder->{QED,1}, Description-> "Lepton Yukawa matrix 1"},
 yl2  == { TeX->Superscript[y,l2],      ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, Unitary->True,Value->{yl2[i_,j_]:>Ryl2[i,j]+I*Iyl2[i,j]}, InteractionOrder->{QED,1}, Description-> "Lepton Yukawa matrix 2"},
 yl3  == { TeX->Superscript[y,l3],      ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, Unitary->True,Value->{yl3[i_,j_]:>Ryl3[i,j]+I*Iyl3[i,j]}, InteractionOrder->{QED,1}, Description-> "Lepton Yukawa matrix 3"},
 yl4  == { TeX->Superscript[y,l4],      ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, Unitary->True,Value->{yl4[i_,j_]:>Ryl4[i,j]+I*Iyl4[i,j]}, InteractionOrder->{QED,1}, Description-> "Lepton Yukawa matrix 4"},

(* quartic terms for bidoublets *)
 lam1 == { TeX->Subscript[\[Lambda],1], ParameterType->Internal, ComplexParameter->True, Value->RLAM1+I*ILAM1, Description->"1st bidoublet quartic term"}, 
 lam2 == { TeX->Subscript[\[Lambda],2], ParameterType->Internal, ComplexParameter->True, Value->RLAM2+I*ILAM2, Description->"2md bidoublet quartic term"}, 
 lam3 == { TeX->Subscript[\[Lambda],3], ParameterType->Internal, ComplexParameter->True, Value->RLAM3+I*ILAM3, Description->"3rd bidoublet quartic term"},  
 lam4 == { TeX->Subscript[\[Lambda],4], ParameterType->Internal, ComplexParameter->True, Value->RLAM4+I*ILAM4, Description->"4th bidoublet quartic term"},
 lam5 == { TeX->Subscript[\[Lambda],5], ParameterType->Internal, ComplexParameter->True, Value->RLAM5+I*ILAM5, Description->"5th bidoublet quartic term"},
 lam6 == { TeX->Subscript[\[Lambda],6], ParameterType->Internal, ComplexParameter->True, Value->RLAM6+I*ILAM6, Description->"6th bidoublet quartic term"},

(* quartic terms for triplets *)
 rho1 == { TeX->Subscript[\[Rho],1], ParameterType->Internal, ComplexParameter->True, Value->RRHO1+I*IRHO1, Description->" 1st triplets quartic term"},
 rho2 == { TeX->Subscript[\[Rho],2], ParameterType->Internal, ComplexParameter->True, Value->RRHO2+I*IRHO2, Description->" 2nd triplets quartic term"},
 rho3 == { TeX->Subscript[\[Rho],3], ParameterType->Internal, ComplexParameter->True, Value->RRHO3+I*IRHO3, Description->" 3rd triplets quartic term"},

(* quartic terms for bidoublets-triplets *)
 al1 == { TeX->Subscript[\[Alpha],1], ParameterType->Internal, ComplexParameter->True, Value->RAL1+I*IAL1, Description->" 1st bidoubet-triplets quartic term"},
 al2 == { TeX->Subscript[\[Alpha],2], ParameterType->Internal, ComplexParameter->True, Value->RAL2+I*IAL2, Description->" 2nd bidoubet-triplets quartic term"},
 al3 == { TeX->Subscript[\[Alpha],3], ParameterType->Internal, ComplexParameter->True, Value->RAL3+I*IAL3, Description->" 3rd bidoubet-triplets quartic term"},
(* Bilinear terms *)


 mu12 == {  TeX->Superscript[Subscript[\[Mu],1],2],     ParameterType->Internal, ComplexParameter->True, Value ->(2*(lam1 + lam2)*v1^2 + 2*(lam1 + 4*lam3 + lam5 + lam6)*v1p^2 + (al1 + al3)*(vL^2 + vR^2))/2 ,Description->"Square of the bidoublet quadratic term"},


 mu1 == {  TeX->Subscript[\[Mu],1],     ParameterType->Internal, ComplexParameter->True, Value ->Sqrt[mu12] ,   Description->"Bidoublet quadratic term"},

 mu22 == {  TeX->Superscript[Subscript[\[Mu],2],2],     ParameterType->Internal, ComplexParameter->True, Value ->((al1 + al3)*v1^2 + (al1 + al2)*v1p^2 + rho3*vL^2 + 2*(rho1 + rho2)*vR^2)/2,Description->"Square of the triplet quadratic term"},


 mu2 == {  TeX->Subscript[\[Mu],2],     ParameterType->Internal, ComplexParameter->True, Value ->Sqrt[mu22],   Description->"Triplet quadratic term"}

};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)


(*Gauge piece*)
LGauge := Block[{mu,nu,ii,aa}, -1/4 FS[B,mu,nu] FS[B,mu,nu] - 1/4 FS[WLi,mu,nu,ii] FS[WLi,mu,nu,ii] - 1/4 FS[WRi,mu,nu,ii] FS[WRi,mu,nu,ii] - 1/4 FS[G,mu,nu,aa] FS[G,mu,nu,aa] ];

(* Fermions *)
LFermions := Block[{mu}, I*( QLbar.Ga[mu].DC[QL, mu] + LLbar.Ga[mu].DC[LL, mu] + QRbar.Ga[mu].DC[QR, mu] + LRbar.Ga[mu].DC[LR, mu])];

(*Higgses*)
LHiggs := Block[{ii, jj, mu, UE, DE, DEL, DER, resu = 0, h1t, h1tbar, tmpp},
 
 (*Some definitions*)
  UE := {{0, -1}, {1, 0}};
  DE := {{0, 1}, {-1, 0}};
  DER[a_, b_] := Expand[1/Sqrt[2] (PauliSigma[1, a, b] hR[1] + PauliSigma[2, a, b] hR[2] + PauliSigma[3, a, b] hR[3])];
  DEL[a_, b_] := Expand[1/Sqrt[2] (PauliSigma[1, a, b] hL[1] + PauliSigma[2, a, b] hL[2] + PauliSigma[3, a, b] hL[3])];
  h1t[ii_, iip_] := Plus @@ Flatten[Table[UE[[ii, jj]] DE[[iip, jjp]] HC[h1[jjp, jj]], {jj, 1, 2}, {jjp, 1, 2}]];
  h1tbar[ii_, iip_] := Plus @@ Flatten[Table[UE[[iip, jjp]] DE[[ii, jj]] h1[jjp, jj], {jj, 1, 2}, {jjp, 1, 2}]];
 
  (*kinetic terms*)
  resu += DC[h1bar[ii, jj], mu] DC[h1[ii, jj], mu] + DC[hLbar[ii], mu] DC[hL[ii], mu] + DC[hRbar[ii], mu] DC[hR[ii], mu];
  (*higgs-higgs Interactions*)
  tmpp = 0; Do[tmpp += mu12*h1bar[ii, jj]*h1[ii, jj], {ii, 1, 2}, {jj, 1, 2}]; resu += Expand[tmpp];
  tmpp = 0; Do[tmpp += mu22*(HC[DEL[ii, jj]]*DEL[ii, jj] + HC[DER[ii, jj]]*DER[ii, jj]), {ii, 1, 2}, {jj, 1, 2}]; resu += Expand[tmpp];
  tmpp = 0; Do[tmpp += lam1*h1bar[ii, jj]*h1[ii, jj]*h1bar[ll, kk]*h1[ll, kk], {ii, 1, 2}, {jj, 1, 2}, {kk, 1, 2}, {ll, 1, 2}]; resu -= Expand[tmpp];
  tmpp = 0; Do[tmpp += lam2*h1bar[ii, jj]*h1[ii, ll]*h1bar[kk, ll]*h1[kk, jj], {ii, 1, 2}, {jj, 1, 2}, {kk, 1, 2}, {ll, 1, 2}]; resu -= Expand[tmpp];
  tmpp = 0; Do[tmpp += (h1bar[ii, jj]*h1t[jj, ii] + h1tbar[jj, ii]*h1[ii, jj]), {ii, 1, 2}, {jj, 1, 2}]; resu -= Expand[tmpp]^2*lam3/2;
  tmpp = 0; Do[tmpp += (h1bar[jj, ii]*h1t[ii, jj] - h1tbar[jj, ii]*h1[ii, jj]), {ii, 1, 2}, {jj, 1, 2}]; resu -= Expand[tmpp]^2*lam4/2;
  tmpp = 0; Do[tmpp += lam5*h1bar[ii, jj]*h1[jj, kk]*h1tbar[kk, ll]*h1t[ll, ii], {ii, 1, 2}, {jj, 1, 2}, {kk, 1, 2}, {ll, 1, 2}]; resu -= Expand[tmpp];
  tmpp = 0; Do[tmpp += lam6*(h1bar[ii, jj]*h1t[jj, kk]*h1bar[kk, ll]*h1t[ll, ii] + h1tbar[ii, jj]*h1[jj, kk]*h1tbar[kk, ll]*h1[ll, ii]), {ii, 1, 2}, {jj, 1, 2}, {kk, 1, 2}, {ll, 1, 2}]; resu -= Expand[tmpp]/2;
  tmpp = 0; Do[tmpp += rho1*(HC[DEL[ii, jj]]*DEL[ii, jj]*HC[DEL[kk, ll]]*DEL[kk, ll] + HC[DER[ii, jj]]*DER[ii, jj]*HC[DER[kk, ll]]*DER[kk, ll]), {ii, 1, 2}, {jj, 1, 2}, {kk, 1, 2}, {ll, 1, 2}]; resu -= Expand[tmpp];
  tmpp = 0; Do[tmpp += rho2*(HC[DEL[ii, jj]]*DEL[ii, ll]*HC[DEL[kk, ll]]*DEL[kk, jj] + HC[DER[ii, jj]]*DER[ii, ll]*HC[DER[kk, ll]]*DER[kk, jj]), {ii, 1, 2}, {jj, 1, 2}, {kk, 1, 2}, {ll, 1, 2}]; resu -= Expand[tmpp];
  tmpp = 0; Do[tmpp += rho3*HC[DEL[ii, jj]] DEL[ii, jj]*HC[DER[kk, ll]]*DER[kk, ll], {ii, 1, 2}, {jj, 1, 2}, {kk, 1, 2}, {ll, 1, 2}]; resu -= Expand[tmpp];
  tmpp = 0; Do[tmpp += al1*h1bar[ii, jj]*h1[ii, jj]*(HC[DEL[kk, ll]]*DEL[kk, ll] + HC[DER[kk, ll]]*DER[kk, ll]), {ii, 1, 2}, {jj, 1, 2}, {kk, 1, 2}, {ll, 1, 2}]; resu -= Expand[tmpp];
  tmpp = 0; Do[tmpp += al2*(HC[DER[jj, ii]] h1bar[kk, jj] h1[kk, ll] DER[ll, ii] + HC[DEL[jj, ii]] h1bar[kk, jj] h1[kk, ll] DEL[ll, ii]), {ii, 1, 2}, {jj, 1, 2}, {kk, 1, 2}, {ll, 1, 2}]; resu -= Expand[tmpp];
  tmpp = 0; Do[tmpp += al3*(HC[DER[jj, ii]] h1tbar[jj, kk] h1t[ll, kk] DER[ll, ii] + HC[DEL[jj, ii]] h1tbar[jj, kk] h1t[ll, kk] DEL[ll, ii]), {ii, 1, 2}, {jj, 1, 2}, {kk, 1, 2}, {ll, 1, 2}]; resu -= Expand[tmpp];

  Expand[resu]];


(*Yukawa piece*) 
LYukawa := Block[{UE, DE, ii,jj,iip,jjp,ff1,ff2,cc1,sp, resu=0, DEL, DER},
  (* some definitions *)
  UE := {{0, -1}, {1, 0}};
  DE := {{0, 1}, {-1, 0}};
  DER[a_,b_] := Expand[1/Sqrt[2] (PauliSigma[1,a,b] hR[1] + PauliSigma[2,a,b] hR[2] + PauliSigma[3,a,b] hR[3])]; 
  DEL[a_,b_] := Expand[1/Sqrt[2] (PauliSigma[1,a,b] hL[1] + PauliSigma[2,a,b] hL[2] + PauliSigma[3,a,b] hL[3])];
  (* Fermion-bidoublet interactions *)
  Do[
    resu -= yq1[ff1,ff2] CC[QLbar[sp,jj,ff1,cc1]].QR[sp,jjp,ff2,cc1] h1[ii,iip] DE[[jj,ii]] UE[[jjp,iip]] +
            yl1[ff1,ff2] CC[LLbar[sp,jj,ff1    ]].LR[sp,jjp,ff2    ] h1[ii,iip] DE[[jj,ii]] UE[[jjp,iip]],
    {ii,1,2},{jj,1,2},{iip,1,2},{jjp,1,2}];
  Do[
    resu -= yq2[ff1,ff2] CC[QRbar[sp,ii,ff1,cc1]].QL[sp,iip,ff2,cc1] h1bar[ii,iip] +
            yl2[ff1,ff2] CC[LRbar[sp,ii,ff1    ]].LL[sp,iip,ff2    ] h1bar[ii,iip],
    {ii,1,2},{iip,1,2}];
  (* Fermion-triplet interactions *)     
  Do[
    resu -= yl3[ff1, ff2] DE[[jj, ii]] CC[ LLbar][sp, ii, ff1].LL[sp, kk, ff2] DEL[jj, kk];
    resu -= yl4[ff1, ff2] UE[[jj, kk]] LRbar[sp, jj, ff1].CC[LR][sp, ii, ff2]  DER[kk,ii],
    {ii,1,2},{jj,1,2},{kk,1,2}];
  resu += HC[resu];
Expand[resu]
];


LagLRSM :=LYukawa + LFermions + LGauge + LHiggs;
