(* ********************************************************* *)
(* *****                                               ***** *)
(* *****  FeynRules model file: the MSSM               ***** *)
(* *****  Author: A. Allou, B. Fuks                    ***** *)
(* *****                                               ***** *)
(* ********************************************************* *)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "MSSM_mix";
M$Information = { Authors->{"Benjamin Fuks"}, Emails->{"fuks@cern.ch"}, Institutions->{"IPHC Strasbourg / University of Strasbourg"},
                  Date->"26.10.12", Version->"1.3.13",
                  References->{"C. Duhr, B. Fuks, CPC 182 (2011) 2404-2462, arXiv:1102.4191 [hep-ph]"},
                  URLs->{"http://feynrules.irmp.ucl.ac.be/view/Main/MSSM"} };

(* v1.3.6:  Renaming of SP to SPot (variable name clashing). Thanks to Kentarou Mawatari.     *)
(* v1.3.7:  Small bug in the definition of the CKM matrix. Thanks Antonio Mariano.            *)
(* v1.3.8:  Interaction orders added.                                                         *)
(* v1.3.9:  Wrong sign for the gaugino soft masses.                                           *)
(* v1.3.10: Inversion of two SLHA counters for the Higgs soft masses. Thanks to Sho Iwamoto.  *)
(* v1.3.11: Adding the Feynman gauge flag necessary for the UFO.                              *)
(* v1.3.12: Preamble updated.                                                                 *)
(* v1.3.13: Definition of bb modified, improving Lagrangian checks. Thanks to Sho Iwamoto.    *)
(* v1.4.0:  Including the mixings.                                                            *)

(* ************************** *)
(* *****      Flags     ***** *)
(* ************************** *)
$CKMDiag = False;   (* CKM  = identity or not *)
$MNSDiag = True;   (* PMNS = identity or not *)
FeynmanGauge = True;


(* ************************************************ *)
(* *****      Mass matrix diagonalization     ***** *)
(* ************************************************ *)
M$vevs = { {hus[2],vu}, {hds[1],vd} };

M$MixingsDescription = {
Mix["1a"] == { MassBasis -> {A, Z},    GaugeBasis -> {B, Wi[3]},     MixingMatrix -> UG, BlockName -> WEAKMIX },
Mix["1b"] == { MassBasis -> {W, Wbar}, GaugeBasis -> {Wi[1], Wi[2]}, Value -> {{1/Sqrt[2], -I/Sqrt[2]}, {1/Sqrt[2], I/Sqrt[2]}} },
Mix["2a"] == { MassBasis -> { {h0, H0}, {A0, G0} }, GaugeBasis -> { hds[1], hus[2] }, BlockName -> {HMIX, AMIX}, MixingMatrix -> {US, UP} }, 
Mix["2b"] == { MassBasis -> {H, GP}, GaugeBasis -> { hdsbar[2], hus[1] }, BlockName -> HCMIX, MixingMatrix -> UC },
Mix["3a"] == { MassBasis -> {boww}, GaugeBasis -> {bow}, Value ->{{I}}},
Mix["3b"] == { MassBasis -> {wow0,wowp,wowm}, GaugeBasis -> {wow[3],wow[1],wow[2]}, Value ->{{I,0,0}, {0,I/Sqrt[2],1/Sqrt[2]}, {0,I/Sqrt[2],-1/Sqrt[2]}} },
Mix["3c"] == { MassBasis -> {neuw[1], neuw[2], neuw[3], neuw[4]}, GaugeBasis -> {boww, wow0, hdw[1], huw[2]},  BlockName -> NMIX, MixingMatrix -> NN },
Mix["3d"]  == { MassBasis -> {{chmw[1],chmw[2]}, {chpw[1],chpw[2]}}, GaugeBasis -> {{wowm,hdw[2]},{wowp,huw[1]}}, BlockName -> {UMIX,VMIX}, MixingMatrix -> {UU,VV} },
Mix["5"]  == { MassBasis -> {goww}, GaugeBasis -> {gow}, Value ->{{I}}},
Mix["6a"] == { MassBasis -> {ghWp, ghWm}, GaugeBasis -> {ghWi[1], ghWi[2]}, Value -> {{1/Sqrt[2], -I/Sqrt[2]}, {1/Sqrt[2], I/Sqrt[2]}} },
Mix["6b"] == { MassBasis -> {ghA, ghZ}, GaugeBasis -> {ghB, ghWi[3]}, MixingMatrix -> UG, BlockName -> WEAKMIX },

Mix["7a"] == { MassBasis -> {vLw[1],vLw[2],vLw[3]} , GaugeBasis -> {LLw[1,1],LLw[1,2],LLw[1,3]}, MixingMatrix -> MNS},
Mix["7b"] == { MassBasis -> {eLw[1],eLw[2],eLw[3]} , GaugeBasis -> {LLw[2,1],LLw[2,2],LLw[2,3]}, Value -> {{1,0,0},{0,1,0},{0,0,1}}},
Mix["7c"] == { MassBasis ->  {uLw[1,_],uLw[2,_], uLw[3,_]}, GaugeBasis ->{QLw[1,1,_],QLw[1,2,_],QLw[1,3,_]}, Value -> {{1,0,0},{0,1,0},{0,0,1}} },

Mix["7d"] == { MassBasis -> {dLw[1,_],dLw[2,_], dLw[3,_]}, GaugeBasis -> {QLw[2,1,_],QLw[2,2,_],QLw[2,3,_]}, MixingMatrix -> CKM, Inverse -> True},
Mix["7e"] == { MassBasis -> {sdL[1,_],sdL[2,_],sdL[3,_]}, GaugeBasis -> {QLs[2,1,_], QLs[2,2,_], QLs[2,3,_]}, MixingMatrix -> CKM, Inverse -> True},

(* CKM/PMNS for  sdowns/ sneutrinos *) 
Mix["8a"] == { MassBasis -> {sn[1], sn[2], sn[3]}, GaugeBasis -> {LLs[1,1], LLs[1,2], LLs[1,3]}, MixingMatrix -> Rn, BlockName -> SNUMIX},
Mix["8b"] == { MassBasis -> {sl[1], sl[2], sl[3],sl[4],sl[5],sl[6]}, GaugeBasis -> {LLs[2,1], LLs[2,2], LLs[2,3],ERsbar[1], ERsbar[2], ERsbar[3]}, 
              MixingMatrix -> Rl, BlockName -> SELMIX},
Mix["8c"] == { MassBasis -> {su[1,_],su[2,_],su[3,_],su[4,_],su[5,_],su[6,_]}, GaugeBasis -> {QLs[1,1,_], QLs[1,2,_], QLs[1,3,_], URsbar[1,_],URsbar[2,_],URsbar[3,_]}, 
              MixingMatrix -> Ru, BlockName -> USQMIX},
Mix["8d"] == { MassBasis -> {sd[1,_],sd[2,_],sd[3,_],sd[4,_],sd[5,_],sd[6,_]}, GaugeBasis -> {sdL[1,_], sdL[2,_], sdL[3,_],DRsbar[1,_],DRsbar[2,_],DRsbar[3,_]},
              MixingMatrix -> Rd, BlockName -> DSQMIX}



}

(* ************************** *)
(* *****  Gauge groups  ***** *)
(* ************************** *)
M$GaugeGroups = {
 U1Y  == { Abelian->True,  CouplingConstant->gp, Superfield->BSF, Charge->Y, GUTNormalization->3/5},
 SU2L == { Abelian->False, CouplingConstant->gw, Superfield->WSF, 
           StructureConstant->ep, Representations->{Ta,SU2D}, Definitions->{Ta[a__]->PauliSigma[a]/2, ep->Eps}},
 SU3C == { Abelian->False, CouplingConstant->gs, Superfield->GSF,
           StructureConstant->f,  Representations->{{T,Colour}, {Tb,Colourb}}, DTerm->dSUN} 
};

(* ************************** *)
(* *** Interaction orders *** *)
(* ************************** *)
M$InteractionOrderHierarchy = { {QCD, 1}, {QED, 2} };


(* *********************************** *)
(* ***** Representation mappings ***** *)
(* *********************************** *)
FR$ReprMap = { {Colour,Colourb} };

(* ************************** *)
(* *****    Indices     ***** *)
(* ************************** *)
IndexRange[Index[SU2W]] =   Unfold[Range[3]]; IndexStyle[SU2W,j];  IndexRange[Index[SU2D]] =   Unfold[Range[2]]; IndexStyle[SU2D,k];
IndexRange[Index[Gluon ]] = NoUnfold[Range[8]]; IndexStyle[Gluon, a];  IndexRange[Index[Colour ]] = NoUnfold[Range[3]]; IndexStyle[Colour, m]; 
IndexRange[Index[Colourb]] = NoUnfold[Range[3]]; IndexStyle[Colourb,m];
IndexRange[Index[NEU ]] = Range[4];           IndexStyle[NEU, i];
IndexRange[Index[CHA ]] = Range[2];           IndexStyle[CHA, i];
IndexRange[Index[GEN ]] = Range[3];           IndexStyle[GEN, f];
IndexRange[Index[SCA ]] = Range[6];           IndexStyle[SCA, i];


(* ************************** *)
(* *****  Superfields   ***** *)
(* ************************** *)
M$Superfields = {
 VSF[1] == { ClassName->BSF, GaugeBoson->B,  Gaugino->bow}, 
 VSF[2] == { ClassName->WSF, GaugeBoson->Wi, Gaugino->wow, Indices->{Index[SU2W]}},
 VSF[3] == { ClassName->GSF, GaugeBoson->G,  Gaugino->gow, Indices->{Index[Gluon] }},
 CSF[1] == { ClassName->HU, Chirality->Left, Weyl->huw, Scalar->hus, QuantumNumbers->{Y-> 1/2}, Indices->{Index[SU2D]}},
 CSF[2] == { ClassName->HD, Chirality->Left, Weyl->hdw, Scalar->hds, QuantumNumbers->{Y->-1/2}, Indices->{Index[SU2D]}},
 CSF[3] == { ClassName->LL, Chirality->Left, Weyl->LLw, Scalar->LLs, QuantumNumbers->{Y->-1/2}, Indices->{Index[SU2D], Index[GEN]}},
 CSF[4] == { ClassName->ER, Chirality->Left, Weyl->ERw, Scalar->ERs, QuantumNumbers->{Y-> 1},   Indices->{Index[GEN]}},
 CSF[5] == { ClassName->VR, Chirality->Left, Weyl->VRw, Scalar->VRs, Indices->{Index[GEN]}},
 CSF[6] == { ClassName->QL, Chirality->Left, Weyl->QLw, Scalar->QLs, QuantumNumbers->{Y-> 1/6}, Indices->{Index[SU2D], Index[GEN], Index[Colour]}},
 CSF[7] == { ClassName->UR, Chirality->Left, Weyl->URw, Scalar->URs, QuantumNumbers->{Y->-2/3}, Indices->{Index[GEN], Index[Colourb]}           },
 CSF[8] == { ClassName->DR, Chirality->Left, Weyl->DRw, Scalar->DRs, QuantumNumbers->{Y-> 1/3}, Indices->{Index[GEN], Index[Colourb]}           }
};

(* ************************** *)
(* *****     Fields     ***** *)
(* ************************** *)
M$ClassesDescription = {
(* Gauge bosons: unphysical vector fields *)
 V[11] == { ClassName->B, Unphysical->True, SelfConjugate->True },
 V[12] == { ClassName->Wi, Unphysical->True, SelfConjugate->True, Indices->{Index[SU2W]}, FlavorIndex->SU2W },

(* Gauge bosons: physical vector fields *)
 V[1] == { ClassName->A, SelfConjugate->True,  Mass->0,  Width->0,  ParticleName->"a", 
           PDG->22, PropagatorLabel->"A", PropagatorType->Sine, PropagatorArrow->None},
 V[2] == { ClassName->Z, SelfConjugate->True,  Mass->MZ, Width->WZ, ParticleName->"Z", 
           PDG->23, PropagatorLabel->"Z", PropagatorType->Sine, PropagatorArrow->None},
 V[3] == { ClassName->W, SelfConjugate->False, Mass->MW, Width->WW, ParticleName->"W+", AntiParticleName->"W-", QuantumNumbers->{Q->1},
           PDG->24, PropagatorLabel->"W", PropagatorType->Sine, PropagatorArrow->Forward},
 V[4] == { ClassName->G, SelfConjugate->True, Indices->{Index[Gluon]}, Mass->0, Width->0, ParticleName->"g", 
           PDG->21, PropagatorLabel->"G", PropagatorType->C,    PropagatorArrow->None },

(* Gauginos: unphysical Weyls *)
 W[20] == { ClassName->bow, Unphysical->True, Chirality->Left, SelfConjugate->False},
 W[200]== { ClassName->boww,Unphysical->True, Chirality->Left, SelfConjugate->False},
 W[21] == { ClassName->wow, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2W]}, FlavorIndex->SU2W },
 W[210]== { ClassName->wow0,Unphysical->True, Chirality->Left, SelfConjugate->False},
 W[211]== { ClassName->wowp,Unphysical->True, Chirality->Left, SelfConjugate->False},
 W[212]== { ClassName->wowm,Unphysical->True, Chirality->Left, SelfConjugate->False},
 W[22] == { ClassName->gow,  Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[Gluon]} },

(* Higgsinos: unphysical Weyls *)
 W[23] == { ClassName->huw,  Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2D]}, FlavorIndex->SU2D, QuantumNumbers->{Y-> 1/2} },
 W[24] == { ClassName->hdw,  Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2D]}, FlavorIndex->SU2D, QuantumNumbers->{Y->-1/2} },

(* Gauginos/Higgsinos: physical Weyls *)
 W[1] == { ClassName->neuw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[NEU]}, FlavorIndex->NEU },
 W[2] == { ClassName->chpw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[CHA]}, FlavorIndex->CHA, QuantumNumbers->{Q-> 1} } ,
 W[3] == { ClassName->chmw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[CHA]}, FlavorIndex->CHA, QuantumNumbers->{Q->-1} } ,
 W[4] == { ClassName->goww, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[Gluon]} },

(* Gauginos/Higgsinos: physical Diracs *)
 F[1] == { ClassName->neu, SelfConjugate->True,  Indices->{Index[NEU]}, FlavorIndex->NEU, WeylComponents->neuw,
           ParticleName->{"n1","n2","n3","n4"},
           ClassMembers->{neu1,neu2,neu3,neu4}, Mass->{Mneu,Mneu1,Mneu2,Mneu3,Mneu4}, Width->{Wneu,Wneu1,Wneu2,Wneu3,Wneu4}, 
           PDG->{1000022,1000023,1000025,1000035}, PropagatorLabel->{"neu","neu1","neu2","neu3","neu4"}, PropagatorType->Straight, PropagatorArrow->None },
 F[2] == { ClassName->ch,  SelfConjugate->False, Indices->{Index[CHA]}, FlavorIndex->CHA, WeylComponents->{chpw,chmwbar}, 
           ParticleName->{"x1+","x2+"}, AntiParticleName->{"x1-","x2-"}, QuantumNumbers->{Q ->1},
           ClassMembers->{ch1,ch2}, Mass->{Mch,Mch1,Mch2}, Width->{Wch,Wch1,Wch2},
           PDG->{1000024,1000037}, PropagatorLabel->{"ch","ch1","ch2"}, PropagatorType->Straight, PropagatorArrow->Forward },
 F[3] == { ClassName->go,  SelfConjugate->True, Indices->{Index[Gluon]}, WeylComponents->goww, Mass->Mgo, Width->Wgo, ParticleName->"go",
           PDG->1000021, PropagatorLabel->"go", PropagatorType->Straight, PropagatorArrow->None },

(* Higgs: unphysical scalars  *)
S[21] == { ClassName->hus,  Unphysical->True, SelfConjugate->False, Indices->{Index[SU2D]}, FlavorIndex->SU2D, QuantumNumbers->{Y-> 1/2} },
S[22] == { ClassName->hds,  Unphysical->True, SelfConjugate->False, Indices->{Index[SU2D]}, FlavorIndex->SU2D, QuantumNumbers->{Y->-1/2} },

(* Higgs: physical fields and Goldstones *)
 S[1] == { ClassName->h0, SelfConjugate->True, Mass->MH01, Width->WH01, ParticleName->"h01",
           PDG->25, PropagatorLabel->"h0", PropagatorType->ScalarDash,  PropagatorArrow->None},
 S[2] == { ClassName->H0, SelfConjugate->True, Mass->MH02, Width->WH02, ParticleName->"h02",
           PDG->35, PropagatorLabel->"H0", PropagatorType->ScalarDash,  PropagatorArrow->None},
 S[3] == { ClassName->A0, SelfConjugate->True, Mass->MA0 , Width->WA0,  ParticleName->"A0" ,
           PDG->36, PropagatorLabel->"A0", PropagatorType->ScalarDash,  PropagatorArrow->None},
 S[4] == { ClassName->H,  SelfConjugate->False, QuantumNumbers->{Q-> 1}, Mass->MH, Width->WH, 
           ParticleName->"H+", AntiParticleName->"H-", 
           PDG->37,  PropagatorLabel->"H", PropagatorType->ScalarDash,  PropagatorArrow->Forward},
 S[5] == { ClassName->G0, SelfConjugate->True, Mass->MZ, Width->WG0, Goldstone->Z,
           ParticleName->"G0", 
           PDG->250, PropagatorLabel->"G0", PropagatorType->D, PropagatorArrow->None},
 S[6] == { ClassName->GP, SelfConjugate->False, QuantumNumbers->{Q-> 1}, Mass->MW, Width->WGP, Goldstone->W,
           ParticleName->"G+", AntiParticleName->"G-",
           PDG->251, PropagatorLabel->"GP", PropagatorType->D, PropagatorArrow->None },

(* Fermions: unphysical Weyls *)
W[25] == { ClassName->LLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2D],Index[GEN]},              FlavorIndex->SU2D, 
           QuantumNumbers->{Y->-1/2} },
W[26] == { ClassName->QLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[SU2D],Index[GEN],Index[Colour]},FlavorIndex->SU2D,
           QuantumNumbers->{Y->1/6} },

(* Fermions: physical Weyls *)
 W[5] == { ClassName->vLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN },
 W[6] == { ClassName->eLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN },
 W[7] == { ClassName->VRw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN },
 W[8] == { ClassName->ERw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, QuantumNumbers->{Y-> 1} },
 W[9] == { ClassName->uLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]},  FlavorIndex->GEN },
 W[10]== { ClassName->dLw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]},  FlavorIndex->GEN },
 W[11]== { ClassName->URw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN],Index[Colourb]}, FlavorIndex->GEN, QuantumNumbers->{Y->-2/3} },
 W[12]== { ClassName->DRw, Unphysical->True, Chirality->Left, SelfConjugate->False, Indices->{Index[GEN],Index[Colourb]}, FlavorIndex->GEN, QuantumNumbers->{Y-> 1/3} },

(* Fermions: physical Dirac *)
 F[4] == { ClassName->vl, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, WeylComponents->{vLw,VRwbar},
           ParticleName->{"ve","vm","vt"}, AntiParticleName->{"ve~","vm~","vt~"},
           ClassMembers->{ve,vm,vt}, Mass->{Mvl,Mve,Mvm,Mvt}, Width->0,
           PDG->{12,14,16}, PropagatorLabel->{"v","ve","vm","vt"}, PropagatorType->Straight, PropagatorArrow->Forward},
 F[5] == { ClassName->l, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, WeylComponents->{eLw,ERwbar}, QuantumNumbers->{Q->-1},
           ParticleName->{"e-","mu-","tau-"}, AntiParticleName->{"e+","mu+","tau+"},
           ClassMembers->{e,m,ta}, Mass->{Ml,Me,Mm,Mta}, Width->0,
           PDG->{11,13,15}, PropagatorLabel->{"l","e","mu","tau"}, PropagatorType->Straight, PropagatorArrow->Forward},
 F[6] == { ClassName->uq, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]}, FlavorIndex->GEN, WeylComponents->{uLw,URwbar}, QuantumNumbers->{Q-> 2/3},
           ParticleName->{"u","c","t"}, AntiParticleName->{"u~","c~","t~"},
           ClassMembers->{u,c,t}, Mass->{Muq,MU,MC,MT}, Width->{Wuq,0,0,WT},
           PDG->{2,4,6}, PropagatorLabel->{"uq","u","c","t"}, PropagatorType->Straight, PropagatorArrow->Forward},
 F[7] == { ClassName->dq, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]}, FlavorIndex->GEN, WeylComponents->{dLw,DRwbar}, QuantumNumbers->{Q->-1/3},
           ParticleName->{"d","s","b"}, AntiParticleName->{"d~","s~","b~"},
           ClassMembers->{d,s,b}, Mass->{Mdq,MD,MS,MB}, Width->0,
           PDG->{1,3,5}, PropagatorLabel->{"dq","d","s","b"}, PropagatorType->Straight, PropagatorArrow->Forward},

(* Sfermion: unphysical scalars *)
S[23] == { ClassName->LLs,  Unphysical->True, SelfConjugate->False, Indices->{Index[SU2D], Index[GEN]}, FlavorIndex->SU2D, QuantumNumbers->{Y->-1/2} },
S[24] == { ClassName->ERs, Unphysical->True, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, QuantumNumbers->{Y-> 1} },
S[25] == { ClassName->VRs, Unphysical->True, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, 
           Definitions->{ VRs[_] -> 0 } },
S[26] == { ClassName->QLs,  Unphysical->True, SelfConjugate->False, Indices->{Index[SU2D], Index[GEN],Index[Colour]}, FlavorIndex->SU2D, QuantumNumbers->{Y->1/6} },
S[261]== { ClassName->sdL,  Unphysical->True, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]}, FlavorIndex->GEN, QuantumNumbers->{Y->1/6} },
S[27] == { ClassName->URs, Unphysical->True, SelfConjugate->False, Indices->{Index[GEN],Index[Colourb]}, FlavorIndex->GEN, QuantumNumbers->{Y->-2/3} },
S[28] == { ClassName->DRs, Unphysical->True, SelfConjugate->False, Indices->{Index[GEN],Index[Colourb]}, FlavorIndex->GEN, QuantumNumbers->{Y-> 1/3} },

(* Sfermion: physical scalars *)
S[7] == {  ClassName->sn, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN, 
           ParticleName->{"sv1","sv2","sv3"}, AntiParticleName->{"sv1~","sv2~","sv3~"},
           ClassMembers-> {sn1, sn2, sn3}, Mass->{Msn,Msn1,Msn2,Msn3}, Width->{Wsn,Wsn1,Wsn2,Wsn3},
           PDG->{1000012,1000014,1000016}, PropagatorLabel->{"sn","sn1","sn2","sn3"}, PropagatorType->ScalarDash, PropagatorArrow->Forward },
S[8] == {  ClassName->sl, SelfConjugate->False, Indices->{Index[SCA]}, FlavorIndex->SCA, QuantumNumbers->{Q->-1},
           ParticleName->{"sl1-","sl2-","sl3-","sl4-","sl5-","sl6-"}, AntiParticleName->{"sl1+","sl2+","sl3+","sl4+","sl5+","sl6+"},
           ClassMembers->{sl1,sl2,sl3,sl4,sl5,sl6}, Mass->{Msl,Msl1,Msl2,Msl3,Msl4,Msl5,Msl6}, Width->{Wsl,Wsl1,Wsl2,Wsl3,Wsl4,Wsl5,Wsl6},
           PDG->{1000011,1000013,1000015,2000011,2000013,2000015}, PropagatorLabel->{"sl","sl1","sl2","sl3","sl4","sl5","sl6"}, 
           PropagatorType->ScalarDash, PropagatorArrow->Forward},
S[9] == {  ClassName->su, SelfConjugate->False, Indices->{Index[SCA],Index[Colour]}, FlavorIndex->SCA, QuantumNumbers->{Q-> 2/3},
           ParticleName->{"su1","su2","su3","su4","su5","su6"}, AntiParticleName->{"su1~","su2~","su3~","su4~","su5~","su6~"},
           ClassMembers->{su1,su2,su3,su4,su5,su6}, Mass->{Msu,Msu1,Msu2,Msu3,Msu4,Msu5,Msu6}, Width->{Wsu,Wsu1,Wsu2,Wsu3,Wsu4,Wsu5,Wsu6},
           PDG->{1000002,1000004,1000006,2000002,2000004,2000006}, PropagatorLabel->{"su","su1","su2","su3","su4","su5","su6"}, 
           PropagatorType->ScalarDash, PropagatorArrow->Forward},
S[10]== {  ClassName->sd, SelfConjugate->False, Indices->{Index[SCA],Index[Colour]}, FlavorIndex->SCA, QuantumNumbers->{Q->-1/3},
           ParticleName->{"sd1","sd2","sd3","sd4","sd5","sd6"}, AntiParticleName->{"sd1~","sd2~","sd3~","sd4~","sd5~","sd6~"},
           ClassMembers->{sd1,sd2,sd3,sd4,sd5,sd6}, Mass->{Msd,Msd1,Msd2,Msd3,Msd4,Msd5,Msd6}, Width->{Wsd,Wsd1,Wsd2,Wsd3,Wsd4,Wsd5,Wsd6},
           PDG->{1000001,1000003,1000005,2000001,2000003,2000005}, PropagatorLabel->{"sd","sd1","sd2","sd3","sd4","sd5","sd6"}, 
           PropagatorType->ScalarDash, PropagatorArrow->Forward},

(* Ghost: related to unphysical gauge bosons *)
 U[11] == { ClassName->ghWi, Unphysical->True, SelfConjugate->False, Ghost->Wi, Indices->{Index[SU2W]}, FlavorIndex->SU2W,
            Definitions->{ghWi[1]->(ghWp+ghWm)/Sqrt[2], ghWi[2]->(ghWm-ghWp)/(I*Sqrt[2]), ghWi[3]->cw ghZ+sw ghA} } ,
 U[12] == { ClassName->ghB, Unphysical->True, SelfConjugate->False, Ghost->B, 
            Definitions->{ghB->-sw ghZ+cw ghA} },

(* Ghost: related to physical gauge bosons *)
 U[1] == { ClassName->ghG, SelfConjugate->False, Indices->{Index[Gluon]}, Ghost->G, QuantumNumbers->{GhostNumber->1}, 
           Mass->0, Width->0, ParticleName->"ghG", PropagatorLabel->"uG", PropagatorType->GhostDash, PropagatorArrow->Forward},
 U[2] == { ClassName->ghA, SelfConjugate->False, Ghost->A, QuantumNumbers->{GhostNumber->1},
           Mass->0, Width->0, ParticleName->"ghA", PropagatorLabel->"uA", PropagatorType->GhostDash, PropagatorArrow->Forward},
 U[3] == { ClassName->ghZ, SelfConjugate->False, Ghost->Z, QuantumNumbers->{GhostNumber->1},
           Mass->{MZ,Internal}, Width->WZ, ParticleName->"ghZ", PropagatorLabel->"uZ", PropagatorType->GhostDash, PropagatorArrow->Forward},
 U[4] == { ClassName->ghWp, SelfConjugate->False, Ghost->W, QuantumNumbers->{GhostNumber->1, Q->1},
           Mass->{MW,Internal}, Width->WW, ParticleName->"ghWp", PropagatorLabel->"uWp", PropagatorType->GhostDash, PropagatorArrow->Forward},
 U[5] == { ClassName->ghWm, SelfConjugate->False, Ghost->Wbar, QuantumNumbers->{GhostNumber->1, Q->-1},
           Mass->{MW,Internal}, Width->WW, ParticleName->"ghWm", PropagatorLabel->"uWm", PropagatorType->GhostDash, PropagatorArrow->Forward}
};


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

(* Couplings constants: external parameters *)
 aEWM1 == { TeX->Subsuperscript[\[Alpha],w,-1], ParameterType->External, ComplexParameter->False, BlockName->SMINPUTS, OrderBlock->1, InteractionOrder->{QED,-2},
            Description->"Inverse of the EW coupling constant at the Z pole"},
 aS    == { TeX->Subscript[\[Alpha],s],         ParameterType->External, ComplexParameter->False, BlockName->SMINPUTS, OrderBlock->3, InteractionOrder->{QCD, 2},
            Description->"Strong coupling constant at the Z pole."},

(* Couplings constants: internal parameters *)
 ee == { TeX->e,              ParameterType->Internal, ComplexParameter->False, Value->Sqrt[4 Pi / aEWM1], InteractionOrder->{QED,1}, 
         Description->"Electric coupling constant"},
 gs == { TeX->Subscript[g,s], ParameterType->Internal, ComplexParameter->False, Value->Sqrt[4 Pi aS],      InteractionOrder->{QCD,1}, ParameterName->G, 
         Description->"Strong coupling constant"},
 gp == { TeX->g',             ParameterType->External, ComplexParameter->False, BlockName -> Gauge, OrderBlock -> 1, InteractionOrder->{QED,1},
         Description->"Hypercharge coupling constant at the Z pole"},
 gw == { TeX->Subscript[g,w], ParameterType->Internal, ComplexParameter->False, BlockName -> Gauge, OrderBlock -> 2, InteractionOrder->{QED,1},
         Description->"Weak coupling constant at the Z pole"},

(* Higgs sector: external parameters *)
 tb == { TeX->Subscript[t,b], ParameterType->External, ComplexParameter->False, BlockName -> FRVev, OrderBlock->2, Description->"Ratio of the two Higgs vevs"},

(* Higgs sector: internal parameters *)
 beta == { TeX->\[Beta], ParameterType->Internal, ComplexParameter->False, Value->ArcTan[tb], Description->"Arctan of the ratio of the two Higgs vevs"},
 vev  == { TeX->v,              ParameterType->External, ComplexParameter->False, BlockName -> FRVev, OrderBlock -> 1, InteractionOrder->{QED,-1}, 
           Description->"Higgs vacuum expectation value"},
 vd   == { TeX->Subscript[v,d], ParameterType->Internal, ComplexParameter->False, Value->vev*Cos[beta],    InteractionOrder->{QED,-1},
           Description->"Down-type Higgs vacuum expectation value"},
 vu   == { TeX->Subscript[v,u], ParameterType->Internal, ComplexParameter->False, Value->vev*Sin[beta],    InteractionOrder->{QED,-1},
           Description->"Up-type Higgs vacuum expectation value"},

(* Superpotential: external parameters *)
 Ryu  == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->YU,
           Description->"Up-type quark Yukawa matrix (real part)"},
 Iyu  == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMYU,
           Description->"Up-type quark Yukawa matrix (imaginary part)"},
 Ryd  == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->YD,
           Description->"Down-type quark Yukawa matrix (real part)"},
 Iyd  == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMYD,
           Description->"Down-type quark Yukawa matrix (imaginary part)"},
 Rye  == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->YE,
           Description->"Charged lepton Yukawa matrix (real part)"},
 Iye  == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMYE,
           Description->"Charged lepton Yukawa matrix (imaginary part)"},

(* Superpotential: internal parameters *)
 yu  == { TeX->Superscript[y,u], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, 
          Definitions:>{yu[i_,j_]:>0 /;(i!=j)}, Value->{yu[i_,j_]:>If[i==j,Ryu[i,j]+I*Iyu[i,j]]}, InteractionOrder->{QED,1}, Description-> "Up-type quark Yukawa matrix"},
 yd  == { TeX->Superscript[y,d], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, 
          Definitions:>{yd[i_,j_]:>0 /;(i!=j)}, Value->{yd[i_,j_]:>If[i==j,Ryd[i,j]+I*Iyd[i,j]]}, InteractionOrder->{QED,1}, Description-> "Down-type quark Yukawa matrix"},
 ye  == { TeX->Superscript[y,e], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, 
          Definitions:>{ye[i_,j_]:>0 /;(i!=j)}, Value->{ye[i_,j_]:>If[i==j,Rye[i,j]+I*Iye[i,j]]}, InteractionOrder->{QED,1}, Description-> "Charged lepton Yukawa matrix"},
 mHu2 == { TeX->Subsuperscript[m,Subscript[H,u],2], ParameterType->External, ComplexParameter->False, BlockName->MSOFT, OrderBlock->22,
           Description->"Up-type Higgs squared mass"},
 mHd2 == { TeX->Subsuperscript[m,Subscript[H,d],2], ParameterType->External, ComplexParameter->False, BlockName->MSOFT, OrderBlock->21,
           Description->"Down-type Higgs squared mass"},
 MUH == { TeX->\[Mu], ParameterType->Internal, ComplexParameter->True, Value->(-8*mHd2*vd^2 + 8*mHu2*vu^2 + (gp^2 + gw^2)*(-vd^4 + vu^4))/(8*(vd - vu)*(vd + vu)), Description->"Off diagonal Higgs mixing parameter"},

(* Soft terms: external parameters *)
 RMx1 == { ParameterType->External, ComplexParameter->False, BlockName->MSOFT,   OrderBlock->1, Description->"Bino mass (real part)"},
 IMx1 == { ParameterType->External, ComplexParameter->False, BlockName->IMMSOFT, OrderBlock->1, Description->"Bino mass (imaginary part)"},
 RMx2 == { ParameterType->External, ComplexParameter->False, BlockName->MSOFT,   OrderBlock->2, Description->"Wino mass (real part)"},
 IMx2 == { ParameterType->External, ComplexParameter->False, BlockName->IMMSOFT, OrderBlock->2, Description->"Wino mass (imaginary part)"},
 RMx3 == { ParameterType->External, ComplexParameter->False, BlockName->MSOFT,   OrderBlock->3, Description->"Gluino mass (real part)"},
 IMx3 == { ParameterType->External, ComplexParameter->False, BlockName->IMMSOFT, OrderBlock->3, Description->"Gluino mass (imaginary part)"},
 RmL2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->MSL2,
           Description->"Left-handed slepton squared mass matrix (real part)"},
 ImL2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMMSL2,
           Description->"Left-handed slepton squared mass matrix (imaginary part)"},
 RmE2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->MSE2,
           Description->"Right-handed slepton squared mass matrix (real part)"},
 ImE2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMMSE2,
           Description->"Right-handed slepton squared mass matrix (imaginary part)"},
 RmQ2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->MSQ2,
           Description->"Left-handed squark squared mass matrix (real part)"},
 ImQ2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMMSQ2,
           Description->"Left-handed squark squared mass matrix (imaginary part)"},
 RmU2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->MSU2,
           Description->"Right-handed up-type squark squared mass matrix (real part)"},
 ImU2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMMSU2,
           Description->"Right-handed up-type squark squared mass matrix (imaginary part)"},
 RmD2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->MSD2,
           Description->"Right-handed down-type squark squared mass matrix (real part)"},
 ImD2 == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMMSD2,
           Description->"Right-handed down-type squark squared mass matrix (imaginary part)"},
 Rte == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->TE,
           Description->"Charged slepton trilinear coupling (real part)"},
 Ite == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMTE,
           Description->"Charged slepton trilinear coupling (imaginary part)"},
 Rtu == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->TU,
           Description->"Up-type squark trilinear coupling (real part)"},
 Itu == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMTU,
           Description->"Up-type squark trilinear coupling (imaginary part)"},
 Rtd == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->TD,
           Description->"Down-type squark trilinear coupling (real part)"},
 Itd == { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMTD,
           Description->"Down-type squark trilinear coupling (imaginary part)"},

(* Soft terms: internal parameters *)
 Mx1 == { TeX->Subscript[M,1], ParameterType->Internal, ComplexParameter->True, Value->RMx1+I*IMx1, Description->"Bino mass"},
 Mx2 == { TeX->Subscript[M,2], ParameterType->Internal, ComplexParameter->True, Value->RMx2+I*IMx2, Description->"Wino mass"},
 Mx3 == { TeX->Subscript[M,3], ParameterType->Internal, ComplexParameter->True, Value->RMx3+I*IMx3, Description->"Gluino mass"},
  bb  == { TeX->b, ParameterType->Internal, ComplexParameter->True, Value-> (vd*vu*(-4*mHd2 + 4*mHu2 - (gp^2 + gw^2)*(vd^2 - vu^2)))/(4*(vd^2 - vu^2)),  Description->"Higgs bilinear soft term"},
 mL2 == { TeX->Subsuperscript[m,OverTilde[L],2], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, 
          Value->{mL2[i_,j_]:>RmL2[i,j]+I*ImL2[i,j]}, Description-> "Left-handed slepton squared mass matrix"},
 mE2 == { TeX->Subsuperscript[m,OverTilde[E],2], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, 
          Value->{mE2[i_,j_]:>RmE2[i,j]+I*ImE2[i,j]}, Description-> "Right-handed slepton squared mass matrix"},
 mQ2 == { TeX->Subsuperscript[m,OverTilde[Q],2], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, 
          Value->{mQ2[i_,j_]:>RmQ2[i,j]+I*ImQ2[i,j]}, Description-> "Left-handed squark squared mass matrix"},
 mU2 == { TeX->Subsuperscript[m,OverTilde[U],2], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, 
          Value->{mU2[i_,j_]:>RmU2[i,j]+I*ImU2[i,j]}, Description-> "Right-handed up-type squark squared mass matrix"},
 mD2 == { TeX->Subsuperscript[m,OverTilde[D],2], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, 
          Value->{mD2[i_,j_]:>RmD2[i,j]+I*ImD2[i,j]}, Description-> "Right-handed down-type squark squared mass matrix"},
 te  == { TeX->Subscript[T,e], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, InteractionOrder->{QED,1},
          Value->{te[i_,j_]:>Rte[i,j]+I*Ite[i,j]}, Description-> "Charged slepton trilinear coupling"},
 tu  == { TeX->Subscript[T,u], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, InteractionOrder->{QED,1},
          Value->{tu[i_,j_]:>Rtu[i,j]+I*Itu[i,j]}, Description-> "Up-type squark trilinear coupling"},
 td  == { TeX->Subscript[T,d], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, InteractionOrder->{QED,1},
          Value->{td[i_,j_]:>Rtd[i,j]+I*Itd[i,j]}, Description-> "Down-type squark trilinear coupling"},

(* Mixings that need to be given as parameters *) 
 RMNS== { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->UPMNS,
          Description->"Neutrino PMNS mixing matrix (real part)"},
 IMNS== { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMUPMNS,
          Description->"Neutrino PMNS mixing matrix (imaginary part)"},
  MNS== { TeX->Superscript[U,pmns], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, Unitary->True,
          If[$MNSDiag, Definitions:>{MNS[i_,j_]:>0 /;(i!=j), MNS[i_,j_]:>1/;(i==j)}, Value->{MNS[i_,j_]:>RMNS[i,j]+I*IMNS[i,j]}], 
          Description-> "Neutrino PMNS mixing matrix"},
 RCKM== { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->VCKM,
          Description->"CKM mixing matrix (real part)"},
 ICKM== { ParameterType->External, ComplexParameter->False, Indices->{Index[GEN],Index[GEN]}, BlockName->IMVCKM,
          Description->"CKM mixing matrix (imaginary part)"},
 CKM == { TeX->Superscript[V,ckm], ParameterType->Internal, ComplexParameter->True, Indices->{Index[GEN],Index[GEN]}, Unitary->True,
          If[$CKMDiag, Definitions:>{CKM[i_,j_]:>0 /;(i!=j), CKM[i_,j_]:>1/;(i==j)}, Value->{CKM[i_,j_]:>RCKM[i,j]+I*ICKM[i,j]}], 
          Description-> "CKM mixing matrix"}
};

(* ************************** *)
(* ****  Diracification  **** *)
(* ************************** *)
ToDirac[exp_]:= Module[{tmp=Expand[exp],cnt=0,prg1=0,prg2=0,prgo1=0,prgo2=0,tot},
 Colourb=Colour;

 tmp = If[Head[tmp]===Plus,List@@tmp,List[tmp]]/.Tb[a_,i_,j_]->-T[a,j,i];

 tmp = OptimizeIndex[#] &/@ tmp;
 tot=Length[tmp];
 Print["Flavor expansion: ", ProgressIndicator[Dynamic[prg1]]];
 tmp = Module[{}, cnt++; prg1=cnt/tot;
    Expand[(ExpandIndices[#] /. {
        Power[PauliSigma[a_,i_?(NumericQ[#] &),j_?(NumericQ[#] &)],2]->PauliSigma[1,i,j]^2 + PauliSigma[3,i,j]^2 + PauliSigma[2,i,j]^2,
        PauliSigma[a_,i_?(NumericQ[#] &),j_?(NumericQ[#] &)] PauliSigma[a_,k_?(NumericQ[#] &),l_?(NumericQ[#] &)]->
          PauliSigma[1,i,j] PauliSigma[1,k,l] + PauliSigma[2,i,j] PauliSigma[2,k,l] + PauliSigma[3,i,j] PauliSigma[3,k,l]})]] &/@ tmp;
  tmp = Plus@@tmp;

  cnt=0; tot=Length[tmp];
  Print["Opt 1: ",ProgressIndicator[Dynamic[prgo1]]];
  tmp = Module[{}, cnt++; prgo1=cnt/tot;OptimizeIndex[#]] &/@ (List@@tmp);
  Print["Weyl2Dirac: ",ProgressIndicator[Dynamic[prg2]]];cnt=0;
  tmp = Module[{}, cnt++; prg2=cnt/tot; WeylToDirac[#]] &/@ tmp; 
  Print["Opt2: ",ProgressIndicator[Dynamic[prgo2]]];cnt=0;
  tmp = Module[{}, cnt++; prgo2=cnt/tot;OptimizeIndex[#]] &/@ tmp; 
  Clear[Colourb];
  Print["starting expansion"];
  tmp=Expand/@tmp;
  Print["Expand done"];
  Return[Plus@@tmp]
];

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)
(* LVector *)
LVector := Module[{}, Plus@@(Module[{tmp}, tmp = SF2Components[#]; Expand[tmp[[2, 5]] + tmp[[2, 6]]]] &/@ (List @@ VSFKineticTerms[]))];

(* LChiral *)
LChiral :=  Plus@@( Theta2Thetabar2Component[#] &/@ (List @@ CSFKineticTerms[]) );

(* Superpotential *)
SPot:= Module[{ff1,ff2,ff3,cc1},
    yu[ff1,ff2] UR[ff1,cc1] (QL[1,ff2,cc1] HU[2] - QL[2,ff2,cc1] HU[1]) -
    yd[ff1,ff3] Conjugate[CKM[ff2,ff3]] DR[ff1,cc1] (QL[1,ff2,cc1] HD[2] - QL[2,ff2,cc1] HD[1]) -
    ye[ff1,ff2] ER[ff1]     (LL[1,ff2]     HD[2] - LL[2,ff2]     HD[1]) +
    MUH (HU[1] HD[2] - HU[2] HD[1])];
LSuperW:= ( Plus@@ (Module[{tmp},tmp=SF2Components[#];tmp[[2,5]]+tmp[[2,6]]] &/@ (List @@ Expand[SPot+HC[SPot]])) )/.Conjugate[CKM[a_, b_]]*CKM[a_, c_]->IndexDelta[b, c];

(* Soft SUSY-breaking Lagrangian *)
LSoft := Module[{Mino, MSca, Tri, Bil},
 (* Gaugino mass terms *)
   Mino:=Module[{s,gl},   Mx1*bow[s].bow[s] +  Mx2*wow[s,gl].wow[s,gl] + Mx3*goww[s,gl].goww[s,gl]];
 (* Scalar mass terms *)
   MSca:=Module[{ii,ff1,ff2,ff3,ff4,cc1}, 
     - mHu2*HC[hus[ii]]*hus[ii] - mHd2*HC[hds[ii]]*hds[ii] - 
       mL2[ff1,ff2]*HC[LLs[ii,ff1]]*LLs[ii,ff2] - mE2[ff1,ff2]*HC[ERs[ff1]]*ERs[ff2] - 
       CKM[ff1,ff2]*mQ2[ff2,ff3]*Conjugate[CKM[ff4,ff3]]*HC[QLs[ii,ff1,cc1]]*QLs[ii,ff4,cc1] - 
       mU2[ff1,ff2]*HC[URs[ff1,cc1]]*URs[ff2,cc1] -  mD2[ff1,ff2]*HC[DRs[ff1,cc1]]*DRs[ff2,cc1] ];
 (* Trilinear couplings *) 
   Tri:=-tu[ff1,ff2]*URs[ff1,cc1] (QLs[1,ff2,cc1] hus[2] - QLs[2,ff2,cc1] hus[1]) +
         Conjugate[CKM[ff3,ff2]]*td[ff1,ff2]*DRs[ff1,cc1] (QLs[1,ff3,cc1] hds[2] - QLs[2,ff3,cc1] hds[1]) +
         te[ff1,ff2]*ERs[ff1] (LLs[1,ff2] hds[2] - LLs[2,ff2] hds[1]) ;
 (* Bilinear couplings *)
   Bil:=-bb*(hus[1] hds[2] - hus[2] hds[1]);
 (* Everything together *)
 (Mino+HC[Mino])/2 + MSca + Tri + HC[Tri] + Bil + HC[Bil]];

(* Ghost Lagrangian and gauge fixing terms *)
LFeynmanGFix := Module[{VectorizeU,VectorizeD, Phiu,Phid,Phiu0,Phid0, phid1,phid2,phiu1,phiu2, GF1,GF2,GF3,LGF, nrules, kk,ll, LGh1,LGh2,LGh3,LGhS,LGh, genu,gend, gh,ghbar},
 (* Expression the doublets in the nu/nd basis *)
 VectorizeU[{a_, b_}] := Simplify[{Sqrt[2] Re[Expand[a]], Sqrt[2] Im[Expand[a]], Sqrt[2] Re[Expand[b]], Sqrt[2] Im[Expand[b]]} /. {Im[_]->0, Re[num_]->num}];
 VectorizeD[{a_, b_}] := Simplify[{Sqrt[2] Re[Expand[a]], Sqrt[2] Im[Expand[a]], Sqrt[2] Re[Expand[b]], Sqrt[2] Im[Expand[b]]} /. {Im[_]->0, Re[num_]->num}]; 

 (* Higgs doublets *)
 Phiu = Expand[ {(phiu1 + I phiu2)/Sqrt[2], (US[2,1]*h0+US[2,2]*H0 + I*UC[2,1]*A0+I*UC[2,2]*G0)/Sqrt[2]} ];
 Phid = Expand[ {(US[1,2]*h0+US[1,2]*H0 + I*UC[1,1]*A0-I*UC[2,2]*G0)/Sqrt[2], (phid1 + I phid2)/Sqrt[2]} ];
 (* vevs *)
 Phiu0 = {0, vu/Sqrt[2]};
 Phid0 = {vd/Sqrt[2], 0};
 (* Back to the physical Higgses and Goldstones *)
 nrules := {
    phid1 -> (UC[1,2]*GPbar - UC[1,2]*GP + UC[1,1]*Hbar + UC[1,1]*H)/Sqrt[2], 
    phid2 -> (UC[1,2]*GPbar + UC[1,2]*GP + UC[1,1]*Hbar - UC[1,1]*H)/(I Sqrt[2]), 
    phiu1 -> (UC[2,2]*GP + UC[2,2]*GPbar + UC[2,1]*H + UC[2,2]*Hbar)/Sqrt[2], 
    phiu2 -> (UC[2,2]*GP - UC[2,2]*GPbar + UC[2,1]*H - UC[2,2]*Hbar)/(I Sqrt[2])};

 (* Gauge-fixing functions *)
 GF1     := Module[{mu}, del[B[mu]   , mu] - gp VectorizeU[-I/2 Phiu0].VectorizeU[Phiu] - gp VectorizeD[I/2 Phid0].VectorizeD[Phid] ];
 GF2[k_] := Module[{mu}, del[Wi[mu,k], mu] - gw VectorizeU[-I/2 PauliSigma[k].Phiu0].VectorizeU[Phiu] - gw VectorizeD[-I/2 PauliSigma[k].Phid0].VectorizeD[Phid] ];
 GF3[a_] := Module[{mu}, del[G[mu,a] , mu] ];
 (* Gauge-fixing Lagrangian *)
 LGF = Expand[-1/2*(GF1 HC[GF1] + Sum[GF2[kk] HC[GF2[kk]], {kk, 1, 3}]) /.nrules /. {HC[a_]->a, h0->0, H0->0, A0->0, H->0, Hbar->0}];
 LGF = Expand[LGF/.(MR$Definitions /. Index[_, a_] -> a)];

 (* Ghost Lagrangians *)
 LGh1 = -ghBbar.del[DC[ghB,mu],mu];
 LGh2 = -ghWibar[kk].del[DC[ghWi[kk], mu], mu];
 LGh3 = -ghGbar[kk].del[DC[ghG[kk],mu],mu];
 genu := {-I/2 gp IdentityMatrix[2], -I/2 gw PauliSigma[1], -I/2 gw PauliSigma[2], -I/2 gw PauliSigma[3]};
 gend := { I/2 gp IdentityMatrix[2], -I/2 gw PauliSigma[1], -I/2 gw PauliSigma[2], -I/2 gw PauliSigma[3]};
 gh    = {ghB,    ghWi[1],    ghWi[2],    ghWi[3]};
 ghbar = {ghBbar, ghWibar[1], ghWibar[2], ghWibar[3]};
 LGhS = Sum[ 
   -ghbar[[kk]].gh[[ll]] (VectorizeU[genu[[kk]].Phiu0].VectorizeU[genu[[ll]].(Phiu+Phiu0)] + VectorizeD[gend[[kk]].Phid0].VectorizeD[gend[[ll]].(Phid+Phid0)]),
   {kk,1,4},{ll,1,4}];
 LGh =(LGh1+LGh2+LGh3+LGhS)/.(MR$Definitions /. Index[_, a_] -> a);
 LGh = LGh/.nrules; 
Expand[LGF+LGh]];

(* Collecting all the pieces together *)
Lag1 := SolveEqMotionF[SolveEqMotionD[LVector+LChiral+LSuperW+LSoft]] ;
Lag := ToDirac[SolveEqMotionF[SolveEqMotionD[LVector+LChiral+LSuperW+LSoft]]] + LFeynmanGFix ;