(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 8.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    206354,       5535]
NotebookOptionsPosition[    193607,       5180]
NotebookOutlinePosition[    193963,       5196]
CellTagsIndexPosition[    193920,       5193]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["\<\
ASperGe:
The Left-Right Symmetric Standard Model\
\>", "Title",
 CellChangeTimes->{{3.5680967526801434`*^9, 3.568096771005324*^9}}],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.568033973654759*^9, 3.568033980105204*^9}}],

Cell[CellGroupData[{

Cell["Set the path", "Section",
 CellChangeTimes->{{3.568033987624649*^9, 3.568033993662871*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", " ", "=", " ", 
   RowBox[{
   "SetDirectory", "[", "\"\<<< address of the package >>\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
  "SetDirectory", "[", "\"\<<< address of the model file>>\>\"", "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.5682913521156816`*^9, 3.568291386602854*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" - FeynRules - \"\>"], "Print",
 CellChangeTimes->{3.568095958334152*^9, 3.568096021939089*^9, 
  3.5680967786901484`*^9, 3.5680972599075747`*^9, 3.568100910928145*^9, 
  3.5682905603278847`*^9, 3.568290834362288*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Version: \"\>", "\[InvisibleSpace]", "\<\"1.7.134\"\>", 
   "\[InvisibleSpace]", 
   RowBox[{"\<\" (\"\>", " ", "\<\"27 January 2013\"\>"}], 
   "\[InvisibleSpace]", "\<\").\"\>"}],
  SequenceForm["Version: ", "1.7.134", " (" "27 January 2013", ")."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568095958334152*^9, 3.568096021939089*^9, 
  3.5680967786901484`*^9, 3.5680972599075747`*^9, 3.568100910928145*^9, 
  3.5682905603278847`*^9, 3.568290834367426*^9}],

Cell[BoxData["\<\"Authors: A. Alloul, N. Christensen, C. Degrande, C. Duhr, \
B. Fuks\"\>"], "Print",
 CellChangeTimes->{3.568095958334152*^9, 3.568096021939089*^9, 
  3.5680967786901484`*^9, 3.5680972599075747`*^9, 3.568100910928145*^9, 
  3.5682905603278847`*^9, 3.5682908343726377`*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.568095958334152*^9, 3.568096021939089*^9, 
  3.5680967786901484`*^9, 3.5680972599075747`*^9, 3.568100910928145*^9, 
  3.5682905603278847`*^9, 3.568290834376869*^9}],

Cell[BoxData["\<\"Please cite: Comput.Phys.Commun.180:1614-1641,2009 \
(arXiv:0806.4194).\"\>"], "Print",
 CellChangeTimes->{3.568095958334152*^9, 3.568096021939089*^9, 
  3.5680967786901484`*^9, 3.5680972599075747`*^9, 3.568100910928145*^9, 
  3.5682905603278847`*^9, 3.5682908343819933`*^9}],

Cell[BoxData["\<\"http://feynrules.phys.ucl.ac.be\"\>"], "Print",
 CellChangeTimes->{3.568095958334152*^9, 3.568096021939089*^9, 
  3.5680967786901484`*^9, 3.5680972599075747`*^9, 3.568100910928145*^9, 
  3.5682905603278847`*^9, 3.568290834387767*^9}],

Cell[BoxData["\<\" \"\>"], "Print",
 CellChangeTimes->{3.568095958334152*^9, 3.568096021939089*^9, 
  3.5680967786901484`*^9, 3.5680972599075747`*^9, 3.568100910928145*^9, 
  3.5682905603278847`*^9, 3.568290834392496*^9}],

Cell[BoxData["\<\"The FeynRules palette can be opened using the command \
FRPalette[].\"\>"], "Print",
 CellChangeTimes->{3.568095958334152*^9, 3.568096021939089*^9, 
  3.5680967786901484`*^9, 3.5680972599075747`*^9, 3.568100910928145*^9, 
  3.5682905603278847`*^9, 3.568290834398223*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Import the model", "Section",
 CellChangeTimes->{{3.568034009758786*^9, 3.5680340152778673`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadModel", "[", "\"\<LRSM_mix.fr\>\"", "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", "$FeynRulesPath", "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.568034045483623*^9, 3.5680340463555202`*^9}, {
  3.568096784928149*^9, 3.568096786575655*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.568096789787891*^9, 3.5680972667734327`*^9, 3.568290567201212*^9, 
  3.568290843966379*^9}],

Cell[BoxData["\<\"Adam Alloul\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.568096789787891*^9, 3.5680972667734327`*^9, 3.568290567201212*^9, 
  3.568290843969234*^9}],

Cell[BoxData["\<\"Benjamin Fuks\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.568096789787891*^9, 3.5680972667734327`*^9, 3.568290567201212*^9, 
  3.5682908439737864`*^9}],

Cell[BoxData["\<\"Michel Rausch de Traubenberg\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.568096789787891*^9, 3.5680972667734327`*^9, 3.568290567201212*^9, 
  3.56829084397887*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.02\"\>"}],
  SequenceForm["Model Version: ", "1.02"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.568096789787891*^9, 3.5680972667734327`*^9, 3.568290567201212*^9, 
  3.5682908439822073`*^9}],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.568096789787891*^9, 3.5680972667734327`*^9, 3.568290567201212*^9, 
  3.5682908439852133`*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.568096789787891*^9, 3.5680972667734327`*^9, 3.568290567201212*^9, 
  3.568290843988112*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.568096789787891*^9, 3.5680972667734327`*^9, 3.568290567201212*^9, 
  3.568290843991173*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.568096789787891*^9, 3.5680972667734327`*^9, 3.568290567201212*^9, 
  3.568290843994112*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.568096789787891*^9, 3.5680972667734327`*^9, 3.568290567201212*^9, 
  3.568290843998106*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.568096789787891*^9, 3.5680972667734327`*^9, 3.568290567201212*^9, 
  3.568290844001071*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.568096789787891*^9, 3.5680972667734327`*^9, 3.568290567201212*^9, 
  3.568290844216227*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.568096789787891*^9, 3.5680972667734327`*^9, 3.568290567201212*^9, 
  3.568290844248406*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"LRSM_mix\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "LRSM_mix", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568095962881637*^9, 3.568096027121998*^9, 
  3.568096789787891*^9, 3.5680972667734327`*^9, 3.568290567201212*^9, 
  3.568290844496859*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Compute the tree level mass matrices", "Section",
 CellChangeTimes->{{3.568034056025237*^9, 3.568034063631463*^9}}],

Cell[CellGroupData[{

Cell["Compute all the mass matrices", "Subsection",
 CellChangeTimes->{{3.5680340709677258`*^9, 3.568034078079522*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComputeMassMatrix", "[", "LagLRSM", "]"}]], "Input",
 CellChangeTimes->{{3.568034079329033*^9, 3.56803408777775*^9}, {
  3.568034188373899*^9, 3.568034193957204*^9}, {3.568095980320429*^9, 
  3.568095991696084*^9}, {3.568096030607581*^9, 3.568096031918537*^9}, {
  3.5680969930260878`*^9, 3.568096993718877*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Index expansion ...\"\>"], "Print",
 CellChangeTimes->{3.568096032659218*^9, 3.5680969955029984`*^9, 
  3.568097269873354*^9, 3.568290578085063*^9, 3.5682908495886927`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  => done in \"\>", "\[InvisibleSpace]", "2.452361`", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["  => done in ", 2.452361, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568096032659218*^9, 3.5680969955029984`*^9, 
  3.568097269873354*^9, 3.568290578085063*^9, 3.5682908520404387`*^9}],

Cell[BoxData["\<\"Tree level mass matrix computations achieved. Only the mass \
matrices necessary for the C++ code have been computed.\"\>"], "Print",
 CellChangeTimes->{3.568096032659218*^9, 3.5680969955029984`*^9, 
  3.568097269873354*^9, 3.568290578085063*^9, 3.568290861958192*^9}],

Cell[BoxData["\<\"Check FR$MassMatrices for the list of the MixingIDs.\"\>"], \
"Print",
 CellChangeTimes->{3.568096032659218*^9, 3.5680969955029984`*^9, 
  3.568097269873354*^9, 3.568290578085063*^9, 3.568290861960884*^9}],

Cell[BoxData["\<\"Use MassMatrix[ MixingID ], GaugeBasis[ MixingID ], \
MassBasis[ MixingID ], BlockName[ MixingID ] and MatrixSymbol[ MixingID ] for \
more information on the results.\"\>"], "Print",
 CellChangeTimes->{3.568096032659218*^9, 3.5680969955029984`*^9, 
  3.568097269873354*^9, 3.568290578085063*^9, 3.568290861963667*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Compute all the mass matrices without generation of the output about the mass \
matrices\
\>", "Subsection",
 CellChangeTimes->{{3.568096058356905*^9, 3.568096068613702*^9}}],

Cell[BoxData[
 RowBox[{"ComputeMassMatrix", "[", 
  RowBox[{"LagLRSM", ",", " ", 
   RowBox[{"ScreenOutput", " ", "\[Rule]", " ", "False"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.568096075110293*^9, 3.5680960919641237`*^9}, {
  3.5680972939708776`*^9, 3.568097296521027*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Compute only the mass matrix of the mixing of the neutral fields ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     SubscriptBox["\[CapitalDelta]", "L"], "0"], ",", " ", 
    SuperscriptBox[
     SubscriptBox["\[CapitalDelta]", "R"], "0"], ",", " ", 
    RowBox[{
     SuperscriptBox["\[CapitalPhi]", "0"], " ", "and", " ", 
     SuperscriptBox[
      RowBox[{"\[CapitalPhi]", "'"}], "0"]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " (DL0, DR0, phi[1,1] and phi[2,2], mixing \[OpenCurlyQuote]2e\
\[CloseCurlyQuote])"
}], "Subsection",
 CellChangeTimes->{{3.568034091791587*^9, 3.568034103135004*^9}, {
  3.568034169446822*^9, 3.568034176724732*^9}, {3.5680342380739393`*^9, 
  3.5680342448739557`*^9}, {3.568096182769602*^9, 3.568096184263101*^9}, {
  3.568097752128531*^9, 3.568097788608597*^9}, {3.568097934320142*^9, 
  3.568098076699478*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ComputeMassMatrix", "[", 
  RowBox[{"LagLRSM", ",", " ", 
   RowBox[{"Mix", "->", "\"\<2e\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.568034177974084*^9, 3.568034208533511*^9}, {
  3.568096100709914*^9, 3.5680961058370113`*^9}, {3.5680961501077957`*^9, 
  3.56809615112292*^9}, {3.5680973854973383`*^9, 3.568097388310876*^9}, {
  3.568098082390111*^9, 3.5680980835741997`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Index expansion ...\"\>"], "Print",
 CellChangeTimes->{3.5680961517635517`*^9, 3.568098085048417*^9, 
  3.5682906081487703`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  => done in \"\>", "\[InvisibleSpace]", "2.4154800000000023`",
    "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["  => done in ", 2.4154800000000023`, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.5680961517635517`*^9, 3.568098085048417*^9, 
  3.568290610563766*^9}],

Cell[BoxData["\<\"Computation of the tree level mass matrix for the mixing id \
2e achieved.\"\>"], "Print",
 CellChangeTimes->{3.5680961517635517`*^9, 3.568098085048417*^9, 
  3.568290613787242*^9}],

Cell[BoxData["\<\"For the results, use MassMatrix[ 2e ], GaugeBasis[ 2e ], \
MassBasis[ 2e ], BlockName [ 2e ] and MatrixSymbol [ 2e ].\"\>"], "Print",
 CellChangeTimes->{3.5680961517635517`*^9, 3.568098085048417*^9, 
  3.568290613790457*^9}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "2", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Rho]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Rho]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Rho]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], 
        RowBox[{
         SubscriptBox["\[Rho]", "3"], " ", 
         SubscriptBox["v", "\<\"L\"\>"], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "3"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         SubscriptBox["v", "\<\"L\"\>"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "2"]}], ")"}], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False], " ", 
         SubscriptBox["v", "\<\"L\"\>"]}]},
       {
        RowBox[{
         SubscriptBox["\[Rho]", "3"], " ", 
         SubscriptBox["v", "\<\"L\"\>"], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}], 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "2", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Rho]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Rho]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "-", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Rho]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "3"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "2"]}], ")"}], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}]},
       {
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "3"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         SubscriptBox["v", "\<\"L\"\>"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "3"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}], 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Lambda]", "2"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"8", " ", 
            SubscriptBox["\[Lambda]", "3"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "5"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "6"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SubsuperscriptBox["v", "1", "2"]}], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Lambda]", "1"], "+", 
           RowBox[{"4", " ", 
            SubscriptBox["\[Lambda]", "3"]}], "+", 
           SubscriptBox["\[Lambda]", "5"], "+", 
           SubscriptBox["\[Lambda]", "6"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False]}]},
       {
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "2"]}], ")"}], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False], " ", 
         SubscriptBox["v", "\<\"L\"\>"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "2"]}], ")"}], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Lambda]", "1"], "+", 
           RowBox[{"4", " ", 
            SubscriptBox["\[Lambda]", "3"]}], "+", 
           SubscriptBox["\[Lambda]", "5"], "+", 
           SubscriptBox["\[Lambda]", "6"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False]}], 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
           RowBox[{"8", " ", 
            SubscriptBox["\[Lambda]", "3"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "5"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "6"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Lambda]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 InterpretationBox[
                  SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                  Subsuperscript[FeynRules`v, 1, "'"],
                  Editable->False], ")"}], "2"]}]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "2", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Rho]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Rho]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Rho]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], "0", "0", 
        "0"},
       {"0", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "2", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Rho]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Rho]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "-", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Rho]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], "0", "0"},
       {"0", "0", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "2"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "-", 
           RowBox[{"8", " ", 
            SubscriptBox["\[Lambda]", "4"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "5"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "-", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "6"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "3"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "4"]}], "+", 
           SubscriptBox["\[Lambda]", "6"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False]}]},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "3"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "4"]}], "+", 
           SubscriptBox["\[Lambda]", "6"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False]}], 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "1", "2"]}], "-", 
           RowBox[{"8", " ", 
            SubscriptBox["\[Lambda]", "4"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "5"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "-", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "6"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Print",
 CellChangeTimes->{3.5680961517635517`*^9, 3.568098085048417*^9, 
  3.5682906139376097`*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[TextData[{
 "Ask for all the information about ",
 "the mixing of the neutral fields ",
 Cell[BoxData[
  FormBox[
   RowBox[{
    SuperscriptBox[
     SubscriptBox["\[CapitalDelta]", "L"], "0"], ",", " ", 
    SuperscriptBox[
     SubscriptBox["\[CapitalDelta]", "R"], "0"], ",", " ", 
    RowBox[{
     SuperscriptBox["\[CapitalPhi]", "0"], " ", "and", " ", 
     SuperscriptBox[
      RowBox[{"\[CapitalPhi]", "'"}], "0"]}]}], TraditionalForm]],
  FormatType->"TraditionalForm"],
 " (DL0, DR0, phi[1,1] and phi[2,2], mixing \[OpenCurlyQuote]2e\
\[CloseCurlyQuote])"
}], "Subsection",
 CellChangeTimes->{{3.56803422194046*^9, 3.56803425080986*^9}, {
  3.5680961867350807`*^9, 3.568096188327422*^9}, {3.568098109809639*^9, 
  3.568098113230564*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"MixingSummary", "[", "\"\<2e\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.568034252584323*^9, 3.568034259451329*^9}, {
  3.568098120194654*^9, 3.568098120932682*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Gauge basis = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"DeltaL0", ",", "DeltaR0", ",", 
     SubscriptBox["h1", 
      RowBox[{"1", ",", "1"}]], ",", 
     SubscriptBox["h1", 
      RowBox[{"2", ",", "2"}]]}], "}"}]}],
  SequenceForm[
  "Gauge basis = ", {$CellContext`DeltaL0, $CellContext`DeltaR0, 
    $CellContext`h1[1, 1], 
    $CellContext`h1[2, 2]}],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.56809618938696*^9, 3.568098121364786*^9, {3.568290616261177*^9, 
   3.568290623965448*^9}}],

Cell[BoxData["\<\"Scalar sector\"\>"], "Print",
 CellChangeTimes->{
  3.56809618938696*^9, 3.568098121364786*^9, {3.568290616261177*^9, 
   3.568290623968425*^9}}],

Cell[BoxData["\<\"***************************************************\"\>"], \
"Print",
 CellChangeTimes->{
  3.56809618938696*^9, 3.568098121364786*^9, {3.568290616261177*^9, 
   3.568290623970976*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Mass basis = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"h01", ",", "h02", ",", "h03", ",", "h04"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n  Block = \"\>", "\[InvisibleSpace]", "HMix", 
   "\[InvisibleSpace]", "\<\"\\n  Symbol = \"\>", "\[InvisibleSpace]", "UHN"}],
  SequenceForm[
  "  Mass basis = ", {$CellContext`h01, $CellContext`h02, $CellContext`h03, \
$CellContext`h04}, "\n  Block = ", $CellContext`HMix, 
   "\n  Symbol = ", $CellContext`UHN],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.56809618938696*^9, 3.568098121364786*^9, {3.568290616261177*^9, 
   3.568290623973446*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Squared mass matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "2", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Rho]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Rho]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Rho]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], 
        RowBox[{
         SubscriptBox["\[Rho]", "3"], " ", 
         SubscriptBox["v", "\<\"L\"\>"], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "3"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         SubscriptBox["v", "\<\"L\"\>"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "2"]}], ")"}], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False], " ", 
         SubscriptBox["v", "\<\"L\"\>"]}]},
       {
        RowBox[{
         SubscriptBox["\[Rho]", "3"], " ", 
         SubscriptBox["v", "\<\"L\"\>"], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}], 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "2", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Rho]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Rho]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "-", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Rho]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "3"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "2"]}], ")"}], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}]},
       {
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "3"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         SubscriptBox["v", "\<\"L\"\>"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "3"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}], 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Lambda]", "2"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"8", " ", 
            SubscriptBox["\[Lambda]", "3"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "5"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "6"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SubsuperscriptBox["v", "1", "2"]}], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Lambda]", "1"], "+", 
           RowBox[{"4", " ", 
            SubscriptBox["\[Lambda]", "3"]}], "+", 
           SubscriptBox["\[Lambda]", "5"], "+", 
           SubscriptBox["\[Lambda]", "6"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False]}]},
       {
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "2"]}], ")"}], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False], " ", 
         SubscriptBox["v", "\<\"L\"\>"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "2"]}], ")"}], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Lambda]", "1"], "+", 
           RowBox[{"4", " ", 
            SubscriptBox["\[Lambda]", "3"]}], "+", 
           SubscriptBox["\[Lambda]", "5"], "+", 
           SubscriptBox["\[Lambda]", "6"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False]}], 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
           RowBox[{"8", " ", 
            SubscriptBox["\[Lambda]", "3"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "5"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "6"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Lambda]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 InterpretationBox[
                  SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                  Subsuperscript[FeynRules`v, 1, "'"],
                  Editable->False], ")"}], "2"]}]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["  Squared mass matrix = ", 
   MatrixForm[{{
     Rational[1, 2] ((-2) 
        FeynRules`mu2^2 + $CellContext`al3 $CellContext`v1^2 + \
$CellContext`al2 $CellContext`v1p^2 + $CellContext`al1 ($CellContext`v1^2 + \
$CellContext`v1p^2) + 6 $CellContext`rho1 $CellContext`vL^2 + 
       6 $CellContext`rho2 $CellContext`vL^2 + $CellContext`rho3 \
$CellContext`vR^2), $CellContext`rho3 $CellContext`vL $CellContext`vR, \
($CellContext`al1 + $CellContext`al3) $CellContext`v1 $CellContext`vL, \
($CellContext`al1 + $CellContext`al2) $CellContext`v1p $CellContext`vL}, \
{$CellContext`rho3 $CellContext`vL $CellContext`vR, 
      Rational[1, 2] ((-2) 
        FeynRules`mu2^2 + $CellContext`al3 $CellContext`v1^2 + \
$CellContext`al2 $CellContext`v1p^2 + $CellContext`al1 ($CellContext`v1^2 + \
$CellContext`v1p^2) + $CellContext`rho3 $CellContext`vL^2 + 
       6 $CellContext`rho1 $CellContext`vR^2 - 
       6 $CellContext`rho2 $CellContext`vR^2), ($CellContext`al1 + \
$CellContext`al3) $CellContext`v1 $CellContext`vR, ($CellContext`al1 + \
$CellContext`al2) $CellContext`v1p $CellContext`vR}, {($CellContext`al1 + \
$CellContext`al3) $CellContext`v1 $CellContext`vL, ($CellContext`al1 + \
$CellContext`al3) $CellContext`v1 $CellContext`vR, 
      Rational[1, 2] ((-2) FeynRules`mu1^2 + 
       6 $CellContext`lam2 $CellContext`v1^2 + 
       8 $CellContext`lam3 $CellContext`v1p^2 + 
       2 $CellContext`lam5 $CellContext`v1p^2 + 
       2 $CellContext`lam6 $CellContext`v1p^2 + 
       2 $CellContext`lam1 (
         3 $CellContext`v1^2 + $CellContext`v1p^2) + $CellContext`al1 \
$CellContext`vL^2 + $CellContext`al3 $CellContext`vL^2 + $CellContext`al1 \
$CellContext`vR^2 + $CellContext`al3 $CellContext`vR^2), 
      2 ($CellContext`lam1 + 
       4 $CellContext`lam3 + $CellContext`lam5 + $CellContext`lam6) \
$CellContext`v1 $CellContext`v1p}, {($CellContext`al1 + $CellContext`al2) \
$CellContext`v1p $CellContext`vL, ($CellContext`al1 + $CellContext`al2) \
$CellContext`v1p $CellContext`vR, 
      2 ($CellContext`lam1 + 
       4 $CellContext`lam3 + $CellContext`lam5 + $CellContext`lam6) \
$CellContext`v1 $CellContext`v1p, 
      Rational[1, 2] ((-2) FeynRules`mu1^2 + 
       8 $CellContext`lam3 $CellContext`v1^2 + 
       2 $CellContext`lam5 $CellContext`v1^2 + 
       2 $CellContext`lam6 $CellContext`v1^2 + 
       6 $CellContext`lam2 $CellContext`v1p^2 + 
       2 $CellContext`lam1 ($CellContext`v1^2 + 
         3 $CellContext`v1p^2) + $CellContext`al1 $CellContext`vL^2 + \
$CellContext`al2 $CellContext`vL^2 + $CellContext`al1 $CellContext`vR^2 + \
$CellContext`al2 $CellContext`vR^2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.56809618938696*^9, 3.568098121364786*^9, {3.568290616261177*^9, 
   3.568290623977722*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Mixing matrix = \"\>", "\[InvisibleSpace]", 
   TagBox["\<\"Please use the numerical code.\"\>",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["  Mixing matrix = ", 
   MatrixForm["Please use the numerical code."]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.56809618938696*^9, 3.568098121364786*^9, {3.568290616261177*^9, 
   3.568290623981736*^9}}],

Cell[BoxData["\<\"Pseudoscalar sector\"\>"], "Print",
 CellChangeTimes->{
  3.56809618938696*^9, 3.568098121364786*^9, {3.568290616261177*^9, 
   3.56829062398346*^9}}],

Cell[BoxData["\<\"***************************************************\"\>"], \
"Print",
 CellChangeTimes->{
  3.56809618938696*^9, 3.568098121364786*^9, {3.568290616261177*^9, 
   3.568290623985106*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Mass basis = \"\>", "\[InvisibleSpace]", 
   RowBox[{"{", 
    RowBox[{"G01", ",", "G02", ",", "a01", ",", "a02"}], "}"}], 
   "\[InvisibleSpace]", "\<\"\\n  Block = \"\>", "\[InvisibleSpace]", "AMix", 
   "\[InvisibleSpace]", "\<\"\\n  Symbol = \"\>", "\[InvisibleSpace]", "UAN"}],
  SequenceForm[
  "  Mass basis = ", {$CellContext`G01, $CellContext`G02, $CellContext`a01, \
$CellContext`a02}, "\n  Block = ", $CellContext`AMix, 
   "\n  Symbol = ", $CellContext`UAN],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.56809618938696*^9, 3.568098121364786*^9, {3.568290616261177*^9, 
   3.5682906239868603`*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Squared mass matrix = \"\>", "\[InvisibleSpace]", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "2", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Rho]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Rho]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Rho]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], "0", "0", 
        "0"},
       {"0", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "2", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Rho]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Rho]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "-", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Rho]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], "0", "0"},
       {"0", "0", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "2"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "-", 
           RowBox[{"8", " ", 
            SubscriptBox["\[Lambda]", "4"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "5"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "-", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "6"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "3"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "4"]}], "+", 
           SubscriptBox["\[Lambda]", "6"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False]}]},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "3"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "4"]}], "+", 
           SubscriptBox["\[Lambda]", "6"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False]}], 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "1", "2"]}], "-", 
           RowBox[{"8", " ", 
            SubscriptBox["\[Lambda]", "4"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "5"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "-", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "6"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["  Squared mass matrix = ", 
   MatrixForm[{{
     Rational[1, 2] ((-2) 
        FeynRules`mu2^2 + $CellContext`al3 $CellContext`v1^2 + \
$CellContext`al2 $CellContext`v1p^2 + $CellContext`al1 ($CellContext`v1^2 + \
$CellContext`v1p^2) + 2 $CellContext`rho1 $CellContext`vL^2 + 
       2 $CellContext`rho2 $CellContext`vL^2 + $CellContext`rho3 \
$CellContext`vR^2), 0, 0, 0}, {
     0, Rational[
       1, 2] ((-2) 
        FeynRules`mu2^2 + $CellContext`al3 $CellContext`v1^2 + \
$CellContext`al2 $CellContext`v1p^2 + $CellContext`al1 ($CellContext`v1^2 + \
$CellContext`v1p^2) + $CellContext`rho3 $CellContext`vL^2 + 
       2 $CellContext`rho1 $CellContext`vR^2 - 
       2 $CellContext`rho2 $CellContext`vR^2), 0, 0}, {
     0, 0, Rational[1, 2] ((-2) FeynRules`mu1^2 + 
       2 $CellContext`lam2 $CellContext`v1^2 - 
       8 $CellContext`lam4 $CellContext`v1p^2 + 
       2 $CellContext`lam5 $CellContext`v1p^2 - 
       2 $CellContext`lam6 $CellContext`v1p^2 + 
       2 $CellContext`lam1 ($CellContext`v1^2 + $CellContext`v1p^2) + \
$CellContext`al1 $CellContext`vL^2 + $CellContext`al3 $CellContext`vL^2 + \
$CellContext`al1 $CellContext`vR^2 + $CellContext`al3 $CellContext`vR^2), \
(-2) (2 $CellContext`lam3 + 
       2 $CellContext`lam4 + $CellContext`lam6) $CellContext`v1 \
$CellContext`v1p}, {
     0, 0, (-2) (2 $CellContext`lam3 + 
       2 $CellContext`lam4 + $CellContext`lam6) $CellContext`v1 \
$CellContext`v1p, 
      Rational[1, 2] ((-2) FeynRules`mu1^2 - 
       8 $CellContext`lam4 $CellContext`v1^2 + 
       2 $CellContext`lam5 $CellContext`v1^2 - 
       2 $CellContext`lam6 $CellContext`v1^2 + 
       2 $CellContext`lam2 $CellContext`v1p^2 + 
       2 $CellContext`lam1 ($CellContext`v1^2 + $CellContext`v1p^2) + \
$CellContext`al1 $CellContext`vL^2 + $CellContext`al2 $CellContext`vL^2 + \
$CellContext`al1 $CellContext`vR^2 + $CellContext`al2 $CellContext`vR^2)}}]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.56809618938696*^9, 3.568098121364786*^9, {3.568290616261177*^9, 
   3.568290623990456*^9}}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"  Mixing matrix = \"\>", "\[InvisibleSpace]", 
   TagBox["\<\"Please use the numerical code.\"\>",
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}],
  SequenceForm["  Mixing matrix = ", 
   MatrixForm["Please use the numerical code."]],
  Editable->False]], "Print",
 CellChangeTimes->{
  3.56809618938696*^9, 3.568098121364786*^9, {3.568290616261177*^9, 
   3.568290623993684*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Print the scalar mass matrix of mixing \[OpenCurlyQuote]2e\[CloseCurlyQuote]\
\>", "Subsection",
 CellChangeTimes->{{3.5680981329843807`*^9, 3.5680982021358967`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MassMatrix", "[", 
   RowBox[{"\"\<2e\>\"", ",", " ", "\"\<S\>\""}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.56809816954711*^9, 3.568098187162857*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubsuperscriptBox["\[Mu]", "2", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "3"], " ", 
          SubsuperscriptBox["v", "1", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            InterpretationBox[
             SubsuperscriptBox["v", "1", "\<\"'\"\>"],
             Subsuperscript[FeynRules`v, 1, "'"],
             Editable->False], ")"}], "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "1"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["v", "1", "2"], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], ")"}]}], "+", 
         RowBox[{"6", " ", 
          SubscriptBox["\[Rho]", "1"], " ", 
          SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
         RowBox[{"6", " ", 
          SubscriptBox["\[Rho]", "2"], " ", 
          SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Rho]", "3"], " ", 
          SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], 
      RowBox[{
       SubscriptBox["\[Rho]", "3"], " ", 
       SubscriptBox["v", "\<\"L\"\>"], " ", 
       SubscriptBox["v", "\<\"R\"\>"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Alpha]", "1"], "+", 
         SubscriptBox["\[Alpha]", "3"]}], ")"}], " ", 
       SubscriptBox["v", "1"], " ", 
       SubscriptBox["v", "\<\"L\"\>"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Alpha]", "1"], "+", 
         SubscriptBox["\[Alpha]", "2"]}], ")"}], " ", 
       InterpretationBox[
        SubsuperscriptBox["v", "1", "\<\"'\"\>"],
        Subsuperscript[FeynRules`v, 1, "'"],
        Editable->False], " ", 
       SubscriptBox["v", "\<\"L\"\>"]}]},
     {
      RowBox[{
       SubscriptBox["\[Rho]", "3"], " ", 
       SubscriptBox["v", "\<\"L\"\>"], " ", 
       SubscriptBox["v", "\<\"R\"\>"]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubsuperscriptBox["\[Mu]", "2", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "3"], " ", 
          SubsuperscriptBox["v", "1", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            InterpretationBox[
             SubsuperscriptBox["v", "1", "\<\"'\"\>"],
             Subsuperscript[FeynRules`v, 1, "'"],
             Editable->False], ")"}], "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "1"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["v", "1", "2"], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], ")"}]}], "+", 
         RowBox[{
          SubscriptBox["\[Rho]", "3"], " ", 
          SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
         RowBox[{"6", " ", 
          SubscriptBox["\[Rho]", "1"], " ", 
          SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "-", 
         RowBox[{"6", " ", 
          SubscriptBox["\[Rho]", "2"], " ", 
          SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Alpha]", "1"], "+", 
         SubscriptBox["\[Alpha]", "3"]}], ")"}], " ", 
       SubscriptBox["v", "1"], " ", 
       SubscriptBox["v", "\<\"R\"\>"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Alpha]", "1"], "+", 
         SubscriptBox["\[Alpha]", "2"]}], ")"}], " ", 
       InterpretationBox[
        SubsuperscriptBox["v", "1", "\<\"'\"\>"],
        Subsuperscript[FeynRules`v, 1, "'"],
        Editable->False], " ", 
       SubscriptBox["v", "\<\"R\"\>"]}]},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Alpha]", "1"], "+", 
         SubscriptBox["\[Alpha]", "3"]}], ")"}], " ", 
       SubscriptBox["v", "1"], " ", 
       SubscriptBox["v", "\<\"L\"\>"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Alpha]", "1"], "+", 
         SubscriptBox["\[Alpha]", "3"]}], ")"}], " ", 
       SubscriptBox["v", "1"], " ", 
       SubscriptBox["v", "\<\"R\"\>"]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
         RowBox[{"6", " ", 
          SubscriptBox["\[Lambda]", "2"], " ", 
          SubsuperscriptBox["v", "1", "2"]}], "+", 
         RowBox[{"8", " ", 
          SubscriptBox["\[Lambda]", "3"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            InterpretationBox[
             SubsuperscriptBox["v", "1", "\<\"'\"\>"],
             Subsuperscript[FeynRules`v, 1, "'"],
             Editable->False], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "5"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            InterpretationBox[
             SubsuperscriptBox["v", "1", "\<\"'\"\>"],
             Subsuperscript[FeynRules`v, 1, "'"],
             Editable->False], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "6"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            InterpretationBox[
             SubsuperscriptBox["v", "1", "\<\"'\"\>"],
             Subsuperscript[FeynRules`v, 1, "'"],
             Editable->False], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "1"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"3", " ", 
             SubsuperscriptBox["v", "1", "2"]}], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], ")"}]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "1"], " ", 
          SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "3"], " ", 
          SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "1"], " ", 
          SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "3"], " ", 
          SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Lambda]", "1"], "+", 
         RowBox[{"4", " ", 
          SubscriptBox["\[Lambda]", "3"]}], "+", 
         SubscriptBox["\[Lambda]", "5"], "+", 
         SubscriptBox["\[Lambda]", "6"]}], ")"}], " ", 
       SubscriptBox["v", "1"], " ", 
       InterpretationBox[
        SubsuperscriptBox["v", "1", "\<\"'\"\>"],
        Subsuperscript[FeynRules`v, 1, "'"],
        Editable->False]}]},
     {
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Alpha]", "1"], "+", 
         SubscriptBox["\[Alpha]", "2"]}], ")"}], " ", 
       InterpretationBox[
        SubsuperscriptBox["v", "1", "\<\"'\"\>"],
        Subsuperscript[FeynRules`v, 1, "'"],
        Editable->False], " ", 
       SubscriptBox["v", "\<\"L\"\>"]}], 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Alpha]", "1"], "+", 
         SubscriptBox["\[Alpha]", "2"]}], ")"}], " ", 
       InterpretationBox[
        SubsuperscriptBox["v", "1", "\<\"'\"\>"],
        Subsuperscript[FeynRules`v, 1, "'"],
        Editable->False], " ", 
       SubscriptBox["v", "\<\"R\"\>"]}], 
      RowBox[{"2", " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["\[Lambda]", "1"], "+", 
         RowBox[{"4", " ", 
          SubscriptBox["\[Lambda]", "3"]}], "+", 
         SubscriptBox["\[Lambda]", "5"], "+", 
         SubscriptBox["\[Lambda]", "6"]}], ")"}], " ", 
       SubscriptBox["v", "1"], " ", 
       InterpretationBox[
        SubsuperscriptBox["v", "1", "\<\"'\"\>"],
        Subsuperscript[FeynRules`v, 1, "'"],
        Editable->False]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
         RowBox[{"8", " ", 
          SubscriptBox["\[Lambda]", "3"], " ", 
          SubsuperscriptBox["v", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "5"], " ", 
          SubsuperscriptBox["v", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "6"], " ", 
          SubsuperscriptBox["v", "1", "2"]}], "+", 
         RowBox[{"6", " ", 
          SubscriptBox["\[Lambda]", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            InterpretationBox[
             SubsuperscriptBox["v", "1", "\<\"'\"\>"],
             Subsuperscript[FeynRules`v, 1, "'"],
             Editable->False], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "1"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["v", "1", "2"], "+", 
            RowBox[{"3", " ", 
             SuperscriptBox[
              RowBox[{"(", 
               InterpretationBox[
                SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                Subsuperscript[FeynRules`v, 1, "'"],
                Editable->False], ")"}], "2"]}]}], ")"}]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "1"], " ", 
          SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "2"], " ", 
          SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "1"], " ", 
          SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "2"], " ", 
          SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.568098176013557*^9, 3.5680981875385637`*^9}, 
   3.568290657466407*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Print the pseudo scalar mass matrix of mixing \[OpenCurlyQuote]2e\
\[CloseCurlyQuote]\
\>", "Subsection",
 CellChangeTimes->{{3.5680982058150387`*^9, 3.568098217423275*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"MassMatrix", "[", 
   RowBox[{"\"\<2e\>\"", ",", " ", "\"\<PS\>\""}], "]"}], "//", 
  "MatrixForm"}]], "Input",
 CellChangeTimes->{{3.56809821834832*^9, 3.568098232696155*^9}}],

Cell[BoxData[
 TagBox[
  RowBox[{"(", "\[NoBreak]", GridBox[{
     {
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubsuperscriptBox["\[Mu]", "2", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "3"], " ", 
          SubsuperscriptBox["v", "1", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            InterpretationBox[
             SubsuperscriptBox["v", "1", "\<\"'\"\>"],
             Subsuperscript[FeynRules`v, 1, "'"],
             Editable->False], ")"}], "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "1"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["v", "1", "2"], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], ")"}]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Rho]", "1"], " ", 
          SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Rho]", "2"], " ", 
          SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Rho]", "3"], " ", 
          SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], "0", "0", 
      "0"},
     {"0", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubsuperscriptBox["\[Mu]", "2", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "3"], " ", 
          SubsuperscriptBox["v", "1", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            InterpretationBox[
             SubsuperscriptBox["v", "1", "\<\"'\"\>"],
             Subsuperscript[FeynRules`v, 1, "'"],
             Editable->False], ")"}], "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "1"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["v", "1", "2"], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], ")"}]}], "+", 
         RowBox[{
          SubscriptBox["\[Rho]", "3"], " ", 
          SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Rho]", "1"], " ", 
          SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Rho]", "2"], " ", 
          SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], "0", "0"},
     {"0", "0", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "2"], " ", 
          SubsuperscriptBox["v", "1", "2"]}], "-", 
         RowBox[{"8", " ", 
          SubscriptBox["\[Lambda]", "4"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            InterpretationBox[
             SubsuperscriptBox["v", "1", "\<\"'\"\>"],
             Subsuperscript[FeynRules`v, 1, "'"],
             Editable->False], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "5"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            InterpretationBox[
             SubsuperscriptBox["v", "1", "\<\"'\"\>"],
             Subsuperscript[FeynRules`v, 1, "'"],
             Editable->False], ")"}], "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "6"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            InterpretationBox[
             SubsuperscriptBox["v", "1", "\<\"'\"\>"],
             Subsuperscript[FeynRules`v, 1, "'"],
             Editable->False], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "1"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["v", "1", "2"], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], ")"}]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "1"], " ", 
          SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "3"], " ", 
          SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "1"], " ", 
          SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "3"], " ", 
          SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "4"]}], "+", 
         SubscriptBox["\[Lambda]", "6"]}], ")"}], " ", 
       SubscriptBox["v", "1"], " ", 
       InterpretationBox[
        SubsuperscriptBox["v", "1", "\<\"'\"\>"],
        Subsuperscript[FeynRules`v, 1, "'"],
        Editable->False]}]},
     {"0", "0", 
      RowBox[{
       RowBox[{"-", "2"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "3"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "4"]}], "+", 
         SubscriptBox["\[Lambda]", "6"]}], ")"}], " ", 
       SubscriptBox["v", "1"], " ", 
       InterpretationBox[
        SubsuperscriptBox["v", "1", "\<\"'\"\>"],
        Subsuperscript[FeynRules`v, 1, "'"],
        Editable->False]}], 
      RowBox[{
       FractionBox["1", "2"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "2"}], " ", 
          SubsuperscriptBox["\[Mu]", "1", "2"]}], "-", 
         RowBox[{"8", " ", 
          SubscriptBox["\[Lambda]", "4"], " ", 
          SubsuperscriptBox["v", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "5"], " ", 
          SubsuperscriptBox["v", "1", "2"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "6"], " ", 
          SubsuperscriptBox["v", "1", "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "2"], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            InterpretationBox[
             SubsuperscriptBox["v", "1", "\<\"'\"\>"],
             Subsuperscript[FeynRules`v, 1, "'"],
             Editable->False], ")"}], "2"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["\[Lambda]", "1"], " ", 
          RowBox[{"(", 
           RowBox[{
            SubsuperscriptBox["v", "1", "2"], "+", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], ")"}]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "1"], " ", 
          SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "2"], " ", 
          SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "1"], " ", 
          SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "+", 
         RowBox[{
          SubscriptBox["\[Alpha]", "2"], " ", 
          SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}]}
    },
    GridBoxAlignment->{
     "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
      "RowsIndexed" -> {}},
    GridBoxSpacings->{"Columns" -> {
        Offset[0.27999999999999997`], {
         Offset[0.7]}, 
        Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
        Offset[0.2], {
         Offset[0.4]}, 
        Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
  Function[BoxForm`e$, 
   MatrixForm[BoxForm`e$]]]], "Output",
 CellChangeTimes->{{3.568098225955304*^9, 3.568098233101625*^9}, 
   3.568290661840715*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Write the ASperGe package", "Section",
 CellChangeTimes->{{3.568034265705269*^9, 3.568034271048539*^9}}],

Cell[CellGroupData[{

Cell["\<\
Write the output for all mass matrices to the folder \
\[OpenCurlyQuote]LRSM_mix_MD\[CloseCurlyQuote] in $FeynRulesPath\
\>", "Subsection",
 CellChangeTimes->{{3.5680962205673933`*^9, 3.5680962369473886`*^9}, {
  3.56809827000555*^9, 3.568098272037425*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteASperGe", "[", "LagLRSM", "]"}]], "Input",
 CellChangeTimes->{{3.568096225027586*^9, 3.568096233868973*^9}, {
  3.568098243583331*^9, 3.56809824773551*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Parameters.cpp and Parameters.hpp output is finished.\\n \
They have been stored in /Users/Karen/trunk/feynrules-development/LRSM_mix_MD\
\"\>"], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.56829089682653*^9}],

Cell[BoxData["\<\"Checking parameter list...\"\>"], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897174303*^9}],

Cell[BoxData["\<\"Warning: Goldstone bosons will be ignored.\"\>"], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.56829089717889*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: No mass value found for \"\>", 
   "\[InvisibleSpace]", "\<\"MD\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: No mass value found for ", "MD", ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897184017*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: No mass value found for \"\>", 
   "\[InvisibleSpace]", "\<\"MU\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: No mass value found for ", "MU", ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897187224*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: No mass value found for \"\>", 
   "\[InvisibleSpace]", "\<\"WT\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: No mass value found for ", "WT", ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897192576*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: No mass value found for \"\>", 
   "\[InvisibleSpace]", "\<\"WZ\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: No mass value found for ", "WZ", ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.56829089719694*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"aS\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "aS", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897200604*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq11x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq11x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897206191*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq11x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq11x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897208899*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq11x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq11x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897211694*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq12x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq12x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897215962*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq12x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq12x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908972210503`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq12x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq12x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908972262*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq13x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq13x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908972308607`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq13x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq13x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897238351*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq13x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq13x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897242631*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq11x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq11x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908972468*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq11x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq11x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897249861*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq11x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq11x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897255315*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq12x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq12x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908972598953`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq12x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq12x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908972636223`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq12x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq12x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897267878*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq13x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq13x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908972707777`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq13x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq13x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897273156*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq13x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq13x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897275406*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl11x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl11x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897278075*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl11x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl11x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908972804403`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl11x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl11x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897283744*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl12x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl12x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897287002*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl12x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl12x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897290009*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl12x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl12x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908972932587`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl13x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl13x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.56829089729583*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl13x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl13x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897298378*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl13x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl13x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897301693*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl11x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl11x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908973054953`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl11x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl11x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908973079853`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl11x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl11x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908973105993`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl12x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl12x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.56829089731313*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl12x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl12x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897315627*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl12x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl12x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.56829089731812*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl13x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl13x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.56829089732047*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl13x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl13x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897322781*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl13x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl13x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897325243*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl31x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl31x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897327765*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl31x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl31x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897330595*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl31x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl31x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897333441*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl32x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl32x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897336155*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl32x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl32x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897339777*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl32x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl32x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908973422537`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl33x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl33x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897344597*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl33x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl33x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897347068*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl33x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl33x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.56829089734997*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl31x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl31x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897352364*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl31x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl31x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897354658*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl31x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl31x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897357095*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl32x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl32x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897359573*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl32x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl32x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908973621798`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl32x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl32x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897364788*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl33x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl33x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897367181*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl33x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl33x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908973695498`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl33x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl33x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897372196*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl41x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl41x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.56829089737499*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl41x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl41x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908973786077`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl41x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl41x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897381366*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl42x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl42x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897383931*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl42x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl42x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908973862658`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl42x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl42x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908973885927`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl43x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl43x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.56829089739117*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl43x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl43x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897393656*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl43x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl43x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897396226*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl41x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl41x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897398849*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl41x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl41x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908974011993`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl41x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl41x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897403532*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl42x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl42x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897406248*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl42x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl42x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897409004*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl42x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl42x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897411419*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl43x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl43x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897413795*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl43x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl43x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897417232*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl43x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl43x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897419632*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RLAM1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RLAM1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908974219627`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"ILAM1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "ILAM1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897426277*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RLAM2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RLAM2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.56829089742899*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"ILAM2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "ILAM2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897432036*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RLAM3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RLAM3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897434476*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"ILAM3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "ILAM3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897437044*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RLAM4\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RLAM4", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897439492*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"ILAM4\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "ILAM4", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897442545*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RLAM5\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RLAM5", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897445137*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"ILAM5\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "ILAM5", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897448092*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RLAM6\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RLAM6", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897450492*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"ILAM6\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "ILAM6", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.56829089745297*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RRHO1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RRHO1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908974554462`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"IRHO1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "IRHO1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908974590673`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RRHO2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RRHO2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897463662*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"IRHO2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "IRHO2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908974681177`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RRHO3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RRHO3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897470942*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"IRHO3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "IRHO3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897473403*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RAL1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RAL1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908974757853`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"IAL1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "IAL1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897478323*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RAL2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RAL2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897480877*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"IAL2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "IAL2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.56829089748387*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RAL3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RAL3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897486517*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"IAL3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "IAL3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.5682908974889593`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Output written on \"\>", 
   "\[InvisibleSpace]", "\<\"input/externals.dat\"\>"}],
  SequenceForm["Output written on ", "input/externals.dat"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290677066638*^9, 3.5682907240352697`*^9, 
  3.568290897491383*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Write the output to the folder \[OpenCurlyQuote]LRSM\[CloseCurlyQuote] in \
$FeynRulesPath only for mixing \[OpenCurlyQuote]2e\[CloseCurlyQuote]\
\>", "Subsection",
 CellChangeTimes->{{3.568096247910824*^9, 3.568096269824924*^9}, {
  3.568096357314967*^9, 3.568096357774859*^9}, {3.568098275605797*^9, 
  3.5680982913881598`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteASperGe", "[", 
  RowBox[{"LagLRSM", ",", " ", 
   RowBox[{"Output", "\[Rule]", "\"\<LRSM\>\""}], ",", " ", 
   RowBox[{"Mix", "\[Rule]", " ", "\"\<2e\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.5680343410263853`*^9, 3.5680343452721643`*^9}, {
  3.568096361840968*^9, 3.568096369463834*^9}, {3.5680982512410593`*^9, 
  3.568098263655603*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "2", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Rho]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Rho]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Rho]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], 
        RowBox[{
         SubscriptBox["\[Rho]", "3"], " ", 
         SubscriptBox["v", "\<\"L\"\>"], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "3"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         SubscriptBox["v", "\<\"L\"\>"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "2"]}], ")"}], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False], " ", 
         SubscriptBox["v", "\<\"L\"\>"]}]},
       {
        RowBox[{
         SubscriptBox["\[Rho]", "3"], " ", 
         SubscriptBox["v", "\<\"L\"\>"], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}], 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "2", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Rho]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Rho]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "-", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Rho]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "3"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "2"]}], ")"}], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}]},
       {
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "3"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         SubscriptBox["v", "\<\"L\"\>"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "3"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}], 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Lambda]", "2"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"8", " ", 
            SubscriptBox["\[Lambda]", "3"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "5"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "6"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              RowBox[{"3", " ", 
               SubsuperscriptBox["v", "1", "2"]}], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Lambda]", "1"], "+", 
           RowBox[{"4", " ", 
            SubscriptBox["\[Lambda]", "3"]}], "+", 
           SubscriptBox["\[Lambda]", "5"], "+", 
           SubscriptBox["\[Lambda]", "6"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False]}]},
       {
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "2"]}], ")"}], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False], " ", 
         SubscriptBox["v", "\<\"L\"\>"]}], 
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Alpha]", "1"], "+", 
           SubscriptBox["\[Alpha]", "2"]}], ")"}], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False], " ", 
         SubscriptBox["v", "\<\"R\"\>"]}], 
        RowBox[{"2", " ", 
         RowBox[{"(", 
          RowBox[{
           SubscriptBox["\[Lambda]", "1"], "+", 
           RowBox[{"4", " ", 
            SubscriptBox["\[Lambda]", "3"]}], "+", 
           SubscriptBox["\[Lambda]", "5"], "+", 
           SubscriptBox["\[Lambda]", "6"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False]}], 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
           RowBox[{"8", " ", 
            SubscriptBox["\[Lambda]", "3"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "5"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "6"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"6", " ", 
            SubscriptBox["\[Lambda]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              RowBox[{"3", " ", 
               SuperscriptBox[
                RowBox[{"(", 
                 InterpretationBox[
                  SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                  Subsuperscript[FeynRules`v, 1, "'"],
                  Editable->False], ")"}], "2"]}]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]], ",", 
   TagBox[
    RowBox[{"(", "\[NoBreak]", GridBox[{
       {
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "2", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Rho]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Rho]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Rho]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], "0", "0", 
        "0"},
       {"0", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "2", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Rho]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Rho]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "-", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Rho]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], "0", "0"},
       {"0", "0", 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "1", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "2"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "-", 
           RowBox[{"8", " ", 
            SubscriptBox["\[Lambda]", "4"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "5"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "-", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "6"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "3"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}], 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "3"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "4"]}], "+", 
           SubscriptBox["\[Lambda]", "6"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False]}]},
       {"0", "0", 
        RowBox[{
         RowBox[{"-", "2"}], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "3"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "4"]}], "+", 
           SubscriptBox["\[Lambda]", "6"]}], ")"}], " ", 
         SubscriptBox["v", "1"], " ", 
         InterpretationBox[
          SubsuperscriptBox["v", "1", "\<\"'\"\>"],
          Subsuperscript[FeynRules`v, 1, "'"],
          Editable->False]}], 
        RowBox[{
         FractionBox["1", "2"], " ", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            RowBox[{"-", "2"}], " ", 
            SubsuperscriptBox["\[Mu]", "1", "2"]}], "-", 
           RowBox[{"8", " ", 
            SubscriptBox["\[Lambda]", "4"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "5"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "-", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "6"], " ", 
            SubsuperscriptBox["v", "1", "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "2"], " ", 
            SuperscriptBox[
             RowBox[{"(", 
              InterpretationBox[
               SubsuperscriptBox["v", "1", "\<\"'\"\>"],
               Subsuperscript[FeynRules`v, 1, "'"],
               Editable->False], ")"}], "2"]}], "+", 
           RowBox[{"2", " ", 
            SubscriptBox["\[Lambda]", "1"], " ", 
            RowBox[{"(", 
             RowBox[{
              SubsuperscriptBox["v", "1", "2"], "+", 
              SuperscriptBox[
               RowBox[{"(", 
                InterpretationBox[
                 SubsuperscriptBox["v", "1", "\<\"'\"\>"],
                 Subsuperscript[FeynRules`v, 1, "'"],
                 Editable->False], ")"}], "2"]}], ")"}]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"L\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "1"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}], "+", 
           RowBox[{
            SubscriptBox["\[Alpha]", "2"], " ", 
            SubsuperscriptBox["v", "\<\"R\"\>", "2"]}]}], ")"}]}]}
      },
      GridBoxAlignment->{
       "Columns" -> {{Center}}, "ColumnsIndexed" -> {}, 
        "Rows" -> {{Baseline}}, "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.4]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], "\[NoBreak]", ")"}],
    Function[BoxForm`e$, 
     MatrixForm[BoxForm`e$]]]}], "}"}]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170597967*^9}],

Cell[BoxData["\<\"Parameters.cpp and Parameters.hpp output is finished.\\n \
They have been stored in /Users/Karen/trunk/feynrules-development/LRSM\"\>"], \
"Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170799202*^9}],

Cell[BoxData["\<\"Checking parameter list...\"\>"], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911708545723`*^9}],

Cell[BoxData["\<\"Warning: Goldstone bosons will be ignored.\"\>"], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170857473*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: No mass value found for \"\>", 
   "\[InvisibleSpace]", "\<\"MD\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: No mass value found for ", "MD", ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911708607264`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: No mass value found for \"\>", 
   "\[InvisibleSpace]", "\<\"MU\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: No mass value found for ", "MU", ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170863185*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: No mass value found for \"\>", 
   "\[InvisibleSpace]", "\<\"WT\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: No mass value found for ", "WT", ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170865652*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: No mass value found for \"\>", 
   "\[InvisibleSpace]", "\<\"WZ\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: No mass value found for ", "WZ", ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170868141*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"aS\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "aS", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170870659*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq11x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq11x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170874049*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq11x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq11x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170877015*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq11x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq11x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170879589*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq12x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq12x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170881863*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq12x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq12x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911708848743`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq12x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq12x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170889283*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq13x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq13x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170893581*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq13x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq13x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170896055*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryq13x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryq13x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170898415*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq11x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq11x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911709007607`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq11x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq11x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170903091*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq11x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq11x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170905426*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq12x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq12x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170907824*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq12x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq12x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170911737*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq12x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq12x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911709159718`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq13x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq13x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170919915*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq13x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq13x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911709227467`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyq13x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyq13x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170925148*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl11x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl11x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170927898*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl11x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl11x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170930779*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl11x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl11x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911709334497`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl12x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl12x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170935726*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl12x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl12x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170937945*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl12x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl12x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911709401493`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl13x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl13x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911709423943`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl13x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl13x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170944811*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl13x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl13x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911709471197`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl11x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl11x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170949359*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl11x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl11x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170951631*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl11x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl11x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911709539967`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl12x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl12x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170956279*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl12x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl12x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.56829117095864*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl12x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl12x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.56829117096093*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl13x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl13x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911709631844`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl13x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl13x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170965514*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl13x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl13x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170968824*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl31x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl31x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911709730043`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl31x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl31x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170976799*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl31x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl31x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170979156*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl32x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl32x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170981406*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl32x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl32x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170983659*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl32x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl32x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911709859*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl33x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl33x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170988221*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl33x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl33x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170990472*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl33x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl33x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911709927187`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl31x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl31x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291170994998*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl31x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl31x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911709981337`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl31x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl31x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171000741*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl32x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl32x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171003038*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl32x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl32x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171005293*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl32x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl32x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171007639*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl33x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl33x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171011524*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl33x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl33x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171015708*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl33x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl33x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171019203*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl41x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl41x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171021523*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl41x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl41x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171023779*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl41x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl41x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.56829117102617*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl42x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl42x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171028488*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl42x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl42x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911710310183`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl42x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl42x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171033285*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl43x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl43x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911710355387`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl43x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl43x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911710378304`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Ryl43x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Ryl43x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171040165*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl41x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl41x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.56829117104246*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl41x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl41x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911710447483`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl41x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl41x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171047666*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl42x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl42x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171050202*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl42x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl42x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171054332*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl42x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl42x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171058481*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl43x1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl43x1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171061471*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl43x2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl43x2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911710646553`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"Iyl43x3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "Iyl43x3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171067328*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RLAM1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RLAM1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171069613*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"ILAM1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "ILAM1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911710718403`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RLAM2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RLAM2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171074089*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"ILAM2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "ILAM2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171076317*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RLAM3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RLAM3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171078588*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"ILAM3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "ILAM3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171080927*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RLAM4\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RLAM4", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171083726*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"ILAM4\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "ILAM4", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911710867434`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RLAM5\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RLAM5", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911710898657`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"ILAM5\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "ILAM5", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911710932093`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RLAM6\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RLAM6", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171098735*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"ILAM6\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "ILAM6", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171104519*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RRHO1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RRHO1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911711089582`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"IRHO1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "IRHO1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171112159*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RRHO2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RRHO2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.56829117111487*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"IRHO2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "IRHO2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171117475*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RRHO3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RRHO3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911711211853`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"IRHO3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "IRHO3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911711250057`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RAL1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RAL1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911711284533`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"IAL1\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "IAL1", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171132678*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RAL2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RAL2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.56829117113678*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"IAL2\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "IAL2", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911711395283`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"RAL3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "RAL3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171144082*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Warning: no value found for parameter \"\>", 
   "\[InvisibleSpace]", "\<\"IAL3\"\>", 
   "\[InvisibleSpace]", "\<\". Default value 1 assigned.\"\>"}],
  SequenceForm[
  "Warning: no value found for parameter ", "IAL3", 
   ". Default value 1 assigned."],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.5682911711489897`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Output written on \"\>", 
   "\[InvisibleSpace]", "\<\"input/externals.dat\"\>"}],
  SequenceForm["Output written on ", "input/externals.dat"],
  Editable->False]], "Print",
 CellChangeTimes->{3.568290688352541*^9, 3.568291171153789*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
Compile and excecute ASperGe and
load the output file back into FeynRules\
\>", "Section",
 CellChangeTimes->{3.568034375175974*^9}],

Cell[BoxData[
 RowBox[{"RunASperGe", "[", "]"}]], "Input",
 CellChangeTimes->{{3.568034380231674*^9, 3.5680343839741983`*^9}}]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1022, 666},
WindowMargins->{{Automatic, 120}, {Automatic, 0}},
FrontEndVersion->"8.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (August 26, \
2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[579, 22, 141, 4, 123, "Title"],
Cell[723, 28, 118, 2, 27, "Input"],
Cell[CellGroupData[{
Cell[866, 34, 97, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[988, 39, 424, 11, 58, "Input"],
Cell[CellGroupData[{
Cell[1437, 54, 235, 3, 20, "Print"],
Cell[1675, 59, 516, 10, 20, "Print"],
Cell[2194, 71, 289, 4, 20, "Print"],
Cell[2486, 77, 221, 3, 20, "Print"],
Cell[2710, 82, 293, 4, 20, "Print"],
Cell[3006, 88, 251, 3, 20, "Print"],
Cell[3260, 93, 221, 3, 20, "Print"],
Cell[3484, 98, 288, 4, 20, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[3833, 109, 103, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[3961, 114, 317, 7, 43, "Input"],
Cell[CellGroupData[{
Cell[4303, 125, 234, 3, 20, "Print"],
Cell[4540, 130, 205, 3, 20, "Print"],
Cell[4748, 135, 209, 3, 20, "Print"],
Cell[4960, 140, 221, 3, 20, "Print"],
Cell[5184, 145, 344, 7, 20, "Print"],
Cell[5531, 154, 207, 3, 20, "Print"],
Cell[5741, 159, 194, 3, 20, "Print"],
Cell[5938, 164, 194, 3, 20, "Print"],
Cell[6135, 169, 242, 4, 20, "Print"],
Cell[6380, 175, 194, 3, 20, "Print"],
Cell[6577, 180, 224, 3, 20, "Print"],
Cell[6804, 185, 227, 3, 20, "Print"],
Cell[7034, 190, 225, 3, 20, "Print"],
Cell[7262, 195, 394, 8, 36, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7717, 210, 121, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[7863, 215, 119, 1, 34, "Subsection"],
Cell[CellGroupData[{
Cell[8007, 220, 336, 5, 27, "Input"],
Cell[CellGroupData[{
Cell[8368, 229, 190, 2, 20, "Print"],
Cell[8561, 233, 373, 7, 20, "Print"],
Cell[8937, 242, 286, 3, 20, "Print"],
Cell[9226, 247, 223, 3, 20, "Print"],
Cell[9452, 252, 335, 4, 36, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9848, 263, 184, 4, 34, "Subsection"],
Cell[10035, 269, 278, 5, 27, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10350, 279, 895, 21, 38, "Subsection"],
Cell[CellGroupData[{
Cell[11270, 304, 406, 7, 27, "Input"],
Cell[CellGroupData[{
Cell[11701, 315, 146, 2, 20, "Print"],
Cell[11850, 319, 348, 7, 20, "Print"],
Cell[12201, 328, 199, 3, 20, "Print"],
Cell[12403, 333, 242, 3, 20, "Print"],
Cell[12648, 338, 20837, 535, 106, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[33546, 880, 754, 20, 38, "Subsection"],
Cell[CellGroupData[{
Cell[34325, 904, 190, 3, 27, "Input"],
Cell[CellGroupData[{
Cell[34540, 911, 569, 16, 26, "Print"],
Cell[35112, 929, 163, 3, 20, "Print"],
Cell[35278, 934, 203, 4, 20, "Print"],
Cell[35484, 940, 667, 14, 51, "Print"],
Cell[36154, 956, 14604, 356, 106, "Print"],
Cell[50761, 1314, 440, 11, 20, "Print"],
Cell[51204, 1327, 168, 3, 20, "Print"],
Cell[51375, 1332, 203, 4, 20, "Print"],
Cell[51581, 1338, 669, 14, 51, "Print"],
Cell[52253, 1354, 11120, 271, 106, "Print"],
Cell[63376, 1627, 440, 11, 20, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[63877, 1645, 176, 3, 35, "Subsection"],
Cell[CellGroupData[{
Cell[64078, 1652, 210, 5, 27, "Input"],
Cell[64291, 1659, 11236, 305, 125, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[75576, 1970, 183, 4, 35, "Subsection"],
Cell[CellGroupData[{
Cell[75784, 1978, 211, 5, 27, "Input"],
Cell[75998, 1985, 8616, 230, 125, "Output"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[84675, 2222, 110, 1, 67, "Section"],
Cell[CellGroupData[{
Cell[84810, 2227, 267, 5, 35, "Subsection"],
Cell[CellGroupData[{
Cell[85102, 2236, 185, 3, 27, "Input"],
Cell[CellGroupData[{
Cell[85312, 2243, 262, 4, 36, "Print"],
Cell[85577, 2249, 151, 2, 20, "Print"],
Cell[85731, 2253, 166, 2, 20, "Print"],
Cell[85900, 2257, 407, 9, 20, "Print"],
Cell[86310, 2268, 407, 9, 20, "Print"],
Cell[86720, 2279, 407, 9, 20, "Print"],
Cell[87130, 2290, 406, 9, 20, "Print"],
Cell[87539, 2301, 421, 10, 20, "Print"],
Cell[87963, 2313, 431, 10, 20, "Print"],
Cell[88397, 2325, 431, 10, 20, "Print"],
Cell[88831, 2337, 431, 10, 20, "Print"],
Cell[89265, 2349, 431, 10, 20, "Print"],
Cell[89699, 2361, 433, 10, 20, "Print"],
Cell[90135, 2373, 429, 10, 20, "Print"],
Cell[90567, 2385, 433, 10, 20, "Print"],
Cell[91003, 2397, 431, 10, 20, "Print"],
Cell[91437, 2409, 431, 10, 20, "Print"],
Cell[91871, 2421, 429, 10, 20, "Print"],
Cell[92303, 2433, 431, 10, 20, "Print"],
Cell[92737, 2445, 431, 10, 20, "Print"],
Cell[93171, 2457, 433, 10, 20, "Print"],
Cell[93607, 2469, 433, 10, 20, "Print"],
Cell[94043, 2481, 431, 10, 20, "Print"],
Cell[94477, 2493, 433, 10, 20, "Print"],
Cell[94913, 2505, 431, 10, 20, "Print"],
Cell[95347, 2517, 431, 10, 20, "Print"],
Cell[95781, 2529, 431, 10, 20, "Print"],
Cell[96215, 2541, 433, 10, 20, "Print"],
Cell[96651, 2553, 431, 10, 20, "Print"],
Cell[97085, 2565, 431, 10, 20, "Print"],
Cell[97519, 2577, 431, 10, 20, "Print"],
Cell[97953, 2589, 433, 10, 20, "Print"],
Cell[98389, 2601, 430, 10, 20, "Print"],
Cell[98822, 2613, 431, 10, 20, "Print"],
Cell[99256, 2625, 431, 10, 20, "Print"],
Cell[99690, 2637, 433, 10, 20, "Print"],
Cell[100126, 2649, 433, 10, 20, "Print"],
Cell[100562, 2661, 433, 10, 20, "Print"],
Cell[100998, 2673, 430, 10, 20, "Print"],
Cell[101431, 2685, 431, 10, 20, "Print"],
Cell[101865, 2697, 430, 10, 20, "Print"],
Cell[102298, 2709, 430, 10, 20, "Print"],
Cell[102731, 2721, 431, 10, 20, "Print"],
Cell[103165, 2733, 431, 10, 20, "Print"],
Cell[103599, 2745, 431, 10, 20, "Print"],
Cell[104033, 2757, 431, 10, 20, "Print"],
Cell[104467, 2769, 431, 10, 20, "Print"],
Cell[104901, 2781, 431, 10, 20, "Print"],
Cell[105335, 2793, 431, 10, 20, "Print"],
Cell[105769, 2805, 433, 10, 20, "Print"],
Cell[106205, 2817, 431, 10, 20, "Print"],
Cell[106639, 2829, 431, 10, 20, "Print"],
Cell[107073, 2841, 430, 10, 20, "Print"],
Cell[107506, 2853, 431, 10, 20, "Print"],
Cell[107940, 2865, 431, 10, 20, "Print"],
Cell[108374, 2877, 431, 10, 20, "Print"],
Cell[108808, 2889, 431, 10, 20, "Print"],
Cell[109242, 2901, 433, 10, 20, "Print"],
Cell[109678, 2913, 431, 10, 20, "Print"],
Cell[110112, 2925, 431, 10, 20, "Print"],
Cell[110546, 2937, 433, 10, 20, "Print"],
Cell[110982, 2949, 431, 10, 20, "Print"],
Cell[111416, 2961, 430, 10, 20, "Print"],
Cell[111849, 2973, 433, 10, 20, "Print"],
Cell[112285, 2985, 431, 10, 20, "Print"],
Cell[112719, 2997, 431, 10, 20, "Print"],
Cell[113153, 3009, 433, 10, 20, "Print"],
Cell[113589, 3021, 433, 10, 20, "Print"],
Cell[114025, 3033, 430, 10, 20, "Print"],
Cell[114458, 3045, 431, 10, 20, "Print"],
Cell[114892, 3057, 431, 10, 20, "Print"],
Cell[115326, 3069, 431, 10, 20, "Print"],
Cell[115760, 3081, 433, 10, 20, "Print"],
Cell[116196, 3093, 431, 10, 20, "Print"],
Cell[116630, 3105, 431, 10, 20, "Print"],
Cell[117064, 3117, 431, 10, 20, "Print"],
Cell[117498, 3129, 431, 10, 20, "Print"],
Cell[117932, 3141, 431, 10, 20, "Print"],
Cell[118366, 3153, 431, 10, 20, "Print"],
Cell[118800, 3165, 431, 10, 20, "Print"],
Cell[119234, 3177, 429, 10, 20, "Print"],
Cell[119666, 3189, 427, 10, 20, "Print"],
Cell[120096, 3201, 426, 10, 20, "Print"],
Cell[120525, 3213, 427, 10, 20, "Print"],
Cell[120955, 3225, 427, 10, 20, "Print"],
Cell[121385, 3237, 427, 10, 20, "Print"],
Cell[121815, 3249, 427, 10, 20, "Print"],
Cell[122245, 3261, 427, 10, 20, "Print"],
Cell[122675, 3273, 427, 10, 20, "Print"],
Cell[123105, 3285, 427, 10, 20, "Print"],
Cell[123535, 3297, 427, 10, 20, "Print"],
Cell[123965, 3309, 426, 10, 20, "Print"],
Cell[124394, 3321, 429, 10, 20, "Print"],
Cell[124826, 3333, 429, 10, 20, "Print"],
Cell[125258, 3345, 427, 10, 20, "Print"],
Cell[125688, 3357, 429, 10, 20, "Print"],
Cell[126120, 3369, 427, 10, 20, "Print"],
Cell[126550, 3381, 427, 10, 20, "Print"],
Cell[126980, 3393, 427, 10, 20, "Print"],
Cell[127410, 3405, 425, 10, 20, "Print"],
Cell[127838, 3417, 425, 10, 20, "Print"],
Cell[128266, 3429, 424, 10, 20, "Print"],
Cell[128693, 3441, 425, 10, 20, "Print"],
Cell[129121, 3453, 427, 10, 20, "Print"],
Cell[129551, 3465, 313, 7, 20, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[129925, 3479, 340, 6, 35, "Subsection"],
Cell[CellGroupData[{
Cell[130290, 3489, 376, 7, 27, "Input"],
Cell[CellGroupData[{
Cell[130691, 3500, 20808, 534, 106, "Print"],
Cell[151502, 4036, 229, 3, 36, "Print"],
Cell[151734, 4041, 126, 1, 20, "Print"],
Cell[151863, 4044, 140, 1, 20, "Print"],
Cell[152006, 4047, 382, 8, 20, "Print"],
Cell[152391, 4057, 380, 8, 20, "Print"],
Cell[152774, 4067, 380, 8, 20, "Print"],
Cell[153157, 4077, 380, 8, 20, "Print"],
Cell[153540, 4087, 394, 9, 20, "Print"],
Cell[153937, 4098, 404, 9, 20, "Print"],
Cell[154344, 4109, 404, 9, 20, "Print"],
Cell[154751, 4120, 404, 9, 20, "Print"],
Cell[155158, 4131, 404, 9, 20, "Print"],
Cell[155565, 4142, 406, 9, 20, "Print"],
Cell[155974, 4153, 404, 9, 20, "Print"],
Cell[156381, 4164, 404, 9, 20, "Print"],
Cell[156788, 4175, 404, 9, 20, "Print"],
Cell[157195, 4186, 404, 9, 20, "Print"],
Cell[157602, 4197, 406, 9, 20, "Print"],
Cell[158011, 4208, 404, 9, 20, "Print"],
Cell[158418, 4219, 404, 9, 20, "Print"],
Cell[158825, 4230, 404, 9, 20, "Print"],
Cell[159232, 4241, 404, 9, 20, "Print"],
Cell[159639, 4252, 406, 9, 20, "Print"],
Cell[160048, 4263, 404, 9, 20, "Print"],
Cell[160455, 4274, 406, 9, 20, "Print"],
Cell[160864, 4285, 404, 9, 20, "Print"],
Cell[161271, 4296, 404, 9, 20, "Print"],
Cell[161678, 4307, 404, 9, 20, "Print"],
Cell[162085, 4318, 406, 9, 20, "Print"],
Cell[162494, 4329, 404, 9, 20, "Print"],
Cell[162901, 4340, 404, 9, 20, "Print"],
Cell[163308, 4351, 406, 9, 20, "Print"],
Cell[163717, 4362, 406, 9, 20, "Print"],
Cell[164126, 4373, 404, 9, 20, "Print"],
Cell[164533, 4384, 406, 9, 20, "Print"],
Cell[164942, 4395, 404, 9, 20, "Print"],
Cell[165349, 4406, 404, 9, 20, "Print"],
Cell[165756, 4417, 406, 9, 20, "Print"],
Cell[166165, 4428, 404, 9, 20, "Print"],
Cell[166572, 4439, 403, 9, 20, "Print"],
Cell[166978, 4450, 403, 9, 20, "Print"],
Cell[167384, 4461, 406, 9, 20, "Print"],
Cell[167793, 4472, 404, 9, 20, "Print"],
Cell[168200, 4483, 404, 9, 20, "Print"],
Cell[168607, 4494, 406, 9, 20, "Print"],
Cell[169016, 4505, 404, 9, 20, "Print"],
Cell[169423, 4516, 404, 9, 20, "Print"],
Cell[169830, 4527, 404, 9, 20, "Print"],
Cell[170237, 4538, 404, 9, 20, "Print"],
Cell[170644, 4549, 402, 9, 20, "Print"],
Cell[171049, 4560, 404, 9, 20, "Print"],
Cell[171456, 4571, 404, 9, 20, "Print"],
Cell[171863, 4582, 406, 9, 20, "Print"],
Cell[172272, 4593, 404, 9, 20, "Print"],
Cell[172679, 4604, 406, 9, 20, "Print"],
Cell[173088, 4615, 404, 9, 20, "Print"],
Cell[173495, 4626, 404, 9, 20, "Print"],
Cell[173902, 4637, 404, 9, 20, "Print"],
Cell[174309, 4648, 404, 9, 20, "Print"],
Cell[174716, 4659, 404, 9, 20, "Print"],
Cell[175123, 4670, 404, 9, 20, "Print"],
Cell[175530, 4681, 404, 9, 20, "Print"],
Cell[175937, 4692, 404, 9, 20, "Print"],
Cell[176344, 4703, 404, 9, 20, "Print"],
Cell[176751, 4714, 403, 9, 20, "Print"],
Cell[177157, 4725, 404, 9, 20, "Print"],
Cell[177564, 4736, 406, 9, 20, "Print"],
Cell[177973, 4747, 404, 9, 20, "Print"],
Cell[178380, 4758, 406, 9, 20, "Print"],
Cell[178789, 4769, 406, 9, 20, "Print"],
Cell[179198, 4780, 404, 9, 20, "Print"],
Cell[179605, 4791, 403, 9, 20, "Print"],
Cell[180011, 4802, 406, 9, 20, "Print"],
Cell[180420, 4813, 404, 9, 20, "Print"],
Cell[180827, 4824, 404, 9, 20, "Print"],
Cell[181234, 4835, 404, 9, 20, "Print"],
Cell[181641, 4846, 404, 9, 20, "Print"],
Cell[182048, 4857, 404, 9, 20, "Print"],
Cell[182455, 4868, 406, 9, 20, "Print"],
Cell[182864, 4879, 404, 9, 20, "Print"],
Cell[183271, 4890, 400, 9, 20, "Print"],
Cell[183674, 4901, 402, 9, 20, "Print"],
Cell[184079, 4912, 400, 9, 20, "Print"],
Cell[184482, 4923, 400, 9, 20, "Print"],
Cell[184885, 4934, 400, 9, 20, "Print"],
Cell[185288, 4945, 400, 9, 20, "Print"],
Cell[185691, 4956, 400, 9, 20, "Print"],
Cell[186094, 4967, 402, 9, 20, "Print"],
Cell[186499, 4978, 402, 9, 20, "Print"],
Cell[186904, 4989, 402, 9, 20, "Print"],
Cell[187309, 5000, 400, 9, 20, "Print"],
Cell[187712, 5011, 400, 9, 20, "Print"],
Cell[188115, 5022, 402, 9, 20, "Print"],
Cell[188520, 5033, 400, 9, 20, "Print"],
Cell[188923, 5044, 399, 9, 20, "Print"],
Cell[189325, 5055, 400, 9, 20, "Print"],
Cell[189728, 5066, 402, 9, 20, "Print"],
Cell[190133, 5077, 402, 9, 20, "Print"],
Cell[190538, 5088, 400, 9, 20, "Print"],
Cell[190941, 5099, 398, 9, 20, "Print"],
Cell[191342, 5110, 397, 9, 20, "Print"],
Cell[191742, 5121, 400, 9, 20, "Print"],
Cell[192145, 5132, 398, 9, 20, "Print"],
Cell[192546, 5143, 400, 9, 20, "Print"],
Cell[192949, 5154, 286, 6, 20, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[193308, 5168, 142, 4, 89, "Section"],
Cell[193453, 5174, 126, 2, 27, "Input"]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
