(***************************************************************************************************************)
(******                       This is the FeynRules mod-file for the Standard model                       ******)
(******                                                                                                   ******)
(******     Authors: N. Christensen, C. Duhr, B. Fuks                                                     ******)
(******     Adapted by A. Alloul for mass diagonalization                                                 ******)
(******                                                                                                   ******)
(****** Choose whether Feynman gauge is desired.                                                          ******)
(****** If set to False, unitary gauge is assumed.                                                          ****)
(****** Feynman gauge is especially useful for CalcHEP/CompHEP where the calculation is 10-100 times faster. ***)
(****** Feynman gauge is not supported in MadGraph and Sherpa.                                              ****)
(***************************************************************************************************************)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "2HDM_mix";

M$Information = {
 Authors      -> "K. De Causmaecker", 
 Version      -> "1.0.0",
 Date         -> "11. 01. 2013",
 Institutions -> "IIHE - Vrije Universiteit Brussel",
 Emails       -> "Karen.De.Causmaecker@vub.ac.be"
};

FeynmanGauge = True;

(* ************************** *)
(* *****  Change  log   ***** *)
(* ************************** *)

(* v1.0.0: 2HDM adapted for the mass diagonalization routine*)

(* ************************** *)
(* ***** vevs & mixings ***** *)
(* ************************** *)
M$vevs = { {phi1[2],vev1} };

M$MixingsDescription = {
    Mix["1u"] == {
        MassBasis -> {A, Z},
        GaugeBasis -> {B, Wi[3]},
        MixingMatrix -> UG,
        BlockName -> WEAKMIX
    }, 

    Mix["2"] == {
        MassBasis -> {W, Wbar},
        GaugeBasis -> {Wi[1], Wi[2]},
        Value -> {{1/Sqrt[2], -I/Sqrt[2]}, {1/Sqrt[2], I/Sqrt[2]}}
    }, 
    
    Mix["1p"] == {
        MassBasis    -> {{H0}, {G0}},
        GaugeBasis   -> {phi1[2]},
        Value        -> {{{1}}, {{1}}}
    },

    Mix["2p"] == {
        MassBasis    -> {{R0}, {I0}},
        GaugeBasis   -> {phi2[2]},
        Value        -> {{{1}}, {{1}}}
    },

    Mix["1s"] == {
        MassBasis    -> {h1, h2, h3},
        GaugeBasis   -> {H0, R0, I0},
        MixingMatrix -> NH,
        BlockName    -> NHMIX
    },

    Mix["2s"] == {
        MassBasis    -> {HP1},
        GaugeBasis   -> {phi1[1]},
        MixingMatrix -> CH1,
        BlockName    -> CH1MIX
    },
    
    Mix["3s"] == {
        MassBasis    -> {HP2},
        GaugeBasis   -> {phi2[1]},
        MixingMatrix -> CH2,
        BlockName    -> CH2MIX
    },

    Mix["4a"] == {
        MassBasis -> {dq[1, _], dq[2, _], dq[3, _]},
        GaugeBasis -> {{QL[2, 1, _], QL[2, 2, _], QL[2, 3, _]}, {dR[1, _], dR[2, _], dR[3, _]}},
        MixingMatrix -> {CKM, _},
        Inverse -> {True, _}, 
        Value -> {_, {{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}}
    },

    Mix["4b"] == {
        MassBasis -> {uq[1, _], uq[2, _], uq[3, _]},
        GaugeBasis -> {{QL[1, 1, _], QL[1, 2, _], QL[1, 3, _]}, {uR[1, _], uR[2, _], uR[3, _]}}, Value -> {{{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}, {{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}}
    }, 

    Mix["5a"] == {
        MassBasis -> {l[1], l[2], l[3]},
        GaugeBasis -> {{LL[2, 1], LL[2, 2], LL[2, 3]}, {lR[1], lR[2], lR[3]}},                 Value -> {{{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}, {{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}}
    }, 

    Mix["5b"] == {
        MassBasis -> {vl[1], vl[2], vl[3]},
        GaugeBasis -> {LL[1, 1], LL[1, 2], LL[1, 3]},
        Value -> {{{1, 0, 0}, {0, 1, 0}, {0, 0, 1}}, {{0, 0, 0}, {0, 0, 0}, {0, 0, 0}}}
    }
};


(* ************************** *)
(* *****  Gauge groups  ***** *)
(* ************************** *)
M$GaugeGroups = {
    U1Y  == { 
        Abelian          -> True,  
        CouplingConstant -> g1, 
        GaugeBoson       -> B, 
        Charge           -> Y
    },
    
    SU2L == { 
        Abelian           -> False, 
        CouplingConstant  -> gw, 
        GaugeBoson        -> Wi, 
        StructureConstant -> Eps, 
        Representations   -> {Ta,SU2D}, 
        Definitions       -> {Ta[a_,b_,c_]->PauliSigma[a,b,c]/2, FSU2L[i_,j_,k_]:> I Eps[i,j,k]}
    },
    
    SU3C == { 
        Abelian           -> False, 
        CouplingConstant  -> gs, 
        GaugeBoson        -> G,
        StructureConstant -> f, 
        Representations   -> {T,Colour}, 
        DTerm             -> dSUN
    } 
};


(* ************************** *)
(* *****    Indices     ***** *)
(* ************************** *)

IndexRange[Index[SU2W      ]] = Unfold[Range[3]]; 
IndexRange[Index[SU2D      ]] = Unfold[Range[2]];
IndexRange[Index[Gluon     ]] = NoUnfold[Range[8]];
IndexRange[Index[Colour    ]] = NoUnfold[Range[3]]; 
IndexRange[Index[Generation]] = Range[3];
IndexRange[Index[Higgs     ]] = Unfold[Range[3]];

IndexStyle[SU2W,       j];
IndexStyle[SU2D,       k];
IndexStyle[Gluon,      a];
IndexStyle[Colour,     m];
IndexStyle[Generation, f];
IndexStyle[Higgs,      h];


(* ************************** *)
(* *** Interaction orders *** *)
(* ***  (as used by mg5)  *** *)
(* ************************** *)

M$InteractionOrderHierarchy = {
    {QCD, 1},
    {QED, 2}
};


(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)
M$ClassesDescription = {

(* Gauge bosons: physical vector fields *)

    V[1] == { 
        ClassName       -> A, 
        SelfConjugate   -> True,  
        Mass            -> 0,  
        Width           -> 0,  
        ParticleName    -> "a", 
        PDG             -> 22, 
        PropagatorLabel -> "a", 
        PropagatorType  -> W, 
        PropagatorArrow -> None,
        FullName        -> "Photon"
    },
    
    V[2] == { 
        ClassName       -> Z, 
        SelfConjugate   -> True,
        Mass            -> MZ,
        Width           -> {WZ, 2.4952},
        ParticleName    -> "Z", 
        PDG             -> 23, 
        PropagatorLabel -> "Z",
        PropagatorType  -> Sine,
        PropagatorArrow -> None,
        FullName        -> "Z"
    },
   
    V[3] == {
        ClassName        -> W,
        SelfConjugate    -> False,
        Mass             -> MW,
        Width            -> {WW, 2.085},
        ParticleName     -> "W+",
        AntiParticleName -> "W-",
		QuantumNumbers   -> {Q -> 1},
		PDG              -> 24, 
		PropagatorLabel  -> "W",
		PropagatorType   -> Sine,
		PropagatorArrow  -> Forward,
		FullName         -> "W"
	},
	
	V[4] == {
		ClassName        -> G,
		SelfConjugate    -> True,
		Indices          -> {Index[Gluon]},
		Mass             -> 0,
		Width            -> 0,
		ParticleName     -> "g", 
		PDG              -> 21,
		PropagatorLabel  -> "G",
		PropagatorType   -> C,
		PropagatorArrow  -> None,
		FullName         -> "G"
	},

(* Ghosts: related to physical gauge bosons *)

	U[1] == { 
		ClassName       -> ghA, 
		SelfConjugate   -> False,
		Ghost           -> A,
		QuantumNumbers  -> {GhostNumber -> 1},
		Mass            -> 0,
		PropagatorLabel -> "uA",
		PropagatorType  -> GhostDash,
		PropagatorArrow -> Forward
	},
	
	U[2] == {
		ClassName       -> ghZ,
		SelfConjugate   -> False,
		Ghost           -> Z,
		QuantumNumbers  -> {GhostNumber -> 1},
		Mass            -> MZ,  
		PropagatorLabel -> "uZ",
		PropagatorType  -> GhostDash,
		PropagatorArrow -> Forward
	},
	
	U[31] == { 
		ClassName       -> ghWp,
		SelfConjugate   -> False, 
		Ghost           -> W,
		QuantumNumbers  -> {GhostNumber -> 1, Q -> 1},
		Mass            -> {MW,Internal}, 
		PropagatorLabel -> "uWp",
		PropagatorType  -> GhostDash, 
		PropagatorArrow -> Forward
	},
	
	U[32] == { 
		ClassName       -> ghWm,
		SelfConjugate   -> False, 
		Ghost           -> Wbar,
		QuantumNumbers  -> {GhostNumber -> 1, Q -> -1},
		Mass            -> MW, 
		PropagatorLabel -> "uWm",
		PropagatorType  -> GhostDash, 
		PropagatorArrow -> Forward
	},
	
	U[4] == { 
		ClassName       -> ghG, 
		SelfConjugate   -> False,
		Indices         -> {Index[Gluon]},
		Ghost           -> G,
		QuantumNumbers  ->{GhostNumber -> 1}, 
		Mass            -> 0,
		PropagatorLabel -> "uG",
		PropagatorType  -> GhostDash,
		PropagatorArrow -> Forward
	},

(* Gauge bosons: unphysical vector fields *)

	V[11] == { 
		ClassName     -> B, 
		Unphysical    -> True, 
		SelfConjugate -> True
	},
	
	V[12] == { 
		ClassName     -> Wi,
		Unphysical    -> True,
		SelfConjugate -> True, 
		Indices       -> {Index[SU2W]},
		FlavorIndex   -> SU2W
	},

(* Ghosts: related to unphysical gauge bosons *)
	
	U[11] == {
		ClassName     -> ghB, 
		Unphysical    -> True,
		SelfConjugate -> False,
		Ghost         -> B, 
		Definitions   -> { ghB -> -(ee/gw) ghZ + (ee/g1) ghA}
	},
	
	U[12] == {
		ClassName     -> ghWi,
		Unphysical    -> True,
		SelfConjugate -> False,
		Ghost         -> Wi,
		Indices       -> {Index[SU2W]},
		FlavorIndex   -> SU2W,
		Definitions   -> { ghWi[1] -> (ghWp+ghWm)/Sqrt[2], ghWi[2] -> (ghWm-ghWp)/(I*Sqrt[2]), ghWi[3] -> (ee/g1) ghZ+(ee/gw) ghA}
    },

(* Fermions: physical fields *)

    F[1] == {
        ClassName        -> vl,
        ClassMembers     -> {ve,vm,vt},
        Indices          -> {Index[Generation]},
        FlavorIndex      -> Generation,
        SelfConjugate    -> False,
        Mass             -> 0,
        Width            -> 0,
        QuantumNumbers   -> {LeptonNumber -> 1},
        PropagatorLabel  -> {"v", "ve", "vm", "vt"} ,
        PropagatorType   -> S,
        PropagatorArrow  -> Forward,
        PDG              -> {12,14,16},
        ParticleName     -> {"ve","vm","vt"},
        AntiParticleName -> {"ve~","vm~","vt~"},
        FullName         -> {"Electron-neutrino", "Mu-neutrino", "Tau-neutrino"}
    },
    
    F[2] == {
        ClassName        -> l,
        ClassMembers     -> {e, mu, ta},
        Indices          -> {Index[Generation]},
        FlavorIndex      -> Generation,
        SelfConjugate    -> False,
        Mass             -> {Ml, {Me,5.11*^-4}, {MM,0.10566}, {MTA,1.777}},
        Width            -> 0,
        QuantumNumbers   -> {Q -> -1, LeptonNumber -> 1},
        PropagatorLabel  -> {"l", "e", "mu", "ta"},
        PropagatorType   -> Straight,
        PropagatorArrow  -> Forward,
        PDG              -> {11, 13, 15},
        ParticleName     -> {"e-", "mu-", "ta-"},
        AntiParticleName -> {"e+", "mu+", "ta+"},
        FullName         -> {"Electron", "Muon", "Tau"} 
    },
    
    F[3] == {
        ClassName        -> uq,
        ClassMembers     -> {u, c, t},
        Indices          -> {Index[Generation], Index[Colour]},
        FlavorIndex      -> Generation,
        SelfConjugate    -> False,
        Mass             -> {Mu, {MU, 2.55*^-3}, {MC,1.27}, {MT,172}},
        Width            -> {0, 0, {WT,1.50833649}},
        QuantumNumbers   -> {Q -> 2/3},
        PropagatorLabel  -> {"uq", "u", "c", "t"},
        PropagatorType   -> Straight,
        PropagatorArrow  -> Forward,
        PDG              -> {2, 4, 6}, 
        ParticleName     -> {"u",  "c",  "t" },
        AntiParticleName -> {"u~", "c~", "t~"},
        FullName         -> {"u-quark", "c-quark", "t-quark"}
    },
    
    F[4] == {
        ClassName        -> dq,
        ClassMembers     -> {d, s, b},
        Indices          -> {Index[Generation], Index[Colour]},
        FlavorIndex      -> Generation,
        SelfConjugate    -> False,
        Mass             -> {Md, {MD,5.04*^-3}, {MS,0.101}, {MB,4.7}},
        Width            -> 0,
        QuantumNumbers   -> {Q -> -1/3},
        PropagatorLabel  -> {"dq", "d", "s", "b"},
        PropagatorType   -> Straight, 
        PropagatorArrow  -> Forward,
        PDG              -> {1,3,5},
        ParticleName     -> {"d",  "s",  "b" },
        AntiParticleName -> {"d~", "s~", "b~"},
        FullName         -> {"d-quark", "s-quark", "b-quark"}
    },

(* Fermions: unphysical fields *)
    
    F[11] == { 
        ClassName      -> LL, 
        Unphysical     -> True, 
        Indices        -> {Index[SU2D], Index[Generation]},
        FlavorIndex    -> SU2D,
        SelfConjugate  -> False,
        QuantumNumbers -> {Y -> -1/2}
    },
    
    F[12] == { 
        ClassName      -> lR, 
        Unphysical     -> True, 
        Indices        -> {Index[Generation]},
        FlavorIndex    -> Generation,
        SelfConjugate  -> False,
        QuantumNumbers -> {Y -> -1}
    },
    
    F[13] == { 
        ClassName      -> QL, 
        Unphysical     -> True, 
        Indices        -> {Index[SU2D], Index[Generation], Index[Colour]},
        FlavorIndex    -> SU2D,
        SelfConjugate  -> False,
        QuantumNumbers -> {Y -> 1/6}
    },
    
    F[14] == { 
        ClassName      -> uR, 
        Unphysical     -> True, 
        Indices        -> {Index[Generation], Index[Colour]},
        FlavorIndex    -> Generation,
        SelfConjugate  -> False,
        QuantumNumbers -> {Y -> 2/3}
    },
    
    F[15] == { 
        ClassName      -> dR, 
        Unphysical     -> True, 
        Indices        -> {Index[Generation], Index[Colour]},
        FlavorIndex    -> Generation,
        SelfConjugate  -> False,
        QuantumNumbers -> {Y -> -1/3}
    },

(* Higgs unphysical scalars *)
(* Unphysical scalar fields *)

    S[100] == {
        ClassName     -> phi1,
        Unphysical    -> True,
        SelfConjugate -> False,
        Indices       -> {Index[SU2D]},
        FlavorIndex   -> SU2D,
        QuantumNumbers-> {Y -> 1/2}
    },

    S[101] == {
        ClassName     -> phi2,
        Unphysical    -> True,
        SelfConjugate -> False,
        Indices       -> {Index[SU2D]},
        FlavorIndex   -> SU2D,          
        QuantumNumbers-> {Y -> 1/2}
    },

    S[110] == {
        ClassName     -> H0,
        Unphysical    -> True,
        SelfConjugate -> True
    },

    S[111] == {
        ClassName     -> R0,
        Unphysical    -> True,
        SelfConjugate -> True
    },

    S[112] == {
        ClassName     -> I0,
        Unphysical    -> True,
        SelfConjugate -> True
    },
  
   
(* Higgs physical scalars *)

    S[103] == {
        ClassName     -> G0,
        SelfConjugate -> True,
        ParticleName  -> "G0"
    },

    S[104] == {
       ClassName      -> H,
       SelfConjugate  -> True,
       Indices        -> {Index[Higgs]},
       FlavorIndex    -> Higgs,
       ClassMembers   -> {h1, h2, h3},
       PDG            -> {25, 35, 36}
       
    },
    
    S[105] == {
       ClassName      -> HP1,
       SelfConjugate  -> False,
       QuantumNumbers -> {Q -> 1},
       ParticleName   -> "h1+",
       AntiParticleName -> "h1-",
       PDG            -> 100004
       
    },
    
    S[106] == {
       ClassName      -> HP2,
       SelfConjugate  -> False,
       QuantumNumbers -> {Q -> 1},
       ParticleName   -> "h2+",
       AntiParticleName -> "h2-",
       PDG            -> 100005
    }
};


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

(* External parameters *)
    aEWM1 == { 
        ParameterType    -> External, 
        BlockName        -> SMINPUTS, 
        OrderBlock       -> 1, 
        Value            -> 127.9,
        InteractionOrder -> {QED,-2},
        Description      -> "Inverse of the EW coupling constant at the Z pole"
    },
 
    Gf == {
        ParameterType    -> External,
        BlockName        -> SMINPUTS,
        OrderBlock       -> 2,
        Value            -> 1.16637*^-5, 
        InteractionOrder -> {QED,2},
        TeX              -> Subscript[G,f],
        Description      -> "Fermi constant"
    },

    aS    == { 
        ParameterType    -> External,
        BlockName        -> SMINPUTS,
        OrderBlock       -> 3,
        Value            -> 0.1184, 
        InteractionOrder -> {QCD,2},
        TeX              -> Subscript[\[Alpha],s],
        Description      -> "Strong coupling constant at the Z pole"
    },
   
    ymdo == {
        ParameterType -> External,
        BlockName     -> YUKAWA,
        OrderBlock    -> 1,
        Value         -> 5.04*^-3,
        Description   -> "Down Yukawa mass"
    },
 
    ymup == {
        ParameterType -> External,
        BlockName     -> YUKAWA,
        OrderBlock    -> 2,
        Value         -> 2.55*^-3,
        Description   -> "Up Yukawa mass"
    },

    yms == {
        ParameterType -> External,
        BlockName     -> YUKAWA,
        OrderBlock    -> 3,
        Value         -> 0.101,
        Description   -> "Strange Yukawa mass"
    },
   
    ymc == {
        ParameterType -> External,
        BlockName     -> YUKAWA,
        OrderBlock    -> 4,
        Value         -> 1.27,
        Description   -> "Charm Yukawa mass"
    },
    
    ymb == {
        ParameterType -> External,
        BlockName     -> YUKAWA,
        OrderBlock    -> 5,
        Value         -> 4.7,
        Description   -> "Bottom Yukawa mass"
    },
  
    ymt == {
        ParameterType -> External,
        BlockName     -> YUKAWA,
        OrderBlock    -> 6,
        Value         -> 172,
        Description   -> "Top Yukawa mass"
    },
    
    yme == {
        ParameterType -> External,
        BlockName     -> YUKAWA,
        OrderBlock    -> 11,
        Value         -> 5.11*^-4,
        Description   -> "Electron Yukawa mass"
    },
    
    ymm == {
        ParameterType -> External,
        BlockName     -> YUKAWA,
        OrderBlock    -> 13,
        Value         -> 0.10566,
        Description   -> "Muon Yukawa mass"
    },

    ymtau == {
        ParameterType -> External,
        BlockName     -> YUKAWA,
        OrderBlock    -> 15,
        Value         -> 1.777,
        Description   -> "Tau Yukawa mass"
    },
 
    cabi == {
        ParameterType -> External,
        BlockName     -> CKMBLOCK,
        OrderBlock    -> 1,
        Value         -> 0.227736,
        TeX           -> Subscript[\[Theta], c],
        Description   -> "Cabibbo angle"
    },

 (*Adam Modifs: 09/17/12*)

    gw == { 
        ParameterType    -> External, 
        BlockName        -> Gauge,
        OrderBlock       -> 2,
        Value            -> 0.663922,   
        InteractionOrder -> {QED,1},  
        TeX              -> Subscript[g,w], 
        Description      -> "Weak coupling constant at the Z pole"
    },
 
    g1 == { 
        ParameterType    -> External, 
        BlockName        -> Gauge,
        OrderBlock       -> 1, 
        Value            -> 0.355574,   
        InteractionOrder -> {QED,1},  
        TeX              -> Subscript[g,1], 
        Description      -> "U(1)Y coupling constant at the Z pole"
    },

    vev1 == {
        ParameterType    -> External,
        BlockName        -> HMIX,
        OrderBlock       -> 1, 
        InteractionOrder -> {QED,-1},
        Description      -> "vacuum expectation value of the first doublet"
    },



 (* Internal Parameters *)

    aEW == {
        ParameterType    -> Internal,
        Value            -> 1/aEWM1,
        InteractionOrder -> {QED,2},
        TeX              -> Subscript[\[Alpha], EW],
        Description      -> "Electroweak coupling contant"
    },

    ee == { 
        ParameterType    -> Internal, 
        Value            -> Sqrt[4 Pi aEW], 
        InteractionOrder -> {QED,1}, 
        TeX              -> e,  
        Description      -> "Electric coupling constant"
    },
 
    gs == { 
        ParameterType    -> Internal, 
        Value            -> Sqrt[4*Pi*aS],
        InteractionOrder -> {QCD,1},  
        TeX              -> Subscript[g,s], 
        ParameterName    -> G,
        Description      -> "Strong coupling constant at the Z pole"
    },

(*Internal parameters: Yukawa's*)

    yl1 == {
        ParameterType    -> Internal,
        Indices          -> {Index[Generation], Index[Generation]},
        Definitions      -> {yl1[i_?NumericQ, j_?NumericQ] :> 0.  /; (i =!= j)},
        Value            -> {yl1[1,1] -> Sqrt[2] yme/vev1, yl1[2,2] -> Sqrt[2] ymm/vev1,  yl1[3,3] -> Sqrt[2] ymtau/vev1},
        InteractionOrder -> {QED, 1},
        ParameterName    -> {yl1[1,1] -> ye, yl1[2,2] -> ym, yl1[3,3] -> ytau},
        TeX              -> Superscript[y, l1],
        Description      -> "Lepton Yukawa couplings"
    },
    
    yu1 == {
        ParameterType    -> Internal,
        Indices          -> {Index[Generation], Index[Generation]},
        Definitions      -> {yu1[i_?NumericQ, j_?NumericQ] :> 0.  /; (i =!= j)},
        Value            -> {yu1[1,1] -> Sqrt[2] ymup/vev1, yu1[2,2] -> Sqrt[2] ymc/vev1,  yu1[3,3] -> Sqrt[2] ymt/vev1},
        InteractionOrder -> {QED, 1},
        ParameterName    -> {yu1[1,1] -> yup, yu1[2,2] -> yc, yu1[3,3] -> yt},
        TeX              -> Superscript[y, u1],
        Description      -> "Up-type Yukawa couplings"
    },
     
    yd1 == {
        ParameterType    -> Internal,
        Indices          -> {Index[Generation], Index[Generation]},
        Definitions      -> {yd1[i_?NumericQ, j_?NumericQ] :> 0.  /; (i =!= j)},
        Value            -> {yd1[1,1] -> Sqrt[2] ymdo/vev1, yd1[2,2] -> Sqrt[2] yms/vev1,  yd1[3,3] -> Sqrt[2] ymb/vev1},
        InteractionOrder -> {QED, 1},
        ParameterName    -> {yd1[1,1] -> ydo, yd1[2,2] -> ys, yd1[3,3] -> yb},
        TeX              -> Superscript[y, d1],
        Description      -> "Down-type Yukawa couplings"
    },
    
    yl2 == {
        ParameterType    -> Internal,
        Indices          -> {Index[Generation], Index[Generation]},
        Definitions      -> {yl2[i_?NumericQ, j_?NumericQ] :> 0.  /; (i =!= j)},
        Value            -> {yl2[1,1] -> Sqrt[2] yme/vev1, yl2[2,2] -> Sqrt[2] ymm/vev1,  yl2[3,3] -> Sqrt[2] ymtau/vev1},
        InteractionOrder -> {QED, 1},
        ParameterName    -> {yl2[1,1] -> ye, yl2[2,2] -> ym, yl2[3,3] -> ytau},
        TeX              -> Superscript[y, l2],
        Description      -> "Lepton Yukawa couplings"
    },
    
    yu2 == {
        ParameterType    -> Internal,
        Indices          -> {Index[Generation], Index[Generation]},
        Definitions      -> {yu2[i_?NumericQ, j_?NumericQ] :> 0.  /; (i =!= j)},
        Value            -> {yu2[1,1] -> Sqrt[2] ymup/vev1, yu2[2,2] -> Sqrt[2] ymc/vev1,    yu2[3,3] -> Sqrt[2] ymt/vev1},
        InteractionOrder -> {QED, 1},
        ParameterName    -> {yu2[1,1] -> yup, yu2[2,2] -> yc, yu2[3,3] -> yt},
        TeX              -> Superscript[y, u2],
        Description      -> "Up-type Yukawa couplings"
    },
    
    yd2 == {
        ParameterType    -> Internal,
        Indices          -> {Index[Generation], Index[Generation]},
        Definitions      -> {yd2[i_?NumericQ, j_?NumericQ] :> 0.  /; (i =!= j)},
        Value            -> {yd2[1,1] -> Sqrt[2] ymdo/vev1, yd2[2,2] -> Sqrt[2] yms/vev1,  yd2[3,3] -> Sqrt[2] ymb/vev1},
        InteractionOrder -> {QED, 1},
        ParameterName    -> {yd2[1,1] -> ydo, yd2[2,2] -> ys, yd2[3,3] -> yb},
        TeX              -> Superscript[y, d2],
        Description      -> "Down-type Yukawa couplings"
    },

 
(* Higgs potential parameters *)
    
    lambda1 == {
        BlockName      -> Higgs,
        OrderBlock     -> 1,
        ComplexParameter -> False,
        Value          -> 1,
        ParameterType  -> External
    },
    
    lambda2 == {
        BlockName      -> Higgs,
        OrderBlock     -> 2,
        ComplexParameter -> False,
        Value          -> 1,
        ParameterType  -> External
    },
    
    lambda3 == {
        BlockName      -> Higgs,
        OrderBlock     -> 3,
        ComplexParameter -> False,
        Value          -> 1,
        ParameterType  -> External
    },
    
    lambda4 == {
        BlockName      -> Higgs,
        OrderBlock     -> 4,
        ComplexParameter -> False,
        Value          -> 1,
        ParameterType  -> External
    },

    lambda5 == {
        ComplexParameter -> False,
        OrderBlock     -> 5,
        ParameterType  -> External,
        BlockName      -> Higgs,
        Value          -> 1,
        Description    -> "lambda5"
    },
    
    lambda6R == {
        BlockName      -> Higgs,
        OrderBlock     -> 6,
        ComplexParameter -> False,
        ParameterType  -> External,
        Value          -> 1,
        Description    -> "real part of lambda6"
    },

    lambda6I == {
        BlockName      -> Higgs,
        OrderBlock     -> 7,
        ComplexParameter -> False,
        ParameterType  -> External,
        Value          -> 1,
        Description    -> "imaginary part of lambda6"
    },
    
    lambda6 == {
        ComplexParameter -> True,
        ParameterType  -> Internal,
        Value          -> lambda6R + I*lambda6I,
        Description    -> "lambda6"
    },

    lambda7R == {
        BlockName      -> Higgs,
        OrderBlock     -> 8,
        ComplexParameter -> False,
        ParameterType  -> External,
        Value          -> 1,
        Description    -> "real part of lambda6"
    },
    
    lambda7I == {
        BlockName      -> Higgs,
        OrderBlock     -> 9,
        ComplexParameter -> False,
        ParameterType  -> External,
        Value          -> 1,
        Description    -> "imaginary part of lambda6"
    },
    
    lambda7 == {
       ParameterType   -> Internal,
       ComplexParameter -> True,
       Value           -> lambda7R + I*lambda7I,
       Description     -> "lambda7"
    },
    
    mu1 == {
        ComplexParameter -> False,
        ParameterType -> Internal,
        Value         -> -lambda1*vev1^2,
        Description   -> "mu1"
    },

    mu2 == {
        BlockName     -> Higgs,
        OrderBlock    -> 10,
        ComplexParameter -> False,
        ParameterType -> External,
        Value         -> 1,
        Description   -> "mu2"
    },
    
    mu3 == {
        ComplexParameter -> True,
        ParameterType -> Internal,
        Value         -> -lambda6*vev1^2/2,
        Description   -> "mu3"
    },

(* N. B. : only Cabibbo mixing! *)
  CKM == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    Unitary       -> True,
    Value         -> {CKM[1,1] -> Cos[cabi],  CKM[1,2] -> Sin[cabi], CKM[1,3] -> 0,
                      CKM[2,1] -> -Sin[cabi], CKM[2,2] -> Cos[cabi], CKM[2,3] -> 0,
                      CKM[3,1] -> 0,          CKM[3,2] -> 0,         CKM[3,3] -> 1},
    TeX         -> Superscript[V,CKM],
    Description -> "CKM-Matrix"}

};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)


LGauge := Block[{mu,nu,ii,aa}, 
 -1/4 FS[B,mu,nu] FS[B,mu,nu] - 1/4 FS[Wi,mu,nu,ii] FS[Wi,mu,nu,ii] - 1/4 FS[G,mu,nu,aa] FS[G,mu,nu,aa] ];

LFermions := Block[{mu}, 
 I*(
   QLbar.Ga[mu].DC[QL, mu] + LLbar.Ga[mu].DC[LL, mu] + uRbar.Ga[mu].DC[uR, mu] + dRbar.Ga[mu].DC[dR, mu] + lRbar.Ga[mu].DC[lR, mu])];

LYukawa := Block[{sp,ii,jj,cc,ff1,ff2,ff3,yuk},

 yuk  =
 - yd1[ff2, ff3] CKM[ff1, ff2] QLbar[sp, ii, ff1, cc].dR [sp, ff3, cc] phi1[ii]
 - yl1[ff1, ff3] LLbar[sp, ii, ff1].lR [sp, ff3] phi1[ii]
 - yu1[ff1, ff2] QLbar[sp, ii, ff1, cc].uR [sp, ff2, cc] phi1bar[jj] Eps[ii, jj];
 
 yuk +=
 - yd2[ff2, ff3] CKM[ff1, ff2] QLbar[sp, ii, ff1, cc].dR [sp, ff3, cc] phi2[ii]
 - yl2[ff1, ff3] LLbar[sp, ii, ff1].lR [sp, ff3] phi2[ii]
 - yu2[ff1, ff2] QLbar[sp, ii, ff1, cc].uR [sp, ff2, cc] phi2bar[jj] Eps[ii, jj];
 
 yuk = yuk /. { CKM[a_, b_] Conjugate[CKM[a_, c_]] -> IndexDelta[b, c], CKM[b_, a_] Conjugate[CKM[c_, a_]] -> IndexDelta[b, c]};
 
 yuk += HC[yuk]
];

LGhost := Block[{LGh1,LGhw,LGhs,LGhphi,mu, generators,gh,ghbar,Vectorize,phi1,phi2,togoldstones,doublet,doublet0},
 (* Pure gauge piece *)
 LGh1 = -ghBbar.del[DC[ghB,mu],mu];
 LGhw = -ghWibar.del[DC[ghWi,mu],mu];
 LGhs = -ghGbar.del[DC[ghG,mu],mu];

 (* Scalar pieces: see Peskin pages 739-742 *)
 (* phi1 and phi2 are the real degrees of freedom of GP *)
 (* Vectorize transforms a doublet in a vector in the phi-basis, i.e. the basis of real degrees of freedom *)

 gh    = {ghB, ghWi[1], ghWi[2], ghWi[3]};
 ghbar = {ghBbar, ghWibar[1], ghWibar[2], ghWibar[3]};
 generators = {-I/2 g1 IdentityMatrix[2], -I/2 gw PauliSigma[1], -I/2 gw PauliSigma[2], -I/2 gw PauliSigma[3]};
 doublet = Expand[{(-I phi1 - phi2)/Sqrt[2], phi2} /. MR$Definitions /. vev -> 0]; 
 doublet0 = {0, vev/Sqrt[2]};
 Vectorize[{a_, b_}]:= Simplify[{Sqrt[2] Re[Expand[a]], Sqrt[2] Im[Expand[a]], Sqrt[2] Re[Expand[b]], Sqrt[2] Im[Expand[b]]}/.{Im[_]->0, Re[num_]->num}];
 togoldstones := {phi1 -> (GP + GPbar)/Sqrt[2], phi2 -> (-GP + GPbar)/(I Sqrt[2])};
 LGhphi=Plus@@Flatten[Table[-ghbar[[kkk]].gh[[lll]] Vectorize[generators[[kkk]].doublet0].Vectorize[generators[[lll]].(doublet+doublet0)],{kkk,4},{lll,4}]] /.togoldstones;

LGhs + If[FeynmanGauge, LGh1 + LGhw + LGhphi,0]];

(* 2HDM potential *)

LHiggsKin := Block[{ii, mu}, 
DC[phi1bar[ii], mu] DC[phi1[ii], mu] +
DC[phi2bar[ii], mu] DC[phi2[ii], mu]
];

P1 = {phi1[1], phi1[2]};
P2 = {phi2[1], phi2[2]};

P1bar = HC[P1];
P2bar = HC[P2];

P11 = HC[P1].P1;
P12 = HC[P1].P2;
P21 = HC[P2].P1;
P22 = HC[P2].P2;

V2HDM := mu1 P11 +mu2 P22 +mu3 P12 +HC[mu3] P21 + 
    lambda1 P11^2 + lambda2 P22^2 + lambda3 P11 P22 +
    lambda4 P12 P21 + lambda5 P12^2 + Conjugate[lambda5] P21^2 + 
     P11 (lambda6 P12+ Conjugate[lambda6] P21) +  P22 (lambda7 P12+ Conjugate[lambda7]P21);

LHiggs := LHiggsKin - V2HDM;

L2HDM:= LGauge + LFermions + LHiggs + LYukawa + LGhost;
