(**************************************************************************************************)
(******     Alternative FR model file for an alternative left-right symmetric model          ******)
(******                                                                                      ******)
(******     Author: Benjamin Fuks                                                            ******)
(******                                                                                      ******)
(**************************************************************************************************)

(* ************************** *) 
(* *****  Information   ***** *) 
(* ************************** *) 
M$ModelName = "ALRSM_BF";
M$Information = { Authors->{"Benjamin Fuks"}, Emails->{"fuks@lpthe.jussieu.fr"},
                  Institutions->{"LPTHE / Sorbonne U."},
                  Date->"29.05.19", Version->"1.1"};


(* ************************** *)
(* *****  Gauge groups  ***** *)
(* ************************** *)
M$GaugeGroups = {
  U1BL == { Abelian->True,  CouplingConstant->gBL, GaugeBoson->B,   Charge->YBL},
  SU2L == { Abelian->False, CouplingConstant->gL,  GaugeBoson->WLi,
            StructureConstant->epL, Representations->{TL,SU2DL},
            Definitions->{TL[a_,b__]-> PauliSigma[Index[SU2WL,a],b  ]/2, epL->Eps}},
  SU2R == { Abelian->False, CouplingConstant->gR,  GaugeBoson->WRi,
            StructureConstant->epR, Representations->{{TR, SU2DR}, {TRs,SU2DRs}},
            Definitions->{TR[a_,b__]-> PauliSigma[Index[SU2WR,a],b]/2,
              TRs[a_,i_,j_]->-PauliSigma[Index[SU2WR,a],j,i]/2, epR->Eps}},
  SU3C == { Abelian->False, CouplingConstant->gs,  GaugeBoson->G,
            StructureConstant->f,  Representations->{{T,Colour}, {Tb,Colourb}}, DTerm->dSUN }
};


(* ************************** *)
(* *** Interaction orders *** *)
(* ************************** *)
M$InteractionOrderHierarchy = { {QCD, 1},  {QED, 2},  {HIG, 2}, {HIW, 2} };
M$InteractionOrderLimit     = { {QCD, 99}, {QED, 99}, {HIG, 1}, {HIW, 1} };


(* ************************** *)
(* *****    Indices     ***** *)
(* ************************** *)
IndexRange[Index[SU2WL  ]] = Unfold[Range[3]];   IndexStyle[SU2WL,   j];
IndexRange[Index[SU2DL  ]] = Unfold[Range[2]];   IndexStyle[SU2DL,   k];
IndexRange[Index[SU2WR  ]] = Unfold[Range[3]];   IndexStyle[SU2WR,   j];
IndexRange[Index[SU2DR  ]] = Unfold[Range[2]];   IndexStyle[SU2DR,   k];
IndexRange[Index[SU2DRs ]] = Unfold[Range[2]];   IndexStyle[SU2DRs,  k];
IndexRange[Index[Gluon  ]] = NoUnfold[Range[8]]; IndexStyle[Gluon,   a];
IndexRange[Index[Colour ]] = NoUnfold[Range[3]]; IndexStyle[Colour,  m];
IndexRange[Index[Colourb]] = NoUnfold[Range[3]]; IndexStyle[Colourb, m];
IndexRange[Index[GEN    ]] = Range[3];           IndexStyle[GEN,     f];
IndexRange[Index[SHIGGS ]] = Range[4];           IndexStyle[SHIGGS,  n];
IndexRange[Index[PHIGGS ]] = Range[2];           IndexStyle[PHIGGS,  n];


(* ************************** *)
(* *****     Fields     ***** *)
(* ************************** *)
M$ClassesDescription = {
(* Gauge bosons: unphysical vector fields *)
  V[11] == { ClassName->B, Unphysical->True, SelfConjugate->True,
             Definitions -> { B[mu_] -> cph*cw*A[mu] - (sph*st+cph*sw*ct)*Z[mu] + (cph*sw*st-sph*ct)*Zp[mu]}},
  V[12] == { ClassName->WLi, Unphysical->True, SelfConjugate->True,
             Indices->{Index[SU2WL]}, FlavorIndex->SU2WL,
             Definitions-> {WLi[mu_,1] -> (Wbar[mu]+W[mu])/Sqrt[2],
                            WLi[mu_,2] -> (Wbar[mu]-W[mu])/(I*Sqrt[2]),
                            WLi[mu_,3] -> sw*A[mu] + cw*ct*Z[mu] - cw*st*Zp[mu]}},
  V[13] == { ClassName->WRi, Unphysical->True, SelfConjugate->True,
             Indices->{Index[SU2WR]}, FlavorIndex->SU2WR,
             Definitions-> {WRi[mu_,1] -> (Wpbar[mu]+Wp[mu])/Sqrt[2],
                            WRi[mu_,2] -> (Wpbar[mu]-Wp[mu])/(I*Sqrt[2]),
                            WRi[mu_,3] -> sph*cw*A[mu] + (cph*st-sph*sw*ct)*Z[mu] + (sph*sw*st+cph*ct)*Zp[mu]}},

(* Gauge bosons: physical vector fields *)
  V[1] == { ClassName->A,  SelfConjugate->True,  Mass->0,              Width->0,           PDG->22},
  V[2] == { ClassName->Z , SelfConjugate->True,  Mass->{MZ,91.1876},   Width->{WZ,2.4952}, PDG->23},
  V[3] == { ClassName->Zp, SelfConjugate->True,  Mass->{MZp,Internal}, Width->{WZp, 13.2}, PDG->32},
  V[4] == { ClassName->W , SelfConjugate->False, Mass->{MW, Internal}, Width->{WW,2.085},  PDG->24,
            QuantumNumbers->{Q->1}},
  V[5] == { ClassName->Wp, SelfConjugate->False, Mass->{MWp,Internal}, Width->{WWp,3.04},  PDG->34,
            QuantumNumbers->{Q->1}},
  V[6] == { ClassName->G, SelfConjugate->True, Indices->{Index[Gluon]}, Mass->0, Width->0, PDG->21,
            PropagatorType->C},

(* Ghost: related to physical gauge bosons *)
  U[1] == { ClassName->ghG,  SelfConjugate->False, Mass->0,            Width->0,
            Ghost->G,    QuantumNumbers->{GhostNumber->1}, Indices->{Index[Gluon]} },

(* Higgs: unphysical scalars *)
  S[11] == { ClassName->Phi,  Unphysical->True, SelfConjugate->False,
             Indices->{Index[SU2DL],Index[SU2DRs]}, FlavorIndex->SU2DRs,
             QuantumNumbers->{LNumber->-1/2},
             Definitions->{
               Phi[1,1]-> (H1 +I A1)/Sqrt[2],
               Phi[1,2]-> Cos[beta] Hp[1],
               Phi[2,1]-> Cos[zeta] Hpbar[2],
               Phi[2,2]:> Module[{ff}, (kk + TH[1,ff] h0[ff] + I/Sqrt[1+tb^2+tz^2] A2)/Sqrt[2]]}},
  S[12] == { ClassName->chiL,  Unphysical->True, SelfConjugate->False,
             Indices->{Index[SU2DL]}, FlavorIndex->SU2DL,
             QuantumNumbers->{YBL->1/2},
             Definitions->{
               chiL[1]-> -Sin[beta] Hp[1],
               chiL[2]:> Module[{ff}, (vL + TH[3,ff] h0[ff] + -I tb/Sqrt[1+tb^2+tz^2] A2)/Sqrt[2]]}},
  S[13] == { ClassName->chiR,  Unphysical->True, SelfConjugate->False,
             Indices->{Index[SU2DR]}, FlavorIndex->SU2DR,
             QuantumNumbers->{YBL->1/2,LNumber-> 1/2},
             Definitions->{
               chiR[1]-> -Sin[zeta] Hp[2],
               chiR[2]:> Module[{ff}, (vR + TH[4,ff] h0[ff] + I tz/Sqrt[1+tb^2+tz^2] A2 )/Sqrt[2]]}},

(* Higgs: physical fields *)
  S[1] == { ClassName->h0, SelfConjugate->True, Indices->{Index[SHIGGS]}, FlavorIndex->SHIGGS,
            ClassMembers->{H0,H1,H2,H3},
            Mass -> {MH, {MH0,125.},  {MH1,Internal}, {MH2,Internal}, {MH3,Internal}},
            Width-> {WH, {WH0,0.0176},{WH1,0.95},     {WH2, 3.18},    {WH3,781.}},
            PDG->{25,35,45,55}},
  S[2] == { ClassName->A0, SelfConjugate->True, Indices->{Index[PHIGGS]}, FlavorIndex->PHIGGS,
            ClassMembers->{A1,A2},
            Mass -> {MA0, {MA1,Internal}, {MA2, Internal}},
            Width-> {WA0, {WA1,0.95},     {WA2,3.18}},
            PDG->{36,46}},
  S[3] == { ClassName->Hp, SelfConjugate->False, Indices->{Index[PHIGGS]}, FlavorIndex->PHIGGS,
            QuantumNumbers->{Q->1},
            ClassMembers->{Hp1,Hp2},
            Mass -> {MHp,{MHp1,Internal}, {MHp2,Internal}},
            Width-> {WHp,{WHp1,2.83}, {WHp2,0.423}},
            PDG->{37,47}},

(* Fermions: unphysical fields *)
  F[11] == { ClassName->LL, Unphysical->True, SelfConjugate->False,
             Indices->{Index[SU2DL],Index[GEN]}, FlavorIndex->SU2DL,
             QuantumNumbers->{YBL->-1/2, LNumber->1},
             Definitions->{
               LL[sp1_,1,ff_] :> Module[{sp2,ff2}, PMNS[ff, ff2] ProjM[sp1,sp2] vl[sp2,ff2]],
               LL[sp1_,2,ff_] :> Module[{sp2}, ProjM[sp1,sp2] l[sp2,ff]] }},
  F[12] == { ClassName->LR, Unphysical->True, SelfConjugate->False,
             Indices->{Index[SU2DR],Index[GEN]}, FlavorIndex->SU2DR,
             QuantumNumbers->{YBL-> -1/2, LNumber->3/2},
             Definitions->{
               LR[sp1_,1,ff_] :> Module[{sp2,ff2}, PMNSp[ff, ff2] ProjP[sp1,sp2] nl[sp2,ff2]],
               LR[sp1_,2,ff_] :> Module[{sp2}, ProjP[sp1,sp2] l[sp2,ff]] }},
  F[13] == { ClassName->NL, Unphysical->True, SelfConjugate->False,
             Indices->{Index[GEN]}, FlavorIndex->GEN,
             QuantumNumbers->{LNumber->2},
             Definitions->{ NL[sp1_,ff_] :>  Module[{sp2}, ProjM[sp1,sp2] nl[sp2,ff]]}},
  F[14] == { ClassName->VR, Unphysical->True, SelfConjugate->False,
             Indices->{Index[GEN]}, FlavorIndex->GEN,
             QuantumNumbers->{LNumber->1},
             Definitions->{ VR[sp1_,ff_] :>  Module[{sp2}, ProjP[sp1,sp2] vl[sp2,ff]]}},
  F[21] == { ClassName->QL, Unphysical->True, SelfConjugate->False,
             Indices->{Index[SU2DL],Index[GEN],Index[Colour]}, FlavorIndex->SU2DL,
             QuantumNumbers->{YBL->1/6},
             Definitions-> {
               QL[sp1_,1,ff_,cc_] :> Module[{sp2}, ProjM[sp1,sp2] uq[sp2,ff,cc]],
               QL[sp1_,2,ff_,cc_] :> Module[{sp2,ff2}, CKM[ff,ff2] ProjM[sp1,sp2] dq[sp2,ff2,cc]] } },
  F[22] == { ClassName->QR, Unphysical->True, SelfConjugate->False,
             Indices->{Index[SU2DR],Index[GEN],Index[Colour]}, FlavorIndex->SU2DR,
             QuantumNumbers->{YBL->1/6, LNumber->-1/2},
             Definitions->{
               QR[sp1_,1,ff_,cc_] :> Module[{sp2}, ProjP[sp1,sp2] uq[sp2,ff,cc]],
               QR[sp1_,2,ff_,cc_] :> Module[{sp2,ff2}, CKMp[ff,ff2] ProjP[sp1,sp2] dqp[sp2,ff2,cc]]}},
  F[23] == { ClassName->dLp, Unphysical->True, SelfConjugate->False,
             Indices->{Index[GEN],Index[Colour]}, FlavorIndex->GEN,
             QuantumNumbers->{YBL->-1/3, LNumber->-1},
             Definitions->{ dLp[sp1_,ff_,cc_] :> Module[{sp2}, ProjM[sp1,sp2] dqp[sp2,ff,cc]] }},
  F[24] == { ClassName->dR, Unphysical->True, SelfConjugate->False,
             Indices->{Index[GEN],Index[Colour]}, FlavorIndex->GEN,
             QuantumNumbers->{YBL->-1/3},
             Definitions->{ dR[sp1_,ff_,cc_] :> Module[{sp2}, ProjP[sp1,sp2] dq[sp2,ff,cc]] }},

(* Fermions: physical fields *)
  F[1] == { ClassName->vl, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN,
            ClassMembers->{ve,vm,vt}, PDG->{12,14,16},
            Mass->{Mvl,{Mve,1.0*^-12},{Mvm,0.0089*^-9},{Mvt,0.0504*^-9}}, Width->0},
  F[2] == { ClassName->l, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN,
            QuantumNumbers->{Q->-1}, ClassMembers->{e,m,ta},
            ParticleName->{"e-","mu-","tau-"}, AntiParticleName->{"e+","mu+","tau+"}, PDG->{11,13,15},
            Mass->{Ml, {Me,5.11*^-4}, {MMU,0.10566}, {MTA,1.777}}, Width->0},
  F[3] == { ClassName->uq, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]}, FlavorIndex->GEN,
            QuantumNumbers->{Q-> 2/3}, ClassMembers->{u,c,t}, PDG->{2,4,6},
            Mass->{Mu, {MU, 2.55*^-3}, {MC,1.27}, {MT,172}}, Width->{Wuq,0,0,{WT,1.50833649}}},
  F[4] == { ClassName->dq, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]}, FlavorIndex->GEN,
            QuantumNumbers->{Q->-1/3}, ClassMembers->{d,s,b}, PDG->{1,3,5},
            Mass->{Mdq, {MD,5.04*^-3}, {MS,0.101}, {MB,4.7}}, Width->0},
  F[5] == { ClassName->nl, SelfConjugate->False, Indices->{Index[GEN]}, FlavorIndex->GEN,
            ClassMembers->{ne,nm,nt}, PDG->{6000012,6000014,6000016},
            ParticleName->{"~ne","~nm","~nt"}, AntiParticleName->{"~ne~","~nm~","~nt~"},
            Mass->{Mnl,{Mne,300},{Mnm,500},{Mnt,700}},
            Width->{Wnl,{Wne,0},{Wnm,7.09*^-4},{Wnt,1.13}}},
  F[6] == { ClassName->dqp, SelfConjugate->False, Indices->{Index[GEN],Index[Colour]}, FlavorIndex->GEN,
            QuantumNumbers->{Q->-1/3}, ClassMembers->{dp,sp,bp}, PDG->{6000001,6000003,6000005},
            Mass->{Mdqp, {MDP,301}, {MSP,501}, {MBP,701}},
            Width->{Wnl,{WDP,0},{WSP,0.262},{WBP,9.85}}}
};


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
(* Shortcuts for Higgs mixings *)
DENO   := (fh[MH2]^2 (1 + gh[MH0]^2) + (gh[MH0] - gh[MH2])^2 - 2 fh[MH0] fh[MH2] (1 + gh[MH0] gh[MH2]) +  fh[MH0]^2 (1 + gh[MH2]^2));
SGN    := (#/Abs[#] &/@ {gh[MH0] (fh[MH2]-fh[MH3]) + gh[MH2] (fh[MH3]-fh[MH0]) + gh[MH3] (fh[MH0]-fh[MH2])})[[1]];
fh[x_] := (2 x^4 vL vR + x^2 (vL^2 + vR^2) (Sqrt[2] kk kap - 4 vL vR lam3) - 2 Sqrt[2] kk (vL^2 - vR^2)^2 lam3 kap) /
             (vR (x^2 (4 kk vL vR (alp1 + alp2) + Sqrt[2] vL^2 kap) + 2 Sqrt[2] (kk^2 (alp1 + alp2) + vL^2 lam3) (vR^2 - vL^2) kap));
gh[x_] := (vL (x^2 (4 kk vL vR (alp1 + alp2) + Sqrt[2] vR^2 kap) + 2 Sqrt[2] (kk^2 (alp1 + alp2) + vR^2 lam3) (vL^2 - vR^2) kap)) /
    (vR (x^2 (4 kk vL vR (alp1 + alp2) + Sqrt[2] vL^2 kap) + 2 Sqrt[2] (kk^2 (alp1 + alp2) + vL^2 lam3) (vR^2 - vL^2) kap));
NLAM1 := Sqrt[2]*kk*MH0^6*vL*vR - 4*(alp1 + alp2)^2*kap*kk^4*(vL^2 - vR^2)^2 +
          MH0^4*(-2*Sqrt[2]*kk*lam3*vL*vR*(vL^2 + vR^2) + kap*(vL^2*vR^2 + kk^2*(vL^2 + vR^2))) -
          2*MH0^2*(2*Sqrt[2]*(alp1 + alp2)^2*kk^3*vL*vR*(vL^2 + vR^2) +
          kap*(lam3*vL^2*vR^2*(vL^2 + vR^2) + kk^2*(4*(alp1 + alp2)*vL^2*vR^2 + lam3*(vL^2 - vR^2)^2)));
DLAM1 := 2*Sqrt[2]*kk^3*MH0^4*vL*vR - 4*kap*kk^4*lam3*(vL^2 - vR^2)^2 + 2*kk^3*MH0^2*(kap*kk - 2*Sqrt[2]*lam3*vL*vR)*(vL^2 + vR^2);
MH2AA := (vL*vR*(2*Sqrt[2]*kk^3*lam1 - kap*vL*vR) + kk*(-(kap*kk) + 2*Sqrt[2]*lam3*vL*vR)*(vL^2 + vR^2))/(Sqrt[2] kk vL vR) - MH0^2;
MH2BB := 1/(kk vL vR)*(Sqrt[2]*kap*kk^2*(4*(alp1 + alp2)*vL^2*vR^2 + lam3*(vL^2 - vR^2)^2) + 
            (vL^2 + vR^2)*(4*kk^3*(alp1^2 + 2*alp1*alp2 + alp2^2 - lam1*lam3)*vL*vR + Sqrt[2]*kap*(kk^4*lam1 + lam3*vL^2*vR^2)));

M$Parameters = {
(* Gauge sector: external parameters *)
  aEWM1 == { TeX->Subsuperscript[\[Alpha],w,-1], ParameterType->External, BlockName->SMINPUTS, OrderBlock->1,
             Value->127.9,       InteractionOrder->{QED,-2},
             Description->"Inverse of the EW coupling constant at the Z pole"},
  Gf    == { TeX->Subscript[G,f],                ParameterType->External, BlockName->SMINPUTS, OrderBlock->2,
             Value->1.16637*^-5, InteractionOrder->{QED,2},
             Description->"Fermi constant"},
  aS    == { TeX->Subscript[\[Alpha],s],         ParameterType->External, BlockName->SMINPUTS, OrderBlock->3,
             Value->0.1184,      InteractionOrder->{QCD, 2},
             Description->"Strong coupling constant at the Z pole."},
  gR    == { TeX->Subscript[g,R],                ParameterType->External, BlockName->SMINPUTS, OrderBlock->6,
             Value->0.646482210, InteractionOrder->{QED, 1},
             Description->"SU(2)_R coupling constant at the Z pole"},

(* Symmetry breaking; external parameters *)
  tb   == { ParameterType->External, BlockName->SMINPUTS, OrderBlock->5, Value->10.,
            Description->"Ratio of the bidoublet-to-left Higgs vevs", TeX->Subscript[t,\[Beta]]},
  vevp == { ParameterType->External, BlockName->SMINPUTS, OrderBlock->7,
            Value->6500, InteractionOrder->{QED,-1},
            Description->"SU(2)_R x U(1)BL breaking scale", TeX-> v'},

(* Symmetry breaking: internal parameters *)
  beta == { ParameterType->Internal, Value->ArcTan[tb],
            Description->"Arctan of the ratio of the bidoublet-to-left Higgs vevs", TeX->\[Beta]},
  vev  == { ParameterType->Internal, Value->1/Sqrt[Sqrt[2] Gf], InteractionOrder->{QED,-1},
            Description -> "SM Higgs vacuum expectation value", TeX ->v},
  kk   == { ParameterType->Internal, Value->vev*Sin[beta],      InteractionOrder->{QED,-1},
            Description -> "Higgs bidoublet vacuum expectation value", TeX -> k},
  vL   == { ParameterType->Internal, Value->vev*Cos[beta],      InteractionOrder->{QED,-1},
            Description -> "SU(2)L Higgs doublet vacuum expectation value", TeX->Subscript[v,L]},
  vR   == { ParameterType->Internal, Value->Sqrt[vevp^2-kk^2],  InteractionOrder->{QED,-1},
            Description -> "SU(2)R Higgs doublet vacuum expectation value", TeX->Subscript[v,R]},
  tz   == { ParameterType->Internal, Value->kk/vR,
            Description->"Ratio of the bidoublet-to-right Higgs vevs", TeX->Subscript[t,\[Zeta]]},
  zeta == { ParameterType->Internal, Value->ArcTan[tz],
            Description->"Arctan of the ratio of the bidoublet-to-right Higgs vevs", TeX->\[Zeta]},

(* Gauge sector: internal parameters *)
  MW == { ParameterType->Internal, Value->Sqrt[MZ^2/2+Sqrt[MZ^4/4-Pi/Sqrt[2]/aEWM1/Gf*MZ^2]],
          Description->"W-boson mass", TeX-> Subscript[M,W]},
  ee == { ParameterType->Internal, Value->Sqrt[4 Pi/aEWM1], InteractionOrder->{QED,1},
          Description->"Electromagnetic coupling", TeX->e},
  gs == { ParameterType->Internal, Value->Sqrt[4 Pi aS],    InteractionOrder->{QCD,1},
          Description->"Strong coupling at the Z pole", TeX->Subscript[g,s], ParameterName->G},
  gL == { ParameterType->Internal, Value->2/vev MW,         InteractionOrder->{QED,1},
          Description->"SU(2)_L coupling constant at the Z pole", TeX->Subscript[g,L]  },
  sw == { ParameterType->Internal, Value->ee/gL,
          Description->"Sine of the weak angle", TeX->Subscript[s,w]},
  cw == { ParameterType->Internal, Value->Sqrt[1-sw^2],
          Description->"Sine of the weak angle", TeX->Subscript[c,w]},
  gY == { ParameterType->Internal, Value->ee/cw, InteractionOrder->{QED,1},
          Description->"U(1)Y coupling constant at the Z pole", TeX->Subscript[g,Y]},
  gBL== { ParameterType->Internal, Value->gY gR/Sqrt[gR^2-gY^2], InteractionOrder->{QED,1},
          Description->"U(1)_{B-L} coupling constant at the Z pole", TeX->Subscript[g,B-L]},
  sph == { ParameterType->Internal, Value->gY/gR,
          Description->"Sine of the weak angle", TeX->Subscript[s,p]},
  cph == { ParameterType->Internal, Value->Sqrt[1-sph^2],
          Description->"Sine of the weak angle", TeX->Subscript[c,p]},
  t2t== { ParameterType->Internal, Description->"Z/Z'-Mixing", TeX-> Subscript[t,2\[Theta]],
          Value->(2*cph*cw*gL*gR*(cph^2*kk^2-sph^2*vL^2))/(-cph^2*kk^2*(gL^2-cph^2*cw^2*gR^2) - cph^2*gL^2*(gL^2-cw^2*gBL^2*sph^2) + cw^2*gR^2*vR^2)},
  st == { ParameterType->Internal, Value->Sin[ArcTan[t2t]/2],
          Description->"Sine of the weak angle", TeX->Subscript[s,t]},
  ct == { ParameterType->Internal, Value->Sqrt[1-st^2],
          Description->"Sine of the weak angle", TeX->Subscript[c,t]},
  MWp== { ParameterType->Internal, Value->1/2 vevp gR,
          Description->"W'-boson mass", TeX-> Subscript[M,W']},
  MZp== { ParameterType->Internal, Value->1/2 Sqrt[ gBL^2 sph^2 vL^2 + gR^2/cph^2 (cph^4 kk^2 + vR^2)  ],
          Description->"Z'-boson mass", TeX-> Subscript[M,Z']},

(* Higgs potential: external parameters *)
  lam2 == { ParameterType -> External, BlockName -> HPOTINPUTS, OrderBlock -> 1, Value -> 0.5,
            InteractionOrder -> {QED,2},
            Description -> "Higgs bidoublet quartic coupling", TeX -> Subscript[\[Lambda],2]},
  lam3 == { ParameterType -> External, BlockName -> HPOTINPUTS, OrderBlock -> 2, Value -> 1.6,
            InteractionOrder -> {QED,2},
            Description -> "Higgs doublet quartic coupling", TeX -> Subscript[\[Lambda],3]},
  alp1 == { ParameterType -> External, BlockName -> HPOTINPUTS, OrderBlock -> 3, Value -> 0.3,
            InteractionOrder -> {QED,2},
            Description -> "Higgs doublet-bidoublet quartic coupling", TeX -> Subscript[\[Alpha],1]},
  alp2 == { ParameterType -> External, BlockName -> HPOTINPUTS, OrderBlock -> 4, Value -> 0.1,
            InteractionOrder -> {QED,2},
            Description -> "Higgs doublet-bidoublet quartic coupling", TeX -> Subscript[\[Alpha],2]},
  alp3 == { ParameterType -> External, BlockName -> HPOTINPUTS, OrderBlock -> 5, Value -> 0.3,
            InteractionOrder -> {QED,2},
            Description -> "Higgs doublet-bidoublet quartic coupling", TeX -> Subscript[\[Alpha],3]},
  kap  == { ParameterType -> External, BlockName -> HPOTINPUTS, OrderBlock -> 6, Value -> -10.,
            InteractionOrder -> {QED,1},
            Description -> "Higgs doublet-bidoublet trilinear coupling", TeX -> \[Kappa]},

(* Higgs potential: internal parameters *)
  IDLT == { ParameterType->Internal, ComplexParameter->False,
            Indices -> {Index[SU2DR], Index[SU2DRs]},
            Definitions -> { IDLT[1,1]->1, IDLT[1,2]->0, IDLT[2,1]->0, IDLT[2,2]->1 },
            Description -> "Delta contracting SU2DR and SU2DRs indices", TeX->\[Delta]},
  UEpsRs== { ParameterType->Internal, ComplexParameter->False,
            Indices -> {Index[SU2DRs], Index[SU2DRs]},
            Definitions -> { UEpsRs[1,1]->0, UEpsRs[1,2]->-1, UEpsRs[2,1]-> 1, UEpsRs[2,2]->0 },
            Description -> "Epsilon in SU2R space (with upper indices)", TeX->Subscript[\[Epsilon],u]},
  UEpsR== { ParameterType->Internal, ComplexParameter->False,
            Indices -> {Index[SU2DR], Index[SU2DR]},
            Definitions -> { UEpsR[1,1]->0, UEpsR[1,2]->-1, UEpsR[2,1]-> 1, UEpsR[2,2]->0 },
            Description -> "Epsilon in SU2R space (with upper indices)", TeX->Subscript[\[Epsilon],u]},
  UEpsL== { ParameterType->Internal, ComplexParameter->False,
            Indices -> {Index[SU2DL], Index[SU2DL]},
            Definitions -> { UEpsL[1,1]->0, UEpsL[1,2]->-1, UEpsL[2,1]-> 1, UEpsL[2,2]->0 },
            Description -> "Epsilon in SU2L space (with upper indices)", TeX->Subscript[\[Epsilon],u]},
  DEps== { ParameterType->Internal, ComplexParameter->False,
            Indices -> {Index[SU2DL], Index[SU2DL]},
            Definitions -> { DEps[1,1]->0, DEps[1,2]-> 1, DEps[2,1]->-1, DEps[2,2]->0 },
            Description -> "Epsilon in SU2L space (with lower indices)", TeX->Subscript[\[Epsilon],d]},
  lam1 == { ParameterType->Internal,  Value -> NLAM1/DLAM1,
            InteractionOrder -> {QED,2},
            Description   -> "Higgs bidoublet quartic term", TeX->Subscript[\[Lambda],1]},
  MU12 == { ParameterType->Internal, Value -> (vL^2+vR^2)(alp1+alp2) + kk^2 lam1 + vL vR kap/(Sqrt[2] kk),
            Description   -> "Higgs bidoublet quadratic term", TeX->Subsuperscript[\[Mu],1,2]},
  MU22 == { ParameterType->Internal, Value -> kk^2(alp1+alp2) + (vL^2+vR^2)*lam3,
            Description   -> "Higgs doublet quadratic term", TeX->Subsuperscript[\[Mu],2,2]},
  lam4 == { ParameterType->Internal, Value -> lam3 - kk kap/(Sqrt[2]vL vR),
            InteractionOrder -> {QED,2},
            Description   -> "Higgs doublet-bidoublet quartic term", TeX->Subscript[\[Lambda],4]},

(* Higgs masses and mixings: internal parameters *)
  MHp1 == { ParameterType->Internal,  Value -> Sqrt[-(2 kk vL (alp2-alp3) + Sqrt[2] kap vR)*(kk^2+vL^2)/(2 kk vL)],
            Description   -> "Lightest charged Higgs mass"},
  MHp2 == { ParameterType->Internal,  Value -> Sqrt[-(2 kk vR (alp2-alp3) + Sqrt[2] kap vL)*(kk^2+vR^2)/(2 kk vR)],
            Description   -> "Heaviest charged Higgs mass"},
  MH1  == { ParameterType->Internal,  Value -> Sqrt[2*kk^2*lam2 - kap*vL*vR/(Sqrt[2]*kk) - (alp2-alp3)*(vL^2+vR^2)],
            Description   -> "Next-to-lightest scalar Higgs mass"},
  MH2  == { ParameterType->Internal,  Value -> 1/Sqrt[2] Sqrt[MH2AA - Sqrt[MH2AA^2 + 4(MH2BB + MH0^2 MH2AA)]],
            Description   -> "Second scalar Higgs mass", TeX->Subscript[M,H2]},
  MH3  == { ParameterType->Internal,  Value -> 1/Sqrt[2] Sqrt[MH2AA + Sqrt[MH2AA^2 + 4(MH2BB + MH0^2 MH2AA)]],
            Description   -> "Third scalar Higgs mass", TeX->Subscript[M,H3]},
  MA1  == { ParameterType->Internal,  Value -> Sqrt[2*kk^2*lam2 - kap*vL*vR/(Sqrt[2]*kk) - (alp2-alp3)*(vL^2+vR^2)],
            Description   -> "Lightest pseudoscalar Higgs mass"},
  MA2  == { ParameterType->Internal,  Value -> Sqrt[ -kap/(Sqrt[2] kk vL vR) ( vL^2 vR^2 + kk^2(vL^2+vR^2)) ],
            Description   -> "Lightest pseudoscalar Higgs mass"},
  TH   == { ParameterType-> Internal, ComplexParameter->False,
            Indices->{Index[SHIGGS],Index[SHIGGS]}, Unitary->True,
            Value -> {
              TH[1,2]-> 0, TH[2,1]-> 0, TH[2,2]-> 1, TH[2,3]-> 0, TH[2,4]-> 0, TH[3,2]-> 0, TH[4,2]-> 0,
              TH[1,1]-> fh[MH0]/Sqrt[1 + fh[MH0]^2 + gh[MH0]^2],
              TH[1,3]-> (fh[MH2] (1 + gh[MH0]^2) - fh[MH0] (1 + gh[MH0] gh[MH2]))/Sqrt[(1 + fh[MH0]^2 + gh[MH0]^2) DENO],
              TH[1,4]-> SGN (gh[MH2] - gh[MH0])/Sqrt[DENO],
              TH[3,1]-> gh[MH0]/Sqrt[1 + fh[MH0]^2 + gh[MH0]^2],
              TH[3,3]-> (gh[MH2]*(1 + fh[MH0]^2) - gh[MH0]*(1 + fh[MH0]*fh[MH2]))/Sqrt[(1 + fh[MH0]^2 + gh[MH0]^2) DENO],
              TH[3,4]-> SGN (fh[MH0] - fh[MH2])/Sqrt[DENO],
              TH[4,1]-> 1/Sqrt[1 + fh[MH0]^2 + gh[MH0]^2],
              TH[4,3]-> (fh[MH0]^2 + gh[MH0]^2 - fh[MH0]*fh[MH2] - gh[MH0]*gh[MH2])/Sqrt[(1 + fh[MH0]^2 + gh[MH0]^2) DENO],
              TH[4,4]-> SGN (gh[MH0] fh[MH2] - gh[MH2] fh[MH0])/Sqrt[DENO]
            }, Description-> "Scalar Higgs mixing matrix TH",  TeX->Subscript[T,H]},

(* Fermion masses: internal parameters *)
  yu == { ParameterType->Internal, ComplexParameter->False,
          Indices->{Index[GEN], Index[GEN]},
          InteractionOrder->{QED, 1},
          Definitions-> {yu[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
          Value      -> {yu[1,1] -> Sqrt[2] MU/kk, yu[2,2] -> Sqrt[2] MC/kk, yu[3,3] -> Sqrt[2] MT/kk},
          Description->"Up-type quark Yukawa couplings", TeX->Superscript[y,u]},
  yd == { ParameterType->Internal, ComplexParameter->False,
          Indices->{Index[GEN], Index[GEN]},
          InteractionOrder->{QED, 1},
          Definitions-> {yd[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
          Value      -> {yd[1,1] -> Sqrt[2] MD/vL, yd[2,2] -> Sqrt[2] MS/vL, yd[3,3] -> Sqrt[2] MB/vL},
          Description->"Down-type quark Yukawa couplings", TeX->Superscript[y,d]},
  ydp== { ParameterType->Internal, ComplexParameter->False,
          Indices->{Index[GEN], Index[GEN]},
          InteractionOrder->{QED, 1},
          Definitions-> {ydp[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
          Value      -> {ydp[1,1] -> Sqrt[2] MDP/vR, ydp[2,2] -> Sqrt[2] MSP/vR, ydp[3,3] -> Sqrt[2] MBP/vR},
          Description->"Exotic down-type quark Yukawa couplings", TeX->Superscript[y,d']},
  ye == { ParameterType->Internal, ComplexParameter->False,
          Indices->{Index[GEN], Index[GEN]},
          InteractionOrder->{QED, 1},
          Definitions-> {ye[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
          Value      -> {ye[1,1] -> Sqrt[2] Me/kk, ye[2,2] -> Sqrt[2] MMU/kk, ye[3,3] -> Sqrt[2] MTA/kk},
          Description->"Charged lepton Yukawa couplings", TeX->Superscript[y,e]},
  ynu== { ParameterType->Internal, ComplexParameter->False,
          Indices->{Index[GEN], Index[GEN]},
          InteractionOrder->{QED, 1},
          Definitions-> {ynu[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
          Value      -> {ynu[1,1] -> Sqrt[2] Mve/vL, ynu[2,2] -> Sqrt[2] Mvm/vL, ynu[3,3] -> Sqrt[2] Mvt/vL},
          Description->"Neutrino Yukawa couplings", TeX->Superscript[y,\[Nu]]},
  yn == { ParameterType->Internal, ComplexParameter->False,
          Indices->{Index[GEN], Index[GEN]},
          InteractionOrder->{QED, 1},
          Definitions-> {yn[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
          Value      -> {yn[1,1] -> Sqrt[2] Mne/vR, yn[2,2] -> Sqrt[2] Mnm/vR, yn[3,3] -> Sqrt[2] Mnt/vR},
          Description->"Scotino Yukawa couplings", TeX->Superscript[y,n]},

(* Fermion mixings: external parameters *)
  CKMlam == { TeX->Subscript[\[Lambda],CKM], ParameterType->External, BlockName->CKMBLOCK, OrderBlock->1,
              Value->0.22453, Description->"Wolfenstein parameter lambda (quark mixings)"},
  CKMA   == { TeX->Subscript[A,CKM], ParameterType->External, BlockName->CKMBLOCK, OrderBlock->2,
              Value->0.836, Description->"Wolfenstein parameter A (quark mixings)"},
  CKMrho == { TeX->Subscript[\[Rho],CKM], ParameterType->External, BlockName->CKMBLOCK, OrderBlock->3,
              Value->0.122, Description->"Wolfenstein parameter rhobar (quark mixings)"},
  CKMeta == { TeX->Subscript[\[Eta],CKM], ParameterType->External, BlockName->CKMBLOCK, OrderBlock->4,
              Value->0.355, Description->"Wolfenstein parameter etabar (quark mixings)"},
  PMNSs12 == { ParameterType->External, BlockName->PMNSBLOCK, OrderBlock->1,
              Value->Sqrt[.297], Description->"Sine of theta_{12} (neutrino mixings)"},
  PMNSs23 == { ParameterType->External, BlockName->PMNSBLOCK, OrderBlock->2,
              Value->Sqrt[.425], Description->"Sine of theta_{23} (neutrino mixings)"},
  PMNSs13 == { ParameterType->External, BlockName->PMNSBLOCK, OrderBlock->3,
              Value->Sqrt[.0215], Description->"Sine of theta_{13} (neutrino mixings)"},
  PMNSdel == { ParameterType->External, BlockName->PMNSBLOCK, OrderBlock->4,
              Value->1.38 Pi, Description->"CP phase (neutrino mixings)"},
  PMNSps12 == { ParameterType->External, BlockName->PMNSBLOCK, OrderBlock->11,
              Value->Sqrt[.297], Description->"Sine of theta_{12} (scotino mixings)"},
  PMNSps23 == { ParameterType->External, BlockName->PMNSBLOCK, OrderBlock->12,
              Value->Sqrt[.425], Description->"Sine of theta_{23} (scotino mixings)"},
  PMNSps13 == { ParameterType->External, BlockName->PMNSBLOCK, OrderBlock->13,
              Value->Sqrt[.0215], Description->"Sine of theta_{13} (scotino mixings)"},
  PMNSpdel == { ParameterType->External, BlockName->PMNSBLOCK, OrderBlock->14,
              Value->1.38 Pi, Description->"Cp phase (scotino mixings)"},
  CKMps12 == { ParameterType->External, BlockName->CKMBLOCK, OrderBlock->11,
               Value->0.22453, Description->"Sine of theta_{12} (exotic down-type quark mixings)"},
  CKMps23 == { ParameterType->External, BlockName->CKMBLOCK, OrderBlock->12,
               Value->0.0421, Description->"Sine of theta_{23} (exotic down-type quark mixings)"},
  CKMps13 == { ParameterType->External, BlockName->CKMBLOCK, OrderBlock->13,
               Value->0.00364, Description->"Sine of theta_{13} (exotic down-type quark mixings)"},
  CKMpdel == { ParameterType->External, BlockName->CKMBLOCK, OrderBlock->14,
               Value->1.24, Description->"CP phase (exotic down-type quark mixings)"},

(* Fermion mixings: internal parameters *)
   CKMs12  == { ParameterType -> Internal, Value->CKMlam,        Description->"s_{12}"},
   CKMs23  == { ParameterType -> Internal, Value->CKMA*CKMlam^2, Description->"s_{23}"},
   CKMs13d == { ParameterType -> Internal, Value->CKMA*CKMlam^3*Sqrt[1-CKMA^2 CKMlam^4](CKMrho + I CKMeta)/
                    (Sqrt[1-CKMlam^2]*(1-CKMA^2 CKMlam^4 (CKMrho + I CKMeta))), Description->"s_{13} Exp[i delta]"},
   CKMc12  == { ParameterType -> Internal, Value-> Sqrt[1-CKMs12^2], Description->"c_{12}"},
   CKMc13  == { ParameterType -> Internal, Value-> Sqrt[1-Abs[CKMs13d]^2], Description->"c_{13}"},
   CKMc23  == { ParameterType -> Internal, Value-> Sqrt[1-CKMs23^2], Description->"c_{23}"},
   CKM  == { ParameterType -> Internal, Indices->{Index[GEN],Index[GEN]}, Unitary-> True,
             Value->{
               CKM[1,1]-> CKMc12*CKMc13,                       CKM[1,2]-> CKMs12*CKMc13,                       CKM[1,3]->Conjugate[CKMs13d],
               CKM[2,1]->-CKMs12*CKMc23-CKMc12*CKMs23*CKMs13d, CKM[2,2]-> CKMc12*CKMc23-CKMs12*CKMs23*CKMs13d, CKM[2,3]->CKMs23*CKMc13,
               CKM[3,1]-> CKMs12*CKMs23-CKMc12*CKMc23*CKMs13d, CKM[3,2]->-CKMc12*CKMs23-CKMs12*CKMc23*CKMs13d, CKM[3,3]->CKMc23*CKMc13},
             Description -> "CKM-Matrix", TeX-> Superscript[V,CKM]},
   PMNSs13d == { ParameterType -> Internal, Value-> PMNSs13*Exp[I PMNSdel], Description->"s_{13} Exp[i delta]"},
   PMNSc12  == { ParameterType -> Internal, Value-> Sqrt[1-PMNSs12^2], Description->"c_{12}"},
   PMNSc13  == { ParameterType -> Internal, Value-> Sqrt[1-PMNSs13^2], Description->"c_{13}"},
   PMNSc23  == { ParameterType -> Internal, Value-> Sqrt[1-PMNSs23^2], Description->"c_{23}"},
   PMNS == { ParameterType -> Internal, Indices->{Index[GEN],Index[GEN]}, Unitary-> True,
             Value->{
              PMNS[1,1]-> PMNSc12*PMNSc13,                          PMNS[1,2]-> PMNSs12*PMNSc13,                          PMNS[1,3]->Conjugate[PMNSs13d],
              PMNS[2,1]->-PMNSs12*PMNSc23-PMNSc12*PMNSs23*PMNSs13d, PMNS[2,2]-> PMNSc12*PMNSc23-PMNSs12*PMNSs23*PMNSs13d, PMNS[2,3]->PMNSs23*PMNSc13,
              PMNS[3,1]-> PMNSs12*PMNSs23-PMNSc12*PMNSc23*PMNSs13d, PMNS[3,2]->-PMNSc12*PMNSs23-PMNSs12*PMNSc23*PMNSs13d, PMNS[3,3]->PMNSc23*PMNSc13},
             Description -> "PMNS-Matrix", TeX-> Superscript[V,PMNS]},
   PMNSps13d == { ParameterType -> Internal, Value-> PMNSps13*Exp[I PMNSpdel], Description->"s_{13} Exp[i delta]"},
   PMNSpc12  == { ParameterType -> Internal, Value-> Sqrt[1-PMNSps12^2], Description->"c_{12}"},
   PMNSpc13  == { ParameterType -> Internal, Value-> Sqrt[1-PMNSps13^2], Description->"c_{13}"},
   PMNSpc23  == { ParameterType -> Internal, Value-> Sqrt[1-PMNSps23^2], Description->"c_{23}"},
   PMNSp== { ParameterType -> Internal, Indices->{Index[GEN],Index[GEN]}, Unitary-> True,
             Value->{
              PMNSp[1,1]-> PMNSpc12*PMNSpc13,                             PMNSp[1,2]-> PMNSps12*PMNSpc13,                             PMNSp[1,3]->Conjugate[PMNSps13d],
              PMNSp[2,1]->-PMNSps12*PMNSpc23-PMNSpc12*PMNSps23*PMNSps13d, PMNSp[2,2]-> PMNSpc12*PMNSpc23-PMNSps12*PMNSps23*PMNSps13d, PMNSp[2,3]->PMNSps23*PMNSpc13,
              PMNSp[3,1]-> PMNSps12*PMNSps23-PMNSpc12*PMNSpc23*PMNSps13d, PMNSp[3,2]->-PMNSpc12*PMNSps23-PMNSps12*PMNSpc23*PMNSps13d, PMNSp[3,3]->PMNSpc23*PMNSpc13},
             Description -> "PMNS'-Matrix", TeX-> Superscript[V',PMNS]},
   CKMps13d == { ParameterType -> Internal, Value-> CKMps13*Exp[I CKMpdel], Description->"s_{13} Exp[i delta]"},
   CKMpc12  == { ParameterType -> Internal, Value-> Sqrt[1-CKMps12^2], Description->"c_{12}"},
   CKMpc13  == { ParameterType -> Internal, Value-> Sqrt[1-CKMps13^2], Description->"c_{13}"},
   CKMpc23  == { ParameterType -> Internal, Value-> Sqrt[1-CKMps23^2], Description->"c_{23}"},
   CKMp== { ParameterType -> Internal, Indices->{Index[GEN],Index[GEN]}, Unitary-> True,
             Value->{
              CKMp[1,1]-> CKMpc12*CKMpc13,                          CKMp[1,2]-> CKMps12*CKMpc13,                          CKMp[1,3]->Conjugate[CKMps13d],
              CKMp[2,1]->-CKMps12*CKMpc23-CKMpc12*CKMps23*CKMps13d, CKMp[2,2]-> CKMpc12*CKMpc23-CKMps12*CKMps23*CKMps13d, CKMp[2,3]->CKMps23*CKMpc13,
              CKMp[3,1]-> CKMps12*CKMps23-CKMpc12*CKMpc23*CKMps13d, CKMp[3,2]->-CKMpc12*CKMps23-CKMps12*CKMpc23*CKMps13d, CKMp[3,3]->CKMpc23*CKMpc13},
             Description -> "CKM'-Matrix", TeX-> Superscript[V',CKM]},

(* Effective Higgs couplings *)
  Ghgg == { ParameterType -> External, InteractionOrder->{HIG,1}, TeX->Subscript[g,hgg], Description -> "Loop-induced h0-gluon coupling",
            BlockName -> EffectiveHiggs, OrderBlock->1, Value ->  0.12},
  Ghaa == { ParameterType -> External, InteractionOrder->{HIG,1}, TeX->Subscript[g,haa], Description -> "Loop-induced h0-photon coupling",
            BlockName -> EffectiveHiggs, OrderBlock->2, Value ->  0.11}
};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)
(* LVector *)
LVector := Plus@@ (Block[{aa,mu,nu}, -1/4 If[Abelian, FS[GaugeBoson,mu,nu]^2, FS[GaugeBoson,mu,nu,aa]^2] /.MR$GaugeGroupRules[#]] & /@ MR$GaugeGroupList);

(* LMatter *)
LMatter := Block[{mu}, I*(
    QLbar.Ga[mu].DC[QL, mu] + QRbar.Ga[mu].DC[QR, mu] + dLpbar.Ga[mu].DC[dLp, mu] + dRbar.Ga[mu].DC[dR, mu] +
    LLbar.Ga[mu].DC[LL, mu] + LRbar.Ga[mu].DC[LR, mu] + NLbar.Ga[mu].DC[NL, mu] + VRbar.Ga[mu].DC[VR, mu])];

(* Scalar potential *)
VHiggs:= Block[{II,IIp,JJ,JJp,JJpp,KK,KKp,LL,LLp,LLpp},
     - MU22 (chiLbar[II] chiL[II] + chiRbar[II] chiR[II])\
     - MU12 (Phibar[II,JJ] Phi[II,JJ]) \
     + lam1 (Phibar[II,JJ] Phi[II,JJ]) (Phibar[KK,LL]Phi[KK,LL]) \
     + lam2 (Phi[II, JJ] UEpsRs[JJ, JJp] DEps[II, IIp] Phi[IIp, JJp]) HC[Phi[KK, LL] UEpsRs[LL, LLp] DEps[KK, KKp] Phi[KKp, LLp]] \
     + lam3 ( chiLbar[II] chiL[II] chiLbar[JJ] chiL[JJ] + chiRbar[II] chiR[II] chiRbar[JJ] chiR[JJ]) \
     + 2 lam4 chiLbar[II] chiL[II] chiRbar[JJ] chiR[JJ] \
     + kap (chiLbar[II] Phi[II, JJ] IDLT[JJp, JJ] chiR[JJp] + chiRbar[JJp] IDLT[JJp, JJ] Phibar[II, JJ] chiL[II]) \
     + 2 alp1 (Phibar[II,JJ] Phi[II,JJ]) (chiLbar[KK] chiL[KK] + chiRbar[KK] chiR[KK]) \
     + 2 alp2 (chiLbar[II] Phi[II, JJ] chiL[KK] Phibar[KK, JJ] + IDLT[II, IIp] IDLT[KK, KKp] Phibar[JJ, IIp] chiRbar[II] Phi[JJ, KKp] chiR[KK]) \
     + 2 alp3 HC[chiL[II] UEpsRs[JJ,JJp] DEps[II,IIp] Phi[IIp,JJp]] (chiL[KK] UEpsRs[JJ,LLp] DEps[KK,KKp] Phi[KKp,LLp]) \
     + 2 alp3 chiRbar[JJpp] IDLT[JJpp,JJ] UEpsRs[JJ,JJp] DEps[II,IIp] Phi[IIp,JJp] HC[chiRbar[LLpp] IDLT[LLpp,LL] UEpsRs[LL,LLp] DEps[II,KKp] Phi[KKp,LLp]]];

(* Higgs Lagrangian *)
LHiggs:= DC[Phibar[II,JJ],mu] DC[Phi[II,JJ],mu] + DC[chiLbar[II],mu] DC[chiL[II],mu] + DC[chiRbar[II],mu] DC[chiR[II],mu] - VHiggs;

(* Yukawa Lagrangian *)
LYuk:= Block[{sp1,ff1,ff2,ff3,cc,ii,iip,jj,jjp,jjpp},
    yu[ff1,ff2]  QLbar[sp1,ii,ff1,cc].QR[sp1,jjpp,ff2,cc] IDLT[jjpp,jj] DEps[ii,iip] UEpsRs[jj,jjp] Phibar[iip, jjp] \
  - yd[ff2,ff3]  CKM[ff1,ff2]  QLbar[sp1,ii,ff1,cc].dR[sp1,ff3,cc] chiL[ii] \
  - ydp[ff2,ff3] CKMp[ff1,ff2] QRbar[sp1,ii,ff1,cc].dLp[sp1,ff3,cc] chiR[ii] \
  - ye[ff1,ff2]  LLbar[sp1,ii,ff1].LR[sp1,jj,ff2] IDLT[jj,jjp] Phi[ii,jjp] \
  + ynu[ff2,ff3] PMNS[ff1,ff2] LLbar[sp1,ii,ff1].VR[sp1,ff3] UEpsL[ii,jj] chiLbar[jj] \
  + yn[ff2,ff3]  PMNSp[ff1,ff2] LRbar[sp1,ii,ff1].NL[sp1,ff3] UEpsR[ii,jj] chiRbar[jj] ];

(* Ghost Lagrangian *)
LGhost:= - ghGbar.del[DC[ghG,mu],mu];

(* Effective Higgs couplings *)
LagHEffective := Block[{mu,nu,aa}, -1/4 Ghaa H0 FS[A,mu,nu] FS[A,mu,nu] -1/4 Ghgg H0 FS[G,mu,nu,aa] FS[G,mu,nu,aa] ];

