# This file was automatically created by FeynRules 2.4.68
# Mathematica version: 10.4.1 for Mac OS X x86 (64-bit) (April 11, 2016)
# Date: Wed 29 May 2019 00:45:20



from object_library import all_parameters, Parameter


from function_library import complexconjugate, re, im, csc, sec, acsc, asec, cot

# This is a default parameter object representing 0.
ZERO = Parameter(name = 'ZERO',
                 nature = 'internal',
                 type = 'real',
                 value = '0.0',
                 texname = '0')

# User-defined parameters.
CKMlam = Parameter(name = 'CKMlam',
                   nature = 'external',
                   type = 'real',
                   value = 0.22453,
                   texname = '\\lambda _{\\text{CKM}}',
                   lhablock = 'CKMBLOCK',
                   lhacode = [ 1 ])

CKMA = Parameter(name = 'CKMA',
                 nature = 'external',
                 type = 'real',
                 value = 0.836,
                 texname = 'A_{\\text{CKM}}',
                 lhablock = 'CKMBLOCK',
                 lhacode = [ 2 ])

CKMrho = Parameter(name = 'CKMrho',
                   nature = 'external',
                   type = 'real',
                   value = 0.122,
                   texname = '\\rho _{\\text{CKM}}',
                   lhablock = 'CKMBLOCK',
                   lhacode = [ 3 ])

CKMeta = Parameter(name = 'CKMeta',
                   nature = 'external',
                   type = 'real',
                   value = 0.355,
                   texname = '\\eta _{\\text{CKM}}',
                   lhablock = 'CKMBLOCK',
                   lhacode = [ 4 ])

CKMps12 = Parameter(name = 'CKMps12',
                    nature = 'external',
                    type = 'real',
                    value = 0.22453,
                    texname = '\\text{CKMps12}',
                    lhablock = 'CKMBLOCK',
                    lhacode = [ 11 ])

CKMps23 = Parameter(name = 'CKMps23',
                    nature = 'external',
                    type = 'real',
                    value = 0.0421,
                    texname = '\\text{CKMps23}',
                    lhablock = 'CKMBLOCK',
                    lhacode = [ 12 ])

CKMps13 = Parameter(name = 'CKMps13',
                    nature = 'external',
                    type = 'real',
                    value = 0.00364,
                    texname = '\\text{CKMps13}',
                    lhablock = 'CKMBLOCK',
                    lhacode = [ 13 ])

CKMpdel = Parameter(name = 'CKMpdel',
                    nature = 'external',
                    type = 'real',
                    value = 1.24,
                    texname = '\\text{CKMpdel}',
                    lhablock = 'CKMBLOCK',
                    lhacode = [ 14 ])

lam2 = Parameter(name = 'lam2',
                 nature = 'external',
                 type = 'real',
                 value = 0.5,
                 texname = '\\lambda _2',
                 lhablock = 'HPOTINPUTS',
                 lhacode = [ 1 ])

lam3 = Parameter(name = 'lam3',
                 nature = 'external',
                 type = 'real',
                 value = 1.6,
                 texname = '\\lambda _3',
                 lhablock = 'HPOTINPUTS',
                 lhacode = [ 2 ])

alp1 = Parameter(name = 'alp1',
                 nature = 'external',
                 type = 'real',
                 value = 0.3,
                 texname = '\\alpha _1',
                 lhablock = 'HPOTINPUTS',
                 lhacode = [ 3 ])

alp2 = Parameter(name = 'alp2',
                 nature = 'external',
                 type = 'real',
                 value = 0.1,
                 texname = '\\alpha _2',
                 lhablock = 'HPOTINPUTS',
                 lhacode = [ 4 ])

alp3 = Parameter(name = 'alp3',
                 nature = 'external',
                 type = 'real',
                 value = 0.3,
                 texname = '\\alpha _3',
                 lhablock = 'HPOTINPUTS',
                 lhacode = [ 5 ])

kap = Parameter(name = 'kap',
                nature = 'external',
                type = 'real',
                value = -10.,
                texname = '\\kappa',
                lhablock = 'HPOTINPUTS',
                lhacode = [ 6 ])

PMNSs12 = Parameter(name = 'PMNSs12',
                    nature = 'external',
                    type = 'real',
                    value = 0.5449770637375485,
                    texname = '\\text{PMNSs12}',
                    lhablock = 'PMNSBLOCK',
                    lhacode = [ 1 ])

PMNSs23 = Parameter(name = 'PMNSs23',
                    nature = 'external',
                    type = 'real',
                    value = 0.6519202405202649,
                    texname = '\\text{PMNSs23}',
                    lhablock = 'PMNSBLOCK',
                    lhacode = [ 2 ])

PMNSs13 = Parameter(name = 'PMNSs13',
                    nature = 'external',
                    type = 'real',
                    value = 0.14662878298615178,
                    texname = '\\text{PMNSs13}',
                    lhablock = 'PMNSBLOCK',
                    lhacode = [ 3 ])

PMNSdel = Parameter(name = 'PMNSdel',
                    nature = 'external',
                    type = 'real',
                    value = 4.335397861953914,
                    texname = '\\text{PMNSdel}',
                    lhablock = 'PMNSBLOCK',
                    lhacode = [ 4 ])

PMNSps12 = Parameter(name = 'PMNSps12',
                     nature = 'external',
                     type = 'real',
                     value = 0.5449770637375485,
                     texname = '\\text{PMNSps12}',
                     lhablock = 'PMNSBLOCK',
                     lhacode = [ 11 ])

PMNSps23 = Parameter(name = 'PMNSps23',
                     nature = 'external',
                     type = 'real',
                     value = 0.6519202405202649,
                     texname = '\\text{PMNSps23}',
                     lhablock = 'PMNSBLOCK',
                     lhacode = [ 12 ])

PMNSps13 = Parameter(name = 'PMNSps13',
                     nature = 'external',
                     type = 'real',
                     value = 0.14662878298615178,
                     texname = '\\text{PMNSps13}',
                     lhablock = 'PMNSBLOCK',
                     lhacode = [ 13 ])

PMNSpdel = Parameter(name = 'PMNSpdel',
                     nature = 'external',
                     type = 'real',
                     value = 4.335397861953914,
                     texname = '\\text{PMNSpdel}',
                     lhablock = 'PMNSBLOCK',
                     lhacode = [ 14 ])

aEWM1 = Parameter(name = 'aEWM1',
                  nature = 'external',
                  type = 'real',
                  value = 127.9,
                  texname = '\\text{Subsuperscript}[\\alpha ,w,-1]',
                  lhablock = 'SMINPUTS',
                  lhacode = [ 1 ])

Gf = Parameter(name = 'Gf',
               nature = 'external',
               type = 'real',
               value = 0.0000116637,
               texname = 'G_f',
               lhablock = 'SMINPUTS',
               lhacode = [ 2 ])

aS = Parameter(name = 'aS',
               nature = 'external',
               type = 'real',
               value = 0.1184,
               texname = '\\alpha _s',
               lhablock = 'SMINPUTS',
               lhacode = [ 3 ])

tb = Parameter(name = 'tb',
               nature = 'external',
               type = 'real',
               value = 10.,
               texname = 't_{\\beta }',
               lhablock = 'SMINPUTS',
               lhacode = [ 5 ])

gR = Parameter(name = 'gR',
               nature = 'external',
               type = 'real',
               value = 0.64648221,
               texname = 'g_R',
               lhablock = 'SMINPUTS',
               lhacode = [ 6 ])

vevp = Parameter(name = 'vevp',
                 nature = 'external',
                 type = 'real',
                 value = 6500,
                 texname = 'v\'',
                 lhablock = 'SMINPUTS',
                 lhacode = [ 7 ])

MZ = Parameter(name = 'MZ',
               nature = 'external',
               type = 'real',
               value = 91.1876,
               texname = '\\text{MZ}',
               lhablock = 'MASS',
               lhacode = [ 23 ])

MH0 = Parameter(name = 'MH0',
                nature = 'external',
                type = 'real',
                value = 125.,
                texname = '\\text{MH0}',
                lhablock = 'MASS',
                lhacode = [ 25 ])

Mve = Parameter(name = 'Mve',
                nature = 'external',
                type = 'real',
                value = 1.e-12,
                texname = '\\text{Mve}',
                lhablock = 'MASS',
                lhacode = [ 12 ])

Mvm = Parameter(name = 'Mvm',
                nature = 'external',
                type = 'real',
                value = 8.9e-12,
                texname = '\\text{Mvm}',
                lhablock = 'MASS',
                lhacode = [ 14 ])

Mvt = Parameter(name = 'Mvt',
                nature = 'external',
                type = 'real',
                value = 5.04e-11,
                texname = '\\text{Mvt}',
                lhablock = 'MASS',
                lhacode = [ 16 ])

Me = Parameter(name = 'Me',
               nature = 'external',
               type = 'real',
               value = 0.000511,
               texname = '\\text{Me}',
               lhablock = 'MASS',
               lhacode = [ 11 ])

MMU = Parameter(name = 'MMU',
                nature = 'external',
                type = 'real',
                value = 0.10566,
                texname = '\\text{MMU}',
                lhablock = 'MASS',
                lhacode = [ 13 ])

MTA = Parameter(name = 'MTA',
                nature = 'external',
                type = 'real',
                value = 1.777,
                texname = '\\text{MTA}',
                lhablock = 'MASS',
                lhacode = [ 15 ])

MU = Parameter(name = 'MU',
               nature = 'external',
               type = 'real',
               value = 0.00255,
               texname = 'M',
               lhablock = 'MASS',
               lhacode = [ 2 ])

MC = Parameter(name = 'MC',
               nature = 'external',
               type = 'real',
               value = 1.27,
               texname = '\\text{MC}',
               lhablock = 'MASS',
               lhacode = [ 4 ])

MT = Parameter(name = 'MT',
               nature = 'external',
               type = 'real',
               value = 172,
               texname = '\\text{MT}',
               lhablock = 'MASS',
               lhacode = [ 6 ])

MD = Parameter(name = 'MD',
               nature = 'external',
               type = 'real',
               value = 0.00504,
               texname = '\\text{MD}',
               lhablock = 'MASS',
               lhacode = [ 1 ])

MS = Parameter(name = 'MS',
               nature = 'external',
               type = 'real',
               value = 0.101,
               texname = '\\text{MS}',
               lhablock = 'MASS',
               lhacode = [ 3 ])

MB = Parameter(name = 'MB',
               nature = 'external',
               type = 'real',
               value = 4.7,
               texname = '\\text{MB}',
               lhablock = 'MASS',
               lhacode = [ 5 ])

Mne = Parameter(name = 'Mne',
                nature = 'external',
                type = 'real',
                value = 300,
                texname = '\\text{Mne}',
                lhablock = 'MASS',
                lhacode = [ 6000012 ])

Mnm = Parameter(name = 'Mnm',
                nature = 'external',
                type = 'real',
                value = 500,
                texname = '\\text{Mnm}',
                lhablock = 'MASS',
                lhacode = [ 6000014 ])

Mnt = Parameter(name = 'Mnt',
                nature = 'external',
                type = 'real',
                value = 700,
                texname = '\\text{Mnt}',
                lhablock = 'MASS',
                lhacode = [ 6000016 ])

MDP = Parameter(name = 'MDP',
                nature = 'external',
                type = 'real',
                value = 301,
                texname = '\\text{MDP}',
                lhablock = 'MASS',
                lhacode = [ 6000001 ])

MSP = Parameter(name = 'MSP',
                nature = 'external',
                type = 'real',
                value = 501,
                texname = '\\text{MSP}',
                lhablock = 'MASS',
                lhacode = [ 6000003 ])

MBP = Parameter(name = 'MBP',
                nature = 'external',
                type = 'real',
                value = 701,
                texname = '\\text{MBP}',
                lhablock = 'MASS',
                lhacode = [ 6000005 ])

WZ = Parameter(name = 'WZ',
               nature = 'external',
               type = 'real',
               value = 2.4952,
               texname = '\\text{WZ}',
               lhablock = 'DECAY',
               lhacode = [ 23 ])

WZp = Parameter(name = 'WZp',
                nature = 'external',
                type = 'real',
                value = 13.2,
                texname = '\\text{WZp}',
                lhablock = 'DECAY',
                lhacode = [ 32 ])

WW = Parameter(name = 'WW',
               nature = 'external',
               type = 'real',
               value = 2.085,
               texname = '\\text{WW}',
               lhablock = 'DECAY',
               lhacode = [ 24 ])

WWp = Parameter(name = 'WWp',
                nature = 'external',
                type = 'real',
                value = 3.04,
                texname = '\\text{WWp}',
                lhablock = 'DECAY',
                lhacode = [ 34 ])

WH0 = Parameter(name = 'WH0',
                nature = 'external',
                type = 'real',
                value = 0.0176,
                texname = '\\text{WH0}',
                lhablock = 'DECAY',
                lhacode = [ 25 ])

WH1 = Parameter(name = 'WH1',
                nature = 'external',
                type = 'real',
                value = 0.95,
                texname = '\\text{WH1}',
                lhablock = 'DECAY',
                lhacode = [ 35 ])

WH2 = Parameter(name = 'WH2',
                nature = 'external',
                type = 'real',
                value = 3.18,
                texname = '\\text{WH2}',
                lhablock = 'DECAY',
                lhacode = [ 45 ])

WH3 = Parameter(name = 'WH3',
                nature = 'external',
                type = 'real',
                value = 781.,
                texname = '\\text{WH3}',
                lhablock = 'DECAY',
                lhacode = [ 55 ])

WA1 = Parameter(name = 'WA1',
                nature = 'external',
                type = 'real',
                value = 0.95,
                texname = '\\text{WA1}',
                lhablock = 'DECAY',
                lhacode = [ 36 ])

WA2 = Parameter(name = 'WA2',
                nature = 'external',
                type = 'real',
                value = 3.18,
                texname = '\\text{WA2}',
                lhablock = 'DECAY',
                lhacode = [ 46 ])

WHp1 = Parameter(name = 'WHp1',
                 nature = 'external',
                 type = 'real',
                 value = 2.83,
                 texname = '\\text{WHp1}',
                 lhablock = 'DECAY',
                 lhacode = [ 37 ])

WHp2 = Parameter(name = 'WHp2',
                 nature = 'external',
                 type = 'real',
                 value = 0.423,
                 texname = '\\text{WHp2}',
                 lhablock = 'DECAY',
                 lhacode = [ 47 ])

WT = Parameter(name = 'WT',
               nature = 'external',
               type = 'real',
               value = 1.50833649,
               texname = '\\text{WT}',
               lhablock = 'DECAY',
               lhacode = [ 6 ])

Wnm = Parameter(name = 'Wnm',
                nature = 'external',
                type = 'real',
                value = 0.000709,
                texname = '\\text{Wnm}',
                lhablock = 'DECAY',
                lhacode = [ 6000014 ])

Wnt = Parameter(name = 'Wnt',
                nature = 'external',
                type = 'real',
                value = 1.13,
                texname = '\\text{Wnt}',
                lhablock = 'DECAY',
                lhacode = [ 6000016 ])

WSP = Parameter(name = 'WSP',
                nature = 'external',
                type = 'real',
                value = 0.262,
                texname = '\\text{WSP}',
                lhablock = 'DECAY',
                lhacode = [ 6000003 ])

WBP = Parameter(name = 'WBP',
                nature = 'external',
                type = 'real',
                value = 9.85,
                texname = '\\text{WBP}',
                lhablock = 'DECAY',
                lhacode = [ 6000005 ])

beta = Parameter(name = 'beta',
                 nature = 'internal',
                 type = 'real',
                 value = 'cmath.atan(tb)',
                 texname = '\\beta')

vev = Parameter(name = 'vev',
                nature = 'internal',
                type = 'real',
                value = '1/(2**0.25*cmath.sqrt(Gf))',
                texname = 'v')

MW = Parameter(name = 'MW',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(MZ**2/2. + cmath.sqrt(MZ**4/4. - (cmath.pi*MZ**2)/(aEWM1*Gf*cmath.sqrt(2))))',
               texname = 'M_W')

ee = Parameter(name = 'ee',
               nature = 'internal',
               type = 'real',
               value = '2*cmath.sqrt(1/aEWM1)*cmath.sqrt(cmath.pi)',
               texname = 'e')

G = Parameter(name = 'G',
              nature = 'internal',
              type = 'real',
              value = '2*cmath.sqrt(aS)*cmath.sqrt(cmath.pi)',
              texname = 'G')

MWp = Parameter(name = 'MWp',
                nature = 'internal',
                type = 'real',
                value = '(gR*vevp)/2.',
                texname = 'M_{W\'}')

TH1x2 = Parameter(name = 'TH1x2',
                  nature = 'internal',
                  type = 'complex',
                  value = '0',
                  texname = '\\text{TH1x2}')

TH2x1 = Parameter(name = 'TH2x1',
                  nature = 'internal',
                  type = 'complex',
                  value = '0',
                  texname = '\\text{TH2x1}')

TH2x2 = Parameter(name = 'TH2x2',
                  nature = 'internal',
                  type = 'complex',
                  value = '1',
                  texname = '\\text{TH2x2}')

TH2x3 = Parameter(name = 'TH2x3',
                  nature = 'internal',
                  type = 'complex',
                  value = '0',
                  texname = '\\text{TH2x3}')

TH2x4 = Parameter(name = 'TH2x4',
                  nature = 'internal',
                  type = 'complex',
                  value = '0',
                  texname = '\\text{TH2x4}')

TH3x2 = Parameter(name = 'TH3x2',
                  nature = 'internal',
                  type = 'complex',
                  value = '0',
                  texname = '\\text{TH3x2}')

TH4x2 = Parameter(name = 'TH4x2',
                  nature = 'internal',
                  type = 'complex',
                  value = '0',
                  texname = '\\text{TH4x2}')

CKMs12 = Parameter(name = 'CKMs12',
                   nature = 'internal',
                   type = 'real',
                   value = 'CKMlam',
                   texname = '\\text{CKMs12}')

CKMs23 = Parameter(name = 'CKMs23',
                   nature = 'internal',
                   type = 'real',
                   value = 'CKMA*CKMlam**2',
                   texname = '\\text{CKMs23}')

CKMs13d = Parameter(name = 'CKMs13d',
                    nature = 'internal',
                    type = 'complex',
                    value = '(CKMA*CKMlam**3*(CKMrho + CKMeta*complex(0,1))*cmath.sqrt(1 - CKMA**2*CKMlam**4))/((1 - CKMA**2*CKMlam**4*(CKMrho + CKMeta*complex(0,1)))*cmath.sqrt(1 - CKMlam**2))',
                    texname = '\\text{CKMs13d}')

PMNSs13d = Parameter(name = 'PMNSs13d',
                     nature = 'internal',
                     type = 'complex',
                     value = 'PMNSs13*cmath.exp(complex(0,1)*PMNSdel)',
                     texname = '\\text{PMNSs13d}')

PMNSc12 = Parameter(name = 'PMNSc12',
                    nature = 'internal',
                    type = 'real',
                    value = 'cmath.sqrt(1 - PMNSs12**2)',
                    texname = '\\text{PMNSc12}')

PMNSc13 = Parameter(name = 'PMNSc13',
                    nature = 'internal',
                    type = 'real',
                    value = 'cmath.sqrt(1 - PMNSs13**2)',
                    texname = '\\text{PMNSc13}')

PMNSc23 = Parameter(name = 'PMNSc23',
                    nature = 'internal',
                    type = 'real',
                    value = 'cmath.sqrt(1 - PMNSs23**2)',
                    texname = '\\text{PMNSc23}')

PMNSps13d = Parameter(name = 'PMNSps13d',
                      nature = 'internal',
                      type = 'complex',
                      value = 'PMNSps13*cmath.exp(complex(0,1)*PMNSpdel)',
                      texname = '\\text{PMNSps13d}')

PMNSpc12 = Parameter(name = 'PMNSpc12',
                     nature = 'internal',
                     type = 'real',
                     value = 'cmath.sqrt(1 - PMNSps12**2)',
                     texname = '\\text{PMNSpc12}')

PMNSpc13 = Parameter(name = 'PMNSpc13',
                     nature = 'internal',
                     type = 'real',
                     value = 'cmath.sqrt(1 - PMNSps13**2)',
                     texname = '\\text{PMNSpc13}')

PMNSpc23 = Parameter(name = 'PMNSpc23',
                     nature = 'internal',
                     type = 'real',
                     value = 'cmath.sqrt(1 - PMNSps23**2)',
                     texname = '\\text{PMNSpc23}')

CKMps13d = Parameter(name = 'CKMps13d',
                     nature = 'internal',
                     type = 'complex',
                     value = 'CKMps13*cmath.exp(CKMpdel*complex(0,1))',
                     texname = '\\text{CKMps13d}')

CKMpc12 = Parameter(name = 'CKMpc12',
                    nature = 'internal',
                    type = 'real',
                    value = 'cmath.sqrt(1 - CKMps12**2)',
                    texname = '\\text{CKMpc12}')

CKMpc13 = Parameter(name = 'CKMpc13',
                    nature = 'internal',
                    type = 'real',
                    value = 'cmath.sqrt(1 - CKMps13**2)',
                    texname = '\\text{CKMpc13}')

CKMpc23 = Parameter(name = 'CKMpc23',
                    nature = 'internal',
                    type = 'real',
                    value = 'cmath.sqrt(1 - CKMps23**2)',
                    texname = '\\text{CKMpc23}')

CKM1x3 = Parameter(name = 'CKM1x3',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKMs13d',
                   texname = '\\text{CKM1x3}')

CKMc12 = Parameter(name = 'CKMc12',
                   nature = 'internal',
                   type = 'real',
                   value = 'cmath.sqrt(1 - CKMs12**2)',
                   texname = '\\text{CKMc12}')

CKMc13 = Parameter(name = 'CKMc13',
                   nature = 'internal',
                   type = 'real',
                   value = 'cmath.sqrt(1 - abs(CKMs13d)**2)',
                   texname = '\\text{CKMc13}')

CKMc23 = Parameter(name = 'CKMc23',
                   nature = 'internal',
                   type = 'real',
                   value = 'cmath.sqrt(1 - CKMs23**2)',
                   texname = '\\text{CKMc23}')

CKMp1x1 = Parameter(name = 'CKMp1x1',
                    nature = 'internal',
                    type = 'complex',
                    value = 'CKMpc12*CKMpc13',
                    texname = '\\text{CKMp1x1}')

CKMp1x2 = Parameter(name = 'CKMp1x2',
                    nature = 'internal',
                    type = 'complex',
                    value = 'CKMpc13*CKMps12',
                    texname = '\\text{CKMp1x2}')

CKMp1x3 = Parameter(name = 'CKMp1x3',
                    nature = 'internal',
                    type = 'complex',
                    value = 'CKMps13d',
                    texname = '\\text{CKMp1x3}')

CKMp2x1 = Parameter(name = 'CKMp2x1',
                    nature = 'internal',
                    type = 'complex',
                    value = '-(CKMpc23*CKMps12) - CKMpc12*CKMps13d*CKMps23',
                    texname = '\\text{CKMp2x1}')

CKMp2x2 = Parameter(name = 'CKMp2x2',
                    nature = 'internal',
                    type = 'complex',
                    value = 'CKMpc12*CKMpc23 - CKMps12*CKMps13d*CKMps23',
                    texname = '\\text{CKMp2x2}')

CKMp2x3 = Parameter(name = 'CKMp2x3',
                    nature = 'internal',
                    type = 'complex',
                    value = 'CKMpc13*CKMps23',
                    texname = '\\text{CKMp2x3}')

CKMp3x1 = Parameter(name = 'CKMp3x1',
                    nature = 'internal',
                    type = 'complex',
                    value = '-(CKMpc12*CKMpc23*CKMps13d) + CKMps12*CKMps23',
                    texname = '\\text{CKMp3x1}')

CKMp3x2 = Parameter(name = 'CKMp3x2',
                    nature = 'internal',
                    type = 'complex',
                    value = '-(CKMpc23*CKMps12*CKMps13d) - CKMpc12*CKMps23',
                    texname = '\\text{CKMp3x2}')

CKMp3x3 = Parameter(name = 'CKMp3x3',
                    nature = 'internal',
                    type = 'complex',
                    value = 'CKMpc13*CKMpc23',
                    texname = '\\text{CKMp3x3}')

PMNS1x1 = Parameter(name = 'PMNS1x1',
                    nature = 'internal',
                    type = 'complex',
                    value = 'PMNSc12*PMNSc13',
                    texname = '\\text{PMNS1x1}')

PMNS1x2 = Parameter(name = 'PMNS1x2',
                    nature = 'internal',
                    type = 'complex',
                    value = 'PMNSc13*PMNSs12',
                    texname = '\\text{PMNS1x2}')

PMNS1x3 = Parameter(name = 'PMNS1x3',
                    nature = 'internal',
                    type = 'complex',
                    value = 'PMNSs13d',
                    texname = '\\text{PMNS1x3}')

PMNS2x1 = Parameter(name = 'PMNS2x1',
                    nature = 'internal',
                    type = 'complex',
                    value = '-(PMNSc23*PMNSs12) - PMNSc12*PMNSs13d*PMNSs23',
                    texname = '\\text{PMNS2x1}')

PMNS2x2 = Parameter(name = 'PMNS2x2',
                    nature = 'internal',
                    type = 'complex',
                    value = 'PMNSc12*PMNSc23 - PMNSs12*PMNSs13d*PMNSs23',
                    texname = '\\text{PMNS2x2}')

PMNS2x3 = Parameter(name = 'PMNS2x3',
                    nature = 'internal',
                    type = 'complex',
                    value = 'PMNSc13*PMNSs23',
                    texname = '\\text{PMNS2x3}')

PMNS3x1 = Parameter(name = 'PMNS3x1',
                    nature = 'internal',
                    type = 'complex',
                    value = '-(PMNSc12*PMNSc23*PMNSs13d) + PMNSs12*PMNSs23',
                    texname = '\\text{PMNS3x1}')

PMNS3x2 = Parameter(name = 'PMNS3x2',
                    nature = 'internal',
                    type = 'complex',
                    value = '-(PMNSc23*PMNSs12*PMNSs13d) - PMNSc12*PMNSs23',
                    texname = '\\text{PMNS3x2}')

PMNS3x3 = Parameter(name = 'PMNS3x3',
                    nature = 'internal',
                    type = 'complex',
                    value = 'PMNSc13*PMNSc23',
                    texname = '\\text{PMNS3x3}')

PMNSp1x1 = Parameter(name = 'PMNSp1x1',
                     nature = 'internal',
                     type = 'complex',
                     value = 'PMNSpc12*PMNSpc13',
                     texname = '\\text{PMNSp1x1}')

PMNSp1x2 = Parameter(name = 'PMNSp1x2',
                     nature = 'internal',
                     type = 'complex',
                     value = 'PMNSpc13*PMNSps12',
                     texname = '\\text{PMNSp1x2}')

PMNSp1x3 = Parameter(name = 'PMNSp1x3',
                     nature = 'internal',
                     type = 'complex',
                     value = 'PMNSps13d',
                     texname = '\\text{PMNSp1x3}')

PMNSp2x1 = Parameter(name = 'PMNSp2x1',
                     nature = 'internal',
                     type = 'complex',
                     value = '-(PMNSpc23*PMNSps12) - PMNSpc12*PMNSps13d*PMNSps23',
                     texname = '\\text{PMNSp2x1}')

PMNSp2x2 = Parameter(name = 'PMNSp2x2',
                     nature = 'internal',
                     type = 'complex',
                     value = 'PMNSpc12*PMNSpc23 - PMNSps12*PMNSps13d*PMNSps23',
                     texname = '\\text{PMNSp2x2}')

PMNSp2x3 = Parameter(name = 'PMNSp2x3',
                     nature = 'internal',
                     type = 'complex',
                     value = 'PMNSpc13*PMNSps23',
                     texname = '\\text{PMNSp2x3}')

PMNSp3x1 = Parameter(name = 'PMNSp3x1',
                     nature = 'internal',
                     type = 'complex',
                     value = '-(PMNSpc12*PMNSpc23*PMNSps13d) + PMNSps12*PMNSps23',
                     texname = '\\text{PMNSp3x1}')

PMNSp3x2 = Parameter(name = 'PMNSp3x2',
                     nature = 'internal',
                     type = 'complex',
                     value = '-(PMNSpc23*PMNSps12*PMNSps13d) - PMNSpc12*PMNSps23',
                     texname = '\\text{PMNSp3x2}')

PMNSp3x3 = Parameter(name = 'PMNSp3x3',
                     nature = 'internal',
                     type = 'complex',
                     value = 'PMNSpc13*PMNSpc23',
                     texname = '\\text{PMNSp3x3}')

gL = Parameter(name = 'gL',
               nature = 'internal',
               type = 'real',
               value = '(2*MW)/vev',
               texname = 'g_L')

kk = Parameter(name = 'kk',
               nature = 'internal',
               type = 'real',
               value = 'vev*cmath.sin(beta)',
               texname = 'k')

vL = Parameter(name = 'vL',
               nature = 'internal',
               type = 'real',
               value = 'vev*cmath.cos(beta)',
               texname = 'v_L')

CKM1x1 = Parameter(name = 'CKM1x1',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKMc12*CKMc13',
                   texname = '\\text{CKM1x1}')

CKM1x2 = Parameter(name = 'CKM1x2',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKMc13*CKMs12',
                   texname = '\\text{CKM1x2}')

CKM2x1 = Parameter(name = 'CKM2x1',
                   nature = 'internal',
                   type = 'complex',
                   value = '-(CKMc23*CKMs12) - CKMc12*CKMs13d*CKMs23',
                   texname = '\\text{CKM2x1}')

CKM2x2 = Parameter(name = 'CKM2x2',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKMc12*CKMc23 - CKMs12*CKMs13d*CKMs23',
                   texname = '\\text{CKM2x2}')

CKM2x3 = Parameter(name = 'CKM2x3',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKMc13*CKMs23',
                   texname = '\\text{CKM2x3}')

CKM3x1 = Parameter(name = 'CKM3x1',
                   nature = 'internal',
                   type = 'complex',
                   value = '-(CKMc12*CKMc23*CKMs13d) + CKMs12*CKMs23',
                   texname = '\\text{CKM3x1}')

CKM3x2 = Parameter(name = 'CKM3x2',
                   nature = 'internal',
                   type = 'complex',
                   value = '-(CKMc23*CKMs12*CKMs13d) - CKMc12*CKMs23',
                   texname = '\\text{CKM3x2}')

CKM3x3 = Parameter(name = 'CKM3x3',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKMc13*CKMc23',
                   texname = '\\text{CKM3x3}')

sw = Parameter(name = 'sw',
               nature = 'internal',
               type = 'real',
               value = 'ee/gL',
               texname = 's_w')

vR = Parameter(name = 'vR',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(-kk**2 + vevp**2)',
               texname = 'v_R')

yd1x1 = Parameter(name = 'yd1x1',
                  nature = 'internal',
                  type = 'real',
                  value = '(MD*cmath.sqrt(2))/vL',
                  texname = '\\text{yd1x1}')

yd2x2 = Parameter(name = 'yd2x2',
                  nature = 'internal',
                  type = 'real',
                  value = '(MS*cmath.sqrt(2))/vL',
                  texname = '\\text{yd2x2}')

yd3x3 = Parameter(name = 'yd3x3',
                  nature = 'internal',
                  type = 'real',
                  value = '(MB*cmath.sqrt(2))/vL',
                  texname = '\\text{yd3x3}')

ye1x1 = Parameter(name = 'ye1x1',
                  nature = 'internal',
                  type = 'real',
                  value = '(Me*cmath.sqrt(2))/kk',
                  texname = '\\text{ye1x1}')

ye2x2 = Parameter(name = 'ye2x2',
                  nature = 'internal',
                  type = 'real',
                  value = '(MMU*cmath.sqrt(2))/kk',
                  texname = '\\text{ye2x2}')

ye3x3 = Parameter(name = 'ye3x3',
                  nature = 'internal',
                  type = 'real',
                  value = '(MTA*cmath.sqrt(2))/kk',
                  texname = '\\text{ye3x3}')

ynu1x1 = Parameter(name = 'ynu1x1',
                   nature = 'internal',
                   type = 'real',
                   value = '(Mve*cmath.sqrt(2))/vL',
                   texname = '\\text{ynu1x1}')

ynu2x2 = Parameter(name = 'ynu2x2',
                   nature = 'internal',
                   type = 'real',
                   value = '(Mvm*cmath.sqrt(2))/vL',
                   texname = '\\text{ynu2x2}')

ynu3x3 = Parameter(name = 'ynu3x3',
                   nature = 'internal',
                   type = 'real',
                   value = '(Mvt*cmath.sqrt(2))/vL',
                   texname = '\\text{ynu3x3}')

yu1x1 = Parameter(name = 'yu1x1',
                  nature = 'internal',
                  type = 'real',
                  value = '(MU*cmath.sqrt(2))/kk',
                  texname = '\\text{yu1x1}')

yu2x2 = Parameter(name = 'yu2x2',
                  nature = 'internal',
                  type = 'real',
                  value = '(MC*cmath.sqrt(2))/kk',
                  texname = '\\text{yu2x2}')

yu3x3 = Parameter(name = 'yu3x3',
                  nature = 'internal',
                  type = 'real',
                  value = '(MT*cmath.sqrt(2))/kk',
                  texname = '\\text{yu3x3}')

cw = Parameter(name = 'cw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(1 - sw**2)',
               texname = 'c_w')

MA1 = Parameter(name = 'MA1',
                nature = 'internal',
                type = 'real',
                value = 'cmath.sqrt(2*kk**2*lam2 - (alp2 - alp3)*(vL**2 + vR**2) - (kap*vL*vR)/(kk*cmath.sqrt(2)))',
                texname = '\\text{MA1}')

MA2 = Parameter(name = 'MA2',
                nature = 'internal',
                type = 'real',
                value = 'cmath.sqrt(-((kap*(vL**2*vR**2 + kk**2*(vL**2 + vR**2)))/(kk*vL*vR)))/2**0.25',
                texname = '\\text{MA2}')

MH1 = Parameter(name = 'MH1',
                nature = 'internal',
                type = 'real',
                value = 'cmath.sqrt(2*kk**2*lam2 - (alp2 - alp3)*(vL**2 + vR**2) - (kap*vL*vR)/(kk*cmath.sqrt(2)))',
                texname = '\\text{MH1}')

MHp1 = Parameter(name = 'MHp1',
                 nature = 'internal',
                 type = 'real',
                 value = 'cmath.sqrt(-(((kk**2 + vL**2)*(2*(alp2 - alp3)*kk*vL + kap*vR*cmath.sqrt(2)))/(kk*vL)))/cmath.sqrt(2)',
                 texname = '\\text{MHp1}')

MHp2 = Parameter(name = 'MHp2',
                 nature = 'internal',
                 type = 'real',
                 value = 'cmath.sqrt(-(((kk**2 + vR**2)*(2*(alp2 - alp3)*kk*vR + kap*vL*cmath.sqrt(2)))/(kk*vR)))/cmath.sqrt(2)',
                 texname = '\\text{MHp2}')

MU22 = Parameter(name = 'MU22',
                 nature = 'internal',
                 type = 'real',
                 value = '(alp1 + alp2)*kk**2 + lam3*(vL**2 + vR**2)',
                 texname = '\\text{Subsuperscript}[\\mu ,2,2]')

TH1x1 = Parameter(name = 'TH1x1',
                  nature = 'internal',
                  type = 'complex',
                  value = '(2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*cmath.sqrt(1 + (2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2) + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))',
                  texname = '\\text{TH1x1}')

TH3x1 = Parameter(name = 'TH3x1',
                  nature = 'internal',
                  type = 'complex',
                  value = '(vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*cmath.sqrt(1 + (2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2) + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))',
                  texname = '\\text{TH3x1}')

TH4x1 = Parameter(name = 'TH4x1',
                  nature = 'internal',
                  type = 'complex',
                  value = '1/cmath.sqrt(1 + (2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2) + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2))',
                  texname = '\\text{TH4x1}')

tz = Parameter(name = 'tz',
               nature = 'internal',
               type = 'real',
               value = 'kk/vR',
               texname = 't_{\\zeta }')

lam1 = Parameter(name = 'lam1',
                 nature = 'internal',
                 type = 'real',
                 value = '(-4*(alp1 + alp2)**2*kap*kk**4*(vL**2 - vR**2)**2 + kk*MH0**6*vL*vR*cmath.sqrt(2) - 2*MH0**2*(kap*(lam3*vL**2*vR**2*(vL**2 + vR**2) + kk**2*(4*(alp1 + alp2)*vL**2*vR**2 + lam3*(vL**2 - vR**2)**2)) + 2*(alp1 + alp2)**2*kk**3*vL*vR*(vL**2 + vR**2)*cmath.sqrt(2)) + MH0**4*(kap*(vL**2*vR**2 + kk**2*(vL**2 + vR**2)) - 2*kk*lam3*vL*vR*(vL**2 + vR**2)*cmath.sqrt(2)))/(-4*kap*kk**4*lam3*(vL**2 - vR**2)**2 + 2*kk**3*MH0**4*vL*vR*cmath.sqrt(2) + 2*kk**3*MH0**2*(vL**2 + vR**2)*(kap*kk - 2*lam3*vL*vR*cmath.sqrt(2)))',
                 texname = '\\lambda _1')

lam4 = Parameter(name = 'lam4',
                 nature = 'internal',
                 type = 'real',
                 value = 'lam3 - (kap*kk)/(vL*vR*cmath.sqrt(2))',
                 texname = '\\lambda _4')

ydp1x1 = Parameter(name = 'ydp1x1',
                   nature = 'internal',
                   type = 'real',
                   value = '(MDP*cmath.sqrt(2))/vR',
                   texname = '\\text{ydp1x1}')

ydp2x2 = Parameter(name = 'ydp2x2',
                   nature = 'internal',
                   type = 'real',
                   value = '(MSP*cmath.sqrt(2))/vR',
                   texname = '\\text{ydp2x2}')

ydp3x3 = Parameter(name = 'ydp3x3',
                   nature = 'internal',
                   type = 'real',
                   value = '(MBP*cmath.sqrt(2))/vR',
                   texname = '\\text{ydp3x3}')

yn1x1 = Parameter(name = 'yn1x1',
                  nature = 'internal',
                  type = 'real',
                  value = '(Mne*cmath.sqrt(2))/vR',
                  texname = '\\text{yn1x1}')

yn2x2 = Parameter(name = 'yn2x2',
                  nature = 'internal',
                  type = 'real',
                  value = '(Mnm*cmath.sqrt(2))/vR',
                  texname = '\\text{yn2x2}')

yn3x3 = Parameter(name = 'yn3x3',
                  nature = 'internal',
                  type = 'real',
                  value = '(Mnt*cmath.sqrt(2))/vR',
                  texname = '\\text{yn3x3}')

MH2 = Parameter(name = 'MH2',
                nature = 'internal',
                type = 'real',
                value = 'cmath.sqrt(-MH0**2 + (vL*vR*(-(kap*vL*vR) + 2*kk**3*lam1*cmath.sqrt(2)) + kk*(vL**2 + vR**2)*(-(kap*kk) + 2*lam3*vL*vR*cmath.sqrt(2)))/(kk*vL*vR*cmath.sqrt(2)) - cmath.sqrt((-MH0**2 + (vL*vR*(-(kap*vL*vR) + 2*kk**3*lam1*cmath.sqrt(2)) + kk*(vL**2 + vR**2)*(-(kap*kk) + 2*lam3*vL*vR*cmath.sqrt(2)))/(kk*vL*vR*cmath.sqrt(2)))**2 + 4*((kap*kk**2*(4*(alp1 + alp2)*vL**2*vR**2 + lam3*(vL**2 - vR**2)**2)*cmath.sqrt(2) + (vL**2 + vR**2)*(4*kk**3*(alp1**2 + 2*alp1*alp2 + alp2**2 - lam1*lam3)*vL*vR + kap*(kk**4*lam1 + lam3*vL**2*vR**2)*cmath.sqrt(2)))/(kk*vL*vR) + MH0**2*(-MH0**2 + (vL*vR*(-(kap*vL*vR) + 2*kk**3*lam1*cmath.sqrt(2)) + kk*(vL**2 + vR**2)*(-(kap*kk) + 2*lam3*vL*vR*cmath.sqrt(2)))/(kk*vL*vR*cmath.sqrt(2))))))/cmath.sqrt(2)',
                texname = 'M_{\\text{H2}}')

MH3 = Parameter(name = 'MH3',
                nature = 'internal',
                type = 'real',
                value = 'cmath.sqrt(-MH0**2 + (vL*vR*(-(kap*vL*vR) + 2*kk**3*lam1*cmath.sqrt(2)) + kk*(vL**2 + vR**2)*(-(kap*kk) + 2*lam3*vL*vR*cmath.sqrt(2)))/(kk*vL*vR*cmath.sqrt(2)) + cmath.sqrt((-MH0**2 + (vL*vR*(-(kap*vL*vR) + 2*kk**3*lam1*cmath.sqrt(2)) + kk*(vL**2 + vR**2)*(-(kap*kk) + 2*lam3*vL*vR*cmath.sqrt(2)))/(kk*vL*vR*cmath.sqrt(2)))**2 + 4*((kap*kk**2*(4*(alp1 + alp2)*vL**2*vR**2 + lam3*(vL**2 - vR**2)**2)*cmath.sqrt(2) + (vL**2 + vR**2)*(4*kk**3*(alp1**2 + 2*alp1*alp2 + alp2**2 - lam1*lam3)*vL*vR + kap*(kk**4*lam1 + lam3*vL**2*vR**2)*cmath.sqrt(2)))/(kk*vL*vR) + MH0**2*(-MH0**2 + (vL*vR*(-(kap*vL*vR) + 2*kk**3*lam1*cmath.sqrt(2)) + kk*(vL**2 + vR**2)*(-(kap*kk) + 2*lam3*vL*vR*cmath.sqrt(2)))/(kk*vL*vR*cmath.sqrt(2))))))/cmath.sqrt(2)',
                texname = 'M_{\\text{H3}}')

MU12 = Parameter(name = 'MU12',
                 nature = 'internal',
                 type = 'real',
                 value = 'kk**2*lam1 + (alp1 + alp2)*(vL**2 + vR**2) + (kap*vL*vR)/(kk*cmath.sqrt(2))',
                 texname = '\\text{Subsuperscript}[\\mu ,1,2]')

zeta = Parameter(name = 'zeta',
                 nature = 'internal',
                 type = 'real',
                 value = 'cmath.atan(tz)',
                 texname = '\\zeta')

gY = Parameter(name = 'gY',
               nature = 'internal',
               type = 'real',
               value = 'ee/cw',
               texname = 'g_Y')

sph = Parameter(name = 'sph',
                nature = 'internal',
                type = 'real',
                value = 'gY/gR',
                texname = 's_p')

TH1x3 = Parameter(name = 'TH1x3',
                  nature = 'internal',
                  type = 'complex',
                  value = '(((2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - ((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))))/cmath.sqrt((1 + (2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2) + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2))*(((2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2) + ((vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))))**2 - (2*(2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + ((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))',
                  texname = '\\text{TH1x3}')

TH1x4 = Parameter(name = 'TH1x4',
                  nature = 'internal',
                  type = 'complex',
                  value = '((-((vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))) + (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))))*((vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*((2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (2*MH3**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH3**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*(-((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))) + (2*MH3**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH3**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(abs((vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*((2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (2*MH3**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH3**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*(-((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))) + (2*MH3**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH3**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))))*cmath.sqrt(((2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2) + ((vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))))**2 - (2*(2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + ((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))',
                  texname = '\\text{TH1x4}')

TH3x3 = Parameter(name = 'TH3x3',
                  nature = 'internal',
                  type = 'complex',
                  value = '((vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*(1 + (2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*(1 + ((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))))/cmath.sqrt((1 + (2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2) + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2))*(((2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2) + ((vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))))**2 - (2*(2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + ((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))',
                  texname = '\\text{TH3x3}')

TH3x4 = Parameter(name = 'TH3x4',
                  nature = 'internal',
                  type = 'complex',
                  value = '(((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))))*((vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*((2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (2*MH3**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH3**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*(-((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))) + (2*MH3**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH3**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(abs((vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*((2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (2*MH3**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH3**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*(-((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))) + (2*MH3**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH3**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))))*cmath.sqrt(((2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2) + ((vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))))**2 - (2*(2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + ((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))',
                  texname = '\\text{TH3x4}')

TH4x3 = Parameter(name = 'TH4x3',
                  nature = 'internal',
                  type = 'complex',
                  value = '((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2) - ((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2) - (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))))/cmath.sqrt((1 + (2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2) + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2))*(((2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2) + ((vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))))**2 - (2*(2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + ((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))',
                  texname = '\\text{TH4x3}')

TH4x4 = Parameter(name = 'TH4x4',
                  nature = 'internal',
                  type = 'complex',
                  value = '(((vL*(2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (vL*(2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))))*((vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*((2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (2*MH3**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH3**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*(-((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))) + (2*MH3**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH3**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(abs((vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*((2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (2*MH3**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH3**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*(-((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))) + (2*MH3**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH3**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH3**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))))*cmath.sqrt(((2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2) + ((vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) - (vL*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))))**2 - (2*(2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(2*MH2**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH2**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2))))))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))) + ((2*MH0**4*vL*vR - 2*kap*kk*lam3*(vL**2 - vR**2)**2*cmath.sqrt(2) + MH0**2*(vL**2 + vR**2)*(-4*lam3*vL*vR + kap*kk*cmath.sqrt(2)))**2*(1 + (vL**2*(2*kap*(vL**2 - vR**2)*((alp1 + alp2)*kk**2 + lam3*vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vR**2*cmath.sqrt(2)))**2)/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH2**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))/(vR**2*(2*kap*((alp1 + alp2)*kk**2 + lam3*vL**2)*(-vL**2 + vR**2)*cmath.sqrt(2) + MH0**2*(4*(alp1 + alp2)*kk*vL*vR + kap*vL**2*cmath.sqrt(2)))**2)))',
                  texname = '\\text{TH4x4}')

gBL = Parameter(name = 'gBL',
                nature = 'internal',
                type = 'real',
                value = '(gR*gY)/cmath.sqrt(gR**2 - gY**2)',
                texname = 'g_{B-L}')

cph = Parameter(name = 'cph',
                nature = 'internal',
                type = 'real',
                value = 'cmath.sqrt(1 - sph**2)',
                texname = 'c_p')

MZp = Parameter(name = 'MZp',
                nature = 'internal',
                type = 'real',
                value = 'cmath.sqrt(gBL**2*sph**2*vL**2 + (gR**2*(cph**4*kk**2 + vR**2))/cph**2)/2.',
                texname = 'M_{Z\'}')

t2t = Parameter(name = 't2t',
                nature = 'internal',
                type = 'real',
                value = '(2*cph*cw*gL*gR*(cph**2*kk**2 - sph**2*vL**2))/(-(cph**2*(gL**2 - cph**2*cw**2*gR**2)*kk**2) - cph**2*gL**2*(gL**2 - cw**2*gBL**2*sph**2) + cw**2*gR**2*vR**2)',
                texname = 't_{2 \\theta }')

st = Parameter(name = 'st',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sin(cmath.atan(t2t)/2.)',
               texname = 's_t')

ct = Parameter(name = 'ct',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(1 - st**2)',
               texname = 'c_t')

I1a11 = Parameter(name = 'I1a11',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM1x1*yd1x1',
                  texname = '\\text{I1a11}')

I1a12 = Parameter(name = 'I1a12',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM1x2*yd2x2',
                  texname = '\\text{I1a12}')

I1a13 = Parameter(name = 'I1a13',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM1x3*yd3x3',
                  texname = '\\text{I1a13}')

I1a21 = Parameter(name = 'I1a21',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM2x1*yd1x1',
                  texname = '\\text{I1a21}')

I1a22 = Parameter(name = 'I1a22',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM2x2*yd2x2',
                  texname = '\\text{I1a22}')

I1a23 = Parameter(name = 'I1a23',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM2x3*yd3x3',
                  texname = '\\text{I1a23}')

I1a31 = Parameter(name = 'I1a31',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM3x1*yd1x1',
                  texname = '\\text{I1a31}')

I1a32 = Parameter(name = 'I1a32',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM3x2*yd2x2',
                  texname = '\\text{I1a32}')

I1a33 = Parameter(name = 'I1a33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM3x3*yd3x3',
                  texname = '\\text{I1a33}')

I10a11 = Parameter(name = 'I10a11',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS1x1*ye1x1',
                   texname = '\\text{I10a11}')

I10a12 = Parameter(name = 'I10a12',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS1x2*ye1x1',
                   texname = '\\text{I10a12}')

I10a13 = Parameter(name = 'I10a13',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS1x3*ye1x1',
                   texname = '\\text{I10a13}')

I10a21 = Parameter(name = 'I10a21',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS2x1*ye2x2',
                   texname = '\\text{I10a21}')

I10a22 = Parameter(name = 'I10a22',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS2x2*ye2x2',
                   texname = '\\text{I10a22}')

I10a23 = Parameter(name = 'I10a23',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS2x3*ye2x2',
                   texname = '\\text{I10a23}')

I10a31 = Parameter(name = 'I10a31',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS3x1*ye3x3',
                   texname = '\\text{I10a31}')

I10a32 = Parameter(name = 'I10a32',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS3x2*ye3x3',
                   texname = '\\text{I10a32}')

I10a33 = Parameter(name = 'I10a33',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS3x3*ye3x3',
                   texname = '\\text{I10a33}')

I11a11 = Parameter(name = 'I11a11',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS1x1*ynu1x1',
                   texname = '\\text{I11a11}')

I11a12 = Parameter(name = 'I11a12',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS1x2*ynu2x2',
                   texname = '\\text{I11a12}')

I11a13 = Parameter(name = 'I11a13',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS1x3*ynu3x3',
                   texname = '\\text{I11a13}')

I11a21 = Parameter(name = 'I11a21',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS2x1*ynu1x1',
                   texname = '\\text{I11a21}')

I11a22 = Parameter(name = 'I11a22',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS2x2*ynu2x2',
                   texname = '\\text{I11a22}')

I11a23 = Parameter(name = 'I11a23',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS2x3*ynu3x3',
                   texname = '\\text{I11a23}')

I11a31 = Parameter(name = 'I11a31',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS3x1*ynu1x1',
                   texname = '\\text{I11a31}')

I11a32 = Parameter(name = 'I11a32',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS3x2*ynu2x2',
                   texname = '\\text{I11a32}')

I11a33 = Parameter(name = 'I11a33',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS3x3*ynu3x3',
                   texname = '\\text{I11a33}')

I12a11 = Parameter(name = 'I12a11',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yd1x1*complexconjugate(CKM1x1)',
                   texname = '\\text{I12a11}')

I12a12 = Parameter(name = 'I12a12',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yd1x1*complexconjugate(CKM2x1)',
                   texname = '\\text{I12a12}')

I12a13 = Parameter(name = 'I12a13',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yd1x1*complexconjugate(CKM3x1)',
                   texname = '\\text{I12a13}')

I12a21 = Parameter(name = 'I12a21',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yd2x2*complexconjugate(CKM1x2)',
                   texname = '\\text{I12a21}')

I12a22 = Parameter(name = 'I12a22',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yd2x2*complexconjugate(CKM2x2)',
                   texname = '\\text{I12a22}')

I12a23 = Parameter(name = 'I12a23',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yd2x2*complexconjugate(CKM3x2)',
                   texname = '\\text{I12a23}')

I12a31 = Parameter(name = 'I12a31',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yd3x3*complexconjugate(CKM1x3)',
                   texname = '\\text{I12a31}')

I12a32 = Parameter(name = 'I12a32',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yd3x3*complexconjugate(CKM2x3)',
                   texname = '\\text{I12a32}')

I12a33 = Parameter(name = 'I12a33',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yd3x3*complexconjugate(CKM3x3)',
                   texname = '\\text{I12a33}')

I13a11 = Parameter(name = 'I13a11',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu1x1*complexconjugate(CKM1x1)',
                   texname = '\\text{I13a11}')

I13a12 = Parameter(name = 'I13a12',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu2x2*complexconjugate(CKM2x1)',
                   texname = '\\text{I13a12}')

I13a13 = Parameter(name = 'I13a13',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu3x3*complexconjugate(CKM3x1)',
                   texname = '\\text{I13a13}')

I13a21 = Parameter(name = 'I13a21',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu1x1*complexconjugate(CKM1x2)',
                   texname = '\\text{I13a21}')

I13a22 = Parameter(name = 'I13a22',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu2x2*complexconjugate(CKM2x2)',
                   texname = '\\text{I13a22}')

I13a23 = Parameter(name = 'I13a23',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu3x3*complexconjugate(CKM3x2)',
                   texname = '\\text{I13a23}')

I13a31 = Parameter(name = 'I13a31',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu1x1*complexconjugate(CKM1x3)',
                   texname = '\\text{I13a31}')

I13a32 = Parameter(name = 'I13a32',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu2x2*complexconjugate(CKM2x3)',
                   texname = '\\text{I13a32}')

I13a33 = Parameter(name = 'I13a33',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu3x3*complexconjugate(CKM3x3)',
                   texname = '\\text{I13a33}')

I14a11 = Parameter(name = 'I14a11',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKMp1x1*yu1x1*complexconjugate(CKM1x1) + CKMp2x1*yu2x2*complexconjugate(CKM2x1) + CKMp3x1*yu3x3*complexconjugate(CKM3x1)',
                   texname = '\\text{I14a11}')

I14a12 = Parameter(name = 'I14a12',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKMp1x2*yu1x1*complexconjugate(CKM1x1) + CKMp2x2*yu2x2*complexconjugate(CKM2x1) + CKMp3x2*yu3x3*complexconjugate(CKM3x1)',
                   texname = '\\text{I14a12}')

I14a13 = Parameter(name = 'I14a13',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKMp1x3*yu1x1*complexconjugate(CKM1x1) + CKMp2x3*yu2x2*complexconjugate(CKM2x1) + CKMp3x3*yu3x3*complexconjugate(CKM3x1)',
                   texname = '\\text{I14a13}')

I14a21 = Parameter(name = 'I14a21',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKMp1x1*yu1x1*complexconjugate(CKM1x2) + CKMp2x1*yu2x2*complexconjugate(CKM2x2) + CKMp3x1*yu3x3*complexconjugate(CKM3x2)',
                   texname = '\\text{I14a21}')

I14a22 = Parameter(name = 'I14a22',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKMp1x2*yu1x1*complexconjugate(CKM1x2) + CKMp2x2*yu2x2*complexconjugate(CKM2x2) + CKMp3x2*yu3x3*complexconjugate(CKM3x2)',
                   texname = '\\text{I14a22}')

I14a23 = Parameter(name = 'I14a23',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKMp1x3*yu1x1*complexconjugate(CKM1x2) + CKMp2x3*yu2x2*complexconjugate(CKM2x2) + CKMp3x3*yu3x3*complexconjugate(CKM3x2)',
                   texname = '\\text{I14a23}')

I14a31 = Parameter(name = 'I14a31',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKMp1x1*yu1x1*complexconjugate(CKM1x3) + CKMp2x1*yu2x2*complexconjugate(CKM2x3) + CKMp3x1*yu3x3*complexconjugate(CKM3x3)',
                   texname = '\\text{I14a31}')

I14a32 = Parameter(name = 'I14a32',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKMp1x2*yu1x1*complexconjugate(CKM1x3) + CKMp2x2*yu2x2*complexconjugate(CKM2x3) + CKMp3x2*yu3x3*complexconjugate(CKM3x3)',
                   texname = '\\text{I14a32}')

I14a33 = Parameter(name = 'I14a33',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKMp1x3*yu1x1*complexconjugate(CKM1x3) + CKMp2x3*yu2x2*complexconjugate(CKM2x3) + CKMp3x3*yu3x3*complexconjugate(CKM3x3)',
                   texname = '\\text{I14a33}')

I15a11 = Parameter(name = 'I15a11',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ydp1x1*complexconjugate(CKMp1x1)',
                   texname = '\\text{I15a11}')

I15a12 = Parameter(name = 'I15a12',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ydp1x1*complexconjugate(CKMp2x1)',
                   texname = '\\text{I15a12}')

I15a13 = Parameter(name = 'I15a13',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ydp1x1*complexconjugate(CKMp3x1)',
                   texname = '\\text{I15a13}')

I15a21 = Parameter(name = 'I15a21',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ydp2x2*complexconjugate(CKMp1x2)',
                   texname = '\\text{I15a21}')

I15a22 = Parameter(name = 'I15a22',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ydp2x2*complexconjugate(CKMp2x2)',
                   texname = '\\text{I15a22}')

I15a23 = Parameter(name = 'I15a23',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ydp2x2*complexconjugate(CKMp3x2)',
                   texname = '\\text{I15a23}')

I15a31 = Parameter(name = 'I15a31',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ydp3x3*complexconjugate(CKMp1x3)',
                   texname = '\\text{I15a31}')

I15a32 = Parameter(name = 'I15a32',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ydp3x3*complexconjugate(CKMp2x3)',
                   texname = '\\text{I15a32}')

I15a33 = Parameter(name = 'I15a33',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ydp3x3*complexconjugate(CKMp3x3)',
                   texname = '\\text{I15a33}')

I16a11 = Parameter(name = 'I16a11',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu1x1*complexconjugate(CKMp1x1)',
                   texname = '\\text{I16a11}')

I16a12 = Parameter(name = 'I16a12',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu2x2*complexconjugate(CKMp2x1)',
                   texname = '\\text{I16a12}')

I16a13 = Parameter(name = 'I16a13',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu3x3*complexconjugate(CKMp3x1)',
                   texname = '\\text{I16a13}')

I16a21 = Parameter(name = 'I16a21',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu1x1*complexconjugate(CKMp1x2)',
                   texname = '\\text{I16a21}')

I16a22 = Parameter(name = 'I16a22',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu2x2*complexconjugate(CKMp2x2)',
                   texname = '\\text{I16a22}')

I16a23 = Parameter(name = 'I16a23',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu3x3*complexconjugate(CKMp3x2)',
                   texname = '\\text{I16a23}')

I16a31 = Parameter(name = 'I16a31',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu1x1*complexconjugate(CKMp1x3)',
                   texname = '\\text{I16a31}')

I16a32 = Parameter(name = 'I16a32',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu2x2*complexconjugate(CKMp2x3)',
                   texname = '\\text{I16a32}')

I16a33 = Parameter(name = 'I16a33',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yu3x3*complexconjugate(CKMp3x3)',
                   texname = '\\text{I16a33}')

I17a11 = Parameter(name = 'I17a11',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS1x1*ye1x1*complexconjugate(PMNSp1x1) + PMNS2x1*ye2x2*complexconjugate(PMNSp2x1) + PMNS3x1*ye3x3*complexconjugate(PMNSp3x1)',
                   texname = '\\text{I17a11}')

I17a12 = Parameter(name = 'I17a12',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS1x2*ye1x1*complexconjugate(PMNSp1x1) + PMNS2x2*ye2x2*complexconjugate(PMNSp2x1) + PMNS3x2*ye3x3*complexconjugate(PMNSp3x1)',
                   texname = '\\text{I17a12}')

I17a13 = Parameter(name = 'I17a13',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS1x3*ye1x1*complexconjugate(PMNSp1x1) + PMNS2x3*ye2x2*complexconjugate(PMNSp2x1) + PMNS3x3*ye3x3*complexconjugate(PMNSp3x1)',
                   texname = '\\text{I17a13}')

I17a21 = Parameter(name = 'I17a21',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS1x1*ye1x1*complexconjugate(PMNSp1x2) + PMNS2x1*ye2x2*complexconjugate(PMNSp2x2) + PMNS3x1*ye3x3*complexconjugate(PMNSp3x2)',
                   texname = '\\text{I17a21}')

I17a22 = Parameter(name = 'I17a22',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS1x2*ye1x1*complexconjugate(PMNSp1x2) + PMNS2x2*ye2x2*complexconjugate(PMNSp2x2) + PMNS3x2*ye3x3*complexconjugate(PMNSp3x2)',
                   texname = '\\text{I17a22}')

I17a23 = Parameter(name = 'I17a23',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS1x3*ye1x1*complexconjugate(PMNSp1x2) + PMNS2x3*ye2x2*complexconjugate(PMNSp2x2) + PMNS3x3*ye3x3*complexconjugate(PMNSp3x2)',
                   texname = '\\text{I17a23}')

I17a31 = Parameter(name = 'I17a31',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS1x1*ye1x1*complexconjugate(PMNSp1x3) + PMNS2x1*ye2x2*complexconjugate(PMNSp2x3) + PMNS3x1*ye3x3*complexconjugate(PMNSp3x3)',
                   texname = '\\text{I17a31}')

I17a32 = Parameter(name = 'I17a32',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS1x2*ye1x1*complexconjugate(PMNSp1x3) + PMNS2x2*ye2x2*complexconjugate(PMNSp2x3) + PMNS3x2*ye3x3*complexconjugate(PMNSp3x3)',
                   texname = '\\text{I17a32}')

I17a33 = Parameter(name = 'I17a33',
                   nature = 'internal',
                   type = 'complex',
                   value = 'PMNS1x3*ye1x1*complexconjugate(PMNSp1x3) + PMNS2x3*ye2x2*complexconjugate(PMNSp2x3) + PMNS3x3*ye3x3*complexconjugate(PMNSp3x3)',
                   texname = '\\text{I17a33}')

I18a11 = Parameter(name = 'I18a11',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ye1x1*complexconjugate(PMNSp1x1)',
                   texname = '\\text{I18a11}')

I18a12 = Parameter(name = 'I18a12',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ye2x2*complexconjugate(PMNSp2x1)',
                   texname = '\\text{I18a12}')

I18a13 = Parameter(name = 'I18a13',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ye3x3*complexconjugate(PMNSp3x1)',
                   texname = '\\text{I18a13}')

I18a21 = Parameter(name = 'I18a21',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ye1x1*complexconjugate(PMNSp1x2)',
                   texname = '\\text{I18a21}')

I18a22 = Parameter(name = 'I18a22',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ye2x2*complexconjugate(PMNSp2x2)',
                   texname = '\\text{I18a22}')

I18a23 = Parameter(name = 'I18a23',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ye3x3*complexconjugate(PMNSp3x2)',
                   texname = '\\text{I18a23}')

I18a31 = Parameter(name = 'I18a31',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ye1x1*complexconjugate(PMNSp1x3)',
                   texname = '\\text{I18a31}')

I18a32 = Parameter(name = 'I18a32',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ye2x2*complexconjugate(PMNSp2x3)',
                   texname = '\\text{I18a32}')

I18a33 = Parameter(name = 'I18a33',
                   nature = 'internal',
                   type = 'complex',
                   value = 'ye3x3*complexconjugate(PMNSp3x3)',
                   texname = '\\text{I18a33}')

I19a11 = Parameter(name = 'I19a11',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yn1x1*complexconjugate(PMNSp1x1)',
                   texname = '\\text{I19a11}')

I19a12 = Parameter(name = 'I19a12',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yn1x1*complexconjugate(PMNSp2x1)',
                   texname = '\\text{I19a12}')

I19a13 = Parameter(name = 'I19a13',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yn1x1*complexconjugate(PMNSp3x1)',
                   texname = '\\text{I19a13}')

I19a21 = Parameter(name = 'I19a21',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yn2x2*complexconjugate(PMNSp1x2)',
                   texname = '\\text{I19a21}')

I19a22 = Parameter(name = 'I19a22',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yn2x2*complexconjugate(PMNSp2x2)',
                   texname = '\\text{I19a22}')

I19a23 = Parameter(name = 'I19a23',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yn2x2*complexconjugate(PMNSp3x2)',
                   texname = '\\text{I19a23}')

I19a31 = Parameter(name = 'I19a31',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yn3x3*complexconjugate(PMNSp1x3)',
                   texname = '\\text{I19a31}')

I19a32 = Parameter(name = 'I19a32',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yn3x3*complexconjugate(PMNSp2x3)',
                   texname = '\\text{I19a32}')

I19a33 = Parameter(name = 'I19a33',
                   nature = 'internal',
                   type = 'complex',
                   value = 'yn3x3*complexconjugate(PMNSp3x3)',
                   texname = '\\text{I19a33}')

I2a11 = Parameter(name = 'I2a11',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM1x1*yu1x1',
                  texname = '\\text{I2a11}')

I2a12 = Parameter(name = 'I2a12',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM1x2*yu1x1',
                  texname = '\\text{I2a12}')

I2a13 = Parameter(name = 'I2a13',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM1x3*yu1x1',
                  texname = '\\text{I2a13}')

I2a21 = Parameter(name = 'I2a21',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM2x1*yu2x2',
                  texname = '\\text{I2a21}')

I2a22 = Parameter(name = 'I2a22',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM2x2*yu2x2',
                  texname = '\\text{I2a22}')

I2a23 = Parameter(name = 'I2a23',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM2x3*yu2x2',
                  texname = '\\text{I2a23}')

I2a31 = Parameter(name = 'I2a31',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM3x1*yu3x3',
                  texname = '\\text{I2a31}')

I2a32 = Parameter(name = 'I2a32',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM3x2*yu3x3',
                  texname = '\\text{I2a32}')

I2a33 = Parameter(name = 'I2a33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKM3x3*yu3x3',
                  texname = '\\text{I2a33}')

I20a11 = Parameter(name = 'I20a11',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKM1x1*yu1x1*complexconjugate(CKMp1x1) + CKM2x1*yu2x2*complexconjugate(CKMp2x1) + CKM3x1*yu3x3*complexconjugate(CKMp3x1)',
                   texname = '\\text{I20a11}')

I20a12 = Parameter(name = 'I20a12',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKM1x2*yu1x1*complexconjugate(CKMp1x1) + CKM2x2*yu2x2*complexconjugate(CKMp2x1) + CKM3x2*yu3x3*complexconjugate(CKMp3x1)',
                   texname = '\\text{I20a12}')

I20a13 = Parameter(name = 'I20a13',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKM1x3*yu1x1*complexconjugate(CKMp1x1) + CKM2x3*yu2x2*complexconjugate(CKMp2x1) + CKM3x3*yu3x3*complexconjugate(CKMp3x1)',
                   texname = '\\text{I20a13}')

I20a21 = Parameter(name = 'I20a21',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKM1x1*yu1x1*complexconjugate(CKMp1x2) + CKM2x1*yu2x2*complexconjugate(CKMp2x2) + CKM3x1*yu3x3*complexconjugate(CKMp3x2)',
                   texname = '\\text{I20a21}')

I20a22 = Parameter(name = 'I20a22',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKM1x2*yu1x1*complexconjugate(CKMp1x2) + CKM2x2*yu2x2*complexconjugate(CKMp2x2) + CKM3x2*yu3x3*complexconjugate(CKMp3x2)',
                   texname = '\\text{I20a22}')

I20a23 = Parameter(name = 'I20a23',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKM1x3*yu1x1*complexconjugate(CKMp1x2) + CKM2x3*yu2x2*complexconjugate(CKMp2x2) + CKM3x3*yu3x3*complexconjugate(CKMp3x2)',
                   texname = '\\text{I20a23}')

I20a31 = Parameter(name = 'I20a31',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKM1x1*yu1x1*complexconjugate(CKMp1x3) + CKM2x1*yu2x2*complexconjugate(CKMp2x3) + CKM3x1*yu3x3*complexconjugate(CKMp3x3)',
                   texname = '\\text{I20a31}')

I20a32 = Parameter(name = 'I20a32',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKM1x2*yu1x1*complexconjugate(CKMp1x3) + CKM2x2*yu2x2*complexconjugate(CKMp2x3) + CKM3x2*yu3x3*complexconjugate(CKMp3x3)',
                   texname = '\\text{I20a32}')

I20a33 = Parameter(name = 'I20a33',
                   nature = 'internal',
                   type = 'complex',
                   value = 'CKM1x3*yu1x1*complexconjugate(CKMp1x3) + CKM2x3*yu2x2*complexconjugate(CKMp2x3) + CKM3x3*yu3x3*complexconjugate(CKMp3x3)',
                   texname = '\\text{I20a33}')

I3a11 = Parameter(name = 'I3a11',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp1x1*ydp1x1',
                  texname = '\\text{I3a11}')

I3a12 = Parameter(name = 'I3a12',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp1x2*ydp2x2',
                  texname = '\\text{I3a12}')

I3a13 = Parameter(name = 'I3a13',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp1x3*ydp3x3',
                  texname = '\\text{I3a13}')

I3a21 = Parameter(name = 'I3a21',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp2x1*ydp1x1',
                  texname = '\\text{I3a21}')

I3a22 = Parameter(name = 'I3a22',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp2x2*ydp2x2',
                  texname = '\\text{I3a22}')

I3a23 = Parameter(name = 'I3a23',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp2x3*ydp3x3',
                  texname = '\\text{I3a23}')

I3a31 = Parameter(name = 'I3a31',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp3x1*ydp1x1',
                  texname = '\\text{I3a31}')

I3a32 = Parameter(name = 'I3a32',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp3x2*ydp2x2',
                  texname = '\\text{I3a32}')

I3a33 = Parameter(name = 'I3a33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp3x3*ydp3x3',
                  texname = '\\text{I3a33}')

I4a11 = Parameter(name = 'I4a11',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp1x1*yu1x1',
                  texname = '\\text{I4a11}')

I4a12 = Parameter(name = 'I4a12',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp1x2*yu1x1',
                  texname = '\\text{I4a12}')

I4a13 = Parameter(name = 'I4a13',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp1x3*yu1x1',
                  texname = '\\text{I4a13}')

I4a21 = Parameter(name = 'I4a21',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp2x1*yu2x2',
                  texname = '\\text{I4a21}')

I4a22 = Parameter(name = 'I4a22',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp2x2*yu2x2',
                  texname = '\\text{I4a22}')

I4a23 = Parameter(name = 'I4a23',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp2x3*yu2x2',
                  texname = '\\text{I4a23}')

I4a31 = Parameter(name = 'I4a31',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp3x1*yu3x3',
                  texname = '\\text{I4a31}')

I4a32 = Parameter(name = 'I4a32',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp3x2*yu3x3',
                  texname = '\\text{I4a32}')

I4a33 = Parameter(name = 'I4a33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'CKMp3x3*yu3x3',
                  texname = '\\text{I4a33}')

I5a11 = Parameter(name = 'I5a11',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp1x1*ye1x1*complexconjugate(PMNS1x1) + PMNSp2x1*ye2x2*complexconjugate(PMNS2x1) + PMNSp3x1*ye3x3*complexconjugate(PMNS3x1)',
                  texname = '\\text{I5a11}')

I5a12 = Parameter(name = 'I5a12',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp1x2*ye1x1*complexconjugate(PMNS1x1) + PMNSp2x2*ye2x2*complexconjugate(PMNS2x1) + PMNSp3x2*ye3x3*complexconjugate(PMNS3x1)',
                  texname = '\\text{I5a12}')

I5a13 = Parameter(name = 'I5a13',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp1x3*ye1x1*complexconjugate(PMNS1x1) + PMNSp2x3*ye2x2*complexconjugate(PMNS2x1) + PMNSp3x3*ye3x3*complexconjugate(PMNS3x1)',
                  texname = '\\text{I5a13}')

I5a21 = Parameter(name = 'I5a21',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp1x1*ye1x1*complexconjugate(PMNS1x2) + PMNSp2x1*ye2x2*complexconjugate(PMNS2x2) + PMNSp3x1*ye3x3*complexconjugate(PMNS3x2)',
                  texname = '\\text{I5a21}')

I5a22 = Parameter(name = 'I5a22',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp1x2*ye1x1*complexconjugate(PMNS1x2) + PMNSp2x2*ye2x2*complexconjugate(PMNS2x2) + PMNSp3x2*ye3x3*complexconjugate(PMNS3x2)',
                  texname = '\\text{I5a22}')

I5a23 = Parameter(name = 'I5a23',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp1x3*ye1x1*complexconjugate(PMNS1x2) + PMNSp2x3*ye2x2*complexconjugate(PMNS2x2) + PMNSp3x3*ye3x3*complexconjugate(PMNS3x2)',
                  texname = '\\text{I5a23}')

I5a31 = Parameter(name = 'I5a31',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp1x1*ye1x1*complexconjugate(PMNS1x3) + PMNSp2x1*ye2x2*complexconjugate(PMNS2x3) + PMNSp3x1*ye3x3*complexconjugate(PMNS3x3)',
                  texname = '\\text{I5a31}')

I5a32 = Parameter(name = 'I5a32',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp1x2*ye1x1*complexconjugate(PMNS1x3) + PMNSp2x2*ye2x2*complexconjugate(PMNS2x3) + PMNSp3x2*ye3x3*complexconjugate(PMNS3x3)',
                  texname = '\\text{I5a32}')

I5a33 = Parameter(name = 'I5a33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp1x3*ye1x1*complexconjugate(PMNS1x3) + PMNSp2x3*ye2x2*complexconjugate(PMNS2x3) + PMNSp3x3*ye3x3*complexconjugate(PMNS3x3)',
                  texname = '\\text{I5a33}')

I6a11 = Parameter(name = 'I6a11',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ye1x1*complexconjugate(PMNS1x1)',
                  texname = '\\text{I6a11}')

I6a12 = Parameter(name = 'I6a12',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ye2x2*complexconjugate(PMNS2x1)',
                  texname = '\\text{I6a12}')

I6a13 = Parameter(name = 'I6a13',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ye3x3*complexconjugate(PMNS3x1)',
                  texname = '\\text{I6a13}')

I6a21 = Parameter(name = 'I6a21',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ye1x1*complexconjugate(PMNS1x2)',
                  texname = '\\text{I6a21}')

I6a22 = Parameter(name = 'I6a22',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ye2x2*complexconjugate(PMNS2x2)',
                  texname = '\\text{I6a22}')

I6a23 = Parameter(name = 'I6a23',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ye3x3*complexconjugate(PMNS3x2)',
                  texname = '\\text{I6a23}')

I6a31 = Parameter(name = 'I6a31',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ye1x1*complexconjugate(PMNS1x3)',
                  texname = '\\text{I6a31}')

I6a32 = Parameter(name = 'I6a32',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ye2x2*complexconjugate(PMNS2x3)',
                  texname = '\\text{I6a32}')

I6a33 = Parameter(name = 'I6a33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ye3x3*complexconjugate(PMNS3x3)',
                  texname = '\\text{I6a33}')

I7a11 = Parameter(name = 'I7a11',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ynu1x1*complexconjugate(PMNS1x1)',
                  texname = '\\text{I7a11}')

I7a12 = Parameter(name = 'I7a12',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ynu1x1*complexconjugate(PMNS2x1)',
                  texname = '\\text{I7a12}')

I7a13 = Parameter(name = 'I7a13',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ynu1x1*complexconjugate(PMNS3x1)',
                  texname = '\\text{I7a13}')

I7a21 = Parameter(name = 'I7a21',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ynu2x2*complexconjugate(PMNS1x2)',
                  texname = '\\text{I7a21}')

I7a22 = Parameter(name = 'I7a22',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ynu2x2*complexconjugate(PMNS2x2)',
                  texname = '\\text{I7a22}')

I7a23 = Parameter(name = 'I7a23',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ynu2x2*complexconjugate(PMNS3x2)',
                  texname = '\\text{I7a23}')

I7a31 = Parameter(name = 'I7a31',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ynu3x3*complexconjugate(PMNS1x3)',
                  texname = '\\text{I7a31}')

I7a32 = Parameter(name = 'I7a32',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ynu3x3*complexconjugate(PMNS2x3)',
                  texname = '\\text{I7a32}')

I7a33 = Parameter(name = 'I7a33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'ynu3x3*complexconjugate(PMNS3x3)',
                  texname = '\\text{I7a33}')

I8a11 = Parameter(name = 'I8a11',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp1x1*ye1x1',
                  texname = '\\text{I8a11}')

I8a12 = Parameter(name = 'I8a12',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp1x2*ye1x1',
                  texname = '\\text{I8a12}')

I8a13 = Parameter(name = 'I8a13',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp1x3*ye1x1',
                  texname = '\\text{I8a13}')

I8a21 = Parameter(name = 'I8a21',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp2x1*ye2x2',
                  texname = '\\text{I8a21}')

I8a22 = Parameter(name = 'I8a22',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp2x2*ye2x2',
                  texname = '\\text{I8a22}')

I8a23 = Parameter(name = 'I8a23',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp2x3*ye2x2',
                  texname = '\\text{I8a23}')

I8a31 = Parameter(name = 'I8a31',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp3x1*ye3x3',
                  texname = '\\text{I8a31}')

I8a32 = Parameter(name = 'I8a32',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp3x2*ye3x3',
                  texname = '\\text{I8a32}')

I8a33 = Parameter(name = 'I8a33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp3x3*ye3x3',
                  texname = '\\text{I8a33}')

I9a11 = Parameter(name = 'I9a11',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp1x1*yn1x1',
                  texname = '\\text{I9a11}')

I9a12 = Parameter(name = 'I9a12',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp1x2*yn2x2',
                  texname = '\\text{I9a12}')

I9a13 = Parameter(name = 'I9a13',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp1x3*yn3x3',
                  texname = '\\text{I9a13}')

I9a21 = Parameter(name = 'I9a21',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp2x1*yn1x1',
                  texname = '\\text{I9a21}')

I9a22 = Parameter(name = 'I9a22',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp2x2*yn2x2',
                  texname = '\\text{I9a22}')

I9a23 = Parameter(name = 'I9a23',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp2x3*yn3x3',
                  texname = '\\text{I9a23}')

I9a31 = Parameter(name = 'I9a31',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp3x1*yn1x1',
                  texname = '\\text{I9a31}')

I9a32 = Parameter(name = 'I9a32',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp3x2*yn2x2',
                  texname = '\\text{I9a32}')

I9a33 = Parameter(name = 'I9a33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'PMNSp3x3*yn3x3',
                  texname = '\\text{I9a33}')

