(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

(* ALP suppression scale. Default: 1 TeV *)

  fa == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    ComplexParameter -> False,
    Value	     -> 1000,
    TeX		     -> Subscript[f,a],
    Description	     -> "ALP scale"
  },

(* Wilson coefficients and parameters in F_i(h) *)

  CGtil == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,OverTilde[G]]
  },
  CWtil == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,OverTilde[W]]
  },
  CBtil == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,OverTilde[B]]
  },
  C1 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,1]
  },
  a1 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,1]
  },
  b1 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[b,1]
  },
  C2 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,2]
  },
  a2 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,2]
  },
  b2 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[b,2]
  },
  C3 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,3]
  },
  a3 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,3]
  },
  b3 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[b,3]
  },
  C4 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,4]
  },
  C5 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,5]
  },
  C6 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,6]
  },
  a6 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,6]
  },
  b6 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[b,6]
  },
  C7 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,7]
  },
  a7 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,7]
  },
  b7 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[b,7]
  },
  C8 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,8]
  },
  a8 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,8]
  },
  b8 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[b,8]
  },
  C9 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,9]
  },
  C10 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,10]
  },
  a10 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,10]
  },
  b10 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[b,10]
  },
  C2D == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,2D]
  },
  a2D == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,2D]
  },
  b2D == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[b,2D]
  },
  C11 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,11]
  },  
  a11 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,11]
  },
  b11 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[b,11]
  },
  C12 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,12]
  },
  a12 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,12]
  },
  b12 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[b,12]
  },
  C13 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,13]
  },
  a13 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,13]
  },
  b13 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[b,13]
  },
  C14 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,14]
  },
  a14 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,14]
  },
  b14 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[b,14]
  },
  C15 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,15]
  },
  a15 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,15]
  },
  a15prime == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subsuperscript[a,15,\[Prime]]
  },
  C16 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,16]
  },
  a16 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,16]
  },
  a16prime == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subsuperscript[a,16,\[Prime]]
  },
  C17 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    InteractionOrder -> {NP, 1},
    ComplexParameter -> False,
    TeX		     -> Subscript[c,17]
  },
  a17 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,17]
  },
  b17 == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[b,17]
  },
  aU == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,U]
  },
  bU == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[b,U]
  },
  aD == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,D]
  },
  bD == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[b,D]
  },
  aL == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[a,L]
  },
  bL == {
    ParameterType    -> External,
    BlockName	     -> ALPPARS,
    Value	     -> 1.,
    ComplexParameter -> False,
    TeX		     -> Subscript[b,L]
  }
}; 
