(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[    197498,       4819]
NotebookOptionsPosition[    192367,       4660]
NotebookOutlinePosition[    192810,       4677]
CellTagsIndexPosition[    192767,       4674]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Demo notebook for the ALPs EFT models", "Chapter",
 CellChangeTimes->{{3.714472665588029*^9, 3.714472689729048*^9}, {
  3.714899887219674*^9, 3.7148998914966784`*^9}}],

Cell["\<\
Effective field theories for a light ALP particle adopted in 1701.05379.

Contains two models:

ALP_linear - linear EFT (section 2)
ALP_chiral  - chiral EFT (section 3)

The models  only contain the ALP field and Lagrangian, so they must be loaded \
besides the SM.
\
\>", "Text",
 CellChangeTimes->{{3.7149005914889593`*^9, 3.714900592898365*^9}, {
  3.714900686180849*^9, 3.714900749569977*^9}, {3.7149010364554167`*^9, 
  3.714901156363299*^9}, {3.7149012109755774`*^9, 3.714901221896302*^9}}],

Cell[TextData[{
 StyleBox["Lagrangians defined ",
  FontVariations->{"Underline"->True}],
 "\n\nLSM - SM Lagrangian\nLAlp0 - Leading ALP Lagrangian. Contains ALP mass \
and kinetic term.\nLAlp1 - Higher order terms in the ALP Lagrangian. Contains \
all the effective operators\nLALP - LAlp0 + LAlp1"
}], "Text",
 CellChangeTimes->{{3.696239302643662*^9, 3.6962395961998587`*^9}, {
   3.6962426279211273`*^9, 3.6962426382382174`*^9}, {3.69624269955401*^9, 
   3.696242713138926*^9}, {3.697464963087976*^9, 3.697464974471815*^9}, {
   3.697781321319046*^9, 3.697781411435602*^9}, {3.697781761740079*^9, 
   3.697781762068541*^9}, 3.7074035932516823`*^9, {3.714027372165451*^9, 
   3.714027386105159*^9}, {3.714037377699317*^9, 3.7140373790930023`*^9}, {
   3.714472728601252*^9, 3.7144729472637987`*^9}, {3.714474312375147*^9, 
   3.7144743155330887`*^9}, {3.714474392406591*^9, 3.714474503350297*^9}, {
   3.714901264631907*^9, 3.714901383884622*^9}},
 Background->RGBColor[0.94, 0.91, 0.88]],

Cell[CellGroupData[{

Cell["FeynRules initialization", "Section",
 CellChangeTimes->{{3.696241144773179*^9, 3.696241150440773*^9}, {
  3.6965809461276217`*^9, 3.6965809488385057`*^9}, {3.7144743309076147`*^9, 
  3.71447433315618*^9}}],

Cell[BoxData[{
 RowBox[{"$FeynRulesPath", "=", 
  RowBox[{
  "SetDirectory", "[", "\"\<-----/feynrules-current/\>\"", 
   "]"}]}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"NotebookDirectory", "[", "]"}], "]"}], ";"}]}], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
   3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
   3.4234163227881193`*^9}, {3.569593920256028*^9, 3.5695939561647587`*^9}, {
   3.633429030562295*^9, 3.6334290416321917`*^9}, 3.633429072465761*^9, {
   3.635234890077219*^9, 3.6352349006796503`*^9}, {3.638618091550831*^9, 
   3.638618091841796*^9}, {3.6386187643019457`*^9, 3.638618764970313*^9}, {
   3.638620435812201*^9, 3.6386204366894207`*^9}, {3.638623211106428*^9, 
   3.638623212908428*^9}, {3.638712295761613*^9, 3.6387122976840363`*^9}, {
   3.638877760050136*^9, 3.6388777607355757`*^9}, 3.675576332946599*^9, {
   3.6761099093380632`*^9, 3.676109922535201*^9}, 3.68648945229902*^9, 
   3.694262296773966*^9, {3.71490017175248*^9, 3.7149001719624357`*^9}, {
   3.7149013954837923`*^9, 3.714901396082449*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["ALP linear EFT", "Section",
 CellChangeTimes->{{3.696241144773179*^9, 3.696241150440773*^9}, {
  3.6965809461276217`*^9, 3.6965809488385057`*^9}, {3.7144743309076147`*^9, 
  3.71447433315618*^9}, {3.7148999134555597`*^9, 3.714899915627069*^9}, {
  3.714900792676422*^9, 3.7149007933801117`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<SM.fr\>\"", ",", "\"\<alp_linear.fr\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["cw", "2"], "+", 
     SuperscriptBox["sw", "2"]}], "\[Equal]", "1"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.419073170860696*^9, 3.419073182827229*^9}, {
   3.5695939666521587`*^9, 3.569593975189637*^9}, {3.571998624557815*^9, 
   3.571998628157531*^9}, {3.5722426658955507`*^9, 3.5722426665661163`*^9}, {
   3.57373494999842*^9, 3.573734950506782*^9}, {3.573738411070033*^9, 
   3.573738411475131*^9}, {3.581766296877213*^9, 3.5817662993035793`*^9}, {
   3.582711295612512*^9, 3.582711304079101*^9}, {3.58271455619954*^9, 
   3.582714556539135*^9}, {3.5837271421921186`*^9, 3.5837271424321213`*^9}, {
   3.624620697450859*^9, 3.6246207033691893`*^9}, {3.6334178673816833`*^9, 
   3.633417870423235*^9}, {3.635168745836775*^9, 3.635168746552165*^9}, {
   3.635234921249031*^9, 3.6352349280391006`*^9}, {3.638611693959074*^9, 
   3.638611733478942*^9}, {3.638618101259109*^9, 3.638618101467348*^9}, 
   3.63861936248402*^9, 3.638619484234972*^9, {3.638620679982355*^9, 
   3.638620680842409*^9}, {3.6386861262510643`*^9, 3.638686136772785*^9}, {
   3.6415550100096617`*^9, 3.641555015231119*^9}, {3.676109930720601*^9, 
   3.6761099312888002`*^9}, {3.6761959551581984`*^9, 3.67619595753176*^9}, {
   3.676196049763735*^9, 3.6761960518031893`*^9}, {3.71489982794697*^9, 
   3.714899828966436*^9}, {3.71490004046701*^9, 3.714900043136207*^9}, {
   3.7149001684519243`*^9, 3.714900176622246*^9}, {3.714900801997252*^9, 
   3.7149008039924498`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.7149001775995293`*^9, 3.714900805104293*^9, 3.714900969187937*^9}],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.7149001775995293`*^9, 3.714900805104293*^9, 3.714900969211878*^9}],

Cell[BoxData["\<\"I. Brivio, M.B. Gavela, L. Merlo, K. Mimasu, J.M. No, R. \
del Rey, V. Sanz\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.7149001775995293`*^9, 3.714900805104293*^9, 3.714900969213647*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1\"\>"}],
  SequenceForm["Model Version: ", "1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.7149001775995293`*^9, 3.714900805104293*^9, 3.714900969214779*^9}],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.7149001775995293`*^9, 3.714900805104293*^9, 3.7149009692156963`*^9}],

Cell[BoxData["\<\"arXiv:1701.05379\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.7149001775995293`*^9, 3.714900805104293*^9, 3.714900969216604*^9}],

Cell[BoxData["\<\"https://feynrules.irmp.ucl.ac.be/wiki/ALPsEFT\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.7149001775995293`*^9, 3.714900805104293*^9, 3.714900969217536*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.7149001775995293`*^9, 3.714900805104293*^9, 3.71490096921843*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.7149001775995293`*^9, 3.714900805104293*^9, 3.714900969219322*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.7149001775995293`*^9, 3.714900805104293*^9, 3.71490096922018*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.7149001775995293`*^9, 3.714900805104293*^9, 3.714900969309099*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.7149001775995293`*^9, 3.714900805104293*^9, 3.714900969311594*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"ALP_linear\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "ALP_linear", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.7149001775995293`*^9, 3.714900805104293*^9, 3.714900969359498*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Feynman rules", "Subsection",
 CellChangeTimes->{{3.638612958456888*^9, 3.638612964903018*^9}, {
  3.641555437690887*^9, 3.6415554385930634`*^9}, {3.714900458407517*^9, 
  3.7149004631939707`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AlpFR", "=", 
   RowBox[{
    RowBox[{"FeynmanRules", "[", 
     RowBox[{"LALP", ",", 
      RowBox[{"MaxParticles", "\[Rule]", "4"}]}], "]"}], "//", "Simplify"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.638612399979039*^9, 3.638612438377034*^9}, {
  3.6386128833730392`*^9, 3.638612887379834*^9}, {3.638613614059422*^9, 
  3.638613674285076*^9}, {3.638613735408643*^9, 3.6386137469743147`*^9}, {
  3.638703969309166*^9, 3.63870398233029*^9}, {3.676198845702183*^9, 
  3.676198850854022*^9}, {3.6762862015383883`*^9, 3.676286202884295*^9}, {
  3.714900437388975*^9, 3.714900439208026*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.638612439263659*^9, 3.638612450767869*^9}, 
   3.6386128940614233`*^9, {3.638613650524602*^9, 3.63861368019837*^9}, 
   3.638613752618588*^9, 3.638622421421833*^9, 3.638623259654512*^9, 
   3.638623682719574*^9, 3.63862387089994*^9, 3.638681839413598*^9, 
   3.638685147339924*^9, 3.638686835296649*^9, 3.638702823739684*^9, 
   3.6387045306445217`*^9, 3.638707583603277*^9, 3.638708179320146*^9, 
   3.638708280154018*^9, 3.638712313990831*^9, 3.638714885676031*^9, 
   3.6387158722970467`*^9, 3.6387688476652308`*^9, 3.6398203261482677`*^9, 
   3.641555449377819*^9, 3.641555863256626*^9, 3.641556195644968*^9, 
   3.641556872703511*^9, {3.675577313538183*^9, 3.675577342032565*^9}, 
   3.6761155889016047`*^9, 3.676198861996129*^9, 3.676199452903678*^9, 
   3.676202111206843*^9, 3.676286210935853*^9, 3.676286782752118*^9, 
   3.6762869143369417`*^9, 3.714900449903*^9, 3.714900976603509*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.638612439263659*^9, 3.638612450767869*^9}, 
   3.6386128940614233`*^9, {3.638613650524602*^9, 3.63861368019837*^9}, 
   3.638613752618588*^9, 3.638622421421833*^9, 3.638623259654512*^9, 
   3.638623682719574*^9, 3.63862387089994*^9, 3.638681839413598*^9, 
   3.638685147339924*^9, 3.638686835296649*^9, 3.638702823739684*^9, 
   3.6387045306445217`*^9, 3.638707583603277*^9, 3.638708179320146*^9, 
   3.638708280154018*^9, 3.638712313990831*^9, 3.638714885676031*^9, 
   3.6387158722970467`*^9, 3.6387688476652308`*^9, 3.6398203261482677`*^9, 
   3.641555449377819*^9, 3.641555863256626*^9, 3.641556195644968*^9, 
   3.641556872703511*^9, {3.675577313538183*^9, 3.675577342032565*^9}, 
   3.6761155889016047`*^9, 3.676198861996129*^9, 3.676199452903678*^9, 
   3.676202111206843*^9, 3.676286210935853*^9, 3.676286782752118*^9, 
   3.6762869143369417`*^9, 3.714900449903*^9, 3.7149009766042957`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.638612439263659*^9, 3.638612450767869*^9}, 
   3.6386128940614233`*^9, {3.638613650524602*^9, 3.63861368019837*^9}, 
   3.638613752618588*^9, 3.638622421421833*^9, 3.638623259654512*^9, 
   3.638623682719574*^9, 3.63862387089994*^9, 3.638681839413598*^9, 
   3.638685147339924*^9, 3.638686835296649*^9, 3.638702823739684*^9, 
   3.6387045306445217`*^9, 3.638707583603277*^9, 3.638708179320146*^9, 
   3.638708280154018*^9, 3.638712313990831*^9, 3.638714885676031*^9, 
   3.6387158722970467`*^9, 3.6387688476652308`*^9, 3.6398203261482677`*^9, 
   3.641555449377819*^9, 3.641555863256626*^9, 3.641556195644968*^9, 
   3.641556872703511*^9, {3.675577313538183*^9, 3.675577342032565*^9}, 
   3.6761155889016047`*^9, 3.676198861996129*^9, 3.676199452903678*^9, 
   3.676202111206843*^9, 3.676286210935853*^9, 3.676286782752118*^9, 
   3.6762869143369417`*^9, 3.714900449903*^9, 3.71490097660509*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"4\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "4", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.638612439263659*^9, 3.638612450767869*^9}, 
   3.6386128940614233`*^9, {3.638613650524602*^9, 3.63861368019837*^9}, 
   3.638613752618588*^9, 3.638622421421833*^9, 3.638623259654512*^9, 
   3.638623682719574*^9, 3.63862387089994*^9, 3.638681839413598*^9, 
   3.638685147339924*^9, 3.638686835296649*^9, 3.638702823739684*^9, 
   3.6387045306445217`*^9, 3.638707583603277*^9, 3.638708179320146*^9, 
   3.638708280154018*^9, 3.638712313990831*^9, 3.638714885676031*^9, 
   3.6387158722970467`*^9, 3.6387688476652308`*^9, 3.6398203261482677`*^9, 
   3.641555449377819*^9, 3.641555863256626*^9, 3.641556195644968*^9, 
   3.641556872703511*^9, {3.675577313538183*^9, 3.675577342032565*^9}, 
   3.6761155889016047`*^9, 3.676198861996129*^9, 3.676199452903678*^9, 
   3.676202111206843*^9, 3.676286210935853*^9, 3.676286782752118*^9, 
   3.6762869143369417`*^9, 3.714900449903*^9, 3.714900976638345*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.638612439263659*^9, 3.638612450767869*^9}, 
   3.6386128940614233`*^9, {3.638613650524602*^9, 3.63861368019837*^9}, 
   3.638613752618588*^9, 3.638622421421833*^9, 3.638623259654512*^9, 
   3.638623682719574*^9, 3.63862387089994*^9, 3.638681839413598*^9, 
   3.638685147339924*^9, 3.638686835296649*^9, 3.638702823739684*^9, 
   3.6387045306445217`*^9, 3.638707583603277*^9, 3.638708179320146*^9, 
   3.638708280154018*^9, 3.638712313990831*^9, 3.638714885676031*^9, 
   3.6387158722970467`*^9, 3.6387688476652308`*^9, 3.6398203261482677`*^9, 
   3.641555449377819*^9, 3.641555863256626*^9, 3.641556195644968*^9, 
   3.641556872703511*^9, {3.675577313538183*^9, 3.675577342032565*^9}, 
   3.6761155889016047`*^9, 3.676198861996129*^9, 3.676199452903678*^9, 
   3.676202111206843*^9, 3.676286210935853*^9, 3.676286782752118*^9, 
   3.6762869143369417`*^9, 3.714900449903*^9, 3.714900980955859*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "14", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{17., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "14", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  14, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 14, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.638612439263659*^9, 3.638612450767869*^9}, 
   3.6386128940614233`*^9, {3.638613650524602*^9, 3.63861368019837*^9}, 
   3.638613752618588*^9, 3.638622421421833*^9, 3.638623259654512*^9, 
   3.638623682719574*^9, 3.63862387089994*^9, 3.638681839413598*^9, 
   3.638685147339924*^9, 3.638686835296649*^9, 3.638702823739684*^9, 
   3.6387045306445217`*^9, 3.638707583603277*^9, 3.638708179320146*^9, 
   3.638708280154018*^9, 3.638712313990831*^9, 3.638714885676031*^9, 
   3.6387158722970467`*^9, 3.6387688476652308`*^9, 3.6398203261482677`*^9, 
   3.641555449377819*^9, 3.641555863256626*^9, 3.641556195644968*^9, 
   3.641556872703511*^9, {3.675577313538183*^9, 3.675577342032565*^9}, 
   3.6761155889016047`*^9, 3.676198861996129*^9, 3.676199452903678*^9, 
   3.676202111206843*^9, 3.676286210935853*^9, 3.676286782752118*^9, 
   3.6762869143369417`*^9, 3.714900449903*^9, 3.714900980995866*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"14", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[14, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.638612439263659*^9, 3.638612450767869*^9}, 
   3.6386128940614233`*^9, {3.638613650524602*^9, 3.63861368019837*^9}, 
   3.638613752618588*^9, 3.638622421421833*^9, 3.638623259654512*^9, 
   3.638623682719574*^9, 3.63862387089994*^9, 3.638681839413598*^9, 
   3.638685147339924*^9, 3.638686835296649*^9, 3.638702823739684*^9, 
   3.6387045306445217`*^9, 3.638707583603277*^9, 3.638708179320146*^9, 
   3.638708280154018*^9, 3.638712313990831*^9, 3.638714885676031*^9, 
   3.6387158722970467`*^9, 3.6387688476652308`*^9, 3.6398203261482677`*^9, 
   3.641555449377819*^9, 3.641555863256626*^9, 3.641556195644968*^9, 
   3.641556872703511*^9, {3.675577313538183*^9, 3.675577342032565*^9}, 
   3.6761155889016047`*^9, 3.676198861996129*^9, 3.676199452903678*^9, 
   3.676202111206843*^9, 3.676286210935853*^9, 3.676286782752118*^9, 
   3.6762869143369417`*^9, 3.714900449903*^9, 3.714900983120726*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AlpFRSimp", "=", 
   RowBox[{
    RowBox[{"AlpFR", "//", "Simplify"}], "//", 
    RowBox[{
     RowBox[{"Collect", "[", 
      RowBox[{"#", ",", 
       RowBox[{"{", 
        SubscriptBox["\[Epsilon]", "_"], "}"}], ",", "FullSimplify"}], "]"}], 
     "&"}]}]}], ";", 
  RowBox[{"AlpFRSimp", "//", "TableForm"}]}]], "Input",
 CellChangeTimes->{{3.638613750408924*^9, 3.638613917314427*^9}, {
   3.6386139618919573`*^9, 3.6386140242555027`*^9}, {3.638614110850162*^9, 
   3.63861411992393*^9}, {3.6386142738449593`*^9, 3.638614464079233*^9}, {
   3.638622495805666*^9, 3.6386224999713*^9}, {3.638622681020277*^9, 
   3.6386226879638844`*^9}, {3.638622722309443*^9, 3.6386227454282093`*^9}, {
   3.638623669647767*^9, 3.638623670261174*^9}, 3.638682708207778*^9, {
   3.638700133618009*^9, 3.638700136676296*^9}, {3.638702929466498*^9, 
   3.638702931898744*^9}, {3.6387030695743713`*^9, 3.6387031130558977`*^9}, {
   3.638703151342684*^9, 3.638703247383995*^9}, {3.638703282975972*^9, 
   3.638703379857666*^9}, {3.6387160628081417`*^9, 3.638716079998055*^9}, {
   3.638716121793007*^9, 3.638716206718704*^9}, {3.676115591639645*^9, 
   3.6761155983649282`*^9}, {3.676199742374304*^9, 3.676199767888208*^9}, 
   3.676286209033051*^9}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {"A", "1"},
       {"A", "2"},
       {"ALP", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["c", 
            OverscriptBox["B", "~"]]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["c", 
              OverscriptBox["B", "~"]], "-", 
             SubscriptBox["c", 
              OverscriptBox["W", "~"]]}], ")"}], " ", 
           SubsuperscriptBox["s", "w", "2"]}]}], ")"}], " ", 
        SubscriptBox["\[Epsilon]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "mu$1", ",", "mu$2"}]], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubsuperscriptBox["\<\"p\"\>", "1", "mu$2"], " ", 
           SubsuperscriptBox["\<\"p\"\>", "2", "mu$1"]}], "-", 
          RowBox[{
           SubsuperscriptBox["\<\"p\"\>", "1", "mu$1"], " ", 
           SubsuperscriptBox["\<\"p\"\>", "2", "mu$2"]}]}], ")"}]}], 
       SubscriptBox["f", "a"]]}]},
    {GridBox[{
       {"ALP", "1"},
       {"G", "2"},
       {"G", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", 
        OverscriptBox["G", "~"]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[Epsilon]", 
           RowBox[{
            SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "\[Alpha]1", ",", 
            "\[Beta]1"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Beta]1"], " ", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Alpha]1"]}], "-", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Alpha]1"], " ", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Beta]1"]}]}], ")"}]}], 
         "+", 
         RowBox[{
          SubscriptBox["\[Epsilon]", 
           RowBox[{
            SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "\[Gamma]1", ",", 
            "\[Beta]1"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SubsuperscriptBox["\<\"p\"\>", "2", "\[Gamma]1"]}], " ", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Beta]1"]}], "+", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Beta]1"], " ", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Gamma]1"]}]}], ")"}]}], 
         "+", 
         RowBox[{
          SubscriptBox["\[Epsilon]", 
           RowBox[{
            SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "\[Alpha]1", ",", 
            "\[Delta]1"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Delta]1"], " ", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Alpha]1"]}], "-", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Alpha]1"], " ", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Delta]1"]}]}], ")"}]}], 
         "+", 
         RowBox[{
          SubscriptBox["\[Epsilon]", 
           RowBox[{
            SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "\[Gamma]1", ",", 
            "\[Delta]1"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Delta]1"], " ", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Gamma]1"]}], "-", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Gamma]1"], " ", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Delta]1"]}]}], ")"}]}]}], 
        ")"}], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]]}], 
      RowBox[{"2", " ", 
       SubscriptBox["f", "a"]}]]},
    {GridBox[{
       {"ALP", "1"},
       {"W", "2"},
       {
        SuperscriptBox["W", "\[Dagger]"], "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", 
        OverscriptBox["W", "~"]], " ", 
       SubscriptBox["\[Epsilon]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1", ",", "mu$2"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubsuperscriptBox["\<\"p\"\>", "2", "mu$2"], " ", 
          SubsuperscriptBox["\<\"p\"\>", "3", "mu$1"]}], "-", 
         RowBox[{
          SubsuperscriptBox["\<\"p\"\>", "2", "mu$1"], " ", 
          SubsuperscriptBox["\<\"p\"\>", "3", "mu$2"]}]}], ")"}]}], 
      SubscriptBox["f", "a"]]},
    {GridBox[{
       {"A", "1"},
       {"ALP", "2"},
       {"Z", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{"2", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["c", 
          OverscriptBox["B", "~"]], "-", 
         SubscriptBox["c", 
          OverscriptBox["W", "~"]]}], ")"}], " ", 
       SubscriptBox["s", "w"], " ", 
       SubscriptBox["\[Epsilon]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1", ",", "mu$2"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubsuperscriptBox["\<\"p\"\>", "1", "mu$2"]}], " ", 
          SubsuperscriptBox["\<\"p\"\>", "3", "mu$1"]}], "+", 
         RowBox[{
          SubsuperscriptBox["\<\"p\"\>", "1", "mu$1"], " ", 
          SubsuperscriptBox["\<\"p\"\>", "3", "mu$2"]}]}], ")"}]}], 
      SubscriptBox["f", "a"]]},
    {GridBox[{
       {"ALP", "1"},
       {"Z", "2"},
       {"Z", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["c", 
            OverscriptBox["W", "~"]]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SubscriptBox["c", 
               OverscriptBox["B", "~"]]}], "+", 
             SubscriptBox["c", 
              OverscriptBox["W", "~"]]}], ")"}], " ", 
           SubsuperscriptBox["s", "w", "2"]}]}], ")"}], " ", 
        SubscriptBox["\[Epsilon]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1", ",", "mu$2"}]], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubsuperscriptBox["\<\"p\"\>", "2", "mu$2"], " ", 
           SubsuperscriptBox["\<\"p\"\>", "3", "mu$1"]}], "-", 
          RowBox[{
           SubsuperscriptBox["\<\"p\"\>", "2", "mu$1"], " ", 
           SubsuperscriptBox["\<\"p\"\>", "3", "mu$2"]}]}], ")"}]}], 
       SubscriptBox["f", "a"]]}]},
    {GridBox[{
       {"ALP", "1"},
       {"G", "2"},
       {"G", "3"},
       {"G", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SubscriptBox["c", 
         OverscriptBox["G", "~"]], " ", 
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", 
          SubscriptBox["\<\"a\"\>", "4"]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[Epsilon]", 
            RowBox[{
             SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", "\[Alpha]1"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Alpha]1"], "+", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Alpha]1"], "+", 
             SubsuperscriptBox["\<\"p\"\>", "4", "\[Alpha]1"]}], ")"}]}], "+", 
          RowBox[{
           SubscriptBox["\[Epsilon]", 
            RowBox[{
             SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", "\[Beta]1"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Beta]1"], "+", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Beta]1"], "+", 
             SubsuperscriptBox["\<\"p\"\>", "4", "\[Beta]1"]}], ")"}]}], "+", 
          
          RowBox[{
           SubscriptBox["\[Epsilon]", 
            RowBox[{
             SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", "\[Gamma]1"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Gamma]1"], "+", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Gamma]1"], "+", 
             SubsuperscriptBox["\<\"p\"\>", "4", "\[Gamma]1"]}], ")"}]}], "+", 
          RowBox[{
           SubscriptBox["\[Epsilon]", 
            RowBox[{
             SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", "\[Delta]1"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Delta]1"], "+", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Delta]1"], "+", 
             SubsuperscriptBox["\<\"p\"\>", "4", "\[Delta]1"]}], ")"}]}]}], 
         ")"}]}], 
       SubscriptBox["f", "a"]]}]},
    {GridBox[{
       {
        OverscriptBox["dq", "\<\"-\"\>"], "1"},
       {"dq", "2"},
       {"ALP", "3"},
       {"H", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{
       SubscriptBox["c", "a\[Phi]"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubsuperscriptBox[
            RowBox[{"(", 
             TemplateBox[{"y","d"},
              "Superscript"], ")"}], 
            RowBox[{
             SubscriptBox["\<\"f\"\>", "2"], ",", 
             SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"]}], " ", 
          SubscriptBox[
           SubscriptBox["P", "\<\"-\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
         RowBox[{
          SubscriptBox[
           SubscriptBox["P", "\<\"+\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
          SubscriptBox[
           TemplateBox[{"y","d"},
            "Superscript"], 
           RowBox[{
            SubscriptBox["\<\"f\"\>", "1"], ",", 
            SubscriptBox["\<\"f\"\>", "2"]}]]}]}], ")"}]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["f", "a"]}]]},
    {GridBox[{
       {
        OverscriptBox["dq", "\<\"-\"\>"], "1"},
       {"dq", "2"},
       {"ALP", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{
       SubscriptBox["c", "a\[Phi]"], " ", "vev", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubsuperscriptBox[
            RowBox[{"(", 
             TemplateBox[{"y","d"},
              "Superscript"], ")"}], 
            RowBox[{
             SubscriptBox["\<\"f\"\>", "2"], ",", 
             SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"]}], " ", 
          SubscriptBox[
           SubscriptBox["P", "\<\"-\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
         RowBox[{
          SubscriptBox[
           SubscriptBox["P", "\<\"+\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
          SubscriptBox[
           TemplateBox[{"y","d"},
            "Superscript"], 
           RowBox[{
            SubscriptBox["\<\"f\"\>", "1"], ",", 
            SubscriptBox["\<\"f\"\>", "2"]}]]}]}], ")"}]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["f", "a"]}]]},
    {GridBox[{
       {
        OverscriptBox["l", "\<\"-\"\>"], "1"},
       {"l", "2"},
       {"ALP", "3"},
       {"H", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{
       SubscriptBox["c", "a\[Phi]"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubsuperscriptBox[
            RowBox[{"(", 
             TemplateBox[{"y","l"},
              "Superscript"], ")"}], 
            RowBox[{
             SubscriptBox["\<\"f\"\>", "2"], ",", 
             SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"]}], " ", 
          SubscriptBox[
           SubscriptBox["P", "\<\"-\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
         RowBox[{
          SubscriptBox[
           SubscriptBox["P", "\<\"+\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
          SubscriptBox[
           TemplateBox[{"y","l"},
            "Superscript"], 
           RowBox[{
            SubscriptBox["\<\"f\"\>", "1"], ",", 
            SubscriptBox["\<\"f\"\>", "2"]}]]}]}], ")"}]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["f", "a"]}]]},
    {GridBox[{
       {
        OverscriptBox["l", "\<\"-\"\>"], "1"},
       {"l", "2"},
       {"ALP", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{
       SubscriptBox["c", "a\[Phi]"], " ", "vev", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubsuperscriptBox[
            RowBox[{"(", 
             TemplateBox[{"y","l"},
              "Superscript"], ")"}], 
            RowBox[{
             SubscriptBox["\<\"f\"\>", "2"], ",", 
             SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"]}], " ", 
          SubscriptBox[
           SubscriptBox["P", "\<\"-\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]]}], "+", 
         RowBox[{
          SubscriptBox[
           SubscriptBox["P", "\<\"+\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
          SubscriptBox[
           TemplateBox[{"y","l"},
            "Superscript"], 
           RowBox[{
            SubscriptBox["\<\"f\"\>", "1"], ",", 
            SubscriptBox["\<\"f\"\>", "2"]}]]}]}], ")"}]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["f", "a"]}]]},
    {GridBox[{
       {
        OverscriptBox["uq", "\<\"-\"\>"], "1"},
       {"uq", "2"},
       {"ALP", "3"},
       {"H", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{
       SubscriptBox["c", "a\[Phi]"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubsuperscriptBox[
           RowBox[{"(", 
            TemplateBox[{"y","u"},
             "Superscript"], ")"}], 
           RowBox[{
            SubscriptBox["\<\"f\"\>", "2"], ",", 
            SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
          SubscriptBox[
           SubscriptBox["P", "\<\"-\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
         RowBox[{
          SubscriptBox[
           SubscriptBox["P", "\<\"+\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
          SubscriptBox[
           TemplateBox[{"y","u"},
            "Superscript"], 
           RowBox[{
            SubscriptBox["\<\"f\"\>", "1"], ",", 
            SubscriptBox["\<\"f\"\>", "2"]}]]}]}], ")"}]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["f", "a"]}]]},
    {GridBox[{
       {
        OverscriptBox["uq", "\<\"-\"\>"], "1"},
       {"uq", "2"},
       {"ALP", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{
       SubscriptBox["c", "a\[Phi]"], " ", "vev", " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubsuperscriptBox[
           RowBox[{"(", 
            TemplateBox[{"y","u"},
             "Superscript"], ")"}], 
           RowBox[{
            SubscriptBox["\<\"f\"\>", "2"], ",", 
            SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
          SubscriptBox[
           SubscriptBox["P", "\<\"-\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
         RowBox[{
          SubscriptBox[
           SubscriptBox["P", "\<\"+\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
          SubscriptBox[
           TemplateBox[{"y","u"},
            "Superscript"], 
           RowBox[{
            SubscriptBox["\<\"f\"\>", "1"], ",", 
            SubscriptBox["\<\"f\"\>", "2"]}]]}]}], ")"}]}], 
      RowBox[{
       SqrtBox["2"], " ", 
       SubscriptBox["f", "a"]}]]},
    {GridBox[{
       {"A", "1"},
       {"ALP", "2"},
       {"W", "3"},
       {
        SuperscriptBox["W", "\[Dagger]"], "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"4", " ", "\[ImaginaryI]", " ", 
        SubscriptBox["c", 
         OverscriptBox["W", "~"]], " ", "e", " ", 
        SubscriptBox["\[Epsilon]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1"}]], " ", 
        RowBox[{"(", 
         RowBox[{
          SubsuperscriptBox["\<\"p\"\>", "1", "mu$1"], "+", 
          SubsuperscriptBox["\<\"p\"\>", "3", "mu$1"], "+", 
          SubsuperscriptBox["\<\"p\"\>", "4", "mu$1"]}], ")"}]}], 
       SubscriptBox["f", "a"]]}]},
    {GridBox[{
       {"ALP", "1"},
       {"W", "2"},
       {
        SuperscriptBox["W", "\[Dagger]"], "3"},
       {"Z", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{"4", " ", "\[ImaginaryI]", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["c", 
        OverscriptBox["W", "~"]], " ", "e", " ", 
       SubscriptBox["\[Epsilon]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1"}]], " ", 
       RowBox[{"(", 
        RowBox[{
         SubsuperscriptBox["\<\"p\"\>", "2", "mu$1"], "+", 
         SubsuperscriptBox["\<\"p\"\>", "3", "mu$1"], "+", 
         SubsuperscriptBox["\<\"p\"\>", "4", "mu$1"]}], ")"}]}], 
      RowBox[{
       SubscriptBox["f", "a"], " ", 
       SubscriptBox["s", "w"]}]]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{{{$CellContext`A, 1}, {$CellContext`A, 2}, {$CellContext`ALP, 
       3}}, Complex[
      0, -2] $CellContext`fa^(-1) (-$CellContext`CBtil + ($CellContext`CBtil - \
$CellContext`CWtil) $CellContext`sw^2) FeynRules`Eps[
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[1]], 
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[2]], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] (FeynRules`FV[1, 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] 
       FeynRules`FV[2, 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] - 
      FeynRules`FV[1, 
        FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] FeynRules`FV[2, 
        FeynRules`Index[
        FeynRules`Lorentz, $CellContext`mu$2]])}, {{{$CellContext`ALP, 1}, {
      FeynRules`G, 2}, {FeynRules`G, 3}}, Complex[0, 
       Rational[1, 2]] $CellContext`CGtil $CellContext`fa^(-1) (
      FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]] (
        FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]] 
         FeynRules`FV[3, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1]] - 
        FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1]] 
        FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]]) + 
      FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]] (-
         FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1]] 
         FeynRules`FV[3, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]] + 
        FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]] 
         FeynRules`FV[3, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1]]) + 
      FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]] (
        FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]] 
         FeynRules`FV[3, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1]] - 
        FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1]] 
        FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]]) + 
      FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]] (
        FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]] 
         FeynRules`FV[3, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1]] - 
        FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1]] 
        FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]])) 
     FeynRules`IndexDelta[
       FeynRules`Index[FeynRules`Gluon, 
        FeynRules`Ext[2]], 
       FeynRules`Index[FeynRules`Gluon, 
        FeynRules`Ext[3]]]}, {{{$CellContext`ALP, 1}, {
      FeynRules`W, 2}, {$CellContext`Wbar, 3}}, 
     Complex[0, 2] $CellContext`CWtil $CellContext`fa^(-1) FeynRules`Eps[
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[2]], 
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[3]], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] (FeynRules`FV[2, 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] 
       FeynRules`FV[3, 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] - 
      FeynRules`FV[2, 
        FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] FeynRules`FV[3, 
        FeynRules`Index[
        FeynRules`Lorentz, $CellContext`mu$2]])}, {{{$CellContext`A, 
       1}, {$CellContext`ALP, 2}, {$CellContext`Z, 3}}, 
     Complex[0, 
       2] $CellContext`cw ($CellContext`CBtil - $CellContext`CWtil) \
$CellContext`fa^(-1) $CellContext`sw FeynRules`Eps[
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[1]], 
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[3]], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] (-
       FeynRules`FV[1, 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] 
       FeynRules`FV[3, 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] + 
      FeynRules`FV[1, 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] 
       FeynRules`FV[3, 
         FeynRules`Index[
         FeynRules`Lorentz, $CellContext`mu$2]])}, {{{$CellContext`ALP, 
       1}, {$CellContext`Z, 2}, {$CellContext`Z, 3}}, 
     Complex[0, -2] $CellContext`fa^(-1) (-$CellContext`CWtil + \
(-$CellContext`CBtil + $CellContext`CWtil) $CellContext`sw^2) FeynRules`Eps[
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[2]], 
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[3]], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] (FeynRules`FV[2, 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] 
       FeynRules`FV[3, 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] - 
      FeynRules`FV[2, 
        FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] FeynRules`FV[3, 
        FeynRules`Index[
        FeynRules`Lorentz, $CellContext`mu$2]])}, {{{$CellContext`ALP, 1}, {
      FeynRules`G, 2}, {FeynRules`G, 3}, {
      FeynRules`G, 4}}, -$CellContext`CGtil $CellContext`fa^(-1) FeynRules`gs 
     FeynRules`f[
       FeynRules`Index[FeynRules`Gluon, 
        FeynRules`Ext[2]], 
       FeynRules`Index[FeynRules`Gluon, 
        FeynRules`Ext[3]], 
       FeynRules`Index[FeynRules`Gluon, 
        FeynRules`Ext[4]]] (FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[4]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1]] (
        FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1]] + 
        FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1]] + 
        FeynRules`FV[4, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1]]) + 
      FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[4]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]] (
        FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]] + 
        FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]] + 
        FeynRules`FV[4, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]]) + 
      FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[4]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1]] (
        FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1]] + 
        FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1]] + 
        FeynRules`FV[4, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1]]) + 
      FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[4]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]] (
        FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]] + 
        FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]] + 
        FeynRules`FV[4, 
          FeynRules`Index[
          FeynRules`Lorentz, $CellContext`\[Delta]1]]))}, \
{{{$CellContext`dqbar, 1}, {$CellContext`dq, 2}, {$CellContext`ALP, 3}, {
      FeynRules`H, 4}}, 
     2^Rational[-1, 2] $CellContext`CaPhi $CellContext`fa^(-1) 
     FeynRules`IndexDelta[
       FeynRules`Index[FeynRules`Colour, 
        FeynRules`Ext[1]], 
       FeynRules`Index[FeynRules`Colour, 
        FeynRules`Ext[2]]] (-Conjugate[
         $CellContext`yd[
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[2]], 
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[1]]]] FeynRules`ProjM[
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[2]]] + FeynRules`ProjP[
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[2]]] $CellContext`yd[
         FeynRules`Index[$CellContext`Generation, 
          FeynRules`Ext[1]], 
         FeynRules`Index[$CellContext`Generation, 
          FeynRules`Ext[2]]])}, {{{$CellContext`dqbar, 1}, {$CellContext`dq, 
       2}, {$CellContext`ALP, 3}}, 
     2^Rational[-1, 
        2] $CellContext`CaPhi $CellContext`fa^(-1) $CellContext`vev 
     FeynRules`IndexDelta[
       FeynRules`Index[FeynRules`Colour, 
        FeynRules`Ext[1]], 
       FeynRules`Index[FeynRules`Colour, 
        FeynRules`Ext[2]]] (-Conjugate[
         $CellContext`yd[
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[2]], 
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[1]]]] FeynRules`ProjM[
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[2]]] + FeynRules`ProjP[
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[2]]] $CellContext`yd[
         FeynRules`Index[$CellContext`Generation, 
          FeynRules`Ext[1]], 
         FeynRules`Index[$CellContext`Generation, 
          FeynRules`Ext[2]]])}, {{{$CellContext`lbar, 1}, {
      FeynRules`l, 2}, {$CellContext`ALP, 3}, {FeynRules`H, 4}}, 
     2^Rational[-1, 2] $CellContext`CaPhi $CellContext`fa^(-1) (-Conjugate[
         $CellContext`yl[
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[2]], 
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[1]]]] FeynRules`ProjM[
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[2]]] + FeynRules`ProjP[
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[2]]] $CellContext`yl[
         FeynRules`Index[$CellContext`Generation, 
          FeynRules`Ext[1]], 
         FeynRules`Index[$CellContext`Generation, 
          FeynRules`Ext[2]]])}, {{{$CellContext`lbar, 1}, {
      FeynRules`l, 2}, {$CellContext`ALP, 3}}, 
     2^Rational[-1, 
        2] $CellContext`CaPhi $CellContext`fa^(-1) $CellContext`vev (-
       Conjugate[
         $CellContext`yl[
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[2]], 
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[1]]]] FeynRules`ProjM[
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[2]]] + FeynRules`ProjP[
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[2]]] $CellContext`yl[
         FeynRules`Index[$CellContext`Generation, 
          FeynRules`Ext[1]], 
         FeynRules`Index[$CellContext`Generation, 
          FeynRules`Ext[2]]])}, {{{$CellContext`uqbar, 1}, {$CellContext`uq, 
       2}, {$CellContext`ALP, 3}, {FeynRules`H, 4}}, 
     2^Rational[-1, 2] $CellContext`CaPhi $CellContext`fa^(-1) 
     FeynRules`IndexDelta[
       FeynRules`Index[FeynRules`Colour, 
        FeynRules`Ext[1]], 
       FeynRules`Index[FeynRules`Colour, 
        FeynRules`Ext[2]]] (Conjugate[
         $CellContext`yu[
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[2]], 
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[1]]]] FeynRules`ProjM[
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[2]]] - FeynRules`ProjP[
        FeynRules`Index[FeynRules`Spin, 
         FeynRules`Ext[1]], 
        FeynRules`Index[FeynRules`Spin, 
         FeynRules`Ext[2]]] $CellContext`yu[
        FeynRules`Index[$CellContext`Generation, 
         FeynRules`Ext[1]], 
        FeynRules`Index[$CellContext`Generation, 
         FeynRules`Ext[2]]])}, {{{$CellContext`uqbar, 1}, {$CellContext`uq, 
       2}, {$CellContext`ALP, 3}}, 
     2^Rational[-1, 
        2] $CellContext`CaPhi $CellContext`fa^(-1) $CellContext`vev 
     FeynRules`IndexDelta[
       FeynRules`Index[FeynRules`Colour, 
        FeynRules`Ext[1]], 
       FeynRules`Index[FeynRules`Colour, 
        FeynRules`Ext[2]]] (Conjugate[
         $CellContext`yu[
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[2]], 
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[1]]]] FeynRules`ProjM[
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[2]]] - FeynRules`ProjP[
        FeynRules`Index[FeynRules`Spin, 
         FeynRules`Ext[1]], 
        FeynRules`Index[FeynRules`Spin, 
         FeynRules`Ext[2]]] $CellContext`yu[
        FeynRules`Index[$CellContext`Generation, 
         FeynRules`Ext[1]], 
        FeynRules`Index[$CellContext`Generation, 
         FeynRules`Ext[2]]])}, {{{$CellContext`A, 1}, {$CellContext`ALP, 2}, {
      FeynRules`W, 3}, {$CellContext`Wbar, 4}}, 
     Complex[0, -4] $CellContext`CWtil FeynRules`ee $CellContext`fa^(-1) 
     FeynRules`Eps[
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[1]], 
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[4]], 
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[3]], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] (FeynRules`FV[1, 
        FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] + 
      FeynRules`FV[3, 
        FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] + 
      FeynRules`FV[4, 
        FeynRules`Index[
        FeynRules`Lorentz, $CellContext`mu$1]])}, {{{$CellContext`ALP, 1}, {
      FeynRules`W, 2}, {$CellContext`Wbar, 3}, {$CellContext`Z, 4}}, 
     Complex[0, 4] $CellContext`cw $CellContext`CWtil 
     FeynRules`ee $CellContext`fa^(-1) $CellContext`sw^(-1) FeynRules`Eps[
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[4]], 
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[2]], 
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[3]], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] (FeynRules`FV[2, 
        FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] + 
      FeynRules`FV[3, 
        FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] + 
      FeynRules`FV[4, 
        FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]])}}]]], "Output",\

 CellChangeTimes->{{3.638614114774802*^9, 3.638614120544181*^9}, {
   3.638614318695908*^9, 3.638614365439787*^9}, {3.638614433232692*^9, 
   3.638614464705694*^9}, 3.6386224388916407`*^9, 3.6386225007679977`*^9, 
   3.6386226973043947`*^9, 3.6386227333544188`*^9, 3.638623278409637*^9, 
   3.6386236952225227`*^9, 3.63862388459741*^9, 3.638681852154767*^9, 
   3.63868270965028*^9, 3.6386851562356977`*^9, 3.638686844261732*^9, 
   3.638700137162476*^9, 3.638702832337493*^9, 3.6387029349627132`*^9, {
   3.638703100427805*^9, 3.6387031136888237`*^9}, {3.63870321256925*^9, 
   3.638703230424244*^9}, {3.638703278436899*^9, 3.638703292187565*^9}, 
   3.6387033347871733`*^9, 3.638703390597958*^9, 3.638704548504233*^9, 
   3.638707599815777*^9, 3.638708193011647*^9, 3.638708294314163*^9, 
   3.638712328104225*^9, 3.638714899545281*^9, 3.6387158861274137`*^9, {
   3.638716073530249*^9, 3.6387160868743467`*^9}, {3.63871612959566*^9, 
   3.638716213883053*^9}, 3.638768861462468*^9, 3.639820343194125*^9, 
   3.6415554721097116`*^9, 3.641556006389512*^9, 3.641556218296584*^9, 
   3.6415568954663677`*^9, 3.675577255235321*^9, 3.6755773956759577`*^9, 
   3.6761156287361507`*^9, 3.676199644982154*^9, {3.6761997657926407`*^9, 
   3.676199788244617*^9}, 3.676202161727428*^9, 3.676286259801929*^9, 
   3.676286831252707*^9, 3.676286963494295*^9, 3.7149005669550333`*^9, 
   3.714900986609859*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Export to UFO", "Subsection",
 CellChangeTimes->{{3.638798084002553*^9, 3.6387980887087*^9}, {
  3.7149007705746527`*^9, 3.7149007713720427`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{
   RowBox[{"LSM", "+", "LALP"}], ",", 
   RowBox[{"MaxParticles", "\[Rule]", "4"}], ",", " ", 
   RowBox[{"Output", "\[Rule]", "\"\<ALP_linear_UFO\>\""}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.638796268087139*^9, 3.638796293694366*^9}, {
  3.676286245623457*^9, 3.676286247246126*^9}, {3.6943356972519197`*^9, 
  3.6943356990015907`*^9}, {3.714900494999193*^9, 3.714900536696802*^9}, {
  3.7149009924193783`*^9, 3.7149009954383917`*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.714900591927953*^9, 3.714901015063738*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.7149010153269167`*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.714901015328267*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.7149010153294573`*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.714901023561137*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "50", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{17., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "50", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  50, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 50, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.714901023644479*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"45", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[45, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.7149010282581987`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{17., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "45"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 45],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.714901029087723*^9}],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.7149010340111856`*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.714901034050983*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{9., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "62"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 62],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.714901034052537*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "4.644`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 4.644, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.714901049084815*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{17., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "72"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 72],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.714901049098535*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", "0.596`", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 0.596, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.71490105045955*^9}],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.714901050462216*^9}],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.714900591927953*^9, 3.714901050621313*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.71490105069834*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{24., {0., 9.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "101", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 101, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.714901052384447*^9}],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.714901052437394*^9}],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.714900591927953*^9, 3.714901052663561*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["ALP chiral EFT", "Section",
 CellChangeTimes->{{3.696241144773179*^9, 3.696241150440773*^9}, {
  3.6965809461276217`*^9, 3.6965809488385057`*^9}, {3.7144743309076147`*^9, 
  3.71447433315618*^9}, {3.7148999134555597`*^9, 3.714899915627069*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"LoadModel", "[", 
   RowBox[{"\"\<SM.fr\>\"", ",", "\"\<alp_chiral.fr\>\""}], "]"}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"$Assumptions", "=", 
   RowBox[{
    RowBox[{
     SuperscriptBox["cw", "2"], "+", 
     SuperscriptBox["sw", "2"]}], "\[Equal]", "1"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.419073170860696*^9, 3.419073182827229*^9}, {
   3.5695939666521587`*^9, 3.569593975189637*^9}, {3.571998624557815*^9, 
   3.571998628157531*^9}, {3.5722426658955507`*^9, 3.5722426665661163`*^9}, {
   3.57373494999842*^9, 3.573734950506782*^9}, {3.573738411070033*^9, 
   3.573738411475131*^9}, {3.581766296877213*^9, 3.5817662993035793`*^9}, {
   3.582711295612512*^9, 3.582711304079101*^9}, {3.58271455619954*^9, 
   3.582714556539135*^9}, {3.5837271421921186`*^9, 3.5837271424321213`*^9}, {
   3.624620697450859*^9, 3.6246207033691893`*^9}, {3.6334178673816833`*^9, 
   3.633417870423235*^9}, {3.635168745836775*^9, 3.635168746552165*^9}, {
   3.635234921249031*^9, 3.6352349280391006`*^9}, {3.638611693959074*^9, 
   3.638611733478942*^9}, {3.638618101259109*^9, 3.638618101467348*^9}, 
   3.63861936248402*^9, 3.638619484234972*^9, {3.638620679982355*^9, 
   3.638620680842409*^9}, {3.6386861262510643`*^9, 3.638686136772785*^9}, {
   3.6415550100096617`*^9, 3.641555015231119*^9}, {3.676109930720601*^9, 
   3.6761099312888002`*^9}, {3.6761959551581984`*^9, 3.67619595753176*^9}, {
   3.676196049763735*^9, 3.6761960518031893`*^9}, {3.71489982794697*^9, 
   3.714899828966436*^9}, {3.71490004046701*^9, 3.714900043136207*^9}, {
   3.7149001684519243`*^9, 3.714900176622246*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\"Merging model-files...\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.7149001775995293`*^9}],

Cell[BoxData["\<\"This model implementation was created by\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.714900177625907*^9}],

Cell[BoxData["\<\"I. Brivio, M.B. Gavela, L. Merlo, K. Mimasu, J.M. No, R. \
del Rey, V. Sanz\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.714900177627756*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1\"\>"}],
  SequenceForm["Model Version: ", "1"],
  Editable->False]], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.714900177628923*^9}],

Cell[BoxData["\<\"Please cite\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.714900177629978*^9}],

Cell[BoxData["\<\"arXiv:1701.05379\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.714900177631019*^9}],

Cell[BoxData["\<\"https://feynrules.irmp.ucl.ac.be/wiki/ALPsEFT\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.714900177632065*^9}],

Cell[BoxData["\<\"For more information, type ModelInformation[].\"\>"], \
"Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.714900177633066*^9}],

Cell[BoxData["\<\"\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.714900177634055*^9}],

Cell[BoxData["\<\"   - Loading particle classes.\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.714900177635138*^9}],

Cell[BoxData["\<\"   - Loading gauge group classes.\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.714900177728979*^9}],

Cell[BoxData["\<\"   - Loading parameter classes.\"\>"], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.7149001777671137`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"\\nModel \"\>", "\[InvisibleSpace]", "\<\"ALP_chiral\"\>", 
   "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
  SequenceForm["\nModel ", "ALP_chiral", " loaded."],
  Editable->False]], "Print",
 CellChangeTimes->{3.6864895218593903`*^9, 3.68992828248105*^9, 
  3.694262302057581*^9, 3.69426253740763*^9, 3.694335188572085*^9, 
  3.694335562109014*^9, 3.714899830515174*^9, 3.7148999875453*^9, 
  3.714900177808638*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Feynman rules", "Subsection",
 CellChangeTimes->{{3.638612958456888*^9, 3.638612964903018*^9}, {
  3.641555437690887*^9, 3.6415554385930634`*^9}, {3.714900458407517*^9, 
  3.7149004631939707`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AlpFR", "=", 
   RowBox[{
    RowBox[{"FeynmanRules", "[", 
     RowBox[{"LALP", ",", 
      RowBox[{"MaxParticles", "\[Rule]", "4"}]}], "]"}], "//", "Simplify"}]}],
   ";"}]], "Input",
 CellChangeTimes->{{3.638612399979039*^9, 3.638612438377034*^9}, {
  3.6386128833730392`*^9, 3.638612887379834*^9}, {3.638613614059422*^9, 
  3.638613674285076*^9}, {3.638613735408643*^9, 3.6386137469743147`*^9}, {
  3.638703969309166*^9, 3.63870398233029*^9}, {3.676198845702183*^9, 
  3.676198850854022*^9}, {3.6762862015383883`*^9, 3.676286202884295*^9}, {
  3.714900437388975*^9, 3.714900439208026*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{{3.638612439263659*^9, 3.638612450767869*^9}, 
   3.6386128940614233`*^9, {3.638613650524602*^9, 3.63861368019837*^9}, 
   3.638613752618588*^9, 3.638622421421833*^9, 3.638623259654512*^9, 
   3.638623682719574*^9, 3.63862387089994*^9, 3.638681839413598*^9, 
   3.638685147339924*^9, 3.638686835296649*^9, 3.638702823739684*^9, 
   3.6387045306445217`*^9, 3.638707583603277*^9, 3.638708179320146*^9, 
   3.638708280154018*^9, 3.638712313990831*^9, 3.638714885676031*^9, 
   3.6387158722970467`*^9, 3.6387688476652308`*^9, 3.6398203261482677`*^9, 
   3.641555449377819*^9, 3.641555863256626*^9, 3.641556195644968*^9, 
   3.641556872703511*^9, {3.675577313538183*^9, 3.675577342032565*^9}, 
   3.6761155889016047`*^9, 3.676198861996129*^9, 3.676199452903678*^9, 
   3.676202111206843*^9, 3.676286210935853*^9, 3.676286782752118*^9, 
   3.6762869143369417`*^9, 3.714900449903*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{{3.638612439263659*^9, 3.638612450767869*^9}, 
   3.6386128940614233`*^9, {3.638613650524602*^9, 3.63861368019837*^9}, 
   3.638613752618588*^9, 3.638622421421833*^9, 3.638623259654512*^9, 
   3.638623682719574*^9, 3.63862387089994*^9, 3.638681839413598*^9, 
   3.638685147339924*^9, 3.638686835296649*^9, 3.638702823739684*^9, 
   3.6387045306445217`*^9, 3.638707583603277*^9, 3.638708179320146*^9, 
   3.638708280154018*^9, 3.638712313990831*^9, 3.638714885676031*^9, 
   3.6387158722970467`*^9, 3.6387688476652308`*^9, 3.6398203261482677`*^9, 
   3.641555449377819*^9, 3.641555863256626*^9, 3.641556195644968*^9, 
   3.641556872703511*^9, {3.675577313538183*^9, 3.675577342032565*^9}, 
   3.6761155889016047`*^9, 3.676198861996129*^9, 3.676199452903678*^9, 
   3.676202111206843*^9, 3.676286210935853*^9, 3.676286782752118*^9, 
   3.6762869143369417`*^9, 3.714900449904093*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{{3.638612439263659*^9, 3.638612450767869*^9}, 
   3.6386128940614233`*^9, {3.638613650524602*^9, 3.63861368019837*^9}, 
   3.638613752618588*^9, 3.638622421421833*^9, 3.638623259654512*^9, 
   3.638623682719574*^9, 3.63862387089994*^9, 3.638681839413598*^9, 
   3.638685147339924*^9, 3.638686835296649*^9, 3.638702823739684*^9, 
   3.6387045306445217`*^9, 3.638707583603277*^9, 3.638708179320146*^9, 
   3.638708280154018*^9, 3.638712313990831*^9, 3.638714885676031*^9, 
   3.6387158722970467`*^9, 3.6387688476652308`*^9, 3.6398203261482677`*^9, 
   3.641555449377819*^9, 3.641555863256626*^9, 3.641556195644968*^9, 
   3.641556872703511*^9, {3.675577313538183*^9, 3.675577342032565*^9}, 
   3.6761155889016047`*^9, 3.676198861996129*^9, 3.676199452903678*^9, 
   3.676202111206843*^9, 3.676286210935853*^9, 3.676286782752118*^9, 
   3.6762869143369417`*^9, 3.714900449905498*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Neglecting all terms with more than \"\>", 
   "\[InvisibleSpace]", "\<\"4\"\>", 
   "\[InvisibleSpace]", "\<\" particles.\"\>"}],
  SequenceForm["Neglecting all terms with more than ", "4", " particles."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.638612439263659*^9, 3.638612450767869*^9}, 
   3.6386128940614233`*^9, {3.638613650524602*^9, 3.63861368019837*^9}, 
   3.638613752618588*^9, 3.638622421421833*^9, 3.638623259654512*^9, 
   3.638623682719574*^9, 3.63862387089994*^9, 3.638681839413598*^9, 
   3.638685147339924*^9, 3.638686835296649*^9, 3.638702823739684*^9, 
   3.6387045306445217`*^9, 3.638707583603277*^9, 3.638708179320146*^9, 
   3.638708280154018*^9, 3.638712313990831*^9, 3.638714885676031*^9, 
   3.6387158722970467`*^9, 3.6387688476652308`*^9, 3.6398203261482677`*^9, 
   3.641555449377819*^9, 3.641555863256626*^9, 3.641556195644968*^9, 
   3.641556872703511*^9, {3.675577313538183*^9, 3.675577342032565*^9}, 
   3.6761155889016047`*^9, 3.676198861996129*^9, 3.676199452903678*^9, 
   3.676202111206843*^9, 3.676286210935853*^9, 3.676286782752118*^9, 
   3.6762869143369417`*^9, 3.714900449958639*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{{3.638612439263659*^9, 3.638612450767869*^9}, 
   3.6386128940614233`*^9, {3.638613650524602*^9, 3.63861368019837*^9}, 
   3.638613752618588*^9, 3.638622421421833*^9, 3.638623259654512*^9, 
   3.638623682719574*^9, 3.63862387089994*^9, 3.638681839413598*^9, 
   3.638685147339924*^9, 3.638686835296649*^9, 3.638702823739684*^9, 
   3.6387045306445217`*^9, 3.638707583603277*^9, 3.638708179320146*^9, 
   3.638708280154018*^9, 3.638712313990831*^9, 3.638714885676031*^9, 
   3.6387158722970467`*^9, 3.6387688476652308`*^9, 3.6398203261482677`*^9, 
   3.641555449377819*^9, 3.641555863256626*^9, 3.641556195644968*^9, 
   3.641556872703511*^9, {3.675577313538183*^9, 3.675577342032565*^9}, 
   3.6761155889016047`*^9, 3.676198861996129*^9, 3.676199452903678*^9, 
   3.676202111206843*^9, 3.676286210935853*^9, 3.676286782752118*^9, 
   3.6762869143369417`*^9, 3.714900462610385*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "22", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{17., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "22", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  22, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 22, "."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.638612439263659*^9, 3.638612450767869*^9}, 
   3.6386128940614233`*^9, {3.638613650524602*^9, 3.63861368019837*^9}, 
   3.638613752618588*^9, 3.638622421421833*^9, 3.638623259654512*^9, 
   3.638623682719574*^9, 3.63862387089994*^9, 3.638681839413598*^9, 
   3.638685147339924*^9, 3.638686835296649*^9, 3.638702823739684*^9, 
   3.6387045306445217`*^9, 3.638707583603277*^9, 3.638708179320146*^9, 
   3.638708280154018*^9, 3.638712313990831*^9, 3.638714885676031*^9, 
   3.6387158722970467`*^9, 3.6387688476652308`*^9, 3.6398203261482677`*^9, 
   3.641555449377819*^9, 3.641555863256626*^9, 3.641556195644968*^9, 
   3.641556872703511*^9, {3.675577313538183*^9, 3.675577342032565*^9}, 
   3.6761155889016047`*^9, 3.676198861996129*^9, 3.676199452903678*^9, 
   3.676202111206843*^9, 3.676286210935853*^9, 3.676286782752118*^9, 
   3.6762869143369417`*^9, 3.71490046268232*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"22", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[22, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{{3.638612439263659*^9, 3.638612450767869*^9}, 
   3.6386128940614233`*^9, {3.638613650524602*^9, 3.63861368019837*^9}, 
   3.638613752618588*^9, 3.638622421421833*^9, 3.638623259654512*^9, 
   3.638623682719574*^9, 3.63862387089994*^9, 3.638681839413598*^9, 
   3.638685147339924*^9, 3.638686835296649*^9, 3.638702823739684*^9, 
   3.6387045306445217`*^9, 3.638707583603277*^9, 3.638708179320146*^9, 
   3.638708280154018*^9, 3.638712313990831*^9, 3.638714885676031*^9, 
   3.6387158722970467`*^9, 3.6387688476652308`*^9, 3.6398203261482677`*^9, 
   3.641555449377819*^9, 3.641555863256626*^9, 3.641556195644968*^9, 
   3.641556872703511*^9, {3.675577313538183*^9, 3.675577342032565*^9}, 
   3.6761155889016047`*^9, 3.676198861996129*^9, 3.676199452903678*^9, 
   3.676202111206843*^9, 3.676286210935853*^9, 3.676286782752118*^9, 
   3.6762869143369417`*^9, 3.714900469803011*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"AlpFRSimp", "=", 
   RowBox[{
    RowBox[{"AlpFR", "//", "Simplify"}], "//", 
    RowBox[{
     RowBox[{"Collect", "[", 
      RowBox[{"#", ",", 
       RowBox[{"{", 
        SubscriptBox["\[Epsilon]", "_"], "}"}], ",", "FullSimplify"}], "]"}], 
     "&"}]}]}], ";", 
  RowBox[{"AlpFRSimp", "//", "TableForm"}]}]], "Input",
 CellChangeTimes->{{3.638613750408924*^9, 3.638613917314427*^9}, {
   3.6386139618919573`*^9, 3.6386140242555027`*^9}, {3.638614110850162*^9, 
   3.63861411992393*^9}, {3.6386142738449593`*^9, 3.638614464079233*^9}, {
   3.638622495805666*^9, 3.6386224999713*^9}, {3.638622681020277*^9, 
   3.6386226879638844`*^9}, {3.638622722309443*^9, 3.6386227454282093`*^9}, {
   3.638623669647767*^9, 3.638623670261174*^9}, 3.638682708207778*^9, {
   3.638700133618009*^9, 3.638700136676296*^9}, {3.638702929466498*^9, 
   3.638702931898744*^9}, {3.6387030695743713`*^9, 3.6387031130558977`*^9}, {
   3.638703151342684*^9, 3.638703247383995*^9}, {3.638703282975972*^9, 
   3.638703379857666*^9}, {3.6387160628081417`*^9, 3.638716079998055*^9}, {
   3.638716121793007*^9, 3.638716206718704*^9}, {3.676115591639645*^9, 
   3.6761155983649282`*^9}, {3.676199742374304*^9, 3.676199767888208*^9}, 
   3.676286209033051*^9}],

Cell[BoxData[
 InterpretationBox[GridBox[{
    {GridBox[{
       {"A", "1"},
       {"ALP", "2"},
       {"H", "3"},
       {"H", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["b", "3"], " ", 
           SubscriptBox["c", "3"], " ", 
           SubscriptBox["c", "w"]}], "+", 
          RowBox[{
           SubscriptBox["b", "10"], " ", 
           SubscriptBox["c", "10"], " ", 
           SubscriptBox["s", "w"]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "3", 
              SubscriptBox["\<\"\[Mu]\"\>", "1"]], "+", 
             SubsuperscriptBox["\<\"p\"\>", "4", 
              SubscriptBox["\<\"\[Mu]\"\>", "1"]]}], ")"}], " ", 
           RowBox[{
            SubscriptBox["\<\"p\"\>", "1"], ".", 
            SubscriptBox["p", "2"]}]}], "-", 
          RowBox[{
           SubsuperscriptBox["\<\"p\"\>", "2", 
            SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubscriptBox["\<\"p\"\>", "1"], ".", 
              SubscriptBox["p", "3"]}], "+", 
             RowBox[{
              SubscriptBox["\<\"p\"\>", "1"], ".", 
              SubscriptBox["p", "4"]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"2", " ", 
        SubscriptBox["f", "a"], " ", "\[Pi]", " ", 
        SuperscriptBox["vev", "2"]}]]}]},
    {GridBox[{
       {"A", "1"},
       {"ALP", "2"},
       {"H", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "3"], " ", 
          SubscriptBox["c", "3"], " ", 
          SubscriptBox["c", "w"]}], "+", 
         RowBox[{
          SubscriptBox["a", "10"], " ", 
          SubscriptBox["c", "10"], " ", 
          SubscriptBox["s", "w"]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           SubsuperscriptBox["\<\"p\"\>", "3", 
            SubscriptBox["\<\"\[Mu]\"\>", "1"]]}], " ", 
          RowBox[{
           SubscriptBox["\<\"p\"\>", "1"], ".", 
           SubscriptBox["p", "2"]}]}], "+", 
         RowBox[{
          SubsuperscriptBox["\<\"p\"\>", "2", 
           SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
          RowBox[{
           SubscriptBox["\<\"p\"\>", "1"], ".", 
           SubscriptBox["p", "3"]}]}]}], ")"}]}], 
      RowBox[{"2", " ", 
       SubscriptBox["f", "a"], " ", "\[Pi]", " ", "vev"}]]},
    {GridBox[{
       {"ALP", "1"},
       {"H", "2"},
       {"H", "3"},
       {"Z", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubsuperscriptBox["\<\"p\"\>", "3", 
            SubscriptBox["\<\"\[Mu]\"\>", "4"]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubscriptBox["b", "11"], " ", 
              SubscriptBox["c", "11"], " ", 
              RowBox[{
               SubscriptBox["\<\"p\"\>", "1"], ".", 
               SubscriptBox["p", "1"]}]}], "+", 
             RowBox[{"2", " ", 
              SubscriptBox["a", "16"], " ", 
              TemplateBox[{"a","16","\[Prime]"},
               "Subsuperscript"], " ", 
              SubscriptBox["c", "16"], " ", 
              RowBox[{
               SubscriptBox["\<\"p\"\>", "1"], ".", 
               SubscriptBox["p", "2"]}]}], "+", 
             RowBox[{
              SubscriptBox["b", "14"], " ", 
              SubscriptBox["c", "14"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SubscriptBox["\<\"p\"\>", "1"], ".", 
                 SubscriptBox["p", "2"]}], "+", 
                RowBox[{
                 SubscriptBox["\<\"p\"\>", "1"], ".", 
                 SubscriptBox["p", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{
           SubsuperscriptBox["\<\"p\"\>", "2", 
            SubscriptBox["\<\"\[Mu]\"\>", "4"]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubscriptBox["b", "11"], " ", 
              SubscriptBox["c", "11"], " ", 
              RowBox[{
               SubscriptBox["\<\"p\"\>", "1"], ".", 
               SubscriptBox["p", "1"]}]}], "+", 
             RowBox[{"2", " ", 
              SubscriptBox["a", "16"], " ", 
              TemplateBox[{"a","16","\[Prime]"},
               "Subsuperscript"], " ", 
              SubscriptBox["c", "16"], " ", 
              RowBox[{
               SubscriptBox["\<\"p\"\>", "1"], ".", 
               SubscriptBox["p", "3"]}]}], "+", 
             RowBox[{
              SubscriptBox["b", "14"], " ", 
              SubscriptBox["c", "14"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SubscriptBox["\<\"p\"\>", "1"], ".", 
                 SubscriptBox["p", "2"]}], "+", 
                RowBox[{
                 SubscriptBox["\<\"p\"\>", "1"], ".", 
                 SubscriptBox["p", "3"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       "+", 
       RowBox[{"4", " ", "\[Pi]", " ", 
        SubscriptBox["s", "w"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["b", "3"], " ", 
           SubscriptBox["c", "3"], " ", 
           SubscriptBox["c", "w"], " ", 
           SubscriptBox["s", "w"]}], "+", 
          RowBox[{
           SubscriptBox["b", "10"], " ", 
           SubscriptBox["c", "10"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SubsuperscriptBox["s", "w", "2"]}], ")"}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          SubsuperscriptBox["\<\"p\"\>", "2", 
           SubscriptBox["\<\"\[Mu]\"\>", "4"]], "+", 
          SubsuperscriptBox["\<\"p\"\>", "3", 
           SubscriptBox["\<\"\[Mu]\"\>", "4"]]}], ")"}], " ", 
        RowBox[{
         SubscriptBox["\<\"p\"\>", "1"], ".", 
         SubscriptBox["p", "4"]}]}], "-", 
       RowBox[{
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SubscriptBox["b", 
            RowBox[{"2", " ", "D"}]], " ", 
           SubscriptBox["c", 
            RowBox[{"2", " ", "D"}]], " ", "e", " ", 
           SuperscriptBox["\[Pi]", "2"], " ", 
           SuperscriptBox["vev", "2"]}], "-", 
          RowBox[{"e", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubscriptBox["b", "17"], " ", 
              SubscriptBox["c", "17"], " ", 
              RowBox[{
               SubscriptBox["\<\"p\"\>", "1"], ".", 
               SubscriptBox["p", "1"]}]}], "+", 
             RowBox[{
              SubscriptBox["b", "12"], " ", 
              SubscriptBox["c", "12"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SubscriptBox["\<\"p\"\>", "1"], ".", 
                 SubscriptBox["p", "2"]}], "+", 
                RowBox[{
                 SubscriptBox["\<\"p\"\>", "1"], ".", 
                 SubscriptBox["p", "3"]}]}], ")"}]}], "+", 
             RowBox[{"4", " ", 
              SubscriptBox["a", "15"], " ", 
              TemplateBox[{"a","15","\[Prime]"},
               "Subsuperscript"], " ", 
              SubscriptBox["c", "15"], " ", 
              RowBox[{
               SubscriptBox["\<\"p\"\>", "2"], ".", 
               SubscriptBox["p", "3"]}]}], "+", 
             RowBox[{
              SubscriptBox["b", "13"], " ", 
              SubscriptBox["c", "13"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SubscriptBox["\<\"p\"\>", "2"], ".", 
                 SubscriptBox["p", "2"]}], "+", 
                RowBox[{"2", " ", 
                 RowBox[{
                  SubscriptBox["\<\"p\"\>", "2"], ".", 
                  SubscriptBox["p", "3"]}]}], "+", 
                RowBox[{
                 SubscriptBox["\<\"p\"\>", "3"], ".", 
                 SubscriptBox["p", "3"]}]}], ")"}]}]}], ")"}]}], "+", 
          RowBox[{"4", " ", "\[Pi]", " ", 
           SubscriptBox["s", "w"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubscriptBox["b", "3"], " ", 
              SubscriptBox["c", "3"], " ", 
              SubscriptBox["c", "w"], " ", 
              SubscriptBox["s", "w"]}], "+", 
             RowBox[{
              SubscriptBox["b", "10"], " ", 
              SubscriptBox["c", "10"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SubsuperscriptBox["s", "w", "2"]}], ")"}]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubscriptBox["\<\"p\"\>", "2"], ".", 
              SubscriptBox["p", "4"]}], "+", 
             RowBox[{
              SubscriptBox["\<\"p\"\>", "3"], ".", 
              SubscriptBox["p", "4"]}]}], ")"}]}]}], ")"}]}]}], 
      RowBox[{"8", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["f", "a"], " ", 
       SuperscriptBox["\[Pi]", "2"], " ", 
       SubscriptBox["s", "w"], " ", 
       SuperscriptBox["vev", "2"]}]]},
    {GridBox[{
       {"ALP", "1"},
       {"H", "2"},
       {"Z", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{
       RowBox[{
        SubsuperscriptBox["\<\"p\"\>", "2", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["a", "11"], " ", 
           SubscriptBox["c", "11"], " ", "e", " ", 
           RowBox[{
            SubscriptBox["\<\"p\"\>", "1"], ".", 
            SubscriptBox["p", "1"]}]}], "+", 
          RowBox[{
           SubscriptBox["a", "14"], " ", 
           SubscriptBox["c", "14"], " ", "e", " ", 
           RowBox[{
            SubscriptBox["\<\"p\"\>", "1"], ".", 
            SubscriptBox["p", "2"]}]}], "+", 
          RowBox[{"4", " ", "\[Pi]", " ", 
           SubscriptBox["s", "w"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubscriptBox["a", "3"], " ", 
              SubscriptBox["c", "3"], " ", 
              SubscriptBox["c", "w"], " ", 
              SubscriptBox["s", "w"]}], "+", 
             RowBox[{
              SubscriptBox["a", "10"], " ", 
              SubscriptBox["c", "10"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SubsuperscriptBox["s", "w", "2"]}], ")"}]}]}], ")"}], " ", 
           RowBox[{
            SubscriptBox["\<\"p\"\>", "1"], ".", 
            SubscriptBox["p", "3"]}]}]}], ")"}]}], "+", 
       RowBox[{
        SubsuperscriptBox["\<\"p\"\>", "1", 
         SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"e", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "16"}], " ", 
              SubscriptBox["a", 
               RowBox[{"2", " ", "D"}]], " ", 
              SubscriptBox["c", 
               RowBox[{"2", " ", "D"}]], " ", 
              SuperscriptBox["\[Pi]", "2"], " ", 
              SuperscriptBox["vev", "2"]}], "+", 
             RowBox[{
              SubscriptBox["a", "17"], " ", 
              SubscriptBox["c", "17"], " ", 
              RowBox[{
               SubscriptBox["\<\"p\"\>", "1"], ".", 
               SubscriptBox["p", "1"]}]}], "+", 
             RowBox[{
              SubscriptBox["a", "12"], " ", 
              SubscriptBox["c", "12"], " ", 
              RowBox[{
               SubscriptBox["\<\"p\"\>", "1"], ".", 
               SubscriptBox["p", "2"]}]}], "+", 
             RowBox[{
              SubscriptBox["a", "13"], " ", 
              SubscriptBox["c", "13"], " ", 
              RowBox[{
               SubscriptBox["\<\"p\"\>", "2"], ".", 
               SubscriptBox["p", "2"]}]}]}], ")"}]}], "-", 
          RowBox[{"4", " ", "\[Pi]", " ", 
           SubscriptBox["s", "w"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubscriptBox["a", "3"], " ", 
              SubscriptBox["c", "3"], " ", 
              SubscriptBox["c", "w"], " ", 
              SubscriptBox["s", "w"]}], "+", 
             RowBox[{
              SubscriptBox["a", "10"], " ", 
              SubscriptBox["c", "10"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SubsuperscriptBox["s", "w", "2"]}], ")"}]}]}], ")"}], " ", 
           RowBox[{
            SubscriptBox["\<\"p\"\>", "2"], ".", 
            SubscriptBox["p", "3"]}]}]}], ")"}]}]}], 
      RowBox[{"8", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["f", "a"], " ", 
       SuperscriptBox["\[Pi]", "2"], " ", 
       SubscriptBox["s", "w"], " ", "vev"}]]},
    {GridBox[{
       {"A", "1"},
       {"A", "2"},
       {"ALP", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"2", " ", "\[ImaginaryI]", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           SubscriptBox["c", 
            OverscriptBox["B", "~"]]}], "+", 
          RowBox[{
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["c", 
              OverscriptBox["B", "~"]], "-", 
             SubscriptBox["c", 
              OverscriptBox["W", "~"]]}], ")"}], " ", 
           SubsuperscriptBox["s", "w", "2"]}]}], ")"}], " ", 
        SubscriptBox["\[Epsilon]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", "mu$1", ",", "mu$2"}]], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubsuperscriptBox["\<\"p\"\>", "1", "mu$2"], " ", 
           SubsuperscriptBox["\<\"p\"\>", "2", "mu$1"]}], "-", 
          RowBox[{
           SubsuperscriptBox["\<\"p\"\>", "1", "mu$1"], " ", 
           SubsuperscriptBox["\<\"p\"\>", "2", "mu$2"]}]}], ")"}]}], 
       SubscriptBox["f", "a"]]}]},
    {GridBox[{
       {"ALP", "1"},
       {"G", "2"},
       {"G", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", 
       SubscriptBox["c", 
        OverscriptBox["G", "~"]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["\[Epsilon]", 
           RowBox[{
            SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "\[Alpha]1", ",", 
            "\[Beta]1"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Beta]1"], " ", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Alpha]1"]}], "-", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Alpha]1"], " ", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Beta]1"]}]}], ")"}]}], 
         "+", 
         RowBox[{
          SubscriptBox["\[Epsilon]", 
           RowBox[{
            SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "\[Gamma]1", ",", 
            "\[Beta]1"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SubsuperscriptBox["\<\"p\"\>", "2", "\[Gamma]1"]}], " ", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Beta]1"]}], "+", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Beta]1"], " ", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Gamma]1"]}]}], ")"}]}], 
         "+", 
         RowBox[{
          SubscriptBox["\[Epsilon]", 
           RowBox[{
            SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "\[Alpha]1", ",", 
            "\[Delta]1"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Delta]1"], " ", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Alpha]1"]}], "-", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Alpha]1"], " ", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Delta]1"]}]}], ")"}]}], 
         "+", 
         RowBox[{
          SubscriptBox["\[Epsilon]", 
           RowBox[{
            SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "\[Gamma]1", ",", 
            "\[Delta]1"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Delta]1"], " ", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Gamma]1"]}], "-", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Gamma]1"], " ", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Delta]1"]}]}], ")"}]}]}], 
        ")"}], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"a\"\>", "2"], ",", 
         SubscriptBox["\<\"a\"\>", "3"]}]]}], 
      RowBox[{"2", " ", 
       SubscriptBox["f", "a"]}]]},
    {GridBox[{
       {"ALP", "1"},
       {"W", "2"},
       {
        SuperscriptBox["W", "\[Dagger]"], "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{
       RowBox[{"2", " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
        SubscriptBox["s", "w"], " ", 
        SubscriptBox["\[Epsilon]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1", ",", "mu$2"}]], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["c", "2"], " ", "e", " ", 
           SubsuperscriptBox["\<\"p\"\>", "1", "mu$1"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SubsuperscriptBox["\<\"p\"\>", "2", "mu$2"]}], "+", 
             SubsuperscriptBox["\<\"p\"\>", "3", "mu$2"]}], ")"}]}], "+", 
          RowBox[{"16", " ", 
           SubscriptBox["c", 
            OverscriptBox["W", "~"]], " ", "\[Pi]", " ", 
           SubscriptBox["s", "w"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubsuperscriptBox["\<\"p\"\>", "2", "mu$2"], " ", 
              SubsuperscriptBox["\<\"p\"\>", "3", "mu$1"]}], "-", 
             RowBox[{
              SubsuperscriptBox["\<\"p\"\>", "2", "mu$1"], " ", 
              SubsuperscriptBox["\<\"p\"\>", "3", "mu$2"]}]}], ")"}]}]}], 
         ")"}]}], "-", 
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubsuperscriptBox["\<\"p\"\>", "1", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubscriptBox["c", "8"], " ", "e", " ", 
              SubsuperscriptBox["\<\"p\"\>", "2", 
               SubscriptBox["\<\"\[Mu]\"\>", "2"]]}], "+", 
             RowBox[{"4", " ", 
              SubscriptBox["c", "6"], " ", "\[Pi]", " ", 
              SubscriptBox["s", "w"], " ", 
              SubsuperscriptBox["\<\"p\"\>", "3", 
               SubscriptBox["\<\"\[Mu]\"\>", "2"]]}]}], ")"}]}], "-", 
          RowBox[{
           SubsuperscriptBox["\<\"p\"\>", "1", 
            SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", 
              SubscriptBox["c", "6"], " ", "\[Pi]", " ", 
              SubscriptBox["s", "w"], " ", 
              SubsuperscriptBox["\<\"p\"\>", "2", 
               SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
             RowBox[{
              SubscriptBox["c", "8"], " ", "e", " ", 
              SubsuperscriptBox["\<\"p\"\>", "3", 
               SubscriptBox["\<\"\[Mu]\"\>", "3"]]}]}], ")"}]}], "+", 
          RowBox[{"4", " ", 
           SubscriptBox["c", "6"], " ", "\[Pi]", " ", 
           SubscriptBox["s", "w"], " ", 
           SubscriptBox["\[Eta]", 
            RowBox[{
             SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "3"]}]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubscriptBox["\<\"p\"\>", "1"], ".", 
              SubscriptBox["p", "2"]}], "-", 
             RowBox[{
              SubscriptBox["\<\"p\"\>", "1"], ".", 
              SubscriptBox["p", "3"]}]}], ")"}]}]}], ")"}]}]}], 
      RowBox[{"16", " ", 
       SubscriptBox["f", "a"], " ", 
       SuperscriptBox["\[Pi]", "2"], " ", 
       SubsuperscriptBox["s", "w", "2"]}]]},
    {GridBox[{
       {"A", "1"},
       {"ALP", "2"},
       {"Z", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Epsilon]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1", ",", "mu$2"}]], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubsuperscriptBox["\<\"p\"\>", "1", "mu$2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"e", " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"2", " ", 
                 SubscriptBox["c", "1"], " ", 
                 SubscriptBox["c", "w"]}], "+", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   SubscriptBox["c", "2"], "+", 
                   RowBox[{"2", " ", 
                    SubscriptBox["c", "7"]}]}], ")"}], " ", 
                 SubscriptBox["s", "w"]}]}], ")"}], " ", 
              SubsuperscriptBox["\<\"p\"\>", "2", "mu$1"]}], "-", 
             RowBox[{"16", " ", 
              RowBox[{"(", 
               RowBox[{
                SubscriptBox["c", 
                 OverscriptBox["B", "~"]], "-", 
                SubscriptBox["c", 
                 OverscriptBox["W", "~"]]}], ")"}], " ", "\[Pi]", " ", 
              SubsuperscriptBox["s", "w", "2"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", "1"}], "+", 
                SubsuperscriptBox["s", "w", "2"]}], ")"}], " ", 
              SubsuperscriptBox["\<\"p\"\>", "3", "mu$1"]}]}], ")"}]}], "+", 
          RowBox[{"16", " ", 
           RowBox[{"(", 
            RowBox[{
             SubscriptBox["c", 
              OverscriptBox["B", "~"]], "-", 
             SubscriptBox["c", 
              OverscriptBox["W", "~"]]}], ")"}], " ", "\[Pi]", " ", 
           SubsuperscriptBox["s", "w", "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             SubsuperscriptBox["s", "w", "2"]}], ")"}], " ", 
           SubsuperscriptBox["\<\"p\"\>", "1", "mu$1"], " ", 
           SubsuperscriptBox["\<\"p\"\>", "3", "mu$2"]}]}], ")"}]}], 
       RowBox[{"8", " ", 
        SubscriptBox["c", "w"], " ", 
        SubscriptBox["f", "a"], " ", "\[Pi]", " ", 
        SubscriptBox["s", "w"]}]]}]},
    {GridBox[{
       {"ALP", "1"},
       {"Z", "2"},
       {"Z", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", 
        SubscriptBox["\[Epsilon]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1", ",", "mu$2"}]], 
        " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"e", " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubscriptBox["c", "2"], " ", 
              SubscriptBox["c", "w"]}], "+", 
             RowBox[{"2", " ", 
              SubscriptBox["c", "7"], " ", 
              SubscriptBox["c", "w"]}], "-", 
             RowBox[{"2", " ", 
              SubscriptBox["c", "1"], " ", 
              SubscriptBox["s", "w"]}]}], ")"}], " ", 
           SubsuperscriptBox["\<\"p\"\>", "1", "mu$1"], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "mu$2"], "-", 
             SubsuperscriptBox["\<\"p\"\>", "3", "mu$2"]}], ")"}]}], "+", 
          RowBox[{"16", " ", 
           SubscriptBox["c", "w"], " ", "\[Pi]", " ", 
           SubscriptBox["s", "w"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"-", 
              SubscriptBox["c", 
               OverscriptBox["W", "~"]]}], "+", 
             RowBox[{
              RowBox[{"(", 
               RowBox[{
                RowBox[{"-", 
                 SubscriptBox["c", 
                  OverscriptBox["B", "~"]]}], "+", 
                SubscriptBox["c", 
                 OverscriptBox["W", "~"]]}], ")"}], " ", 
              SubsuperscriptBox["s", "w", "2"]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubsuperscriptBox["\<\"p\"\>", "2", "mu$2"], " ", 
              SubsuperscriptBox["\<\"p\"\>", "3", "mu$1"]}], "-", 
             RowBox[{
              SubsuperscriptBox["\<\"p\"\>", "2", "mu$1"], " ", 
              SubsuperscriptBox["\<\"p\"\>", "3", "mu$2"]}]}], ")"}]}]}], 
         ")"}]}], 
       RowBox[{"8", " ", 
        SubscriptBox["c", "w"], " ", 
        SubscriptBox["f", "a"], " ", "\[Pi]", " ", 
        SubscriptBox["s", "w"]}]]}]},
    {GridBox[{
       {"ALP", "1"},
       {"G", "2"},
       {"G", "3"},
       {"G", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SubscriptBox["c", 
         OverscriptBox["G", "~"]], " ", 
        SubscriptBox["g", "s"], " ", 
        SubscriptBox["f", 
         RowBox[{
          SubscriptBox["\<\"a\"\>", "2"], ",", 
          SubscriptBox["\<\"a\"\>", "3"], ",", 
          SubscriptBox["\<\"a\"\>", "4"]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubscriptBox["\[Epsilon]", 
            RowBox[{
             SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", "\[Alpha]1"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Alpha]1"], "+", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Alpha]1"], "+", 
             SubsuperscriptBox["\<\"p\"\>", "4", "\[Alpha]1"]}], ")"}]}], "+", 
          RowBox[{
           SubscriptBox["\[Epsilon]", 
            RowBox[{
             SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", "\[Beta]1"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Beta]1"], "+", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Beta]1"], "+", 
             SubsuperscriptBox["\<\"p\"\>", "4", "\[Beta]1"]}], ")"}]}], "+", 
          
          RowBox[{
           SubscriptBox["\[Epsilon]", 
            RowBox[{
             SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", "\[Gamma]1"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Gamma]1"], "+", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Gamma]1"], "+", 
             SubsuperscriptBox["\<\"p\"\>", "4", "\[Gamma]1"]}], ")"}]}], "+", 
          RowBox[{
           SubscriptBox["\[Epsilon]", 
            RowBox[{
             SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
             SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", "\[Delta]1"}]], " ", 
           RowBox[{"(", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", "\[Delta]1"], "+", 
             SubsuperscriptBox["\<\"p\"\>", "3", "\[Delta]1"], "+", 
             SubsuperscriptBox["\<\"p\"\>", "4", "\[Delta]1"]}], ")"}]}]}], 
         ")"}]}], 
       SubscriptBox["f", "a"]]}]},
    {GridBox[{
       {
        OverscriptBox["dq", "\<\"-\"\>"], "1"},
       {"dq", "2"},
       {"ALP", "3"},
       {"H", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SubscriptBox["a", "D"], " ", 
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SubscriptBox["c", 
            RowBox[{"2", " ", "D"}]], " ", 
           SuperscriptBox["\[Pi]", "2"], " ", 
           SuperscriptBox["vev", "2"]}], "-", 
          RowBox[{
           SubscriptBox["c", "17"], " ", 
           RowBox[{
            SubscriptBox["\<\"p\"\>", "3"], ".", 
            SubscriptBox["p", "3"]}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubsuperscriptBox[
            RowBox[{"(", 
             TemplateBox[{"V","CKM"},
              "Superscript"], ")"}], 
            RowBox[{
             SubscriptBox["\<\"f\"\>", "2"], ",", 
             "Generation$1"}], "\<\"*\"\>"], " ", 
           SubsuperscriptBox[
            RowBox[{"(", 
             TemplateBox[{"y","d"},
              "Superscript"], ")"}], 
            RowBox[{"Generation$1", ",", 
             SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
           SubscriptBox[
            SubscriptBox["P", "\<\"-\"\>"], 
            RowBox[{
             SubscriptBox["\<\"s\"\>", "1"], ",", 
             SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
          RowBox[{
           SubscriptBox[
            TemplateBox[{"V","CKM"},
             "Superscript"], 
            RowBox[{
             SubscriptBox["\<\"f\"\>", "1"], ",", "Generation$1"}]], " ", 
           SubscriptBox[
            SubscriptBox["P", "\<\"+\"\>"], 
            RowBox[{
             SubscriptBox["\<\"s\"\>", "1"], ",", 
             SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
           SubscriptBox[
            TemplateBox[{"y","d"},
             "Superscript"], 
            RowBox[{"Generation$1", ",", 
             SubscriptBox["\<\"f\"\>", "2"]}]]}]}], ")"}]}], 
       RowBox[{"4", " ", 
        SqrtBox["2"], " ", 
        SubscriptBox["f", "a"], " ", 
        SuperscriptBox["\[Pi]", "2"], " ", 
        SuperscriptBox["vev", "2"]}]]}]},
    {GridBox[{
       {
        OverscriptBox["dq", "\<\"-\"\>"], "1"},
       {"dq", "2"},
       {"ALP", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SubscriptBox["\[Delta]", 
         RowBox[{
          SubscriptBox["\<\"m\"\>", "1"], ",", 
          SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SubscriptBox["c", 
            RowBox[{"2", " ", "D"}]], " ", 
           SuperscriptBox["\[Pi]", "2"], " ", 
           SuperscriptBox["vev", "2"]}], "-", 
          RowBox[{
           SubscriptBox["c", "17"], " ", 
           RowBox[{
            SubscriptBox["\<\"p\"\>", "3"], ".", 
            SubscriptBox["p", "3"]}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubsuperscriptBox[
            RowBox[{"(", 
             TemplateBox[{"V","CKM"},
              "Superscript"], ")"}], 
            RowBox[{
             SubscriptBox["\<\"f\"\>", "2"], ",", 
             "Generation$1"}], "\<\"*\"\>"], " ", 
           SubsuperscriptBox[
            RowBox[{"(", 
             TemplateBox[{"y","d"},
              "Superscript"], ")"}], 
            RowBox[{"Generation$1", ",", 
             SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
           SubscriptBox[
            SubscriptBox["P", "\<\"-\"\>"], 
            RowBox[{
             SubscriptBox["\<\"s\"\>", "1"], ",", 
             SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
          RowBox[{
           SubscriptBox[
            TemplateBox[{"V","CKM"},
             "Superscript"], 
            RowBox[{
             SubscriptBox["\<\"f\"\>", "1"], ",", "Generation$1"}]], " ", 
           SubscriptBox[
            SubscriptBox["P", "\<\"+\"\>"], 
            RowBox[{
             SubscriptBox["\<\"s\"\>", "1"], ",", 
             SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
           SubscriptBox[
            TemplateBox[{"y","d"},
             "Superscript"], 
            RowBox[{"Generation$1", ",", 
             SubscriptBox["\<\"f\"\>", "2"]}]]}]}], ")"}]}], 
       RowBox[{"8", " ", 
        SqrtBox["2"], " ", 
        SubscriptBox["f", "a"], " ", 
        SuperscriptBox["\[Pi]", "2"], " ", "vev"}]]}]},
    {GridBox[{
       {
        OverscriptBox["l", "\<\"-\"\>"], "1"},
       {"l", "2"},
       {"ALP", "3"},
       {"H", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        SubscriptBox["a", "L"], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SubscriptBox["c", 
            RowBox[{"2", " ", "D"}]], " ", 
           SuperscriptBox["\[Pi]", "2"], " ", 
           SuperscriptBox["vev", "2"]}], "-", 
          RowBox[{
           SubscriptBox["c", "17"], " ", 
           RowBox[{
            SubscriptBox["\<\"p\"\>", "3"], ".", 
            SubscriptBox["p", "3"]}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubsuperscriptBox[
            RowBox[{"(", 
             TemplateBox[{"y","l"},
              "Superscript"], ")"}], 
            RowBox[{
             SubscriptBox["\<\"f\"\>", "2"], ",", 
             SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
           SubscriptBox[
            SubscriptBox["P", "\<\"-\"\>"], 
            RowBox[{
             SubscriptBox["\<\"s\"\>", "1"], ",", 
             SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
          RowBox[{
           SubscriptBox[
            SubscriptBox["P", "\<\"+\"\>"], 
            RowBox[{
             SubscriptBox["\<\"s\"\>", "1"], ",", 
             SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
           SubscriptBox[
            TemplateBox[{"y","l"},
             "Superscript"], 
            RowBox[{
             SubscriptBox["\<\"f\"\>", "1"], ",", 
             SubscriptBox["\<\"f\"\>", "2"]}]]}]}], ")"}]}], 
       RowBox[{"4", " ", 
        SqrtBox["2"], " ", 
        SubscriptBox["f", "a"], " ", 
        SuperscriptBox["\[Pi]", "2"], " ", 
        SuperscriptBox["vev", "2"]}]]}]},
    {GridBox[{
       {
        OverscriptBox["l", "\<\"-\"\>"], "1"},
       {"l", "2"},
       {"ALP", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{"16", " ", 
           SubscriptBox["c", 
            RowBox[{"2", " ", "D"}]], " ", 
           SuperscriptBox["\[Pi]", "2"], " ", 
           SuperscriptBox["vev", "2"]}], "-", 
          RowBox[{
           SubscriptBox["c", "17"], " ", 
           RowBox[{
            SubscriptBox["\<\"p\"\>", "3"], ".", 
            SubscriptBox["p", "3"]}]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubsuperscriptBox[
            RowBox[{"(", 
             TemplateBox[{"y","l"},
              "Superscript"], ")"}], 
            RowBox[{
             SubscriptBox["\<\"f\"\>", "2"], ",", 
             SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
           SubscriptBox[
            SubscriptBox["P", "\<\"-\"\>"], 
            RowBox[{
             SubscriptBox["\<\"s\"\>", "1"], ",", 
             SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
          RowBox[{
           SubscriptBox[
            SubscriptBox["P", "\<\"+\"\>"], 
            RowBox[{
             SubscriptBox["\<\"s\"\>", "1"], ",", 
             SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
           SubscriptBox[
            TemplateBox[{"y","l"},
             "Superscript"], 
            RowBox[{
             SubscriptBox["\<\"f\"\>", "1"], ",", 
             SubscriptBox["\<\"f\"\>", "2"]}]]}]}], ")"}]}], 
       RowBox[{"8", " ", 
        SqrtBox["2"], " ", 
        SubscriptBox["f", "a"], " ", 
        SuperscriptBox["\[Pi]", "2"], " ", "vev"}]]}]},
    {GridBox[{
       {
        OverscriptBox["uq", "\<\"-\"\>"], "1"},
       {"uq", "2"},
       {"ALP", "3"},
       {"H", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{
       SubscriptBox["a", "U"], " ", 
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", 
          SubscriptBox["c", 
           RowBox[{"2", " ", "D"}]], " ", 
          SuperscriptBox["\[Pi]", "2"], " ", 
          SuperscriptBox["vev", "2"]}], "-", 
         RowBox[{
          SubscriptBox["c", "17"], " ", 
          RowBox[{
           SubscriptBox["\<\"p\"\>", "3"], ".", 
           SubscriptBox["p", "3"]}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubsuperscriptBox[
           RowBox[{"(", 
            TemplateBox[{"y","u"},
             "Superscript"], ")"}], 
           RowBox[{
            SubscriptBox["\<\"f\"\>", "2"], ",", 
            SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
          SubscriptBox[
           SubscriptBox["P", "\<\"-\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
         RowBox[{
          SubscriptBox[
           SubscriptBox["P", "\<\"+\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
          SubscriptBox[
           TemplateBox[{"y","u"},
            "Superscript"], 
           RowBox[{
            SubscriptBox["\<\"f\"\>", "1"], ",", 
            SubscriptBox["\<\"f\"\>", "2"]}]]}]}], ")"}]}], 
      RowBox[{"4", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["f", "a"], " ", 
       SuperscriptBox["\[Pi]", "2"], " ", 
       SuperscriptBox["vev", "2"]}]]},
    {GridBox[{
       {
        OverscriptBox["uq", "\<\"-\"\>"], "1"},
       {"uq", "2"},
       {"ALP", "3"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{
       SubscriptBox["\[Delta]", 
        RowBox[{
         SubscriptBox["\<\"m\"\>", "1"], ",", 
         SubscriptBox["\<\"m\"\>", "2"]}]], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"16", " ", 
          SubscriptBox["c", 
           RowBox[{"2", " ", "D"}]], " ", 
          SuperscriptBox["\[Pi]", "2"], " ", 
          SuperscriptBox["vev", "2"]}], "-", 
         RowBox[{
          SubscriptBox["c", "17"], " ", 
          RowBox[{
           SubscriptBox["\<\"p\"\>", "3"], ".", 
           SubscriptBox["p", "3"]}]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubsuperscriptBox[
           RowBox[{"(", 
            TemplateBox[{"y","u"},
             "Superscript"], ")"}], 
           RowBox[{
            SubscriptBox["\<\"f\"\>", "2"], ",", 
            SubscriptBox["\<\"f\"\>", "1"]}], "\<\"*\"\>"], " ", 
          SubscriptBox[
           SubscriptBox["P", "\<\"-\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]]}], "-", 
         RowBox[{
          SubscriptBox[
           SubscriptBox["P", "\<\"+\"\>"], 
           RowBox[{
            SubscriptBox["\<\"s\"\>", "1"], ",", 
            SubscriptBox["\<\"s\"\>", "2"]}]], " ", 
          SubscriptBox[
           TemplateBox[{"y","u"},
            "Superscript"], 
           RowBox[{
            SubscriptBox["\<\"f\"\>", "1"], ",", 
            SubscriptBox["\<\"f\"\>", "2"]}]]}]}], ")"}]}], 
      RowBox[{"8", " ", 
       SqrtBox["2"], " ", 
       SubscriptBox["f", "a"], " ", 
       SuperscriptBox["\[Pi]", "2"], " ", "vev"}]]},
    {GridBox[{
       {"ALP", "1"},
       {"H", "2"},
       {"W", "3"},
       {
        SuperscriptBox["W", "\[Dagger]"], "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"e", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           SubsuperscriptBox["\<\"p\"\>", "1", 
            SubscriptBox["\<\"\[Mu]\"\>", "4"]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              SubscriptBox["a", "8"], " ", 
              SubscriptBox["c", "8"], " ", "e", " ", 
              SubsuperscriptBox["\<\"p\"\>", "3", 
               SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
             RowBox[{"4", " ", "\[Pi]", " ", 
              SubscriptBox["s", "w"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SubscriptBox["a", "10"], " ", 
                 SubscriptBox["c", "10"], " ", 
                 SubsuperscriptBox["\<\"p\"\>", "2", 
                  SubscriptBox["\<\"\[Mu]\"\>", "3"]]}], "+", 
                RowBox[{
                 SubscriptBox["a", "6"], " ", 
                 SubscriptBox["c", "6"], " ", 
                 SubsuperscriptBox["\<\"p\"\>", "4", 
                  SubscriptBox["\<\"\[Mu]\"\>", "3"]]}]}], ")"}]}]}], ")"}]}],
           "-", 
          RowBox[{
           SubsuperscriptBox["\<\"p\"\>", "1", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"4", " ", "\[Pi]", " ", 
              SubscriptBox["s", "w"], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SubscriptBox["a", "10"], " ", 
                 SubscriptBox["c", "10"], " ", 
                 SubsuperscriptBox["\<\"p\"\>", "2", 
                  SubscriptBox["\<\"\[Mu]\"\>", "4"]]}], "+", 
                RowBox[{
                 SubscriptBox["a", "6"], " ", 
                 SubscriptBox["c", "6"], " ", 
                 SubsuperscriptBox["\<\"p\"\>", "3", 
                  SubscriptBox["\<\"\[Mu]\"\>", "4"]]}]}], ")"}]}], "+", 
             RowBox[{
              SubscriptBox["a", "8"], " ", 
              SubscriptBox["c", "8"], " ", "e", " ", 
              SubsuperscriptBox["\<\"p\"\>", "4", 
               SubscriptBox["\<\"\[Mu]\"\>", "4"]]}]}], ")"}]}], "+", 
          RowBox[{"2", " ", "\[Pi]", " ", 
           SubscriptBox["s", "w"], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{
              RowBox[{"-", "\[ImaginaryI]"}], " ", 
              SubscriptBox["a", "2"], " ", 
              SubscriptBox["c", "2"], " ", 
              SubscriptBox["\[Epsilon]", 
               RowBox[{
                SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
                SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1", ",", 
                "mu$2"}]], " ", 
              SubsuperscriptBox["\<\"p\"\>", "1", "mu$1"], " ", 
              RowBox[{"(", 
               RowBox[{
                SubsuperscriptBox["\<\"p\"\>", "3", "mu$2"], "-", 
                SubsuperscriptBox["\<\"p\"\>", "4", "mu$2"]}], ")"}]}], "+", 
             RowBox[{"2", " ", 
              SubscriptBox["a", "6"], " ", 
              SubscriptBox["c", "6"], " ", 
              SubscriptBox["\[Eta]", 
               RowBox[{
                SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
                SubscriptBox["\<\"\[Mu]\"\>", "4"]}]], " ", 
              RowBox[{"(", 
               RowBox[{
                RowBox[{
                 SubscriptBox["\<\"p\"\>", "1"], ".", 
                 SubscriptBox["p", "3"]}], "-", 
                RowBox[{
                 SubscriptBox["\<\"p\"\>", "1"], ".", 
                 SubscriptBox["p", "4"]}]}], ")"}]}]}], ")"}]}]}], ")"}]}], 
       RowBox[{"8", " ", 
        SubscriptBox["f", "a"], " ", 
        SuperscriptBox["\[Pi]", "2"], " ", 
        SubsuperscriptBox["s", "w", "2"], " ", "vev"}]]}]},
    {GridBox[{
       {"A", "1"},
       {"ALP", "2"},
       {"W", "3"},
       {
        SuperscriptBox["W", "\[Dagger]"], "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
          SubscriptBox["s", "w"], " ", 
          SubscriptBox["\[Epsilon]", 
           RowBox[{
            SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
            SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             RowBox[{"-", 
              SubscriptBox["c", "2"]}], " ", "e", " ", 
             SubsuperscriptBox["\<\"p\"\>", "2", "mu$1"]}], "+", 
            RowBox[{"16", " ", 
             SubscriptBox["c", 
              OverscriptBox["W", "~"]], " ", "\[Pi]", " ", 
             SubscriptBox["s", "w"], " ", 
             RowBox[{"(", 
              RowBox[{
               SubsuperscriptBox["\<\"p\"\>", "1", "mu$1"], "+", 
               SubsuperscriptBox["\<\"p\"\>", "3", "mu$1"], "+", 
               SubsuperscriptBox["\<\"p\"\>", "4", "mu$1"]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"e", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SubscriptBox["c", "8"], " ", "e"}], "-", 
            RowBox[{"4", " ", 
             SubscriptBox["c", "6"], " ", "\[Pi]", " ", 
             SubscriptBox["s", "w"]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", 
              SubscriptBox["\<\"\[Mu]\"\>", "4"]], " ", 
             SubscriptBox["\[Eta]", 
              RowBox[{
               SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
               SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
            RowBox[{
             SubsuperscriptBox["\<\"p\"\>", "2", 
              SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
             SubscriptBox["\[Eta]", 
              RowBox[{
               SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
               SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}], ")"}]}], "+", 
         RowBox[{"8", " ", 
          SubscriptBox["c", "6"], " ", "e", " ", "\[Pi]", " ", 
          SubscriptBox["s", "w"], " ", 
          SubsuperscriptBox["\<\"p\"\>", "2", 
           SubscriptBox["\<\"\[Mu]\"\>", "1"]], " ", 
          SubscriptBox["\[Eta]", 
           RowBox[{
            SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
            SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}], ")"}]}], 
      RowBox[{"16", " ", 
       SubscriptBox["f", "a"], " ", 
       SuperscriptBox["\[Pi]", "2"], " ", 
       SubsuperscriptBox["s", "w", "2"]}]]},
    {GridBox[{
       {"ALP", "1"},
       {"W", "2"},
       {
        SuperscriptBox["W", "\[Dagger]"], "3"},
       {"Z", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{"e", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", "4"}], " ", "\[ImaginaryI]", " ", "\[Pi]", " ", 
          SubscriptBox["s", "w"], " ", 
          SubscriptBox["\[Epsilon]", 
           RowBox[{
            SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", 
            SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", "mu$1"}]], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"e", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"3", " ", 
                SubscriptBox["c", "2"]}], "+", 
               RowBox[{"2", " ", 
                SubscriptBox["c", "7"]}], "-", 
               RowBox[{"2", " ", 
                SubscriptBox["c", "2"], " ", 
                SubsuperscriptBox["s", "w", "2"]}]}], ")"}], " ", 
             SubsuperscriptBox["\<\"p\"\>", "1", "mu$1"]}], "+", 
            RowBox[{"32", " ", 
             SubscriptBox["c", 
              OverscriptBox["W", "~"]], " ", "\[Pi]", " ", 
             SubscriptBox["s", "w"], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{"-", "1"}], "+", 
               SubsuperscriptBox["s", "w", "2"]}], ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               SubsuperscriptBox["\<\"p\"\>", "2", "mu$1"], "+", 
               SubsuperscriptBox["\<\"p\"\>", "3", "mu$1"], "+", 
               SubsuperscriptBox["\<\"p\"\>", "4", "mu$1"]}], ")"}]}]}], 
           ")"}]}], "+", 
         RowBox[{"e", " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"2", " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SubscriptBox["c", "5"], " ", "e"}], "-", 
               RowBox[{"8", " ", 
                SubscriptBox["c", "6"], " ", "\[Pi]", " ", 
                SubscriptBox["s", "w"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"-", "1"}], "+", 
                  SubsuperscriptBox["s", "w", "2"]}], ")"}]}]}], ")"}], " ", 
             SubsuperscriptBox["\<\"p\"\>", "1", 
              SubscriptBox["\<\"\[Mu]\"\>", "4"]], " ", 
             SubscriptBox["\[Eta]", 
              RowBox[{
               SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
               SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
            RowBox[{
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SubscriptBox["c", "4"], " ", "e"}], "+", 
               RowBox[{"2", " ", 
                SubscriptBox["s", "w"], " ", 
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{
                   RowBox[{"-", 
                    SubscriptBox["c", "8"]}], " ", "e", " ", 
                   SubscriptBox["s", "w"]}], "+", 
                  RowBox[{"4", " ", 
                   SubscriptBox["c", "6"], " ", "\[Pi]", " ", 
                   RowBox[{"(", 
                    RowBox[{
                    RowBox[{"-", "1"}], "+", 
                    SubsuperscriptBox["s", "w", "2"]}], ")"}]}]}], ")"}]}]}], 
              ")"}], " ", 
             RowBox[{"(", 
              RowBox[{
               RowBox[{
                SubsuperscriptBox["\<\"p\"\>", "1", 
                 SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
                SubscriptBox["\[Eta]", 
                 RowBox[{
                  SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
                  SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
               RowBox[{
                SubsuperscriptBox["\<\"p\"\>", "1", 
                 SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
                SubscriptBox["\[Eta]", 
                 RowBox[{
                  SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
                  SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}], ")"}]}]}], 
           ")"}]}]}], ")"}]}], 
      RowBox[{"32", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["f", "a"], " ", 
       SuperscriptBox["\[Pi]", "2"], " ", 
       SubsuperscriptBox["s", "w", "3"]}]]},
    {GridBox[{
       {"A", "1"},
       {"ALP", "2"},
       {"H", "3"},
       {"Z", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     RowBox[{"-", 
      FractionBox[
       RowBox[{"\[ImaginaryI]", " ", "e", " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"2", " ", 
           SubscriptBox["a", "1"], " ", 
           SubscriptBox["c", "1"], " ", 
           SubscriptBox["c", "w"]}], "+", 
          RowBox[{
           SubscriptBox["a", "2"], " ", 
           SubscriptBox["c", "2"], " ", 
           SubscriptBox["s", "w"]}], "+", 
          RowBox[{"2", " ", 
           SubscriptBox["a", "7"], " ", 
           SubscriptBox["c", "7"], " ", 
           SubscriptBox["s", "w"]}]}], ")"}], " ", 
        SubscriptBox["\[Epsilon]", 
         RowBox[{
          SubscriptBox["\<\"\[Mu]\"\>", "1"], ",", 
          SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", "mu$1", ",", "mu$2"}]], 
        " ", 
        SubsuperscriptBox["\<\"p\"\>", "1", "mu$2"], " ", 
        SubsuperscriptBox["\<\"p\"\>", "2", "mu$1"]}], 
       RowBox[{"4", " ", 
        SubscriptBox["c", "w"], " ", 
        SubscriptBox["f", "a"], " ", "\[Pi]", " ", 
        SubscriptBox["s", "w"], " ", "vev"}]]}]},
    {GridBox[{
       {"ALP", "1"},
       {"H", "2"},
       {"Z", "3"},
       {"Z", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{"\[ImaginaryI]", " ", "e", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubscriptBox["a", "2"], " ", 
          SubscriptBox["c", "2"], " ", 
          SubscriptBox["c", "w"]}], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "7"], " ", 
          SubscriptBox["c", "7"], " ", 
          SubscriptBox["c", "w"]}], "-", 
         RowBox[{"2", " ", 
          SubscriptBox["a", "1"], " ", 
          SubscriptBox["c", "1"], " ", 
          SubscriptBox["s", "w"]}]}], ")"}], " ", 
       SubscriptBox["\[Epsilon]", 
        RowBox[{
         SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
         SubscriptBox["\<\"\[Mu]\"\>", "4"], ",", "mu$1", ",", "mu$2"}]], " ", 
       SubsuperscriptBox["\<\"p\"\>", "1", "mu$1"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          SubsuperscriptBox["\<\"p\"\>", "3", "mu$2"]}], "+", 
         SubsuperscriptBox["\<\"p\"\>", "4", "mu$2"]}], ")"}]}], 
      RowBox[{"4", " ", 
       SubscriptBox["c", "w"], " ", 
       SubscriptBox["f", "a"], " ", "\[Pi]", " ", 
       SubscriptBox["s", "w"], " ", "vev"}]]},
    {GridBox[{
       {"ALP", "1"},
       {"Z", "2"},
       {"Z", "3"},
       {"Z", "4"}
      },
      GridBoxAlignment->{
       "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
        "RowsIndexed" -> {}},
      GridBoxSpacings->{"Columns" -> {
          Offset[0.27999999999999997`], {
           Offset[0.7]}, 
          Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
          Offset[0.2], {
           Offset[0.1]}, 
          Offset[0.2]}, "RowsIndexed" -> {}}], 
     FractionBox[
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         SubscriptBox["c", "4"], "+", 
         SubscriptBox["c", "5"], "+", 
         RowBox[{"2", " ", 
          SubscriptBox["c", "9"]}]}], ")"}], " ", 
       SuperscriptBox["e", "3"], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          SubsuperscriptBox["\<\"p\"\>", "1", 
           SubscriptBox["\<\"\[Mu]\"\>", "4"]], " ", 
          SubscriptBox["\[Eta]", 
           RowBox[{
            SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
            SubscriptBox["\<\"\[Mu]\"\>", "3"]}]]}], "+", 
         RowBox[{
          SubsuperscriptBox["\<\"p\"\>", "1", 
           SubscriptBox["\<\"\[Mu]\"\>", "3"]], " ", 
          SubscriptBox["\[Eta]", 
           RowBox[{
            SubscriptBox["\<\"\[Mu]\"\>", "2"], ",", 
            SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}], "+", 
         RowBox[{
          SubsuperscriptBox["\<\"p\"\>", "1", 
           SubscriptBox["\<\"\[Mu]\"\>", "2"]], " ", 
          SubscriptBox["\[Eta]", 
           RowBox[{
            SubscriptBox["\<\"\[Mu]\"\>", "3"], ",", 
            SubscriptBox["\<\"\[Mu]\"\>", "4"]}]]}]}], ")"}]}], 
      RowBox[{"16", " ", 
       SubsuperscriptBox["c", "w", "3"], " ", 
       SubscriptBox["f", "a"], " ", 
       SuperscriptBox["\[Pi]", "2"], " ", 
       SubsuperscriptBox["s", "w", "3"]}]]}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  TableForm[{{{{$CellContext`A, 1}, {$CellContext`ALP, 2}, {FeynRules`H, 3}, {
      FeynRules`H, 4}}, Rational[-1, 2] $CellContext`fa^(-1) 
     Pi^(-1) ($CellContext`b3 $CellContext`C3 $CellContext`cw + \
$CellContext`b10 $CellContext`C10 $CellContext`sw) $CellContext`vev^(-2) ((
        FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, 
           FeynRules`Ext[1]]] + FeynRules`FV[4, 
          FeynRules`Index[FeynRules`Lorentz, 
           FeynRules`Ext[1]]]) FeynRules`SP[1, 2] - FeynRules`FV[2, 
        FeynRules`Index[FeynRules`Lorentz, 
         FeynRules`Ext[1]]] (FeynRules`SP[1, 3] + 
       FeynRules`SP[1, 4]))}, {{{$CellContext`A, 1}, {$CellContext`ALP, 2}, {
      FeynRules`H, 3}}, Rational[1, 2] $CellContext`fa^(-1) 
     Pi^(-1) ($CellContext`a3 $CellContext`C3 $CellContext`cw + \
$CellContext`a10 $CellContext`C10 $CellContext`sw) $CellContext`vev^(-1) (-
       FeynRules`FV[3, 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[1]]] FeynRules`SP[1, 2] + FeynRules`FV[2, 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[1]]] FeynRules`SP[1, 3])}, {{{$CellContext`ALP, 1}, {
      FeynRules`H, 2}, {FeynRules`H, 3}, {$CellContext`Z, 4}}, 
     Rational[1, 8] $CellContext`cw^(-1) $CellContext`fa^(-1) 
     Pi^(-2) $CellContext`sw^(-1) $CellContext`vev^(-2) (
      FeynRules`ee (FeynRules`FV[3, 
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[4]]] ($CellContext`b11 $CellContext`C11 
           FeynRules`SP[1, 1] + 
          2 $CellContext`a16 $CellContext`a16prime $CellContext`C16 
           FeynRules`SP[1, 2] + $CellContext`b14 $CellContext`C14 (
            FeynRules`SP[1, 2] + FeynRules`SP[1, 3])) + FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[4]]] ($CellContext`b11 $CellContext`C11 
           FeynRules`SP[1, 1] + 
          2 $CellContext`a16 $CellContext`a16prime $CellContext`C16 
           FeynRules`SP[1, 3] + $CellContext`b14 $CellContext`C14 (
            FeynRules`SP[1, 2] + FeynRules`SP[1, 3]))) + 
      4 Pi $CellContext`sw ($CellContext`b3 $CellContext`C3 $CellContext`cw \
$CellContext`sw + $CellContext`b10 $CellContext`C10 (-1 + $CellContext`sw^2)) \
(FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, 
           FeynRules`Ext[4]]] + FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, 
           FeynRules`Ext[4]]]) FeynRules`SP[1, 4] - FeynRules`FV[1, 
        FeynRules`Index[FeynRules`Lorentz, 
         FeynRules`Ext[4]]] (
       16 $CellContext`b2D $CellContext`C2D FeynRules`ee 
        Pi^2 $CellContext`vev^2 - 
       FeynRules`ee ($CellContext`b17 $CellContext`C17 
         FeynRules`SP[1, 1] + $CellContext`b12 $CellContext`C12 (
          FeynRules`SP[1, 2] + FeynRules`SP[1, 3]) + 
        4 $CellContext`a15 $CellContext`a15prime $CellContext`C15 
         FeynRules`SP[2, 3] + $CellContext`b13 $CellContext`C13 (
          FeynRules`SP[2, 2] + 2 FeynRules`SP[2, 3] + FeynRules`SP[3, 3])) + 
       4 Pi $CellContext`sw ($CellContext`b3 $CellContext`C3 $CellContext`cw \
$CellContext`sw + $CellContext`b10 $CellContext`C10 (-1 + $CellContext`sw^2)) \
(FeynRules`SP[2, 4] + FeynRules`SP[3, 4])))}, {{{$CellContext`ALP, 1}, {
      FeynRules`H, 2}, {$CellContext`Z, 3}}, 
     Rational[1, 8] $CellContext`cw^(-1) $CellContext`fa^(-1) 
     Pi^(-2) $CellContext`sw^(-1) $CellContext`vev^(-1) (FeynRules`FV[2, 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]]] ($CellContext`a11 $CellContext`C11 FeynRules`ee 
         FeynRules`SP[1, 1] + $CellContext`a14 $CellContext`C14 FeynRules`ee 
         FeynRules`SP[1, 2] + 
        4 Pi $CellContext`sw ($CellContext`a3 $CellContext`C3 $CellContext`cw \
$CellContext`sw + $CellContext`a10 $CellContext`C10 (-1 + $CellContext`sw^2)) 
         FeynRules`SP[1, 3]) + FeynRules`FV[1, 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]]] (
        FeynRules`ee ((-16) $CellContext`a2D $CellContext`C2D 
           Pi^2 $CellContext`vev^2 + $CellContext`a17 $CellContext`C17 
           FeynRules`SP[1, 1] + $CellContext`a12 $CellContext`C12 
           FeynRules`SP[1, 2] + $CellContext`a13 $CellContext`C13 
           FeynRules`SP[2, 2]) - 4 
        Pi $CellContext`sw ($CellContext`a3 $CellContext`C3 $CellContext`cw \
$CellContext`sw + $CellContext`a10 $CellContext`C10 (-1 + $CellContext`sw^2)) 
        FeynRules`SP[2, 3]))}, {{{$CellContext`A, 1}, {$CellContext`A, 
       2}, {$CellContext`ALP, 3}}, 
     Complex[0, -2] $CellContext`fa^(-1) (-$CellContext`CBtil + \
($CellContext`CBtil - $CellContext`CWtil) $CellContext`sw^2) FeynRules`Eps[
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[1]], 
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[2]], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] (FeynRules`FV[1, 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] 
       FeynRules`FV[2, 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] - 
      FeynRules`FV[1, 
        FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] FeynRules`FV[2, 
        FeynRules`Index[
        FeynRules`Lorentz, $CellContext`mu$2]])}, {{{$CellContext`ALP, 1}, {
      FeynRules`G, 2}, {FeynRules`G, 3}}, Complex[0, 
       Rational[1, 2]] $CellContext`CGtil $CellContext`fa^(-1) (
      FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]] (
        FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]] 
         FeynRules`FV[3, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1]] - 
        FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1]] 
        FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]]) + 
      FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]] (-
         FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1]] 
         FeynRules`FV[3, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]] + 
        FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]] 
         FeynRules`FV[3, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1]]) + 
      FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]] (
        FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]] 
         FeynRules`FV[3, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1]] - 
        FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1]] 
        FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]]) + 
      FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]] (
        FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]] 
         FeynRules`FV[3, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1]] - 
        FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1]] 
        FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]])) 
     FeynRules`IndexDelta[
       FeynRules`Index[FeynRules`Gluon, 
        FeynRules`Ext[2]], 
       FeynRules`Index[FeynRules`Gluon, 
        FeynRules`Ext[3]]]}, {{{$CellContext`ALP, 1}, {
      FeynRules`W, 2}, {$CellContext`Wbar, 3}}, 
     Rational[1, 16] $CellContext`fa^(-1) 
     Pi^(-2) $CellContext`sw^(-2) (
      Complex[0, 2] Pi $CellContext`sw FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1], 
         FeynRules`Index[
         FeynRules`Lorentz, $CellContext`mu$2]] ($CellContext`C2 FeynRules`ee 
         FeynRules`FV[1, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] (-
           FeynRules`FV[2, 
             FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] + 
          FeynRules`FV[3, 
            FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]]) + 
        16 $CellContext`CWtil Pi $CellContext`sw (FeynRules`FV[2, 
             FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] 
           FeynRules`FV[3, 
             FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] - 
          FeynRules`FV[2, 
            FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] 
          FeynRules`FV[3, 
            FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]])) - 
      FeynRules`ee (FeynRules`FV[1, 
          FeynRules`Index[FeynRules`Lorentz, 
           FeynRules`Ext[3]]] ($CellContext`C8 FeynRules`ee FeynRules`FV[2, 
            FeynRules`Index[FeynRules`Lorentz, 
             FeynRules`Ext[2]]] + 
         4 $CellContext`C6 Pi $CellContext`sw FeynRules`FV[3, 
            FeynRules`Index[FeynRules`Lorentz, 
             FeynRules`Ext[2]]]) - FeynRules`FV[1, 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]]] (
        4 $CellContext`C6 Pi $CellContext`sw FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[3]]] + $CellContext`C8 FeynRules`ee 
         FeynRules`FV[3, 
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[3]]]) + 
       4 $CellContext`C6 Pi $CellContext`sw FeynRules`ME[
          FeynRules`Index[FeynRules`Lorentz, 
           FeynRules`Ext[2]], 
          FeynRules`Index[FeynRules`Lorentz, 
           FeynRules`Ext[3]]] (FeynRules`SP[1, 2] - FeynRules`SP[
         1, 3])))}, {{{$CellContext`A, 1}, {$CellContext`ALP, 
       2}, {$CellContext`Z, 3}}, Complex[0, 
       Rational[-1, 8]] $CellContext`cw^(-1) $CellContext`fa^(-1) 
     Pi^(-1) $CellContext`sw^(-1) FeynRules`Eps[
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[1]], 
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[3]], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] (FeynRules`FV[1, 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] (
        FeynRules`ee (
          2 $CellContext`C1 $CellContext`cw + ($CellContext`C2 + 
            2 $CellContext`C7) $CellContext`sw) FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] - 
        16 ($CellContext`CBtil - $CellContext`CWtil) 
        Pi $CellContext`sw^2 (-1 + $CellContext`sw^2) FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]]) + 
      16 ($CellContext`CBtil - $CellContext`CWtil) 
       Pi $CellContext`sw^2 (-1 + $CellContext`sw^2) FeynRules`FV[1, 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] 
       FeynRules`FV[3, 
         FeynRules`Index[
         FeynRules`Lorentz, $CellContext`mu$2]])}, {{{$CellContext`ALP, 
       1}, {$CellContext`Z, 2}, {$CellContext`Z, 3}}, Complex[0, 
       Rational[-1, 8]] $CellContext`cw^(-1) $CellContext`fa^(-1) 
     Pi^(-1) $CellContext`sw^(-1) FeynRules`Eps[
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[2]], 
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[3]], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] (
      FeynRules`ee ($CellContext`C2 $CellContext`cw + 
        2 $CellContext`C7 $CellContext`cw - 2 $CellContext`C1 $CellContext`sw)
         FeynRules`FV[1, 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] (
        FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] - 
        FeynRules`FV[3, 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]]) + 
      16 $CellContext`cw 
       Pi $CellContext`sw (-$CellContext`CWtil + (-$CellContext`CBtil + \
$CellContext`CWtil) $CellContext`sw^2) (FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] 
         FeynRules`FV[3, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] - 
        FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] 
        FeynRules`FV[3, 
          FeynRules`Index[
          FeynRules`Lorentz, $CellContext`mu$2]]))}, {{{$CellContext`ALP, 
       1}, {FeynRules`G, 2}, {FeynRules`G, 3}, {
      FeynRules`G, 4}}, -$CellContext`CGtil $CellContext`fa^(-1) FeynRules`gs 
     FeynRules`f[
       FeynRules`Index[FeynRules`Gluon, 
        FeynRules`Ext[2]], 
       FeynRules`Index[FeynRules`Gluon, 
        FeynRules`Ext[3]], 
       FeynRules`Index[FeynRules`Gluon, 
        FeynRules`Ext[4]]] (FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[4]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1]] (
        FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1]] + 
        FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1]] + 
        FeynRules`FV[4, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Alpha]1]]) + 
      FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[4]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]] (
        FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]] + 
        FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]] + 
        FeynRules`FV[4, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Beta]1]]) + 
      FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[4]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1]] (
        FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1]] + 
        FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1]] + 
        FeynRules`FV[4, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Gamma]1]]) + 
      FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[4]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]] (
        FeynRules`FV[2, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]] + 
        FeynRules`FV[3, 
          FeynRules`Index[FeynRules`Lorentz, $CellContext`\[Delta]1]] + 
        FeynRules`FV[4, 
          FeynRules`Index[
          FeynRules`Lorentz, $CellContext`\[Delta]1]]))}, \
{{{$CellContext`dqbar, 1}, {$CellContext`dq, 2}, {$CellContext`ALP, 3}, {
      FeynRules`H, 4}}, Rational[-1, 4] 
     2^Rational[-1, 2] $CellContext`aD $CellContext`fa^(-1) 
     Pi^(-2) $CellContext`vev^(-2) FeynRules`IndexDelta[
       FeynRules`Index[FeynRules`Colour, 
        FeynRules`Ext[1]], 
       FeynRules`Index[FeynRules`Colour, 
        FeynRules`Ext[2]]] (
      16 $CellContext`C2D Pi^2 $CellContext`vev^2 - $CellContext`C17 
      FeynRules`SP[3, 3]) (Conjugate[
         $CellContext`CKM[
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[2]], 
          
          FeynRules`Index[$CellContext`Generation, \
$CellContext`Generation$1]]] Conjugate[
         $CellContext`yd[
          FeynRules`Index[$CellContext`Generation, $CellContext`Generation$1], 
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[1]]]] FeynRules`ProjM[
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[2]]] - $CellContext`CKM[
        FeynRules`Index[$CellContext`Generation, 
         FeynRules`Ext[1]], 
        FeynRules`Index[$CellContext`Generation, $CellContext`Generation$1]] 
      FeynRules`ProjP[
        FeynRules`Index[FeynRules`Spin, 
         FeynRules`Ext[1]], 
        FeynRules`Index[FeynRules`Spin, 
         FeynRules`Ext[2]]] $CellContext`yd[
        FeynRules`Index[$CellContext`Generation, $CellContext`Generation$1], 
        FeynRules`Index[$CellContext`Generation, 
         FeynRules`Ext[2]]])}, {{{$CellContext`dqbar, 1}, {$CellContext`dq, 
       2}, {$CellContext`ALP, 3}}, Rational[-1, 8] 
     2^Rational[-1, 2] $CellContext`fa^(-1) Pi^(-2) $CellContext`vev^(-1) 
     FeynRules`IndexDelta[
       FeynRules`Index[FeynRules`Colour, 
        FeynRules`Ext[1]], 
       FeynRules`Index[FeynRules`Colour, 
        FeynRules`Ext[2]]] (
      16 $CellContext`C2D Pi^2 $CellContext`vev^2 - $CellContext`C17 
      FeynRules`SP[3, 3]) (Conjugate[
         $CellContext`CKM[
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[2]], 
          
          FeynRules`Index[$CellContext`Generation, \
$CellContext`Generation$1]]] Conjugate[
         $CellContext`yd[
          FeynRules`Index[$CellContext`Generation, $CellContext`Generation$1], 
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[1]]]] FeynRules`ProjM[
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[2]]] - $CellContext`CKM[
        FeynRules`Index[$CellContext`Generation, 
         FeynRules`Ext[1]], 
        FeynRules`Index[$CellContext`Generation, $CellContext`Generation$1]] 
      FeynRules`ProjP[
        FeynRules`Index[FeynRules`Spin, 
         FeynRules`Ext[1]], 
        FeynRules`Index[FeynRules`Spin, 
         FeynRules`Ext[2]]] $CellContext`yd[
        FeynRules`Index[$CellContext`Generation, $CellContext`Generation$1], 
        FeynRules`Index[$CellContext`Generation, 
         FeynRules`Ext[2]]])}, {{{$CellContext`lbar, 1}, {
      FeynRules`l, 2}, {$CellContext`ALP, 3}, {FeynRules`H, 4}}, 
     Rational[-1, 4] 2^Rational[-1, 2] $CellContext`aL $CellContext`fa^(-1) 
     Pi^(-2) $CellContext`vev^(-2) (
      16 $CellContext`C2D Pi^2 $CellContext`vev^2 - $CellContext`C17 
      FeynRules`SP[3, 3]) (Conjugate[
         $CellContext`yl[
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[2]], 
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[1]]]] FeynRules`ProjM[
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[2]]] - FeynRules`ProjP[
        FeynRules`Index[FeynRules`Spin, 
         FeynRules`Ext[1]], 
        FeynRules`Index[FeynRules`Spin, 
         FeynRules`Ext[2]]] $CellContext`yl[
        FeynRules`Index[$CellContext`Generation, 
         FeynRules`Ext[1]], 
        FeynRules`Index[$CellContext`Generation, 
         FeynRules`Ext[2]]])}, {{{$CellContext`lbar, 1}, {
      FeynRules`l, 2}, {$CellContext`ALP, 3}}, Rational[-1, 8] 
     2^Rational[-1, 2] $CellContext`fa^(-1) 
     Pi^(-2) $CellContext`vev^(-1) (
      16 $CellContext`C2D Pi^2 $CellContext`vev^2 - $CellContext`C17 
      FeynRules`SP[3, 3]) (Conjugate[
         $CellContext`yl[
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[2]], 
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[1]]]] FeynRules`ProjM[
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[2]]] - FeynRules`ProjP[
        FeynRules`Index[FeynRules`Spin, 
         FeynRules`Ext[1]], 
        FeynRules`Index[FeynRules`Spin, 
         FeynRules`Ext[2]]] $CellContext`yl[
        FeynRules`Index[$CellContext`Generation, 
         FeynRules`Ext[1]], 
        FeynRules`Index[$CellContext`Generation, 
         FeynRules`Ext[2]]])}, {{{$CellContext`uqbar, 1}, {$CellContext`uq, 
       2}, {$CellContext`ALP, 3}, {FeynRules`H, 4}}, Rational[1, 4] 
     2^Rational[-1, 2] $CellContext`aU $CellContext`fa^(-1) 
     Pi^(-2) $CellContext`vev^(-2) FeynRules`IndexDelta[
       FeynRules`Index[FeynRules`Colour, 
        FeynRules`Ext[1]], 
       FeynRules`Index[FeynRules`Colour, 
        FeynRules`Ext[2]]] (
      16 $CellContext`C2D Pi^2 $CellContext`vev^2 - $CellContext`C17 
      FeynRules`SP[3, 3]) (Conjugate[
         $CellContext`yu[
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[2]], 
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[1]]]] FeynRules`ProjM[
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[2]]] - FeynRules`ProjP[
        FeynRules`Index[FeynRules`Spin, 
         FeynRules`Ext[1]], 
        FeynRules`Index[FeynRules`Spin, 
         FeynRules`Ext[2]]] $CellContext`yu[
        FeynRules`Index[$CellContext`Generation, 
         FeynRules`Ext[1]], 
        FeynRules`Index[$CellContext`Generation, 
         FeynRules`Ext[2]]])}, {{{$CellContext`uqbar, 1}, {$CellContext`uq, 
       2}, {$CellContext`ALP, 3}}, Rational[1, 8] 
     2^Rational[-1, 2] $CellContext`fa^(-1) Pi^(-2) $CellContext`vev^(-1) 
     FeynRules`IndexDelta[
       FeynRules`Index[FeynRules`Colour, 
        FeynRules`Ext[1]], 
       FeynRules`Index[FeynRules`Colour, 
        FeynRules`Ext[2]]] (
      16 $CellContext`C2D Pi^2 $CellContext`vev^2 - $CellContext`C17 
      FeynRules`SP[3, 3]) (Conjugate[
         $CellContext`yu[
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[2]], 
          FeynRules`Index[$CellContext`Generation, 
           FeynRules`Ext[1]]]] FeynRules`ProjM[
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Spin, 
          FeynRules`Ext[2]]] - FeynRules`ProjP[
        FeynRules`Index[FeynRules`Spin, 
         FeynRules`Ext[1]], 
        FeynRules`Index[FeynRules`Spin, 
         FeynRules`Ext[2]]] $CellContext`yu[
        FeynRules`Index[$CellContext`Generation, 
         FeynRules`Ext[1]], 
        FeynRules`Index[$CellContext`Generation, 
         FeynRules`Ext[2]]])}, {{{$CellContext`ALP, 1}, {FeynRules`H, 2}, {
      FeynRules`W, 3}, {$CellContext`Wbar, 4}}, Rational[-1, 8] 
     FeynRules`ee $CellContext`fa^(-1) 
     Pi^(-2) $CellContext`sw^(-2) $CellContext`vev^(-1) (FeynRules`FV[1, 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[4]]] ($CellContext`a8 $CellContext`C8 FeynRules`ee 
         FeynRules`FV[3, 
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[3]]] + 
        4 Pi $CellContext`sw ($CellContext`a10 $CellContext`C10 
           FeynRules`FV[2, 
             FeynRules`Index[FeynRules`Lorentz, 
              FeynRules`Ext[3]]] + $CellContext`a6 $CellContext`C6 
           FeynRules`FV[4, 
             FeynRules`Index[FeynRules`Lorentz, 
              FeynRules`Ext[3]]])) - FeynRules`FV[1, 
        FeynRules`Index[FeynRules`Lorentz, 
         FeynRules`Ext[3]]] (
       4 Pi $CellContext`sw ($CellContext`a10 $CellContext`C10 FeynRules`FV[2, 
            FeynRules`Index[FeynRules`Lorentz, 
             FeynRules`Ext[4]]] + $CellContext`a6 $CellContext`C6 
          FeynRules`FV[3, 
            FeynRules`Index[FeynRules`Lorentz, 
             FeynRules`Ext[4]]]) + $CellContext`a8 $CellContext`C8 
        FeynRules`ee FeynRules`FV[4, 
          FeynRules`Index[FeynRules`Lorentz, 
           FeynRules`Ext[4]]]) + 
      2 Pi $CellContext`sw (
        Complex[0, -1] FeynRules`a2 $CellContext`C2 FeynRules`Eps[
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[4]], 
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[3]], 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1], 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] 
         FeynRules`FV[1, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] (
          FeynRules`FV[3, 
            FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] - 
          FeynRules`FV[4, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]]) + 
        2 $CellContext`a6 $CellContext`C6 FeynRules`ME[
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[3]], 
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[4]]] (FeynRules`SP[1, 3] - FeynRules`SP[
          1, 4])))}, {{{$CellContext`A, 1}, {$CellContext`ALP, 2}, {
      FeynRules`W, 3}, {$CellContext`Wbar, 4}}, Rational[1, 16] 
     FeynRules`ee $CellContext`fa^(-1) 
     Pi^(-2) $CellContext`sw^(-2) (
      Complex[0, -4] Pi $CellContext`sw FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[1]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[4]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[
         FeynRules`Lorentz, $CellContext`mu$1]] (-$CellContext`C2 
         FeynRules`ee FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] + 
        16 $CellContext`CWtil Pi $CellContext`sw (FeynRules`FV[1, 
            FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] + 
          FeynRules`FV[3, 
            FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] + 
          FeynRules`FV[4, 
            FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]])) + 
      FeynRules`ee ($CellContext`C8 FeynRules`ee - 4 $CellContext`C6 
        Pi $CellContext`sw) (FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[4]]] FeynRules`ME[
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[1]], 
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[3]]] + FeynRules`FV[2, 
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[3]]] FeynRules`ME[
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[1]], 
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[4]]]) + 
      8 $CellContext`C6 FeynRules`ee Pi $CellContext`sw FeynRules`FV[2, 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[1]]] FeynRules`ME[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[4]]])}, {{{$CellContext`ALP, 1}, {
      FeynRules`W, 2}, {$CellContext`Wbar, 3}, {$CellContext`Z, 4}}, 
     Rational[1, 32] $CellContext`cw^(-1) FeynRules`ee $CellContext`fa^(-1) 
     Pi^(-2) $CellContext`sw^(-3) (
      Complex[0, -4] Pi $CellContext`sw FeynRules`Eps[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[4]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] (
        FeynRules`ee (3 $CellContext`C2 + 2 $CellContext`C7 - 
          2 $CellContext`C2 $CellContext`sw^2) FeynRules`FV[1, 
           FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] + 
        32 $CellContext`CWtil 
         Pi $CellContext`sw (-1 + $CellContext`sw^2) (FeynRules`FV[2, 
            FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] + 
          FeynRules`FV[3, 
            FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] + 
          FeynRules`FV[4, 
            FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]])) + 
      FeynRules`ee (
        2 ($CellContext`C5 FeynRules`ee - 8 $CellContext`C6 
          Pi $CellContext`sw (-1 + $CellContext`sw^2)) FeynRules`FV[1, 
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[4]]] FeynRules`ME[
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[2]], 
           FeynRules`Index[FeynRules`Lorentz, 
            FeynRules`Ext[3]]] + ($CellContext`C4 FeynRules`ee + 
          2 $CellContext`sw (-$CellContext`C8 FeynRules`ee $CellContext`sw + 
            4 $CellContext`C6 Pi (-1 + $CellContext`sw^2))) (FeynRules`FV[1, 
             FeynRules`Index[FeynRules`Lorentz, 
              FeynRules`Ext[3]]] FeynRules`ME[
             FeynRules`Index[FeynRules`Lorentz, 
              FeynRules`Ext[2]], 
             FeynRules`Index[FeynRules`Lorentz, 
              FeynRules`Ext[4]]] + FeynRules`FV[1, 
             FeynRules`Index[FeynRules`Lorentz, 
              FeynRules`Ext[2]]] FeynRules`ME[
             FeynRules`Index[FeynRules`Lorentz, 
              FeynRules`Ext[3]], 
             FeynRules`Index[FeynRules`Lorentz, 
              FeynRules`Ext[4]]])))}, {{{$CellContext`A, 
       1}, {$CellContext`ALP, 2}, {FeynRules`H, 3}, {$CellContext`Z, 4}}, 
     Complex[0, 
       Rational[-1, 4]] $CellContext`cw^(-1) 
     FeynRules`ee $CellContext`fa^(-1) 
     Pi^(-1) $CellContext`sw^(-1) (
      2 FeynRules`a1 $CellContext`C1 $CellContext`cw + 
      FeynRules`a2 $CellContext`C2 $CellContext`sw + 
      2 $CellContext`a7 $CellContext`C7 $CellContext`sw) $CellContext`vev^(-1)
        FeynRules`Eps[
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[1]], 
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[4]], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] 
     FeynRules`FV[1, 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] 
     FeynRules`FV[2, 
       FeynRules`Index[
       FeynRules`Lorentz, $CellContext`mu$1]]}, {{{$CellContext`ALP, 1}, {
      FeynRules`H, 2}, {$CellContext`Z, 3}, {$CellContext`Z, 4}}, Complex[0, 
       Rational[1, 4]] $CellContext`cw^(-1) FeynRules`ee $CellContext`fa^(-1) 
     Pi^(-1) $CellContext`sw^(-1) (
      FeynRules`a2 $CellContext`C2 $CellContext`cw + 
      2 $CellContext`a7 $CellContext`C7 $CellContext`cw - 2 
      FeynRules`a1 $CellContext`C1 $CellContext`sw) $CellContext`vev^(-1) 
     FeynRules`Eps[
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[3]], 
       FeynRules`Index[FeynRules`Lorentz, 
        FeynRules`Ext[4]], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1], 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] 
     FeynRules`FV[1, 
       FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$1]] (-
       FeynRules`FV[3, 
         FeynRules`Index[FeynRules`Lorentz, $CellContext`mu$2]] + 
      FeynRules`FV[4, 
        FeynRules`Index[
        FeynRules`Lorentz, $CellContext`mu$2]])}, {{{$CellContext`ALP, 
       1}, {$CellContext`Z, 2}, {$CellContext`Z, 3}, {$CellContext`Z, 4}}, 
     Rational[1, 16] ($CellContext`C4 + $CellContext`C5 + 
      2 $CellContext`C9) $CellContext`cw^(-3) 
     FeynRules`ee^3 $CellContext`fa^(-1) 
     Pi^(-2) $CellContext`sw^(-3) (FeynRules`FV[1, 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[4]]] FeynRules`ME[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]]] + FeynRules`FV[1, 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]]] FeynRules`ME[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[4]]] + FeynRules`FV[1, 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[2]]] FeynRules`ME[
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[3]], 
         FeynRules`Index[FeynRules`Lorentz, 
          FeynRules`Ext[4]]])}}]]], "Output",
 CellChangeTimes->{{3.638614114774802*^9, 3.638614120544181*^9}, {
   3.638614318695908*^9, 3.638614365439787*^9}, {3.638614433232692*^9, 
   3.638614464705694*^9}, 3.6386224388916407`*^9, 3.6386225007679977`*^9, 
   3.6386226973043947`*^9, 3.6386227333544188`*^9, 3.638623278409637*^9, 
   3.6386236952225227`*^9, 3.63862388459741*^9, 3.638681852154767*^9, 
   3.63868270965028*^9, 3.6386851562356977`*^9, 3.638686844261732*^9, 
   3.638700137162476*^9, 3.638702832337493*^9, 3.6387029349627132`*^9, {
   3.638703100427805*^9, 3.6387031136888237`*^9}, {3.63870321256925*^9, 
   3.638703230424244*^9}, {3.638703278436899*^9, 3.638703292187565*^9}, 
   3.6387033347871733`*^9, 3.638703390597958*^9, 3.638704548504233*^9, 
   3.638707599815777*^9, 3.638708193011647*^9, 3.638708294314163*^9, 
   3.638712328104225*^9, 3.638714899545281*^9, 3.6387158861274137`*^9, {
   3.638716073530249*^9, 3.6387160868743467`*^9}, {3.63871612959566*^9, 
   3.638716213883053*^9}, 3.638768861462468*^9, 3.639820343194125*^9, 
   3.6415554721097116`*^9, 3.641556006389512*^9, 3.641556218296584*^9, 
   3.6415568954663677`*^9, 3.675577255235321*^9, 3.6755773956759577`*^9, 
   3.6761156287361507`*^9, 3.676199644982154*^9, {3.6761997657926407`*^9, 
   3.676199788244617*^9}, 3.676202161727428*^9, 3.676286259801929*^9, 
   3.676286831252707*^9, 3.676286963494295*^9, 3.7149005669550333`*^9}]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Export to UFO", "Subsection",
 CellChangeTimes->{{3.638798084002553*^9, 3.6387980887087*^9}, {
  3.7149007705746527`*^9, 3.7149007713720427`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"WriteUFO", "[", 
  RowBox[{
   RowBox[{"LSM", "+", "LALP"}], ",", 
   RowBox[{"MaxParticles", "\[Rule]", "4"}], ",", " ", 
   RowBox[{"Output", "\[Rule]", "\"\<ALP_chiral_UFO\>\""}]}], "]"}]], "Input",\

 CellChangeTimes->{{3.638796268087139*^9, 3.638796293694366*^9}, {
  3.676286245623457*^9, 3.676286247246126*^9}, {3.6943356972519197`*^9, 
  3.6943356990015907`*^9}, {3.714900494999193*^9, 3.714900536696802*^9}}],

Cell[CellGroupData[{

Cell[BoxData["\<\" --- Universal FeynRules Output (UFO) v 1.1 ---\"\>"], \
"Print",
 CellChangeTimes->{3.714900591927953*^9}],

Cell[BoxData[
 StyleBox["\<\"Starting Feynman rule calculation.\"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.714900592506741*^9}],

Cell[BoxData["\<\"Expanding the Lagrangian...\"\>"], "Print",
 CellChangeTimes->{3.714900592507815*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Expanding the indices over \"\>", "\[InvisibleSpace]", "2", 
   "\[InvisibleSpace]", "\<\" cores\"\>"}],
  SequenceForm["Expanding the indices over ", 2, " cores"],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900592508318*^9}],

Cell[BoxData["\<\"Collecting the different structures that enter the \
vertex.\"\>"], "Print",
 CellChangeTimes->{3.714900608629657*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
  "58", "\[InvisibleSpace]", "\<\" possible non-zero vertices have been found \
-> starting the computation: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$FeynmanRules, StandardForm],
    ImageSizeCache->{17., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "58", "\[InvisibleSpace]", "\<\".\"\>"}],
  SequenceForm[
  58, " possible non-zero vertices have been found -> starting the \
computation: ", 
   Dynamic[FeynRules`FR$FeynmanRules], " / ", 58, "."],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900608708271*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"53", "\[InvisibleSpace]", "\<\" vertices obtained.\"\>"}],
  SequenceForm[53, " vertices obtained."],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900616841229*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Flavor expansion of the vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" cores: \"\>", 
   "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[FeynRules`FR$Count1, StandardForm],
    ImageSizeCache->{17., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "53"}],
  SequenceForm[
  "Flavor expansion of the vertices distributed over ", 2, " cores: ", 
   Dynamic[FeynRules`FR$Count1], " / ", 53],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900618127434*^9}],

Cell[BoxData["\<\"   - Saved vertices in InterfaceRun[ 1 ].\"\>"], "Print",
 CellChangeTimes->{3.714900624975767*^9}],

Cell[BoxData[
 StyleBox["\<\"Computing the squared matrix elements relevant for the 1->2 \
decays: \"\>",
  StripOnInput->False,
  LineColor->RGBColor[1, 0.5, 0],
  FrontFaceColor->RGBColor[1, 0.5, 0],
  BackFaceColor->RGBColor[1, 0.5, 0],
  GraphicsColor->RGBColor[1, 0.5, 0],
  FontWeight->Bold,
  FontColor->RGBColor[1, 0.5, 0]]], "Print",
 CellChangeTimes->{3.7149006250032682`*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{17., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "70"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 70],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900625010377*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Squared matrix elent compute in \"\>", "\[InvisibleSpace]", 
   "20.716`", "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Squared matrix elent compute in ", 20.716, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900682420899*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{
   DynamicBox[ToBoxes[PRIVATE`mycounter, StandardForm],
    ImageSizeCache->{17., {0., 9.}}], "\[InvisibleSpace]", "\<\" / \"\>", 
   "\[InvisibleSpace]", "89"}],
  SequenceForm[
   Dynamic[PRIVATE`mycounter], " / ", 89],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900682430378*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Decay widths computed in \"\>", "\[InvisibleSpace]", "4.82`", 
   "\[InvisibleSpace]", "\<\" seconds.\"\>"}],
  SequenceForm["Decay widths computed in ", 4.82, " seconds."],
  Editable->False]], "Print",
 CellChangeTimes->{3.7149006884162073`*^9}],

Cell[BoxData["\<\"Preparing Python output.\"\>"], "Print",
 CellChangeTimes->{3.7149006884176807`*^9}],

Cell[BoxData["\<\"    - Splitting vertices into building blocks.\"\>"], \
"Print",
 CellChangeTimes->{3.714900688859367*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"Splitting of vertices distributed over \"\>", 
   "\[InvisibleSpace]", "2", "\[InvisibleSpace]", "\<\" kernels.\"\>"}],
  SequenceForm["Splitting of vertices distributed over ", 2, " kernels."],
  Editable->False]], "Print",
 CellChangeTimes->{3.714900688951193*^9}],

Cell[BoxData[
 InterpretationBox[
  RowBox[{"\<\"    - Optimizing: \"\>", "\[InvisibleSpace]", 
   DynamicBox[ToBoxes[PRIVATE`PY$SplitVertexCounter, StandardForm],
    ImageSizeCache->{24., {0., 9.}}], "\[InvisibleSpace]", "\<\"/\"\>", 
   "\[InvisibleSpace]", "121", "\[InvisibleSpace]", "\<\" .\"\>"}],
  SequenceForm["    - Optimizing: ", 
   Dynamic[PRIVATE`PY$SplitVertexCounter], "/", 121, " ."],
  Editable->False]], "Print",
 CellChangeTimes->{3.71490069124506*^9}],

Cell[BoxData["\<\"    - Writing files.\"\>"], "Print",
 CellChangeTimes->{3.714900691465427*^9}],

Cell[BoxData["\<\"Done!\"\>"], "Print",
 CellChangeTimes->{3.7149006929108877`*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]]
},
WindowSize->{1149, 1028},
WindowMargins->{{Automatic, 322}, {-123, Automatic}},
PrivateNotebookOptions->{"VersionedStylesheet"->{"Default.nb"[8.] -> False}},
ShowSelection->True,
FrontEndVersion->"11.0 for Linux x86 (64-bit) (September 21, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 173, 2, 66, "Chapter"],
Cell[743, 26, 506, 14, 209, "Text"],
Cell[1252, 42, 991, 16, 159, "Text"],
Cell[CellGroupData[{
Cell[2268, 62, 212, 3, 65, "Section"],
Cell[2483, 67, 1183, 20, 78, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[3703, 92, 301, 4, 65, "Section"],
Cell[CellGroupData[{
Cell[4029, 100, 1690, 29, 58, "Input"],
Cell[CellGroupData[{
Cell[5744, 133, 327, 4, 24, "Print"],
Cell[6074, 139, 345, 4, 24, "Print"],
Cell[6422, 145, 380, 5, 26, "Print"],
Cell[6805, 152, 447, 8, 24, "Print"],
Cell[7255, 162, 318, 4, 24, "Print"],
Cell[7576, 168, 321, 4, 24, "Print"],
Cell[7900, 174, 350, 4, 24, "Print"],
Cell[8253, 180, 352, 5, 26, "Print"],
Cell[8608, 187, 305, 4, 24, "Print"],
Cell[8916, 193, 334, 4, 24, "Print"],
Cell[9253, 199, 338, 4, 24, "Print"],
Cell[9594, 205, 336, 4, 24, "Print"],
Cell[9933, 211, 509, 9, 45, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[10491, 226, 203, 3, 45, "Subsection"],
Cell[CellGroupData[{
Cell[10719, 233, 628, 13, 34, "Input"],
Cell[CellGroupData[{
Cell[11372, 250, 1225, 21, 24, "Print"],
Cell[12600, 273, 982, 13, 24, "Print"],
Cell[13585, 288, 1161, 18, 24, "Print"],
Cell[14749, 308, 1204, 19, 24, "Print"],
Cell[15956, 329, 1013, 14, 24, "Print"],
Cell[16972, 345, 1494, 25, 24, "Print"],
Cell[18469, 372, 1095, 17, 24, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[19613, 395, 1267, 24, 36, "Input"],
Cell[20883, 421, 43874, 1114, 834, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[64806, 1541, 152, 2, 45, "Subsection"],
Cell[CellGroupData[{
Cell[64983, 1547, 494, 10, 34, "Input"],
Cell[CellGroupData[{
Cell[65502, 1561, 147, 2, 24, "Print"],
Cell[65652, 1565, 372, 9, 24, "Print"],
Cell[66027, 1576, 125, 1, 24, "Print"],
Cell[66155, 1579, 309, 6, 24, "Print"],
Cell[66467, 1587, 158, 2, 24, "Print"],
Cell[66628, 1591, 639, 13, 24, "Print"],
Cell[67270, 1606, 242, 5, 24, "Print"],
Cell[67515, 1613, 594, 12, 24, "Print"],
Cell[68112, 1627, 141, 1, 24, "Print"],
Cell[68256, 1630, 406, 10, 24, "Print"],
Cell[68665, 1642, 359, 9, 24, "Print"],
Cell[69027, 1653, 332, 6, 24, "Print"],
Cell[69362, 1661, 360, 9, 24, "Print"],
Cell[69725, 1672, 317, 6, 24, "Print"],
Cell[70045, 1680, 122, 1, 24, "Print"],
Cell[70170, 1683, 146, 2, 24, "Print"],
Cell[70319, 1687, 336, 6, 24, "Print"],
Cell[70658, 1695, 496, 9, 24, "Print"],
Cell[71157, 1706, 118, 1, 24, "Print"],
Cell[71278, 1709, 103, 1, 24, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[71454, 1718, 250, 3, 51, "Section"],
Cell[CellGroupData[{
Cell[71729, 1725, 1638, 28, 58, "Input"],
Cell[CellGroupData[{
Cell[73392, 1757, 283, 4, 24, "Print"],
Cell[73678, 1763, 299, 4, 24, "Print"],
Cell[73980, 1769, 334, 5, 26, "Print"],
Cell[74317, 1776, 401, 8, 24, "Print"],
Cell[74721, 1786, 270, 4, 24, "Print"],
Cell[74994, 1792, 275, 4, 24, "Print"],
Cell[75272, 1798, 304, 4, 24, "Print"],
Cell[75579, 1804, 307, 5, 26, "Print"],
Cell[75889, 1811, 259, 4, 24, "Print"],
Cell[76151, 1817, 289, 4, 24, "Print"],
Cell[76443, 1823, 292, 4, 24, "Print"],
Cell[76738, 1829, 292, 4, 24, "Print"],
Cell[77033, 1835, 463, 9, 45, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[77545, 1850, 203, 3, 45, "Subsection"],
Cell[CellGroupData[{
Cell[77773, 1857, 628, 13, 34, "Input"],
Cell[CellGroupData[{
Cell[78426, 1874, 1203, 21, 24, "Print"],
Cell[79632, 1897, 961, 13, 24, "Print"],
Cell[80596, 1912, 1143, 18, 24, "Print"],
Cell[81742, 1932, 1185, 19, 24, "Print"],
Cell[82930, 1953, 994, 14, 24, "Print"],
Cell[83927, 1969, 1474, 25, 24, "Print"],
Cell[85404, 1996, 1076, 17, 24, "Print"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[86529, 2019, 1267, 24, 36, "Input"],
Cell[87799, 2045, 98371, 2434, 1292, "Output"]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[186219, 4485, 152, 2, 37, "Subsection"],
Cell[CellGroupData[{
Cell[186396, 4491, 441, 9, 34, "Input"],
Cell[CellGroupData[{
Cell[186862, 4504, 125, 2, 24, "Print"],
Cell[186990, 4508, 348, 9, 24, "Print"],
Cell[187341, 4519, 103, 1, 24, "Print"],
Cell[187447, 4522, 285, 6, 24, "Print"],
Cell[187735, 4530, 136, 2, 24, "Print"],
Cell[187874, 4534, 617, 13, 24, "Print"],
Cell[188494, 4549, 218, 5, 24, "Print"],
Cell[188715, 4556, 572, 12, 24, "Print"],
Cell[189290, 4570, 117, 1, 24, "Print"],
Cell[189410, 4573, 386, 10, 24, "Print"],
Cell[189799, 4585, 338, 9, 24, "Print"],
Cell[190140, 4596, 312, 6, 24, "Print"],
Cell[190455, 4604, 338, 9, 24, "Print"],
Cell[190796, 4615, 296, 6, 24, "Print"],
Cell[191095, 4623, 102, 1, 24, "Print"],
Cell[191200, 4626, 124, 2, 24, "Print"],
Cell[191327, 4630, 315, 6, 24, "Print"],
Cell[191645, 4638, 473, 9, 24, "Print"],
Cell[192121, 4649, 96, 1, 24, "Print"],
Cell[192220, 4652, 83, 1, 24, "Print"]
}, Open  ]]
}, Open  ]]
}, Closed]]
}, Closed]]
}, Open  ]]
}
]
*)

