# This file was automatically created by FeynRules 2.3.13
# Mathematica version: 9.0 for Mac OS X x86 (64-bit) (January 24, 2013)
# Date: Sun 4 Dec 2016 10:20:08



from object_library import all_parameters, Parameter


from function_library import complexconjugate, re, im, csc, sec, acsc, asec, cot

# This is a default parameter object representing 0.
ZERO = Parameter(name = 'ZERO',
                 nature = 'internal',
                 type = 'real',
                 value = '0.0',
                 texname = '0')

# This is a default parameter object representing the renormalization scale (MU_R).
MU_R = Parameter(name = 'MU_R',
                 nature = 'external',
                 type = 'real',
                 value = 91.188,
                 texname = '\\text{\\mu_r}',
                 lhablock = 'LOOP',
                 lhacode = [1])

# User-defined parameters.
Lambda = Parameter(name = 'Lambda',
                   nature = 'external',
                   type = 'real',
                   value = 1000,
                   texname = '\\Lambda',
                   lhablock = 'DIM6',
                   lhacode = [ 1 ])

YHt = Parameter(name = 'YHt',
                nature = 'external',
                type = 'real',
                value = 0.7,
                texname = '\\text{YH}_t',
                lhablock = 'DIM6',
                lhacode = [ 2 ])

YHt5 = Parameter(name = 'YHt5',
                 nature = 'external',
                 type = 'real',
                 value = 0,
                 texname = '\\text{YH}_{\\text{t5}}',
                 lhablock = 'DIM6',
                 lhacode = [ 3 ])

CtG = Parameter(name = 'CtG',
                nature = 'external',
                type = 'real',
                value = -0.00009823,
                texname = '\\text{RC}_{\\text{tG}}',
                lhablock = 'DIM6',
                lhacode = [ 4 ])

CphiG = Parameter(name = 'CphiG',
                  nature = 'external',
                  type = 'real',
                  value = -0.00938,
                  texname = '\\text{RC}_{\\text{phiG}}',
                  lhablock = 'DIM6',
                  lhacode = [ 5 ])

CphiG5 = Parameter(name = 'CphiG5',
                   nature = 'external',
                   type = 'real',
                   value = 0,
                   texname = '\\text{RC}_{\\text{phiG5}}',
                   lhablock = 'DIM6',
                   lhacode = [ 6 ])

YHf = Parameter(name = 'YHf',
                nature = 'external',
                type = 'real',
                value = 0.7,
                texname = '\\text{YH}_f',
                lhablock = 'DIM6',
                lhacode = [ 7 ])

YHf5 = Parameter(name = 'YHf5',
                 nature = 'external',
                 type = 'real',
                 value = 0,
                 texname = '\\text{YH}_{\\text{f5}}',
                 lhablock = 'DIM6',
                 lhacode = [ 8 ])

muprime = Parameter(name = 'muprime',
                    nature = 'external',
                    type = 'real',
                    value = 172.5,
                    texname = '\\text{$\\mu $1}',
                    lhablock = 'DIM6',
                    lhacode = [ 9 ])

muyukawa = Parameter(name = 'muyukawa',
                     nature = 'external',
                     type = 'real',
                     value = 172.5,
                     texname = '\\text{$\\mu $2}',
                     lhablock = 'DIM6',
                     lhacode = [ 10 ])

creal = Parameter(name = 'creal',
                  nature = 'external',
                  type = 'real',
                  value = 1.06614,
                  texname = 'c_{\\text{real}}',
                  lhablock = 'DIM6',
                  lhacode = [ 11 ])

cimag = Parameter(name = 'cimag',
                  nature = 'external',
                  type = 'real',
                  value = 1.17661,
                  texname = 'c_{\\text{imag}}',
                  lhablock = 'DIM6',
                  lhacode = [ 12 ])

cc = Parameter(name = 'cc',
               nature = 'external',
               type = 'real',
               value = 1,
               texname = 'c_c',
               lhablock = 'DIM6',
               lhacode = [ 13 ])

aEWM1 = Parameter(name = 'aEWM1',
                  nature = 'external',
                  type = 'real',
                  value = 127.9,
                  texname = '\\text{aEWM1}',
                  lhablock = 'SMINPUTS',
                  lhacode = [ 1 ])

Gf = Parameter(name = 'Gf',
               nature = 'external',
               type = 'real',
               value = 0.0000116637,
               texname = 'G_f',
               lhablock = 'SMINPUTS',
               lhacode = [ 2 ])

aS = Parameter(name = 'aS',
               nature = 'external',
               type = 'real',
               value = 0.1184,
               texname = '\\alpha _s',
               lhablock = 'SMINPUTS',
               lhacode = [ 3 ])

ymt = Parameter(name = 'ymt',
                nature = 'external',
                type = 'real',
                value = 172.5,
                texname = '\\text{ymt}',
                lhablock = 'YUKAWA',
                lhacode = [ 6 ])

ymtau = Parameter(name = 'ymtau',
                  nature = 'external',
                  type = 'real',
                  value = 1.777,
                  texname = '\\text{ymtau}',
                  lhablock = 'YUKAWA',
                  lhacode = [ 15 ])

MZ = Parameter(name = 'MZ',
               nature = 'external',
               type = 'real',
               value = 91.1876,
               texname = '\\text{MZ}',
               lhablock = 'MASS',
               lhacode = [ 23 ])

MTA = Parameter(name = 'MTA',
                nature = 'external',
                type = 'real',
                value = 1.777,
                texname = '\\text{MTA}',
                lhablock = 'MASS',
                lhacode = [ 15 ])

MT = Parameter(name = 'MT',
               nature = 'external',
               type = 'real',
               value = 172.5,
               texname = '\\text{MT}',
               lhablock = 'MASS',
               lhacode = [ 6 ])

MH = Parameter(name = 'MH',
               nature = 'external',
               type = 'real',
               value = 125,
               texname = '\\text{MH}',
               lhablock = 'MASS',
               lhacode = [ 25 ])

MHH = Parameter(name = 'MHH',
                nature = 'external',
                type = 'real',
                value = 600,
                texname = '\\text{MHH}',
                lhablock = 'MASS',
                lhacode = [ 900025 ])

MHA = Parameter(name = 'MHA',
                nature = 'external',
                type = 'real',
                value = 800,
                texname = '\\text{MHA}',
                lhablock = 'MASS',
                lhacode = [ 900026 ])

WZ = Parameter(name = 'WZ',
               nature = 'external',
               type = 'real',
               value = 2.4952,
               texname = '\\text{WZ}',
               lhablock = 'DECAY',
               lhacode = [ 23 ])

WW = Parameter(name = 'WW',
               nature = 'external',
               type = 'real',
               value = 2.085,
               texname = '\\text{WW}',
               lhablock = 'DECAY',
               lhacode = [ 24 ])

WT = Parameter(name = 'WT',
               nature = 'external',
               type = 'real',
               value = 1.50833649,
               texname = '\\text{WT}',
               lhablock = 'DECAY',
               lhacode = [ 6 ])

WH = Parameter(name = 'WH',
               nature = 'external',
               type = 'real',
               value = 0.00407,
               texname = '\\text{WH}',
               lhablock = 'DECAY',
               lhacode = [ 25 ])

WHH = Parameter(name = 'WHH',
                nature = 'external',
                type = 'real',
                value = 80,
                texname = '\\text{WHH}',
                lhablock = 'DECAY',
                lhacode = [ 900025 ])

WHA = Parameter(name = 'WHA',
                nature = 'external',
                type = 'real',
                value = 80,
                texname = '\\text{WHA}',
                lhablock = 'DECAY',
                lhacode = [ 900026 ])

aEW = Parameter(name = 'aEW',
                nature = 'internal',
                type = 'real',
                value = '1/aEWM1',
                texname = '\\alpha _{\\text{EW}}')

ccc = Parameter(name = 'ccc',
                nature = 'internal',
                type = 'complex',
                value = 'cc*(creal + cimag*complex(0,1))',
                texname = 'c_{\\text{complex}}')

G = Parameter(name = 'G',
              nature = 'internal',
              type = 'real',
              value = '2*cmath.sqrt(aS)*cmath.sqrt(cmath.pi)',
              texname = 'G')

MW = Parameter(name = 'MW',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(MZ**2/2. + cmath.sqrt(MZ**4/4. - (aEW*cmath.pi*MZ**2)/(Gf*cmath.sqrt(2))))',
               texname = 'M_W')

ee = Parameter(name = 'ee',
               nature = 'internal',
               type = 'real',
               value = '2*cmath.sqrt(aEW)*cmath.sqrt(cmath.pi)',
               texname = 'e')

sw2 = Parameter(name = 'sw2',
                nature = 'internal',
                type = 'real',
                value = '1 - MW**2/MZ**2',
                texname = '\\text{sw2}')

cw = Parameter(name = 'cw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(1 - sw2)',
               texname = 'c_w')

sw = Parameter(name = 'sw',
               nature = 'internal',
               type = 'real',
               value = 'cmath.sqrt(sw2)',
               texname = 's_w')

g1 = Parameter(name = 'g1',
               nature = 'internal',
               type = 'real',
               value = 'ee/cw',
               texname = 'g_1')

gw = Parameter(name = 'gw',
               nature = 'internal',
               type = 'real',
               value = 'ee/sw',
               texname = 'g_w')

vev = Parameter(name = 'vev',
                nature = 'internal',
                type = 'real',
                value = '(2*MW*sw)/ee',
                texname = '\\text{vev}')

lam = Parameter(name = 'lam',
                nature = 'internal',
                type = 'real',
                value = 'MH**2/(2.*vev**2)',
                texname = '\\text{lam}')

yt = Parameter(name = 'yt',
               nature = 'internal',
               type = 'real',
               value = '(ymt*cmath.sqrt(2))/vev',
               texname = '\\text{yt}')

ytau = Parameter(name = 'ytau',
                 nature = 'internal',
                 type = 'real',
                 value = '(ymtau*cmath.sqrt(2))/vev',
                 texname = '\\text{ytau}')

muH = Parameter(name = 'muH',
                nature = 'internal',
                type = 'real',
                value = 'cmath.sqrt(lam*vev**2)',
                texname = '\\mu')

I2b33 = Parameter(name = 'I2b33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'yt',
                  texname = '\\text{I2b33}')

I3b33 = Parameter(name = 'I3b33',
                  nature = 'internal',
                  type = 'complex',
                  value = 'yt',
                  texname = '\\text{I3b33}')

