(***************************************************************************************************************)
(******     This is the FeynRules mod-file for four top production      ******)
(******                                                                                                   ******)
(******     Authors: C. Degrande                                                                          ******)
(******                                                                                                   ******)
(***************************************************************************************************************)

M$ModelName = "4topEFT";


M$Information = {Authors -> {"C. Degrande"}, 
             Version -> "1.0",
             Date -> "31.01. 2017",
             Institutions -> {"CERN"},
             Emails -> {"celine.degrande@cern.ch"},
             URLs -> "http://feynrules.phys.ucl.ac.be"};


M$InteractionOrderHierarchy = {
{NP,1}
}

M$InteractionOrderLimit = {
{NP,2}
}



(****************  Parameters *************)

M$Parameters = {

(* External parameters *)


  CRL2== {
        ParameterType -> External,
        BlockName -> DIM6,
	  InteractionOrder -> { NP, 2},
        Value -> 1,
	  TeX -> Subscript[C,R]/\[CapitalLambda]^2,
        Description -> "coefficient of OR in TeV-2"},
                
  C1LL2== {
        ParameterType -> External,
        BlockName -> DIM6,
	  InteractionOrder -> { NP, 2},
        Value -> 1,
	  TeX -> Subsuperscript[C,L,1]/\[CapitalLambda]^2,
        Description -> "coefficient of O1L in TeV-2"},
                
  C8LL2== {
        ParameterType -> External,
        BlockName -> DIM6,
	  InteractionOrder -> { NP, 2},
        Value -> 1,
	  TeX -> Subsuperscript[C,L,8]/\[CapitalLambda]^2,
        Description -> "coefficient of O8L in TeV-2"},
                
  C1BL2== {
        ParameterType -> External,
        BlockName -> DIM6,
	  InteractionOrder -> { NP, 2},
        Value -> 1,
	  TeX -> Subsuperscript[C,B,1]/\[CapitalLambda]^2,
        Description -> "coefficient of O1B in TeV-2"},
                
  C8BL2== {
        ParameterType -> External,
        BlockName -> DIM6,
	  InteractionOrder -> { NP, 2},
        Value -> 1,
	  TeX -> Subsuperscript[C,B,8]/\[CapitalLambda]^2,
        Description -> "coefficient of O8B in TeV-2"}

}

L4top= (C8BL2 Module[{ii,jj,kk,kk1,jj1,mu,aa,cc,sp1,sp2,sp3,sp4,cc1,cc2,cc3},  (QLbar[sp1,jj,3,cc].QL[sp2,jj,3,cc2] Ga[mu,sp1,sp2]) T[aa,cc,cc2]T[aa,cc3,cc4] uRbar[sp3,3,cc3].uR[sp4,3,cc4] Ga[mu,sp3,sp4]]+
 C1BL2 Module[{ii,jj,kk,kk1,jj1,mu,aa,cc,sp1,sp2,sp3,sp4,cc1,cc2,cc3},  (QLbar[sp1,jj,3,cc].QL[sp2,jj,3,cc] Ga[mu,sp1,sp2])  uRbar[sp3,3,cc3].uR[sp4,3,cc3] Ga[mu,sp3,sp4]]+
 C8LL2 Module[{ii,jj,kk,kk1,jj1,mu,aa,cc,sp1,sp2,sp3,sp4,cc1,cc2,cc3},  (QLbar[sp1,jj,3,cc].QL[sp2,jj,3,cc2] Ga[mu,sp1,sp2]) T[aa,cc,cc2]T[aa,cc3,cc4] QLbar[sp3,ii,3,cc3].QL[sp4,ii,3,cc4] Ga[mu,sp3,sp4]]+
C1LL2 Module[{ii,jj,kk,kk1,jj1,mu,aa,cc,sp1,sp2,sp3,sp4,cc1,cc2,cc3},  (QLbar[sp1,jj,3,cc].QL[sp2,jj,3,cc] Ga[mu,sp1,sp2]) QLbar[sp3,ii,3,cc3].QL[sp4,ii,3,cc3] Ga[mu,sp3,sp4]]+
 CRL2 Module[{ii,jj,kk,kk1,jj1,mu,aa,cc,sp1,sp2,sp3,sp4,cc1,cc2,cc3},  (uRbar[sp1,3,cc].uR[sp2,3,cc] Ga[mu,sp1,sp2]) uRbar[sp3,3,cc3].uR[sp4,3,cc3] Ga[mu,sp3,sp4]])/1000^2;