
M$ModelName = "368_sextets";

(* 
   
   The convention and notations follow 0909.2666 and the models "Sextet diquarks" and "Triplet diquarks" available on the FeynRules Model Database. 

   The new particles and quantum numbers are

   sFu  =  (6, 1, -2/3)
   sFd  =  (6, 1, 1/3)
   sSu  =  (6, 1, 1/3) (Lepton number -1)
   sSd  =  (6, 1, 4/3) (Lepton number -1)

*)

M$Information = {Authors -> {"T. Murphy"}, 
             Version -> "1.0",
             Date -> "10. 09. 2021",
             Institutions -> {"The Ohio State University"},
             Emails -> {"murphy.1573@osu.edu"}};

IndexRange[Index[Sextet]] = Range[6];
IndexStyle[ Sextet, u];

AddGaugeRepresentation[SU3C -> {T6, Sextet}];

(* CGC matrices for 3 * 3 ~ 6 (K6/K6bar) are symmetric *)

(*

SetAttributes[CFu, Orderless];
SetAttributes[CFd, Orderless];
SetAttributes[CSu, Orderless];
SetAttributes[CSd, Orderless];
SetAttributes[CFBu, Orderless];
SetAttributes[CFBd, Orderless];

*)

M$Parameters = {

(* External parameters *)

   CFBuR == {Indices -> {Index[Generation]},
              ParameterType -> External,
              BlockName     -> SFBUR,
              Value         -> {CFBuR[_] -> 0.1},
              ComplexParameter -> False,
              InteractionOrder -> {QCD, 1}
            },

   CFBuI == {Indices -> {Index[Generation]},
              ParameterType -> External,
              BlockName     -> SFBUI,
              Value         -> {CFBuI[_] -> 0},
              ComplexParameter -> False,
              InteractionOrder -> {QCD, 1}
            },

   CFBdR == {Indices -> {Index[Generation]},
              ParameterType -> External,
              BlockName     -> SFBDR,
              Value         -> {CFBdR[_] -> 0.1},
              ComplexParameter -> False,
              InteractionOrder -> {QCD, 1}
            },

   CFBdI == {Indices -> {Index[Generation]},
              ParameterType -> External,
              BlockName     -> SFBDI,
              Value         -> {CFBdI[_] -> 0},
              ComplexParameter -> False,
              InteractionOrder -> {QCD, 1}
            },


   CFuR == {Indices -> {Index[Generation]},
             BlockName -> SFUPR,
             Value -> {CFuR[_]  -> 0.1},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False 
            },

   CFuI == {Indices -> {Index[Generation]},
             BlockName -> SFUPI,
             Value -> {CFuI[_]  -> 0},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False 
            },

   CFdR == {Indices -> {Index[Generation]},
             BlockName -> SFDOWNR,
             Value -> {CFdR[_]  -> 0.1},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False 
            },

   CFdI == {Indices -> {Index[Generation]},
             BlockName -> SFDOWNI,
             Value -> {CFdI[_]  -> 0},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False 
            },
 
   CSuR == {Indices -> {Index[Generation], Index[Generation]},
             BlockName -> SSUPR,
             Value -> {CSuR[_,_]  -> 0.1},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False 
            },

   CSuI == {Indices -> {Index[Generation], Index[Generation]},
             BlockName -> SSUPI,
             Value -> {CSuI[_,_]  -> 0},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False 
            },

   CSdR == {Indices -> {Index[Generation], Index[Generation]},
             BlockName -> SSDOWNR,
             Value -> {CSdR[_,_]  -> 0.1},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False 
            },

   CSdI == {Indices -> {Index[Generation], Index[Generation]},
             BlockName -> SSDOWNI,
             Value -> {CSdI[_,_]  -> 0},
             InteractionOrder -> {QCD, 1},
             ParameterType -> External,
             ComplexParameter -> False 
            },

(* Internal parameters *)

   CFBu == {Indices -> {Index[Generation]},
            Value -> {CFBu[i_] :> CFBuR[i] + I CFBuI[i]},
            InteractionOrder -> {QCD, 1},
            ComplexParameter -> True,
            Description -> "Sextet fermion coupling to up-type quarks and B boson"
            },

   CFBd == {Indices -> {Index[Generation]},
            Value -> {CFBd[i_] :> CFBdR[i] + I CFBdI[i]},
            InteractionOrder -> {QCD, 1},
            ComplexParameter -> True,
            Description -> "Sextet fermion coupling to down-type quarks and B boson"
            },

   CFu == {Indices -> {Index[Generation]},
            Value -> {CFu[i_] :> CFuR[i] + I CFuI[i]},
            InteractionOrder -> {QCD, 1},
            ComplexParameter -> True,
            Description -> "Sextet fermion coupling to up-type quarks"
            },

   CFd == {Indices -> {Index[Generation]},
            Value -> {CFd[i_] :> CFdR[i] + I CFdI[i]},
            InteractionOrder -> {QCD, 1},
            ComplexParameter -> True,
            Description -> "Sextet fermion coupling to down-type quarks"
            },

   CSu == {Indices -> {Index[Generation], Index[Generation]},
            Value -> {CSu[i_,j_] :> CSuR[i,j] + I CSuI[i,j]},
            InteractionOrder -> {QCD, 1},
            ComplexParameter -> True,
            Description -> "Sextet scalar coupling to up-type quarks"
            },

   CSd == {Indices -> {Index[Generation], Index[Generation]},
            Value -> {CSd[i_,j_] :> CSdR[i,j] + I CSdI[i,j]},
            InteractionOrder -> {QCD, 1},
            ComplexParameter -> True,
            Description -> "Sextet scalar coupling to down-type quarks"
            }

};

M$ClassesDescription = {

   F[100] == {
      ClassName -> sFu,
      SelfConjugate -> False,
      Indices -> {Index[Sextet]},
      Mass ->    {MFu, 500},
      Width ->   {WFu, 4.7740},
      QuantumNumbers -> {Q -> -2/3}
     },

   F[200] == {
      ClassName -> sFd,
      SelfConjugate -> False,
      Indices -> {Index[Sextet]},
      Mass ->    {MFd, 500},
      Width ->   {WFd, 4.7740},
      QuantumNumbers -> {Q -> 1/3}
     },

   S[100] == {
      ClassName -> sSu,
      SelfConjugate -> False,
      Indices -> {Index[Sextet]},
      Mass ->    {MSu, 500},
      Width ->   {WSu, 4.4108},
      QuantumNumbers -> {Q -> 1/3, LeptonNumber -> -1}
     },

   S[200] == {
      ClassName -> sSd,
      SelfConjugate -> False,
      Indices -> {Index[Sextet]},
      Mass ->    {MSd, 500},
      Width ->   {WSd, 4.0647},
      QuantumNumbers -> {Q -> 4/3, LeptonNumber -> -1}
     }

};


(* the Lagrangian *)
(* Hermitian conjugates are written semi-manually so MG5_aMC understands triplet/antitriplet color flow *)


LSextetKin :=    sFubar[ss,kk].(I Ga[mu,ss,rr].DC[sFu[rr,kk],mu] - MFu sFu[ss,kk]) +
               + sFdbar[ss,kk].(I Ga[mu,ss,rr].DC[sFd[rr,kk],mu] - MFd sFd[ss,kk]) +
               + DC[sSubar[kk], mu]DC[sSu[kk],mu] - MSu^2 sSubar[kk]sSu[kk] +
               + DC[sSdbar[kk], mu]DC[sSd[kk],mu] - MSd^2 sSdbar[kk]sSd[kk];

LFu  :=    CFu[mm] I Sqrt[2] K6[kk,yy,zz] T[aa,zz,xx] K3bar[ii,xx,yy] sFubar[ss,kk].(I/2)(Ga[mu,ss,rr].Ga[nu,rr,tt]-Ga[nu,ss,rr].Ga[mu,rr,tt]).CC[uR][tt,mm,ii] FS[G,mu,nu,aa] +
         + HC[CFu[mm]] (-I Sqrt[2]) K3[ii,xx,yy] T[aa,xx,zz] K6bar[kk,zz,yy] HC[sFubar[ss,kk].(I/2)(Ga[mu,ss,rr].Ga[nu,rr,tt]-Ga[nu,ss,rr].Ga[mu,rr,tt]).CC[uR][tt,mm,ii]] FS[G,mu,nu,aa] +
         + CFBu[mm] I Sqrt[2] K6[kk,yy,zz] T[aa,zz,xx] K3bar[ii,xx,yy] sFubar[ss,kk].CC[uR][ss,mm,ii] FS[G,mu,nu,aa] FS[B,mu,nu] +
         + HC[CFBu[mm]] (-I Sqrt[2]) K3[ii,xx,yy] T[aa,xx,zz] K6bar[kk,zz,yy] HC[sFubar[ss,kk].CC[uR][ss,mm,ii]] FS[G,mu,nu,aa] FS[B,mu,nu];

LFd  :=    CFd[mm] I Sqrt[2] K6[kk,yy,zz] T[aa,zz,xx] K3bar[ii,xx,yy] sFdbar[ss,kk].(I/2)(Ga[mu,ss,rr].Ga[nu,rr,tt]-Ga[nu,ss,rr].Ga[mu,rr,tt]).CC[dR][tt,mm,ii] FS[G,mu,nu,aa] +
         + HC[CFd[mm]] (-I Sqrt[2]) K3[ii,xx,yy] T[aa,xx,zz] K6bar[kk,zz,yy] HC[sFdbar[ss,kk].(I/2)(Ga[mu,ss,rr].Ga[nu,rr,tt]-Ga[nu,ss,rr].Ga[mu,rr,tt]).CC[dR][tt,mm,ii]] FS[G,mu,nu,aa] +
         + CFBd[mm] I Sqrt[2] K6[kk,yy,zz] T[aa,zz,xx] K3bar[ii,xx,yy] sFdbar[ss,kk].CC[dR][ss,mm,ii] FS[G,mu,nu,aa] FS[B,mu,nu] +
         + HC[CFBd[mm]] (-I Sqrt[2]) K3[ii,xx,yy] T[aa,xx,zz] K6bar[kk,zz,yy] HC[sFdbar[ss,kk].CC[dR][ss,mm,ii]] FS[G,mu,nu,aa] FS[B,mu,nu];

LSu  :=    CSu[mm,ll] I Sqrt[2] K6[kk,yy,zz] T[aa,zz,xx] K3bar[ii,xx,yy] sSubar[kk] lRbar[ss,ll].(I/2)(Ga[mu,ss,rr].Ga[nu,rr,tt]-Ga[nu,ss,rr].Ga[mu,rr,tt]).CC[uR][tt,mm,ii] FS[G,mu,nu,aa] +
         + HC[CSu[mm,ll]] (-I Sqrt[2]) K3[ii,xx,yy] T[aa,xx,zz] K6bar[kk,zz,yy] HC[sSubar[kk] lRbar[ss,ll].(I/2)(Ga[mu,ss,rr].Ga[nu,rr,tt]-Ga[nu,ss,rr].Ga[mu,rr,tt]).CC[uR][tt,mm,ii] FS[G,mu,nu,aa]];

LSd  :=    CSd[mm,ll] I Sqrt[2] K6[kk,yy,zz] T[aa,zz,xx] K3bar[ii,xx,yy] sSdbar[kk] lRbar[ss,ll].(I/2)(Ga[mu,ss,rr].Ga[nu,rr,tt]-Ga[nu,ss,rr].Ga[mu,rr,tt]).CC[dR][tt,mm,ii] FS[G,mu,nu,aa] +
         + HC[CSd[mm,ll]] (-I Sqrt[2]) K3[ii,xx,yy] T[aa,xx,zz] K6bar[kk,zz,yy] HC[sSdbar[kk] lRbar[ss,ll].(I/2)(Ga[mu,ss,rr].Ga[nu,rr,tt]-Ga[nu,ss,rr].Ga[mu,rr,tt]).CC[dR][tt,mm,ii] FS[G,mu,nu,aa]];

LSextet := LSextetKin + LFu + LFd + LSu + LSd;
