(***************************************************************************************************************)
(******      This is the FeynRules mod-file for the 331 model where beta equals to -1/Sqrt[3] ******)
(******                                                                                                   ******)
(******     Authors: Dongming Zhang          ******)
(******                                                                                                   ******)
(****** Choose whether Feynman gauge is desired.                                                          ******)
(****** If set to False, unitary gauge is assumed.                                                          ****)
(****** Feynman gauge is especially useful for CalcHEP/CompHEP where the calculation is 10-100 times faster. ***)
(****** Feynman gauge is not supported in MadGraph and Sherpa.                                              ****)
(***************************************************************************************************************)

(* ************************** *)
(* *****  Information   ***** *)
(* ************************** *)
M$ModelName = "331_-1 Model";

M$Information = {
  Authors      -> {"Dongming Zhang"}, 
  Version      -> "1.0.0",
  Date         -> "22. 01. 2014",
  Institutions -> {"Peking University"},
  Emails       -> {"zhangdongming@pku.edu.cn"},
  URLs         -> "http://feynrules.irmp.ucl.ac.be/wiki/331"
};

FeynmanGauge = True;

(* ************************** *)
(* *****  Change  log   ***** *)
(* ************************** *)

(* ************************** *)
(* *****      vevs      ***** *)
(* ************************** *)
M$vevs = { {Rho[2],v}, {Phi[1],v2}, {Chi[3],v3} };

(* ************************** *)
(* *****  Gauge groups  ***** *)
(* ************************** *)
M$GaugeGroups = {
  U1X  == { 
    Abelian          -> True,  
    CouplingConstant -> gx, 
    GaugeBoson       -> K, 
    Charge           -> X
  },
  SU3L == { 
    Abelian           -> False, 
    CouplingConstant  -> gw, 
    GaugeBoson        -> Wi, 
    StructureConstant -> x, 
    Representations   -> {Ta,SU3T},
    Definitions       -> {Ta[a_,b_,c_]->Gellmann[a,b,c]/2,FSU3L[i_,j_,k_]:> I x[i,j,k]},
    SymmetricTensor   -> dSUN
  },
  ASU3L == {
    Abelian           -> False, 
    CouplingConstant  -> gw, 
    GaugeBoson        -> WWi, 
    StructureConstant -> x, 
    Representations   -> {Tb,ASU3T},
    Definitions       -> {Tb[a_,b_,c_]->-Gellmann[a,c,b]/2,FSU3L[i_,j_,k_]:> I x[i,j,k]},
    SymmetricTensor   -> dSUN
  },
  SU3C == { 
    Abelian           -> False, 
    CouplingConstant  -> gs, 
    GaugeBoson        -> G,
    StructureConstant -> f, 
    Representations   -> {T,Colour}, 
    SymmetricTensor   -> dSUN
  } 
};

(* ************************** *)
(* *** Gellmann matrices  *** *)
(* ************************** *)

Table[Gellmann[i, j, k] = 0, {i, 1, 8}, {j, 1, 3}, {k, 1, 3}] // 
  Flatten;

Gellmann[1] = {{0, 1, 0}, {1, 0, 0}, {0, 0, 0}};
Gellmann[2] = {{0, -I, 0}, {I, 0, 0}, {0, 0, 0}};
Gellmann[3] = {{1, 0, 0}, {0, -1, 0}, {0, 0, 0}};
Gellmann[4] = {{0, 0, 1}, {0, 0, 0}, {1, 0, 0}};
Gellmann[5] = {{0, 0, -I}, {0, 0, 0}, {I, 0, 0}};
Gellmann[6] = {{0, 0, 0}, {0, 0, 1}, {0, 1, 0}};
Gellmann[7] = {{0, 0, 0}, {0, 0, -I}, {0, I, 0}};
Gellmann[8] = 1/Sqrt[3] {{1, 0, 0}, {0, 1, 0}, {0, 0, -2}};

Gellmann[1, 1, 2] = 1; Gellmann[1, 2, 1] = 1;
Gellmann[2, 1, 2] = -I; Gellmann[2, 2, 1] = I;
Gellmann[3, 1, 1] = 1; Gellmann[3, 2, 2] = -1;
Gellmann[4, 1, 3] = 1; Gellmann[4, 3, 1] = 1;
Gellmann[5, 1, 3] = -I; Gellmann[5, 3, 1] = I;
Gellmann[6, 2, 3] = 1; Gellmann[6, 3, 2] = 1;
Gellmann[7, 2, 3] = -I; Gellmann[7, 3, 2] = I;
Gellmann[8, 1, 1] = 1/Sqrt[3]; Gellmann[8, 2, 2] = 1/Sqrt[3];
Gellmann[8, 3, 3] = -2/Sqrt[3];


Gellmann[i_Integer, j_Integer, k_Integer] := Gellmann[i][[j, k]];
Gellmann[xx___, Index[_, i_Integer], yy___] := Gellmann[xx, i, yy];

Gellmann /: 
  Gellmann[i1_, i2_, i3_?(Not[NumericQ[#]] &)] Gellmann[j1_, i3_, 
    j3_] :=     
  Gellmann[i1, i2, 1] Gellmann[j1, 1, j3] + 
   Gellmann[i1, i2, 2] Gellmann[j1, 2, j3] +
   Gellmann[i1, i2, 3] Gellmann[j1, 3, j3];

Table[x[i, j, k] = 0, {i, 1, 8}, {j, 1, 8}, {k, 1, 8}] // Flatten;
x[1, 2, 3] = 1; x[2, 3, 1] = 1; x[3, 1, 2] = 1;
x[2, 1, 3] = -1; x[1, 3, 2] = -1; x[3, 2, 1] = -1;
x[1, 5, 6] = -1/2; x[3, 6, 7] = -1/2; x[1, 7, 4] = -1/2; 
x[2, 6, 4] = -1/2; x[2, 7, 5] = -1/2; x[3, 5, 4] = -1/2; 
x[6, 1, 5] = -1/2; x[7, 3, 6] = -1/2; x[4, 1, 7] = -1/2; 
x[4, 2, 6] = -1/2; x[5, 2, 7] = -1/2; x[4, 3, 5] = -1/2; 
x[5, 6, 1] = -1/2; x[6, 7, 3] = -1/2; x[7, 4, 1] = -1/2; 
x[6, 4, 2] = -1/2; x[7, 5, 2] = -1/2; x[5, 4, 3] = -1/2;
x[1, 6, 5] = 1/2; x[3, 7, 6] = 1/2; x[1, 4, 7] = 1/2; 
x[2, 4, 6] = 1/2; x[2, 5, 7] = 1/2; x[3, 4, 5] = 1/2; 
x[5, 1, 6] = 1/2; x[7, 6, 3] = 1/2; x[4, 7, 1] = 1/2; 
x[4, 6, 2] = 1/2; x[5, 7, 2] = 1/2; x[4, 5, 3] = 1/2; 
x[6, 5, 1] = 1/2; x[6, 3, 7] = 1/2; x[7, 1, 4] = 1/2; 
x[6, 2, 4] = 1/2; x[7, 2, 5] = 1/2; x[5, 3, 4] = 1/2;
x[4, 5, 8] = Sqrt[3]/2; x[6, 7, 8] = Sqrt[3]/2; 
x[8, 4, 5] = Sqrt[3]/2; x[8, 6, 7] = Sqrt[3]/2; 
x[5, 8, 4] = Sqrt[3]/2; x[7, 8, 6] = Sqrt[3]/2;
x[4, 8, 5] = -Sqrt[3]/2; x[6, 8, 7] = -Sqrt[3]/2; 
x[5, 4, 8] = -Sqrt[3]/2;
x[7, 6, 8] = -Sqrt[3]/2; x[8, 7, 6] = -Sqrt[3]/2; 
x[8, 5, 4] = -Sqrt[3]/2;

x /: x[ii___, Except[Index[___] | _?NumericQ, jj_], kk___] f_[aa___, 
    Index[name_, jj_], cc___] := 
  x[ii, Index[name, jj], kk] f[aa, Index[name, jj], cc];
x /: x[ii___, Except[Index[___] | _?NumericQ, jj_], 
    kk___] f_[aa___, Index[name_, jj_], cc___][ind___] := 
  x[ii, Index[name, jj], kk] f[aa, Index[name, jj], cc][ind];
x /: x[ii___, Except[Index[___] | _?NumericQ, jj_], kk___] f_[aa___, 
    g_[xx___, Index[name_, jj_], yy___], cc___] := 
  x[ii, Index[name, jj], kk] f[aa, g[xx, Index[name, jj], yy], cc];
x /: x[ii___, Except[Index[___] | _?NumericQ, jj_], 
    kk___] f_[aa___, g_[xx___, Index[name_, jj_], yy___], cc___][
    ind___] := 
  x[ii, Index[name, jj], kk] f[aa, g[xx, Index[name, jj], yy], cc][
    ind];

x[ii___, Except[_Index | _Done[Index] | _FV, 
    jj_?(Not[NumericQ[#]] &)], kk___, Index[name_, ll_], mm___] := 
  x[ii, Index[name, jj], kk, Index[name, ll], mm];
x[ii___, Index[name_, ll_], kk___, 
   Except[_Index | _Done[Index] | _FV, jj_?(Not[NumericQ[#]] &)], 
   mm___] := x[ii, Index[name, ll], kk, Index[name, jj], mm];

x /: x[i_?((Not[NumericQ[#]] && Not[MatchQ[#, Index[_, _?NumericQ]]] &&
          Not[MatchQ[#, Done[Index][_, _?NumericQ]]]) &), j_, k_] x[
    i_, m_, n_] := 
  x[1, j, k] x[1, m, n] + x[2, j, k] x[2, m, n] + 
   x[3, j, k] x[3, m, n] + x[4, j, k] x[4, m, n] + 
   x[5, j, k] x[5, m, n] + x[6, j, k] x[6, m, n] + 
   x[7, j, k] x[7, m, n] + x[8, j, k] x[8, m, n];

x /: x[i_?((Not[NumericQ[#]] && Not[MatchQ[#, Index[_, _?NumericQ]]] &&
          Not[MatchQ[#, Done[Index][_, _?NumericQ]]]) &), j_, k_] x[
    m_, n_, i_] := x[i, j, k] x[i, m, n];
x /: x[i_?((Not[NumericQ[#]] && Not[MatchQ[#, Index[_, _?NumericQ]]] &&
          Not[MatchQ[#, Done[Index][_, _?NumericQ]]]) &), j_, k_] x[
    m_, i_, n_] := x[i, j, k] x[i, n, m];
x /: x[j_, 
    i_?((Not[NumericQ[#]] && Not[MatchQ[#, Index[_, _?NumericQ]]] && 
         Not[MatchQ[#, Done[Index][_, _?NumericQ]]]) &), k_] x[m_, i_,
     n_] := x[i, k, j] x[i, n, m];
x /: x[j_, 
    i_?((Not[NumericQ[#]] && Not[MatchQ[#, Index[_, _?NumericQ]]] && 
         Not[MatchQ[#, Done[Index][_, _?NumericQ]]]) &), k_] x[m_, n_,
     i_] := x[i, k, j] x[i, m, n];
x /: x[j_, k_, 
    i_?((Not[NumericQ[#]] && Not[MatchQ[#, Index[_, _?NumericQ]]] && 
         Not[MatchQ[#, Done[Index][_, _?NumericQ]]]) &)] x[m_, n_, 
    i_] := x[i, j, k] x[i, m, n];

x /: x[___, i_, ___, j_, ___] FV[a_, i_] FV[a_, j_] := 0;
x /: x[___, i_, ___, j_, ___] del[del[_, i_], j_] := 0;
x /: x[___, i_, ___, j_, ___] del[del[_, j_], i_] := 0;

x[xx___, Index[name_, i_?NumericQ], yy___] := x[xx, i, yy];

(* ************************** *)
(* *****    Indices     ***** *)
(* ************************** *)

IndexRange[Index[SU3W      ]] = Unfold[Range[8]]; 
IndexRange[Index[ASU3W     ]] = Unfold[Range[8]];
IndexRange[Index[ASU3T     ]] = Unfold[Range[3]]; 
IndexRange[Index[SU3T      ]] = Unfold[Range[3]];
IndexRange[Index[Gluon     ]] = NoUnfold[Range[8]];
IndexRange[Index[Colour    ]] = NoUnfold[Range[3]]; 
IndexRange[Index[Generation1]] = Range[3,3];
IndexRange[Index[Generation2]] = Range[2];
IndexRange[Index[Generation]] = Range[3];

IndexStyle[SU3W,       j];
IndexStyle[ASU3W,      o];
IndexStyle[ASU3T,      p];
IndexStyle[SU3T,       k];
IndexStyle[Gluon,      a];
IndexStyle[Colour,     m];
IndexStyle[Generation1, r];
IndexStyle[Generation2, g];
IndexStyle[Generation, f];


(* ************************** *)
(* *** Interaction orders *** *)
(* ***  (as used by mg5)  *** *)
(* ************************** *)

M$InteractionOrderHierarchy = {
  {QCD, 1},
  {QED, 2}
};


(* ************************** *)
(* **** Particle classes **** *)
(* ************************** *)
M$ClassesDescription = {

(* Gauge bosons: physical vector fields *)
  V[1] == { 
    ClassName       -> A, 
    SelfConjugate   -> True,  
    Mass            -> 0,  
    Width           -> 0,  
    ParticleName    -> "a", 
    PDG             -> 22, 
    PropagatorLabel -> "a", 
    PropagatorType  -> W, 
    PropagatorArrow -> None,
    FullName        -> "Photon"
  },
  V[2] == { 
    ClassName       -> Z, 
    SelfConjugate   -> True,
    Mass            -> {MZ, 91.1876},
    Width           -> {WZ, 2.4952},
    ParticleName    -> "Z", 
    PDG             -> 23, 
    PropagatorLabel -> "Z",
    PropagatorType  -> Sine,
    PropagatorArrow -> None,
    FullName        -> "Z"
  },
  V[3] == { 
    ClassName       -> ZP, 
    SelfConjugate   -> True,
    Mass            -> {MZP, 4000},
    Width           -> {WZP, 10},
    ParticleName    -> "ZP",  
    PropagatorLabel -> "ZP",
    PropagatorType  -> Sine,
    PropagatorArrow -> None,
    FullName        -> "ZP"
  },
  V[4] == {
    ClassName        -> W,
    SelfConjugate    -> False,
    Mass             -> {MW, 80.385},
    Width            -> {WW, 2.085},
    ParticleName     -> "W+",
    AntiParticleName -> "W-",
    QuantumNumbers   -> {Q -> 1},
    PDG              -> 24, 
    PropagatorLabel  -> "W",
    PropagatorType   -> Sine,
    PropagatorArrow  -> Forward,
    FullName         -> "W"
  },
  V[5] == {
    ClassName        -> YY,
    SelfConjugate    -> False,
    Mass             -> {MY, Internal},
    Width            -> {WY, 0},
    ParticleName     -> "~YY",
    AntiParticleName -> "~YY~",
    QuantumNumbers   -> {Q -> 0},
    PropagatorLabel  -> "YY",
    PropagatorType   -> Sine,
    PropagatorArrow  -> None,
    FullName         -> "~YY"
  },
  V[6] == {
    ClassName        -> V,
    SelfConjugate    -> False,
    Mass             -> {MV, Internal},
    Width            -> {WV, 10},
    ParticleName     -> "~V+",
    AntiParticleName -> "~V-",
    QuantumNumbers   -> {Q -> 1},
    PropagatorLabel  -> "V",
    PropagatorType   -> Sine,
    PropagatorArrow  -> Forward,
    FullName         -> "~V"
  },
  V[7] == {
    ClassName        -> G,
    SelfConjugate    -> True,
    Indices          -> {Index[Gluon]},
    Mass             -> 0,
    Width            -> 0,
    ParticleName     -> "g", 
    PDG              -> 21,
    PropagatorLabel  -> "G",
    PropagatorType   -> C,
    PropagatorArrow  -> None,
    FullName         -> "G"
  },

(* Ghosts: related to physical gauge bosons *)
  U[1] == { 
    ClassName       -> ghA, 
    SelfConjugate   -> False,
    Ghost           -> A,
    QuantumNumbers  -> {GhostNumber -> 1},
    Mass            -> 0,
    Width	    -> 0,
    PropagatorLabel -> "uA",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[2] == {
    ClassName       -> ghZ,
    SelfConjugate   -> False,
    Ghost           -> Z,
    QuantumNumbers  -> {GhostNumber -> 1},
    Mass            -> {MZ,91.1876},  
    Width	    -> {WZ, 2.4952},
    PropagatorLabel -> "uZ",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[3] == {
    ClassName       -> ghZP,
    SelfConjugate   -> False,
    Ghost           -> ZP,
    QuantumNumbers  -> {GhostNumber -> 1},
    Mass            -> {MZP,4000},  
    Width	    -> {WZP, 10},
    PropagatorLabel -> "uZP",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },
  U[41] == { 
    ClassName       -> ghWp,
    SelfConjugate   -> False, 
    Ghost           -> W,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> 1},
    Mass            -> {MW, 80.385}, 
    Width           -> {WW, 2.085}, 
    PropagatorLabel -> "uWp",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[42] == { 
    ClassName       -> ghWm,
    SelfConjugate   -> False, 
    Ghost           -> Wbar,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> -1},
    Mass            -> {MW, 80.385}, 
    Width           -> {WW, 2.085},
    PropagatorLabel -> "uWm",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[51] == { 
    ClassName       -> ghYp,
    SelfConjugate   -> False, 
    Ghost           -> YY,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> 0},
    Mass            -> {MY, Internal}, 
    Width           -> {WY, 0}, 
    PropagatorLabel -> "uY",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[52] == { 
    ClassName       -> ghYm,
    SelfConjugate   -> False, 
    Ghost           -> YYbar,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> 0},
    Mass            -> {MY, Internal}, 
    Width           -> {WY, 0},
    PropagatorLabel -> "uY~",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[61] == { 
    ClassName       -> ghVp,
    SelfConjugate   -> False, 
    Ghost           -> V,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> 1},
    Mass            -> {MV,Internal}, 
    Width           -> {WV, 10}, 
    PropagatorLabel -> "uVp",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[62] == { 
    ClassName       -> ghVm,
    SelfConjugate   -> False, 
    Ghost           -> Vbar,
    QuantumNumbers  -> {GhostNumber -> 1, Q -> -1},
    Mass            -> {MV,Internal}, 
    Width           -> {WV, 10},
    PropagatorLabel -> "uVm",
    PropagatorType  -> GhostDash, 
    PropagatorArrow -> Forward
  },
  U[7] == { 
    ClassName       -> ghG, 
    SelfConjugate   -> False,
    Indices         -> {Index[Gluon]},
    Ghost           -> G,
    QuantumNumbers  ->{GhostNumber -> 1}, 
    Mass            -> 0,
    Width	    -> 0,
    PropagatorLabel -> "uG",
    PropagatorType  -> GhostDash,
    PropagatorArrow -> Forward
  },

(* Gauge bosons: unphysical vector fields *)
  V[12] == { 
    ClassName     -> K, 
    Unphysical    -> True, 
    SelfConjugate -> True, 
    Definitions   -> { K[mu_] -> c3 (cz ZP[mu]-sz Z[mu]) + s3 (-sw (cz Z[mu]+sz ZP[mu]) + cw A[mu])} 
  },
  V[13] == { 
    ClassName     -> Wi,
    Unphysical    -> True,
    SelfConjugate -> True, 
    Indices       -> {Index[SU3W]},
    FlavorIndex   -> SU3W,
    Definitions   -> { 
Wi[mu_,1] -> (Wbar[mu]+W[mu])/Sqrt[2], Wi[mu_,2] -> (Wbar[mu]-W[mu])/(I*Sqrt[2]),
Wi[mu_,4] -> (YYbar[mu]+YY[mu])/Sqrt[2], Wi[mu_,5] -> (YY[mu]-YYbar[mu])/(I*Sqrt[2]), 
Wi[mu_,6] -> (Vbar[mu]+V[mu])/Sqrt[2], Wi[mu_,7] -> (V[mu]-Vbar[mu])/(I*Sqrt[2]), 
Wi[mu_,3] -> cw (cz Z[mu]+sz ZP[mu]) + sw A[mu], Wi[mu_,8] -> -s3 (cz ZP[mu]-sz Z[mu]) + c3 (-sw (cz Z[mu]+sz ZP[mu]) +cw A[mu])} 
  },
  V[14] == { 
    ClassName     -> WWi,
    Unphysical    -> True,
    SelfConjugate -> True, 
    Indices       -> {Index[ASU3W]},
    FlavorIndex   -> ASU3W,
    Definitions   -> { 
WWi[mu_,1] -> (Wbar[mu]+W[mu])/Sqrt[2], WWi[mu_,2] -> (Wbar[mu]-W[mu])/(I*Sqrt[2]),
WWi[mu_,4] -> (YYbar[mu]+YY[mu])/Sqrt[2], WWi[mu_,5] -> (YY[mu]-YYbar[mu])/(I*Sqrt[2]),
WWi[mu_,6] -> (Vbar[mu]+V[mu])/Sqrt[2], WWi[mu_,7] -> (V[mu]-Vbar[mu])/(I*Sqrt[2]), 
WWi[mu_,3] -> cw (cz Z[mu]+sz ZP[mu]) + sw A[mu], WWi[mu_,8] -> -s3 (cz ZP[mu]-sz Z[mu])+c3 (-sw (cz Z[mu]+sz ZP[mu])+cw A[mu])} 
  },

(* Ghosts: related to unphysical gauge bosons *)
  U[12] == {
    ClassName     -> ghK, 
    Unphysical    -> True,
    SelfConjugate -> False,
    Ghost         -> K, 
    Definitions   -> { ghK -> -c3 (cz ghZP-sz ghZ) + s3 (-sw (cz ghZ+sz ghZP) + cw ghA)}
  },
  U[13] == {
    ClassName     -> ghWi,
    Unphysical    -> True,
    SelfConjugate -> False,
    Ghost         -> Wi,
    Indices       -> {Index[SU3W]},
    FlavorIndex   -> SU3W,
    Definitions   -> { ghWi[1] -> (ghWp+ghWm)/Sqrt[2], ghWi[2] -> (ghWm-ghWp)/(I*Sqrt[2]), ghWi[4] -> (ghYp+ghYm)/Sqrt[2], ghWi[5] -> (ghYp-ghYm)/(I*Sqrt[2]), ghWi[6] -> (ghVp+ghVm)/Sqrt[2], ghWi[7] -> (ghVp-ghVm)/(I*Sqrt[2]),  ghWi[3] -> cw (cz ghZ+sz ghZP)+sw ghA, ghWi[8] ->  -s3 (cz ghZP-sz ghZ)+c3 (-sw (cz ghZ+sz ghZP) + cw ghA)}
  },

(* Fermions: physical fields *)
  F[1] == {
    ClassName        -> vl,
    ClassMembers     -> {ve,vm,vt},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> 0,
    Width            -> 0,
    QuantumNumbers   -> {LeptonNumber -> 1},
    PropagatorLabel  -> {"v", "ve", "vm", "vt"} ,
    PropagatorType   -> S,
    PropagatorArrow  -> Forward,
    PDG              -> {12,14,16},
    ParticleName     -> {"ve","vm","vt"},
    AntiParticleName -> {"ve~","vm~","vt~"},
    FullName         -> {"Electron-neutrino", "Mu-neutrino", "Tau-neutrino"}
  },
  F[2] == {
    ClassName        -> l,
    ClassMembers     -> {e, mu, ta},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Ml, {Me,5.11*^-4}, {MMU,0.10566}, {MTA,1.777}},
    Width            -> 0,
    QuantumNumbers   -> {Q -> -1, LeptonNumber -> 1},
    PropagatorLabel  -> {"l", "e", "mu", "ta"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {11, 13, 15},
    ParticleName     -> {"e-", "mu-", "ta-"},
    AntiParticleName -> {"e+", "mu+", "ta+"},
    FullName         -> {"Electron", "Muon", "Tau"} 
  },
  F[3] == {
    ClassName        -> EE,
    ClassMembers     -> {Ee, Emu, Eta},
    Indices          -> {Index[Generation]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {ME, {MEE,1*^3}, {MEMU,1*^3}, {META,1*^3}},
    Width            -> {WE, {WEE,10},{WEMU,10},{WETA,10}},
    QuantumNumbers   -> {Q -> -1, LeptonNumber -> 1},
    PropagatorLabel  -> {"E", "Ee", "Emu", "Eta"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    ParticleName     -> {"~Ee-", "~Emu-", "~Eta-"},
    AntiParticleName -> {"~Ee+", "~Emu+", "~Eta+"},
    FullName         -> {"~HElectron", "~HMuon", "~HTau"} 
  },
  F[4] == {
    ClassName        -> uq,
    ClassMembers     -> {u, c, t},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Mu, {MU, 2.55*^-3}, {MC,1.27}, {MT,172}},
    Width            -> {0, 0, {WT,1.50833649}},
    QuantumNumbers   -> {Q -> 2/3},
    PropagatorLabel  -> {"uq", "u", "c", "t"},
    PropagatorType   -> Straight,
    PropagatorArrow  -> Forward,
    PDG              -> {2, 4, 6}, 
    ParticleName     -> {"u",  "c",  "t" },
    AntiParticleName -> {"u~", "c~", "t~"},
    FullName         -> {"u-quark", "c-quark", "t-quark"}
  },
  F[5] == {
    ClassName        -> dq,
    ClassMembers     -> {d, s, b},
    Indices          -> {Index[Generation], Index[Colour]},
    FlavorIndex      -> Generation,
    SelfConjugate    -> False,
    Mass             -> {Md, {MD,5.04*^-3}, {MS,0.101}, {MB,4.7}},
    Width            -> 0,
    QuantumNumbers   -> {Q -> -1/3},
    PropagatorLabel  -> {"dq", "d", "s", "b"},
    PropagatorType   -> Straight, 
    PropagatorArrow  -> Forward,
    PDG              -> {1,3,5},
    ParticleName     -> {"d",  "s",  "b" },
    AntiParticleName -> {"d~", "s~", "b~"},
    FullName         -> {"d-quark", "s-quark", "b-quark"}
  },
   F[6] == {
    ClassName        -> Jq12,
    ClassMembers     -> {Jd, Js},
    Indices          -> {Index[Generation2], Index[Colour]},
    FlavorIndex      -> Generation2,
    SelfConjugate    -> False,
    Mass             -> {MJ12, {MJD,1*^3}, {MJS,1*^3}},
    Width            -> {WJQ12,{WJD,10},{WJS,10}},
    QuantumNumbers   -> {Q -> 2/3},
    PropagatorLabel  -> {"Jq12", "Jd", "Js"},
    PropagatorType   -> Straight, 
    PropagatorArrow  -> Forward,
    ParticleName     -> {"~Jd",  "~Js"},
    AntiParticleName -> {"~Jd~", "~Js~"},
    FullName         -> {"~Jd-quark", "~Js-quark"}
  },
  F[7] == {
    ClassName        -> Jt,
    Indices          -> {Index[Colour]},
    SelfConjugate    -> False,
    Mass              -> {MJT,1*^3},
    Width            -> 10,
    QuantumNumbers   -> {Q -> -1/3},
    PropagatorLabel  -> "Jt",
    PropagatorType   -> Straight, 
    PropagatorArrow  -> Forward,
    ParticleName     -> "~Jt",
    AntiParticleName -> "~Jt~",
    FullName         -> "~Jt-quark"
  },



(* Fermions: unphysical fields *)
   F[11] == { 
    ClassName      -> LL,
    Unphysical     -> True, 
    Indices        -> {Index[ASU3T], Index[Generation]},
    FlavorIndex    -> ASU3T,
    SelfConjugate  -> False,
    QuantumNumbers -> {X -> -2/3},
    Definitions    -> { 
      LL[sp1_,1,ff_] :> Module[{sp2}, ProjM[sp1,sp2] l[sp2,ff]], 
      LL[sp1_,2,ff_] :> -Module[{sp2}, ProjM[sp1,sp2] vl[sp2,ff]], 
      LL[sp1_,3,ff_] :> Module[{sp2}, ProjM[sp1,sp2] EE[sp2,ff]]}
  },
  F[12] == { 
    ClassName      -> lR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {X -> -1},
    Definitions    -> { lR[sp1_,ff_] :> Module[{sp2}, ProjP[sp1,sp2] l[sp2,ff]] }
  },
  F[13] == { 
    ClassName      -> EER, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {X -> -1},
    Definitions    -> { EER[sp1_,ff_] :> Module[{sp2}, ProjP[sp1,sp2] EE[sp2,ff]] }
  },
  F[14] == { 
    ClassName      -> QL12, 
    Unphysical     -> True, 
    Indices        -> {Index[SU3T], Index[Generation2], Index[Colour]},
    FlavorIndex    -> SU3T,
    SelfConjugate  -> False,
    QuantumNumbers -> {X -> 1/3},
    Definitions    -> { 
      QL12[sp1_,1,1,cc_] :> Module[{sp2,ff2}, RU[1,ff2]  ProjM[sp1,sp2] uq[sp2,ff2,cc]],
      QL12[sp1_,1,2,cc_] :> Module[{sp2,ff2}, RU[2,ff2]  ProjM[sp1,sp2] uq[sp2,ff2,cc]],
      QL12[sp1_,2,1,cc_] :> Module[{sp2,ff2}, CKM[1,ff2] ProjM[sp1,sp2] dq[sp2,ff2,cc]],
      QL12[sp1_,2,2,cc_] :> Module[{sp2,ff2}, CKM[2,ff2] ProjM[sp1,sp2] dq[sp2,ff2,cc]],
      QL12[sp1_,3,ff12_,cc_] :> Module[{sp2}, ProjM[sp1,sp2] Jq12[sp2,ff12,cc]]}
  },
 F[15] == { 
    ClassName      -> QL3, 
    Unphysical     -> True, 
    Indices        -> {Index[ASU3T], Index[Generation1], Index[Colour]},
    FlavorIndex    -> ASU3T,
    SelfConjugate  -> False,
    QuantumNumbers -> {X -> 0},
    Definitions    -> { 
      QL3[sp1_,1,3,cc_] :> Module[{sp2,ff2}, CKM[3,ff2] ProjM[sp1,sp2] dq[sp2,ff2,cc]],
      QL3[sp1_,2,3,cc_] :>-Module[{sp2,ff2}, RU[3,ff2]  ProjM[sp1,sp2] uq[sp2,ff2,cc]],
      QL3[sp1_,3,3,cc_] :> Module[{sp2}, ProjM[sp1,sp2] Jt[sp2,cc]]}
  },
  F[16] == { 
    ClassName      -> QL, 
    Unphysical     -> True, 
    Indices        -> {Index[SU3T], Index[Generation], Index[Colour]},
    FlavorIndex    -> SU3T,
    SelfConjugate  -> False,
    QuantumNumbers -> {X -> 1/3, X -> 1/3, X -> 0},
    Definitions    -> { 
      QL[sp1_,1,1,cc_] :> QL12[sp1,1,1,cc],
      QL[sp1_,1,2,cc_] :> QL12[sp1,1,2,cc],
      QL[sp1_,1,3,cc_] :> QL3[sp1,1,3,cc],
      QL[sp1_,2,1,cc_] :> QL12[sp1,2,1,cc],
      QL[sp1_,2,2,cc_] :> QL12[sp1,2,2,cc],
      QL[sp1_,2,3,cc_] :> QL3[sp1,2,3,cc],
      QL[sp1_,3,1,cc_] :> QL12[sp1,3,1,cc],
      QL[sp1_,3,2,cc_] :> QL12[sp1,3,2,cc],
      QL[sp1_,3,3,cc_] :> QL3[sp1,3,3,cc]}
  },
  F[17] == { 
    ClassName      -> uR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {X -> 2/3},
    Definitions    -> { uR[sp1_,ff_,cc_] :> Module[{sp2}, ProjP[sp1,sp2] uq[sp2,ff,cc]] }
  },
  F[18] == { 
    ClassName      -> dR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {X -> -1/3},
    Definitions    -> { dR[sp1_,ff_,cc_] :> Module[{sp2}, ProjP[sp1,sp2] dq[sp2,ff,cc]] }
  },
   F[19] == { 
    ClassName      -> JR12, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation2], Index[Colour]},
    FlavorIndex    -> Generation2,
    SelfConjugate  -> False,
    QuantumNumbers -> {X -> 2/3},
    Definitions    -> { JR12[sp1_,ff_,cc_] :> Module[{sp2}, ProjP[sp1,sp2] Jq12[sp2,ff,cc]] }
  },
   F[20] == { 
    ClassName      -> JR3, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation1], Index[Colour]},
    FlavorIndex    -> Generation1,
    SelfConjugate  -> False,
    QuantumNumbers -> {X -> -1/3},
    Definitions    -> { JR3[sp1_,ff_,cc_] :> Module[{sp2}, ProjP[sp1,sp2] Jt[sp2,cc]] }
  },
   F[21] == { 
    ClassName      -> JR, 
    Unphysical     -> True, 
    Indices        -> {Index[Generation], Index[Colour]},
    FlavorIndex    -> Generation,
    SelfConjugate  -> False,
    QuantumNumbers -> {X -> 2/3, X -> 2/3, X -> -1/3},
    Definitions    -> { JR[sp1_,1,cc_] :> JR12[sp1,1,cc],
                        JR[sp1_,2,cc_] :> JR12[sp1,2,cc],
                        JR[sp1_,3,cc_] :> JR3[sp1,3,cc] }
  },
  
(* Higgs: physical scalars  *)
  S[1] == {
    ClassName       -> h,
    SelfConjugate   -> True,
    Mass            -> {Mh,125},
    Width           -> {Wh,0.00407},
    PropagatorLabel -> "h",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 25,
    ParticleName    -> "h",
    FullName        -> "h"
  },
  S[2] == {
    ClassName       -> H2,
    SelfConjugate   -> True,
    Mass            -> {MH2,Internal},
    Width           -> {WH2,10},
    PropagatorLabel -> "H2",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    ParticleName    -> "H2",
    FullName        -> "H2"
  },
  S[3] == {
    ClassName       -> H3,
    SelfConjugate   -> True,
    Mass            -> {MH3,Internal},
    Width           -> {WH3,10},
    PropagatorLabel -> "H3",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    ParticleName    -> "H3",
    FullName        -> "H3"
  },
  S[4] == {
    ClassName       -> H0,
    SelfConjugate   -> True,
    Mass            -> {MH0,Internal},
    Width           -> {WH0,10},
    PropagatorLabel -> "H0",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    ParticleName    -> "H0",
    FullName        -> "H0"
  },
  S[5] == {
    ClassName       -> HW,
    SelfConjugate   -> False,
    Mass            -> {MHW,Internal},
    Width           -> {WHW,10},
    ParticleName    -> "HW+",
    AntiParticleName -> "HW-",
    QuantumNumbers  -> {Q -> 1},
    PropagatorLabel -> "HW",
    PropagatorType  -> D,
    PropagatorArrow -> Forward,
    FullName        -> "HW"
  },
  S[6] == {
    ClassName       -> HY,
    SelfConjugate   -> False,
    Mass            -> {MHY,Internal},
    Width           -> {WHY,10},
    ParticleName    -> "~HY",
    AntiParticleName -> "~HY~",
    QuantumNumbers  -> {Q -> 0},
    PropagatorLabel -> "HY",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    FullName        -> "HY"
  },
  S[7] == {
    ClassName       -> HV,
    SelfConjugate   -> False,
    Mass            -> {MHV,Internal},
    Width           -> {WHV,10},
    ParticleName    -> "~HV+",
    AntiParticleName -> "~HV-",
    QuantumNumbers  -> {Q -> 1},
    PropagatorLabel -> "HV",
    PropagatorType  -> D,
    PropagatorArrow -> Forward,
    FullName        -> "HV"
  },


(* Higgs: physical scalars  *)
  S[8] == {
    ClassName       -> GZ,
    SelfConjugate   -> True,
    Goldstone       -> Z,
    Mass            -> {MZ, 91.1876},
    Width           -> {WZ, 2.4952},
    PropagatorLabel -> "GZ",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    PDG             -> 250,
    ParticleName    -> "GZ",
    FullName        -> "GZ"
  },
  S[9] == {
    ClassName       -> GZP,
    SelfConjugate   -> True,
    Goldstone       -> ZP,
    Mass            -> {MZP, 4000},
    Width           -> {WZP, 10},
    PropagatorLabel -> "GZP",
    PropagatorType  -> D,
    PropagatorArrow -> None,
    ParticleName    -> "GZP",
    FullName        -> "GZP"
  },
  S[10] == {
    ClassName        -> GW,
    SelfConjugate    -> False,
    Goldstone        -> W,
    Mass             -> {MW, 80.385},
    QuantumNumbers   -> {Q -> 1},
    Width            -> {WW, 2.085},
    PropagatorLabel  -> "GW",
    PropagatorType   -> D,
    PropagatorArrow  -> None,
    PDG              -> 251,
    ParticleName     -> "GW+",
    AntiParticleName -> "GW-",
    FullName         -> "GW"
  },
   S[11] == {
    ClassName        -> GY,
    SelfConjugate    -> False,
    Goldstone        -> YY,
    Mass             -> {MY, Internal},
    QuantumNumbers  -> {Q -> 0},
    Width            -> {WY, 0},
    PropagatorLabel  -> "GY",
    PropagatorType   -> D,
    PropagatorArrow  -> None,
    ParticleName     -> "GY",
    AntiParticleName -> "GY~",
    FullName         -> "GY"
  },
   S[12] == {
    ClassName        -> GV,
    SelfConjugate    -> False,
    Goldstone        -> V,
    Mass             -> {MV, Internal},
    QuantumNumbers   -> {Q -> 1},
    Width            -> {WV, 10},
    PropagatorLabel  -> "GV",
    PropagatorType   -> D,
    PropagatorArrow  -> None,
    ParticleName     -> "GV+",
    AntiParticleName -> "GV-",
    FullName         -> "GV"
  },


(* Higgs: unphysical scalars  *)
  S[13] == { 
    ClassName      -> Rho, 
    Unphysical     -> True, 
    Indices        -> {Index[SU3T]},
    FlavorIndex    -> SU3T,
    SelfConjugate  -> False,
    QuantumNumbers -> {X -> 2/3},
    Definitions    -> { Rho[1] -> -I (HW svv2+GW cvv2), Rho[2] -> (v + UH11 h + UH12 H2 + UH13 H3 + I (Uh11 H0 + Uh12 GZ + Uh13 GZP))/Sqrt[2], Rho[3] -> -I (HV svv3+GV cvv3)}
  },
  S[14] == { 
    ClassName      -> Phi, 
    Unphysical     -> True, 
    Indices        -> {Index[SU3T]},
    FlavorIndex    -> SU3T,
    SelfConjugate  -> False,
    QuantumNumbers -> {X -> -1/3},
    Definitions    -> { Phi[1] -> (v2 + UH21 h + UH22 H2 + UH23 H3 + I (Uh21 H0  + Uh23 GZP))/Sqrt[2], Phi[2] -> -I(GWbar svv2 -HWbar cvv2), Phi[3] -> -I(HY sv2v3+GY cv2v3) }
  },
   S[15] == { 
    ClassName      -> Chi, 
    Unphysical     -> True, 
    Indices        -> {Index[SU3T]},
    FlavorIndex    -> SU3T,
    SelfConjugate  -> False,
    QuantumNumbers -> {X -> -1/3},
    Definitions    -> { Chi[1] -> -I (GYbar sv2v3-HYbar cv2v3), Chi[2] -> -I (GVbar svv3-HVbar cvv3), Chi[3] -> (v3 + UH31 h + UH32 H2 + UH33 H3 + I (Uh31 H0 + Uh32 GZ + Uh33 GZP))/Sqrt[2] }
  },
   S[16] == { 
    ClassName      -> Su,
    Unphysical     -> True,
    Indices        -> {Index[Generation], Index[Generation],Index[SU3T]},
    FlavorIndex    -> SU3T,
    SelfConjugate  -> False,
    Definitions    -> {Su[1,1,kk_] -> Phi[kk],  Su[1,2,kk_] -> 0, Su[1,3,kk_] -> 0, Su[2,1,kk_] -> 0, Su[2,2,kk_] -> Phi[kk], Su[2,3,kk_] -> 0, Su[3,1,kk_] -> 0, Su[3,2,kk_] -> 0, Su[3,3,kk_] -> -Rhobar[kk]}
  },
   S[17] == {
    ClassName      -> Sd,
    Unphysical     -> True,
    Indices        -> {Index[Generation], Index[Generation],Index[SU3T]},
    FlavorIndex    -> SU3T,
    SelfConjugate  -> False,
    Definitions    -> {Sd[1,1,kk_] -> Rho[kk],  Sd[1,2,kk_] -> 0, Sd[1,3,kk_] -> 0, Sd[2,1,kk_] -> 0, Sd[2,2,kk_] -> Rho[kk], Sd[2,3,kk_] -> 0, Sd[3,1,kk_] -> 0, Sd[3,2,kk_] -> 0, Sd[3,3,kk_] -> Phibar[kk]}
  },
   S[18] == {
    ClassName      -> SJ,
    Unphysical     -> True,
    Indices        -> {Index[Generation], Index[Generation],Index[SU3T]},
    FlavorIndex    -> SU3T,
    SelfConjugate  -> False,
    Definitions    -> {SJ[1,1,kk_] -> Chi[kk],  SJ[1,2,kk_] -> 0, SJ[1,3,kk_] -> 0, SJ[2,1,kk_] -> 0, SJ[2,2,kk_] -> Chi[kk], SJ[2,3,kk_] -> 0, SJ[3,1,kk_] -> 0, SJ[3,2,kk_] -> 0, SJ[3,3,kk_] -> Chibar[kk]}
  }
};
  

(* ************************** *)
(* *****     Gauge      ***** *)
(* *****   Parameters   ***** *)
(* *****   (FeynArts)   ***** *)
(* ************************** *)

GaugeXi[ V[1]  ] = GaugeXi[A];
GaugeXi[ V[2]  ] = GaugeXi[Z];
GaugeXi[ V[3]  ] = GaugeXi[ZP];
GaugeXi[ V[4]  ] = GaugeXi[W];
GaugeXi[ V[5]  ] = GaugeXi[YY];
GaugeXi[ V[6]  ] = GaugeXi[V];
GaugeXi[ V[7]  ] = GaugeXi[G];
GaugeXi[ S[1]  ] = 1;
GaugeXi[ S[2]  ] = 1;
GaugeXi[ S[3]  ] = 1;
GaugeXi[ S[4]  ] = 1;
GaugeXi[ S[5]  ] = 1;
GaugeXi[ S[6]  ] = 1;
GaugeXi[ S[7]  ] = 1;
GaugeXi[ S[8]  ] = GaugeXi[Z];
GaugeXi[ S[9]  ] = GaugeXi[ZP];
GaugeXi[ S[10]  ] = GaugeXi[W];
GaugeXi[ S[11]  ] = GaugeXi[YY];
GaugeXi[ S[12]  ] = GaugeXi[V];
GaugeXi[ U[1]  ] = GaugeXi[A];
GaugeXi[ U[2]  ] = GaugeXi[Z];
GaugeXi[ U[3]  ] = GaugeXi[ZP];
GaugeXi[ U[41] ] = GaugeXi[W];
GaugeXi[ U[42] ] = GaugeXi[W];
GaugeXi[ U[51] ] = GaugeXi[YY];
GaugeXi[ U[52] ] = GaugeXi[YY];
GaugeXi[ U[61] ] = GaugeXi[V];
GaugeXi[ U[62] ] = GaugeXi[V];
GaugeXi[ U[7]  ] = GaugeXi[G];


(* ************************** *)
(* *****   Parameters   ***** *)
(* ************************** *)
M$Parameters = {

  (* External parameters *)
  aEWM1 == { 
    ParameterType    -> External, 
    BlockName        -> SMINPUTS, 
    OrderBlock       -> 1, 
    Value            -> 127.9,
    InteractionOrder -> {QED,-2},
    Description      -> "Inverse of the EW coupling constant at the Z pole"
  },
  Gf == {
    ParameterType    -> External,
    BlockName        -> SMINPUTS,
    OrderBlock       -> 2,
    Value            -> 1.16637*^-5, 
    InteractionOrder -> {QED,2},
    TeX              -> Subscript[G,f],
    Description      -> "Fermi constant"
  },
  aS    == { 
    ParameterType    -> External,
    BlockName        -> SMINPUTS,
    OrderBlock       -> 3,
    Value            -> 0.1184, 
    InteractionOrder -> {QCD,2},
    TeX              -> Subscript[\[Alpha],s],
    Description      -> "Strong coupling constant at the Z pole"
  },
  ymdo == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 1,
    Value         -> 5.04*^-3,
    Description   -> "Down Yukawa mass"
  },
  ymup == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 2,
    Value         -> 2.55*^-3,
    Description   -> "Up Yukawa mass"
  },
  yms == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 3,
    Value         -> 0.101,
    Description   -> "Strange Yukawa mass"
  },
  ymc == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 4,
    Value         -> 1.27,
    Description   -> "Charm Yukawa mass"
  },
  ymb == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 5,
    Value         -> 4.7,
    Description   -> "Bottom Yukawa mass"
  },
  ymt == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 6,
    Value         -> 172,
    Description   -> "Top Yukawa mass"
  },
  ymD == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 7,
    Value         -> 1*^3,
    Description   -> "Heavy Down Yukawa mass"
  },
  ymS == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 8,
    Value         -> 1*^3,
    Description   -> "Heavy Strange Yukawa mass"
  },
  ymT == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 9,
    Value         -> 1*^3,
    Description   -> "Heavy Top Yukawa mass"
  },
  yme == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 11,
    Value         -> 5.11*^-4,
    Description   -> "Electron Yukawa mass"
  },
  ymm == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 13,
    Value         -> 0.10566,
    Description   -> "Muon Yukawa mass"
  },
  ymtau == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 15,
    Value         -> 1.777,
    Description   -> "Tau Yukawa mass"
  },
  ymEe == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 16,
    Value         -> 1*^3,
    Description   -> "Heavy Electron Yukawa mass"
  },
  ymEm == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 17,
    Value         -> 1*^3,
    Description   -> "Heavy Muon Yukawa mass"
  },
  ymEtau == {
    ParameterType -> External,
    BlockName     -> YUKAWA,
    OrderBlock    -> 18,
    Value         -> 1*^3,
    Description   -> "Heavy Tau Yukawa mass"
  },
  cabi == {
    ParameterType -> External,
    BlockName     -> CKMBLOCK,
    OrderBlock    -> 1,
    Value         -> 0.227736,
    TeX           -> Subscript[\[Theta], c],
    Description   -> "Cabibbo angle"
  },
  v2 == {
    ParameterType    -> External,
    BlockName     -> OTHERS,
    OrderBlock    -> 21,
    Value            -> 174.105,
    InteractionOrder -> {QED,-1},
    Description      -> "phi vacuum expectation value"
  },
  v3 == {
    ParameterType -> External,
    BlockName     -> OTHERS,
    OrderBlock    -> 1,
    Value         -> 2528.6,
    InteractionOrder -> {QED,-1},
    Description   -> "Chi vaccum expectation value"
  },
  lam2 == {
    ParameterType    -> External,
    BlockName     -> OTHERS,
    OrderBlock    -> 2,
    Value            -> -0.4,
    InteractionOrder -> {QED, 2},
    TeX              -> Subscript[\[Lambda], 2],
    Description      -> "phi quartic coupling"
  },
  lam3 == {
    ParameterType    -> External,
    BlockName     -> OTHERS,
    OrderBlock    -> 3,
    Value            -> -0.8,
    InteractionOrder -> {QED, 2},
    TeX              -> Subscript[\[Lambda], 3],
    Description      -> "Chi quartic coupling"
  },
  lam12 == {
    ParameterType    -> External,
    BlockName     -> OTHERS,
    OrderBlock    -> 4,
    Value            -> -1,
    InteractionOrder -> {QED, 2},
    TeX              -> Subscript[\[Lambda], 12],
    Description      -> "Rho Rho and phi phi quartic coupling"
  },
  lam13 == {
    ParameterType    -> External,
    BlockName     -> OTHERS,
    OrderBlock    -> 5,
    Value            -> -0.7,
    InteractionOrder -> {QED, 2},
    TeX              -> Subscript[\[Lambda], 13],
    Description      -> "Rho Rho and Chi Chi quartic coupling"
  },
  lam23 == {
    ParameterType    -> External,
    BlockName     -> OTHERS,
    OrderBlock    -> 6,
    Value            -> -0.6,
    InteractionOrder -> {QED, 2},
    TeX              -> Subscript[\[Lambda], 23],
    Description      -> "Chi Chi and phi phi quartic coupling"
  },
  lam12P == {
    ParameterType    -> External,
    BlockName     -> OTHERS,
    OrderBlock    -> 7,
    Value            -> -0.2,
    InteractionOrder -> {QED, 2},
    TeX              -> Subscript[\[Lambda]', 12],
    Description      -> "Rho phi and phi Rho quartic coupling"
  },
  lam13P == {
    ParameterType    -> External,
    BlockName     -> OTHERS,
    OrderBlock    -> 8,
    Value            -> -0.3,
    InteractionOrder -> {QED, 2},
    TeX              -> Subscript[\[Lambda]', 13],
    Description      -> "Rho Chi and Chi Rho quartic coupling"
  },
  lam23P == {
    ParameterType    -> External,
    BlockName     -> OTHERS,
    OrderBlock    -> 9,
    Value            -> -0.1,
    InteractionOrder -> {QED, 2},
    TeX              -> Subscript[\[Lambda]', 23],
    Description      -> "phi Chi and Chi phi quartic coupling"
  },
  UH11 == {
    ParameterType -> External, 
    BlockName     -> OTHERS,
    OrderBlock    -> 10,
    Value         -> -0.716449,
    TeX           -> Subsuperscript[U,11,H],
    Description   -> "11 rotation-matrix element of Realscalar"
  },
  UH12 == {
    ParameterType -> External, 
    BlockName     -> OTHERS,
    OrderBlock    -> 11,
    Value         -> 0.69729,
    TeX           -> Subsuperscript[U,12,H],
    Description   -> "12 rotation-matrix element of Realscalar"
  },
  UH13 == {
    ParameterType -> External, 
    BlockName     -> OTHERS,
    OrderBlock    -> 12,
    Value         -> 0.0220899,
    TeX           -> Subsuperscript[U,13,H],
    Description   -> "13 rotation-matrix element of Realscalar"
  },
  UH21 == {
    ParameterType -> External, 
    BlockName     -> OTHERS,
    OrderBlock    -> 13,
    Value         -> -0.69693,
    TeX           -> Subsuperscript[U,21,H],
    Description   -> "21 rotation-matrix element of Realscalar"
  },
  UH22 == {
    ParameterType -> External, 
    BlockName     -> OTHERS,
    OrderBlock    -> 14,
    Value         -> -0.716789,
    TeX           -> Subsuperscript[U,22,H],
    Description   -> "22 rotation-matrix element of Realscalar"
  },
  UH23 == {
    ParameterType -> External, 
    BlockName     -> OTHERS,
    OrderBlock    -> 15,
    Value         -> 0.0224204,
    TeX           -> Subsuperscript[U,23,H],
    Description   -> "23 rotation-matrix element of Realscalar"
  },
  UH31 == {
    ParameterType -> External, 
    BlockName     -> OTHERS,
    OrderBlock    -> 16,
    Value         -> 0.0314673,
    TeX           -> Subsuperscript[U,31,H],
    Description   -> "31 rotation-matrix element of Realscalar"
  },
  UH32 == {
    ParameterType -> External, 
    BlockName     -> OTHERS,
    OrderBlock    -> 17,
    Value         -> 0.000667955,
    TeX           -> Subsuperscript[U,32,H],
    Description   -> "32 rotation-matrix element of Realscalar"
  },
  UH33 == {
    ParameterType -> External, 
    BlockName     -> OTHERS,
    OrderBlock    -> 18,
    Value         -> 0.999505,
    TeX           -> Subsuperscript[U,33,H],
    Description   -> "33 rotation-matrix element of Realscalar"
  },
  tz == {
    ParameterType    -> External,
    BlockName     -> OTHERS,
    OrderBlock    -> 19,
    Definitions      -> {tz -> 0},
    Description      -> "Tan of z zp mixing angle"
  },
  lam1 == {
    ParameterType    -> External,
    BlockName     -> OTHERS,
    OrderBlock    -> 20,
    Value            -> 0.5,
    InteractionOrder -> {QED, 2},
    TeX              -> Subscript[\[Lambda], 1],
    Description      -> "Rho quartic coupling"
  },
  lamWS == {
    ParameterType    -> External,
    BlockName     -> WOLFENSTEIN,
    OrderBlock    -> 1,
    Value            -> 0.2253,
    TeX              -> \[Lambda],
    Description      -> "Wolfenstein variable lam"
  },
  AWS == {
    ParameterType    -> External,
    BlockName     -> WOLFENSTEIN,
    OrderBlock    -> 2,
    Value            -> 0.808,
    TeX              -> A,
    Description      -> "Wolfenstein variable A"
  },
  rhoWS == {
    ParameterType    -> External,
    BlockName     -> WOLFENSTEIN,
    OrderBlock    -> 3,
    Value            -> 0.132,
    TeX              -> \[Rho],
    Description      -> "Wolfenstein variable rho"
  },
  etaWS == {
    ParameterType    -> External,
    BlockName     -> WOLFENSTEIN,
    OrderBlock    -> 4,
    Value            -> 0.341,
    TeX              -> \[Eta],
    Description      -> "Wolfenstein variable eta"
  },

  (* Internal Parameters *)
  beta == {
    ParameterType    -> Internal,
    Definitions      -> {beta -> -1/Sqrt[3]},
    TeX              -> \[Beta],
    Description      -> "beta"
  },
  aEW == {
    ParameterType    -> Internal,
    Value            -> 1/aEWM1,
    InteractionOrder -> {QED,2},
    TeX              -> Subscript[\[Alpha], EW],
    Description      -> "Electroweak coupling contant"
  },
  ee == { 
    ParameterType    -> Internal, 
    Value            -> Sqrt[4 Pi aEW], 
    InteractionOrder -> {QED,1}, 
    TeX              -> e,  
    Description      -> "Electric coupling constant"
  },
  cw == { 
    ParameterType -> Internal, 
    Value         -> MW/MZ, 
    TeX           -> Subscript[c,w], 
    Description   -> "Cosine of the Weinberg angle"
  },
  sw == { 
    ParameterType -> Internal, 
    Value         -> Sqrt[1-cw^2], 
    TeX           -> Subscript[s,w], 
    Description   -> "Sine of the Weinberg angle"
  },
  c3 == {
    ParameterType -> Internal, 
    Definitions   -> {c3->beta sw/cw}, 
    TeX           -> Subscript[c,3], 
    Description   -> "Cosine of the 331 angle"
  },
  s3 == {
    ParameterType -> Internal, 
    Definitions   -> {s3->Sqrt[1-(1+beta^2)*sw^2]/cw}, 
    TeX           -> Subscript[s,3], 
    Description   -> "Sine of the 331 angle"
  },
  gw == { 
    ParameterType    -> Internal, 
    Definitions      -> {gw->ee/sw}, 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[g,w], 
    Description      -> "Weak coupling constant at the Z pole"
  },
  gx == {
    ParameterType    -> Internal, 
    Definitions      -> {gx->gw sw/Sqrt[1-(1+beta^2)*sw^2]}, 
    InteractionOrder -> {QED,1},  
    TeX              -> Subscript[g,x], 
    Description      -> "U(1)X coupling constant at the Z pole"
  },
  gs == { 
    ParameterType    -> Internal, 
    Value            -> Sqrt[4 Pi aS],
    InteractionOrder -> {QCD,1},  
    TeX              -> Subscript[g,s], 
    ParameterName    -> G,
    Description      -> "Strong coupling constant at the Z pole"
  },
  v == {
    ParameterType -> Internal,
    Value         -> Sqrt[(Sqrt[2]Gf)^-1-v2^2], 
    InteractionOrder -> {QED,-1},
    Description   -> "Rho vaccum expectation value"
  },
  v3 == {
    ParameterType -> Internal,
    Value         -> MZP Sqrt[3 - 4 sw^2]/(gw cw),
    InteractionOrder -> {QED,-1},
    Description   -> "Chi vaccum expectation value"
  },
  cz == {
    ParameterType    -> Internal,
    Definitions      -> {cz->1/Sqrt[1+tz^2]},
    Description      -> "Cosin of z zp mixing angle"
  },
  sz == {
    ParameterType    -> Internal,
    Definitions      -> {sz->-tz/Sqrt[1+tz^2]},
    Description      -> "Sin of z zp mixing angle"
  },
  svv2 == {
    ParameterType -> Internal, 
    Value         -> 1/Sqrt[1+(v/v2)^2], 
    TeX           -> Subscript[s,vv2], 
    Description   -> "Sine of the vv2 angle"
  },
  cvv2 == {
    ParameterType -> Internal, 
    Value         -> Sqrt[1-svv2^2], 
    TeX           -> Subscript[c,vv2], 
    Description   -> "Cosine of the vv2 angle"
  },
  svv3 == {
    ParameterType -> Internal, 
    Value         -> 1/Sqrt[1+(v/v3)^2], 
    TeX           -> Subscript[s,vv3], 
    Description   -> "Sine of the vv3 angle"
  },
  cvv3 == {
    ParameterType -> Internal, 
    Value         -> Sqrt[1-svv3^2], 
    TeX           -> Subscript[c,vv3], 
    Description   -> "Cosine of the vv3 angle"
  },
  sv2v3 == {
    ParameterType -> Internal, 
    Value         -> 1/Sqrt[1+(v2/v3)^2], 
    TeX           -> Subscript[s,v2v3], 
    Description   -> "Sine of the v2v3 angle"
  },   
  cv2v3 == {
    ParameterType -> Internal, 
    Value         -> Sqrt[1-sv2v3^2], 
    TeX           -> Subscript[c,v2v3], 
    Description   -> "Cosine of the v2v3 angle"
  }, 
  ff == {
    ParameterType    -> Internal,
    Value            -> -v3/(2Sqrt[2]),
    InteractionOrder -> {QED,1},
    TeX              -> f,
    Description      -> "Coefficient of the cubic piece of the Higgs potential"
  },
  mu1 == {
    ParameterType -> Internal,
    Definitions   -> {mu1->-lam1*v^2-lam12*v2^2/2-lam13*v3^2/2+ff*v3*v2/v},
    Description   -> "Coefficient of the quadratic piece of the Rho potential"
  },
  mu2 == {
    ParameterType -> Internal,
    Definitions   -> {mu2->-lam2*v2^2-lam12*v^2/2-lam23*v3^2/2+ff*v3*v/v2},
    Description   -> "Coefficient of the quadratic piece of the phi potential"
  },
  mu3 == {
    ParameterType -> Internal,
    Definitions   -> {mu3->-lam3*v3^2-lam13*v^2/2-lam23*v2^2/2+ff*v*v2/v3},
    Description   -> "Coefficient of the quadratic piece of the Chi potential"
  },
  yl == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yl[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yl[1,1] -> Sqrt[2] yme / v2, yl[2,2] -> Sqrt[2] ymm / v2, yl[3,3] -> Sqrt[2] ymtau / v2},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yl[1,1] -> ye, yl[2,2] -> ym, yl[3,3] -> ytau},
    TeX              -> Superscript[y, l],
    Description      -> "Lepton Yukawa couplings"
  },
  yE == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yE[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yE[1,1] -> Sqrt[2] ymEe / v3, yE[2,2] -> Sqrt[2] ymEm / v3, yE[3,3] -> Sqrt[2] ymEtau / v3},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yE[1,1] -> yEe, yl[2,2] -> yEm, yl[3,3] -> yEtau},
    TeX              -> Superscript[y, E],
    Description      -> "Heavy Lepton Yukawa couplings"
  },
  yu == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yu[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yu[1,1] -> Sqrt[2] ymup/v2, yu[2,2] -> Sqrt[2] ymc/v2, yu[3,3] -> Sqrt[2] ymt/v2},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yu[1,1] -> yup, yu[2,2] -> yc, yu[3,3] -> yt},
    TeX              -> Superscript[y, u],
    Description      -> "Up-type Yukawa couplings"
  },
  yd == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yd[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yd[1,1] -> Sqrt[2] ymdo/v, yd[2,2] -> Sqrt[2] yms/v, yd[3,3] -> Sqrt[2] ymb/v},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yd[1,1] -> ydo, yd[2,2] -> ys, yd[3,3] -> yb},
    TeX              -> Superscript[y, d],
    Description      -> "Down-type Yukawa couplings"
  },
  yJ == {
    ParameterType    -> Internal,
    Indices          -> {Index[Generation], Index[Generation]},
    Definitions      -> {yJ[i_?NumericQ, j_?NumericQ] :> 0  /; (i =!= j)},
    Value            -> {yJ[1,1] -> Sqrt[2] ymD/v3, yJ[2,2] -> Sqrt[2] ymS/v3, yJ[3,3] -> Sqrt[2] ymT/v3},
    InteractionOrder -> {QED, 1},
    ParameterName    -> {yJ[1,1] -> yD, yJ[2,2] -> yS, yJ[3,3] -> yT},
    TeX              -> Superscript[y, J],
    Description      -> "Heavy-type Yukawa couplings"
  },
  MY == {
    ParameterType -> Internal, 
    Value         -> 1/2 gw Sqrt[v3^2+v2^2],
    TeX           -> Subscript[M,Y], 
    Description   -> "YY mass"
  },
  MV == {
    ParameterType -> Internal, 
    Value         -> 1/2 gw Sqrt[v3^2+v^2],
    TeX           -> Subscript[M,V], 
    Description   -> "V mass"
  },
  MH2 == {
    ParameterType -> Internal, 
    Value         -> Sqrt[2] Sqrt[ff UH22 UH32 v-lam1 UH12^2 v^2+ff UH12 UH32 v2-lam12 UH12 UH22 v v2-lam2 UH22^2 v2^2-(ff UH32^2 v v2)/(2 v3)+ff UH12 UH22 v3-lam13 UH12 UH32 v v3-(ff UH22^2 v v3)/(2 v2)-lam23 UH22 UH32 v2 v3-(ff UH12^2 v2 v3)/(2 v)-lam3 UH32^2 v3^2],
    TeX           -> Subscript[M,H2], 
    Description   -> "H2 mass"
  },
  MH3 == {
    ParameterType -> Internal, 
    Value         -> Sqrt[2] Sqrt[ff UH23 UH33 v-lam1 UH13^2 v^2+ff UH13 UH33 v2-lam12 UH13 UH23 v v2-lam2 UH23^2 v2^2-(ff UH33^2 v v2)/(2 v3)+ff UH13 UH23 v3-lam13 UH13 UH33 v v3-(ff UH23^2 v v3)/(2 v2)-lam23 UH23 UH33 v2 v3-(ff UH13^2 v2 v3)/(2 v)-lam3 UH33^2 v3^2],
    TeX           -> Subscript[M,H3], 
    Description   -> "H3 mass"
  },
  Uh11 == {
    ParameterType -> Internal, 
    Value         -> v3/(v Sqrt[1 + (1/v^2 + 1/v2^2) v3^2]),
    TeX           -> Subsuperscript[U, 11, h], 
    Description   -> "11 rotation-matrix element of Pseudoscalar"
  },
  Uh12 == {
    ParameterType -> Internal, 
    Value         -> -v/(Sqrt[1 + v^2/v3^2] v3),
    TeX           -> Subsuperscript[U, 12, h], 
    Description   -> "12 rotation-matrix element of Pseudoscalar"
  },
  Uh13 == {
    ParameterType -> Internal, 
    Value         -> -(v v2 v3^2 (v^2 + v3^2))/(Sqrt[
 v2^2 (v^2 + v3^2)^2] Sqrt[(v^2 + v3^2) (v2^2 v3^2 + 
    v^2 (v2^2 + v3^2))]),
    TeX           -> Subsuperscript[U, 13, h], 
    Description   -> "13 rotation-matrix element of Pseudoscalar"
  },
  Uh21 == {
    ParameterType -> Internal, 
    Value         -> v3/(v2 Sqrt[1 + (1/v^2 + 1/v2^2) v3^2]),
    TeX           -> Subsuperscript[U, 21, h], 
    Description   -> "21 rotation-matrix element of Pseudoscalar"
  },
  Uh23 == {
    ParameterType -> Internal, 
    Value         -> Sqrt[
 v2^2 (v^2 + v3^2)^2]/Sqrt[(v^2 + v3^2) (v2^2 v3^2 + 
   v^2 (v2^2 + v3^2))],
    TeX           -> Subsuperscript[U, 23, h], 
    Description   -> "23 rotation-matrix element of Pseudoscalar"
  },
  Uh31 == {
    ParameterType -> Internal, 
    Value         -> 1/Sqrt[1 + (1/v^2 + 1/v2^2) v3^2],
    TeX           -> Subsuperscript[U, 31, h], 
    Description   -> "31 rotation-matrix element of Pseudoscalar"
  },
  Uh32 == {
    ParameterType -> Internal, 
    Value         -> 1/Sqrt[1 + v^2/v3^2],
    TeX           -> Subsuperscript[U, 32, h], 
    Description   -> "32 rotation-matrix element of Pseudoscalar"
  },
  Uh33 == {
    ParameterType -> Internal, 
    Value         -> -(v^2 v2 v3 (v^2 + v3^2))/(Sqrt[
 v2^2 (v^2 + v3^2)^2] Sqrt[(v^2 + v3^2) (v2^2 v3^2 + 
    v^2 (v2^2 + v3^2))]),
    TeX           -> Subsuperscript[U, 33, h], 
    Description   -> "33 rotation-matrix element of Pseudoscalar"
  },
  MH0 == {
    ParameterType -> Internal, 
    Value         -> Sqrt[2] Sqrt[-ff Uh21 Uh31 v-ff Uh11 Uh31 v2-(ff Uh31^2 v v2)/(2 v3)-ff Uh11 Uh21 v3-(ff Uh21^2 v v3)/(2 v2)-(ff Uh11^2 v2 v3)/(2 v)],
    TeX           -> Subscript[M,H0], 
    Description   -> "H0 mass"
  },
  MHW == {
    ParameterType -> Internal, 
    Value         -> Sqrt[ (v^2+v2^2) ((-ff v3)/(v v2)-lam12P/2)],
    TeX           -> Subscript[M,HW], 
    Description   -> "HW mass"
  },
  MHY == {
    ParameterType -> Internal, 
    Value         -> Sqrt[ (v2^2+v3^2) ((-ff v)/(v2 v3)-lam23P/2)],
    TeX           -> Subscript[M,HY], 
    Description   -> "HY mass"
  },
  MHV == {
    ParameterType -> Internal, 
    Value         -> Sqrt[ (v^2+v3^2) ((-ff v2)/(v v3)-lam13P/2)],
    TeX           -> Subscript[M,HV], 
    Description   -> "HV mass"
  },




(* N. B. : only Cabibbo mixing! *)
  CKM == { 
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    Unitary       -> True,
    Value         -> {CKM[1,1] -> 1-lamWS^2/2,  CKM[1,2] -> lamWS, CKM[1,3] -> AWS*lamWS^3*(rhoWS-I*etaWS), CKM[2,1] -> -lamWS, CKM[2,2] -> 1-lamWS^2/2, CKM[2,3] -> AWS*lamWS^2, CKM[3,1] -> AWS*lamWS^3*(1-rhoWS-I*etaWS), CKM[3,2] -> -AWS*lamWS^2, CKM[3,3] -> 1},
    TeX         -> Superscript[V,CKM],
    Description -> "CKM-Matrix"
  },
  RU == {
    ParameterType -> Internal,
    Indices       -> {Index[Generation], Index[Generation]},
    Unitary       -> True,
    Definitions         -> {RU[1,1] -> 1,  RU[1,2] -> 0, RU[1,3] -> 0, RU[2,1] -> 0, RU[2,2] -> 1, RU[2,3] -> 0, RU[3,1] -> 0, RU[3,2] -> 0, RU[3,3] -> 1},
    TeX         -> Superscript[R,u],
    Description -> "RU-Matrix"
  }

};

(* ************************** *)
(* *****   Lagrangian   ***** *)
(* ************************** *)

LGauge := Block[{mu,nu,ii,aa}, 

  ExpandIndices[-1/4 FS[K,mu,nu] FS[K,mu,nu] - 1/4 FS[Wi,mu,nu,ii]FS[Wi,mu,nu,ii] - 1/4 FS[G,mu,nu,aa] FS[G,mu,nu,aa], FlavorExpand->SU3W]];


LFermions := Block[{mu,fermi},
  
  fermi=ExpandIndices[I*(
QL12bar.Ga[mu].DC[QL12, mu] + QL3bar.Ga[mu].DC[QL3, mu] + LLbar.Ga[mu].DC[LL, mu] + uRbar.Ga[mu].DC[uR, mu] + dRbar.Ga[mu].DC[dR, mu] + JR12bar.Ga[mu].DC[JR12,mu] + JR3bar.Ga[mu].DC[JR3,mu] + lRbar.Ga[mu].DC[lR, mu] + EERbar.Ga[mu].DC[EER, mu]), 
  FlavorExpand->{SU3W,SU3T,ASU3W,ASU3T}];
  fermi = ExpandIndices[fermi]];

LHiggs := Block[{ii,mu, feynmangaugerules},
  feynmangaugerules = If[Not[FeynmanGauge], {GZ|GZP|GW|GWbar|GY|GYbar|GV|GVbar ->0}, {}];
 
  ExpandIndices[DC[Rhobar[ii],mu] DC[Rho[ii],mu] + DC[Phibar[ii],mu] DC[Phi[ii],mu] + DC[Chibar[ii],mu] DC[Chi[ii],mu] + mu1 Rhobar[ii] Rho[ii] + lam1 Rhobar[ii] Rho[ii] Rhobar[jj] Rho[jj] + mu2 Phibar[ii] Phi[ii] + lam2 Phibar[ii] Phi[ii] Phibar[jj] Phi[jj] + mu3 Chibar[ii] Chi[ii] + lam3 Chibar[ii] Chi[ii] Chibar[jj] Chi[jj] + lam12 Rhobar[ii] Rho[ii] Phibar[jj] Phi[jj] + lam13 Rhobar[ii] Rho[ii] Chibar[jj] Chi[jj] + lam23 Phibar[ii] Phi[ii] Chibar[jj] Chi[jj] + lam12P Rhobar[ii] Phi[ii] Phibar[jj] Rho[jj] + lam13P Rhobar[ii] Chi[ii] Chibar[jj] Rho[jj] + lam23P Phibar[ii] Chi[ii] Chibar[jj] Phi[jj] + Sqrt[2] ff Eps[ii,jj,kk] Rho[ii] Phi[jj] Chi[kk] + Sqrt[2] ff HC[Eps[ii,jj,kk] Rho[ii] Phi[jj] Chi[kk]], FlavorExpand->{SU3T,SU3W}]/.feynmangaugerules
 ];

LYukawa := Block[{sp,ii,cc,ff1,ff3,ff4,yuk,feynmangaugerules},
  feynmangaugerules = If[Not[FeynmanGauge], {GZ|GZP|GW|GWbar|GY|GYbar|GV|GVbar ->0}, {}];
 
  yuk = ExpandIndices[
   -yl[ff1, ff3] LLbar[sp, ii, ff1].lR [sp, ff3] Phibar[ii] 
   -yE[ff1, ff3] LLbar[sp, ii, ff1].EER [sp, ff3] Chibar[ii]
   -yu[ff1, ff3] RU[ff2, ff1]  QLbar[sp, ii, ff4, cc].uR [sp, ff3, cc] Su[ff4, ff1, ii]
   -yd[ff1, ff3] CKM[ff2, ff1] QLbar[sp, ii, ff4, cc].dR [sp, ff3, cc] Sd[ff4, ff2, ii]
   -yJ[ff1, ff3] QLbar[sp, ii, ff2, cc].JR[sp, ff3, cc] SJ[ff2, ff1, ii],
FlavorExpand -> {SU3T}];
  yuk = ExpandIndices[yuk] /.{CKM[a_, b_] Conjugate[CKM[a_, c_]] -> 1/3 IndexDelta[b, c],CKM[b_, a_] Conjugate[CKM[c_, a_]] -> 1/3 IndexDelta[b, c]};
  yuk+HC[yuk]/.feynmangaugerules
 ];

LGhost := Block[{LGh1,LGhw,LGhs,LGhhiggs,LGhrho,LGhphi,LGhchi,mu, generators,gh,ghbar,Vectorize,rho1,rho2,rho3,rho4,phi1,phi2,phi3,phi4,chi1,chi2,chi3,chi4,togoldstones,rho,rho0,phi,phi0,chi,chi0},
  (* Pure gauge piece *) 	
  LGh1 = -ghKbar.del[DC[ghK,mu],mu];
  LGhw = -ghWibar.del[DC[ghWi,mu],mu];
  LGhs = -ghGbar.del[DC[ghG,mu],mu];

  (* Scalar pieces: see Peskin pages 739-742 *)
  (* rho1, rho2, rho3 and rho4 are the real degrees of freedom of HW and GW *)
  (* Vectorize transforms a triplet in a vector in the phi-basis, i.e. the basis of real degrees of freedom *)
  gh    = {ghK, ghWi[1], ghWi[2], ghWi[3], ghWi[4], ghWi[5], ghWi[6], ghWi[7], ghWi[8]};
  ghbar = {ghKbar, ghWibar[1], ghWibar[2], ghWibar[3], ghWibar[4], ghWibar[5], ghWibar[6], ghWibar[7], ghWibar[8]};
  generators = {-I/2 gx IdentityMatrix[3], -I/2 gw Gellmann[1], -I/2 gw Gellmann[2], -I/2 gw Gellmann[3], -I/2 gw Gellmann[4], -I/2 gw Gellmann[5], -I/2 gw Gellmann[6], -I/2 gw Gellmann[7], -I/2 gw Gellmann[8]};
  rho = Expand[{(-I rho1 - rho2)/Sqrt[2], (UH11 h + UH12 H2 + UH13 H3 + I (Uh11 H0 + Uh12 GZ + Uh13 GZP))/Sqrt[2], (-I rho3 - rho4)/Sqrt[2] } ]; 
  rho0 = {0, v/Sqrt[2], 0};
  phi = Expand[{(UH21 h + UH22 H2 + UH23 H3 + I (Uh21 H0  + Uh23 GZP))/Sqrt[2], (-I phi1 - phi2)/Sqrt[2], (-I phi3 - phi4)/Sqrt[2] } ]; 
  phi0 = {v2/Sqrt[2], 0, 0};
  chi = Expand[{(-I chi1 - chi2)/Sqrt[2], (-I chi3 - chi4)/Sqrt[2], (UH31 h + UH32 H2 + UH33 H3 + I (Uh31 H0 + Uh32 GZ + Uh33 GZP))/Sqrt[2] } ];
  chi0 = {0, 0, v3/Sqrt[2]};
  Vectorize[{a_, b_, c_}]:= Simplify[{Sqrt[2] Re[Expand[a]], Sqrt[2] Im[Expand[a]], Sqrt[2] Re[Expand[b]], Sqrt[2] Im[Expand[b]], Sqrt[2] Re[Expand[c]], Sqrt[2] Im[Expand[c]]}/.{Im[_]->0, Re[num_]->num}];
  togoldstones := {
rho1 -> (HW svv2 + GW cvv2 + HWbar svv2 + GWbar cvv2)/Sqrt[2], 
rho2 -> (- HW svv2 - GW cvv2  + HWbar svv2 + GWbar cvv2)/(I Sqrt[2]), 
rho3 -> (GV cvv3 + HV svv3 + GVbar cvv3 + HVbar svv3)/Sqrt[2], 
rho4 -> (- GV cvv3 - HV svv3  + GVbar cvv3 + HVbar svv3)/(I Sqrt[2]),
phi1 -> (- HW cvv2 + GW svv2 - HWbar cvv2 + GWbar svv2)/Sqrt[2], 
phi2 -> (HWbar cvv2 - GWbar svv2 - HW cvv2 + GW svv2)/(I Sqrt[2]), 
phi3 -> (GY cv2v3 + HY sv2v3 + GYbar cv2v3 + HYbar sv2v3)/Sqrt[2], 
phi4 -> (- GY cv2v3 - HY sv2v3 + GYbar cv2v3 + HYbar sv2v3)/(I Sqrt[2]),
chi1 -> (- HY cv2v3 + GY sv2v3 - HYbar cv2v3 + GYbar sv2v3)/Sqrt[2], 
chi2 -> (HYbar cv2v3 - GYbar sv2v3 - HY cv2v3 + GY sv2v3)/(I Sqrt[2]), 
chi3 -> (- HV cvv3 + GV svv3 - HVbar cvv3 + GVbar svv3)/Sqrt[2], 
chi4 -> (HVbar cvv3 - GVbar svv3 - HV cvv3 + GV svv3)/(I Sqrt[2])};
  LGhrho=
Plus@@Flatten[Table[-ghbar[[kkk]].gh[[lll]] Vectorize[generators[[kkk]].(rho0)].Vectorize[generators[[lll]].(rho + rho0)],{kkk,9},{lll,9}]];
  LGhphi=
Plus@@Flatten[Table[-ghbar[[kkkk]].gh[[llll]] Vectorize[generators[[kkkk]].(phi0)].Vectorize[generators[[llll]].(phi + phi0)],{kkkk,9},{llll,9}]];
  LGhchi=
Plus@@Flatten[Table[-ghbar[[kkkkk]].gh[[lllll]] Vectorize[generators[[kkkkk]].(chi0)].Vectorize[generators[[lllll]].(chi + chi0)],{kkkkk,9},{lllll,9}]];

  LGhhiggs=LGhrho+ LGhphi+ LGhchi /.togoldstones;

ExpandIndices[ LGhs + If[FeynmanGauge, LGhw +LGh1 + LGhhiggs ,0], FlavorExpand->SU3W]];

LThree:= LHiggs+LFermions+LYukawa+LGhost+LGauge;

Table[Gellmann[i, j, k] = 0, {i, 1, 8}, {j, 1, 3}, {k, 1, 3}] // 
  Flatten;

Gellmann[1] = {{0, 1, 0}, {1, 0, 0}, {0, 0, 0}};
Gellmann[2] = {{0, -I, 0}, {I, 0, 0}, {0, 0, 0}};
Gellmann[3] = {{1, 0, 0}, {0, -1, 0}, {0, 0, 0}};
Gellmann[4] = {{0, 0, 1}, {0, 0, 0}, {1, 0, 0}};
Gellmann[5] = {{0, 0, -I}, {0, 0, 0}, {I, 0, 0}};
Gellmann[6] = {{0, 0, 0}, {0, 0, 1}, {0, 1, 0}};
Gellmann[7] = {{0, 0, 0}, {0, 0, -I}, {0, I, 0}};
Gellmann[8] = 1/Sqrt[3] {{1, 0, 0}, {0, 1, 0}, {0, 0, -2}};

Gellmann[1, 1, 2] = 1; Gellmann[1, 2, 1] = 1;
Gellmann[2, 1, 2] = -I; Gellmann[2, 2, 1] = I;
Gellmann[3, 1, 1] = 1; Gellmann[3, 2, 2] = -1;
Gellmann[4, 1, 3] = 1; Gellmann[4, 3, 1] = 1;
Gellmann[5, 1, 3] = -I; Gellmann[5, 3, 1] = I;
Gellmann[6, 2, 3] = 1; Gellmann[6, 3, 2] = 1;
Gellmann[7, 2, 3] = -I; Gellmann[7, 3, 2] = I;
Gellmann[8, 1, 1] = 1/Sqrt[3]; Gellmann[8, 2, 2] = 1/Sqrt[3];
Gellmann[8, 3, 3] = -2/Sqrt[3];


Gellmann[i_Integer, j_Integer, k_Integer] := Gellmann[i][[j, k]];
Gellmann[xx___, Index[_, i_Integer], yy___] := Gellmann[xx, i, yy];

Gellmann /: 
  Gellmann[i1_, i2_, i3_?(Not[NumericQ[#]] &)] Gellmann[j1_, i3_, 
    j3_] :=     
  Gellmann[i1, i2, 1] Gellmann[j1, 1, j3] + 
   Gellmann[i1, i2, 2] Gellmann[j1, 2, j3] +
   Gellmann[i1, i2, 3] Gellmann[j1, 3, j3];

Table[x[i, j, k] = 0, {i, 1, 8}, {j, 1, 8}, {k, 1, 8}] // Flatten;
x[1, 2, 3] = 1; x[2, 3, 1] = 1; x[3, 1, 2] = 1;
x[2, 1, 3] = -1; x[1, 3, 2] = -1; x[3, 2, 1] = -1;
x[1, 5, 6] = -1/2; x[3, 6, 7] = -1/2; x[1, 7, 4] = -1/2; 
x[2, 6, 4] = -1/2; x[2, 7, 5] = -1/2; x[3, 5, 4] = -1/2; 
x[6, 1, 5] = -1/2; x[7, 3, 6] = -1/2; x[4, 1, 7] = -1/2; 
x[4, 2, 6] = -1/2; x[5, 2, 7] = -1/2; x[4, 3, 5] = -1/2; 
x[5, 6, 1] = -1/2; x[6, 7, 3] = -1/2; x[7, 4, 1] = -1/2; 
x[6, 4, 2] = -1/2; x[7, 5, 2] = -1/2; x[5, 4, 3] = -1/2;
x[1, 6, 5] = 1/2; x[3, 7, 6] = 1/2; x[1, 4, 7] = 1/2; 
x[2, 4, 6] = 1/2; x[2, 5, 7] = 1/2; x[3, 4, 5] = 1/2; 
x[5, 1, 6] = 1/2; x[7, 6, 3] = 1/2; x[4, 7, 1] = 1/2; 
x[4, 6, 2] = 1/2; x[5, 7, 2] = 1/2; x[4, 5, 3] = 1/2; 
x[6, 5, 1] = 1/2; x[6, 3, 7] = 1/2; x[7, 1, 4] = 1/2; 
x[6, 2, 4] = 1/2; x[7, 2, 5] = 1/2; x[5, 3, 4] = 1/2;
x[4, 5, 8] = Sqrt[3]/2; x[6, 7, 8] = Sqrt[3]/2; 
x[8, 4, 5] = Sqrt[3]/2; x[8, 6, 7] = Sqrt[3]/2; 
x[5, 8, 4] = Sqrt[3]/2; x[7, 8, 6] = Sqrt[3]/2;
x[4, 8, 5] = -Sqrt[3]/2; x[6, 8, 7] = -Sqrt[3]/2; 
x[5, 4, 8] = -Sqrt[3]/2;
x[7, 6, 8] = -Sqrt[3]/2; x[8, 7, 6] = -Sqrt[3]/2; 
x[8, 5, 4] = -Sqrt[3]/2;

x /: x[ii___, Except[Index[___] | _?NumericQ, jj_], kk___] f_[aa___, 
    Index[name_, jj_], cc___] := 
  x[ii, Index[name, jj], kk] f[aa, Index[name, jj], cc];
x /: x[ii___, Except[Index[___] | _?NumericQ, jj_], 
    kk___] f_[aa___, Index[name_, jj_], cc___][ind___] := 
  x[ii, Index[name, jj], kk] f[aa, Index[name, jj], cc][ind];
x /: x[ii___, Except[Index[___] | _?NumericQ, jj_], kk___] f_[aa___, 
    g_[xx___, Index[name_, jj_], yy___], cc___] := 
  x[ii, Index[name, jj], kk] f[aa, g[xx, Index[name, jj], yy], cc];
x /: x[ii___, Except[Index[___] | _?NumericQ, jj_], 
    kk___] f_[aa___, g_[xx___, Index[name_, jj_], yy___], cc___][
    ind___] := 
  x[ii, Index[name, jj], kk] f[aa, g[xx, Index[name, jj], yy], cc][
    ind];

x[ii___, Except[_Index | _Done[Index] | _FV, 
    jj_?(Not[NumericQ[#]] &)], kk___, Index[name_, ll_], mm___] := 
  x[ii, Index[name, jj], kk, Index[name, ll], mm];
x[ii___, Index[name_, ll_], kk___, 
   Except[_Index | _Done[Index] | _FV, jj_?(Not[NumericQ[#]] &)], 
   mm___] := x[ii, Index[name, ll], kk, Index[name, jj], mm];

x /: x[i_?((Not[NumericQ[#]] && Not[MatchQ[#, Index[_, _?NumericQ]]] &&
          Not[MatchQ[#, Done[Index][_, _?NumericQ]]]) &), j_, k_] x[
    i_, m_, n_] := 
  x[1, j, k] x[1, m, n] + x[2, j, k] x[2, m, n] + 
   x[3, j, k] x[3, m, n] + x[4, j, k] x[4, m, n] + 
   x[5, j, k] x[5, m, n] + x[6, j, k] x[6, m, n] + 
   x[7, j, k] x[7, m, n] + x[8, j, k] x[8, m, n];

x /: x[i_?((Not[NumericQ[#]] && Not[MatchQ[#, Index[_, _?NumericQ]]] &&
          Not[MatchQ[#, Done[Index][_, _?NumericQ]]]) &), j_, k_] x[
    m_, n_, i_] := x[i, j, k] x[i, m, n];
x /: x[i_?((Not[NumericQ[#]] && Not[MatchQ[#, Index[_, _?NumericQ]]] &&
          Not[MatchQ[#, Done[Index][_, _?NumericQ]]]) &), j_, k_] x[
    m_, i_, n_] := x[i, j, k] x[i, n, m];
x /: x[j_, 
    i_?((Not[NumericQ[#]] && Not[MatchQ[#, Index[_, _?NumericQ]]] && 
         Not[MatchQ[#, Done[Index][_, _?NumericQ]]]) &), k_] x[m_, i_,
     n_] := x[i, k, j] x[i, n, m];
x /: x[j_, 
    i_?((Not[NumericQ[#]] && Not[MatchQ[#, Index[_, _?NumericQ]]] && 
         Not[MatchQ[#, Done[Index][_, _?NumericQ]]]) &), k_] x[m_, n_,
     i_] := x[i, k, j] x[i, m, n];
x /: x[j_, k_, 
    i_?((Not[NumericQ[#]] && Not[MatchQ[#, Index[_, _?NumericQ]]] && 
         Not[MatchQ[#, Done[Index][_, _?NumericQ]]]) &)] x[m_, n_, 
    i_] := x[i, j, k] x[i, m, n];

x /: x[___, i_, ___, j_, ___] FV[a_, i_] FV[a_, j_] := 0;
x /: x[___, i_, ___, j_, ___] del[del[_, i_], j_] := 0;
x /: x[___, i_, ___, j_, ___] del[del[_, j_], i_] := 0;

x[xx___, Index[name_, i_?NumericQ], yy___] := x[xx, i, yy];