M$ModelName = "2IDM3N";

M$Information = {Authors -> {"Amine Ahriche"},
                 Version -> "1.0",
                 Date -> "04. 10. 2022",
                 Institutions -> {"Sharjah U., UAE."},
                 Emails -> {"ahriche@sharjah.ac.ae"}
	        };

FeynmanGauge = False;
M$InteractionOrderHierarchy = { {QCD,1}, {NP,1}, {QED,2} }
M$Parameters = Join[M$IntPrm, M$ExtPrm];

IndexRange[ Index[Generation] ] = Range[3]
IndexRange[ Index[Colour] ] = NoUnfold[Range[3]]
IndexRange[ Index[Gluon] ] = NoUnfold[Range[8]]
IndexRange[ Index[SU2W] ] = Range[3]

IndexStyle[Colour, i]
IndexStyle[Generation, f]
IndexStyle[Gluon,a]
IndexStyle[SU2W,k]

M$GaugeGroups = {

U1Y == {
	Abelian -> True,
	GaugeBoson -> B,
	Charge -> Y,
	CouplingConstant -> g1},

SU2L == {
	Abelian -> False,
	GaugeBoson -> Wi,
	StructureConstant -> Eps,
	CouplingConstant -> g2},

SU3C == {
	Abelian -> False,
	GaugeBoson -> G,
	StructureConstant -> f,
	Representations -> {T, Colour},
	CouplingConstant -> gs}
}

(*****************************)
(*** Parameters of the IDM ***)
(*****************************)

(*-------------------------*)
(*** External Parameters ***)
(*-------------------------*)

M$ExtPrm = {

(*** Electroweak interaction ***)

aEWM1== {
	TeX              -> Subsuperscript[\[Alpha],w,-1],
	ParameterType    -> External,
	Value		 -> 1./128.9,
	InteractionOrder -> {QED, -2},
	Description      -> "EW coupling constant at the Z pole"},

Gf == {
	TeX              -> Subscript[G,F],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 1.16637*10^(-5),
	InteractionOrder -> {QED, 2},
	Description      -> "Fermi constant"},

MZ == {
	TeX              -> Subscript[m,Z],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 91.1876,
	Description      -> "Z pole mass"},

MW == {
	TeX              -> Subscript[m,W],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 79.947,
	Description      -> "W pole mass"},

(*** Strong  interaction ***)

aS == {
	TeX              -> Subscript[\[Alpha],s],
	ParameterType    -> External,
	Value		 -> 0.1172,
	InteractionOrder -> {QCD, 2},
	Description      -> "Strong coupling constant at the Z pole."},

QS == {
	TeX              -> Subscript[Q,s],
	ParameterType    -> External,
	Value		 -> 100.,
	InteractionOrder -> {QCD, 1},
	Description      -> "QCD scale for running quark masses in CalcHEP"},

v == {
	TeX              -> v,
	ParameterType    -> External,
	Value -> 246.22,
	ComplexParameter -> False,
	InteractionOrder -> {QED, -1},
	Description -> "Higgs VEV"},

(*** Scalar  mixing ***)

sH == {
	TeX              -> Subscript[sin, H],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.1,
	Description      -> "mixing H"},

sA == {
	TeX              -> Subscript[sin, A],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.1,
	Description      -> "mixing H"},

sC == {
	TeX              -> Subscript[sin, C],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.1,
	Description      -> "mixing H"},

(*** Scalar  sector ***)

lam1 == {
	TeX              -> Subscript[\[Lambda], 1],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.05,
	InteractionOrder -> {QED, 2},
	Description      -> "Inert doublet quartic self-coupling"},

lam2 == {
	TeX              -> Subscript[\[Lambda], 2],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.05,
	InteractionOrder -> {QED, 2},
	Description      -> "Inert doublet quartic self-coupling"},

w1 == {
	TeX              -> Subscript[\[Omega], 1],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.05,
	InteractionOrder -> {QED, 2},
	Description      -> "Inert doublet quartic self-coupling"},

w2 == {
	TeX              -> Subscript[\[Omega], 2],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.1,
	InteractionOrder -> {QED, 2},
	Description      -> "Inert doublet quartic self-coupling"},

r1 == {
	TeX              -> Subscript[\[Rho], 1],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.05,
	InteractionOrder -> {QED, 2},
	Description      -> "Inert doublet quartic self-coupling"},

r2 == {
	TeX              -> Subscript[\[Rho], 2],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.05,
	InteractionOrder -> {QED, 2},
	Description      -> "Inert doublet quartic self-coupling"},

mh == {
	TeX              -> Subscript[m, h],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 125.18,
	Description      -> "Higgs boson mass"},

hr11 == {
	TeX              -> Subscript[hr, 11],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr12 == {
	TeX              -> Subscript[hr, 12],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr13 == {
	TeX              -> Subscript[hr, 13],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr14 == {
	TeX              -> Subscript[hr, 14],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr15 == {
	TeX              -> Subscript[hr, 15],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr16 == {
	TeX              -> Subscript[hr, 16],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr21 == {
	TeX              -> Subscript[hr, 21],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr22 == {
	TeX              -> Subscript[hr, 22],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr23 == {
	TeX              -> Subscript[hr, 23],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr24 == {
	TeX              -> Subscript[hr, 24],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr25 == {
	TeX              -> Subscript[hr, 25],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr26 == {
	TeX              -> Subscript[hr, 26],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr31 == {
	TeX              -> Subscript[hr, 31],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr32 == {
	TeX              -> Subscript[hr, 32],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr33 == {
	TeX              -> Subscript[hr, 33],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr34 == {
	TeX              -> Subscript[hr, 34],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr35 == {
	TeX              -> Subscript[hr, 35],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hr36 == {
	TeX              -> Subscript[hr, 36],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.5,
	InteractionOrder -> {NP, 1},
	Description      -> "real-Yuk"},

hi11 == {
	TeX              -> Subscript[hi, 11],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi12 == {
	TeX              -> Subscript[hi, 12],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi13 == {
	TeX              -> Subscript[hi, 13],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi14 == {
	TeX              -> Subscript[hi, 14],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi15 == {
	TeX              -> Subscript[hi, 15],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi16 == {
	TeX              -> Subscript[hi, 16],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi21 == {
	TeX              -> Subscript[hi, 21],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi22 == {
	TeX              -> Subscript[hi, 22],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi23 == {
	TeX              -> Subscript[hi, 23],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi24 == {
	TeX              -> Subscript[hi, 24],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi25 == {
	TeX              -> Subscript[hi, 25],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi26 == {
	TeX              -> Subscript[hi, 26],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi31 == {
	TeX              -> Subscript[hi, 31],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi32 == {
	TeX              -> Subscript[hi, 32],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi33 == {
	TeX              -> Subscript[hi, 33],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi34 == {
	TeX              -> Subscript[hi, 34],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi35 == {
	TeX              -> Subscript[hi, 35],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"},

hi36 == {
	TeX              -> Subscript[hi, 36],
	ParameterType    -> External,
	ComplexParameter -> False,
	Value		 -> 0.2,
	InteractionOrder -> {NP, 1},
	Description      -> "Im-Yuk"}

}

(*-------------------------*)
(*** Internal Parameters ***)
(*-------------------------*)

M$IntPrm = {

(*** Electroweak interaction ***)

cH == {
	TeX              -> Subscript[cos H],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> Sqrt[1-sH^2],
	Description      -> "Scalar mixing"},

cA == {
	TeX              -> Subscript[cos A],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> Sqrt[1-sA^2],
	Description      -> "Scalar mixing"},

cC == {
	TeX              -> Subscript[cos C],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> Sqrt[1-sC^2],
	Description      -> "Scalar mixing"},

mu12 == {
	TeX              -> Subscript[\[Mu], 1],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value		 -> MH01^2 cC^2 + MH02^2 sC^2 - w1/2 v^2 ,
	Description      -> "Inert mass parameter"},

mu22 == {
	TeX              -> Subscript[\[Mu], 2],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value		 -> MH01^2 sC^2 + MH02^2 cC^2 - w2/2 v^2,
	Description      -> "Inert mass parameter"},

mu32 == {
	TeX              -> Subscript[\[Mu], 3],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value		 -> sC cC (MH02^2 - MH01^2),
	Description      -> "Inert mass parameter"},

k1 == {
	TeX              -> Subscript[\[Kappa], 1],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value		 -> ( MH01^2 cH^2 + MH02^2 sH^2 + MA01^2 cA^2 + MA02^2 sA^2 -2 (MHch1^2 cC^2 + MHch2^2 sC^2) )/v^2,
	InteractionOrder -> {QED, 2},
	Description      -> "Inert doublet quartic self-coupling"},

k2 == {
	TeX              -> Subscript[\[Kappa], 2],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value		 -> ( MH01^2 sH^2 + MH02^2 cH^2 + MA01^2 sA^2 + MA02^2 cA^2 -2 (MHch1^2 sC^2 + MHch2^2 cC^2) )/v^2,
	InteractionOrder -> {QED, 2},
	Description      -> "Inert doublet quartic self-coupling"},

x1 == {
	TeX              -> Subscript[\[Chi], 1],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value		 -> ( MH01^2 cH^2 + MH02^2 sH^2 - MA01^2 cA^2 - MA02^2 sA^2 )/v^2,
	InteractionOrder -> {QED, 2},
	Description      -> "Inert doublet quartic self-coupling"},

x2 == {
	TeX              -> Subscript[\[Chi], 2],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value		 -> ( MH01^2 sH^2 + MH02^2 cH^2 - MA01^2 sA^2 - MA02^2 cA^2 )/v^2,
	InteractionOrder -> {QED, 2},
	Description      -> "Inert doublet quartic self-coupling"},

x3 == {
	TeX              -> Subscript[\[Chi], 3],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value		 -> ( sH cH (MH02^2 - MH01^2) - sA cA (MA02^2 - MA01^2) )/v^2,
	InteractionOrder -> {QED, 2},
	Description      -> "Inert doublet quartic self-coupling"},

x4 == {
	TeX              -> Subscript[\[Chi], 4],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value		 -> ( sH cH (MH02^2 - MH01^2) + sA cA (MA02^2 - MA01^2) -2 sC cC (MHch2^2 - MHch1^2) )/v^2,
	InteractionOrder -> {QED, 2},
	Description      -> "Inert doublet quartic self-coupling"},

ee == {
	TeX              -> e,
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> Sqrt[4 Pi aEWM1],
	InteractionOrder -> {QED, 1},
	Description      -> "Electron charge - Photon coupling to electrons"},

CW2 == {
	TeX              -> Subsuperscript[c, w,2],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> (MW/MZ)^2,
	Description      -> "Squared cosine of the weak angle"},
SW2 == {
	TeX              -> Subsuperscript[s, w,2],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> 1-CW2,
	Description      -> "Squared Sin of the weak angle"},
CW == {
	TeX              -> Subscript[c, w],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> Sqrt[CW2],
	Description      -> "Cosine of the weak angle"},
SW == {
	TeX              -> Subscript[s, w],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> Sqrt[SW2],
	Description      -> "Sine of the weak angle"},

g1 == {
	TeX              -> Subscript[g, 1],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> ee/CW,
	InteractionOrder -> {QED, 1},

        Description      -> "U(1)_Y coupling constant"},

g2 == {
	TeX              -> Subscript[g, 2],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> ee/SW,
	InteractionOrder -> {QED, 1},
	Description      -> "SU(2) coupling constant"},

(*** Yukawa couplings ***)
yu == {
	TeX              -> Superscript[y, u],
	ParameterType    -> Internal,
	ComplexParameter -> True,
	Indices          -> {Index[Generation]},
	Definitions      :> {yu[i_] :> Sqrt[2] Mu[i]/v },
	Description      -> "up-type quark Yukawa couplings"},

yd == {
	TeX              -> Superscript[y, d],
	ParameterType    -> Internal,
	ComplexParameter -> True,
	Indices          -> {Index[Generation]},
	Definitions      :> {yd[i_] :> Sqrt[2] Md[i]/v },
	Description      -> "down-type quark Yukawa couplings"},

yl == {
	TeX              -> Superscript[y, l],
	ParameterType    -> Internal,
	ComplexParameter -> True,
	Indices          -> {Index[Generation]},
	Definitions      :> {yl[i_] :> Sqrt[2] Ml[i]/v },
	Description      -> "down-type lepton Yukawa couplings"},

(*** Strong  interaction ***)

gs == {
	TeX              -> Subscript[g, s],
	ComplexParameter -> False,
	ParameterType    -> Internal,
	Value            -> Sqrt[4 Pi aS],
	InteractionOrder -> {QCD, 1},
	ParameterName    -> G,
	Description      -> "Strong coupling constant"},

(*** CKM  matrix ***)

CKM == {
	TeX              -> Superscript[V, CKM],
	ParameterType    -> Internal,
	ComplexParameter -> True,
	Indices          -> {Index[Generation], Index[Generation]},
	TensorClass      -> CKM,
	Unitary          -> True,
	Value            -> {CKM[1,1] -> 0.97428, CKM[1,2] -> 0.2253, CKM[1,3] -> 0.00347,
                            CKM[2,1] -> 0.2252, CKM[2,2] -> 0.97345, CKM[2,3] -> 0.0410,
                            CKM[3,1] -> 0.00862, CKM[3,2] -> 0.0403, CKM[3,3] -> 0.999152},
	Description      -> "CKM-Matrix"},

(*** Scalar sector parameters ***)

muH2 == {
	TeX              -> Subscript[\[Mu], 1],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> mh^2/2,
	Description      -> "higgs mass parameter"},

lamH == {
	TeX              -> Subscript[\[Lambda], 1],
        InteractionOrder -> {QED,2},
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Value            -> 3 mh^2/v^2,
	InteractionOrder -> {QED, 2},
	Description      -> "higgs quartic self-coupling"},

(*** New Yukawa Couplings ***)

h1r == {
	TeX              -> Superscript[h1,r],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Indices          -> {Index[Generation], Index[Generation]},
	TensorClass      -> CKM,
	Unitary          -> False,
	Value            -> {h1r[1,1] -> hr11, h1r[1,2] -> hr12, h1r[1,3] -> hr13,
                           h1r[2,1] -> hr21, h1r[2,2] -> hr22, h1r[2,3] -> hr23,
                           h1r[3,1] -> hr31, h1r[3,2] -> hr32, h1r[3,3] -> hr33 },
	InteractionOrder -> {NP, 1},
	Description      -> "New-Yuk"},

h1i == {
	TeX              -> Superscript[h1,i],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Indices          -> {Index[Generation], Index[Generation]},
	TensorClass      -> CKM,
	Unitary          -> False,
	Value            -> {h1i[1,1] -> hi11, h1i[1,2] -> hi12, h1i[1,3] -> hi13,
                           h1i[2,1] -> hi21, h1i[2,2] -> hi22, h1i[2,3] -> hi23,
                           h1i[3,1] -> hi31, h1i[3,2] -> hi32, h1i[3,3] -> hi33 },
	InteractionOrder -> {NP, 1},
	Description      -> "New-Yuk"},

h2r == {
	TeX              -> Superscript[h2,r],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Indices          -> {Index[Generation], Index[Generation]},
	TensorClass      -> CKM,
	Unitary          -> False,
	Value            -> {h2r[1,1] -> hr14, h2r[1,2] -> hr15, h2r[1,3] -> hr16,
                         h2r[2,1] -> hr24, h2r[2,2] -> hr25, h2r[2,3] -> hr26,
                         h2r[3,1] -> hr34, h2r[3,2] -> hr35, h2r[3,3] -> hr36 },
	InteractionOrder -> {NP, 1},
	Description      -> "New-Yuk"},

h2i == {
	TeX              -> Superscript[h2,i],
	ParameterType    -> Internal,
	ComplexParameter -> False,
	Indices          -> {Index[Generation], Index[Generation]},
	TensorClass      -> CKM,
	Unitary          -> False,
	Value            -> {h2i[1,1] -> hi14, h2i[1,2] -> hi15, h2i[1,3] -> hi16,
                         h2i[2,1] -> hi24, h2i[2,2] -> hi25, h2i[2,3] -> hi26,
                         h2i[3,1] -> hi34, h2i[3,2] -> hi35, h2i[3,3] -> hi36 },
	InteractionOrder -> {NP, 1},
	Description      -> "New-Yuk"}

}

(*********************************************)
(*** PARTICLE CONTENT EXCEPT SCALAR SECTOR ***)
(*********************************************)

M$ClassesDescription = {

(*------------------*)
(*** GAUGE BOSONS ***)
(*------------------*)

(* Mass Eigenstates *)
V[1] == {
	ClassName       ->  A,
	SelfConjugate   ->  True,
	Indices         -> {},
	Mass            ->  0,
	Width           ->  0,
	ParticleName    ->  "a",
	PDG             ->  22,
	PropagatorLabel ->  "\\gamma",
	PropagatorType  -> Sine,
	PropagatorArrow -> None},

V[2] == {
	ClassName       ->  Z,
	SelfConjugate   ->  True,
	Indices         -> {},
	Mass            -> {MZ,Internal},
	Width           -> {WZ,2.4952},
	ParticleName    ->  "Z",
	PDG             ->  23,
	PropagatorLabel ->  "Z",
	PropagatorType  -> Sine,
	PropagatorArrow -> None},

V[3] == {
	ClassName       -> W,
	SelfConjugate   -> False,
	Indices         -> {},
	Mass            -> {MW,Internal},
	Width           -> {WW,2.085},
	QuantumNumbers  -> {Q -> 1},
	ParticleName    -> "W+",
	AntiParticleName-> "W-",
	PDG             -> 24,
	PropagatorLabel -> "W",
	PropagatorType  -> Sine,
	PropagatorArrow -> Forward},

V[4] == {
	ClassName       -> G,
	SelfConjugate   -> True,
	Indices         -> {Index[Gluon]},
	Mass            -> 0,
	Width           -> 0,
	ParticleName    ->  "g",
	PDG             -> 21,
	PropagatorLabel -> "G",
	PropagatorType  -> C,
	PropagatorArrow -> None},

(* Gauge Eigenstates and relation to mass eigenstates *)
V[5] == {
        ClassName -> Wi,
        Unphysical -> True,
        SelfConjugate -> True,
        Indices -> {Index[SU2W]},

        FlavorIndex -> SU2W,
        Mass -> 0,
        Definitions -> {Wi[mu_, 1] -> (W[mu] + Wbar[mu])/Sqrt[2],
                        Wi[mu_, 2] -> (Wbar[mu] - W[mu])/Sqrt[2]/I,
                        Wi[mu_, 3] -> CW Z[mu] + SW A[mu]}},

V[6] == {
        ClassName -> B,
	Unphysical -> True,
	SelfConjugate -> True,
	Indices -> {},
	Mass -> 0,
        Definitions -> {B[mu_] -> -SW Z[mu] + CW A[mu]}},

(*--------------------------*)
(*** Vector boson ghosts  ***)
(*--------------------------*)

(* mass eigenstates *)
U[1] == {
	ClassName -> ghA,
	SelfConjugate -> False,
	Indices -> {},
	Ghost -> A,
	Mass -> 0,
	QuantumNumbers -> {GhostNumber -> 1},
	PropagatorLabel -> uA,
	PropagatorType -> GhostDash,
	PropagatorArrow -> Forward},

U[2] == {
	ClassName -> ghZ,
	SelfConjugate -> False,
	Indices -> {},
	Mass -> {MZ, Internal},
	Ghost -> Z,
	QuantumNumbers -> {GhostNumber -> 1},
	PropagatorLabel -> uZ,
	PropagatorType -> GhostDash,
	PropagatorArrow -> Forward},

U[3] == {
	ClassName -> ghWp,
	SelfConjugate -> False,
	Indices -> {},
	Mass -> {MW, Internal},
	Ghost -> W,
	QuantumNumbers -> {Q-> 1, GhostNumber -> 1},
	PropagatorLabel -> uWp,
	PropagatorType -> GhostDash,
	PropagatorArrow -> Forward},

U[4] == {
	ClassName -> ghWm,
	SelfConjugate -> False,
	Indices -> {},
	Mass -> {MW, Internal},
	Ghost -> Wbar,
	QuantumNumbers -> {Q-> -1, GhostNumber -> 1},
	PropagatorLabel -> uWm,
	PropagatorType -> GhostDash,
	PropagatorArrow -> Forward},

U[5] == {
	ClassName -> ghG,
	SelfConjugate -> False,
	Indices -> {Index[Gluon]},
	Ghost -> G,
	Mass -> 0,
	QuantumNumbers -> {GhostNumber -> 1},
	PropagatorLabel -> uG,
	PropagatorType -> GhostDash,
	PropagatorArrow -> Forward},

(* gauge eigenstates *)
U[6] == {
	ClassName -> ghWi,
	Unphysical -> True,
	Definitions -> {ghWi[1] -> (ghWp + ghWm)/Sqrt[2],
                        ghWi[2] -> (ghWm - ghWp)/Sqrt[2]/I,
                        ghWi[3] -> CW ghZ + SW ghA},
	SelfConjugate -> False,
	Ghost -> Wi,
	Indices -> {Index[SU2W]},
	FlavorIndex -> SU2W},

U[7] == {
	ClassName -> ghB,
	SelfConjugate -> False,
	Definitions -> {ghB -> -SW ghZ + CW ghA},
	Indices -> {},
	Ghost -> B,
	Unphysical -> True},

(*--------------*)
(*** FERMIONS ***)
(*--------------*)

(* Neutrinos: I_3 = +1/2, Q = 0 *)
F[1] == {
	ClassName        -> vl,
	SelfConjugate    -> False,
	Indices          -> {Index[Generation]},
	ClassMembers     -> {ve, vm, vt},
	FlavorIndex      -> Generation,
	Mass             -> {Mnu,{Mnue, 0.},{Mnum, 0.},{Mnut, 0.}},
	Width            -> {Wnu, {Wnue, 0}, {Wnumu, 0}, {Wnut, 0}},
	ParticleName     -> {"ne", "nm", "nl"},
	AntiParticleName -> {"Ne","Nm","Nl"},
	PDG              -> {12, 14, 16},
	PropagatorLabel  -> {"v", "ve", "vm", "vt"},
	PropagatorType   -> Straight,
	PropagatorArrow  -> Forward,
	FullName -> {"Electron-neutrino", "Mu-neutrino", "Tau-neutrino"} },

(* Charged leptons: I_3 = -1/2, Q = -1 *)
F[2] == {
	ClassName        -> l,
	SelfConjugate    -> False,
	Indices          -> {Index[Generation]},
	QuantumNumbers   -> {Q ->-1},
	ClassMembers     -> {e, m, ta},
	FlavorIndex      -> Generation,
	Mass		 -> {Ml, {Me, 0.00511}, {MM, 0.1057}, {MTA, 1.77686}},
	Width            -> {Wl, {WE, 0}, {WM, 0}, {WTA, 0}},
	ParticleName     -> {"e", "m", "l"},
	AntiParticleName -> {"E", "M", "L"},
	PDG              -> {11, 13, 15},
	PropagatorLabel  -> {"l", "e", "m", "tau"},
	PropagatorType   -> Straight,
	PropagatorArrow  -> Forward,
        FullName -> {"Electron", "Muon", "Tau"} },

(* u-type quarks: I_3 = +1/2, Q = +2/3 *)
F[3] == {
	ClassName        -> uq,
	SelfConjugate    -> False,
	Indices          -> {Index[Generation], Index[Colour]},
	QuantumNumbers   -> {Q -> 2/3},
	ClassMembers     -> {u, c, t},
	FlavorIndex      -> Generation,
	Mass             -> {Mu, {MU, 0.00216}, {MC, 1.2}, {MT, 172.76}},
	Width            -> {Wu, {WU, 0}, {WC, 0}, {WT, 1.42}},
	ParticleName     -> {"u", "c", "t"},
	AntiParticleName -> {"U", "C", "T"},
	PDG              -> {2, 4, 6},
	PropagatorLabel  -> {"uq", "u", "c", "t"},
	PropagatorType   -> Straight,
	PropagatorArrow  -> Forward,
        FullName -> {"u-quark", "c-quark", "t-quark"}},

(* d-type quarks: I_3 = -1/2, Q = -1/3 *)
F[4] == {
	ClassName        -> dq,
	SelfConjugate    -> False,
	Indices          -> {Index[Generation], Index[Colour]},
	QuantumNumbers   -> {Q -> -1/3},
	ClassMembers     -> {d, s, b},
	FlavorIndex      -> Generation,
	Mass             -> {Md, {MD, 0.00467}, {MS, 0.1}, {MB, 4.23}},
	Width            -> {Wd, {WD, 0}, {WS, 0}, {WB, 0}},
	ParticleName     -> {"d", "s", "b"},
	AntiParticleName -> {"D", "S", "B"},
	PDG              -> {1, 3, 5},
	PropagatorLabel  -> {"dq", "d", "s", "b"},
	PropagatorType   -> Straight,
	PropagatorArrow  -> Forward,
        FullName -> {"d-quark", "s-quark", "b-quark"}},

(* Majoran neutrinos: I_3 = 0, Q = 0 *)

F[5] == {
 	ClassName        -> NN,
 	SelfConjugate    -> True,
 	Indices          -> {Index[Generation]},
 	ClassMembers     -> {NN1, NN2, NN3},
 	FlavorIndex      -> Generation,
 	Mass             -> {Mn,{Mn1, 20},{Mn2, 30},{Mn3, 40}},
 	Width            -> {WN, {WN1, 0}, {WN2, 0}, {WN3, 0}},
 	ParticleName     -> {"NN1", "NN2", "NN3"},
 	PDG              -> {52, 54, 56},
 	PropagatorLabel  -> {"NN", "NN1", "NN2", "NN3"},
 	PropagatorType   -> Straight,
 	PropagatorArrow  -> None,
 	FullName -> {"NN1", "NN2", "NN3"} },

S[1] == {
	ClassName        -> h,
	SelfConjugate    -> True,
	Indices          -> {},
	Mass             -> {mh, Internal},
	Width            -> {Wh, 0.0042},
	ParticleName     -> "h",
	PDG              -> 25,
	PropagatorLabel  -> "h",
	PropagatorType   -> ScalarDash,
	PropagatorArrow  -> None},

(* neutral Goldstone *)
S[2] == {
        ClassName -> G0,
	SelfConjugate -> True,
	Mass -> {MZ, Internal},
	Width -> WG0,
	PropagatorLabel -> "G0",
	PropagatorType -> D,
	PropagatorArrow -> None,
	ParticleName ->"G0",
	PDG -> 250,
	FullName -> "G0",
	Goldstone -> Z },

(* charged Goldstones *)
S[3] == {
	ClassName -> Gch,
	SelfConjugate -> False,
	Mass -> {MW, Internal},
	Width -> WGp,
	PropagatorLabel -> "Gch",
	PropagatorType -> D,
	PropagatorArrow -> None,
	ParticleName ->"G+",
	AntiParticleName ->"G-",
	PDG -> 251,
	FullName -> "Gch",
	TeXClassName -> "Gch",
	TeXParticleName -> "G^+",
	TeXAntiParticleName -> "G^-",
	Goldstone -> W,
	QuantumNumbers -> {Q -> 1}},

(*-----------------------*)
(*** IDM scalar fields ***)
(*-----------------------*)

(* Neutral scalar *)
S[4] == {
	ClassName        -> H01,
	SelfConjugate    -> True,
	Indices          -> {},
	Mass             -> {MH01, 200.},
	Width            -> {WH01, 0.},
	ParticleName     -> "H01",
	PDG              -> 75,
	PropagatorLabel  -> "H01",
	PropagatorType   -> ScalarDash,
	PropagatorArrow  -> None},

S[5] == {
	ClassName        -> H02,
	SelfConjugate    -> True,
	Indices          -> {},
	Mass             -> {MH02, 200.},
	Width            -> {WH02, 0.5},
	ParticleName     -> "H02",
	PDG              -> 76,
	PropagatorLabel  -> "H02",
	PropagatorType   -> ScalarDash,
	PropagatorArrow  -> None},

(* Neutral pseudoscalar *)
S[6] == {
	ClassName        -> A01,
	SelfConjugate    -> True,
	Indices          -> {},
	Mass             -> {MA01, 200.},
	Width            -> {WA01, 0.5},
	ParticleName     -> "A01",
	PDG              -> 77,
	PropagatorLabel  -> "A01",
	PropagatorType   -> ScalarDash,
	PropagatorArrow  -> None},

S[7] == {
	ClassName        -> A02,
	SelfConjugate    -> True,
	Indices          -> {},
	Mass             -> {MA02, 200.},
	Width            -> {WA02, 0.5},
	ParticleName     -> "A02",
	PDG              -> 78,
	PropagatorLabel  -> "A02",
	PropagatorType   -> ScalarDash,
	PropagatorArrow  -> None},

(* Charged scalar *)
S[8] == {
	ClassName        -> Hch1,
	SelfConjugate    -> False,
	Indices          -> {},
	QuantumNumbers   -> {Q -> 1},
	Mass             -> {MHch1, 250.},
	Width            -> {WHch1, 0.5},
	ParticleName     -> "H1+",
	AntiParticleName -> "H1-",
	PDG              -> 79,
	PropagatorLabel  -> "Hch1",
	PropagatorType   -> ScalarDash,
	PropagatorArrow  -> Forward},

S[9] == {
	ClassName        -> Hch2,
	SelfConjugate    -> False,
	Indices          -> {},
	QuantumNumbers   -> {Q -> 1},
	Mass             -> {MHch2, 250.},
	Width            -> {WHch2, 0.5},
	ParticleName     -> "H2+",
	AntiParticleName -> "H2-",
	PDG              -> 80,
	PropagatorLabel  -> "Hch2",
	PropagatorType   -> ScalarDash,
	PropagatorArrow  -> Forward}

};

(**********************)
(*** IDM LAGRANGIAN ***)
(**********************)

(*--------------------------------*)
(*** Gauge field strength terms ***)
(*--------------------------------*)

LGauge := -1/4*(del[B[nu],mu] - del[B[mu],nu])^2  -
	   1/4*(del[Wi[nu,i1],mu]-del[Wi[mu,i1],nu] + ee/SW*Eps[i1,i2,i3]*Wi[mu,i2]*Wi[nu,i3]) *
	       (del[Wi[nu,i1],mu]-del[Wi[mu,i1],nu] + ee/SW*Eps[i1,i4,i5]*Wi[mu,i4]*Wi[nu,i5]) -
	   1/4*(del[G[nu,a1],mu] - del[G[mu,a1],nu] + gs*f[a1,a2,a3]*G[mu,a2]*G[nu,a3])*
	       (del[G[nu,a1],mu] - del[G[mu,a1],nu] + gs*f[a1,a4,a5]*G[mu,a4]*G[nu,a5]);

(*-------------------------*)
(*** Gauge-fermion terms ***)
(*-------------------------*)

LFermions = Module[{Lkin, LQCD, LEWleft, LEWright},

        Lkin = I uqbar.Ga[mu].del[uq, mu] +
	       I dqbar.Ga[mu].del[dq, mu] +
	       I lbar.Ga[mu].del[l, mu] +
	       I vlbar.Ga[mu].del[vl, mu];

	LQCD = gs (uqbar.Ga[mu].T[a].uq +
	       dqbar.Ga[mu].T[a].dq)G[mu, a];

	LBright =
	      -2 ee/CW B[mu]/2 lbar.Ga[mu].ProjP.l +           (*Y_lR=-2*)
	     4/3 ee/CW B[mu]/2 uqbar.Ga[mu].ProjP.uq -         (*Y_uR=4/3*)
	     2/3 ee/CW B[mu]/2 dqbar.Ga[mu].ProjP.dq;          (*Y_dR=-2/3*)

	LBleft =
	        -ee/CW B[mu]/2 vlbar.Ga[mu].ProjM.vl -         (*Y_LL=-1*)
	         ee/CW B[mu]/2 lbar.Ga[mu].ProjM.l  +          (*Y_LL=-1*)
	     1/3 ee/CW B[mu]/2 uqbar.Ga[mu].ProjM.uq +         (*Y_QL=1/3*)
	     1/3 ee/CW B[mu]/2 dqbar.Ga[mu].ProjM.dq ;         (*Y_QL=1/3*)

	LWleft = 1/2 ee/SW (
	vlbar.Ga[mu].ProjM.vl Wi[mu, 3] -              (*sigma3 = ( 1   0 )*)
	lbar.Ga[mu].ProjM.l Wi[mu, 3] +                (*         ( 0  -1 )*)

	Sqrt[2] vlbar.Ga[mu].ProjM.l W[mu] +
	Sqrt[2] lbar.Ga[mu].ProjM.vl Wbar[mu]+

	uqbar.Ga[mu].ProjM.uq Wi[mu, 3] -              (*sigma3 = ( 1   0 )*)
	dqbar.Ga[mu].ProjM.dq Wi[mu, 3] +              (*         ( 0  -1 )*)

	Sqrt[2] uqbar.Ga[mu].ProjM.CKM.dq W[mu] +
	Sqrt[2] dqbar.Ga[mu].ProjM.HC[CKM].uq Wbar[mu]
	);

	Lkin + LQCD + LBright + LBleft + LWleft];

(*-----------------------*)
(*** Yukawa lagrangian ***)
(*-----------------------*)

LYuk :=
	If[FeynmanGauge, Module[{s,r,n,m,i},
	- yd[n] CKM[n,m] uqbar[s,n,i].ProjP[s,r].dq[r,m,i] (Gch)
	- yd[n]          dqbar[s,n,i].ProjP[s,r].dq[r,n,i] (v+h+I G0)/Sqrt[2]

	- yu[n]                     uqbar[s,n,i].ProjP[s,r].uq[r,n,i] (v+h-I G0)/Sqrt[2]
	+ yu[n] Conjugate[CKM[m,n]] dqbar[s,n,i].ProjP[s,r].uq[r,m,i] (Gchbar)    (*+ sign from eps matrix*)

	- yl[n] vlbar[s,n].ProjP[s,r].l[r,n] (Gch)
	- yl[n] lbar[s,n].ProjP[s,r].l[r,n] (v+h+I G0)/Sqrt[2]
	],

	Module[{s,r,n,m,i},
	- yd[n] dqbar[s,n,i].ProjP[s,r].dq[r,n,i] (v+h)/Sqrt[2]
	- yu[n] uqbar[s,n,i].ProjP[s,r].uq[r,n,i] (v+h)/Sqrt[2]
	- yl[n] lbar[s,n].ProjP[s,r].l[r,n] (v+h)/Sqrt[2]
	]
	];

LYukawa := LYuk + HC[LYuk];

(*-----------------------*)
(*** Scalar lagrangian ***)
(*-----------------------*)

(* Usual higgs doublet *)
Phi0 := If[FeynmanGauge, {Gch, (v + h + I G0)/Sqrt[2]}, {0, (v + h)/Sqrt[2]}];
Phi0bar := If[FeynmanGauge, {Gchbar, (v + h - I G0)/Sqrt[2]}, {0, (v + h)/Sqrt[2]}];
(* Inert doublet *)
Phi1 := {(cC Hch1 -sC Hch2), ((cH H01 -sH H02) + I (cA A01 -sA A02))/Sqrt[2]};
Phi1bar := {(cC Hch1bar -sC Hch2bar), ((cH H01 -sH H02) - I (cA A01 -sA A02))/Sqrt[2]};
Phi2 := {(sC Hch1 +cC Hch2), ((sH H01 +cH H02) + I (sA A01 +cA A02))/Sqrt[2]};
Phi2bar := {(sC Hch1bar +cC Hch2bar), ((sH H01 +cH H02) - I (sA A01 +cA A02))/Sqrt[2]};

LScalar := Block[{PMVec, WVec, Dc, Dcbar, Vphi},

(* Vector of Pauli matrices *)
	PMVec = Table[PauliSigma[i], {i, 3}];
(* Vector of gauge bosons - gauge eigenstates *)
	Wvec[mu_] := {Wi[mu, 1], Wi[mu, 2], Wi[mu, 3]};

(* Covariant derivative, Y_Phi0 = 1 for both scalar doublets *)
	Dc[f_, mu_] := del[f, mu] - I ee/CW B[mu]/2 f - I 1/2 ee/SW (Wvec[mu].PMVec).f;
	Dcbar[f_, mu_] :=  HC[Dc[f, mu]];

(* Covariant derivative terms *)
	Lcov :=
	HC[Dc[Phi0, mu]].Dc[Phi0, mu] +
	HC[Dc[Phi1, mu]].Dc[Phi1, mu] +
	HC[Dc[Phi2, mu]].Dc[Phi2, mu];

(* Scalar potential *)
	Vscalar :=
	-muH2 Phi0bar.Phi0 + mu12 Phi1bar.Phi1 + mu22 Phi2bar.Phi2 + lamH/6 (Phi0bar.Phi0)^2 +
	lam1/6 (Phi1bar.Phi1)^2 + lam2/6 (Phi2bar.Phi2)^2 + w1 (Phi0bar.Phi0) (Phi1bar.Phi1) +
	w2 (Phi0bar.Phi0) (Phi2bar.Phi2) + r1 (Phi1bar.Phi1) (Phi2bar.Phi2) + r2 (Phi2bar.Phi1)  (Phi1bar.Phi2) + k1 (Phi0bar.Phi1) (Phi1bar.Phi0) + k2 (Phi0bar.Phi2) (Phi2bar.Phi0) +
	mu32 (Phi1bar.Phi2+Phi2bar.Phi1) + x1/2 ((Phi0bar.Phi1)^2 + (Phi1bar.Phi0)^2) +
	x2/2 ((Phi0bar.Phi2)^2 + (Phi2bar.Phi0)^2) + x3 ((Phi0bar.Phi1) (Phi0bar.Phi2) + (Phi1bar.Phi0) (Phi2bar.Phi0)) + x4 ((Phi1bar.Phi0) (Phi0bar.Phi2) + (Phi0bar.Phi1) (Phi2bar.Phi0)) ;

	Lcov - Vscalar];

(*----------------------*)
(*** Ghost lagrangian ***)
(*----------------------*)

(* First the ghost terms that can be derived through              *)
(* the BRST transformations of the gauge-fixing function G:       *)
(* - g * antighost * d_BRST G                                     *)

LGhost := If[FeynmanGauge,
	Block[{dBRSTG,LGhostG,dBRSTWi,LGhostWi,dBRSTB,LGhostB},

	dBRSTG[mu_,a_] := Module[{a2, a3}, del[ghG[a], mu] + gs f[a,a2,a3] G[mu,a2] ghG[a3]];
		LGhostG := - ghGbar[a].del[dBRSTG[mu,a],mu];

	dBRSTWi[mu_,i_] := Module[{i2, i3}, del[ghWi[i], mu] + ee/SW Eps[i,i2,i3] Wi[mu,i2] ghWi[i3] ];
		LGhostWi := - ghWibar[a].del[dBRSTWi[mu,a],mu];

	dBRSTB[mu_] := del[ghB, mu];
		LGhostB := - ghBbar.del[dBRSTB[mu],mu];

(* Now the part involving ghosts and scalars *)
(* Calculation following Peskin-Schroeder    *)

	LGhostphi :=
	-(-(ee^2*v^2*ghBbar . ghB)/(4*CW^2) + (ee^2*v^2*ghBbar . ghWi[3])/(4*CW*SW) -
	(ee^2*v^2*ghWibar[1] . ghWi[1])/(4*SW^2) -
	(ee^2*v^2*ghWibar[2] . ghWi[2])/(4*SW^2) +
	(ee^2*v^2*ghWibar[3] . ghB)/(4*CW*SW) -
	(ee^2*v^2*ghWibar[3] . ghWi[3])/(4*SW^2) +
	(v*((ee^2*h*ghBbar . ghB)/CW^2 +
	(ee*((ee*(Gch + Gchbar)*ghBbar . ghWi[1])/(Sqrt[2]*CW) -
	(I*ee*(-Gch + Gchbar)*ghBbar . ghWi[2])/(Sqrt[2]*CW) -
	(ee*h*ghBbar . ghWi[3])/CW +
	(ee*(Gch + Gchbar)*ghWibar[1] . ghB)/(Sqrt[2]*CW) +
	(ee*h*ghWibar[1] . ghWi[1])/SW + (ee*G0*ghWibar[1] . ghWi[2])/SW +
	(ee*(Gch + Gchbar)*ghWibar[1] . ghWi[3])/(Sqrt[2]*SW) -
	(I*ee*(-Gch + Gchbar)*ghWibar[2] . ghB)/(Sqrt[2]*CW) -
	(ee*G0*ghWibar[2] . ghWi[1])/SW +
	(ee*h*ghWibar[2] . ghWi[2])/SW -
	(I*ee*(-Gch + Gchbar)*ghWibar[2] . ghWi[3])/(Sqrt[2]*SW) -
	(ee*h*ghWibar[3] . ghB)/CW -
	(ee*(Gch + Gchbar)*ghWibar[3] . ghWi[1])/(Sqrt[2]*SW) +
	(I*ee*(-Gch + Gchbar)*ghWibar[3] . ghWi[2])/(Sqrt[2]*SW) +
	(ee*h*ghWibar[3] . ghWi[3])/SW))/SW))/4);

(* Total ghost Lagrangian *)
	LGhostG + LGhostWi + LGhostB + LGhostphi],

(* If in Unitary gauge, only write strong sector ghost Lagrangian, needed from CalcHEP *)
Block[{dBRSTG,LGhostG},

	dBRSTG[mu_,a_] := Module[{a2, a3}, del[ghG[a], mu] + gs f[a,a2,a3] G[mu,a2] ghG[a3]];
		LGhostG := - ghGbar[a].del[dBRSTG[mu,a],mu];
LGhostG]
];

(* We just want the CP-even operator, since we only have the SM Higgs. We also neglect photons. *)

MKin := I/2 NNbar.Ga[mu].del[NN, mu] - Mn NNbar.NN/2;

LYuN := Module[{s,r,i,k}, (h1r[i,k]-I h1i[i,k]) (((cH H01 -sH H02) + I (cA A01 -sA A02))/Sqrt[2] NNbar[s,k].ProjP[s,r].vl[r,i]-(cC Hch1 -sC Hch2) NNbar[s,k].ProjP[s,r].l[r,i]) +
(h2r[i,k]-I h2i[i,k]) (((sH H01 +cH H02) + I (sA A01 +cA A02))/Sqrt[2] NNbar[s,k].ProjP[s,r].vl[r,i]-(sC Hch1 +cC Hch2) NNbar[s,k].ProjP[s,r].l[r,i])  ];

LYukawaN := MKin + LYuN + HC[LYuN];

(*------------------*)
(* Total lagrangian *)
(*------------------*)

L2IDM3N := ExpandIndices[LGauge + LFermions + LYukawa + LScalar + LGhost + LYukawaN, FlavorExpand->SU2W];
