(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     19040,        553]
NotebookOptionsPosition[     15640,        436]
NotebookOutlinePosition[     16020,        453]
CellTagsIndexPosition[     15977,        450]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"$FeynRulesPath", "=", 
  RowBox[{"SetDirectory", "[", "\"\<< path >\>\"", "]"}]}]], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
  3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
  3.4234163227881193`*^9}, {3.4499828019723682`*^9, 3.449982827416329*^9}, {
  3.449995896987596*^9, 3.44999590156848*^9}, {3.453787194669977*^9, 
  3.4537871987493134`*^9}}],

Cell[BoxData[
 RowBox[{"<<", "FeynRules`"}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"<", " ", 
    RowBox[{"model", " ", "path"}], " ", ">"}], "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.419073170860696*^9, 3.419073182827229*^9}, {
  3.449995977371011*^9, 3.449995977737762*^9}, {3.449996062058289*^9, 
  3.449996073803035*^9}, {3.45378721864566*^9, 3.453787221979855*^9}}],

Cell[CellGroupData[{

Cell["The generic Two Higgs Doublet model", "Title",
 CellChangeTimes->{{3.453787246659294*^9, 3.453787254056096*^9}}],

Cell["We first load in the model-file", "Text",
 CellChangeTimes->{{3.4537872570726023`*^9, 3.4537872575282097`*^9}}],

Cell[BoxData[
 RowBox[{"LoadModel", "[", "\"\<2HDM.fr\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.4022069973481913`*^9, 3.402207011768662*^9}, 
   3.4022081212072697`*^9, {3.402208250379383*^9, 3.402208254043104*^9}, 
   3.4027466057480917`*^9, {3.403240270135737*^9, 3.403240277228945*^9}, 
   3.403266503388291*^9, {3.403267649630335*^9, 3.40326765417397*^9}, {
   3.403269919787421*^9, 3.403269921965273*^9}, {3.403347551273425*^9, 
   3.403347555049163*^9}, 3.4044490490588417`*^9, {3.411744339876704*^9, 
   3.411744340012457*^9}, {3.4121886924550533`*^9, 3.412188699157571*^9}, 
   3.412188808811866*^9, 3.4121888580521603`*^9, {3.412450464077868*^9, 
   3.412450464378695*^9}, {3.413715097460478*^9, 3.41371509757642*^9}, {
   3.41440825334604*^9, 3.414408254159686*^9}, {3.41862573831756*^9, 
   3.4186257392223186`*^9}, {3.4190731862389174`*^9, 3.419073187003003*^9}, {
   3.419073336802393*^9, 3.4190733374513063`*^9}, {3.4190828041801767`*^9, 
   3.4190828048079023`*^9}, {3.449996078731757*^9, 3.449996080402082*^9}}],

Cell[BoxData[
 RowBox[{"LoadRestriction", "[", "\"\<HiggsBasis.rst\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.45378777192177*^9, 3.45378778546101*^9}}],

Cell["We can now read in the param_card", "Text",
 CellChangeTimes->{{3.454001066602683*^9, 3.454001072540792*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"ReadLHAFile", "[", 
   RowBox[{"Input", "\[Rule]", "\"\<param_card_FR.dat\>\""}], "]"}], 
  ";"}]], "Input",
 CellChangeTimes->{{3.454001077554552*^9, 3.454001091308895*^9}}],

Cell[CellGroupData[{

Cell["The Lagrangian", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, 
   3.4537872736095467`*^9}],

Cell["\<\
The full Lagrangian in unitary gauge can be accessed immediatly via\
\>", "Text",
 CellChangeTimes->{{3.411910016771447*^9, 3.411910062087528*^9}, {
  3.411910094087652*^9, 3.411910096590087*^9}, {3.411910215381351*^9, 
  3.4119102162371798`*^9}, {3.453787355523837*^9, 3.4537873558028727`*^9}}],

Cell[BoxData["L2HDM"], "Input",
 CellChangeTimes->{{3.411910106011015*^9, 3.411910106351081*^9}, {
  3.4537873576279984`*^9, 3.453787359226983*^9}}],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}}],

Cell["\<\
The part of the lagrangian representing the gauge sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}}],

Cell[BoxData["LGauge"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Scalar sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910274288354*^9, 3.41191027703699*^9}}],

Cell["\<\
The part of the lagrangian representing the scalar sector can be accessed via\
\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.41191028690167*^9, 
  3.411910287709094*^9}}],

Cell[BoxData["LHiggs"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910290186841*^9, 3.411910292005392*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Fermion sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.4119103528868923`*^9, 3.411910357404933*^9}}],

Cell["\<\
The part of the lagrangian representing the fermion sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.4119103873434134`*^9, 
  3.411910388077118*^9}}],

Cell[BoxData["LFermions"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.411910379677638*^9, 3.4119103807255*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}}],

Cell["\<\
The part of the lagrangian representing the Yukawa sector can be accessed via\
\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.411910399061659*^9, 
  3.411910400421185*^9}}],

Cell[BoxData["LYukawa"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.4119104032372026`*^9, 3.411910404165523*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Feynman Gauge", "Subsection",
 CellChangeTimes->{{3.411910080775518*^9, 3.41191008414785*^9}, {
  3.411910431304595*^9, 3.41191043361451*^9}}],

Cell["\<\
By default, SM lagrangian is loaded in unitary gauge. However, Feynman gauge \
for the QCD sector (required for CalcHep for example) can be obtained via \
\>", "Text",
 CellChangeTimes->{{3.411910440565042*^9, 3.411910480762147*^9}, {
  3.4537873808489027`*^9, 3.453787415736421*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input",
 CellChangeTimes->{{3.411910487433539*^9, 3.4119104927114267`*^9}}],

Cell["\<\
The full lagrangian in Feynman gauge can be accessed immediatly via\
\>", "Text",
 CellChangeTimes->{{3.411910016771447*^9, 3.411910062087528*^9}, {
  3.411910094087652*^9, 3.411910096590087*^9}, {3.411910215381351*^9, 
  3.4119102162371798`*^9}, {3.411910436148773*^9, 3.411910437013105*^9}}],

Cell[BoxData["L2HDM"], "Input",
 CellChangeTimes->{{3.411910106011015*^9, 3.411910106351081*^9}, {
  3.4537873968568993`*^9, 3.453787398534165*^9}}],

Cell[CellGroupData[{

Cell["Ghost sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}, {3.4119106057673063`*^9, 
  3.411910606397141*^9}}],

Cell["\<\
The part of the lagrangian representing the ghost sector can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.4119101255458603`*^9, 3.411910192225008*^9}, {
  3.411910235813308*^9, 3.4119102509651337`*^9}, {3.411910399061659*^9, 
  3.411910400421185*^9}, {3.4119106110136833`*^9, 3.411910611661195*^9}}],

Cell[BoxData["LGhost"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
  3.4119104032372026`*^9, 3.411910404165523*^9}, {3.411910615100849*^9, 
  3.411910615781582*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Checking the Lagrangian", "Section",
 CellChangeTimes->{{3.4234156496121893`*^9, 3.423415657027569*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input",
 CellChangeTimes->{{3.4234159280429783`*^9, 3.423415934798614*^9}}],

Cell[CellGroupData[{

Cell["Checking hermiticity", "Subsection",
 CellChangeTimes->{{3.4234156831783743`*^9, 3.423415689540821*^9}}],

Cell["The hermiticity of the Lagrangian can be checked via", "Text",
 CellChangeTimes->{{3.423415694323595*^9, 3.423415707867804*^9}}],

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", 
  RowBox[{"L2HDM", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.414763473002973*^9, 3.4147634845507174`*^9}, {
  3.453787432047991*^9, 3.453787433215515*^9}}],

Cell["\<\
The same command can be applied to the flavor - expanded Lagrangian\
\>", "Text",
 CellChangeTimes->{{3.423415721582508*^9, 3.423415739787958*^9}}],

Cell[BoxData[
 RowBox[{"CheckHermiticity", "[", 
  RowBox[{"L2HDM", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.414763604111637*^9, 3.4147636044973803`*^9}, {
  3.453787441615571*^9, 3.453787442614904*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculation of the Feynman rules", "Section",
 CellChangeTimes->{{3.411910637332127*^9, 3.41191064360071*^9}}],

Cell["\<\
We will calculate now explicitly the Feynman rules for the 2HDM.\
\>", "Text",
 CellChangeTimes->{{3.41191064804084*^9, 3.411910672936666*^9}, {
  3.453787483596156*^9, 3.453787484219084*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "False"}], ";"}]], "Input",
 CellChangeTimes->{{3.411910674121689*^9, 3.4119106799564953`*^9}, {
  3.4537874894123993`*^9, 3.453787489939929*^9}}],

Cell[CellGroupData[{

Cell["Gauge sector", "Subsection",
 CellChangeTimes->{{3.411910690443768*^9, 3.411910692233274*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsGauge", "=", 
   RowBox[{"FeynmanRules", "[", 
    RowBox[{"LGauge", ",", 
     RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.40274690437012*^9, {3.402746954727231*^9, 3.4027469691642714`*^9}, {
   3.4032592998045692`*^9, 3.403259304564069*^9}, 3.403267976055098*^9, {
   3.411910705212987*^9, 3.411910705553741*^9}, {3.423415993272615*^9, 
   3.42341600147605*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Higgs Sector", "Subsection",
 CellChangeTimes->{3.404470070069872*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsHiggs", "=", 
   RowBox[{"FeynmanRules", "[", "LHiggs", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.411910728609757*^9, 3.41191072908109*^9}, {
   3.423416009086747*^9, 3.423416012982971*^9}, 3.423416065626593*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Matter sector", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsFermions", "=", 
   RowBox[{"FeynmanRules", "[", "LFermions", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.402205118991502*^9, 3.4022051228508387`*^9}, 
   3.402747846432675*^9, {3.4032613449872217`*^9, 3.403261349245253*^9}, {
   3.403266977133403*^9, 3.4032669793125563`*^9}, {3.411910788644576*^9, 
   3.411910789233307*^9}, {3.423416034294303*^9, 3.423416042739814*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Yukawa sector", "Subsection"],

Cell[BoxData[
 RowBox[{
  RowBox[{"vertsYukawa", "=", 
   RowBox[{"FeynmanRules", "[", "LYukawa", "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.403266987858165*^9, 3.4032670026080303`*^9}, {
  3.411910826105542*^9, 3.411910826777452*^9}, {3.423416089772278*^9, 
  3.423416095643961*^9}, {3.453787609095393*^9, 3.4537876092341127`*^9}}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Outputs and interfaces", "Section",
 CellChangeTimes->{
  3.411910944409371*^9, {3.412185514054689*^9, 3.412185517014236*^9}}],

Cell[CellGroupData[{

Cell["FeynArts output", "Subsection",
 CellChangeTimes->{{3.411911000132907*^9, 3.411911005135379*^9}}],

Cell["The FeynArts output for the 2HDM can be obtained via", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911062212926*^9, 3.4119110634765463`*^9}, {3.453787639896587*^9, 
  3.4537876423355713`*^9}}],

Cell[BoxData[
 RowBox[{"WriteFeynArtsOutput", "[", 
  RowBox[{"LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", 
   RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]], "Input",
 CellChangeTimes->{{3.411911018354619*^9, 3.4119110196967573`*^9}, {
   3.412185470680571*^9, 3.412185480912915*^9}, {3.41245048911446*^9, 
   3.4124504892674522`*^9}, 3.414315634453483*^9, {3.423416180751266*^9, 
   3.423416182892613*^9}, 3.453787647041366*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["Sherpa output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}}],

Cell["The Sherpa output for the 2HDM can be obtained via", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911059590749*^9, 3.4119110601885567`*^9}, {3.453787690392329*^9, 
  3.4537876910312977`*^9}}],

Cell[BoxData[
 RowBox[{"WriteSHOutput", "[", 
  RowBox[{"LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
   3.412185455856553*^9, 3.412185456628922*^9}, {3.4143156544792233`*^9, 
   3.414315668290971*^9}, {3.423416222700699*^9, 3.423416235756197*^9}, 
   3.453787694328566*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["MadGraph output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911131666554*^9, 3.411911135984398*^9}}],

Cell["The MadGraph output for the 2HDM can be obtained via", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911059590749*^9, 3.4119110601885567`*^9}, {3.41191113897644*^9, 
  3.411911142024486*^9}, {3.45378770643867*^9, 3.453787706966777*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"WriteMGOutput", "[", 
   RowBox[{"LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa"}], "]"}],
   ";"}]], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
   3.412185409690489*^9, 3.4121854352800217`*^9}, 3.453787697192544*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell["CalcHep output", "Subsection",
 CellChangeTimes->{{3.4119110460271273`*^9, 3.411911049405038*^9}, {
  3.411911150323291*^9, 3.4119111515122623`*^9}}],

Cell["\<\
The CalcHep output for the 2HDM can be obtained via (Note that the QCD ghosts \
are required in CalcHep!)\
\>", "Text",
 CellChangeTimes->{{3.411910955110715*^9, 3.4119109690877657`*^9}, {
  3.411911059590749*^9, 3.4119110601885567`*^9}, {3.4119111540967712`*^9, 
  3.411911155096376*^9}, {3.4537877038388042`*^9, 3.45378773221243*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"FeynmanGauge", "=", "True"}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"WriteCHOutput", "[", 
   RowBox[{
   "LGauge", ",", "LHiggs", ",", "LFermions", ",", "LYukawa", ",", "LGhost", 
    ",", 
    RowBox[{"MaxExpressionLength", "\[Rule]", "800"}]}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.4119110943383636`*^9, 3.41191110054212*^9}, {
   3.412185398898693*^9, 3.412185419919883*^9}, {3.414315699020526*^9, 
   3.41431570701153*^9}, 3.414315777726746*^9, {3.414316480328691*^9, 
   3.414316491307609*^9}, {3.4143165302100153`*^9, 3.414316531719597*^9}, 
   3.423416262588552*^9, {3.453787700872117*^9, 3.453787701240477*^9}, {
   3.45378773578975*^9, 3.453787756740387*^9}, {3.453788657465733*^9, 
   3.4537886587121067`*^9}, {3.453788732026514*^9, 3.453788732305941*^9}}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1280, 692},
WindowMargins->{{0, Automatic}, {0, Automatic}},
ShowSelection->True,
Magnification->1.5,
FrontEndVersion->"7.0 for Mac OS X x86 (32-bit) (November 10, 2008)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[545, 20, 430, 7, 40, "Input"],
Cell[978, 29, 54, 1, 40, "Input"],
Cell[1035, 32, 358, 7, 40, "Input"],
Cell[CellGroupData[{
Cell[1418, 43, 118, 1, 114, "Title"],
Cell[1539, 46, 117, 1, 39, "Text"],
Cell[1659, 49, 1030, 14, 40, "Input"],
Cell[2692, 65, 153, 2, 40, "Input"],
Cell[2848, 69, 115, 1, 39, "Text"],
Cell[2966, 72, 209, 5, 42, "Input"],
Cell[CellGroupData[{
Cell[3200, 81, 127, 2, 100, "Section"],
Cell[3330, 85, 305, 5, 39, "Text"],
Cell[3638, 92, 148, 2, 40, "Input"],
Cell[CellGroupData[{
Cell[3811, 98, 105, 1, 36, "Subsubsection"],
Cell[3919, 101, 219, 4, 39, "Text"],
Cell[4141, 107, 98, 1, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4276, 113, 154, 2, 36, "Subsubsection"],
Cell[4433, 117, 270, 6, 39, "Text"],
Cell[4706, 125, 147, 2, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4890, 132, 158, 2, 36, "Subsubsection"],
Cell[5051, 136, 272, 5, 39, "Text"],
Cell[5326, 143, 148, 2, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[5511, 150, 155, 2, 36, "Subsubsection"],
Cell[5669, 154, 271, 6, 39, "Text"],
Cell[5943, 162, 150, 2, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[6130, 169, 148, 2, 51, "Subsection"],
Cell[6281, 173, 294, 5, 62, "Text"],
Cell[6578, 180, 149, 3, 40, "Input"],
Cell[6730, 185, 303, 5, 39, "Text"],
Cell[7036, 192, 148, 2, 40, "Input"],
Cell[CellGroupData[{
Cell[7209, 198, 205, 3, 36, "Subsubsection"],
Cell[7417, 203, 316, 5, 39, "Text"],
Cell[7736, 210, 198, 3, 40, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[7995, 220, 110, 1, 100, "Section"],
Cell[8108, 223, 149, 3, 40, "Input"],
Cell[CellGroupData[{
Cell[8282, 230, 110, 1, 51, "Subsection"],
Cell[8395, 233, 134, 1, 39, "Text"],
Cell[8532, 236, 257, 5, 40, "Input"],
Cell[8792, 243, 157, 3, 39, "Text"],
Cell[8952, 248, 257, 5, 40, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9258, 259, 116, 1, 100, "Section"],
Cell[9377, 262, 202, 4, 39, "Text"],
Cell[9582, 268, 201, 4, 40, "Input"],
Cell[CellGroupData[{
Cell[9808, 276, 100, 1, 51, "Subsection"],
Cell[9911, 279, 457, 10, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10405, 294, 76, 1, 51, "Subsection"],
Cell[10484, 297, 258, 5, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[10779, 307, 35, 0, 51, "Subsection"],
Cell[10817, 309, 417, 7, 40, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[11271, 321, 35, 0, 51, "Subsection"],
Cell[11309, 323, 337, 6, 40, "Input"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[11695, 335, 132, 2, 225, "Section"],
Cell[CellGroupData[{
Cell[11852, 341, 103, 1, 114, "Subsection"],
Cell[11958, 344, 238, 3, 87, "Text"],
Cell[12199, 349, 456, 7, 90, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[12692, 361, 103, 1, 114, "Subsection"],
Cell[12798, 364, 236, 3, 87, "Text"],
Cell[13037, 369, 377, 7, 90, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[13451, 381, 154, 2, 114, "Subsection"],
Cell[13608, 385, 280, 3, 87, "Text"],
Cell[13891, 390, 296, 6, 90, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[14224, 401, 155, 2, 114, "Subsection"],
Cell[14382, 405, 346, 6, 87, "Text"],
Cell[14731, 413, 869, 18, 195, "Input"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

(* End of internal cache information *)
