

(*****************************************************************************************)

(* SM Lagrangian *)

(******************** Gauge F^2 Lagrangian terms*************************)
(*Sign convention from Lagrangian in between Eq. (A.9) and Eq. (A.10) of Peskin & Schroeder.*)
 LGauge = -1/4 (del[Wi[nu, i1], mu] - del[Wi[mu, i1], nu] + gw Eps[i1, i2, i3] Wi[mu, i2] Wi[nu, i3])*
 					(del[Wi[nu, i1], mu] - del[Wi[mu, i1], nu] + gw Eps[i1, i4, i5] Wi[mu, i4] Wi[nu, i5]) -
	
	1/4 (del[B[nu], mu] - del[B[mu], nu])^2 -
	
	1/4 (del[G[nu, a1], mu] - del[G[mu, a1], nu] + gs f[a1, a2, a3] G[mu, a2] G[nu, a3])*
 		 (del[G[nu, a1], mu] - del[G[mu, a1], nu] + gs f[a1, a4, a5] G[mu, a4] G[nu, a5]);


(********************* Fermion Lagrangian terms*************************)
(*Sign convention from Lagrangian in between Eq. (A.9) and Eq. (A.10) of Peskin & Schroeder.*)
 LFermions = Module[{Lkin, LQCD, LEWleft, LEWright},

    Lkin = I uqbar.Ga[mu].del[uq, mu] + 
    	I dqbar.Ga[mu].del[dq, mu] + 
    	I lbar.Ga[mu].del[l, mu] + 
    	I vlbar.Ga[mu].del[vl, mu];

    LQCD = gs (uqbar.Ga[mu].T[a].uq + 
    	dqbar.Ga[mu].T[a].dq)G[mu, a];

    LBright = 
     -2ee/cw B[mu]/2 lbar.Ga[mu].ProjP.l +           (*Y_lR=-2*)
    	4ee/3/cw B[mu]/2 uqbar.Ga[mu].ProjP.uq -       (*Y_uR=4/3*)
    	2ee/3/cw B[mu]/2 dqbar.Ga[mu].ProjP.dq;        (*Y_dR=-2/3*)

    LBleft = 
     -ee/cw B[mu]/2 vlbar.Ga[mu].ProjM.vl -          (*Y_LL=-1*)
    	ee/cw B[mu]/2 lbar.Ga[mu].ProjM.l  +           (*Y_LL=-1*)
    	ee/3/cw B[mu]/2 uqbar.Ga[mu].ProjM.uq +        (*Y_QL=1/3*)
    	ee/3/cw B[mu]/2 dqbar.Ga[mu].ProjM.dq ;        (*Y_QL=1/3*)
	
	LWleft = ee/sw/2(
	   vlbar.Ga[mu].ProjM.vl Wi[mu, 3] -              (*sigma3 = ( 1   0 )*)
    	lbar.Ga[mu].ProjM.l Wi[mu, 3] +                (*         ( 0  -1 )*)
    	
    	Sqrt[2] vlbar.Ga[mu].ProjM.l W[mu] +
    	Sqrt[2] lbar.Ga[mu].ProjM.vl Wbar[mu]+
    	
    	uqbar.Ga[mu].ProjM.uq Wi[mu, 3] -              (*sigma3 = ( 1   0 )*)
    	dqbar.Ga[mu].ProjM.dq Wi[mu, 3] +              (*         ( 0  -1 )*)
    	
    	Sqrt[2] uqbar.Ga[mu].ProjM.CKM.dq W[mu] +
    	Sqrt[2] dqbar.Ga[mu].ProjM.HC[CKM].uq Wbar[mu]
    	);

    Lkin + LQCD + LBright + LBleft + LWleft];
    



(**************Ghost terms**************************)
(* Now we need the ghost terms which are of the form:             *)
(* - g * antighost * d_BRST G                                     *)
(* where d_BRST G is BRST transform of the gauge fixing function. *)

LGhost := If[FeynmanGauge, 
		Block[{dBRSTG,LGhostG,dBRSTWi,LGhostWi,dBRSTB,LGhostB},
		
	(***********First the pure gauge piece.**********************) 	
	dBRSTG[mu_,a_] := 1/gs Module[{a2, a3}, del[ghG[a], mu] + gs f[a,a2,a3] G[mu,a2] ghG[a3]];
		LGhostG := - gs ghGbar[a].del[dBRSTG[mu,a],mu];
 	
	dBRSTWi[mu_,i_] := sw/ee Module[{i2, i3}, del[ghWi[i], mu] + ee/sw Eps[i,i2,i3] Wi[mu,i2] ghWi[i3] ];
		LGhostWi := - ee/sw ghWibar[a].del[dBRSTWi[mu,a],mu];	
 	
	dBRSTB[mu_] := cw/ee del[ghB, mu];
		LGhostB := - ee/cw ghBbar.del[dBRSTB[mu],mu];
	
	(***********Next the piece from the scalar field.************)

        (* To be added *)
		 	
	(***********Now add the pieces together.********************)
	LGhostG (* + LGhostWi + LGhostB*)]

, 0];


	


P1 = {\[Phi]1P, \[Phi]10};
P2 = {\[Phi]2P, \[Phi]20};

P1bar = HC[P1];
P2bar = HC[P2];

P11 = HC[P1].P1;
P12 = HC[P1].P2;
P21 = HC[P2].P1;
P22 = HC[P2].P2;

 

    
 LHiggsKin := Block[{PMVec, WVec, Dc, Dcbar},
    
    PMVec = Table[PauliSigma[i], {i, 3}];   
    Wvec[mu_] := {Wi[mu, 1], Wi[mu, 2], Wi[mu, 3]};

	(*Y_phi=1*)
    Dc[f_, mu_] := I del[f, mu] + ee/cw B[mu]/2 f + ee/sw/2 (Wvec[mu].PMVec).f;
    Dcbar[f_, mu_] := -I del[f, mu] + ee/cw B[mu]/2 f + ee/sw/2 f.(Wvec[mu].PMVec);

    (Dcbar[P1bar, mu]).Dc[P1, mu] + (Dcbar[P2bar, mu]).Dc[P2, mu]];

V2HDM := mu1 P11 +mu2 P2s2 -mu3 P12 -Conjugate[mu3]^2 P21 + 
    \[Lambda]1 P11^2 + \[Lambda]2 P22^2 + \[Lambda]3 P11 P22 +
    \[Lambda]4 P12 P21 + \[Lambda]5 (P12^2 + P21^2) + 
     P11 (\[Lambda]6 P12+ Conjugate[\[Lambda]6] P21) +  P22 (\[Lambda]7 P12+ Conjugate[\[Lambda]7]P21);

LHiggs := LHiggsKin - V2HDM;


LYukUR := -Sqrt[2]/v (\[Phi]10bar uqbar.DU.ProjP.uq - 
          \[Phi]2Pbar dqbar.GU.ProjP.uq +
          \[Phi]20bar uqbar.GU.ProjP.uq);

LYukU := LYukUR + HC[LYukUR];

LYukDR := -Sqrt[2]/v (\[Phi]10 dqbar.DD.ProjP.dq + 
          \[Phi]2P uqbar.GD.ProjP.dq +
          \[Phi]20 dqbar.GD.ProjP.dq);

LYukD := LYukDR + HC[LYukDR];

LYukLR := -Sqrt[2]/v (\[Phi]10 lbar.DL.ProjP.l + 
          \[Phi]2P vlbar.GL.ProjP.l +
          \[Phi]20 lbar.GL.ProjP.l);

LYukL := LYukLR + HC[LYukLR];

LYukawa := LYukU + LYukD + LYukL;
		
		
L2HDM := LGauge + LFermions + LHiggs + LYukawa + LGhost;
