(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 12.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    115841,       3443]
NotebookOptionsPosition[    109979,       3332]
NotebookOutlinePosition[    110338,       3348]
CellTagsIndexPosition[    110295,       3345]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["The 2 Gravitons coupled to Standard Model", "Title",
 CellChangeTimes->{{3.405054966614888*^9, 3.4050549767315893`*^9}, 
   3.4529230123333807`*^9, {3.45405649584802*^9, 3.4540564997867126`*^9}, {
   3.4540565705776033`*^9, 3.454056571055434*^9}, {3.454057181466007*^9, 
   3.454057182797702*^9}, {3.846585206929676*^9, 
   3.846585224973124*^9}},ExpressionUUID->"0c7d382c-2c43-4a74-a4b0-\
6b33b7b494db"],

Cell[CellGroupData[{

Cell["Load of the FeynRules package", "Section",
 CellChangeTimes->{{3.452856941348258*^9, 
  3.452856954182706*^9}},ExpressionUUID->"a39a0740-0c79-41c6-87fc-\
51f5ba05af02"],

Cell[BoxData[
 RowBox[{"Quit", "[", "]"}]], "Input",
 CellChangeTimes->{{3.4521543016025457`*^9, 
  3.452154302750087*^9}},ExpressionUUID->"b8c26645-927c-4e00-ae82-\
8dce9c9ad8f2"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"$FeynRulesPath", "=", 
   RowBox[{"SetDirectory", "[", "\"\<<address of the package>\>\"", "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{"<<", "FeynRules`"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"SetDirectory", "[", 
   RowBox[{"$FeynRulesPath", "<>", "\"\</Models/2GravitonsSM\>\""}], "]"}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.41265862251538*^9, 3.412658649947229*^9}, {
   3.423415585782702*^9, 3.423415597189939*^9}, {3.4234163173467493`*^9, 
   3.4234163227881193`*^9}, {3.453613499780509*^9, 3.453613524557995*^9}, {
   3.454050520543564*^9, 3.454050533398179*^9}, {3.454056582682654*^9, 
   3.4540565840807753`*^9}, {3.454061008970613*^9, 3.4540610300313797`*^9}, 
   3.4540621439628963`*^9, {3.846585304596931*^9, 3.846585315491149*^9}},
 CellLabel->"In[1]:=",ExpressionUUID->"17ecac41-11e8-41a2-bb8f-8286be4e30fa"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Load of the full 2GravitonsSM model", "Section",
 CellChangeTimes->{{3.452856959806845*^9, 3.452856965627877*^9}, {
   3.454050557859632*^9, 3.454050559388439*^9}, {3.454062198742198*^9, 
   3.454062202491016*^9}, 
   3.846587138869749*^9},ExpressionUUID->"5b4bbec4-1119-4816-a391-\
9dbf12789517"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"LoadModel", "[", "\"\<2GravitonsSM.fr\>\"", "]"}]], "Input",
 CellChangeTimes->{{3.402749737680746*^9, 3.4027497378335543`*^9}, 
   3.405009528824724*^9, 3.449909327040394*^9, 3.452152811321804*^9, 
   3.4529230123338823`*^9, 3.45405650276263*^9, 
   3.8465853223685093`*^9},ExpressionUUID->"90eb63cf-3355-434a-930e-\
55afdafb9e3d"],

Cell[CellGroupData[{

Cell[BoxData[
 FormBox["\<\"This model implementation was created by\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.845608291397253*^9, {3.8456085064145393`*^9, 3.845608534285594*^9}, 
   3.8457655448749228`*^9, 3.8457827150940437`*^9, 3.845785557594512*^9, 
   3.845788891008789*^9, 3.845849231608396*^9, {3.846586255067142*^9, 
   3.846586280188559*^9}, 3.846586408136796*^9, 3.846586684338305*^9, 
   3.846586825293819*^9, 3.846587001597612*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"1d2ad7a4-41fc-4184-8f60-69b803fdc27c"],

Cell[BoxData[
 FormBox["\<\"Tran Quang Loc\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.845608291397253*^9, {3.8456085064145393`*^9, 3.845608534285594*^9}, 
   3.8457655448749228`*^9, 3.8457827150940437`*^9, 3.845785557594512*^9, 
   3.845788891008789*^9, 3.845849231608396*^9, {3.846586255067142*^9, 
   3.846586280188559*^9}, 3.846586408136796*^9, 3.846586684338305*^9, 
   3.846586825293819*^9, 3.846587001663806*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"85e92282-e1fc-4fb8-96fa-0b5abbeb1ef0"],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"Model Version: \"\>", "\[InvisibleSpace]", "\<\"1.0.0\"\>"}],
   SequenceForm["Model Version: ", "1.0.0"],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.845608291397253*^9, {3.8456085064145393`*^9, 3.845608534285594*^9}, 
   3.8457655448749228`*^9, 3.8457827150940437`*^9, 3.845785557594512*^9, 
   3.845788891008789*^9, 3.845849231608396*^9, {3.846586255067142*^9, 
   3.846586280188559*^9}, 3.846586408136796*^9, 3.846586684338305*^9, 
   3.846586825293819*^9, 3.846587001725778*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"0194ce7d-a119-4ac0-b7d5-6e46cc6809fb"],

Cell[BoxData[
 FormBox["\<\"https://feynrules.irmp.ucl.ac.be/wiki/2GravitonsSM\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.845608291397253*^9, {3.8456085064145393`*^9, 3.845608534285594*^9}, 
   3.8457655448749228`*^9, 3.8457827150940437`*^9, 3.845785557594512*^9, 
   3.845788891008789*^9, 3.845849231608396*^9, {3.846586255067142*^9, 
   3.846586280188559*^9}, 3.846586408136796*^9, 3.846586684338305*^9, 
   3.846586825293819*^9, 3.846587001784381*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"32beafcd-a690-41e1-8438-0f37fa115909"],

Cell[BoxData[
 FormBox["\<\"For more information, type ModelInformation[].\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.845608291397253*^9, {3.8456085064145393`*^9, 3.845608534285594*^9}, 
   3.8457655448749228`*^9, 3.8457827150940437`*^9, 3.845785557594512*^9, 
   3.845788891008789*^9, 3.845849231608396*^9, {3.846586255067142*^9, 
   3.846586280188559*^9}, 3.846586408136796*^9, 3.846586684338305*^9, 
   3.846586825293819*^9, 3.846587001843349*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"c00742c0-5c06-443a-bc15-2b63f78053e7"],

Cell[BoxData[
 FormBox["\<\"\"\>", TraditionalForm]], "Print",
 CellChangeTimes->{
  3.845608291397253*^9, {3.8456085064145393`*^9, 3.845608534285594*^9}, 
   3.8457655448749228`*^9, 3.8457827150940437`*^9, 3.845785557594512*^9, 
   3.845788891008789*^9, 3.845849231608396*^9, {3.846586255067142*^9, 
   3.846586280188559*^9}, 3.846586408136796*^9, 3.846586684338305*^9, 
   3.846586825293819*^9, 3.846587001890704*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"74101b3c-5e42-45c1-ae04-420f8f845b26"],

Cell[BoxData[
 FormBox["\<\"   - Loading particle classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{
  3.845608291397253*^9, {3.8456085064145393`*^9, 3.845608534285594*^9}, 
   3.8457655448749228`*^9, 3.8457827150940437`*^9, 3.845785557594512*^9, 
   3.845788891008789*^9, 3.845849231608396*^9, {3.846586255067142*^9, 
   3.846586280188559*^9}, 3.846586408136796*^9, 3.846586684338305*^9, 
   3.846586825293819*^9, 3.846587001952841*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"29c1d312-5bd8-455a-9233-5dda7eaf6dfb"],

Cell[BoxData[
 FormBox["\<\"   - Loading gauge group classes.\"\>", 
  TraditionalForm]], "Print",
 CellChangeTimes->{
  3.845608291397253*^9, {3.8456085064145393`*^9, 3.845608534285594*^9}, 
   3.8457655448749228`*^9, 3.8457827150940437`*^9, 3.845785557594512*^9, 
   3.845788891008789*^9, 3.845849231608396*^9, {3.846586255067142*^9, 
   3.846586280188559*^9}, 3.846586408136796*^9, 3.846586684338305*^9, 
   3.846586825293819*^9, 3.846587002014564*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"16353bb5-aaac-4ebc-9648-c57638500838"],

Cell[BoxData[
 FormBox["\<\"   - Loading parameter classes.\"\>", TraditionalForm]], "Print",\

 CellChangeTimes->{
  3.845608291397253*^9, {3.8456085064145393`*^9, 3.845608534285594*^9}, 
   3.8457655448749228`*^9, 3.8457827150940437`*^9, 3.845785557594512*^9, 
   3.845788891008789*^9, 3.845849231608396*^9, {3.846586255067142*^9, 
   3.846586280188559*^9}, 3.846586408136796*^9, 3.846586684338305*^9, 
   3.846586825293819*^9, 3.84658700209111*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"87bc4951-f092-4380-a792-f0b06a032c97"],

Cell[BoxData[
 FormBox[
  InterpretationBox[
   RowBox[{"\<\"\\nModel \"\>", 
    "\[InvisibleSpace]", "\<\"2 Gravitons coupled to Standard Model\"\>", 
    "\[InvisibleSpace]", "\<\" loaded.\"\>"}],
   SequenceForm[
   "\nModel ", "2 Gravitons coupled to Standard Model", " loaded."],
   Editable->False], TraditionalForm]], "Print",
 CellChangeTimes->{
  3.845608291397253*^9, {3.8456085064145393`*^9, 3.845608534285594*^9}, 
   3.8457655448749228`*^9, 3.8457827150940437`*^9, 3.845785557594512*^9, 
   3.845788891008789*^9, 3.845849231608396*^9, {3.846586255067142*^9, 
   3.846586280188559*^9}, 3.846586408136796*^9, 3.846586684338305*^9, 
   3.846586825293819*^9, 3.846587002140764*^9},
 CellLabel->
  "During evaluation of \
In[4]:=",ExpressionUUID->"2886e799-79a0-4cdb-ab75-e372b9e3bccd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The full 2GravitonsSM lagrangian", "Section",
 CellChangeTimes->{{3.411910065227421*^9, 3.411910071535137*^9}, {
   3.4540507294896593`*^9, 3.4540507310208197`*^9}, {3.4540567139322166`*^9, 
   3.454056718777896*^9}, 
   3.846587141162957*^9},ExpressionUUID->"8f8f6385-04c2-4ae6-9586-\
bfd6425af08f"],

Cell["\<\
The part of the lagrangian representing the up-to-two Gravitons coupled to \
each sector of SM can be accessed via\
\>", "Text",
 CellChangeTimes->{{3.846588269106967*^9, 3.846588269111033*^9}, {
  3.8465883047485123`*^9, 3.846588313094907*^9}, {3.84658845413844*^9, 
  3.8465884621293497`*^9}, {3.846588980750147*^9, 
  3.8465889855300207`*^9}},ExpressionUUID->"69aa44e3-ef8c-40a0-b1c4-\
290aa6d62baa"],

Cell[CellGroupData[{

Cell["Gravitons + Gauge sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
   3.454057138248085*^9, 3.454057139479412*^9}, {3.846587158423683*^9, 
   3.846587192203702*^9}, 3.846587223843741*^9, {3.8465881291606007`*^9, 
   3.846588143125564*^9}},ExpressionUUID->"e31e7898-918c-4686-8343-\
b7f9fed381c3"],

Cell[CellGroupData[{

Cell[BoxData["LGGaugeO2"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.454050790694797*^9, 3.454050807408856*^9}, 3.454052286514977*^9, {
   3.454057086606534*^9, 3.4540570873864717`*^9}, 3.454061218230431*^9, 
   3.846587070017083*^9, 
   3.8465876836896887`*^9},ExpressionUUID->"80552330-6b99-4064-acd6-\
d05d29e6b5f4"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   FormBox["\[Kappa]",
    TraditionalForm], " ", 
   RowBox[{
    FormBox[
     SubscriptBox["h", 
      RowBox[{
       FormBox["\[Mu]",
        TraditionalForm], ",", 
       FormBox["\[Nu]",
        TraditionalForm]}]],
     TraditionalForm], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Rho]",
               TraditionalForm]],
             TraditionalForm], ")"}],
           TraditionalForm], "-", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], ")"}],
           TraditionalForm]}], ")"}]}], " ", 
       RowBox[{"(", 
        RowBox[{
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Nu]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Rho]",
              TraditionalForm]],
            TraditionalForm], ")"}],
          TraditionalForm], "-", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Rho]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Nu]",
              TraditionalForm]],
            TraditionalForm], ")"}],
          TraditionalForm]}], ")"}]}], "-", 
      RowBox[{
       FormBox[
        SubscriptBox["\[Eta]", 
         RowBox[{
          FormBox[
           FormBox["\[Mu]",
            TraditionalForm],
           TraditionalForm], ",", 
          FormBox[
           FormBox["\[Nu]",
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], ".", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "4"]}], " ", 
          SuperscriptBox[
           RowBox[{"(", 
            RowBox[{
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", 
                FormBox["\[Rho]",
                 TraditionalForm]], "(", 
               FormBox[
                SubscriptBox["B", "sig"],
                TraditionalForm], ")"}],
              TraditionalForm], "-", 
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", "sig"], "(", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], ")"}],
              TraditionalForm]}], ")"}], "2"]}], "-", 
         RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", "sig"], "(", 
               FormBox[
                SubscriptBox["G", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "a1"}]],
                TraditionalForm], ")"}],
              TraditionalForm]}], "+", 
            FormBox[
             RowBox[{
              SubscriptBox["\<\"\[PartialD]\"\>", 
               FormBox["\[Rho]",
                TraditionalForm]], "(", 
              FormBox[
               SubscriptBox["G", 
                RowBox[{"sig", ",", "a1"}]],
               TraditionalForm], ")"}],
             TraditionalForm], "+", 
            RowBox[{
             FormBox[
              SubscriptBox["g", "s"],
              TraditionalForm], " ", 
             FormBox[
              SubscriptBox["f", 
               RowBox[{"a1", ",", "a2", ",", "a3"}]],
              TraditionalForm], " ", 
             FormBox[
              SubscriptBox["G", 
               RowBox[{
                FormBox["\[Rho]",
                 TraditionalForm], ",", "a2"}]],
              TraditionalForm], " ", 
             FormBox[
              SubscriptBox["G", 
               RowBox[{"sig", ",", "a3"}]],
              TraditionalForm]}]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", "sig"], "(", 
               FormBox[
                SubscriptBox["G", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "a1"}]],
                TraditionalForm], ")"}],
              TraditionalForm]}], "+", 
            FormBox[
             RowBox[{
              SubscriptBox["\<\"\[PartialD]\"\>", 
               FormBox["\[Rho]",
                TraditionalForm]], "(", 
              FormBox[
               SubscriptBox["G", 
                RowBox[{"sig", ",", "a1"}]],
               TraditionalForm], ")"}],
             TraditionalForm], "+", 
            RowBox[{
             FormBox[
              SubscriptBox["g", "s"],
              TraditionalForm], " ", 
             FormBox[
              SubscriptBox["f", 
               RowBox[{"a1", ",", "a4", ",", "a5"}]],
              TraditionalForm], " ", 
             FormBox[
              SubscriptBox["G", 
               RowBox[{
                FormBox["\[Rho]",
                 TraditionalForm], ",", "a4"}]],
              TraditionalForm], " ", 
             FormBox[
              SubscriptBox["G", 
               RowBox[{"sig", ",", "a5"}]],
              TraditionalForm]}]}], ")"}]}], "-", 
         RowBox[{
          FractionBox["1", "4"], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", "sig"], "(", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "i1"}]],
                TraditionalForm], ")"}],
              TraditionalForm]}], "+", 
            FormBox[
             RowBox[{
              SubscriptBox["\<\"\[PartialD]\"\>", 
               FormBox["\[Rho]",
                TraditionalForm]], "(", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{"sig", ",", "i1"}]],
               TraditionalForm], ")"}],
             TraditionalForm], "+", 
            FractionBox[
             RowBox[{
              FormBox["e",
               TraditionalForm], " ", 
              FormBox[
               SubscriptBox["\[Epsilon]", 
                RowBox[{"i1", ",", "i2", ",", "i3"}]],
               TraditionalForm], " ", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "i2"}]],
               TraditionalForm], " ", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{"sig", ",", "i3"}]],
               TraditionalForm]}], 
             FormBox[
              SubscriptBox["s", "w"],
              TraditionalForm]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            RowBox[{"-", 
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", "sig"], "(", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "i1"}]],
                TraditionalForm], ")"}],
              TraditionalForm]}], "+", 
            FormBox[
             RowBox[{
              SubscriptBox["\<\"\[PartialD]\"\>", 
               FormBox["\[Rho]",
                TraditionalForm]], "(", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{"sig", ",", "i1"}]],
               TraditionalForm], ")"}],
             TraditionalForm], "+", 
            FractionBox[
             RowBox[{
              FormBox["e",
               TraditionalForm], " ", 
              FormBox[
               SubscriptBox["\[Epsilon]", 
                RowBox[{"i1", ",", "i4", ",", "i5"}]],
               TraditionalForm], " ", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "i4"}]],
               TraditionalForm], " ", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{"sig", ",", "i5"}]],
               TraditionalForm]}], 
             FormBox[
              SubscriptBox["s", "w"],
              TraditionalForm]]}], ")"}]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            FormBox[
             SubscriptBox["G", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "a1"}]],
             TraditionalForm], ")"}],
           TraditionalForm]}], "+", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Mu]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "a1"}]],
            TraditionalForm], ")"}],
          TraditionalForm], "+", 
         RowBox[{
          FormBox[
           SubscriptBox["g", "s"],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["f", 
            RowBox[{"a1", ",", "a2", ",", "a3"}]],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["G", 
            RowBox[{
             FormBox["\[Mu]",
              TraditionalForm], ",", "a2"}]],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["G", 
            RowBox[{
             FormBox["\[Rho]",
              TraditionalForm], ",", "a3"}]],
           TraditionalForm]}]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            FormBox[
             SubscriptBox["G", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "a1"}]],
             TraditionalForm], ")"}],
           TraditionalForm]}], "+", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Nu]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "a1"}]],
            TraditionalForm], ")"}],
          TraditionalForm], "+", 
         RowBox[{
          FormBox[
           SubscriptBox["g", "s"],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["f", 
            RowBox[{"a1", ",", "a2", ",", "a3"}]],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["G", 
            RowBox[{
             FormBox["\[Nu]",
              TraditionalForm], ",", "a2"}]],
           TraditionalForm], " ", 
          FormBox[
           SubscriptBox["G", 
            RowBox[{
             FormBox["\[Rho]",
              TraditionalForm], ",", "a3"}]],
           TraditionalForm]}]}], ")"}]}], "-", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "i1"}]],
             TraditionalForm], ")"}],
           TraditionalForm]}], "+", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Mu]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "i1"}]],
            TraditionalForm], ")"}],
          TraditionalForm], "+", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["\[Epsilon]", 
             RowBox[{"i1", ",", "i2", ",", "i3"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "i2"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "i3"}]],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["s", "w"],
           TraditionalForm]]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "i1"}]],
             TraditionalForm], ")"}],
           TraditionalForm]}], "+", 
         FormBox[
          RowBox[{
           SubscriptBox["\<\"\[PartialD]\"\>", 
            FormBox["\[Nu]",
             TraditionalForm]], "(", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "i1"}]],
            TraditionalForm], ")"}],
          TraditionalForm], "+", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["\[Epsilon]", 
             RowBox[{"i1", ",", "i4", ",", "i5"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "i4"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Rho]",
               TraditionalForm], ",", "i5"}]],
            TraditionalForm]}], 
          FormBox[
           SubscriptBox["s", "w"],
           TraditionalForm]]}], ")"}]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.4540612188923187`*^9},ExpressionUUID->"3fcd004e-dc4a-4abb-ac49-\
494b60fae4f3"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gravitons + Scalar sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910274288354*^9, 3.41191027703699*^9}, {3.8465871725740137`*^9, 
  3.846587225484082*^9}},ExpressionUUID->"6255587e-0af9-4334-a0fa-\
39a7c53c18cf"],

Cell[CellGroupData[{

Cell[BoxData["LGHiggsO2"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.411910290186841*^9, 3.411910292005392*^9}, 3.454052293282386*^9, {
   3.454057094128326*^9, 3.454057094642251*^9}, 3.45406122079182*^9, 
   3.846587079935059*^9},ExpressionUUID->"0b6ab6a8-4b40-48b1-b8de-\
c216aa59c101"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   FormBox["\[Kappa]",
    TraditionalForm], " ", 
   RowBox[{
    FormBox[
     SubscriptBox["h", 
      RowBox[{
       FormBox["\[Mu]",
        TraditionalForm], ",", 
       FormBox["\[Nu]",
        TraditionalForm]}]],
     TraditionalForm], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", "\[Lambda]", " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"H", "+", "v"}], ")"}], "4"]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", 
       SuperscriptBox[
        FormBox["\[Mu]",
         TraditionalForm], "2"], " ", 
       SuperscriptBox[
        RowBox[{"(", 
         RowBox[{"H", "+", "v"}], ")"}], "2"]}], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         FormBox["e",
          TraditionalForm], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           SubscriptBox["Wi", 
            RowBox[{
             FormBox["\[Mu]",
              TraditionalForm], ",", "1"}]],
           TraditionalForm], "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "2"}]],
            TraditionalForm]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           SubscriptBox["Wi", 
            RowBox[{
             FormBox["\[Nu]",
              TraditionalForm], ",", "1"}]],
           TraditionalForm], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "2"}]],
            TraditionalForm]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"H", "+", "v"}], ")"}], "2"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], "2"]}]], "+", 
      FractionBox[
       RowBox[{
        SuperscriptBox[
         FormBox["e",
          TraditionalForm], "2"], " ", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           SubscriptBox["Wi", 
            RowBox[{
             FormBox["\[Mu]",
              TraditionalForm], ",", "1"}]],
           TraditionalForm], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "2"}]],
            TraditionalForm]}]}], ")"}], " ", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           SubscriptBox["Wi", 
            RowBox[{
             FormBox["\[Nu]",
              TraditionalForm], ",", "1"}]],
           TraditionalForm], "+", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "2"}]],
            TraditionalForm]}]}], ")"}], " ", 
        SuperscriptBox[
         RowBox[{"(", 
          RowBox[{"H", "+", "v"}], ")"}], "2"]}], 
       RowBox[{"8", " ", 
        SuperscriptBox[
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm], "2"]}]], "-", 
      RowBox[{
       FormBox[
        SubscriptBox["\[Eta]", 
         RowBox[{
          FormBox[
           FormBox["\[Mu]",
            TraditionalForm],
           TraditionalForm], ",", 
          FormBox[
           FormBox["\[Nu]",
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], ".", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           SuperscriptBox[
            FormBox["e",
             TraditionalForm], "2"], " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              SubscriptBox["Wi", 
               RowBox[{
                FormBox["\[Rho]",
                 TraditionalForm], ",", "1"}]],
              TraditionalForm], "-", 
             RowBox[{"\[ImaginaryI]", " ", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "2"}]],
               TraditionalForm]}]}], ")"}], " ", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              SubscriptBox["Wi", 
               RowBox[{
                FormBox["\[Rho]",
                 TraditionalForm], ",", "1"}]],
              TraditionalForm], "+", 
             RowBox[{"\[ImaginaryI]", " ", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "2"}]],
               TraditionalForm]}]}], ")"}], " ", 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"H", "+", "v"}], ")"}], "2"]}], 
          RowBox[{"8", " ", 
           SuperscriptBox[
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm], "2"]}]], "+", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{
              FormBox["e",
               TraditionalForm], " ", 
              RowBox[{"(", 
               RowBox[{"H", "+", "v"}], ")"}], " ", 
              FormBox[
               SubscriptBox["B", 
                FormBox["\[Rho]",
                 TraditionalForm]],
               TraditionalForm]}], 
             RowBox[{"2", " ", 
              SqrtBox["2"], " ", 
              FormBox[
               SubscriptBox["c", "w"],
               TraditionalForm]}]], "-", 
            FractionBox[
             RowBox[{"\[ImaginaryI]", " ", 
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", "H", ")"}],
               TraditionalForm]}], 
             SqrtBox["2"]], "-", 
            FractionBox[
             RowBox[{
              FormBox["e",
               TraditionalForm], " ", 
              RowBox[{"(", 
               RowBox[{"H", "+", "v"}], ")"}], " ", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "3"}]],
               TraditionalForm]}], 
             RowBox[{"2", " ", 
              SqrtBox["2"], " ", 
              FormBox[
               SubscriptBox["s", "w"],
               TraditionalForm]}]]}], ")"}], " ", 
          RowBox[{"(", 
           RowBox[{
            FractionBox[
             RowBox[{
              FormBox["e",
               TraditionalForm], " ", 
              RowBox[{"(", 
               RowBox[{"H", "+", "v"}], ")"}], " ", 
              FormBox[
               SubscriptBox["B", 
                FormBox["\[Rho]",
                 TraditionalForm]],
               TraditionalForm]}], 
             RowBox[{"2", " ", 
              SqrtBox["2"], " ", 
              FormBox[
               SubscriptBox["c", "w"],
               TraditionalForm]}]], "+", 
            FractionBox[
             RowBox[{"\[ImaginaryI]", " ", 
              FormBox[
               RowBox[{
                SubscriptBox["\<\"\[PartialD]\"\>", 
                 FormBox["\[Rho]",
                  TraditionalForm]], "(", "H", ")"}],
               TraditionalForm]}], 
             SqrtBox["2"]], "-", 
            FractionBox[
             RowBox[{
              FormBox["e",
               TraditionalForm], " ", 
              RowBox[{"(", 
               RowBox[{"H", "+", "v"}], ")"}], " ", 
              FormBox[
               SubscriptBox["Wi", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "3"}]],
               TraditionalForm]}], 
             RowBox[{"2", " ", 
              SqrtBox["2"], " ", 
              FormBox[
               SubscriptBox["s", "w"],
               TraditionalForm]}]]}], ")"}]}]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Mu]",
              TraditionalForm]],
            TraditionalForm]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]}]], "+", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            RowBox[{
             SubscriptBox["\<\"\[PartialD]\"\>", 
              FormBox["\[Mu]",
               TraditionalForm]], "(", "H", ")"}],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "3"}]],
            TraditionalForm]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["s", "w"],
            TraditionalForm]}]]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Nu]",
              TraditionalForm]],
            TraditionalForm]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]}]], "-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            RowBox[{
             SubscriptBox["\<\"\[PartialD]\"\>", 
              FormBox["\[Nu]",
               TraditionalForm]], "(", "H", ")"}],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "3"}]],
            TraditionalForm]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["s", "w"],
            TraditionalForm]}]]}], ")"}]}], "+", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Mu]",
              TraditionalForm]],
            TraditionalForm]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]}]], "-", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            RowBox[{
             SubscriptBox["\<\"\[PartialD]\"\>", 
              FormBox["\[Mu]",
               TraditionalForm]], "(", "H", ")"}],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "3"}]],
            TraditionalForm]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["s", "w"],
            TraditionalForm]}]]}], ")"}], " ", 
       RowBox[{"(", 
        RowBox[{
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           FormBox[
            SubscriptBox["B", 
             FormBox["\[Nu]",
              TraditionalForm]],
            TraditionalForm]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]}]], "+", 
         FractionBox[
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            RowBox[{
             SubscriptBox["\<\"\[PartialD]\"\>", 
              FormBox["\[Nu]",
               TraditionalForm]], "(", "H", ")"}],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           FormBox[
            SubscriptBox["Wi", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "3"}]],
            TraditionalForm]}], 
          RowBox[{"2", " ", 
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["s", "w"],
            TraditionalForm]}]]}], ")"}]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.454061221137125*^9},ExpressionUUID->"291dcac5-8f83-4b14-8091-\
6467de9ab4bb"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gravitons + Fermion sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.4119103528868923`*^9, 3.411910357404933*^9}, {3.846587199928822*^9, 
  3.8465872270347633`*^9}},ExpressionUUID->"e55c713f-40d3-442f-872b-\
50b0e6cec5f2"],

Cell[CellGroupData[{

Cell[BoxData["LGFermionsO2"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.411910379677638*^9, 3.4119103807255*^9}, {3.454050812632284*^9, 
   3.4540508182235947`*^9}, 3.4540522991223593`*^9, {3.454057102034585*^9, 
   3.454057104921763*^9}, 3.454061223464816*^9, 
   3.8465870757434187`*^9},ExpressionUUID->"b9e6afda-6b21-4d26-b289-\
4e476fc55518"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   FormBox["\[Kappa]",
    TraditionalForm], " ", 
   RowBox[{
    FormBox[
     SubscriptBox["h", 
      RowBox[{
       FormBox["\[Mu]",
        TraditionalForm], ",", 
       FormBox["\[Nu]",
        TraditionalForm]}]],
     TraditionalForm], ".", 
    RowBox[{"(", 
     RowBox[{
      RowBox[{
       RowBox[{"-", 
        FractionBox["1", "4"]}], " ", "\[ImaginaryI]", " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", 
          FormBox["\[Nu]",
           TraditionalForm]], "(", 
         RowBox[{
          FormBox[
           SuperscriptBox["dq", "\[Dagger]"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Mu]",
             TraditionalForm]],
           TraditionalForm], ".", "dq"}], ")"}],
        TraditionalForm]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", 
          FormBox["\[Mu]",
           TraditionalForm]], "(", 
         RowBox[{
          FormBox[
           SuperscriptBox["dq", "\[Dagger]"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Nu]",
             TraditionalForm]],
           TraditionalForm], ".", "dq"}], ")"}],
        TraditionalForm]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", 
          FormBox["\[Nu]",
           TraditionalForm]], "(", 
         RowBox[{
          FormBox[
           SuperscriptBox["l", "\[Dagger]"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Mu]",
             TraditionalForm]],
           TraditionalForm], ".", "l"}], ")"}],
        TraditionalForm]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", 
          FormBox["\[Mu]",
           TraditionalForm]], "(", 
         RowBox[{
          FormBox[
           SuperscriptBox["l", "\[Dagger]"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Nu]",
             TraditionalForm]],
           TraditionalForm], ".", "l"}], ")"}],
        TraditionalForm]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", 
          FormBox["\[Nu]",
           TraditionalForm]], "(", 
         RowBox[{
          FormBox[
           SuperscriptBox["uq", "\[Dagger]"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Mu]",
             TraditionalForm]],
           TraditionalForm], ".", "uq"}], ")"}],
        TraditionalForm]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", 
          FormBox["\[Mu]",
           TraditionalForm]], "(", 
         RowBox[{
          FormBox[
           SuperscriptBox["uq", "\[Dagger]"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Nu]",
             TraditionalForm]],
           TraditionalForm], ".", "uq"}], ")"}],
        TraditionalForm]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", 
          FormBox["\[Nu]",
           TraditionalForm]], "(", 
         RowBox[{
          FormBox[
           SuperscriptBox["vl", "\[Dagger]"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Mu]",
             TraditionalForm]],
           TraditionalForm], ".", "vl"}], ")"}],
        TraditionalForm]}], "-", 
      RowBox[{
       FractionBox["1", "4"], " ", "\[ImaginaryI]", " ", 
       FormBox[
        RowBox[{
         SubscriptBox["\<\"\[PartialD]\"\>", 
          FormBox["\[Mu]",
           TraditionalForm]], "(", 
         RowBox[{
          FormBox[
           SuperscriptBox["vl", "\[Dagger]"],
           TraditionalForm], ".", 
          FormBox[
           SuperscriptBox["\[Gamma]", 
            FormBox["\[Nu]",
             TraditionalForm]],
           TraditionalForm], ".", "vl"}], ")"}],
        TraditionalForm]}], "-", 
      RowBox[{
       FormBox[
        SubscriptBox["\[Eta]", 
         RowBox[{
          FormBox[
           FormBox["\[Mu]",
            TraditionalForm],
           TraditionalForm], ",", 
          FormBox[
           FormBox["\[Nu]",
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], ".", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", "2"]}], " ", "\[ImaginaryI]", " ", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            RowBox[{
             FormBox[
              SuperscriptBox["dq", "\[Dagger]"],
              TraditionalForm], ".", 
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox["\[Rho]",
                TraditionalForm]],
              TraditionalForm], ".", "dq"}], ")"}],
           TraditionalForm]}], "-", 
         RowBox[{
          FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            RowBox[{
             FormBox[
              SuperscriptBox["l", "\[Dagger]"],
              TraditionalForm], ".", 
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox["\[Rho]",
                TraditionalForm]],
              TraditionalForm], ".", "l"}], ")"}],
           TraditionalForm]}], "-", 
         RowBox[{
          FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            RowBox[{
             FormBox[
              SuperscriptBox["uq", "\[Dagger]"],
              TraditionalForm], ".", 
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox["\[Rho]",
                TraditionalForm]],
              TraditionalForm], ".", "uq"}], ")"}],
           TraditionalForm]}], "-", 
         RowBox[{
          FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Rho]",
              TraditionalForm]], "(", 
            RowBox[{
             FormBox[
              SuperscriptBox["vl", "\[Dagger]"],
              TraditionalForm], ".", 
             FormBox[
              SuperscriptBox["\[Gamma]", 
               FormBox["\[Rho]",
                TraditionalForm]],
              TraditionalForm], ".", "vl"}], ")"}],
           TraditionalForm]}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{
           FormBox[
            SuperscriptBox["dq", "\[Dagger]"],
            TraditionalForm], ".", 
           FormBox[
            SuperscriptBox["\[Gamma]", 
             FormBox["\[Rho]",
              TraditionalForm]],
            TraditionalForm], ".", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", 
                FormBox["\[Rho]",
                 TraditionalForm]], "(", "dq", ")"}],
              TraditionalForm], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "dq"}]}], 
              RowBox[{"6", " ", 
               FormBox[
                SubscriptBox["c", "w"],
                TraditionalForm]}]], "+", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"+\"\>"],
                 TraditionalForm], ".", "dq"}]}], 
              RowBox[{"3", " ", 
               FormBox[
                SubscriptBox["c", "w"],
                TraditionalForm]}]], "-", 
             RowBox[{"\[ImaginaryI]", " ", 
              FormBox[
               SubscriptBox["g", "s"],
               TraditionalForm], " ", 
              RowBox[{
               FormBox[
                SuperscriptBox["T", "a$182"],
                TraditionalForm], ".", "dq"}], " ", 
              FormBox[
               SubscriptBox["G", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "a$182"}]],
               TraditionalForm]}], "+", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "dq"}], " ", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "3"}]],
                TraditionalForm]}], 
              RowBox[{"2", " ", 
               FormBox[
                SubscriptBox["s", "w"],
                TraditionalForm]}]]}], ")"}]}]}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{
           FormBox[
            SuperscriptBox["l", "\[Dagger]"],
            TraditionalForm], ".", 
           FormBox[
            SuperscriptBox["\[Gamma]", 
             FormBox["\[Rho]",
              TraditionalForm]],
            TraditionalForm], ".", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", 
                FormBox["\[Rho]",
                 TraditionalForm]], "(", "l", ")"}],
              TraditionalForm], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "l"}]}], 
              RowBox[{"2", " ", 
               FormBox[
                SubscriptBox["c", "w"],
                TraditionalForm]}]], "+", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"+\"\>"],
                 TraditionalForm], ".", "l"}]}], 
              FormBox[
               SubscriptBox["c", "w"],
               TraditionalForm]], "+", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "l"}], " ", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "3"}]],
                TraditionalForm]}], 
              RowBox[{"2", " ", 
               FormBox[
                SubscriptBox["s", "w"],
                TraditionalForm]}]]}], ")"}]}]}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{
           FormBox[
            SuperscriptBox["uq", "\[Dagger]"],
            TraditionalForm], ".", 
           FormBox[
            SuperscriptBox["\[Gamma]", 
             FormBox["\[Rho]",
              TraditionalForm]],
            TraditionalForm], ".", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", 
                FormBox["\[Rho]",
                 TraditionalForm]], "(", "uq", ")"}],
              TraditionalForm], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "uq"}]}], 
              RowBox[{"6", " ", 
               FormBox[
                SubscriptBox["c", "w"],
                TraditionalForm]}]], "-", 
             FractionBox[
              RowBox[{"2", " ", "\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"+\"\>"],
                 TraditionalForm], ".", "uq"}]}], 
              RowBox[{"3", " ", 
               FormBox[
                SubscriptBox["c", "w"],
                TraditionalForm]}]], "-", 
             RowBox[{"\[ImaginaryI]", " ", 
              FormBox[
               SubscriptBox["g", "s"],
               TraditionalForm], " ", 
              RowBox[{
               FormBox[
                SuperscriptBox["T", "a$181"],
                TraditionalForm], ".", "uq"}], " ", 
              FormBox[
               SubscriptBox["G", 
                RowBox[{
                 FormBox["\[Rho]",
                  TraditionalForm], ",", "a$181"}]],
               TraditionalForm]}], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "uq"}], " ", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "3"}]],
                TraditionalForm]}], 
              RowBox[{"2", " ", 
               FormBox[
                SubscriptBox["s", "w"],
                TraditionalForm]}]]}], ")"}]}]}], "+", 
         RowBox[{"\[ImaginaryI]", " ", 
          RowBox[{
           FormBox[
            SuperscriptBox["vl", "\[Dagger]"],
            TraditionalForm], ".", 
           FormBox[
            SuperscriptBox["\[Gamma]", 
             FormBox["\[Rho]",
              TraditionalForm]],
            TraditionalForm], ".", 
           RowBox[{"(", 
            RowBox[{
             FormBox[
              RowBox[{
               SubscriptBox["\<\"\[PartialD]\"\>", 
                FormBox["\[Rho]",
                 TraditionalForm]], "(", "vl", ")"}],
              TraditionalForm], "+", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               FormBox[
                SubscriptBox["B", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "vl"}]}], 
              RowBox[{"2", " ", 
               FormBox[
                SubscriptBox["c", "w"],
                TraditionalForm]}]], "-", 
             FractionBox[
              RowBox[{"\[ImaginaryI]", " ", 
               FormBox["e",
                TraditionalForm], " ", 
               RowBox[{
                FormBox[
                 SubscriptBox["P", "\<\"-\"\>"],
                 TraditionalForm], ".", "vl"}], " ", 
               FormBox[
                SubscriptBox["Wi", 
                 RowBox[{
                  FormBox["\[Rho]",
                   TraditionalForm], ",", "3"}]],
                TraditionalForm]}], 
              RowBox[{"2", " ", 
               FormBox[
                SubscriptBox["s", "w"],
                TraditionalForm]}]]}], ")"}]}]}], "-", 
         FractionBox[
          RowBox[{
           FormBox["e",
            TraditionalForm], " ", 
           RowBox[{"(", 
            RowBox[{
             RowBox[{"CKM", " ", 
              RowBox[{
               FormBox[
                SuperscriptBox["uq", "\[Dagger]"],
                TraditionalForm], ".", 
               FormBox[
                SuperscriptBox["\[Gamma]", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], ".", 
               FormBox[
                SubscriptBox["P", "\<\"-\"\>"],
                TraditionalForm], ".", "dq"}], " ", 
              FormBox[
               SubscriptBox["W", 
                FormBox["\[Rho]",
                 TraditionalForm]],
               TraditionalForm]}], "+", 
             RowBox[{
              RowBox[{
               FormBox[
                SuperscriptBox["vl", "\[Dagger]"],
                TraditionalForm], ".", 
               FormBox[
                SuperscriptBox["\[Gamma]", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], ".", 
               FormBox[
                SubscriptBox["P", "\<\"-\"\>"],
                TraditionalForm], ".", "l"}], " ", 
              FormBox[
               SubscriptBox["W", 
                FormBox["\[Rho]",
                 TraditionalForm]],
               TraditionalForm]}], "+", 
             RowBox[{
              RowBox[{
               FormBox[
                SuperscriptBox["l", "\[Dagger]"],
                TraditionalForm], ".", 
               FormBox[
                SuperscriptBox["\[Gamma]", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], ".", 
               FormBox[
                SubscriptBox["P", "\<\"-\"\>"],
                TraditionalForm], ".", "vl"}], " ", 
              FormBox[
               SubsuperscriptBox["W", 
                FormBox["\[Rho]",
                 TraditionalForm], "\[Dagger]"],
               TraditionalForm]}], "+", 
             RowBox[{
              RowBox[{
               FormBox[
                SuperscriptBox["dq", "\[Dagger]"],
                TraditionalForm], ".", 
               FormBox[
                SuperscriptBox["\[Gamma]", 
                 FormBox["\[Rho]",
                  TraditionalForm]],
                TraditionalForm], ".", 
               FormBox[
                SubscriptBox["P", "\<\"-\"\>"],
                TraditionalForm], ".", "uq"}], " ", 
              FormBox[
               SuperscriptBox["CKM", "\[Dagger]"],
               TraditionalForm], " ", 
              FormBox[
               SubsuperscriptBox["W", 
                FormBox["\[Rho]",
                 TraditionalForm], "\[Dagger]"],
               TraditionalForm]}]}], ")"}]}], 
          RowBox[{
           SqrtBox["2"], " ", 
           FormBox[
            SubscriptBox["s", "w"],
            TraditionalForm]}]]}], ")"}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["dq", "\[Dagger]"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Mu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", "dq", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "dq"}]}], 
           RowBox[{"6", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "dq"}]}], 
           RowBox[{"3", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["g", "s"],
            TraditionalForm], " ", 
           RowBox[{
            FormBox[
             SuperscriptBox["T", "a$187"],
             TraditionalForm], ".", "dq"}], " ", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "a$187"}]],
            TraditionalForm]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "dq"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["dq", "\[Dagger]"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Nu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", "dq", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "dq"}]}], 
           RowBox[{"6", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "dq"}]}], 
           RowBox[{"3", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["g", "s"],
            TraditionalForm], " ", 
           RowBox[{
            FormBox[
             SuperscriptBox["T", "a$188"],
             TraditionalForm], ".", "dq"}], " ", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "a$188"}]],
            TraditionalForm]}], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "dq"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["l", "\[Dagger]"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Mu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", "l", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "l"}]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "l"}]}], 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "l"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["l", "\[Dagger]"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Nu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", "l", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "l"}]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "l"}]}], 
           FormBox[
            SubscriptBox["c", "w"],
            TraditionalForm]], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "l"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["uq", "\[Dagger]"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Mu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", "uq", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "uq"}]}], 
           RowBox[{"6", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          FractionBox[
           RowBox[{"2", " ", "\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "uq"}]}], 
           RowBox[{"3", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["g", "s"],
            TraditionalForm], " ", 
           RowBox[{
            FormBox[
             SuperscriptBox["T", "a$185"],
             TraditionalForm], ".", "uq"}], " ", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Nu]",
               TraditionalForm], ",", "a$185"}]],
            TraditionalForm]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "uq"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["uq", "\[Dagger]"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Nu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", "uq", ")"}],
           TraditionalForm], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "uq"}]}], 
           RowBox[{"6", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          FractionBox[
           RowBox[{"2", " ", "\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"+\"\>"],
              TraditionalForm], ".", "uq"}]}], 
           RowBox[{"3", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          RowBox[{"\[ImaginaryI]", " ", 
           FormBox[
            SubscriptBox["g", "s"],
            TraditionalForm], " ", 
           RowBox[{
            FormBox[
             SuperscriptBox["T", "a$186"],
             TraditionalForm], ".", "uq"}], " ", 
           FormBox[
            SubscriptBox["G", 
             RowBox[{
              FormBox["\[Mu]",
               TraditionalForm], ",", "a$186"}]],
            TraditionalForm]}], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "uq"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["vl", "\[Dagger]"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Mu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Nu]",
              TraditionalForm]], "(", "vl", ")"}],
           TraditionalForm], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "vl"}]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "vl"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Nu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "+", 
      RowBox[{
       FractionBox["1", "2"], " ", "\[ImaginaryI]", " ", 
       RowBox[{
        FormBox[
         SuperscriptBox["vl", "\[Dagger]"],
         TraditionalForm], ".", 
        FormBox[
         SuperscriptBox["\[Gamma]", 
          FormBox["\[Nu]",
           TraditionalForm]],
         TraditionalForm], ".", 
        RowBox[{"(", 
         RowBox[{
          FormBox[
           RowBox[{
            SubscriptBox["\<\"\[PartialD]\"\>", 
             FormBox["\[Mu]",
              TraditionalForm]], "(", "vl", ")"}],
           TraditionalForm], "+", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["B", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "vl"}]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["c", "w"],
             TraditionalForm]}]], "-", 
          FractionBox[
           RowBox[{"\[ImaginaryI]", " ", 
            FormBox["e",
             TraditionalForm], " ", 
            RowBox[{
             FormBox[
              SubscriptBox["P", "\<\"-\"\>"],
              TraditionalForm], ".", "vl"}], " ", 
            FormBox[
             SubscriptBox["Wi", 
              RowBox[{
               FormBox["\[Mu]",
                TraditionalForm], ",", "3"}]],
             TraditionalForm]}], 
           RowBox[{"2", " ", 
            FormBox[
             SubscriptBox["s", "w"],
             TraditionalForm]}]]}], ")"}]}]}], "-", 
      RowBox[{
       FractionBox["1", 
        RowBox[{
         SqrtBox["2"], " ", 
         FormBox[
          SubscriptBox["s", "w"],
          TraditionalForm]}]], 
       RowBox[{
        FormBox["e",
         TraditionalForm], " ", 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"CKM", " ", 
           RowBox[{
            FormBox[
             SuperscriptBox["uq", "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "dq"}], " ", 
           FormBox[
            SubscriptBox["W", 
             FormBox["\[Mu]",
              TraditionalForm]],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             SuperscriptBox["vl", "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "l"}], " ", 
           FormBox[
            SubscriptBox["W", 
             FormBox["\[Mu]",
              TraditionalForm]],
            TraditionalForm]}], "+", 
          RowBox[{"CKM", " ", 
           RowBox[{
            FormBox[
             SuperscriptBox["uq", "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "dq"}], " ", 
           FormBox[
            SubscriptBox["W", 
             FormBox["\[Nu]",
              TraditionalForm]],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             SuperscriptBox["vl", "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "l"}], " ", 
           FormBox[
            SubscriptBox["W", 
             FormBox["\[Nu]",
              TraditionalForm]],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             SuperscriptBox["l", "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "vl"}], " ", 
           FormBox[
            SubsuperscriptBox["W", 
             FormBox["\[Mu]",
              TraditionalForm], "\[Dagger]"],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             SuperscriptBox["dq", "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Nu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "uq"}], " ", 
           FormBox[
            SuperscriptBox["CKM", "\[Dagger]"],
            TraditionalForm], " ", 
           FormBox[
            SubsuperscriptBox["W", 
             FormBox["\[Mu]",
              TraditionalForm], "\[Dagger]"],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             SuperscriptBox["l", "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "vl"}], " ", 
           FormBox[
            SubsuperscriptBox["W", 
             FormBox["\[Nu]",
              TraditionalForm], "\[Dagger]"],
            TraditionalForm]}], "+", 
          RowBox[{
           RowBox[{
            FormBox[
             SuperscriptBox["dq", "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SuperscriptBox["\[Gamma]", 
              FormBox["\[Mu]",
               TraditionalForm]],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["P", "\<\"-\"\>"],
             TraditionalForm], ".", "uq"}], " ", 
           FormBox[
            SuperscriptBox["CKM", "\[Dagger]"],
            TraditionalForm], " ", 
           FormBox[
            SubsuperscriptBox["W", 
             FormBox["\[Nu]",
              TraditionalForm], "\[Dagger]"],
            TraditionalForm]}]}], ")"}]}]}]}], ")"}]}]}], 
  TraditionalForm]], "Output",
 CellChangeTimes->{
  3.45406122390963*^9},ExpressionUUID->"d45a1b88-1dea-4e0d-b094-f0acead477a1"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gravitons + Yukawa sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}, {3.846587201709598*^9, 
  3.846587228322217*^9}},ExpressionUUID->"49b0b76d-dae2-4d44-92f8-\
831da3136cbd"],

Cell[CellGroupData[{

Cell[BoxData["LGYukawaO2"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.4119104032372026`*^9, 3.411910404165523*^9}, 3.4540523167591047`*^9, {
   3.454057108491197*^9, 3.4540571095455637`*^9}, 3.454061225806781*^9, 
   3.8465870833881893`*^9},ExpressionUUID->"c5cc8969-d9dc-4874-85e7-\
5a07594f4dd8"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   FormBox["\[Kappa]",
    TraditionalForm], " ", 
   RowBox[{
    FormBox[
     SubscriptBox["h", 
      RowBox[{
       FormBox["\[Mu]",
        TraditionalForm], ",", 
       FormBox["\[Nu]",
        TraditionalForm]}]],
     TraditionalForm], ".", 
    RowBox[{"(", 
     RowBox[{"-", 
      RowBox[{
       FormBox[
        SubscriptBox["\[Eta]", 
         RowBox[{
          FormBox[
           FormBox["\[Mu]",
            TraditionalForm],
           TraditionalForm], ",", 
          FormBox[
           FormBox["\[Nu]",
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], ".", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"H", "+", "v"}], ")"}], " ", 
            RowBox[{
             FormBox[
              SubsuperscriptBox["dq", 
               RowBox[{"s$194", ",", "n$194", ",", "i$194"}], "\[Dagger]"],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["dq", 
               RowBox[{"r$194", ",", "n$194", ",", "i$194"}]],
              TraditionalForm]}], " ", 
            FormBox[
             SubscriptBox[
              RowBox[{"(", 
               SubscriptBox["P", "\<\"+\"\>"], ")"}], 
              RowBox[{"s$194", ",", "r$194"}]],
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["yd", "n$194"],
             TraditionalForm]}], 
           SqrtBox["2"]]}], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["dq", 
              RowBox[{"r$195", ",", "n$195", ",", "i$195"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["dq", 
              RowBox[{"s$195", ",", "n$195", ",", "i$195"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"-\"\>"], ")"}], 
             RowBox[{"r$195", ",", "s$195"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yd", "n$195"],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["l", 
              RowBox[{"s$194", ",", "n$194"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["l", 
              RowBox[{"r$194", ",", "n$194"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"+\"\>"], ")"}], 
             RowBox[{"s$194", ",", "r$194"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yl", "n$194"],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["l", 
              RowBox[{"r$195", ",", "n$195"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["l", 
              RowBox[{"s$195", ",", "n$195"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"-\"\>"], ")"}], 
             RowBox[{"r$195", ",", "s$195"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yl", "n$195"],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["uq", 
              RowBox[{"s$194", ",", "n$194", ",", "i$194"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["uq", 
              RowBox[{"r$194", ",", "n$194", ",", "i$194"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"+\"\>"], ")"}], 
             RowBox[{"s$194", ",", "r$194"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yu", "n$194"],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["uq", 
              RowBox[{"r$195", ",", "n$195", ",", "i$195"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["uq", 
              RowBox[{"s$195", ",", "n$195", ",", "i$195"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"-\"\>"], ")"}], 
             RowBox[{"r$195", ",", "s$195"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yu", "n$195"],
            TraditionalForm]}], 
          SqrtBox["2"]]}], ")"}]}]}], ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.454061226531508*^9},ExpressionUUID->"0d2c3841-cd5b-4454-b952-\
167bcedc6b99"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gravitons + Ghost sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}, {3.846587094895335*^9, 
  3.846587095297233*^9}, {3.8465872029715157`*^9, 
  3.846587229213891*^9}},ExpressionUUID->"e273bb53-205e-4ce8-b51f-\
77f61ca43d3b"],

Cell[CellGroupData[{

Cell[BoxData["LGGhostO2"], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.4119104032372026`*^9, 3.411910404165523*^9}, 3.4540523167591047`*^9, {
   3.454057108491197*^9, 3.4540571095455637`*^9}, 3.454061225806781*^9, 
   3.8465870833881893`*^9, 
   3.846587114736705*^9},ExpressionUUID->"71a4aa6c-1c15-481b-9fc4-\
9330b53c715e"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   FormBox["\[Kappa]",
    TraditionalForm], " ", 
   RowBox[{
    FormBox[
     SubscriptBox["h", 
      RowBox[{
       FormBox["\[Mu]",
        TraditionalForm], ",", 
       FormBox["\[Nu]",
        TraditionalForm]}]],
     TraditionalForm], ".", 
    RowBox[{"(", 
     RowBox[{"-", 
      RowBox[{
       FormBox[
        SubscriptBox["\[Eta]", 
         RowBox[{
          FormBox[
           FormBox["\[Mu]",
            TraditionalForm],
           TraditionalForm], ",", 
          FormBox[
           FormBox["\[Nu]",
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], ".", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"H", "+", "v"}], ")"}], " ", 
            RowBox[{
             FormBox[
              SubsuperscriptBox["dq", 
               RowBox[{"s$194", ",", "n$194", ",", "i$194"}], "\[Dagger]"],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["dq", 
               RowBox[{"r$194", ",", "n$194", ",", "i$194"}]],
              TraditionalForm]}], " ", 
            FormBox[
             SubscriptBox[
              RowBox[{"(", 
               SubscriptBox["P", "\<\"+\"\>"], ")"}], 
              RowBox[{"s$194", ",", "r$194"}]],
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["yd", "n$194"],
             TraditionalForm]}], 
           SqrtBox["2"]]}], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["dq", 
              RowBox[{"r$195", ",", "n$195", ",", "i$195"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["dq", 
              RowBox[{"s$195", ",", "n$195", ",", "i$195"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"-\"\>"], ")"}], 
             RowBox[{"r$195", ",", "s$195"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yd", "n$195"],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["l", 
              RowBox[{"s$194", ",", "n$194"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["l", 
              RowBox[{"r$194", ",", "n$194"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"+\"\>"], ")"}], 
             RowBox[{"s$194", ",", "r$194"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yl", "n$194"],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["l", 
              RowBox[{"r$195", ",", "n$195"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["l", 
              RowBox[{"s$195", ",", "n$195"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"-\"\>"], ")"}], 
             RowBox[{"r$195", ",", "s$195"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yl", "n$195"],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["uq", 
              RowBox[{"s$194", ",", "n$194", ",", "i$194"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["uq", 
              RowBox[{"r$194", ",", "n$194", ",", "i$194"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"+\"\>"], ")"}], 
             RowBox[{"s$194", ",", "r$194"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yu", "n$194"],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["uq", 
              RowBox[{"r$195", ",", "n$195", ",", "i$195"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["uq", 
              RowBox[{"s$195", ",", "n$195", ",", "i$195"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"-\"\>"], ")"}], 
             RowBox[{"r$195", ",", "s$195"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yu", "n$195"],
            TraditionalForm]}], 
          SqrtBox["2"]]}], ")"}]}]}], ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.454061226531508*^9},ExpressionUUID->"37480c59-abcc-458b-96b9-\
4525dad79f51"]
}, Closed]]
}, Open  ]],

Cell[CellGroupData[{

Cell["The Gravitons + SM Lagrangian", "Subsubsection",
 CellChangeTimes->{{3.84658857959754*^9, 
  3.8465886014033747`*^9}},ExpressionUUID->"0cac47a0-8b44-413a-bbdf-\
87383adeb324"],

Cell["\<\
The part of the lagrangian representing the up-to-two Gravitons + full SM can \
be accessed via\
\>", "Text",
 CellChangeTimes->{{3.452857023659556*^9, 3.452857026196998*^9}, {
   3.454050603115306*^9, 3.454050604633585*^9}, {3.4540508481103973`*^9, 
   3.454050850614224*^9}, {3.846587206795353*^9, 3.846587231526289*^9}, {
   3.846588532771557*^9, 3.84658853590773*^9}, {3.8465885672503023`*^9, 
   3.8465885835925617`*^9}, 3.846588628366824*^9, {3.846588991842053*^9, 
   3.846588992190091*^9}},ExpressionUUID->"44cd65f4-1dd3-445d-89bc-\
86fd60970a40"],

Cell[BoxData[
 RowBox[{
  RowBox[{"LGTotal", ":=", 
   RowBox[{
   "LGGaugeO2", "+", "LGHiggsO2", "+", "LGFermionsO2", "+", "LGYukawaO2", "+",
     "LGGhostO2"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.454056821219754*^9, 3.4540568403918133`*^9}, {
   3.454057126321587*^9, 3.454057148256241*^9}, 3.846587126891378*^9, {
   3.846588736288669*^9, 
   3.846588738286845*^9}},ExpressionUUID->"91b83000-35d7-4c8d-b139-\
9d02bd9d2244"]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Calculation of the Feynman Rules", "Section",
 CellChangeTimes->{{3.4050095696734943`*^9, 3.4050095702696466`*^9}, {
   3.449909557093049*^9, 3.449909562576384*^9}, 3.452923012401949*^9, {
   3.45405673743528*^9, 
   3.4540567428169327`*^9}},ExpressionUUID->"50030a7f-5392-4160-8560-\
48224d30be9c"],

Cell["\<\
We will calculate now explicitly the Feynman rules for the up-to-two \
Gravitons coupled to each sector of SM in Feynman gauge.\
\>", "Text",
 CellChangeTimes->{{3.846587870746901*^9, 3.846587892274826*^9}, {
  3.846588912653144*^9, 3.846588925049086*^9}, {3.846589001634121*^9, 
  3.846589006489996*^9}},ExpressionUUID->"46ed1c78-f47a-4177-94f9-\
4cf8218f6f6d"],

Cell[BoxData[
 RowBox[{
  RowBox[{"FeynmanGauge", "=", "True"}], ";"}]], "Input",
 CellChangeTimes->{{3.84658784283851*^9, 
  3.846587857899506*^9}},ExpressionUUID->"46d76b01-79e9-402a-b6b1-\
adf6a35a4d69"],

Cell[CellGroupData[{

Cell["Gravitons + Gauge sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
   3.454057138248085*^9, 3.454057139479412*^9}, 
   3.846588677267292*^9},ExpressionUUID->"620d0c08-735a-487d-8815-\
004be19352b3"],

Cell[BoxData[
 RowBox[{"vertsGGaugeO2", "=", 
  RowBox[{"FeynmanRules", "[", 
   RowBox[{"LGGaugeO2", ",", " ", 
    RowBox[{"FlavorExpand", "\[Rule]", " ", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.45406138410235*^9, 3.454061389893989*^9}, {
   3.846587900346593*^9, 3.846587901760047*^9}, {3.8465880800508966`*^9, 
   3.846588085561921*^9}, 
   3.846588946603231*^9},ExpressionUUID->"959ee140-46d8-4d5e-9f36-\
6ae3c82ee355"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gravitons + Scalar sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910274288354*^9, 3.41191027703699*^9}, {3.846588689923386*^9, 
  3.846588692722417*^9}},ExpressionUUID->"a38d459d-783e-4af2-a1d0-\
99b51620e3a0"],

Cell[BoxData[
 RowBox[{"vertsGHiggsO2", "=", 
  RowBox[{"FeynmanRules", "[", "LGHiggsO2", "]"}]}]], "Input",
 CellChangeTimes->{{3.454061456389081*^9, 3.454061463346387*^9}, {
   3.846588194006473*^9, 3.846588197252454*^9}, {3.846588717835994*^9, 
   3.84658873040434*^9}, 
   3.846588949805257*^9},ExpressionUUID->"ceb34b49-147c-4906-baea-\
30ba2cd34bd2"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gravitons + Fermion sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.4119103528868923`*^9, 3.411910357404933*^9}, {3.846588695356337*^9, 
  3.846588699830613*^9}},ExpressionUUID->"92c021fa-5f00-4e0e-b55f-\
4a42072531aa"],

Cell[BoxData[
 RowBox[{"vertsGFermionsO2", "=", 
  RowBox[{"FeynmanRules", "[", "LGFermionsO2", "]"}]}]], "Input",
 CellChangeTimes->{{3.454056857284236*^9, 3.4540568672993917`*^9}, 
   3.4540569533264227`*^9, {3.4540571289311743`*^9, 3.4540571290168457`*^9}, {
   3.454061235719533*^9, 3.45406124186089*^9}, 3.8465882022068577`*^9, 
   3.8465887466657543`*^9, 
   3.846588952697526*^9},ExpressionUUID->"a3dd8090-3c67-41b6-b34e-\
51429bf8c82f"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gravitons + Yukawa sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
   3.411910393742139*^9, 3.411910394852953*^9}, 
   3.8465887010778513`*^9},ExpressionUUID->"4de69377-84e8-4afc-8145-\
6416fa1b8211"],

Cell[BoxData[
 RowBox[{"vertsGYukawaO2", "=", 
  RowBox[{"FeynmanRules", "[", 
   RowBox[{"LGYukawaO2", ",", 
    RowBox[{"FlavorExpand", "\[Rule]", "True"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.454061488319646*^9, 3.454061493153029*^9}, 
   3.8465882037164173`*^9, 3.8465887531401567`*^9, {3.846588839568973*^9, 
   3.846588839797961*^9}, 
   3.846588955638159*^9},ExpressionUUID->"d1dced09-9f23-4049-a247-\
1ff2cb8220c6"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Gravitons + Ghost sector", "Subsubsection",
 CellChangeTimes->{{3.4119102216473637`*^9, 3.411910224608881*^9}, {
  3.411910393742139*^9, 3.411910394852953*^9}, {3.846587094895335*^9, 
  3.846587095297233*^9}, {3.8465872029715157`*^9, 
  3.846587229213891*^9}},ExpressionUUID->"32391b8d-1a41-4c99-ac04-\
6b73f843d1ea"],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"vertsGGhostO2", "=", 
  RowBox[{"FeynmanRules", "[", 
   RowBox[{"LGGhostO2", ",", " ", 
    RowBox[{"FlavorExpand", "\[Rule]", "SU2W"}]}], "]"}]}]], "Input",
 CellChangeTimes->{{3.411910181169772*^9, 3.411910184667088*^9}, {
   3.4119104032372026`*^9, 3.411910404165523*^9}, 3.4540523167591047`*^9, {
   3.454057108491197*^9, 3.4540571095455637`*^9}, 3.454061225806781*^9, 
   3.8465870833881893`*^9, 3.846587114736705*^9, 3.846588205175249*^9, 
   3.846588759707254*^9, {3.846588848300332*^9, 3.846588861786497*^9}, 
   3.846588959547681*^9},ExpressionUUID->"8b957fda-0e1b-4e2b-b1ff-\
01140f8b5a43"],

Cell[BoxData[
 FormBox[
  RowBox[{
   RowBox[{"-", 
    FractionBox["1", "2"]}], " ", 
   FormBox["\[Kappa]",
    TraditionalForm], " ", 
   RowBox[{
    FormBox[
     SubscriptBox["h", 
      RowBox[{
       FormBox["\[Mu]",
        TraditionalForm], ",", 
       FormBox["\[Nu]",
        TraditionalForm]}]],
     TraditionalForm], ".", 
    RowBox[{"(", 
     RowBox[{"-", 
      RowBox[{
       FormBox[
        SubscriptBox["\[Eta]", 
         RowBox[{
          FormBox[
           FormBox["\[Mu]",
            TraditionalForm],
           TraditionalForm], ",", 
          FormBox[
           FormBox["\[Nu]",
            TraditionalForm],
           TraditionalForm]}]],
        TraditionalForm], ".", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", 
          FractionBox[
           RowBox[{
            RowBox[{"(", 
             RowBox[{"H", "+", "v"}], ")"}], " ", 
            RowBox[{
             FormBox[
              SubsuperscriptBox["dq", 
               RowBox[{"s$194", ",", "n$194", ",", "i$194"}], "\[Dagger]"],
              TraditionalForm], ".", 
             FormBox[
              SubscriptBox["dq", 
               RowBox[{"r$194", ",", "n$194", ",", "i$194"}]],
              TraditionalForm]}], " ", 
            FormBox[
             SubscriptBox[
              RowBox[{"(", 
               SubscriptBox["P", "\<\"+\"\>"], ")"}], 
              RowBox[{"s$194", ",", "r$194"}]],
             TraditionalForm], " ", 
            FormBox[
             SubscriptBox["yd", "n$194"],
             TraditionalForm]}], 
           SqrtBox["2"]]}], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["dq", 
              RowBox[{"r$195", ",", "n$195", ",", "i$195"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["dq", 
              RowBox[{"s$195", ",", "n$195", ",", "i$195"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"-\"\>"], ")"}], 
             RowBox[{"r$195", ",", "s$195"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yd", "n$195"],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["l", 
              RowBox[{"s$194", ",", "n$194"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["l", 
              RowBox[{"r$194", ",", "n$194"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"+\"\>"], ")"}], 
             RowBox[{"s$194", ",", "r$194"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yl", "n$194"],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["l", 
              RowBox[{"r$195", ",", "n$195"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["l", 
              RowBox[{"s$195", ",", "n$195"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"-\"\>"], ")"}], 
             RowBox[{"r$195", ",", "s$195"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yl", "n$195"],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["uq", 
              RowBox[{"s$194", ",", "n$194", ",", "i$194"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["uq", 
              RowBox[{"r$194", ",", "n$194", ",", "i$194"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"+\"\>"], ")"}], 
             RowBox[{"s$194", ",", "r$194"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yu", "n$194"],
            TraditionalForm]}], 
          SqrtBox["2"]], "-", 
         FractionBox[
          RowBox[{
           RowBox[{"(", 
            RowBox[{"H", "+", "v"}], ")"}], " ", 
           RowBox[{
            FormBox[
             SubsuperscriptBox["uq", 
              RowBox[{"r$195", ",", "n$195", ",", "i$195"}], "\[Dagger]"],
             TraditionalForm], ".", 
            FormBox[
             SubscriptBox["uq", 
              RowBox[{"s$195", ",", "n$195", ",", "i$195"}]],
             TraditionalForm]}], " ", 
           FormBox[
            SubscriptBox[
             RowBox[{"(", 
              SubscriptBox["P", "\<\"-\"\>"], ")"}], 
             RowBox[{"r$195", ",", "s$195"}]],
            TraditionalForm], " ", 
           FormBox[
            SubscriptBox["yu", "n$195"],
            TraditionalForm]}], 
          SqrtBox["2"]]}], ")"}]}]}], ")"}]}]}], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.454061226531508*^9},ExpressionUUID->"d83f6427-c2c1-4428-93e0-\
822b87a65902"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
Evaluator->"Neutrino",
WindowSize->{808, 703},
WindowMargins->{{Automatic, 0}, {40, Automatic}},
FrontEndVersion->"12.0 for Mac OS X x86 (64-bit) (April 8, 2019)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 410, 6, 160, "Title",ExpressionUUID->"0c7d382c-2c43-4a74-a4b0-6b33b7b494db"],
Cell[CellGroupData[{
Cell[1015, 32, 174, 3, 67, "Section",ExpressionUUID->"a39a0740-0c79-41c6-87fc-51f5ba05af02"],
Cell[1192, 37, 180, 4, 30, "Input",ExpressionUUID->"b8c26645-927c-4e00-ae82-8dce9c9ad8f2"],
Cell[1375, 43, 880, 16, 73, "Input",ExpressionUUID->"17ecac41-11e8-41a2-bb8f-8286be4e30fa"]
}, Open  ]],
Cell[CellGroupData[{
Cell[2292, 64, 303, 5, 67, "Section",ExpressionUUID->"5b4bbec4-1119-4816-a391-9dbf12789517"],
Cell[CellGroupData[{
Cell[2620, 73, 356, 6, 30, "Input",ExpressionUUID->"90eb63cf-3355-434a-930e-55afdafb9e3d"],
Cell[CellGroupData[{
Cell[3001, 83, 566, 11, 20, "Print",ExpressionUUID->"1d2ad7a4-41fc-4184-8f60-69b803fdc27c"],
Cell[3570, 96, 537, 10, 20, "Print",ExpressionUUID->"85e92282-e1fc-4fb8-96fa-0b5abbeb1ef0"],
Cell[4110, 108, 677, 14, 20, "Print",ExpressionUUID->"0194ce7d-a119-4ac0-b7d5-6e46cc6809fb"],
Cell[4790, 124, 576, 11, 20, "Print",ExpressionUUID->"32beafcd-a690-41e1-8438-0f37fa115909"],
Cell[5369, 137, 572, 11, 20, "Print",ExpressionUUID->"c00742c0-5c06-443a-bc15-2b63f78053e7"],
Cell[5944, 150, 523, 10, 20, "Print",ExpressionUUID->"74101b3c-5e42-45c1-ae04-420f8f845b26"],
Cell[6470, 162, 555, 11, 20, "Print",ExpressionUUID->"29c1d312-5bd8-455a-9233-5dda7eaf6dfb"],
Cell[7028, 175, 559, 11, 20, "Print",ExpressionUUID->"16353bb5-aaac-4ebc-9648-c57638500838"],
Cell[7590, 188, 555, 11, 20, "Print",ExpressionUUID->"87bc4951-f092-4380-a792-f0b06a032c97"],
Cell[8148, 201, 795, 17, 36, "Print",ExpressionUUID->"2886e799-79a0-4cdb-ab75-e372b9e3bccd"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[9004, 225, 306, 5, 67, "Section",ExpressionUUID->"8f8f6385-04c2-4ae6-9586-bfd6425af08f"],
Cell[9313, 232, 413, 8, 58, "Text",ExpressionUUID->"69aa44e3-ef8c-40a0-b1c4-290aa6d62baa"],
Cell[CellGroupData[{
Cell[9751, 244, 348, 5, 45, "Subsubsection",ExpressionUUID->"e31e7898-918c-4686-8343-b7f9fed381c3"],
Cell[CellGroupData[{
Cell[10124, 253, 358, 6, 30, "Input",ExpressionUUID->"80552330-6b99-4064-acd6-d05d29e6b5f4"],
Cell[10485, 261, 15156, 480, 316, "Output",ExpressionUUID->"3fcd004e-dc4a-4abb-ac49-494b60fae4f3"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[25690, 747, 274, 4, 45, "Subsubsection",ExpressionUUID->"6255587e-0af9-4334-a0fa-39a7c53c18cf"],
Cell[CellGroupData[{
Cell[25989, 755, 327, 5, 30, "Input",ExpressionUUID->"0b6ab6a8-4b40-48b1-b8de-c216aa59c101"],
Cell[26319, 762, 13675, 446, 346, "Output",ExpressionUUID->"291dcac5-8f83-4b14-8091-6467de9ab4bb"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[40043, 1214, 278, 4, 45, "Subsubsection",ExpressionUUID->"e55c713f-40d3-442f-872b-50b0e6cec5f2"],
Cell[CellGroupData[{
Cell[40346, 1222, 385, 6, 30, "Input",ExpressionUUID->"b9e6afda-6b21-4d26-b289-4e476fc55518"],
Cell[40734, 1230, 44693, 1367, 898, "Output",ExpressionUUID->"d45a1b88-1dea-4e0d-b094-f0acead477a1"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[85476, 2603, 273, 4, 45, "Subsubsection",ExpressionUUID->"49b0b76d-dae2-4d44-92f8-831da3136cbd"],
Cell[CellGroupData[{
Cell[85774, 2611, 337, 5, 30, "Input",ExpressionUUID->"c5cc8969-d9dc-4874-85e7-5a07594f4dd8"],
Cell[86114, 2618, 5667, 174, 375, "Output",ExpressionUUID->"0d2c3841-cd5b-4454-b952-167bcedc6b99"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[91830, 2798, 323, 5, 45, "Subsubsection",ExpressionUUID->"e273bb53-205e-4ce8-b51f-77f61ca43d3b"],
Cell[CellGroupData[{
Cell[92178, 2807, 362, 6, 30, "Input",ExpressionUUID->"71a4aa6c-1c15-481b-9fc4-9330b53c715e"],
Cell[92543, 2815, 5667, 174, 375, "Output",ExpressionUUID->"37480c59-abcc-458b-96b9-4525dad79f51"]
}, Closed]]
}, Open  ]],
Cell[CellGroupData[{
Cell[98259, 2995, 181, 3, 45, "Subsubsection",ExpressionUUID->"0cac47a0-8b44-413a-bbdf-87383adeb324"],
Cell[98443, 3000, 565, 10, 35, "Text",ExpressionUUID->"44cd65f4-1dd3-445d-89bc-86fd60970a40"],
Cell[99011, 3012, 432, 10, 30, "Input",ExpressionUUID->"91b83000-35d7-4c8d-b139-9d02bd9d2244"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[99492, 3028, 305, 5, 67, "Section",ExpressionUUID->"50030a7f-5392-4160-8560-48224d30be9c"],
Cell[99800, 3035, 372, 7, 58, "Text",ExpressionUUID->"46ed1c78-f47a-4177-94f9-4cf8218f6f6d"],
Cell[100175, 3044, 206, 5, 30, "Input",ExpressionUUID->"46d76b01-79e9-402a-b6b1-adf6a35a4d69"],
Cell[CellGroupData[{
Cell[100406, 3053, 250, 4, 45, "Subsubsection",ExpressionUUID->"620d0c08-735a-487d-8815-004be19352b3"],
Cell[100659, 3059, 437, 9, 30, "Input",ExpressionUUID->"959ee140-46d8-4d5e-9f36-6ae3c82ee355"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101133, 3073, 272, 4, 45, "Subsubsection",ExpressionUUID->"a38d459d-783e-4af2-a1d0-99b51620e3a0"],
Cell[101408, 3079, 356, 7, 30, "Input",ExpressionUUID->"ceb34b49-147c-4906-baea-30ba2cd34bd2"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101801, 3091, 276, 4, 45, "Subsubsection",ExpressionUUID->"92c021fa-5f00-4e0e-b55f-4a42072531aa"],
Cell[102080, 3097, 444, 8, 30, "Input",ExpressionUUID->"a3dd8090-3c67-41b6-b34e-51429bf8c82f"]
}, Open  ]],
Cell[CellGroupData[{
Cell[102561, 3110, 253, 4, 45, "Subsubsection",ExpressionUUID->"4de69377-84e8-4afc-8145-6416fa1b8211"],
Cell[102817, 3116, 430, 9, 30, "Input",ExpressionUUID->"d1dced09-9f23-4049-a247-1ff2cb8220c6"]
}, Open  ]],
Cell[CellGroupData[{
Cell[103284, 3130, 323, 5, 45, "Subsubsection",ExpressionUUID->"32391b8d-1a41-4c99-ac04-6b73f843d1ea"],
Cell[CellGroupData[{
Cell[103632, 3139, 625, 11, 30, "Input",ExpressionUUID->"8b957fda-0e1b-4e2b-b1ff-01140f8b5a43"],
Cell[104260, 3152, 5667, 174, 375, "Output",ExpressionUUID->"d83f6427-c2c1-4428-93e0-822b87a65902"]
}, Closed]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

