#ifndef MadGraphMatchingTreeWriter_h
#define MadGraphMatchingTreeWriter_h

#include "ExRootAnalysis/ExRootModule.h"

#include <map>

class TClass;
class TIterator;
class ExRootTreeBranch;

class MadGraphMatchingTreeWriter: public ExRootModule
{
public:

  MadGraphMatchingTreeWriter();
  ~MadGraphMatchingTreeWriter();

  void Init();
  void Process();
  void Finish();

private:

  void ProcessPartons(ExRootTreeBranch *branch, TIterator *iterator);
  void ProcessMatching(ExRootTreeBranch *branch, TIterator *iterator);
  void ProcessJets(ExRootTreeBranch *branch, TIterator *iterator);

  Double_t fJetPTMin, fJetEtaMax; //!
#ifndef __CINT__
  typedef void (MadGraphMatchingTreeWriter::*TProcessMethod)(ExRootTreeBranch*, TIterator*); //!

  typedef std::map<ExRootTreeBranch *, std::pair<TProcessMethod, TIterator*> > TBranchMap; //!

  TBranchMap fBranchMap; //!

  std::map< TClass *, TProcessMethod > fClassMap; //!
#endif
  ClassDef(MadGraphMatchingTreeWriter, 1)
};

#endif
