#ifndef MadGraphConeJetFinder_h
#define MadGraphConeJetFinder_h

#include "ExRootAnalysis/ExRootModule.h"

#include "CDFCones/PhysicsTower.hh"
#include "CDFCones/Cluster.hh"

#include <vector>

class TObjArray;
class TIterator;

class MidPointAlgorithm;

class MadGraphConeJetFinder: public ExRootModule
{
public:

  MadGraphConeJetFinder();
  ~MadGraphConeJetFinder();

  void Init();
  void Process();
  void Finish();
  
private:

  std::vector<PhysicsTower> fTowersList;
  std::vector<Cluster> fJetsList;

  MidPointAlgorithm *fJetAlgo; //!

  TIterator *fItInputArray; //!

  const TObjArray *fInputArray; //!

  TObjArray *fOutputArray; //!

  ClassDef(MadGraphConeJetFinder, 1)
};

#endif
