
/** \class ExRootFactory
 *
 *  Class handling creation of ExRootCandidate,
 *  ExRootCandList and all other objects.
 *
 *  $Date: 2008-06-04 13:57:55 $
 *  $Revision: 1.1 $
 *
 *
 *  \author P. Demin - UCL, Louvain-la-Neuve
 *
 */

#include "ExRootAnalysis/ExRootTreeWriter.h"
#include "ExRootAnalysis/ExRootTreeBranch.h"

#include "ExRootAnalysis/ExRootFactory.h"

#include "ExRootAnalysis/ExRootCandidate.h"
#include "ExRootAnalysis/ExRootCandList.h"

#include "TClass.h"
#include "TObjArray.h"

using namespace std;

//------------------------------------------------------------------------------

ExRootFactory::ExRootFactory() :
  fTreeWriter(0), fPermanentObjArrays(0)
{
  fTreeWriter = new ExRootTreeWriter();
  fPermanentObjArrays = fTreeWriter->NewFactory("PermanentObjArrays", TObjArray::Class());
}

//------------------------------------------------------------------------------

ExRootFactory::~ExRootFactory()
{
  if(fTreeWriter) delete fTreeWriter;
}

//------------------------------------------------------------------------------

void ExRootFactory::Clear()
{
  map<const TClass *, ExRootTreeBranch *>::iterator it_map;
  for(it_map = fMakers.begin(); it_map != fMakers.end(); ++it_map)
  {
    it_map->second->Clear();
  }

  set<TObject *>::iterator it_set;
  for(it_set = fPool.begin(); it_set != fPool.end(); ++it_set)
  {
    (*it_set)->Clear();
  }
}

//------------------------------------------------------------------------------

TObjArray *ExRootFactory::NewArray()
{
  return New<TObjArray>();
}

//------------------------------------------------------------------------------

TObjArray *ExRootFactory::NewPermanentArray()
{
  TObjArray *array = static_cast<TObjArray *>(fPermanentObjArrays->NewEntry());
  fPool.insert(array);
  return array;
}

//------------------------------------------------------------------------------

ExRootCandList *ExRootFactory::NewCandList()
{
  ExRootCandList *object = New<ExRootCandList>();
  object->SetFactory(this);
  return object;
}

//------------------------------------------------------------------------------

ExRootCandidate *ExRootFactory::NewCandidate()
{
  ExRootCandidate *object = New<ExRootCandidate>();
  object->SetFactory(this);
  TProcessID::AssignID(object);
  return object;
}

//------------------------------------------------------------------------------

ExRootCandList *ExRootFactory::NewPermanentCandList()
{
  ExRootCandList *object = static_cast<ExRootCandList *>(fPermanentCandLists->NewEntry());
  object->SetFactory(this);
  fPool.insert(object);
  return object;
}

//------------------------------------------------------------------------------

ExRootCandidate *ExRootFactory::NewPermanentCandidate()
{
  ExRootCandidate *object = static_cast<ExRootCandidate *>(fPermanentCandidates->NewEntry());
  object->SetFactory(this);
  TProcessID::AssignID(object);
  fPool.insert(object);
  return object;
}

//------------------------------------------------------------------------------

TObject *ExRootFactory::New(TClass *cl)
{
  ExRootTreeBranch *maker = 0;
  map<const TClass *, ExRootTreeBranch *>::iterator it = fMakers.find(cl);

  if(it != fMakers.end())
  {
    maker = it->second;
  }
  else
  {
    maker = fTreeWriter->NewFactory(cl->GetName(), cl);
    fMakers.insert(make_pair(cl, maker));
  }

  return maker->NewEntry();
}

//------------------------------------------------------------------------------

