#ifndef MadGraphParticleClassifier_h
#define MadGraphParticleClassifier_h

#include "ExRootAnalysis/ExRootClassifier.h"

#include <map>
#include <set>
#include <deque>

#include "TString.h"

class TObject;

class MadGraphParticleClassifier : public ExRootClassifier
{
public:

  MadGraphParticleClassifier();

  void InsertParticleStatus(Int_t status);
  void InsertClassPID(const TString &className, Int_t pid);
  void SetExtendable(Bool_t extendable);

  Int_t GetCategory(TObject *object);
  Int_t GetMaxCategories() const;
  TString GetCategoryClassName(Int_t category) const;

private:

  std::map< Int_t, Int_t > fParticleIDMap;
  std::map< TString, Int_t > fClassNameMap;
  std::deque< TString > fClassNameArray;
  std::set< Int_t > fParticleStatusSet;

  Int_t fMaxCategories;
  
  Bool_t fIsExtendable;
};

#endif
