##############################################################################
# Input collections (specify ROOT tree name and file listing input ROOT files)
##############################################################################

add InputCollection {STDHEP pythia_events.list}

set OutputFile Matching
set TreeName Matching

#######################################
# Order of execution of various modules
#######################################

set ExecutionPath {
  pythiafix initstateselection showerselection partonjetfinder jetparticleselection hadronjetfinder treewriter
}

###############################
# Fix partilce's daughter index
###############################

module PythiaFix pythiafix

#################
# Parton selector
#################

module MadGraphPartonSelector initstateselection {
  set PartonIDs {1 2 3 4 5 21}
  set ExcludedAncestorIDs {6 23 24}
}

#################
# Parton selector
#################

module MadGraphShowerPartonSelector showerselection {
  set EtaMax 5.0
  set PartonIDs {1 2 3 4 5 21}
  set ExcludedAncestorIDs {6 23 24}
}

###################
# Parton jet finder
###################

module MadGraphKtJetFinder partonjetfinder {
  set InputArray "showerselection/candidates"

  set CollisionType 4
  set DistanceScheme 3
  set RecombinationScheme 3
  set ParameterR 1.0

  set Exclusive true
  set ECut 1.0
  set DCut 2500.0
  
  set ParticleNumberMin 2
}

##############################
# Hadron jet particle selector
##############################

module MadGraphJetParticleSelector jetparticleselection {
  set SpecialParticleIDs {11 13 15}
  set ExcludedAncestorIDs {22 23 24}
  set ExcludedParticleIDs {12 14 16}
}

###################
# Hadron jet finder
###################

module MadGraphKtJetFinder hadronjetfinder {
  set InputArray "jetparticleselection/candidates"

  set CollisionType 4
  set DistanceScheme 3
  set RecombinationScheme 3
  set ParameterR 1.0

  set Exclusive true
  set ECut 1.0
  set DCut 2500.0
  
  set ParticleNumberMin 2
}

##################
# ROOT tree writer
##################

module MadGraphMatchingTreeWriter treewriter {
  set InputPartonArrayJets "partonjetfinder/candidates"
  set InputHadronArrayJets "hadronjetfinder/candidates"
  set InputArrayMatching "partonjetfinder/matching"
  set InputArrayPartons "initstateselection/candidates"
  set JetPTMin 20.0
  set JetEtaMax 4.5
}

