#ifndef ExRootModule_h
#define ExRootModule_h

/** \class ExRootModule
 *
 *  Base class for analysis modules
 *
 *  $Date: 2008-06-04 13:57:25 $
 *  $Revision: 1.1 $
 *
 *
 *  \author P. Demin - UCL, Louvain-la-Neuve
 *
 */

#include "ExRootAnalysis/ExRootTask.h"

class TClass;
class TObject;
class TFolder;
class TClonesArray;

class ExRootResult;
class ExRootTreeBranch;
class ExRootTreeReader;
class ExRootTreeWriter;

class ExRootFactory;

class ExRootModule: public ExRootTask 
{
public:

  ExRootModule();
  ~ExRootModule();

  virtual void Init();
  virtual void Process();
  virtual void Finish();

  const TObjArray *ImportArray(const char *name);
  TObjArray *ExportArray(const char *name);

  TClonesArray *UseBranch(const char *name);

  ExRootTreeBranch *NewBranch(const char *name, TClass *cl);

  ExRootResult *GetPlots();
  ExRootFactory *GetFactory();
  ExRootTreeReader *GetTreeReader();


protected:

  ExRootTreeReader *fTreeReader;
  ExRootTreeWriter *fTreeWriter;

  ExRootFactory *fFactory;

private:

  TFolder *NewFolder(const char *name);
  TObject *GetObject(const char *name, TClass *cl);

  ExRootResult *fPlots;

  TFolder *fPlotFolder, *fExportFolder;

  ClassDef(ExRootModule, 1)
};

#endif /* ExRootModule_h */

