#ifndef ExRootCandList_h
#define ExRootCandList_h

/** \class ExRootCandidate
 *
 *  A list of ExRootCandidates with iterators.
 *
 *  $Date: 2008-06-04 13:57:23 $
 *  $Revision: 1.1 $
 *
 *
 *  \author P. Demin - UCL, Louvain-la-Neuve
 *
 */

#include "TNamed.h"

#include "ExRootAnalysis/ExRootSortableObject.h"

class TBrowser;
class TObjArray;

class ExRootCandList;
class ExRootCandidate;
class ExRootFactory;

//------------------------------------------------------------------------------

class ExRootCandIter
{
  friend class ExRootCandConstIter;

public:

  ExRootCandIter() : fArray(0), fCursor(0) { }
  ExRootCandIter(TObjArray *array);
  ExRootCandIter(ExRootCandList *object);
  ExRootCandIter(const ExRootCandIter &iter);
  ~ExRootCandIter() { }

  ExRootCandIter &operator=(const ExRootCandIter &rhs);

  ExRootCandidate *Next(Bool_t direction = kIterForward);
  void Reset(Bool_t direction = kIterForward);

private:

    const TObjArray *fArray; // array being iterated
  Int_t fCursor; // current position in array
};

//------------------------------------------------------------------------------

class ExRootCandConstIter
{
public:

  ExRootCandConstIter() : fArray(0), fCursor(0) { }
  ExRootCandConstIter(const TObjArray *array);
  ExRootCandConstIter(const ExRootCandList *object);
  ExRootCandConstIter(const ExRootCandIter &iter);
  ExRootCandConstIter(const ExRootCandConstIter &iter);
  ~ExRootCandConstIter() { }

  ExRootCandConstIter &operator=(const ExRootCandIter &rhs);
  ExRootCandConstIter &operator=(const ExRootCandConstIter &rhs);

  const ExRootCandidate *Next(Bool_t direction = kIterForward);
  void Reset(Bool_t direction = kIterForward);

private:

  const TObjArray *fArray; // array being iterated
  Int_t fCursor; // current position in array
};

//------------------------------------------------------------------------------

class ExRootCandList: public TNamed
{
  friend class ExRootFactory;
  friend class ExRootCandIter;
  friend class ExRootCandConstIter;

public:

  ExRootCandList();

  ExRootCandList(const ExRootCandList &object);

  virtual ~ExRootCandList() {}

  /** Add link to a candidate.
    @param object -- pointer to ExRootCandidate instance
    */
  virtual void Add(ExRootCandidate *object);
  virtual void Add(const ExRootCandidate *object);

  /** Return number of candidates in this list.
    @return number of candidates of type int
    */
  Int_t Size() const;

  /** Return pointer to the i-th candidate of this candidate.
    @return pointer to ExRootCandidate
    */
  const ExRootCandidate *At(Int_t i) const;

  /** Return iterarator for the list of candidates.
    @return iterarator of type ExRootCandConstIter
    */
  ExRootCandConstIter Iterator() const { return ExRootCandConstIter(fArray); }

  /** Sorts candidates using an instance of a functor class
    that inherits from ExRootCompare.
    @param compare -- pointer to ExRootCompare
    */
  void Sort(ExRootCompare *compare);

  /** Copy this candidate to object of type ExRootCandList.
    @param object -- reference to TObject
    */
  virtual void Copy(TObject &object) const;

  /** Make a clone of this list.
    @return pointer to TObject
    */
  virtual TObject *Clone(const char *newname = "") const;

  virtual void Clear();

  /** Browse the list of candidates.
    */
  virtual void Browse(TBrowser *b);

  /** Returns kTRUE in case candidate contains browsable objects.
    @return value of type Bool_t
    */
  virtual Bool_t IsFolder() const { return kTRUE; }

protected:

  ExRootFactory *fFactory; //!

private:

  void SetFactory(ExRootFactory *factory) { fFactory = factory; }

private:

  /** array of daughters
    */
  TObjArray *fArray; //!

  ClassDef(ExRootCandList, 1)
};

#endif /* ExRootCandList_h */


