
//------------------------------------------------------------------------------

void AnalyseEvents(ExRootTreeReader *treeReader)
{
  TClonesArray *branchM1 = treeReader->UseBranch("Match");
  TClonesArray *branchM2 = treeReader->UseBranch("Matching.Match");

  Long64_t allEntries = treeReader->GetEntries();

  cout << "** Chain contains " << allEntries << " events" << endl;

  ExRootGenMatch *match;

  // Loop over all events
  for(entry = 0; entry < allEntries; ++entry)
  {
    // Load selected branches with data from specified event
    treeReader->ReadEntry(entry);

    nclus = -1;
    if(branchM1->GetEntriesFast() > 0)
    {
      match = (ExRootGenMatch*) branchM1->At(0);
      nclus = match->Nclus; 
    }

    // Analyse missing ET
    if(nclus != branchM2->GetEntriesFast())
    {
      cout << entry << "\t" << nclus << "\t" << branchM2->GetEntriesFast() << endl;
    }
  }
}

//------------------------------------------------------------------------------

void Example()
{
  TChain *chain1 = new TChain("Match");
  TChain *chain2 = new TChain("Matching");
  chain1->Add("../../eventtree_nclus.root");
  chain2->Add("MatchingTree.root");
  chain1->AddFriend(chain2, "Matching");

  ExRootTreeReader *treeReader = new ExRootTreeReader(chain1);
  ExRootResult *result = new ExRootResult();

  AnalyseEvents(treeReader);

  cout << "** Exiting..." << endl;

  delete treeReader;
  delete chain1;
  delete chain2;
}

//------------------------------------------------------------------------------

