#ifndef MadGraphMatchingTreeWriter_h
#define MadGraphMatchingTreeWriter_h

#include "ExRootAnalysis/ExRootModule.h"

#include "TString.h"

#include <map>

class TH1;
class TIterator;
class TObjArray;
class TClonesArray;

class MadGraphMatchingTreeWriter: public ExRootModule
{
public:

  MadGraphMatchingTreeWriter();
  ~MadGraphMatchingTreeWriter();

  void Init();
  void Process();
  void Finish();

private:

  Double_t fJetPTMin, fJetEtaMax;

  const TObjArray *fInputArrayPartonJets; //!
  const TObjArray *fInputArrayHadronJets; //!
  const TObjArray *fInputArrayMatching; //!
  const TObjArray *fInputArrayPartons; //!

  TIterator *fItInputArrayPartonJets; //!
  TIterator *fItInputArrayHadronJets; //!
  TIterator *fItInputArrayMatching; //!
  TIterator *fItInputArrayPartons; //!
  
  ExRootTreeBranch *fBranchPartonJets; //!
  ExRootTreeBranch *fBranchHadronJets; //!
  ExRootTreeBranch *fBranchMatching; //!
  ExRootTreeBranch *fBranchPartons; //!

  ClassDef(MadGraphMatchingTreeWriter, 1)
};

#endif
