#ifndef MadGraphJetParticleSelector_h
#define MadGraphJetParticleSelector_h

#include "ExRootAnalysis/ExRootModule.h"

class TClonesArray;
class TObjArray;

class ExRootFilter;
class MadGraphJetParticleClassifier;

class MadGraphJetParticleSelector: public ExRootModule
{
public:

  MadGraphJetParticleSelector();
  ~MadGraphJetParticleSelector();

  void Init();
  void Process();
  void Finish();

private:

  ExRootFilter *fFilter; //!
  MadGraphJetParticleClassifier *fClassifier; //!

  TClonesArray *fBranchParticle; //!

  TObjArray *fOutputArray; //!
  
  Double_t fEtaMax;

  ClassDef(MadGraphJetParticleSelector, 1)
};

#endif
