#ifndef MadGraphCDFConeJetFinder_h
#define MadGraphCDFConeJetFinder_h

#include "ExRootAnalysis/ExRootModule.h"

#include "CDFCones/PhysicsTower.hh"
#include "CDFCones/Cluster.hh"

#include <vector>

class TObjArray;
class TIterator;

class MidPointAlgorithm;

class MadGraphCDFConeJetFinder: public ExRootModule
{
public:

  MadGraphCDFConeJetFinder();
  ~MadGraphCDFConeJetFinder();

  void Init();
  void Process();
  void Finish();
  
private:

  std::vector<PhysicsTower> fTowersList;
  std::vector<Cluster> fJetsList;

  MidPointAlgorithm *fJetAlgo; //!

  TIterator *fItInputArray; //!

  const TObjArray *fInputArray; //!

  TObjArray *fOutputArray; //!

  ClassDef(MadGraphCDFConeJetFinder, 1)
};

#endif
