#ifndef MadGraphShowerPartonSelector_h
#define MadGraphShowerPartonSelector_h

#include "ExRootAnalysis/ExRootModule.h"

class TClonesArray;
class TObjArray;

class ExRootFilter;
class MadGraphShowerPartonClassifier;

class MadGraphShowerPartonSelector: public ExRootModule
{
public:

  MadGraphShowerPartonSelector();
  ~MadGraphShowerPartonSelector();

  void Init();
  void Process();
  void Finish();

private:

  ExRootFilter *fFilter; //!
  MadGraphShowerPartonClassifier *fClassifier; //!

  TClonesArray *fBranchParticle; //!

  TObjArray *fOutputArray; //!
  
  Double_t fEtaMax;

  ClassDef(MadGraphShowerPartonSelector, 1)
};

#endif
