#ifndef MadGraphAnalysis_h
#define MadGraphAnalysis_h

#include "ExRootAnalysis/ExRootModule.h"

#include "TString.h"

#include <map>

class TH1;
class TObjArray;
class TClonesArray;

class MadGraphAnalysis: public ExRootModule
{
public:

  MadGraphAnalysis();
  ~MadGraphAnalysis();

  void Init();
  void Process();
  void Finish();

private:

  struct ParticleHistograms
  {
    TH1 *fParticlePt;
    TH1 *fParticleRapidity;
  };

  struct PairHistograms
  {
    TH1 *fPairDeltaR;
    TH1 *fPairMass;
  };

  void BookParticleHistograms(ParticleHistograms *histograms,
                              const char *name, const char *title);
  void BookPairHistograms(PairHistograms *histograms,
                          const char *name, const char *title);

  ParticleHistograms *GetParticleHistograms(const char *candName);
  PairHistograms *GetPairHistograms(const char *candName1, const char *candName2);

  TString fOutputFileName; //!
  
  Bool_t fIsUnWeighted; //!

  const TObjArray *fInputArray; //!

  TClonesArray *fBranchEvent; //!

  std::map<TString, ParticleHistograms *> fParticleHistogramsMap; //!
  std::map<TString, PairHistograms *> fPairHistogramsMap; //!

  ClassDef(MadGraphAnalysis, 1)
};

#endif
