#ifndef ExRootEventLoop_h
#define ExRootEventLoop_h

/** \class ExRootEventLoop
 *
 *  Analysis steering class.
 *  Implements events loop and modules management.
 *
 *  $Date: 2008-06-04 13:57:24 $
 *  $Revision: 1.1 $
 *
 *
 *  \author P. Demin - UCL, Louvain-la-Neuve
 *
 */

#include "ExRootAnalysis/ExRootModule.h"

class TTask;
class TFile;
class TFolder;
class TObjArray;

class ExRootTreeReader;

class ExRootEventLoop: public ExRootModule
{
public:

  ExRootEventLoop();
  ~ExRootEventLoop();

  Long64_t GetEntries();
  Bool_t ReadEvent(Long64_t entry);

  virtual void Init();
  virtual void Process();
  virtual void Finish();

  virtual void Clear();

private:

  Long64_t fAllEntries;

  ExRootTask *fEventLoop;

  TObjArray *fChains;

  ClassDef(ExRootEventLoop, 1)
};

#endif /* ExRootEventLoop_h */

