##############################################################################
# Input collections (specify ROOT tree name and file listing input ROOT files)
##############################################################################

add InputCollection {STDHEP pythia_events.list}

#######################
# Output ROOT file name
#######################

set OutputFile MadSim.root

#######################################
# Order of execution of various modules
#######################################

set ExecutionPath {
  leptonselection partonselection jetfinder merger analysis
}

#################
# Lepton selector
#################

module MadGraphShowerLeptonSelector leptonselection {
  add ParticleStatus 1
  add ClassParticles e {11 -11}
  add ClassParticles #mu {13 -13}
}

#################
# Parton selector
#################

module MadGraphShowerPartonSelector partonselection {
  set PartonIDs {1 2 3 4 5 21}
}

############
# Jet finder
############

module MadGraphKtJetFinder jetfinder {
  set InputArray "partonselection/candidates"

  set CollisionType 4
  set DistanceScheme 1
  set RecombinationScheme 1
  set ParameterR 1.0
}

#################################
# Merge all input arrays into one
#################################

module MadGraphJetLeptonMerger merger {
  set InputLeptonsArray "leptonselection/candidates"
  set InputJetsArray "jetfinder/candidates"
  set JetNumberMax 4
}

#################
# Analysis module
#################

module MadGraphAnalysis analysis {
  set InputArray "merger/candidates"
  set IsUnWeighted false
  set OutputFile "pythia_plots.root"
}

