
#include "modules/MadGraphJetLeptonMerger.h"

#include "ExRootAnalysis/ExRootClasses.h"

#include "ExRootAnalysis/ExRootFactory.h"
#include "ExRootAnalysis/ExRootCandidate.h"

#include "TString.h"

#include <iostream>

using namespace std;

//------------------------------------------------------------------------------

MadGraphJetLeptonMerger::MadGraphJetLeptonMerger() :
  fItInputLeptons(0), fItInputJets(0)
{
}

//------------------------------------------------------------------------------

MadGraphJetLeptonMerger::~MadGraphJetLeptonMerger()
{
}

//------------------------------------------------------------------------------

void MadGraphJetLeptonMerger::Init()
{
  // import array with output from lepton and jet finders

  fInputLeptons = ImportArray(GetString("InputLeptonsArray", "leptonfinder/leptons"));
  fItInputLeptons = fInputLeptons->MakeIterator();

  fInputJets = ImportArray(GetString("InputJetsArray", "jetfinder/jets"));
  fItInputJets = fInputJets->MakeIterator();

  fJetNumberMax = GetInt("JetNumberMax", 4);

  // create output arrays

  fOutputArray = ExportArray("candidates");

}

//------------------------------------------------------------------------------

void MadGraphJetLeptonMerger::Finish()
{
  if(fItInputLeptons) delete fItInputLeptons;
  if(fItInputJets) delete fItInputJets;
}

//------------------------------------------------------------------------------

void MadGraphJetLeptonMerger::Process()
{
  TObject *object = 0;
  Int_t entry;

  fItInputLeptons->Reset();
  while((object = fItInputLeptons->Next()))
  {
    fOutputArray->Add(object);
  }

  entry = 0;
  fItInputJets->Reset();
  while((object = fItInputJets->Next()) && entry < fJetNumberMax)
  {
    fOutputArray->Add(object);
    ++entry;
  }
}

//------------------------------------------------------------------------------
