#ifndef MadGraphIsolatedLeptonFinder_h
#define MadGraphIsolatedLeptonFinder_h

#include "ExRootAnalysis/ExRootModule.h"

class TClonesArray;
class TObjArray;
class TIterator;

class ExRootFilter;
class MadGraphParticleClassifier;

class ExRootGenParticle;

class MadGraphIsolatedLeptonFinder: public ExRootModule
{
public:
    
  MadGraphIsolatedLeptonFinder();
  ~MadGraphIsolatedLeptonFinder();

  void Init();
  void Process();
  void Finish();
  
private:

  Double_t GetMinDeltaR(ExRootGenParticle *lepton);

  TIterator *fItParticle; //!

  ExRootFilter *fFilter; //!
  MadGraphParticleClassifier *fClassifier; //!

  TClonesArray *fBranchParticle; //!

  TObjArray *fOutputArray; //!
  
  Double_t fMinPT, fMinDeltaR;

  ClassDef(MadGraphIsolatedLeptonFinder, 1)
};

#endif
