#ifndef MadGraphMatchingAnalysis_h
#define MadGraphMatchingAnalysis_h

#include "ExRootAnalysis/ExRootModule.h"

#include "TString.h"

#include <map>

class TH1;
class TObjArray;
class TClonesArray;

class MadGraphMatchingAnalysis: public ExRootModule
{
public:

  MadGraphMatchingAnalysis();
  ~MadGraphMatchingAnalysis();

  void Init();
  void Process();
  void Finish();

private:

  struct MatchingHistograms
  {
    TH1 *fYMerge;
  };

  void BookMatchingHistograms(MatchingHistograms *histograms,
                              const char *name, const char *title);

  MatchingHistograms *GetMatchingHistograms(const char *name);

  TString fOutputFileName; //!

  const TObjArray *fInputArrayCandidates; //!
  const TObjArray *fInputArrayMatching; //!

  std::map<TString, MatchingHistograms *> fMatchingHistogramsMap; //!

  ClassDef(MadGraphMatchingAnalysis, 1)
};

#endif
