#ifndef MadGraphSISConeJetFinder_h
#define MadGraphSISConeJetFinder_h

#include "ExRootAnalysis/ExRootModule.h"

#include "SISCone/momentum.h"

#include <vector>

namespace siscone {
  class Csiscone;
}

class TObjArray;
class TIterator;

class MidPointAlgorithm;

class MadGraphSISConeJetFinder: public ExRootModule
{
public:

  MadGraphSISConeJetFinder();
  ~MadGraphSISConeJetFinder();

  void Init();
  void Process();
  void Finish();
  
private:

  std::vector<siscone::Cmomentum> fParticlesList;

  siscone::Csiscone *fJetAlgo; //!

  double fConeRadius;
  double fConeAreaFraction;
  int    fMaxIterations;
  double fJetPTMin;

  TIterator *fItInputArray; //!

  const TObjArray *fInputArray; //!

  TObjArray *fOutputArray; //!

  ClassDef(MadGraphSISConeJetFinder, 1)
};

#endif
