#ifndef MadGraphKtJetFinder_h
#define MadGraphKtJetFinder_h

#include "ExRootAnalysis/ExRootModule.h"

#include "KtJet/KtLorentzVector.h"

#include <vector>

class TObjArray;
class TIterator;

class MadGraphKtJetFinder: public ExRootModule
{
public:

  MadGraphKtJetFinder();
  ~MadGraphKtJetFinder();

  void Init();
  void Process();
  void Finish();

private:

  Bool_t fIsExclusive;

  Int_t fParticleNumberMin;

  Double_t fParameterR, fECut, fDCut;

  Int_t fCollisionType, fDistanceScheme, fRecombinationScheme;

  std::vector<KtJet::KtLorentzVector> fTowersList; //!
  std::vector<KtJet::KtLorentzVector> fJetsList; //!

  TIterator *fItInputArray; //!

  const TObjArray *fInputArray; //!

  TObjArray *fOutputArrayCandidates; //!
  TObjArray *fOutputArrayMatching; //!

  ClassDef(MadGraphKtJetFinder, 1)
};

#endif
